<?php

require_once(__DIR__ . "/db.sp_combo_item.php");

function db_sp_combo_exists($sp_combo_id) {
	global $lDB;

	$count = $lDB->get("
		SELECT COUNT(sp_combo_ix) FROM sp_combo WHERE sp_combo_ix = '" . $lDB->escape($sp_combo_id) . "'
	",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_sp_combo_insert($sp_combo_name, $sp_combo_limit) {
	global $lDB;
	global $dbcode;
	global $userid;

	$sp_combo_sort_seq = $lDB->get("SELECT MAX(sp_combo_sort_seq) FROM sp_combo",4) + 1;

	$today = date("Y-m-d H:i:s");
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO sp_combo (
			sp_combo_db,
			sp_combo_name,
			sp_combo_limit,
			sp_combo_sort_seq,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'" . $lDB->escape($dbcode) . "',
			'" . $lDB->escape($sp_combo_name) . "',
			'" . $lDB->escape($sp_combo_limit) . "',
			'" . $lDB->escape($sp_combo_sort_seq) . "',
			'" . $lDB->escape($today) . "',
			'" . $lDB->escape($ad_create_date_tz) . "',
			'" . $lDB->escape($userid) . "',
			'" . $lDB->escape($today) . "',
			'" . $lDB->escape($ad_modify_date_tz) . "',
			'" . $lDB->escape($userid) . "'
		)
	");

	$sp_combo_id = $lDB->insert_id;

	return $sp_combo_id;
}

function db_sp_combo_update($sp_combo_id, $sp_combo_name, $sp_combo_limit) {
	global $lDB;

	if(!db_sp_combo_exists($sp_combo_id)) {
		return false;
	}

	$lDB->put("
		UPDATE sp_combo SET
			sp_combo_name = '" . $lDB->escape($sp_combo_name) . "',
			sp_combo_limit = '" . $lDB->escape($sp_combo_limit) . "'
		WHERE
			sp_combo_ix = '" . $lDB->escape($sp_combo_id) . "'
	");
	db_sp_combo_update_audit($sp_combo_id);

	return true;
}

function db_sp_combo_delete($sp_combo_id) {
	global $lDB;

	if(!db_sp_combo_exists($sp_combo_id)) {
		return false;
	}

	db_sp_combo_item_delete_by_combo($sp_combo_id);

	$lDB->put("
		DELETE FROM sp_combo WHERE sp_combo_ix = '" . $lDB->escape($sp_combo_id) . "'
	");

	db_sp_combo_resequence();

	return true;
}

function db_sp_combo_update_audit($sp_combo_id) {
	global $lDB;
	global $userid;

	$today = date("Y-m-d H:i:s");
	$timezone = $ad_modify_date_tz = date("e");
	$lDB->put("
		UPDATE sp_combo SET
			ad_modify_date = '" . $lDB->escape($today) . "',
			ad_modify_date_tz = '" . $lDB->escape($timezone) . "',
			ad_modify_user_id = '" . $lDB->escape($userid) . "'
		WHERE
			sp_combo_ix = '" . $lDB->escape($sp_combo_id) . "'
	");

	return true;	

}

function db_sp_combo_set_seq($sp_combo_id, $sp_combo_sort_seq, $audit=true) {
	global $lDB;

	$lDB->put("
		UPDATE sp_combo SET
			sp_combo_sort_seq = '" . $lDB->escape($sp_combo_sort_seq) . "'
		WHERE sp_combo_ix = '" . $lDB->escape($sp_combo_id) . "'
	");

	if($audit) {
		db_sp_combo_update_audit($sp_combo_id);
	}

	return true;
}

function db_sp_combo_move($sp_combo_id, $direction) {
	global $lDB;

	if(!db_sp_combo_exists($sp_combo_id)) {
		return false;
	}

	$max_combo_sort_seq = $lDB->get("SELECT MAX(sp_combo_sort_seq) FROM sp_combo",4);

	$sp_combo_sort_seq = $lDB->get("SELECT sp_combo_sort_seq FROM sp_combo WHERE sp_combo_ix = '" . $lDB->escape($sp_combo_id) . "'",4);

	if($direction) {
		$step = 1;
	} else {
		$step = -1;
	}

	$target_combo_sort_seq = $sp_combo_sort_seq + $step;
	if($target_combo_sort_seq < 1) {
		$target_combo_sort_seq = 1;
	}
	if($target_combo_sort_seq > $max_combo_sort_seq) {
		$target_combo_sort_seq = $max_combo_sort_seq;
	}

	if($target_combo_sort_seq == $sp_combo_sort_seq) { // no change required
		return false;
	}

	$target_combo_id = $lDB->get("SELECT sp_combo_ix FROM sp_combo WHERE sp_combo_sort_seq = '" . $lDB->escape($target_combo_sort_seq) . "'", 4);

	db_sp_combo_set_seq($sp_combo_id, $target_combo_sort_seq);
	db_sp_combo_set_seq($target_combo_id, $sp_combo_sort_seq);

	return true;
}

function db_sp_combo_resequence() {
	global $lDB;

	$combos = $lDB->get("
		SELECT
			sp_combo.sp_combo_ix
		FROM
			sp_combo
		ORDER BY
			sp_combo_sort_seq
",3);

	$sp_combo_sort_seq = 1;
	foreach($combos as $sp_combo_id) {
		db_sp_combo_set_seq($sp_combo_id, $sp_combo_sort_seq, false);
		$sp_combo_sort_seq++;
	}

	return true;
}
