<?php

require_once(__DIR__ . "/db.sp_combo.php");
require_once(__DIR__ . "/db.sp_special.php");

function db_sp_combo_item_exists($sp_combo_item_id) {
	global $lDB;

	$count = $lDB->get("
		SELECT COUNT(sp_combo_item_ix) FROM sp_combo_item WHERE sp_combo_item_ix = '" . $lDB->escape($sp_combo_item_id) . "'
	",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_sp_combo_item_insert($sp_combo_id, $sp_special_id) {
	global $lDB;
	global $dbcode;

	if(!db_sp_combo_exists($sp_combo_id) || !db_sp_special_exists($sp_special_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO sp_combo_item (
			sp_combo_item_db,
			sp_combo_id,
			sp_special_id
		) VALUES (
			'" . $lDB->escape($dbcode) . "',
			'" . $lDB->escape($sp_combo_id) . "',
			'" . $lDB->escape($sp_special_id) . "'
		)
	");

	$sp_combo_item_id = $lDB->insert_id;

	return $sp_combo_item_id;
}

function db_sp_combo_item_delete($sp_combo_item_id) {
	global $lDB;

	if(!db_sp_combo_item_exists($sp_combo_item_id)) {
		return false;
	}

	$lDB->put("DELETE FROM sp_combo_item WHERE sp_combo_item_ix = '" . $lDB->escape($sp_combo_item_id) . "'");

	return true;
}

function db_sp_combo_item_delete_by_combo($sp_combo_id) {
	global $lDB;

	$list = $lDB->get("
		SELECT sp_combo_item_ix FROM sp_combo_item WHERE sp_combo_id = '" . $lDB->escape($sp_combo_id) . "'
	",3);
	foreach($list as $sp_combo_item_id) {
		db_sp_combo_item_delete($sp_combo_item_id);
	}

	return true;
}

function db_sp_combo_item_delete_by_all($sp_combo_id, $sp_special_id) {
	global $lDB;

	$list = $lDB->get("
		SELECT
			sp_combo_item_ix
		FROM
			sp_combo_item
		WHERE
			sp_combo_id = '" . $lDB->escape($sp_combo_id) . "'
			AND sp_special_id = '" . $lDB->escape($sp_special_id) . "'
	",3);
	foreach($list as $sp_combo_item_id) {
		db_sp_combo_item_delete($sp_combo_item_id);
	}

	return true;
}
