<?php

require_once(__DIR__ . "/db.rt_period.php");
require_once(__DIR__ . "/db.sp_combo.php");

function db_sp_combo_period_exists($sp_combo_period_id) {
	global $lDB;

	$count = $lDB->get("
		SELECT COUNT(sp_combo_period_ix) FROM sp_combo_period WHERE sp_combo_period_ix = '" . $lDB->escape($sp_combo_period_id) . "'
	",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_sp_combo_period_insert($sp_combo_id, $rt_period_id) {
	global $lDB;
	global $dbcode;

	if(!db_sp_combo_exists($sp_combo_id) || !db_rt_period_exists($rt_period_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO sp_combo_period (
			sp_combo_period_db,
			sp_combo_id,
			rt_period_id
		) VALUES (
			'" . $lDB->escape($dbcode) . "',
			'" . $lDB->escape($sp_combo_id) . "',
			'" . $lDB->escape($rt_period_id) . "'
		)
	");

	$sp_combo_period_id = $lDB->insert_id;

	return $sp_combo_period_id;
}

function db_sp_combo_period_delete($sp_combo_period_id) {
	global $lDB;

	if(!db_sp_combo_period_exists($sp_combo_period_id)) {
		return false;
	}

	$lDB->put("DELETE FROM sp_combo_period WHERE sp_combo_period_ix = '" . $lDB->escape($sp_combo_period_id) . "'");

	return true;
}

function db_sp_combo_period_delete_by_combo($sp_combo_id) {
	global $lDB;

	$list = $lDB->get("
		SELECT sp_combo_period_ix FROM sp_combo_period WHERE sp_combo_id = '" . $lDB->escape($sp_combo_id) . "'
	",3);
	foreach($list as $sp_combo_period_id) {
		db_sp_combo_period_delete($sp_combo_period_id);
	}

	return true;
}

function db_sp_combo_period_delete_by_all($sp_combo_id, $rt_period_id) {
	global $lDB;

	$list = $lDB->get("
		SELECT
			sp_combo_period_ix
		FROM
			sp_combo_period
		WHERE
			sp_combo_id = '" . $lDB->escape($sp_combo_id) . "'
			AND rt_period_id = '" . $lDB->escape($rt_period_id) . "'
	",3);
	foreach($list as $sp_combo_period_id) {
		db_sp_combo_period_delete($sp_combo_period_id);
	}

	return true;
}
