<?php

require_once(__DIR__ . "/db.sp_accomm_type.php");
require_once(__DIR__ . "/db.sp_prop_rate_group.php");
require_once(__DIR__ . "/db.sp_rate_group_benefit.php");
require_once(__DIR__ . "/db.sp_rate_group_qualify.php");
require_once(__DIR__ . "/db.sp_special_period.php");
require_once(__DIR__ . "/db.sp_special_rate_type.php");

function db_sp_special_exists($sp_special_id) {
	global $lDB;

	$count = $lDB->get("
		SELECT COUNT(sp_special_ix) FROM sp_special WHERE sp_special_ix = '" . $lDB->escape($sp_special_id) . "'
	",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_sp_special_exists_by_folio($fn_folio_id) {
	global $lDB;

	$rv_reservation_item_id = $lDB->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_amt_sp_discount
		FROM
			rv_reservation_item
			LEFT JOIN fn_folio ON fn_folio_ix = rv_reservation_item.fn_folio_id
		WHERE
			fn_folio.fn_folio_ix = '".$fn_folio_id."'
			AND rv_reservation_item.rv_item_amt_sp_discount != 0
	",2);

	return ($rv_reservation_item_id > 0 ) ? true : false;
}

function db_sp_special_by_folio($fn_folio_id) {
	global $lDB;

	$sp_special_ids = $lDB->get("
		SELECT
			rv_special.sp_special_id
		FROM
			fn_folio
			LEFT JOIN rv_special ON rv_special.rv_reservation_id = fn_folio.rv_reservation_id
		WHERE
			fn_folio.fn_folio_ix = '".$fn_folio_id."'
	",2);
	return $sp_special_ids;
}

function db_sp_special_get_by_folio($folioId) {
	global $lDB;

	$sp_special_ids = db_sp_special_by_folio($folioId);
	$counter = 0;
	$specials = array();
	foreach ($sp_special_ids as $special) {
		$sp_special_desc = db_sp_special_get_desc($special['sp_special_id']);
		$sp_special_note = db_sp_special_get_note($special['sp_special_id']);
		if (!empty($sp_special_desc)) {
			$specials[$counter]['sp_special_desc'] = $sp_special_desc;
			$specials[$counter]['sp_special_note'] = $sp_special_note;
		}
		$counter++;
	}
	return $specials;
}

function db_sp_special_get_by_reservation($resId) {
	global $lDB;

	$specials = $lDB->get("
		SELECT
			sp_special.sp_special_desc,
			sp_special.sp_special_note
		FROM
			sp_special
			LEFT JOIN rv_special ON rv_special.sp_special_id = sp_special.sp_special_ix
		WHERE
			rv_special.rv_reservation_id = '".$resId."'
	",2);
	return $specials;
}

function db_sp_special_id_get_by_reservation($resId) {
//	die("TODO REMOVE");
	global $lDB;

	$specials = $lDB->get("
		SELECT
			rv_special.sp_special_id
		FROM
			rv_special
		WHERE
			rv_reservation_id = '" . $resId . "'
	",2);
	return $specials;
}

function db_sp_special_override_by_reservation($resId) {
	global $lDB;

	$rv_sp_overide_yn = $lDB->get("
		SELECT
			rv_special.rv_sp_overide_yn
		FROM
			rv_special
		WHERE
			rv_reservation_id = '" . $resId . "'
	",4);
	$override = ($rv_sp_overide_yn == '1') ? true : false;
	return $override;
}

function db_sp_special_get_by_invoice($fn_invoice_id) {
	global $lDB;

	$special = $lDB->get("
		SELECT
			fn_invoice_special.fn_inv_special_desc AS sp_special_desc,
			fn_invoice_special.fn_inv_special_note AS sp_special_note
		FROM
			fn_invoice_special
		WHERE
			fn_invoice_special.fn_invoice_id = '".$fn_invoice_id."'
	",2);
	return $special;
}

function db_sp_special_get_desc($sp_special_ix) {
	global $lDB;

	if ($sp_special_ix == "") {
		return "";
	}

	$sp_special_desc = $lDB->get("
		SELECT
			sp_special.sp_special_desc
		FROM
			sp_special
		WHERE
			sp_special.sp_special_ix = '".$sp_special_ix."'
	",4);
	return $sp_special_desc;
}

function db_sp_special_get_note($sp_special_ix) {
	global $lDB;

	$sp_special_note = $lDB->get("
		SELECT
			sp_special.sp_special_note
		FROM
			sp_special
		WHERE
			sp_special.sp_special_ix = '".$sp_special_ix."'
	",4);
	return $sp_special_note;
}

function db_sp_special_insert($sp_special_desc, $sp_special_date_from, $sp_special_date_to, $sp_special_lead_time_ind, $sp_special_lead_time_amt, $sp_special_comm_perc, $sp_special_commissionable_yn , $sp_special_min_properties, $sp_special_note) {
	global $lDB;
	global $dbcode;

	$createDate = date("Y-m-d H:i:s");
	$createDateTz = date("e");

	$pr_user_id = $GLOBALS['userid'];

	$sp_special_priority = $GLOBALS['lDB']->get("
		SELECT
			MAX(sp_special.sp_special_priority)
		FROM
			sp_special
	",4);
	$sp_special_priority++;
	
	$lDB->put("
		INSERT INTO sp_special (
			sp_special.sp_special_db,
			sp_special.sp_special_desc,
			sp_special.sp_special_note,
			sp_special.sp_special_date_from,
			sp_special.sp_special_date_to,
			sp_special.sp_special_lead_time_ind,
			sp_special.sp_special_lead_time_amt,
			sp_special.sp_special_comm_perc,
			sp_special.sp_special_commissionable_yn,
			sp_special.sp_special_min_properties,
			sp_special.sp_special_priority,
			sp_special.ad_create_date,
			sp_special.ad_create_date_tz,
			sp_special.ad_create_user_id

		) VALUES (
			'$dbcode',
			'" . $lDB->escape($sp_special_desc) . "',
			'" . $lDB->escape($sp_special_note) . "',
			'$sp_special_date_from',
			'$sp_special_date_to',
			'$sp_special_lead_time_ind',
			'$sp_special_lead_time_amt',
			'$sp_special_comm_perc',
			'$sp_special_commissionable_yn',
			'$sp_special_min_properties',
			'$sp_special_priority',
			'$createDate',
			'$createDateTz',
			'$pr_user_id'
		)
	");

	$sp_special_id = $lDB->insert_id;

	return $sp_special_id;	
}


function db_sp_special_update($sp_special_id, $sp_special_desc, $sp_special_date_from, $sp_special_date_to, $sp_special_lead_time_ind, $sp_special_lead_time_amt, $sp_special_comm_perc, $sp_special_commissionable_yn ,$sp_special_min_properties, $sp_special_note) {
	global $lDB;

	$updateDate = date("Y-m-d H:i:s");
	$updateDateTz = date("e");

	$pr_user_id = $GLOBALS['userid'];	

	$lDB->put("
		UPDATE 
			sp_special
		SET 
			sp_special.sp_special_desc = '" . $lDB->escape($sp_special_desc) . "',
			sp_special.sp_special_note = '" . $lDB->escape($sp_special_note) . "',
			sp_special.sp_special_date_from = '$sp_special_date_from',
			sp_special.sp_special_date_to = '$sp_special_date_to',
			sp_special.sp_special_lead_time_ind = '$sp_special_lead_time_ind',
			sp_special.sp_special_lead_time_amt = '$sp_special_lead_time_amt',
			sp_special.sp_special_comm_perc = '$sp_special_comm_perc',
			sp_special.sp_special_commissionable_yn = '$sp_special_commissionable_yn',
			sp_special.sp_special_min_properties = '$sp_special_min_properties',
			sp_special.ad_modify_date = '$updateDate',
			sp_special.ad_modify_date_tz = '$updateDateTz',
			sp_special.ad_modify_user_id = '$pr_user_id'
		WHERE
			sp_special.sp_special_ix = '$sp_special_id' 
	");

	return true;
}

function db_sp_special_inactive_check($sp_special_id) {
	$check = $GLOBALS['lDB']->get("
		SELECT
			sp_special.sp_special_inactive_yn
		FROM
			sp_special
		WHERE
			sp_special.sp_special_ix = '$sp_special_id'
	",4);

	return ($check == 1) ? true : false;
}

function db_sp_special_in_use_check($sp_special_id) {
	$special_in_use = false;
	$check = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_special
		WHERE
			sp_special_id = '$sp_special_id'
	",4);
	if($check > 0) {
		$special_in_use = true;
	}
	return $special_in_use;
}

function db_sp_special_delete($sp_special_id) {

	global $lDB;

	if (db_sp_special_in_use_check($sp_special_id)) {
		$lDB->put("
			UPDATE
				sp_special
			SET
				sp_special_inactive_yn = 1,
				ad_modify_date = '".date("Y-m-d")."',
				ad_modify_date_tz = '".date("e")."'
			WHERE
				sp_special_ix = '$sp_special_id'
		");
	} else {
		// sp_accomm_type
		db_sp_accomm_type_delete_by_special($sp_special_id);

		// sp_prop_rate_group
		db_sp_prop_rate_group_delete_by_special($sp_special_id);

		// sp_rate_group_qualify
		db_sp_rate_group_qualify_delete_by_special($sp_special_id);

		// sp_rate_group_benefit
		db_sp_rate_group_benefit_delete_by_special($sp_special_id);

		// sp_special_period
		db_sp_special_period_delete_by_special($sp_special_id);

		// sp_special_rate_type
		db_sp_special_rate_type_delete_by_special($sp_special_id);

		$lDB->put("
			DELETE FROM 
				sp_special 
			WHERE 
				sp_special_ix = '$sp_special_id'
		");

	}

}

function db_sp_special_restore($sp_special_id) {

	global $lDB;

	$lDB->put("
		UPDATE
			sp_special
		SET
			sp_special_inactive_yn = 0,
			ad_modify_date = '".date("Y-m-d")."',
			ad_modify_date_tz = '".date("e")."'
		WHERE
			sp_special_ix = '$sp_special_id'
	");
}
