<?php

require_once(__DIR__ . "/db.rf_database.php");
require_once(__DIR__ . "/class.lock.php");

define("DB_TC_PROP_STOCK_UPDATE_ACCOMM",1);
define("DB_TC_PROP_STOCK_UPDATE_OCCUPANCY",2);
define("DB_TC_PROP_STOCK_UPDATE_BLOCK",3);
define("DB_TC_PROP_STOCK_UPDATE_AGENTALLOCATION",4);

function db_tc_prop_stock_update_code($tc_prop_stock_type_ind) {
	switch($tc_prop_stock_type_ind) {
	case DB_TC_PROP_STOCK_UPDATE_ACCOMM:
		return "accomm";
	case DB_TC_PROP_STOCK_UPDATE_OCCUPANCY:
		return "occupancy";
	case DB_TC_PROP_STOCK_UPDATE_BLOCK:
		return "block";
	case DB_TC_PROP_STOCK_UPDATE_AGENTALLOCATION:
		return "agentAllocation";
	}
}

function db_tc_prop_stock_update_exists($ac_accomm_type_id,$tc_prop_stock_date,$tc_prop_stock_type_ind,$rf_db_code) {
	global $lDB;

	$check = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			tc_prop_stock_update
		WHERE
			ac_accomm_type_id = '" . $lDB->escape($ac_accomm_type_id) . "'
			AND tc_prop_stock_date = '" . $lDB->escape($tc_prop_stock_date) . "'
			AND tc_prop_stock_type_ind = '" . $lDB->escape($tc_prop_stock_type_ind) . "'
			AND rf_db_code = '" . $lDB->escape($rf_db_code) . "'
	",4);

	if($check > 0) {
		return true;
	} else {
		return false;
	}
}

function db_tc_prop_stock_update_insert($ac_accomm_type_id,$tc_prop_stock_date,$tc_prop_stock_type_ind) {
	global $lDB;
	global $isWebServer;
	global $envWebOverride;

	// Wait until data transfers are complete
	$lock = new Lock("data_transfer_tc_res_update",LOCK_LEVEL_PRINCIPAL,-1);
	$lock->Acquire();

	if($isWebServer || $envWebOverride) {
		$dbCodes = db_rf_database_get_remote_codes();
	} else {
		$dbCodes = array('WA');
	}

	foreach($dbCodes as $rf_db_code) {
		$lDB->put("
			INSERT IGNORE INTO tc_prop_stock_update (
				ac_accomm_type_id,
				tc_prop_stock_date,
				tc_prop_stock_type_ind,
				rf_db_code
			) VALUES (
				'".$lDB->escape($ac_accomm_type_id)."',
				'".$lDB->escape($tc_prop_stock_date)."',
				'".$lDB->escape($tc_prop_stock_type_ind)."',
				'".$lDB->escape($rf_db_code)."'
			)
		");
	}

	$lock->Release();

	return true;
}

function db_tc_prop_stock_update_delete($ac_accomm_type_id,$tc_prop_stock_date,$tc_prop_stock_type_ind,$rf_db_code) {
	global $lDB;

	$lDB->put("
		DELETE FROM tc_prop_stock_update WHERE
			ac_accomm_type_id = '" . $lDB->escape($ac_accomm_type_id) . "'
			AND tc_prop_stock_date = '" . $lDB->escape($tc_prop_stock_date) . "'
			AND tc_prop_stock_type_ind = '" . $lDB->escape($tc_prop_stock_type_ind) . "'
			AND rf_db_code = '" . $lDB->escape($rf_db_code) . "'
	");
	return true;
}
