<?php

define("DB_TC_SEQUENCE_INSERTED_VALUE",'TC_SEQUENCE_TABLE_INSERTED');

function db_tc_sequence_exists($tc_sequence_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(tc_sequence_id) FROM tc_sequence WHERE tc_sequence_id = '$tc_sequence_id'",4);
	if($check > 0) { return true; } else { return false; }
}


function db_tc_sequence_exists_by_key($tc_sequence_table_name, $tc_sequence_db_code, $tc_sequence_prefix) {
	global $lDB;

	$check = $lDB->get("
		SELECT
			COUNT(tc_sequence_id)
		FROM tc_sequence
		WHERE
			tc_sequence_name = '$tc_sequence_name'
			AND tc_sequence_db_code = '$tc_sequence_db_code'
			AND tc_sequence_prefix = '$tc_sequence_prefix'
		",4);
	if($check > 0) { return true; } else { return false; }
}

function db_tc_sequence_insert(
		$tc_sequence_table_name,
		$tc_sequence_db_code,
		$tc_sequence_prefix,
		$tc_sequence_next_id=null
	) {
	global $lDB;
	if (db_tc_sequence_exists($tc_sequence_db_code.$tc_sequence_prefix.$tc_sequence_table_name)) {
		return false;
	}
	$tc_sequence_id = false;
	if (empty($tc_sequence_next_id)) {
		$tc_table_key_ind = $lDB->get("SELECT tc_table.tc_table_key_ind FROM tc_table WHERE tc_table.tc_table_name = '$tc_sequence_table_name'",4);
		if ($tc_table_key_ind == 3) {
			$pr_bus_inv_number = $lDB->get("
				SELECT DISTINCT
					pr_business.pr_bus_inv_number
				FROM pr_business
				WHERE
					pr_business.pr_bus_inv_prefix = '$tc_sequence_prefix'
			",4);
			$tc_sequence_next_id = (!empty($pr_bus_inv_number)&&$tc_sequence_table_name=='fn_invoice')?$pr_bus_inv_number:$lDB->get("
				SELECT IFNULL(MAX($tc_sequence_table_name.".$tc_sequence_table_name."_id),0) + 1
				FROM
					$tc_sequence_table_name
				WHERE
					$tc_sequence_table_name.".$tc_sequence_table_name."_prefix = '$tc_sequence_prefix'
					AND $tc_sequence_table_name.".$tc_sequence_table_name."_db = '".$tc_sequence_db_code."'
			",4);
		} else {
			$tc_sequence_next_id = $lDB->get("
				SELECT IFNULL(MAX($tc_sequence_table_name.".$tc_sequence_table_name."_id),0) + 1
				FROM
					$tc_sequence_table_name
				WHERE
					$tc_sequence_table_name.".$tc_sequence_table_name."_db = '".$tc_sequence_db_code."'
			",4);
		}
	}
	$tc_sequence_next_id = $tc_sequence_next_id===false?1:$tc_sequence_next_id;
	$tempFlag = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = "1";
	$lDB->put("
		INSERT INTO tc_sequence (
			tc_sequence_table_name,
			tc_sequence_db_code,
			tc_sequence_prefix,
			tc_sequence_next_id,
			dt_temp_id
		)
		VALUES (
			'$tc_sequence_table_name',
			'$tc_sequence_db_code',
			'$tc_sequence_prefix',
			$tc_sequence_next_id,
			'".DB_TC_SEQUENCE_INSERTED_VALUE."'
		)
	");
	$GLOBALS['flagChngs'] = $tempFlag;
	$tc_sequence_id = db_tc_sequence_get_inserted();

	return $tc_sequence_id;
}

function db_tc_sequence_increment(
	$tc_sequence_table_name,
	$tc_sequence_db_code,
	$tc_sequence_prefix=''
) {
	global $lDB;
	$GLOBALS['incrementSequence'] = isset($GLOBALS['incrementSequence'])?$GLOBALS['incrementSequence']:"1";

	if ($GLOBALS['incrementSequence'] == "1") {
		$lDB->put("
			UPDATE
				tc_sequence
				INNER JOIN $tc_sequence_table_name ON $tc_sequence_table_name.".$tc_sequence_table_name."_db = tc_sequence.tc_sequence_db_code
			SET
				tc_sequence.tc_sequence_next_id = tc_sequence.tc_sequence_next_id + 1
			WHERE
				tc_sequence.tc_sequence_id = '".$tc_sequence_db_code.$tc_sequence_prefix."$tc_sequence_table_name'
		");
	}
}

function db_tc_sequence_insert_missing_tables($tc_sequence_db_code) {
	global $lDB;
	$tc_sequence_tables = db_tc_sequence_get_missing_tables($tc_sequence_db_code);
	foreach($tc_sequence_tables as $tc_sequence_table) {
		db_tc_sequence_insert(
			$tc_sequence_table['tc_table_name'],
			$tc_sequence_db_code,
			$tc_sequence_table['pr_bus_inv_prefix']
		);
	}
}

function db_tc_sequence_get_missing_tables($tc_sequence_db_code) {
	global $lDB;

	return array_merge(
		$lDB->get("
			SELECT DISTINCT
				tc_table.tc_table_name,
				'' AS pr_bus_inv_prefix,
				'' AS pr_bus_inv_number
			FROM
				tc_table
			WHERE
				tc_table.tc_table_user_facing_yn = '1'
				AND tc_table.tc_table_name NOT IN (
					SELECT DISTINCT
						tc_sequence.tc_sequence_table_name
					FROM
						tc_sequence
					WHERE
						tc_sequence.tc_sequence_db_code = '".$tc_sequence_db_code."'
						AND (
							tc_sequence_prefix IS NULL
							OR tc_sequence_prefix = ''
						)
				)
		", 6),
		$lDB->get("
			SELECT DISTINCT
				tc_table.tc_table_name,
				pr_business.pr_bus_inv_prefix,
				pr_business.pr_bus_inv_number
			FROM
				tc_table, pr_business
			WHERE
				pr_business.pr_bus_inactive_yn != '1'
				AND tc_table.tc_table_user_facing_yn = '1'
				AND tc_table.tc_table_key_ind = '3'
				AND CONCAT('".$tc_sequence_db_code."', pr_business.pr_bus_inv_prefix, tc_table.tc_table_name) NOT IN (
					SELECT DISTINCT
						tc_sequence.tc_sequence_id
					FROM
						tc_sequence
					WHERE
						tc_sequence.tc_sequence_db_code = '".$tc_sequence_db_code."'
				)
		", 6)
	);
}

function db_tc_sequence_get_inserted() {
	global $lDB;
	$insert_id = $lDB->get("SELECT tc_sequence_id FROM tc_sequence WHERE dt_temp_id = '".DB_TC_SEQUENCE_INSERTED_VALUE."'",4);
	$lDB->put("UPDATE tc_sequence SET dt_temp_id = NULL WHERE tc_sequence_id = '$insert_id'");
	return $insert_id;
}

function db_tc_sequence_get_next_id(
	$tc_sequence_table_name,
	$tc_sequence_db_code,
	$tc_sequence_prefix=''
) {
	global $lDB;
	$tc_sequence_next_id = $lDB->get("
		SELECT
			tc_sequence_next_id
		FROM
			tc_sequence
		WHERE
			tc_sequence_table_name = '$tc_sequence_table_name'
			AND tc_sequence_db_code = '$tc_sequence_db_code'
			AND tc_sequence_prefix = '$tc_sequence_prefix'
		FOR UPDATE
	",4);
	$table_next_id = $lDB->get("
		SELECT COUNT(*)
		FROM
			$tc_sequence_table_name
		WHERE
			$tc_sequence_table_name.".$tc_sequence_table_name."_ix = '$tc_sequence_db_code$tc_sequence_prefix$tc_sequence_next_id'
	",4);
	$prefixWhere = !empty($tc_sequence_prefix)?"AND $tc_sequence_table_name.".$tc_sequence_table_name."_prefix = '$tc_sequence_prefix'":"";
	$table_max_id = $lDB->get("
		SELECT MAX($tc_sequence_table_name.".$tc_sequence_table_name."_id)
		FROM
			$tc_sequence_table_name
		WHERE
			$tc_sequence_table_name.".$tc_sequence_table_name."_db = '$tc_sequence_db_code'
			$prefixWhere
	",4);
	if ($tc_sequence_next_id <= $table_max_id || !empty($table_next_id)) {
		db_tc_sequence_increment(
			$tc_sequence_table_name,
			$tc_sequence_db_code,
			$tc_sequence_prefix
		);
		$tc_sequence_next_id = db_tc_sequence_get_next_id(
			$tc_sequence_table_name,
			$tc_sequence_db_code,
			$tc_sequence_prefix
		);
	}
	return $tc_sequence_next_id;
}

function db_tc_sequence_reset(
	$tc_sequence_table_name,
	$tc_sequence_db_code,
	$tc_sequence_prefix=''
) {
	global $lDB;
	$tc_sequence_next_id = $lDB->get("
		SELECT
			tc_sequence_next_id
		FROM
			tc_sequence
		WHERE
			tc_sequence_table_name = '$tc_sequence_table_name'
			AND tc_sequence_db_code = '$tc_sequence_db_code'
			AND tc_sequence_prefix = '$tc_sequence_prefix'
		FOR UPDATE
	",4);
	$table_next_id = $lDB->get("
		SELECT COUNT(*)
		FROM
			$tc_sequence_table_name
		WHERE
			$tc_sequence_table_name.".$tc_sequence_table_name."_ix = '$tc_sequence_db_code$tc_sequence_prefix$tc_sequence_next_id'
	",4);
	$prefixWhere = !empty($tc_sequence_prefix)?"AND $tc_sequence_table_name.".$tc_sequence_table_name."_prefix = '$tc_sequence_prefix'":"";
	$table_max_id = $lDB->get("
		SELECT MAX($tc_sequence_table_name.".$tc_sequence_table_name."_id)
		FROM
			$tc_sequence_table_name
		WHERE
			$tc_sequence_table_name.".$tc_sequence_table_name."_db = '$tc_sequence_db_code'
			$prefixWhere
	",4);
	$table_max_id = empty($table_max_id)?0:$table_max_id;
	$table_next_id = $table_max_id + 1;
	if ($tc_sequence_next_id != $table_next_id) {
		$lDB->put("
			UPDATE
				tc_sequence
			SET
				tc_sequence.tc_sequence_next_id = $table_next_id
			WHERE
				tc_sequence.tc_sequence_id = '".$tc_sequence_db_code.$tc_sequence_prefix."$tc_sequence_table_name'
		");
	}
	return $table_next_id;
}
