<?php

require_once(__DIR__ . "/db.tc_table.php");
require_once(__DIR__ . "/db.rf_database.php");

define("DB_TR_RULE_EXCLUDE",0);
define("DB_TR_RULE_INCLUDE",1);

define("DB_TR_RULE_TYPE_FIELD_COMPARE",1);
define("DB_TR_RULE_TYPE_ALWAYS_TRUE",2);

function db_tr_rule_get_remote_codes($tc_table_name,$record_id,$exclude=false) {
	global $lDB;

	$rules = $lDB->get("
		SELECT
			tr_rule.tr_rule_ix,
			tr_rule.tr_rule_type,
			tr_rule.tr_rule_field_1,
			tr_rule.tr_rule_field_2,
			tr_rule.tr_rule_inc_excl
		FROM
			tr_rule
			INNER JOIN tc_table ON tc_table.tc_table_id = tr_rule.tc_table_id
		WHERE
			tc_table.tc_table_name = '$tc_table_name'
		ORDER BY
			tr_rule.tr_rule_seq
	",2);
	if(sizeof($rules) > 0) {
		if($rules[0]['tr_rule_inc_excl'] == DB_TR_RULE_INCLUDE) {
			$codes = array();
		} else {
			$codes = db_rf_database_get_remote_codes($exclude);
		}
		foreach($rules as $rule) {
			$match = false;
			switch($rule['tr_rule_type']) {
			case DB_TR_RULE_TYPE_FIELD_COMPARE:
				$key = db_tc_table_get_key($tc_table_name);
				$check = $lDB->get("SELECT $rule[tr_rule_field_1] FROM $tc_table_name WHERE $key = '$record_id'",4);
				if($check == $rule['tr_rule_field_2']) {
					$match = true;
				}
				break;
			case DB_TR_RULE_TYPE_ALWAYS_TRUE:
				$match = true;
				break;
			}

			if($match) {
				$ruleCodes = $lDB->get("SELECT rf_db_code FROM tr_rule_item WHERE tr_rule_item.tr_rule_id = '$rule[tr_rule_ix]'",3);
				if($rule['tr_rule_inc_excl'] == "1") {
					$codes = array_unique(array_merge($codes,$ruleCodes));
				} else {
					$codes = array_diff($codes,$ruleCodes); // exclusion
				}
			}
		}
		$codes = array_intersect($codes,db_rf_database_get_remote_codes($exclude));
	} else {
		$codes = db_rf_database_get_remote_codes($exclude);
	}

	return $codes;
}
