<?php

/*
 * $Id: db.zg_account_prop.php,v 1.4 2011-05-30 12:49:56 light Exp $
 *
 * $Log: db.zg_account_prop.php,v $
 * Revision 1.4  2011-05-30 12:49:56  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.3  2011-05-17 14:08:23  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.2  2009-07-31 18:08:16  light
 * Bug #6855 - Guest API
 *
 * Revision 1.1  2009-05-22 14:31:32  light
 * Bug #6639 - API to eGuestSurv
 *
 */

/**
 * db.zg_account_prop.php - Database access routines for the zg_account_prop table
 */

require_once(__DIR__ . "/db.zg_account.php");
require_once(__DIR__ . "/db.pr_persona.php");

 function db_zg_account_prop_exists($zg_account_prop_id) {
	global $lDB;

	$propCheck = $lDB->get("SELECT COUNT(zg_account_prop_ix) FROM zg_account_prop WHERE zg_account_prop_ix = '$zg_account_prop_id'",4);
	if($propCheck > 0) { return true; } else { return false; }
}

function db_zg_account_prop_insert($zg_account_id, $pr_business_id, $zg_acc_prop_code=false) {
	global $dbcode;
	global $lDB;
	
	if(!db_zg_account_exists($zg_account_id) || !db_pr_persona_exists($pr_business_id)) { return false; }

	$extra = array();
	if($zg_acc_prop_code !== false) {
		$extra['zg_acc_prop_code'] = $lDB->escape($zg_acc_prop_code);
	}
	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}
	
	$lDB->put("
		INSERT INTO zg_account_prop (
			zg_account_prop_db,
			zg_account_id,
			pr_business_id
			$extraFields
		) VALUES (
			'".$lDB->escape($dbcode)."',	
			'".$lDB->escape($zg_account_id)."',
			'".$lDB->escape($pr_business_id)."'
			$extraValues
		)
	");

	$zg_account_prop_ix = $lDB->insert_id;
	
	return $zg_account_prop_ix;
}

function db_zg_account_prop_update($zg_account_prop_id, $zg_acc_prop_code) {
	global $lDB;

	if(db_zg_account_prop_exists($zg_account_prop_id)) {
		$lDB->put("
			UPDATE 
				zg_account_prop 
			SET 
				zg_acc_prop_code = '".$lDB->escape($zg_acc_prop_code)."' 
			WHERE 
				zg_account_prop_ix = '$zg_account_prop_id'
		");
		return true;
	} else {
		return false;
	}
}

function db_zg_account_prop_delete($zg_account_prop_id) {
	global $lDB;
	
	if(db_zg_account_prop_exists($zg_account_prop_id)) {
		$lDB->put("DELETE FROM zg_account_prop WHERE zg_account_prop_ix = '$zg_account_prop_id' ");
		return true;
	} else {
		return false;
	}
}

function db_zg_account_prop_delete_by_business($pr_business_id, $zg_account_id) {
	global $lDB;
	
	$zg_account_prop_id = $lDB->get("SELECT zg_account_prop_ix FROM zg_account_prop WHERE pr_business_id = '$pr_business_id' AND zg_account_id='$zg_account_id'",4);
	if($zg_account_prop_id != "") {
		db_zg_account_prop_delete($zg_account_prop_id);
	}
}

function db_zg_account_prop_exists_by_account($zg_account_id) {
	global $lDB;
	
	$propCount = $lDB->get("
		SELECT 
			COUNT(zg_account_id) 
		FROM 
			zg_account_prop 
		WHERE 
			zg_account_id = '$zg_account_id'
	",4);
	if($propCount > 0) {
		return true;
	} else {
		return false;
	}
}

function zg_account_prop_get_related($propId = null ,$include=true) {
	if(empty($propId)) return array();
	$relatedAccnt = $GLOBALS['lDB']->get("
		SELECT	
			zg_account_prop.zg_account_id 
		FROM 
			zg_account_prop
			INNER JOIN zg_account ON zg_account_prop.zg_account_id = zg_account.zg_account_ix
		WHERE 
			zg_account_prop.pr_business_id = '$propId'
			AND zg_account.zg_account_inactive_yn = 0
	", 4);

	if(empty($relatedAccnt)) return array();

	$extra = "";
	if(!$include) $extra = " AND pr_business_id != '$propId'"; 

	return $GLOBALS['lDB']->get("
		SELECT	pr_business_id FROM zg_account_prop WHERE zg_account_id = '$relatedAccnt' $extra
	", 3);
}
