<?php

/*
 * $Id: db.zg_transfer.php,v 1.3 2011-05-30 12:49:56 light Exp $
 *
 * $Log: db.zg_transfer.php,v $
 * Revision 1.3  2011-05-30 12:49:56  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.2  2011-05-17 14:08:23  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.1  2009-05-22 14:31:32  light
 * Bug #6639 - API to eGuestSurv
 *
 */

/**
 * db.zg_transfer.php - Database access routines for the zg_transfer table
 */

DEFINE('DB_ZG_TRANSFER_SUCCESS',1);
DEFINE('DB_ZG_TRANSFER_FAILED',2);
DEFINE('DB_ZG_TRANSFER_RESENT',3);

function db_zg_transfer_exists($zg_transfer_id) {
	global $lDB;

	$transferCheck = $lDB->get("SELECT COUNT(zg_transfer_ix) FROM zg_transfer WHERE zg_transfer_ix = '$zg_transfer_id'",4);
	
	if($transferCheck > 0) { return true; } else { return false; }
}

function db_zg_transfer_insert($zg_trf_log,  $zg_trf_date_close=false, $zg_trf_status_ind=false, $zg_trf_request=false, $zg_trf_response=false) {
	global $dbcode;
	global $lDB;
	$zg_trf_date_open = date("Y-m-d H:i:s");
	$zg_trf_date_open_tz = date("e");
	
	$extra = array();
	if($zg_trf_date_close !== false) {
		$extra['zg_trf_date_close'] = $zg_trf_date_close;
	}
	if($zg_trf_status_ind !== false) {
		$extra['zg_trf_status_ind'] = $zg_trf_status_ind;
	}
	if($zg_trf_request !== false) {
		$extra['zg_trf_request'] = $zg_trf_request;
	}
	if($zg_trf_response !== false) {
		$extra['zg_trf_response'] = $zg_trf_response;
	}
	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}

	$lDB->put("
		INSERT INTO zg_transfer (
			zg_transfer_db, 
			zg_trf_date_open,
			zg_trf_date_open_tz,
			zg_trf_log
			$extraFields
		) VALUES (
			'".$lDB->escape($dbcode)."', 
			'".$lDB->escape($zg_trf_date_open)."',
			'".$lDB->escape($zg_trf_date_open_tz)."',
			'".$lDB->escape($zg_trf_log)."'
			$extraValues
		)
	");

	$zg_transfer_ix = $lDB->insert_id;
	
	return $zg_transfer_ix;
}

function db_zg_transfer_set_request($zg_transfer_id, $zg_trf_request) {
	global $lDB;
	
	if(db_zg_transfer_exists($zg_transfer_id)) {
		
		$lDB->put("
			UPDATE zg_transfer SET
				zg_trf_request = '".$lDB->escape($zg_trf_request)."'
			WHERE
				zg_transfer_ix ='$zg_transfer_id'
		");
		return true;
	} else {
		return false;
	}
}

function db_zg_transfer_set_response($zg_transfer_id, $zg_trf_response) {
	global $lDB;
	if(db_zg_transfer_exists($zg_transfer_id)) {
		$lDB->put("
			UPDATE zg_transfer SET
				zg_trf_response = '".$lDB->escape($zg_trf_response)."' 
			WHERE
				zg_transfer_ix = '$zg_transfer_id'
		");
		return true;
	} else {
		return false;
	}
}

function db_zg_transfer_update($zg_transfer_id, $zg_trf_status_ind, $zg_trf_log, $zg_trf_date_close=true) {
	global $lDB;
	$closeDate = "";
	if($zg_trf_date_close) {
		$zg_trf_date_close = date("Y-m-d H:i:s");
		$zg_trf_date_close_tz = date("e");
		$closeDate = "zg_trf_date_close='$zg_trf_date_close', zg_trf_date_close_tz='$zg_trf_date_close_tz',";
	}

	if(db_zg_transfer_exists($zg_transfer_id)) {
		$lDB->put("
			UPDATE zg_transfer SET
				zg_trf_status_ind='".$lDB->escape($zg_trf_status_ind)."',
				$closeDate
				zg_trf_log='".$lDB->escape($zg_trf_log)."'
			WHERE
				zg_transfer_ix ='$zg_transfer_id'
		");
	}
}
