<?php

/*
 * $Id: db.zg_transfer_guest.php,v 1.4 2011-05-30 12:49:56 light Exp $
 *
 * $Log: db.zg_transfer_guest.php,v $
 * Revision 1.4  2011-05-30 12:49:56  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.3  2011-05-17 14:08:23  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.2  2009-07-31 18:08:16  light
 * Bug #6855 - Guest API
 *
 * Revision 1.1  2009-05-22 14:31:32  light
 * Bug #6639 - API to eGuestSurv
 *
 */

/**
 * db.zg_transfer_guest.php - Database access routines for the zg_transfer_guest table
 */

require_once(__DIR__ . '/db.zg_transfer.php');
require_once(__DIR__ . '/db.zg_transfer_guest_prop.php');
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/db.zg_account_prop.php");

DEFINE('DB_ZG_TRANSFER_GUEST_UNLOGGED',0);
DEFINE('DB_ZG_TRANSFER_GUEST_SUCCESS',1);
DEFINE('DB_ZG_TRANSFER_GUEST_FAILED',2);

function db_zg_transfer_guest_exists($zg_transfer_guest_id) {
	global $lDB;

	$transferGuestCheck = $lDB->get("SELECT COUNT(zg_transfer_guest_ix) FROM zg_transfer_guest WHERE zg_transfer_guest_ix = '$zg_transfer_guest_id'",4);
	if($transferGuestCheck > 0) { return true; } else { return false; }
}

function db_zg_transfer_guest_insert($zg_transfer_id, $pr_guest_id, $pr_business_id, $rv_reservation_id) {
	global $dbcode;
	global $lDB;

	if(!db_zg_transfer_exists($zg_transfer_id) || !db_pr_persona_exists($pr_guest_id) || !db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}
	
	$lDB->put("
		INSERT INTO zg_transfer_guest (
			zg_transfer_guest_db,
			pr_guest_id,
			rv_reservation_id,
			zg_transfer_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pr_guest_id)."',
			'".$lDB->escape($rv_reservation_id)."',
			'".$lDB->escape($zg_transfer_id)."'
		)
	");

	$zg_transfer_guest_ix = $lDB->insert_id;
	$relatedProp = zg_account_prop_get_related($pr_business_id);
	foreach($relatedProp as $pr_business_id) {
		db_zg_transfer_guest_prop_insert($zg_transfer_guest_ix, $pr_business_id);
	}

	return $zg_transfer_guest_ix;
}

function db_zg_transfer_guest_set_status($zg_transfer_guest_id, $zg_trf_guest_status_ind) {
	global $lDB;
	if(db_zg_transfer_guest_exists($zg_transfer_guest_id)) {
		$lDB->put("UPDATE zg_transfer_guest SET zg_trf_guest_status_ind = '".$lDB->escape($zg_trf_guest_status_ind)."' WHERE zg_transfer_guest_ix = '$zg_transfer_guest_id'");
		return true;
	} else {
		return false;
	}
}
