<?php

require_once(__DIR__ . "/db.zs_task.php");
require_once(__DIR__ . "/db.zs_task_log.php");

define("STATUS_SUCCESS",0);
define("STATUS_PENDING",10);
define("STATUS_EXECUTING",20);
define("STATUS_ERROR",30);
define("STATUS_FATAL_ERROR",40);

function db_zs_queue_exists($zs_queue_id) {
	global $lDB;

	$queueCheck = $lDB->get("SELECT COUNT(zs_queue_ix) FROM zs_queue WHERE zs_queue_ix = '$zs_queue_id'",4);
	if($queueCheck > 0) { return true; } else { return false; }
}

function db_zs_queue_insert($zs_schedule_id,$zs_queue_date_sched,$zs_queue_status_ind=STATUS_PENDING,$zs_queue_task_title=false,$zs_queue_details=false,$zs_queue_parent_id=false,$zs_task_notify_id=false,$pr_user_id=false) {
	global $lDB;

	$createDate = date("Y-m-d H:i:s");
	$timeZone = date("e");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$taskInfo = $lDB->get("
		SELECT
			zs_task.zs_task_ix,
			zs_task.zs_task_title,
			zs_task.zs_task_command
		FROM
			zs_schedule
			INNER JOIN zs_task ON zs_task.zs_task_ix = zs_schedule.zs_task_id
		WHERE
			zs_schedule.zs_schedule_ix = '$zs_schedule_id'
	",1);
	$zs_task_id = $lDB->get("SELECT zs_task_id FROM zs_schedule WHERE zs_schedule_ix = '$zs_schedule_id'",4);

	if($zs_queue_task_title === false) {
		$zs_queue_task_title = addslashes($taskInfo['zs_task_title']);
	}

	if($zs_queue_details === false) {
		$zs_queue_details = "";
	}

	if($zs_queue_status_ind==STATUS_SUCCESS) {
		$zs_queue_date_start = $zs_queue_date_end = date("Y-m-d H:i:s");
	} else {
		$zs_queue_date_start = $zs_queue_date_end = "0000-00-00 00:00:00";
	}

	$extra = array();
	if($zs_queue_parent_id !== false) {
		$attemptNext = $lDB->get("SELECT zs_queue_attempt_next FROM zs_queue WHERE zs_queue_ix = '$zs_queue_parent_id'",4);
		$extra['zs_queue_parent_id'] = $zs_queue_parent_id;
		$extra['zs_queue_parent_attempt_next'] = $attemptNext;
	}
	if($zs_task_notify_id !== false) {
		$extra['zs_task_notify_id'] = $zs_task_notify_id;
	}
	$extraField = "";
	$extraValue = "";
	foreach($extra as $key=>$item) {
		$extraField .= "$key,\n";
		$extraValue .= "'$item',\n";
	}
	

	$zs_task_command = addslashes($taskInfo['zs_task_command']);

	$lDB->put("
		INSERT INTO zs_queue (
			zs_queue_db,
			zs_queue_id,
			zs_schedule_id,
			zs_task_id,
			zs_queue_command,
			zs_queue_date_sched,
			zs_queue_date_sched_tz,
			zs_queue_attempt_next,
			zs_queue_attempt_next_tz,
			zs_queue_status_ind,
			zs_queue_task_title,
			zs_queue_details,
			zs_queue_date_start,
			zs_queue_date_start_tz,
			zs_queue_date_end,
			zs_queue_date_end_tz,
			$extraField
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($zs_schedule_id)."',
			'".$lDB->escape($taskInfo['zs_task_ix'])."',
			'".$lDB->escape($zs_task_command)."',
			'".$lDB->escape($zs_queue_date_sched)."',
			'".$lDB->escape($timeZone)."',
			'".$lDB->escape($zs_queue_date_sched)."',
			'".$lDB->escape($timeZone)."',
			'".$lDB->escape($zs_queue_status_ind)."',
			'".$lDB->escape($zs_queue_task_title)."',
			'".$lDB->escape($zs_queue_details)."',
			'".$lDB->escape($zs_queue_date_start)."',
			'".$lDB->escape($timeZone)."',
			'".$lDB->escape($zs_queue_date_end)."',
			'".$lDB->escape($timeZone)."',
			$extraValue
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($timeZone)."',
			'".$lDB->escape($pr_user_id)."'
		)
	");
	$queueId = $lDB->insert_id;

	db_zs_task_log_insert($queueId);

	return $queueId;	
}

function db_zs_queue_update($zs_queue_id,$zs_queue_status_ind,$zs_queue_details=false,$zs_queue_attempt_count=false,$zs_queue_command=false,$pr_user_id=false) {
	global $lDB;

	$modifyDate = date("Y-m-d H:i:s");
	$modifyDateTz = date("e");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$queue = $lDB->get("
		SELECT
			zs_queue.zs_queue_attempt_count,
			zs_queue.zs_queue_date_start,
			zs_queue.zs_queue_date_end,
			zs_task.zs_task_ix,
			zs_task.zs_task_retry_delay,
			zs_task.zs_task_retries
		FROM
			zs_queue
			INNER JOIN zs_task ON zs_task.zs_task_ix = zs_queue.zs_task_id
		WHERE
			zs_queue.zs_queue_ix = '$zs_queue_id'
	",1);

	$extra = array();

	if($zs_queue_status_ind == STATUS_EXECUTING) {
		$extra['zs_queue_attempt_count'] = $queue['zs_queue_attempt_count'] + 1;
		if($queue['zs_queue_date_start'] == "0000-00-00 00:00:00") {
			$extra['zs_queue_date_start'] = date("Y-m-d H:i:s");
		}
	}

	if($zs_queue_status_ind == STATUS_ERROR) {
		if($queue['zs_queue_attempt_count'] > $queue['zs_task_retries']) {
			$zs_queue_status_ind = STATUS_FATAL_ERROR;
		} else {
			$extra['zs_queue_attempt_next'] = date("Y-m-d H:i:00", time() + ($queue['zs_task_retry_delay'] * 60));
		}
	}

	if($zs_queue_status_ind == STATUS_SUCCESS || $zs_queue_status_ind == STATUS_ERROR || $zs_queue_status_ind == STATUS_FATAL_ERROR) {
		$extra['zs_queue_date_end'] = date("Y-m-d H:i:s");
	}

	if($zs_queue_details !== false) {
		$extra['zs_queue_details'] = $lDB->escape($zs_queue_details);
	}

	if($zs_queue_attempt_count !== false) {
		$extra['zs_queue_attempt_count'] = $lDB->escape($zs_queue_attempt_count);
	}

	if($zs_queue_command !== false) {
		$extra['zs_queue_command'] = $lDB->escape($zs_queue_command);
	}

	$extraSQL = "";
	foreach($extra as $key=>$item) {
		$extraSQL .= "$key = '$item',\n";
	}

	$lDB->put("
		UPDATE zs_queue SET
			zs_queue_status_ind = '".$lDB->escape($zs_queue_status_ind)."',
			$extraSQL
			ad_modify_date = '".$lDB->escape($modifyDate)."',
			ad_modify_date_tz = '".$lDB->escape($modifyDateTz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			zs_queue_ix = '$zs_queue_id'
	");

	if($zs_queue_status_ind == STATUS_FATAL_ERROR) {
		db_zs_task_set_suspend($queue['zs_task_ix'],$zs_queue_details,$pr_user_id=false);
	}

	db_zs_task_log_insert($zs_queue_id);

	return true;
}

/**
 * Resets the status of all EXECUTING tasks to PENDING
 */
function db_zs_queue_reset($pr_user_id=false) {
	$list = $GLOBALS['lDB']->get("SELECT zs_queue_ix FROM zs_queue WHERE zs_queue_status_ind = '".STATUS_EXECUTING."'",3);
	$list = empty($list) ? array() : $list;
	foreach($list as $zs_queue_id) {
		db_zs_queue_update($zs_queue_id,STATUS_PENDING);
	}
}

function db_zs_queue_set_inactive($zs_queue_id) {
	$GLOBALS['lDB']->put("UPDATE zs_queue SET zs_queue_inactive_yn = '1' WHERE zs_queue_ix = '$zs_queue_id'");
}

function db_zs_queue_delete($zs_queue_id) {
	if(db_zs_queue_exists($zs_queue_id)) {
		$GLOBALS['lDB']->put("DELETE FROM zs_queue WHERE zs_queue_ix = '$zs_queue_id'");
		return true;
	} else {
		return false;
	}
}

function db_zs_queue_delete_by_schedule($zs_schedule_id) {
	$list = $GLOBALS['lDB']->get("SELECT zs_queue_ix FROM zs_queue WHERE zs_schedule_id = '$zs_schedule_id'",3);
	foreach($list as $item) {
		db_zs_queue_delete($item);
	}
}
