<?php
require_once(__DIR__ . "/db.zs_queue.php");

define("DB_ZS_SCHEDULE_REPEAT",1);
define("DB_ZS_SCHEDULE_ONCE",2);
define("DB_ZS_SCHEDULE_SUSPEND",3);

function db_zs_schedule_exists($zs_schedule_id) {
	global $lDB;

	$scheduleCheck = $lDB->get("SELECT COUNT(zs_schedule_ix) FROM zs_schedule WHERE zs_schedule_ix = '$zs_schedule_id'",4);
	if($scheduleCheck > 0) { return true; } else { return false; }
}

function db_zs_schedule_insert($zs_task_id,$zs_sched_type_ind,$zs_sched_sch_minute,$zs_sched_sch_hour,$zs_sched_sch_dom,$zs_sched_sch_month,$zs_sched_sch_dow,$pr_user_id=false) {
	global $lDB;

	$createDate = date("Y-m-d H:i:s");
	$createDateTz = date("e");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$zs_sched_sch_minute = is_array($zs_sched_sch_minute) ? implode(",", $zs_sched_sch_minute) : "";
	$zs_sched_sch_hour = is_array($zs_sched_sch_hour) ? implode(",", $zs_sched_sch_hour) : "";
	$zs_sched_sch_dom = is_array($zs_sched_sch_dom) ? implode(",", $zs_sched_sch_dom) : "";
	$zs_sched_sch_month = is_array($zs_sched_sch_month) ? implode(",", $zs_sched_sch_month) : "";
	$zs_sched_sch_dow = is_array($zs_sched_sch_dow) ? implode(",", $zs_sched_sch_dow) : "";			

	$lDB->put("
		INSERT INTO zs_schedule (
			zs_schedule_db,
			zs_schedule_id,
			zs_task_id,
			zs_sched_last_execution,
			zs_sched_last_execution_tz,
			zs_sched_type_ind,
			zs_sched_sch_minute,
			zs_sched_sch_hour,
			zs_sched_sch_dom,
			zs_sched_sch_month,
			zs_sched_sch_dow,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($zs_task_id)."',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($createDateTz)."',
			'".$lDB->escape($zs_sched_type_ind)."',
			'".$lDB->escape($zs_sched_sch_minute)."',
			'".$lDB->escape($zs_sched_sch_hour)."',
			'".$lDB->escape($zs_sched_sch_dom)."',
			'".$lDB->escape($zs_sched_sch_month)."',
			'".$lDB->escape($zs_sched_sch_dow)."',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($createDateTz)."',
			'".$lDB->escape($pr_user_id)."'
		)
	");
	$scheduleId = $lDB->insert_id;
	
	return $scheduleId;	
}

function db_zs_schedule_update($zs_schedule_id,$zs_sched_type_ind,$zs_sched_sch_minute,$zs_sched_sch_hour,$zs_sched_sch_dom,$zs_sched_sch_month,$zs_sched_sch_dow,$pr_user_id=false) {
	global $lDB;

	$modifyDate = date("Y-m-d H:i:s");
	$modifyDateTz = date("e");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$zs_sched_sch_minute = is_array($zs_sched_sch_minute) ? implode(",", $zs_sched_sch_minute) : "";
	$zs_sched_sch_hour = is_array($zs_sched_sch_hour) ? implode(",", $zs_sched_sch_hour) : "";
	$zs_sched_sch_dom = is_array($zs_sched_sch_dom) ? implode(",", $zs_sched_sch_dom) : "";
	$zs_sched_sch_month = is_array($zs_sched_sch_month) ? implode(",", $zs_sched_sch_month) : "";
	$zs_sched_sch_dow = is_array($zs_sched_sch_dow) ? implode(",", $zs_sched_sch_dow) : "";			

	$lDB->put("
		UPDATE zs_schedule SET
			zs_sched_type_ind = '".$lDB->escape($zs_sched_type_ind)."',
			zs_sched_sch_minute = '".$lDB->escape($zs_sched_sch_minute)."',
			zs_sched_sch_hour = '".$lDB->escape($zs_sched_sch_hour)."',
			zs_sched_sch_dom = '".$lDB->escape($zs_sched_sch_dom)."',
			zs_sched_sch_month = '".$lDB->escape($zs_sched_sch_month)."',
			zs_sched_sch_dow = '".$lDB->escape($zs_sched_sch_dow)."',
			ad_modify_date = '".$lDB->escape($modifyDate)."',
			ad_modify_date_tz = '".$lDB->escape($modifyDateTz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			zs_schedule_ix = '$zs_schedule_id'
	");
	return true;
}

function db_zs_schedule_set_last_execution($zs_schedule_id,$zs_sched_last_execution=false) {
	global $lDB;
	if($zs_sched_last_execution === false) {
		$zs_sched_last_execution = date("Y-m-d H:i:s");
	}
	$zs_sched_last_execution_tz = date("e");
	$lDB->put("UPDATE zs_schedule SET zs_sched_last_execution = '".$lDB->escape($zs_sched_last_execution)."', zs_sched_last_execution_tz = '".$lDB->escape($zs_sched_last_execution_tz)."' WHERE zs_schedule_ix = '$zs_schedule_id'");
}

function db_zs_schedule_delete($zs_schedule_id) {
	if(db_zs_schedule_exists($zs_schedule_id)) {
		$GLOBALS['lDB']->put("DELETE FROM zs_schedule WHERE zs_schedule_ix = '$zs_schedule_id'");
		db_zs_queue_delete_by_schedule($zs_schedule_id);
		return true;
	} else {
		return false;
	}
}

function db_zs_schedule_delete_by_task($zs_task_id) {
	$list = $GLOBALS['lDB']->get("SELECT zs_schedule_ix FROM zs_schedule WHERE zs_task_id = '$zs_task_id'",3);
	foreach($list as $item) {
		db_zs_schedule_delete($item);
	}
}

function db_zs_schedule_set_type_ind($zs_schedule_id,$zs_sched_type_ind) {
	global $lDB;
	$lDB->put("UPDATE zs_schedule SET zs_sched_type_ind = '".$lDB->escape($zs_sched_type_ind)."' WHERE zs_schedule_ix = '$zs_schedule_id'");
}
