<?php
define("TASK_RETRIES",1);
define("TASK_RETRY_DELAY",1);

require_once(__DIR__ . "/db.zs_schedule.php");
require_once(__DIR__ . "/db.zs_task_notify.php");

function db_zs_task_exists($zs_task_id) {
	global $lDB;

	$taskCheck = $lDB->get("SELECT COUNT(zs_task_ix) FROM zs_task WHERE zs_task_ix = '$zs_task_id'",4);
	if($taskCheck > 0) { return true; } else { return false; }
}

function db_zs_task_insert($zs_task_title,$zs_task_command,$zs_task_target_db,$zs_task_retries,$zs_task_retry_delay,$zs_task_recover_all_yn,$zs_task_inactive_yn,$pr_user_id=false) {
	global $lDB;

	$createDate = date("Y-m-d H:i:s");
	$createDateTz = date("e");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$lDB->put("
		INSERT INTO zs_task (
			zs_task_db,
			zs_task_id,
			zs_task_title,
			zs_task_command,
			zs_task_target_db,
			zs_task_retries,
			zs_task_retry_delay,
			zs_task_recover_all_yn,
			zs_task_inactive_yn,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($zs_task_title)."',
			'".$lDB->escape($zs_task_command)."',
			'".$lDB->escape($zs_task_target_db)."',
			'".$lDB->escape($zs_task_retries)."',
			'".$lDB->escape($zs_task_retry_delay)."',
			'".$lDB->escape($zs_task_recover_all_yn)."',
			'".$lDB->escape($zs_task_inactive_yn)."',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($createDateTz)."',
			'".$lDB->escape($pr_user_id)."'
		)
	");	

	$taskId = $lDB->insert_id;
	
	return $taskId;	
}

function db_zs_task_update($zs_task_id,$zs_task_title,$zs_task_command,$zs_task_target_db,$zs_task_retries,$zs_task_retry_delay,$zs_task_recover_all_yn,$zs_task_inactive_yn,$zs_task_suspend_yn=false,$pr_user_id=false) {
	global $lDB;

	$modifyDate = date("Y-m-d H:i:s");
	$modifyDateTz = date("e");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	if($zs_task_suspend_yn === false) {
		$zs_task_suspend_yn = "0";
	}

	$lDB->put("
		UPDATE zs_task SET
			zs_task_title = '".$lDB->escape($zs_task_title)."',
			zs_task_command = '".$lDB->escape($zs_task_command)."',
			zs_task_target_db = '".$lDB->escape($zs_task_target_db)."',
			zs_task_retries = '".$lDB->escape($zs_task_retries)."',
			zs_task_retry_delay = '".$lDB->escape($zs_task_retry_delay)."',
			zs_task_recover_all_yn = '".$lDB->escape($zs_task_recover_all_yn)."',
			zs_task_inactive_yn = '".$lDB->escape($zs_task_inactive_yn)."',
			zs_task_suspend_yn = '".$lDB->escape($zs_task_suspend_yn)."',
			ad_modify_date = '".$lDB->escape($modifyDate)."',
			ad_modify_date_tz = '".$lDB->escape($modifyDateTz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			zs_task.zs_task_ix = '$zs_task_id'
	",7);
	return true;
}

function db_zs_task_set_suspend($zs_task_id,$zs_task_suspend_reason,$pr_user_id=false) {
	global $lDB;

	$modifyDate = date("Y-m-d H:i:s");
	$suspendDateTz = $modifyDateTz = date("e");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$lDB->put("
		UPDATE zs_task SET
			zs_task_suspend_yn = 1,
			zs_task_suspend_date = '".$lDB->escape($modifyDate)."',
			zs_task_suspend_date_tz = '".$lDB->escape($suspendDateTz)."',
			zs_task_suspend_reason = '".$lDB->escape($zs_task_suspend_reason)."',		
			ad_modify_date = '".$lDB->escape($modifyDate)."',
			ad_modify_date_tz = '".$lDB->escape($modifyDateTz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			zs_task.zs_task_ix = '$zs_task_id'
	");
	return true;
}

function db_zs_task_set_last_execution($zs_task_id,$zs_task_last_execution=false) {
	global $lDB;
	if($zs_task_last_execution === false) {
		$zs_task_last_execution = date("Y-m-d H:i:s");
	}
	$zs_task_last_execution_tz = date("e");
	$lDB->put("UPDATE zs_task SET zs_task_last_execution = '".$lDB->escape($zs_task_last_execution)."', zs_task_last_execution_tz = '".$lDB->escape($zs_task_last_execution_tz)."' WHERE zs_task_ix = '$zs_task_id'");
}


function db_zs_task_delete($zs_task_id) {
	
	db_zs_schedule_delete_by_task($zs_task_id);
	db_zs_task_notify_delete_by_task($zs_task_id);
	$GLOBALS['lDB']->put("DELETE FROM zs_task WHERE zs_task_ix = '$zs_task_id'");
}
