/* RRDEV-1415-Remove-the-procedure-ixIndexesDrop */
--
-- SQL query to drop the existing ixIndexesDrop procedure
--
DROP PROCEDURE IF EXISTS `ixIndexesDrop`;
/* RRDEV-1485-on-the-telephone-report-the */
/* removed sc table changes */
/* RRDEV-1552-financial-interface-to-sage-db-upgrade */
/* removed sc table changes */
/* RRDEV-1560-guest-api */
/* RRDEV-1560 Guest API */
DROP TABLE IF EXISTS ad_persona;
CREATE TABLE ad_persona (
	ad_persona_db char(2) NOT NULL DEFAULT 'RS',
	ad_persona_id int(11) NOT NULL,
	ad_persona_ix varchar(36) NOT NULL,
	ad_persona_time timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
	ad_persona_time_tz varchar(40) NOT NULL,
	ad_persona_form text NOT NULL,
	pr_user_id varchar(36) DEFAULT NULL,
	rf_database_id int(11) DEFAULT NULL,
	pr_persona_id varchar(36) DEFAULT NULL,
	rv_reservation_id varchar(36) DEFAULT NULL,
	dt_temp_id varchar(36) DEFAULT NULL,
	ad_persona_trf_yn tinyint(1) NOT NULL DEFAULT '0',
	PRIMARY KEY (ad_persona_ix),
	KEY pr_persona_id (pr_persona_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS ad_persona_detail;
CREATE TABLE ad_persona_detail (
	ad_persona_detail_db char(2) NOT NULL DEFAULT 'RS',
	ad_persona_detail_id int(11) NOT NULL,
	ad_persona_detail_ix varchar(36) NOT NULL,
	ad_persona_detail_value_from text NOT NULL,
	ad_persona_detail_value_to text NOT NULL,
	ad_persona_detail_value_from_display text NOT NULL,
	ad_persona_detail_value_to_display text NOT NULL,
	ad_persona_detail_id_from varchar(36) DEFAULT NULL,
	ad_persona_detail_id_to varchar(36) DEFAULT NULL,
	ad_persona_detail_field_id varchar(36) DEFAULT NULL,
	ad_persona_detail_action_ind tinyint(2) NOT NULL DEFAULT '0',
	ad_persona_id varchar(36) DEFAULT NULL,
	ad_module_field_id varchar(36) DEFAULT NULL,
	dt_temp_id varchar(36) DEFAULT NULL,
	ad_persona_detail_trf_yn tinyint(1) NOT NULL DEFAULT '0',
	PRIMARY KEY (ad_persona_detail_ix),
	KEY ad_persona_id (ad_persona_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

/* Remove and add index for ac_accomm_block.ac_accomm_type_id - HS212909*/
ALTER TABLE ac_accomm_block DROP INDEX IF EXISTS ac_accomm_type_id;
ALTER TABLE ac_accomm_block ADD INDEX(ac_accomm_type_id);

/* RRDEV-1574-wetu-integration */
/* RRDEV-1574-wetu-integration */

ALTER TABLE pr_business ADD pr_bus_wetu_id VARCHAR(50) AFTER pr_bus_statutory_label_3;
ALTER TABLE pr_business ADD pr_bus_wetu_exclude TINYINT(1) NOT NULL DEFAULT '0' AFTER pr_bus_wetu_id;

ALTER TABLE ac_accomm_type ADD ac_accomm_wetu_id VARCHAR(50) AFTER ac_accomm_name_short;
ALTER TABLE ac_accomm_type ADD ac_accomm_wetu_exclude TINYINT(1) NOT NULL DEFAULT '0' AFTER ac_accomm_wetu_id;

ALTER TABLE rv_reservation ADD rv_wetu_id VARCHAR(40) AFTER rv_wait_list_user_id;
ALTER TABLE rv_reservation ADD rv_wetu_timestamp TIMESTAMP NULL DEFAULT NULL AFTER rv_wetu_id;

ALTER TABLE ac_extra ADD ac_ext_wetu_prop_id VARCHAR(50) AFTER ac_extra_category_id;
ALTER TABLE ac_extra ADD ac_ext_wetu_accomm_id VARCHAR(50) AFTER ac_ext_wetu_prop_id;
ALTER TABLE ac_extra ADD ac_ext_wetu_exclude TINYINT(1) NOT NULL DEFAULT '0' AFTER ac_ext_wetu_accomm_id;

ALTER TABLE rf_system ADD rf_sys_wetu_username VARCHAR(50) AFTER rf_sys_locked_yn;
ALTER TABLE rf_system ADD rf_sys_wetu_password VARCHAR(50) AFTER rf_sys_wetu_username;
ALTER TABLE rf_system ADD rf_sys_wetu_api_key VARCHAR(50) AFTER rf_sys_wetu_password;

ALTER TABLE `sc_group` ADD `sc_grp_res_wetu_yn` TINYINT(1) NOT NULL DEFAULT '0' AFTER `sc_grp_res_sp_apply_man_yn`;
/* RRDEV-1602-performance-index-additions */
/* RRDEV-1602 Performance index additions */

/* Standardise table structure */
ALTER TABLE pg_type_obj_data CHANGE dt_demp_id dt_temp_id VARCHAR(36) NULL;
ALTER TABLE rf_db_business ADD dt_temp_id VARCHAR(36) NULL AFTER rf_db_code;

/* Add index for rv_reservation_id to rv_note */
ALTER TABLE rv_note DROP INDEX IF EXISTS rv_reservation_id;
ALTER TABLE rv_note ADD INDEX rv_reservation_id (rv_reservation_id);

/* Add indexes to all dt_temp_id and trf_yn tables */
ALTER TABLE ac_accomm_block DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_accomm_block DROP INDEX IF EXISTS ac_accomm_block_trf_yn;
ALTER TABLE ac_accomm_block ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_accomm_block_trf_yn (ac_accomm_block_trf_yn);

ALTER TABLE ac_accomm_image DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_accomm_image DROP INDEX IF EXISTS ac_accomm_image_trf_yn;
ALTER TABLE ac_accomm_image ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_accomm_image_trf_yn (ac_accomm_image_trf_yn);

ALTER TABLE ac_accomm_room DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_accomm_room DROP INDEX IF EXISTS ac_accomm_room_trf_yn;
ALTER TABLE ac_accomm_room ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_accomm_room_trf_yn (ac_accomm_room_trf_yn);

ALTER TABLE ac_accomm_room_attr DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_accomm_room_attr DROP INDEX IF EXISTS ac_accomm_room_attr_trf_yn;
ALTER TABLE ac_accomm_room_attr ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_accomm_room_attr_trf_yn (ac_accomm_room_attr_trf_yn);

ALTER TABLE ac_accomm_room_block DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_accomm_room_block DROP INDEX IF EXISTS ac_accomm_room_block_trf_yn;
ALTER TABLE ac_accomm_room_block ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_accomm_room_block_trf_yn (ac_accomm_room_block_trf_yn);

ALTER TABLE ac_accomm_type DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_accomm_type DROP INDEX IF EXISTS ac_accomm_type_trf_yn;
ALTER TABLE ac_accomm_type ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_accomm_type_trf_yn (ac_accomm_type_trf_yn);

ALTER TABLE ac_extra DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_extra DROP INDEX IF EXISTS ac_extra_trf_yn;
ALTER TABLE ac_extra ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_extra_trf_yn (ac_extra_trf_yn);

ALTER TABLE ac_extra_cat_inv DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_extra_cat_inv DROP INDEX IF EXISTS ac_extra_cat_inv_trf_yn;
ALTER TABLE ac_extra_cat_inv ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_extra_cat_inv_trf_yn (ac_extra_cat_inv_trf_yn);

ALTER TABLE ac_extra_category DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_extra_category DROP INDEX IF EXISTS ac_extra_category_trf_yn;
ALTER TABLE ac_extra_category ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_extra_category_trf_yn (ac_extra_category_trf_yn);

ALTER TABLE ac_extra_inv DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_extra_inv DROP INDEX IF EXISTS ac_extra_inv_trf_yn;
ALTER TABLE ac_extra_inv ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_extra_inv_trf_yn (ac_extra_inv_trf_yn);

ALTER TABLE ac_extra_prop DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_extra_prop DROP INDEX IF EXISTS ac_extra_prop_trf_yn;
ALTER TABLE ac_extra_prop ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_extra_prop_trf_yn (ac_extra_prop_trf_yn);

ALTER TABLE ac_pay_item DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_pay_item DROP INDEX IF EXISTS ac_pay_item_trf_yn;
ALTER TABLE ac_pay_item ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_pay_item_trf_yn (ac_pay_item_trf_yn);

ALTER TABLE ac_pay_plan DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_pay_plan DROP INDEX IF EXISTS ac_pay_plan_trf_yn;
ALTER TABLE ac_pay_plan ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_pay_plan_trf_yn (ac_pay_plan_trf_yn);

ALTER TABLE ac_pos DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_pos DROP INDEX IF EXISTS ac_pos_trf_yn;
ALTER TABLE ac_pos ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_pos_trf_yn (ac_pos_trf_yn);

ALTER TABLE ac_pos_map DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_pos_map DROP INDEX IF EXISTS ac_pos_map_trf_yn;
ALTER TABLE ac_pos_map ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_pos_map_trf_yn (ac_pos_map_trf_yn);

ALTER TABLE ac_pos_map_accomm DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ac_pos_map_accomm DROP INDEX IF EXISTS ac_pos_map_accomm_trf_yn;
ALTER TABLE ac_pos_map_accomm ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ac_pos_map_accomm_trf_yn (ac_pos_map_accomm_trf_yn);

ALTER TABLE ad_api DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ad_api DROP INDEX IF EXISTS ad_api_trf_yn;
ALTER TABLE ad_api ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ad_api_trf_yn (ad_api_trf_yn);

ALTER TABLE ad_archive DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ad_archive DROP INDEX IF EXISTS ad_archive_trf_yn;
ALTER TABLE ad_archive ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ad_archive_trf_yn (ad_archive_trf_yn);

ALTER TABLE ad_batch DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ad_batch DROP INDEX IF EXISTS ad_batch_trf_yn;
ALTER TABLE ad_batch ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ad_batch_trf_yn (ad_batch_trf_yn);

ALTER TABLE ad_db_status DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ad_db_status DROP INDEX IF EXISTS ad_db_status_trf_yn;
ALTER TABLE ad_db_status ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ad_db_status_trf_yn (ad_db_status_trf_yn);

ALTER TABLE ad_res_detail DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ad_res_detail DROP INDEX IF EXISTS ad_res_detail_trf_yn;
ALTER TABLE ad_res_detail ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ad_res_detail_trf_yn (ad_res_detail_trf_yn);

ALTER TABLE ad_reservation DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ad_reservation DROP INDEX IF EXISTS ad_reservation_trf_yn;
ALTER TABLE ad_reservation ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ad_reservation_trf_yn (ad_reservation_trf_yn);

ALTER TABLE ad_user_log DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ad_user_log DROP INDEX IF EXISTS ad_user_log_trf_yn;
ALTER TABLE ad_user_log ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ad_user_log_trf_yn (ad_user_log_trf_yn);

ALTER TABLE ad_useraccess DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ad_useraccess DROP INDEX IF EXISTS ad_useraccess_trf_yn;
ALTER TABLE ad_useraccess ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ad_useraccess_trf_yn (ad_useraccess_trf_yn);

ALTER TABLE ad_useraccess_detail DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE ad_useraccess_detail DROP INDEX IF EXISTS ad_useraccess_detail_trf_yn;
ALTER TABLE ad_useraccess_detail ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX ad_useraccess_detail_trf_yn (ad_useraccess_detail_trf_yn);

ALTER TABLE bl_block DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE bl_block DROP INDEX IF EXISTS bl_block_trf_yn;
ALTER TABLE bl_block ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX bl_block_trf_yn (bl_block_trf_yn);

ALTER TABLE bl_block_itinerary DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE bl_block_itinerary DROP INDEX IF EXISTS bl_block_itinerary_trf_yn;
ALTER TABLE bl_block_itinerary ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX bl_block_itinerary_trf_yn (bl_block_itinerary_trf_yn);

ALTER TABLE bl_block_period DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE bl_block_period DROP INDEX IF EXISTS bl_block_period_trf_yn;
ALTER TABLE bl_block_period ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX bl_block_period_trf_yn (bl_block_period_trf_yn);

ALTER TABLE em_mail DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE em_mail DROP INDEX IF EXISTS em_mail_trf_yn;
ALTER TABLE em_mail ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX em_mail_trf_yn (em_mail_trf_yn);

ALTER TABLE em_mail_log DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE em_mail_log DROP INDEX IF EXISTS em_mail_log_trf_yn;
ALTER TABLE em_mail_log ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX em_mail_log_trf_yn (em_mail_log_trf_yn);

ALTER TABLE fn_batch DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_batch DROP INDEX IF EXISTS fn_batch_trf_yn;
ALTER TABLE fn_batch ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_batch_trf_yn (fn_batch_trf_yn);

ALTER TABLE fn_cost_centre DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_cost_centre DROP INDEX IF EXISTS fn_cost_centre_trf_yn;
ALTER TABLE fn_cost_centre ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_cost_centre_trf_yn (fn_cost_centre_trf_yn);

ALTER TABLE fn_db_business DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_db_business DROP INDEX IF EXISTS fn_db_business_trf_yn;
ALTER TABLE fn_db_business ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_db_business_trf_yn (fn_db_business_trf_yn);

ALTER TABLE fn_debtor DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_debtor DROP INDEX IF EXISTS fn_debtor_trf_yn;
ALTER TABLE fn_debtor ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_debtor_trf_yn (fn_debtor_trf_yn);

ALTER TABLE fn_folio DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_folio DROP INDEX IF EXISTS fn_folio_trf_yn;
ALTER TABLE fn_folio ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_folio_trf_yn (fn_folio_trf_yn);

ALTER TABLE fn_invoice DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_invoice DROP INDEX IF EXISTS fn_invoice_trf_yn;
ALTER TABLE fn_invoice ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_invoice_trf_yn (fn_invoice_trf_yn);

ALTER TABLE fn_invoice_bank DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_invoice_bank DROP INDEX IF EXISTS fn_invoice_bank_trf_yn;
ALTER TABLE fn_invoice_bank ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_invoice_bank_trf_yn (fn_invoice_bank_trf_yn);

ALTER TABLE fn_invoice_item DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_invoice_item DROP INDEX IF EXISTS fn_invoice_item_trf_yn;
ALTER TABLE fn_invoice_item ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_invoice_item_trf_yn (fn_invoice_item_trf_yn);

ALTER TABLE fn_invoice_item_tax DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_invoice_item_tax DROP INDEX IF EXISTS fn_invoice_item_tax_trf_yn;
ALTER TABLE fn_invoice_item_tax ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_invoice_item_tax_trf_yn (fn_invoice_item_tax_trf_yn);

ALTER TABLE fn_invoice_note DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_invoice_note DROP INDEX IF EXISTS fn_invoice_note_trf_yn;
ALTER TABLE fn_invoice_note ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_invoice_note_trf_yn (fn_invoice_note_trf_yn);

ALTER TABLE fn_invoice_payment DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_invoice_payment DROP INDEX IF EXISTS fn_invoice_payment_trf_yn;
ALTER TABLE fn_invoice_payment ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_invoice_payment_trf_yn (fn_invoice_payment_trf_yn);

ALTER TABLE fn_invoice_special DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_invoice_special DROP INDEX IF EXISTS fn_invoice_special_trf_yn;
ALTER TABLE fn_invoice_special ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_invoice_special_trf_yn (fn_invoice_special_trf_yn);

ALTER TABLE fn_ledger DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_ledger DROP INDEX IF EXISTS fn_ledger_trf_yn;
ALTER TABLE fn_ledger ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_ledger_trf_yn (fn_ledger_trf_yn);

ALTER TABLE fn_option_data DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_option_data DROP INDEX IF EXISTS fn_option_data_trf_yn;
ALTER TABLE fn_option_data ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_option_data_trf_yn (fn_option_data_trf_yn);

ALTER TABLE fn_tran DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_tran DROP INDEX IF EXISTS fn_tran_trf_yn;
ALTER TABLE fn_tran ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_tran_trf_yn (fn_tran_trf_yn);

ALTER TABLE fn_tran_item DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_tran_item DROP INDEX IF EXISTS fn_tran_item_trf_yn;
ALTER TABLE fn_tran_item ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_tran_item_trf_yn (fn_tran_item_trf_yn);

ALTER TABLE fn_year DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE fn_year DROP INDEX IF EXISTS fn_year_trf_yn;
ALTER TABLE fn_year ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX fn_year_trf_yn (fn_year_trf_yn);

ALTER TABLE pf_field DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pf_field DROP INDEX IF EXISTS pf_field_trf_yn;
ALTER TABLE pf_field ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pf_field_trf_yn (pf_field_trf_yn);

ALTER TABLE pf_option DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pf_option DROP INDEX IF EXISTS pf_option_trf_yn;
ALTER TABLE pf_option ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pf_option_trf_yn (pf_option_trf_yn);

ALTER TABLE pg_acc_business DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pg_acc_business DROP INDEX IF EXISTS pg_acc_business_trf_yn;
ALTER TABLE pg_acc_business ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pg_acc_business_trf_yn (pg_acc_business_trf_yn);

ALTER TABLE pg_acc_currency DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pg_acc_currency DROP INDEX IF EXISTS pg_acc_currency_trf_yn;
ALTER TABLE pg_acc_currency ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pg_acc_currency_trf_yn (pg_acc_currency_trf_yn);

ALTER TABLE pg_acc_method DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pg_acc_method DROP INDEX IF EXISTS pg_acc_method_trf_yn;
ALTER TABLE pg_acc_method ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pg_acc_method_trf_yn (pg_acc_method_trf_yn);

ALTER TABLE pg_acc_obj_data DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pg_acc_obj_data DROP INDEX IF EXISTS pg_acc_obj_data_trf_yn;
ALTER TABLE pg_acc_obj_data ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pg_acc_obj_data_trf_yn (pg_acc_obj_data_trf_yn);

ALTER TABLE pg_account DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pg_account DROP INDEX IF EXISTS pg_account_trf_yn;
ALTER TABLE pg_account ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pg_account_trf_yn (pg_account_trf_yn);

ALTER TABLE pg_type_obj_data DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pg_type_obj_data DROP INDEX IF EXISTS pg_type_obj_data_trf_yn;
ALTER TABLE pg_type_obj_data ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pg_type_obj_data_trf_yn (pg_type_obj_data_trf_yn);

ALTER TABLE pr_agent DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_agent DROP INDEX IF EXISTS pr_agent_trf_yn;
ALTER TABLE pr_agent ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_agent_trf_yn (pr_agent_trf_yn);

ALTER TABLE pr_agent_rate DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_agent_rate DROP INDEX IF EXISTS pr_agent_rate_trf_yn;
ALTER TABLE pr_agent_rate ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_agent_rate_trf_yn (pr_agent_rate_trf_yn);

ALTER TABLE pr_bus_bank DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_bus_bank DROP INDEX IF EXISTS pr_bus_bank_trf_yn;
ALTER TABLE pr_bus_bank ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_bus_bank_trf_yn (pr_bus_bank_trf_yn);

ALTER TABLE pr_bus_image DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_bus_image DROP INDEX IF EXISTS pr_bus_image_trf_yn;
ALTER TABLE pr_bus_image ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_bus_image_trf_yn (pr_bus_image_trf_yn);

ALTER TABLE pr_bus_social DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_bus_social DROP INDEX IF EXISTS pr_bus_social_trf_yn;
ALTER TABLE pr_bus_social ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_bus_social_trf_yn (pr_bus_social_trf_yn);

ALTER TABLE pr_bus_tax DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_bus_tax DROP INDEX IF EXISTS pr_bus_tax_trf_yn;
ALTER TABLE pr_bus_tax ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_bus_tax_trf_yn (pr_bus_tax_trf_yn);

ALTER TABLE pr_business DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_business DROP INDEX IF EXISTS pr_business_trf_yn;
ALTER TABLE pr_business ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_business_trf_yn (pr_business_trf_yn);

ALTER TABLE pr_event DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_event DROP INDEX IF EXISTS pr_event_trf_yn;
ALTER TABLE pr_event ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_event_trf_yn (pr_event_trf_yn);

ALTER TABLE pr_event_persona DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_event_persona DROP INDEX IF EXISTS pr_event_persona_trf_yn;
ALTER TABLE pr_event_persona ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_event_persona_trf_yn (pr_event_persona_trf_yn);

ALTER TABLE pr_guest DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_guest DROP INDEX IF EXISTS pr_guest_trf_yn;
ALTER TABLE pr_guest ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_guest_trf_yn (pr_guest_trf_yn);

ALTER TABLE pr_guest_obj_data DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_guest_obj_data DROP INDEX IF EXISTS pr_guest_obj_data_trf_yn;
ALTER TABLE pr_guest_obj_data ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_guest_obj_data_trf_yn (pr_guest_obj_data_trf_yn);

ALTER TABLE pr_link DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_link DROP INDEX IF EXISTS pr_link_trf_yn;
ALTER TABLE pr_link ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_link_trf_yn (pr_link_trf_yn);

ALTER TABLE pr_persona DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_persona DROP INDEX IF EXISTS pr_persona_trf_yn;
ALTER TABLE pr_persona ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_persona_trf_yn (pr_persona_trf_yn);

ALTER TABLE pr_persona_inv DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_persona_inv DROP INDEX IF EXISTS pr_persona_inv_trf_yn;
ALTER TABLE pr_persona_inv ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_persona_inv_trf_yn (pr_persona_inv_trf_yn);

ALTER TABLE pr_phone DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_phone DROP INDEX IF EXISTS pr_phone_trf_yn;
ALTER TABLE pr_phone ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_phone_trf_yn (pr_phone_trf_yn);

ALTER TABLE pr_sales_obj_data DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_sales_obj_data DROP INDEX IF EXISTS pr_sales_obj_data_trf_yn;
ALTER TABLE pr_sales_obj_data ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_sales_obj_data_trf_yn (pr_sales_obj_data_trf_yn);

ALTER TABLE pr_supplier DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_supplier DROP INDEX IF EXISTS pr_supplier_trf_yn;
ALTER TABLE pr_supplier ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_supplier_trf_yn (pr_supplier_trf_yn);

ALTER TABLE pr_user DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE pr_user DROP INDEX IF EXISTS pr_user_trf_yn;
ALTER TABLE pr_user ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX pr_user_trf_yn (pr_user_trf_yn);

ALTER TABLE rc_action DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rc_action DROP INDEX IF EXISTS rc_action_trf_yn;
ALTER TABLE rc_action ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rc_action_trf_yn (rc_action_trf_yn);

ALTER TABLE rc_event DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rc_event DROP INDEX IF EXISTS rc_event_trf_yn;
ALTER TABLE rc_event ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rc_event_trf_yn (rc_event_trf_yn);

ALTER TABLE rc_event_tag DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rc_event_tag DROP INDEX IF EXISTS rc_event_tag_trf_yn;
ALTER TABLE rc_event_tag ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rc_event_tag_trf_yn (rc_event_tag_trf_yn);

ALTER TABLE rc_obj_sales DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rc_obj_sales DROP INDEX IF EXISTS rc_obj_sales_trf_yn;
ALTER TABLE rc_obj_sales ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rc_obj_sales_trf_yn (rc_obj_sales_trf_yn);

ALTER TABLE rc_obj_sales_data DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rc_obj_sales_data DROP INDEX IF EXISTS rc_obj_sales_data_trf_yn;
ALTER TABLE rc_obj_sales_data ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rc_obj_sales_data_trf_yn (rc_obj_sales_data_trf_yn);

ALTER TABLE rc_tag DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rc_tag DROP INDEX IF EXISTS rc_tag_trf_yn;
ALTER TABLE rc_tag ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rc_tag_trf_yn (rc_tag_trf_yn);

ALTER TABLE rf_bank DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_bank DROP INDEX IF EXISTS rf_bank_trf_yn;
ALTER TABLE rf_bank ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_bank_trf_yn (rf_bank_trf_yn);

ALTER TABLE rf_bank_env DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_bank_env DROP INDEX IF EXISTS rf_bank_env_trf_yn;
ALTER TABLE rf_bank_env ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_bank_env_trf_yn (rf_bank_env_trf_yn);

ALTER TABLE rf_bank_inv DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_bank_inv DROP INDEX IF EXISTS rf_bank_inv_trf_yn;
ALTER TABLE rf_bank_inv ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_bank_inv_trf_yn (rf_bank_inv_trf_yn);

ALTER TABLE rf_comms_preference DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_comms_preference DROP INDEX IF EXISTS rf_comms_preference_trf_yn;
ALTER TABLE rf_comms_preference ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_comms_preference_trf_yn (rf_comms_preference_trf_yn);

ALTER TABLE rf_country DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_country DROP INDEX IF EXISTS rf_country_trf_yn;
ALTER TABLE rf_country ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_country_trf_yn (rf_country_trf_yn);

ALTER TABLE rf_currency DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_currency DROP INDEX IF EXISTS rf_currency_trf_yn;
ALTER TABLE rf_currency ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_currency_trf_yn (rf_currency_trf_yn);

ALTER TABLE rf_currency_inv DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_currency_inv DROP INDEX IF EXISTS rf_currency_inv_trf_yn;
ALTER TABLE rf_currency_inv ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_currency_inv_trf_yn (rf_currency_inv_trf_yn);

ALTER TABLE rf_custom DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_custom DROP INDEX IF EXISTS rf_custom_trf_yn;
ALTER TABLE rf_custom ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_custom_trf_yn (rf_custom_trf_yn);

ALTER TABLE rf_database DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_database DROP INDEX IF EXISTS rf_database_trf_yn;
ALTER TABLE rf_database ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_database_trf_yn (rf_database_trf_yn);

ALTER TABLE rf_db_business DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_db_business DROP INDEX IF EXISTS rf_db_business_trf_yn;
ALTER TABLE rf_db_business ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_db_business_trf_yn (rf_db_business_trf_yn);

ALTER TABLE rf_default DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_default DROP INDEX IF EXISTS rf_default_trf_yn;
ALTER TABLE rf_default ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_default_trf_yn (rf_default_trf_yn);

ALTER TABLE rf_default_rate DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_default_rate DROP INDEX IF EXISTS rf_default_rate_trf_yn;
ALTER TABLE rf_default_rate ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_default_rate_trf_yn (rf_default_rate_trf_yn);

ALTER TABLE rf_exchange_rate DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_exchange_rate DROP INDEX IF EXISTS rf_exchange_rate_trf_yn;
ALTER TABLE rf_exchange_rate ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_exchange_rate_trf_yn (rf_exchange_rate_trf_yn);

ALTER TABLE rf_guest_type DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_guest_type DROP INDEX IF EXISTS rf_guest_type_trf_yn;
ALTER TABLE rf_guest_type ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_guest_type_trf_yn (rf_guest_type_trf_yn);

ALTER TABLE rf_mail DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_mail DROP INDEX IF EXISTS rf_mail_trf_yn;
ALTER TABLE rf_mail ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_mail_trf_yn (rf_mail_trf_yn);

ALTER TABLE rf_mthd_pmnt DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_mthd_pmnt DROP INDEX IF EXISTS rf_mthd_pmnt_trf_yn;
ALTER TABLE rf_mthd_pmnt ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_mthd_pmnt_trf_yn (rf_mthd_pmnt_trf_yn);

ALTER TABLE rf_name_suffix DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_name_suffix DROP INDEX IF EXISTS rf_name_suffix_trf_yn;
ALTER TABLE rf_name_suffix ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_name_suffix_trf_yn (rf_name_suffix_trf_yn);

ALTER TABLE rf_note DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_note DROP INDEX IF EXISTS rf_note_trf_yn;
ALTER TABLE rf_note ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_note_trf_yn (rf_note_trf_yn);

ALTER TABLE rf_note_cust_default DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_note_cust_default DROP INDEX IF EXISTS rf_note_cust_default_trf_yn;
ALTER TABLE rf_note_cust_default ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_note_cust_default_trf_yn (rf_note_cust_default_trf_yn);

ALTER TABLE rf_note_cust_item DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_note_cust_item DROP INDEX IF EXISTS rf_note_cust_item_trf_yn;
ALTER TABLE rf_note_cust_item ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_note_cust_item_trf_yn (rf_note_cust_item_trf_yn);

ALTER TABLE rf_note_custom DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_note_custom DROP INDEX IF EXISTS rf_note_custom_trf_yn;
ALTER TABLE rf_note_custom ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_note_custom_trf_yn (rf_note_custom_trf_yn);

ALTER TABLE rf_obj_guest DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_obj_guest DROP INDEX IF EXISTS rf_obj_guest_trf_yn;
ALTER TABLE rf_obj_guest ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_obj_guest_trf_yn (rf_obj_guest_trf_yn);

ALTER TABLE rf_obj_guest_data DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_obj_guest_data DROP INDEX IF EXISTS rf_obj_guest_data_trf_yn;
ALTER TABLE rf_obj_guest_data ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_obj_guest_data_trf_yn (rf_obj_guest_data_trf_yn);

ALTER TABLE rf_obj_trip DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_obj_trip DROP INDEX IF EXISTS rf_obj_trip_trf_yn;
ALTER TABLE rf_obj_trip ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_obj_trip_trf_yn (rf_obj_trip_trf_yn);

ALTER TABLE rf_obj_trip_data DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_obj_trip_data DROP INDEX IF EXISTS rf_obj_trip_data_trf_yn;
ALTER TABLE rf_obj_trip_data ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_obj_trip_data_trf_yn (rf_obj_trip_data_trf_yn);

ALTER TABLE rf_obj_trip_prop DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_obj_trip_prop DROP INDEX IF EXISTS rf_obj_trip_prop_trf_yn;
ALTER TABLE rf_obj_trip_prop ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_obj_trip_prop_trf_yn (rf_obj_trip_prop_trf_yn);

ALTER TABLE rf_phone_extn DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_phone_extn DROP INDEX IF EXISTS rf_phone_extn_trf_yn;
ALTER TABLE rf_phone_extn ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_phone_extn_trf_yn (rf_phone_extn_trf_yn);

ALTER TABLE rf_phone_prop_extra DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_phone_prop_extra DROP INDEX IF EXISTS rf_phone_prop_extra_trf_yn;
ALTER TABLE rf_phone_prop_extra ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_phone_prop_extra_trf_yn (rf_phone_prop_extra_trf_yn);

ALTER TABLE rf_phone_type DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_phone_type DROP INDEX IF EXISTS rf_phone_type_trf_yn;
ALTER TABLE rf_phone_type ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_phone_type_trf_yn (rf_phone_type_trf_yn);

ALTER TABLE rf_reservation_status DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_reservation_status DROP INDEX IF EXISTS rf_reservation_status_trf_yn;
ALTER TABLE rf_reservation_status ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_reservation_status_trf_yn (rf_reservation_status_trf_yn);

ALTER TABLE rf_source DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_source DROP INDEX IF EXISTS rf_source_trf_yn;
ALTER TABLE rf_source ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_source_trf_yn (rf_source_trf_yn);

ALTER TABLE rf_tax_inv DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_tax_inv DROP INDEX IF EXISTS rf_tax_inv_trf_yn;
ALTER TABLE rf_tax_inv ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_tax_inv_trf_yn (rf_tax_inv_trf_yn);

ALTER TABLE rf_tax_rate DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_tax_rate DROP INDEX IF EXISTS rf_tax_rate_trf_yn;
ALTER TABLE rf_tax_rate ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_tax_rate_trf_yn (rf_tax_rate_trf_yn);

ALTER TABLE rf_title DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rf_title DROP INDEX IF EXISTS rf_title_trf_yn;
ALTER TABLE rf_title ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rf_title_trf_yn (rf_title_trf_yn);

ALTER TABLE rt_component DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_component DROP INDEX IF EXISTS rt_component_trf_yn;
ALTER TABLE rt_component ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_component_trf_yn (rt_component_trf_yn);

ALTER TABLE rt_component_inv DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_component_inv DROP INDEX IF EXISTS rt_component_inv_trf_yn;
ALTER TABLE rt_component_inv ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_component_inv_trf_yn (rt_component_inv_trf_yn);

ALTER TABLE rt_period DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_period DROP INDEX IF EXISTS rt_period_trf_yn;
ALTER TABLE rt_period ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_period_trf_yn (rt_period_trf_yn);

ALTER TABLE rt_period_dates DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_period_dates DROP INDEX IF EXISTS rt_period_dates_trf_yn;
ALTER TABLE rt_period_dates ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_period_dates_trf_yn (rt_period_dates_trf_yn);

ALTER TABLE rt_rate DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_rate DROP INDEX IF EXISTS rt_rate_trf_yn;
ALTER TABLE rt_rate ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_rate_trf_yn (rt_rate_trf_yn);

ALTER TABLE rt_rate_comp_grp DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_rate_comp_grp DROP INDEX IF EXISTS rt_rate_comp_grp_trf_yn;
ALTER TABLE rt_rate_comp_grp ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_rate_comp_grp_trf_yn (rt_rate_comp_grp_trf_yn);

ALTER TABLE rt_rate_component DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_rate_component DROP INDEX IF EXISTS rt_rate_component_trf_yn;
ALTER TABLE rt_rate_component ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_rate_component_trf_yn (rt_rate_component_trf_yn);

ALTER TABLE rt_rate_group DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_rate_group DROP INDEX IF EXISTS rt_rate_group_trf_yn;
ALTER TABLE rt_rate_group ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_rate_group_trf_yn (rt_rate_group_trf_yn);

ALTER TABLE rt_rate_grp_amt DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_rate_grp_amt DROP INDEX IF EXISTS rt_rate_grp_amt_trf_yn;
ALTER TABLE rt_rate_grp_amt ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_rate_grp_amt_trf_yn (rt_rate_grp_amt_trf_yn);

ALTER TABLE rt_rate_type DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_rate_type DROP INDEX IF EXISTS rt_rate_type_trf_yn;
ALTER TABLE rt_rate_type ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_rate_type_trf_yn (rt_rate_type_trf_yn);

ALTER TABLE rt_tax_group DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_tax_group DROP INDEX IF EXISTS rt_tax_group_trf_yn;
ALTER TABLE rt_tax_group ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_tax_group_trf_yn (rt_tax_group_trf_yn);

ALTER TABLE rt_tax_group_item DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rt_tax_group_item DROP INDEX IF EXISTS rt_tax_group_item_trf_yn;
ALTER TABLE rt_tax_group_item ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rt_tax_group_item_trf_yn (rt_tax_group_item_trf_yn);

ALTER TABLE rv_extra DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_extra DROP INDEX IF EXISTS rv_extra_trf_yn;
ALTER TABLE rv_extra ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_extra_trf_yn (rv_extra_trf_yn);

ALTER TABLE rv_extra_prop DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_extra_prop DROP INDEX IF EXISTS rv_extra_prop_trf_yn;
ALTER TABLE rv_extra_prop ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_extra_prop_trf_yn (rv_extra_prop_trf_yn);

ALTER TABLE rv_extra_tax DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_extra_tax DROP INDEX IF EXISTS rv_extra_tax_trf_yn;
ALTER TABLE rv_extra_tax ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_extra_tax_trf_yn (rv_extra_tax_trf_yn);

ALTER TABLE rv_note DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_note DROP INDEX IF EXISTS rv_note_trf_yn;
ALTER TABLE rv_note ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_note_trf_yn (rv_note_trf_yn);

ALTER TABLE rv_pay_plan_item DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_pay_plan_item DROP INDEX IF EXISTS rv_pay_plan_item_trf_yn;
ALTER TABLE rv_pay_plan_item ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_pay_plan_item_trf_yn (rv_pay_plan_item_trf_yn);

ALTER TABLE rv_payment DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_payment DROP INDEX IF EXISTS rv_payment_trf_yn;
ALTER TABLE rv_payment ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_payment_trf_yn (rv_payment_trf_yn);

ALTER TABLE rv_payment_gateway DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_payment_gateway DROP INDEX IF EXISTS rv_payment_gateway_trf_yn;
ALTER TABLE rv_payment_gateway ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_payment_gateway_trf_yn (rv_payment_gateway_trf_yn);

ALTER TABLE rv_payment_gateway_folio DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_payment_gateway_folio DROP INDEX IF EXISTS rv_payment_gateway_folio_trf_yn;
ALTER TABLE rv_payment_gateway_folio ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_payment_gateway_folio_trf_yn (rv_payment_gateway_folio_trf_yn);

ALTER TABLE rv_payment_item DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_payment_item DROP INDEX IF EXISTS rv_payment_item_trf_yn;
ALTER TABLE rv_payment_item ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_payment_item_trf_yn (rv_payment_item_trf_yn);

ALTER TABLE rv_phone DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_phone DROP INDEX IF EXISTS rv_phone_trf_yn;
ALTER TABLE rv_phone ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_phone_trf_yn (rv_phone_trf_yn);

ALTER TABLE rv_res_item_comp DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_res_item_comp DROP INDEX IF EXISTS rv_res_item_comp_trf_yn;
ALTER TABLE rv_res_item_comp ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_res_item_comp_trf_yn (rv_res_item_comp_trf_yn);

ALTER TABLE rv_res_item_comp_rate_grp DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_res_item_comp_rate_grp DROP INDEX IF EXISTS rv_res_item_comp_rate_grp_trf_yn;
ALTER TABLE rv_res_item_comp_rate_grp ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_res_item_comp_rate_grp_trf_yn (rv_res_item_comp_rate_grp_trf_yn);

ALTER TABLE rv_res_item_comp_tax DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_res_item_comp_tax DROP INDEX IF EXISTS rv_res_item_comp_tax_trf_yn;
ALTER TABLE rv_res_item_comp_tax ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_res_item_comp_tax_trf_yn (rv_res_item_comp_tax_trf_yn);

ALTER TABLE rv_res_item_group DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_res_item_group DROP INDEX IF EXISTS rv_res_item_group_trf_yn;
ALTER TABLE rv_res_item_group ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_res_item_group_trf_yn (rv_res_item_group_trf_yn);

ALTER TABLE rv_res_item_grp_status DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_res_item_grp_status DROP INDEX IF EXISTS rv_res_item_grp_status_trf_yn;
ALTER TABLE rv_res_item_grp_status ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_res_item_grp_status_trf_yn (rv_res_item_grp_status_trf_yn);

ALTER TABLE rv_res_item_guest DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_res_item_guest DROP INDEX IF EXISTS rv_res_item_guest_trf_yn;
ALTER TABLE rv_res_item_guest ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_res_item_guest_trf_yn (rv_res_item_guest_trf_yn);

ALTER TABLE rv_res_item_rate_grp DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_res_item_rate_grp DROP INDEX IF EXISTS rv_res_item_rate_grp_trf_yn;
ALTER TABLE rv_res_item_rate_grp ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_res_item_rate_grp_trf_yn (rv_res_item_rate_grp_trf_yn);

ALTER TABLE rv_reservation DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_reservation DROP INDEX IF EXISTS rv_reservation_trf_yn;
ALTER TABLE rv_reservation ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_reservation_trf_yn (rv_reservation_trf_yn);

ALTER TABLE rv_reservation_guest DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_reservation_guest DROP INDEX IF EXISTS rv_reservation_guest_trf_yn;
ALTER TABLE rv_reservation_guest ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_reservation_guest_trf_yn (rv_reservation_guest_trf_yn);

ALTER TABLE rv_reservation_item DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_reservation_item DROP INDEX IF EXISTS rv_reservation_item_trf_yn;
ALTER TABLE rv_reservation_item ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_reservation_item_trf_yn (rv_reservation_item_trf_yn);

ALTER TABLE rv_special DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_special DROP INDEX IF EXISTS rv_special_trf_yn;
ALTER TABLE rv_special ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_special_trf_yn (rv_special_trf_yn);

ALTER TABLE rv_trip_obj_data DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE rv_trip_obj_data DROP INDEX IF EXISTS rv_trip_obj_data_trf_yn;
ALTER TABLE rv_trip_obj_data ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX rv_trip_obj_data_trf_yn (rv_trip_obj_data_trf_yn);

ALTER TABLE sc_accomm DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sc_accomm DROP INDEX IF EXISTS sc_accomm_trf_yn;
ALTER TABLE sc_accomm ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sc_accomm_trf_yn (sc_accomm_trf_yn);

ALTER TABLE sc_fun_group DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sc_fun_group DROP INDEX IF EXISTS sc_fun_group_trf_yn;
ALTER TABLE sc_fun_group ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sc_fun_group_trf_yn (sc_fun_group_trf_yn);

ALTER TABLE sc_group DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sc_group DROP INDEX IF EXISTS sc_group_trf_yn;
ALTER TABLE sc_group ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sc_group_trf_yn (sc_group_trf_yn);

ALTER TABLE sc_user DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sc_user DROP INDEX IF EXISTS sc_user_trf_yn;
ALTER TABLE sc_user ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sc_user_trf_yn (sc_user_trf_yn);

ALTER TABLE sp_accomm_type DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sp_accomm_type DROP INDEX IF EXISTS sp_accomm_type_trf_yn;
ALTER TABLE sp_accomm_type ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sp_accomm_type_trf_yn (sp_accomm_type_trf_yn);

ALTER TABLE sp_prop_rate_group DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sp_prop_rate_group DROP INDEX IF EXISTS sp_prop_rate_group_trf_yn;
ALTER TABLE sp_prop_rate_group ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sp_prop_rate_group_trf_yn (sp_prop_rate_group_trf_yn);

ALTER TABLE sp_rate_group_benefit DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sp_rate_group_benefit DROP INDEX IF EXISTS sp_rate_group_benefit_trf_yn;
ALTER TABLE sp_rate_group_benefit ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sp_rate_group_benefit_trf_yn (sp_rate_group_benefit_trf_yn);

ALTER TABLE sp_rate_group_qualify DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sp_rate_group_qualify DROP INDEX IF EXISTS sp_rate_group_qualify_trf_yn;
ALTER TABLE sp_rate_group_qualify ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sp_rate_group_qualify_trf_yn (sp_rate_group_qualify_trf_yn);

ALTER TABLE sp_special DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sp_special DROP INDEX IF EXISTS sp_special_trf_yn;
ALTER TABLE sp_special ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sp_special_trf_yn (sp_special_trf_yn);

ALTER TABLE sp_special_period DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sp_special_period DROP INDEX IF EXISTS sp_special_period_trf_yn;
ALTER TABLE sp_special_period ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sp_special_period_trf_yn (sp_special_period_trf_yn);

ALTER TABLE sp_special_rate_type DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE sp_special_rate_type DROP INDEX IF EXISTS sp_special_rate_type_trf_yn;
ALTER TABLE sp_special_rate_type ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX sp_special_rate_type_trf_yn (sp_special_rate_type_trf_yn);

ALTER TABLE tc_sequence DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE tc_sequence DROP INDEX IF EXISTS tc_sequence_trf_yn;
ALTER TABLE tc_sequence ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX tc_sequence_trf_yn (tc_sequence_trf_yn);

ALTER TABLE tc_transfer DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE tc_transfer DROP INDEX IF EXISTS tc_transfer_trf_yn;
ALTER TABLE tc_transfer ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX tc_transfer_trf_yn (tc_transfer_trf_yn);

ALTER TABLE tc_transfer_table DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE tc_transfer_table DROP INDEX IF EXISTS tc_transfer_table_trf_yn;
ALTER TABLE tc_transfer_table ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX tc_transfer_table_trf_yn (tc_transfer_table_trf_yn);

ALTER TABLE tr_rule DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE tr_rule DROP INDEX IF EXISTS tr_rule_trf_yn;
ALTER TABLE tr_rule ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX tr_rule_trf_yn (tr_rule_trf_yn);

ALTER TABLE tr_rule_item DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE tr_rule_item DROP INDEX IF EXISTS tr_rule_item_trf_yn;
ALTER TABLE tr_rule_item ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX tr_rule_item_trf_yn (tr_rule_item_trf_yn);

ALTER TABLE zg_account DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zg_account DROP INDEX IF EXISTS zg_account_trf_yn;
ALTER TABLE zg_account ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zg_account_trf_yn (zg_account_trf_yn);

ALTER TABLE zg_account_prop DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zg_account_prop DROP INDEX IF EXISTS zg_account_prop_trf_yn;
ALTER TABLE zg_account_prop ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zg_account_prop_trf_yn (zg_account_prop_trf_yn);

ALTER TABLE zg_transfer DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zg_transfer DROP INDEX IF EXISTS zg_transfer_trf_yn;
ALTER TABLE zg_transfer ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zg_transfer_trf_yn (zg_transfer_trf_yn);

ALTER TABLE zg_transfer_guest DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zg_transfer_guest DROP INDEX IF EXISTS zg_transfer_guest_trf_yn;
ALTER TABLE zg_transfer_guest ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zg_transfer_guest_trf_yn (zg_transfer_guest_trf_yn);

ALTER TABLE zg_transfer_guest_prop DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zg_transfer_guest_prop DROP INDEX IF EXISTS zg_transfer_guest_prop_trf_yn;
ALTER TABLE zg_transfer_guest_prop ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zg_transfer_guest_prop_trf_yn (zg_transfer_guest_prop_trf_yn);

ALTER TABLE zm_account DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zm_account DROP INDEX IF EXISTS zm_account_trf_yn;
ALTER TABLE zm_account ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zm_account_trf_yn (zm_account_trf_yn);

ALTER TABLE zm_account_credentials DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zm_account_credentials DROP INDEX IF EXISTS zm_account_cred_trf_yn;
ALTER TABLE zm_account_credentials ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zm_account_cred_trf_yn (zm_account_cred_trf_yn);

ALTER TABLE zm_account_type DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zm_account_type DROP INDEX IF EXISTS zm_account_type_trf_yn;
ALTER TABLE zm_account_type ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zm_account_type_trf_yn (zm_account_type_trf_yn);

ALTER TABLE zm_credential_field DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zm_credential_field DROP INDEX IF EXISTS zm_credential_field_trf_yn;
ALTER TABLE zm_credential_field ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zm_credential_field_trf_yn (zm_credential_field_trf_yn);

ALTER TABLE zs_queue DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zs_queue DROP INDEX IF EXISTS zs_queue_trf_yn;
ALTER TABLE zs_queue ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zs_queue_trf_yn (zs_queue_trf_yn);

ALTER TABLE zs_schedule DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zs_schedule DROP INDEX IF EXISTS zs_schedule_trf_yn;
ALTER TABLE zs_schedule ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zs_schedule_trf_yn (zs_schedule_trf_yn);

ALTER TABLE zs_task DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zs_task DROP INDEX IF EXISTS zs_task_trf_yn;
ALTER TABLE zs_task ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zs_task_trf_yn (zs_task_trf_yn);

ALTER TABLE zs_task_log DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zs_task_log DROP INDEX IF EXISTS zs_task_log_trf_yn;
ALTER TABLE zs_task_log ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zs_task_log_trf_yn (zs_task_log_trf_yn);

ALTER TABLE zs_task_notify DROP INDEX IF EXISTS dt_temp_id;
ALTER TABLE zs_task_notify DROP INDEX IF EXISTS zs_task_notify_trf_yn;
ALTER TABLE zs_task_notify ADD INDEX dt_temp_id (dt_temp_id), ADD INDEX zs_task_notify_trf_yn (zs_task_notify_trf_yn);

/* RRDEV-1560-guest-api-SC */
/* removed sc table changes */
/* RRDEV-1574-wetu-integration-sc */
/* removed sc table changes */
/* RRDEV-1602-performance-index-additions-SC */
/* removed sc table changes */
/* RRDEV-1667-set-survey-batch-guests-as-user-facing */
/* removed sc table changes */
/* RRDEV-1681-open-and-close-out-rooms */
/* RRDEV-1681 Availability management calendar */
ALTER TABLE ac_accomm_block ADD IF NOT EXISTS ac_type_ind TINYINT(1) NOT NULL DEFAULT '1' AFTER ac_reason;
/* RRDEV-1681-open-and-close-out-rooms */
/* removed sc table changes */
/* RRDEV-1683-agents-edit-in-rr-and-in-the- */
ALTER TABLE sc_group
ADD COLUMN sc_grp_res_edit_details_yn tinyint(1) NOT NULL DEFAULT 0 AFTER sc_grp_inactive_yn,
ADD COLUMN sc_grp_res_edit_itineraries_yn tinyint(1) NOT NULL DEFAULT 0 AFTER sc_grp_res_edit_details_yn;

UPDATE sc_group
INNER JOIN sc_fun_group ON
sc_group.sc_group_id = sc_fun_group.sc_group_id AND sc_fun_group.sc_function_id = 52
SET sc_grp_res_edit_details_yn = 1, sc_grp_res_edit_itineraries_yn = 1
WHERE sc_fun_group.sc_fun_grp_level > 5;

ALTER TABLE rv_reservation
ADD COLUMN rv_mod_request_yn tinyint(1) NOT NULL DEFAULT 0 AFTER rv_deleted_yn,
ADD COLUMN rv_mod_request_date datetime AFTER rv_mod_request_yn,
ADD COLUMN rv_mod_request_ack_date datetime AFTER rv_mod_request_date,
ADD COLUMN rv_mod_request_ack_id varchar(36) AFTER rv_mod_request_ack_date,
ADD COLUMN  rv_mod_yn tinyint(1) NOT NULL DEFAULT 0 AFTER rv_mod_request_ack_id,
ADD COLUMN rv_mod_date datetime AFTER rv_mod_yn,
ADD COLUMN rv_mod_ack_date datetime AFTER rv_mod_date,
ADD COLUMN rv_mod_ack_id varchar(36) AFTER rv_mod_ack_date;
/* RRDEV-1687-xero-financial-interface-2145 */
INSERT INTO fn_option_data(
    fn_option_data_db,
    fn_option_data_id,
    fn_option_data_ix,
    pr_business_id,
    fn_option_id,
    fn_option_data_contents,
    dt_temp_id,
    fn_option_data_trf_yn
)
VALUES(
    'WA',
    '',
    '2c325a47-f30b-11e8-b4f8-02eeb68e8486',
    NULL,
    'RS12',
    'Lodge,',
    NULL,
    '0'
);

INSERT INTO fn_option_data(
    fn_option_data_db,
    fn_option_data_id,
    fn_option_data_ix,
    pr_business_id,
    fn_option_id,
    fn_option_data_contents,
    dt_temp_id,
    fn_option_data_trf_yn
)
VALUES(
    'WA',
    '',
    '5c6d10fc-02c8-11e9-8eb2-f2801f1b9fd1',
    NULL,
    'RS13',
    '2,1',
    NULL,
    '0'
);
/* RRDEV-1683-agents-edit-in-rr-and-in-the- */
/* removed sc table changes */
/* RRDEV-1687-xero-financial-interface-2145 */
/* removed sc table changes */
/* RRDEV-1719-option-to-export-pastel-trans */
/* removed sc table changes */
/* RRDEV-1649-reminders-on-reservation-and-contact-database-changes */
DROP TABLE IF EXISTS re_reminder;
DROP TABLE IF EXISTS re_reminder_log;
DROP TABLE IF EXISTS re_reminder_status;
DROP TABLE IF EXISTS re_reminder_persona;

CREATE TABLE `re_reminder` (
   `re_reminder_db` varchar(2) NOT NULL DEFAULT 'WB',
   `re_reminder_id` int(11) NOT NULL,
   `re_reminder_ix` varchar(36) NOT NULL,
   `re_reminder_note` text,
   `re_reminder_status_id` tinyint(4) NOT NULL DEFAULT '10',
   `re_reminder_send_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
   `re_reminder_send_date_tz` varchar(40) DEFAULT NULL,
   `re_reminder_repeat_yn` tinyint(1) NOT NULL DEFAULT '0',
   `re_reminder_link_to_ind_id` tinyint(1) NOT NULL DEFAULT '0',
   `re_reminder_link_to_id` varchar(36) DEFAULT NULL,
   `ad_create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
   `ad_create_date_tz` varchar(40) DEFAULT NULL,
   `ad_create_user_id` varchar(36) DEFAULT NULL,
   `ad_modify_date` timestamp NULL DEFAULT '0000-00-00 00:00:00',
   `ad_modify_date_tz` varchar(40) DEFAULT NULL,
   `ad_modify_user_id` varchar(36) DEFAULT NULL,
   `dt_temp_id` varchar(36) DEFAULT NULL,
   `re_reminder_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `re_reminder_persona` (
   `re_reminder_persona_db` varchar(2) NOT NULL DEFAULT 'WB',
   `re_reminder_persona_id` int(11) NOT NULL,
   `re_reminder_persona_ix` varchar(36) NOT NULL,
   `re_reminder_sent_to_email` varchar(255) NOT NULL,
   `pr_persona_id` varchar(36) NOT NULL,
   `re_reminder_id` varchar(36) NOT NULL,
   `dt_temp_id` varchar(36) DEFAULT NULL,
   `re_reminder_persona_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `re_reminder_log` (
  `re_reminder_log_db` varchar(2) NOT NULL DEFAULT 'WB',
  `re_reminder_log_id` int(11) NOT NULL,
  `re_reminder_log_ix` varchar(36) NOT NULL,
  `re_reminder_id` varchar(36) NOT NULL,
  `re_reminder_log_status` tinyint(2) DEFAULT 0,
  `re_reminder_log_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `re_reminder_log_date_tz` varchar(40) DEFAULT NULL,
  `ad_create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ad_create_date_tz` varchar(40) DEFAULT NULL,
  `ad_create_user_id` varchar(36) DEFAULT NULL,
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `re_reminder_log_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `re_reminder_status` (
  `re_reminder_status_id` int(11) NOT NULL,
  `re_reminder_status_desc` text NOT NULL,
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `re_reminder_status_trf_yn` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


ALTER TABLE `re_reminder` ADD PRIMARY KEY (`re_reminder_ix`);

ALTER TABLE `re_reminder_status` ADD PRIMARY KEY (`re_reminder_status_id`);

ALTER TABLE `re_reminder_log` ADD PRIMARY KEY (`re_reminder_log_ix`);

ALTER TABLE `re_reminder_persona` ADD PRIMARY KEY (`re_reminder_persona_ix`);

INSERT INTO `re_reminder_status` (`re_reminder_status_id`, `re_reminder_status_desc`,`dt_temp_id`, `re_reminder_status_trf_yn`) VALUES
( 10, 'Active',  NULL, 0),
( 20, 'Suspended', NULL, 0),
( 30, 'Failed', NULL, 0),
( 40, 'Sent', NULL, 0);
/* RRDEV-1649-reminders-on-reservation-and-contact-database-changes */
/* removed sc table changes */
/* SC Tables */
-- MySQL dump 10.15  Distrib 10.0.38-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: zzz_upgrade_7_19_0
-- ------------------------------------------------------
-- Server version	10.0.38-MariaDB-0ubuntu0.16.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `sc_function`
--

DROP TABLE IF EXISTS `sc_function`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sc_function` (
  `sc_function_id` int(11) NOT NULL AUTO_INCREMENT,
  `sc_fun_code` char(10) DEFAULT NULL,
  `sc_fun_desc` char(50) DEFAULT NULL,
  `sc_fun_sys_code` tinyint(1) NOT NULL DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `sc_function_trf_yn` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sc_function_id`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `sc_function_trf_yn` (`sc_function_trf_yn`)
) ENGINE=InnoDB AUTO_INCREMENT=6002 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sc_function`
--

LOCK TABLES `sc_function` WRITE;
/*!40000 ALTER TABLE `sc_function` DISABLE KEYS */;
INSERT INTO `sc_function` VALUES (50,'01','Availability calendar',0,NULL,1),(51,'02','Occupancy calendar',0,NULL,1),(52,'03','Reservation: Tabs',0,NULL,1),(53,'04','Reports: Std, Prov, Contact, Mail, Pay received',0,NULL,1),(54,'05','Contacts',0,NULL,1),(55,'06','Report: Updated',0,NULL,1),(57,'11','Code Tables: General',0,NULL,1),(58,'12','Code Tables: Financial',5,NULL,1),(59,NULL,'Report: Extras',0,NULL,0),(60,'21','Report: Login Statistics',0,NULL,1),(61,'22','Business structure',5,NULL,1),(62,'31','Customisation',5,NULL,1),(63,'32','System settings',5,NULL,1),(64,'33','Data transfer',0,NULL,1),(65,'34','Access control',3,NULL,1),(66,NULL,'General access',9,NULL,1),(67,'08','Reports: Arrivals/Departures, Rooming',0,NULL,1),(68,NULL,'Rates',5,NULL,1),(69,NULL,'Payments: Record',0,NULL,1),(70,NULL,'Reservation: Web requests received',0,NULL,1),(71,NULL,'Report: Consultant',0,NULL,0),(74,NULL,'Report: Payments Due',0,NULL,0),(75,NULL,'DB Status Change',3,NULL,0),(76,NULL,'Reports Financials: Rev, Comp, Folio/Inv',0,NULL,0),(77,NULL,'Reports Financials: Commission',0,NULL,0),(78,NULL,'Reports: Business structure',0,NULL,0),(79,NULL,'Extras Quick Entry',0,NULL,0),(80,'12','Code Tables: Extras',0,NULL,1),(81,'0','Rooming Calendar',0,NULL,1),(82,NULL,'Contact User Role',3,NULL,1),(83,NULL,'Contact Agent Role',3,NULL,1),(84,NULL,'Contact Guest Role',0,NULL,1),(85,NULL,'Code Tables: Standard Notes',0,NULL,1),(86,NULL,'Code Tables: POS',0,NULL,1),(87,NULL,'Environment Setup',0,NULL,1),(88,NULL,'Reports Financials: Bed Night',0,NULL,1),(89,NULL,'Code Tables: Custom notes',0,NULL,1),(90,NULL,'Report: Telephone charges',0,NULL,0),(91,NULL,'Reports Financials: Sales Journal',0,NULL,0),(92,NULL,'Code Tables: Telephone',0,NULL,1),(93,NULL,'Report: Extras Audit',0,NULL,0),(94,NULL,'Report: Payments by group',0,NULL,0),(95,NULL,'Reports: PAX Analysis, PAX Count (today)',0,NULL,0),(96,NULL,'Report: Availability',0,NULL,0),(97,NULL,'Report: Occupancy',0,NULL,0),(98,NULL,'Report: Allocation Summary',0,NULL,0),(99,NULL,'Report: Allocations List',0,NULL,0),(100,NULL,'Financial: GL Account detail - Invoicing Unit List',0,NULL,0),(101,NULL,'Financial: GL Batch',0,NULL,0),(102,NULL,'Report: Payment Item',0,NULL,0),(103,NULL,'Report: Accommodation Chart',0,NULL,0),(104,NULL,'Report: Overbooking',0,NULL,0),(105,NULL,'Reports Financials: Sales Analysis',0,NULL,1),(106,NULL,'Reports Financials: Age Analysis',0,NULL,1),(107,NULL,'Reports Financials: Cash Flow Forecast',0,NULL,1),(108,NULL,'Reservation: Invoicing',0,NULL,1),(109,NULL,'Report: Operations Chart',0,NULL,0),(110,NULL,'Guest Tripsheet',0,NULL,0),(111,NULL,'Report: Guest History',0,NULL,0),(112,NULL,'Code Tables: Guest Profile',0,NULL,0),(113,NULL,'Code Tables: Guest Tripsheet',0,NULL,0),(114,NULL,'Code Tables: Guest Survey',0,NULL,0),(115,NULL,'Guest Survey',0,NULL,0),(116,NULL,'API Audit',0,NULL,0),(117,NULL,'My Preferences: Default Page',0,NULL,1),(118,NULL,'My Preferences: Email Templates',0,NULL,1),(119,NULL,'Code Tables: CRM events',0,NULL,0),(120,NULL,'Code Tables: CRM sales profile',0,NULL,0),(121,NULL,'Contacts: CRM',0,NULL,0),(122,NULL,'Reports: CRM',0,NULL,0),(123,NULL,'Reservation: Tabs (Notes)',0,NULL,1),(124,NULL,'Reservation: Tabs (Rooming)',0,NULL,1),(125,NULL,'Reservation: Tabs (Financial)',0,NULL,1),(126,NULL,'Code Tables: Payment Gateway',0,NULL,1),(127,NULL,'Reports Financials: Tax Analysis',0,NULL,1),(128,NULL,'Reports Financials: Debtors Analysis',0,NULL,1),(1000,NULL,'Report: Room Discrepancy',0,NULL,1),(1001,NULL,'Reports Financials: Financial Analysis',0,NULL,1),(1002,NULL,'Payments: Deposit',0,NULL,1),(1004,NULL,'Business structure: Open and close out rooms',0,NULL,0),(2000,NULL,'Reports Financials: Customer Statement',0,NULL,1),(2001,NULL,'Specials',5,NULL,1),(6000,NULL,'Report: Audit Trail',0,NULL,0),(6001,NULL,'Block Templates',0,NULL,0);
/*!40000 ALTER TABLE `sc_function` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sc_job`
--

DROP TABLE IF EXISTS `sc_job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sc_job` (
  `sc_job_id` int(11) NOT NULL DEFAULT '0',
  `sc_job_desc` text,
  `sc_job_level` tinyint(4) NOT NULL DEFAULT '99',
  `sc_job_cords` text NOT NULL,
  `sc_job_homepage_yn` tinyint(4) NOT NULL DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `sc_job_trf_yn` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sc_job_id`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `sc_job_trf_yn` (`sc_job_trf_yn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sc_job`
--

LOCK TABLES `sc_job` WRITE;
/*!40000 ALTER TABLE `sc_job` DISABLE KEYS */;
INSERT INTO `sc_job` VALUES (0,'Display reservation form',4,'\"1:0:1\",\"1:49:1\"',0,NULL,1),(1,'Add reservation form',99,'\"2,0:0:1\",\"1:49:1\"',0,NULL,1),(2,'Edit reservation form',6,'\"3,0:0:1\",\"1:49:1\"',0,NULL,1),(3,'Add db reservation and go to add item form',5,'\"2,1:0:0\",\"3,0:0:1\",\"1:49:1\"',0,NULL,1),(4,'Update db reservation and return to edit',6,'\"3,1:0:0\",\"3:0:1\",\"1:49:1\"',0,NULL,1),(13,'Display rooming form',4,'\"1:4:1\"',0,NULL,1),(14,'Edit rooming form',6,'\"3:4:1\"',0,NULL,1),(15,'Update db rooming and return to display',6,'\"3,1:4:0\",\"3:4:1\"',0,NULL,1),(16,'Display status change form',6,'\"3,0:3:1\"',0,NULL,1),(17,'Update reservation status',6,'\"3,1:3:0\"',0,NULL,1),(19,'Find Reservation',4,'\"2:6:1\",\"1:5:1\"',1,NULL,1),(20,'Availability Calendar',4,'\"1:7:1\"',1,NULL,1),(29,'Occupancy Calendar',3,'\"1:11:1\"',1,NULL,1),(30,'Delete Reservation',9,'\"6:0:1\",\"2,0:0:1\",\"1:49:1\"',0,NULL,1),(31,'Booked Calendar Item List Display',4,'\"1:12:1\"',0,NULL,1),(32,'Property Details Popup View',4,'\"1:13:1\"',0,NULL,1),(33,'Tree View',4,'\"1:14:1\"',0,NULL,1),(37,'Property Details Popup Save (Edit)',6,'\"3,1:13:1\",\"3,0:13:1\"',0,NULL,1),(38,'Property Details Popup Edit',6,'\"3:13:1\"',0,NULL,1),(39,'Property Details Popup Delete',7,'\"4,1:13:1\"',0,NULL,1),(40,'Property Details Popup Save (Add)',6,'\"2,1:13:1\",\"3,0:13:1\"',0,NULL,1),(41,'Property Details Popup Add',5,'\"2:13:1\"',0,NULL,1),(42,'Find Contacts Page',4,'\"2:17:1\",\"1:16:1\"',0,NULL,1),(43,'Add New Contact Page (pr_persona)',5,'\"2,0:18:1\"',0,NULL,1),(44,'Add Contact to DB > Edit (pr_persona)',6,'\"2,1:18:0\",\"1:150:0\",\"3,0:18:1\"',0,NULL,1),(45,'Edit Contact Page (pr_persona)',6,'\"3,0:18:1\"',0,NULL,1),(46,'Update Contact on DB > Edit (pr_persona)',6,'\"3,1:18:0\",\"3,0:18:1\"',0,NULL,1),(47,'Display Contact Page (pr_persona)',4,'\"1:18:1\"',0,NULL,1),(48,'Display User Details Page (pr_user)',4,'\"1:19:1\"',0,NULL,1),(49,'Display Add User Page (pr_user)',5,'\"2,0:19:1\"',0,NULL,1),(50,'Add User to DB (pr_user)',6,'\"2,1:19:0\",\"3,0:19:1\"',0,NULL,1),(51,'Display Edit User Page (pr_user)',6,'\"3,0:19:1\"',0,NULL,1),(52,'Update User on DB (pr_user)',6,'\"3,1:19:0\",\"3,0:19:1\"',0,NULL,1),(53,'Delete User from DB (pr_user)',7,'\"4,1:19:0\",\"2,0:19:1\"',0,NULL,1),(54,'Delete Contact from DB (pr_persona)',7,'\"4,1:18:0\",\"2,0:18:1\"',0,NULL,1),(55,'Display Change User Password Form',5,'\"2,0:20:1\"',0,NULL,1),(56,'Display Change User Password Confirmation',6,'\"3,0:20:1\"',0,NULL,1),(57,'Display Agent Details Page (pr_agent)',4,'\"1:21:1\"',0,NULL,1),(58,'Display Add Agent Page (pr_agent)',5,'\"2,0:21:1\"',0,NULL,1),(59,'Add Agent to DB (pr_agent)',6,'\"2,1:21:0\",\"3,0:21:1\"',0,NULL,1),(60,'Display Edit Agent Page (pr_agent)',6,'\"3,0:21:1\"',0,NULL,1),(61,'Update Agent on DB (pr_agent)',6,'\"3,1:21:0\",\"3,0:21:1\"',0,NULL,1),(62,'Delete Agent from DB (pr_agent)',7,'\"4,1:21:0\",\"2,0:21:1\"',0,NULL,1),(63,'Display Listing of all contacts where the linked address is null',4,'\"1:22:1\"',0,NULL,1),(64,'Update the Linked Address Field.',4,'\"1:23:0\"',0,NULL,1),(65,'Reset a user\"s password',4,'\"1:24:1\"',0,NULL,1),(66,'Telephone Listing',3,'\"0:26:1\"',0,NULL,1),(67,'Display Telephone',4,'\"1:25:1\",\"1:26:1\"',0,NULL,1),(68,'Add Telephone Form',6,'\"2,0:25:1\",\"3:26:1\"',0,NULL,1),(69,'Save New Telephone to DB',6,'\"2,1:25:0\",\"2,0:25:1\",\"3:26:1\"',0,NULL,1),(70,'Edit Telephone Form',6,'\"3,0:25:1\",\"3:26:1\"',0,NULL,1),(71,'Update Telephone in DB',6,'\"3,1:25:0\",\"2,0:25:1\",\"3:26:1\"',0,NULL,1),(72,'Delete Telephone',7,'\"4,1:25:0\",\"2,0:25:1\",\"1:26:1\"',0,NULL,1),(75,'Display Country',4,'\"1:30:1\",\"1:31:1\"',0,NULL,1),(76,'Add Country Form',6,'\"2,0:30:1\",\"3:31:1\"',0,NULL,1),(77,'Save New Country to DB',6,'\"2,1:30:0\",\"2,0:30:1\",\"3:31:1\"',0,NULL,1),(78,'Edit Country Form',6,'\"3,0:30:1\",\"3:31:1\"',0,NULL,1),(79,'Update Country in DB',6,'\"3,1:30:0\",\"2,0:30:1\",\"3:31:1\"',0,NULL,1),(80,'Delete Country',7,'\"4,1:30:0\",\"2:30:1\",\"1:31:1\"',0,NULL,1),(81,'Display Currency',4,'\"1:32:1\",\"1:33:1\"',0,NULL,1),(82,'Add Currency Form',6,'\"2,0:32:1\",\"3:33:1\"',0,NULL,1),(83,'Save New Currency to DB',6,'\"2,1:32:0\",\"2,0:32:1\",\"3:33:1\"',0,NULL,1),(84,'Edit Currency Form',6,'\"3,0:32:1\",\"3:33:1\"',0,NULL,1),(85,'Update Currency in DB',6,'\"3,1:32:0\",\"2,0:32:1\",\"3:33:1\"',0,NULL,1),(86,'Delete Currency',7,'\"4,1:32:0\",\"2:32:1\",\"1:33:1\"',0,NULL,1),(87,'Display Phone Type',4,'\"1:34:1\",\"1:35:1\"',0,NULL,1),(88,'Add Phone Type Form',6,'\"2,0:34:1\",\"3:35:1\"',0,NULL,1),(89,'Save New Phone Type to DB',6,'\"2,1:34:0\",\"2,0:34:1\",\"3:35:1\"',0,NULL,1),(90,'Edit Phone Type Form',6,'\"3,0:34:1\",\"3:35:1\"',0,NULL,1),(91,'Update Phone Type in DB',6,'\"3,1:34:0\",\"2,0:34:1\",\"3:35:1\"',0,NULL,1),(92,'Delete Phone Type',7,'\"4,1:34:0\",\"2:34:1\",\"1:35:1\"',0,NULL,1),(105,'Display Defaults',4,'\"1:40:1\"',0,NULL,1),(106,'Add Defaults Form',5,'\"2,0:40:1\"',0,NULL,1),(107,'Save New Defaults to DB',6,'\"2,1:40:1\",\"3,0:40:1\"',0,NULL,1),(108,'Edit Defaults Form',6,'\"3,0:40:1\"',0,NULL,1),(109,'Update Defaults in DB',6,'\"3,1:40:0\",\"3,0:40:1\"',0,NULL,1),(110,'Delete Defaults',127,'\"4,1:40:0\",\"1:40:1\"',0,NULL,1),(111,'Display System Table',4,'\"1:41:1\"',0,NULL,1),(112,'Add System Table Form',5,'\"2,0:41:1\"',0,NULL,1),(113,'Save New System Table to DB',6,'\"2,1:41:1\",\"3,0:41:1\"',0,NULL,1),(114,'Edit System Table Form',6,'\"3,0:41:1\"',0,NULL,1),(115,'Update System Table in DB',6,'\"3,1:41:1\",\"3,0:41:1\"',0,NULL,1),(116,'Delete System Table',127,'\"4,1:41:0\",\"1:41:1\"',0,NULL,1),(123,'Audit Report',4,'\"1:46:1\"',0,NULL,1),(126,'Review Transfer Data',4,'\"1:50:1\"',0,NULL,1),(127,'Transfer Data Import',4,'\"1:51:1\"',0,NULL,1),(128,'Transfer Data User Interface',4,'\"1:52:1\"',0,NULL,1),(129,'Public Calendar',4,'\"1:7:1\"',0,NULL,1),(131,'Principal Reservation Wizard popup window (select contact)',4,'\"1:55:1\"',0,NULL,1),(132,'Home page',4,'\"1:56:1\"',0,NULL,1),(134,'Contact Relations Selection List',4,'\"1:59:1\"',0,NULL,1),(135,'Property Link Users Form',4,'\"1:58:1\"',0,NULL,1),(136,'Property Remove Linked User Popup',4,'\"1:60:1\"',0,NULL,1),(137,'Reservation Notes Add Note',6,'\"3,0:61:1\"',0,NULL,1),(138,'Reservation Notes Display Note',4,'\"1:61:1\"',0,NULL,1),(139,'Reservation Notes Save and Edit Note',6,'\"3,1:61:1\",\"3,0:61:1\"',0,NULL,1),(140,'Agent filter on Occupancy Calendar',4,'\"1:62:1\"',0,NULL,1),(144,'Display Access Groups (sc_groups)',4,'\"1:66:1\",\"1:67:0\"',0,NULL,1),(145,'Add Access Groups (sc_groups)',6,'\"2,0:66:1\",\"3:67:0\"',0,NULL,1),(146,'Save Access Groups (sc_groups) to DB',6,'\"2,1:66:0\",\"2,0:66:1\",\"3:67:0\"',0,NULL,1),(147,'Edit Access Groups (sc_groups)',6,'\"3,0:66:1\",\"3:67:0\"',0,NULL,1),(148,'Update Access Groups (sc_groups) in DB',6,'\"3,1:66:0\",\"2,0:66:1\",\"3:67:0\"',0,NULL,1),(149,'Delete Access Groups (sc_groups)',7,'\"4,1:66:0\",\"2,0:66:1\",\"1:67:0\"',0,NULL,1),(150,'Display Functions List (sc_functions)',4,'\"1:68:1\",\"1:69:0\"',0,NULL,1),(151,'Display Functions List (sc_functions)',4,'\"1:68:1\",\"1:69:0\",',0,NULL,1),(160,'Display Functions List (sc_functions)',4,'\"1:70:1\"',0,NULL,1),(161,'Display Functions Update (sc_functions)',4,'\"1:70:1\"',0,NULL,1),(162,'Display Property/Accommodation List (sc_functions)',4,'\"1:71:1\"',0,NULL,1),(163,'Display Property/Accommodation Update (sc_functions)',4,'\"1:71:1\"',0,NULL,1),(164,'Display User List (sc_functions)',4,'\"1:72:1\"',0,NULL,1),(165,'Display User Update (sc_functions)',4,'\"1:72:1\"',0,NULL,1),(166,'Add New Property',6,'\"2,0:73:1\"',0,NULL,1),(167,'Add Property to DB > Edit (pr_persona)',6,'\"2,1:73:0\",\"1:76:0\",\"1:150:0\",\"3,0:73:1\"',0,NULL,1),(168,'Edit Property Page (pr_persona)',6,'\"3,0:73:1\"',0,NULL,1),(169,'Update Property on DB > Edit (pr_persona)',6,'\"3,1:73:0\",\"3,0:73:1\"',0,NULL,1),(170,'Display Property Page (pr_persona)',4,'\"1:73:1\"',0,NULL,1),(171,'Delete Property from DB (pr_persona)',7,'\"4,1:73:0\",\"2,0:73:1\"',0,NULL,1),(172,'Display Property/Accomm Tree ',4,'\"1:74:1\"',0,NULL,1),(173,'Home Page Administration',4,'\"1:75:1\"',0,NULL,1),(174,'Display Accomm Type (property tree)',4,'\"1:77:1\"',0,NULL,1),(175,'Edit Accomm Type (property tree)',6,'\"3,0:77:1\"',0,NULL,1),(176,'Update Accomm Type on DB > Edit (prop tree)',6,'\"3,1:77:0\",\"3,0:77:1\"',0,NULL,1),(177,'Display Arrivals & Departures',4,'\"3:79:1\"',0,NULL,1),(178,'Display Mail Report',4,'\"1:80:1\"',0,NULL,1),(179,'Display Contact Report',4,'\"1:81:1\"',0,NULL,1),(180,'Display Reservation Summary Tab',4,'\"1:82:1\"',0,NULL,1),(181,'Display Property Notes',4,'\"1:78:1\"',0,NULL,1),(182,'Edit Property Notes',6,'\"3,0:78:1\"',0,NULL,1),(183,'Update Property Notes on DB > Edit (prop tree)',6,'\"3,1:78:0\",\"3,0:78:1\"',0,NULL,1),(184,'Reservation Email',4,'\"1:83:1\"',0,NULL,1),(185,'Generic Email',4,'\"1:84:1\"',0,NULL,1),(186,'Display Components (for res item)',4,'\"1:86:1\",\"1:87:1\"',0,NULL,1),(187,'Edit Components (for res item)',6,'\"3,0:86:1\",\"1:87:1\"',0,NULL,1),(188,'Save Components (for res item)',6,'\"3,1:86:1\",\"3,0:86:1\",\"1:87:1\"',0,NULL,1),(189,'Send email (used for general send, resend, forward etc.)',4,'\"1:90:1\"',0,NULL,1),(190,'Display email log',4,'\"1:91:1\"',0,NULL,1),(191,'Display reservations comms tab',4,'\"1:84:1\"',0,NULL,1),(192,'Add Standard Notes Form',6,'\"2,0:93:1\",\"3:94:1\"',0,NULL,1),(193,'Edit Standard Notes Form',6,'\"3,0:93:1\",\"3:94:1\"',0,NULL,1),(194,'Display Standard Note',4,'\"1:93:1\",\"1:94:1\"',0,NULL,1),(195,'Save New Standard Note to DB',6,'\"2,1:93:0\",\"2,0:93:1\",\"3:94:1\"',0,NULL,1),(196,'Update Standard Note in DB',6,'\"3,1:93:0\",\"2,0:93:1\",\"3:94:1\"',0,NULL,1),(197,'Delete Standard Note',7,'\"4,1:93:0\",\"2:93:1\",\"1:94:1\"',0,NULL,1),(198,'Guest nationionality popup',4,'\"1:237:1\"',0,NULL,1),(199,'Standard notes popup',4,'\"1:238:1\"',0,NULL,1),(200,'Reservation Extras Report',4,'\"1:241:1\"',0,NULL,1),(201,'General Report Module',4,'\"1:253:1\"',0,NULL,1),(202,'Arrival Departures Report',4,'\"1:253:1\"',0,NULL,1),(203,'Report: Consultant',4,'\"1:253:1\"',0,NULL,1),(204,'Provisional Report',4,'\"1:253:1\"',0,NULL,1),(205,'Updated Report',4,'\"1:253:1\"',0,NULL,1),(207,'Commission report',4,'\"1:274:1\"',0,NULL,0),(208,'Commission report popup',4,'\"1:275:1\"',0,NULL,0),(209,'Display Guest Details Page (pr_guest)',4,'\"1:279:1\"',0,NULL,0),(210,'Display Add Guest Page (pr_guest)',5,'\"2,0:279:1\"',0,NULL,0),(211,'Add Guest to DB (pr_guest)',6,'\"2,1:279:0\",\"1:150:0\",\"3,0:279:1\"',0,NULL,0),(212,'Display Edit Guest Page (pr_guest)',6,'\"3,0:279:1\"',0,NULL,0),(213,'Update Guest on DB (pr_guest)',6,'\"3,1:279:0\",\"3,0:279:1\"',0,NULL,0),(214,'Delete Guest from DB (pr_guest)',7,'\"4,1:279:0\",\"2,0:279:1\"',0,NULL,0),(215,'Display rooming tab',4,'\"1:280:1\"',0,NULL,0),(216,'Edit rooming tab',6,'\"3,0:280:1\"',0,NULL,0),(217,'Update rooming tab',6,'\"3,1:280:0\",\"3,0:280:1\"',0,NULL,0),(218,'Display contact import popup',4,'\"1:281:1\"',0,NULL,0),(219,'Add New Guest Contact Popup (pr_persona)',5,'\"2,0:282:1\"',0,NULL,0),(220,'Add Guest contact to DB > Edit (pr_persona)',6,'\"2,1:282:0\",\"1:283:0\",\"3,0:282:1\"',0,NULL,0),(221,'Edit Guest Contact Popup (pr_persona)',6,'\"3,0:282:1\"',0,NULL,0),(222,'Update Guest Contact on DB > Edit (pr_persona)',6,'\"3,1:282:0\",\"3,0:282:1\"',0,NULL,0),(223,'Display Guest Contact Popup (pr_persona)',4,'\"1:282:1\"',0,NULL,0),(224,'Room select popup',4,'\"1:284:1\"',0,NULL,0),(225,'Travel log popup',4,'\"1:285:1\"',0,NULL,0),(226,'Room allocations calendar',4,'\"1:286:1\"',0,NULL,0),(227,'Property / Accommodation popup',4,'\"1:287:1\"',0,NULL,0),(228,'Current Reservations by room popup',4,'\"1:288:1\"',0,NULL,0),(229,'Room / Guest extras popup',4,'\"1:293:1\"',0,NULL,0),(230,'Extras filter popup',4,'\"1:295:1\"',0,NULL,0),(231,'Manage folios',4,'\"1:296:1\"',0,NULL,0),(232,'New folio',4,'\"1:297:1\"',0,NULL,0),(233,'Folio / Invoice Report',4,'\"1:298:1\"',0,NULL,1),(234,'Rooming Calendar',4,'\"1:301:1\"',1,NULL,0),(235,'Rooming calendar - checkout',4,'\"1:307:1\"',0,NULL,0),(236,'Display POS',4,'\"1:308:1\",\"1:309:1\"',0,NULL,0),(237,'Add POS Form',6,'\"2,0:308:1\",\"3:309:1\"',0,NULL,0),(238,'Save New POS to DB',6,'\"2,1:308:0\",\"2,0:308:1\",\"3:309:1\"',0,NULL,0),(239,'Edit POS Form',6,'\"3,0:308:1\",\"3:309:1\"',0,NULL,0),(240,'Update POS in DB',6,'\"3,1:308:0\",\"2,0:308:1\",\"3:309:1\"',0,NULL,0),(241,'Delete POS',7,'\"4,1:308:0\",\"2:308:1\",\"1:309:1\"',0,NULL,0),(242,'Rooming Calendar Guest Popup',4,'\"1:310:1\"',0,NULL,0),(243,'Rooming calendar extras',4,'\"1:311:1\"',0,NULL,0),(244,'Rooming Calendar - Payment Folios',4,'\"1:312:1\"',0,NULL,0),(245,'Rooming Calendar - Payments',5,'\"1:313:1\"',0,NULL,0),(246,'Bed Night Report',4,'\"1:317:1\"',1,NULL,0),(247,'Bednights Report Popup',4,'\"1:319:1\"',0,NULL,0),(248,'Quick Reservation Find',4,'\"1:321:1\"',0,NULL,0),(249,'Sales journal (Reservation Group)',4,'\"1:323:1\"',0,NULL,0),(250,'Sales journal (Reservation)',4,'\"1:323:1\"',0,NULL,0),(251,'Sales journal (Folio)',4,'\"1:323:1\"',0,NULL,0),(252,'Display Telephone Code Table',4,'\"1:330:1\"',0,NULL,0),(253,'Edit Telephone Code Table',6,'\"3:330:1\"',0,NULL,0),(254,'Update Telephone Code Table To DB',6,'\"3,1:330:1\",\"3:330:1\"',0,NULL,0),(255,'Delete Telephone Code Table From DB',7,'\"4,1:330:1\",\"3:330:1\"',0,NULL,0),(256,'Select Extra (List)',2,'\"1:332:1\"',0,NULL,1),(257,'Telephone Report',4,'\"1:333:1\"',0,NULL,0),(258,'Telephone Report Popup',4,'\"1:334:1\"',0,NULL,0),(259,'Reservation Calendar - Room Popup',4,'\"1:336:1\"',0,NULL,1),(260,'Extras Audit Report',4,'\"1:337:1\"',0,NULL,0),(261,'Payments by group report',4,'\"1:338:1\"',0,NULL,0),(262,'Availability Report',4,'\"1:339:1\"',1,NULL,0),(263,'Clear system cache',4,'\"1:340:1\"',0,NULL,0),(264,'Occupancy Report',4,'\"1:339:1\"',0,NULL,0),(265,'Allocation Summary Report',4,'\"1:341:1\"',0,NULL,0),(266,'Allocations List',4,'\"1:342:1\"',0,NULL,0),(267,'Display Agent Allocations',4,'\"1:343:1\"',0,NULL,0),(268,'Add Agent Allocation Page',5,'\"2,0:343:1\"',0,NULL,0),(269,'Add Agent Allocation to DB',6,'\"2,1:343:0\",\"1:343:1\"',0,NULL,0),(270,'Edit Agent Allocation',6,'\"3,0:343:1\"',0,NULL,0),(271,'Update Agent Allocation on DB',6,'\"3,1:343:1\",\"1:343:1\"',0,NULL,0),(272,'Delete Agent Allocation',7,'\"4,1:343:1\",\"1:343:1\"',0,NULL,0),(273,'Agent Allocation Reservation List',4,'\"1:344:1\"',0,NULL,0),(274,'Details Tab Item List Display',4,'\"1:12:1\"',0,NULL,1),(275,'Allocations Popup Item List Display',4,'\"1:12:1\"',0,NULL,1),(276,'Account Detail',4,'\"1:345:1\"',1,NULL,0),(277,'GL Account Detail popup - General Tab',6,'\"1:346:1\"',0,NULL,0),(278,'GL Account Detail popup - GL Codes Tab',6,'\"1:347:1\"',0,NULL,0),(279,'GL Account Detail popup - Cost Centres Tab',7,'\"1:348:1\"',0,NULL,0),(280,'GL Account Detail popup - Properties Tab',6,'\"1:349:1\"',0,NULL,0),(281,'GL Account Detail popup - Accommodation Tab',6,'\"1:350:1\"',0,NULL,0),(282,'GL Account Detail popup - Bank/Cash Points Tab',6,'\"1:351:1\"',0,NULL,0),(283,'GL Account Detail popup - Extra Categories Tab',6,'\"1:352:1\"',0,NULL,0),(284,'GL Account Detail popup - Extras Tab',6,'\"1:353:1\"',0,NULL,0),(285,'GL Account Detail popup - Rate Components Tab',6,'\"1:354:1\"',0,NULL,0),(286,'GL Account Detail popup - Tax Rates Tab',6,'\"1:355:1\"',0,NULL,0),(287,'GL Account Detail popup - Debtor Codes Tab',6,'\"1:356:1\"',0,NULL,0),(288,'GL Account Detail popup - Contacts/Debtors Tab',6,'\"1:357:1\"',0,NULL,0),(289,'GL Batch Invoice Unit',4,'\"1:345:1\"',0,NULL,0),(290,'GL Batch popup',6,'\"1:358:1\"',0,NULL,0),(291,'Payment Item Report',4,'\"1:359:1\"',0,NULL,0),(292,'Room Report',4,'\"1:360:1\"',0,NULL,0),(293,'Property accommodation filter popup',4,'\"1:361:1\"',0,NULL,0),(294,'Overbooking report',4,'\"1:362:1\"',0,NULL,0),(295,'Transaction maintenance',4,'\"1:363:1\"',0,NULL,0),(296,'Transaction maintenance popup (View)',4,'\"1:364:1\"',0,NULL,0),(297,'Rate dropdown',4,'\"1:365:1\"',0,NULL,0),(298,'Display payment',4,'\"1:366:1\"',0,NULL,0),(299,'Record Payments',5,'\"2,0:366:1\"',1,NULL,0),(300,'Payment add save',5,'\"2,1:366:0\",\"1:366:1\"',0,NULL,0),(301,'Payment void',7,'\"4,1:366:0\",\"1:366:1\"',0,NULL,0),(302,'GL Account Detail popup - Year Tab',6,'\"1:367:1\"',0,NULL,0),(303,'Batch audit trail',6,'\"1:368:1\"',0,NULL,0),(304,'Sales Analysis Report',4,'\"1:369:1\"',1,NULL,0),(305,'Sales analysis report popup',4,'\"1:370:1\"',0,NULL,0),(306,'Extras Report (Custom)',4,'\"1:371:1\"',1,NULL,0),(307,'Transaction list popup',4,'\"1:372:1\"',0,NULL,0),(308,'Rate report',4,'\"1:373:1\"',0,NULL,0),(309,'Age Analysis Report',4,'\"1:374:1\"',0,NULL,0),(310,'Cash Flow Forecast Report',4,'\"1:374:1\"',0,NULL,0),(311,'Favourite profile popup',4,'\"1:375:1\"',0,NULL,0),(312,'Operations Chart',4,'\"1:376:1\"',1,NULL,0),(313,'Display guest profile object.',4,'\"1:377:1\",\"1:378:1\"',0,NULL,0),(314,'Add guest profile object form',6,'\"2,0:377:1\",\"3:378:1\"',0,NULL,0),(315,'Save new guest profile object to DB',6,'\"2,1:377:0\",\"2,0:377:1\",\"3:378:1\"',0,NULL,0),(316,'Edit guest profile object form',6,'\"3,0:377:1\",\"3:378:1\"',0,NULL,0),(317,'Update guest profile object in DB',6,'\"3,1:377:0\",\"2,0:377:1\",\"1:378:1\"',0,NULL,0),(318,'Delete guest profile object',7,'\"4,1:377:0\",\"2:377:1\",\"1:378:1\"',0,NULL,0),(319,'Select object type',4,'\"1:379:1\"',0,NULL,0),(320,'Set Object Order',4,'\"1:380:1\"',0,NULL,0),(321,'Save object order',6,'\"3,1:380:1\"',0,NULL,0),(322,'Display guest tripsheet object.',4,'\"1:381:1\",\"1:382:1\"',0,NULL,0),(323,'Add guest tripsheet object form',6,'\"2,0:381:1\",\"3:382:1\"',0,NULL,0),(324,'Save new guest tripsheet object to DB',6,'\"2,1:381:0\",\"2,0:381:1\",\"3:382:1\"',0,NULL,0),(325,'Edit guest tripsheet object form',6,'\"3,0:381:1\",\"3:382:1\"',0,NULL,0),(326,'Update guest tripsheet object in DB',6,'\"3,1:381:0\",\"2,0:381:1\",\"3:382:1\"',0,NULL,0),(327,'Delete guest tripsheet object',7,'\"4,1:381:0\",\"2:381:1\",\"1:382:1\"',0,NULL,0),(328,'Set guest tripsheet object order',4,'\"1:383:1\"',0,NULL,0),(329,'Save guest tripsheet object order',6,'\"3,1:383:1\"',0,NULL,0),(330,'Display guest tripsheet',4,'\"1:384:1\"',0,NULL,0),(331,'Add guest tripsheet form',6,'\"2,0:384:1\"',0,NULL,0),(332,'Save new guest tripsheet to DB',6,'\"2,1:384:0\",\"3,0:384:1\"',0,NULL,0),(333,'Edit guest tripsheet  form',6,'\"3,0:384:1\"',0,NULL,0),(334,'Update guest tripsheet in DB',6,'\"3,1:384:0\",\"3,0:384:1\"',0,NULL,0),(335,'Delete guest tripsheet',7,'\"4,1:384:0\",\"2,0:384:1\"',0,NULL,0),(336,'Guest report',4,'\"1:385:1\"',0,NULL,0),(337,'Display guest survey account',4,'\"1,0:386:1\",\"1,0:387:1\"',0,NULL,0),(338,'Add guest survey account',4,'\"2,0:386:1\",\"3:387:1\"',0,NULL,0),(339,'Edit guest survey account',6,'\"3,0:386:1\",\"3:387:1\"',0,NULL,0),(340,'Update guest survey account',6,'\"3,1:386:0\",\"2,0:386:1\",\"3:387:1\"',0,NULL,0),(341,'Save new guest survey account',6,'\"2,1:386:0\",\"3,0:386:1\",\"3:387:1\"',0,NULL,0),(342,'Delete guest survey account',7,'\"4,1:386:0\",\"2:386:1\",\"1:387:1\"',0,NULL,0),(343,'Edit guest survey account property',6,'\"3:388:1\"',0,NULL,0),(344,'Update guest survey account property',6,'\"3,1:388:1\"',0,NULL,0),(345,'Guest survey report',4,'\"1:389:1\"',0,NULL,0),(346,'Run guest survey batch',4,'\"1:390:1\"',0,NULL,0),(347,'Review guest survey batch',4,'\"1:391:1\"',0,NULL,0),(348,'View guest survey batch detail',4,'\"1:392:1\"',0,NULL,0),(349,'General email popup',4,'\"1:393:1\"',0,NULL,0),(350,'Duplicate contact check / popup',4,'\"1:394:1\"',0,NULL,0),(351,'Itenary Summary',4,'\"1:395:1\"',0,NULL,0),(352,'API Audit Report',4,'\"1:396:1\"',0,NULL,0),(353,'Calendar Wizard Step 3',4,'\"3:397:1\"',0,NULL,0),(354,'Calendar Wizard Step 3 Add New Guest',4,'\"1:403:1\"',0,NULL,0),(355,'Display CRM event actions',4,'\"1:406:1\",\"1:407:1\"',0,NULL,0),(356,'Add CRM event action form',6,'\"2,0:406:1\",\"3:407:1\"',0,NULL,0),(357,'Save new CRM event action to DB',6,'\"2,1:406:0\",\"2,0:406:1\",\"3:407:1\"',0,NULL,0),(358,'Edit CRM event action form',6,'\"3,0:406:1\",\"3:407:1\"',0,NULL,0),(359,'Update CRM event action in DB',6,'\"3,1:406:0\",\"2,0:406:1\",\"1:407:1\"',0,NULL,0),(360,'Delete CRM event action',7,'\"4,1:406:0\",\"2:406:1\",\"1:407:1\"',0,NULL,0),(361,'Display CRM event tags',4,'\"1:408:1\",\"1:409:1\"',0,NULL,0),(362,'Add CRM event tag form',6,'\"2,0:408:1\",\"3:409:1\"',0,NULL,0),(363,'Save new CRM event tag to DB',6,'\"2,1:408:0\",\"2,0:408:1\",\"3:409:1\"',0,NULL,0),(364,'Edit CRM event tag form',6,'\"3,0:408:1\",\"3:409:1\"',0,NULL,0),(365,'Update CRM event tag in DB',6,'\"3,1:408:0\",\"2,0:408:1\",\"1:409:1\"',0,NULL,0),(366,'Delete CRM event tag',7,'\"4,1:408:0\",\"2:408:1\",\"1:409:1\"',0,NULL,0),(367,'Display CRM events',4,'\"1:410:1\",\"1:411:1\"',0,NULL,0),(368,'Add CRM event form',6,'\"2,0:410:1\",\"3:411:1\"',0,NULL,0),(369,'Save new CRM event to DB',6,'\"2,1:410:0\",\"2,0:410:1\",\"3:411:1\"',0,NULL,0),(370,'Edit CRM event form',6,'\"3,0:410:1\",\"3:411:1\"',0,NULL,0),(371,'Update CRM event in DB',6,'\"3,1:410:0\",\"2,0:410:1\",\"1:411:1\"',0,NULL,0),(372,'Delete CRM event',7,'\"4,1:410:0\",\"2:410:1\",\"1:411:1\"',0,NULL,0),(373,'Display sales profile object',4,'\"1:412:1\",\"1:413:1\"',0,NULL,0),(374,'Add sales profile object form',6,'\"2,0:412:1\",\"3:413:1\"',0,NULL,0),(375,'Save new sales profile object to DB',6,'\"2,1:412:0\",\"2,0:412:1\",\"3:413:1\"',0,NULL,0),(376,'Edit sales profile object form',6,'\"3,0:412:1\",\"3:413:1\"',0,NULL,0),(377,'Update sales profile object in DB',6,'\"3,1:412:0\",\"2,0:412:1\",\"1:413:1\"',0,NULL,0),(378,'Delete sales profile object',7,'\"4,1:412:0\",\"2:412:1\",\"1:413:1\"',0,NULL,0),(379,'Select object type',4,'\"1:414:1\"',0,NULL,0),(380,'Set Object Order',4,'\"1:415:1\"',0,NULL,0),(381,'Save object order',6,'\"2,1:415:0\",\"2,0:415:1\"',0,NULL,0),(382,'Display sales profile',4,'\"1:416:1\"',0,NULL,0),(383,'Add sales profile form',6,'\"2,0:416:1\"',0,NULL,0),(384,'Save new sales profile to DB',6,'\"2,1:416:0\",\"3,0:416:1\"',0,NULL,0),(385,'Edit sales profile form',6,'\"3,0:416:1\"',0,NULL,0),(386,'Update sales profile in DB',6,'\"3,1:416:0\",\"3,0:416:1\"',0,NULL,0),(387,'Delete sales profile',7,'\"4,1:416:0\",\"2,0:416:1\"',0,NULL,0),(388,'Display CRM contact events',4,'\"3,0:418:1\"',0,NULL,0),(389,'Add CRM contact event form',6,'\"2,0:417:1\"',0,NULL,0),(390,'Save new CRM contact event to DB',6,'\"2,1:417:0\",\"3,0:417:1\"',0,NULL,0),(391,'Edit CRM contact event form',6,'\"3,0:417:1\"',0,NULL,0),(392,'Update CRM contact event in DB',6,'\"3,1:417:0\",\"3,0:417:1\"',0,NULL,0),(393,'Delete CRM contact event',7,'\"4,1:417:0\",\"2,0:417:1\"',0,NULL,0),(394,'CRM custom report',4,'\"1:419:1\"',0,NULL,0),(395,'Display Rate Group',4,'\"1:404:1\",\"1:405:1\"',0,NULL,1),(396,'Add Rate Group Form',5,'\"2,0:404:1\",\"1:405:1\"',0,NULL,1),(397,'Save Rate Group to DB',5,'\"2,1:404:1\",\"2,0:404:1\",\"1:405:1\"',0,NULL,1),(398,'Edit Rate Group Form',6,'\"3,0:404:1\",\"3:405:1\"',0,NULL,1),(399,'Update Rate Group in DB',6,'\"3,1:404:1\",\"2,0:404:1\",\"1:405:1\"',0,NULL,1),(400,'Delete Rate Group',7,'\"4,1:404:1\",\"2,0:404:1\",\"1:405:1\"',0,NULL,1),(401,'Display Rates Setup',7,'\"1:428:1\"',0,NULL,1),(403,'Event pop up',4,'\"1:420:1\"',0,NULL,0),(404,'Edit Rate Header',4,'\"1:421:1\"',0,NULL,1),(405,'Edit Rate Components',4,'\"1:422:1\"',0,NULL,1),(406,'Edit Rate Component Split',4,'\"1:423:1\"',0,NULL,1),(407,'Edit Rate Amounts',4,'\"1:424:1\"',0,NULL,1),(408,'Email contact pop up',4,'\"1:425:1\"',0,NULL,0),(409,'Display Rates Add',7,'\"1:429:1\"',0,NULL,1),(410,'Display Tax Group Form',4,'\"1:430:1\",\"1:431:1\"',0,NULL,1),(411,'Add Tax Group Form',5,'\"2,0:430:1\",\"1:431:1\"',0,NULL,1),(412,'Save Tax Group to DB',5,'\"2,1:430:1\",\"2,0:430:1\",\"1:431:1\"',0,NULL,1),(413,'Edit Tax Group Form',6,'\"3,0:430:1\",\"3:431:1\"',0,NULL,1),(414,'Update Tax Group in DB',6,'\"3,1:430:1\",\"2,0:430:1\",\"1:431:1\"',0,NULL,1),(415,'Delete Tax Group',7,'\"4,1:430:1\",\"2,0:430:1\",\"1:431:1\"',0,NULL,1),(416,'Display Tax Group Items Form',4,'\"1:432:1\",\"1:433:1\"',0,NULL,1),(417,'Add Tax Group Items Form',5,'\"2,0:432:1\",\"1:433:1\"',0,NULL,1),(418,'Save Tax Group Items to DB',5,'\"2,1:432:1\",\"2,0:432:1\",\"1:433:1\"',0,NULL,1),(419,'Edit Tax Group Items Form',6,'\"3,0:432:1\",\"3:433:1\"',0,NULL,1),(420,'Update Tax Group Items in DB',6,'\"3,1:432:1\",\"2,0:432:1\",\"1:433:1\"',0,NULL,1),(421,'Delete Tax Group Items',7,'\"4,1:432:1\",\"2,0:432:1\",\"1:433:1\"',0,NULL,1),(422,'Add Rate Header',7,'\"2:421:1\"',0,NULL,1),(423,'Rate Selection Popup',7,'\"1:434:1\"',0,NULL,1),(424,'Copy Rate',7,'\"2:435:1\"',0,NULL,1),(500,'Standard Report Page',4,'\"1:151:1\"',0,NULL,1),(501,'Display Comm Preference',4,'\"1:152:1\",\"1:153:1\"',0,NULL,1),(502,'Add Comm Preference Form',6,'\"2,0:152:1\",\"3:153:1\"',0,NULL,1),(503,'Save New Comm Preference to DB',6,'\"2,1:152:0\",\"2,0:152:1\",\"3:153:1\"',0,NULL,1),(504,'Edit Comm Preference Form',6,'\"3,0:152:1\",\"3:153:1\"',0,NULL,1),(505,'Update Comm Preference in DB',6,'\"3,1:152:0\",\"2,0:152:1\",\"3:153:1\"',0,NULL,1),(506,'Delete Comm Preference',7,'\"4,1:152:0\",\"2:152:1\",\"1:153:1\"',0,NULL,1),(507,'Display Suffix',4,'\"1:154:1\",\"1:155:1\"',0,NULL,1),(508,'Add Suffix Form',6,'\"2,0:154:1\",\"3:155:1\"',0,NULL,1),(509,'Save New Suffix to DB',6,'\"2,1:154:0\",\"2,0:154:1\",\"3:155:1\"',0,NULL,1),(510,'Edit Suffix Form',6,'\"3,0:154:1\",\"3:155:1\"',0,NULL,1),(511,'Update Suffix in DB',6,'\"3,1:154:0\",\"2,0:154:1\",\"3:155:1\"',0,NULL,1),(512,'Delete Suffix',7,'\"4,1:154:0\",\"2:154:1\",\"1:155:1\"',0,NULL,1),(513,'Display Title',4,'\"1:156:1\",\"1:157:1\"',0,NULL,1),(514,'Add Title Form',6,'\"2,0:156:1\",\"3:157:1\"',0,NULL,1),(515,'Save New Title to DB',6,'\"2,1:156:0\",\"2,0:156:1\",\"3:157:1\"',0,NULL,1),(516,'Edit Title Form',6,'\"3,0:156:1\",\"3:157:1\"',0,NULL,1),(517,'Update Title in DB',6,'\"3,1:156:0\",\"2,0:156:1\",\"3:157:1\"',0,NULL,1),(518,'Delete Title',7,'\"4,1:156:0\",\"2:156:1\",\"1:157:1\"',0,NULL,1),(525,'Overbooking Details For Res Item Details',4,'\"1:160:1\"',0,NULL,1),(526,'Delete a Contact',7,'\"4,0:18:1\",\"2,0:18:1\"',0,NULL,1),(527,'Change Password Screen',4,'\"1:161:1\"',0,NULL,1),(528,'Log Off Screen',4,'\"1:162:1\"',0,NULL,1),(529,'Email Form',4,'\"1:163:1\"',0,NULL,1),(530,'save contact and then Display Add User Page',5,'\"1:164:0\",\"2,0:19:1\"',0,NULL,1),(531,'Property User Display',4,'\"1:165:1\"',0,NULL,1),(532,'Property User Edit',6,'\"3:165:1\"',0,NULL,1),(534,'Reservation Summary',4,'\"1:167:1\"',0,NULL,1),(535,'Reservation Summary Email',4,'\"1:168:1\"',0,NULL,1),(536,'Reservation Summary Email Search',4,'\"1:169:1\"',0,NULL,1),(537,'Contact Report',4,'\"3:171:1\",\"1:170:1\"',0,NULL,1),(538,'Contact Report Agent Popup',4,'\"1:172:1\"',0,NULL,1),(539,'Review Transfer Tables',4,'\"1:173:1\"',0,NULL,1),(540,'Display Rate Type',4,'\"1:174:1\",\"1:175:1\"',0,NULL,1),(541,'Add Rate Type Form',5,'\"2,0:174:1\",\"3:175:1\"',0,NULL,1),(542,'Save New Rate Type to DB',5,'\"2,1:174:1\",\"2,0:174:1\",\"1:175:1\"',0,NULL,1),(543,'Edit Rate Type Form',6,'\"3,0:174:1\",\"3:175:1\"',0,NULL,1),(544,'Update Rate Type in DB',6,'\"3,1:174:1\",\"2,0:174:1\",\"1:175:1\"',0,NULL,1),(545,'Delete Rate Type',7,'\"4,1:174:1\",\"2,0:174:1\",\"1:175:1\"',0,NULL,1),(546,'Display Ac Period',4,'\"1:176:1\",\"1:177:1\"',0,NULL,1),(547,'Add Ac Period Form',5,'\"2,0:176:1\",\"3:177:1\"',0,NULL,1),(548,'Save New Ac Period to DB',5,'\"2,1:176:1\",\"2,0:176:1\",\"1:177:1\"',0,NULL,1),(549,'Edit Ac Period Form',6,'\"3,0:176:1\",\"3:177:1\"',0,NULL,1),(550,'Update Ac Period in DB',6,'\"3,1:176:1\",\"2,0:176:1\",\"1:177:1\"',0,NULL,1),(551,'Delete Ac Period',7,'\"4,1:176:1\",\"2,0:176:1\",\"1:177:1\"',0,NULL,1),(552,'Display Tax Rate',4,'\"1:178:1\",\"1:179:1\"',0,NULL,1),(553,'Add Tax Rate Form',5,'\"2,0:178:1\",\"3:179:1\"',0,NULL,1),(554,'Save New Tax Rate to DB',5,'\"2,1:178:1\",\"2,0:178:1\",\"1:179:1\"',0,NULL,1),(555,'Edit Tax Rate Form',6,'\"3,0:178:1\",\"3:179:1\"',0,NULL,1),(556,'Update Tax Rate in DB',6,'\"3,1:178:1\",\"2,0:178:1\",\"1:179:1\"',0,NULL,1),(557,'Delete Tax Rate',7,'\"4,1:178:1\",\"2,0:178:1\",\"1:179:1\"',0,NULL,1),(558,'Display Bank Details',4,'\"1:180:1\",\"1:181:1\"',0,NULL,1),(559,'Add Bank Details Form',5,'\"2,0:180:1\",\"3:181:1\"',0,NULL,1),(560,'Save New Bank Details to DB',5,'\"2,1:180:1\",\"2,0:180:1\",\"1:181:1\"',0,NULL,1),(561,'Edit Bank Details Form',6,'\"3,0:180:1\",\"3:181:1\"',0,NULL,1),(562,'Update Bank Details in DB',6,'\"3,1:180:1\",\"2,0:180:1\",\"1:181:1\"',0,NULL,1),(563,'Delete Bank Details',7,'\"4,1:180:1\",\"2,0:180:1\",\"1:181:1\"',0,NULL,1),(564,'Display Extra',4,'\"1:182:1\",\"1:183:1\"',0,NULL,1),(565,'Add Extra Form',5,'\"2,0:182:1\",\"3:183:1\"',0,NULL,1),(566,'Save New Extra to DB',5,'\"2,1:182:1\",\"2,0:182:1\",\"1:183:1\"',0,NULL,1),(567,'Edit Extra Form',6,'\"3,0:182:1\",\"3:183:1\"',0,NULL,1),(568,'Update Extra in DB',6,'\"3,1:182:1\",\"2,0:182:1\",\"1:183:1\"',0,NULL,1),(569,'Delete Extra',7,'\"4,1:182:1\",\"2,0:182:1\",\"1:183:1\"',0,NULL,1),(570,'Display Cost Component',4,'\"1:184:1\",\"1:185:1\"',0,NULL,1),(571,'Add Cost Component Form',5,'\"2,0:184:1\",\"3:185:1\"',0,NULL,1),(572,'Save New Cost Component to DB',5,'\"2,1:184:1\",\"2,0:184:1\",\"1:185:1\"',0,NULL,1),(573,'Edit Cost Component Form',6,'\"3,0:184:1\",\"3:185:1\"',0,NULL,1),(574,'Update Cost Component in DB',6,'\"3,1:184:1\",\"2,0:184:1\",\"1:185:1\"',0,NULL,1),(575,'Delete Cost Component',7,'\"4,1:184:1\",\"2,0:184:1\",\"1:185:1\"',0,NULL,1),(576,'Display Payment Plan',4,'\"1:186:1\",\"1:187:1\"',0,NULL,1),(577,'Add Payment Plan Form',5,'\"2,0:186:1\",\"3:187:1\"',0,NULL,1),(578,'Save New Payment Plan to DB',5,'\"2,1:186:1\",\"2,0:186:1\",\"1:187:1\"',0,NULL,1),(579,'Edit Payment Plan Form',6,'\"3,0:186:1\",\"3:187:1\"',0,NULL,1),(580,'Update Payment Plan in DB',6,'\"3,1:186:1\",\"2,0:186:1\",\"1:187:1\"',0,NULL,1),(581,'Delete Payment Plan',7,'\"4,1:186:1\",\"2,0:186:1\",\"1:187:1\"',0,NULL,1),(582,'Display Payment Plan',4,'\"1:188:1\",\"1:189:1\"',0,NULL,1),(583,'Add Payment Plan Form',5,'\"2,0:188:1\",\"1:189:1\"',0,NULL,1),(584,'Save New Payment Plan to DB',5,'\"2,1:188:1\",\"2,0:188:1\",\"1:189:1\"',0,NULL,1),(585,'Edit Payment Plan Form',6,'\"3,0:188:1\",\"3:189:1\"',0,NULL,1),(586,'Update Payment Plan in DB',6,'\"3,1:188:1\",\"2,0:188:1\",\"1:189:1\"',0,NULL,1),(587,'Delete Payment Plan',7,'\"4,1:188:1\",\"2,0:188:1\",\"1:189:1\"',0,NULL,1),(588,'Display Exchange Currency',4,'\"1:190:1\",\"1:191:1\"',0,NULL,1),(589,'Add Exchange Currency Form',5,'\"2,0:190:1\",\"1:191:1\"',0,NULL,1),(590,'Save New Exchange Currency to DB',5,'\"2,1:190:1\",\"2,0:190:1\",\"1:191:1\"',0,NULL,1),(591,'Edit Exchange Currency Form',6,'\"3,0:190:1\",\"3:191:1\"',0,NULL,1),(592,'Update Exchange Currency in DB',6,'\"3,1:190:1\",\"2,0:190:1\",\"1:191:1\"',0,NULL,1),(593,'Delete Exchange Currency',7,'\"4,1:190:1\",\"2,0:190:1\",\"1:191:1\"',0,NULL,1),(594,'Display Method of Payment',4,'\"1:194:1\",\"1:195:1\"',0,NULL,1),(595,'Add Method of Payment Form',5,'\"2,0:194:1\",\"3:195:1\"',0,NULL,1),(596,'Save New Method of Payment to DB',5,'\"2,1:194:1\",\"2,0:194:1\",\"1:195:1\"',0,NULL,1),(597,'Edit Method of Payment Form',6,'\"3,0:194:1\",\"3:195:1\"',0,NULL,1),(598,'Update Method of Payment in DB',6,'\"3,1:194:1\",\"2,0:194:1\",\"1:195:1\"',0,NULL,1),(599,'Delete Method of Payment',7,'\"4,1:194:1\",\"2,0:194:1\",\"1:195:1\"',0,NULL,1),(606,'Delete accommodation type on the property maintainance screen.',7,'\"4,1:77:1\",\"2,0:77:1\"',0,NULL,1),(607,'Add New Accomm Type (property tree)',5,'\"2,1:77:1\",\"3,0:77:1\"',0,NULL,1),(608,'Add New Accomm Type (property tree) Display',5,'\"2,0:77:1',0,NULL,1),(609,'Display Extra',4,'\"1:196:1\",\"1:197:1\"',0,NULL,1),(610,'Add New Extra',5,'\"2,0:196:1\",\"1:197:1\"',0,NULL,1),(611,'Save New Extra',5,'\"2,1:196:1\",\"2,0:196:1\",\"1:197:1\"',0,NULL,1),(612,'Edit Extra',6,'\"3,0:196:1\",\"3:197:1\"',0,NULL,1),(613,'Save Updated Extra',6,'\"3,1:196:1\",\"2,0:196:1\",\"1:197:1\"',0,NULL,1),(614,'Delete Extra',7,'\"4,1:196:1\",\"2,0:196:1\",\"1:197:1\"',0,NULL,1),(615,'Select Extra (List)',2,'\"1:198:1\"',0,NULL,1),(616,'Extra Exch Rate',2,'\"3:199:1\"',0,NULL,1),(617,'Display Daily Exch Rate',4,'\"1:200:1\",\"1:201:1\"',0,NULL,1),(618,'Add Daily Exch Rate Form',5,'\"2,0:200:1\",\"3:201:1\"',0,NULL,1),(619,'Save New Daily Exch Rate to DB',5,'\"2,1:200:1\",\"2,0:200:1\",\"1:201:1\"',0,NULL,1),(620,'Edit Daily Exch Rate Form',6,'\"3,0:200:1\",\"3:201:1\"',0,NULL,1),(621,'Update Daily Exch Rate in DB',6,'\"3,1:200:1\",\"2,0:200:1\",\"1:201:1\"',0,NULL,1),(622,'Delete Daily Exch Rate',7,'\"4,1:200:1\",\"2,0:200:1\",\"1:201:1\"',0,NULL,1),(636,'Property Bank Select',5,'\"1:209:1\"',0,NULL,1),(637,'Calendar Wizard Itinerary',4,'\"1:210:1\"',0,NULL,1),(639,'Calendar Wizard Step 2',4,'\"3:212:1\"',0,NULL,1),(640,'Calendar Wizard Step 4',4,'\"1:213:1\"',0,NULL,1),(641,'Add Extra Frame',4,'\"1:214:1\"',0,NULL,1),(642,'Calendar Wizard Step 4 Document Summary',4,'\"1:215:1\"',0,NULL,1),(643,'Cancel the calendar wizard reservation',4,'\"1:216:1\"',0,NULL,1),(644,'Number of rooms RS page',4,'\"1:217:1\"',0,NULL,1),(645,'Overbooking popup',4,'\"1:218:1\"',0,NULL,1),(646,'Reservation Billings Display',4,'\"1:219:1\"',0,NULL,1),(647,'Reservation Billings Edit',6,'\"3:219:1\"',0,NULL,1),(648,'Reservation Billings Save and Edit',6,'\"3,1:219:0\",\"3:219:1\"',0,NULL,1),(649,'Reservation Billings rsFrame',6,'\"1:220:1\"',0,NULL,1),(650,'Reservation Requests',4,'\"1:221:1\"',1,NULL,1),(651,'New Payment',5,'\"2,0:222:1\"',0,NULL,1),(652,'Prov expiry report',4,'\"1:223:1\"',0,NULL,1),(653,'Consultant allocate report',4,'\"1:224:1\"',0,NULL,1),(654,'Record payments report',4,'\"1:225:1\"',0,NULL,1),(656,'Rate summary popup',4,'\"1:227:1\"',0,NULL,1),(657,'Consultant popup',4,'\"1:228:1\"',0,NULL,1),(658,'Report pay search popup',4,'\"1:229:1\"',0,NULL,1),(659,'Res Note Popup',4,'\"1:230:1\"',0,NULL,1),(660,'Reservation Summary Reports',4,'\"1:231:1\"',0,NULL,1),(661,'Multi filter popup',4,'\"1:232:1\"',0,NULL,1),(662,'capture payment popup',4,'\"2,0:233:1\"',0,NULL,1),(663,'Payment Item Listing (for remote script)',4,'\"1:234:1\"',0,NULL,1),(664,'Payment Capture Reservation Find Popup',4,'\"1:235:1\"',0,NULL,1),(665,'Save Payment Item',5,'\"2,1:233:1\",\"1:233:1\",\"1:264:0\"',0,NULL,1),(667,'Display Payment',4,'\"1:222:1\",\"1:234:1\"',0,NULL,1),(668,'Add Payment Form',5,'\"2,0:222:1\"',0,NULL,1),(669,'Save New Payment to DB',5,'\"2,1:222:1\",\"1:233:0\",\"1:222:1\",\"1:234:1\"',0,NULL,1),(670,'Edit Payment Form',15,'\"3,0:222:1\",\"3:234:1\"',0,NULL,1),(671,'Update Payment in DB',15,'\"3,1:222:1\",\"3,0:222:1\",\"1:234:1\"',0,NULL,1),(672,'Delete Payment',7,'\"4,1:222:1\",\"2,0:222:1\",\"1:234:1\"',0,NULL,1),(673,'Reservation Update Report',4,'\"1:236:1\"',0,NULL,1),(674,'New Reservation Item popup',5,'\"2:240:1\"',0,NULL,1),(675,'Details for Update Report',4,'\"1:242:1\"',0,NULL,1),(676,'Select optional components',4,'\"2:244:1\"',0,NULL,1),(677,'Edit Payment Plan Item',4,'\"1:243:1\"',0,NULL,1),(678,'Accommodation Note Popup',4,'\"1:245:1\"',0,NULL,1),(679,'Calendar Select Agent Popup',4,'\"1:246:1\"',0,NULL,1),(680,'Maintain Reservation Item Frame',4,'\"1:247:1\"',0,NULL,1),(681,'Agent rates popup',4,'\"1:248:1\"',0,NULL,1),(682,'Agent contact details',4,'\"1:249:1\"',0,NULL,1),(683,'Agent Role details',4,'\"1:250:1\"',0,NULL,1),(684,'Different Configurations Popup',4,'\"1:251:1\"',0,NULL,1),(685,'Payment note popup',4,'\"1:252:1\"',0,NULL,1),(686,'Display Source',4,'\"1:254:1\",\"1:255:1\"',0,NULL,1),(687,'Add Source Form',5,'\"2,0:254:1\",\"3:255:1\"',0,NULL,1),(688,'Save New Source to DB',5,'\"2,1:254:0\",\"2,0:254:1\",\"3:255:1\"',0,NULL,1),(689,'Edit Source Form',6,'\"3,0:254:1\",\"3:255:1\"',0,NULL,1),(690,'Update Source in DB',6,'\"3,1:254:0\",\"2,0:254:1\",\"3:255:1\"',0,NULL,1),(691,'Delete Source',7,'\"4,1:254:0\",\"2:254:1\",\"1:255:1\"',0,NULL,1),(692,'Persona Selection Popup',4,'\"1:265:1\"',0,NULL,0),(693,'Quick Availability Search',4,'\"1:266:1\"',1,NULL,1),(694,'Quick Search Results',4,'\"1:267:1\"',0,NULL,1),(696,'Payment Item load res',4,'\"1:234:1\"',0,NULL,1),(700,'Reservation Audit Popup',4,'\"1:270:1\"',0,NULL,0),(701,'DB Status Change - set web as master',10,'1:260:1',0,NULL,0),(702,'DB Status Change - set resoffice as master',10,'1:260:1',0,NULL,0),(703,'DB Status Change - force slave status',10,'1:260:1',0,NULL,0),(704,'DB Status Change - force master setting',10,'1:260:1',0,NULL,0),(705,'Revenue report',4,'\"1:256:1\"',0,NULL,0),(706,'Payments Due Report',4,'\"1:257:1\"',1,NULL,0),(707,'Source Popup',4,'\"1:258:1\"',0,NULL,0),(708,'Source Note Popup',4,'\"1:259:1\"',0,NULL,0),(709,'Component analysis report',4,'\"1:261:1\"',0,NULL,0),(711,'Extras Check popup',4,'\"1:263:1\"',0,NULL,0),(712,'Component analysis report popup',4,'\"1:271:1\"',0,NULL,0),(713,'Revenue report reservation popup',4,'\"1:272:1\"',0,NULL,0),(714,'Review DB Changes',4,'\"1:273:1\"',0,NULL,0),(715,'Property report',4,'\"1:276:1\"',0,NULL,0),(716,'Display Guest Type',4,'\"1:277:1\",\"1:278:1\"',0,NULL,1),(717,'Guest type code table',5,'\"2,0:277:1\",\"3:278:1\"',0,NULL,0),(718,'Save new guest type to DB',5,'\"2,1:277:0\",\"2,0:277:1\",\"3:278:1\"',0,NULL,0),(719,'Edit guest type form',6,'\"3,0:277:1\",\"3:278:1\"',0,NULL,0),(720,'Update guest type',6,'\"3,1:277:0\",\"2,0:277:1\",\"3:278:1\"',0,NULL,0),(721,'Delete guest type in DB',6,'\"4,1:277:0\",\"2,0:277:1\",\"3:278:1\"',0,NULL,0),(722,'Display extras categories',4,'\"1:289:1\",\"1:290:1\"',0,NULL,0),(723,'Add extra category form',6,'\"2,0:289:1\",\"3:290:1\"',0,NULL,0),(724,'Save extra category to DB',6,'\"2,1:289:0\",\"2,0:289:1\",\"3:290:1\"',0,NULL,0),(725,'Edit extra category form',6,'\"3,0:289:1\",\"3:290:1\"',0,NULL,0),(726,'Update extra category in DB',6,'\"3,1:289:0\",\"3,0:289:1\",\"3:290:1\"',0,NULL,0),(727,'Delete extra category',7,'\"4,1:289:0\",\"2:289:1\",\"1:290:1\"',0,NULL,0),(728,'Display gl code',4,'\"1:291:1\",\"1:292:1\"',0,NULL,0),(729,'Add gl code form',5,'\"2,0:291:1\",\"3:292:1\"',0,NULL,0),(730,'Save gl code to DB',5,'\"2,1:291:0\",\"2,0:291:1\",\"3:292:1\"',0,NULL,0),(731,'Edit gl code form',6,'\"3,0:291:1\",\"3:292:1\"',0,NULL,0),(732,'Update gl code in DB',6,'\"3,1:291:0\",\"2,0:291:1\",\"3:292:1\"',0,NULL,0),(733,'Delete gl code',7,'\"4,1:291:0\",\"2:291:1\",\"1:292:1\"',0,NULL,0),(734,'Extras Quick Entry',7,'\"1:294:1\"',1,NULL,0),(735,'Persona Pop Details',7,'\"1:299:1\"',0,NULL,0),(736,'Pax Count Popup ',4,'\"1:300:1\"',0,NULL,0),(737,'Rooming Pax Report Popup',7,'\"1:302:1\"',0,NULL,1),(738,'Rooming Pax Report',4,'\"1:302:1\"',0,NULL,1),(739,'Rooming Extras Report',7,'\"1:303:1\"',0,NULL,1),(740,'Rooming Depart Folios Report',7,'\"1:304:1\"',0,NULL,1),(741,'Rooming Day Sheet',7,'\"1:305:1\"',0,NULL,1),(742,'Arrivals/Departures Report',4,'\"1:306:1\"',0,NULL,1),(743,'Data Transfer Popup',7,'\"1:314:1\"',0,NULL,1),(744,'Display Server Details ',4,'\"1:315:1\",\"1:316:1\"',0,NULL,1),(745,'Add Server Details Form',5,'\"2,0:315:1\",\"3:316:1\"',0,NULL,1),(746,'Save New Server Details to DB',5,'\"2,1:315:1\",\"2,0:315:1\",\"1:316:1\"',0,NULL,1),(747,'Edit Server Details form',6,'\"3,0:315:1\",\"3:316:1\"',0,NULL,1),(748,'Update Server Details in DB',6,'\"3,1:315:1\",\"3,0:315:1\",\"1:316:1\"',0,NULL,1),(749,'Delete Server Details',7,'\"4,1:315:1\",\"2,0:315:1\",\"1:316:1\"',0,NULL,1),(750,'Reservation Itinerary Popup Display',7,'\"1:318:1\"',0,NULL,1),(751,'Agent popup edit',7,'\"3,0:250:1\"',0,NULL,1),(752,'Agent popup edit/save',7,'\"3,1:250:1\",\"3,0:250:1\"',0,NULL,1),(753,'Extra Category Filter Popup',4,'\"1:320:1\"',0,NULL,1),(754,'Rooming Summary Popup',7,'\"1:322:1\"',0,NULL,1),(756,'Change expiry date popup',7,'\"1:324:1\"',0,NULL,1),(757,'Notify agent/contact prov exp popup',7,'\"1:325:1\"',0,NULL,1),(758,'Display Custom notes',4,'\"1:326:1\",\"1:327:1\"',0,NULL,1),(759,'Custom notes code table',5,'\"2,0:326:1\",\"3:327:1\"',0,NULL,1),(760,'Save new custom note to DB',5,'\"2,1:326:0\",\"1:331:0\",\"3,0:326:1\",\"3:327:1\"',0,NULL,1),(761,'Edit Custom note form',6,'\"3,0:326:1\",\"3:327:1\"',0,NULL,1),(762,'Update Custom note',6,'\"3,1:326:0\",\"1:331:0\",\"3,0:326:1\",\"3:327:1\"',0,NULL,1),(763,'Delete Custom note in DB',6,'\"4,1:326:0\",\"2,0:326:1\",\"3:327:1\"',0,NULL,1),(764,'Custom Note setup',6,'\"1:328:1\"',0,NULL,1),(765,'Custom Note images',6,'\"1:329:1\"',0,NULL,1),(766,'Delete Custom note items in DB',6,'\"4,1:326:0\",\"3,0:326:1\",\"3:327:1\"',0,NULL,1),(767,'Telephone Listing\r\n(from Property popup)',3,'\"0:26:1\"',0,NULL,1),(768,'Display Telephone\r\n(from Property popup)',4,'\"1:25:1\",\"1:26:1\"',0,NULL,1),(769,'Add Telephone Form\r\n(from Property popup)',6,'\"2,0:25:1\",\"3:26:1\"',0,NULL,1),(770,'Save New Telephone to DB\r\n(from Property popup)',6,'\"2,1:25:0\",\"2,0:25:1\",\"3:26:1\"',0,NULL,1),(771,'Edit Telephone Form\r\n(from Property popup)',6,'\"3,0:25:1\",\"3:26:1\"',0,NULL,1),(772,'Update Telephone in DB\r\n(from Property popup)',6,'\"3,1:25:0\",\"2,0:25:1\",\"3:26:1\"',0,NULL,1),(773,'Delete Telephone\r\n(from Property popup)',7,'\"4,1:25:0\",\"2,0:25:1\",\"1:26:1\"',0,NULL,1),(774,'Folio Details Popup',7,'\"1:335:1\"',0,NULL,1),(780,'Display My Preferences Form',4,'\"3:400:1\"',0,NULL,1),(781,'Update My Preferences',6,'\"3,1:400:0\",\"3,0:400:1\"',0,NULL,1),(782,'Email Templates',4,'\"1:398:1\"',0,NULL,1),(783,'Get Email Templates',4,'\"1:399:1\"',0,NULL,1),(784,'Display Rate Period Dates Form',4,'\"1:401:1\",\"1:402:1\"',0,NULL,1),(785,'Add Rate Period Dates Form',5,'\"2,0:401:1\",\"1:402:1\"',0,NULL,1),(786,'Save Rate Period Dates to DB',5,'\"2,1:401:1\",\"2,0:401:1\",\"1:402:1\"',0,NULL,1),(787,'Edit Rate Period Dates Form',6,'\"3,0:401:1\",\"3:402:1\"',0,NULL,1),(788,'Update Rate Period Dates in DB',6,'\"3,1:401:1\",\"2,0:401:1\",\"1:402:1\"',0,NULL,1),(789,'Delete Rate Period Dates',7,'\"4,1:401:1\",\"2,0:401:1\",\"1:402:1\"',0,NULL,1),(998,'Licence screen of death',0,'\"1:501:1\"',0,NULL,5),(999,'White screen of death',0,'\"1:500:1\"',0,NULL,5),(1000,'Debtors Report',4,'\"1:1000:1\"',1,NULL,0),(1001,'Display payment gateway',4,'\"1,0:1001:1\",\"1,0:1002:1\"',0,NULL,0),(1002,'Add payment gateway',6,'\"2,0:1001:1\",\"3:1002:1\"',0,NULL,0),(1003,'Edit payment gateway',6,'\"3,0:1001:1\",\"3:1002:1\"',0,NULL,0),(1004,'Update payment gateway',6,'\"3,1:1001:0\",\"2,0:1001:1\",\"3:1002:1\"',0,NULL,0),(1005,'Save new payment gateway',6,'\"2,1:1001:0\",\"3,0:1001:1\",\"3:1002:1\"',0,NULL,0),(1006,'Delete payment gateway',7,'\"4,1:1001:0\",\"2:1001:1\",\"1:1002:1\"',0,NULL,0),(1007,'Payment Gateway Reply form',4,'\"3:1003:1\"',0,NULL,0),(1008,'Reservation Payment Gateway Popup',4,'\"1:1004:1\"',0,NULL,0),(1009,'Requests Received Status Popup',4,'\"1:1005:1\"',0,NULL,0),(1010,'Folio / Invoice Report Bulk Email Popup',4,'\"1:1006:1\"',0,NULL,1),(1011,'Room Discrepancy Report',4,'\"1:1007:1\"',0,NULL,1),(1013,'Email attachment list',4,'\"1:1009:1\"',0,NULL,1),(1014,'Financial Analysis Report (Day)',4,'\"1:1008:1\"',0,NULL,1),(1015,'Financial Analysis Report (Folio)',4,'\"1:1008:1\"',0,NULL,1),(1016,'Invoice tax display & order popup (edit)',6,'\"3:1010:1\"',0,NULL,1),(1017,'Invoice tax display & order popup (save edit)',6,'\"3,1:1010:1\"',0,NULL,1),(1018,'Transaction maintenance popup (Edit)',6,'3:364:1',0,NULL,1),(1019,'Transaction maintenance popup (Edit Save)',6,'3,1:364:1',0,NULL,1),(1020,'Transaction check codes popup',4,'1:1011:1',0,NULL,1),(1021,'Payment gateway deposit (edit)',6,'3:1012:1',0,NULL,1),(1022,'Payment gateway deposit (save edit)',6,'3,1:1012:1',0,NULL,1),(1023,'Archive selection popup',4,'1:1013:1',0,NULL,1),(1025,'Contact Audit Popup',4,'1:1015:1',0,NULL,0),(1026,'Open and close out rooms',6,'1:1016:1',0,NULL,0),(2000,'Rate Calculator',7,'\"1:2000:1\"',0,NULL,1),(2001,'Delete Rate',7,'\"2:2001:1\"',0,NULL,1),(2002,'Rate Sheet',4,'\"1:2002:1\"',1,NULL,0),(2003,'Debtors Analysis Report',4,'\"1:2003:1\"',0,NULL,1),(2004,'Tax Analysis Report',4,'\"1:2004:1\"',0,NULL,1),(2005,'Guest Tripsheet Select',4,'\"3:2005:1\"',0,NULL,1),(2006,'Guest Tripsheet Copy',4,'\"3,1:2005:1\"',0,NULL,1),(2007,'Invoice Currency Calc or Regen',2,'\"3:2006:1\"',0,NULL,1),(2008,'Customer Statement',4,'\"1:2007:1\"',0,NULL,1),(2009,'Customer Statement Bulk Email Popup',4,'\"1:2008:1\"',0,NULL,1),(2010,'Specials',4,'\"1:2009:1\"',0,NULL,1),(2011,'Specials Wizard Step 1',4,'\"1:2010:1\"',0,NULL,1),(2012,'Specials Wizard Step 2',4,'\"1:2011:1\"',0,NULL,1),(2013,'Specials Wizard Step 3',4,'\"1:2012:1\"',0,NULL,1),(2014,'Select Special Popup',4,'\"1:2013:1\"',0,NULL,1),(2015,'Save Special',4,'\"1:2014:1\"',0,NULL,1),(2016,'Show applied Special itinerary details',4,'\"1:2015:1\"',0,NULL,1),(3000,'Error reporting',4,'\"1:3000:1\"',0,NULL,1),(3001,'Auto Mailer',4,'\"1:3001:1\"',0,NULL,1),(3002,'Profiles',4,'\"1:3002:1\"',0,NULL,1),(3003,'Quick Menu Search',4,'\"1:3003:1\"',0,NULL,1),(3004,'Wetu Tab',4,'\"1:3004:1\"',0,NULL,1),(3005,'Wetu Mapping',4,'\"1:3005:1\"',0,NULL,1),(3007,'Add reminder modal',5,'\"1:3007:1\"',0,NULL,1),(3008,'Search reservations and contacts',5,'\"1:3008:1\"',0,NULL,1),(3009,'Get reminders to be send list',5,'\"1:3009:1\"',0,NULL,1),(3010,'Display reservations reminders tab',4,'\"1:3010:1\"',0,NULL,1),(3011,'Edit reminder modal',5,'\"1:3011:1\"',0,NULL,1),(6000,'Audit Trail Report',4,'\"1:6000:1\"',0,NULL,0),(6001,'Display Block Templates',4,'\"1:6001:1\"',0,NULL,0),(6002,'Add Block Templates Page',4,'\"2:6001:1\"',0,NULL,0),(6003,'Add Block Templates to DB',6,'\"2,1:6001:0\",\"1:6001:1\"',0,NULL,0),(6004,'Edit Block Templates',6,'\"3,0:6001:1\"',0,NULL,0),(6005,'Update Block Templates on DB',6,'\"3,1:6001:1\",\"1:6001:1\"',0,NULL,0),(6006,'Delete Block Templates',6,'\"4,1:6001:1\",\"1:6001:1\"',0,NULL,0),(6007,'List Block Templates',4,'\"2:6002:1\",\"1:6002:1\"',0,NULL,0),(6008,'Display Block Template Periods',4,'\"1:6003:1\"',0,NULL,0),(6009,'Add Block Template Periods Page',5,'\"2:6003:1\"',0,NULL,0),(6010,'Add Block Template Periods to DB',5,'\"2:6003:1\",\"1:6003:1\"',0,NULL,0),(6011,'Edit Block Template Periods',5,'\"3,0:6003:1\"',0,NULL,0),(6012,'Update Block Template Periods on DB',5,'\"3,1:6003:1\",\"1:6003:1\"',0,NULL,0),(6013,'Delete Block Template Periods',5,'\"4,1:6003:1\",\"1:6003:1',0,NULL,0),(6014,'Reservation List',4,'\"1:6004:1\"',0,NULL,0),(6015,'Allocation Time Line',4,'\"1:6005:1\"',0,NULL,0),(6016,'View Create Reservation from Template Dialog',5,'\"1:6006:1\"',0,NULL,0),(6017,'Add Reservation from Template',5,'\"2:6006:1\"',0,NULL,0),(7000,'Send Reservation Modification Request Email',5,'\"2:7000:1\"',0,NULL,0);
/*!40000 ALTER TABLE `sc_job` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sc_fun_job`
--

DROP TABLE IF EXISTS `sc_fun_job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sc_fun_job` (
  `sc_fun_job_id` int(11) NOT NULL AUTO_INCREMENT,
  `sc_job_id` int(11) DEFAULT NULL,
  `sc_function_id` int(11) DEFAULT NULL,
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `sc_fun_job_trf_yn` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sc_fun_job_id`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `sc_fun_job_trf_yn` (`sc_fun_job_trf_yn`)
) ENGINE=InnoDB AUTO_INCREMENT=755 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sc_fun_job`
--

LOCK TABLES `sc_fun_job` WRITE;
/*!40000 ALTER TABLE `sc_fun_job` DISABLE KEYS */;
INSERT INTO `sc_fun_job` VALUES (1,0,52,NULL,1),(2,1,52,NULL,1),(3,2,52,NULL,1),(4,3,52,NULL,1),(5,4,52,NULL,1),(6,5,52,NULL,1),(7,6,52,NULL,1),(8,7,52,NULL,1),(9,8,52,NULL,1),(10,9,52,NULL,1),(11,10,52,NULL,1),(12,11,52,NULL,1),(13,12,52,NULL,1),(14,19,52,NULL,1),(15,20,50,NULL,1),(16,16,52,NULL,1),(18,43,54,NULL,1),(19,44,54,NULL,1),(20,45,54,NULL,1),(21,46,54,NULL,1),(27,66,54,NULL,1),(28,67,54,NULL,1),(29,68,54,NULL,1),(30,69,54,NULL,1),(31,70,54,NULL,1),(32,71,54,NULL,1),(33,72,54,NULL,1),(34,42,54,NULL,1),(35,47,54,NULL,1),(36,48,82,NULL,1),(37,49,82,NULL,1),(38,50,82,NULL,1),(39,51,82,NULL,1),(40,52,82,NULL,1),(41,53,82,NULL,1),(42,54,54,NULL,1),(43,55,54,NULL,1),(44,56,54,NULL,1),(45,65,54,NULL,1),(46,57,83,NULL,1),(47,58,83,NULL,1),(48,59,83,NULL,1),(49,60,83,NULL,1),(50,61,83,NULL,1),(51,62,83,NULL,1),(52,63,54,NULL,1),(53,64,54,NULL,1),(54,134,54,NULL,1),(55,135,54,NULL,1),(56,136,54,NULL,1),(57,500,54,NULL,1),(58,525,52,NULL,1),(59,137,123,NULL,1),(60,138,123,NULL,1),(61,139,123,NULL,1),(62,133,53,NULL,1),(63,142,53,NULL,1),(64,143,53,NULL,1),(65,141,53,NULL,1),(66,34,53,NULL,1),(67,73,53,NULL,1),(68,74,53,NULL,1),(71,17,52,NULL,1),(72,87,57,NULL,1),(73,88,57,NULL,1),(74,89,57,NULL,1),(75,90,57,NULL,1),(76,91,57,NULL,1),(77,92,57,NULL,1),(78,75,57,NULL,1),(79,76,57,NULL,1),(80,77,57,NULL,1),(81,78,57,NULL,1),(82,79,57,NULL,1),(83,80,57,NULL,1),(84,29,51,NULL,1),(85,140,51,NULL,1),(89,33,61,NULL,1),(90,126,64,NULL,1),(91,127,64,NULL,1),(92,128,64,NULL,1),(93,111,63,NULL,1),(94,112,63,NULL,1),(95,113,63,NULL,1),(96,114,63,NULL,1),(97,115,63,NULL,1),(98,116,63,NULL,1),(99,105,63,NULL,1),(100,106,63,NULL,1),(101,107,63,NULL,1),(102,108,63,NULL,1),(103,109,63,NULL,1),(104,110,63,NULL,1),(105,81,57,NULL,1),(106,82,57,NULL,1),(107,83,57,NULL,1),(108,84,57,NULL,1),(109,85,57,NULL,1),(110,86,57,NULL,1),(111,123,60,NULL,1),(112,144,65,NULL,1),(113,145,65,NULL,1),(114,146,65,NULL,1),(115,147,65,NULL,1),(116,148,65,NULL,1),(117,149,65,NULL,1),(118,150,65,NULL,1),(119,151,65,NULL,1),(120,160,65,NULL,1),(121,161,65,NULL,1),(122,162,65,NULL,1),(123,163,65,NULL,1),(124,164,65,NULL,1),(125,165,65,NULL,1),(127,132,66,NULL,1),(128,501,57,NULL,1),(129,502,57,NULL,1),(130,503,57,NULL,1),(131,504,57,NULL,1),(132,505,57,NULL,1),(133,506,57,NULL,1),(134,507,57,NULL,1),(135,508,57,NULL,1),(136,509,57,NULL,1),(137,510,57,NULL,1),(138,511,57,NULL,1),(139,512,57,NULL,1),(140,513,57,NULL,1),(141,514,57,NULL,1),(142,515,57,NULL,1),(143,516,57,NULL,1),(144,517,57,NULL,1),(145,518,57,NULL,1),(146,519,58,NULL,1),(147,520,58,NULL,1),(148,521,58,NULL,1),(149,522,58,NULL,1),(150,523,58,NULL,1),(151,524,58,NULL,1),(152,18,52,NULL,1),(153,30,52,NULL,1),(154,31,51,NULL,1),(155,129,62,NULL,1),(156,526,54,NULL,1),(157,130,59,NULL,1),(158,131,59,NULL,1),(159,170,61,NULL,1),(160,168,61,NULL,1),(162,166,61,NULL,1),(163,167,61,NULL,1),(164,173,62,NULL,1),(165,528,50,NULL,1),(166,171,61,NULL,1),(167,172,61,NULL,1),(168,174,61,NULL,1),(169,529,54,NULL,1),(170,530,82,NULL,1),(172,527,66,NULL,1),(173,169,61,NULL,1),(174,531,61,NULL,1),(175,175,61,NULL,1),(176,532,61,NULL,1),(177,176,61,NULL,1),(179,177,67,NULL,1),(180,178,61,NULL,1),(181,179,61,NULL,1),(182,180,61,NULL,1),(183,181,61,NULL,1),(184,528,66,NULL,1),(185,182,61,NULL,1),(186,183,61,NULL,1),(187,534,52,NULL,1),(188,535,52,NULL,1),(189,536,52,NULL,1),(190,184,50,NULL,1),(191,537,53,NULL,1),(192,132,66,NULL,1),(193,538,55,NULL,1),(194,539,64,NULL,1),(195,185,53,NULL,1),(196,540,58,NULL,1),(197,541,58,NULL,1),(198,542,58,NULL,1),(199,543,58,NULL,1),(200,544,58,NULL,1),(201,545,58,NULL,1),(202,546,58,NULL,1),(203,547,58,NULL,1),(204,548,58,NULL,1),(205,549,58,NULL,1),(206,550,58,NULL,1),(207,551,58,NULL,1),(208,552,58,NULL,1),(209,553,58,NULL,1),(210,554,58,NULL,1),(211,555,58,NULL,1),(212,556,58,NULL,1),(213,557,58,NULL,1),(214,558,58,NULL,1),(215,559,58,NULL,1),(216,560,58,NULL,1),(217,561,58,NULL,1),(218,562,58,NULL,1),(219,563,58,NULL,1),(220,564,80,NULL,1),(221,565,80,NULL,1),(222,566,80,NULL,1),(223,567,80,NULL,1),(224,568,80,NULL,1),(225,569,80,NULL,1),(226,570,58,NULL,1),(227,571,58,NULL,1),(228,572,58,NULL,1),(229,573,58,NULL,1),(230,574,58,NULL,1),(231,575,58,NULL,1),(232,576,58,NULL,1),(233,577,58,NULL,1),(234,578,58,NULL,1),(235,579,58,NULL,1),(236,580,58,NULL,1),(237,581,58,NULL,1),(238,582,58,NULL,1),(239,583,58,NULL,1),(240,584,58,NULL,1),(241,585,58,NULL,1),(242,586,58,NULL,1),(243,587,58,NULL,1),(244,588,58,NULL,1),(245,589,58,NULL,1),(246,590,58,NULL,1),(247,591,58,NULL,1),(248,592,58,NULL,1),(249,593,58,NULL,1),(250,594,58,NULL,1),(251,595,58,NULL,1),(252,596,58,NULL,1),(253,597,58,NULL,1),(254,598,58,NULL,1),(255,599,58,NULL,1),(262,606,61,NULL,1),(263,607,61,NULL,1),(264,608,61,NULL,1),(265,999,66,NULL,1),(266,609,52,NULL,1),(267,610,52,NULL,1),(268,611,52,NULL,1),(269,612,52,NULL,1),(270,613,52,NULL,1),(271,614,52,NULL,1),(272,615,52,NULL,1),(273,616,52,NULL,1),(274,617,58,NULL,1),(275,618,58,NULL,1),(276,619,58,NULL,1),(277,620,58,NULL,1),(278,621,58,NULL,1),(279,622,58,NULL,1),(293,636,61,NULL,1),(294,637,50,NULL,1),(295,638,50,NULL,1),(296,639,50,NULL,1),(297,640,50,NULL,1),(298,641,50,NULL,1),(299,642,50,NULL,1),(300,643,50,NULL,1),(301,644,50,NULL,1),(302,645,50,NULL,1),(303,186,52,NULL,1),(304,187,52,NULL,1),(305,188,52,NULL,1),(306,646,125,NULL,1),(307,647,125,NULL,1),(308,648,125,NULL,1),(309,649,52,NULL,1),(310,650,70,NULL,1),(311,651,69,NULL,1),(312,652,53,NULL,1),(313,653,71,NULL,1),(314,654,53,NULL,1),(316,656,66,NULL,1),(317,657,52,NULL,1),(318,658,52,NULL,1),(319,659,52,NULL,1),(320,660,52,NULL,1),(321,661,66,NULL,1),(322,189,52,NULL,1),(323,190,52,NULL,1),(324,191,52,NULL,1),(325,192,85,NULL,1),(326,193,85,NULL,1),(327,194,85,NULL,1),(328,195,85,NULL,1),(329,196,85,NULL,1),(330,197,85,NULL,1),(331,662,69,NULL,1),(332,663,69,NULL,1),(333,664,69,NULL,1),(334,665,69,NULL,1),(335,666,69,NULL,1),(336,667,69,NULL,1),(337,668,69,NULL,1),(338,669,69,NULL,1),(339,671,69,NULL,1),(340,672,69,NULL,1),(341,670,69,NULL,1),(342,673,55,NULL,1),(343,198,66,NULL,1),(345,199,66,NULL,1),(346,674,66,NULL,1),(347,200,59,NULL,1),(348,675,53,NULL,1),(349,676,50,NULL,1),(351,678,50,NULL,1),(352,679,50,NULL,1),(353,680,52,NULL,1),(354,681,53,NULL,1),(356,683,83,NULL,1),(358,682,54,NULL,1),(360,685,52,NULL,0),(361,684,50,NULL,0),(362,201,53,NULL,1),(363,131,59,NULL,1),(364,202,67,NULL,1),(365,203,71,NULL,1),(366,204,53,NULL,1),(367,205,55,NULL,1),(368,686,57,NULL,1),(369,687,57,NULL,1),(370,688,57,NULL,1),(371,689,57,NULL,1),(372,690,57,NULL,1),(373,691,57,NULL,1),(374,701,75,NULL,0),(375,702,75,NULL,0),(376,703,75,NULL,0),(377,704,75,NULL,0),(378,705,76,NULL,0),(379,706,74,NULL,0),(380,707,52,NULL,0),(381,708,52,NULL,0),(382,709,76,NULL,0),(384,700,52,NULL,0),(385,711,52,NULL,0),(386,712,76,NULL,0),(387,692,66,NULL,0),(388,713,76,NULL,0),(389,700,52,NULL,0),(390,714,75,NULL,0),(391,677,52,NULL,0),(392,207,77,NULL,0),(393,208,77,NULL,0),(394,715,78,NULL,0),(395,716,57,NULL,0),(396,717,57,NULL,0),(397,718,57,NULL,0),(398,719,57,NULL,0),(399,720,57,NULL,0),(400,721,57,NULL,0),(401,209,84,NULL,0),(402,210,84,NULL,0),(403,211,84,NULL,0),(404,212,84,NULL,0),(405,213,84,NULL,0),(406,214,84,NULL,0),(407,215,124,NULL,0),(408,216,124,NULL,0),(409,217,124,NULL,0),(410,218,52,NULL,0),(411,219,52,NULL,0),(412,220,52,NULL,0),(413,221,52,NULL,0),(414,222,52,NULL,0),(415,223,52,NULL,0),(416,224,52,NULL,0),(417,225,52,NULL,0),(418,693,50,NULL,1),(419,694,50,NULL,1),(420,226,81,NULL,0),(421,227,52,NULL,0),(422,228,61,NULL,0),(423,722,80,NULL,0),(424,723,80,NULL,0),(425,724,80,NULL,0),(426,725,80,NULL,0),(427,726,80,NULL,0),(428,727,80,NULL,0),(429,728,58,NULL,0),(430,729,58,NULL,0),(431,730,58,NULL,0),(432,731,58,NULL,0),(433,732,58,NULL,0),(434,733,58,NULL,0),(435,229,52,NULL,0),(436,734,79,NULL,0),(437,230,66,NULL,0),(438,231,52,NULL,0),(439,232,52,NULL,0),(440,696,69,NULL,1),(441,233,76,NULL,0),(442,735,66,NULL,0),(443,736,95,NULL,0),(444,234,81,NULL,0),(445,737,95,NULL,0),(446,738,95,NULL,0),(447,739,66,NULL,0),(448,740,81,NULL,0),(449,741,66,NULL,0),(450,235,81,NULL,0),(451,742,67,NULL,0),(452,236,86,NULL,0),(453,237,86,NULL,0),(454,238,86,NULL,0),(455,239,86,NULL,0),(456,240,86,NULL,0),(457,241,86,NULL,0),(458,242,81,NULL,0),(459,243,81,NULL,0),(460,244,81,NULL,0),(461,245,69,NULL,0),(462,743,64,NULL,0),(463,744,87,NULL,0),(464,745,87,NULL,0),(465,746,87,NULL,0),(466,747,87,NULL,0),(467,748,87,NULL,0),(468,749,87,NULL,0),(469,246,88,NULL,0),(470,750,52,NULL,0),(471,247,88,NULL,0),(472,751,83,NULL,0),(473,752,83,NULL,0),(474,753,66,NULL,0),(475,248,52,NULL,0),(476,754,67,NULL,0),(477,249,91,NULL,0),(478,250,91,NULL,0),(479,251,91,NULL,0),(481,756,53,NULL,1),(482,757,53,NULL,1),(483,758,89,NULL,1),(484,759,89,NULL,1),(485,760,89,NULL,1),(486,761,89,NULL,1),(487,762,89,NULL,1),(488,763,89,NULL,1),(489,764,89,NULL,1),(490,765,89,NULL,1),(491,252,92,NULL,0),(492,253,92,NULL,0),(493,254,92,NULL,0),(494,255,92,NULL,0),(495,766,89,NULL,1),(496,767,61,NULL,1),(497,768,61,NULL,1),(498,769,61,NULL,0),(499,770,61,NULL,0),(500,771,61,NULL,0),(501,772,61,NULL,0),(502,773,61,NULL,0),(503,256,57,NULL,0),(504,257,90,NULL,0),(505,258,90,NULL,0),(506,774,81,NULL,0),(507,259,50,NULL,0),(508,260,93,NULL,0),(509,261,94,NULL,0),(510,262,96,NULL,0),(511,263,66,NULL,0),(512,264,97,NULL,0),(513,265,98,NULL,0),(514,266,99,NULL,0),(515,267,83,NULL,0),(516,268,83,NULL,0),(517,269,83,NULL,0),(518,270,83,NULL,0),(519,271,83,NULL,0),(520,272,83,NULL,0),(521,273,83,NULL,0),(522,998,66,NULL,0),(523,274,52,NULL,0),(524,275,83,NULL,0),(525,276,100,NULL,0),(526,277,100,NULL,0),(527,278,100,NULL,0),(528,279,100,NULL,0),(529,280,100,NULL,0),(530,281,100,NULL,0),(531,282,100,NULL,0),(532,283,100,NULL,0),(533,284,100,NULL,0),(534,285,100,NULL,0),(535,286,100,NULL,0),(536,287,100,NULL,0),(537,288,100,NULL,0),(538,289,101,NULL,0),(539,290,101,NULL,0),(540,291,102,NULL,0),(541,292,103,NULL,0),(542,293,66,NULL,0),(543,294,104,NULL,0),(544,295,101,NULL,0),(545,297,66,NULL,0),(546,296,101,NULL,0),(547,298,69,NULL,0),(548,299,69,NULL,0),(549,300,69,NULL,0),(550,301,69,NULL,0),(551,302,100,NULL,0),(552,303,101,NULL,0),(553,304,105,NULL,0),(554,305,105,NULL,0),(555,306,59,NULL,0),(556,307,66,NULL,0),(557,308,72,NULL,0),(558,309,106,NULL,0),(559,310,107,NULL,0),(560,311,66,NULL,0),(561,312,109,NULL,0),(562,313,112,NULL,0),(563,314,112,NULL,0),(564,315,112,NULL,0),(565,316,112,NULL,0),(566,317,112,NULL,0),(567,318,112,NULL,0),(568,319,66,NULL,0),(569,320,112,NULL,0),(570,321,112,NULL,0),(571,322,113,NULL,0),(572,323,113,NULL,0),(573,324,113,NULL,0),(574,325,113,NULL,0),(575,326,113,NULL,0),(576,327,113,NULL,0),(577,328,113,NULL,0),(578,329,113,NULL,0),(579,330,110,NULL,0),(580,331,110,NULL,0),(581,332,110,NULL,0),(582,333,110,NULL,0),(583,334,110,NULL,0),(584,335,110,NULL,0),(585,336,111,NULL,0),(586,337,114,NULL,0),(587,338,114,NULL,0),(588,339,114,NULL,0),(589,340,114,NULL,0),(590,341,114,NULL,0),(591,342,114,NULL,0),(592,343,114,NULL,0),(593,344,114,NULL,0),(594,345,115,NULL,0),(595,346,115,NULL,0),(596,347,115,NULL,0),(597,348,115,NULL,0),(598,349,66,NULL,0),(599,350,66,NULL,0),(600,351,50,NULL,0),(601,352,116,NULL,0),(602,782,118,NULL,1),(603,783,118,NULL,1),(604,780,117,NULL,1),(605,781,117,NULL,1),(606,353,50,NULL,0),(607,354,50,NULL,0),(608,355,119,NULL,0),(609,356,119,NULL,0),(610,357,119,NULL,0),(611,358,119,NULL,0),(612,359,119,NULL,0),(613,360,119,NULL,0),(614,361,119,NULL,0),(615,362,119,NULL,0),(616,363,119,NULL,0),(617,364,119,NULL,0),(618,365,119,NULL,0),(619,366,119,NULL,0),(620,367,119,NULL,0),(621,368,119,NULL,0),(622,369,119,NULL,0),(623,370,119,NULL,0),(624,371,119,NULL,0),(625,372,119,NULL,0),(626,373,120,NULL,0),(627,374,120,NULL,0),(628,375,120,NULL,0),(629,376,120,NULL,0),(630,377,120,NULL,0),(631,378,120,NULL,0),(632,379,66,NULL,0),(633,380,120,NULL,0),(634,381,120,NULL,0),(635,382,121,NULL,0),(636,383,121,NULL,0),(637,384,121,NULL,0),(638,385,121,NULL,0),(639,386,121,NULL,0),(640,387,121,NULL,0),(641,388,121,NULL,0),(642,389,121,NULL,0),(643,390,121,NULL,0),(644,391,121,NULL,0),(645,392,121,NULL,0),(646,393,121,NULL,0),(647,394,122,NULL,0),(648,403,121,NULL,0),(649,408,121,NULL,0),(650,784,58,NULL,1),(651,785,58,NULL,1),(652,786,58,NULL,1),(653,787,58,NULL,1),(654,788,58,NULL,1),(655,789,58,NULL,1),(656,395,58,NULL,1),(657,396,58,NULL,1),(658,397,58,NULL,1),(659,398,58,NULL,1),(660,399,58,NULL,1),(661,400,58,NULL,1),(662,401,68,NULL,1),(663,404,68,NULL,1),(664,405,68,NULL,1),(665,406,68,NULL,1),(666,407,68,NULL,1),(667,409,68,NULL,1),(668,422,68,NULL,1),(669,410,58,NULL,1),(670,411,58,NULL,1),(671,412,58,NULL,1),(672,413,58,NULL,1),(673,414,58,NULL,1),(674,415,58,NULL,1),(675,416,58,NULL,1),(676,417,58,NULL,1),(677,418,58,NULL,1),(678,419,58,NULL,1),(679,420,58,NULL,1),(680,421,58,NULL,1),(681,423,58,NULL,1),(682,424,58,NULL,1),(683,2000,58,NULL,1),(684,2001,58,NULL,1),(685,1000,100,NULL,0),(686,1001,126,NULL,0),(687,1002,126,NULL,0),(688,1003,126,NULL,0),(689,1004,126,NULL,0),(690,1005,126,NULL,0),(691,1006,126,NULL,0),(692,1007,50,NULL,0),(693,1008,66,NULL,0),(694,1009,70,NULL,0),(695,2002,68,NULL,1),(696,2003,128,NULL,1),(697,1010,76,NULL,0),(698,2004,127,NULL,1),(699,1011,1000,NULL,1),(700,1013,66,NULL,0),(701,2005,110,NULL,1),(702,2006,110,NULL,1),(703,1014,1001,NULL,0),(704,1015,1001,NULL,0),(705,2007,52,NULL,1),(706,2008,2000,NULL,1),(707,2009,52,NULL,1),(708,1017,61,NULL,0),(709,1016,61,NULL,0),(710,2010,2001,NULL,0),(711,2011,2001,NULL,0),(712,2012,2001,NULL,0),(713,2013,2001,NULL,0),(714,2014,66,NULL,0),(715,2015,2001,NULL,0),(716,2016,2001,NULL,0),(717,6000,6000,NULL,0),(718,3000,66,NULL,1),(719,6001,6001,NULL,0),(720,6002,6001,NULL,0),(721,6003,6001,NULL,0),(722,6004,6001,NULL,0),(723,6005,6001,NULL,0),(724,6006,6001,NULL,0),(725,6007,6001,NULL,0),(726,6008,6001,NULL,0),(727,6009,6001,NULL,0),(728,6010,6001,NULL,0),(729,6011,6001,NULL,0),(730,6012,6001,NULL,0),(731,6013,6001,NULL,0),(732,6014,6001,NULL,0),(733,6015,6001,NULL,0),(734,6016,6001,NULL,0),(735,6017,6001,NULL,0),(736,3001,66,NULL,1),(737,1018,101,NULL,1),(738,1019,101,NULL,1),(739,1020,101,NULL,1),(740,1021,1002,NULL,0),(741,1022,1002,NULL,0),(742,3002,66,NULL,1),(743,3003,66,NULL,1),(744,1023,66,NULL,1),(745,1025,54,NULL,0),(746,3004,52,NULL,0),(747,3005,57,NULL,1),(748,1026,1004,NULL,0),(749,7000,52,NULL,0),(750,3007,66,NULL,0),(751,3011,66,NULL,0),(752,3008,66,NULL,0),(753,3009,66,NULL,0),(754,3010,52,NULL,0);
/*!40000 ALTER TABLE `sc_fun_job` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sc_menu`
--

DROP TABLE IF EXISTS `sc_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sc_menu` (
  `sc_menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `sc_menu_job_top` int(11) DEFAULT NULL,
  `sc_menu_param` char(100) DEFAULT NULL,
  `sc_menu_parent` int(11) NOT NULL DEFAULT '0',
  `sc_menu_seq` tinyint(4) NOT NULL DEFAULT '0',
  `sc_menu_title` char(50) DEFAULT NULL,
  `sc_function_id` int(11) NOT NULL DEFAULT '0',
  `sc_job_id` int(11) NOT NULL DEFAULT '0',
  `sc_menu_format_id` int(11) NOT NULL DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `sc_menu_trf_yn` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sc_menu_id`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `sc_menu_trf_yn` (`sc_menu_trf_yn`)
) ENGINE=InnoDB AUTO_INCREMENT=6005 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sc_menu`
--

LOCK TABLES `sc_menu` WRITE;
/*!40000 ALTER TABLE `sc_menu` DISABLE KEYS */;
INSERT INTO `sc_menu` VALUES (1,NULL,'',0,1,'Reservations  |',0,0,1,NULL,1),(2,NULL,'',0,4,'Contacts   |',0,0,2,NULL,1),(3,NULL,'',0,5,'Reports   |',0,0,3,NULL,1),(4,NULL,'',0,7,'Admin   |',0,0,4,NULL,1),(5,NULL,'',0,8,'Info',0,0,5,NULL,1),(7,NULL,'',1,1,'Find Reservation',52,19,7,NULL,1),(8,NULL,'',1,3,'Availability Calendar',50,20,7,NULL,1),(9,NULL,'',217,2,'Data Transfer',0,0,9,NULL,1),(10,145,'',218,7,'User Access',65,144,9,NULL,1),(12,NULL,'',218,1,'Business Structure',61,172,12,NULL,1),(13,NULL,'',218,2,'Code Tables',0,0,0,NULL,1),(14,76,'',272,1,'Country',57,75,13,NULL,1),(15,82,'',53,2,'Currency',57,81,13,NULL,1),(16,NULL,'',1,4,'Occupancy Calendar',51,29,7,NULL,1),(17,NULL,'',1,12,'Reports',0,0,0,NULL,1),(18,NULL,'',17,15,'Arrivals Departures',67,202,8,NULL,1),(19,NULL,'',17,50,'Standard Reports',53,201,15,NULL,1),(23,NULL,'showContactType()',2,1,'Add Contact',54,43,6,NULL,1),(24,NULL,'',2,2,'Find Contact',54,42,6,NULL,1),(25,NULL,'',161,4,'Login Statistics',60,123,8,NULL,1),(26,NULL,'dataTransfer()',9,1,'Run Data Transfer',64,128,11,NULL,1),(27,NULL,'',9,2,'Review Data Transfer',64,126,0,NULL,1),(29,NULL,'',218,3,'Customisation',62,173,0,NULL,1),(30,108,'',218,4,'Defaults',63,105,0,NULL,1),(32,88,'',258,3,'Phone Type',57,87,13,NULL,1),(33,502,'',258,1,'Comms Preference',57,501,13,NULL,1),(34,508,'',258,2,'Name Suffix',57,507,13,NULL,1),(35,514,'',258,4,'Title',57,513,13,NULL,1),(38,NULL,'',3,8,'Reservation',0,0,8,NULL,1),(39,NULL,'window.visitWebsite();',5,1,'Visit Our Website',0,0,10,NULL,1),(41,NULL,'openHelp()',5,1,'Help',0,0,14,NULL,1),(42,NULL,'showAbout()',5,2,'About ResRequest',0,0,0,NULL,1),(43,NULL,'',2,4,'Reports',0,0,0,NULL,1),(44,NULL,'',43,1,'Contact',53,537,16,NULL,1),(45,NULL,'',38,80,'Standard Reports',53,201,15,NULL,1),(48,NULL,'',267,1,'Contact',53,537,0,NULL,1),(49,NULL,'',38,20,'Arrivals Departures',67,202,15,NULL,1),(50,NULL,'',3,11,'Mail',53,185,9,NULL,1),(52,NULL,'openPopup(\'email_form.php?email_address=!censysEmail!\',595,363)',5,4,'ResRequest Support',0,0,0,NULL,1),(53,NULL,'',13,2,'Financials',0,0,13,NULL,1),(54,541,'',53,11,'Rate Type',58,540,18,NULL,1),(55,547,'',53,10,'Rate Periods',58,546,18,NULL,1),(56,553,NULL,53,12,'Tax Rate',58,552,18,NULL,1),(57,559,NULL,53,1,'Bank Cash Point',58,558,18,NULL,1),(58,565,NULL,53,4,'Extras',58,564,18,NULL,1),(59,571,NULL,53,8,'Rate Component',58,570,18,NULL,1),(60,577,NULL,53,7,'Payment Plans',58,576,18,NULL,1),(62,595,NULL,53,6,'Payment Method',58,594,18,NULL,1),(64,618,NULL,53,3,'Daily Exchange',58,617,18,NULL,1),(65,NULL,NULL,17,40,'Provisional Expiry',53,204,8,NULL,1),(66,NULL,NULL,38,60,'Provisional Expiry',53,204,15,NULL,1),(67,NULL,NULL,38,31,'Consultant',71,203,15,NULL,1),(68,NULL,NULL,17,21,'Consultant',71,203,15,NULL,1),(69,NULL,NULL,106,14,'Received Payments',53,654,15,NULL,1),(70,NULL,NULL,166,14,'Received Payments',53,654,15,NULL,1),(72,NULL,NULL,17,55,'Update',55,205,15,NULL,1),(74,NULL,NULL,38,90,'Update',55,205,15,NULL,1),(75,687,NULL,272,3,'Source',57,686,15,NULL,1),(80,NULL,'',217,3,'Master Change',75,0,9,NULL,1),(81,NULL,'dbStatusChange(1)',80,1,'Web as Master',75,701,11,NULL,1),(82,NULL,'dbStatusChange(2)',80,1,'ResOffice as Master',75,702,11,NULL,1),(83,NULL,'dbStatusChange(3)',80,1,'Set to Slave',75,703,11,NULL,1),(84,NULL,'dbStatusChange(4)',80,1,'Set to Master',75,704,11,NULL,1),(100,NULL,'',0,3,'Financials |',0,0,2,NULL,1),(101,NULL,'',6003,1,'Record Payments',69,299,6,NULL,1),(102,NULL,'',1,6,'Reservation Requests',70,650,7,NULL,1),(103,192,'',272,4,'Standard Notes',57,194,13,NULL,1),(105,NULL,NULL,159,1,'Extras',59,200,15,NULL,1),(106,NULL,NULL,3,6,'Financials',0,0,15,NULL,1),(107,NULL,NULL,106,15,'Revenue',76,705,15,NULL,1),(108,NULL,NULL,106,13,'Payments Due',74,706,15,NULL,1),(110,NULL,NULL,106,5,'Components',74,709,15,NULL,1),(111,NULL,NULL,106,4,'Commission',77,207,15,NULL,1),(112,NULL,NULL,3,10,'Business Structure',78,715,15,NULL,1),(113,717,NULL,260,3,'Guest Type',57,716,15,NULL,1),(114,NULL,NULL,1,5,'Rooming Calendar',81,234,7,NULL,1),(115,723,NULL,53,5,'Extras Category',58,722,15,NULL,1),(117,NULL,'',0,2,'Property  |',0,0,2,NULL,1),(118,NULL,'',117,1,'Extras Quick Entry',79,734,2,NULL,1),(119,NULL,NULL,161,5,'Review Master Changes',75,714,8,NULL,1),(120,NULL,NULL,80,4,'Review Changes',75,714,0,NULL,1),(121,NULL,'',1,2,'Quick Availability Search',50,693,7,NULL,1),(124,NULL,'',1,7,'_',0,0,7,NULL,1),(125,NULL,NULL,106,10,'Folio Invoice',76,233,15,NULL,1),(126,NULL,'openPaxMenu()',17,35,'PAX Count (today)',95,736,15,NULL,1),(127,NULL,'openPaxMenu()',38,50,'PAX Count (today)',95,736,15,NULL,1),(128,NULL,'',17,30,'PAX Analysis',66,738,15,NULL,1),(129,NULL,'',38,40,'PAX Analysis',66,738,15,NULL,1),(130,237,'',147,3,'POS',57,236,15,NULL,0),(131,NULL,'',218,5,'Environment Setup',87,744,9,NULL,1),(132,NULL,'',38,70,'Rooming',67,742,15,NULL,1),(133,NULL,'',17,45,'Rooming',67,742,8,NULL,1),(134,NULL,NULL,106,2,'Bed Nights',53,246,8,NULL,1),(135,759,'',272,2,'Custom Notes',89,758,13,NULL,1),(136,NULL,NULL,106,18,'Sales by Res Group',76,249,15,NULL,1),(137,NULL,NULL,106,19,'Sales by Reservation',76,250,15,NULL,1),(138,NULL,NULL,106,17,'Sales by Folio',76,251,15,NULL,1),(139,NULL,NULL,117,2,'Rooming Calendar',81,234,7,NULL,1),(140,NULL,'',117,7,'Reports',0,0,3,NULL,1),(141,NULL,'',140,2,'Arrivals Departures',67,202,15,NULL,1),(142,NULL,NULL,140,3,'Extras',59,200,15,NULL,1),(143,NULL,'',140,7,'PAX Analysis',66,738,15,NULL,1),(144,NULL,'openPaxMenu()',140,8,'PAX Count (today)',95,736,15,NULL,1),(145,NULL,'',140,10,'Rooming',67,742,15,NULL,1),(146,NULL,NULL,140,12,'Update',55,205,15,NULL,1),(147,NULL,'',13,3,'Integration',0,0,13,NULL,1),(148,253,'',147,4,'Telephone',57,252,15,NULL,0),(150,NULL,NULL,140,11,'Telephone',90,257,15,NULL,1),(151,NULL,'',3,7,'Property',0,0,8,NULL,1),(152,NULL,'',151,2,'Arrivals Departures',67,202,15,NULL,1),(153,NULL,NULL,151,3,'Extras',59,200,15,NULL,1),(154,NULL,'',151,7,'PAX Analysis',66,738,15,NULL,1),(155,NULL,'openPaxMenu()',151,8,'PAX Count (today)',95,736,15,NULL,1),(156,NULL,'',151,10,'Rooming',67,742,15,NULL,1),(157,NULL,NULL,151,12,'Update',55,205,15,NULL,1),(158,NULL,NULL,151,11,'Telephone',90,257,15,NULL,1),(159,NULL,NULL,3,5,'Extras',0,0,15,NULL,1),(160,NULL,NULL,159,3,'Extras Audit',93,260,15,NULL,1),(161,NULL,NULL,3,3,'Audit',0,0,15,NULL,1),(162,NULL,NULL,161,2,'Extras Audit',93,260,15,NULL,1),(163,NULL,NULL,166,12,'Payments by Group',94,261,15,NULL,1),(164,NULL,NULL,100,2,'Processes',0,0,15,NULL,1),(165,NULL,NULL,164,3,'Generate Invoices',76,233,15,NULL,1),(166,NULL,NULL,100,4,'Reports',0,0,15,NULL,1),(167,NULL,NULL,166,15,'Revenue',76,705,15,NULL,1),(168,NULL,NULL,166,13,'Payments Due',74,706,15,NULL,1),(169,NULL,NULL,166,2,'Bed Nights',53,246,8,NULL,1),(170,NULL,NULL,166,5,'Components',74,709,15,NULL,1),(171,NULL,NULL,166,4,'Commission',77,207,15,NULL,1),(172,NULL,NULL,166,10,'Folio Invoice',76,233,15,NULL,1),(173,NULL,NULL,166,18,'Sales by Res Group',76,249,15,NULL,1),(174,NULL,NULL,166,19,'Sales by Reservation',76,250,15,NULL,1),(175,NULL,NULL,166,17,'Sales by Folio',76,251,15,NULL,1),(176,NULL,'openPopup(\'reservation.php?527\',350,360)',254,1,'Change Password',66,527,4,NULL,1),(178,NULL,NULL,38,30,'Availability',96,262,15,NULL,0),(179,NULL,'cacheClear()',217,1,'Clear System Cache',66,263,11,NULL,1),(180,NULL,NULL,38,35,'Occupancy',97,264,15,NULL,0),(181,NULL,NULL,106,12,'Payments by Group',94,261,15,NULL,1),(182,NULL,NULL,17,20,'Availability',96,262,15,NULL,0),(183,NULL,NULL,17,25,'Occupancy',97,264,15,NULL,0),(184,NULL,NULL,17,10,'Allocations List',99,266,15,NULL,0),(185,NULL,NULL,38,11,'Allocations List',99,266,15,NULL,0),(186,NULL,NULL,38,12,'Allocation Summary',98,265,15,NULL,0),(187,NULL,NULL,17,12,'Allocation Summary',98,265,15,NULL,0),(189,NULL,NULL,100,1,'GL Interface',100,276,15,NULL,0),(190,NULL,NULL,166,11,'Payment Item',94,291,15,NULL,1),(191,NULL,NULL,106,11,'Payment Item',94,291,15,NULL,1),(192,NULL,'',140,1,'Accommodation Chart',67,292,15,NULL,1),(193,NULL,'',151,1,'Accommodation Chart',67,292,15,NULL,1),(194,NULL,'',117,4,'Room Management',0,0,3,NULL,1),(195,NULL,NULL,194,1,'Rooming Calendar',81,234,7,NULL,1),(196,NULL,'',194,2,'Reports',0,0,3,NULL,1),(197,NULL,'',196,3,'Rooming',67,742,15,NULL,1),(198,NULL,'',196,1,'Accommodation Chart',67,292,15,NULL,1),(199,NULL,'',117,3,'_',0,0,15,NULL,1),(200,NULL,'',117,6,'_',0,0,15,NULL,1),(201,NULL,'',100,3,'_',0,0,15,NULL,1),(202,NULL,'',2,3,'_',0,0,15,NULL,1),(203,NULL,'',1,8,'Reservation Creation',0,0,7,NULL,1),(204,NULL,'',1,9,'Reservation Management',0,0,7,NULL,1),(205,NULL,'',1,10,'Room Management',0,0,7,NULL,1),(206,NULL,'',1,11,'_',0,0,7,NULL,1),(207,NULL,'',203,1,'Availability Calendar',50,20,7,NULL,1),(208,NULL,'',203,3,'Reservation Requests',70,650,7,NULL,1),(209,NULL,'',203,2,'Quick Availability Search',50,693,7,NULL,1),(210,NULL,'',204,1,'Find Reservation',52,19,7,NULL,1),(211,NULL,'',204,2,'Occupancy Calendar',51,29,7,NULL,1),(212,NULL,NULL,205,1,'Rooming Calendar',81,234,7,NULL,1),(213,NULL,'dataTransfer()',4,1,'Run Data Transfer',64,128,11,NULL,1),(214,NULL,'',4,4,'_',0,0,7,NULL,1),(215,NULL,NULL,4,2,'Business Structure',61,172,15,NULL,1),(216,NULL,'',4,3,'Customisation',62,173,0,NULL,1),(217,NULL,'',4,6,'Operations',0,0,9,NULL,1),(218,NULL,'',4,7,'Setup',0,0,9,NULL,1),(220,NULL,NULL,17,27,'Overbooking',104,294,15,NULL,0),(221,NULL,NULL,38,37,'Overbooking',104,294,15,NULL,0),(222,NULL,NULL,164,4,'Process Transactions',66,295,15,NULL,1),(224,NULL,NULL,106,16,'Sales Analysis',105,304,15,NULL,1),(225,NULL,NULL,166,16,'Sales Analysis',105,304,15,NULL,1),(226,NULL,NULL,159,2,'Extras (Custom)',59,306,15,NULL,1),(227,NULL,NULL,140,4,'Extras (Custom)',59,306,15,NULL,1),(228,NULL,NULL,151,4,'Extras (Custom)',59,306,15,NULL,1),(229,NULL,NULL,106,1,'Age Analysis',106,309,15,NULL,1),(230,NULL,NULL,166,1,'Age Analysis',106,309,15,NULL,1),(231,NULL,NULL,106,3,'Cash Flow Forecast',107,310,15,NULL,1),(232,NULL,NULL,166,3,'Cash Flow Forecast',107,310,15,NULL,1),(233,NULL,'',3,2,'_',0,0,15,NULL,1),(234,NULL,'favourites',3,1,'My Favourites',0,0,15,NULL,1),(235,NULL,'',140,6,'Operations Chart',109,312,15,NULL,1),(236,NULL,'',151,6,'Operations Chart',109,312,15,NULL,1),(237,NULL,'',196,2,'Operations Chart',109,312,15,NULL,1),(238,314,NULL,260,1,'Guest Profile',112,313,15,NULL,0),(239,323,NULL,260,2,'Guest Tripsheet',113,322,15,NULL,0),(240,NULL,NULL,43,3,'Guest History',111,336,15,NULL,0),(241,NULL,NULL,140,5,'Guest History',111,336,15,NULL,0),(242,NULL,NULL,117,5,'Guest Management',0,0,0,NULL,0),(243,NULL,NULL,242,2,'Rooming Calendar',81,234,4,NULL,0),(244,NULL,NULL,242,1,'Guest Survey',0,0,15,NULL,0),(245,NULL,NULL,244,1,'Run Survey Batch',115,345,4,NULL,0),(246,NULL,NULL,244,2,'Review Survey Batches',115,347,4,NULL,0),(247,NULL,'window.visitOnlineSurvey();',244,3,'Go to Online Survey',0,0,4,NULL,0),(248,338,NULL,147,1,'Guest Survey',114,337,15,NULL,0),(249,NULL,'window.visitAnalytics();',161,3,'Go to Google Analytics',0,0,15,NULL,1),(250,NULL,'',242,3,'Reports',0,0,0,NULL,1),(251,NULL,NULL,250,1,'Guest History',111,336,15,NULL,0),(252,NULL,NULL,151,5,'Guest History',111,336,15,NULL,0),(253,NULL,NULL,161,1,'API Audit',116,352,4,NULL,0),(254,NULL,NULL,0,6,'Options |',0,0,19,NULL,1),(255,NULL,'openPreferences(350,360)',254,2,'My Preferences',117,780,20,NULL,1),(256,396,'',53,9,'Rate Group',58,395,18,NULL,1),(257,NULL,NULL,13,1,'Contacts',0,0,13,NULL,0),(258,NULL,NULL,257,1,'Contact Profile',0,0,13,NULL,0),(259,NULL,NULL,257,2,'CRM',0,0,13,NULL,0),(260,NULL,NULL,257,3,'Guest Profile',0,0,13,NULL,0),(261,NULL,NULL,259,1,'Events',0,0,13,NULL,0),(262,373,NULL,259,2,'Sales Profile',120,374,15,NULL,0),(263,356,NULL,261,1,'Event Action',119,355,15,NULL,0),(264,362,NULL,261,2,'Event Tag',119,361,15,NULL,0),(265,368,NULL,261,3,'Events',119,367,15,NULL,0),(266,NULL,NULL,43,2,'CRM (Custom)',122,394,15,NULL,0),(267,NULL,NULL,3,4,'Contacts',0,0,13,NULL,0),(268,NULL,NULL,267,2,'CRM (Custom)',122,394,15,NULL,0),(270,409,'',273,1,'Add Rates',68,409,0,NULL,1),(271,411,'',53,12,'Tax Group',58,410,18,NULL,1),(272,NULL,NULL,13,4,'Other',0,0,13,NULL,0),(273,NULL,NULL,218,6,'Rates',0,0,9,NULL,0),(274,NULL,NULL,164,5,'Process Debtors',100,1000,15,NULL,0),(275,1002,NULL,147,2,'Payment Gateway',126,1001,15,NULL,0),(276,2002,NULL,273,3,'Rate Sheet',68,2002,0,NULL,1),(277,NULL,NULL,106,7,'Debtors Analysis',128,2003,15,NULL,1),(278,NULL,NULL,166,7,'Debtors Analysis',128,2003,15,NULL,1),(279,NULL,NULL,106,20,'Tax Analysis',127,2004,15,NULL,1),(280,NULL,NULL,166,20,'Tax Analysis',127,2004,15,NULL,1),(281,NULL,NULL,140,9,'Room Discrepancy',1000,1011,15,NULL,1),(282,NULL,NULL,151,9,'Room Discrepancy',1000,1011,15,NULL,1),(283,NULL,NULL,106,8,'Financial Analysis (Day)',1001,1014,15,NULL,1),(284,NULL,NULL,106,9,'Financial Analysis (Folio)',1001,1015,15,NULL,1),(285,NULL,NULL,166,8,'Financial Analysis (Day)',1001,1014,15,NULL,1),(286,NULL,NULL,166,9,'Financial Analysis (Folio)',1001,1015,15,NULL,1),(287,NULL,NULL,106,6,'Customer Statement',2000,2008,15,NULL,1),(288,NULL,NULL,166,6,'Customer Statement',2000,2008,15,NULL,1),(289,2010,NULL,273,4,'Specials',2001,2010,0,NULL,1),(290,NULL,NULL,161,0,'Audit Trail',6000,6000,15,NULL,0),(291,NULL,NULL,267,3,'Guest History',111,336,15,NULL,0),(3002,NULL,NULL,3,12,'All Profiles',3002,3002,9,NULL,1),(3005,NULL,NULL,147,5,'Wetu Mapping',57,3005,9,NULL,1),(6002,NULL,NULL,1,7,'Block Templates',6007,6007,7,NULL,0),(6003,NULL,NULL,164,1,'Record Payment',0,0,15,NULL,1),(6004,NULL,'',6003,2,'Credit Card Payment',1002,1021,6,NULL,1);
/*!40000 ALTER TABLE `sc_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sc_menu_format`
--

DROP TABLE IF EXISTS `sc_menu_format`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sc_menu_format` (
  `sc_menu_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `sc_menu_format_desc` text,
  `sc_menu_format_width` int(11) NOT NULL DEFAULT '0',
  `sc_menu_format_height` int(11) NOT NULL DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `sc_menu_format_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sc_menu_format_id`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `sc_menu_format_trf_yn` (`sc_menu_format_trf_yn`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sc_menu_format`
--

LOCK TABLES `sc_menu_format` WRITE;
/*!40000 ALTER TABLE `sc_menu_format` DISABLE KEYS */;
INSERT INTO `sc_menu_format` VALUES (1,'Reservation Head',72,15,NULL,1),(2,'Contact Head',60,15,NULL,1),(3,'Report Head',55,15,NULL,1),(4,'Admin Head',90,15,NULL,1),(5,'Info Head',80,15,NULL,1),(6,'Contact Children',90,18,NULL,1),(7,'Reservation children',103,18,NULL,1),(8,'Reports Children',87,18,NULL,1),(9,'Admin Children',110,30,NULL,1),(10,'Info Children',95,18,NULL,1),(11,'Data Transfer',110,18,NULL,1),(12,'System Setup',80,18,NULL,1),(13,'Code Tables',95,18,NULL,1),(14,'Help',85,18,NULL,1),(15,'Reservation Reports',87,18,NULL,1),(16,'Contact Report',65,18,NULL,1),(17,'Res Report',85,18,NULL,1),(18,'Financials',100,18,NULL,1),(19,'Preferences Head',90,15,NULL,1),(20,'Preferences Children',100,15,NULL,1);
/*!40000 ALTER TABLE `sc_menu_format` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sc_transfer`
--

DROP TABLE IF EXISTS `sc_transfer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sc_transfer` (
  `sc_transfer_id` int(11) NOT NULL AUTO_INCREMENT,
  `sc_trf_message` text NOT NULL,
  `sc_trf_status` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`sc_transfer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1063 DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sc_transfer`
--

LOCK TABLES `sc_transfer` WRITE;
/*!40000 ALTER TABLE `sc_transfer` DISABLE KEYS */;
INSERT INTO `sc_transfer` VALUES (52,'Transmission completed. You may now disconnect from the Internet.',0),(1004,'Error zipping send transfer files',30),(1006,'Please connect to the internet and then continue send transfer',30),(1010,'Logging in to FTP server failed',30),(1011,'Uploading send transfer package failed',30),(1012,'Unable to trigger send transfer import on web',30),(1013,'Awaiting send transfer report package from web',10),(1014,'Web: The send transfer package is corrupt',30),(1016,'Web: Error extracting send transfer data to file',30),(1019,'Web: Error importing send transfer data',30),(1022,'Web: Error extracting send transfer report data to file',30),(1023,'Web: Error zipping send transfer report files',30),(1026,'Web: Import successful, send transfer report generated',30),(1028,'Error downloading send transfer report package',30),(1029,'The send transfer report package is corrupt',30),(1033,'Send transfer completed successfully',0),(1035,'Please connect to the internet and then continue receive transfer',30),(1038,'Unable to trigger receive transfer export on web',30),(1039,'Awaiting receive transfer package from web',10),(1040,'Web: Error creating receive transfer record',40),(1041,'Web: Error extracting receive transfer changes to file',30),(1043,'Web: Error zipping receive transfer files',30),(1045,'Web: Export successful, receive transfer package generated',10),(1047,'Error downloading receive transfer package',30),(1048,'The receive transfer package is corrupt',30),(1051,'Error importing receive transfer data',40),(1054,'Receive transfer completed successfully',0),(1055,'User aborted transfer',30),(1056,'The transfer has been completed under abnormal conditions. For assistance please save the LOG file and email it to support@amanzi.com',40),(1058,'Send transfer import failed',30),(1060,'Unable to import the send transfer report',40),(1062,'System versions differ',30);
/*!40000 ALTER TABLE `sc_transfer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tc_table`
--

DROP TABLE IF EXISTS `tc_table`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tc_table` (
  `tc_table_id` int(11) NOT NULL AUTO_INCREMENT,
  `tc_table_name` varchar(50) NOT NULL DEFAULT '',
  `tc_table_seq` mediumint(9) NOT NULL DEFAULT '0',
  `tc_table_sys_code` tinyint(1) NOT NULL DEFAULT '0',
  `tc_table_key_ind` tinyint(4) NOT NULL DEFAULT '0',
  `tc_table_user_facing_yn` tinyint(1) DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `tc_table_trf_yn` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tc_table_id`),
  UNIQUE KEY `tc_table_name` (`tc_table_name`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `tc_table_trf_yn` (`tc_table_trf_yn`)
) ENGINE=InnoDB AUTO_INCREMENT=216 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tc_table`
--

LOCK TABLES `tc_table` WRITE;
/*!40000 ALTER TABLE `tc_table` DISABLE KEYS */;
INSERT INTO `tc_table` VALUES (1,'ac_accomm_type',25,0,0,0,'',1),(2,'ad_user_log',45,0,0,0,'',1),(3,'pr_agent',20,0,1,0,'',1),(4,'pr_business',20,0,1,0,'',1),(5,'pr_persona',15,0,0,1,'',1),(6,'pr_phone',20,0,0,1,'',1),(7,'pr_user',20,0,1,0,'',1),(10,'rf_comms_preference',5,0,0,0,'',1),(11,'rf_country',10,0,2,0,'',1),(12,'rf_currency',5,0,0,0,'',1),(13,'rf_name_suffix',5,0,2,0,'',1),(15,'rf_phone_type',5,0,2,0,'',1),(17,'rf_title',5,0,2,0,'',1),(18,'rf_default',35,0,1,0,'',1),(19,'rv_reservation',25,0,0,1,'',1),(20,'rv_reservation_item',30,0,0,0,'',1),(21,'tc_table',2,0,1,0,'',1),(23,'td_deletions',2,1,1,0,'',1),(24,'sc_accomm',30,0,1,0,'',1),(27,'sc_fun_group',10,0,1,0,'',1),(29,'sc_group',5,0,1,0,'',1),(32,'sc_user',30,0,1,0,'',1),(35,'em_mail',25,0,0,0,'',1),(36,'pr_link',25,0,0,0,'',1),(37,'rf_link_type',5,0,2,0,'',1),(38,'rf_mail',5,0,2,0,'',1),(40,'rf_reservation_status',5,0,1,0,'',1),(45,'ac_extra',10,0,0,0,'',1),(46,'ac_pay_item',10,0,0,0,'',1),(47,'ac_pay_plan',5,0,0,0,'',1),(49,'pr_agent_rate',25,0,0,0,'',1),(50,'pr_bus_bank',25,0,0,0,'',1),(51,'rf_bank',10,0,2,0,'',1),(52,'rf_default_rate',15,0,1,0,'',1),(53,'rf_exchange_rate',10,0,0,0,'',1),(55,'rf_mthd_pmnt',5,0,0,0,'',1),(56,'rf_tax_rate',5,0,0,0,'',1),(57,'rv_extra',30,0,0,0,'',1),(58,'rv_pay_plan_item',30,0,2,0,'',1),(59,'rv_payment',10,0,0,1,'',1),(60,'rv_payment_item',30,0,0,1,'',1),(61,'rv_res_item_comp',35,0,0,0,'',1),(62,'rf_custom',5,0,1,0,'',1),(63,'em_mail_log',30,0,0,0,'',1),(64,'rf_note',5,0,0,0,'',1),(65,'ad_db_status',25,0,0,0,'',1),(66,'ad_reservation',30,0,0,0,'',1),(67,'rf_source',5,0,0,0,'',1),(68,'ac_accomm_block',30,0,0,0,NULL,1),(69,'ac_accomm_room',30,0,0,0,NULL,1),(70,'ac_accomm_room_attr',35,0,0,0,NULL,1),(71,'ac_accomm_room_block',35,0,0,0,NULL,1),(72,'ac_extra_category',5,0,0,0,NULL,1),(73,'ac_extra_prop',25,0,0,0,NULL,1),(74,'fn_folio',40,0,0,0,NULL,1),(75,'fn_invoice',45,0,3,1,NULL,1),(76,'fn_invoice_item',50,0,0,0,NULL,1),(77,'pr_guest',20,0,1,0,NULL,1),(78,'rf_database',5,0,1,0,NULL,1),(79,'rf_db_business',10,0,1,0,NULL,1),(80,'rf_guest_type',5,0,0,0,NULL,1),(81,'rv_res_item_group',35,0,0,0,NULL,1),(82,'rv_res_item_guest',35,0,0,0,NULL,1),(83,'rv_reservation_guest',30,0,0,0,NULL,1),(84,'fn_ledger',25,0,0,0,NULL,1),(85,'tc_transfer',90,5,0,1,NULL,1),(86,'tc_transfer_table',90,5,0,0,NULL,1),(87,'ac_pos',15,0,0,0,NULL,1),(88,'rv_res_item_grp_status',40,0,0,0,NULL,1),(89,'pr_supplier',20,0,1,0,NULL,1),(90,'tc_res_update',80,2,1,0,NULL,1),(91,'fn_invoice_bank',50,0,0,0,NULL,1),(92,'rf_phone_extn',5,0,0,0,NULL,1),(93,'rv_phone',25,0,0,1,NULL,1),(94,'fn_invoice_note',50,0,0,0,NULL,1),(95,'rf_note_custom',10,0,0,0,NULL,1),(96,'rf_note_cust_item',15,0,0,0,NULL,1),(97,'rf_note_cust_default',15,0,0,0,NULL,1),(98,'rf_phone_prop_extra',25,0,0,0,NULL,1),(99,'rf_bank_env',15,0,0,0,NULL,1),(100,'fn_invoice_payment',50,0,0,0,NULL,1),(101,'rv_extra_prop',35,0,0,0,NULL,1),(103,'ac_extra_cat_inv',30,0,0,0,NULL,1),(104,'ac_extra_inv',30,0,0,0,NULL,1),(106,'fn_cost_centre',25,0,0,0,NULL,1),(107,'fn_debtor',25,0,0,0,NULL,1),(108,'fn_system',5,0,0,0,NULL,1),(109,'pr_persona_inv',30,0,0,0,NULL,1),(110,'rf_tax_inv',25,0,0,0,NULL,1),(111,'pf_object',5,0,0,0,NULL,1),(112,'pf_option',10,0,0,0,NULL,1),(113,'pf_field',15,0,0,0,NULL,1),(114,'zs_task',20,0,0,0,NULL,1),(115,'zs_schedule',25,0,0,0,NULL,1),(116,'zs_task_notify',25,0,0,0,NULL,1),(117,'zs_queue',30,0,0,0,NULL,1),(118,'zs_task_log',35,0,0,0,NULL,1),(119,'rf_bank_inv',30,0,0,0,NULL,1),(120,'fn_batch',25,0,3,1,NULL,1),(121,'fn_tran',45,0,0,1,NULL,1),(122,'fn_tran_item',50,0,0,0,NULL,1),(123,'fn_year',25,0,0,0,NULL,1),(124,'ad_batch',30,0,0,0,NULL,1),(125,'tr_rule',45,0,0,0,NULL,1),(126,'tr_rule_item',50,0,0,0,NULL,1),(128,'zg_account',5,0,0,0,NULL,1),(129,'zg_account_prop',25,0,0,0,NULL,1),(130,'zg_transfer',10,0,0,0,NULL,1),(131,'zg_transfer_guest',30,0,0,1,NULL,1),(132,'rf_obj_guest',5,0,0,0,NULL,1),(133,'rf_obj_guest_data',10,0,0,0,NULL,1),(134,'rf_obj_trip',5,0,0,0,NULL,1),(135,'rf_obj_trip_data',10,0,0,0,NULL,1),(136,'rf_obj_trip_prop',25,0,0,0,NULL,1),(137,'pr_guest_obj_data',25,0,0,0,NULL,1),(138,'rv_trip_obj_data',30,0,0,0,NULL,1),(139,'rv_note',30,0,0,0,NULL,1),(140,'pr_event',15,0,0,0,NULL,1),(141,'pr_event_persona',20,0,0,0,NULL,1),(142,'pr_sales_obj_data',20,0,0,0,NULL,1),(143,'rc_action',10,0,0,0,NULL,1),(144,'rc_event',10,0,0,0,NULL,1),(145,'rc_event_tag',15,0,0,0,NULL,1),(146,'rc_obj_sales',10,0,0,0,NULL,1),(147,'rc_obj_sales_data',15,0,0,0,NULL,1),(148,'rc_tag',10,0,0,0,NULL,1),(149,'zg_transfer_guest_prop',35,0,0,0,NULL,1),(159,'rt_component',10,0,0,0,NULL,0),(160,'rt_component_inv',30,0,0,0,NULL,0),(161,'rt_period',5,0,0,0,NULL,0),(162,'rt_period_dates',10,0,0,0,NULL,0),(163,'rt_rate',30,0,0,0,NULL,0),(164,'rt_rate_comp_grp',40,0,0,0,NULL,0),(165,'rt_rate_component',35,0,0,0,NULL,0),(166,'rt_rate_group',5,0,0,0,NULL,0),(167,'rt_rate_grp_amt',35,0,0,0,NULL,0),(168,'rt_rate_type',10,0,0,0,NULL,0),(169,'rt_tax_group',5,0,0,0,NULL,0),(170,'rt_tax_group_item',10,0,0,0,NULL,0),(171,'rv_res_item_comp_tax',40,0,0,0,NULL,0),(172,'rv_res_item_comp_rate_grp',40,0,0,0,NULL,0),(173,'rv_res_item_rate_grp',35,0,0,0,NULL,0),(174,'fn_invoice_item_tax',55,0,0,0,NULL,0),(175,'ac_pos_map',20,0,0,0,NULL,0),(176,'ac_pos_map_accomm',30,0,0,0,NULL,0),(177,'fn_db_business',25,0,0,0,NULL,0),(178,'pg_account',20,0,0,0,NULL,0),(179,'pg_acc_business',25,0,0,0,NULL,0),(180,'pg_acc_currency',25,0,0,0,NULL,0),(181,'pg_acc_method',25,0,0,0,NULL,0),(182,'pg_acc_obj_data',30,0,0,0,NULL,0),(183,'pg_method',20,0,0,0,NULL,0),(184,'pg_type',15,0,0,0,NULL,0),(185,'pg_type_obj',20,0,0,0,NULL,0),(186,'pg_type_obj_data',25,0,0,0,NULL,0),(187,'rv_payment_gateway',30,0,0,0,NULL,0),(188,'fn_option_data',25,0,0,0,NULL,1),(189,'fn_option',20,0,0,0,NULL,1),(190,'rf_currency_inv',25,0,0,0,NULL,1),(191,'pr_bus_tax',25,0,0,0,NULL,1),(192,'sp_special',25,0,0,0,NULL,1),(193,'sp_accomm_type',30,0,0,0,NULL,1),(194,'sp_prop_rate_group',30,0,0,0,NULL,1),(195,'sp_rate_group_benefit',30,0,0,0,NULL,1),(196,'sp_rate_group_qualify',30,0,0,0,NULL,1),(197,'sp_special_period',30,0,0,0,NULL,1),(198,'sp_special_rate_type',30,0,0,0,NULL,1),(199,'rv_special',30,0,0,0,NULL,1),(200,'ad_res_detail',35,0,0,0,'',1),(201,'bl_block',40,0,0,1,'',1),(202,'bl_block_period',35,0,0,0,'',1),(203,'bl_block_itinerary',30,0,0,0,'',1),(204,'fn_invoice_special',35,0,0,0,'',1),(205,'rv_payment_gateway_folio',35,0,0,0,NULL,0),(206,'ad_useraccess',30,0,0,0,'',1),(207,'ad_useraccess_detail',35,0,0,0,'',1),(208,'rv_extra_tax',40,0,0,0,NULL,0),(209,'tc_sequence',90,0,1,0,NULL,0),(210,'ad_persona',25,0,0,0,NULL,0),(211,'ad_persona_detail',30,0,0,0,NULL,0),(212,'re_reminder',30,0,0,0,NULL,0),(213,'re_reminder_persona',35,0,0,0,NULL,0),(214,'re_reminder_status',25,0,1,0,NULL,0),(215,'re_reminder_log',35,0,0,0,NULL,0);
/*!40000 ALTER TABLE `tc_table` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pf_object`
--

DROP TABLE IF EXISTS `pf_object`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pf_object` (
  `pf_object_db` char(2) NOT NULL DEFAULT '',
  `pf_object_id` int(11) NOT NULL,
  `pf_object_ix` varchar(36) NOT NULL,
  `pf_object_name` varchar(50) DEFAULT NULL,
  `pf_object_note` varchar(255) DEFAULT NULL,
  `sc_job_id` int(11) DEFAULT NULL,
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `pf_object_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pf_object_ix`),
  UNIQUE KEY `pf_object_ix` (`pf_object_ix`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `pf_object_trf_yn` (`pf_object_trf_yn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pf_object`
--

LOCK TABLES `pf_object` WRITE;
/*!40000 ALTER TABLE `pf_object` DISABLE KEYS */;
INSERT INTO `pf_object` VALUES ('RS',1,'RS1','room_chart','Rooming chart profiles',292,NULL,1),('RS',10,'RS10','sales_analysis_report','Sales Analysis',304,NULL,1),('RS',1000,'RS1000','discrepancy_report','Room Discrepancy Report',1011,NULL,1),('RS',1001,'RS1001','financial_analysis_day','Financial Analysis Report (Day)',1014,NULL,1),('RS',1002,'RS1002','financial_analysis_folio','Financial Analysis Report (Folio)',1015,NULL,1),('RS',1003,'RS1003','debtor_report','Debtor maintenance (Financial interface)',1000,NULL,1),('RS',1004,'RS1004','open_and_close_out_rooms','Open And Close Out Rooms',1026,NULL,1),('RS',1005,'RS1005','occupancy_calendar','Occupancy Calendar',29,NULL,1),('RS',106,'RS106','availability_chart','Availability Chart Report',262,NULL,1),('RS',107,'RS107','occupancy_chart','Occupancy Chart Report',264,NULL,1),('RS',108,'RS108','arrDep_report','Arrival/Departure report profile',202,NULL,1),('RS',109,'RS109','consultant_report','Consultant Report Profile',203,NULL,1),('RS',11,'RS11','payments_due_report','Payments Due',706,NULL,1),('RS',110,'RS110','provisional_report','Provisional Report Profile',204,NULL,1),('RS',111,'RS111','update_report','Update Report Profile',205,NULL,1),('RS',112,'RS112','standard_report','Standard Report Profile',201,NULL,1),('RS',113,'RS113','crm_custem_report','CRM Custom Report',394,NULL,0),('RS',12,'RS12','sales_by_group','Sales by Reservation Group Report',249,NULL,1),('RS',13,'RS13','sales_by_reservation','Sales by Reservation Report',250,NULL,1),('RS',14,'RS14','sales_by_folio','Sales by Folio Report',251,NULL,1),('RS',15,'RS15','guest_history','Guest History Report',336,NULL,1),('RS',16,'RS16','survey_report','Survey Report',345,NULL,1),('RS',17,'RS17','operation_chart','Operations Chart',312,NULL,1),('RS',18,'RS18','overbooking_chart','Overbooking Chart',294,NULL,1),('RS',19,'RS19','pax_report','PAX Analysis Report',738,NULL,1),('RS',2,'RS2','revenue_report','Revenue Report',705,NULL,1),('RS',20,'RS20','allocation_report','Allocation List Report',266,NULL,1),('RS',2000,'RS2000','edit_rates','Edit Rates',401,NULL,1),('RS',2001,'RS2001','add_rates','Add Rates',409,NULL,1),('RS',2002,'RS2002','rate_sheet','Rate Sheet',2002,NULL,1),('RS',2003,'RS2003','debtors_analysis_report','Debtors Analysis',2003,NULL,1),('RS',2004,'RS2004','tax_analysis_report','Tax Analysis',2004,NULL,1),('',2005,'RS2005','customer_statement','Customer Statement Report',2008,NULL,1),('RS',21,'RS21','allocation_summary_report','Allocation Summary Report',265,NULL,1),('RS',22,'RS22','folio_invoice_report','Folio Invoice Report',233,NULL,1),('RS',23,'RS23','payment_received_report','Payments Received Report',654,NULL,1),('RS',24,'RS24','payment_group_report','Payments By Group Report',261,NULL,1),('RS',25,'RS25','payment_item_report','Payment Item Report',291,NULL,1),('RS',26,'RS26','audit_api_report','API Audit Report',352,NULL,1),('RS',27,'RS27','user_preferences','User Preferences',780,NULL,1),('RS',28,'RS28','email_templates','Email Templates',782,NULL,1),('RS',29,'RS29','rooming_calendar','Rooming calendar',234,NULL,1),('RS',3,'RS3','email_document','Email profile for the reservation summary document',NULL,NULL,1),('RS',4,'RS4','email_proforma','Email profile for the reservation folio document',NULL,NULL,1),('RS',5,'RS5','email_invoice','Email profile for the reservation invoice document',NULL,NULL,1),('RS',6,'RS6','bed_night_report','Bed Night Report',246,NULL,1),('RS',6000,'RS6000','audit_trail_report','Audit Trail Report',6000,NULL,1),('RS',7,'RS7','extra_report','Extra Report',306,NULL,1),('RS',8,'RS8','transaction_report','Transaction maintenance',295,NULL,1),('RS',9,'RS9','component_report','Component Report',709,NULL,1);
/*!40000 ALTER TABLE `pf_object` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rf_link_type`
--

DROP TABLE IF EXISTS `rf_link_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rf_link_type` (
  `rf_link_type_db` char(2) NOT NULL DEFAULT '0',
  `rf_link_type_id` int(11) NOT NULL DEFAULT '0',
  `rf_link_type_desc` text,
  `rf_link_type_lock_yn` tinyint(1) NOT NULL DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `rf_link_type_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rf_link_type_db`,`rf_link_type_id`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `rf_link_type_trf_yn` (`rf_link_type_trf_yn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rf_link_type`
--

LOCK TABLES `rf_link_type` WRITE;
/*!40000 ALTER TABLE `rf_link_type` DISABLE KEYS */;
INSERT INTO `rf_link_type` VALUES ('RS',1,'Business',1,'',1),('RS',2,'Agent',1,'',1),('RS',3,'Guest to guest',1,NULL,1),('RS',4,'Guest to agent',1,NULL,1);
/*!40000 ALTER TABLE `rf_link_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pg_method`
--

DROP TABLE IF EXISTS `pg_method`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pg_method` (
  `pg_method_db` char(2) NOT NULL DEFAULT '',
  `pg_method_id` int(11) NOT NULL,
  `pg_method_ix` varchar(36) NOT NULL,
  `pg_method_name` varchar(50) NOT NULL DEFAULT '',
  `pg_method_note` text,
  `pg_method_image` varchar(50) NOT NULL DEFAULT '',
  `pg_method_inactive_yn` tinyint(1) NOT NULL DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `pg_method_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pg_method_ix`),
  UNIQUE KEY `pg_method_ix` (`pg_method_ix`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `pg_method_trf_yn` (`pg_method_trf_yn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pg_method`
--

LOCK TABLES `pg_method` WRITE;
/*!40000 ALTER TABLE `pg_method` DISABLE KEYS */;
INSERT INTO `pg_method` VALUES ('RS',1,'RS1','AMEX','Pay with an American Express card','amex.gif',0,NULL,0),('RS',2,'RS2','Diners Club','Pay with a Diners Club International card','dinersclub.gif',0,NULL,0),('RS',3,'RS3','Mastercard','Pay with a Mastercard','mastercard.gif',0,NULL,0),('RS',4,'RS4','Paypal','Pay with a Paypal account','paypal.gif',0,NULL,0),('RS',5,'RS5','VISA','Pay with American Express card','visa.gif',0,NULL,0);
/*!40000 ALTER TABLE `pg_method` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pg_type`
--

DROP TABLE IF EXISTS `pg_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pg_type` (
  `pg_type_db` char(2) NOT NULL DEFAULT '',
  `pg_type_id` int(11) NOT NULL,
  `pg_type_ix` varchar(36) NOT NULL,
  `pg_type_name` varchar(50) NOT NULL DEFAULT '',
  `pg_type_label` varchar(50) NOT NULL DEFAULT '',
  `pg_type_logo` varchar(50) DEFAULT NULL,
  `pg_type_api_url` varchar(255) NOT NULL DEFAULT '',
  `pg_type_site_url` varchar(255) NOT NULL DEFAULT '',
  `pg_type_inactive_yn` tinyint(1) NOT NULL DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `pg_type_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pg_type_ix`),
  UNIQUE KEY `pg_type_ix` (`pg_type_ix`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `pg_type_trf_yn` (`pg_type_trf_yn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pg_type`
--

LOCK TABLES `pg_type` WRITE;
/*!40000 ALTER TABLE `pg_type` DISABLE KEYS */;
INSERT INTO `pg_type` VALUES ('RS',1,'RS1','paygate','Paygate SA','paygate_logo.gif','https://www.paygate.co.za/PayWebv2/process.trans','http://www.paygate.co.za',0,NULL,0),('RS',2,'RS2','3gdirectpay','3G Direct Pay',NULL,'https://ssl.3gsecure.net','https://ssl.3gsecure.net',0,NULL,0),('RS',3,'RS3','external','External',NULL,'','',0,NULL,1),('RS',4,'RS4','iveri','iVeri Lite',NULL,'https://backoffice.host.iveri.com/Lite/Transactions/New/EasyAuthorise.aspx','https://backoffice.iveri.co.za/',0,NULL,1),('RS',5,'RS5','paygate-ea','Paygate Kenya','paygate-ea_logo.gif','https://www.paygate-ea.com/paywebv3/process.trans','http://www.paygate-ea.com',0,NULL,0),('RS',6,'RS6','pesapal','Pesapal',NULL,'https://www.pesapal.com/api/','https://www.pesapal.com/',0,NULL,1);
/*!40000 ALTER TABLE `pg_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pg_type_obj`
--

DROP TABLE IF EXISTS `pg_type_obj`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pg_type_obj` (
  `pg_type_obj_db` char(2) NOT NULL DEFAULT '',
  `pg_type_obj_id` int(11) NOT NULL,
  `pg_type_obj_ix` varchar(36) NOT NULL,
  `pg_type_obj_name` varchar(30) NOT NULL DEFAULT '',
  `pg_type_obj_label` varchar(50) NOT NULL DEFAULT '',
  `pg_type_obj_sort_seq` tinyint(4) NOT NULL DEFAULT '0',
  `pg_type_obj_type_ind` tinyint(4) NOT NULL DEFAULT '1',
  `pg_type_id` varchar(36) DEFAULT NULL,
  `pg_type_obj_mandatory_yn` tinyint(1) NOT NULL DEFAULT '0',
  `pg_type_obj_inactive_yn` tinyint(1) NOT NULL DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `pg_type_obj_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pg_type_obj_ix`),
  UNIQUE KEY `pg_type_obj_ix` (`pg_type_obj_ix`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `pg_type_obj_trf_yn` (`pg_type_obj_trf_yn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pg_type_obj`
--

LOCK TABLES `pg_type_obj` WRITE;
/*!40000 ALTER TABLE `pg_type_obj` DISABLE KEYS */;
INSERT INTO `pg_type_obj` VALUES ('RS',1,'RS1','PayGate_Id','PayGate Id',1,1,'RS1',1,0,NULL,0),('RS',10,'RS10','Pesapal_Key','Pesapal Merchant Consumer Key',1,1,'RS6',1,0,NULL,1),('RS',11,'RS11','Pesapal_Secret','Pesapal Merchant Consumer Secret',1,1,'RS6',1,0,NULL,1),('RS',2,'RS2','PayGate_Key','PayGate Key',1,1,'RS1',1,0,NULL,0),('RS',3,'RS3','Company_Id','Company Token',1,1,'RS2',1,0,NULL,0),('RS',4,'RS4','Service_Id','Service Type',2,1,'RS2',1,0,NULL,0),('RS',5,'RS5','Service_Desc','Service Description',3,1,'RS2',1,0,NULL,0),('RS',6,'RS6','Merchant_Application_Id','Merchant Application Id',1,1,'RS4',1,0,NULL,1),('RS',7,'RS7','Product_Name','Product Name',2,1,'RS4',1,0,NULL,1),('RS',8,'RS8','PayGateEA_Id','PayGate Id',1,1,'RS5',1,0,NULL,0),('RS',9,'RS9','PayGateEA_Key','PayGate Key',1,1,'RS5',1,0,NULL,0);
/*!40000 ALTER TABLE `pg_type_obj` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fn_system`
--

DROP TABLE IF EXISTS `fn_system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fn_system` (
  `fn_system_db` char(2) NOT NULL DEFAULT '',
  `fn_system_id` int(11) NOT NULL,
  `fn_system_ix` varchar(36) NOT NULL,
  `fn_system_name` varchar(50) DEFAULT NULL,
  `fn_system_desc` varchar(50) DEFAULT NULL,
  `fn_sys_credit_note_yn` tinyint(1) NOT NULL DEFAULT '0',
  `fn_sys_debtor_yn` tinyint(1) NOT NULL DEFAULT '0',
  `fn_sys_invoice_yn` tinyint(1) NOT NULL DEFAULT '0',
  `fn_sys_payment_yn` tinyint(1) NOT NULL DEFAULT '0',
  `fn_sys_refund_yn` tinyint(1) NOT NULL DEFAULT '0',
  `fn_sys_tran_yn` tinyint(1) NOT NULL DEFAULT '0',
  `fn_sys_tran_summary_yn` tinyint(1) NOT NULL DEFAULT '0',
  `fn_sys_tax_groups_yn` tinyint(1) NOT NULL DEFAULT '1',
  `fn_system_inactive_yn` tinyint(1) NOT NULL DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `fn_system_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fn_system_ix`),
  UNIQUE KEY `fn_system_ix` (`fn_system_ix`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `fn_system_trf_yn` (`fn_system_trf_yn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fn_system`
--

LOCK TABLES `fn_system` WRITE;
/*!40000 ALTER TABLE `fn_system` DISABLE KEYS */;
INSERT INTO `fn_system` VALUES ('RS',1,'RS1','none','None',0,0,0,0,0,0,0,1,0,NULL,1),('RS',10,'RS10','quickbooks_zed_axis_invoices','Quickbooks (Zed Axis Invoices)',1,1,1,1,1,0,0,1,0,NULL,1),('RS',11,'RS11','tally','Tally',0,0,1,0,0,0,0,1,0,NULL,0),('RS',12,'RS12','pastel_evolution_7','Pastel Evolution 7',0,1,0,0,0,1,0,1,0,NULL,0),('RS',13,'RS13','sage_300','Sage 300',0,0,0,0,0,1,1,1,0,NULL,1),('RS',14,'RS14','sunsystems','Sun systems V6',0,1,0,0,0,1,1,1,0,NULL,1),('RS',15,'RS15','xero','Xero',0,0,1,0,0,0,0,0,0,NULL,1),('RS',2,'RS2','manual','Manual',0,0,0,0,0,0,0,1,0,NULL,1),('RS',3,'RS3','pastel_partner','Pastel Partner',0,1,0,0,0,1,0,1,0,NULL,1),('RS',4,'RS4','quickbooks_direct','QuickBooks (Direct)',1,1,1,1,0,1,0,1,0,NULL,1),('RS',5,'RS5','pastel_evolution','Pastel Evolution',0,1,0,0,0,1,0,1,0,NULL,1),('RS',7,'RS7','sage','Sage',0,1,0,0,0,1,0,1,0,NULL,1),('RS',8,'RS8','pastel_partner_11','Pastel Partner 11+',0,1,0,0,0,1,1,1,0,NULL,1),('RS',9,'RS9','quickbooks_zed_axis_journals','Quickbooks (Zed Axis Journals)',0,1,0,0,0,1,0,1,0,NULL,0);
/*!40000 ALTER TABLE `fn_system` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fn_option`
--

DROP TABLE IF EXISTS `fn_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fn_option` (
  `fn_option_db` char(2) NOT NULL DEFAULT '',
  `fn_option_id` int(11) NOT NULL,
  `fn_option_ix` varchar(36) NOT NULL,
  `fn_option_name` varchar(50) DEFAULT NULL,
  `fn_option_desc` text,
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `fn_option_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fn_option_ix`),
  UNIQUE KEY `fn_option_ix` (`fn_option_ix`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `fn_option_trf_yn` (`fn_option_trf_yn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fn_option`
--

LOCK TABLES `fn_option` WRITE;
/*!40000 ALTER TABLE `fn_option` DISABLE KEYS */;
INSERT INTO `fn_option` VALUES ('RS',1,'RS1','account_code_format','Specifies which account code format to use. 1=Ledger code, 2=Ledger code+cost centre, 3=Cost centre+Ledger code',NULL,1),('RS',10,'RS10','QB_inv_amt','Applies to QuickBooks Zed-Axis invoices. 1 = Export source currency incl tax. (Default) 2 = Export source currency excl tax. 3 = Export GL currency incl tax. 4 = Export GL currency excl tax.',NULL,1),('RS',11,'RS11','memo_format','Select and sequence data in the memo field',NULL,1),('RS',12,'RS12','Xero tracking labels','Specify labels for the 2 tracking fields separated by a comma.',NULL,1),('RS',13,'RS13','Xero tracking values','Specifies which fields should be used as the tracking values separated by a comma. 1 = Blank, 2 = Revenue Centre 1.',NULL,1),('RS',2,'RS2','tax_precision','Specifies the number of decimal places to which tax should be rounded to. If unspecified defaults to the maximum of 6.',NULL,1),('RS',3,'RS3','journal_format','Specifies the format to be used when exporting a Pastel Partner journal. 1=Normal, 2=With Source Currency',NULL,1),('RS',4,'RS4','reference_format','Specifies the format to be used for the reference field when exporting a Pastel Partner journal. 1=Line item type, 2=Reservation number, 3=Link (invoice or payment item), 4=Debtor code, 5=Document number (default), 6=Reservation number+Invoice number. This can apply to Pastel Partner, Pastel Evolution, and Quickbooks.',NULL,1),('RS',5,'RS5','debtor_recalculate','If set, the debtor line for each transaction will be recalculated based on the other transaction items after they are rounded off. For debtors in a foreign currency this is not possible, so the difference is applied to the largest non-debtor transaction item instead. 1,yes or true = enabled, anything else = disabled',NULL,1),('RS',6,'RS6','summary_date','Whether to use the earlier or latest transaction date when exporting a transaction summary. 1 (default) = latest, 2 = earliest.',NULL,1),('RS',7,'RS7','exchange_rate_format','Set the format in which the exchange rate is exported. 1 (default) = 1 home currency into x foreign currency, 2 = 1 foreign currency into x home currency',NULL,1),('RS',8,'RS8','account_code_separator','Specifies the separator to be used when concatenating account elements for the account code.',NULL,1),('RS',9,'RS9','company_name','The company name to be used with Tally exports',NULL,0);
/*!40000 ALTER TABLE `fn_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ad_module_field`
--

DROP TABLE IF EXISTS `ad_module_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ad_module_field` (
  `ad_module_field_id` int(11) NOT NULL AUTO_INCREMENT,
  `ad_module_field_name` varchar(300) NOT NULL,
  `ad_module_field_description` varchar(200) NOT NULL,
  `tc_table_id` int(11) NOT NULL,
  `rf_audit_module_id` varchar(36) DEFAULT NULL,
  `tc_table_id_display` int(11) DEFAULT NULL,
  `ad_module_field_display` varchar(300) DEFAULT NULL,
  `ad_module_field_display_type_ind` int(11) NOT NULL,
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `ad_module_field_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ad_module_field_id`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `ad_module_field_trf_yn` (`ad_module_field_trf_yn`)
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ad_module_field`
--

LOCK TABLES `ad_module_field` WRITE;
/*!40000 ALTER TABLE `ad_module_field` DISABLE KEYS */;
INSERT INTO `ad_module_field` VALUES (1,'rv_reservation.rv_res_name','Reservation name',19,'1',NULL,NULL,7,'',1),(2,'rv_reservation.rf_source_ix','Source',19,'1',67,'rf_source_desc',7,'',1),(3,'rv_reservation.rv_agent_id','Agent',19,'1',5,'pr_name_last',7,'',1),(4,'rv_reservation.rv_origin_agent_id','Originator',19,'1',5,'CONCAT(pr_persona.pr_name_first, \" \", pr_persona.pr_name_last)',7,'',1),(5,'rv_reservation.rv_corr_persona_id','Contact',19,'1',5,'CONCAT(pr_persona.pr_name_first, \" \", pr_persona.pr_name_last)',7,'',1),(6,'rv_reservation.rv_confirmation_date','Confirmation date',19,'1',NULL,NULL,4,'',1),(7,'rv_reservation.rv_cancel_reason','Cancellation reason',19,'1',NULL,NULL,8,'',1),(8,'rv_reservation.rv_cancel_date','Cancellation date',19,'1',NULL,NULL,4,'',1),(9,'rv_reservation.rf_reservation_status_id','Reservation status',19,'1',40,'rf_reservation_status_desc',7,'',1),(10,'rv_reservation.rv_consultant_id','Consultant',19,'1',5,'CONCAT(pr_persona.pr_name_first, \" \", pr_persona.pr_name_last)',7,'',1),(11,'rv_reservation.rv_date_consultant','Consultant date set',19,'1',NULL,NULL,4,'',1),(12,'rv_reservation.rv_agent_ref','Voucher reference',19,'1',NULL,NULL,7,'',1),(13,'rv_reservation.rv_provision_expiry_date','Provisional expiry date',19,'1',NULL,NULL,4,'',1),(14,'rv_reservation.rv_confirmation_user_id','Confirmed by',19,'1',5,'CONCAT(pr_persona.pr_name_first, \" \", pr_persona.pr_name_last)',7,'',1),(15,'rv_reservation.rv_cancel_user_id','Cancelled by',19,'1',5,'CONCAT(pr_persona.pr_name_first, \" \", pr_persona.pr_name_last)',7,'',1),(16,'rv_reservation.rv_wait_list_date','Waitlist date',19,'1',NULL,NULL,4,'',1),(17,'rv_reservation.rv_wait_list_user_id','Waitlisted by',19,'1',5,'CONCAT(pr_persona.pr_name_first, \" \", pr_persona.pr_name_last)',7,'',1),(18,'rv_reservation.rv_date_quote','Quote date',19,'1',NULL,NULL,4,'',1),(19,'rv_reservation.rv_invoice_persona_id','Invoice contact',19,'2',5,'CONCAT(pr_persona.pr_name_first, \" \", pr_persona.pr_name_last)',7,'',1),(20,'rv_reservation.rv_billing_persona_id','Billing contact',19,'2',5,'CONCAT(pr_persona.pr_name_first, \" \", pr_persona.pr_name_last)',7,'',1),(21,'rv_reservation.rv_commission_deduct_yn','Deduct commission?',19,'2',NULL,NULL,1,'',1),(22,'rv_reservation.rv_commission_perc','Commission percentage',19,'2',NULL,NULL,5,'',1),(23,'rv_reservation.rv_invoice_currency_id','Invoice currency',19,'2',12,'rf_currency.rf_currency_name',7,'',1),(24,'rv_reservation.rv_exchg_rate','Exchange rate',19,'2',NULL,NULL,5,'',1),(25,'rv_reservation.rv_exchg_expiry_date','Exchange rate expiry date',19,'2',NULL,NULL,4,'',1),(26,'rv_reservation.rv_folio_level_ind','Folio level',19,'2',NULL,NULL,7,'',1),(27,'rv_reservation.rt_rate_type_id','Rate type',19,'2',168,'rt_rate_type_desc',7,'',1),(28,'rv_reservation_item.rv_item_amt_comm','Commission',20,'3',NULL,NULL,2,'',1),(29,'rv_reservation_item.rv_item_amt_gross','Amount gross',20,'3',NULL,NULL,2,'',1),(30,'rv_reservation_item.rv_item_amt_nett','Amount net',20,'3',NULL,NULL,2,'',1),(31,'rv_reservation_item.rv_item_amt_payable','Amount due',20,'3',NULL,NULL,2,'',1),(32,'rv_reservation_item.rv_item_amt_tax','Amount tax',20,'3',NULL,NULL,2,'',1),(33,'rv_reservation_item.rv_item_overide_level_ind','Override level',20,'3',NULL,NULL,7,'',1),(34,'rv_reservation_item.rv_item_overide_amt','Override amount',20,'3',NULL,NULL,2,'',1),(35,'rv_reservation_item.rv_item_date_arrive','Arrival date',20,'3',NULL,NULL,4,'',1),(36,'rv_reservation_item.rv_item_date_depart','Departure date',20,'3',NULL,NULL,4,'',1),(37,'rv_reservation_item.rv_item_adult_count','Adult per room',20,'3',NULL,NULL,6,'',1),(38,'rv_reservation_item.rv_item_child_count','Child per room',20,'3',NULL,NULL,6,'',1),(39,'rv_reservation_item.rv_item_exch_rate','Exchange rate',20,'3',NULL,NULL,5,'',1),(40,'rv_reservation_item.rv_item_nights','Total nights',20,'3',NULL,NULL,6,'',1),(41,'rv_reservation_item.rv_item_note_conf','Note configuration',20,'3',NULL,NULL,7,'',1),(42,'rv_reservation_item.rv_item_note_general','Note general',20,'3',NULL,NULL,7,'',1),(43,'rv_reservation_item.rv_item_split_yn','Split',20,'3',NULL,NULL,1,'',1),(44,'rv_reservation_item.rv_item_var_perc','Variance percentage',20,'3',NULL,NULL,5,'',1),(45,'rv_reservation_item.rt_rate_type_id','Rate type',20,'3',168,'rt_rate_type_desc',7,'',1),(46,'rv_reservation_item.ac_accomm_type_id','Accommodation',20,'3',1,'ac_accomm_desc',7,'',1),(47,'rv_reservation_item.pr_business_id','Property',20,'3',5,'pr_name_last',7,'',1),(48,'rv_note.rv_note_general','Reservation notes',139,'4',NULL,NULL,8,'',1),(49,'rv_note.rv_note_guests','Guest information',139,'4',NULL,NULL,8,'',1),(50,'rv_note.rv_note_internal','Internal memo',139,'4',NULL,NULL,8,'',1),(51,'rv_reservation.rf_country_id','Guest nationality',19,'4',11,'rf_country_name',7,'',1),(52,'rv_reservation.rv_date_deleted','Delete date',19,'1',NULL,NULL,4,'',1),(53,'rv_special.rv_special_ix','Special applied',19,'3',NULL,NULL,7,NULL,0),(54,'sc_group.sc_grp_avail_limit_yn','Limit stock displayed',29,'5',NULL,NULL,1,'',1),(55,'sc_group.sc_grp_avail_limit','Stock displayed limit',29,'5',NULL,NULL,1,'',1),(56,'sc_group.sc_grp_avail_prov_yn','Allow provisional toggle',29,'5',NULL,NULL,1,'',1),(57,'sc_group.sc_grp_code','Group Code',29,'5',NULL,NULL,1,'',1),(58,'sc_group.sc_grp_consultant_yn','Consultant',29,'5',NULL,NULL,1,'',1),(59,'sc_group.sc_grp_desc','Description',29,'5',NULL,NULL,1,'',1),(60,'sc_group.sc_grp_alloc_ind','Show allocations',29,'5',NULL,NULL,1,'',1),(61,'sc_group.sc_grp_api_yn','API',29,'5',NULL,NULL,1,'',1),(62,'sc_group.sc_grp_archive_yn','Archive',29,'5',NULL,NULL,1,'',1),(63,'sc_group.sc_grp_force_payment_yn','Payment Forced',29,'5',NULL,NULL,1,'',1),(64,'sc_group.sc_grp_res_lock_yn','Lock reservations before/after',29,'5',NULL,NULL,1,'',1),(65,'sc_group.sc_grp_res_lock_days','Lock reservations days',29,'5',NULL,NULL,1,'',1),(66,'sc_group.sc_grp_res_lock_ind','Lock reservations arr/dep',29,'5',NULL,NULL,1,'',1),(67,'sc_group.sc_grp_res_status_unalloc_yn','Stock-holding to non-stock-holding',29,'5',NULL,NULL,1,'',1),(68,'sc_group.sc_grp_res_status_alloc_yn','Non-stock-holding to stock-holding',29,'5',NULL,NULL,1,'',1),(69,'sc_group.sc_grp_res_void_invoice_yn','Allow voiding Invoices',29,'5',NULL,NULL,1,'',1),(70,'sc_group.sc_grp_res_void_payment_yn','Allow voiding Payments',29,'5',NULL,NULL,1,'',1),(71,'sc_group.sc_grp_cross_invoice_yn','Allow cross invoicing',29,'5',NULL,NULL,1,'',1),(72,'sc_group.sc_grp_res_ovr_rate_type_yn','Allow Rate type overrides',29,'5',NULL,NULL,1,'',1),(73,'sc_group.sc_grp_res_ovr_amount_yn','Allow Rate amount overrides',29,'5',NULL,NULL,1,'',1),(74,'sc_group.sc_grp_res_ovr_variance_yn','Allow Component variance overrides',29,'5',NULL,NULL,1,'',1),(75,'sc_group.sc_grp_res_ovr_overbooking_yn','Allow Overbooking overrides',29,'5',NULL,NULL,1,'',1),(76,'sc_group.sc_grp_res_ovr_specials_yn','Allow Non-qualifying specials overrides',29,'5',NULL,NULL,1,'',1),(77,'sc_group.sc_grp_res_ovr_total_pax_yn','Allow Total PAX overrides',29,'5',NULL,NULL,1,'',1),(78,'sc_group.sc_grp_res_sp_apply_auto_yn','Specials - Automatic application',29,'5',NULL,NULL,1,'',1),(79,'sc_group.sc_grp_res_sp_apply_man_yn','Specials - Manual selection',29,'5',NULL,NULL,1,'',1),(80,'rv_reservation_item.rv_alloc_expiry_date','Allocation expiry date',20,'3',NULL,NULL,4,'',1),(81,'pr_persona.pr_name_first','First name',5,'6',NULL,NULL,7,NULL,0),(82,'pr_persona.pr_name_last','Last name',5,'6',NULL,NULL,7,NULL,0),(83,'pr_persona.pr_title_id','Title',5,'6',17,'rf_title_desc',7,NULL,0),(84,'pr_persona.pr_name_suffix_id','Suffix',5,'6',13,'rf_suffix_desc',7,NULL,0),(85,'pr_persona.pr_email','Email',5,'6',NULL,NULL,7,NULL,0),(86,'pr_persona.pr_persona_link_id','Linked address',5,'6',5,'pr_name_last',7,NULL,0),(87,'pr_persona.pr_persona_fwd_id','Forward contact',5,'6',5,'pr_name_last',7,NULL,0),(88,'pr_persona.pr_corr_addr_line1','Postal address line 1',5,'6',NULL,NULL,7,NULL,0),(89,'pr_persona.pr_corr_addr_line2','Postal address line 2',5,'6',NULL,NULL,7,NULL,0),(90,'pr_persona.pr_corr_addr_line3','Postal address line 3',5,'6',NULL,NULL,7,NULL,0),(91,'pr_persona.pr_corr_city','Postal city',5,'6',NULL,NULL,7,NULL,0),(92,'pr_persona.pr_corr_post_code','Postal code',5,'6',NULL,NULL,7,NULL,0),(93,'pr_persona.pr_corr_country_id','Postal country',5,'6',11,'rf_country_name',7,NULL,0),(94,'pr_persona.pr_phys_addr_line1','Physical address line 1',5,'6',NULL,NULL,7,NULL,0),(95,'pr_persona.pr_phys_addr_line2','Physical address line 2',5,'6',NULL,NULL,7,NULL,0),(96,'pr_persona.pr_phys_addr_line3','Physical address line 3',5,'6',NULL,NULL,7,NULL,0),(97,'pr_persona.pr_phys_city','Physical city',5,'6',NULL,NULL,7,NULL,0),(98,'pr_persona.pr_phys_post_code','Physical code',5,'6',NULL,NULL,7,NULL,0),(99,'pr_persona.pr_phys_country_id','Physical country',5,'6',11,'rf_country_name',7,NULL,0),(100,'pr_persona.pr_org_yn','Organisation?',5,'6',NULL,NULL,1,NULL,0),(101,'pr_persona.pr_web_addr','Web address',5,'6',NULL,NULL,7,NULL,0),(102,'pr_persona.pr_persona_inactive_yn','Inactive?',5,'6',NULL,NULL,1,NULL,0),(103,'pr_persona.pr_statutory_1','Statutory reference 1',5,'6',NULL,NULL,7,NULL,0),(104,'pr_persona.pr_statutory_2','Statutory reference 2',5,'6',NULL,NULL,7,NULL,0),(105,'pr_persona.pr_statutory_3','Statutory reference 3',5,'6',NULL,NULL,7,NULL,0),(106,'pr_phone.pr_default_yn','Default phone?',6,'7',NULL,NULL,1,NULL,0),(107,'pr_phone.pr_phone_detail','Phone detail',6,'7',NULL,NULL,7,NULL,0),(108,'pr_phone.pr_phone_number','Phone number',6,'7',NULL,NULL,7,NULL,0),(109,'pr_phone.rf_phone_type_id','Phone type',6,'7',15,'rf_phone_type_desc',7,NULL,0),(110,'pr_guest.pr_guest_primary_yn','Primary?',77,'8',NULL,NULL,1,NULL,0),(111,'pr_guest.pr_guest_inactive_yn','Inactive?',77,'8',NULL,NULL,1,NULL,0),(112,'pr_guest_obj_data.','Guest profile',137,'8',NULL,NULL,7,NULL,0),(113,'rv_trip_obj_data.','Tripsheet',138,'9',NULL,NULL,7,NULL,0);
/*!40000 ALTER TABLE `ad_module_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rf_audit_module`
--

DROP TABLE IF EXISTS `rf_audit_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rf_audit_module` (
  `rf_audit_module_id` int(11) NOT NULL AUTO_INCREMENT,
  `rf_audit_module_name` varchar(100) NOT NULL,
  `rf_audit_module_description_internal` varchar(200) NOT NULL,
  `rf_audit_module_description_external` varchar(200) NOT NULL,
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `rf_audit_module_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rf_audit_module_id`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `rf_audit_module_trf_yn` (`rf_audit_module_trf_yn`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rf_audit_module`
--

LOCK TABLES `rf_audit_module` WRITE;
/*!40000 ALTER TABLE `rf_audit_module` DISABLE KEYS */;
INSERT INTO `rf_audit_module` VALUES (1,'Detail','resdetail','General details of the reservation','',1),(2,'Financial','resfinancial','Financial details of the reservation','',1),(3,'Itinerary','resitinerary','Itinerary items related to a reservation','',1),(4,'Note','resnote','Reservation notes, memos or guest information','',1),(5,'Useraccess','useraccess','User access',NULL,1),(6,'Contact','persona','Contact details',NULL,0),(7,'Phone','phone','Phone details',NULL,0),(8,'Guest','guest','Guest profile',NULL,0),(9,'Tripsheet','tripsheet','Tripsheet',NULL,0);
/*!40000 ALTER TABLE `rf_audit_module` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pr_social`
--

DROP TABLE IF EXISTS `pr_social`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pr_social` (
  `pr_social_db` char(2) NOT NULL DEFAULT '',
  `pr_social_id` int(11) NOT NULL,
  `pr_social_ix` varchar(36) NOT NULL,
  `pr_social_name` varchar(50) DEFAULT NULL,
  `pr_social_label` varchar(50) DEFAULT NULL,
  `pr_social_sort_seq` tinyint(4) DEFAULT '0',
  `dt_temp_id` varchar(36) DEFAULT NULL,
  `pr_social_trf_yn` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pr_social_ix`),
  UNIQUE KEY `pr_social_ix` (`pr_social_ix`),
  KEY `dt_temp_id` (`dt_temp_id`),
  KEY `pr_social_trf_yn` (`pr_social_trf_yn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pr_social`
--

LOCK TABLES `pr_social` WRITE;
/*!40000 ALTER TABLE `pr_social` DISABLE KEYS */;
INSERT INTO `pr_social` VALUES ('RS',1,'RS1','facebook','Facebook',1,NULL,0),('RS',2,'RS2','twitter','Twitter',2,NULL,0),('RS',3,'RS3','pinterest','Pinterest',3,NULL,0),('RS',4,'RS4','googleplus','Google+',4,NULL,0),('RS',5,'RS5','linkedin','LinkedIn',5,NULL,0),('RS',6,'RS6','tripadvisor','TripAdvisor',6,NULL,0);
/*!40000 ALTER TABLE `pr_social` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-02-22 15:39:47
/* 0000 - Update database version - should always be at the end of the script */
UPDATE rf_database SET rf_db_version_db = '7.19.0';
/* Time Zones */
USE mysql;
TRUNCATE TABLE time_zone;
TRUNCATE TABLE time_zone_name;
TRUNCATE TABLE time_zone_transition;
TRUNCATE TABLE time_zone_transition_type;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Abidjan', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Accra', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1640995148, 2)
,(@time_zone_id, -1556841600, 1)
,(@time_zone_id, -1546388400, 2)
,(@time_zone_id, -1525305600, 1)
,(@time_zone_id, -1514852400, 2)
,(@time_zone_id, -1493769600, 1)
,(@time_zone_id, -1483316400, 2)
,(@time_zone_id, -1462233600, 1)
,(@time_zone_id, -1451780400, 2)
,(@time_zone_id, -1430611200, 1)
,(@time_zone_id, -1420158000, 2)
,(@time_zone_id, -1399075200, 1)
,(@time_zone_id, -1388622000, 2)
,(@time_zone_id, -1367539200, 1)
,(@time_zone_id, -1357086000, 2)
,(@time_zone_id, -1336003200, 1)
,(@time_zone_id, -1325550000, 2)
,(@time_zone_id, -1304380800, 1)
,(@time_zone_id, -1293927600, 2)
,(@time_zone_id, -1272844800, 1)
,(@time_zone_id, -1262391600, 2)
,(@time_zone_id, -1241308800, 1)
,(@time_zone_id, -1230855600, 2)
,(@time_zone_id, -1209772800, 1)
,(@time_zone_id, -1199319600, 2)
,(@time_zone_id, -1178150400, 1)
,(@time_zone_id, -1167697200, 2)
,(@time_zone_id, -1146614400, 1)
,(@time_zone_id, -1136161200, 2)
,(@time_zone_id, -1115078400, 1)
,(@time_zone_id, -1104625200, 2)
,(@time_zone_id, -1083542400, 1)
,(@time_zone_id, -1073089200, 2)
,(@time_zone_id, -1051920000, 1)
,(@time_zone_id, -1041466800, 2)
,(@time_zone_id, -1020384000, 1)
,(@time_zone_id, -1009930800, 2)
,(@time_zone_id, -988848000, 1)
,(@time_zone_id, -978394800, 2)
,(@time_zone_id, -957312000, 1)
,(@time_zone_id, -946858800, 2)
,(@time_zone_id, -925689600, 1)
,(@time_zone_id, -915236400, 2)
,(@time_zone_id, -894153600, 1)
,(@time_zone_id, -883700400, 2)
,(@time_zone_id, -862617600, 1)
,(@time_zone_id, -852164400, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -52, 0, 'LMT')
,(@time_zone_id, 1, 1200, 1, '+0020')
,(@time_zone_id, 2, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Addis_Ababa', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1309746436, 1)
,(@time_zone_id, -1262314800, 2)
,(@time_zone_id, -946780200, 3)
,(@time_zone_id, -315629100, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8836, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, 'EAT')
,(@time_zone_id, 2, 9000, 0, '+0230')
,(@time_zone_id, 3, 9900, 0, '+0245')
,(@time_zone_id, 4, 10800, 0, 'EAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Algiers', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1855958961, 4)
,(@time_zone_id, -1689814800, 2)
,(@time_zone_id, -1680397200, 3)
,(@time_zone_id, -1665363600, 2)
,(@time_zone_id, -1648342800, 3)
,(@time_zone_id, -1635123600, 2)
,(@time_zone_id, -1616893200, 3)
,(@time_zone_id, -1604278800, 2)
,(@time_zone_id, -1585443600, 3)
,(@time_zone_id, -1574038800, 2)
,(@time_zone_id, -1552266000, 3)
,(@time_zone_id, -1539997200, 2)
,(@time_zone_id, -1531443600, 3)
,(@time_zone_id, -956365200, 2)
,(@time_zone_id, -950486400, 4)
,(@time_zone_id, -942012000, 6)
,(@time_zone_id, -812502000, 5)
,(@time_zone_id, -796262400, 6)
,(@time_zone_id, -781052400, 5)
,(@time_zone_id, -766630800, 6)
,(@time_zone_id, -733280400, 4)
,(@time_zone_id, -439430400, 6)
,(@time_zone_id, -212029200, 4)
,(@time_zone_id, 41468400, 2)
,(@time_zone_id, 54774000, 3)
,(@time_zone_id, 231724800, 7)
,(@time_zone_id, 246236400, 6)
,(@time_zone_id, 259545600, 5)
,(@time_zone_id, 275274000, 6)
,(@time_zone_id, 309740400, 4)
,(@time_zone_id, 325468800, 7)
,(@time_zone_id, 341802000, 4)
,(@time_zone_id, 357523200, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 732, 0, 'LMT')
,(@time_zone_id, 1, 561, 0, 'PMT')
,(@time_zone_id, 2, 3600, 1, 'WEST')
,(@time_zone_id, 3, 0, 0, 'WET')
,(@time_zone_id, 4, 0, 0, 'WET')
,(@time_zone_id, 5, 7200, 1, 'CEST')
,(@time_zone_id, 6, 3600, 0, 'CET')
,(@time_zone_id, 7, 3600, 1, 'WEST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Asmara', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1309746436, 1)
,(@time_zone_id, -1262314800, 2)
,(@time_zone_id, -946780200, 3)
,(@time_zone_id, -315629100, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8836, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, 'EAT')
,(@time_zone_id, 2, 9000, 0, '+0230')
,(@time_zone_id, 3, 9900, 0, '+0245')
,(@time_zone_id, 4, 10800, 0, 'EAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Asmera', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1309746436, 1)
,(@time_zone_id, -1262314800, 2)
,(@time_zone_id, -946780200, 3)
,(@time_zone_id, -315629100, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8836, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, 'EAT')
,(@time_zone_id, 2, 9000, 0, '+0230')
,(@time_zone_id, 3, 9900, 0, '+0245')
,(@time_zone_id, 4, 10800, 0, 'EAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Bamako', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Bangui', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Banjul', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Bissau', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830380400, 1)
,(@time_zone_id, 157770000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -3740, 0, 'LMT')
,(@time_zone_id, 1, -3600, 0, '-01')
,(@time_zone_id, 2, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Blantyre', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2109291020, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7820, 0, 'LMT')
,(@time_zone_id, 1, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Brazzaville', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Bujumbura', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2109291020, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7820, 0, 'LMT')
,(@time_zone_id, 1, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Cairo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -929844000, 1)
,(@time_zone_id, -923108400, 2)
,(@time_zone_id, -906170400, 1)
,(@time_zone_id, -892868400, 2)
,(@time_zone_id, -875844000, 1)
,(@time_zone_id, -857790000, 2)
,(@time_zone_id, -844308000, 1)
,(@time_zone_id, -825822000, 2)
,(@time_zone_id, -812685600, 1)
,(@time_zone_id, -794199600, 2)
,(@time_zone_id, -779853600, 1)
,(@time_zone_id, -762663600, 2)
,(@time_zone_id, -399088800, 1)
,(@time_zone_id, -386650800, 2)
,(@time_zone_id, -368330400, 1)
,(@time_zone_id, -355114800, 2)
,(@time_zone_id, -336790800, 1)
,(@time_zone_id, -323654400, 2)
,(@time_zone_id, -305168400, 1)
,(@time_zone_id, -292032000, 2)
,(@time_zone_id, -273632400, 1)
,(@time_zone_id, -260496000, 2)
,(@time_zone_id, -242096400, 1)
,(@time_zone_id, -228960000, 2)
,(@time_zone_id, -210560400, 1)
,(@time_zone_id, -197424000, 2)
,(@time_zone_id, -178938000, 1)
,(@time_zone_id, -165801600, 2)
,(@time_zone_id, -147402000, 1)
,(@time_zone_id, -134265600, 2)
,(@time_zone_id, -115866000, 1)
,(@time_zone_id, -102643200, 2)
,(@time_zone_id, -84330000, 1)
,(@time_zone_id, -71107200, 2)
,(@time_zone_id, -52707600, 1)
,(@time_zone_id, -39484800, 2)
,(@time_zone_id, -21171600, 1)
,(@time_zone_id, -7948800, 2)
,(@time_zone_id, 10364400, 1)
,(@time_zone_id, 23587200, 2)
,(@time_zone_id, 41900400, 1)
,(@time_zone_id, 55123200, 2)
,(@time_zone_id, 73522800, 1)
,(@time_zone_id, 86745600, 2)
,(@time_zone_id, 105058800, 1)
,(@time_zone_id, 118281600, 2)
,(@time_zone_id, 136594800, 1)
,(@time_zone_id, 149817600, 2)
,(@time_zone_id, 168130800, 1)
,(@time_zone_id, 181353600, 2)
,(@time_zone_id, 199753200, 1)
,(@time_zone_id, 212976000, 2)
,(@time_zone_id, 231289200, 1)
,(@time_zone_id, 244512000, 2)
,(@time_zone_id, 262825200, 1)
,(@time_zone_id, 276048000, 2)
,(@time_zone_id, 294361200, 1)
,(@time_zone_id, 307584000, 2)
,(@time_zone_id, 325983600, 1)
,(@time_zone_id, 339206400, 2)
,(@time_zone_id, 357519600, 1)
,(@time_zone_id, 370742400, 2)
,(@time_zone_id, 396399600, 1)
,(@time_zone_id, 402278400, 2)
,(@time_zone_id, 426812400, 1)
,(@time_zone_id, 433814400, 2)
,(@time_zone_id, 452214000, 1)
,(@time_zone_id, 465436800, 2)
,(@time_zone_id, 483750000, 1)
,(@time_zone_id, 496972800, 2)
,(@time_zone_id, 515286000, 1)
,(@time_zone_id, 528508800, 2)
,(@time_zone_id, 546822000, 1)
,(@time_zone_id, 560044800, 2)
,(@time_zone_id, 578444400, 1)
,(@time_zone_id, 591667200, 2)
,(@time_zone_id, 610412400, 1)
,(@time_zone_id, 623203200, 2)
,(@time_zone_id, 641516400, 1)
,(@time_zone_id, 654739200, 2)
,(@time_zone_id, 673052400, 1)
,(@time_zone_id, 686275200, 2)
,(@time_zone_id, 704674800, 1)
,(@time_zone_id, 717897600, 2)
,(@time_zone_id, 736210800, 1)
,(@time_zone_id, 749433600, 2)
,(@time_zone_id, 767746800, 1)
,(@time_zone_id, 780969600, 2)
,(@time_zone_id, 799020000, 3)
,(@time_zone_id, 812322000, 2)
,(@time_zone_id, 830469600, 3)
,(@time_zone_id, 843771600, 2)
,(@time_zone_id, 861919200, 3)
,(@time_zone_id, 875221200, 2)
,(@time_zone_id, 893368800, 3)
,(@time_zone_id, 906670800, 2)
,(@time_zone_id, 925423200, 3)
,(@time_zone_id, 938725200, 2)
,(@time_zone_id, 956872800, 3)
,(@time_zone_id, 970174800, 2)
,(@time_zone_id, 988322400, 3)
,(@time_zone_id, 1001624400, 2)
,(@time_zone_id, 1019772000, 3)
,(@time_zone_id, 1033074000, 2)
,(@time_zone_id, 1051221600, 3)
,(@time_zone_id, 1064523600, 2)
,(@time_zone_id, 1083276000, 3)
,(@time_zone_id, 1096578000, 2)
,(@time_zone_id, 1114725600, 3)
,(@time_zone_id, 1128027600, 2)
,(@time_zone_id, 1146175200, 3)
,(@time_zone_id, 1158872400, 2)
,(@time_zone_id, 1177624800, 3)
,(@time_zone_id, 1189112400, 2)
,(@time_zone_id, 1209074400, 3)
,(@time_zone_id, 1219957200, 2)
,(@time_zone_id, 1240524000, 3)
,(@time_zone_id, 1250802000, 2)
,(@time_zone_id, 1272578400, 3)
,(@time_zone_id, 1281474000, 2)
,(@time_zone_id, 1284069600, 1)
,(@time_zone_id, 1285880400, 2)
,(@time_zone_id, 1400191200, 1)
,(@time_zone_id, 1403816400, 2)
,(@time_zone_id, 1406844000, 1)
,(@time_zone_id, 1411678800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7509, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'EEST')
,(@time_zone_id, 2, 7200, 0, 'EET')
,(@time_zone_id, 3, 10800, 1, 'EEST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Casablanca', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1773012580, 2)
,(@time_zone_id, -956361600, 1)
,(@time_zone_id, -950490000, 2)
,(@time_zone_id, -942019200, 1)
,(@time_zone_id, -761187600, 2)
,(@time_zone_id, -617241600, 1)
,(@time_zone_id, -605149200, 2)
,(@time_zone_id, -81432000, 1)
,(@time_zone_id, -71110800, 2)
,(@time_zone_id, 141264000, 1)
,(@time_zone_id, 147222000, 2)
,(@time_zone_id, 199756800, 1)
,(@time_zone_id, 207702000, 2)
,(@time_zone_id, 231292800, 1)
,(@time_zone_id, 244249200, 2)
,(@time_zone_id, 265507200, 1)
,(@time_zone_id, 271033200, 2)
,(@time_zone_id, 448243200, 3)
,(@time_zone_id, 504918000, 2)
,(@time_zone_id, 1212278400, 1)
,(@time_zone_id, 1220223600, 2)
,(@time_zone_id, 1243814400, 1)
,(@time_zone_id, 1250809200, 2)
,(@time_zone_id, 1272758400, 1)
,(@time_zone_id, 1281222000, 2)
,(@time_zone_id, 1301788800, 1)
,(@time_zone_id, 1312066800, 2)
,(@time_zone_id, 1335664800, 1)
,(@time_zone_id, 1342749600, 2)
,(@time_zone_id, 1345428000, 1)
,(@time_zone_id, 1348970400, 2)
,(@time_zone_id, 1367114400, 1)
,(@time_zone_id, 1373162400, 2)
,(@time_zone_id, 1376100000, 1)
,(@time_zone_id, 1382839200, 2)
,(@time_zone_id, 1396144800, 1)
,(@time_zone_id, 1403920800, 2)
,(@time_zone_id, 1406944800, 1)
,(@time_zone_id, 1414288800, 2)
,(@time_zone_id, 1427594400, 1)
,(@time_zone_id, 1434247200, 2)
,(@time_zone_id, 1437271200, 1)
,(@time_zone_id, 1445738400, 2)
,(@time_zone_id, 1459044000, 1)
,(@time_zone_id, 1465092000, 2)
,(@time_zone_id, 1468116000, 1)
,(@time_zone_id, 1477792800, 2)
,(@time_zone_id, 1490493600, 1)
,(@time_zone_id, 1495332000, 2)
,(@time_zone_id, 1498960800, 1)
,(@time_zone_id, 1509242400, 2)
,(@time_zone_id, 1521943200, 1)
,(@time_zone_id, 1526176800, 2)
,(@time_zone_id, 1529200800, 1)
,(@time_zone_id, 1540692000, 3)
,(@time_zone_id, 1557021600, 4)
,(@time_zone_id, 1560045600, 3)
,(@time_zone_id, 1587261600, 4)
,(@time_zone_id, 1590285600, 3)
,(@time_zone_id, 1618106400, 4)
,(@time_zone_id, 1621130400, 3)
,(@time_zone_id, 1648346400, 4)
,(@time_zone_id, 1651975200, 3)
,(@time_zone_id, 1679191200, 4)
,(@time_zone_id, 1682215200, 3)
,(@time_zone_id, 1710036000, 4)
,(@time_zone_id, 1713060000, 3)
,(@time_zone_id, 1740276000, 4)
,(@time_zone_id, 1743904800, 3)
,(@time_zone_id, 1771120800, 4)
,(@time_zone_id, 1774144800, 3)
,(@time_zone_id, 1801965600, 4)
,(@time_zone_id, 1804989600, 3)
,(@time_zone_id, 1832205600, 4)
,(@time_zone_id, 1835229600, 3)
,(@time_zone_id, 1863050400, 4)
,(@time_zone_id, 1866074400, 3)
,(@time_zone_id, 1893290400, 4)
,(@time_zone_id, 1896919200, 3)
,(@time_zone_id, 1924135200, 4)
,(@time_zone_id, 1927159200, 3)
,(@time_zone_id, 1954980000, 4)
,(@time_zone_id, 1958004000, 3)
,(@time_zone_id, 1985220000, 4)
,(@time_zone_id, 1988848800, 3)
,(@time_zone_id, 2016064800, 4)
,(@time_zone_id, 2019088800, 3)
,(@time_zone_id, 2046304800, 4)
,(@time_zone_id, 2049933600, 3)
,(@time_zone_id, 2077149600, 4)
,(@time_zone_id, 2080173600, 3)
,(@time_zone_id, 2107994400, 4)
,(@time_zone_id, 2111018400, 3)
,(@time_zone_id, 2138234400, 4)
,(@time_zone_id, 2141863200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -1820, 0, 'LMT')
,(@time_zone_id, 1, 3600, 1, '+01')
,(@time_zone_id, 2, 0, 0, '+00')
,(@time_zone_id, 3, 3600, 0, '+01')
,(@time_zone_id, 4, 0, 1, '+00')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Ceuta', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1630112400, 2)
,(@time_zone_id, -1616810400, 1)
,(@time_zone_id, -1442451600, 2)
,(@time_zone_id, -1427673600, 3)
,(@time_zone_id, -1379293200, 2)
,(@time_zone_id, -1364774400, 3)
,(@time_zone_id, -1348448400, 2)
,(@time_zone_id, -1333324800, 3)
,(@time_zone_id, -1316390400, 2)
,(@time_zone_id, -1301270400, 3)
,(@time_zone_id, -1293840000, 1)
,(@time_zone_id, -81432000, 2)
,(@time_zone_id, -71110800, 1)
,(@time_zone_id, 141264000, 2)
,(@time_zone_id, 147222000, 1)
,(@time_zone_id, 199756800, 2)
,(@time_zone_id, 207702000, 1)
,(@time_zone_id, 231292800, 2)
,(@time_zone_id, 244249200, 1)
,(@time_zone_id, 265507200, 2)
,(@time_zone_id, 271033200, 1)
,(@time_zone_id, 448243200, 4)
,(@time_zone_id, 512528400, 5)
,(@time_zone_id, 528253200, 6)
,(@time_zone_id, 543978000, 5)
,(@time_zone_id, 559702800, 6)
,(@time_zone_id, 575427600, 5)
,(@time_zone_id, 591152400, 6)
,(@time_zone_id, 606877200, 5)
,(@time_zone_id, 622602000, 6)
,(@time_zone_id, 638326800, 5)
,(@time_zone_id, 654656400, 6)
,(@time_zone_id, 670381200, 5)
,(@time_zone_id, 686106000, 6)
,(@time_zone_id, 701830800, 5)
,(@time_zone_id, 717555600, 6)
,(@time_zone_id, 733280400, 5)
,(@time_zone_id, 749005200, 6)
,(@time_zone_id, 764730000, 5)
,(@time_zone_id, 780454800, 6)
,(@time_zone_id, 796179600, 5)
,(@time_zone_id, 811904400, 6)
,(@time_zone_id, 828234000, 5)
,(@time_zone_id, 846378000, 6)
,(@time_zone_id, 859683600, 5)
,(@time_zone_id, 877827600, 6)
,(@time_zone_id, 891133200, 5)
,(@time_zone_id, 909277200, 6)
,(@time_zone_id, 922582800, 5)
,(@time_zone_id, 941331600, 6)
,(@time_zone_id, 954032400, 5)
,(@time_zone_id, 972781200, 6)
,(@time_zone_id, 985482000, 5)
,(@time_zone_id, 1004230800, 6)
,(@time_zone_id, 1017536400, 5)
,(@time_zone_id, 1035680400, 6)
,(@time_zone_id, 1048986000, 5)
,(@time_zone_id, 1067130000, 6)
,(@time_zone_id, 1080435600, 5)
,(@time_zone_id, 1099184400, 6)
,(@time_zone_id, 1111885200, 5)
,(@time_zone_id, 1130634000, 6)
,(@time_zone_id, 1143334800, 5)
,(@time_zone_id, 1162083600, 6)
,(@time_zone_id, 1174784400, 5)
,(@time_zone_id, 1193533200, 6)
,(@time_zone_id, 1206838800, 5)
,(@time_zone_id, 1224982800, 6)
,(@time_zone_id, 1238288400, 5)
,(@time_zone_id, 1256432400, 6)
,(@time_zone_id, 1269738000, 5)
,(@time_zone_id, 1288486800, 6)
,(@time_zone_id, 1301187600, 5)
,(@time_zone_id, 1319936400, 6)
,(@time_zone_id, 1332637200, 5)
,(@time_zone_id, 1351386000, 6)
,(@time_zone_id, 1364691600, 5)
,(@time_zone_id, 1382835600, 6)
,(@time_zone_id, 1396141200, 5)
,(@time_zone_id, 1414285200, 6)
,(@time_zone_id, 1427590800, 5)
,(@time_zone_id, 1445734800, 6)
,(@time_zone_id, 1459040400, 5)
,(@time_zone_id, 1477789200, 6)
,(@time_zone_id, 1490490000, 5)
,(@time_zone_id, 1509238800, 6)
,(@time_zone_id, 1521939600, 5)
,(@time_zone_id, 1540688400, 6)
,(@time_zone_id, 1553994000, 5)
,(@time_zone_id, 1572138000, 6)
,(@time_zone_id, 1585443600, 5)
,(@time_zone_id, 1603587600, 6)
,(@time_zone_id, 1616893200, 5)
,(@time_zone_id, 1635642000, 6)
,(@time_zone_id, 1648342800, 5)
,(@time_zone_id, 1667091600, 6)
,(@time_zone_id, 1679792400, 5)
,(@time_zone_id, 1698541200, 6)
,(@time_zone_id, 1711846800, 5)
,(@time_zone_id, 1729990800, 6)
,(@time_zone_id, 1743296400, 5)
,(@time_zone_id, 1761440400, 6)
,(@time_zone_id, 1774746000, 5)
,(@time_zone_id, 1792890000, 6)
,(@time_zone_id, 1806195600, 5)
,(@time_zone_id, 1824944400, 6)
,(@time_zone_id, 1837645200, 5)
,(@time_zone_id, 1856394000, 6)
,(@time_zone_id, 1869094800, 5)
,(@time_zone_id, 1887843600, 6)
,(@time_zone_id, 1901149200, 5)
,(@time_zone_id, 1919293200, 6)
,(@time_zone_id, 1932598800, 5)
,(@time_zone_id, 1950742800, 6)
,(@time_zone_id, 1964048400, 5)
,(@time_zone_id, 1982797200, 6)
,(@time_zone_id, 1995498000, 5)
,(@time_zone_id, 2014246800, 6)
,(@time_zone_id, 2026947600, 5)
,(@time_zone_id, 2045696400, 6)
,(@time_zone_id, 2058397200, 5)
,(@time_zone_id, 2077146000, 6)
,(@time_zone_id, 2090451600, 5)
,(@time_zone_id, 2108595600, 6)
,(@time_zone_id, 2121901200, 5)
,(@time_zone_id, 2140045200, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -1276, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'WET')
,(@time_zone_id, 2, 3600, 1, 'WEST')
,(@time_zone_id, 3, 0, 0, 'WET')
,(@time_zone_id, 4, 3600, 0, 'CET')
,(@time_zone_id, 5, 7200, 1, 'CEST')
,(@time_zone_id, 6, 3600, 0, 'CET')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Conakry', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Dakar', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Dar_es_Salaam', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1309746436, 1)
,(@time_zone_id, -1262314800, 2)
,(@time_zone_id, -946780200, 3)
,(@time_zone_id, -315629100, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8836, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, 'EAT')
,(@time_zone_id, 2, 9000, 0, '+0230')
,(@time_zone_id, 3, 9900, 0, '+0245')
,(@time_zone_id, 4, 10800, 0, 'EAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Djibouti', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1309746436, 1)
,(@time_zone_id, -1262314800, 2)
,(@time_zone_id, -946780200, 3)
,(@time_zone_id, -315629100, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8836, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, 'EAT')
,(@time_zone_id, 2, 9000, 0, '+0230')
,(@time_zone_id, 3, 9900, 0, '+0245')
,(@time_zone_id, 4, 10800, 0, 'EAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Douala', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/El_Aaiun', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1136070432, 1)
,(@time_zone_id, 198291600, 3)
,(@time_zone_id, 199756800, 2)
,(@time_zone_id, 207702000, 3)
,(@time_zone_id, 231292800, 2)
,(@time_zone_id, 244249200, 3)
,(@time_zone_id, 265507200, 2)
,(@time_zone_id, 271033200, 3)
,(@time_zone_id, 1212278400, 2)
,(@time_zone_id, 1220223600, 3)
,(@time_zone_id, 1243814400, 2)
,(@time_zone_id, 1250809200, 3)
,(@time_zone_id, 1272758400, 2)
,(@time_zone_id, 1281222000, 3)
,(@time_zone_id, 1301788800, 2)
,(@time_zone_id, 1312066800, 3)
,(@time_zone_id, 1335664800, 2)
,(@time_zone_id, 1342749600, 3)
,(@time_zone_id, 1345428000, 2)
,(@time_zone_id, 1348970400, 3)
,(@time_zone_id, 1367114400, 2)
,(@time_zone_id, 1373162400, 3)
,(@time_zone_id, 1376100000, 2)
,(@time_zone_id, 1382839200, 3)
,(@time_zone_id, 1396144800, 2)
,(@time_zone_id, 1403920800, 3)
,(@time_zone_id, 1406944800, 2)
,(@time_zone_id, 1414288800, 3)
,(@time_zone_id, 1427594400, 2)
,(@time_zone_id, 1434247200, 3)
,(@time_zone_id, 1437271200, 2)
,(@time_zone_id, 1445738400, 3)
,(@time_zone_id, 1459044000, 2)
,(@time_zone_id, 1465092000, 3)
,(@time_zone_id, 1468116000, 2)
,(@time_zone_id, 1477792800, 3)
,(@time_zone_id, 1490493600, 2)
,(@time_zone_id, 1495332000, 3)
,(@time_zone_id, 1498960800, 2)
,(@time_zone_id, 1509242400, 3)
,(@time_zone_id, 1521943200, 2)
,(@time_zone_id, 1526176800, 3)
,(@time_zone_id, 1529200800, 2)
,(@time_zone_id, 1540692000, 5)
,(@time_zone_id, 1557021600, 4)
,(@time_zone_id, 1560045600, 5)
,(@time_zone_id, 1587261600, 4)
,(@time_zone_id, 1590285600, 5)
,(@time_zone_id, 1618106400, 4)
,(@time_zone_id, 1621130400, 5)
,(@time_zone_id, 1648346400, 4)
,(@time_zone_id, 1651975200, 5)
,(@time_zone_id, 1679191200, 4)
,(@time_zone_id, 1682215200, 5)
,(@time_zone_id, 1710036000, 4)
,(@time_zone_id, 1713060000, 5)
,(@time_zone_id, 1740276000, 4)
,(@time_zone_id, 1743904800, 5)
,(@time_zone_id, 1771120800, 4)
,(@time_zone_id, 1774144800, 5)
,(@time_zone_id, 1801965600, 4)
,(@time_zone_id, 1804989600, 5)
,(@time_zone_id, 1832205600, 4)
,(@time_zone_id, 1835229600, 5)
,(@time_zone_id, 1863050400, 4)
,(@time_zone_id, 1866074400, 5)
,(@time_zone_id, 1893290400, 4)
,(@time_zone_id, 1896919200, 5)
,(@time_zone_id, 1924135200, 4)
,(@time_zone_id, 1927159200, 5)
,(@time_zone_id, 1954980000, 4)
,(@time_zone_id, 1958004000, 5)
,(@time_zone_id, 1985220000, 4)
,(@time_zone_id, 1988848800, 5)
,(@time_zone_id, 2016064800, 4)
,(@time_zone_id, 2019088800, 5)
,(@time_zone_id, 2046304800, 4)
,(@time_zone_id, 2049933600, 5)
,(@time_zone_id, 2077149600, 4)
,(@time_zone_id, 2080173600, 5)
,(@time_zone_id, 2107994400, 4)
,(@time_zone_id, 2111018400, 5)
,(@time_zone_id, 2138234400, 4)
,(@time_zone_id, 2141863200, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -3168, 0, 'LMT')
,(@time_zone_id, 1, -3600, 0, '-01')
,(@time_zone_id, 2, 3600, 1, '+01')
,(@time_zone_id, 3, 0, 0, '+00')
,(@time_zone_id, 4, 0, 1, '+00')
,(@time_zone_id, 5, 3600, 0, '+01')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Freetown', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Gaborone', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2109291020, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7820, 0, 'LMT')
,(@time_zone_id, 1, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Harare', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2109291020, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7820, 0, 'LMT')
,(@time_zone_id, 1, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Johannesburg', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2109288600, 3)
,(@time_zone_id, -860976000, 2)
,(@time_zone_id, -845254800, 3)
,(@time_zone_id, -829526400, 2)
,(@time_zone_id, -813805200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 6720, 0, 'LMT')
,(@time_zone_id, 1, 5400, 0, 'SAST')
,(@time_zone_id, 2, 10800, 1, 'SAST')
,(@time_zone_id, 3, 7200, 0, 'SAST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Juba', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1230775588, 2)
,(@time_zone_id, 10360800, 1)
,(@time_zone_id, 24786000, 2)
,(@time_zone_id, 41810400, 1)
,(@time_zone_id, 56322000, 2)
,(@time_zone_id, 73432800, 1)
,(@time_zone_id, 87944400, 2)
,(@time_zone_id, 104882400, 1)
,(@time_zone_id, 119480400, 2)
,(@time_zone_id, 136332000, 1)
,(@time_zone_id, 151016400, 2)
,(@time_zone_id, 167781600, 1)
,(@time_zone_id, 182552400, 2)
,(@time_zone_id, 199231200, 1)
,(@time_zone_id, 214174800, 2)
,(@time_zone_id, 230680800, 1)
,(@time_zone_id, 245710800, 2)
,(@time_zone_id, 262735200, 1)
,(@time_zone_id, 277246800, 2)
,(@time_zone_id, 294184800, 1)
,(@time_zone_id, 308782800, 2)
,(@time_zone_id, 325634400, 1)
,(@time_zone_id, 340405200, 2)
,(@time_zone_id, 357084000, 1)
,(@time_zone_id, 371941200, 2)
,(@time_zone_id, 388533600, 1)
,(@time_zone_id, 403477200, 2)
,(@time_zone_id, 419983200, 1)
,(@time_zone_id, 435013200, 2)
,(@time_zone_id, 452037600, 1)
,(@time_zone_id, 466635600, 2)
,(@time_zone_id, 483487200, 1)
,(@time_zone_id, 498171600, 2)
,(@time_zone_id, 947930400, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7588, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'CAST')
,(@time_zone_id, 2, 7200, 0, 'CAT')
,(@time_zone_id, 3, 10800, 0, 'EAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Kampala', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1309746436, 1)
,(@time_zone_id, -1262314800, 2)
,(@time_zone_id, -946780200, 3)
,(@time_zone_id, -315629100, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8836, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, 'EAT')
,(@time_zone_id, 2, 9000, 0, '+0230')
,(@time_zone_id, 3, 9900, 0, '+0245')
,(@time_zone_id, 4, 10800, 0, 'EAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Khartoum', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1230775808, 2)
,(@time_zone_id, 10360800, 1)
,(@time_zone_id, 24786000, 2)
,(@time_zone_id, 41810400, 1)
,(@time_zone_id, 56322000, 2)
,(@time_zone_id, 73432800, 1)
,(@time_zone_id, 87944400, 2)
,(@time_zone_id, 104882400, 1)
,(@time_zone_id, 119480400, 2)
,(@time_zone_id, 136332000, 1)
,(@time_zone_id, 151016400, 2)
,(@time_zone_id, 167781600, 1)
,(@time_zone_id, 182552400, 2)
,(@time_zone_id, 199231200, 1)
,(@time_zone_id, 214174800, 2)
,(@time_zone_id, 230680800, 1)
,(@time_zone_id, 245710800, 2)
,(@time_zone_id, 262735200, 1)
,(@time_zone_id, 277246800, 2)
,(@time_zone_id, 294184800, 1)
,(@time_zone_id, 308782800, 2)
,(@time_zone_id, 325634400, 1)
,(@time_zone_id, 340405200, 2)
,(@time_zone_id, 357084000, 1)
,(@time_zone_id, 371941200, 2)
,(@time_zone_id, 388533600, 1)
,(@time_zone_id, 403477200, 2)
,(@time_zone_id, 419983200, 1)
,(@time_zone_id, 435013200, 2)
,(@time_zone_id, 452037600, 1)
,(@time_zone_id, 466635600, 2)
,(@time_zone_id, 483487200, 1)
,(@time_zone_id, 498171600, 2)
,(@time_zone_id, 947930400, 3)
,(@time_zone_id, 1509483600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7808, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'CAST')
,(@time_zone_id, 2, 7200, 0, 'CAT')
,(@time_zone_id, 3, 10800, 0, 'EAT')
,(@time_zone_id, 4, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Kigali', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2109291020, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7820, 0, 'LMT')
,(@time_zone_id, 1, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Kinshasa', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Lagos', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Libreville', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Lome', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Luanda', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Lubumbashi', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2109291020, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7820, 0, 'LMT')
,(@time_zone_id, 1, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Lusaka', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2109291020, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7820, 0, 'LMT')
,(@time_zone_id, 1, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Malabo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Maputo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2109291020, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 7820, 0, 'LMT')
,(@time_zone_id, 1, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Maseru', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2109288600, 3)
,(@time_zone_id, -860976000, 2)
,(@time_zone_id, -845254800, 3)
,(@time_zone_id, -829526400, 2)
,(@time_zone_id, -813805200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 6720, 0, 'LMT')
,(@time_zone_id, 1, 5400, 0, 'SAST')
,(@time_zone_id, 2, 10800, 1, 'SAST')
,(@time_zone_id, 3, 7200, 0, 'SAST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Mbabane', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2109288600, 3)
,(@time_zone_id, -860976000, 2)
,(@time_zone_id, -845254800, 3)
,(@time_zone_id, -829526400, 2)
,(@time_zone_id, -813805200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 6720, 0, 'LMT')
,(@time_zone_id, 1, 5400, 0, 'SAST')
,(@time_zone_id, 2, 10800, 1, 'SAST')
,(@time_zone_id, 3, 7200, 0, 'SAST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Mogadishu', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1309746436, 1)
,(@time_zone_id, -1262314800, 2)
,(@time_zone_id, -946780200, 3)
,(@time_zone_id, -315629100, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8836, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, 'EAT')
,(@time_zone_id, 2, 9000, 0, '+0230')
,(@time_zone_id, 3, 9900, 0, '+0245')
,(@time_zone_id, 4, 10800, 0, 'EAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Monrovia', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1604359012, 2)
,(@time_zone_id, 63593070, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -2588, 0, 'LMT')
,(@time_zone_id, 1, -2588, 0, 'MMT')
,(@time_zone_id, 2, -2670, 0, 'MMT')
,(@time_zone_id, 3, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Nairobi', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1309746436, 1)
,(@time_zone_id, -1262314800, 2)
,(@time_zone_id, -946780200, 3)
,(@time_zone_id, -315629100, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8836, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, 'EAT')
,(@time_zone_id, 2, 9000, 0, '+0230')
,(@time_zone_id, 3, 9900, 0, '+0245')
,(@time_zone_id, 4, 10800, 0, 'EAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Ndjamena', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830387612, 1)
,(@time_zone_id, 308703600, 2)
,(@time_zone_id, 321314400, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 3612, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
,(@time_zone_id, 2, 7200, 1, 'WAST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Niamey', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Nouakchott', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Ouagadougou', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Porto-Novo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1588464816, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 816, 0, 'LMT')
,(@time_zone_id, 1, 3600, 0, 'WAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Sao_Tome', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1830384000, 2)
,(@time_zone_id, 1514768400, 3)
,(@time_zone_id, 1546304400, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 1616, 0, 'LMT')
,(@time_zone_id, 1, -2205, 0, 'LMT')
,(@time_zone_id, 2, 0, 0, 'GMT')
,(@time_zone_id, 3, 3600, 0, 'WAT')
,(@time_zone_id, 4, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Timbuktu', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830383032, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -968, 0, 'LMT')
,(@time_zone_id, 1, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Tripoli', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577926364, 2)
,(@time_zone_id, -574902000, 1)
,(@time_zone_id, -568087200, 2)
,(@time_zone_id, -512175600, 1)
,(@time_zone_id, -504928800, 2)
,(@time_zone_id, -449888400, 1)
,(@time_zone_id, -441856800, 2)
,(@time_zone_id, -347158800, 3)
,(@time_zone_id, 378684000, 2)
,(@time_zone_id, 386463600, 1)
,(@time_zone_id, 402271200, 2)
,(@time_zone_id, 417999600, 1)
,(@time_zone_id, 433807200, 2)
,(@time_zone_id, 449622000, 1)
,(@time_zone_id, 465429600, 2)
,(@time_zone_id, 481590000, 1)
,(@time_zone_id, 496965600, 2)
,(@time_zone_id, 512953200, 1)
,(@time_zone_id, 528674400, 2)
,(@time_zone_id, 544230000, 1)
,(@time_zone_id, 560037600, 2)
,(@time_zone_id, 575852400, 1)
,(@time_zone_id, 591660000, 2)
,(@time_zone_id, 607388400, 1)
,(@time_zone_id, 623196000, 2)
,(@time_zone_id, 641775600, 3)
,(@time_zone_id, 844034400, 2)
,(@time_zone_id, 860108400, 1)
,(@time_zone_id, 875916000, 3)
,(@time_zone_id, 1352505600, 2)
,(@time_zone_id, 1364515200, 1)
,(@time_zone_id, 1382659200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 3164, 0, 'LMT')
,(@time_zone_id, 1, 7200, 1, 'CEST')
,(@time_zone_id, 2, 3600, 0, 'CET')
,(@time_zone_id, 3, 7200, 0, 'EET')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Tunis', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1855958961, 4)
,(@time_zone_id, -969242400, 2)
,(@time_zone_id, -950493600, 3)
,(@time_zone_id, -941940000, 2)
,(@time_zone_id, -891136800, 4)
,(@time_zone_id, -877827600, 5)
,(@time_zone_id, -857257200, 4)
,(@time_zone_id, -844556400, 5)
,(@time_zone_id, -842918400, 4)
,(@time_zone_id, -842223600, 5)
,(@time_zone_id, -828230400, 4)
,(@time_zone_id, -812502000, 5)
,(@time_zone_id, -796269600, 4)
,(@time_zone_id, -781052400, 5)
,(@time_zone_id, -766634400, 4)
,(@time_zone_id, 231202800, 2)
,(@time_zone_id, 243903600, 3)
,(@time_zone_id, 262825200, 2)
,(@time_zone_id, 276044400, 3)
,(@time_zone_id, 581122800, 2)
,(@time_zone_id, 591145200, 3)
,(@time_zone_id, 606870000, 2)
,(@time_zone_id, 622594800, 3)
,(@time_zone_id, 641516400, 2)
,(@time_zone_id, 654649200, 3)
,(@time_zone_id, 1114902000, 2)
,(@time_zone_id, 1128038400, 3)
,(@time_zone_id, 1143334800, 2)
,(@time_zone_id, 1162083600, 3)
,(@time_zone_id, 1174784400, 2)
,(@time_zone_id, 1193533200, 3)
,(@time_zone_id, 1206838800, 2)
,(@time_zone_id, 1224982800, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 2444, 0, 'LMT')
,(@time_zone_id, 1, 561, 0, 'PMT')
,(@time_zone_id, 2, 7200, 1, 'CEST')
,(@time_zone_id, 3, 3600, 0, 'CET')
,(@time_zone_id, 4, 3600, 0, 'CET')
,(@time_zone_id, 5, 7200, 1, 'CEST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Africa/Windhoek', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2109288600, 2)
,(@time_zone_id, -860976000, 3)
,(@time_zone_id, -845254800, 2)
,(@time_zone_id, 637970400, 5)
,(@time_zone_id, 764200800, 4)
,(@time_zone_id, 778640400, 5)
,(@time_zone_id, 796780800, 4)
,(@time_zone_id, 810090000, 5)
,(@time_zone_id, 828835200, 4)
,(@time_zone_id, 841539600, 5)
,(@time_zone_id, 860284800, 4)
,(@time_zone_id, 873594000, 5)
,(@time_zone_id, 891734400, 4)
,(@time_zone_id, 905043600, 5)
,(@time_zone_id, 923184000, 4)
,(@time_zone_id, 936493200, 5)
,(@time_zone_id, 954633600, 4)
,(@time_zone_id, 967942800, 5)
,(@time_zone_id, 986083200, 4)
,(@time_zone_id, 999392400, 5)
,(@time_zone_id, 1018137600, 4)
,(@time_zone_id, 1030842000, 5)
,(@time_zone_id, 1049587200, 4)
,(@time_zone_id, 1062896400, 5)
,(@time_zone_id, 1081036800, 4)
,(@time_zone_id, 1094346000, 5)
,(@time_zone_id, 1112486400, 4)
,(@time_zone_id, 1125795600, 5)
,(@time_zone_id, 1143936000, 4)
,(@time_zone_id, 1157245200, 5)
,(@time_zone_id, 1175385600, 4)
,(@time_zone_id, 1188694800, 5)
,(@time_zone_id, 1207440000, 4)
,(@time_zone_id, 1220749200, 5)
,(@time_zone_id, 1238889600, 4)
,(@time_zone_id, 1252198800, 5)
,(@time_zone_id, 1270339200, 4)
,(@time_zone_id, 1283648400, 5)
,(@time_zone_id, 1301788800, 4)
,(@time_zone_id, 1315098000, 5)
,(@time_zone_id, 1333238400, 4)
,(@time_zone_id, 1346547600, 5)
,(@time_zone_id, 1365292800, 4)
,(@time_zone_id, 1377997200, 5)
,(@time_zone_id, 1396742400, 4)
,(@time_zone_id, 1410051600, 5)
,(@time_zone_id, 1428192000, 4)
,(@time_zone_id, 1441501200, 5)
,(@time_zone_id, 1459641600, 4)
,(@time_zone_id, 1472950800, 5)
,(@time_zone_id, 1491091200, 4)
,(@time_zone_id, 1504400400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 4104, 0, 'LMT')
,(@time_zone_id, 1, 5400, 0, '+0130')
,(@time_zone_id, 2, 7200, 0, 'SAST')
,(@time_zone_id, 3, 10800, 1, 'SAST')
,(@time_zone_id, 4, 3600, 1, 'WAT')
,(@time_zone_id, 5, 7200, 0, 'CAT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Adak', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -880196400, 2)
,(@time_zone_id, -769395600, 3)
,(@time_zone_id, -765374400, 1)
,(@time_zone_id, -86878800, 4)
,(@time_zone_id, -21466800, 5)
,(@time_zone_id, -5745600, 4)
,(@time_zone_id, 9982800, 5)
,(@time_zone_id, 25704000, 4)
,(@time_zone_id, 41432400, 5)
,(@time_zone_id, 57758400, 4)
,(@time_zone_id, 73486800, 5)
,(@time_zone_id, 89208000, 4)
,(@time_zone_id, 104936400, 5)
,(@time_zone_id, 120657600, 4)
,(@time_zone_id, 126709200, 5)
,(@time_zone_id, 152107200, 4)
,(@time_zone_id, 162392400, 5)
,(@time_zone_id, 183556800, 4)
,(@time_zone_id, 199285200, 5)
,(@time_zone_id, 215611200, 4)
,(@time_zone_id, 230734800, 5)
,(@time_zone_id, 247060800, 4)
,(@time_zone_id, 262789200, 5)
,(@time_zone_id, 278510400, 4)
,(@time_zone_id, 294238800, 5)
,(@time_zone_id, 309960000, 4)
,(@time_zone_id, 325688400, 5)
,(@time_zone_id, 341409600, 4)
,(@time_zone_id, 357138000, 5)
,(@time_zone_id, 372859200, 4)
,(@time_zone_id, 388587600, 5)
,(@time_zone_id, 404913600, 4)
,(@time_zone_id, 420037200, 5)
,(@time_zone_id, 436363200, 6)
,(@time_zone_id, 439034400, 8)
,(@time_zone_id, 452088000, 7)
,(@time_zone_id, 467809200, 8)
,(@time_zone_id, 483537600, 7)
,(@time_zone_id, 499258800, 8)
,(@time_zone_id, 514987200, 7)
,(@time_zone_id, 530708400, 8)
,(@time_zone_id, 544622400, 7)
,(@time_zone_id, 562158000, 8)
,(@time_zone_id, 576072000, 7)
,(@time_zone_id, 594212400, 8)
,(@time_zone_id, 607521600, 7)
,(@time_zone_id, 625662000, 8)
,(@time_zone_id, 638971200, 7)
,(@time_zone_id, 657111600, 8)
,(@time_zone_id, 671025600, 7)
,(@time_zone_id, 688561200, 8)
,(@time_zone_id, 702475200, 7)
,(@time_zone_id, 720010800, 8)
,(@time_zone_id, 733924800, 7)
,(@time_zone_id, 752065200, 8)
,(@time_zone_id, 765374400, 7)
,(@time_zone_id, 783514800, 8)
,(@time_zone_id, 796824000, 7)
,(@time_zone_id, 814964400, 8)
,(@time_zone_id, 828878400, 7)
,(@time_zone_id, 846414000, 8)
,(@time_zone_id, 860328000, 7)
,(@time_zone_id, 877863600, 8)
,(@time_zone_id, 891777600, 7)
,(@time_zone_id, 909313200, 8)
,(@time_zone_id, 923227200, 7)
,(@time_zone_id, 941367600, 8)
,(@time_zone_id, 954676800, 7)
,(@time_zone_id, 972817200, 8)
,(@time_zone_id, 986126400, 7)
,(@time_zone_id, 1004266800, 8)
,(@time_zone_id, 1018180800, 7)
,(@time_zone_id, 1035716400, 8)
,(@time_zone_id, 1049630400, 7)
,(@time_zone_id, 1067166000, 8)
,(@time_zone_id, 1081080000, 7)
,(@time_zone_id, 1099220400, 8)
,(@time_zone_id, 1112529600, 7)
,(@time_zone_id, 1130670000, 8)
,(@time_zone_id, 1143979200, 7)
,(@time_zone_id, 1162119600, 8)
,(@time_zone_id, 1173614400, 7)
,(@time_zone_id, 1194174000, 8)
,(@time_zone_id, 1205064000, 7)
,(@time_zone_id, 1225623600, 8)
,(@time_zone_id, 1236513600, 7)
,(@time_zone_id, 1257073200, 8)
,(@time_zone_id, 1268568000, 7)
,(@time_zone_id, 1289127600, 8)
,(@time_zone_id, 1300017600, 7)
,(@time_zone_id, 1320577200, 8)
,(@time_zone_id, 1331467200, 7)
,(@time_zone_id, 1352026800, 8)
,(@time_zone_id, 1362916800, 7)
,(@time_zone_id, 1383476400, 8)
,(@time_zone_id, 1394366400, 7)
,(@time_zone_id, 1414926000, 8)
,(@time_zone_id, 1425816000, 7)
,(@time_zone_id, 1446375600, 8)
,(@time_zone_id, 1457870400, 7)
,(@time_zone_id, 1478430000, 8)
,(@time_zone_id, 1489320000, 7)
,(@time_zone_id, 1509879600, 8)
,(@time_zone_id, 1520769600, 7)
,(@time_zone_id, 1541329200, 8)
,(@time_zone_id, 1552219200, 7)
,(@time_zone_id, 1572778800, 8)
,(@time_zone_id, 1583668800, 7)
,(@time_zone_id, 1604228400, 8)
,(@time_zone_id, 1615723200, 7)
,(@time_zone_id, 1636282800, 8)
,(@time_zone_id, 1647172800, 7)
,(@time_zone_id, 1667732400, 8)
,(@time_zone_id, 1678622400, 7)
,(@time_zone_id, 1699182000, 8)
,(@time_zone_id, 1710072000, 7)
,(@time_zone_id, 1730631600, 8)
,(@time_zone_id, 1741521600, 7)
,(@time_zone_id, 1762081200, 8)
,(@time_zone_id, 1772971200, 7)
,(@time_zone_id, 1793530800, 8)
,(@time_zone_id, 1805025600, 7)
,(@time_zone_id, 1825585200, 8)
,(@time_zone_id, 1836475200, 7)
,(@time_zone_id, 1857034800, 8)
,(@time_zone_id, 1867924800, 7)
,(@time_zone_id, 1888484400, 8)
,(@time_zone_id, 1899374400, 7)
,(@time_zone_id, 1919934000, 8)
,(@time_zone_id, 1930824000, 7)
,(@time_zone_id, 1951383600, 8)
,(@time_zone_id, 1962878400, 7)
,(@time_zone_id, 1983438000, 8)
,(@time_zone_id, 1994328000, 7)
,(@time_zone_id, 2014887600, 8)
,(@time_zone_id, 2025777600, 7)
,(@time_zone_id, 2046337200, 8)
,(@time_zone_id, 2057227200, 7)
,(@time_zone_id, 2077786800, 8)
,(@time_zone_id, 2088676800, 7)
,(@time_zone_id, 2109236400, 8)
,(@time_zone_id, 2120126400, 7)
,(@time_zone_id, 2140686000, 8)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -42398, 0, 'LMT')
,(@time_zone_id, 1, -39600, 0, 'NST')
,(@time_zone_id, 2, -36000, 1, 'NWT')
,(@time_zone_id, 3, -36000, 1, 'NPT')
,(@time_zone_id, 4, -39600, 0, 'BST')
,(@time_zone_id, 5, -36000, 1, 'BDT')
,(@time_zone_id, 6, -36000, 0, 'AHST')
,(@time_zone_id, 7, -32400, 1, 'HDT')
,(@time_zone_id, 8, -36000, 0, 'HST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Anchorage', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -880200000, 2)
,(@time_zone_id, -769395600, 3)
,(@time_zone_id, -765378000, 1)
,(@time_zone_id, -86882400, 4)
,(@time_zone_id, -21470400, 5)
,(@time_zone_id, -5749200, 4)
,(@time_zone_id, 9979200, 5)
,(@time_zone_id, 25700400, 4)
,(@time_zone_id, 41428800, 5)
,(@time_zone_id, 57754800, 4)
,(@time_zone_id, 73483200, 5)
,(@time_zone_id, 89204400, 4)
,(@time_zone_id, 104932800, 5)
,(@time_zone_id, 120654000, 4)
,(@time_zone_id, 126705600, 5)
,(@time_zone_id, 152103600, 4)
,(@time_zone_id, 162388800, 5)
,(@time_zone_id, 183553200, 4)
,(@time_zone_id, 199281600, 5)
,(@time_zone_id, 215607600, 4)
,(@time_zone_id, 230731200, 5)
,(@time_zone_id, 247057200, 4)
,(@time_zone_id, 262785600, 5)
,(@time_zone_id, 278506800, 4)
,(@time_zone_id, 294235200, 5)
,(@time_zone_id, 309956400, 4)
,(@time_zone_id, 325684800, 5)
,(@time_zone_id, 341406000, 4)
,(@time_zone_id, 357134400, 5)
,(@time_zone_id, 372855600, 4)
,(@time_zone_id, 388584000, 5)
,(@time_zone_id, 404910000, 4)
,(@time_zone_id, 420033600, 5)
,(@time_zone_id, 436359600, 6)
,(@time_zone_id, 439030800, 8)
,(@time_zone_id, 452084400, 7)
,(@time_zone_id, 467805600, 8)
,(@time_zone_id, 483534000, 7)
,(@time_zone_id, 499255200, 8)
,(@time_zone_id, 514983600, 7)
,(@time_zone_id, 530704800, 8)
,(@time_zone_id, 544618800, 7)
,(@time_zone_id, 562154400, 8)
,(@time_zone_id, 576068400, 7)
,(@time_zone_id, 594208800, 8)
,(@time_zone_id, 607518000, 7)
,(@time_zone_id, 625658400, 8)
,(@time_zone_id, 638967600, 7)
,(@time_zone_id, 657108000, 8)
,(@time_zone_id, 671022000, 7)
,(@time_zone_id, 688557600, 8)
,(@time_zone_id, 702471600, 7)
,(@time_zone_id, 720007200, 8)
,(@time_zone_id, 733921200, 7)
,(@time_zone_id, 752061600, 8)
,(@time_zone_id, 765370800, 7)
,(@time_zone_id, 783511200, 8)
,(@time_zone_id, 796820400, 7)
,(@time_zone_id, 814960800, 8)
,(@time_zone_id, 828874800, 7)
,(@time_zone_id, 846410400, 8)
,(@time_zone_id, 860324400, 7)
,(@time_zone_id, 877860000, 8)
,(@time_zone_id, 891774000, 7)
,(@time_zone_id, 909309600, 8)
,(@time_zone_id, 923223600, 7)
,(@time_zone_id, 941364000, 8)
,(@time_zone_id, 954673200, 7)
,(@time_zone_id, 972813600, 8)
,(@time_zone_id, 986122800, 7)
,(@time_zone_id, 1004263200, 8)
,(@time_zone_id, 1018177200, 7)
,(@time_zone_id, 1035712800, 8)
,(@time_zone_id, 1049626800, 7)
,(@time_zone_id, 1067162400, 8)
,(@time_zone_id, 1081076400, 7)
,(@time_zone_id, 1099216800, 8)
,(@time_zone_id, 1112526000, 7)
,(@time_zone_id, 1130666400, 8)
,(@time_zone_id, 1143975600, 7)
,(@time_zone_id, 1162116000, 8)
,(@time_zone_id, 1173610800, 7)
,(@time_zone_id, 1194170400, 8)
,(@time_zone_id, 1205060400, 7)
,(@time_zone_id, 1225620000, 8)
,(@time_zone_id, 1236510000, 7)
,(@time_zone_id, 1257069600, 8)
,(@time_zone_id, 1268564400, 7)
,(@time_zone_id, 1289124000, 8)
,(@time_zone_id, 1300014000, 7)
,(@time_zone_id, 1320573600, 8)
,(@time_zone_id, 1331463600, 7)
,(@time_zone_id, 1352023200, 8)
,(@time_zone_id, 1362913200, 7)
,(@time_zone_id, 1383472800, 8)
,(@time_zone_id, 1394362800, 7)
,(@time_zone_id, 1414922400, 8)
,(@time_zone_id, 1425812400, 7)
,(@time_zone_id, 1446372000, 8)
,(@time_zone_id, 1457866800, 7)
,(@time_zone_id, 1478426400, 8)
,(@time_zone_id, 1489316400, 7)
,(@time_zone_id, 1509876000, 8)
,(@time_zone_id, 1520766000, 7)
,(@time_zone_id, 1541325600, 8)
,(@time_zone_id, 1552215600, 7)
,(@time_zone_id, 1572775200, 8)
,(@time_zone_id, 1583665200, 7)
,(@time_zone_id, 1604224800, 8)
,(@time_zone_id, 1615719600, 7)
,(@time_zone_id, 1636279200, 8)
,(@time_zone_id, 1647169200, 7)
,(@time_zone_id, 1667728800, 8)
,(@time_zone_id, 1678618800, 7)
,(@time_zone_id, 1699178400, 8)
,(@time_zone_id, 1710068400, 7)
,(@time_zone_id, 1730628000, 8)
,(@time_zone_id, 1741518000, 7)
,(@time_zone_id, 1762077600, 8)
,(@time_zone_id, 1772967600, 7)
,(@time_zone_id, 1793527200, 8)
,(@time_zone_id, 1805022000, 7)
,(@time_zone_id, 1825581600, 8)
,(@time_zone_id, 1836471600, 7)
,(@time_zone_id, 1857031200, 8)
,(@time_zone_id, 1867921200, 7)
,(@time_zone_id, 1888480800, 8)
,(@time_zone_id, 1899370800, 7)
,(@time_zone_id, 1919930400, 8)
,(@time_zone_id, 1930820400, 7)
,(@time_zone_id, 1951380000, 8)
,(@time_zone_id, 1962874800, 7)
,(@time_zone_id, 1983434400, 8)
,(@time_zone_id, 1994324400, 7)
,(@time_zone_id, 2014884000, 8)
,(@time_zone_id, 2025774000, 7)
,(@time_zone_id, 2046333600, 8)
,(@time_zone_id, 2057223600, 7)
,(@time_zone_id, 2077783200, 8)
,(@time_zone_id, 2088673200, 7)
,(@time_zone_id, 2109232800, 8)
,(@time_zone_id, 2120122800, 7)
,(@time_zone_id, 2140682400, 8)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -35976, 0, 'LMT')
,(@time_zone_id, 1, -36000, 0, 'AST')
,(@time_zone_id, 2, -32400, 1, 'AWT')
,(@time_zone_id, 3, -32400, 1, 'APT')
,(@time_zone_id, 4, -36000, 0, 'AHST')
,(@time_zone_id, 5, -32400, 1, 'AHDT')
,(@time_zone_id, 6, -32400, 0, 'YST')
,(@time_zone_id, 7, -28800, 1, 'AKDT')
,(@time_zone_id, 8, -32400, 0, 'AKST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Anguilla', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Antigua', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Araguaina', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767214032, 2)
,(@time_zone_id, -1206957600, 1)
,(@time_zone_id, -1191362400, 2)
,(@time_zone_id, -1175374800, 1)
,(@time_zone_id, -1159826400, 2)
,(@time_zone_id, -633819600, 1)
,(@time_zone_id, -622069200, 2)
,(@time_zone_id, -602283600, 1)
,(@time_zone_id, -591832800, 2)
,(@time_zone_id, -570747600, 1)
,(@time_zone_id, -560210400, 2)
,(@time_zone_id, -539125200, 1)
,(@time_zone_id, -531352800, 2)
,(@time_zone_id, -191365200, 1)
,(@time_zone_id, -184197600, 2)
,(@time_zone_id, -155163600, 1)
,(@time_zone_id, -150069600, 2)
,(@time_zone_id, -128898000, 1)
,(@time_zone_id, -121125600, 2)
,(@time_zone_id, -99954000, 1)
,(@time_zone_id, -89589600, 2)
,(@time_zone_id, -68418000, 1)
,(@time_zone_id, -57967200, 2)
,(@time_zone_id, 499748400, 1)
,(@time_zone_id, 511236000, 2)
,(@time_zone_id, 530593200, 1)
,(@time_zone_id, 540266400, 2)
,(@time_zone_id, 562129200, 1)
,(@time_zone_id, 571197600, 2)
,(@time_zone_id, 592974000, 1)
,(@time_zone_id, 602042400, 2)
,(@time_zone_id, 624423600, 1)
,(@time_zone_id, 634701600, 2)
,(@time_zone_id, 813726000, 1)
,(@time_zone_id, 824004000, 2)
,(@time_zone_id, 844570800, 1)
,(@time_zone_id, 856058400, 2)
,(@time_zone_id, 876106800, 1)
,(@time_zone_id, 888717600, 2)
,(@time_zone_id, 908074800, 1)
,(@time_zone_id, 919562400, 2)
,(@time_zone_id, 938919600, 1)
,(@time_zone_id, 951616800, 2)
,(@time_zone_id, 970974000, 1)
,(@time_zone_id, 982461600, 2)
,(@time_zone_id, 1003028400, 1)
,(@time_zone_id, 1013911200, 2)
,(@time_zone_id, 1036292400, 1)
,(@time_zone_id, 1045360800, 2)
,(@time_zone_id, 1350788400, 1)
,(@time_zone_id, 1361066400, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -11568, 0, 'LMT')
,(@time_zone_id, 1, -7200, 1, '-02')
,(@time_zone_id, 2, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/Buenos_Aires', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 5)
,(@time_zone_id, 687927600, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
,(@time_zone_id, 1224385200, 4)
,(@time_zone_id, 1237082400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14028, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/Catamarca', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 2)
,(@time_zone_id, 687931200, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1086058800, 2)
,(@time_zone_id, 1087704000, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15788, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/ComodRivadavia', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 2)
,(@time_zone_id, 687931200, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1086058800, 2)
,(@time_zone_id, 1087704000, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15788, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/Cordoba', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 2)
,(@time_zone_id, 687931200, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
,(@time_zone_id, 1224385200, 4)
,(@time_zone_id, 1237082400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15408, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/Jujuy', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 2)
,(@time_zone_id, 657086400, 3)
,(@time_zone_id, 669178800, 2)
,(@time_zone_id, 686721600, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15672, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/La_Rioja', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667792800, 2)
,(@time_zone_id, 673588800, 5)
,(@time_zone_id, 687927600, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1086058800, 2)
,(@time_zone_id, 1087704000, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16044, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/Mendoza', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 2)
,(@time_zone_id, 655963200, 3)
,(@time_zone_id, 667796400, 2)
,(@time_zone_id, 687499200, 3)
,(@time_zone_id, 699418800, 2)
,(@time_zone_id, 719380800, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1085281200, 2)
,(@time_zone_id, 1096171200, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16516, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/Rio_Gallegos', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 5)
,(@time_zone_id, 687927600, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1086058800, 2)
,(@time_zone_id, 1087704000, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16612, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/Salta', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 2)
,(@time_zone_id, 687931200, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15700, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/San_Juan', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667792800, 2)
,(@time_zone_id, 673588800, 5)
,(@time_zone_id, 687927600, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1085972400, 2)
,(@time_zone_id, 1090728000, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16444, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/San_Luis', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 637380000, 2)
,(@time_zone_id, 655963200, 3)
,(@time_zone_id, 667796400, 2)
,(@time_zone_id, 675748800, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1085972400, 2)
,(@time_zone_id, 1090728000, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1200880800, 3)
,(@time_zone_id, 1205031600, 2)
,(@time_zone_id, 1223784000, 3)
,(@time_zone_id, 1236481200, 2)
,(@time_zone_id, 1255233600, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15924, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
,(@time_zone_id, 6, -10800, 1, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/Tucuman', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 2)
,(@time_zone_id, 687931200, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1086058800, 2)
,(@time_zone_id, 1087099200, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
,(@time_zone_id, 1224385200, 4)
,(@time_zone_id, 1237082400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15652, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Argentina/Ushuaia', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 5)
,(@time_zone_id, 687927600, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1085886000, 2)
,(@time_zone_id, 1087704000, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16392, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Aruba', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1826738653, 1)
,(@time_zone_id, -157750200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16547, 0, 'LMT')
,(@time_zone_id, 1, -16200, 0, '-0430')
,(@time_zone_id, 2, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Asuncion', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1206389360, 2)
,(@time_zone_id, 86760000, 3)
,(@time_zone_id, 134017200, 2)
,(@time_zone_id, 181368000, 4)
,(@time_zone_id, 194497200, 2)
,(@time_zone_id, 212990400, 4)
,(@time_zone_id, 226033200, 2)
,(@time_zone_id, 244526400, 4)
,(@time_zone_id, 257569200, 2)
,(@time_zone_id, 276062400, 4)
,(@time_zone_id, 291783600, 2)
,(@time_zone_id, 307598400, 4)
,(@time_zone_id, 323406000, 2)
,(@time_zone_id, 339220800, 4)
,(@time_zone_id, 354942000, 2)
,(@time_zone_id, 370756800, 4)
,(@time_zone_id, 386478000, 2)
,(@time_zone_id, 402292800, 4)
,(@time_zone_id, 418014000, 2)
,(@time_zone_id, 433828800, 4)
,(@time_zone_id, 449636400, 2)
,(@time_zone_id, 465451200, 4)
,(@time_zone_id, 481172400, 2)
,(@time_zone_id, 496987200, 4)
,(@time_zone_id, 512708400, 2)
,(@time_zone_id, 528523200, 4)
,(@time_zone_id, 544244400, 2)
,(@time_zone_id, 560059200, 4)
,(@time_zone_id, 575866800, 2)
,(@time_zone_id, 591681600, 4)
,(@time_zone_id, 607402800, 2)
,(@time_zone_id, 625032000, 4)
,(@time_zone_id, 638938800, 2)
,(@time_zone_id, 654753600, 4)
,(@time_zone_id, 670474800, 2)
,(@time_zone_id, 686721600, 4)
,(@time_zone_id, 699418800, 2)
,(@time_zone_id, 718257600, 4)
,(@time_zone_id, 733546800, 2)
,(@time_zone_id, 749448000, 4)
,(@time_zone_id, 762318000, 2)
,(@time_zone_id, 780984000, 4)
,(@time_zone_id, 793767600, 2)
,(@time_zone_id, 812520000, 4)
,(@time_zone_id, 825649200, 2)
,(@time_zone_id, 844574400, 4)
,(@time_zone_id, 856666800, 2)
,(@time_zone_id, 876024000, 4)
,(@time_zone_id, 888721200, 2)
,(@time_zone_id, 907473600, 4)
,(@time_zone_id, 920775600, 2)
,(@time_zone_id, 938923200, 4)
,(@time_zone_id, 952225200, 2)
,(@time_zone_id, 970372800, 4)
,(@time_zone_id, 983674800, 2)
,(@time_zone_id, 1002427200, 4)
,(@time_zone_id, 1018148400, 2)
,(@time_zone_id, 1030852800, 4)
,(@time_zone_id, 1049598000, 2)
,(@time_zone_id, 1062907200, 4)
,(@time_zone_id, 1081047600, 2)
,(@time_zone_id, 1097985600, 4)
,(@time_zone_id, 1110682800, 2)
,(@time_zone_id, 1129435200, 4)
,(@time_zone_id, 1142132400, 2)
,(@time_zone_id, 1160884800, 4)
,(@time_zone_id, 1173582000, 2)
,(@time_zone_id, 1192939200, 4)
,(@time_zone_id, 1205031600, 2)
,(@time_zone_id, 1224388800, 4)
,(@time_zone_id, 1236481200, 2)
,(@time_zone_id, 1255838400, 4)
,(@time_zone_id, 1270954800, 2)
,(@time_zone_id, 1286078400, 4)
,(@time_zone_id, 1302404400, 2)
,(@time_zone_id, 1317528000, 4)
,(@time_zone_id, 1333854000, 2)
,(@time_zone_id, 1349582400, 4)
,(@time_zone_id, 1364094000, 2)
,(@time_zone_id, 1381032000, 4)
,(@time_zone_id, 1395543600, 2)
,(@time_zone_id, 1412481600, 4)
,(@time_zone_id, 1426993200, 2)
,(@time_zone_id, 1443931200, 4)
,(@time_zone_id, 1459047600, 2)
,(@time_zone_id, 1475380800, 4)
,(@time_zone_id, 1490497200, 2)
,(@time_zone_id, 1506830400, 4)
,(@time_zone_id, 1521946800, 2)
,(@time_zone_id, 1538884800, 4)
,(@time_zone_id, 1553396400, 2)
,(@time_zone_id, 1570334400, 4)
,(@time_zone_id, 1584846000, 2)
,(@time_zone_id, 1601784000, 4)
,(@time_zone_id, 1616900400, 2)
,(@time_zone_id, 1633233600, 4)
,(@time_zone_id, 1648350000, 2)
,(@time_zone_id, 1664683200, 4)
,(@time_zone_id, 1679799600, 2)
,(@time_zone_id, 1696132800, 4)
,(@time_zone_id, 1711249200, 2)
,(@time_zone_id, 1728187200, 4)
,(@time_zone_id, 1742698800, 2)
,(@time_zone_id, 1759636800, 4)
,(@time_zone_id, 1774148400, 2)
,(@time_zone_id, 1791086400, 4)
,(@time_zone_id, 1806202800, 2)
,(@time_zone_id, 1822536000, 4)
,(@time_zone_id, 1837652400, 2)
,(@time_zone_id, 1853985600, 4)
,(@time_zone_id, 1869102000, 2)
,(@time_zone_id, 1886040000, 4)
,(@time_zone_id, 1900551600, 2)
,(@time_zone_id, 1917489600, 4)
,(@time_zone_id, 1932001200, 2)
,(@time_zone_id, 1948939200, 4)
,(@time_zone_id, 1964055600, 2)
,(@time_zone_id, 1980388800, 4)
,(@time_zone_id, 1995505200, 2)
,(@time_zone_id, 2011838400, 4)
,(@time_zone_id, 2026954800, 2)
,(@time_zone_id, 2043288000, 4)
,(@time_zone_id, 2058404400, 2)
,(@time_zone_id, 2075342400, 4)
,(@time_zone_id, 2089854000, 2)
,(@time_zone_id, 2106792000, 4)
,(@time_zone_id, 2121303600, 2)
,(@time_zone_id, 2138241600, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -13840, 0, 'LMT')
,(@time_zone_id, 1, -13840, 0, 'AMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 0, '-03')
,(@time_zone_id, 4, -10800, 1, '-03')
,(@time_zone_id, 5, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Atikokan', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632067200, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -923248800, 1)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21988, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Atka', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -880196400, 2)
,(@time_zone_id, -769395600, 3)
,(@time_zone_id, -765374400, 1)
,(@time_zone_id, -86878800, 4)
,(@time_zone_id, -21466800, 5)
,(@time_zone_id, -5745600, 4)
,(@time_zone_id, 9982800, 5)
,(@time_zone_id, 25704000, 4)
,(@time_zone_id, 41432400, 5)
,(@time_zone_id, 57758400, 4)
,(@time_zone_id, 73486800, 5)
,(@time_zone_id, 89208000, 4)
,(@time_zone_id, 104936400, 5)
,(@time_zone_id, 120657600, 4)
,(@time_zone_id, 126709200, 5)
,(@time_zone_id, 152107200, 4)
,(@time_zone_id, 162392400, 5)
,(@time_zone_id, 183556800, 4)
,(@time_zone_id, 199285200, 5)
,(@time_zone_id, 215611200, 4)
,(@time_zone_id, 230734800, 5)
,(@time_zone_id, 247060800, 4)
,(@time_zone_id, 262789200, 5)
,(@time_zone_id, 278510400, 4)
,(@time_zone_id, 294238800, 5)
,(@time_zone_id, 309960000, 4)
,(@time_zone_id, 325688400, 5)
,(@time_zone_id, 341409600, 4)
,(@time_zone_id, 357138000, 5)
,(@time_zone_id, 372859200, 4)
,(@time_zone_id, 388587600, 5)
,(@time_zone_id, 404913600, 4)
,(@time_zone_id, 420037200, 5)
,(@time_zone_id, 436363200, 6)
,(@time_zone_id, 439034400, 8)
,(@time_zone_id, 452088000, 7)
,(@time_zone_id, 467809200, 8)
,(@time_zone_id, 483537600, 7)
,(@time_zone_id, 499258800, 8)
,(@time_zone_id, 514987200, 7)
,(@time_zone_id, 530708400, 8)
,(@time_zone_id, 544622400, 7)
,(@time_zone_id, 562158000, 8)
,(@time_zone_id, 576072000, 7)
,(@time_zone_id, 594212400, 8)
,(@time_zone_id, 607521600, 7)
,(@time_zone_id, 625662000, 8)
,(@time_zone_id, 638971200, 7)
,(@time_zone_id, 657111600, 8)
,(@time_zone_id, 671025600, 7)
,(@time_zone_id, 688561200, 8)
,(@time_zone_id, 702475200, 7)
,(@time_zone_id, 720010800, 8)
,(@time_zone_id, 733924800, 7)
,(@time_zone_id, 752065200, 8)
,(@time_zone_id, 765374400, 7)
,(@time_zone_id, 783514800, 8)
,(@time_zone_id, 796824000, 7)
,(@time_zone_id, 814964400, 8)
,(@time_zone_id, 828878400, 7)
,(@time_zone_id, 846414000, 8)
,(@time_zone_id, 860328000, 7)
,(@time_zone_id, 877863600, 8)
,(@time_zone_id, 891777600, 7)
,(@time_zone_id, 909313200, 8)
,(@time_zone_id, 923227200, 7)
,(@time_zone_id, 941367600, 8)
,(@time_zone_id, 954676800, 7)
,(@time_zone_id, 972817200, 8)
,(@time_zone_id, 986126400, 7)
,(@time_zone_id, 1004266800, 8)
,(@time_zone_id, 1018180800, 7)
,(@time_zone_id, 1035716400, 8)
,(@time_zone_id, 1049630400, 7)
,(@time_zone_id, 1067166000, 8)
,(@time_zone_id, 1081080000, 7)
,(@time_zone_id, 1099220400, 8)
,(@time_zone_id, 1112529600, 7)
,(@time_zone_id, 1130670000, 8)
,(@time_zone_id, 1143979200, 7)
,(@time_zone_id, 1162119600, 8)
,(@time_zone_id, 1173614400, 7)
,(@time_zone_id, 1194174000, 8)
,(@time_zone_id, 1205064000, 7)
,(@time_zone_id, 1225623600, 8)
,(@time_zone_id, 1236513600, 7)
,(@time_zone_id, 1257073200, 8)
,(@time_zone_id, 1268568000, 7)
,(@time_zone_id, 1289127600, 8)
,(@time_zone_id, 1300017600, 7)
,(@time_zone_id, 1320577200, 8)
,(@time_zone_id, 1331467200, 7)
,(@time_zone_id, 1352026800, 8)
,(@time_zone_id, 1362916800, 7)
,(@time_zone_id, 1383476400, 8)
,(@time_zone_id, 1394366400, 7)
,(@time_zone_id, 1414926000, 8)
,(@time_zone_id, 1425816000, 7)
,(@time_zone_id, 1446375600, 8)
,(@time_zone_id, 1457870400, 7)
,(@time_zone_id, 1478430000, 8)
,(@time_zone_id, 1489320000, 7)
,(@time_zone_id, 1509879600, 8)
,(@time_zone_id, 1520769600, 7)
,(@time_zone_id, 1541329200, 8)
,(@time_zone_id, 1552219200, 7)
,(@time_zone_id, 1572778800, 8)
,(@time_zone_id, 1583668800, 7)
,(@time_zone_id, 1604228400, 8)
,(@time_zone_id, 1615723200, 7)
,(@time_zone_id, 1636282800, 8)
,(@time_zone_id, 1647172800, 7)
,(@time_zone_id, 1667732400, 8)
,(@time_zone_id, 1678622400, 7)
,(@time_zone_id, 1699182000, 8)
,(@time_zone_id, 1710072000, 7)
,(@time_zone_id, 1730631600, 8)
,(@time_zone_id, 1741521600, 7)
,(@time_zone_id, 1762081200, 8)
,(@time_zone_id, 1772971200, 7)
,(@time_zone_id, 1793530800, 8)
,(@time_zone_id, 1805025600, 7)
,(@time_zone_id, 1825585200, 8)
,(@time_zone_id, 1836475200, 7)
,(@time_zone_id, 1857034800, 8)
,(@time_zone_id, 1867924800, 7)
,(@time_zone_id, 1888484400, 8)
,(@time_zone_id, 1899374400, 7)
,(@time_zone_id, 1919934000, 8)
,(@time_zone_id, 1930824000, 7)
,(@time_zone_id, 1951383600, 8)
,(@time_zone_id, 1962878400, 7)
,(@time_zone_id, 1983438000, 8)
,(@time_zone_id, 1994328000, 7)
,(@time_zone_id, 2014887600, 8)
,(@time_zone_id, 2025777600, 7)
,(@time_zone_id, 2046337200, 8)
,(@time_zone_id, 2057227200, 7)
,(@time_zone_id, 2077786800, 8)
,(@time_zone_id, 2088676800, 7)
,(@time_zone_id, 2109236400, 8)
,(@time_zone_id, 2120126400, 7)
,(@time_zone_id, 2140686000, 8)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -42398, 0, 'LMT')
,(@time_zone_id, 1, -39600, 0, 'NST')
,(@time_zone_id, 2, -36000, 1, 'NWT')
,(@time_zone_id, 3, -36000, 1, 'NPT')
,(@time_zone_id, 4, -39600, 0, 'BST')
,(@time_zone_id, 5, -36000, 1, 'BDT')
,(@time_zone_id, 6, -36000, 0, 'AHST')
,(@time_zone_id, 7, -32400, 1, 'HDT')
,(@time_zone_id, 8, -36000, 0, 'HST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Bahia', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767216356, 2)
,(@time_zone_id, -1206957600, 1)
,(@time_zone_id, -1191362400, 2)
,(@time_zone_id, -1175374800, 1)
,(@time_zone_id, -1159826400, 2)
,(@time_zone_id, -633819600, 1)
,(@time_zone_id, -622069200, 2)
,(@time_zone_id, -602283600, 1)
,(@time_zone_id, -591832800, 2)
,(@time_zone_id, -570747600, 1)
,(@time_zone_id, -560210400, 2)
,(@time_zone_id, -539125200, 1)
,(@time_zone_id, -531352800, 2)
,(@time_zone_id, -191365200, 1)
,(@time_zone_id, -184197600, 2)
,(@time_zone_id, -155163600, 1)
,(@time_zone_id, -150069600, 2)
,(@time_zone_id, -128898000, 1)
,(@time_zone_id, -121125600, 2)
,(@time_zone_id, -99954000, 1)
,(@time_zone_id, -89589600, 2)
,(@time_zone_id, -68418000, 1)
,(@time_zone_id, -57967200, 2)
,(@time_zone_id, 499748400, 1)
,(@time_zone_id, 511236000, 2)
,(@time_zone_id, 530593200, 1)
,(@time_zone_id, 540266400, 2)
,(@time_zone_id, 562129200, 1)
,(@time_zone_id, 571197600, 2)
,(@time_zone_id, 592974000, 1)
,(@time_zone_id, 602042400, 2)
,(@time_zone_id, 624423600, 1)
,(@time_zone_id, 634701600, 2)
,(@time_zone_id, 656478000, 1)
,(@time_zone_id, 666756000, 2)
,(@time_zone_id, 687927600, 1)
,(@time_zone_id, 697600800, 2)
,(@time_zone_id, 719982000, 1)
,(@time_zone_id, 728445600, 2)
,(@time_zone_id, 750826800, 1)
,(@time_zone_id, 761709600, 2)
,(@time_zone_id, 782276400, 1)
,(@time_zone_id, 793159200, 2)
,(@time_zone_id, 813726000, 1)
,(@time_zone_id, 824004000, 2)
,(@time_zone_id, 844570800, 1)
,(@time_zone_id, 856058400, 2)
,(@time_zone_id, 876106800, 1)
,(@time_zone_id, 888717600, 2)
,(@time_zone_id, 908074800, 1)
,(@time_zone_id, 919562400, 2)
,(@time_zone_id, 938919600, 1)
,(@time_zone_id, 951616800, 2)
,(@time_zone_id, 970974000, 1)
,(@time_zone_id, 982461600, 2)
,(@time_zone_id, 1003028400, 1)
,(@time_zone_id, 1013911200, 2)
,(@time_zone_id, 1036292400, 1)
,(@time_zone_id, 1045360800, 2)
,(@time_zone_id, 1318734000, 1)
,(@time_zone_id, 1330221600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -9244, 0, 'LMT')
,(@time_zone_id, 1, -7200, 1, '-02')
,(@time_zone_id, 2, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Bahia_Banderas', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514739600, 1)
,(@time_zone_id, -1343066400, 2)
,(@time_zone_id, -1234807200, 1)
,(@time_zone_id, -1220292000, 2)
,(@time_zone_id, -1207159200, 1)
,(@time_zone_id, -1191344400, 2)
,(@time_zone_id, -873828000, 1)
,(@time_zone_id, -661539600, 3)
,(@time_zone_id, 28800, 1)
,(@time_zone_id, 828867600, 4)
,(@time_zone_id, 846403200, 1)
,(@time_zone_id, 860317200, 4)
,(@time_zone_id, 877852800, 1)
,(@time_zone_id, 891766800, 4)
,(@time_zone_id, 909302400, 1)
,(@time_zone_id, 923216400, 4)
,(@time_zone_id, 941356800, 1)
,(@time_zone_id, 954666000, 4)
,(@time_zone_id, 972806400, 1)
,(@time_zone_id, 989139600, 4)
,(@time_zone_id, 1001836800, 1)
,(@time_zone_id, 1018170000, 4)
,(@time_zone_id, 1035705600, 1)
,(@time_zone_id, 1049619600, 4)
,(@time_zone_id, 1067155200, 1)
,(@time_zone_id, 1081069200, 4)
,(@time_zone_id, 1099209600, 1)
,(@time_zone_id, 1112518800, 4)
,(@time_zone_id, 1130659200, 1)
,(@time_zone_id, 1143968400, 4)
,(@time_zone_id, 1162108800, 1)
,(@time_zone_id, 1175418000, 4)
,(@time_zone_id, 1193558400, 1)
,(@time_zone_id, 1207472400, 4)
,(@time_zone_id, 1225008000, 1)
,(@time_zone_id, 1238922000, 4)
,(@time_zone_id, 1256457600, 1)
,(@time_zone_id, 1270371600, 5)
,(@time_zone_id, 1288508400, 2)
,(@time_zone_id, 1301817600, 5)
,(@time_zone_id, 1319958000, 2)
,(@time_zone_id, 1333267200, 5)
,(@time_zone_id, 1351407600, 2)
,(@time_zone_id, 1365321600, 5)
,(@time_zone_id, 1382857200, 2)
,(@time_zone_id, 1396771200, 5)
,(@time_zone_id, 1414306800, 2)
,(@time_zone_id, 1428220800, 5)
,(@time_zone_id, 1445756400, 2)
,(@time_zone_id, 1459670400, 5)
,(@time_zone_id, 1477810800, 2)
,(@time_zone_id, 1491120000, 5)
,(@time_zone_id, 1509260400, 2)
,(@time_zone_id, 1522569600, 5)
,(@time_zone_id, 1540710000, 2)
,(@time_zone_id, 1554624000, 5)
,(@time_zone_id, 1572159600, 2)
,(@time_zone_id, 1586073600, 5)
,(@time_zone_id, 1603609200, 2)
,(@time_zone_id, 1617523200, 5)
,(@time_zone_id, 1635663600, 2)
,(@time_zone_id, 1648972800, 5)
,(@time_zone_id, 1667113200, 2)
,(@time_zone_id, 1680422400, 5)
,(@time_zone_id, 1698562800, 2)
,(@time_zone_id, 1712476800, 5)
,(@time_zone_id, 1730012400, 2)
,(@time_zone_id, 1743926400, 5)
,(@time_zone_id, 1761462000, 2)
,(@time_zone_id, 1775376000, 5)
,(@time_zone_id, 1792911600, 2)
,(@time_zone_id, 1806825600, 5)
,(@time_zone_id, 1824966000, 2)
,(@time_zone_id, 1838275200, 5)
,(@time_zone_id, 1856415600, 2)
,(@time_zone_id, 1869724800, 5)
,(@time_zone_id, 1887865200, 2)
,(@time_zone_id, 1901779200, 5)
,(@time_zone_id, 1919314800, 2)
,(@time_zone_id, 1933228800, 5)
,(@time_zone_id, 1950764400, 2)
,(@time_zone_id, 1964678400, 5)
,(@time_zone_id, 1982818800, 2)
,(@time_zone_id, 1996128000, 5)
,(@time_zone_id, 2014268400, 2)
,(@time_zone_id, 2027577600, 5)
,(@time_zone_id, 2045718000, 2)
,(@time_zone_id, 2059027200, 5)
,(@time_zone_id, 2077167600, 2)
,(@time_zone_id, 2091081600, 5)
,(@time_zone_id, 2108617200, 2)
,(@time_zone_id, 2122531200, 5)
,(@time_zone_id, 2140066800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -25260, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -28800, 0, 'PST')
,(@time_zone_id, 4, -21600, 1, 'MDT')
,(@time_zone_id, 5, -18000, 1, 'CDT')
,(@time_zone_id, 6, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Barbados', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1451678491, 1)
,(@time_zone_id, -1199217691, 3)
,(@time_zone_id, 234943200, 2)
,(@time_zone_id, 244616400, 3)
,(@time_zone_id, 261554400, 2)
,(@time_zone_id, 276066000, 3)
,(@time_zone_id, 293004000, 2)
,(@time_zone_id, 307515600, 3)
,(@time_zone_id, 325058400, 2)
,(@time_zone_id, 338706000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14309, 0, 'LMT')
,(@time_zone_id, 1, -14309, 0, 'BMT')
,(@time_zone_id, 2, -10800, 1, 'ADT')
,(@time_zone_id, 3, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Belem', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767213964, 2)
,(@time_zone_id, -1206957600, 1)
,(@time_zone_id, -1191362400, 2)
,(@time_zone_id, -1175374800, 1)
,(@time_zone_id, -1159826400, 2)
,(@time_zone_id, -633819600, 1)
,(@time_zone_id, -622069200, 2)
,(@time_zone_id, -602283600, 1)
,(@time_zone_id, -591832800, 2)
,(@time_zone_id, -570747600, 1)
,(@time_zone_id, -560210400, 2)
,(@time_zone_id, -539125200, 1)
,(@time_zone_id, -531352800, 2)
,(@time_zone_id, -191365200, 1)
,(@time_zone_id, -184197600, 2)
,(@time_zone_id, -155163600, 1)
,(@time_zone_id, -150069600, 2)
,(@time_zone_id, -128898000, 1)
,(@time_zone_id, -121125600, 2)
,(@time_zone_id, -99954000, 1)
,(@time_zone_id, -89589600, 2)
,(@time_zone_id, -68418000, 1)
,(@time_zone_id, -57967200, 2)
,(@time_zone_id, 499748400, 1)
,(@time_zone_id, 511236000, 2)
,(@time_zone_id, 530593200, 1)
,(@time_zone_id, 540266400, 2)
,(@time_zone_id, 562129200, 1)
,(@time_zone_id, 571197600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -11636, 0, 'LMT')
,(@time_zone_id, 1, -7200, 1, '-02')
,(@time_zone_id, 2, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Belize', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1822500432, 2)
,(@time_zone_id, -1616954400, 1)
,(@time_zone_id, -1606069800, 2)
,(@time_zone_id, -1585504800, 1)
,(@time_zone_id, -1574015400, 2)
,(@time_zone_id, -1554055200, 1)
,(@time_zone_id, -1542565800, 2)
,(@time_zone_id, -1522605600, 1)
,(@time_zone_id, -1511116200, 2)
,(@time_zone_id, -1490551200, 1)
,(@time_zone_id, -1479666600, 2)
,(@time_zone_id, -1459101600, 1)
,(@time_zone_id, -1448217000, 2)
,(@time_zone_id, -1427652000, 1)
,(@time_zone_id, -1416162600, 2)
,(@time_zone_id, -1396202400, 1)
,(@time_zone_id, -1384713000, 2)
,(@time_zone_id, -1364752800, 1)
,(@time_zone_id, -1353263400, 2)
,(@time_zone_id, -1333303200, 1)
,(@time_zone_id, -1321813800, 2)
,(@time_zone_id, -1301248800, 1)
,(@time_zone_id, -1290364200, 2)
,(@time_zone_id, -1269799200, 1)
,(@time_zone_id, -1258914600, 2)
,(@time_zone_id, -1238349600, 1)
,(@time_zone_id, -1226860200, 2)
,(@time_zone_id, -1206900000, 1)
,(@time_zone_id, -1195410600, 2)
,(@time_zone_id, -1175450400, 1)
,(@time_zone_id, -1163961000, 2)
,(@time_zone_id, -1143396000, 1)
,(@time_zone_id, -1132511400, 2)
,(@time_zone_id, -1111946400, 1)
,(@time_zone_id, -1101061800, 2)
,(@time_zone_id, -1080496800, 1)
,(@time_zone_id, -1069612200, 2)
,(@time_zone_id, -1049047200, 1)
,(@time_zone_id, -1037557800, 2)
,(@time_zone_id, -1017597600, 1)
,(@time_zone_id, -1006108200, 2)
,(@time_zone_id, -986148000, 1)
,(@time_zone_id, -974658600, 2)
,(@time_zone_id, -954093600, 1)
,(@time_zone_id, -943209000, 2)
,(@time_zone_id, -922644000, 1)
,(@time_zone_id, -911759400, 2)
,(@time_zone_id, -891194400, 1)
,(@time_zone_id, -879705000, 2)
,(@time_zone_id, -859744800, 1)
,(@time_zone_id, -848255400, 2)
,(@time_zone_id, 123919200, 3)
,(@time_zone_id, 129618000, 2)
,(@time_zone_id, 409039200, 3)
,(@time_zone_id, 413874000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21168, 0, 'LMT')
,(@time_zone_id, 1, -19800, 1, '-0530')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Blanc-Sablon', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632074400, 1)
,(@time_zone_id, -1615143600, 2)
,(@time_zone_id, -880221600, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765399600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -13708, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, 'ADT')
,(@time_zone_id, 2, -14400, 0, 'AST')
,(@time_zone_id, 3, -10800, 1, 'AWT')
,(@time_zone_id, 4, -10800, 1, 'APT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Boa_Vista', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767211040, 2)
,(@time_zone_id, -1206954000, 1)
,(@time_zone_id, -1191358800, 2)
,(@time_zone_id, -1175371200, 1)
,(@time_zone_id, -1159822800, 2)
,(@time_zone_id, -633816000, 1)
,(@time_zone_id, -622065600, 2)
,(@time_zone_id, -602280000, 1)
,(@time_zone_id, -591829200, 2)
,(@time_zone_id, -570744000, 1)
,(@time_zone_id, -560206800, 2)
,(@time_zone_id, -539121600, 1)
,(@time_zone_id, -531349200, 2)
,(@time_zone_id, -191361600, 1)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -155160000, 1)
,(@time_zone_id, -150066000, 2)
,(@time_zone_id, -128894400, 1)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -99950400, 1)
,(@time_zone_id, -89586000, 2)
,(@time_zone_id, -68414400, 1)
,(@time_zone_id, -57963600, 2)
,(@time_zone_id, 499752000, 1)
,(@time_zone_id, 511239600, 2)
,(@time_zone_id, 530596800, 1)
,(@time_zone_id, 540270000, 2)
,(@time_zone_id, 562132800, 1)
,(@time_zone_id, 571201200, 2)
,(@time_zone_id, 938923200, 1)
,(@time_zone_id, 951620400, 2)
,(@time_zone_id, 970977600, 1)
,(@time_zone_id, 971578800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14560, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, '-03')
,(@time_zone_id, 2, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Bogota', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1739041424, 3)
,(@time_zone_id, 704869200, 2)
,(@time_zone_id, 733896000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -17776, 0, 'LMT')
,(@time_zone_id, 1, -17776, 0, 'BMT')
,(@time_zone_id, 2, -14400, 1, '-04')
,(@time_zone_id, 3, -18000, 0, '-05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Boise', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633269600, 1)
,(@time_zone_id, -1615129200, 2)
,(@time_zone_id, -1601820000, 1)
,(@time_zone_id, -1583679600, 2)
,(@time_zone_id, -1471788000, 5)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765388800, 5)
,(@time_zone_id, -84380400, 6)
,(@time_zone_id, -68659200, 5)
,(@time_zone_id, -52930800, 6)
,(@time_zone_id, -37209600, 5)
,(@time_zone_id, -21481200, 6)
,(@time_zone_id, -5760000, 5)
,(@time_zone_id, 9968400, 6)
,(@time_zone_id, 25689600, 5)
,(@time_zone_id, 41418000, 6)
,(@time_zone_id, 57744000, 5)
,(@time_zone_id, 73472400, 6)
,(@time_zone_id, 89193600, 5)
,(@time_zone_id, 104922000, 6)
,(@time_zone_id, 120643200, 5)
,(@time_zone_id, 129114000, 6)
,(@time_zone_id, 152092800, 5)
,(@time_zone_id, 162378000, 6)
,(@time_zone_id, 183542400, 5)
,(@time_zone_id, 199270800, 6)
,(@time_zone_id, 215596800, 5)
,(@time_zone_id, 230720400, 6)
,(@time_zone_id, 247046400, 5)
,(@time_zone_id, 262774800, 6)
,(@time_zone_id, 278496000, 5)
,(@time_zone_id, 294224400, 6)
,(@time_zone_id, 309945600, 5)
,(@time_zone_id, 325674000, 6)
,(@time_zone_id, 341395200, 5)
,(@time_zone_id, 357123600, 6)
,(@time_zone_id, 372844800, 5)
,(@time_zone_id, 388573200, 6)
,(@time_zone_id, 404899200, 5)
,(@time_zone_id, 420022800, 6)
,(@time_zone_id, 436348800, 5)
,(@time_zone_id, 452077200, 6)
,(@time_zone_id, 467798400, 5)
,(@time_zone_id, 483526800, 6)
,(@time_zone_id, 499248000, 5)
,(@time_zone_id, 514976400, 6)
,(@time_zone_id, 530697600, 5)
,(@time_zone_id, 544611600, 6)
,(@time_zone_id, 562147200, 5)
,(@time_zone_id, 576061200, 6)
,(@time_zone_id, 594201600, 5)
,(@time_zone_id, 607510800, 6)
,(@time_zone_id, 625651200, 5)
,(@time_zone_id, 638960400, 6)
,(@time_zone_id, 657100800, 5)
,(@time_zone_id, 671014800, 6)
,(@time_zone_id, 688550400, 5)
,(@time_zone_id, 702464400, 6)
,(@time_zone_id, 720000000, 5)
,(@time_zone_id, 733914000, 6)
,(@time_zone_id, 752054400, 5)
,(@time_zone_id, 765363600, 6)
,(@time_zone_id, 783504000, 5)
,(@time_zone_id, 796813200, 6)
,(@time_zone_id, 814953600, 5)
,(@time_zone_id, 828867600, 6)
,(@time_zone_id, 846403200, 5)
,(@time_zone_id, 860317200, 6)
,(@time_zone_id, 877852800, 5)
,(@time_zone_id, 891766800, 6)
,(@time_zone_id, 909302400, 5)
,(@time_zone_id, 923216400, 6)
,(@time_zone_id, 941356800, 5)
,(@time_zone_id, 954666000, 6)
,(@time_zone_id, 972806400, 5)
,(@time_zone_id, 986115600, 6)
,(@time_zone_id, 1004256000, 5)
,(@time_zone_id, 1018170000, 6)
,(@time_zone_id, 1035705600, 5)
,(@time_zone_id, 1049619600, 6)
,(@time_zone_id, 1067155200, 5)
,(@time_zone_id, 1081069200, 6)
,(@time_zone_id, 1099209600, 5)
,(@time_zone_id, 1112518800, 6)
,(@time_zone_id, 1130659200, 5)
,(@time_zone_id, 1143968400, 6)
,(@time_zone_id, 1162108800, 5)
,(@time_zone_id, 1173603600, 6)
,(@time_zone_id, 1194163200, 5)
,(@time_zone_id, 1205053200, 6)
,(@time_zone_id, 1225612800, 5)
,(@time_zone_id, 1236502800, 6)
,(@time_zone_id, 1257062400, 5)
,(@time_zone_id, 1268557200, 6)
,(@time_zone_id, 1289116800, 5)
,(@time_zone_id, 1300006800, 6)
,(@time_zone_id, 1320566400, 5)
,(@time_zone_id, 1331456400, 6)
,(@time_zone_id, 1352016000, 5)
,(@time_zone_id, 1362906000, 6)
,(@time_zone_id, 1383465600, 5)
,(@time_zone_id, 1394355600, 6)
,(@time_zone_id, 1414915200, 5)
,(@time_zone_id, 1425805200, 6)
,(@time_zone_id, 1446364800, 5)
,(@time_zone_id, 1457859600, 6)
,(@time_zone_id, 1478419200, 5)
,(@time_zone_id, 1489309200, 6)
,(@time_zone_id, 1509868800, 5)
,(@time_zone_id, 1520758800, 6)
,(@time_zone_id, 1541318400, 5)
,(@time_zone_id, 1552208400, 6)
,(@time_zone_id, 1572768000, 5)
,(@time_zone_id, 1583658000, 6)
,(@time_zone_id, 1604217600, 5)
,(@time_zone_id, 1615712400, 6)
,(@time_zone_id, 1636272000, 5)
,(@time_zone_id, 1647162000, 6)
,(@time_zone_id, 1667721600, 5)
,(@time_zone_id, 1678611600, 6)
,(@time_zone_id, 1699171200, 5)
,(@time_zone_id, 1710061200, 6)
,(@time_zone_id, 1730620800, 5)
,(@time_zone_id, 1741510800, 6)
,(@time_zone_id, 1762070400, 5)
,(@time_zone_id, 1772960400, 6)
,(@time_zone_id, 1793520000, 5)
,(@time_zone_id, 1805014800, 6)
,(@time_zone_id, 1825574400, 5)
,(@time_zone_id, 1836464400, 6)
,(@time_zone_id, 1857024000, 5)
,(@time_zone_id, 1867914000, 6)
,(@time_zone_id, 1888473600, 5)
,(@time_zone_id, 1899363600, 6)
,(@time_zone_id, 1919923200, 5)
,(@time_zone_id, 1930813200, 6)
,(@time_zone_id, 1951372800, 5)
,(@time_zone_id, 1962867600, 6)
,(@time_zone_id, 1983427200, 5)
,(@time_zone_id, 1994317200, 6)
,(@time_zone_id, 2014876800, 5)
,(@time_zone_id, 2025766800, 6)
,(@time_zone_id, 2046326400, 5)
,(@time_zone_id, 2057216400, 6)
,(@time_zone_id, 2077776000, 5)
,(@time_zone_id, 2088666000, 6)
,(@time_zone_id, 2109225600, 5)
,(@time_zone_id, 2120115600, 6)
,(@time_zone_id, 2140675200, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -27889, 0, 'LMT')
,(@time_zone_id, 1, -25200, 1, 'PDT')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
,(@time_zone_id, 4, -21600, 1, 'MPT')
,(@time_zone_id, 5, -25200, 0, 'MST')
,(@time_zone_id, 6, -21600, 1, 'MDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Buenos_Aires', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 5)
,(@time_zone_id, 687927600, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
,(@time_zone_id, 1224385200, 4)
,(@time_zone_id, 1237082400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14028, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Cambridge_Bay', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577923200, 3)
,(@time_zone_id, -880210800, 1)
,(@time_zone_id, -769395600, 2)
,(@time_zone_id, -765388800, 3)
,(@time_zone_id, -147891600, 4)
,(@time_zone_id, -131562000, 3)
,(@time_zone_id, 325674000, 5)
,(@time_zone_id, 341395200, 3)
,(@time_zone_id, 357123600, 5)
,(@time_zone_id, 372844800, 3)
,(@time_zone_id, 388573200, 5)
,(@time_zone_id, 404899200, 3)
,(@time_zone_id, 420022800, 5)
,(@time_zone_id, 436348800, 3)
,(@time_zone_id, 452077200, 5)
,(@time_zone_id, 467798400, 3)
,(@time_zone_id, 483526800, 5)
,(@time_zone_id, 499248000, 3)
,(@time_zone_id, 514976400, 5)
,(@time_zone_id, 530697600, 3)
,(@time_zone_id, 544611600, 5)
,(@time_zone_id, 562147200, 3)
,(@time_zone_id, 576061200, 5)
,(@time_zone_id, 594201600, 3)
,(@time_zone_id, 607510800, 5)
,(@time_zone_id, 625651200, 3)
,(@time_zone_id, 638960400, 5)
,(@time_zone_id, 657100800, 3)
,(@time_zone_id, 671014800, 5)
,(@time_zone_id, 688550400, 3)
,(@time_zone_id, 702464400, 5)
,(@time_zone_id, 720000000, 3)
,(@time_zone_id, 733914000, 5)
,(@time_zone_id, 752054400, 3)
,(@time_zone_id, 765363600, 5)
,(@time_zone_id, 783504000, 3)
,(@time_zone_id, 796813200, 5)
,(@time_zone_id, 814953600, 3)
,(@time_zone_id, 828867600, 5)
,(@time_zone_id, 846403200, 3)
,(@time_zone_id, 860317200, 5)
,(@time_zone_id, 877852800, 3)
,(@time_zone_id, 891766800, 5)
,(@time_zone_id, 909302400, 3)
,(@time_zone_id, 923216400, 5)
,(@time_zone_id, 941356800, 7)
,(@time_zone_id, 954662400, 6)
,(@time_zone_id, 972802800, 8)
,(@time_zone_id, 973400400, 7)
,(@time_zone_id, 986115600, 5)
,(@time_zone_id, 1004256000, 3)
,(@time_zone_id, 1018170000, 5)
,(@time_zone_id, 1035705600, 3)
,(@time_zone_id, 1049619600, 5)
,(@time_zone_id, 1067155200, 3)
,(@time_zone_id, 1081069200, 5)
,(@time_zone_id, 1099209600, 3)
,(@time_zone_id, 1112518800, 5)
,(@time_zone_id, 1130659200, 3)
,(@time_zone_id, 1143968400, 5)
,(@time_zone_id, 1162108800, 3)
,(@time_zone_id, 1173603600, 5)
,(@time_zone_id, 1194163200, 3)
,(@time_zone_id, 1205053200, 5)
,(@time_zone_id, 1225612800, 3)
,(@time_zone_id, 1236502800, 5)
,(@time_zone_id, 1257062400, 3)
,(@time_zone_id, 1268557200, 5)
,(@time_zone_id, 1289116800, 3)
,(@time_zone_id, 1300006800, 5)
,(@time_zone_id, 1320566400, 3)
,(@time_zone_id, 1331456400, 5)
,(@time_zone_id, 1352016000, 3)
,(@time_zone_id, 1362906000, 5)
,(@time_zone_id, 1383465600, 3)
,(@time_zone_id, 1394355600, 5)
,(@time_zone_id, 1414915200, 3)
,(@time_zone_id, 1425805200, 5)
,(@time_zone_id, 1446364800, 3)
,(@time_zone_id, 1457859600, 5)
,(@time_zone_id, 1478419200, 3)
,(@time_zone_id, 1489309200, 5)
,(@time_zone_id, 1509868800, 3)
,(@time_zone_id, 1520758800, 5)
,(@time_zone_id, 1541318400, 3)
,(@time_zone_id, 1552208400, 5)
,(@time_zone_id, 1572768000, 3)
,(@time_zone_id, 1583658000, 5)
,(@time_zone_id, 1604217600, 3)
,(@time_zone_id, 1615712400, 5)
,(@time_zone_id, 1636272000, 3)
,(@time_zone_id, 1647162000, 5)
,(@time_zone_id, 1667721600, 3)
,(@time_zone_id, 1678611600, 5)
,(@time_zone_id, 1699171200, 3)
,(@time_zone_id, 1710061200, 5)
,(@time_zone_id, 1730620800, 3)
,(@time_zone_id, 1741510800, 5)
,(@time_zone_id, 1762070400, 3)
,(@time_zone_id, 1772960400, 5)
,(@time_zone_id, 1793520000, 3)
,(@time_zone_id, 1805014800, 5)
,(@time_zone_id, 1825574400, 3)
,(@time_zone_id, 1836464400, 5)
,(@time_zone_id, 1857024000, 3)
,(@time_zone_id, 1867914000, 5)
,(@time_zone_id, 1888473600, 3)
,(@time_zone_id, 1899363600, 5)
,(@time_zone_id, 1919923200, 3)
,(@time_zone_id, 1930813200, 5)
,(@time_zone_id, 1951372800, 3)
,(@time_zone_id, 1962867600, 5)
,(@time_zone_id, 1983427200, 3)
,(@time_zone_id, 1994317200, 5)
,(@time_zone_id, 2014876800, 3)
,(@time_zone_id, 2025766800, 5)
,(@time_zone_id, 2046326400, 3)
,(@time_zone_id, 2057216400, 5)
,(@time_zone_id, 2077776000, 3)
,(@time_zone_id, 2088666000, 5)
,(@time_zone_id, 2109225600, 3)
,(@time_zone_id, 2120115600, 5)
,(@time_zone_id, 2140675200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, -21600, 1, 'MWT')
,(@time_zone_id, 2, -21600, 1, 'MPT')
,(@time_zone_id, 3, -25200, 0, 'MST')
,(@time_zone_id, 4, -18000, 1, 'MDDT')
,(@time_zone_id, 5, -21600, 1, 'MDT')
,(@time_zone_id, 6, -18000, 1, 'CDT')
,(@time_zone_id, 7, -21600, 0, 'CST')
,(@time_zone_id, 8, -18000, 0, 'EST')
,(@time_zone_id, 9, -21600, 1, 'MDT')
,(@time_zone_id, 10, -25200, 0, 'MST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Campo_Grande', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767212492, 2)
,(@time_zone_id, -1206954000, 1)
,(@time_zone_id, -1191358800, 2)
,(@time_zone_id, -1175371200, 1)
,(@time_zone_id, -1159822800, 2)
,(@time_zone_id, -633816000, 1)
,(@time_zone_id, -622065600, 2)
,(@time_zone_id, -602280000, 1)
,(@time_zone_id, -591829200, 2)
,(@time_zone_id, -570744000, 1)
,(@time_zone_id, -560206800, 2)
,(@time_zone_id, -539121600, 1)
,(@time_zone_id, -531349200, 2)
,(@time_zone_id, -191361600, 1)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -155160000, 1)
,(@time_zone_id, -150066000, 2)
,(@time_zone_id, -128894400, 1)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -99950400, 1)
,(@time_zone_id, -89586000, 2)
,(@time_zone_id, -68414400, 1)
,(@time_zone_id, -57963600, 2)
,(@time_zone_id, 499752000, 1)
,(@time_zone_id, 511239600, 2)
,(@time_zone_id, 530596800, 1)
,(@time_zone_id, 540270000, 2)
,(@time_zone_id, 562132800, 1)
,(@time_zone_id, 571201200, 2)
,(@time_zone_id, 592977600, 1)
,(@time_zone_id, 602046000, 2)
,(@time_zone_id, 624427200, 1)
,(@time_zone_id, 634705200, 2)
,(@time_zone_id, 656481600, 1)
,(@time_zone_id, 666759600, 2)
,(@time_zone_id, 687931200, 1)
,(@time_zone_id, 697604400, 2)
,(@time_zone_id, 719985600, 1)
,(@time_zone_id, 728449200, 2)
,(@time_zone_id, 750830400, 1)
,(@time_zone_id, 761713200, 2)
,(@time_zone_id, 782280000, 1)
,(@time_zone_id, 793162800, 2)
,(@time_zone_id, 813729600, 1)
,(@time_zone_id, 824007600, 2)
,(@time_zone_id, 844574400, 1)
,(@time_zone_id, 856062000, 2)
,(@time_zone_id, 876110400, 1)
,(@time_zone_id, 888721200, 2)
,(@time_zone_id, 908078400, 1)
,(@time_zone_id, 919566000, 2)
,(@time_zone_id, 938923200, 1)
,(@time_zone_id, 951620400, 2)
,(@time_zone_id, 970977600, 1)
,(@time_zone_id, 982465200, 2)
,(@time_zone_id, 1003032000, 1)
,(@time_zone_id, 1013914800, 2)
,(@time_zone_id, 1036296000, 1)
,(@time_zone_id, 1045364400, 2)
,(@time_zone_id, 1066536000, 1)
,(@time_zone_id, 1076814000, 2)
,(@time_zone_id, 1099368000, 1)
,(@time_zone_id, 1108868400, 2)
,(@time_zone_id, 1129435200, 1)
,(@time_zone_id, 1140318000, 2)
,(@time_zone_id, 1162699200, 1)
,(@time_zone_id, 1172372400, 2)
,(@time_zone_id, 1192334400, 1)
,(@time_zone_id, 1203217200, 2)
,(@time_zone_id, 1224388800, 1)
,(@time_zone_id, 1234666800, 2)
,(@time_zone_id, 1255838400, 1)
,(@time_zone_id, 1266721200, 2)
,(@time_zone_id, 1287288000, 1)
,(@time_zone_id, 1298170800, 2)
,(@time_zone_id, 1318737600, 1)
,(@time_zone_id, 1330225200, 2)
,(@time_zone_id, 1350792000, 1)
,(@time_zone_id, 1361070000, 2)
,(@time_zone_id, 1382241600, 1)
,(@time_zone_id, 1392519600, 2)
,(@time_zone_id, 1413691200, 1)
,(@time_zone_id, 1424574000, 2)
,(@time_zone_id, 1445140800, 1)
,(@time_zone_id, 1456023600, 2)
,(@time_zone_id, 1476590400, 1)
,(@time_zone_id, 1487473200, 2)
,(@time_zone_id, 1508040000, 1)
,(@time_zone_id, 1518922800, 2)
,(@time_zone_id, 1541304000, 1)
,(@time_zone_id, 1550372400, 2)
,(@time_zone_id, 1572753600, 1)
,(@time_zone_id, 1581822000, 2)
,(@time_zone_id, 1604203200, 1)
,(@time_zone_id, 1613876400, 2)
,(@time_zone_id, 1636257600, 1)
,(@time_zone_id, 1645326000, 2)
,(@time_zone_id, 1667707200, 1)
,(@time_zone_id, 1677380400, 2)
,(@time_zone_id, 1699156800, 1)
,(@time_zone_id, 1708225200, 2)
,(@time_zone_id, 1730606400, 1)
,(@time_zone_id, 1739674800, 2)
,(@time_zone_id, 1762056000, 1)
,(@time_zone_id, 1771729200, 2)
,(@time_zone_id, 1793505600, 1)
,(@time_zone_id, 1803178800, 2)
,(@time_zone_id, 1825560000, 1)
,(@time_zone_id, 1834628400, 2)
,(@time_zone_id, 1857009600, 1)
,(@time_zone_id, 1866078000, 2)
,(@time_zone_id, 1888459200, 1)
,(@time_zone_id, 1897527600, 2)
,(@time_zone_id, 1919908800, 1)
,(@time_zone_id, 1928977200, 2)
,(@time_zone_id, 1951358400, 1)
,(@time_zone_id, 1960426800, 2)
,(@time_zone_id, 1983412800, 1)
,(@time_zone_id, 1992481200, 2)
,(@time_zone_id, 2014862400, 1)
,(@time_zone_id, 2024535600, 2)
,(@time_zone_id, 2046312000, 1)
,(@time_zone_id, 2055380400, 2)
,(@time_zone_id, 2077761600, 1)
,(@time_zone_id, 2086830000, 2)
,(@time_zone_id, 2109211200, 1)
,(@time_zone_id, 2118884400, 2)
,(@time_zone_id, 2140660800, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -13108, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, '-03')
,(@time_zone_id, 2, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Cancun', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514743200, 1)
,(@time_zone_id, 377935200, 3)
,(@time_zone_id, 828860400, 2)
,(@time_zone_id, 846396000, 3)
,(@time_zone_id, 860310000, 2)
,(@time_zone_id, 877845600, 3)
,(@time_zone_id, 891759600, 2)
,(@time_zone_id, 902037600, 4)
,(@time_zone_id, 909298800, 1)
,(@time_zone_id, 923212800, 4)
,(@time_zone_id, 941353200, 1)
,(@time_zone_id, 954662400, 4)
,(@time_zone_id, 972802800, 1)
,(@time_zone_id, 989136000, 4)
,(@time_zone_id, 1001833200, 1)
,(@time_zone_id, 1018166400, 4)
,(@time_zone_id, 1035702000, 1)
,(@time_zone_id, 1049616000, 4)
,(@time_zone_id, 1067151600, 1)
,(@time_zone_id, 1081065600, 4)
,(@time_zone_id, 1099206000, 1)
,(@time_zone_id, 1112515200, 4)
,(@time_zone_id, 1130655600, 1)
,(@time_zone_id, 1143964800, 4)
,(@time_zone_id, 1162105200, 1)
,(@time_zone_id, 1175414400, 4)
,(@time_zone_id, 1193554800, 1)
,(@time_zone_id, 1207468800, 4)
,(@time_zone_id, 1225004400, 1)
,(@time_zone_id, 1238918400, 4)
,(@time_zone_id, 1256454000, 1)
,(@time_zone_id, 1270368000, 4)
,(@time_zone_id, 1288508400, 1)
,(@time_zone_id, 1301817600, 4)
,(@time_zone_id, 1319958000, 1)
,(@time_zone_id, 1333267200, 4)
,(@time_zone_id, 1351407600, 1)
,(@time_zone_id, 1365321600, 4)
,(@time_zone_id, 1382857200, 1)
,(@time_zone_id, 1396771200, 4)
,(@time_zone_id, 1414306800, 1)
,(@time_zone_id, 1422777600, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20824, 0, 'LMT')
,(@time_zone_id, 1, -21600, 0, 'CST')
,(@time_zone_id, 2, -14400, 1, 'EDT')
,(@time_zone_id, 3, -18000, 0, 'EST')
,(@time_zone_id, 4, -18000, 1, 'CDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Caracas', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1826739140, 2)
,(@time_zone_id, -157750200, 3)
,(@time_zone_id, 1197183600, 2)
,(@time_zone_id, 1462086000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16064, 0, 'LMT')
,(@time_zone_id, 1, -16060, 0, 'CMT')
,(@time_zone_id, 2, -16200, 0, '-0430')
,(@time_zone_id, 3, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Catamarca', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 2)
,(@time_zone_id, 687931200, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1086058800, 2)
,(@time_zone_id, 1087704000, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15788, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Cayenne', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1846269040, 1)
,(@time_zone_id, -71092800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -12560, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, '-04')
,(@time_zone_id, 2, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Cayman', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1946918424, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -19088, 0, 'LMT')
,(@time_zone_id, 1, -19176, 0, 'CMT')
,(@time_zone_id, 2, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Chicago', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -1563724800, 1)
,(@time_zone_id, -1551632400, 2)
,(@time_zone_id, -1538928000, 1)
,(@time_zone_id, -1520182800, 2)
,(@time_zone_id, -1504454400, 1)
,(@time_zone_id, -1491757200, 2)
,(@time_zone_id, -1473004800, 1)
,(@time_zone_id, -1459702800, 2)
,(@time_zone_id, -1441555200, 1)
,(@time_zone_id, -1428253200, 2)
,(@time_zone_id, -1410105600, 1)
,(@time_zone_id, -1396803600, 2)
,(@time_zone_id, -1378656000, 1)
,(@time_zone_id, -1365354000, 2)
,(@time_zone_id, -1347206400, 1)
,(@time_zone_id, -1333904400, 2)
,(@time_zone_id, -1315152000, 1)
,(@time_zone_id, -1301850000, 2)
,(@time_zone_id, -1283702400, 1)
,(@time_zone_id, -1270400400, 2)
,(@time_zone_id, -1252252800, 1)
,(@time_zone_id, -1238950800, 2)
,(@time_zone_id, -1220803200, 1)
,(@time_zone_id, -1207501200, 2)
,(@time_zone_id, -1189353600, 1)
,(@time_zone_id, -1176051600, 2)
,(@time_zone_id, -1157299200, 1)
,(@time_zone_id, -1144602000, 2)
,(@time_zone_id, -1125849600, 1)
,(@time_zone_id, -1112547600, 2)
,(@time_zone_id, -1094400000, 1)
,(@time_zone_id, -1081098000, 2)
,(@time_zone_id, -1067788800, 3)
,(@time_zone_id, -1045414800, 2)
,(@time_zone_id, -1031500800, 1)
,(@time_zone_id, -1018198800, 2)
,(@time_zone_id, -1000051200, 1)
,(@time_zone_id, -986749200, 2)
,(@time_zone_id, -967996800, 1)
,(@time_zone_id, -955299600, 2)
,(@time_zone_id, -936547200, 1)
,(@time_zone_id, -923245200, 2)
,(@time_zone_id, -905097600, 1)
,(@time_zone_id, -891795600, 2)
,(@time_zone_id, -880214400, 4)
,(@time_zone_id, -769395600, 5)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -747244800, 1)
,(@time_zone_id, -733942800, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -702493200, 2)
,(@time_zone_id, -684345600, 1)
,(@time_zone_id, -671043600, 2)
,(@time_zone_id, -652896000, 1)
,(@time_zone_id, -639594000, 2)
,(@time_zone_id, -620841600, 1)
,(@time_zone_id, -608144400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 1)
,(@time_zone_id, -447267600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -415818000, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -384368400, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -352918800, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -321469200, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -289414800, 2)
,(@time_zone_id, -273686400, 1)
,(@time_zone_id, -257965200, 2)
,(@time_zone_id, -242236800, 1)
,(@time_zone_id, -226515600, 2)
,(@time_zone_id, -210787200, 1)
,(@time_zone_id, -195066000, 2)
,(@time_zone_id, -179337600, 1)
,(@time_zone_id, -163616400, 2)
,(@time_zone_id, -147888000, 1)
,(@time_zone_id, -131562000, 2)
,(@time_zone_id, -116438400, 1)
,(@time_zone_id, -100112400, 2)
,(@time_zone_id, -84384000, 1)
,(@time_zone_id, -68662800, 2)
,(@time_zone_id, -52934400, 1)
,(@time_zone_id, -37213200, 2)
,(@time_zone_id, -21484800, 1)
,(@time_zone_id, -5763600, 2)
,(@time_zone_id, 9964800, 1)
,(@time_zone_id, 25686000, 2)
,(@time_zone_id, 41414400, 1)
,(@time_zone_id, 57740400, 2)
,(@time_zone_id, 73468800, 1)
,(@time_zone_id, 89190000, 2)
,(@time_zone_id, 104918400, 1)
,(@time_zone_id, 120639600, 2)
,(@time_zone_id, 126691200, 1)
,(@time_zone_id, 152089200, 2)
,(@time_zone_id, 162374400, 1)
,(@time_zone_id, 183538800, 2)
,(@time_zone_id, 199267200, 1)
,(@time_zone_id, 215593200, 2)
,(@time_zone_id, 230716800, 1)
,(@time_zone_id, 247042800, 2)
,(@time_zone_id, 262771200, 1)
,(@time_zone_id, 278492400, 2)
,(@time_zone_id, 294220800, 1)
,(@time_zone_id, 309942000, 2)
,(@time_zone_id, 325670400, 1)
,(@time_zone_id, 341391600, 2)
,(@time_zone_id, 357120000, 1)
,(@time_zone_id, 372841200, 2)
,(@time_zone_id, 388569600, 1)
,(@time_zone_id, 404895600, 2)
,(@time_zone_id, 420019200, 1)
,(@time_zone_id, 436345200, 2)
,(@time_zone_id, 452073600, 1)
,(@time_zone_id, 467794800, 2)
,(@time_zone_id, 483523200, 1)
,(@time_zone_id, 499244400, 2)
,(@time_zone_id, 514972800, 1)
,(@time_zone_id, 530694000, 2)
,(@time_zone_id, 544608000, 1)
,(@time_zone_id, 562143600, 2)
,(@time_zone_id, 576057600, 1)
,(@time_zone_id, 594198000, 2)
,(@time_zone_id, 607507200, 1)
,(@time_zone_id, 625647600, 2)
,(@time_zone_id, 638956800, 1)
,(@time_zone_id, 657097200, 2)
,(@time_zone_id, 671011200, 1)
,(@time_zone_id, 688546800, 2)
,(@time_zone_id, 702460800, 1)
,(@time_zone_id, 719996400, 2)
,(@time_zone_id, 733910400, 1)
,(@time_zone_id, 752050800, 2)
,(@time_zone_id, 765360000, 1)
,(@time_zone_id, 783500400, 2)
,(@time_zone_id, 796809600, 1)
,(@time_zone_id, 814950000, 2)
,(@time_zone_id, 828864000, 1)
,(@time_zone_id, 846399600, 2)
,(@time_zone_id, 860313600, 1)
,(@time_zone_id, 877849200, 2)
,(@time_zone_id, 891763200, 1)
,(@time_zone_id, 909298800, 2)
,(@time_zone_id, 923212800, 1)
,(@time_zone_id, 941353200, 2)
,(@time_zone_id, 954662400, 1)
,(@time_zone_id, 972802800, 2)
,(@time_zone_id, 986112000, 1)
,(@time_zone_id, 1004252400, 2)
,(@time_zone_id, 1018166400, 1)
,(@time_zone_id, 1035702000, 2)
,(@time_zone_id, 1049616000, 1)
,(@time_zone_id, 1067151600, 2)
,(@time_zone_id, 1081065600, 1)
,(@time_zone_id, 1099206000, 2)
,(@time_zone_id, 1112515200, 1)
,(@time_zone_id, 1130655600, 2)
,(@time_zone_id, 1143964800, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 1)
,(@time_zone_id, 1194159600, 2)
,(@time_zone_id, 1205049600, 1)
,(@time_zone_id, 1225609200, 2)
,(@time_zone_id, 1236499200, 1)
,(@time_zone_id, 1257058800, 2)
,(@time_zone_id, 1268553600, 1)
,(@time_zone_id, 1289113200, 2)
,(@time_zone_id, 1300003200, 1)
,(@time_zone_id, 1320562800, 2)
,(@time_zone_id, 1331452800, 1)
,(@time_zone_id, 1352012400, 2)
,(@time_zone_id, 1362902400, 1)
,(@time_zone_id, 1383462000, 2)
,(@time_zone_id, 1394352000, 1)
,(@time_zone_id, 1414911600, 2)
,(@time_zone_id, 1425801600, 1)
,(@time_zone_id, 1446361200, 2)
,(@time_zone_id, 1457856000, 1)
,(@time_zone_id, 1478415600, 2)
,(@time_zone_id, 1489305600, 1)
,(@time_zone_id, 1509865200, 2)
,(@time_zone_id, 1520755200, 1)
,(@time_zone_id, 1541314800, 2)
,(@time_zone_id, 1552204800, 1)
,(@time_zone_id, 1572764400, 2)
,(@time_zone_id, 1583654400, 1)
,(@time_zone_id, 1604214000, 2)
,(@time_zone_id, 1615708800, 1)
,(@time_zone_id, 1636268400, 2)
,(@time_zone_id, 1647158400, 1)
,(@time_zone_id, 1667718000, 2)
,(@time_zone_id, 1678608000, 1)
,(@time_zone_id, 1699167600, 2)
,(@time_zone_id, 1710057600, 1)
,(@time_zone_id, 1730617200, 2)
,(@time_zone_id, 1741507200, 1)
,(@time_zone_id, 1762066800, 2)
,(@time_zone_id, 1772956800, 1)
,(@time_zone_id, 1793516400, 2)
,(@time_zone_id, 1805011200, 1)
,(@time_zone_id, 1825570800, 2)
,(@time_zone_id, 1836460800, 1)
,(@time_zone_id, 1857020400, 2)
,(@time_zone_id, 1867910400, 1)
,(@time_zone_id, 1888470000, 2)
,(@time_zone_id, 1899360000, 1)
,(@time_zone_id, 1919919600, 2)
,(@time_zone_id, 1930809600, 1)
,(@time_zone_id, 1951369200, 2)
,(@time_zone_id, 1962864000, 1)
,(@time_zone_id, 1983423600, 2)
,(@time_zone_id, 1994313600, 1)
,(@time_zone_id, 2014873200, 2)
,(@time_zone_id, 2025763200, 1)
,(@time_zone_id, 2046322800, 2)
,(@time_zone_id, 2057212800, 1)
,(@time_zone_id, 2077772400, 2)
,(@time_zone_id, 2088662400, 1)
,(@time_zone_id, 2109222000, 2)
,(@time_zone_id, 2120112000, 1)
,(@time_zone_id, 2140671600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21036, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 0, 'EST')
,(@time_zone_id, 4, -18000, 1, 'CWT')
,(@time_zone_id, 5, -18000, 1, 'CPT')
,(@time_zone_id, 6, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Chihuahua', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514739600, 1)
,(@time_zone_id, -1343066400, 2)
,(@time_zone_id, -1234807200, 1)
,(@time_zone_id, -1220292000, 2)
,(@time_zone_id, -1207159200, 1)
,(@time_zone_id, -1191344400, 2)
,(@time_zone_id, 828864000, 3)
,(@time_zone_id, 846399600, 2)
,(@time_zone_id, 860313600, 3)
,(@time_zone_id, 877849200, 2)
,(@time_zone_id, 891766800, 4)
,(@time_zone_id, 909302400, 1)
,(@time_zone_id, 923216400, 4)
,(@time_zone_id, 941356800, 1)
,(@time_zone_id, 954666000, 4)
,(@time_zone_id, 972806400, 1)
,(@time_zone_id, 989139600, 4)
,(@time_zone_id, 1001836800, 1)
,(@time_zone_id, 1018170000, 4)
,(@time_zone_id, 1035705600, 1)
,(@time_zone_id, 1049619600, 4)
,(@time_zone_id, 1067155200, 1)
,(@time_zone_id, 1081069200, 4)
,(@time_zone_id, 1099209600, 1)
,(@time_zone_id, 1112518800, 4)
,(@time_zone_id, 1130659200, 1)
,(@time_zone_id, 1143968400, 4)
,(@time_zone_id, 1162108800, 1)
,(@time_zone_id, 1175418000, 4)
,(@time_zone_id, 1193558400, 1)
,(@time_zone_id, 1207472400, 4)
,(@time_zone_id, 1225008000, 1)
,(@time_zone_id, 1238922000, 4)
,(@time_zone_id, 1256457600, 1)
,(@time_zone_id, 1270371600, 4)
,(@time_zone_id, 1288512000, 1)
,(@time_zone_id, 1301821200, 4)
,(@time_zone_id, 1319961600, 1)
,(@time_zone_id, 1333270800, 4)
,(@time_zone_id, 1351411200, 1)
,(@time_zone_id, 1365325200, 4)
,(@time_zone_id, 1382860800, 1)
,(@time_zone_id, 1396774800, 4)
,(@time_zone_id, 1414310400, 1)
,(@time_zone_id, 1428224400, 4)
,(@time_zone_id, 1445760000, 1)
,(@time_zone_id, 1459674000, 4)
,(@time_zone_id, 1477814400, 1)
,(@time_zone_id, 1491123600, 4)
,(@time_zone_id, 1509264000, 1)
,(@time_zone_id, 1522573200, 4)
,(@time_zone_id, 1540713600, 1)
,(@time_zone_id, 1554627600, 4)
,(@time_zone_id, 1572163200, 1)
,(@time_zone_id, 1586077200, 4)
,(@time_zone_id, 1603612800, 1)
,(@time_zone_id, 1617526800, 4)
,(@time_zone_id, 1635667200, 1)
,(@time_zone_id, 1648976400, 4)
,(@time_zone_id, 1667116800, 1)
,(@time_zone_id, 1680426000, 4)
,(@time_zone_id, 1698566400, 1)
,(@time_zone_id, 1712480400, 4)
,(@time_zone_id, 1730016000, 1)
,(@time_zone_id, 1743930000, 4)
,(@time_zone_id, 1761465600, 1)
,(@time_zone_id, 1775379600, 4)
,(@time_zone_id, 1792915200, 1)
,(@time_zone_id, 1806829200, 4)
,(@time_zone_id, 1824969600, 1)
,(@time_zone_id, 1838278800, 4)
,(@time_zone_id, 1856419200, 1)
,(@time_zone_id, 1869728400, 4)
,(@time_zone_id, 1887868800, 1)
,(@time_zone_id, 1901782800, 4)
,(@time_zone_id, 1919318400, 1)
,(@time_zone_id, 1933232400, 4)
,(@time_zone_id, 1950768000, 1)
,(@time_zone_id, 1964682000, 4)
,(@time_zone_id, 1982822400, 1)
,(@time_zone_id, 1996131600, 4)
,(@time_zone_id, 2014272000, 1)
,(@time_zone_id, 2027581200, 4)
,(@time_zone_id, 2045721600, 1)
,(@time_zone_id, 2059030800, 4)
,(@time_zone_id, 2077171200, 1)
,(@time_zone_id, 2091085200, 4)
,(@time_zone_id, 2108620800, 1)
,(@time_zone_id, 2122534800, 4)
,(@time_zone_id, 2140070400, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -25460, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CDT')
,(@time_zone_id, 4, -21600, 1, 'MDT')
,(@time_zone_id, 5, -25200, 0, 'MST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Coral_Harbour', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632067200, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -923248800, 1)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21988, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Cordoba', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 2)
,(@time_zone_id, 687931200, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
,(@time_zone_id, 1224385200, 4)
,(@time_zone_id, 1237082400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15408, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Costa_Rica', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1545071027, 3)
,(@time_zone_id, 288770400, 2)
,(@time_zone_id, 297234000, 3)
,(@time_zone_id, 320220000, 2)
,(@time_zone_id, 328683600, 3)
,(@time_zone_id, 664264800, 2)
,(@time_zone_id, 678344400, 3)
,(@time_zone_id, 695714400, 2)
,(@time_zone_id, 700635600, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20173, 0, 'LMT')
,(@time_zone_id, 1, -20173, 0, 'SJMT')
,(@time_zone_id, 2, -18000, 1, 'CDT')
,(@time_zone_id, 3, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Creston', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1680454800, 2)
,(@time_zone_id, -1627833600, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -27964, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -25200, 0, 'MST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Cuiaba', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767212140, 2)
,(@time_zone_id, -1206954000, 1)
,(@time_zone_id, -1191358800, 2)
,(@time_zone_id, -1175371200, 1)
,(@time_zone_id, -1159822800, 2)
,(@time_zone_id, -633816000, 1)
,(@time_zone_id, -622065600, 2)
,(@time_zone_id, -602280000, 1)
,(@time_zone_id, -591829200, 2)
,(@time_zone_id, -570744000, 1)
,(@time_zone_id, -560206800, 2)
,(@time_zone_id, -539121600, 1)
,(@time_zone_id, -531349200, 2)
,(@time_zone_id, -191361600, 1)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -155160000, 1)
,(@time_zone_id, -150066000, 2)
,(@time_zone_id, -128894400, 1)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -99950400, 1)
,(@time_zone_id, -89586000, 2)
,(@time_zone_id, -68414400, 1)
,(@time_zone_id, -57963600, 2)
,(@time_zone_id, 499752000, 1)
,(@time_zone_id, 511239600, 2)
,(@time_zone_id, 530596800, 1)
,(@time_zone_id, 540270000, 2)
,(@time_zone_id, 562132800, 1)
,(@time_zone_id, 571201200, 2)
,(@time_zone_id, 592977600, 1)
,(@time_zone_id, 602046000, 2)
,(@time_zone_id, 624427200, 1)
,(@time_zone_id, 634705200, 2)
,(@time_zone_id, 656481600, 1)
,(@time_zone_id, 666759600, 2)
,(@time_zone_id, 687931200, 1)
,(@time_zone_id, 697604400, 2)
,(@time_zone_id, 719985600, 1)
,(@time_zone_id, 728449200, 2)
,(@time_zone_id, 750830400, 1)
,(@time_zone_id, 761713200, 2)
,(@time_zone_id, 782280000, 1)
,(@time_zone_id, 793162800, 2)
,(@time_zone_id, 813729600, 1)
,(@time_zone_id, 824007600, 2)
,(@time_zone_id, 844574400, 1)
,(@time_zone_id, 856062000, 2)
,(@time_zone_id, 876110400, 1)
,(@time_zone_id, 888721200, 2)
,(@time_zone_id, 908078400, 1)
,(@time_zone_id, 919566000, 2)
,(@time_zone_id, 938923200, 1)
,(@time_zone_id, 951620400, 2)
,(@time_zone_id, 970977600, 1)
,(@time_zone_id, 982465200, 2)
,(@time_zone_id, 1003032000, 1)
,(@time_zone_id, 1013914800, 2)
,(@time_zone_id, 1036296000, 1)
,(@time_zone_id, 1045364400, 2)
,(@time_zone_id, 1099368000, 1)
,(@time_zone_id, 1108868400, 2)
,(@time_zone_id, 1129435200, 1)
,(@time_zone_id, 1140318000, 2)
,(@time_zone_id, 1162699200, 1)
,(@time_zone_id, 1172372400, 2)
,(@time_zone_id, 1192334400, 1)
,(@time_zone_id, 1203217200, 2)
,(@time_zone_id, 1224388800, 1)
,(@time_zone_id, 1234666800, 2)
,(@time_zone_id, 1255838400, 1)
,(@time_zone_id, 1266721200, 2)
,(@time_zone_id, 1287288000, 1)
,(@time_zone_id, 1298170800, 2)
,(@time_zone_id, 1318737600, 1)
,(@time_zone_id, 1330225200, 2)
,(@time_zone_id, 1350792000, 1)
,(@time_zone_id, 1361070000, 2)
,(@time_zone_id, 1382241600, 1)
,(@time_zone_id, 1392519600, 2)
,(@time_zone_id, 1413691200, 1)
,(@time_zone_id, 1424574000, 2)
,(@time_zone_id, 1445140800, 1)
,(@time_zone_id, 1456023600, 2)
,(@time_zone_id, 1476590400, 1)
,(@time_zone_id, 1487473200, 2)
,(@time_zone_id, 1508040000, 1)
,(@time_zone_id, 1518922800, 2)
,(@time_zone_id, 1541304000, 1)
,(@time_zone_id, 1550372400, 2)
,(@time_zone_id, 1572753600, 1)
,(@time_zone_id, 1581822000, 2)
,(@time_zone_id, 1604203200, 1)
,(@time_zone_id, 1613876400, 2)
,(@time_zone_id, 1636257600, 1)
,(@time_zone_id, 1645326000, 2)
,(@time_zone_id, 1667707200, 1)
,(@time_zone_id, 1677380400, 2)
,(@time_zone_id, 1699156800, 1)
,(@time_zone_id, 1708225200, 2)
,(@time_zone_id, 1730606400, 1)
,(@time_zone_id, 1739674800, 2)
,(@time_zone_id, 1762056000, 1)
,(@time_zone_id, 1771729200, 2)
,(@time_zone_id, 1793505600, 1)
,(@time_zone_id, 1803178800, 2)
,(@time_zone_id, 1825560000, 1)
,(@time_zone_id, 1834628400, 2)
,(@time_zone_id, 1857009600, 1)
,(@time_zone_id, 1866078000, 2)
,(@time_zone_id, 1888459200, 1)
,(@time_zone_id, 1897527600, 2)
,(@time_zone_id, 1919908800, 1)
,(@time_zone_id, 1928977200, 2)
,(@time_zone_id, 1951358400, 1)
,(@time_zone_id, 1960426800, 2)
,(@time_zone_id, 1983412800, 1)
,(@time_zone_id, 1992481200, 2)
,(@time_zone_id, 2014862400, 1)
,(@time_zone_id, 2024535600, 2)
,(@time_zone_id, 2046312000, 1)
,(@time_zone_id, 2055380400, 2)
,(@time_zone_id, 2077761600, 1)
,(@time_zone_id, 2086830000, 2)
,(@time_zone_id, 2109211200, 1)
,(@time_zone_id, 2118884400, 2)
,(@time_zone_id, 2140660800, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -13460, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, '-03')
,(@time_zone_id, 2, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Curacao', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1826738653, 1)
,(@time_zone_id, -157750200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16547, 0, 'LMT')
,(@time_zone_id, 1, -16200, 0, '-0430')
,(@time_zone_id, 2, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Danmarkshavn', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1686091520, 1)
,(@time_zone_id, 323845200, 4)
,(@time_zone_id, 338950800, 2)
,(@time_zone_id, 354675600, 3)
,(@time_zone_id, 370400400, 2)
,(@time_zone_id, 386125200, 3)
,(@time_zone_id, 401850000, 2)
,(@time_zone_id, 417574800, 3)
,(@time_zone_id, 433299600, 2)
,(@time_zone_id, 449024400, 3)
,(@time_zone_id, 465354000, 2)
,(@time_zone_id, 481078800, 3)
,(@time_zone_id, 496803600, 2)
,(@time_zone_id, 512528400, 3)
,(@time_zone_id, 528253200, 2)
,(@time_zone_id, 543978000, 3)
,(@time_zone_id, 559702800, 2)
,(@time_zone_id, 575427600, 3)
,(@time_zone_id, 591152400, 2)
,(@time_zone_id, 606877200, 3)
,(@time_zone_id, 622602000, 2)
,(@time_zone_id, 638326800, 3)
,(@time_zone_id, 654656400, 2)
,(@time_zone_id, 670381200, 3)
,(@time_zone_id, 686106000, 2)
,(@time_zone_id, 701830800, 3)
,(@time_zone_id, 717555600, 2)
,(@time_zone_id, 733280400, 3)
,(@time_zone_id, 749005200, 2)
,(@time_zone_id, 764730000, 3)
,(@time_zone_id, 780454800, 2)
,(@time_zone_id, 796179600, 3)
,(@time_zone_id, 811904400, 2)
,(@time_zone_id, 820465200, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -4480, 0, 'LMT')
,(@time_zone_id, 1, -10800, 0, '-03')
,(@time_zone_id, 2, -10800, 0, '-03')
,(@time_zone_id, 3, -7200, 1, '-02')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, 0, 0, 'GMT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Dawson', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632056400, 1)
,(@time_zone_id, -1615125600, 2)
,(@time_zone_id, -1596978000, 1)
,(@time_zone_id, -1583164800, 2)
,(@time_zone_id, -880203600, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765381600, 2)
,(@time_zone_id, -147884400, 5)
,(@time_zone_id, -131554800, 2)
,(@time_zone_id, 120646800, 6)
,(@time_zone_id, 325677600, 7)
,(@time_zone_id, 341398800, 6)
,(@time_zone_id, 357127200, 7)
,(@time_zone_id, 372848400, 6)
,(@time_zone_id, 388576800, 7)
,(@time_zone_id, 404902800, 6)
,(@time_zone_id, 420026400, 7)
,(@time_zone_id, 436352400, 6)
,(@time_zone_id, 452080800, 7)
,(@time_zone_id, 467802000, 6)
,(@time_zone_id, 483530400, 7)
,(@time_zone_id, 499251600, 6)
,(@time_zone_id, 514980000, 7)
,(@time_zone_id, 530701200, 6)
,(@time_zone_id, 544615200, 7)
,(@time_zone_id, 562150800, 6)
,(@time_zone_id, 576064800, 7)
,(@time_zone_id, 594205200, 6)
,(@time_zone_id, 607514400, 7)
,(@time_zone_id, 625654800, 6)
,(@time_zone_id, 638964000, 7)
,(@time_zone_id, 657104400, 6)
,(@time_zone_id, 671018400, 7)
,(@time_zone_id, 688554000, 6)
,(@time_zone_id, 702468000, 7)
,(@time_zone_id, 720003600, 6)
,(@time_zone_id, 733917600, 7)
,(@time_zone_id, 752058000, 6)
,(@time_zone_id, 765367200, 7)
,(@time_zone_id, 783507600, 6)
,(@time_zone_id, 796816800, 7)
,(@time_zone_id, 814957200, 6)
,(@time_zone_id, 828871200, 7)
,(@time_zone_id, 846406800, 6)
,(@time_zone_id, 860320800, 7)
,(@time_zone_id, 877856400, 6)
,(@time_zone_id, 891770400, 7)
,(@time_zone_id, 909306000, 6)
,(@time_zone_id, 923220000, 7)
,(@time_zone_id, 941360400, 6)
,(@time_zone_id, 954669600, 7)
,(@time_zone_id, 972810000, 6)
,(@time_zone_id, 986119200, 7)
,(@time_zone_id, 1004259600, 6)
,(@time_zone_id, 1018173600, 7)
,(@time_zone_id, 1035709200, 6)
,(@time_zone_id, 1049623200, 7)
,(@time_zone_id, 1067158800, 6)
,(@time_zone_id, 1081072800, 7)
,(@time_zone_id, 1099213200, 6)
,(@time_zone_id, 1112522400, 7)
,(@time_zone_id, 1130662800, 6)
,(@time_zone_id, 1143972000, 7)
,(@time_zone_id, 1162112400, 6)
,(@time_zone_id, 1173607200, 7)
,(@time_zone_id, 1194166800, 6)
,(@time_zone_id, 1205056800, 7)
,(@time_zone_id, 1225616400, 6)
,(@time_zone_id, 1236506400, 7)
,(@time_zone_id, 1257066000, 6)
,(@time_zone_id, 1268560800, 7)
,(@time_zone_id, 1289120400, 6)
,(@time_zone_id, 1300010400, 7)
,(@time_zone_id, 1320570000, 6)
,(@time_zone_id, 1331460000, 7)
,(@time_zone_id, 1352019600, 6)
,(@time_zone_id, 1362909600, 7)
,(@time_zone_id, 1383469200, 6)
,(@time_zone_id, 1394359200, 7)
,(@time_zone_id, 1414918800, 6)
,(@time_zone_id, 1425808800, 7)
,(@time_zone_id, 1446368400, 6)
,(@time_zone_id, 1457863200, 7)
,(@time_zone_id, 1478422800, 6)
,(@time_zone_id, 1489312800, 7)
,(@time_zone_id, 1509872400, 6)
,(@time_zone_id, 1520762400, 7)
,(@time_zone_id, 1541322000, 6)
,(@time_zone_id, 1552212000, 7)
,(@time_zone_id, 1572771600, 6)
,(@time_zone_id, 1583661600, 7)
,(@time_zone_id, 1604221200, 6)
,(@time_zone_id, 1615716000, 7)
,(@time_zone_id, 1636275600, 6)
,(@time_zone_id, 1647165600, 7)
,(@time_zone_id, 1667725200, 6)
,(@time_zone_id, 1678615200, 7)
,(@time_zone_id, 1699174800, 6)
,(@time_zone_id, 1710064800, 7)
,(@time_zone_id, 1730624400, 6)
,(@time_zone_id, 1741514400, 7)
,(@time_zone_id, 1762074000, 6)
,(@time_zone_id, 1772964000, 7)
,(@time_zone_id, 1793523600, 6)
,(@time_zone_id, 1805018400, 7)
,(@time_zone_id, 1825578000, 6)
,(@time_zone_id, 1836468000, 7)
,(@time_zone_id, 1857027600, 6)
,(@time_zone_id, 1867917600, 7)
,(@time_zone_id, 1888477200, 6)
,(@time_zone_id, 1899367200, 7)
,(@time_zone_id, 1919926800, 6)
,(@time_zone_id, 1930816800, 7)
,(@time_zone_id, 1951376400, 6)
,(@time_zone_id, 1962871200, 7)
,(@time_zone_id, 1983430800, 6)
,(@time_zone_id, 1994320800, 7)
,(@time_zone_id, 2014880400, 6)
,(@time_zone_id, 2025770400, 7)
,(@time_zone_id, 2046330000, 6)
,(@time_zone_id, 2057220000, 7)
,(@time_zone_id, 2077779600, 6)
,(@time_zone_id, 2088669600, 7)
,(@time_zone_id, 2109229200, 6)
,(@time_zone_id, 2120119200, 7)
,(@time_zone_id, 2140678800, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -33460, 0, 'LMT')
,(@time_zone_id, 1, -28800, 1, 'YDT')
,(@time_zone_id, 2, -32400, 0, 'YST')
,(@time_zone_id, 3, -28800, 1, 'YWT')
,(@time_zone_id, 4, -28800, 1, 'YPT')
,(@time_zone_id, 5, -25200, 1, 'YDDT')
,(@time_zone_id, 6, -28800, 0, 'PST')
,(@time_zone_id, 7, -25200, 1, 'PDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Dawson_Creek', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632060000, 1)
,(@time_zone_id, -1615129200, 2)
,(@time_zone_id, -880207200, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765385200, 2)
,(@time_zone_id, -715788000, 1)
,(@time_zone_id, -702486000, 2)
,(@time_zone_id, -684338400, 1)
,(@time_zone_id, -671036400, 2)
,(@time_zone_id, -652888800, 1)
,(@time_zone_id, -639586800, 2)
,(@time_zone_id, -620834400, 1)
,(@time_zone_id, -608137200, 2)
,(@time_zone_id, -589384800, 1)
,(@time_zone_id, -576082800, 2)
,(@time_zone_id, -557935200, 1)
,(@time_zone_id, -544633200, 2)
,(@time_zone_id, -526485600, 1)
,(@time_zone_id, -513183600, 2)
,(@time_zone_id, -495036000, 1)
,(@time_zone_id, -481734000, 2)
,(@time_zone_id, -463586400, 1)
,(@time_zone_id, -450284400, 2)
,(@time_zone_id, -431532000, 1)
,(@time_zone_id, -418230000, 2)
,(@time_zone_id, -400082400, 1)
,(@time_zone_id, -386780400, 2)
,(@time_zone_id, -368632800, 1)
,(@time_zone_id, -355330800, 2)
,(@time_zone_id, -337183200, 1)
,(@time_zone_id, -323881200, 2)
,(@time_zone_id, -305733600, 1)
,(@time_zone_id, -292431600, 2)
,(@time_zone_id, -273679200, 1)
,(@time_zone_id, -260982000, 2)
,(@time_zone_id, -242229600, 1)
,(@time_zone_id, -226508400, 2)
,(@time_zone_id, -210780000, 1)
,(@time_zone_id, -195058800, 2)
,(@time_zone_id, -179330400, 1)
,(@time_zone_id, -163609200, 2)
,(@time_zone_id, -147880800, 1)
,(@time_zone_id, -131554800, 2)
,(@time_zone_id, -116431200, 1)
,(@time_zone_id, -100105200, 2)
,(@time_zone_id, -84376800, 1)
,(@time_zone_id, -68655600, 2)
,(@time_zone_id, -52927200, 1)
,(@time_zone_id, -37206000, 2)
,(@time_zone_id, -21477600, 1)
,(@time_zone_id, -5756400, 2)
,(@time_zone_id, 9972000, 1)
,(@time_zone_id, 25693200, 2)
,(@time_zone_id, 41421600, 1)
,(@time_zone_id, 57747600, 2)
,(@time_zone_id, 73476000, 1)
,(@time_zone_id, 84013200, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -28856, 0, 'LMT')
,(@time_zone_id, 1, -25200, 1, 'PDT')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -25200, 1, 'PWT')
,(@time_zone_id, 4, -25200, 1, 'PPT')
,(@time_zone_id, 5, -25200, 0, 'MST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Denver', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633273200, 1)
,(@time_zone_id, -1615132800, 2)
,(@time_zone_id, -1601823600, 1)
,(@time_zone_id, -1583683200, 2)
,(@time_zone_id, -1570374000, 1)
,(@time_zone_id, -1551628800, 2)
,(@time_zone_id, -1538924400, 1)
,(@time_zone_id, -1534089600, 2)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765388800, 2)
,(@time_zone_id, -147884400, 1)
,(@time_zone_id, -131558400, 2)
,(@time_zone_id, -116434800, 1)
,(@time_zone_id, -100108800, 2)
,(@time_zone_id, -84380400, 1)
,(@time_zone_id, -68659200, 2)
,(@time_zone_id, -52930800, 1)
,(@time_zone_id, -37209600, 2)
,(@time_zone_id, -21481200, 1)
,(@time_zone_id, -5760000, 2)
,(@time_zone_id, 9968400, 1)
,(@time_zone_id, 25689600, 2)
,(@time_zone_id, 41418000, 1)
,(@time_zone_id, 57744000, 2)
,(@time_zone_id, 73472400, 1)
,(@time_zone_id, 89193600, 2)
,(@time_zone_id, 104922000, 1)
,(@time_zone_id, 120643200, 2)
,(@time_zone_id, 126694800, 1)
,(@time_zone_id, 152092800, 2)
,(@time_zone_id, 162378000, 1)
,(@time_zone_id, 183542400, 2)
,(@time_zone_id, 199270800, 1)
,(@time_zone_id, 215596800, 2)
,(@time_zone_id, 230720400, 1)
,(@time_zone_id, 247046400, 2)
,(@time_zone_id, 262774800, 1)
,(@time_zone_id, 278496000, 2)
,(@time_zone_id, 294224400, 1)
,(@time_zone_id, 309945600, 2)
,(@time_zone_id, 325674000, 1)
,(@time_zone_id, 341395200, 2)
,(@time_zone_id, 357123600, 1)
,(@time_zone_id, 372844800, 2)
,(@time_zone_id, 388573200, 1)
,(@time_zone_id, 404899200, 2)
,(@time_zone_id, 420022800, 1)
,(@time_zone_id, 436348800, 2)
,(@time_zone_id, 452077200, 1)
,(@time_zone_id, 467798400, 2)
,(@time_zone_id, 483526800, 1)
,(@time_zone_id, 499248000, 2)
,(@time_zone_id, 514976400, 1)
,(@time_zone_id, 530697600, 2)
,(@time_zone_id, 544611600, 1)
,(@time_zone_id, 562147200, 2)
,(@time_zone_id, 576061200, 1)
,(@time_zone_id, 594201600, 2)
,(@time_zone_id, 607510800, 1)
,(@time_zone_id, 625651200, 2)
,(@time_zone_id, 638960400, 1)
,(@time_zone_id, 657100800, 2)
,(@time_zone_id, 671014800, 1)
,(@time_zone_id, 688550400, 2)
,(@time_zone_id, 702464400, 1)
,(@time_zone_id, 720000000, 2)
,(@time_zone_id, 733914000, 1)
,(@time_zone_id, 752054400, 2)
,(@time_zone_id, 765363600, 1)
,(@time_zone_id, 783504000, 2)
,(@time_zone_id, 796813200, 1)
,(@time_zone_id, 814953600, 2)
,(@time_zone_id, 828867600, 1)
,(@time_zone_id, 846403200, 2)
,(@time_zone_id, 860317200, 1)
,(@time_zone_id, 877852800, 2)
,(@time_zone_id, 891766800, 1)
,(@time_zone_id, 909302400, 2)
,(@time_zone_id, 923216400, 1)
,(@time_zone_id, 941356800, 2)
,(@time_zone_id, 954666000, 1)
,(@time_zone_id, 972806400, 2)
,(@time_zone_id, 986115600, 1)
,(@time_zone_id, 1004256000, 2)
,(@time_zone_id, 1018170000, 1)
,(@time_zone_id, 1035705600, 2)
,(@time_zone_id, 1049619600, 1)
,(@time_zone_id, 1067155200, 2)
,(@time_zone_id, 1081069200, 1)
,(@time_zone_id, 1099209600, 2)
,(@time_zone_id, 1112518800, 1)
,(@time_zone_id, 1130659200, 2)
,(@time_zone_id, 1143968400, 1)
,(@time_zone_id, 1162108800, 2)
,(@time_zone_id, 1173603600, 1)
,(@time_zone_id, 1194163200, 2)
,(@time_zone_id, 1205053200, 1)
,(@time_zone_id, 1225612800, 2)
,(@time_zone_id, 1236502800, 1)
,(@time_zone_id, 1257062400, 2)
,(@time_zone_id, 1268557200, 1)
,(@time_zone_id, 1289116800, 2)
,(@time_zone_id, 1300006800, 1)
,(@time_zone_id, 1320566400, 2)
,(@time_zone_id, 1331456400, 1)
,(@time_zone_id, 1352016000, 2)
,(@time_zone_id, 1362906000, 1)
,(@time_zone_id, 1383465600, 2)
,(@time_zone_id, 1394355600, 1)
,(@time_zone_id, 1414915200, 2)
,(@time_zone_id, 1425805200, 1)
,(@time_zone_id, 1446364800, 2)
,(@time_zone_id, 1457859600, 1)
,(@time_zone_id, 1478419200, 2)
,(@time_zone_id, 1489309200, 1)
,(@time_zone_id, 1509868800, 2)
,(@time_zone_id, 1520758800, 1)
,(@time_zone_id, 1541318400, 2)
,(@time_zone_id, 1552208400, 1)
,(@time_zone_id, 1572768000, 2)
,(@time_zone_id, 1583658000, 1)
,(@time_zone_id, 1604217600, 2)
,(@time_zone_id, 1615712400, 1)
,(@time_zone_id, 1636272000, 2)
,(@time_zone_id, 1647162000, 1)
,(@time_zone_id, 1667721600, 2)
,(@time_zone_id, 1678611600, 1)
,(@time_zone_id, 1699171200, 2)
,(@time_zone_id, 1710061200, 1)
,(@time_zone_id, 1730620800, 2)
,(@time_zone_id, 1741510800, 1)
,(@time_zone_id, 1762070400, 2)
,(@time_zone_id, 1772960400, 1)
,(@time_zone_id, 1793520000, 2)
,(@time_zone_id, 1805014800, 1)
,(@time_zone_id, 1825574400, 2)
,(@time_zone_id, 1836464400, 1)
,(@time_zone_id, 1857024000, 2)
,(@time_zone_id, 1867914000, 1)
,(@time_zone_id, 1888473600, 2)
,(@time_zone_id, 1899363600, 1)
,(@time_zone_id, 1919923200, 2)
,(@time_zone_id, 1930813200, 1)
,(@time_zone_id, 1951372800, 2)
,(@time_zone_id, 1962867600, 1)
,(@time_zone_id, 1983427200, 2)
,(@time_zone_id, 1994317200, 1)
,(@time_zone_id, 2014876800, 2)
,(@time_zone_id, 2025766800, 1)
,(@time_zone_id, 2046326400, 2)
,(@time_zone_id, 2057216400, 1)
,(@time_zone_id, 2077776000, 2)
,(@time_zone_id, 2088666000, 1)
,(@time_zone_id, 2109225600, 2)
,(@time_zone_id, 2120115600, 1)
,(@time_zone_id, 2140675200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -25196, 0, 'LMT')
,(@time_zone_id, 1, -21600, 1, 'MDT')
,(@time_zone_id, 2, -25200, 0, 'MST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
,(@time_zone_id, 4, -21600, 1, 'MPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Detroit', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2051202469, 1)
,(@time_zone_id, -1724083200, 2)
,(@time_zone_id, -880218000, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765396000, 2)
,(@time_zone_id, -684349200, 5)
,(@time_zone_id, -671047200, 2)
,(@time_zone_id, 104914800, 5)
,(@time_zone_id, 120636000, 2)
,(@time_zone_id, 126687600, 5)
,(@time_zone_id, 152085600, 2)
,(@time_zone_id, 167814000, 5)
,(@time_zone_id, 183535200, 2)
,(@time_zone_id, 199263600, 5)
,(@time_zone_id, 215589600, 2)
,(@time_zone_id, 230713200, 5)
,(@time_zone_id, 247039200, 2)
,(@time_zone_id, 262767600, 5)
,(@time_zone_id, 278488800, 2)
,(@time_zone_id, 294217200, 5)
,(@time_zone_id, 309938400, 2)
,(@time_zone_id, 325666800, 5)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 5)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 5)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 5)
,(@time_zone_id, 436341600, 2)
,(@time_zone_id, 452070000, 5)
,(@time_zone_id, 467791200, 2)
,(@time_zone_id, 483519600, 5)
,(@time_zone_id, 499240800, 2)
,(@time_zone_id, 514969200, 5)
,(@time_zone_id, 530690400, 2)
,(@time_zone_id, 544604400, 5)
,(@time_zone_id, 562140000, 2)
,(@time_zone_id, 576054000, 5)
,(@time_zone_id, 594194400, 2)
,(@time_zone_id, 607503600, 5)
,(@time_zone_id, 625644000, 2)
,(@time_zone_id, 638953200, 5)
,(@time_zone_id, 657093600, 2)
,(@time_zone_id, 671007600, 5)
,(@time_zone_id, 688543200, 2)
,(@time_zone_id, 702457200, 5)
,(@time_zone_id, 719992800, 2)
,(@time_zone_id, 733906800, 5)
,(@time_zone_id, 752047200, 2)
,(@time_zone_id, 765356400, 5)
,(@time_zone_id, 783496800, 2)
,(@time_zone_id, 796806000, 5)
,(@time_zone_id, 814946400, 2)
,(@time_zone_id, 828860400, 5)
,(@time_zone_id, 846396000, 2)
,(@time_zone_id, 860310000, 5)
,(@time_zone_id, 877845600, 2)
,(@time_zone_id, 891759600, 5)
,(@time_zone_id, 909295200, 2)
,(@time_zone_id, 923209200, 5)
,(@time_zone_id, 941349600, 2)
,(@time_zone_id, 954658800, 5)
,(@time_zone_id, 972799200, 2)
,(@time_zone_id, 986108400, 5)
,(@time_zone_id, 1004248800, 2)
,(@time_zone_id, 1018162800, 5)
,(@time_zone_id, 1035698400, 2)
,(@time_zone_id, 1049612400, 5)
,(@time_zone_id, 1067148000, 2)
,(@time_zone_id, 1081062000, 5)
,(@time_zone_id, 1099202400, 2)
,(@time_zone_id, 1112511600, 5)
,(@time_zone_id, 1130652000, 2)
,(@time_zone_id, 1143961200, 5)
,(@time_zone_id, 1162101600, 2)
,(@time_zone_id, 1173596400, 5)
,(@time_zone_id, 1194156000, 2)
,(@time_zone_id, 1205046000, 5)
,(@time_zone_id, 1225605600, 2)
,(@time_zone_id, 1236495600, 5)
,(@time_zone_id, 1257055200, 2)
,(@time_zone_id, 1268550000, 5)
,(@time_zone_id, 1289109600, 2)
,(@time_zone_id, 1299999600, 5)
,(@time_zone_id, 1320559200, 2)
,(@time_zone_id, 1331449200, 5)
,(@time_zone_id, 1352008800, 2)
,(@time_zone_id, 1362898800, 5)
,(@time_zone_id, 1383458400, 2)
,(@time_zone_id, 1394348400, 5)
,(@time_zone_id, 1414908000, 2)
,(@time_zone_id, 1425798000, 5)
,(@time_zone_id, 1446357600, 2)
,(@time_zone_id, 1457852400, 5)
,(@time_zone_id, 1478412000, 2)
,(@time_zone_id, 1489302000, 5)
,(@time_zone_id, 1509861600, 2)
,(@time_zone_id, 1520751600, 5)
,(@time_zone_id, 1541311200, 2)
,(@time_zone_id, 1552201200, 5)
,(@time_zone_id, 1572760800, 2)
,(@time_zone_id, 1583650800, 5)
,(@time_zone_id, 1604210400, 2)
,(@time_zone_id, 1615705200, 5)
,(@time_zone_id, 1636264800, 2)
,(@time_zone_id, 1647154800, 5)
,(@time_zone_id, 1667714400, 2)
,(@time_zone_id, 1678604400, 5)
,(@time_zone_id, 1699164000, 2)
,(@time_zone_id, 1710054000, 5)
,(@time_zone_id, 1730613600, 2)
,(@time_zone_id, 1741503600, 5)
,(@time_zone_id, 1762063200, 2)
,(@time_zone_id, 1772953200, 5)
,(@time_zone_id, 1793512800, 2)
,(@time_zone_id, 1805007600, 5)
,(@time_zone_id, 1825567200, 2)
,(@time_zone_id, 1836457200, 5)
,(@time_zone_id, 1857016800, 2)
,(@time_zone_id, 1867906800, 5)
,(@time_zone_id, 1888466400, 2)
,(@time_zone_id, 1899356400, 5)
,(@time_zone_id, 1919916000, 2)
,(@time_zone_id, 1930806000, 5)
,(@time_zone_id, 1951365600, 2)
,(@time_zone_id, 1962860400, 5)
,(@time_zone_id, 1983420000, 2)
,(@time_zone_id, 1994310000, 5)
,(@time_zone_id, 2014869600, 2)
,(@time_zone_id, 2025759600, 5)
,(@time_zone_id, 2046319200, 2)
,(@time_zone_id, 2057209200, 5)
,(@time_zone_id, 2077768800, 2)
,(@time_zone_id, 2088658800, 5)
,(@time_zone_id, 2109218400, 2)
,(@time_zone_id, 2120108400, 5)
,(@time_zone_id, 2140668000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -19931, 0, 'LMT')
,(@time_zone_id, 1, -21600, 0, 'CST')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -14400, 1, 'EWT')
,(@time_zone_id, 4, -14400, 1, 'EPT')
,(@time_zone_id, 5, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Dominica', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Edmonton', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1998663968, 2)
,(@time_zone_id, -1632063600, 1)
,(@time_zone_id, -1615132800, 2)
,(@time_zone_id, -1600614000, 1)
,(@time_zone_id, -1596816000, 2)
,(@time_zone_id, -1567954800, 1)
,(@time_zone_id, -1551628800, 2)
,(@time_zone_id, -1536505200, 1)
,(@time_zone_id, -1523203200, 2)
,(@time_zone_id, -1504450800, 1)
,(@time_zone_id, -1491753600, 2)
,(@time_zone_id, -1473001200, 1)
,(@time_zone_id, -1459699200, 2)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765388800, 2)
,(@time_zone_id, -715791600, 1)
,(@time_zone_id, -702489600, 2)
,(@time_zone_id, -84380400, 1)
,(@time_zone_id, -68659200, 2)
,(@time_zone_id, -21481200, 1)
,(@time_zone_id, -5760000, 2)
,(@time_zone_id, 73472400, 1)
,(@time_zone_id, 89193600, 2)
,(@time_zone_id, 104922000, 1)
,(@time_zone_id, 120643200, 2)
,(@time_zone_id, 136371600, 1)
,(@time_zone_id, 152092800, 2)
,(@time_zone_id, 167821200, 1)
,(@time_zone_id, 183542400, 2)
,(@time_zone_id, 199270800, 1)
,(@time_zone_id, 215596800, 2)
,(@time_zone_id, 230720400, 1)
,(@time_zone_id, 247046400, 2)
,(@time_zone_id, 262774800, 1)
,(@time_zone_id, 278496000, 2)
,(@time_zone_id, 294224400, 1)
,(@time_zone_id, 309945600, 2)
,(@time_zone_id, 325674000, 1)
,(@time_zone_id, 341395200, 2)
,(@time_zone_id, 357123600, 1)
,(@time_zone_id, 372844800, 2)
,(@time_zone_id, 388573200, 1)
,(@time_zone_id, 404899200, 2)
,(@time_zone_id, 420022800, 1)
,(@time_zone_id, 436348800, 2)
,(@time_zone_id, 452077200, 1)
,(@time_zone_id, 467798400, 2)
,(@time_zone_id, 483526800, 1)
,(@time_zone_id, 499248000, 2)
,(@time_zone_id, 514976400, 1)
,(@time_zone_id, 530697600, 2)
,(@time_zone_id, 544611600, 1)
,(@time_zone_id, 562147200, 2)
,(@time_zone_id, 576061200, 1)
,(@time_zone_id, 594201600, 2)
,(@time_zone_id, 607510800, 1)
,(@time_zone_id, 625651200, 2)
,(@time_zone_id, 638960400, 1)
,(@time_zone_id, 657100800, 2)
,(@time_zone_id, 671014800, 1)
,(@time_zone_id, 688550400, 2)
,(@time_zone_id, 702464400, 1)
,(@time_zone_id, 720000000, 2)
,(@time_zone_id, 733914000, 1)
,(@time_zone_id, 752054400, 2)
,(@time_zone_id, 765363600, 1)
,(@time_zone_id, 783504000, 2)
,(@time_zone_id, 796813200, 1)
,(@time_zone_id, 814953600, 2)
,(@time_zone_id, 828867600, 1)
,(@time_zone_id, 846403200, 2)
,(@time_zone_id, 860317200, 1)
,(@time_zone_id, 877852800, 2)
,(@time_zone_id, 891766800, 1)
,(@time_zone_id, 909302400, 2)
,(@time_zone_id, 923216400, 1)
,(@time_zone_id, 941356800, 2)
,(@time_zone_id, 954666000, 1)
,(@time_zone_id, 972806400, 2)
,(@time_zone_id, 986115600, 1)
,(@time_zone_id, 1004256000, 2)
,(@time_zone_id, 1018170000, 1)
,(@time_zone_id, 1035705600, 2)
,(@time_zone_id, 1049619600, 1)
,(@time_zone_id, 1067155200, 2)
,(@time_zone_id, 1081069200, 1)
,(@time_zone_id, 1099209600, 2)
,(@time_zone_id, 1112518800, 1)
,(@time_zone_id, 1130659200, 2)
,(@time_zone_id, 1143968400, 1)
,(@time_zone_id, 1162108800, 2)
,(@time_zone_id, 1173603600, 1)
,(@time_zone_id, 1194163200, 2)
,(@time_zone_id, 1205053200, 1)
,(@time_zone_id, 1225612800, 2)
,(@time_zone_id, 1236502800, 1)
,(@time_zone_id, 1257062400, 2)
,(@time_zone_id, 1268557200, 1)
,(@time_zone_id, 1289116800, 2)
,(@time_zone_id, 1300006800, 1)
,(@time_zone_id, 1320566400, 2)
,(@time_zone_id, 1331456400, 1)
,(@time_zone_id, 1352016000, 2)
,(@time_zone_id, 1362906000, 1)
,(@time_zone_id, 1383465600, 2)
,(@time_zone_id, 1394355600, 1)
,(@time_zone_id, 1414915200, 2)
,(@time_zone_id, 1425805200, 1)
,(@time_zone_id, 1446364800, 2)
,(@time_zone_id, 1457859600, 1)
,(@time_zone_id, 1478419200, 2)
,(@time_zone_id, 1489309200, 1)
,(@time_zone_id, 1509868800, 2)
,(@time_zone_id, 1520758800, 1)
,(@time_zone_id, 1541318400, 2)
,(@time_zone_id, 1552208400, 1)
,(@time_zone_id, 1572768000, 2)
,(@time_zone_id, 1583658000, 1)
,(@time_zone_id, 1604217600, 2)
,(@time_zone_id, 1615712400, 1)
,(@time_zone_id, 1636272000, 2)
,(@time_zone_id, 1647162000, 1)
,(@time_zone_id, 1667721600, 2)
,(@time_zone_id, 1678611600, 1)
,(@time_zone_id, 1699171200, 2)
,(@time_zone_id, 1710061200, 1)
,(@time_zone_id, 1730620800, 2)
,(@time_zone_id, 1741510800, 1)
,(@time_zone_id, 1762070400, 2)
,(@time_zone_id, 1772960400, 1)
,(@time_zone_id, 1793520000, 2)
,(@time_zone_id, 1805014800, 1)
,(@time_zone_id, 1825574400, 2)
,(@time_zone_id, 1836464400, 1)
,(@time_zone_id, 1857024000, 2)
,(@time_zone_id, 1867914000, 1)
,(@time_zone_id, 1888473600, 2)
,(@time_zone_id, 1899363600, 1)
,(@time_zone_id, 1919923200, 2)
,(@time_zone_id, 1930813200, 1)
,(@time_zone_id, 1951372800, 2)
,(@time_zone_id, 1962867600, 1)
,(@time_zone_id, 1983427200, 2)
,(@time_zone_id, 1994317200, 1)
,(@time_zone_id, 2014876800, 2)
,(@time_zone_id, 2025766800, 1)
,(@time_zone_id, 2046326400, 2)
,(@time_zone_id, 2057216400, 1)
,(@time_zone_id, 2077776000, 2)
,(@time_zone_id, 2088666000, 1)
,(@time_zone_id, 2109225600, 2)
,(@time_zone_id, 2120115600, 1)
,(@time_zone_id, 2140675200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -27232, 0, 'LMT')
,(@time_zone_id, 1, -21600, 1, 'MDT')
,(@time_zone_id, 2, -25200, 0, 'MST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
,(@time_zone_id, 4, -21600, 1, 'MPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Eirunepe', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767208832, 2)
,(@time_zone_id, -1206950400, 1)
,(@time_zone_id, -1191355200, 2)
,(@time_zone_id, -1175367600, 1)
,(@time_zone_id, -1159819200, 2)
,(@time_zone_id, -633812400, 1)
,(@time_zone_id, -622062000, 2)
,(@time_zone_id, -602276400, 1)
,(@time_zone_id, -591825600, 2)
,(@time_zone_id, -570740400, 1)
,(@time_zone_id, -560203200, 2)
,(@time_zone_id, -539118000, 1)
,(@time_zone_id, -531345600, 2)
,(@time_zone_id, -191358000, 1)
,(@time_zone_id, -184190400, 2)
,(@time_zone_id, -155156400, 1)
,(@time_zone_id, -150062400, 2)
,(@time_zone_id, -128890800, 1)
,(@time_zone_id, -121118400, 2)
,(@time_zone_id, -99946800, 1)
,(@time_zone_id, -89582400, 2)
,(@time_zone_id, -68410800, 1)
,(@time_zone_id, -57960000, 2)
,(@time_zone_id, 499755600, 1)
,(@time_zone_id, 511243200, 2)
,(@time_zone_id, 530600400, 1)
,(@time_zone_id, 540273600, 2)
,(@time_zone_id, 562136400, 1)
,(@time_zone_id, 571204800, 2)
,(@time_zone_id, 750834000, 1)
,(@time_zone_id, 761716800, 2)
,(@time_zone_id, 1214283600, 3)
,(@time_zone_id, 1384056000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16768, 0, 'LMT')
,(@time_zone_id, 1, -14400, 1, '-04')
,(@time_zone_id, 2, -18000, 0, '-05')
,(@time_zone_id, 3, -14400, 0, '-04')
,(@time_zone_id, 4, -18000, 0, '-05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/El_Salvador', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1546279392, 2)
,(@time_zone_id, 547020000, 1)
,(@time_zone_id, 559717200, 2)
,(@time_zone_id, 578469600, 1)
,(@time_zone_id, 591166800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21408, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Ensenada', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514736000, 1)
,(@time_zone_id, -1451667600, 2)
,(@time_zone_id, -1343062800, 1)
,(@time_zone_id, -1234803600, 2)
,(@time_zone_id, -1222963200, 3)
,(@time_zone_id, -1207242000, 2)
,(@time_zone_id, -873820800, 4)
,(@time_zone_id, -769395600, 5)
,(@time_zone_id, -761677200, 2)
,(@time_zone_id, -686073600, 3)
,(@time_zone_id, -661539600, 2)
,(@time_zone_id, -495039600, 3)
,(@time_zone_id, -481734000, 2)
,(@time_zone_id, -463590000, 3)
,(@time_zone_id, -450284400, 2)
,(@time_zone_id, -431535600, 3)
,(@time_zone_id, -418230000, 2)
,(@time_zone_id, -400086000, 3)
,(@time_zone_id, -386780400, 2)
,(@time_zone_id, -368636400, 3)
,(@time_zone_id, -355330800, 2)
,(@time_zone_id, -337186800, 3)
,(@time_zone_id, -323881200, 2)
,(@time_zone_id, -305737200, 3)
,(@time_zone_id, -292431600, 2)
,(@time_zone_id, 199274400, 3)
,(@time_zone_id, 215600400, 2)
,(@time_zone_id, 230724000, 3)
,(@time_zone_id, 247050000, 2)
,(@time_zone_id, 262778400, 3)
,(@time_zone_id, 278499600, 2)
,(@time_zone_id, 294228000, 3)
,(@time_zone_id, 309949200, 2)
,(@time_zone_id, 325677600, 3)
,(@time_zone_id, 341398800, 2)
,(@time_zone_id, 357127200, 3)
,(@time_zone_id, 372848400, 2)
,(@time_zone_id, 388576800, 3)
,(@time_zone_id, 404902800, 2)
,(@time_zone_id, 420026400, 3)
,(@time_zone_id, 436352400, 2)
,(@time_zone_id, 452080800, 3)
,(@time_zone_id, 467802000, 2)
,(@time_zone_id, 483530400, 3)
,(@time_zone_id, 499251600, 2)
,(@time_zone_id, 514980000, 3)
,(@time_zone_id, 530701200, 2)
,(@time_zone_id, 544615200, 3)
,(@time_zone_id, 562150800, 2)
,(@time_zone_id, 576064800, 3)
,(@time_zone_id, 594205200, 2)
,(@time_zone_id, 607514400, 3)
,(@time_zone_id, 625654800, 2)
,(@time_zone_id, 638964000, 3)
,(@time_zone_id, 657104400, 2)
,(@time_zone_id, 671018400, 3)
,(@time_zone_id, 688554000, 2)
,(@time_zone_id, 702468000, 3)
,(@time_zone_id, 720003600, 2)
,(@time_zone_id, 733917600, 3)
,(@time_zone_id, 752058000, 2)
,(@time_zone_id, 765367200, 3)
,(@time_zone_id, 783507600, 2)
,(@time_zone_id, 796816800, 3)
,(@time_zone_id, 814957200, 2)
,(@time_zone_id, 828871200, 3)
,(@time_zone_id, 846406800, 2)
,(@time_zone_id, 860320800, 3)
,(@time_zone_id, 877856400, 2)
,(@time_zone_id, 891770400, 3)
,(@time_zone_id, 909306000, 2)
,(@time_zone_id, 923220000, 3)
,(@time_zone_id, 941360400, 2)
,(@time_zone_id, 954669600, 3)
,(@time_zone_id, 972810000, 2)
,(@time_zone_id, 986119200, 3)
,(@time_zone_id, 1004259600, 2)
,(@time_zone_id, 1018173600, 3)
,(@time_zone_id, 1035709200, 2)
,(@time_zone_id, 1049623200, 3)
,(@time_zone_id, 1067158800, 2)
,(@time_zone_id, 1081072800, 3)
,(@time_zone_id, 1099213200, 2)
,(@time_zone_id, 1112522400, 3)
,(@time_zone_id, 1130662800, 2)
,(@time_zone_id, 1143972000, 3)
,(@time_zone_id, 1162112400, 2)
,(@time_zone_id, 1175421600, 3)
,(@time_zone_id, 1193562000, 2)
,(@time_zone_id, 1207476000, 3)
,(@time_zone_id, 1225011600, 2)
,(@time_zone_id, 1238925600, 3)
,(@time_zone_id, 1256461200, 2)
,(@time_zone_id, 1268560800, 3)
,(@time_zone_id, 1289120400, 2)
,(@time_zone_id, 1300010400, 3)
,(@time_zone_id, 1320570000, 2)
,(@time_zone_id, 1331460000, 3)
,(@time_zone_id, 1352019600, 2)
,(@time_zone_id, 1362909600, 3)
,(@time_zone_id, 1383469200, 2)
,(@time_zone_id, 1394359200, 3)
,(@time_zone_id, 1414918800, 2)
,(@time_zone_id, 1425808800, 3)
,(@time_zone_id, 1446368400, 2)
,(@time_zone_id, 1457863200, 3)
,(@time_zone_id, 1478422800, 2)
,(@time_zone_id, 1489312800, 3)
,(@time_zone_id, 1509872400, 2)
,(@time_zone_id, 1520762400, 3)
,(@time_zone_id, 1541322000, 2)
,(@time_zone_id, 1552212000, 3)
,(@time_zone_id, 1572771600, 2)
,(@time_zone_id, 1583661600, 3)
,(@time_zone_id, 1604221200, 2)
,(@time_zone_id, 1615716000, 3)
,(@time_zone_id, 1636275600, 2)
,(@time_zone_id, 1647165600, 3)
,(@time_zone_id, 1667725200, 2)
,(@time_zone_id, 1678615200, 3)
,(@time_zone_id, 1699174800, 2)
,(@time_zone_id, 1710064800, 3)
,(@time_zone_id, 1730624400, 2)
,(@time_zone_id, 1741514400, 3)
,(@time_zone_id, 1762074000, 2)
,(@time_zone_id, 1772964000, 3)
,(@time_zone_id, 1793523600, 2)
,(@time_zone_id, 1805018400, 3)
,(@time_zone_id, 1825578000, 2)
,(@time_zone_id, 1836468000, 3)
,(@time_zone_id, 1857027600, 2)
,(@time_zone_id, 1867917600, 3)
,(@time_zone_id, 1888477200, 2)
,(@time_zone_id, 1899367200, 3)
,(@time_zone_id, 1919926800, 2)
,(@time_zone_id, 1930816800, 3)
,(@time_zone_id, 1951376400, 2)
,(@time_zone_id, 1962871200, 3)
,(@time_zone_id, 1983430800, 2)
,(@time_zone_id, 1994320800, 3)
,(@time_zone_id, 2014880400, 2)
,(@time_zone_id, 2025770400, 3)
,(@time_zone_id, 2046330000, 2)
,(@time_zone_id, 2057220000, 3)
,(@time_zone_id, 2077779600, 2)
,(@time_zone_id, 2088669600, 3)
,(@time_zone_id, 2109229200, 2)
,(@time_zone_id, 2120119200, 3)
,(@time_zone_id, 2140678800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -28084, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -25200, 1, 'PDT')
,(@time_zone_id, 4, -25200, 1, 'PWT')
,(@time_zone_id, 5, -25200, 1, 'PPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Fort_Nelson', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632060000, 1)
,(@time_zone_id, -1615129200, 2)
,(@time_zone_id, -880207200, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765385200, 2)
,(@time_zone_id, -715788000, 1)
,(@time_zone_id, -702486000, 2)
,(@time_zone_id, -684338400, 1)
,(@time_zone_id, -671036400, 2)
,(@time_zone_id, -652888800, 1)
,(@time_zone_id, -639586800, 2)
,(@time_zone_id, -620834400, 1)
,(@time_zone_id, -608137200, 2)
,(@time_zone_id, -589384800, 1)
,(@time_zone_id, -576082800, 2)
,(@time_zone_id, -557935200, 1)
,(@time_zone_id, -544633200, 2)
,(@time_zone_id, -526485600, 1)
,(@time_zone_id, -513183600, 2)
,(@time_zone_id, -495036000, 1)
,(@time_zone_id, -481734000, 2)
,(@time_zone_id, -463586400, 1)
,(@time_zone_id, -450284400, 2)
,(@time_zone_id, -431532000, 1)
,(@time_zone_id, -418230000, 2)
,(@time_zone_id, -400082400, 1)
,(@time_zone_id, -386780400, 2)
,(@time_zone_id, -368632800, 1)
,(@time_zone_id, -355330800, 2)
,(@time_zone_id, -337183200, 1)
,(@time_zone_id, -323881200, 2)
,(@time_zone_id, -305733600, 1)
,(@time_zone_id, -292431600, 2)
,(@time_zone_id, -273679200, 1)
,(@time_zone_id, -260982000, 2)
,(@time_zone_id, -242229600, 1)
,(@time_zone_id, -226508400, 2)
,(@time_zone_id, -210780000, 1)
,(@time_zone_id, -195058800, 2)
,(@time_zone_id, -179330400, 1)
,(@time_zone_id, -163609200, 2)
,(@time_zone_id, -147880800, 1)
,(@time_zone_id, -131554800, 2)
,(@time_zone_id, -116431200, 1)
,(@time_zone_id, -100105200, 2)
,(@time_zone_id, -84376800, 1)
,(@time_zone_id, -68655600, 2)
,(@time_zone_id, -52927200, 1)
,(@time_zone_id, -37206000, 2)
,(@time_zone_id, -21477600, 1)
,(@time_zone_id, -5756400, 2)
,(@time_zone_id, 9972000, 1)
,(@time_zone_id, 25693200, 2)
,(@time_zone_id, 41421600, 1)
,(@time_zone_id, 57747600, 2)
,(@time_zone_id, 73476000, 1)
,(@time_zone_id, 89197200, 2)
,(@time_zone_id, 104925600, 1)
,(@time_zone_id, 120646800, 2)
,(@time_zone_id, 136375200, 1)
,(@time_zone_id, 152096400, 2)
,(@time_zone_id, 167824800, 1)
,(@time_zone_id, 183546000, 2)
,(@time_zone_id, 199274400, 1)
,(@time_zone_id, 215600400, 2)
,(@time_zone_id, 230724000, 1)
,(@time_zone_id, 247050000, 2)
,(@time_zone_id, 262778400, 1)
,(@time_zone_id, 278499600, 2)
,(@time_zone_id, 294228000, 1)
,(@time_zone_id, 309949200, 2)
,(@time_zone_id, 325677600, 1)
,(@time_zone_id, 341398800, 2)
,(@time_zone_id, 357127200, 1)
,(@time_zone_id, 372848400, 2)
,(@time_zone_id, 388576800, 1)
,(@time_zone_id, 404902800, 2)
,(@time_zone_id, 420026400, 1)
,(@time_zone_id, 436352400, 2)
,(@time_zone_id, 452080800, 1)
,(@time_zone_id, 467802000, 2)
,(@time_zone_id, 483530400, 1)
,(@time_zone_id, 499251600, 2)
,(@time_zone_id, 514980000, 1)
,(@time_zone_id, 530701200, 2)
,(@time_zone_id, 544615200, 1)
,(@time_zone_id, 562150800, 2)
,(@time_zone_id, 576064800, 1)
,(@time_zone_id, 594205200, 2)
,(@time_zone_id, 607514400, 1)
,(@time_zone_id, 625654800, 2)
,(@time_zone_id, 638964000, 1)
,(@time_zone_id, 657104400, 2)
,(@time_zone_id, 671018400, 1)
,(@time_zone_id, 688554000, 2)
,(@time_zone_id, 702468000, 1)
,(@time_zone_id, 720003600, 2)
,(@time_zone_id, 733917600, 1)
,(@time_zone_id, 752058000, 2)
,(@time_zone_id, 765367200, 1)
,(@time_zone_id, 783507600, 2)
,(@time_zone_id, 796816800, 1)
,(@time_zone_id, 814957200, 2)
,(@time_zone_id, 828871200, 1)
,(@time_zone_id, 846406800, 2)
,(@time_zone_id, 860320800, 1)
,(@time_zone_id, 877856400, 2)
,(@time_zone_id, 891770400, 1)
,(@time_zone_id, 909306000, 2)
,(@time_zone_id, 923220000, 1)
,(@time_zone_id, 941360400, 2)
,(@time_zone_id, 954669600, 1)
,(@time_zone_id, 972810000, 2)
,(@time_zone_id, 986119200, 1)
,(@time_zone_id, 1004259600, 2)
,(@time_zone_id, 1018173600, 1)
,(@time_zone_id, 1035709200, 2)
,(@time_zone_id, 1049623200, 1)
,(@time_zone_id, 1067158800, 2)
,(@time_zone_id, 1081072800, 1)
,(@time_zone_id, 1099213200, 2)
,(@time_zone_id, 1112522400, 1)
,(@time_zone_id, 1130662800, 2)
,(@time_zone_id, 1143972000, 1)
,(@time_zone_id, 1162112400, 2)
,(@time_zone_id, 1173607200, 1)
,(@time_zone_id, 1194166800, 2)
,(@time_zone_id, 1205056800, 1)
,(@time_zone_id, 1225616400, 2)
,(@time_zone_id, 1236506400, 1)
,(@time_zone_id, 1257066000, 2)
,(@time_zone_id, 1268560800, 1)
,(@time_zone_id, 1289120400, 2)
,(@time_zone_id, 1300010400, 1)
,(@time_zone_id, 1320570000, 2)
,(@time_zone_id, 1331460000, 1)
,(@time_zone_id, 1352019600, 2)
,(@time_zone_id, 1362909600, 1)
,(@time_zone_id, 1383469200, 2)
,(@time_zone_id, 1394359200, 1)
,(@time_zone_id, 1414918800, 2)
,(@time_zone_id, 1425808800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -29447, 0, 'LMT')
,(@time_zone_id, 1, -25200, 1, 'PDT')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -25200, 1, 'PWT')
,(@time_zone_id, 4, -25200, 1, 'PPT')
,(@time_zone_id, 5, -25200, 0, 'MST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Fort_Wayne', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -900259200, 1)
,(@time_zone_id, -891795600, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -747244800, 1)
,(@time_zone_id, -733942800, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -702493200, 2)
,(@time_zone_id, -684345600, 1)
,(@time_zone_id, -671043600, 2)
,(@time_zone_id, -652896000, 1)
,(@time_zone_id, -639594000, 2)
,(@time_zone_id, -620841600, 1)
,(@time_zone_id, -608144400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 5)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 1143961200, 6)
,(@time_zone_id, 1162101600, 5)
,(@time_zone_id, 1173596400, 6)
,(@time_zone_id, 1194156000, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20678, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Fortaleza', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767216360, 2)
,(@time_zone_id, -1206957600, 1)
,(@time_zone_id, -1191362400, 2)
,(@time_zone_id, -1175374800, 1)
,(@time_zone_id, -1159826400, 2)
,(@time_zone_id, -633819600, 1)
,(@time_zone_id, -622069200, 2)
,(@time_zone_id, -602283600, 1)
,(@time_zone_id, -591832800, 2)
,(@time_zone_id, -570747600, 1)
,(@time_zone_id, -560210400, 2)
,(@time_zone_id, -539125200, 1)
,(@time_zone_id, -531352800, 2)
,(@time_zone_id, -191365200, 1)
,(@time_zone_id, -184197600, 2)
,(@time_zone_id, -155163600, 1)
,(@time_zone_id, -150069600, 2)
,(@time_zone_id, -128898000, 1)
,(@time_zone_id, -121125600, 2)
,(@time_zone_id, -99954000, 1)
,(@time_zone_id, -89589600, 2)
,(@time_zone_id, -68418000, 1)
,(@time_zone_id, -57967200, 2)
,(@time_zone_id, 499748400, 1)
,(@time_zone_id, 511236000, 2)
,(@time_zone_id, 530593200, 1)
,(@time_zone_id, 540266400, 2)
,(@time_zone_id, 562129200, 1)
,(@time_zone_id, 571197600, 2)
,(@time_zone_id, 592974000, 1)
,(@time_zone_id, 602042400, 2)
,(@time_zone_id, 624423600, 1)
,(@time_zone_id, 634701600, 2)
,(@time_zone_id, 938919600, 1)
,(@time_zone_id, 951616800, 2)
,(@time_zone_id, 970974000, 1)
,(@time_zone_id, 972180000, 2)
,(@time_zone_id, 1003028400, 1)
,(@time_zone_id, 1013911200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -9240, 0, 'LMT')
,(@time_zone_id, 1, -7200, 1, '-02')
,(@time_zone_id, 2, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Glace_Bay', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2131646412, 2)
,(@time_zone_id, -1632074400, 1)
,(@time_zone_id, -1615143600, 2)
,(@time_zone_id, -880221600, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765399600, 2)
,(@time_zone_id, -526500000, 1)
,(@time_zone_id, -513198000, 2)
,(@time_zone_id, 73461600, 1)
,(@time_zone_id, 89182800, 2)
,(@time_zone_id, 104911200, 1)
,(@time_zone_id, 120632400, 2)
,(@time_zone_id, 136360800, 1)
,(@time_zone_id, 152082000, 2)
,(@time_zone_id, 167810400, 1)
,(@time_zone_id, 183531600, 2)
,(@time_zone_id, 199260000, 1)
,(@time_zone_id, 215586000, 2)
,(@time_zone_id, 230709600, 1)
,(@time_zone_id, 247035600, 2)
,(@time_zone_id, 262764000, 1)
,(@time_zone_id, 278485200, 2)
,(@time_zone_id, 294213600, 1)
,(@time_zone_id, 309934800, 2)
,(@time_zone_id, 325663200, 1)
,(@time_zone_id, 341384400, 2)
,(@time_zone_id, 357112800, 1)
,(@time_zone_id, 372834000, 2)
,(@time_zone_id, 388562400, 1)
,(@time_zone_id, 404888400, 2)
,(@time_zone_id, 420012000, 1)
,(@time_zone_id, 436338000, 2)
,(@time_zone_id, 452066400, 1)
,(@time_zone_id, 467787600, 2)
,(@time_zone_id, 483516000, 1)
,(@time_zone_id, 499237200, 2)
,(@time_zone_id, 514965600, 1)
,(@time_zone_id, 530686800, 2)
,(@time_zone_id, 544600800, 1)
,(@time_zone_id, 562136400, 2)
,(@time_zone_id, 576050400, 1)
,(@time_zone_id, 594190800, 2)
,(@time_zone_id, 607500000, 1)
,(@time_zone_id, 625640400, 2)
,(@time_zone_id, 638949600, 1)
,(@time_zone_id, 657090000, 2)
,(@time_zone_id, 671004000, 1)
,(@time_zone_id, 688539600, 2)
,(@time_zone_id, 702453600, 1)
,(@time_zone_id, 719989200, 2)
,(@time_zone_id, 733903200, 1)
,(@time_zone_id, 752043600, 2)
,(@time_zone_id, 765352800, 1)
,(@time_zone_id, 783493200, 2)
,(@time_zone_id, 796802400, 1)
,(@time_zone_id, 814942800, 2)
,(@time_zone_id, 828856800, 1)
,(@time_zone_id, 846392400, 2)
,(@time_zone_id, 860306400, 1)
,(@time_zone_id, 877842000, 2)
,(@time_zone_id, 891756000, 1)
,(@time_zone_id, 909291600, 2)
,(@time_zone_id, 923205600, 1)
,(@time_zone_id, 941346000, 2)
,(@time_zone_id, 954655200, 1)
,(@time_zone_id, 972795600, 2)
,(@time_zone_id, 986104800, 1)
,(@time_zone_id, 1004245200, 2)
,(@time_zone_id, 1018159200, 1)
,(@time_zone_id, 1035694800, 2)
,(@time_zone_id, 1049608800, 1)
,(@time_zone_id, 1067144400, 2)
,(@time_zone_id, 1081058400, 1)
,(@time_zone_id, 1099198800, 2)
,(@time_zone_id, 1112508000, 1)
,(@time_zone_id, 1130648400, 2)
,(@time_zone_id, 1143957600, 1)
,(@time_zone_id, 1162098000, 2)
,(@time_zone_id, 1173592800, 1)
,(@time_zone_id, 1194152400, 2)
,(@time_zone_id, 1205042400, 1)
,(@time_zone_id, 1225602000, 2)
,(@time_zone_id, 1236492000, 1)
,(@time_zone_id, 1257051600, 2)
,(@time_zone_id, 1268546400, 1)
,(@time_zone_id, 1289106000, 2)
,(@time_zone_id, 1299996000, 1)
,(@time_zone_id, 1320555600, 2)
,(@time_zone_id, 1331445600, 1)
,(@time_zone_id, 1352005200, 2)
,(@time_zone_id, 1362895200, 1)
,(@time_zone_id, 1383454800, 2)
,(@time_zone_id, 1394344800, 1)
,(@time_zone_id, 1414904400, 2)
,(@time_zone_id, 1425794400, 1)
,(@time_zone_id, 1446354000, 2)
,(@time_zone_id, 1457848800, 1)
,(@time_zone_id, 1478408400, 2)
,(@time_zone_id, 1489298400, 1)
,(@time_zone_id, 1509858000, 2)
,(@time_zone_id, 1520748000, 1)
,(@time_zone_id, 1541307600, 2)
,(@time_zone_id, 1552197600, 1)
,(@time_zone_id, 1572757200, 2)
,(@time_zone_id, 1583647200, 1)
,(@time_zone_id, 1604206800, 2)
,(@time_zone_id, 1615701600, 1)
,(@time_zone_id, 1636261200, 2)
,(@time_zone_id, 1647151200, 1)
,(@time_zone_id, 1667710800, 2)
,(@time_zone_id, 1678600800, 1)
,(@time_zone_id, 1699160400, 2)
,(@time_zone_id, 1710050400, 1)
,(@time_zone_id, 1730610000, 2)
,(@time_zone_id, 1741500000, 1)
,(@time_zone_id, 1762059600, 2)
,(@time_zone_id, 1772949600, 1)
,(@time_zone_id, 1793509200, 2)
,(@time_zone_id, 1805004000, 1)
,(@time_zone_id, 1825563600, 2)
,(@time_zone_id, 1836453600, 1)
,(@time_zone_id, 1857013200, 2)
,(@time_zone_id, 1867903200, 1)
,(@time_zone_id, 1888462800, 2)
,(@time_zone_id, 1899352800, 1)
,(@time_zone_id, 1919912400, 2)
,(@time_zone_id, 1930802400, 1)
,(@time_zone_id, 1951362000, 2)
,(@time_zone_id, 1962856800, 1)
,(@time_zone_id, 1983416400, 2)
,(@time_zone_id, 1994306400, 1)
,(@time_zone_id, 2014866000, 2)
,(@time_zone_id, 2025756000, 1)
,(@time_zone_id, 2046315600, 2)
,(@time_zone_id, 2057205600, 1)
,(@time_zone_id, 2077765200, 2)
,(@time_zone_id, 2088655200, 1)
,(@time_zone_id, 2109214800, 2)
,(@time_zone_id, 2120104800, 1)
,(@time_zone_id, 2140664400, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14388, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, 'ADT')
,(@time_zone_id, 2, -14400, 0, 'AST')
,(@time_zone_id, 3, -10800, 1, 'AWT')
,(@time_zone_id, 4, -10800, 1, 'APT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Godthab', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1686083584, 1)
,(@time_zone_id, 323845200, 4)
,(@time_zone_id, 338950800, 2)
,(@time_zone_id, 354675600, 3)
,(@time_zone_id, 370400400, 2)
,(@time_zone_id, 386125200, 3)
,(@time_zone_id, 401850000, 2)
,(@time_zone_id, 417574800, 3)
,(@time_zone_id, 433299600, 2)
,(@time_zone_id, 449024400, 3)
,(@time_zone_id, 465354000, 2)
,(@time_zone_id, 481078800, 3)
,(@time_zone_id, 496803600, 2)
,(@time_zone_id, 512528400, 3)
,(@time_zone_id, 528253200, 2)
,(@time_zone_id, 543978000, 3)
,(@time_zone_id, 559702800, 2)
,(@time_zone_id, 575427600, 3)
,(@time_zone_id, 591152400, 2)
,(@time_zone_id, 606877200, 3)
,(@time_zone_id, 622602000, 2)
,(@time_zone_id, 638326800, 3)
,(@time_zone_id, 654656400, 2)
,(@time_zone_id, 670381200, 3)
,(@time_zone_id, 686106000, 2)
,(@time_zone_id, 701830800, 3)
,(@time_zone_id, 717555600, 2)
,(@time_zone_id, 733280400, 3)
,(@time_zone_id, 749005200, 2)
,(@time_zone_id, 764730000, 3)
,(@time_zone_id, 780454800, 2)
,(@time_zone_id, 796179600, 3)
,(@time_zone_id, 811904400, 2)
,(@time_zone_id, 828234000, 3)
,(@time_zone_id, 846378000, 2)
,(@time_zone_id, 859683600, 3)
,(@time_zone_id, 877827600, 2)
,(@time_zone_id, 891133200, 3)
,(@time_zone_id, 909277200, 2)
,(@time_zone_id, 922582800, 3)
,(@time_zone_id, 941331600, 2)
,(@time_zone_id, 954032400, 3)
,(@time_zone_id, 972781200, 2)
,(@time_zone_id, 985482000, 3)
,(@time_zone_id, 1004230800, 2)
,(@time_zone_id, 1017536400, 3)
,(@time_zone_id, 1035680400, 2)
,(@time_zone_id, 1048986000, 3)
,(@time_zone_id, 1067130000, 2)
,(@time_zone_id, 1080435600, 3)
,(@time_zone_id, 1099184400, 2)
,(@time_zone_id, 1111885200, 3)
,(@time_zone_id, 1130634000, 2)
,(@time_zone_id, 1143334800, 3)
,(@time_zone_id, 1162083600, 2)
,(@time_zone_id, 1174784400, 3)
,(@time_zone_id, 1193533200, 2)
,(@time_zone_id, 1206838800, 3)
,(@time_zone_id, 1224982800, 2)
,(@time_zone_id, 1238288400, 3)
,(@time_zone_id, 1256432400, 2)
,(@time_zone_id, 1269738000, 3)
,(@time_zone_id, 1288486800, 2)
,(@time_zone_id, 1301187600, 3)
,(@time_zone_id, 1319936400, 2)
,(@time_zone_id, 1332637200, 3)
,(@time_zone_id, 1351386000, 2)
,(@time_zone_id, 1364691600, 3)
,(@time_zone_id, 1382835600, 2)
,(@time_zone_id, 1396141200, 3)
,(@time_zone_id, 1414285200, 2)
,(@time_zone_id, 1427590800, 3)
,(@time_zone_id, 1445734800, 2)
,(@time_zone_id, 1459040400, 3)
,(@time_zone_id, 1477789200, 2)
,(@time_zone_id, 1490490000, 3)
,(@time_zone_id, 1509238800, 2)
,(@time_zone_id, 1521939600, 3)
,(@time_zone_id, 1540688400, 2)
,(@time_zone_id, 1553994000, 3)
,(@time_zone_id, 1572138000, 2)
,(@time_zone_id, 1585443600, 3)
,(@time_zone_id, 1603587600, 2)
,(@time_zone_id, 1616893200, 3)
,(@time_zone_id, 1635642000, 2)
,(@time_zone_id, 1648342800, 3)
,(@time_zone_id, 1667091600, 2)
,(@time_zone_id, 1679792400, 3)
,(@time_zone_id, 1698541200, 2)
,(@time_zone_id, 1711846800, 3)
,(@time_zone_id, 1729990800, 2)
,(@time_zone_id, 1743296400, 3)
,(@time_zone_id, 1761440400, 2)
,(@time_zone_id, 1774746000, 3)
,(@time_zone_id, 1792890000, 2)
,(@time_zone_id, 1806195600, 3)
,(@time_zone_id, 1824944400, 2)
,(@time_zone_id, 1837645200, 3)
,(@time_zone_id, 1856394000, 2)
,(@time_zone_id, 1869094800, 3)
,(@time_zone_id, 1887843600, 2)
,(@time_zone_id, 1901149200, 3)
,(@time_zone_id, 1919293200, 2)
,(@time_zone_id, 1932598800, 3)
,(@time_zone_id, 1950742800, 2)
,(@time_zone_id, 1964048400, 3)
,(@time_zone_id, 1982797200, 2)
,(@time_zone_id, 1995498000, 3)
,(@time_zone_id, 2014246800, 2)
,(@time_zone_id, 2026947600, 3)
,(@time_zone_id, 2045696400, 2)
,(@time_zone_id, 2058397200, 3)
,(@time_zone_id, 2077146000, 2)
,(@time_zone_id, 2090451600, 3)
,(@time_zone_id, 2108595600, 2)
,(@time_zone_id, 2121901200, 3)
,(@time_zone_id, 2140045200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -12416, 0, 'LMT')
,(@time_zone_id, 1, -10800, 0, '-03')
,(@time_zone_id, 2, -10800, 0, '-03')
,(@time_zone_id, 3, -7200, 1, '-02')
,(@time_zone_id, 4, -7200, 1, '-02')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Goose_Bay', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1632076148, 2)
,(@time_zone_id, -1615145348, 1)
,(@time_zone_id, -1096921748, 3)
,(@time_zone_id, -1061670600, 4)
,(@time_zone_id, -1048973400, 3)
,(@time_zone_id, -1030221000, 4)
,(@time_zone_id, -1017523800, 3)
,(@time_zone_id, -998771400, 4)
,(@time_zone_id, -986074200, 3)
,(@time_zone_id, -966717000, 4)
,(@time_zone_id, -954624600, 3)
,(@time_zone_id, -935267400, 4)
,(@time_zone_id, -922570200, 3)
,(@time_zone_id, -903817800, 4)
,(@time_zone_id, -891120600, 3)
,(@time_zone_id, -872368200, 6)
,(@time_zone_id, -769395600, 5)
,(@time_zone_id, -765401400, 3)
,(@time_zone_id, -746044200, 4)
,(@time_zone_id, -733347000, 3)
,(@time_zone_id, -714594600, 4)
,(@time_zone_id, -701897400, 3)
,(@time_zone_id, -683145000, 4)
,(@time_zone_id, -670447800, 3)
,(@time_zone_id, -651695400, 4)
,(@time_zone_id, -638998200, 3)
,(@time_zone_id, -619641000, 4)
,(@time_zone_id, -606943800, 3)
,(@time_zone_id, -589401000, 4)
,(@time_zone_id, -576099000, 3)
,(@time_zone_id, -557951400, 4)
,(@time_zone_id, -544649400, 3)
,(@time_zone_id, -526501800, 4)
,(@time_zone_id, -513199800, 3)
,(@time_zone_id, -495052200, 4)
,(@time_zone_id, -481750200, 3)
,(@time_zone_id, -463602600, 4)
,(@time_zone_id, -450300600, 3)
,(@time_zone_id, -431548200, 4)
,(@time_zone_id, -418246200, 3)
,(@time_zone_id, -400098600, 4)
,(@time_zone_id, -386796600, 3)
,(@time_zone_id, -368649000, 4)
,(@time_zone_id, -355347000, 3)
,(@time_zone_id, -337199400, 4)
,(@time_zone_id, -323897400, 3)
,(@time_zone_id, -305749800, 4)
,(@time_zone_id, -289423800, 3)
,(@time_zone_id, -273695400, 4)
,(@time_zone_id, -257974200, 3)
,(@time_zone_id, -242245800, 4)
,(@time_zone_id, -226524600, 3)
,(@time_zone_id, -210796200, 4)
,(@time_zone_id, -195075000, 3)
,(@time_zone_id, -179346600, 4)
,(@time_zone_id, -163625400, 3)
,(@time_zone_id, -147897000, 4)
,(@time_zone_id, -131571000, 3)
,(@time_zone_id, -119903400, 8)
,(@time_zone_id, -116445600, 7)
,(@time_zone_id, -100119600, 8)
,(@time_zone_id, -84391200, 7)
,(@time_zone_id, -68670000, 8)
,(@time_zone_id, -52941600, 7)
,(@time_zone_id, -37220400, 8)
,(@time_zone_id, -21492000, 7)
,(@time_zone_id, -5770800, 8)
,(@time_zone_id, 9957600, 7)
,(@time_zone_id, 25678800, 8)
,(@time_zone_id, 41407200, 7)
,(@time_zone_id, 57733200, 8)
,(@time_zone_id, 73461600, 7)
,(@time_zone_id, 89182800, 8)
,(@time_zone_id, 104911200, 7)
,(@time_zone_id, 120632400, 8)
,(@time_zone_id, 136360800, 7)
,(@time_zone_id, 152082000, 8)
,(@time_zone_id, 167810400, 7)
,(@time_zone_id, 183531600, 8)
,(@time_zone_id, 199260000, 7)
,(@time_zone_id, 215586000, 8)
,(@time_zone_id, 230709600, 7)
,(@time_zone_id, 247035600, 8)
,(@time_zone_id, 262764000, 7)
,(@time_zone_id, 278485200, 8)
,(@time_zone_id, 294213600, 7)
,(@time_zone_id, 309934800, 8)
,(@time_zone_id, 325663200, 7)
,(@time_zone_id, 341384400, 8)
,(@time_zone_id, 357112800, 7)
,(@time_zone_id, 372834000, 8)
,(@time_zone_id, 388562400, 7)
,(@time_zone_id, 404888400, 8)
,(@time_zone_id, 420012000, 7)
,(@time_zone_id, 436338000, 8)
,(@time_zone_id, 452066400, 7)
,(@time_zone_id, 467787600, 8)
,(@time_zone_id, 483516000, 7)
,(@time_zone_id, 499237200, 8)
,(@time_zone_id, 514965600, 7)
,(@time_zone_id, 530686800, 8)
,(@time_zone_id, 544593660, 7)
,(@time_zone_id, 562129260, 8)
,(@time_zone_id, 576043260, 9)
,(@time_zone_id, 594180060, 8)
,(@time_zone_id, 607492860, 7)
,(@time_zone_id, 625633260, 8)
,(@time_zone_id, 638942460, 7)
,(@time_zone_id, 657082860, 8)
,(@time_zone_id, 670996860, 7)
,(@time_zone_id, 688532460, 8)
,(@time_zone_id, 702446460, 7)
,(@time_zone_id, 719982060, 8)
,(@time_zone_id, 733896060, 7)
,(@time_zone_id, 752036460, 8)
,(@time_zone_id, 765345660, 7)
,(@time_zone_id, 783486060, 8)
,(@time_zone_id, 796795260, 7)
,(@time_zone_id, 814935660, 8)
,(@time_zone_id, 828849660, 7)
,(@time_zone_id, 846385260, 8)
,(@time_zone_id, 860299260, 7)
,(@time_zone_id, 877834860, 8)
,(@time_zone_id, 891748860, 7)
,(@time_zone_id, 909284460, 8)
,(@time_zone_id, 923198460, 7)
,(@time_zone_id, 941338860, 8)
,(@time_zone_id, 954648060, 7)
,(@time_zone_id, 972788460, 8)
,(@time_zone_id, 986097660, 7)
,(@time_zone_id, 1004238060, 8)
,(@time_zone_id, 1018152060, 7)
,(@time_zone_id, 1035687660, 8)
,(@time_zone_id, 1049601660, 7)
,(@time_zone_id, 1067137260, 8)
,(@time_zone_id, 1081051260, 7)
,(@time_zone_id, 1099191660, 8)
,(@time_zone_id, 1112500860, 7)
,(@time_zone_id, 1130641260, 8)
,(@time_zone_id, 1143950460, 7)
,(@time_zone_id, 1162090860, 8)
,(@time_zone_id, 1173585660, 7)
,(@time_zone_id, 1194145260, 8)
,(@time_zone_id, 1205035260, 7)
,(@time_zone_id, 1225594860, 8)
,(@time_zone_id, 1236484860, 7)
,(@time_zone_id, 1257044460, 8)
,(@time_zone_id, 1268539260, 7)
,(@time_zone_id, 1289098860, 8)
,(@time_zone_id, 1299988860, 7)
,(@time_zone_id, 1320555600, 8)
,(@time_zone_id, 1331445600, 7)
,(@time_zone_id, 1352005200, 8)
,(@time_zone_id, 1362895200, 7)
,(@time_zone_id, 1383454800, 8)
,(@time_zone_id, 1394344800, 7)
,(@time_zone_id, 1414904400, 8)
,(@time_zone_id, 1425794400, 7)
,(@time_zone_id, 1446354000, 8)
,(@time_zone_id, 1457848800, 7)
,(@time_zone_id, 1478408400, 8)
,(@time_zone_id, 1489298400, 7)
,(@time_zone_id, 1509858000, 8)
,(@time_zone_id, 1520748000, 7)
,(@time_zone_id, 1541307600, 8)
,(@time_zone_id, 1552197600, 7)
,(@time_zone_id, 1572757200, 8)
,(@time_zone_id, 1583647200, 7)
,(@time_zone_id, 1604206800, 8)
,(@time_zone_id, 1615701600, 7)
,(@time_zone_id, 1636261200, 8)
,(@time_zone_id, 1647151200, 7)
,(@time_zone_id, 1667710800, 8)
,(@time_zone_id, 1678600800, 7)
,(@time_zone_id, 1699160400, 8)
,(@time_zone_id, 1710050400, 7)
,(@time_zone_id, 1730610000, 8)
,(@time_zone_id, 1741500000, 7)
,(@time_zone_id, 1762059600, 8)
,(@time_zone_id, 1772949600, 7)
,(@time_zone_id, 1793509200, 8)
,(@time_zone_id, 1805004000, 7)
,(@time_zone_id, 1825563600, 8)
,(@time_zone_id, 1836453600, 7)
,(@time_zone_id, 1857013200, 8)
,(@time_zone_id, 1867903200, 7)
,(@time_zone_id, 1888462800, 8)
,(@time_zone_id, 1899352800, 7)
,(@time_zone_id, 1919912400, 8)
,(@time_zone_id, 1930802400, 7)
,(@time_zone_id, 1951362000, 8)
,(@time_zone_id, 1962856800, 7)
,(@time_zone_id, 1983416400, 8)
,(@time_zone_id, 1994306400, 7)
,(@time_zone_id, 2014866000, 8)
,(@time_zone_id, 2025756000, 7)
,(@time_zone_id, 2046315600, 8)
,(@time_zone_id, 2057205600, 7)
,(@time_zone_id, 2077765200, 8)
,(@time_zone_id, 2088655200, 7)
,(@time_zone_id, 2109214800, 8)
,(@time_zone_id, 2120104800, 7)
,(@time_zone_id, 2140664400, 8)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14500, 0, 'LMT')
,(@time_zone_id, 1, -12652, 0, 'NST')
,(@time_zone_id, 2, -9052, 1, 'NDT')
,(@time_zone_id, 3, -12600, 0, 'NST')
,(@time_zone_id, 4, -9000, 1, 'NDT')
,(@time_zone_id, 5, -9000, 1, 'NPT')
,(@time_zone_id, 6, -9000, 1, 'NWT')
,(@time_zone_id, 7, -10800, 1, 'ADT')
,(@time_zone_id, 8, -14400, 0, 'AST')
,(@time_zone_id, 9, -7200, 1, 'ADDT')
,(@time_zone_id, 10, -10800, 1, 'ADT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Grand_Turk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1827687170, 2)
,(@time_zone_id, 294217200, 3)
,(@time_zone_id, 309938400, 2)
,(@time_zone_id, 325666800, 3)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 3)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 3)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 3)
,(@time_zone_id, 436341600, 2)
,(@time_zone_id, 452070000, 3)
,(@time_zone_id, 467791200, 2)
,(@time_zone_id, 483519600, 3)
,(@time_zone_id, 499240800, 2)
,(@time_zone_id, 514969200, 3)
,(@time_zone_id, 530690400, 2)
,(@time_zone_id, 544604400, 3)
,(@time_zone_id, 562140000, 2)
,(@time_zone_id, 576054000, 3)
,(@time_zone_id, 594194400, 2)
,(@time_zone_id, 607503600, 3)
,(@time_zone_id, 625644000, 2)
,(@time_zone_id, 638953200, 3)
,(@time_zone_id, 657093600, 2)
,(@time_zone_id, 671007600, 3)
,(@time_zone_id, 688543200, 2)
,(@time_zone_id, 702457200, 3)
,(@time_zone_id, 719992800, 2)
,(@time_zone_id, 733906800, 3)
,(@time_zone_id, 752047200, 2)
,(@time_zone_id, 765356400, 3)
,(@time_zone_id, 783496800, 2)
,(@time_zone_id, 796806000, 3)
,(@time_zone_id, 814946400, 2)
,(@time_zone_id, 828860400, 3)
,(@time_zone_id, 846396000, 2)
,(@time_zone_id, 860310000, 3)
,(@time_zone_id, 877845600, 2)
,(@time_zone_id, 891759600, 3)
,(@time_zone_id, 909295200, 2)
,(@time_zone_id, 923209200, 3)
,(@time_zone_id, 941349600, 2)
,(@time_zone_id, 954658800, 3)
,(@time_zone_id, 972799200, 2)
,(@time_zone_id, 986108400, 3)
,(@time_zone_id, 1004248800, 2)
,(@time_zone_id, 1018162800, 3)
,(@time_zone_id, 1035698400, 2)
,(@time_zone_id, 1049612400, 3)
,(@time_zone_id, 1067148000, 2)
,(@time_zone_id, 1081062000, 3)
,(@time_zone_id, 1099202400, 2)
,(@time_zone_id, 1112511600, 3)
,(@time_zone_id, 1130652000, 2)
,(@time_zone_id, 1143961200, 3)
,(@time_zone_id, 1162101600, 2)
,(@time_zone_id, 1173596400, 3)
,(@time_zone_id, 1194156000, 2)
,(@time_zone_id, 1205046000, 3)
,(@time_zone_id, 1225605600, 2)
,(@time_zone_id, 1236495600, 3)
,(@time_zone_id, 1257055200, 2)
,(@time_zone_id, 1268550000, 3)
,(@time_zone_id, 1289109600, 2)
,(@time_zone_id, 1299999600, 3)
,(@time_zone_id, 1320559200, 2)
,(@time_zone_id, 1331449200, 3)
,(@time_zone_id, 1352008800, 2)
,(@time_zone_id, 1362898800, 3)
,(@time_zone_id, 1383458400, 2)
,(@time_zone_id, 1394348400, 3)
,(@time_zone_id, 1414908000, 2)
,(@time_zone_id, 1425798000, 3)
,(@time_zone_id, 1446357600, 4)
,(@time_zone_id, 1520751600, 3)
,(@time_zone_id, 1541311200, 2)
,(@time_zone_id, 1552201200, 3)
,(@time_zone_id, 1572760800, 2)
,(@time_zone_id, 1583650800, 3)
,(@time_zone_id, 1604210400, 2)
,(@time_zone_id, 1615705200, 3)
,(@time_zone_id, 1636264800, 2)
,(@time_zone_id, 1647154800, 3)
,(@time_zone_id, 1667714400, 2)
,(@time_zone_id, 1678604400, 3)
,(@time_zone_id, 1699164000, 2)
,(@time_zone_id, 1710054000, 3)
,(@time_zone_id, 1730613600, 2)
,(@time_zone_id, 1741503600, 3)
,(@time_zone_id, 1762063200, 2)
,(@time_zone_id, 1772953200, 3)
,(@time_zone_id, 1793512800, 2)
,(@time_zone_id, 1805007600, 3)
,(@time_zone_id, 1825567200, 2)
,(@time_zone_id, 1836457200, 3)
,(@time_zone_id, 1857016800, 2)
,(@time_zone_id, 1867906800, 3)
,(@time_zone_id, 1888466400, 2)
,(@time_zone_id, 1899356400, 3)
,(@time_zone_id, 1919916000, 2)
,(@time_zone_id, 1930806000, 3)
,(@time_zone_id, 1951365600, 2)
,(@time_zone_id, 1962860400, 3)
,(@time_zone_id, 1983420000, 2)
,(@time_zone_id, 1994310000, 3)
,(@time_zone_id, 2014869600, 2)
,(@time_zone_id, 2025759600, 3)
,(@time_zone_id, 2046319200, 2)
,(@time_zone_id, 2057209200, 3)
,(@time_zone_id, 2077768800, 2)
,(@time_zone_id, 2088658800, 3)
,(@time_zone_id, 2109218400, 2)
,(@time_zone_id, 2120108400, 3)
,(@time_zone_id, 2140668000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -17072, 0, 'LMT')
,(@time_zone_id, 1, -18430, 0, 'KMT')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -14400, 1, 'EDT')
,(@time_zone_id, 4, -14400, 0, 'AST')
,(@time_zone_id, 5, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Grenada', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Guadeloupe', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Guatemala', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1617040676, 2)
,(@time_zone_id, 123055200, 1)
,(@time_zone_id, 130914000, 2)
,(@time_zone_id, 422344800, 1)
,(@time_zone_id, 433054800, 2)
,(@time_zone_id, 669708000, 1)
,(@time_zone_id, 684219600, 2)
,(@time_zone_id, 1146376800, 1)
,(@time_zone_id, 1159678800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21724, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Guayaquil', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1230749160, 3)
,(@time_zone_id, 722926800, 2)
,(@time_zone_id, 728884800, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -19160, 0, 'LMT')
,(@time_zone_id, 1, -18840, 0, 'QMT')
,(@time_zone_id, 2, -14400, 1, '-04')
,(@time_zone_id, 3, -18000, 0, '-05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Guyana', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1730578040, 1)
,(@time_zone_id, 176010300, 2)
,(@time_zone_id, 662698800, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -13960, 0, 'LMT')
,(@time_zone_id, 1, -13500, 0, '-0345')
,(@time_zone_id, 2, -10800, 0, '-03')
,(@time_zone_id, 3, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Halifax', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2131645536, 2)
,(@time_zone_id, -1696276800, 1)
,(@time_zone_id, -1680469200, 2)
,(@time_zone_id, -1632074400, 1)
,(@time_zone_id, -1615143600, 2)
,(@time_zone_id, -1566763200, 1)
,(@time_zone_id, -1557090000, 2)
,(@time_zone_id, -1535486400, 1)
,(@time_zone_id, -1524949200, 2)
,(@time_zone_id, -1504468800, 1)
,(@time_zone_id, -1493413200, 2)
,(@time_zone_id, -1472414400, 1)
,(@time_zone_id, -1461963600, 2)
,(@time_zone_id, -1440964800, 1)
,(@time_zone_id, -1429390800, 2)
,(@time_zone_id, -1409515200, 1)
,(@time_zone_id, -1396731600, 2)
,(@time_zone_id, -1376856000, 1)
,(@time_zone_id, -1366491600, 2)
,(@time_zone_id, -1346616000, 1)
,(@time_zone_id, -1333832400, 2)
,(@time_zone_id, -1313956800, 1)
,(@time_zone_id, -1303678800, 2)
,(@time_zone_id, -1282507200, 1)
,(@time_zone_id, -1272661200, 2)
,(@time_zone_id, -1251057600, 1)
,(@time_zone_id, -1240088400, 2)
,(@time_zone_id, -1219608000, 1)
,(@time_zone_id, -1207429200, 2)
,(@time_zone_id, -1188763200, 1)
,(@time_zone_id, -1175979600, 2)
,(@time_zone_id, -1157313600, 1)
,(@time_zone_id, -1143925200, 2)
,(@time_zone_id, -1124049600, 1)
,(@time_zone_id, -1113771600, 2)
,(@time_zone_id, -1091390400, 1)
,(@time_zone_id, -1081026000, 2)
,(@time_zone_id, -1059854400, 1)
,(@time_zone_id, -1050786000, 2)
,(@time_zone_id, -1030910400, 1)
,(@time_zone_id, -1018126800, 2)
,(@time_zone_id, -999460800, 1)
,(@time_zone_id, -986677200, 2)
,(@time_zone_id, -965592000, 1)
,(@time_zone_id, -955227600, 2)
,(@time_zone_id, -935956800, 1)
,(@time_zone_id, -923173200, 2)
,(@time_zone_id, -904507200, 1)
,(@time_zone_id, -891723600, 2)
,(@time_zone_id, -880221600, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765399600, 2)
,(@time_zone_id, -747252000, 1)
,(@time_zone_id, -733950000, 2)
,(@time_zone_id, -715802400, 1)
,(@time_zone_id, -702500400, 2)
,(@time_zone_id, -684352800, 1)
,(@time_zone_id, -671050800, 2)
,(@time_zone_id, -652903200, 1)
,(@time_zone_id, -639601200, 2)
,(@time_zone_id, -589399200, 1)
,(@time_zone_id, -576097200, 2)
,(@time_zone_id, -557949600, 1)
,(@time_zone_id, -544647600, 2)
,(@time_zone_id, -526500000, 1)
,(@time_zone_id, -513198000, 2)
,(@time_zone_id, -495050400, 1)
,(@time_zone_id, -481748400, 2)
,(@time_zone_id, -431546400, 1)
,(@time_zone_id, -418244400, 2)
,(@time_zone_id, -400096800, 1)
,(@time_zone_id, -386794800, 2)
,(@time_zone_id, -368647200, 1)
,(@time_zone_id, -355345200, 2)
,(@time_zone_id, -337197600, 1)
,(@time_zone_id, -323895600, 2)
,(@time_zone_id, -242244000, 1)
,(@time_zone_id, -226522800, 2)
,(@time_zone_id, -210794400, 1)
,(@time_zone_id, -195073200, 2)
,(@time_zone_id, -179344800, 1)
,(@time_zone_id, -163623600, 2)
,(@time_zone_id, -147895200, 1)
,(@time_zone_id, -131569200, 2)
,(@time_zone_id, -116445600, 1)
,(@time_zone_id, -100119600, 2)
,(@time_zone_id, -84391200, 1)
,(@time_zone_id, -68670000, 2)
,(@time_zone_id, -52941600, 1)
,(@time_zone_id, -37220400, 2)
,(@time_zone_id, -21492000, 1)
,(@time_zone_id, -5770800, 2)
,(@time_zone_id, 9957600, 1)
,(@time_zone_id, 25678800, 2)
,(@time_zone_id, 41407200, 1)
,(@time_zone_id, 57733200, 2)
,(@time_zone_id, 73461600, 1)
,(@time_zone_id, 89182800, 2)
,(@time_zone_id, 104911200, 1)
,(@time_zone_id, 120632400, 2)
,(@time_zone_id, 136360800, 1)
,(@time_zone_id, 152082000, 2)
,(@time_zone_id, 167810400, 1)
,(@time_zone_id, 183531600, 2)
,(@time_zone_id, 199260000, 1)
,(@time_zone_id, 215586000, 2)
,(@time_zone_id, 230709600, 1)
,(@time_zone_id, 247035600, 2)
,(@time_zone_id, 262764000, 1)
,(@time_zone_id, 278485200, 2)
,(@time_zone_id, 294213600, 1)
,(@time_zone_id, 309934800, 2)
,(@time_zone_id, 325663200, 1)
,(@time_zone_id, 341384400, 2)
,(@time_zone_id, 357112800, 1)
,(@time_zone_id, 372834000, 2)
,(@time_zone_id, 388562400, 1)
,(@time_zone_id, 404888400, 2)
,(@time_zone_id, 420012000, 1)
,(@time_zone_id, 436338000, 2)
,(@time_zone_id, 452066400, 1)
,(@time_zone_id, 467787600, 2)
,(@time_zone_id, 483516000, 1)
,(@time_zone_id, 499237200, 2)
,(@time_zone_id, 514965600, 1)
,(@time_zone_id, 530686800, 2)
,(@time_zone_id, 544600800, 1)
,(@time_zone_id, 562136400, 2)
,(@time_zone_id, 576050400, 1)
,(@time_zone_id, 594190800, 2)
,(@time_zone_id, 607500000, 1)
,(@time_zone_id, 625640400, 2)
,(@time_zone_id, 638949600, 1)
,(@time_zone_id, 657090000, 2)
,(@time_zone_id, 671004000, 1)
,(@time_zone_id, 688539600, 2)
,(@time_zone_id, 702453600, 1)
,(@time_zone_id, 719989200, 2)
,(@time_zone_id, 733903200, 1)
,(@time_zone_id, 752043600, 2)
,(@time_zone_id, 765352800, 1)
,(@time_zone_id, 783493200, 2)
,(@time_zone_id, 796802400, 1)
,(@time_zone_id, 814942800, 2)
,(@time_zone_id, 828856800, 1)
,(@time_zone_id, 846392400, 2)
,(@time_zone_id, 860306400, 1)
,(@time_zone_id, 877842000, 2)
,(@time_zone_id, 891756000, 1)
,(@time_zone_id, 909291600, 2)
,(@time_zone_id, 923205600, 1)
,(@time_zone_id, 941346000, 2)
,(@time_zone_id, 954655200, 1)
,(@time_zone_id, 972795600, 2)
,(@time_zone_id, 986104800, 1)
,(@time_zone_id, 1004245200, 2)
,(@time_zone_id, 1018159200, 1)
,(@time_zone_id, 1035694800, 2)
,(@time_zone_id, 1049608800, 1)
,(@time_zone_id, 1067144400, 2)
,(@time_zone_id, 1081058400, 1)
,(@time_zone_id, 1099198800, 2)
,(@time_zone_id, 1112508000, 1)
,(@time_zone_id, 1130648400, 2)
,(@time_zone_id, 1143957600, 1)
,(@time_zone_id, 1162098000, 2)
,(@time_zone_id, 1173592800, 1)
,(@time_zone_id, 1194152400, 2)
,(@time_zone_id, 1205042400, 1)
,(@time_zone_id, 1225602000, 2)
,(@time_zone_id, 1236492000, 1)
,(@time_zone_id, 1257051600, 2)
,(@time_zone_id, 1268546400, 1)
,(@time_zone_id, 1289106000, 2)
,(@time_zone_id, 1299996000, 1)
,(@time_zone_id, 1320555600, 2)
,(@time_zone_id, 1331445600, 1)
,(@time_zone_id, 1352005200, 2)
,(@time_zone_id, 1362895200, 1)
,(@time_zone_id, 1383454800, 2)
,(@time_zone_id, 1394344800, 1)
,(@time_zone_id, 1414904400, 2)
,(@time_zone_id, 1425794400, 1)
,(@time_zone_id, 1446354000, 2)
,(@time_zone_id, 1457848800, 1)
,(@time_zone_id, 1478408400, 2)
,(@time_zone_id, 1489298400, 1)
,(@time_zone_id, 1509858000, 2)
,(@time_zone_id, 1520748000, 1)
,(@time_zone_id, 1541307600, 2)
,(@time_zone_id, 1552197600, 1)
,(@time_zone_id, 1572757200, 2)
,(@time_zone_id, 1583647200, 1)
,(@time_zone_id, 1604206800, 2)
,(@time_zone_id, 1615701600, 1)
,(@time_zone_id, 1636261200, 2)
,(@time_zone_id, 1647151200, 1)
,(@time_zone_id, 1667710800, 2)
,(@time_zone_id, 1678600800, 1)
,(@time_zone_id, 1699160400, 2)
,(@time_zone_id, 1710050400, 1)
,(@time_zone_id, 1730610000, 2)
,(@time_zone_id, 1741500000, 1)
,(@time_zone_id, 1762059600, 2)
,(@time_zone_id, 1772949600, 1)
,(@time_zone_id, 1793509200, 2)
,(@time_zone_id, 1805004000, 1)
,(@time_zone_id, 1825563600, 2)
,(@time_zone_id, 1836453600, 1)
,(@time_zone_id, 1857013200, 2)
,(@time_zone_id, 1867903200, 1)
,(@time_zone_id, 1888462800, 2)
,(@time_zone_id, 1899352800, 1)
,(@time_zone_id, 1919912400, 2)
,(@time_zone_id, 1930802400, 1)
,(@time_zone_id, 1951362000, 2)
,(@time_zone_id, 1962856800, 1)
,(@time_zone_id, 1983416400, 2)
,(@time_zone_id, 1994306400, 1)
,(@time_zone_id, 2014866000, 2)
,(@time_zone_id, 2025756000, 1)
,(@time_zone_id, 2046315600, 2)
,(@time_zone_id, 2057205600, 1)
,(@time_zone_id, 2077765200, 2)
,(@time_zone_id, 2088655200, 1)
,(@time_zone_id, 2109214800, 2)
,(@time_zone_id, 2120104800, 1)
,(@time_zone_id, 2140664400, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15264, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, 'ADT')
,(@time_zone_id, 2, -14400, 0, 'AST')
,(@time_zone_id, 3, -10800, 1, 'AWT')
,(@time_zone_id, 4, -10800, 1, 'APT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Havana', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1402813824, 3)
,(@time_zone_id, -1311534000, 2)
,(@time_zone_id, -1300996800, 3)
,(@time_zone_id, -933534000, 2)
,(@time_zone_id, -925675200, 3)
,(@time_zone_id, -902084400, 2)
,(@time_zone_id, -893620800, 3)
,(@time_zone_id, -870030000, 2)
,(@time_zone_id, -862171200, 3)
,(@time_zone_id, -775681200, 2)
,(@time_zone_id, -767822400, 3)
,(@time_zone_id, -744231600, 2)
,(@time_zone_id, -736372800, 3)
,(@time_zone_id, -144702000, 2)
,(@time_zone_id, -134251200, 3)
,(@time_zone_id, -113425200, 2)
,(@time_zone_id, -102542400, 3)
,(@time_zone_id, -86295600, 2)
,(@time_zone_id, -72907200, 3)
,(@time_zone_id, -54154800, 2)
,(@time_zone_id, -41457600, 3)
,(@time_zone_id, -21495600, 2)
,(@time_zone_id, -5774400, 3)
,(@time_zone_id, 9954000, 2)
,(@time_zone_id, 25675200, 3)
,(@time_zone_id, 41403600, 2)
,(@time_zone_id, 57729600, 3)
,(@time_zone_id, 73458000, 2)
,(@time_zone_id, 87364800, 3)
,(@time_zone_id, 104907600, 2)
,(@time_zone_id, 118900800, 3)
,(@time_zone_id, 136357200, 2)
,(@time_zone_id, 150436800, 3)
,(@time_zone_id, 167806800, 2)
,(@time_zone_id, 183528000, 3)
,(@time_zone_id, 199256400, 2)
,(@time_zone_id, 215582400, 3)
,(@time_zone_id, 230706000, 2)
,(@time_zone_id, 247032000, 3)
,(@time_zone_id, 263365200, 2)
,(@time_zone_id, 276667200, 3)
,(@time_zone_id, 290581200, 2)
,(@time_zone_id, 308721600, 3)
,(@time_zone_id, 322030800, 2)
,(@time_zone_id, 340171200, 3)
,(@time_zone_id, 358318800, 2)
,(@time_zone_id, 371620800, 3)
,(@time_zone_id, 389768400, 2)
,(@time_zone_id, 403070400, 3)
,(@time_zone_id, 421218000, 2)
,(@time_zone_id, 434520000, 3)
,(@time_zone_id, 452667600, 2)
,(@time_zone_id, 466574400, 3)
,(@time_zone_id, 484117200, 2)
,(@time_zone_id, 498024000, 3)
,(@time_zone_id, 511333200, 2)
,(@time_zone_id, 529473600, 3)
,(@time_zone_id, 542782800, 2)
,(@time_zone_id, 560923200, 3)
,(@time_zone_id, 574837200, 2)
,(@time_zone_id, 592372800, 3)
,(@time_zone_id, 606286800, 2)
,(@time_zone_id, 623822400, 3)
,(@time_zone_id, 638946000, 2)
,(@time_zone_id, 655876800, 3)
,(@time_zone_id, 671000400, 2)
,(@time_zone_id, 687330000, 4)
,(@time_zone_id, 702450000, 2)
,(@time_zone_id, 718779600, 4)
,(@time_zone_id, 733899600, 2)
,(@time_zone_id, 750229200, 4)
,(@time_zone_id, 765349200, 2)
,(@time_zone_id, 781678800, 4)
,(@time_zone_id, 796798800, 2)
,(@time_zone_id, 813128400, 4)
,(@time_zone_id, 828853200, 2)
,(@time_zone_id, 844578000, 4)
,(@time_zone_id, 860302800, 2)
,(@time_zone_id, 876632400, 4)
,(@time_zone_id, 891147600, 5)
,(@time_zone_id, 909291600, 4)
,(@time_zone_id, 922597200, 5)
,(@time_zone_id, 941346000, 4)
,(@time_zone_id, 954651600, 5)
,(@time_zone_id, 972795600, 4)
,(@time_zone_id, 986101200, 5)
,(@time_zone_id, 1004245200, 4)
,(@time_zone_id, 1018155600, 5)
,(@time_zone_id, 1035694800, 4)
,(@time_zone_id, 1049605200, 5)
,(@time_zone_id, 1067144400, 4)
,(@time_zone_id, 1080450000, 5)
,(@time_zone_id, 1162098000, 4)
,(@time_zone_id, 1173589200, 5)
,(@time_zone_id, 1193547600, 4)
,(@time_zone_id, 1205643600, 5)
,(@time_zone_id, 1224997200, 4)
,(@time_zone_id, 1236488400, 5)
,(@time_zone_id, 1256446800, 4)
,(@time_zone_id, 1268542800, 5)
,(@time_zone_id, 1288501200, 4)
,(@time_zone_id, 1300597200, 5)
,(@time_zone_id, 1321160400, 4)
,(@time_zone_id, 1333256400, 5)
,(@time_zone_id, 1352005200, 4)
,(@time_zone_id, 1362891600, 5)
,(@time_zone_id, 1383454800, 4)
,(@time_zone_id, 1394341200, 5)
,(@time_zone_id, 1414904400, 4)
,(@time_zone_id, 1425790800, 5)
,(@time_zone_id, 1446354000, 4)
,(@time_zone_id, 1457845200, 5)
,(@time_zone_id, 1478408400, 4)
,(@time_zone_id, 1489294800, 5)
,(@time_zone_id, 1509858000, 4)
,(@time_zone_id, 1520744400, 5)
,(@time_zone_id, 1541307600, 4)
,(@time_zone_id, 1552194000, 5)
,(@time_zone_id, 1572757200, 4)
,(@time_zone_id, 1583643600, 5)
,(@time_zone_id, 1604206800, 4)
,(@time_zone_id, 1615698000, 5)
,(@time_zone_id, 1636261200, 4)
,(@time_zone_id, 1647147600, 5)
,(@time_zone_id, 1667710800, 4)
,(@time_zone_id, 1678597200, 5)
,(@time_zone_id, 1699160400, 4)
,(@time_zone_id, 1710046800, 5)
,(@time_zone_id, 1730610000, 4)
,(@time_zone_id, 1741496400, 5)
,(@time_zone_id, 1762059600, 4)
,(@time_zone_id, 1772946000, 5)
,(@time_zone_id, 1793509200, 4)
,(@time_zone_id, 1805000400, 5)
,(@time_zone_id, 1825563600, 4)
,(@time_zone_id, 1836450000, 5)
,(@time_zone_id, 1857013200, 4)
,(@time_zone_id, 1867899600, 5)
,(@time_zone_id, 1888462800, 4)
,(@time_zone_id, 1899349200, 5)
,(@time_zone_id, 1919912400, 4)
,(@time_zone_id, 1930798800, 5)
,(@time_zone_id, 1951362000, 4)
,(@time_zone_id, 1962853200, 5)
,(@time_zone_id, 1983416400, 4)
,(@time_zone_id, 1994302800, 5)
,(@time_zone_id, 2014866000, 4)
,(@time_zone_id, 2025752400, 5)
,(@time_zone_id, 2046315600, 4)
,(@time_zone_id, 2057202000, 5)
,(@time_zone_id, 2077765200, 4)
,(@time_zone_id, 2088651600, 5)
,(@time_zone_id, 2109214800, 4)
,(@time_zone_id, 2120101200, 5)
,(@time_zone_id, 2140664400, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -19768, 0, 'LMT')
,(@time_zone_id, 1, -19776, 0, 'HMT')
,(@time_zone_id, 2, -14400, 1, 'CDT')
,(@time_zone_id, 3, -18000, 0, 'CST')
,(@time_zone_id, 4, -18000, 0, 'CST')
,(@time_zone_id, 5, -14400, 1, 'CDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Hermosillo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514739600, 1)
,(@time_zone_id, -1343066400, 2)
,(@time_zone_id, -1234807200, 1)
,(@time_zone_id, -1220292000, 2)
,(@time_zone_id, -1207159200, 1)
,(@time_zone_id, -1191344400, 2)
,(@time_zone_id, -873828000, 1)
,(@time_zone_id, -661539600, 3)
,(@time_zone_id, 28800, 1)
,(@time_zone_id, 828867600, 4)
,(@time_zone_id, 846403200, 1)
,(@time_zone_id, 860317200, 4)
,(@time_zone_id, 877852800, 1)
,(@time_zone_id, 891766800, 4)
,(@time_zone_id, 909302400, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -26632, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -28800, 0, 'PST')
,(@time_zone_id, 4, -21600, 1, 'MDT')
,(@time_zone_id, 5, -25200, 0, 'MST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Indiana/Indianapolis', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -900259200, 1)
,(@time_zone_id, -891795600, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -747244800, 1)
,(@time_zone_id, -733942800, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -702493200, 2)
,(@time_zone_id, -684345600, 1)
,(@time_zone_id, -671043600, 2)
,(@time_zone_id, -652896000, 1)
,(@time_zone_id, -639594000, 2)
,(@time_zone_id, -620841600, 1)
,(@time_zone_id, -608144400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 5)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 1143961200, 6)
,(@time_zone_id, 1162101600, 5)
,(@time_zone_id, 1173596400, 6)
,(@time_zone_id, 1194156000, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20678, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Indiana/Knox', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -702493200, 2)
,(@time_zone_id, -684345600, 1)
,(@time_zone_id, -671043600, 2)
,(@time_zone_id, -652896000, 1)
,(@time_zone_id, -639594000, 2)
,(@time_zone_id, -620841600, 1)
,(@time_zone_id, -608144400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 1)
,(@time_zone_id, -447267600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -415818000, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -355338000, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -321469200, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -289414800, 2)
,(@time_zone_id, -273686400, 1)
,(@time_zone_id, -257965200, 2)
,(@time_zone_id, -242236800, 5)
,(@time_zone_id, -195066000, 2)
,(@time_zone_id, -84384000, 1)
,(@time_zone_id, -68662800, 2)
,(@time_zone_id, -52934400, 1)
,(@time_zone_id, -37213200, 2)
,(@time_zone_id, -21484800, 1)
,(@time_zone_id, -5763600, 2)
,(@time_zone_id, 9964800, 1)
,(@time_zone_id, 25686000, 2)
,(@time_zone_id, 41414400, 1)
,(@time_zone_id, 57740400, 2)
,(@time_zone_id, 73468800, 1)
,(@time_zone_id, 89190000, 2)
,(@time_zone_id, 104918400, 1)
,(@time_zone_id, 120639600, 2)
,(@time_zone_id, 126691200, 1)
,(@time_zone_id, 152089200, 2)
,(@time_zone_id, 162374400, 1)
,(@time_zone_id, 183538800, 2)
,(@time_zone_id, 199267200, 1)
,(@time_zone_id, 215593200, 2)
,(@time_zone_id, 230716800, 1)
,(@time_zone_id, 247042800, 2)
,(@time_zone_id, 262771200, 1)
,(@time_zone_id, 278492400, 2)
,(@time_zone_id, 294220800, 1)
,(@time_zone_id, 309942000, 2)
,(@time_zone_id, 325670400, 1)
,(@time_zone_id, 341391600, 2)
,(@time_zone_id, 357120000, 1)
,(@time_zone_id, 372841200, 2)
,(@time_zone_id, 388569600, 1)
,(@time_zone_id, 404895600, 2)
,(@time_zone_id, 420019200, 1)
,(@time_zone_id, 436345200, 2)
,(@time_zone_id, 452073600, 1)
,(@time_zone_id, 467794800, 2)
,(@time_zone_id, 483523200, 1)
,(@time_zone_id, 499244400, 2)
,(@time_zone_id, 514972800, 1)
,(@time_zone_id, 530694000, 2)
,(@time_zone_id, 544608000, 1)
,(@time_zone_id, 562143600, 2)
,(@time_zone_id, 576057600, 1)
,(@time_zone_id, 594198000, 2)
,(@time_zone_id, 607507200, 1)
,(@time_zone_id, 625647600, 2)
,(@time_zone_id, 638956800, 1)
,(@time_zone_id, 657097200, 2)
,(@time_zone_id, 671011200, 1)
,(@time_zone_id, 688546800, 5)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 1)
,(@time_zone_id, 1194159600, 2)
,(@time_zone_id, 1205049600, 1)
,(@time_zone_id, 1225609200, 2)
,(@time_zone_id, 1236499200, 1)
,(@time_zone_id, 1257058800, 2)
,(@time_zone_id, 1268553600, 1)
,(@time_zone_id, 1289113200, 2)
,(@time_zone_id, 1300003200, 1)
,(@time_zone_id, 1320562800, 2)
,(@time_zone_id, 1331452800, 1)
,(@time_zone_id, 1352012400, 2)
,(@time_zone_id, 1362902400, 1)
,(@time_zone_id, 1383462000, 2)
,(@time_zone_id, 1394352000, 1)
,(@time_zone_id, 1414911600, 2)
,(@time_zone_id, 1425801600, 1)
,(@time_zone_id, 1446361200, 2)
,(@time_zone_id, 1457856000, 1)
,(@time_zone_id, 1478415600, 2)
,(@time_zone_id, 1489305600, 1)
,(@time_zone_id, 1509865200, 2)
,(@time_zone_id, 1520755200, 1)
,(@time_zone_id, 1541314800, 2)
,(@time_zone_id, 1552204800, 1)
,(@time_zone_id, 1572764400, 2)
,(@time_zone_id, 1583654400, 1)
,(@time_zone_id, 1604214000, 2)
,(@time_zone_id, 1615708800, 1)
,(@time_zone_id, 1636268400, 2)
,(@time_zone_id, 1647158400, 1)
,(@time_zone_id, 1667718000, 2)
,(@time_zone_id, 1678608000, 1)
,(@time_zone_id, 1699167600, 2)
,(@time_zone_id, 1710057600, 1)
,(@time_zone_id, 1730617200, 2)
,(@time_zone_id, 1741507200, 1)
,(@time_zone_id, 1762066800, 2)
,(@time_zone_id, 1772956800, 1)
,(@time_zone_id, 1793516400, 2)
,(@time_zone_id, 1805011200, 1)
,(@time_zone_id, 1825570800, 2)
,(@time_zone_id, 1836460800, 1)
,(@time_zone_id, 1857020400, 2)
,(@time_zone_id, 1867910400, 1)
,(@time_zone_id, 1888470000, 2)
,(@time_zone_id, 1899360000, 1)
,(@time_zone_id, 1919919600, 2)
,(@time_zone_id, 1930809600, 1)
,(@time_zone_id, 1951369200, 2)
,(@time_zone_id, 1962864000, 1)
,(@time_zone_id, 1983423600, 2)
,(@time_zone_id, 1994313600, 1)
,(@time_zone_id, 2014873200, 2)
,(@time_zone_id, 2025763200, 1)
,(@time_zone_id, 2046322800, 2)
,(@time_zone_id, 2057212800, 1)
,(@time_zone_id, 2077772400, 2)
,(@time_zone_id, 2088662400, 1)
,(@time_zone_id, 2109222000, 2)
,(@time_zone_id, 2120112000, 1)
,(@time_zone_id, 2140671600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20790, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Indiana/Marengo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 1)
,(@time_zone_id, -450291600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -418237200, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -355338000, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -323888400, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -292438800, 2)
,(@time_zone_id, -273686400, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 41410800, 6)
,(@time_zone_id, 57736800, 5)
,(@time_zone_id, 73465200, 6)
,(@time_zone_id, 89186400, 5)
,(@time_zone_id, 104914800, 6)
,(@time_zone_id, 120636000, 5)
,(@time_zone_id, 126687600, 1)
,(@time_zone_id, 152089200, 5)
,(@time_zone_id, 162370800, 6)
,(@time_zone_id, 183535200, 5)
,(@time_zone_id, 1143961200, 6)
,(@time_zone_id, 1162101600, 5)
,(@time_zone_id, 1173596400, 6)
,(@time_zone_id, 1194156000, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20723, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Indiana/Petersburg', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -462996000, 1)
,(@time_zone_id, -450291600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -418237200, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -355338000, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -323888400, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -292438800, 2)
,(@time_zone_id, -273686400, 1)
,(@time_zone_id, -257965200, 2)
,(@time_zone_id, -242236800, 1)
,(@time_zone_id, -226515600, 2)
,(@time_zone_id, -210787200, 1)
,(@time_zone_id, -195066000, 2)
,(@time_zone_id, -179337600, 1)
,(@time_zone_id, -163616400, 2)
,(@time_zone_id, -147888000, 5)
,(@time_zone_id, -100112400, 2)
,(@time_zone_id, -84384000, 1)
,(@time_zone_id, -68662800, 2)
,(@time_zone_id, -52934400, 1)
,(@time_zone_id, -37213200, 2)
,(@time_zone_id, -21484800, 1)
,(@time_zone_id, -5763600, 2)
,(@time_zone_id, 9964800, 1)
,(@time_zone_id, 25686000, 2)
,(@time_zone_id, 41414400, 1)
,(@time_zone_id, 57740400, 2)
,(@time_zone_id, 73468800, 1)
,(@time_zone_id, 89190000, 2)
,(@time_zone_id, 104918400, 1)
,(@time_zone_id, 120639600, 2)
,(@time_zone_id, 126691200, 1)
,(@time_zone_id, 152089200, 2)
,(@time_zone_id, 162374400, 1)
,(@time_zone_id, 183538800, 2)
,(@time_zone_id, 199267200, 1)
,(@time_zone_id, 215593200, 2)
,(@time_zone_id, 230716800, 1)
,(@time_zone_id, 247042800, 5)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 1)
,(@time_zone_id, 1194159600, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20947, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Indiana/Tell_City', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -747244800, 1)
,(@time_zone_id, -733942800, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -462996000, 1)
,(@time_zone_id, -450291600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -418237200, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -355338000, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -323888400, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -289414800, 2)
,(@time_zone_id, -273686400, 1)
,(@time_zone_id, -260989200, 2)
,(@time_zone_id, -242236800, 1)
,(@time_zone_id, -226515600, 2)
,(@time_zone_id, -210787200, 1)
,(@time_zone_id, -195066000, 2)
,(@time_zone_id, -179337600, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 1)
,(@time_zone_id, 1194159600, 2)
,(@time_zone_id, 1205049600, 1)
,(@time_zone_id, 1225609200, 2)
,(@time_zone_id, 1236499200, 1)
,(@time_zone_id, 1257058800, 2)
,(@time_zone_id, 1268553600, 1)
,(@time_zone_id, 1289113200, 2)
,(@time_zone_id, 1300003200, 1)
,(@time_zone_id, 1320562800, 2)
,(@time_zone_id, 1331452800, 1)
,(@time_zone_id, 1352012400, 2)
,(@time_zone_id, 1362902400, 1)
,(@time_zone_id, 1383462000, 2)
,(@time_zone_id, 1394352000, 1)
,(@time_zone_id, 1414911600, 2)
,(@time_zone_id, 1425801600, 1)
,(@time_zone_id, 1446361200, 2)
,(@time_zone_id, 1457856000, 1)
,(@time_zone_id, 1478415600, 2)
,(@time_zone_id, 1489305600, 1)
,(@time_zone_id, 1509865200, 2)
,(@time_zone_id, 1520755200, 1)
,(@time_zone_id, 1541314800, 2)
,(@time_zone_id, 1552204800, 1)
,(@time_zone_id, 1572764400, 2)
,(@time_zone_id, 1583654400, 1)
,(@time_zone_id, 1604214000, 2)
,(@time_zone_id, 1615708800, 1)
,(@time_zone_id, 1636268400, 2)
,(@time_zone_id, 1647158400, 1)
,(@time_zone_id, 1667718000, 2)
,(@time_zone_id, 1678608000, 1)
,(@time_zone_id, 1699167600, 2)
,(@time_zone_id, 1710057600, 1)
,(@time_zone_id, 1730617200, 2)
,(@time_zone_id, 1741507200, 1)
,(@time_zone_id, 1762066800, 2)
,(@time_zone_id, 1772956800, 1)
,(@time_zone_id, 1793516400, 2)
,(@time_zone_id, 1805011200, 1)
,(@time_zone_id, 1825570800, 2)
,(@time_zone_id, 1836460800, 1)
,(@time_zone_id, 1857020400, 2)
,(@time_zone_id, 1867910400, 1)
,(@time_zone_id, 1888470000, 2)
,(@time_zone_id, 1899360000, 1)
,(@time_zone_id, 1919919600, 2)
,(@time_zone_id, 1930809600, 1)
,(@time_zone_id, 1951369200, 2)
,(@time_zone_id, 1962864000, 1)
,(@time_zone_id, 1983423600, 2)
,(@time_zone_id, 1994313600, 1)
,(@time_zone_id, 2014873200, 2)
,(@time_zone_id, 2025763200, 1)
,(@time_zone_id, 2046322800, 2)
,(@time_zone_id, 2057212800, 1)
,(@time_zone_id, 2077772400, 2)
,(@time_zone_id, 2088662400, 1)
,(@time_zone_id, 2109222000, 2)
,(@time_zone_id, 2120112000, 1)
,(@time_zone_id, 2140671600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20823, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
,(@time_zone_id, 7, -18000, 1, 'CDT')
,(@time_zone_id, 8, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Indiana/Vevay', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -495043200, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 41410800, 6)
,(@time_zone_id, 57736800, 5)
,(@time_zone_id, 73465200, 6)
,(@time_zone_id, 89186400, 5)
,(@time_zone_id, 1143961200, 6)
,(@time_zone_id, 1162101600, 5)
,(@time_zone_id, 1173596400, 6)
,(@time_zone_id, 1194156000, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20416, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Indiana/Vincennes', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -747244800, 1)
,(@time_zone_id, -733942800, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -462996000, 1)
,(@time_zone_id, -450291600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -418237200, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -355338000, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -323888400, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -289414800, 2)
,(@time_zone_id, -273686400, 1)
,(@time_zone_id, -260989200, 2)
,(@time_zone_id, -242236800, 1)
,(@time_zone_id, -226515600, 2)
,(@time_zone_id, -210787200, 1)
,(@time_zone_id, -195066000, 2)
,(@time_zone_id, -179337600, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 1)
,(@time_zone_id, 1194159600, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21007, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Indiana/Winamac', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -747244800, 1)
,(@time_zone_id, -733942800, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -702493200, 2)
,(@time_zone_id, -684345600, 1)
,(@time_zone_id, -671043600, 2)
,(@time_zone_id, -652896000, 1)
,(@time_zone_id, -639594000, 2)
,(@time_zone_id, -620841600, 1)
,(@time_zone_id, -608144400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 1)
,(@time_zone_id, -447267600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -415818000, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -355338000, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -323888400, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -292438800, 2)
,(@time_zone_id, -273686400, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 6)
,(@time_zone_id, 1194156000, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20785, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Indianapolis', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -900259200, 1)
,(@time_zone_id, -891795600, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -747244800, 1)
,(@time_zone_id, -733942800, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -702493200, 2)
,(@time_zone_id, -684345600, 1)
,(@time_zone_id, -671043600, 2)
,(@time_zone_id, -652896000, 1)
,(@time_zone_id, -639594000, 2)
,(@time_zone_id, -620841600, 1)
,(@time_zone_id, -608144400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 5)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 1143961200, 6)
,(@time_zone_id, 1162101600, 5)
,(@time_zone_id, 1173596400, 6)
,(@time_zone_id, 1194156000, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20678, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Inuvik', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -536457600, 2)
,(@time_zone_id, -147888000, 1)
,(@time_zone_id, -131558400, 2)
,(@time_zone_id, 294228000, 3)
,(@time_zone_id, 325674000, 4)
,(@time_zone_id, 341395200, 3)
,(@time_zone_id, 357123600, 4)
,(@time_zone_id, 372844800, 3)
,(@time_zone_id, 388573200, 4)
,(@time_zone_id, 404899200, 3)
,(@time_zone_id, 420022800, 4)
,(@time_zone_id, 436348800, 3)
,(@time_zone_id, 452077200, 4)
,(@time_zone_id, 467798400, 3)
,(@time_zone_id, 483526800, 4)
,(@time_zone_id, 499248000, 3)
,(@time_zone_id, 514976400, 4)
,(@time_zone_id, 530697600, 3)
,(@time_zone_id, 544611600, 4)
,(@time_zone_id, 562147200, 3)
,(@time_zone_id, 576061200, 4)
,(@time_zone_id, 594201600, 3)
,(@time_zone_id, 607510800, 4)
,(@time_zone_id, 625651200, 3)
,(@time_zone_id, 638960400, 4)
,(@time_zone_id, 657100800, 3)
,(@time_zone_id, 671014800, 4)
,(@time_zone_id, 688550400, 3)
,(@time_zone_id, 702464400, 4)
,(@time_zone_id, 720000000, 3)
,(@time_zone_id, 733914000, 4)
,(@time_zone_id, 752054400, 3)
,(@time_zone_id, 765363600, 4)
,(@time_zone_id, 783504000, 3)
,(@time_zone_id, 796813200, 4)
,(@time_zone_id, 814953600, 3)
,(@time_zone_id, 828867600, 4)
,(@time_zone_id, 846403200, 3)
,(@time_zone_id, 860317200, 4)
,(@time_zone_id, 877852800, 3)
,(@time_zone_id, 891766800, 4)
,(@time_zone_id, 909302400, 3)
,(@time_zone_id, 923216400, 4)
,(@time_zone_id, 941356800, 3)
,(@time_zone_id, 954666000, 4)
,(@time_zone_id, 972806400, 3)
,(@time_zone_id, 986115600, 4)
,(@time_zone_id, 1004256000, 3)
,(@time_zone_id, 1018170000, 4)
,(@time_zone_id, 1035705600, 3)
,(@time_zone_id, 1049619600, 4)
,(@time_zone_id, 1067155200, 3)
,(@time_zone_id, 1081069200, 4)
,(@time_zone_id, 1099209600, 3)
,(@time_zone_id, 1112518800, 4)
,(@time_zone_id, 1130659200, 3)
,(@time_zone_id, 1143968400, 4)
,(@time_zone_id, 1162108800, 3)
,(@time_zone_id, 1173603600, 4)
,(@time_zone_id, 1194163200, 3)
,(@time_zone_id, 1205053200, 4)
,(@time_zone_id, 1225612800, 3)
,(@time_zone_id, 1236502800, 4)
,(@time_zone_id, 1257062400, 3)
,(@time_zone_id, 1268557200, 4)
,(@time_zone_id, 1289116800, 3)
,(@time_zone_id, 1300006800, 4)
,(@time_zone_id, 1320566400, 3)
,(@time_zone_id, 1331456400, 4)
,(@time_zone_id, 1352016000, 3)
,(@time_zone_id, 1362906000, 4)
,(@time_zone_id, 1383465600, 3)
,(@time_zone_id, 1394355600, 4)
,(@time_zone_id, 1414915200, 3)
,(@time_zone_id, 1425805200, 4)
,(@time_zone_id, 1446364800, 3)
,(@time_zone_id, 1457859600, 4)
,(@time_zone_id, 1478419200, 3)
,(@time_zone_id, 1489309200, 4)
,(@time_zone_id, 1509868800, 3)
,(@time_zone_id, 1520758800, 4)
,(@time_zone_id, 1541318400, 3)
,(@time_zone_id, 1552208400, 4)
,(@time_zone_id, 1572768000, 3)
,(@time_zone_id, 1583658000, 4)
,(@time_zone_id, 1604217600, 3)
,(@time_zone_id, 1615712400, 4)
,(@time_zone_id, 1636272000, 3)
,(@time_zone_id, 1647162000, 4)
,(@time_zone_id, 1667721600, 3)
,(@time_zone_id, 1678611600, 4)
,(@time_zone_id, 1699171200, 3)
,(@time_zone_id, 1710061200, 4)
,(@time_zone_id, 1730620800, 3)
,(@time_zone_id, 1741510800, 4)
,(@time_zone_id, 1762070400, 3)
,(@time_zone_id, 1772960400, 4)
,(@time_zone_id, 1793520000, 3)
,(@time_zone_id, 1805014800, 4)
,(@time_zone_id, 1825574400, 3)
,(@time_zone_id, 1836464400, 4)
,(@time_zone_id, 1857024000, 3)
,(@time_zone_id, 1867914000, 4)
,(@time_zone_id, 1888473600, 3)
,(@time_zone_id, 1899363600, 4)
,(@time_zone_id, 1919923200, 3)
,(@time_zone_id, 1930813200, 4)
,(@time_zone_id, 1951372800, 3)
,(@time_zone_id, 1962867600, 4)
,(@time_zone_id, 1983427200, 3)
,(@time_zone_id, 1994317200, 4)
,(@time_zone_id, 2014876800, 3)
,(@time_zone_id, 2025766800, 4)
,(@time_zone_id, 2046326400, 3)
,(@time_zone_id, 2057216400, 4)
,(@time_zone_id, 2077776000, 3)
,(@time_zone_id, 2088666000, 4)
,(@time_zone_id, 2109225600, 3)
,(@time_zone_id, 2120115600, 4)
,(@time_zone_id, 2140675200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, -21600, 1, 'PDDT')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -25200, 0, 'MST')
,(@time_zone_id, 4, -21600, 1, 'MDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Iqaluit', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -865296000, 5)
,(@time_zone_id, -769395600, 1)
,(@time_zone_id, -765396000, 2)
,(@time_zone_id, -147898800, 3)
,(@time_zone_id, -131569200, 2)
,(@time_zone_id, 325666800, 4)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 4)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 4)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 4)
,(@time_zone_id, 436341600, 2)
,(@time_zone_id, 452070000, 4)
,(@time_zone_id, 467791200, 2)
,(@time_zone_id, 483519600, 4)
,(@time_zone_id, 499240800, 2)
,(@time_zone_id, 514969200, 4)
,(@time_zone_id, 530690400, 2)
,(@time_zone_id, 544604400, 4)
,(@time_zone_id, 562140000, 2)
,(@time_zone_id, 576054000, 4)
,(@time_zone_id, 594194400, 2)
,(@time_zone_id, 607503600, 4)
,(@time_zone_id, 625644000, 2)
,(@time_zone_id, 638953200, 4)
,(@time_zone_id, 657093600, 2)
,(@time_zone_id, 671007600, 4)
,(@time_zone_id, 688543200, 2)
,(@time_zone_id, 702457200, 4)
,(@time_zone_id, 719992800, 2)
,(@time_zone_id, 733906800, 4)
,(@time_zone_id, 752047200, 2)
,(@time_zone_id, 765356400, 4)
,(@time_zone_id, 783496800, 2)
,(@time_zone_id, 796806000, 4)
,(@time_zone_id, 814946400, 2)
,(@time_zone_id, 828860400, 4)
,(@time_zone_id, 846396000, 2)
,(@time_zone_id, 860310000, 4)
,(@time_zone_id, 877845600, 2)
,(@time_zone_id, 891759600, 4)
,(@time_zone_id, 909295200, 2)
,(@time_zone_id, 923209200, 4)
,(@time_zone_id, 941349600, 6)
,(@time_zone_id, 954662400, 7)
,(@time_zone_id, 972802800, 2)
,(@time_zone_id, 986108400, 4)
,(@time_zone_id, 1004248800, 2)
,(@time_zone_id, 1018162800, 4)
,(@time_zone_id, 1035698400, 2)
,(@time_zone_id, 1049612400, 4)
,(@time_zone_id, 1067148000, 2)
,(@time_zone_id, 1081062000, 4)
,(@time_zone_id, 1099202400, 2)
,(@time_zone_id, 1112511600, 4)
,(@time_zone_id, 1130652000, 2)
,(@time_zone_id, 1143961200, 4)
,(@time_zone_id, 1162101600, 2)
,(@time_zone_id, 1173596400, 4)
,(@time_zone_id, 1194156000, 2)
,(@time_zone_id, 1205046000, 4)
,(@time_zone_id, 1225605600, 2)
,(@time_zone_id, 1236495600, 4)
,(@time_zone_id, 1257055200, 2)
,(@time_zone_id, 1268550000, 4)
,(@time_zone_id, 1289109600, 2)
,(@time_zone_id, 1299999600, 4)
,(@time_zone_id, 1320559200, 2)
,(@time_zone_id, 1331449200, 4)
,(@time_zone_id, 1352008800, 2)
,(@time_zone_id, 1362898800, 4)
,(@time_zone_id, 1383458400, 2)
,(@time_zone_id, 1394348400, 4)
,(@time_zone_id, 1414908000, 2)
,(@time_zone_id, 1425798000, 4)
,(@time_zone_id, 1446357600, 2)
,(@time_zone_id, 1457852400, 4)
,(@time_zone_id, 1478412000, 2)
,(@time_zone_id, 1489302000, 4)
,(@time_zone_id, 1509861600, 2)
,(@time_zone_id, 1520751600, 4)
,(@time_zone_id, 1541311200, 2)
,(@time_zone_id, 1552201200, 4)
,(@time_zone_id, 1572760800, 2)
,(@time_zone_id, 1583650800, 4)
,(@time_zone_id, 1604210400, 2)
,(@time_zone_id, 1615705200, 4)
,(@time_zone_id, 1636264800, 2)
,(@time_zone_id, 1647154800, 4)
,(@time_zone_id, 1667714400, 2)
,(@time_zone_id, 1678604400, 4)
,(@time_zone_id, 1699164000, 2)
,(@time_zone_id, 1710054000, 4)
,(@time_zone_id, 1730613600, 2)
,(@time_zone_id, 1741503600, 4)
,(@time_zone_id, 1762063200, 2)
,(@time_zone_id, 1772953200, 4)
,(@time_zone_id, 1793512800, 2)
,(@time_zone_id, 1805007600, 4)
,(@time_zone_id, 1825567200, 2)
,(@time_zone_id, 1836457200, 4)
,(@time_zone_id, 1857016800, 2)
,(@time_zone_id, 1867906800, 4)
,(@time_zone_id, 1888466400, 2)
,(@time_zone_id, 1899356400, 4)
,(@time_zone_id, 1919916000, 2)
,(@time_zone_id, 1930806000, 4)
,(@time_zone_id, 1951365600, 2)
,(@time_zone_id, 1962860400, 4)
,(@time_zone_id, 1983420000, 2)
,(@time_zone_id, 1994310000, 4)
,(@time_zone_id, 2014869600, 2)
,(@time_zone_id, 2025759600, 4)
,(@time_zone_id, 2046319200, 2)
,(@time_zone_id, 2057209200, 4)
,(@time_zone_id, 2077768800, 2)
,(@time_zone_id, 2088658800, 4)
,(@time_zone_id, 2109218400, 2)
,(@time_zone_id, 2120108400, 4)
,(@time_zone_id, 2140668000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, -14400, 1, 'EPT')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -10800, 1, 'EDDT')
,(@time_zone_id, 4, -14400, 1, 'EDT')
,(@time_zone_id, 5, -14400, 1, 'EWT')
,(@time_zone_id, 6, -21600, 0, 'CST')
,(@time_zone_id, 7, -18000, 1, 'CDT')
,(@time_zone_id, 8, -14400, 1, 'EDT')
,(@time_zone_id, 9, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Jamaica', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1827687170, 2)
,(@time_zone_id, 126687600, 3)
,(@time_zone_id, 152085600, 2)
,(@time_zone_id, 162370800, 3)
,(@time_zone_id, 183535200, 2)
,(@time_zone_id, 199263600, 3)
,(@time_zone_id, 215589600, 2)
,(@time_zone_id, 230713200, 3)
,(@time_zone_id, 247039200, 2)
,(@time_zone_id, 262767600, 3)
,(@time_zone_id, 278488800, 2)
,(@time_zone_id, 294217200, 3)
,(@time_zone_id, 309938400, 2)
,(@time_zone_id, 325666800, 3)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 3)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 3)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 3)
,(@time_zone_id, 436341600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -18430, 0, 'LMT')
,(@time_zone_id, 1, -18430, 0, 'KMT')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Jujuy', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 2)
,(@time_zone_id, 657086400, 3)
,(@time_zone_id, 669178800, 2)
,(@time_zone_id, 686721600, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15672, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Juneau', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -880207200, 2)
,(@time_zone_id, -769395600, 3)
,(@time_zone_id, -765385200, 1)
,(@time_zone_id, -21477600, 4)
,(@time_zone_id, -5756400, 1)
,(@time_zone_id, 9972000, 4)
,(@time_zone_id, 25693200, 1)
,(@time_zone_id, 41421600, 4)
,(@time_zone_id, 57747600, 1)
,(@time_zone_id, 73476000, 4)
,(@time_zone_id, 89197200, 1)
,(@time_zone_id, 104925600, 4)
,(@time_zone_id, 120646800, 1)
,(@time_zone_id, 126698400, 4)
,(@time_zone_id, 152096400, 1)
,(@time_zone_id, 162381600, 4)
,(@time_zone_id, 183546000, 1)
,(@time_zone_id, 199274400, 4)
,(@time_zone_id, 215600400, 1)
,(@time_zone_id, 230724000, 4)
,(@time_zone_id, 247050000, 1)
,(@time_zone_id, 262778400, 4)
,(@time_zone_id, 278499600, 1)
,(@time_zone_id, 294228000, 4)
,(@time_zone_id, 309949200, 1)
,(@time_zone_id, 325677600, 5)
,(@time_zone_id, 341402400, 1)
,(@time_zone_id, 357127200, 4)
,(@time_zone_id, 372848400, 1)
,(@time_zone_id, 388576800, 4)
,(@time_zone_id, 404902800, 1)
,(@time_zone_id, 420026400, 4)
,(@time_zone_id, 436352400, 6)
,(@time_zone_id, 439030800, 8)
,(@time_zone_id, 452084400, 7)
,(@time_zone_id, 467805600, 8)
,(@time_zone_id, 483534000, 7)
,(@time_zone_id, 499255200, 8)
,(@time_zone_id, 514983600, 7)
,(@time_zone_id, 530704800, 8)
,(@time_zone_id, 544618800, 7)
,(@time_zone_id, 562154400, 8)
,(@time_zone_id, 576068400, 7)
,(@time_zone_id, 594208800, 8)
,(@time_zone_id, 607518000, 7)
,(@time_zone_id, 625658400, 8)
,(@time_zone_id, 638967600, 7)
,(@time_zone_id, 657108000, 8)
,(@time_zone_id, 671022000, 7)
,(@time_zone_id, 688557600, 8)
,(@time_zone_id, 702471600, 7)
,(@time_zone_id, 720007200, 8)
,(@time_zone_id, 733921200, 7)
,(@time_zone_id, 752061600, 8)
,(@time_zone_id, 765370800, 7)
,(@time_zone_id, 783511200, 8)
,(@time_zone_id, 796820400, 7)
,(@time_zone_id, 814960800, 8)
,(@time_zone_id, 828874800, 7)
,(@time_zone_id, 846410400, 8)
,(@time_zone_id, 860324400, 7)
,(@time_zone_id, 877860000, 8)
,(@time_zone_id, 891774000, 7)
,(@time_zone_id, 909309600, 8)
,(@time_zone_id, 923223600, 7)
,(@time_zone_id, 941364000, 8)
,(@time_zone_id, 954673200, 7)
,(@time_zone_id, 972813600, 8)
,(@time_zone_id, 986122800, 7)
,(@time_zone_id, 1004263200, 8)
,(@time_zone_id, 1018177200, 7)
,(@time_zone_id, 1035712800, 8)
,(@time_zone_id, 1049626800, 7)
,(@time_zone_id, 1067162400, 8)
,(@time_zone_id, 1081076400, 7)
,(@time_zone_id, 1099216800, 8)
,(@time_zone_id, 1112526000, 7)
,(@time_zone_id, 1130666400, 8)
,(@time_zone_id, 1143975600, 7)
,(@time_zone_id, 1162116000, 8)
,(@time_zone_id, 1173610800, 7)
,(@time_zone_id, 1194170400, 8)
,(@time_zone_id, 1205060400, 7)
,(@time_zone_id, 1225620000, 8)
,(@time_zone_id, 1236510000, 7)
,(@time_zone_id, 1257069600, 8)
,(@time_zone_id, 1268564400, 7)
,(@time_zone_id, 1289124000, 8)
,(@time_zone_id, 1300014000, 7)
,(@time_zone_id, 1320573600, 8)
,(@time_zone_id, 1331463600, 7)
,(@time_zone_id, 1352023200, 8)
,(@time_zone_id, 1362913200, 7)
,(@time_zone_id, 1383472800, 8)
,(@time_zone_id, 1394362800, 7)
,(@time_zone_id, 1414922400, 8)
,(@time_zone_id, 1425812400, 7)
,(@time_zone_id, 1446372000, 8)
,(@time_zone_id, 1457866800, 7)
,(@time_zone_id, 1478426400, 8)
,(@time_zone_id, 1489316400, 7)
,(@time_zone_id, 1509876000, 8)
,(@time_zone_id, 1520766000, 7)
,(@time_zone_id, 1541325600, 8)
,(@time_zone_id, 1552215600, 7)
,(@time_zone_id, 1572775200, 8)
,(@time_zone_id, 1583665200, 7)
,(@time_zone_id, 1604224800, 8)
,(@time_zone_id, 1615719600, 7)
,(@time_zone_id, 1636279200, 8)
,(@time_zone_id, 1647169200, 7)
,(@time_zone_id, 1667728800, 8)
,(@time_zone_id, 1678618800, 7)
,(@time_zone_id, 1699178400, 8)
,(@time_zone_id, 1710068400, 7)
,(@time_zone_id, 1730628000, 8)
,(@time_zone_id, 1741518000, 7)
,(@time_zone_id, 1762077600, 8)
,(@time_zone_id, 1772967600, 7)
,(@time_zone_id, 1793527200, 8)
,(@time_zone_id, 1805022000, 7)
,(@time_zone_id, 1825581600, 8)
,(@time_zone_id, 1836471600, 7)
,(@time_zone_id, 1857031200, 8)
,(@time_zone_id, 1867921200, 7)
,(@time_zone_id, 1888480800, 8)
,(@time_zone_id, 1899370800, 7)
,(@time_zone_id, 1919930400, 8)
,(@time_zone_id, 1930820400, 7)
,(@time_zone_id, 1951380000, 8)
,(@time_zone_id, 1962874800, 7)
,(@time_zone_id, 1983434400, 8)
,(@time_zone_id, 1994324400, 7)
,(@time_zone_id, 2014884000, 8)
,(@time_zone_id, 2025774000, 7)
,(@time_zone_id, 2046333600, 8)
,(@time_zone_id, 2057223600, 7)
,(@time_zone_id, 2077783200, 8)
,(@time_zone_id, 2088673200, 7)
,(@time_zone_id, 2109232800, 8)
,(@time_zone_id, 2120122800, 7)
,(@time_zone_id, 2140682400, 8)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -32261, 0, 'LMT')
,(@time_zone_id, 1, -28800, 0, 'PST')
,(@time_zone_id, 2, -25200, 1, 'PWT')
,(@time_zone_id, 3, -25200, 1, 'PPT')
,(@time_zone_id, 4, -25200, 1, 'PDT')
,(@time_zone_id, 5, -28800, 1, 'YDT')
,(@time_zone_id, 6, -32400, 0, 'YST')
,(@time_zone_id, 7, -28800, 1, 'AKDT')
,(@time_zone_id, 8, -32400, 0, 'AKST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Kentucky/Louisville', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -1535904000, 1)
,(@time_zone_id, -1525280400, 2)
,(@time_zone_id, -905097600, 1)
,(@time_zone_id, -891795600, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -757360800, 1)
,(@time_zone_id, -744224400, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -608144400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 1)
,(@time_zone_id, -450291600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -415818000, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -384368400, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -352918800, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -321469200, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -289414800, 2)
,(@time_zone_id, -273686400, 1)
,(@time_zone_id, -266432400, 5)
,(@time_zone_id, -52938000, 6)
,(@time_zone_id, -37216800, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 41410800, 6)
,(@time_zone_id, 57736800, 5)
,(@time_zone_id, 73465200, 6)
,(@time_zone_id, 89186400, 5)
,(@time_zone_id, 104914800, 6)
,(@time_zone_id, 120636000, 5)
,(@time_zone_id, 126687600, 1)
,(@time_zone_id, 152089200, 5)
,(@time_zone_id, 162370800, 6)
,(@time_zone_id, 183535200, 5)
,(@time_zone_id, 199263600, 6)
,(@time_zone_id, 215589600, 5)
,(@time_zone_id, 230713200, 6)
,(@time_zone_id, 247039200, 5)
,(@time_zone_id, 262767600, 6)
,(@time_zone_id, 278488800, 5)
,(@time_zone_id, 294217200, 6)
,(@time_zone_id, 309938400, 5)
,(@time_zone_id, 325666800, 6)
,(@time_zone_id, 341388000, 5)
,(@time_zone_id, 357116400, 6)
,(@time_zone_id, 372837600, 5)
,(@time_zone_id, 388566000, 6)
,(@time_zone_id, 404892000, 5)
,(@time_zone_id, 420015600, 6)
,(@time_zone_id, 436341600, 5)
,(@time_zone_id, 452070000, 6)
,(@time_zone_id, 467791200, 5)
,(@time_zone_id, 483519600, 6)
,(@time_zone_id, 499240800, 5)
,(@time_zone_id, 514969200, 6)
,(@time_zone_id, 530690400, 5)
,(@time_zone_id, 544604400, 6)
,(@time_zone_id, 562140000, 5)
,(@time_zone_id, 576054000, 6)
,(@time_zone_id, 594194400, 5)
,(@time_zone_id, 607503600, 6)
,(@time_zone_id, 625644000, 5)
,(@time_zone_id, 638953200, 6)
,(@time_zone_id, 657093600, 5)
,(@time_zone_id, 671007600, 6)
,(@time_zone_id, 688543200, 5)
,(@time_zone_id, 702457200, 6)
,(@time_zone_id, 719992800, 5)
,(@time_zone_id, 733906800, 6)
,(@time_zone_id, 752047200, 5)
,(@time_zone_id, 765356400, 6)
,(@time_zone_id, 783496800, 5)
,(@time_zone_id, 796806000, 6)
,(@time_zone_id, 814946400, 5)
,(@time_zone_id, 828860400, 6)
,(@time_zone_id, 846396000, 5)
,(@time_zone_id, 860310000, 6)
,(@time_zone_id, 877845600, 5)
,(@time_zone_id, 891759600, 6)
,(@time_zone_id, 909295200, 5)
,(@time_zone_id, 923209200, 6)
,(@time_zone_id, 941349600, 5)
,(@time_zone_id, 954658800, 6)
,(@time_zone_id, 972799200, 5)
,(@time_zone_id, 986108400, 6)
,(@time_zone_id, 1004248800, 5)
,(@time_zone_id, 1018162800, 6)
,(@time_zone_id, 1035698400, 5)
,(@time_zone_id, 1049612400, 6)
,(@time_zone_id, 1067148000, 5)
,(@time_zone_id, 1081062000, 6)
,(@time_zone_id, 1099202400, 5)
,(@time_zone_id, 1112511600, 6)
,(@time_zone_id, 1130652000, 5)
,(@time_zone_id, 1143961200, 6)
,(@time_zone_id, 1162101600, 5)
,(@time_zone_id, 1173596400, 6)
,(@time_zone_id, 1194156000, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20582, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Kentucky/Monticello', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -52934400, 1)
,(@time_zone_id, -37213200, 2)
,(@time_zone_id, -21484800, 1)
,(@time_zone_id, -5763600, 2)
,(@time_zone_id, 9964800, 1)
,(@time_zone_id, 25686000, 2)
,(@time_zone_id, 41414400, 1)
,(@time_zone_id, 57740400, 2)
,(@time_zone_id, 73468800, 1)
,(@time_zone_id, 89190000, 2)
,(@time_zone_id, 104918400, 1)
,(@time_zone_id, 120639600, 2)
,(@time_zone_id, 126691200, 1)
,(@time_zone_id, 152089200, 2)
,(@time_zone_id, 162374400, 1)
,(@time_zone_id, 183538800, 2)
,(@time_zone_id, 199267200, 1)
,(@time_zone_id, 215593200, 2)
,(@time_zone_id, 230716800, 1)
,(@time_zone_id, 247042800, 2)
,(@time_zone_id, 262771200, 1)
,(@time_zone_id, 278492400, 2)
,(@time_zone_id, 294220800, 1)
,(@time_zone_id, 309942000, 2)
,(@time_zone_id, 325670400, 1)
,(@time_zone_id, 341391600, 2)
,(@time_zone_id, 357120000, 1)
,(@time_zone_id, 372841200, 2)
,(@time_zone_id, 388569600, 1)
,(@time_zone_id, 404895600, 2)
,(@time_zone_id, 420019200, 1)
,(@time_zone_id, 436345200, 2)
,(@time_zone_id, 452073600, 1)
,(@time_zone_id, 467794800, 2)
,(@time_zone_id, 483523200, 1)
,(@time_zone_id, 499244400, 2)
,(@time_zone_id, 514972800, 1)
,(@time_zone_id, 530694000, 2)
,(@time_zone_id, 544608000, 1)
,(@time_zone_id, 562143600, 2)
,(@time_zone_id, 576057600, 1)
,(@time_zone_id, 594198000, 2)
,(@time_zone_id, 607507200, 1)
,(@time_zone_id, 625647600, 2)
,(@time_zone_id, 638956800, 1)
,(@time_zone_id, 657097200, 2)
,(@time_zone_id, 671011200, 1)
,(@time_zone_id, 688546800, 2)
,(@time_zone_id, 702460800, 1)
,(@time_zone_id, 719996400, 2)
,(@time_zone_id, 733910400, 1)
,(@time_zone_id, 752050800, 2)
,(@time_zone_id, 765360000, 1)
,(@time_zone_id, 783500400, 2)
,(@time_zone_id, 796809600, 1)
,(@time_zone_id, 814950000, 2)
,(@time_zone_id, 828864000, 1)
,(@time_zone_id, 846399600, 2)
,(@time_zone_id, 860313600, 1)
,(@time_zone_id, 877849200, 2)
,(@time_zone_id, 891763200, 1)
,(@time_zone_id, 909298800, 2)
,(@time_zone_id, 923212800, 1)
,(@time_zone_id, 941353200, 2)
,(@time_zone_id, 954662400, 1)
,(@time_zone_id, 972802800, 6)
,(@time_zone_id, 986108400, 5)
,(@time_zone_id, 1004248800, 6)
,(@time_zone_id, 1018162800, 5)
,(@time_zone_id, 1035698400, 6)
,(@time_zone_id, 1049612400, 5)
,(@time_zone_id, 1067148000, 6)
,(@time_zone_id, 1081062000, 5)
,(@time_zone_id, 1099202400, 6)
,(@time_zone_id, 1112511600, 5)
,(@time_zone_id, 1130652000, 6)
,(@time_zone_id, 1143961200, 5)
,(@time_zone_id, 1162101600, 6)
,(@time_zone_id, 1173596400, 5)
,(@time_zone_id, 1194156000, 6)
,(@time_zone_id, 1205046000, 5)
,(@time_zone_id, 1225605600, 6)
,(@time_zone_id, 1236495600, 5)
,(@time_zone_id, 1257055200, 6)
,(@time_zone_id, 1268550000, 5)
,(@time_zone_id, 1289109600, 6)
,(@time_zone_id, 1299999600, 5)
,(@time_zone_id, 1320559200, 6)
,(@time_zone_id, 1331449200, 5)
,(@time_zone_id, 1352008800, 6)
,(@time_zone_id, 1362898800, 5)
,(@time_zone_id, 1383458400, 6)
,(@time_zone_id, 1394348400, 5)
,(@time_zone_id, 1414908000, 6)
,(@time_zone_id, 1425798000, 5)
,(@time_zone_id, 1446357600, 6)
,(@time_zone_id, 1457852400, 5)
,(@time_zone_id, 1478412000, 6)
,(@time_zone_id, 1489302000, 5)
,(@time_zone_id, 1509861600, 6)
,(@time_zone_id, 1520751600, 5)
,(@time_zone_id, 1541311200, 6)
,(@time_zone_id, 1552201200, 5)
,(@time_zone_id, 1572760800, 6)
,(@time_zone_id, 1583650800, 5)
,(@time_zone_id, 1604210400, 6)
,(@time_zone_id, 1615705200, 5)
,(@time_zone_id, 1636264800, 6)
,(@time_zone_id, 1647154800, 5)
,(@time_zone_id, 1667714400, 6)
,(@time_zone_id, 1678604400, 5)
,(@time_zone_id, 1699164000, 6)
,(@time_zone_id, 1710054000, 5)
,(@time_zone_id, 1730613600, 6)
,(@time_zone_id, 1741503600, 5)
,(@time_zone_id, 1762063200, 6)
,(@time_zone_id, 1772953200, 5)
,(@time_zone_id, 1793512800, 6)
,(@time_zone_id, 1805007600, 5)
,(@time_zone_id, 1825567200, 6)
,(@time_zone_id, 1836457200, 5)
,(@time_zone_id, 1857016800, 6)
,(@time_zone_id, 1867906800, 5)
,(@time_zone_id, 1888466400, 6)
,(@time_zone_id, 1899356400, 5)
,(@time_zone_id, 1919916000, 6)
,(@time_zone_id, 1930806000, 5)
,(@time_zone_id, 1951365600, 6)
,(@time_zone_id, 1962860400, 5)
,(@time_zone_id, 1983420000, 6)
,(@time_zone_id, 1994310000, 5)
,(@time_zone_id, 2014869600, 6)
,(@time_zone_id, 2025759600, 5)
,(@time_zone_id, 2046319200, 6)
,(@time_zone_id, 2057209200, 5)
,(@time_zone_id, 2077768800, 6)
,(@time_zone_id, 2088658800, 5)
,(@time_zone_id, 2109218400, 6)
,(@time_zone_id, 2120108400, 5)
,(@time_zone_id, 2140668000, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20364, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -14400, 1, 'EDT')
,(@time_zone_id, 6, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Knox_IN', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -702493200, 2)
,(@time_zone_id, -684345600, 1)
,(@time_zone_id, -671043600, 2)
,(@time_zone_id, -652896000, 1)
,(@time_zone_id, -639594000, 2)
,(@time_zone_id, -620841600, 1)
,(@time_zone_id, -608144400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 1)
,(@time_zone_id, -447267600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -415818000, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -355338000, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -321469200, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -289414800, 2)
,(@time_zone_id, -273686400, 1)
,(@time_zone_id, -257965200, 2)
,(@time_zone_id, -242236800, 5)
,(@time_zone_id, -195066000, 2)
,(@time_zone_id, -84384000, 1)
,(@time_zone_id, -68662800, 2)
,(@time_zone_id, -52934400, 1)
,(@time_zone_id, -37213200, 2)
,(@time_zone_id, -21484800, 1)
,(@time_zone_id, -5763600, 2)
,(@time_zone_id, 9964800, 1)
,(@time_zone_id, 25686000, 2)
,(@time_zone_id, 41414400, 1)
,(@time_zone_id, 57740400, 2)
,(@time_zone_id, 73468800, 1)
,(@time_zone_id, 89190000, 2)
,(@time_zone_id, 104918400, 1)
,(@time_zone_id, 120639600, 2)
,(@time_zone_id, 126691200, 1)
,(@time_zone_id, 152089200, 2)
,(@time_zone_id, 162374400, 1)
,(@time_zone_id, 183538800, 2)
,(@time_zone_id, 199267200, 1)
,(@time_zone_id, 215593200, 2)
,(@time_zone_id, 230716800, 1)
,(@time_zone_id, 247042800, 2)
,(@time_zone_id, 262771200, 1)
,(@time_zone_id, 278492400, 2)
,(@time_zone_id, 294220800, 1)
,(@time_zone_id, 309942000, 2)
,(@time_zone_id, 325670400, 1)
,(@time_zone_id, 341391600, 2)
,(@time_zone_id, 357120000, 1)
,(@time_zone_id, 372841200, 2)
,(@time_zone_id, 388569600, 1)
,(@time_zone_id, 404895600, 2)
,(@time_zone_id, 420019200, 1)
,(@time_zone_id, 436345200, 2)
,(@time_zone_id, 452073600, 1)
,(@time_zone_id, 467794800, 2)
,(@time_zone_id, 483523200, 1)
,(@time_zone_id, 499244400, 2)
,(@time_zone_id, 514972800, 1)
,(@time_zone_id, 530694000, 2)
,(@time_zone_id, 544608000, 1)
,(@time_zone_id, 562143600, 2)
,(@time_zone_id, 576057600, 1)
,(@time_zone_id, 594198000, 2)
,(@time_zone_id, 607507200, 1)
,(@time_zone_id, 625647600, 2)
,(@time_zone_id, 638956800, 1)
,(@time_zone_id, 657097200, 2)
,(@time_zone_id, 671011200, 1)
,(@time_zone_id, 688546800, 5)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 1)
,(@time_zone_id, 1194159600, 2)
,(@time_zone_id, 1205049600, 1)
,(@time_zone_id, 1225609200, 2)
,(@time_zone_id, 1236499200, 1)
,(@time_zone_id, 1257058800, 2)
,(@time_zone_id, 1268553600, 1)
,(@time_zone_id, 1289113200, 2)
,(@time_zone_id, 1300003200, 1)
,(@time_zone_id, 1320562800, 2)
,(@time_zone_id, 1331452800, 1)
,(@time_zone_id, 1352012400, 2)
,(@time_zone_id, 1362902400, 1)
,(@time_zone_id, 1383462000, 2)
,(@time_zone_id, 1394352000, 1)
,(@time_zone_id, 1414911600, 2)
,(@time_zone_id, 1425801600, 1)
,(@time_zone_id, 1446361200, 2)
,(@time_zone_id, 1457856000, 1)
,(@time_zone_id, 1478415600, 2)
,(@time_zone_id, 1489305600, 1)
,(@time_zone_id, 1509865200, 2)
,(@time_zone_id, 1520755200, 1)
,(@time_zone_id, 1541314800, 2)
,(@time_zone_id, 1552204800, 1)
,(@time_zone_id, 1572764400, 2)
,(@time_zone_id, 1583654400, 1)
,(@time_zone_id, 1604214000, 2)
,(@time_zone_id, 1615708800, 1)
,(@time_zone_id, 1636268400, 2)
,(@time_zone_id, 1647158400, 1)
,(@time_zone_id, 1667718000, 2)
,(@time_zone_id, 1678608000, 1)
,(@time_zone_id, 1699167600, 2)
,(@time_zone_id, 1710057600, 1)
,(@time_zone_id, 1730617200, 2)
,(@time_zone_id, 1741507200, 1)
,(@time_zone_id, 1762066800, 2)
,(@time_zone_id, 1772956800, 1)
,(@time_zone_id, 1793516400, 2)
,(@time_zone_id, 1805011200, 1)
,(@time_zone_id, 1825570800, 2)
,(@time_zone_id, 1836460800, 1)
,(@time_zone_id, 1857020400, 2)
,(@time_zone_id, 1867910400, 1)
,(@time_zone_id, 1888470000, 2)
,(@time_zone_id, 1899360000, 1)
,(@time_zone_id, 1919919600, 2)
,(@time_zone_id, 1930809600, 1)
,(@time_zone_id, 1951369200, 2)
,(@time_zone_id, 1962864000, 1)
,(@time_zone_id, 1983423600, 2)
,(@time_zone_id, 1994313600, 1)
,(@time_zone_id, 2014873200, 2)
,(@time_zone_id, 2025763200, 1)
,(@time_zone_id, 2046322800, 2)
,(@time_zone_id, 2057212800, 1)
,(@time_zone_id, 2077772400, 2)
,(@time_zone_id, 2088662400, 1)
,(@time_zone_id, 2109222000, 2)
,(@time_zone_id, 2120112000, 1)
,(@time_zone_id, 2140671600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20790, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Kralendijk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1826738653, 1)
,(@time_zone_id, -157750200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16547, 0, 'LMT')
,(@time_zone_id, 1, -16200, 0, '-0430')
,(@time_zone_id, 2, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/La_Paz', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1205954844, 2)
,(@time_zone_id, -1192307244, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16356, 0, 'LMT')
,(@time_zone_id, 1, -16356, 0, 'CMT')
,(@time_zone_id, 2, -12756, 1, 'BST')
,(@time_zone_id, 3, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Lima', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1938538284, 3)
,(@time_zone_id, -1009825200, 2)
,(@time_zone_id, -1002052800, 3)
,(@time_zone_id, -986756400, 2)
,(@time_zone_id, -971035200, 3)
,(@time_zone_id, -955306800, 2)
,(@time_zone_id, -939585600, 3)
,(@time_zone_id, 504939600, 2)
,(@time_zone_id, 512712000, 3)
,(@time_zone_id, 536475600, 2)
,(@time_zone_id, 544248000, 3)
,(@time_zone_id, 631170000, 2)
,(@time_zone_id, 638942400, 3)
,(@time_zone_id, 757400400, 2)
,(@time_zone_id, 765172800, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -18492, 0, 'LMT')
,(@time_zone_id, 1, -18516, 0, 'LMT')
,(@time_zone_id, 2, -14400, 1, '-04')
,(@time_zone_id, 3, -18000, 0, '-05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Los_Angeles', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633269600, 1)
,(@time_zone_id, -1615129200, 2)
,(@time_zone_id, -1601820000, 1)
,(@time_zone_id, -1583679600, 2)
,(@time_zone_id, -880207200, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765385200, 2)
,(@time_zone_id, -687967140, 1)
,(@time_zone_id, -662655600, 2)
,(@time_zone_id, -620838000, 1)
,(@time_zone_id, -608137200, 2)
,(@time_zone_id, -589388400, 1)
,(@time_zone_id, -576082800, 2)
,(@time_zone_id, -557938800, 1)
,(@time_zone_id, -544633200, 2)
,(@time_zone_id, -526489200, 1)
,(@time_zone_id, -513183600, 2)
,(@time_zone_id, -495039600, 1)
,(@time_zone_id, -481734000, 2)
,(@time_zone_id, -463590000, 1)
,(@time_zone_id, -450284400, 2)
,(@time_zone_id, -431535600, 1)
,(@time_zone_id, -418230000, 2)
,(@time_zone_id, -400086000, 1)
,(@time_zone_id, -386780400, 2)
,(@time_zone_id, -368636400, 1)
,(@time_zone_id, -355330800, 2)
,(@time_zone_id, -337186800, 1)
,(@time_zone_id, -323881200, 2)
,(@time_zone_id, -305737200, 1)
,(@time_zone_id, -292431600, 2)
,(@time_zone_id, -273682800, 1)
,(@time_zone_id, -260982000, 2)
,(@time_zone_id, -242233200, 1)
,(@time_zone_id, -226508400, 2)
,(@time_zone_id, -210783600, 1)
,(@time_zone_id, -195058800, 2)
,(@time_zone_id, -179334000, 1)
,(@time_zone_id, -163609200, 2)
,(@time_zone_id, -147884400, 1)
,(@time_zone_id, -131554800, 2)
,(@time_zone_id, -116434800, 1)
,(@time_zone_id, -100105200, 2)
,(@time_zone_id, -84376800, 1)
,(@time_zone_id, -68655600, 2)
,(@time_zone_id, -52927200, 1)
,(@time_zone_id, -37206000, 2)
,(@time_zone_id, -21477600, 1)
,(@time_zone_id, -5756400, 2)
,(@time_zone_id, 9972000, 1)
,(@time_zone_id, 25693200, 2)
,(@time_zone_id, 41421600, 1)
,(@time_zone_id, 57747600, 2)
,(@time_zone_id, 73476000, 1)
,(@time_zone_id, 89197200, 2)
,(@time_zone_id, 104925600, 1)
,(@time_zone_id, 120646800, 2)
,(@time_zone_id, 126698400, 1)
,(@time_zone_id, 152096400, 2)
,(@time_zone_id, 162381600, 1)
,(@time_zone_id, 183546000, 2)
,(@time_zone_id, 199274400, 1)
,(@time_zone_id, 215600400, 2)
,(@time_zone_id, 230724000, 1)
,(@time_zone_id, 247050000, 2)
,(@time_zone_id, 262778400, 1)
,(@time_zone_id, 278499600, 2)
,(@time_zone_id, 294228000, 1)
,(@time_zone_id, 309949200, 2)
,(@time_zone_id, 325677600, 1)
,(@time_zone_id, 341398800, 2)
,(@time_zone_id, 357127200, 1)
,(@time_zone_id, 372848400, 2)
,(@time_zone_id, 388576800, 1)
,(@time_zone_id, 404902800, 2)
,(@time_zone_id, 420026400, 1)
,(@time_zone_id, 436352400, 2)
,(@time_zone_id, 452080800, 1)
,(@time_zone_id, 467802000, 2)
,(@time_zone_id, 483530400, 1)
,(@time_zone_id, 499251600, 2)
,(@time_zone_id, 514980000, 1)
,(@time_zone_id, 530701200, 2)
,(@time_zone_id, 544615200, 1)
,(@time_zone_id, 562150800, 2)
,(@time_zone_id, 576064800, 1)
,(@time_zone_id, 594205200, 2)
,(@time_zone_id, 607514400, 1)
,(@time_zone_id, 625654800, 2)
,(@time_zone_id, 638964000, 1)
,(@time_zone_id, 657104400, 2)
,(@time_zone_id, 671018400, 1)
,(@time_zone_id, 688554000, 2)
,(@time_zone_id, 702468000, 1)
,(@time_zone_id, 720003600, 2)
,(@time_zone_id, 733917600, 1)
,(@time_zone_id, 752058000, 2)
,(@time_zone_id, 765367200, 1)
,(@time_zone_id, 783507600, 2)
,(@time_zone_id, 796816800, 1)
,(@time_zone_id, 814957200, 2)
,(@time_zone_id, 828871200, 1)
,(@time_zone_id, 846406800, 2)
,(@time_zone_id, 860320800, 1)
,(@time_zone_id, 877856400, 2)
,(@time_zone_id, 891770400, 1)
,(@time_zone_id, 909306000, 2)
,(@time_zone_id, 923220000, 1)
,(@time_zone_id, 941360400, 2)
,(@time_zone_id, 954669600, 1)
,(@time_zone_id, 972810000, 2)
,(@time_zone_id, 986119200, 1)
,(@time_zone_id, 1004259600, 2)
,(@time_zone_id, 1018173600, 1)
,(@time_zone_id, 1035709200, 2)
,(@time_zone_id, 1049623200, 1)
,(@time_zone_id, 1067158800, 2)
,(@time_zone_id, 1081072800, 1)
,(@time_zone_id, 1099213200, 2)
,(@time_zone_id, 1112522400, 1)
,(@time_zone_id, 1130662800, 2)
,(@time_zone_id, 1143972000, 1)
,(@time_zone_id, 1162112400, 2)
,(@time_zone_id, 1173607200, 1)
,(@time_zone_id, 1194166800, 2)
,(@time_zone_id, 1205056800, 1)
,(@time_zone_id, 1225616400, 2)
,(@time_zone_id, 1236506400, 1)
,(@time_zone_id, 1257066000, 2)
,(@time_zone_id, 1268560800, 1)
,(@time_zone_id, 1289120400, 2)
,(@time_zone_id, 1300010400, 1)
,(@time_zone_id, 1320570000, 2)
,(@time_zone_id, 1331460000, 1)
,(@time_zone_id, 1352019600, 2)
,(@time_zone_id, 1362909600, 1)
,(@time_zone_id, 1383469200, 2)
,(@time_zone_id, 1394359200, 1)
,(@time_zone_id, 1414918800, 2)
,(@time_zone_id, 1425808800, 1)
,(@time_zone_id, 1446368400, 2)
,(@time_zone_id, 1457863200, 1)
,(@time_zone_id, 1478422800, 2)
,(@time_zone_id, 1489312800, 1)
,(@time_zone_id, 1509872400, 2)
,(@time_zone_id, 1520762400, 1)
,(@time_zone_id, 1541322000, 2)
,(@time_zone_id, 1552212000, 1)
,(@time_zone_id, 1572771600, 2)
,(@time_zone_id, 1583661600, 1)
,(@time_zone_id, 1604221200, 2)
,(@time_zone_id, 1615716000, 1)
,(@time_zone_id, 1636275600, 2)
,(@time_zone_id, 1647165600, 1)
,(@time_zone_id, 1667725200, 2)
,(@time_zone_id, 1678615200, 1)
,(@time_zone_id, 1699174800, 2)
,(@time_zone_id, 1710064800, 1)
,(@time_zone_id, 1730624400, 2)
,(@time_zone_id, 1741514400, 1)
,(@time_zone_id, 1762074000, 2)
,(@time_zone_id, 1772964000, 1)
,(@time_zone_id, 1793523600, 2)
,(@time_zone_id, 1805018400, 1)
,(@time_zone_id, 1825578000, 2)
,(@time_zone_id, 1836468000, 1)
,(@time_zone_id, 1857027600, 2)
,(@time_zone_id, 1867917600, 1)
,(@time_zone_id, 1888477200, 2)
,(@time_zone_id, 1899367200, 1)
,(@time_zone_id, 1919926800, 2)
,(@time_zone_id, 1930816800, 1)
,(@time_zone_id, 1951376400, 2)
,(@time_zone_id, 1962871200, 1)
,(@time_zone_id, 1983430800, 2)
,(@time_zone_id, 1994320800, 1)
,(@time_zone_id, 2014880400, 2)
,(@time_zone_id, 2025770400, 1)
,(@time_zone_id, 2046330000, 2)
,(@time_zone_id, 2057220000, 1)
,(@time_zone_id, 2077779600, 2)
,(@time_zone_id, 2088669600, 1)
,(@time_zone_id, 2109229200, 2)
,(@time_zone_id, 2120119200, 1)
,(@time_zone_id, 2140678800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -28378, 0, 'LMT')
,(@time_zone_id, 1, -25200, 1, 'PDT')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -25200, 1, 'PWT')
,(@time_zone_id, 4, -25200, 1, 'PPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Louisville', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -1535904000, 1)
,(@time_zone_id, -1525280400, 2)
,(@time_zone_id, -905097600, 1)
,(@time_zone_id, -891795600, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -757360800, 1)
,(@time_zone_id, -744224400, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -608144400, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 1)
,(@time_zone_id, -450291600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -415818000, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -384368400, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -352918800, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -321469200, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -289414800, 2)
,(@time_zone_id, -273686400, 1)
,(@time_zone_id, -266432400, 5)
,(@time_zone_id, -52938000, 6)
,(@time_zone_id, -37216800, 5)
,(@time_zone_id, -21488400, 6)
,(@time_zone_id, -5767200, 5)
,(@time_zone_id, 9961200, 6)
,(@time_zone_id, 25682400, 5)
,(@time_zone_id, 41410800, 6)
,(@time_zone_id, 57736800, 5)
,(@time_zone_id, 73465200, 6)
,(@time_zone_id, 89186400, 5)
,(@time_zone_id, 104914800, 6)
,(@time_zone_id, 120636000, 5)
,(@time_zone_id, 126687600, 1)
,(@time_zone_id, 152089200, 5)
,(@time_zone_id, 162370800, 6)
,(@time_zone_id, 183535200, 5)
,(@time_zone_id, 199263600, 6)
,(@time_zone_id, 215589600, 5)
,(@time_zone_id, 230713200, 6)
,(@time_zone_id, 247039200, 5)
,(@time_zone_id, 262767600, 6)
,(@time_zone_id, 278488800, 5)
,(@time_zone_id, 294217200, 6)
,(@time_zone_id, 309938400, 5)
,(@time_zone_id, 325666800, 6)
,(@time_zone_id, 341388000, 5)
,(@time_zone_id, 357116400, 6)
,(@time_zone_id, 372837600, 5)
,(@time_zone_id, 388566000, 6)
,(@time_zone_id, 404892000, 5)
,(@time_zone_id, 420015600, 6)
,(@time_zone_id, 436341600, 5)
,(@time_zone_id, 452070000, 6)
,(@time_zone_id, 467791200, 5)
,(@time_zone_id, 483519600, 6)
,(@time_zone_id, 499240800, 5)
,(@time_zone_id, 514969200, 6)
,(@time_zone_id, 530690400, 5)
,(@time_zone_id, 544604400, 6)
,(@time_zone_id, 562140000, 5)
,(@time_zone_id, 576054000, 6)
,(@time_zone_id, 594194400, 5)
,(@time_zone_id, 607503600, 6)
,(@time_zone_id, 625644000, 5)
,(@time_zone_id, 638953200, 6)
,(@time_zone_id, 657093600, 5)
,(@time_zone_id, 671007600, 6)
,(@time_zone_id, 688543200, 5)
,(@time_zone_id, 702457200, 6)
,(@time_zone_id, 719992800, 5)
,(@time_zone_id, 733906800, 6)
,(@time_zone_id, 752047200, 5)
,(@time_zone_id, 765356400, 6)
,(@time_zone_id, 783496800, 5)
,(@time_zone_id, 796806000, 6)
,(@time_zone_id, 814946400, 5)
,(@time_zone_id, 828860400, 6)
,(@time_zone_id, 846396000, 5)
,(@time_zone_id, 860310000, 6)
,(@time_zone_id, 877845600, 5)
,(@time_zone_id, 891759600, 6)
,(@time_zone_id, 909295200, 5)
,(@time_zone_id, 923209200, 6)
,(@time_zone_id, 941349600, 5)
,(@time_zone_id, 954658800, 6)
,(@time_zone_id, 972799200, 5)
,(@time_zone_id, 986108400, 6)
,(@time_zone_id, 1004248800, 5)
,(@time_zone_id, 1018162800, 6)
,(@time_zone_id, 1035698400, 5)
,(@time_zone_id, 1049612400, 6)
,(@time_zone_id, 1067148000, 5)
,(@time_zone_id, 1081062000, 6)
,(@time_zone_id, 1099202400, 5)
,(@time_zone_id, 1112511600, 6)
,(@time_zone_id, 1130652000, 5)
,(@time_zone_id, 1143961200, 6)
,(@time_zone_id, 1162101600, 5)
,(@time_zone_id, 1173596400, 6)
,(@time_zone_id, 1194156000, 5)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 5)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 5)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 5)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 5)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 5)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 5)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 5)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 5)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 5)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 5)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 5)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 5)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 5)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 5)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 5)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 5)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 5)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 5)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 5)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 5)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 5)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 5)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 5)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 5)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 5)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 5)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 5)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 5)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 5)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20582, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Lower_Princes', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1826738653, 1)
,(@time_zone_id, -157750200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16547, 0, 'LMT')
,(@time_zone_id, 1, -16200, 0, '-0430')
,(@time_zone_id, 2, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Maceio', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767217028, 2)
,(@time_zone_id, -1206957600, 1)
,(@time_zone_id, -1191362400, 2)
,(@time_zone_id, -1175374800, 1)
,(@time_zone_id, -1159826400, 2)
,(@time_zone_id, -633819600, 1)
,(@time_zone_id, -622069200, 2)
,(@time_zone_id, -602283600, 1)
,(@time_zone_id, -591832800, 2)
,(@time_zone_id, -570747600, 1)
,(@time_zone_id, -560210400, 2)
,(@time_zone_id, -539125200, 1)
,(@time_zone_id, -531352800, 2)
,(@time_zone_id, -191365200, 1)
,(@time_zone_id, -184197600, 2)
,(@time_zone_id, -155163600, 1)
,(@time_zone_id, -150069600, 2)
,(@time_zone_id, -128898000, 1)
,(@time_zone_id, -121125600, 2)
,(@time_zone_id, -99954000, 1)
,(@time_zone_id, -89589600, 2)
,(@time_zone_id, -68418000, 1)
,(@time_zone_id, -57967200, 2)
,(@time_zone_id, 499748400, 1)
,(@time_zone_id, 511236000, 2)
,(@time_zone_id, 530593200, 1)
,(@time_zone_id, 540266400, 2)
,(@time_zone_id, 562129200, 1)
,(@time_zone_id, 571197600, 2)
,(@time_zone_id, 592974000, 1)
,(@time_zone_id, 602042400, 2)
,(@time_zone_id, 624423600, 1)
,(@time_zone_id, 634701600, 2)
,(@time_zone_id, 813726000, 1)
,(@time_zone_id, 824004000, 2)
,(@time_zone_id, 938919600, 1)
,(@time_zone_id, 951616800, 2)
,(@time_zone_id, 970974000, 1)
,(@time_zone_id, 972180000, 2)
,(@time_zone_id, 1003028400, 1)
,(@time_zone_id, 1013911200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -8572, 0, 'LMT')
,(@time_zone_id, 1, -7200, 1, '-02')
,(@time_zone_id, 2, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Managua', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1121105688, 2)
,(@time_zone_id, 105084000, 3)
,(@time_zone_id, 161758800, 2)
,(@time_zone_id, 290584800, 4)
,(@time_zone_id, 299134800, 2)
,(@time_zone_id, 322034400, 4)
,(@time_zone_id, 330584400, 2)
,(@time_zone_id, 694260000, 3)
,(@time_zone_id, 717310800, 2)
,(@time_zone_id, 725868000, 3)
,(@time_zone_id, 852094800, 2)
,(@time_zone_id, 1113112800, 4)
,(@time_zone_id, 1128229200, 2)
,(@time_zone_id, 1146384000, 4)
,(@time_zone_id, 1159682400, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20708, 0, 'LMT')
,(@time_zone_id, 1, -20712, 0, 'MMT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 0, 'EST')
,(@time_zone_id, 4, -18000, 1, 'CDT')
,(@time_zone_id, 5, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Manaus', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767211196, 2)
,(@time_zone_id, -1206954000, 1)
,(@time_zone_id, -1191358800, 2)
,(@time_zone_id, -1175371200, 1)
,(@time_zone_id, -1159822800, 2)
,(@time_zone_id, -633816000, 1)
,(@time_zone_id, -622065600, 2)
,(@time_zone_id, -602280000, 1)
,(@time_zone_id, -591829200, 2)
,(@time_zone_id, -570744000, 1)
,(@time_zone_id, -560206800, 2)
,(@time_zone_id, -539121600, 1)
,(@time_zone_id, -531349200, 2)
,(@time_zone_id, -191361600, 1)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -155160000, 1)
,(@time_zone_id, -150066000, 2)
,(@time_zone_id, -128894400, 1)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -99950400, 1)
,(@time_zone_id, -89586000, 2)
,(@time_zone_id, -68414400, 1)
,(@time_zone_id, -57963600, 2)
,(@time_zone_id, 499752000, 1)
,(@time_zone_id, 511239600, 2)
,(@time_zone_id, 530596800, 1)
,(@time_zone_id, 540270000, 2)
,(@time_zone_id, 562132800, 1)
,(@time_zone_id, 571201200, 2)
,(@time_zone_id, 750830400, 1)
,(@time_zone_id, 761713200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14404, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, '-03')
,(@time_zone_id, 2, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Marigot', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Martinique', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1851537340, 2)
,(@time_zone_id, 323841600, 3)
,(@time_zone_id, 338958000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14660, 0, 'LMT')
,(@time_zone_id, 1, -14660, 0, 'FFMT')
,(@time_zone_id, 2, -14400, 0, 'AST')
,(@time_zone_id, 3, -10800, 1, 'ADT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Matamoros', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514743200, 1)
,(@time_zone_id, 576057600, 2)
,(@time_zone_id, 594198000, 1)
,(@time_zone_id, 828864000, 2)
,(@time_zone_id, 846399600, 1)
,(@time_zone_id, 860313600, 2)
,(@time_zone_id, 877849200, 1)
,(@time_zone_id, 891763200, 2)
,(@time_zone_id, 909298800, 1)
,(@time_zone_id, 923212800, 2)
,(@time_zone_id, 941353200, 1)
,(@time_zone_id, 954662400, 2)
,(@time_zone_id, 972802800, 1)
,(@time_zone_id, 989136000, 2)
,(@time_zone_id, 1001833200, 1)
,(@time_zone_id, 1018166400, 2)
,(@time_zone_id, 1035702000, 1)
,(@time_zone_id, 1049616000, 2)
,(@time_zone_id, 1067151600, 1)
,(@time_zone_id, 1081065600, 2)
,(@time_zone_id, 1099206000, 1)
,(@time_zone_id, 1112515200, 2)
,(@time_zone_id, 1130655600, 1)
,(@time_zone_id, 1143964800, 2)
,(@time_zone_id, 1162105200, 1)
,(@time_zone_id, 1175414400, 2)
,(@time_zone_id, 1193554800, 1)
,(@time_zone_id, 1207468800, 2)
,(@time_zone_id, 1225004400, 1)
,(@time_zone_id, 1238918400, 2)
,(@time_zone_id, 1256454000, 1)
,(@time_zone_id, 1268553600, 2)
,(@time_zone_id, 1289113200, 1)
,(@time_zone_id, 1300003200, 2)
,(@time_zone_id, 1320562800, 1)
,(@time_zone_id, 1331452800, 2)
,(@time_zone_id, 1352012400, 1)
,(@time_zone_id, 1362902400, 2)
,(@time_zone_id, 1383462000, 1)
,(@time_zone_id, 1394352000, 2)
,(@time_zone_id, 1414911600, 1)
,(@time_zone_id, 1425801600, 2)
,(@time_zone_id, 1446361200, 1)
,(@time_zone_id, 1457856000, 2)
,(@time_zone_id, 1478415600, 1)
,(@time_zone_id, 1489305600, 2)
,(@time_zone_id, 1509865200, 1)
,(@time_zone_id, 1520755200, 2)
,(@time_zone_id, 1541314800, 1)
,(@time_zone_id, 1552204800, 2)
,(@time_zone_id, 1572764400, 1)
,(@time_zone_id, 1583654400, 2)
,(@time_zone_id, 1604214000, 1)
,(@time_zone_id, 1615708800, 2)
,(@time_zone_id, 1636268400, 1)
,(@time_zone_id, 1647158400, 2)
,(@time_zone_id, 1667718000, 1)
,(@time_zone_id, 1678608000, 2)
,(@time_zone_id, 1699167600, 1)
,(@time_zone_id, 1710057600, 2)
,(@time_zone_id, 1730617200, 1)
,(@time_zone_id, 1741507200, 2)
,(@time_zone_id, 1762066800, 1)
,(@time_zone_id, 1772956800, 2)
,(@time_zone_id, 1793516400, 1)
,(@time_zone_id, 1805011200, 2)
,(@time_zone_id, 1825570800, 1)
,(@time_zone_id, 1836460800, 2)
,(@time_zone_id, 1857020400, 1)
,(@time_zone_id, 1867910400, 2)
,(@time_zone_id, 1888470000, 1)
,(@time_zone_id, 1899360000, 2)
,(@time_zone_id, 1919919600, 1)
,(@time_zone_id, 1930809600, 2)
,(@time_zone_id, 1951369200, 1)
,(@time_zone_id, 1962864000, 2)
,(@time_zone_id, 1983423600, 1)
,(@time_zone_id, 1994313600, 2)
,(@time_zone_id, 2014873200, 1)
,(@time_zone_id, 2025763200, 2)
,(@time_zone_id, 2046322800, 1)
,(@time_zone_id, 2057212800, 2)
,(@time_zone_id, 2077772400, 1)
,(@time_zone_id, 2088662400, 2)
,(@time_zone_id, 2109222000, 1)
,(@time_zone_id, 2120112000, 2)
,(@time_zone_id, 2140671600, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -24000, 0, 'LMT')
,(@time_zone_id, 1, -21600, 0, 'CST')
,(@time_zone_id, 2, -18000, 1, 'CDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Mazatlan', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514739600, 1)
,(@time_zone_id, -1343066400, 2)
,(@time_zone_id, -1234807200, 1)
,(@time_zone_id, -1220292000, 2)
,(@time_zone_id, -1207159200, 1)
,(@time_zone_id, -1191344400, 2)
,(@time_zone_id, -873828000, 1)
,(@time_zone_id, -661539600, 3)
,(@time_zone_id, 28800, 1)
,(@time_zone_id, 828867600, 4)
,(@time_zone_id, 846403200, 1)
,(@time_zone_id, 860317200, 4)
,(@time_zone_id, 877852800, 1)
,(@time_zone_id, 891766800, 4)
,(@time_zone_id, 909302400, 1)
,(@time_zone_id, 923216400, 4)
,(@time_zone_id, 941356800, 1)
,(@time_zone_id, 954666000, 4)
,(@time_zone_id, 972806400, 1)
,(@time_zone_id, 989139600, 4)
,(@time_zone_id, 1001836800, 1)
,(@time_zone_id, 1018170000, 4)
,(@time_zone_id, 1035705600, 1)
,(@time_zone_id, 1049619600, 4)
,(@time_zone_id, 1067155200, 1)
,(@time_zone_id, 1081069200, 4)
,(@time_zone_id, 1099209600, 1)
,(@time_zone_id, 1112518800, 4)
,(@time_zone_id, 1130659200, 1)
,(@time_zone_id, 1143968400, 4)
,(@time_zone_id, 1162108800, 1)
,(@time_zone_id, 1175418000, 4)
,(@time_zone_id, 1193558400, 1)
,(@time_zone_id, 1207472400, 4)
,(@time_zone_id, 1225008000, 1)
,(@time_zone_id, 1238922000, 4)
,(@time_zone_id, 1256457600, 1)
,(@time_zone_id, 1270371600, 4)
,(@time_zone_id, 1288512000, 1)
,(@time_zone_id, 1301821200, 4)
,(@time_zone_id, 1319961600, 1)
,(@time_zone_id, 1333270800, 4)
,(@time_zone_id, 1351411200, 1)
,(@time_zone_id, 1365325200, 4)
,(@time_zone_id, 1382860800, 1)
,(@time_zone_id, 1396774800, 4)
,(@time_zone_id, 1414310400, 1)
,(@time_zone_id, 1428224400, 4)
,(@time_zone_id, 1445760000, 1)
,(@time_zone_id, 1459674000, 4)
,(@time_zone_id, 1477814400, 1)
,(@time_zone_id, 1491123600, 4)
,(@time_zone_id, 1509264000, 1)
,(@time_zone_id, 1522573200, 4)
,(@time_zone_id, 1540713600, 1)
,(@time_zone_id, 1554627600, 4)
,(@time_zone_id, 1572163200, 1)
,(@time_zone_id, 1586077200, 4)
,(@time_zone_id, 1603612800, 1)
,(@time_zone_id, 1617526800, 4)
,(@time_zone_id, 1635667200, 1)
,(@time_zone_id, 1648976400, 4)
,(@time_zone_id, 1667116800, 1)
,(@time_zone_id, 1680426000, 4)
,(@time_zone_id, 1698566400, 1)
,(@time_zone_id, 1712480400, 4)
,(@time_zone_id, 1730016000, 1)
,(@time_zone_id, 1743930000, 4)
,(@time_zone_id, 1761465600, 1)
,(@time_zone_id, 1775379600, 4)
,(@time_zone_id, 1792915200, 1)
,(@time_zone_id, 1806829200, 4)
,(@time_zone_id, 1824969600, 1)
,(@time_zone_id, 1838278800, 4)
,(@time_zone_id, 1856419200, 1)
,(@time_zone_id, 1869728400, 4)
,(@time_zone_id, 1887868800, 1)
,(@time_zone_id, 1901782800, 4)
,(@time_zone_id, 1919318400, 1)
,(@time_zone_id, 1933232400, 4)
,(@time_zone_id, 1950768000, 1)
,(@time_zone_id, 1964682000, 4)
,(@time_zone_id, 1982822400, 1)
,(@time_zone_id, 1996131600, 4)
,(@time_zone_id, 2014272000, 1)
,(@time_zone_id, 2027581200, 4)
,(@time_zone_id, 2045721600, 1)
,(@time_zone_id, 2059030800, 4)
,(@time_zone_id, 2077171200, 1)
,(@time_zone_id, 2091085200, 4)
,(@time_zone_id, 2108620800, 1)
,(@time_zone_id, 2122534800, 4)
,(@time_zone_id, 2140070400, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -25540, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -28800, 0, 'PST')
,(@time_zone_id, 4, -21600, 1, 'MDT')
,(@time_zone_id, 5, -25200, 0, 'MST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Mendoza', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 2)
,(@time_zone_id, 655963200, 3)
,(@time_zone_id, 667796400, 2)
,(@time_zone_id, 687499200, 3)
,(@time_zone_id, 699418800, 2)
,(@time_zone_id, 719380800, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1085281200, 2)
,(@time_zone_id, 1096171200, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16516, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Menominee', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633276800, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1601827200, 1)
,(@time_zone_id, -1583686800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -747244800, 1)
,(@time_zone_id, -733942800, 2)
,(@time_zone_id, -116438400, 1)
,(@time_zone_id, -100112400, 2)
,(@time_zone_id, -21484800, 5)
,(@time_zone_id, 104914800, 1)
,(@time_zone_id, 120639600, 2)
,(@time_zone_id, 126691200, 1)
,(@time_zone_id, 152089200, 2)
,(@time_zone_id, 162374400, 1)
,(@time_zone_id, 183538800, 2)
,(@time_zone_id, 199267200, 1)
,(@time_zone_id, 215593200, 2)
,(@time_zone_id, 230716800, 1)
,(@time_zone_id, 247042800, 2)
,(@time_zone_id, 262771200, 1)
,(@time_zone_id, 278492400, 2)
,(@time_zone_id, 294220800, 1)
,(@time_zone_id, 309942000, 2)
,(@time_zone_id, 325670400, 1)
,(@time_zone_id, 341391600, 2)
,(@time_zone_id, 357120000, 1)
,(@time_zone_id, 372841200, 2)
,(@time_zone_id, 388569600, 1)
,(@time_zone_id, 404895600, 2)
,(@time_zone_id, 420019200, 1)
,(@time_zone_id, 436345200, 2)
,(@time_zone_id, 452073600, 1)
,(@time_zone_id, 467794800, 2)
,(@time_zone_id, 483523200, 1)
,(@time_zone_id, 499244400, 2)
,(@time_zone_id, 514972800, 1)
,(@time_zone_id, 530694000, 2)
,(@time_zone_id, 544608000, 1)
,(@time_zone_id, 562143600, 2)
,(@time_zone_id, 576057600, 1)
,(@time_zone_id, 594198000, 2)
,(@time_zone_id, 607507200, 1)
,(@time_zone_id, 625647600, 2)
,(@time_zone_id, 638956800, 1)
,(@time_zone_id, 657097200, 2)
,(@time_zone_id, 671011200, 1)
,(@time_zone_id, 688546800, 2)
,(@time_zone_id, 702460800, 1)
,(@time_zone_id, 719996400, 2)
,(@time_zone_id, 733910400, 1)
,(@time_zone_id, 752050800, 2)
,(@time_zone_id, 765360000, 1)
,(@time_zone_id, 783500400, 2)
,(@time_zone_id, 796809600, 1)
,(@time_zone_id, 814950000, 2)
,(@time_zone_id, 828864000, 1)
,(@time_zone_id, 846399600, 2)
,(@time_zone_id, 860313600, 1)
,(@time_zone_id, 877849200, 2)
,(@time_zone_id, 891763200, 1)
,(@time_zone_id, 909298800, 2)
,(@time_zone_id, 923212800, 1)
,(@time_zone_id, 941353200, 2)
,(@time_zone_id, 954662400, 1)
,(@time_zone_id, 972802800, 2)
,(@time_zone_id, 986112000, 1)
,(@time_zone_id, 1004252400, 2)
,(@time_zone_id, 1018166400, 1)
,(@time_zone_id, 1035702000, 2)
,(@time_zone_id, 1049616000, 1)
,(@time_zone_id, 1067151600, 2)
,(@time_zone_id, 1081065600, 1)
,(@time_zone_id, 1099206000, 2)
,(@time_zone_id, 1112515200, 1)
,(@time_zone_id, 1130655600, 2)
,(@time_zone_id, 1143964800, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 1)
,(@time_zone_id, 1194159600, 2)
,(@time_zone_id, 1205049600, 1)
,(@time_zone_id, 1225609200, 2)
,(@time_zone_id, 1236499200, 1)
,(@time_zone_id, 1257058800, 2)
,(@time_zone_id, 1268553600, 1)
,(@time_zone_id, 1289113200, 2)
,(@time_zone_id, 1300003200, 1)
,(@time_zone_id, 1320562800, 2)
,(@time_zone_id, 1331452800, 1)
,(@time_zone_id, 1352012400, 2)
,(@time_zone_id, 1362902400, 1)
,(@time_zone_id, 1383462000, 2)
,(@time_zone_id, 1394352000, 1)
,(@time_zone_id, 1414911600, 2)
,(@time_zone_id, 1425801600, 1)
,(@time_zone_id, 1446361200, 2)
,(@time_zone_id, 1457856000, 1)
,(@time_zone_id, 1478415600, 2)
,(@time_zone_id, 1489305600, 1)
,(@time_zone_id, 1509865200, 2)
,(@time_zone_id, 1520755200, 1)
,(@time_zone_id, 1541314800, 2)
,(@time_zone_id, 1552204800, 1)
,(@time_zone_id, 1572764400, 2)
,(@time_zone_id, 1583654400, 1)
,(@time_zone_id, 1604214000, 2)
,(@time_zone_id, 1615708800, 1)
,(@time_zone_id, 1636268400, 2)
,(@time_zone_id, 1647158400, 1)
,(@time_zone_id, 1667718000, 2)
,(@time_zone_id, 1678608000, 1)
,(@time_zone_id, 1699167600, 2)
,(@time_zone_id, 1710057600, 1)
,(@time_zone_id, 1730617200, 2)
,(@time_zone_id, 1741507200, 1)
,(@time_zone_id, 1762066800, 2)
,(@time_zone_id, 1772956800, 1)
,(@time_zone_id, 1793516400, 2)
,(@time_zone_id, 1805011200, 1)
,(@time_zone_id, 1825570800, 2)
,(@time_zone_id, 1836460800, 1)
,(@time_zone_id, 1857020400, 2)
,(@time_zone_id, 1867910400, 1)
,(@time_zone_id, 1888470000, 2)
,(@time_zone_id, 1899360000, 1)
,(@time_zone_id, 1919919600, 2)
,(@time_zone_id, 1930809600, 1)
,(@time_zone_id, 1951369200, 2)
,(@time_zone_id, 1962864000, 1)
,(@time_zone_id, 1983423600, 2)
,(@time_zone_id, 1994313600, 1)
,(@time_zone_id, 2014873200, 2)
,(@time_zone_id, 2025763200, 1)
,(@time_zone_id, 2046322800, 2)
,(@time_zone_id, 2057212800, 1)
,(@time_zone_id, 2077772400, 2)
,(@time_zone_id, 2088662400, 1)
,(@time_zone_id, 2109222000, 2)
,(@time_zone_id, 2120112000, 1)
,(@time_zone_id, 2140671600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21027, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 0, 'EST')
,(@time_zone_id, 6, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Merida', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514743200, 1)
,(@time_zone_id, 377935200, 2)
,(@time_zone_id, 407653200, 1)
,(@time_zone_id, 828864000, 3)
,(@time_zone_id, 846399600, 1)
,(@time_zone_id, 860313600, 3)
,(@time_zone_id, 877849200, 1)
,(@time_zone_id, 891763200, 3)
,(@time_zone_id, 909298800, 1)
,(@time_zone_id, 923212800, 3)
,(@time_zone_id, 941353200, 1)
,(@time_zone_id, 954662400, 3)
,(@time_zone_id, 972802800, 1)
,(@time_zone_id, 989136000, 3)
,(@time_zone_id, 1001833200, 1)
,(@time_zone_id, 1018166400, 3)
,(@time_zone_id, 1035702000, 1)
,(@time_zone_id, 1049616000, 3)
,(@time_zone_id, 1067151600, 1)
,(@time_zone_id, 1081065600, 3)
,(@time_zone_id, 1099206000, 1)
,(@time_zone_id, 1112515200, 3)
,(@time_zone_id, 1130655600, 1)
,(@time_zone_id, 1143964800, 3)
,(@time_zone_id, 1162105200, 1)
,(@time_zone_id, 1175414400, 3)
,(@time_zone_id, 1193554800, 1)
,(@time_zone_id, 1207468800, 3)
,(@time_zone_id, 1225004400, 1)
,(@time_zone_id, 1238918400, 3)
,(@time_zone_id, 1256454000, 1)
,(@time_zone_id, 1270368000, 3)
,(@time_zone_id, 1288508400, 1)
,(@time_zone_id, 1301817600, 3)
,(@time_zone_id, 1319958000, 1)
,(@time_zone_id, 1333267200, 3)
,(@time_zone_id, 1351407600, 1)
,(@time_zone_id, 1365321600, 3)
,(@time_zone_id, 1382857200, 1)
,(@time_zone_id, 1396771200, 3)
,(@time_zone_id, 1414306800, 1)
,(@time_zone_id, 1428220800, 3)
,(@time_zone_id, 1445756400, 1)
,(@time_zone_id, 1459670400, 3)
,(@time_zone_id, 1477810800, 1)
,(@time_zone_id, 1491120000, 3)
,(@time_zone_id, 1509260400, 1)
,(@time_zone_id, 1522569600, 3)
,(@time_zone_id, 1540710000, 1)
,(@time_zone_id, 1554624000, 3)
,(@time_zone_id, 1572159600, 1)
,(@time_zone_id, 1586073600, 3)
,(@time_zone_id, 1603609200, 1)
,(@time_zone_id, 1617523200, 3)
,(@time_zone_id, 1635663600, 1)
,(@time_zone_id, 1648972800, 3)
,(@time_zone_id, 1667113200, 1)
,(@time_zone_id, 1680422400, 3)
,(@time_zone_id, 1698562800, 1)
,(@time_zone_id, 1712476800, 3)
,(@time_zone_id, 1730012400, 1)
,(@time_zone_id, 1743926400, 3)
,(@time_zone_id, 1761462000, 1)
,(@time_zone_id, 1775376000, 3)
,(@time_zone_id, 1792911600, 1)
,(@time_zone_id, 1806825600, 3)
,(@time_zone_id, 1824966000, 1)
,(@time_zone_id, 1838275200, 3)
,(@time_zone_id, 1856415600, 1)
,(@time_zone_id, 1869724800, 3)
,(@time_zone_id, 1887865200, 1)
,(@time_zone_id, 1901779200, 3)
,(@time_zone_id, 1919314800, 1)
,(@time_zone_id, 1933228800, 3)
,(@time_zone_id, 1950764400, 1)
,(@time_zone_id, 1964678400, 3)
,(@time_zone_id, 1982818800, 1)
,(@time_zone_id, 1996128000, 3)
,(@time_zone_id, 2014268400, 1)
,(@time_zone_id, 2027577600, 3)
,(@time_zone_id, 2045718000, 1)
,(@time_zone_id, 2059027200, 3)
,(@time_zone_id, 2077167600, 1)
,(@time_zone_id, 2091081600, 3)
,(@time_zone_id, 2108617200, 1)
,(@time_zone_id, 2122531200, 3)
,(@time_zone_id, 2140066800, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21508, 0, 'LMT')
,(@time_zone_id, 1, -21600, 0, 'CST')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -18000, 1, 'CDT')
,(@time_zone_id, 4, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Metlakatla', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -880207200, 2)
,(@time_zone_id, -769395600, 3)
,(@time_zone_id, -765385200, 1)
,(@time_zone_id, -21477600, 4)
,(@time_zone_id, -5756400, 1)
,(@time_zone_id, 9972000, 4)
,(@time_zone_id, 25693200, 1)
,(@time_zone_id, 41421600, 4)
,(@time_zone_id, 57747600, 1)
,(@time_zone_id, 73476000, 4)
,(@time_zone_id, 89197200, 1)
,(@time_zone_id, 104925600, 4)
,(@time_zone_id, 120646800, 1)
,(@time_zone_id, 126698400, 4)
,(@time_zone_id, 152096400, 1)
,(@time_zone_id, 162381600, 4)
,(@time_zone_id, 183546000, 1)
,(@time_zone_id, 199274400, 4)
,(@time_zone_id, 215600400, 1)
,(@time_zone_id, 230724000, 4)
,(@time_zone_id, 247050000, 1)
,(@time_zone_id, 262778400, 4)
,(@time_zone_id, 278499600, 1)
,(@time_zone_id, 294228000, 4)
,(@time_zone_id, 309949200, 1)
,(@time_zone_id, 325677600, 4)
,(@time_zone_id, 341398800, 1)
,(@time_zone_id, 357127200, 4)
,(@time_zone_id, 372848400, 1)
,(@time_zone_id, 388576800, 4)
,(@time_zone_id, 404902800, 1)
,(@time_zone_id, 420026400, 4)
,(@time_zone_id, 436352400, 1)
,(@time_zone_id, 1446372000, 5)
,(@time_zone_id, 1457866800, 6)
,(@time_zone_id, 1478426400, 5)
,(@time_zone_id, 1489316400, 6)
,(@time_zone_id, 1509876000, 5)
,(@time_zone_id, 1520766000, 6)
,(@time_zone_id, 1541325600, 1)
,(@time_zone_id, 1552215600, 6)
,(@time_zone_id, 1572775200, 5)
,(@time_zone_id, 1583665200, 6)
,(@time_zone_id, 1604224800, 5)
,(@time_zone_id, 1615719600, 6)
,(@time_zone_id, 1636279200, 5)
,(@time_zone_id, 1647169200, 6)
,(@time_zone_id, 1667728800, 5)
,(@time_zone_id, 1678618800, 6)
,(@time_zone_id, 1699178400, 5)
,(@time_zone_id, 1710068400, 6)
,(@time_zone_id, 1730628000, 5)
,(@time_zone_id, 1741518000, 6)
,(@time_zone_id, 1762077600, 5)
,(@time_zone_id, 1772967600, 6)
,(@time_zone_id, 1793527200, 5)
,(@time_zone_id, 1805022000, 6)
,(@time_zone_id, 1825581600, 5)
,(@time_zone_id, 1836471600, 6)
,(@time_zone_id, 1857031200, 5)
,(@time_zone_id, 1867921200, 6)
,(@time_zone_id, 1888480800, 5)
,(@time_zone_id, 1899370800, 6)
,(@time_zone_id, 1919930400, 5)
,(@time_zone_id, 1930820400, 6)
,(@time_zone_id, 1951380000, 5)
,(@time_zone_id, 1962874800, 6)
,(@time_zone_id, 1983434400, 5)
,(@time_zone_id, 1994324400, 6)
,(@time_zone_id, 2014884000, 5)
,(@time_zone_id, 2025774000, 6)
,(@time_zone_id, 2046333600, 5)
,(@time_zone_id, 2057223600, 6)
,(@time_zone_id, 2077783200, 5)
,(@time_zone_id, 2088673200, 6)
,(@time_zone_id, 2109232800, 5)
,(@time_zone_id, 2120122800, 6)
,(@time_zone_id, 2140682400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -31578, 0, 'LMT')
,(@time_zone_id, 1, -28800, 0, 'PST')
,(@time_zone_id, 2, -25200, 1, 'PWT')
,(@time_zone_id, 3, -25200, 1, 'PPT')
,(@time_zone_id, 4, -25200, 1, 'PDT')
,(@time_zone_id, 5, -32400, 0, 'AKST')
,(@time_zone_id, 6, -28800, 1, 'AKDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Mexico_City', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514739600, 1)
,(@time_zone_id, -1343066400, 2)
,(@time_zone_id, -1234807200, 1)
,(@time_zone_id, -1220292000, 2)
,(@time_zone_id, -1207159200, 1)
,(@time_zone_id, -1191344400, 2)
,(@time_zone_id, -975261600, 3)
,(@time_zone_id, -963169200, 2)
,(@time_zone_id, -917114400, 3)
,(@time_zone_id, -907354800, 2)
,(@time_zone_id, -821901600, 4)
,(@time_zone_id, -810068400, 2)
,(@time_zone_id, -627501600, 3)
,(@time_zone_id, -612990000, 2)
,(@time_zone_id, 828864000, 3)
,(@time_zone_id, 846399600, 2)
,(@time_zone_id, 860313600, 3)
,(@time_zone_id, 877849200, 2)
,(@time_zone_id, 891763200, 3)
,(@time_zone_id, 909298800, 2)
,(@time_zone_id, 923212800, 3)
,(@time_zone_id, 941353200, 2)
,(@time_zone_id, 954662400, 3)
,(@time_zone_id, 972802800, 2)
,(@time_zone_id, 989136000, 3)
,(@time_zone_id, 1001833200, 2)
,(@time_zone_id, 1018166400, 3)
,(@time_zone_id, 1035702000, 2)
,(@time_zone_id, 1049616000, 3)
,(@time_zone_id, 1067151600, 2)
,(@time_zone_id, 1081065600, 3)
,(@time_zone_id, 1099206000, 2)
,(@time_zone_id, 1112515200, 3)
,(@time_zone_id, 1130655600, 2)
,(@time_zone_id, 1143964800, 3)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1175414400, 3)
,(@time_zone_id, 1193554800, 2)
,(@time_zone_id, 1207468800, 3)
,(@time_zone_id, 1225004400, 2)
,(@time_zone_id, 1238918400, 3)
,(@time_zone_id, 1256454000, 2)
,(@time_zone_id, 1270368000, 3)
,(@time_zone_id, 1288508400, 2)
,(@time_zone_id, 1301817600, 3)
,(@time_zone_id, 1319958000, 2)
,(@time_zone_id, 1333267200, 3)
,(@time_zone_id, 1351407600, 2)
,(@time_zone_id, 1365321600, 3)
,(@time_zone_id, 1382857200, 2)
,(@time_zone_id, 1396771200, 3)
,(@time_zone_id, 1414306800, 2)
,(@time_zone_id, 1428220800, 3)
,(@time_zone_id, 1445756400, 2)
,(@time_zone_id, 1459670400, 3)
,(@time_zone_id, 1477810800, 2)
,(@time_zone_id, 1491120000, 3)
,(@time_zone_id, 1509260400, 2)
,(@time_zone_id, 1522569600, 3)
,(@time_zone_id, 1540710000, 2)
,(@time_zone_id, 1554624000, 3)
,(@time_zone_id, 1572159600, 2)
,(@time_zone_id, 1586073600, 3)
,(@time_zone_id, 1603609200, 2)
,(@time_zone_id, 1617523200, 3)
,(@time_zone_id, 1635663600, 2)
,(@time_zone_id, 1648972800, 3)
,(@time_zone_id, 1667113200, 2)
,(@time_zone_id, 1680422400, 3)
,(@time_zone_id, 1698562800, 2)
,(@time_zone_id, 1712476800, 3)
,(@time_zone_id, 1730012400, 2)
,(@time_zone_id, 1743926400, 3)
,(@time_zone_id, 1761462000, 2)
,(@time_zone_id, 1775376000, 3)
,(@time_zone_id, 1792911600, 2)
,(@time_zone_id, 1806825600, 3)
,(@time_zone_id, 1824966000, 2)
,(@time_zone_id, 1838275200, 3)
,(@time_zone_id, 1856415600, 2)
,(@time_zone_id, 1869724800, 3)
,(@time_zone_id, 1887865200, 2)
,(@time_zone_id, 1901779200, 3)
,(@time_zone_id, 1919314800, 2)
,(@time_zone_id, 1933228800, 3)
,(@time_zone_id, 1950764400, 2)
,(@time_zone_id, 1964678400, 3)
,(@time_zone_id, 1982818800, 2)
,(@time_zone_id, 1996128000, 3)
,(@time_zone_id, 2014268400, 2)
,(@time_zone_id, 2027577600, 3)
,(@time_zone_id, 2045718000, 2)
,(@time_zone_id, 2059027200, 3)
,(@time_zone_id, 2077167600, 2)
,(@time_zone_id, 2091081600, 3)
,(@time_zone_id, 2108617200, 2)
,(@time_zone_id, 2122531200, 3)
,(@time_zone_id, 2140066800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -23796, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CDT')
,(@time_zone_id, 4, -18000, 1, 'CWT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Miquelon', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1850328920, 1)
,(@time_zone_id, 326001600, 2)
,(@time_zone_id, 544597200, 3)
,(@time_zone_id, 562132800, 2)
,(@time_zone_id, 576046800, 3)
,(@time_zone_id, 594187200, 2)
,(@time_zone_id, 607496400, 3)
,(@time_zone_id, 625636800, 2)
,(@time_zone_id, 638946000, 3)
,(@time_zone_id, 657086400, 2)
,(@time_zone_id, 671000400, 3)
,(@time_zone_id, 688536000, 2)
,(@time_zone_id, 702450000, 3)
,(@time_zone_id, 719985600, 2)
,(@time_zone_id, 733899600, 3)
,(@time_zone_id, 752040000, 2)
,(@time_zone_id, 765349200, 3)
,(@time_zone_id, 783489600, 2)
,(@time_zone_id, 796798800, 3)
,(@time_zone_id, 814939200, 2)
,(@time_zone_id, 828853200, 3)
,(@time_zone_id, 846388800, 2)
,(@time_zone_id, 860302800, 3)
,(@time_zone_id, 877838400, 2)
,(@time_zone_id, 891752400, 3)
,(@time_zone_id, 909288000, 2)
,(@time_zone_id, 923202000, 3)
,(@time_zone_id, 941342400, 2)
,(@time_zone_id, 954651600, 3)
,(@time_zone_id, 972792000, 2)
,(@time_zone_id, 986101200, 3)
,(@time_zone_id, 1004241600, 2)
,(@time_zone_id, 1018155600, 3)
,(@time_zone_id, 1035691200, 2)
,(@time_zone_id, 1049605200, 3)
,(@time_zone_id, 1067140800, 2)
,(@time_zone_id, 1081054800, 3)
,(@time_zone_id, 1099195200, 2)
,(@time_zone_id, 1112504400, 3)
,(@time_zone_id, 1130644800, 2)
,(@time_zone_id, 1143954000, 3)
,(@time_zone_id, 1162094400, 2)
,(@time_zone_id, 1173589200, 3)
,(@time_zone_id, 1194148800, 2)
,(@time_zone_id, 1205038800, 3)
,(@time_zone_id, 1225598400, 2)
,(@time_zone_id, 1236488400, 3)
,(@time_zone_id, 1257048000, 2)
,(@time_zone_id, 1268542800, 3)
,(@time_zone_id, 1289102400, 2)
,(@time_zone_id, 1299992400, 3)
,(@time_zone_id, 1320552000, 2)
,(@time_zone_id, 1331442000, 3)
,(@time_zone_id, 1352001600, 2)
,(@time_zone_id, 1362891600, 3)
,(@time_zone_id, 1383451200, 2)
,(@time_zone_id, 1394341200, 3)
,(@time_zone_id, 1414900800, 2)
,(@time_zone_id, 1425790800, 3)
,(@time_zone_id, 1446350400, 2)
,(@time_zone_id, 1457845200, 3)
,(@time_zone_id, 1478404800, 2)
,(@time_zone_id, 1489294800, 3)
,(@time_zone_id, 1509854400, 2)
,(@time_zone_id, 1520744400, 3)
,(@time_zone_id, 1541304000, 2)
,(@time_zone_id, 1552194000, 3)
,(@time_zone_id, 1572753600, 2)
,(@time_zone_id, 1583643600, 3)
,(@time_zone_id, 1604203200, 2)
,(@time_zone_id, 1615698000, 3)
,(@time_zone_id, 1636257600, 2)
,(@time_zone_id, 1647147600, 3)
,(@time_zone_id, 1667707200, 2)
,(@time_zone_id, 1678597200, 3)
,(@time_zone_id, 1699156800, 2)
,(@time_zone_id, 1710046800, 3)
,(@time_zone_id, 1730606400, 2)
,(@time_zone_id, 1741496400, 3)
,(@time_zone_id, 1762056000, 2)
,(@time_zone_id, 1772946000, 3)
,(@time_zone_id, 1793505600, 2)
,(@time_zone_id, 1805000400, 3)
,(@time_zone_id, 1825560000, 2)
,(@time_zone_id, 1836450000, 3)
,(@time_zone_id, 1857009600, 2)
,(@time_zone_id, 1867899600, 3)
,(@time_zone_id, 1888459200, 2)
,(@time_zone_id, 1899349200, 3)
,(@time_zone_id, 1919908800, 2)
,(@time_zone_id, 1930798800, 3)
,(@time_zone_id, 1951358400, 2)
,(@time_zone_id, 1962853200, 3)
,(@time_zone_id, 1983412800, 2)
,(@time_zone_id, 1994302800, 3)
,(@time_zone_id, 2014862400, 2)
,(@time_zone_id, 2025752400, 3)
,(@time_zone_id, 2046312000, 2)
,(@time_zone_id, 2057202000, 3)
,(@time_zone_id, 2077761600, 2)
,(@time_zone_id, 2088651600, 3)
,(@time_zone_id, 2109211200, 2)
,(@time_zone_id, 2120101200, 3)
,(@time_zone_id, 2140660800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -13480, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
,(@time_zone_id, 2, -10800, 0, '-03')
,(@time_zone_id, 3, -7200, 1, '-02')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Moncton', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2131642800, 3)
,(@time_zone_id, -1632074400, 2)
,(@time_zone_id, -1615143600, 3)
,(@time_zone_id, -1153681200, 2)
,(@time_zone_id, -1145822400, 3)
,(@time_zone_id, -1122231600, 2)
,(@time_zone_id, -1114372800, 3)
,(@time_zone_id, -1090782000, 2)
,(@time_zone_id, -1082923200, 3)
,(@time_zone_id, -1059332400, 2)
,(@time_zone_id, -1051473600, 3)
,(@time_zone_id, -1027882800, 2)
,(@time_zone_id, -1020024000, 3)
,(@time_zone_id, -996433200, 2)
,(@time_zone_id, -988574400, 3)
,(@time_zone_id, -965674800, 2)
,(@time_zone_id, -955396800, 3)
,(@time_zone_id, -934743600, 2)
,(@time_zone_id, -923947200, 3)
,(@time_zone_id, -904503600, 2)
,(@time_zone_id, -891892800, 3)
,(@time_zone_id, -880221600, 4)
,(@time_zone_id, -769395600, 5)
,(@time_zone_id, -765399600, 3)
,(@time_zone_id, -747252000, 2)
,(@time_zone_id, -733950000, 3)
,(@time_zone_id, -715802400, 2)
,(@time_zone_id, -702500400, 3)
,(@time_zone_id, -684352800, 2)
,(@time_zone_id, -671050800, 3)
,(@time_zone_id, -652903200, 2)
,(@time_zone_id, -639601200, 3)
,(@time_zone_id, -620848800, 2)
,(@time_zone_id, -608151600, 3)
,(@time_zone_id, -589399200, 2)
,(@time_zone_id, -576097200, 3)
,(@time_zone_id, -557949600, 2)
,(@time_zone_id, -544647600, 3)
,(@time_zone_id, -526500000, 2)
,(@time_zone_id, -513198000, 3)
,(@time_zone_id, -495050400, 2)
,(@time_zone_id, -481748400, 3)
,(@time_zone_id, -463600800, 2)
,(@time_zone_id, -450298800, 3)
,(@time_zone_id, -431546400, 2)
,(@time_zone_id, -418244400, 3)
,(@time_zone_id, -400096800, 2)
,(@time_zone_id, -384375600, 3)
,(@time_zone_id, -368647200, 2)
,(@time_zone_id, -352926000, 3)
,(@time_zone_id, -337197600, 2)
,(@time_zone_id, -321476400, 3)
,(@time_zone_id, -305748000, 2)
,(@time_zone_id, -289422000, 3)
,(@time_zone_id, -273693600, 2)
,(@time_zone_id, -257972400, 3)
,(@time_zone_id, -242244000, 2)
,(@time_zone_id, -226522800, 3)
,(@time_zone_id, -210794400, 2)
,(@time_zone_id, -195073200, 3)
,(@time_zone_id, -179344800, 2)
,(@time_zone_id, -163623600, 3)
,(@time_zone_id, -147895200, 2)
,(@time_zone_id, -131569200, 3)
,(@time_zone_id, -116445600, 2)
,(@time_zone_id, -100119600, 3)
,(@time_zone_id, -84391200, 2)
,(@time_zone_id, -68670000, 3)
,(@time_zone_id, -52941600, 2)
,(@time_zone_id, -37220400, 3)
,(@time_zone_id, -21492000, 2)
,(@time_zone_id, -5770800, 3)
,(@time_zone_id, 9957600, 2)
,(@time_zone_id, 25678800, 3)
,(@time_zone_id, 41407200, 2)
,(@time_zone_id, 57733200, 3)
,(@time_zone_id, 73461600, 2)
,(@time_zone_id, 89182800, 3)
,(@time_zone_id, 136360800, 2)
,(@time_zone_id, 152082000, 3)
,(@time_zone_id, 167810400, 2)
,(@time_zone_id, 183531600, 3)
,(@time_zone_id, 199260000, 2)
,(@time_zone_id, 215586000, 3)
,(@time_zone_id, 230709600, 2)
,(@time_zone_id, 247035600, 3)
,(@time_zone_id, 262764000, 2)
,(@time_zone_id, 278485200, 3)
,(@time_zone_id, 294213600, 2)
,(@time_zone_id, 309934800, 3)
,(@time_zone_id, 325663200, 2)
,(@time_zone_id, 341384400, 3)
,(@time_zone_id, 357112800, 2)
,(@time_zone_id, 372834000, 3)
,(@time_zone_id, 388562400, 2)
,(@time_zone_id, 404888400, 3)
,(@time_zone_id, 420012000, 2)
,(@time_zone_id, 436338000, 3)
,(@time_zone_id, 452066400, 2)
,(@time_zone_id, 467787600, 3)
,(@time_zone_id, 483516000, 2)
,(@time_zone_id, 499237200, 3)
,(@time_zone_id, 514965600, 2)
,(@time_zone_id, 530686800, 3)
,(@time_zone_id, 544600800, 2)
,(@time_zone_id, 562136400, 3)
,(@time_zone_id, 576050400, 2)
,(@time_zone_id, 594190800, 3)
,(@time_zone_id, 607500000, 2)
,(@time_zone_id, 625640400, 3)
,(@time_zone_id, 638949600, 2)
,(@time_zone_id, 657090000, 3)
,(@time_zone_id, 671004000, 2)
,(@time_zone_id, 688539600, 3)
,(@time_zone_id, 702453600, 2)
,(@time_zone_id, 719989200, 3)
,(@time_zone_id, 733896060, 2)
,(@time_zone_id, 752036460, 3)
,(@time_zone_id, 765345660, 2)
,(@time_zone_id, 783486060, 3)
,(@time_zone_id, 796795260, 2)
,(@time_zone_id, 814935660, 3)
,(@time_zone_id, 828849660, 2)
,(@time_zone_id, 846385260, 3)
,(@time_zone_id, 860299260, 2)
,(@time_zone_id, 877834860, 3)
,(@time_zone_id, 891748860, 2)
,(@time_zone_id, 909284460, 3)
,(@time_zone_id, 923198460, 2)
,(@time_zone_id, 941338860, 3)
,(@time_zone_id, 954648060, 2)
,(@time_zone_id, 972788460, 3)
,(@time_zone_id, 986097660, 2)
,(@time_zone_id, 1004238060, 3)
,(@time_zone_id, 1018152060, 2)
,(@time_zone_id, 1035687660, 3)
,(@time_zone_id, 1049601660, 2)
,(@time_zone_id, 1067137260, 3)
,(@time_zone_id, 1081051260, 2)
,(@time_zone_id, 1099191660, 3)
,(@time_zone_id, 1112500860, 2)
,(@time_zone_id, 1130641260, 3)
,(@time_zone_id, 1143950460, 2)
,(@time_zone_id, 1162090860, 3)
,(@time_zone_id, 1173592800, 2)
,(@time_zone_id, 1194152400, 3)
,(@time_zone_id, 1205042400, 2)
,(@time_zone_id, 1225602000, 3)
,(@time_zone_id, 1236492000, 2)
,(@time_zone_id, 1257051600, 3)
,(@time_zone_id, 1268546400, 2)
,(@time_zone_id, 1289106000, 3)
,(@time_zone_id, 1299996000, 2)
,(@time_zone_id, 1320555600, 3)
,(@time_zone_id, 1331445600, 2)
,(@time_zone_id, 1352005200, 3)
,(@time_zone_id, 1362895200, 2)
,(@time_zone_id, 1383454800, 3)
,(@time_zone_id, 1394344800, 2)
,(@time_zone_id, 1414904400, 3)
,(@time_zone_id, 1425794400, 2)
,(@time_zone_id, 1446354000, 3)
,(@time_zone_id, 1457848800, 2)
,(@time_zone_id, 1478408400, 3)
,(@time_zone_id, 1489298400, 2)
,(@time_zone_id, 1509858000, 3)
,(@time_zone_id, 1520748000, 2)
,(@time_zone_id, 1541307600, 3)
,(@time_zone_id, 1552197600, 2)
,(@time_zone_id, 1572757200, 3)
,(@time_zone_id, 1583647200, 2)
,(@time_zone_id, 1604206800, 3)
,(@time_zone_id, 1615701600, 2)
,(@time_zone_id, 1636261200, 3)
,(@time_zone_id, 1647151200, 2)
,(@time_zone_id, 1667710800, 3)
,(@time_zone_id, 1678600800, 2)
,(@time_zone_id, 1699160400, 3)
,(@time_zone_id, 1710050400, 2)
,(@time_zone_id, 1730610000, 3)
,(@time_zone_id, 1741500000, 2)
,(@time_zone_id, 1762059600, 3)
,(@time_zone_id, 1772949600, 2)
,(@time_zone_id, 1793509200, 3)
,(@time_zone_id, 1805004000, 2)
,(@time_zone_id, 1825563600, 3)
,(@time_zone_id, 1836453600, 2)
,(@time_zone_id, 1857013200, 3)
,(@time_zone_id, 1867903200, 2)
,(@time_zone_id, 1888462800, 3)
,(@time_zone_id, 1899352800, 2)
,(@time_zone_id, 1919912400, 3)
,(@time_zone_id, 1930802400, 2)
,(@time_zone_id, 1951362000, 3)
,(@time_zone_id, 1962856800, 2)
,(@time_zone_id, 1983416400, 3)
,(@time_zone_id, 1994306400, 2)
,(@time_zone_id, 2014866000, 3)
,(@time_zone_id, 2025756000, 2)
,(@time_zone_id, 2046315600, 3)
,(@time_zone_id, 2057205600, 2)
,(@time_zone_id, 2077765200, 3)
,(@time_zone_id, 2088655200, 2)
,(@time_zone_id, 2109214800, 3)
,(@time_zone_id, 2120104800, 2)
,(@time_zone_id, 2140664400, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15548, 0, 'LMT')
,(@time_zone_id, 1, -18000, 0, 'EST')
,(@time_zone_id, 2, -10800, 1, 'ADT')
,(@time_zone_id, 3, -14400, 0, 'AST')
,(@time_zone_id, 4, -10800, 1, 'AWT')
,(@time_zone_id, 5, -10800, 1, 'APT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Monterrey', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514743200, 1)
,(@time_zone_id, 576057600, 2)
,(@time_zone_id, 594198000, 1)
,(@time_zone_id, 828864000, 2)
,(@time_zone_id, 846399600, 1)
,(@time_zone_id, 860313600, 2)
,(@time_zone_id, 877849200, 1)
,(@time_zone_id, 891763200, 2)
,(@time_zone_id, 909298800, 1)
,(@time_zone_id, 923212800, 2)
,(@time_zone_id, 941353200, 1)
,(@time_zone_id, 954662400, 2)
,(@time_zone_id, 972802800, 1)
,(@time_zone_id, 989136000, 2)
,(@time_zone_id, 1001833200, 1)
,(@time_zone_id, 1018166400, 2)
,(@time_zone_id, 1035702000, 1)
,(@time_zone_id, 1049616000, 2)
,(@time_zone_id, 1067151600, 1)
,(@time_zone_id, 1081065600, 2)
,(@time_zone_id, 1099206000, 1)
,(@time_zone_id, 1112515200, 2)
,(@time_zone_id, 1130655600, 1)
,(@time_zone_id, 1143964800, 2)
,(@time_zone_id, 1162105200, 1)
,(@time_zone_id, 1175414400, 2)
,(@time_zone_id, 1193554800, 1)
,(@time_zone_id, 1207468800, 2)
,(@time_zone_id, 1225004400, 1)
,(@time_zone_id, 1238918400, 2)
,(@time_zone_id, 1256454000, 1)
,(@time_zone_id, 1270368000, 2)
,(@time_zone_id, 1288508400, 1)
,(@time_zone_id, 1301817600, 2)
,(@time_zone_id, 1319958000, 1)
,(@time_zone_id, 1333267200, 2)
,(@time_zone_id, 1351407600, 1)
,(@time_zone_id, 1365321600, 2)
,(@time_zone_id, 1382857200, 1)
,(@time_zone_id, 1396771200, 2)
,(@time_zone_id, 1414306800, 1)
,(@time_zone_id, 1428220800, 2)
,(@time_zone_id, 1445756400, 1)
,(@time_zone_id, 1459670400, 2)
,(@time_zone_id, 1477810800, 1)
,(@time_zone_id, 1491120000, 2)
,(@time_zone_id, 1509260400, 1)
,(@time_zone_id, 1522569600, 2)
,(@time_zone_id, 1540710000, 1)
,(@time_zone_id, 1554624000, 2)
,(@time_zone_id, 1572159600, 1)
,(@time_zone_id, 1586073600, 2)
,(@time_zone_id, 1603609200, 1)
,(@time_zone_id, 1617523200, 2)
,(@time_zone_id, 1635663600, 1)
,(@time_zone_id, 1648972800, 2)
,(@time_zone_id, 1667113200, 1)
,(@time_zone_id, 1680422400, 2)
,(@time_zone_id, 1698562800, 1)
,(@time_zone_id, 1712476800, 2)
,(@time_zone_id, 1730012400, 1)
,(@time_zone_id, 1743926400, 2)
,(@time_zone_id, 1761462000, 1)
,(@time_zone_id, 1775376000, 2)
,(@time_zone_id, 1792911600, 1)
,(@time_zone_id, 1806825600, 2)
,(@time_zone_id, 1824966000, 1)
,(@time_zone_id, 1838275200, 2)
,(@time_zone_id, 1856415600, 1)
,(@time_zone_id, 1869724800, 2)
,(@time_zone_id, 1887865200, 1)
,(@time_zone_id, 1901779200, 2)
,(@time_zone_id, 1919314800, 1)
,(@time_zone_id, 1933228800, 2)
,(@time_zone_id, 1950764400, 1)
,(@time_zone_id, 1964678400, 2)
,(@time_zone_id, 1982818800, 1)
,(@time_zone_id, 1996128000, 2)
,(@time_zone_id, 2014268400, 1)
,(@time_zone_id, 2027577600, 2)
,(@time_zone_id, 2045718000, 1)
,(@time_zone_id, 2059027200, 2)
,(@time_zone_id, 2077167600, 1)
,(@time_zone_id, 2091081600, 2)
,(@time_zone_id, 2108617200, 1)
,(@time_zone_id, 2122531200, 2)
,(@time_zone_id, 2140066800, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -24076, 0, 'LMT')
,(@time_zone_id, 1, -21600, 0, 'CST')
,(@time_zone_id, 2, -18000, 1, 'CDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Montevideo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1942690509, 1)
,(@time_zone_id, -1567455309, 2)
,(@time_zone_id, -1459627200, 4)
,(@time_zone_id, -1443819600, 3)
,(@time_zone_id, -1428006600, 4)
,(@time_zone_id, -1412283600, 3)
,(@time_zone_id, -1396470600, 4)
,(@time_zone_id, -1380747600, 3)
,(@time_zone_id, -1141590600, 4)
,(@time_zone_id, -1128286800, 3)
,(@time_zone_id, -1110141000, 4)
,(@time_zone_id, -1096837200, 3)
,(@time_zone_id, -1078691400, 4)
,(@time_zone_id, -1065387600, 3)
,(@time_zone_id, -1047241800, 4)
,(@time_zone_id, -1033938000, 3)
,(@time_zone_id, -1015187400, 4)
,(@time_zone_id, -1002488400, 3)
,(@time_zone_id, -983737800, 4)
,(@time_zone_id, -971038800, 3)
,(@time_zone_id, -954707400, 4)
,(@time_zone_id, -938984400, 3)
,(@time_zone_id, -920838600, 4)
,(@time_zone_id, -907534800, 3)
,(@time_zone_id, -896819400, 4)
,(@time_zone_id, -853621200, 6)
,(@time_zone_id, -845847000, 5)
,(@time_zone_id, -334789200, 6)
,(@time_zone_id, -319671000, 5)
,(@time_zone_id, -314226000, 7)
,(@time_zone_id, -309996000, 5)
,(@time_zone_id, -149720400, 7)
,(@time_zone_id, -134604000, 5)
,(@time_zone_id, -50446800, 6)
,(@time_zone_id, -34205400, 5)
,(@time_zone_id, 9860400, 7)
,(@time_zone_id, 14176800, 5)
,(@time_zone_id, 72846000, 7)
,(@time_zone_id, 80100000, 5)
,(@time_zone_id, 127278000, 8)
,(@time_zone_id, 132111000, 6)
,(@time_zone_id, 147234600, 5)
,(@time_zone_id, 156913200, 7)
,(@time_zone_id, 165376800, 5)
,(@time_zone_id, 219812400, 7)
,(@time_zone_id, 226461600, 5)
,(@time_zone_id, 250052400, 7)
,(@time_zone_id, 257911200, 5)
,(@time_zone_id, 282711600, 7)
,(@time_zone_id, 289360800, 5)
,(@time_zone_id, 294202800, 7)
,(@time_zone_id, 322020000, 5)
,(@time_zone_id, 566449200, 7)
,(@time_zone_id, 573012000, 5)
,(@time_zone_id, 597812400, 7)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 625633200, 7)
,(@time_zone_id, 635911200, 5)
,(@time_zone_id, 656478000, 7)
,(@time_zone_id, 667965600, 5)
,(@time_zone_id, 688532400, 7)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 7)
,(@time_zone_id, 730864800, 5)
,(@time_zone_id, 1095562800, 7)
,(@time_zone_id, 1111896000, 5)
,(@time_zone_id, 1128834000, 7)
,(@time_zone_id, 1142136000, 5)
,(@time_zone_id, 1159678800, 7)
,(@time_zone_id, 1173585600, 5)
,(@time_zone_id, 1191733200, 7)
,(@time_zone_id, 1205035200, 5)
,(@time_zone_id, 1223182800, 7)
,(@time_zone_id, 1236484800, 5)
,(@time_zone_id, 1254632400, 7)
,(@time_zone_id, 1268539200, 5)
,(@time_zone_id, 1286082000, 7)
,(@time_zone_id, 1299988800, 5)
,(@time_zone_id, 1317531600, 7)
,(@time_zone_id, 1331438400, 5)
,(@time_zone_id, 1349586000, 7)
,(@time_zone_id, 1362888000, 5)
,(@time_zone_id, 1381035600, 7)
,(@time_zone_id, 1394337600, 5)
,(@time_zone_id, 1412485200, 7)
,(@time_zone_id, 1425787200, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -13491, 0, 'LMT')
,(@time_zone_id, 1, -13491, 0, 'MMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -12600, 0, '-0330')
,(@time_zone_id, 4, -10800, 1, '-03')
,(@time_zone_id, 5, -10800, 0, '-03')
,(@time_zone_id, 6, -9000, 1, '-0230')
,(@time_zone_id, 7, -7200, 1, '-02')
,(@time_zone_id, 8, -5400, 1, '-0130')
,(@time_zone_id, 9, -7200, 1, '-02')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Montreal', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632070800, 1)
,(@time_zone_id, -1615140000, 2)
,(@time_zone_id, -1601753400, 1)
,(@time_zone_id, -1583697600, 2)
,(@time_zone_id, -1567357200, 1)
,(@time_zone_id, -1554667200, 2)
,(@time_zone_id, -1534698000, 1)
,(@time_zone_id, -1524074400, 2)
,(@time_zone_id, -1503248400, 1)
,(@time_zone_id, -1492365600, 2)
,(@time_zone_id, -1471798800, 1)
,(@time_zone_id, -1460916000, 2)
,(@time_zone_id, -1440954000, 1)
,(@time_zone_id, -1428861600, 2)
,(@time_zone_id, -1409504400, 1)
,(@time_zone_id, -1397412000, 2)
,(@time_zone_id, -1378054800, 1)
,(@time_zone_id, -1365962400, 2)
,(@time_zone_id, -1346605200, 1)
,(@time_zone_id, -1333908000, 2)
,(@time_zone_id, -1315155600, 1)
,(@time_zone_id, -1301853600, 2)
,(@time_zone_id, -1283706000, 1)
,(@time_zone_id, -1270404000, 2)
,(@time_zone_id, -1252256400, 1)
,(@time_zone_id, -1238954400, 2)
,(@time_zone_id, -1220806800, 1)
,(@time_zone_id, -1207504800, 2)
,(@time_zone_id, -1188752400, 1)
,(@time_zone_id, -1176055200, 2)
,(@time_zone_id, -1157302800, 1)
,(@time_zone_id, -1144000800, 2)
,(@time_zone_id, -1125853200, 1)
,(@time_zone_id, -1112551200, 2)
,(@time_zone_id, -1094403600, 1)
,(@time_zone_id, -1081101600, 2)
,(@time_zone_id, -1062954000, 1)
,(@time_zone_id, -1049652000, 2)
,(@time_zone_id, -1031504400, 1)
,(@time_zone_id, -1018202400, 2)
,(@time_zone_id, -1000054800, 1)
,(@time_zone_id, -986752800, 2)
,(@time_zone_id, -968000400, 1)
,(@time_zone_id, -955303200, 2)
,(@time_zone_id, -936550800, 1)
,(@time_zone_id, -880218000, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765396000, 2)
,(@time_zone_id, -747248400, 1)
,(@time_zone_id, -733946400, 2)
,(@time_zone_id, -715806000, 1)
,(@time_zone_id, -702504000, 2)
,(@time_zone_id, -684356400, 1)
,(@time_zone_id, -671054400, 2)
,(@time_zone_id, -652906800, 1)
,(@time_zone_id, -634161600, 2)
,(@time_zone_id, -620845200, 1)
,(@time_zone_id, -602704800, 2)
,(@time_zone_id, -589395600, 1)
,(@time_zone_id, -576093600, 2)
,(@time_zone_id, -557946000, 1)
,(@time_zone_id, -544644000, 2)
,(@time_zone_id, -526496400, 1)
,(@time_zone_id, -513194400, 2)
,(@time_zone_id, -495046800, 1)
,(@time_zone_id, -481744800, 2)
,(@time_zone_id, -463597200, 1)
,(@time_zone_id, -450295200, 2)
,(@time_zone_id, -431542800, 1)
,(@time_zone_id, -418240800, 2)
,(@time_zone_id, -400093200, 1)
,(@time_zone_id, -384372000, 2)
,(@time_zone_id, -368643600, 1)
,(@time_zone_id, -352922400, 2)
,(@time_zone_id, -337194000, 1)
,(@time_zone_id, -321472800, 2)
,(@time_zone_id, -305744400, 1)
,(@time_zone_id, -289418400, 2)
,(@time_zone_id, -273690000, 1)
,(@time_zone_id, -257968800, 2)
,(@time_zone_id, -242240400, 1)
,(@time_zone_id, -226519200, 2)
,(@time_zone_id, -210790800, 1)
,(@time_zone_id, -195069600, 2)
,(@time_zone_id, -179341200, 1)
,(@time_zone_id, -163620000, 2)
,(@time_zone_id, -147891600, 1)
,(@time_zone_id, -131565600, 2)
,(@time_zone_id, -116442000, 1)
,(@time_zone_id, -100116000, 2)
,(@time_zone_id, -84387600, 1)
,(@time_zone_id, -68666400, 2)
,(@time_zone_id, -52938000, 1)
,(@time_zone_id, -37216800, 2)
,(@time_zone_id, -21488400, 1)
,(@time_zone_id, -5767200, 2)
,(@time_zone_id, 9961200, 1)
,(@time_zone_id, 25682400, 2)
,(@time_zone_id, 41410800, 1)
,(@time_zone_id, 57736800, 2)
,(@time_zone_id, 73465200, 1)
,(@time_zone_id, 89186400, 2)
,(@time_zone_id, 104914800, 1)
,(@time_zone_id, 120636000, 2)
,(@time_zone_id, 136364400, 1)
,(@time_zone_id, 152085600, 2)
,(@time_zone_id, 167814000, 1)
,(@time_zone_id, 183535200, 2)
,(@time_zone_id, 199263600, 1)
,(@time_zone_id, 215589600, 2)
,(@time_zone_id, 230713200, 1)
,(@time_zone_id, 247039200, 2)
,(@time_zone_id, 262767600, 1)
,(@time_zone_id, 278488800, 2)
,(@time_zone_id, 294217200, 1)
,(@time_zone_id, 309938400, 2)
,(@time_zone_id, 325666800, 1)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 1)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 1)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 1)
,(@time_zone_id, 436341600, 2)
,(@time_zone_id, 452070000, 1)
,(@time_zone_id, 467791200, 2)
,(@time_zone_id, 483519600, 1)
,(@time_zone_id, 499240800, 2)
,(@time_zone_id, 514969200, 1)
,(@time_zone_id, 530690400, 2)
,(@time_zone_id, 544604400, 1)
,(@time_zone_id, 562140000, 2)
,(@time_zone_id, 576054000, 1)
,(@time_zone_id, 594194400, 2)
,(@time_zone_id, 607503600, 1)
,(@time_zone_id, 625644000, 2)
,(@time_zone_id, 638953200, 1)
,(@time_zone_id, 657093600, 2)
,(@time_zone_id, 671007600, 1)
,(@time_zone_id, 688543200, 2)
,(@time_zone_id, 702457200, 1)
,(@time_zone_id, 719992800, 2)
,(@time_zone_id, 733906800, 1)
,(@time_zone_id, 752047200, 2)
,(@time_zone_id, 765356400, 1)
,(@time_zone_id, 783496800, 2)
,(@time_zone_id, 796806000, 1)
,(@time_zone_id, 814946400, 2)
,(@time_zone_id, 828860400, 1)
,(@time_zone_id, 846396000, 2)
,(@time_zone_id, 860310000, 1)
,(@time_zone_id, 877845600, 2)
,(@time_zone_id, 891759600, 1)
,(@time_zone_id, 909295200, 2)
,(@time_zone_id, 923209200, 1)
,(@time_zone_id, 941349600, 2)
,(@time_zone_id, 954658800, 1)
,(@time_zone_id, 972799200, 2)
,(@time_zone_id, 986108400, 1)
,(@time_zone_id, 1004248800, 2)
,(@time_zone_id, 1018162800, 1)
,(@time_zone_id, 1035698400, 2)
,(@time_zone_id, 1049612400, 1)
,(@time_zone_id, 1067148000, 2)
,(@time_zone_id, 1081062000, 1)
,(@time_zone_id, 1099202400, 2)
,(@time_zone_id, 1112511600, 1)
,(@time_zone_id, 1130652000, 2)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162101600, 2)
,(@time_zone_id, 1173596400, 1)
,(@time_zone_id, 1194156000, 2)
,(@time_zone_id, 1205046000, 1)
,(@time_zone_id, 1225605600, 2)
,(@time_zone_id, 1236495600, 1)
,(@time_zone_id, 1257055200, 2)
,(@time_zone_id, 1268550000, 1)
,(@time_zone_id, 1289109600, 2)
,(@time_zone_id, 1299999600, 1)
,(@time_zone_id, 1320559200, 2)
,(@time_zone_id, 1331449200, 1)
,(@time_zone_id, 1352008800, 2)
,(@time_zone_id, 1362898800, 1)
,(@time_zone_id, 1383458400, 2)
,(@time_zone_id, 1394348400, 1)
,(@time_zone_id, 1414908000, 2)
,(@time_zone_id, 1425798000, 1)
,(@time_zone_id, 1446357600, 2)
,(@time_zone_id, 1457852400, 1)
,(@time_zone_id, 1478412000, 2)
,(@time_zone_id, 1489302000, 1)
,(@time_zone_id, 1509861600, 2)
,(@time_zone_id, 1520751600, 1)
,(@time_zone_id, 1541311200, 2)
,(@time_zone_id, 1552201200, 1)
,(@time_zone_id, 1572760800, 2)
,(@time_zone_id, 1583650800, 1)
,(@time_zone_id, 1604210400, 2)
,(@time_zone_id, 1615705200, 1)
,(@time_zone_id, 1636264800, 2)
,(@time_zone_id, 1647154800, 1)
,(@time_zone_id, 1667714400, 2)
,(@time_zone_id, 1678604400, 1)
,(@time_zone_id, 1699164000, 2)
,(@time_zone_id, 1710054000, 1)
,(@time_zone_id, 1730613600, 2)
,(@time_zone_id, 1741503600, 1)
,(@time_zone_id, 1762063200, 2)
,(@time_zone_id, 1772953200, 1)
,(@time_zone_id, 1793512800, 2)
,(@time_zone_id, 1805007600, 1)
,(@time_zone_id, 1825567200, 2)
,(@time_zone_id, 1836457200, 1)
,(@time_zone_id, 1857016800, 2)
,(@time_zone_id, 1867906800, 1)
,(@time_zone_id, 1888466400, 2)
,(@time_zone_id, 1899356400, 1)
,(@time_zone_id, 1919916000, 2)
,(@time_zone_id, 1930806000, 1)
,(@time_zone_id, 1951365600, 2)
,(@time_zone_id, 1962860400, 1)
,(@time_zone_id, 1983420000, 2)
,(@time_zone_id, 1994310000, 1)
,(@time_zone_id, 2014869600, 2)
,(@time_zone_id, 2025759600, 1)
,(@time_zone_id, 2046319200, 2)
,(@time_zone_id, 2057209200, 1)
,(@time_zone_id, 2077768800, 2)
,(@time_zone_id, 2088658800, 1)
,(@time_zone_id, 2109218400, 2)
,(@time_zone_id, 2120108400, 1)
,(@time_zone_id, 2140668000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -19052, 0, 'LMT')
,(@time_zone_id, 1, -14400, 1, 'EDT')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -14400, 1, 'EWT')
,(@time_zone_id, 4, -14400, 1, 'EPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Montserrat', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Nassau', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825095030, 2)
,(@time_zone_id, -179341200, 1)
,(@time_zone_id, -163620000, 2)
,(@time_zone_id, -147891600, 1)
,(@time_zone_id, -131565600, 2)
,(@time_zone_id, -116442000, 1)
,(@time_zone_id, -100116000, 2)
,(@time_zone_id, -84387600, 1)
,(@time_zone_id, -68666400, 2)
,(@time_zone_id, -52938000, 1)
,(@time_zone_id, -37216800, 2)
,(@time_zone_id, -21488400, 1)
,(@time_zone_id, -5767200, 2)
,(@time_zone_id, 9961200, 1)
,(@time_zone_id, 25682400, 2)
,(@time_zone_id, 41410800, 1)
,(@time_zone_id, 57736800, 2)
,(@time_zone_id, 73465200, 1)
,(@time_zone_id, 89186400, 2)
,(@time_zone_id, 104914800, 1)
,(@time_zone_id, 120636000, 2)
,(@time_zone_id, 136364400, 1)
,(@time_zone_id, 152085600, 2)
,(@time_zone_id, 167814000, 1)
,(@time_zone_id, 183535200, 2)
,(@time_zone_id, 199263600, 1)
,(@time_zone_id, 215589600, 2)
,(@time_zone_id, 230713200, 1)
,(@time_zone_id, 247039200, 2)
,(@time_zone_id, 262767600, 1)
,(@time_zone_id, 278488800, 2)
,(@time_zone_id, 294217200, 1)
,(@time_zone_id, 309938400, 2)
,(@time_zone_id, 325666800, 1)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 1)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 1)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 1)
,(@time_zone_id, 436341600, 2)
,(@time_zone_id, 452070000, 1)
,(@time_zone_id, 467791200, 2)
,(@time_zone_id, 483519600, 1)
,(@time_zone_id, 499240800, 2)
,(@time_zone_id, 514969200, 1)
,(@time_zone_id, 530690400, 2)
,(@time_zone_id, 544604400, 1)
,(@time_zone_id, 562140000, 2)
,(@time_zone_id, 576054000, 1)
,(@time_zone_id, 594194400, 2)
,(@time_zone_id, 607503600, 1)
,(@time_zone_id, 625644000, 2)
,(@time_zone_id, 638953200, 1)
,(@time_zone_id, 657093600, 2)
,(@time_zone_id, 671007600, 1)
,(@time_zone_id, 688543200, 2)
,(@time_zone_id, 702457200, 1)
,(@time_zone_id, 719992800, 2)
,(@time_zone_id, 733906800, 1)
,(@time_zone_id, 752047200, 2)
,(@time_zone_id, 765356400, 1)
,(@time_zone_id, 783496800, 2)
,(@time_zone_id, 796806000, 1)
,(@time_zone_id, 814946400, 2)
,(@time_zone_id, 828860400, 1)
,(@time_zone_id, 846396000, 2)
,(@time_zone_id, 860310000, 1)
,(@time_zone_id, 877845600, 2)
,(@time_zone_id, 891759600, 1)
,(@time_zone_id, 909295200, 2)
,(@time_zone_id, 923209200, 1)
,(@time_zone_id, 941349600, 2)
,(@time_zone_id, 954658800, 1)
,(@time_zone_id, 972799200, 2)
,(@time_zone_id, 986108400, 1)
,(@time_zone_id, 1004248800, 2)
,(@time_zone_id, 1018162800, 1)
,(@time_zone_id, 1035698400, 2)
,(@time_zone_id, 1049612400, 1)
,(@time_zone_id, 1067148000, 2)
,(@time_zone_id, 1081062000, 1)
,(@time_zone_id, 1099202400, 2)
,(@time_zone_id, 1112511600, 1)
,(@time_zone_id, 1130652000, 2)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162101600, 2)
,(@time_zone_id, 1173596400, 1)
,(@time_zone_id, 1194156000, 2)
,(@time_zone_id, 1205046000, 1)
,(@time_zone_id, 1225605600, 2)
,(@time_zone_id, 1236495600, 1)
,(@time_zone_id, 1257055200, 2)
,(@time_zone_id, 1268550000, 1)
,(@time_zone_id, 1289109600, 2)
,(@time_zone_id, 1299999600, 1)
,(@time_zone_id, 1320559200, 2)
,(@time_zone_id, 1331449200, 1)
,(@time_zone_id, 1352008800, 2)
,(@time_zone_id, 1362898800, 1)
,(@time_zone_id, 1383458400, 2)
,(@time_zone_id, 1394348400, 1)
,(@time_zone_id, 1414908000, 2)
,(@time_zone_id, 1425798000, 1)
,(@time_zone_id, 1446357600, 2)
,(@time_zone_id, 1457852400, 1)
,(@time_zone_id, 1478412000, 2)
,(@time_zone_id, 1489302000, 1)
,(@time_zone_id, 1509861600, 2)
,(@time_zone_id, 1520751600, 1)
,(@time_zone_id, 1541311200, 2)
,(@time_zone_id, 1552201200, 1)
,(@time_zone_id, 1572760800, 2)
,(@time_zone_id, 1583650800, 1)
,(@time_zone_id, 1604210400, 2)
,(@time_zone_id, 1615705200, 1)
,(@time_zone_id, 1636264800, 2)
,(@time_zone_id, 1647154800, 1)
,(@time_zone_id, 1667714400, 2)
,(@time_zone_id, 1678604400, 1)
,(@time_zone_id, 1699164000, 2)
,(@time_zone_id, 1710054000, 1)
,(@time_zone_id, 1730613600, 2)
,(@time_zone_id, 1741503600, 1)
,(@time_zone_id, 1762063200, 2)
,(@time_zone_id, 1772953200, 1)
,(@time_zone_id, 1793512800, 2)
,(@time_zone_id, 1805007600, 1)
,(@time_zone_id, 1825567200, 2)
,(@time_zone_id, 1836457200, 1)
,(@time_zone_id, 1857016800, 2)
,(@time_zone_id, 1867906800, 1)
,(@time_zone_id, 1888466400, 2)
,(@time_zone_id, 1899356400, 1)
,(@time_zone_id, 1919916000, 2)
,(@time_zone_id, 1930806000, 1)
,(@time_zone_id, 1951365600, 2)
,(@time_zone_id, 1962860400, 1)
,(@time_zone_id, 1983420000, 2)
,(@time_zone_id, 1994310000, 1)
,(@time_zone_id, 2014869600, 2)
,(@time_zone_id, 2025759600, 1)
,(@time_zone_id, 2046319200, 2)
,(@time_zone_id, 2057209200, 1)
,(@time_zone_id, 2077768800, 2)
,(@time_zone_id, 2088658800, 1)
,(@time_zone_id, 2109218400, 2)
,(@time_zone_id, 2120108400, 1)
,(@time_zone_id, 2140668000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -18570, 0, 'LMT')
,(@time_zone_id, 1, -14400, 1, 'EDT')
,(@time_zone_id, 2, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/New_York', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633280400, 1)
,(@time_zone_id, -1615140000, 2)
,(@time_zone_id, -1601830800, 1)
,(@time_zone_id, -1583690400, 2)
,(@time_zone_id, -1570381200, 1)
,(@time_zone_id, -1551636000, 2)
,(@time_zone_id, -1536512400, 1)
,(@time_zone_id, -1523210400, 2)
,(@time_zone_id, -1504458000, 1)
,(@time_zone_id, -1491760800, 2)
,(@time_zone_id, -1473008400, 1)
,(@time_zone_id, -1459706400, 2)
,(@time_zone_id, -1441558800, 1)
,(@time_zone_id, -1428256800, 2)
,(@time_zone_id, -1410109200, 1)
,(@time_zone_id, -1396807200, 2)
,(@time_zone_id, -1378659600, 1)
,(@time_zone_id, -1365357600, 2)
,(@time_zone_id, -1347210000, 1)
,(@time_zone_id, -1333908000, 2)
,(@time_zone_id, -1315155600, 1)
,(@time_zone_id, -1301853600, 2)
,(@time_zone_id, -1283706000, 1)
,(@time_zone_id, -1270404000, 2)
,(@time_zone_id, -1252256400, 1)
,(@time_zone_id, -1238954400, 2)
,(@time_zone_id, -1220806800, 1)
,(@time_zone_id, -1207504800, 2)
,(@time_zone_id, -1189357200, 1)
,(@time_zone_id, -1176055200, 2)
,(@time_zone_id, -1157302800, 1)
,(@time_zone_id, -1144605600, 2)
,(@time_zone_id, -1125853200, 1)
,(@time_zone_id, -1112551200, 2)
,(@time_zone_id, -1094403600, 1)
,(@time_zone_id, -1081101600, 2)
,(@time_zone_id, -1062954000, 1)
,(@time_zone_id, -1049652000, 2)
,(@time_zone_id, -1031504400, 1)
,(@time_zone_id, -1018202400, 2)
,(@time_zone_id, -1000054800, 1)
,(@time_zone_id, -986752800, 2)
,(@time_zone_id, -968000400, 1)
,(@time_zone_id, -955303200, 2)
,(@time_zone_id, -936550800, 1)
,(@time_zone_id, -923248800, 2)
,(@time_zone_id, -905101200, 1)
,(@time_zone_id, -891799200, 2)
,(@time_zone_id, -880218000, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765396000, 2)
,(@time_zone_id, -747248400, 1)
,(@time_zone_id, -733946400, 2)
,(@time_zone_id, -715798800, 1)
,(@time_zone_id, -702496800, 2)
,(@time_zone_id, -684349200, 1)
,(@time_zone_id, -671047200, 2)
,(@time_zone_id, -652899600, 1)
,(@time_zone_id, -639597600, 2)
,(@time_zone_id, -620845200, 1)
,(@time_zone_id, -608148000, 2)
,(@time_zone_id, -589395600, 1)
,(@time_zone_id, -576093600, 2)
,(@time_zone_id, -557946000, 1)
,(@time_zone_id, -544644000, 2)
,(@time_zone_id, -526496400, 1)
,(@time_zone_id, -513194400, 2)
,(@time_zone_id, -495046800, 1)
,(@time_zone_id, -481744800, 2)
,(@time_zone_id, -463597200, 1)
,(@time_zone_id, -447271200, 2)
,(@time_zone_id, -431542800, 1)
,(@time_zone_id, -415821600, 2)
,(@time_zone_id, -400093200, 1)
,(@time_zone_id, -384372000, 2)
,(@time_zone_id, -368643600, 1)
,(@time_zone_id, -352922400, 2)
,(@time_zone_id, -337194000, 1)
,(@time_zone_id, -321472800, 2)
,(@time_zone_id, -305744400, 1)
,(@time_zone_id, -289418400, 2)
,(@time_zone_id, -273690000, 1)
,(@time_zone_id, -257968800, 2)
,(@time_zone_id, -242240400, 1)
,(@time_zone_id, -226519200, 2)
,(@time_zone_id, -210790800, 1)
,(@time_zone_id, -195069600, 2)
,(@time_zone_id, -179341200, 1)
,(@time_zone_id, -163620000, 2)
,(@time_zone_id, -147891600, 1)
,(@time_zone_id, -131565600, 2)
,(@time_zone_id, -116442000, 1)
,(@time_zone_id, -100116000, 2)
,(@time_zone_id, -84387600, 1)
,(@time_zone_id, -68666400, 2)
,(@time_zone_id, -52938000, 1)
,(@time_zone_id, -37216800, 2)
,(@time_zone_id, -21488400, 1)
,(@time_zone_id, -5767200, 2)
,(@time_zone_id, 9961200, 1)
,(@time_zone_id, 25682400, 2)
,(@time_zone_id, 41410800, 1)
,(@time_zone_id, 57736800, 2)
,(@time_zone_id, 73465200, 1)
,(@time_zone_id, 89186400, 2)
,(@time_zone_id, 104914800, 1)
,(@time_zone_id, 120636000, 2)
,(@time_zone_id, 126687600, 1)
,(@time_zone_id, 152085600, 2)
,(@time_zone_id, 162370800, 1)
,(@time_zone_id, 183535200, 2)
,(@time_zone_id, 199263600, 1)
,(@time_zone_id, 215589600, 2)
,(@time_zone_id, 230713200, 1)
,(@time_zone_id, 247039200, 2)
,(@time_zone_id, 262767600, 1)
,(@time_zone_id, 278488800, 2)
,(@time_zone_id, 294217200, 1)
,(@time_zone_id, 309938400, 2)
,(@time_zone_id, 325666800, 1)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 1)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 1)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 1)
,(@time_zone_id, 436341600, 2)
,(@time_zone_id, 452070000, 1)
,(@time_zone_id, 467791200, 2)
,(@time_zone_id, 483519600, 1)
,(@time_zone_id, 499240800, 2)
,(@time_zone_id, 514969200, 1)
,(@time_zone_id, 530690400, 2)
,(@time_zone_id, 544604400, 1)
,(@time_zone_id, 562140000, 2)
,(@time_zone_id, 576054000, 1)
,(@time_zone_id, 594194400, 2)
,(@time_zone_id, 607503600, 1)
,(@time_zone_id, 625644000, 2)
,(@time_zone_id, 638953200, 1)
,(@time_zone_id, 657093600, 2)
,(@time_zone_id, 671007600, 1)
,(@time_zone_id, 688543200, 2)
,(@time_zone_id, 702457200, 1)
,(@time_zone_id, 719992800, 2)
,(@time_zone_id, 733906800, 1)
,(@time_zone_id, 752047200, 2)
,(@time_zone_id, 765356400, 1)
,(@time_zone_id, 783496800, 2)
,(@time_zone_id, 796806000, 1)
,(@time_zone_id, 814946400, 2)
,(@time_zone_id, 828860400, 1)
,(@time_zone_id, 846396000, 2)
,(@time_zone_id, 860310000, 1)
,(@time_zone_id, 877845600, 2)
,(@time_zone_id, 891759600, 1)
,(@time_zone_id, 909295200, 2)
,(@time_zone_id, 923209200, 1)
,(@time_zone_id, 941349600, 2)
,(@time_zone_id, 954658800, 1)
,(@time_zone_id, 972799200, 2)
,(@time_zone_id, 986108400, 1)
,(@time_zone_id, 1004248800, 2)
,(@time_zone_id, 1018162800, 1)
,(@time_zone_id, 1035698400, 2)
,(@time_zone_id, 1049612400, 1)
,(@time_zone_id, 1067148000, 2)
,(@time_zone_id, 1081062000, 1)
,(@time_zone_id, 1099202400, 2)
,(@time_zone_id, 1112511600, 1)
,(@time_zone_id, 1130652000, 2)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162101600, 2)
,(@time_zone_id, 1173596400, 1)
,(@time_zone_id, 1194156000, 2)
,(@time_zone_id, 1205046000, 1)
,(@time_zone_id, 1225605600, 2)
,(@time_zone_id, 1236495600, 1)
,(@time_zone_id, 1257055200, 2)
,(@time_zone_id, 1268550000, 1)
,(@time_zone_id, 1289109600, 2)
,(@time_zone_id, 1299999600, 1)
,(@time_zone_id, 1320559200, 2)
,(@time_zone_id, 1331449200, 1)
,(@time_zone_id, 1352008800, 2)
,(@time_zone_id, 1362898800, 1)
,(@time_zone_id, 1383458400, 2)
,(@time_zone_id, 1394348400, 1)
,(@time_zone_id, 1414908000, 2)
,(@time_zone_id, 1425798000, 1)
,(@time_zone_id, 1446357600, 2)
,(@time_zone_id, 1457852400, 1)
,(@time_zone_id, 1478412000, 2)
,(@time_zone_id, 1489302000, 1)
,(@time_zone_id, 1509861600, 2)
,(@time_zone_id, 1520751600, 1)
,(@time_zone_id, 1541311200, 2)
,(@time_zone_id, 1552201200, 1)
,(@time_zone_id, 1572760800, 2)
,(@time_zone_id, 1583650800, 1)
,(@time_zone_id, 1604210400, 2)
,(@time_zone_id, 1615705200, 1)
,(@time_zone_id, 1636264800, 2)
,(@time_zone_id, 1647154800, 1)
,(@time_zone_id, 1667714400, 2)
,(@time_zone_id, 1678604400, 1)
,(@time_zone_id, 1699164000, 2)
,(@time_zone_id, 1710054000, 1)
,(@time_zone_id, 1730613600, 2)
,(@time_zone_id, 1741503600, 1)
,(@time_zone_id, 1762063200, 2)
,(@time_zone_id, 1772953200, 1)
,(@time_zone_id, 1793512800, 2)
,(@time_zone_id, 1805007600, 1)
,(@time_zone_id, 1825567200, 2)
,(@time_zone_id, 1836457200, 1)
,(@time_zone_id, 1857016800, 2)
,(@time_zone_id, 1867906800, 1)
,(@time_zone_id, 1888466400, 2)
,(@time_zone_id, 1899356400, 1)
,(@time_zone_id, 1919916000, 2)
,(@time_zone_id, 1930806000, 1)
,(@time_zone_id, 1951365600, 2)
,(@time_zone_id, 1962860400, 1)
,(@time_zone_id, 1983420000, 2)
,(@time_zone_id, 1994310000, 1)
,(@time_zone_id, 2014869600, 2)
,(@time_zone_id, 2025759600, 1)
,(@time_zone_id, 2046319200, 2)
,(@time_zone_id, 2057209200, 1)
,(@time_zone_id, 2077768800, 2)
,(@time_zone_id, 2088658800, 1)
,(@time_zone_id, 2109218400, 2)
,(@time_zone_id, 2120108400, 1)
,(@time_zone_id, 2140668000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -17762, 0, 'LMT')
,(@time_zone_id, 1, -14400, 1, 'EDT')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -14400, 1, 'EWT')
,(@time_zone_id, 4, -14400, 1, 'EPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Nipigon', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632070800, 1)
,(@time_zone_id, -1615140000, 2)
,(@time_zone_id, -923252400, 1)
,(@time_zone_id, -880218000, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765396000, 2)
,(@time_zone_id, 136364400, 1)
,(@time_zone_id, 152085600, 2)
,(@time_zone_id, 167814000, 1)
,(@time_zone_id, 183535200, 2)
,(@time_zone_id, 199263600, 1)
,(@time_zone_id, 215589600, 2)
,(@time_zone_id, 230713200, 1)
,(@time_zone_id, 247039200, 2)
,(@time_zone_id, 262767600, 1)
,(@time_zone_id, 278488800, 2)
,(@time_zone_id, 294217200, 1)
,(@time_zone_id, 309938400, 2)
,(@time_zone_id, 325666800, 1)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 1)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 1)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 1)
,(@time_zone_id, 436341600, 2)
,(@time_zone_id, 452070000, 1)
,(@time_zone_id, 467791200, 2)
,(@time_zone_id, 483519600, 1)
,(@time_zone_id, 499240800, 2)
,(@time_zone_id, 514969200, 1)
,(@time_zone_id, 530690400, 2)
,(@time_zone_id, 544604400, 1)
,(@time_zone_id, 562140000, 2)
,(@time_zone_id, 576054000, 1)
,(@time_zone_id, 594194400, 2)
,(@time_zone_id, 607503600, 1)
,(@time_zone_id, 625644000, 2)
,(@time_zone_id, 638953200, 1)
,(@time_zone_id, 657093600, 2)
,(@time_zone_id, 671007600, 1)
,(@time_zone_id, 688543200, 2)
,(@time_zone_id, 702457200, 1)
,(@time_zone_id, 719992800, 2)
,(@time_zone_id, 733906800, 1)
,(@time_zone_id, 752047200, 2)
,(@time_zone_id, 765356400, 1)
,(@time_zone_id, 783496800, 2)
,(@time_zone_id, 796806000, 1)
,(@time_zone_id, 814946400, 2)
,(@time_zone_id, 828860400, 1)
,(@time_zone_id, 846396000, 2)
,(@time_zone_id, 860310000, 1)
,(@time_zone_id, 877845600, 2)
,(@time_zone_id, 891759600, 1)
,(@time_zone_id, 909295200, 2)
,(@time_zone_id, 923209200, 1)
,(@time_zone_id, 941349600, 2)
,(@time_zone_id, 954658800, 1)
,(@time_zone_id, 972799200, 2)
,(@time_zone_id, 986108400, 1)
,(@time_zone_id, 1004248800, 2)
,(@time_zone_id, 1018162800, 1)
,(@time_zone_id, 1035698400, 2)
,(@time_zone_id, 1049612400, 1)
,(@time_zone_id, 1067148000, 2)
,(@time_zone_id, 1081062000, 1)
,(@time_zone_id, 1099202400, 2)
,(@time_zone_id, 1112511600, 1)
,(@time_zone_id, 1130652000, 2)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162101600, 2)
,(@time_zone_id, 1173596400, 1)
,(@time_zone_id, 1194156000, 2)
,(@time_zone_id, 1205046000, 1)
,(@time_zone_id, 1225605600, 2)
,(@time_zone_id, 1236495600, 1)
,(@time_zone_id, 1257055200, 2)
,(@time_zone_id, 1268550000, 1)
,(@time_zone_id, 1289109600, 2)
,(@time_zone_id, 1299999600, 1)
,(@time_zone_id, 1320559200, 2)
,(@time_zone_id, 1331449200, 1)
,(@time_zone_id, 1352008800, 2)
,(@time_zone_id, 1362898800, 1)
,(@time_zone_id, 1383458400, 2)
,(@time_zone_id, 1394348400, 1)
,(@time_zone_id, 1414908000, 2)
,(@time_zone_id, 1425798000, 1)
,(@time_zone_id, 1446357600, 2)
,(@time_zone_id, 1457852400, 1)
,(@time_zone_id, 1478412000, 2)
,(@time_zone_id, 1489302000, 1)
,(@time_zone_id, 1509861600, 2)
,(@time_zone_id, 1520751600, 1)
,(@time_zone_id, 1541311200, 2)
,(@time_zone_id, 1552201200, 1)
,(@time_zone_id, 1572760800, 2)
,(@time_zone_id, 1583650800, 1)
,(@time_zone_id, 1604210400, 2)
,(@time_zone_id, 1615705200, 1)
,(@time_zone_id, 1636264800, 2)
,(@time_zone_id, 1647154800, 1)
,(@time_zone_id, 1667714400, 2)
,(@time_zone_id, 1678604400, 1)
,(@time_zone_id, 1699164000, 2)
,(@time_zone_id, 1710054000, 1)
,(@time_zone_id, 1730613600, 2)
,(@time_zone_id, 1741503600, 1)
,(@time_zone_id, 1762063200, 2)
,(@time_zone_id, 1772953200, 1)
,(@time_zone_id, 1793512800, 2)
,(@time_zone_id, 1805007600, 1)
,(@time_zone_id, 1825567200, 2)
,(@time_zone_id, 1836457200, 1)
,(@time_zone_id, 1857016800, 2)
,(@time_zone_id, 1867906800, 1)
,(@time_zone_id, 1888466400, 2)
,(@time_zone_id, 1899356400, 1)
,(@time_zone_id, 1919916000, 2)
,(@time_zone_id, 1930806000, 1)
,(@time_zone_id, 1951365600, 2)
,(@time_zone_id, 1962860400, 1)
,(@time_zone_id, 1983420000, 2)
,(@time_zone_id, 1994310000, 1)
,(@time_zone_id, 2014869600, 2)
,(@time_zone_id, 2025759600, 1)
,(@time_zone_id, 2046319200, 2)
,(@time_zone_id, 2057209200, 1)
,(@time_zone_id, 2077768800, 2)
,(@time_zone_id, 2088658800, 1)
,(@time_zone_id, 2109218400, 2)
,(@time_zone_id, 2120108400, 1)
,(@time_zone_id, 2140668000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21184, 0, 'LMT')
,(@time_zone_id, 1, -14400, 1, 'EDT')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -14400, 1, 'EWT')
,(@time_zone_id, 4, -14400, 1, 'EPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Nome', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -880196400, 2)
,(@time_zone_id, -769395600, 3)
,(@time_zone_id, -765374400, 1)
,(@time_zone_id, -86878800, 4)
,(@time_zone_id, -21466800, 5)
,(@time_zone_id, -5745600, 4)
,(@time_zone_id, 9982800, 5)
,(@time_zone_id, 25704000, 4)
,(@time_zone_id, 41432400, 5)
,(@time_zone_id, 57758400, 4)
,(@time_zone_id, 73486800, 5)
,(@time_zone_id, 89208000, 4)
,(@time_zone_id, 104936400, 5)
,(@time_zone_id, 120657600, 4)
,(@time_zone_id, 126709200, 5)
,(@time_zone_id, 152107200, 4)
,(@time_zone_id, 162392400, 5)
,(@time_zone_id, 183556800, 4)
,(@time_zone_id, 199285200, 5)
,(@time_zone_id, 215611200, 4)
,(@time_zone_id, 230734800, 5)
,(@time_zone_id, 247060800, 4)
,(@time_zone_id, 262789200, 5)
,(@time_zone_id, 278510400, 4)
,(@time_zone_id, 294238800, 5)
,(@time_zone_id, 309960000, 4)
,(@time_zone_id, 325688400, 5)
,(@time_zone_id, 341409600, 4)
,(@time_zone_id, 357138000, 5)
,(@time_zone_id, 372859200, 4)
,(@time_zone_id, 388587600, 5)
,(@time_zone_id, 404913600, 4)
,(@time_zone_id, 420037200, 5)
,(@time_zone_id, 436363200, 6)
,(@time_zone_id, 439030800, 8)
,(@time_zone_id, 452084400, 7)
,(@time_zone_id, 467805600, 8)
,(@time_zone_id, 483534000, 7)
,(@time_zone_id, 499255200, 8)
,(@time_zone_id, 514983600, 7)
,(@time_zone_id, 530704800, 8)
,(@time_zone_id, 544618800, 7)
,(@time_zone_id, 562154400, 8)
,(@time_zone_id, 576068400, 7)
,(@time_zone_id, 594208800, 8)
,(@time_zone_id, 607518000, 7)
,(@time_zone_id, 625658400, 8)
,(@time_zone_id, 638967600, 7)
,(@time_zone_id, 657108000, 8)
,(@time_zone_id, 671022000, 7)
,(@time_zone_id, 688557600, 8)
,(@time_zone_id, 702471600, 7)
,(@time_zone_id, 720007200, 8)
,(@time_zone_id, 733921200, 7)
,(@time_zone_id, 752061600, 8)
,(@time_zone_id, 765370800, 7)
,(@time_zone_id, 783511200, 8)
,(@time_zone_id, 796820400, 7)
,(@time_zone_id, 814960800, 8)
,(@time_zone_id, 828874800, 7)
,(@time_zone_id, 846410400, 8)
,(@time_zone_id, 860324400, 7)
,(@time_zone_id, 877860000, 8)
,(@time_zone_id, 891774000, 7)
,(@time_zone_id, 909309600, 8)
,(@time_zone_id, 923223600, 7)
,(@time_zone_id, 941364000, 8)
,(@time_zone_id, 954673200, 7)
,(@time_zone_id, 972813600, 8)
,(@time_zone_id, 986122800, 7)
,(@time_zone_id, 1004263200, 8)
,(@time_zone_id, 1018177200, 7)
,(@time_zone_id, 1035712800, 8)
,(@time_zone_id, 1049626800, 7)
,(@time_zone_id, 1067162400, 8)
,(@time_zone_id, 1081076400, 7)
,(@time_zone_id, 1099216800, 8)
,(@time_zone_id, 1112526000, 7)
,(@time_zone_id, 1130666400, 8)
,(@time_zone_id, 1143975600, 7)
,(@time_zone_id, 1162116000, 8)
,(@time_zone_id, 1173610800, 7)
,(@time_zone_id, 1194170400, 8)
,(@time_zone_id, 1205060400, 7)
,(@time_zone_id, 1225620000, 8)
,(@time_zone_id, 1236510000, 7)
,(@time_zone_id, 1257069600, 8)
,(@time_zone_id, 1268564400, 7)
,(@time_zone_id, 1289124000, 8)
,(@time_zone_id, 1300014000, 7)
,(@time_zone_id, 1320573600, 8)
,(@time_zone_id, 1331463600, 7)
,(@time_zone_id, 1352023200, 8)
,(@time_zone_id, 1362913200, 7)
,(@time_zone_id, 1383472800, 8)
,(@time_zone_id, 1394362800, 7)
,(@time_zone_id, 1414922400, 8)
,(@time_zone_id, 1425812400, 7)
,(@time_zone_id, 1446372000, 8)
,(@time_zone_id, 1457866800, 7)
,(@time_zone_id, 1478426400, 8)
,(@time_zone_id, 1489316400, 7)
,(@time_zone_id, 1509876000, 8)
,(@time_zone_id, 1520766000, 7)
,(@time_zone_id, 1541325600, 8)
,(@time_zone_id, 1552215600, 7)
,(@time_zone_id, 1572775200, 8)
,(@time_zone_id, 1583665200, 7)
,(@time_zone_id, 1604224800, 8)
,(@time_zone_id, 1615719600, 7)
,(@time_zone_id, 1636279200, 8)
,(@time_zone_id, 1647169200, 7)
,(@time_zone_id, 1667728800, 8)
,(@time_zone_id, 1678618800, 7)
,(@time_zone_id, 1699178400, 8)
,(@time_zone_id, 1710068400, 7)
,(@time_zone_id, 1730628000, 8)
,(@time_zone_id, 1741518000, 7)
,(@time_zone_id, 1762077600, 8)
,(@time_zone_id, 1772967600, 7)
,(@time_zone_id, 1793527200, 8)
,(@time_zone_id, 1805022000, 7)
,(@time_zone_id, 1825581600, 8)
,(@time_zone_id, 1836471600, 7)
,(@time_zone_id, 1857031200, 8)
,(@time_zone_id, 1867921200, 7)
,(@time_zone_id, 1888480800, 8)
,(@time_zone_id, 1899370800, 7)
,(@time_zone_id, 1919930400, 8)
,(@time_zone_id, 1930820400, 7)
,(@time_zone_id, 1951380000, 8)
,(@time_zone_id, 1962874800, 7)
,(@time_zone_id, 1983434400, 8)
,(@time_zone_id, 1994324400, 7)
,(@time_zone_id, 2014884000, 8)
,(@time_zone_id, 2025774000, 7)
,(@time_zone_id, 2046333600, 8)
,(@time_zone_id, 2057223600, 7)
,(@time_zone_id, 2077783200, 8)
,(@time_zone_id, 2088673200, 7)
,(@time_zone_id, 2109232800, 8)
,(@time_zone_id, 2120122800, 7)
,(@time_zone_id, 2140682400, 8)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -39698, 0, 'LMT')
,(@time_zone_id, 1, -39600, 0, 'NST')
,(@time_zone_id, 2, -36000, 1, 'NWT')
,(@time_zone_id, 3, -36000, 1, 'NPT')
,(@time_zone_id, 4, -39600, 0, 'BST')
,(@time_zone_id, 5, -36000, 1, 'BDT')
,(@time_zone_id, 6, -32400, 0, 'YST')
,(@time_zone_id, 7, -28800, 1, 'AKDT')
,(@time_zone_id, 8, -32400, 0, 'AKST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Noronha', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767217820, 2)
,(@time_zone_id, -1206961200, 1)
,(@time_zone_id, -1191366000, 2)
,(@time_zone_id, -1175378400, 1)
,(@time_zone_id, -1159830000, 2)
,(@time_zone_id, -633823200, 1)
,(@time_zone_id, -622072800, 2)
,(@time_zone_id, -602287200, 1)
,(@time_zone_id, -591836400, 2)
,(@time_zone_id, -570751200, 1)
,(@time_zone_id, -560214000, 2)
,(@time_zone_id, -539128800, 1)
,(@time_zone_id, -531356400, 2)
,(@time_zone_id, -191368800, 1)
,(@time_zone_id, -184201200, 2)
,(@time_zone_id, -155167200, 1)
,(@time_zone_id, -150073200, 2)
,(@time_zone_id, -128901600, 1)
,(@time_zone_id, -121129200, 2)
,(@time_zone_id, -99957600, 1)
,(@time_zone_id, -89593200, 2)
,(@time_zone_id, -68421600, 1)
,(@time_zone_id, -57970800, 2)
,(@time_zone_id, 499744800, 1)
,(@time_zone_id, 511232400, 2)
,(@time_zone_id, 530589600, 1)
,(@time_zone_id, 540262800, 2)
,(@time_zone_id, 562125600, 1)
,(@time_zone_id, 571194000, 2)
,(@time_zone_id, 592970400, 1)
,(@time_zone_id, 602038800, 2)
,(@time_zone_id, 624420000, 1)
,(@time_zone_id, 634698000, 2)
,(@time_zone_id, 938916000, 1)
,(@time_zone_id, 951613200, 2)
,(@time_zone_id, 970970400, 1)
,(@time_zone_id, 971571600, 2)
,(@time_zone_id, 1003024800, 1)
,(@time_zone_id, 1013907600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -7780, 0, 'LMT')
,(@time_zone_id, 1, -3600, 1, '-01')
,(@time_zone_id, 2, -7200, 0, '-02')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/North_Dakota/Beulah', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633273200, 1)
,(@time_zone_id, -1615132800, 2)
,(@time_zone_id, -1601823600, 1)
,(@time_zone_id, -1583683200, 2)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765388800, 2)
,(@time_zone_id, -84380400, 1)
,(@time_zone_id, -68659200, 2)
,(@time_zone_id, -52930800, 1)
,(@time_zone_id, -37209600, 2)
,(@time_zone_id, -21481200, 1)
,(@time_zone_id, -5760000, 2)
,(@time_zone_id, 9968400, 1)
,(@time_zone_id, 25689600, 2)
,(@time_zone_id, 41418000, 1)
,(@time_zone_id, 57744000, 2)
,(@time_zone_id, 73472400, 1)
,(@time_zone_id, 89193600, 2)
,(@time_zone_id, 104922000, 1)
,(@time_zone_id, 120643200, 2)
,(@time_zone_id, 126694800, 1)
,(@time_zone_id, 152092800, 2)
,(@time_zone_id, 162378000, 1)
,(@time_zone_id, 183542400, 2)
,(@time_zone_id, 199270800, 1)
,(@time_zone_id, 215596800, 2)
,(@time_zone_id, 230720400, 1)
,(@time_zone_id, 247046400, 2)
,(@time_zone_id, 262774800, 1)
,(@time_zone_id, 278496000, 2)
,(@time_zone_id, 294224400, 1)
,(@time_zone_id, 309945600, 2)
,(@time_zone_id, 325674000, 1)
,(@time_zone_id, 341395200, 2)
,(@time_zone_id, 357123600, 1)
,(@time_zone_id, 372844800, 2)
,(@time_zone_id, 388573200, 1)
,(@time_zone_id, 404899200, 2)
,(@time_zone_id, 420022800, 1)
,(@time_zone_id, 436348800, 2)
,(@time_zone_id, 452077200, 1)
,(@time_zone_id, 467798400, 2)
,(@time_zone_id, 483526800, 1)
,(@time_zone_id, 499248000, 2)
,(@time_zone_id, 514976400, 1)
,(@time_zone_id, 530697600, 2)
,(@time_zone_id, 544611600, 1)
,(@time_zone_id, 562147200, 2)
,(@time_zone_id, 576061200, 1)
,(@time_zone_id, 594201600, 2)
,(@time_zone_id, 607510800, 1)
,(@time_zone_id, 625651200, 2)
,(@time_zone_id, 638960400, 1)
,(@time_zone_id, 657100800, 2)
,(@time_zone_id, 671014800, 1)
,(@time_zone_id, 688550400, 2)
,(@time_zone_id, 702464400, 1)
,(@time_zone_id, 720000000, 2)
,(@time_zone_id, 733914000, 1)
,(@time_zone_id, 752054400, 2)
,(@time_zone_id, 765363600, 1)
,(@time_zone_id, 783504000, 2)
,(@time_zone_id, 796813200, 1)
,(@time_zone_id, 814953600, 2)
,(@time_zone_id, 828867600, 1)
,(@time_zone_id, 846403200, 2)
,(@time_zone_id, 860317200, 1)
,(@time_zone_id, 877852800, 2)
,(@time_zone_id, 891766800, 1)
,(@time_zone_id, 909302400, 2)
,(@time_zone_id, 923216400, 1)
,(@time_zone_id, 941356800, 2)
,(@time_zone_id, 954666000, 1)
,(@time_zone_id, 972806400, 2)
,(@time_zone_id, 986115600, 1)
,(@time_zone_id, 1004256000, 2)
,(@time_zone_id, 1018170000, 1)
,(@time_zone_id, 1035705600, 2)
,(@time_zone_id, 1049619600, 1)
,(@time_zone_id, 1067155200, 2)
,(@time_zone_id, 1081069200, 1)
,(@time_zone_id, 1099209600, 2)
,(@time_zone_id, 1112518800, 1)
,(@time_zone_id, 1130659200, 2)
,(@time_zone_id, 1143968400, 1)
,(@time_zone_id, 1162108800, 2)
,(@time_zone_id, 1173603600, 1)
,(@time_zone_id, 1194163200, 2)
,(@time_zone_id, 1205053200, 1)
,(@time_zone_id, 1225612800, 2)
,(@time_zone_id, 1236502800, 1)
,(@time_zone_id, 1257062400, 2)
,(@time_zone_id, 1268557200, 1)
,(@time_zone_id, 1289116800, 6)
,(@time_zone_id, 1300003200, 5)
,(@time_zone_id, 1320562800, 6)
,(@time_zone_id, 1331452800, 5)
,(@time_zone_id, 1352012400, 6)
,(@time_zone_id, 1362902400, 5)
,(@time_zone_id, 1383462000, 6)
,(@time_zone_id, 1394352000, 5)
,(@time_zone_id, 1414911600, 6)
,(@time_zone_id, 1425801600, 5)
,(@time_zone_id, 1446361200, 6)
,(@time_zone_id, 1457856000, 5)
,(@time_zone_id, 1478415600, 6)
,(@time_zone_id, 1489305600, 5)
,(@time_zone_id, 1509865200, 6)
,(@time_zone_id, 1520755200, 5)
,(@time_zone_id, 1541314800, 6)
,(@time_zone_id, 1552204800, 5)
,(@time_zone_id, 1572764400, 6)
,(@time_zone_id, 1583654400, 5)
,(@time_zone_id, 1604214000, 6)
,(@time_zone_id, 1615708800, 5)
,(@time_zone_id, 1636268400, 6)
,(@time_zone_id, 1647158400, 5)
,(@time_zone_id, 1667718000, 6)
,(@time_zone_id, 1678608000, 5)
,(@time_zone_id, 1699167600, 6)
,(@time_zone_id, 1710057600, 5)
,(@time_zone_id, 1730617200, 6)
,(@time_zone_id, 1741507200, 5)
,(@time_zone_id, 1762066800, 6)
,(@time_zone_id, 1772956800, 5)
,(@time_zone_id, 1793516400, 6)
,(@time_zone_id, 1805011200, 5)
,(@time_zone_id, 1825570800, 6)
,(@time_zone_id, 1836460800, 5)
,(@time_zone_id, 1857020400, 6)
,(@time_zone_id, 1867910400, 5)
,(@time_zone_id, 1888470000, 6)
,(@time_zone_id, 1899360000, 5)
,(@time_zone_id, 1919919600, 6)
,(@time_zone_id, 1930809600, 5)
,(@time_zone_id, 1951369200, 6)
,(@time_zone_id, 1962864000, 5)
,(@time_zone_id, 1983423600, 6)
,(@time_zone_id, 1994313600, 5)
,(@time_zone_id, 2014873200, 6)
,(@time_zone_id, 2025763200, 5)
,(@time_zone_id, 2046322800, 6)
,(@time_zone_id, 2057212800, 5)
,(@time_zone_id, 2077772400, 6)
,(@time_zone_id, 2088662400, 5)
,(@time_zone_id, 2109222000, 6)
,(@time_zone_id, 2120112000, 5)
,(@time_zone_id, 2140671600, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -24427, 0, 'LMT')
,(@time_zone_id, 1, -21600, 1, 'MDT')
,(@time_zone_id, 2, -25200, 0, 'MST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
,(@time_zone_id, 4, -21600, 1, 'MPT')
,(@time_zone_id, 5, -18000, 1, 'CDT')
,(@time_zone_id, 6, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/North_Dakota/Center', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633273200, 1)
,(@time_zone_id, -1615132800, 2)
,(@time_zone_id, -1601823600, 1)
,(@time_zone_id, -1583683200, 2)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765388800, 2)
,(@time_zone_id, -84380400, 1)
,(@time_zone_id, -68659200, 2)
,(@time_zone_id, -52930800, 1)
,(@time_zone_id, -37209600, 2)
,(@time_zone_id, -21481200, 1)
,(@time_zone_id, -5760000, 2)
,(@time_zone_id, 9968400, 1)
,(@time_zone_id, 25689600, 2)
,(@time_zone_id, 41418000, 1)
,(@time_zone_id, 57744000, 2)
,(@time_zone_id, 73472400, 1)
,(@time_zone_id, 89193600, 2)
,(@time_zone_id, 104922000, 1)
,(@time_zone_id, 120643200, 2)
,(@time_zone_id, 126694800, 1)
,(@time_zone_id, 152092800, 2)
,(@time_zone_id, 162378000, 1)
,(@time_zone_id, 183542400, 2)
,(@time_zone_id, 199270800, 1)
,(@time_zone_id, 215596800, 2)
,(@time_zone_id, 230720400, 1)
,(@time_zone_id, 247046400, 2)
,(@time_zone_id, 262774800, 1)
,(@time_zone_id, 278496000, 2)
,(@time_zone_id, 294224400, 1)
,(@time_zone_id, 309945600, 2)
,(@time_zone_id, 325674000, 1)
,(@time_zone_id, 341395200, 2)
,(@time_zone_id, 357123600, 1)
,(@time_zone_id, 372844800, 2)
,(@time_zone_id, 388573200, 1)
,(@time_zone_id, 404899200, 2)
,(@time_zone_id, 420022800, 1)
,(@time_zone_id, 436348800, 2)
,(@time_zone_id, 452077200, 1)
,(@time_zone_id, 467798400, 2)
,(@time_zone_id, 483526800, 1)
,(@time_zone_id, 499248000, 2)
,(@time_zone_id, 514976400, 1)
,(@time_zone_id, 530697600, 2)
,(@time_zone_id, 544611600, 1)
,(@time_zone_id, 562147200, 2)
,(@time_zone_id, 576061200, 1)
,(@time_zone_id, 594201600, 2)
,(@time_zone_id, 607510800, 1)
,(@time_zone_id, 625651200, 2)
,(@time_zone_id, 638960400, 1)
,(@time_zone_id, 657100800, 2)
,(@time_zone_id, 671014800, 1)
,(@time_zone_id, 688550400, 2)
,(@time_zone_id, 702464400, 1)
,(@time_zone_id, 720000000, 6)
,(@time_zone_id, 733910400, 5)
,(@time_zone_id, 752050800, 6)
,(@time_zone_id, 765360000, 5)
,(@time_zone_id, 783500400, 6)
,(@time_zone_id, 796809600, 5)
,(@time_zone_id, 814950000, 6)
,(@time_zone_id, 828864000, 5)
,(@time_zone_id, 846399600, 6)
,(@time_zone_id, 860313600, 5)
,(@time_zone_id, 877849200, 6)
,(@time_zone_id, 891763200, 5)
,(@time_zone_id, 909298800, 6)
,(@time_zone_id, 923212800, 5)
,(@time_zone_id, 941353200, 6)
,(@time_zone_id, 954662400, 5)
,(@time_zone_id, 972802800, 6)
,(@time_zone_id, 986112000, 5)
,(@time_zone_id, 1004252400, 6)
,(@time_zone_id, 1018166400, 5)
,(@time_zone_id, 1035702000, 6)
,(@time_zone_id, 1049616000, 5)
,(@time_zone_id, 1067151600, 6)
,(@time_zone_id, 1081065600, 5)
,(@time_zone_id, 1099206000, 6)
,(@time_zone_id, 1112515200, 5)
,(@time_zone_id, 1130655600, 6)
,(@time_zone_id, 1143964800, 5)
,(@time_zone_id, 1162105200, 6)
,(@time_zone_id, 1173600000, 5)
,(@time_zone_id, 1194159600, 6)
,(@time_zone_id, 1205049600, 5)
,(@time_zone_id, 1225609200, 6)
,(@time_zone_id, 1236499200, 5)
,(@time_zone_id, 1257058800, 6)
,(@time_zone_id, 1268553600, 5)
,(@time_zone_id, 1289113200, 6)
,(@time_zone_id, 1300003200, 5)
,(@time_zone_id, 1320562800, 6)
,(@time_zone_id, 1331452800, 5)
,(@time_zone_id, 1352012400, 6)
,(@time_zone_id, 1362902400, 5)
,(@time_zone_id, 1383462000, 6)
,(@time_zone_id, 1394352000, 5)
,(@time_zone_id, 1414911600, 6)
,(@time_zone_id, 1425801600, 5)
,(@time_zone_id, 1446361200, 6)
,(@time_zone_id, 1457856000, 5)
,(@time_zone_id, 1478415600, 6)
,(@time_zone_id, 1489305600, 5)
,(@time_zone_id, 1509865200, 6)
,(@time_zone_id, 1520755200, 5)
,(@time_zone_id, 1541314800, 6)
,(@time_zone_id, 1552204800, 5)
,(@time_zone_id, 1572764400, 6)
,(@time_zone_id, 1583654400, 5)
,(@time_zone_id, 1604214000, 6)
,(@time_zone_id, 1615708800, 5)
,(@time_zone_id, 1636268400, 6)
,(@time_zone_id, 1647158400, 5)
,(@time_zone_id, 1667718000, 6)
,(@time_zone_id, 1678608000, 5)
,(@time_zone_id, 1699167600, 6)
,(@time_zone_id, 1710057600, 5)
,(@time_zone_id, 1730617200, 6)
,(@time_zone_id, 1741507200, 5)
,(@time_zone_id, 1762066800, 6)
,(@time_zone_id, 1772956800, 5)
,(@time_zone_id, 1793516400, 6)
,(@time_zone_id, 1805011200, 5)
,(@time_zone_id, 1825570800, 6)
,(@time_zone_id, 1836460800, 5)
,(@time_zone_id, 1857020400, 6)
,(@time_zone_id, 1867910400, 5)
,(@time_zone_id, 1888470000, 6)
,(@time_zone_id, 1899360000, 5)
,(@time_zone_id, 1919919600, 6)
,(@time_zone_id, 1930809600, 5)
,(@time_zone_id, 1951369200, 6)
,(@time_zone_id, 1962864000, 5)
,(@time_zone_id, 1983423600, 6)
,(@time_zone_id, 1994313600, 5)
,(@time_zone_id, 2014873200, 6)
,(@time_zone_id, 2025763200, 5)
,(@time_zone_id, 2046322800, 6)
,(@time_zone_id, 2057212800, 5)
,(@time_zone_id, 2077772400, 6)
,(@time_zone_id, 2088662400, 5)
,(@time_zone_id, 2109222000, 6)
,(@time_zone_id, 2120112000, 5)
,(@time_zone_id, 2140671600, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -24312, 0, 'LMT')
,(@time_zone_id, 1, -21600, 1, 'MDT')
,(@time_zone_id, 2, -25200, 0, 'MST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
,(@time_zone_id, 4, -21600, 1, 'MPT')
,(@time_zone_id, 5, -18000, 1, 'CDT')
,(@time_zone_id, 6, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/North_Dakota/New_Salem', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633273200, 1)
,(@time_zone_id, -1615132800, 2)
,(@time_zone_id, -1601823600, 1)
,(@time_zone_id, -1583683200, 2)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765388800, 2)
,(@time_zone_id, -84380400, 1)
,(@time_zone_id, -68659200, 2)
,(@time_zone_id, -52930800, 1)
,(@time_zone_id, -37209600, 2)
,(@time_zone_id, -21481200, 1)
,(@time_zone_id, -5760000, 2)
,(@time_zone_id, 9968400, 1)
,(@time_zone_id, 25689600, 2)
,(@time_zone_id, 41418000, 1)
,(@time_zone_id, 57744000, 2)
,(@time_zone_id, 73472400, 1)
,(@time_zone_id, 89193600, 2)
,(@time_zone_id, 104922000, 1)
,(@time_zone_id, 120643200, 2)
,(@time_zone_id, 126694800, 1)
,(@time_zone_id, 152092800, 2)
,(@time_zone_id, 162378000, 1)
,(@time_zone_id, 183542400, 2)
,(@time_zone_id, 199270800, 1)
,(@time_zone_id, 215596800, 2)
,(@time_zone_id, 230720400, 1)
,(@time_zone_id, 247046400, 2)
,(@time_zone_id, 262774800, 1)
,(@time_zone_id, 278496000, 2)
,(@time_zone_id, 294224400, 1)
,(@time_zone_id, 309945600, 2)
,(@time_zone_id, 325674000, 1)
,(@time_zone_id, 341395200, 2)
,(@time_zone_id, 357123600, 1)
,(@time_zone_id, 372844800, 2)
,(@time_zone_id, 388573200, 1)
,(@time_zone_id, 404899200, 2)
,(@time_zone_id, 420022800, 1)
,(@time_zone_id, 436348800, 2)
,(@time_zone_id, 452077200, 1)
,(@time_zone_id, 467798400, 2)
,(@time_zone_id, 483526800, 1)
,(@time_zone_id, 499248000, 2)
,(@time_zone_id, 514976400, 1)
,(@time_zone_id, 530697600, 2)
,(@time_zone_id, 544611600, 1)
,(@time_zone_id, 562147200, 2)
,(@time_zone_id, 576061200, 1)
,(@time_zone_id, 594201600, 2)
,(@time_zone_id, 607510800, 1)
,(@time_zone_id, 625651200, 2)
,(@time_zone_id, 638960400, 1)
,(@time_zone_id, 657100800, 2)
,(@time_zone_id, 671014800, 1)
,(@time_zone_id, 688550400, 2)
,(@time_zone_id, 702464400, 1)
,(@time_zone_id, 720000000, 2)
,(@time_zone_id, 733914000, 1)
,(@time_zone_id, 752054400, 2)
,(@time_zone_id, 765363600, 1)
,(@time_zone_id, 783504000, 2)
,(@time_zone_id, 796813200, 1)
,(@time_zone_id, 814953600, 2)
,(@time_zone_id, 828867600, 1)
,(@time_zone_id, 846403200, 2)
,(@time_zone_id, 860317200, 1)
,(@time_zone_id, 877852800, 2)
,(@time_zone_id, 891766800, 1)
,(@time_zone_id, 909302400, 2)
,(@time_zone_id, 923216400, 1)
,(@time_zone_id, 941356800, 2)
,(@time_zone_id, 954666000, 1)
,(@time_zone_id, 972806400, 2)
,(@time_zone_id, 986115600, 1)
,(@time_zone_id, 1004256000, 2)
,(@time_zone_id, 1018170000, 1)
,(@time_zone_id, 1035705600, 2)
,(@time_zone_id, 1049619600, 1)
,(@time_zone_id, 1067155200, 6)
,(@time_zone_id, 1081065600, 5)
,(@time_zone_id, 1099206000, 6)
,(@time_zone_id, 1112515200, 5)
,(@time_zone_id, 1130655600, 6)
,(@time_zone_id, 1143964800, 5)
,(@time_zone_id, 1162105200, 6)
,(@time_zone_id, 1173600000, 5)
,(@time_zone_id, 1194159600, 6)
,(@time_zone_id, 1205049600, 5)
,(@time_zone_id, 1225609200, 6)
,(@time_zone_id, 1236499200, 5)
,(@time_zone_id, 1257058800, 6)
,(@time_zone_id, 1268553600, 5)
,(@time_zone_id, 1289113200, 6)
,(@time_zone_id, 1300003200, 5)
,(@time_zone_id, 1320562800, 6)
,(@time_zone_id, 1331452800, 5)
,(@time_zone_id, 1352012400, 6)
,(@time_zone_id, 1362902400, 5)
,(@time_zone_id, 1383462000, 6)
,(@time_zone_id, 1394352000, 5)
,(@time_zone_id, 1414911600, 6)
,(@time_zone_id, 1425801600, 5)
,(@time_zone_id, 1446361200, 6)
,(@time_zone_id, 1457856000, 5)
,(@time_zone_id, 1478415600, 6)
,(@time_zone_id, 1489305600, 5)
,(@time_zone_id, 1509865200, 6)
,(@time_zone_id, 1520755200, 5)
,(@time_zone_id, 1541314800, 6)
,(@time_zone_id, 1552204800, 5)
,(@time_zone_id, 1572764400, 6)
,(@time_zone_id, 1583654400, 5)
,(@time_zone_id, 1604214000, 6)
,(@time_zone_id, 1615708800, 5)
,(@time_zone_id, 1636268400, 6)
,(@time_zone_id, 1647158400, 5)
,(@time_zone_id, 1667718000, 6)
,(@time_zone_id, 1678608000, 5)
,(@time_zone_id, 1699167600, 6)
,(@time_zone_id, 1710057600, 5)
,(@time_zone_id, 1730617200, 6)
,(@time_zone_id, 1741507200, 5)
,(@time_zone_id, 1762066800, 6)
,(@time_zone_id, 1772956800, 5)
,(@time_zone_id, 1793516400, 6)
,(@time_zone_id, 1805011200, 5)
,(@time_zone_id, 1825570800, 6)
,(@time_zone_id, 1836460800, 5)
,(@time_zone_id, 1857020400, 6)
,(@time_zone_id, 1867910400, 5)
,(@time_zone_id, 1888470000, 6)
,(@time_zone_id, 1899360000, 5)
,(@time_zone_id, 1919919600, 6)
,(@time_zone_id, 1930809600, 5)
,(@time_zone_id, 1951369200, 6)
,(@time_zone_id, 1962864000, 5)
,(@time_zone_id, 1983423600, 6)
,(@time_zone_id, 1994313600, 5)
,(@time_zone_id, 2014873200, 6)
,(@time_zone_id, 2025763200, 5)
,(@time_zone_id, 2046322800, 6)
,(@time_zone_id, 2057212800, 5)
,(@time_zone_id, 2077772400, 6)
,(@time_zone_id, 2088662400, 5)
,(@time_zone_id, 2109222000, 6)
,(@time_zone_id, 2120112000, 5)
,(@time_zone_id, 2140671600, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -24339, 0, 'LMT')
,(@time_zone_id, 1, -21600, 1, 'MDT')
,(@time_zone_id, 2, -25200, 0, 'MST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
,(@time_zone_id, 4, -21600, 1, 'MPT')
,(@time_zone_id, 5, -18000, 1, 'CDT')
,(@time_zone_id, 6, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Ojinaga', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514739600, 1)
,(@time_zone_id, -1343066400, 2)
,(@time_zone_id, -1234807200, 1)
,(@time_zone_id, -1220292000, 2)
,(@time_zone_id, -1207159200, 1)
,(@time_zone_id, -1191344400, 2)
,(@time_zone_id, 828864000, 3)
,(@time_zone_id, 846399600, 2)
,(@time_zone_id, 860313600, 3)
,(@time_zone_id, 877849200, 2)
,(@time_zone_id, 891766800, 4)
,(@time_zone_id, 909302400, 1)
,(@time_zone_id, 923216400, 4)
,(@time_zone_id, 941356800, 1)
,(@time_zone_id, 954666000, 4)
,(@time_zone_id, 972806400, 1)
,(@time_zone_id, 989139600, 4)
,(@time_zone_id, 1001836800, 1)
,(@time_zone_id, 1018170000, 4)
,(@time_zone_id, 1035705600, 1)
,(@time_zone_id, 1049619600, 4)
,(@time_zone_id, 1067155200, 1)
,(@time_zone_id, 1081069200, 4)
,(@time_zone_id, 1099209600, 1)
,(@time_zone_id, 1112518800, 4)
,(@time_zone_id, 1130659200, 1)
,(@time_zone_id, 1143968400, 4)
,(@time_zone_id, 1162108800, 1)
,(@time_zone_id, 1175418000, 4)
,(@time_zone_id, 1193558400, 1)
,(@time_zone_id, 1207472400, 4)
,(@time_zone_id, 1225008000, 1)
,(@time_zone_id, 1238922000, 4)
,(@time_zone_id, 1256457600, 1)
,(@time_zone_id, 1268557200, 4)
,(@time_zone_id, 1289116800, 1)
,(@time_zone_id, 1300006800, 4)
,(@time_zone_id, 1320566400, 1)
,(@time_zone_id, 1331456400, 4)
,(@time_zone_id, 1352016000, 1)
,(@time_zone_id, 1362906000, 4)
,(@time_zone_id, 1383465600, 1)
,(@time_zone_id, 1394355600, 4)
,(@time_zone_id, 1414915200, 1)
,(@time_zone_id, 1425805200, 4)
,(@time_zone_id, 1446364800, 1)
,(@time_zone_id, 1457859600, 4)
,(@time_zone_id, 1478419200, 1)
,(@time_zone_id, 1489309200, 4)
,(@time_zone_id, 1509868800, 1)
,(@time_zone_id, 1520758800, 4)
,(@time_zone_id, 1541318400, 1)
,(@time_zone_id, 1552208400, 4)
,(@time_zone_id, 1572768000, 1)
,(@time_zone_id, 1583658000, 4)
,(@time_zone_id, 1604217600, 1)
,(@time_zone_id, 1615712400, 4)
,(@time_zone_id, 1636272000, 1)
,(@time_zone_id, 1647162000, 4)
,(@time_zone_id, 1667721600, 1)
,(@time_zone_id, 1678611600, 4)
,(@time_zone_id, 1699171200, 1)
,(@time_zone_id, 1710061200, 4)
,(@time_zone_id, 1730620800, 1)
,(@time_zone_id, 1741510800, 4)
,(@time_zone_id, 1762070400, 1)
,(@time_zone_id, 1772960400, 4)
,(@time_zone_id, 1793520000, 1)
,(@time_zone_id, 1805014800, 4)
,(@time_zone_id, 1825574400, 1)
,(@time_zone_id, 1836464400, 4)
,(@time_zone_id, 1857024000, 1)
,(@time_zone_id, 1867914000, 4)
,(@time_zone_id, 1888473600, 1)
,(@time_zone_id, 1899363600, 4)
,(@time_zone_id, 1919923200, 1)
,(@time_zone_id, 1930813200, 4)
,(@time_zone_id, 1951372800, 1)
,(@time_zone_id, 1962867600, 4)
,(@time_zone_id, 1983427200, 1)
,(@time_zone_id, 1994317200, 4)
,(@time_zone_id, 2014876800, 1)
,(@time_zone_id, 2025766800, 4)
,(@time_zone_id, 2046326400, 1)
,(@time_zone_id, 2057216400, 4)
,(@time_zone_id, 2077776000, 1)
,(@time_zone_id, 2088666000, 4)
,(@time_zone_id, 2109225600, 1)
,(@time_zone_id, 2120115600, 4)
,(@time_zone_id, 2140675200, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -25060, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CDT')
,(@time_zone_id, 4, -21600, 1, 'MDT')
,(@time_zone_id, 5, -25200, 0, 'MST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Panama', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1946918424, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -19088, 0, 'LMT')
,(@time_zone_id, 1, -19176, 0, 'CMT')
,(@time_zone_id, 2, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Pangnirtung', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1546300800, 3)
,(@time_zone_id, -880221600, 1)
,(@time_zone_id, -769395600, 2)
,(@time_zone_id, -765399600, 3)
,(@time_zone_id, -147902400, 4)
,(@time_zone_id, -131572800, 3)
,(@time_zone_id, 325663200, 5)
,(@time_zone_id, 341384400, 3)
,(@time_zone_id, 357112800, 5)
,(@time_zone_id, 372834000, 3)
,(@time_zone_id, 388562400, 5)
,(@time_zone_id, 404888400, 3)
,(@time_zone_id, 420012000, 5)
,(@time_zone_id, 436338000, 3)
,(@time_zone_id, 452066400, 5)
,(@time_zone_id, 467787600, 3)
,(@time_zone_id, 483516000, 5)
,(@time_zone_id, 499237200, 3)
,(@time_zone_id, 514965600, 5)
,(@time_zone_id, 530686800, 3)
,(@time_zone_id, 544600800, 5)
,(@time_zone_id, 562136400, 3)
,(@time_zone_id, 576050400, 5)
,(@time_zone_id, 594190800, 3)
,(@time_zone_id, 607500000, 5)
,(@time_zone_id, 625640400, 3)
,(@time_zone_id, 638949600, 5)
,(@time_zone_id, 657090000, 3)
,(@time_zone_id, 671004000, 5)
,(@time_zone_id, 688539600, 3)
,(@time_zone_id, 702453600, 5)
,(@time_zone_id, 719989200, 3)
,(@time_zone_id, 733903200, 5)
,(@time_zone_id, 752043600, 3)
,(@time_zone_id, 765352800, 5)
,(@time_zone_id, 783493200, 3)
,(@time_zone_id, 796802400, 6)
,(@time_zone_id, 814946400, 7)
,(@time_zone_id, 828860400, 6)
,(@time_zone_id, 846396000, 7)
,(@time_zone_id, 860310000, 6)
,(@time_zone_id, 877845600, 7)
,(@time_zone_id, 891759600, 6)
,(@time_zone_id, 909295200, 7)
,(@time_zone_id, 923209200, 6)
,(@time_zone_id, 941349600, 8)
,(@time_zone_id, 954662400, 9)
,(@time_zone_id, 972802800, 7)
,(@time_zone_id, 986108400, 6)
,(@time_zone_id, 1004248800, 7)
,(@time_zone_id, 1018162800, 6)
,(@time_zone_id, 1035698400, 7)
,(@time_zone_id, 1049612400, 6)
,(@time_zone_id, 1067148000, 7)
,(@time_zone_id, 1081062000, 6)
,(@time_zone_id, 1099202400, 7)
,(@time_zone_id, 1112511600, 6)
,(@time_zone_id, 1130652000, 7)
,(@time_zone_id, 1143961200, 6)
,(@time_zone_id, 1162101600, 7)
,(@time_zone_id, 1173596400, 6)
,(@time_zone_id, 1194156000, 7)
,(@time_zone_id, 1205046000, 6)
,(@time_zone_id, 1225605600, 7)
,(@time_zone_id, 1236495600, 6)
,(@time_zone_id, 1257055200, 7)
,(@time_zone_id, 1268550000, 6)
,(@time_zone_id, 1289109600, 7)
,(@time_zone_id, 1299999600, 6)
,(@time_zone_id, 1320559200, 7)
,(@time_zone_id, 1331449200, 6)
,(@time_zone_id, 1352008800, 7)
,(@time_zone_id, 1362898800, 6)
,(@time_zone_id, 1383458400, 7)
,(@time_zone_id, 1394348400, 6)
,(@time_zone_id, 1414908000, 7)
,(@time_zone_id, 1425798000, 6)
,(@time_zone_id, 1446357600, 7)
,(@time_zone_id, 1457852400, 6)
,(@time_zone_id, 1478412000, 7)
,(@time_zone_id, 1489302000, 6)
,(@time_zone_id, 1509861600, 7)
,(@time_zone_id, 1520751600, 6)
,(@time_zone_id, 1541311200, 7)
,(@time_zone_id, 1552201200, 6)
,(@time_zone_id, 1572760800, 7)
,(@time_zone_id, 1583650800, 6)
,(@time_zone_id, 1604210400, 7)
,(@time_zone_id, 1615705200, 6)
,(@time_zone_id, 1636264800, 7)
,(@time_zone_id, 1647154800, 6)
,(@time_zone_id, 1667714400, 7)
,(@time_zone_id, 1678604400, 6)
,(@time_zone_id, 1699164000, 7)
,(@time_zone_id, 1710054000, 6)
,(@time_zone_id, 1730613600, 7)
,(@time_zone_id, 1741503600, 6)
,(@time_zone_id, 1762063200, 7)
,(@time_zone_id, 1772953200, 6)
,(@time_zone_id, 1793512800, 7)
,(@time_zone_id, 1805007600, 6)
,(@time_zone_id, 1825567200, 7)
,(@time_zone_id, 1836457200, 6)
,(@time_zone_id, 1857016800, 7)
,(@time_zone_id, 1867906800, 6)
,(@time_zone_id, 1888466400, 7)
,(@time_zone_id, 1899356400, 6)
,(@time_zone_id, 1919916000, 7)
,(@time_zone_id, 1930806000, 6)
,(@time_zone_id, 1951365600, 7)
,(@time_zone_id, 1962860400, 6)
,(@time_zone_id, 1983420000, 7)
,(@time_zone_id, 1994310000, 6)
,(@time_zone_id, 2014869600, 7)
,(@time_zone_id, 2025759600, 6)
,(@time_zone_id, 2046319200, 7)
,(@time_zone_id, 2057209200, 6)
,(@time_zone_id, 2077768800, 7)
,(@time_zone_id, 2088658800, 6)
,(@time_zone_id, 2109218400, 7)
,(@time_zone_id, 2120108400, 6)
,(@time_zone_id, 2140668000, 7)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, -10800, 1, 'AWT')
,(@time_zone_id, 2, -10800, 1, 'APT')
,(@time_zone_id, 3, -14400, 0, 'AST')
,(@time_zone_id, 4, -7200, 1, 'ADDT')
,(@time_zone_id, 5, -10800, 1, 'ADT')
,(@time_zone_id, 6, -14400, 1, 'EDT')
,(@time_zone_id, 7, -18000, 0, 'EST')
,(@time_zone_id, 8, -21600, 0, 'CST')
,(@time_zone_id, 9, -18000, 1, 'CDT')
,(@time_zone_id, 10, -14400, 1, 'EDT')
,(@time_zone_id, 11, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Paramaribo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1861906760, 1)
,(@time_zone_id, -1104524348, 2)
,(@time_zone_id, -765317964, 3)
,(@time_zone_id, 465449400, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -13240, 0, 'LMT')
,(@time_zone_id, 1, -13252, 0, 'PMT')
,(@time_zone_id, 2, -13236, 0, 'PMT')
,(@time_zone_id, 3, -12600, 0, '-0330')
,(@time_zone_id, 4, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Phoenix', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633273200, 1)
,(@time_zone_id, -1615132800, 2)
,(@time_zone_id, -1601823600, 1)
,(@time_zone_id, -1583683200, 2)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -820519140, 2)
,(@time_zone_id, -812653140, 3)
,(@time_zone_id, -796845540, 2)
,(@time_zone_id, -84380400, 1)
,(@time_zone_id, -68659200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -26898, 0, 'LMT')
,(@time_zone_id, 1, -21600, 1, 'MDT')
,(@time_zone_id, 2, -25200, 0, 'MST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Port-au-Prince', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1670483460, 3)
,(@time_zone_id, 421218000, 2)
,(@time_zone_id, 436334400, 3)
,(@time_zone_id, 452062800, 2)
,(@time_zone_id, 467784000, 3)
,(@time_zone_id, 483512400, 2)
,(@time_zone_id, 499233600, 3)
,(@time_zone_id, 514962000, 2)
,(@time_zone_id, 530683200, 3)
,(@time_zone_id, 546411600, 2)
,(@time_zone_id, 562132800, 3)
,(@time_zone_id, 576050400, 4)
,(@time_zone_id, 594194400, 5)
,(@time_zone_id, 607500000, 4)
,(@time_zone_id, 625644000, 5)
,(@time_zone_id, 638949600, 4)
,(@time_zone_id, 657093600, 5)
,(@time_zone_id, 671004000, 4)
,(@time_zone_id, 688543200, 5)
,(@time_zone_id, 702453600, 4)
,(@time_zone_id, 719992800, 5)
,(@time_zone_id, 733903200, 4)
,(@time_zone_id, 752047200, 5)
,(@time_zone_id, 765352800, 4)
,(@time_zone_id, 783496800, 5)
,(@time_zone_id, 796802400, 4)
,(@time_zone_id, 814946400, 5)
,(@time_zone_id, 828856800, 4)
,(@time_zone_id, 846396000, 5)
,(@time_zone_id, 860306400, 4)
,(@time_zone_id, 877845600, 5)
,(@time_zone_id, 1112504400, 2)
,(@time_zone_id, 1130644800, 3)
,(@time_zone_id, 1143954000, 2)
,(@time_zone_id, 1162094400, 3)
,(@time_zone_id, 1331449200, 2)
,(@time_zone_id, 1352008800, 3)
,(@time_zone_id, 1362898800, 2)
,(@time_zone_id, 1383458400, 3)
,(@time_zone_id, 1394348400, 2)
,(@time_zone_id, 1414908000, 3)
,(@time_zone_id, 1425798000, 2)
,(@time_zone_id, 1446357600, 3)
,(@time_zone_id, 1489302000, 2)
,(@time_zone_id, 1509861600, 3)
,(@time_zone_id, 1520751600, 2)
,(@time_zone_id, 1541311200, 3)
,(@time_zone_id, 1552201200, 2)
,(@time_zone_id, 1572760800, 3)
,(@time_zone_id, 1583650800, 2)
,(@time_zone_id, 1604210400, 3)
,(@time_zone_id, 1615705200, 2)
,(@time_zone_id, 1636264800, 3)
,(@time_zone_id, 1647154800, 2)
,(@time_zone_id, 1667714400, 3)
,(@time_zone_id, 1678604400, 2)
,(@time_zone_id, 1699164000, 3)
,(@time_zone_id, 1710054000, 2)
,(@time_zone_id, 1730613600, 3)
,(@time_zone_id, 1741503600, 2)
,(@time_zone_id, 1762063200, 3)
,(@time_zone_id, 1772953200, 2)
,(@time_zone_id, 1793512800, 3)
,(@time_zone_id, 1805007600, 2)
,(@time_zone_id, 1825567200, 3)
,(@time_zone_id, 1836457200, 2)
,(@time_zone_id, 1857016800, 3)
,(@time_zone_id, 1867906800, 2)
,(@time_zone_id, 1888466400, 3)
,(@time_zone_id, 1899356400, 2)
,(@time_zone_id, 1919916000, 3)
,(@time_zone_id, 1930806000, 2)
,(@time_zone_id, 1951365600, 3)
,(@time_zone_id, 1962860400, 2)
,(@time_zone_id, 1983420000, 3)
,(@time_zone_id, 1994310000, 2)
,(@time_zone_id, 2014869600, 3)
,(@time_zone_id, 2025759600, 2)
,(@time_zone_id, 2046319200, 3)
,(@time_zone_id, 2057209200, 2)
,(@time_zone_id, 2077768800, 3)
,(@time_zone_id, 2088658800, 2)
,(@time_zone_id, 2109218400, 3)
,(@time_zone_id, 2120108400, 2)
,(@time_zone_id, 2140668000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -17360, 0, 'LMT')
,(@time_zone_id, 1, -17340, 0, 'PPMT')
,(@time_zone_id, 2, -14400, 1, 'EDT')
,(@time_zone_id, 3, -18000, 0, 'EST')
,(@time_zone_id, 4, -14400, 1, 'EDT')
,(@time_zone_id, 5, -18000, 0, 'EST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Port_of_Spain', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Porto_Acre', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767209328, 2)
,(@time_zone_id, -1206950400, 1)
,(@time_zone_id, -1191355200, 2)
,(@time_zone_id, -1175367600, 1)
,(@time_zone_id, -1159819200, 2)
,(@time_zone_id, -633812400, 1)
,(@time_zone_id, -622062000, 2)
,(@time_zone_id, -602276400, 1)
,(@time_zone_id, -591825600, 2)
,(@time_zone_id, -570740400, 1)
,(@time_zone_id, -560203200, 2)
,(@time_zone_id, -539118000, 1)
,(@time_zone_id, -531345600, 2)
,(@time_zone_id, -191358000, 1)
,(@time_zone_id, -184190400, 2)
,(@time_zone_id, -155156400, 1)
,(@time_zone_id, -150062400, 2)
,(@time_zone_id, -128890800, 1)
,(@time_zone_id, -121118400, 2)
,(@time_zone_id, -99946800, 1)
,(@time_zone_id, -89582400, 2)
,(@time_zone_id, -68410800, 1)
,(@time_zone_id, -57960000, 2)
,(@time_zone_id, 499755600, 1)
,(@time_zone_id, 511243200, 2)
,(@time_zone_id, 530600400, 1)
,(@time_zone_id, 540273600, 2)
,(@time_zone_id, 562136400, 1)
,(@time_zone_id, 571204800, 2)
,(@time_zone_id, 1214283600, 3)
,(@time_zone_id, 1384056000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16272, 0, 'LMT')
,(@time_zone_id, 1, -14400, 1, '-04')
,(@time_zone_id, 2, -18000, 0, '-05')
,(@time_zone_id, 3, -14400, 0, '-04')
,(@time_zone_id, 4, -18000, 0, '-05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Porto_Velho', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767210264, 2)
,(@time_zone_id, -1206954000, 1)
,(@time_zone_id, -1191358800, 2)
,(@time_zone_id, -1175371200, 1)
,(@time_zone_id, -1159822800, 2)
,(@time_zone_id, -633816000, 1)
,(@time_zone_id, -622065600, 2)
,(@time_zone_id, -602280000, 1)
,(@time_zone_id, -591829200, 2)
,(@time_zone_id, -570744000, 1)
,(@time_zone_id, -560206800, 2)
,(@time_zone_id, -539121600, 1)
,(@time_zone_id, -531349200, 2)
,(@time_zone_id, -191361600, 1)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -155160000, 1)
,(@time_zone_id, -150066000, 2)
,(@time_zone_id, -128894400, 1)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -99950400, 1)
,(@time_zone_id, -89586000, 2)
,(@time_zone_id, -68414400, 1)
,(@time_zone_id, -57963600, 2)
,(@time_zone_id, 499752000, 1)
,(@time_zone_id, 511239600, 2)
,(@time_zone_id, 530596800, 1)
,(@time_zone_id, 540270000, 2)
,(@time_zone_id, 562132800, 1)
,(@time_zone_id, 571201200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15336, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, '-03')
,(@time_zone_id, 2, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Puerto_Rico', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -873057600, 3)
,(@time_zone_id, -769395600, 2)
,(@time_zone_id, -765399600, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15865, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
,(@time_zone_id, 2, -10800, 1, 'APT')
,(@time_zone_id, 3, -10800, 1, 'AWT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Punta_Arenas', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1892661434, 2)
,(@time_zone_id, -1688410800, 1)
,(@time_zone_id, -1619205434, 3)
,(@time_zone_id, -1593806400, 1)
,(@time_zone_id, -1335986234, 4)
,(@time_zone_id, -1317585600, 2)
,(@time_zone_id, -1304362800, 4)
,(@time_zone_id, -1286049600, 2)
,(@time_zone_id, -1272826800, 4)
,(@time_zone_id, -1254513600, 2)
,(@time_zone_id, -1241290800, 4)
,(@time_zone_id, -1222977600, 2)
,(@time_zone_id, -1209754800, 4)
,(@time_zone_id, -1191355200, 2)
,(@time_zone_id, -1178132400, 3)
,(@time_zone_id, -870552000, 2)
,(@time_zone_id, -865278000, 3)
,(@time_zone_id, -718056000, 2)
,(@time_zone_id, -713649600, 3)
,(@time_zone_id, -36619200, 5)
,(@time_zone_id, -23922000, 6)
,(@time_zone_id, -3355200, 5)
,(@time_zone_id, 7527600, 6)
,(@time_zone_id, 24465600, 5)
,(@time_zone_id, 37767600, 6)
,(@time_zone_id, 55915200, 5)
,(@time_zone_id, 69217200, 6)
,(@time_zone_id, 87969600, 5)
,(@time_zone_id, 100666800, 6)
,(@time_zone_id, 118209600, 5)
,(@time_zone_id, 132116400, 6)
,(@time_zone_id, 150868800, 5)
,(@time_zone_id, 163566000, 6)
,(@time_zone_id, 182318400, 5)
,(@time_zone_id, 195620400, 6)
,(@time_zone_id, 213768000, 5)
,(@time_zone_id, 227070000, 6)
,(@time_zone_id, 245217600, 5)
,(@time_zone_id, 258519600, 6)
,(@time_zone_id, 277272000, 5)
,(@time_zone_id, 289969200, 6)
,(@time_zone_id, 308721600, 5)
,(@time_zone_id, 321418800, 6)
,(@time_zone_id, 340171200, 5)
,(@time_zone_id, 353473200, 6)
,(@time_zone_id, 371620800, 5)
,(@time_zone_id, 384922800, 6)
,(@time_zone_id, 403070400, 5)
,(@time_zone_id, 416372400, 6)
,(@time_zone_id, 434520000, 5)
,(@time_zone_id, 447822000, 6)
,(@time_zone_id, 466574400, 5)
,(@time_zone_id, 479271600, 6)
,(@time_zone_id, 498024000, 5)
,(@time_zone_id, 510721200, 6)
,(@time_zone_id, 529473600, 5)
,(@time_zone_id, 545194800, 6)
,(@time_zone_id, 560923200, 5)
,(@time_zone_id, 574225200, 6)
,(@time_zone_id, 592372800, 5)
,(@time_zone_id, 605674800, 6)
,(@time_zone_id, 624427200, 5)
,(@time_zone_id, 637124400, 6)
,(@time_zone_id, 653457600, 5)
,(@time_zone_id, 668574000, 6)
,(@time_zone_id, 687326400, 5)
,(@time_zone_id, 700628400, 6)
,(@time_zone_id, 718776000, 5)
,(@time_zone_id, 732078000, 6)
,(@time_zone_id, 750225600, 5)
,(@time_zone_id, 763527600, 6)
,(@time_zone_id, 781675200, 5)
,(@time_zone_id, 794977200, 6)
,(@time_zone_id, 813729600, 5)
,(@time_zone_id, 826426800, 6)
,(@time_zone_id, 845179200, 5)
,(@time_zone_id, 859690800, 6)
,(@time_zone_id, 876628800, 5)
,(@time_zone_id, 889930800, 6)
,(@time_zone_id, 906868800, 5)
,(@time_zone_id, 923194800, 6)
,(@time_zone_id, 939528000, 5)
,(@time_zone_id, 952830000, 6)
,(@time_zone_id, 971582400, 5)
,(@time_zone_id, 984279600, 6)
,(@time_zone_id, 1003032000, 5)
,(@time_zone_id, 1015729200, 6)
,(@time_zone_id, 1034481600, 5)
,(@time_zone_id, 1047178800, 6)
,(@time_zone_id, 1065931200, 5)
,(@time_zone_id, 1079233200, 6)
,(@time_zone_id, 1097380800, 5)
,(@time_zone_id, 1110682800, 6)
,(@time_zone_id, 1128830400, 5)
,(@time_zone_id, 1142132400, 6)
,(@time_zone_id, 1160884800, 5)
,(@time_zone_id, 1173582000, 6)
,(@time_zone_id, 1192334400, 5)
,(@time_zone_id, 1206846000, 6)
,(@time_zone_id, 1223784000, 5)
,(@time_zone_id, 1237086000, 6)
,(@time_zone_id, 1255233600, 5)
,(@time_zone_id, 1270350000, 6)
,(@time_zone_id, 1286683200, 5)
,(@time_zone_id, 1304823600, 6)
,(@time_zone_id, 1313899200, 5)
,(@time_zone_id, 1335668400, 6)
,(@time_zone_id, 1346558400, 5)
,(@time_zone_id, 1367118000, 6)
,(@time_zone_id, 1378612800, 5)
,(@time_zone_id, 1398567600, 6)
,(@time_zone_id, 1410062400, 5)
,(@time_zone_id, 1463281200, 6)
,(@time_zone_id, 1471147200, 5)
,(@time_zone_id, 1480820400, 7)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -17020, 0, 'LMT')
,(@time_zone_id, 1, -16966, 0, 'SMT')
,(@time_zone_id, 2, -18000, 0, '-05')
,(@time_zone_id, 3, -14400, 0, '-04')
,(@time_zone_id, 4, -14400, 1, '-04')
,(@time_zone_id, 5, -10800, 1, '-03')
,(@time_zone_id, 6, -14400, 0, '-04')
,(@time_zone_id, 7, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Rainy_River', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632067200, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -923248800, 1)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, 136368000, 1)
,(@time_zone_id, 152089200, 2)
,(@time_zone_id, 167817600, 1)
,(@time_zone_id, 183538800, 2)
,(@time_zone_id, 199267200, 1)
,(@time_zone_id, 215593200, 2)
,(@time_zone_id, 230716800, 1)
,(@time_zone_id, 247042800, 2)
,(@time_zone_id, 262771200, 1)
,(@time_zone_id, 278492400, 2)
,(@time_zone_id, 294220800, 1)
,(@time_zone_id, 309942000, 2)
,(@time_zone_id, 325670400, 1)
,(@time_zone_id, 341391600, 2)
,(@time_zone_id, 357120000, 1)
,(@time_zone_id, 372841200, 2)
,(@time_zone_id, 388569600, 1)
,(@time_zone_id, 404895600, 2)
,(@time_zone_id, 420019200, 1)
,(@time_zone_id, 436345200, 2)
,(@time_zone_id, 452073600, 1)
,(@time_zone_id, 467794800, 2)
,(@time_zone_id, 483523200, 1)
,(@time_zone_id, 499244400, 2)
,(@time_zone_id, 514972800, 1)
,(@time_zone_id, 530694000, 2)
,(@time_zone_id, 544608000, 1)
,(@time_zone_id, 562143600, 2)
,(@time_zone_id, 576057600, 1)
,(@time_zone_id, 594198000, 2)
,(@time_zone_id, 607507200, 1)
,(@time_zone_id, 625647600, 2)
,(@time_zone_id, 638956800, 1)
,(@time_zone_id, 657097200, 2)
,(@time_zone_id, 671011200, 1)
,(@time_zone_id, 688546800, 2)
,(@time_zone_id, 702460800, 1)
,(@time_zone_id, 719996400, 2)
,(@time_zone_id, 733910400, 1)
,(@time_zone_id, 752050800, 2)
,(@time_zone_id, 765360000, 1)
,(@time_zone_id, 783500400, 2)
,(@time_zone_id, 796809600, 1)
,(@time_zone_id, 814950000, 2)
,(@time_zone_id, 828864000, 1)
,(@time_zone_id, 846399600, 2)
,(@time_zone_id, 860313600, 1)
,(@time_zone_id, 877849200, 2)
,(@time_zone_id, 891763200, 1)
,(@time_zone_id, 909298800, 2)
,(@time_zone_id, 923212800, 1)
,(@time_zone_id, 941353200, 2)
,(@time_zone_id, 954662400, 1)
,(@time_zone_id, 972802800, 2)
,(@time_zone_id, 986112000, 1)
,(@time_zone_id, 1004252400, 2)
,(@time_zone_id, 1018166400, 1)
,(@time_zone_id, 1035702000, 2)
,(@time_zone_id, 1049616000, 1)
,(@time_zone_id, 1067151600, 2)
,(@time_zone_id, 1081065600, 1)
,(@time_zone_id, 1099206000, 2)
,(@time_zone_id, 1112515200, 1)
,(@time_zone_id, 1130655600, 2)
,(@time_zone_id, 1143964800, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 1)
,(@time_zone_id, 1194159600, 2)
,(@time_zone_id, 1205049600, 1)
,(@time_zone_id, 1225609200, 2)
,(@time_zone_id, 1236499200, 1)
,(@time_zone_id, 1257058800, 2)
,(@time_zone_id, 1268553600, 1)
,(@time_zone_id, 1289113200, 2)
,(@time_zone_id, 1300003200, 1)
,(@time_zone_id, 1320562800, 2)
,(@time_zone_id, 1331452800, 1)
,(@time_zone_id, 1352012400, 2)
,(@time_zone_id, 1362902400, 1)
,(@time_zone_id, 1383462000, 2)
,(@time_zone_id, 1394352000, 1)
,(@time_zone_id, 1414911600, 2)
,(@time_zone_id, 1425801600, 1)
,(@time_zone_id, 1446361200, 2)
,(@time_zone_id, 1457856000, 1)
,(@time_zone_id, 1478415600, 2)
,(@time_zone_id, 1489305600, 1)
,(@time_zone_id, 1509865200, 2)
,(@time_zone_id, 1520755200, 1)
,(@time_zone_id, 1541314800, 2)
,(@time_zone_id, 1552204800, 1)
,(@time_zone_id, 1572764400, 2)
,(@time_zone_id, 1583654400, 1)
,(@time_zone_id, 1604214000, 2)
,(@time_zone_id, 1615708800, 1)
,(@time_zone_id, 1636268400, 2)
,(@time_zone_id, 1647158400, 1)
,(@time_zone_id, 1667718000, 2)
,(@time_zone_id, 1678608000, 1)
,(@time_zone_id, 1699167600, 2)
,(@time_zone_id, 1710057600, 1)
,(@time_zone_id, 1730617200, 2)
,(@time_zone_id, 1741507200, 1)
,(@time_zone_id, 1762066800, 2)
,(@time_zone_id, 1772956800, 1)
,(@time_zone_id, 1793516400, 2)
,(@time_zone_id, 1805011200, 1)
,(@time_zone_id, 1825570800, 2)
,(@time_zone_id, 1836460800, 1)
,(@time_zone_id, 1857020400, 2)
,(@time_zone_id, 1867910400, 1)
,(@time_zone_id, 1888470000, 2)
,(@time_zone_id, 1899360000, 1)
,(@time_zone_id, 1919919600, 2)
,(@time_zone_id, 1930809600, 1)
,(@time_zone_id, 1951369200, 2)
,(@time_zone_id, 1962864000, 1)
,(@time_zone_id, 1983423600, 2)
,(@time_zone_id, 1994313600, 1)
,(@time_zone_id, 2014873200, 2)
,(@time_zone_id, 2025763200, 1)
,(@time_zone_id, 2046322800, 2)
,(@time_zone_id, 2057212800, 1)
,(@time_zone_id, 2077772400, 2)
,(@time_zone_id, 2088662400, 1)
,(@time_zone_id, 2109222000, 2)
,(@time_zone_id, 2120112000, 1)
,(@time_zone_id, 2140671600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -22696, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Rankin_Inlet', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -410227200, 2)
,(@time_zone_id, -147895200, 1)
,(@time_zone_id, -131565600, 2)
,(@time_zone_id, 325670400, 3)
,(@time_zone_id, 341391600, 2)
,(@time_zone_id, 357120000, 3)
,(@time_zone_id, 372841200, 2)
,(@time_zone_id, 388569600, 3)
,(@time_zone_id, 404895600, 2)
,(@time_zone_id, 420019200, 3)
,(@time_zone_id, 436345200, 2)
,(@time_zone_id, 452073600, 3)
,(@time_zone_id, 467794800, 2)
,(@time_zone_id, 483523200, 3)
,(@time_zone_id, 499244400, 2)
,(@time_zone_id, 514972800, 3)
,(@time_zone_id, 530694000, 2)
,(@time_zone_id, 544608000, 3)
,(@time_zone_id, 562143600, 2)
,(@time_zone_id, 576057600, 3)
,(@time_zone_id, 594198000, 2)
,(@time_zone_id, 607507200, 3)
,(@time_zone_id, 625647600, 2)
,(@time_zone_id, 638956800, 3)
,(@time_zone_id, 657097200, 2)
,(@time_zone_id, 671011200, 3)
,(@time_zone_id, 688546800, 2)
,(@time_zone_id, 702460800, 3)
,(@time_zone_id, 719996400, 2)
,(@time_zone_id, 733910400, 3)
,(@time_zone_id, 752050800, 2)
,(@time_zone_id, 765360000, 3)
,(@time_zone_id, 783500400, 2)
,(@time_zone_id, 796809600, 3)
,(@time_zone_id, 814950000, 2)
,(@time_zone_id, 828864000, 3)
,(@time_zone_id, 846399600, 2)
,(@time_zone_id, 860313600, 3)
,(@time_zone_id, 877849200, 2)
,(@time_zone_id, 891763200, 3)
,(@time_zone_id, 909298800, 2)
,(@time_zone_id, 923212800, 3)
,(@time_zone_id, 941353200, 2)
,(@time_zone_id, 954662400, 3)
,(@time_zone_id, 972802800, 4)
,(@time_zone_id, 986112000, 3)
,(@time_zone_id, 1004252400, 2)
,(@time_zone_id, 1018166400, 3)
,(@time_zone_id, 1035702000, 2)
,(@time_zone_id, 1049616000, 3)
,(@time_zone_id, 1067151600, 2)
,(@time_zone_id, 1081065600, 3)
,(@time_zone_id, 1099206000, 2)
,(@time_zone_id, 1112515200, 3)
,(@time_zone_id, 1130655600, 2)
,(@time_zone_id, 1143964800, 3)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 3)
,(@time_zone_id, 1194159600, 2)
,(@time_zone_id, 1205049600, 3)
,(@time_zone_id, 1225609200, 2)
,(@time_zone_id, 1236499200, 3)
,(@time_zone_id, 1257058800, 2)
,(@time_zone_id, 1268553600, 3)
,(@time_zone_id, 1289113200, 2)
,(@time_zone_id, 1300003200, 3)
,(@time_zone_id, 1320562800, 2)
,(@time_zone_id, 1331452800, 3)
,(@time_zone_id, 1352012400, 2)
,(@time_zone_id, 1362902400, 3)
,(@time_zone_id, 1383462000, 2)
,(@time_zone_id, 1394352000, 3)
,(@time_zone_id, 1414911600, 2)
,(@time_zone_id, 1425801600, 3)
,(@time_zone_id, 1446361200, 2)
,(@time_zone_id, 1457856000, 3)
,(@time_zone_id, 1478415600, 2)
,(@time_zone_id, 1489305600, 3)
,(@time_zone_id, 1509865200, 2)
,(@time_zone_id, 1520755200, 3)
,(@time_zone_id, 1541314800, 2)
,(@time_zone_id, 1552204800, 3)
,(@time_zone_id, 1572764400, 2)
,(@time_zone_id, 1583654400, 3)
,(@time_zone_id, 1604214000, 2)
,(@time_zone_id, 1615708800, 3)
,(@time_zone_id, 1636268400, 2)
,(@time_zone_id, 1647158400, 3)
,(@time_zone_id, 1667718000, 2)
,(@time_zone_id, 1678608000, 3)
,(@time_zone_id, 1699167600, 2)
,(@time_zone_id, 1710057600, 3)
,(@time_zone_id, 1730617200, 2)
,(@time_zone_id, 1741507200, 3)
,(@time_zone_id, 1762066800, 2)
,(@time_zone_id, 1772956800, 3)
,(@time_zone_id, 1793516400, 2)
,(@time_zone_id, 1805011200, 3)
,(@time_zone_id, 1825570800, 2)
,(@time_zone_id, 1836460800, 3)
,(@time_zone_id, 1857020400, 2)
,(@time_zone_id, 1867910400, 3)
,(@time_zone_id, 1888470000, 2)
,(@time_zone_id, 1899360000, 3)
,(@time_zone_id, 1919919600, 2)
,(@time_zone_id, 1930809600, 3)
,(@time_zone_id, 1951369200, 2)
,(@time_zone_id, 1962864000, 3)
,(@time_zone_id, 1983423600, 2)
,(@time_zone_id, 1994313600, 3)
,(@time_zone_id, 2014873200, 2)
,(@time_zone_id, 2025763200, 3)
,(@time_zone_id, 2046322800, 2)
,(@time_zone_id, 2057212800, 3)
,(@time_zone_id, 2077772400, 2)
,(@time_zone_id, 2088662400, 3)
,(@time_zone_id, 2109222000, 2)
,(@time_zone_id, 2120112000, 3)
,(@time_zone_id, 2140671600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, -14400, 1, 'CDDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CDT')
,(@time_zone_id, 4, -18000, 0, 'EST')
,(@time_zone_id, 5, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Recife', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767217224, 2)
,(@time_zone_id, -1206957600, 1)
,(@time_zone_id, -1191362400, 2)
,(@time_zone_id, -1175374800, 1)
,(@time_zone_id, -1159826400, 2)
,(@time_zone_id, -633819600, 1)
,(@time_zone_id, -622069200, 2)
,(@time_zone_id, -602283600, 1)
,(@time_zone_id, -591832800, 2)
,(@time_zone_id, -570747600, 1)
,(@time_zone_id, -560210400, 2)
,(@time_zone_id, -539125200, 1)
,(@time_zone_id, -531352800, 2)
,(@time_zone_id, -191365200, 1)
,(@time_zone_id, -184197600, 2)
,(@time_zone_id, -155163600, 1)
,(@time_zone_id, -150069600, 2)
,(@time_zone_id, -128898000, 1)
,(@time_zone_id, -121125600, 2)
,(@time_zone_id, -99954000, 1)
,(@time_zone_id, -89589600, 2)
,(@time_zone_id, -68418000, 1)
,(@time_zone_id, -57967200, 2)
,(@time_zone_id, 499748400, 1)
,(@time_zone_id, 511236000, 2)
,(@time_zone_id, 530593200, 1)
,(@time_zone_id, 540266400, 2)
,(@time_zone_id, 562129200, 1)
,(@time_zone_id, 571197600, 2)
,(@time_zone_id, 592974000, 1)
,(@time_zone_id, 602042400, 2)
,(@time_zone_id, 624423600, 1)
,(@time_zone_id, 634701600, 2)
,(@time_zone_id, 938919600, 1)
,(@time_zone_id, 951616800, 2)
,(@time_zone_id, 970974000, 1)
,(@time_zone_id, 971575200, 2)
,(@time_zone_id, 1003028400, 1)
,(@time_zone_id, 1013911200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -8376, 0, 'LMT')
,(@time_zone_id, 1, -7200, 1, '-02')
,(@time_zone_id, 2, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Regina', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2030202084, 2)
,(@time_zone_id, -1632063600, 1)
,(@time_zone_id, -1615132800, 2)
,(@time_zone_id, -1251651600, 1)
,(@time_zone_id, -1238349600, 2)
,(@time_zone_id, -1220202000, 1)
,(@time_zone_id, -1206900000, 2)
,(@time_zone_id, -1188752400, 1)
,(@time_zone_id, -1175450400, 2)
,(@time_zone_id, -1156698000, 1)
,(@time_zone_id, -1144000800, 2)
,(@time_zone_id, -1125248400, 1)
,(@time_zone_id, -1111946400, 2)
,(@time_zone_id, -1032714000, 1)
,(@time_zone_id, -1016992800, 2)
,(@time_zone_id, -1001264400, 1)
,(@time_zone_id, -986148000, 2)
,(@time_zone_id, -969814800, 1)
,(@time_zone_id, -954093600, 2)
,(@time_zone_id, -937760400, 1)
,(@time_zone_id, -922039200, 2)
,(@time_zone_id, -906310800, 1)
,(@time_zone_id, -890589600, 2)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765388800, 2)
,(@time_zone_id, -748450800, 1)
,(@time_zone_id, -732729600, 2)
,(@time_zone_id, -715791600, 1)
,(@time_zone_id, -702489600, 2)
,(@time_zone_id, -684342000, 1)
,(@time_zone_id, -671040000, 2)
,(@time_zone_id, -652892400, 1)
,(@time_zone_id, -639590400, 2)
,(@time_zone_id, -620838000, 1)
,(@time_zone_id, -608140800, 2)
,(@time_zone_id, -589388400, 1)
,(@time_zone_id, -576086400, 2)
,(@time_zone_id, -557938800, 1)
,(@time_zone_id, -544636800, 2)
,(@time_zone_id, -526489200, 1)
,(@time_zone_id, -513187200, 2)
,(@time_zone_id, -495039600, 1)
,(@time_zone_id, -481737600, 2)
,(@time_zone_id, -463590000, 1)
,(@time_zone_id, -450288000, 2)
,(@time_zone_id, -431535600, 1)
,(@time_zone_id, -418233600, 2)
,(@time_zone_id, -400086000, 1)
,(@time_zone_id, -386784000, 2)
,(@time_zone_id, -337186800, 1)
,(@time_zone_id, -321465600, 2)
,(@time_zone_id, -305737200, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -25116, 0, 'LMT')
,(@time_zone_id, 1, -21600, 1, 'MDT')
,(@time_zone_id, 2, -25200, 0, 'MST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
,(@time_zone_id, 4, -21600, 1, 'MPT')
,(@time_zone_id, 5, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Resolute', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -704937600, 2)
,(@time_zone_id, -147895200, 1)
,(@time_zone_id, -131565600, 2)
,(@time_zone_id, 325670400, 3)
,(@time_zone_id, 341391600, 2)
,(@time_zone_id, 357120000, 3)
,(@time_zone_id, 372841200, 2)
,(@time_zone_id, 388569600, 3)
,(@time_zone_id, 404895600, 2)
,(@time_zone_id, 420019200, 3)
,(@time_zone_id, 436345200, 2)
,(@time_zone_id, 452073600, 3)
,(@time_zone_id, 467794800, 2)
,(@time_zone_id, 483523200, 3)
,(@time_zone_id, 499244400, 2)
,(@time_zone_id, 514972800, 3)
,(@time_zone_id, 530694000, 2)
,(@time_zone_id, 544608000, 3)
,(@time_zone_id, 562143600, 2)
,(@time_zone_id, 576057600, 3)
,(@time_zone_id, 594198000, 2)
,(@time_zone_id, 607507200, 3)
,(@time_zone_id, 625647600, 2)
,(@time_zone_id, 638956800, 3)
,(@time_zone_id, 657097200, 2)
,(@time_zone_id, 671011200, 3)
,(@time_zone_id, 688546800, 2)
,(@time_zone_id, 702460800, 3)
,(@time_zone_id, 719996400, 2)
,(@time_zone_id, 733910400, 3)
,(@time_zone_id, 752050800, 2)
,(@time_zone_id, 765360000, 3)
,(@time_zone_id, 783500400, 2)
,(@time_zone_id, 796809600, 3)
,(@time_zone_id, 814950000, 2)
,(@time_zone_id, 828864000, 3)
,(@time_zone_id, 846399600, 2)
,(@time_zone_id, 860313600, 3)
,(@time_zone_id, 877849200, 2)
,(@time_zone_id, 891763200, 3)
,(@time_zone_id, 909298800, 2)
,(@time_zone_id, 923212800, 3)
,(@time_zone_id, 941353200, 2)
,(@time_zone_id, 954662400, 3)
,(@time_zone_id, 972802800, 4)
,(@time_zone_id, 986112000, 3)
,(@time_zone_id, 1004252400, 2)
,(@time_zone_id, 1018166400, 3)
,(@time_zone_id, 1035702000, 2)
,(@time_zone_id, 1049616000, 3)
,(@time_zone_id, 1067151600, 2)
,(@time_zone_id, 1081065600, 3)
,(@time_zone_id, 1099206000, 2)
,(@time_zone_id, 1112515200, 3)
,(@time_zone_id, 1130655600, 2)
,(@time_zone_id, 1143964800, 3)
,(@time_zone_id, 1162105200, 4)
,(@time_zone_id, 1173600000, 3)
,(@time_zone_id, 1194159600, 2)
,(@time_zone_id, 1205049600, 3)
,(@time_zone_id, 1225609200, 2)
,(@time_zone_id, 1236499200, 3)
,(@time_zone_id, 1257058800, 2)
,(@time_zone_id, 1268553600, 3)
,(@time_zone_id, 1289113200, 2)
,(@time_zone_id, 1300003200, 3)
,(@time_zone_id, 1320562800, 2)
,(@time_zone_id, 1331452800, 3)
,(@time_zone_id, 1352012400, 2)
,(@time_zone_id, 1362902400, 3)
,(@time_zone_id, 1383462000, 2)
,(@time_zone_id, 1394352000, 3)
,(@time_zone_id, 1414911600, 2)
,(@time_zone_id, 1425801600, 3)
,(@time_zone_id, 1446361200, 2)
,(@time_zone_id, 1457856000, 3)
,(@time_zone_id, 1478415600, 2)
,(@time_zone_id, 1489305600, 3)
,(@time_zone_id, 1509865200, 2)
,(@time_zone_id, 1520755200, 3)
,(@time_zone_id, 1541314800, 2)
,(@time_zone_id, 1552204800, 3)
,(@time_zone_id, 1572764400, 2)
,(@time_zone_id, 1583654400, 3)
,(@time_zone_id, 1604214000, 2)
,(@time_zone_id, 1615708800, 3)
,(@time_zone_id, 1636268400, 2)
,(@time_zone_id, 1647158400, 3)
,(@time_zone_id, 1667718000, 2)
,(@time_zone_id, 1678608000, 3)
,(@time_zone_id, 1699167600, 2)
,(@time_zone_id, 1710057600, 3)
,(@time_zone_id, 1730617200, 2)
,(@time_zone_id, 1741507200, 3)
,(@time_zone_id, 1762066800, 2)
,(@time_zone_id, 1772956800, 3)
,(@time_zone_id, 1793516400, 2)
,(@time_zone_id, 1805011200, 3)
,(@time_zone_id, 1825570800, 2)
,(@time_zone_id, 1836460800, 3)
,(@time_zone_id, 1857020400, 2)
,(@time_zone_id, 1867910400, 3)
,(@time_zone_id, 1888470000, 2)
,(@time_zone_id, 1899360000, 3)
,(@time_zone_id, 1919919600, 2)
,(@time_zone_id, 1930809600, 3)
,(@time_zone_id, 1951369200, 2)
,(@time_zone_id, 1962864000, 3)
,(@time_zone_id, 1983423600, 2)
,(@time_zone_id, 1994313600, 3)
,(@time_zone_id, 2014873200, 2)
,(@time_zone_id, 2025763200, 3)
,(@time_zone_id, 2046322800, 2)
,(@time_zone_id, 2057212800, 3)
,(@time_zone_id, 2077772400, 2)
,(@time_zone_id, 2088662400, 3)
,(@time_zone_id, 2109222000, 2)
,(@time_zone_id, 2120112000, 3)
,(@time_zone_id, 2140671600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, -14400, 1, 'CDDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CDT')
,(@time_zone_id, 4, -18000, 0, 'EST')
,(@time_zone_id, 5, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Rio_Branco', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767209328, 2)
,(@time_zone_id, -1206950400, 1)
,(@time_zone_id, -1191355200, 2)
,(@time_zone_id, -1175367600, 1)
,(@time_zone_id, -1159819200, 2)
,(@time_zone_id, -633812400, 1)
,(@time_zone_id, -622062000, 2)
,(@time_zone_id, -602276400, 1)
,(@time_zone_id, -591825600, 2)
,(@time_zone_id, -570740400, 1)
,(@time_zone_id, -560203200, 2)
,(@time_zone_id, -539118000, 1)
,(@time_zone_id, -531345600, 2)
,(@time_zone_id, -191358000, 1)
,(@time_zone_id, -184190400, 2)
,(@time_zone_id, -155156400, 1)
,(@time_zone_id, -150062400, 2)
,(@time_zone_id, -128890800, 1)
,(@time_zone_id, -121118400, 2)
,(@time_zone_id, -99946800, 1)
,(@time_zone_id, -89582400, 2)
,(@time_zone_id, -68410800, 1)
,(@time_zone_id, -57960000, 2)
,(@time_zone_id, 499755600, 1)
,(@time_zone_id, 511243200, 2)
,(@time_zone_id, 530600400, 1)
,(@time_zone_id, 540273600, 2)
,(@time_zone_id, 562136400, 1)
,(@time_zone_id, 571204800, 2)
,(@time_zone_id, 1214283600, 3)
,(@time_zone_id, 1384056000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16272, 0, 'LMT')
,(@time_zone_id, 1, -14400, 1, '-04')
,(@time_zone_id, 2, -18000, 0, '-05')
,(@time_zone_id, 3, -14400, 0, '-04')
,(@time_zone_id, 4, -18000, 0, '-05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Rosario', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1567453392, 2)
,(@time_zone_id, -1233432000, 3)
,(@time_zone_id, -1222981200, 2)
,(@time_zone_id, -1205956800, 3)
,(@time_zone_id, -1194037200, 2)
,(@time_zone_id, -1172865600, 3)
,(@time_zone_id, -1162501200, 2)
,(@time_zone_id, -1141329600, 3)
,(@time_zone_id, -1130965200, 2)
,(@time_zone_id, -1109793600, 3)
,(@time_zone_id, -1099429200, 2)
,(@time_zone_id, -1078257600, 3)
,(@time_zone_id, -1067806800, 2)
,(@time_zone_id, -1046635200, 3)
,(@time_zone_id, -1036270800, 2)
,(@time_zone_id, -1015099200, 3)
,(@time_zone_id, -1004734800, 2)
,(@time_zone_id, -983563200, 3)
,(@time_zone_id, -973198800, 2)
,(@time_zone_id, -952027200, 3)
,(@time_zone_id, -941576400, 2)
,(@time_zone_id, -931032000, 3)
,(@time_zone_id, -900882000, 2)
,(@time_zone_id, -890337600, 3)
,(@time_zone_id, -833749200, 2)
,(@time_zone_id, -827265600, 3)
,(@time_zone_id, -752274000, 2)
,(@time_zone_id, -733780800, 3)
,(@time_zone_id, -197326800, 2)
,(@time_zone_id, -190843200, 3)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -164491200, 3)
,(@time_zone_id, -152658000, 2)
,(@time_zone_id, -132955200, 3)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -101419200, 3)
,(@time_zone_id, -86821200, 2)
,(@time_zone_id, -71092800, 3)
,(@time_zone_id, -54766800, 2)
,(@time_zone_id, -39038400, 3)
,(@time_zone_id, -23317200, 2)
,(@time_zone_id, -7588800, 5)
,(@time_zone_id, 128142000, 4)
,(@time_zone_id, 136605600, 5)
,(@time_zone_id, 596948400, 4)
,(@time_zone_id, 605066400, 5)
,(@time_zone_id, 624423600, 4)
,(@time_zone_id, 636516000, 5)
,(@time_zone_id, 656478000, 4)
,(@time_zone_id, 667965600, 2)
,(@time_zone_id, 687931200, 4)
,(@time_zone_id, 699415200, 5)
,(@time_zone_id, 719377200, 4)
,(@time_zone_id, 731469600, 5)
,(@time_zone_id, 938919600, 3)
,(@time_zone_id, 952052400, 5)
,(@time_zone_id, 1198983600, 4)
,(@time_zone_id, 1205632800, 5)
,(@time_zone_id, 1224385200, 4)
,(@time_zone_id, 1237082400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -15408, 0, 'LMT')
,(@time_zone_id, 1, -15408, 0, 'CMT')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 1, '-03')
,(@time_zone_id, 4, -7200, 1, '-02')
,(@time_zone_id, 5, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Santa_Isabel', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514736000, 1)
,(@time_zone_id, -1451667600, 2)
,(@time_zone_id, -1343062800, 1)
,(@time_zone_id, -1234803600, 2)
,(@time_zone_id, -1222963200, 3)
,(@time_zone_id, -1207242000, 2)
,(@time_zone_id, -873820800, 4)
,(@time_zone_id, -769395600, 5)
,(@time_zone_id, -761677200, 2)
,(@time_zone_id, -686073600, 3)
,(@time_zone_id, -661539600, 2)
,(@time_zone_id, -495039600, 3)
,(@time_zone_id, -481734000, 2)
,(@time_zone_id, -463590000, 3)
,(@time_zone_id, -450284400, 2)
,(@time_zone_id, -431535600, 3)
,(@time_zone_id, -418230000, 2)
,(@time_zone_id, -400086000, 3)
,(@time_zone_id, -386780400, 2)
,(@time_zone_id, -368636400, 3)
,(@time_zone_id, -355330800, 2)
,(@time_zone_id, -337186800, 3)
,(@time_zone_id, -323881200, 2)
,(@time_zone_id, -305737200, 3)
,(@time_zone_id, -292431600, 2)
,(@time_zone_id, 199274400, 3)
,(@time_zone_id, 215600400, 2)
,(@time_zone_id, 230724000, 3)
,(@time_zone_id, 247050000, 2)
,(@time_zone_id, 262778400, 3)
,(@time_zone_id, 278499600, 2)
,(@time_zone_id, 294228000, 3)
,(@time_zone_id, 309949200, 2)
,(@time_zone_id, 325677600, 3)
,(@time_zone_id, 341398800, 2)
,(@time_zone_id, 357127200, 3)
,(@time_zone_id, 372848400, 2)
,(@time_zone_id, 388576800, 3)
,(@time_zone_id, 404902800, 2)
,(@time_zone_id, 420026400, 3)
,(@time_zone_id, 436352400, 2)
,(@time_zone_id, 452080800, 3)
,(@time_zone_id, 467802000, 2)
,(@time_zone_id, 483530400, 3)
,(@time_zone_id, 499251600, 2)
,(@time_zone_id, 514980000, 3)
,(@time_zone_id, 530701200, 2)
,(@time_zone_id, 544615200, 3)
,(@time_zone_id, 562150800, 2)
,(@time_zone_id, 576064800, 3)
,(@time_zone_id, 594205200, 2)
,(@time_zone_id, 607514400, 3)
,(@time_zone_id, 625654800, 2)
,(@time_zone_id, 638964000, 3)
,(@time_zone_id, 657104400, 2)
,(@time_zone_id, 671018400, 3)
,(@time_zone_id, 688554000, 2)
,(@time_zone_id, 702468000, 3)
,(@time_zone_id, 720003600, 2)
,(@time_zone_id, 733917600, 3)
,(@time_zone_id, 752058000, 2)
,(@time_zone_id, 765367200, 3)
,(@time_zone_id, 783507600, 2)
,(@time_zone_id, 796816800, 3)
,(@time_zone_id, 814957200, 2)
,(@time_zone_id, 828871200, 3)
,(@time_zone_id, 846406800, 2)
,(@time_zone_id, 860320800, 3)
,(@time_zone_id, 877856400, 2)
,(@time_zone_id, 891770400, 3)
,(@time_zone_id, 909306000, 2)
,(@time_zone_id, 923220000, 3)
,(@time_zone_id, 941360400, 2)
,(@time_zone_id, 954669600, 3)
,(@time_zone_id, 972810000, 2)
,(@time_zone_id, 986119200, 3)
,(@time_zone_id, 1004259600, 2)
,(@time_zone_id, 1018173600, 3)
,(@time_zone_id, 1035709200, 2)
,(@time_zone_id, 1049623200, 3)
,(@time_zone_id, 1067158800, 2)
,(@time_zone_id, 1081072800, 3)
,(@time_zone_id, 1099213200, 2)
,(@time_zone_id, 1112522400, 3)
,(@time_zone_id, 1130662800, 2)
,(@time_zone_id, 1143972000, 3)
,(@time_zone_id, 1162112400, 2)
,(@time_zone_id, 1175421600, 3)
,(@time_zone_id, 1193562000, 2)
,(@time_zone_id, 1207476000, 3)
,(@time_zone_id, 1225011600, 2)
,(@time_zone_id, 1238925600, 3)
,(@time_zone_id, 1256461200, 2)
,(@time_zone_id, 1268560800, 3)
,(@time_zone_id, 1289120400, 2)
,(@time_zone_id, 1300010400, 3)
,(@time_zone_id, 1320570000, 2)
,(@time_zone_id, 1331460000, 3)
,(@time_zone_id, 1352019600, 2)
,(@time_zone_id, 1362909600, 3)
,(@time_zone_id, 1383469200, 2)
,(@time_zone_id, 1394359200, 3)
,(@time_zone_id, 1414918800, 2)
,(@time_zone_id, 1425808800, 3)
,(@time_zone_id, 1446368400, 2)
,(@time_zone_id, 1457863200, 3)
,(@time_zone_id, 1478422800, 2)
,(@time_zone_id, 1489312800, 3)
,(@time_zone_id, 1509872400, 2)
,(@time_zone_id, 1520762400, 3)
,(@time_zone_id, 1541322000, 2)
,(@time_zone_id, 1552212000, 3)
,(@time_zone_id, 1572771600, 2)
,(@time_zone_id, 1583661600, 3)
,(@time_zone_id, 1604221200, 2)
,(@time_zone_id, 1615716000, 3)
,(@time_zone_id, 1636275600, 2)
,(@time_zone_id, 1647165600, 3)
,(@time_zone_id, 1667725200, 2)
,(@time_zone_id, 1678615200, 3)
,(@time_zone_id, 1699174800, 2)
,(@time_zone_id, 1710064800, 3)
,(@time_zone_id, 1730624400, 2)
,(@time_zone_id, 1741514400, 3)
,(@time_zone_id, 1762074000, 2)
,(@time_zone_id, 1772964000, 3)
,(@time_zone_id, 1793523600, 2)
,(@time_zone_id, 1805018400, 3)
,(@time_zone_id, 1825578000, 2)
,(@time_zone_id, 1836468000, 3)
,(@time_zone_id, 1857027600, 2)
,(@time_zone_id, 1867917600, 3)
,(@time_zone_id, 1888477200, 2)
,(@time_zone_id, 1899367200, 3)
,(@time_zone_id, 1919926800, 2)
,(@time_zone_id, 1930816800, 3)
,(@time_zone_id, 1951376400, 2)
,(@time_zone_id, 1962871200, 3)
,(@time_zone_id, 1983430800, 2)
,(@time_zone_id, 1994320800, 3)
,(@time_zone_id, 2014880400, 2)
,(@time_zone_id, 2025770400, 3)
,(@time_zone_id, 2046330000, 2)
,(@time_zone_id, 2057220000, 3)
,(@time_zone_id, 2077779600, 2)
,(@time_zone_id, 2088669600, 3)
,(@time_zone_id, 2109229200, 2)
,(@time_zone_id, 2120119200, 3)
,(@time_zone_id, 2140678800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -28084, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -25200, 1, 'PDT')
,(@time_zone_id, 4, -25200, 1, 'PWT')
,(@time_zone_id, 5, -25200, 1, 'PPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Santarem', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767212472, 2)
,(@time_zone_id, -1206954000, 1)
,(@time_zone_id, -1191358800, 2)
,(@time_zone_id, -1175371200, 1)
,(@time_zone_id, -1159822800, 2)
,(@time_zone_id, -633816000, 1)
,(@time_zone_id, -622065600, 2)
,(@time_zone_id, -602280000, 1)
,(@time_zone_id, -591829200, 2)
,(@time_zone_id, -570744000, 1)
,(@time_zone_id, -560206800, 2)
,(@time_zone_id, -539121600, 1)
,(@time_zone_id, -531349200, 2)
,(@time_zone_id, -191361600, 1)
,(@time_zone_id, -184194000, 2)
,(@time_zone_id, -155160000, 1)
,(@time_zone_id, -150066000, 2)
,(@time_zone_id, -128894400, 1)
,(@time_zone_id, -121122000, 2)
,(@time_zone_id, -99950400, 1)
,(@time_zone_id, -89586000, 2)
,(@time_zone_id, -68414400, 1)
,(@time_zone_id, -57963600, 2)
,(@time_zone_id, 499752000, 1)
,(@time_zone_id, 511239600, 2)
,(@time_zone_id, 530596800, 1)
,(@time_zone_id, 540270000, 2)
,(@time_zone_id, 562132800, 1)
,(@time_zone_id, 571201200, 2)
,(@time_zone_id, 1214280000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -13128, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, '-03')
,(@time_zone_id, 2, -14400, 0, '-04')
,(@time_zone_id, 3, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Santiago', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1892661434, 2)
,(@time_zone_id, -1688410800, 1)
,(@time_zone_id, -1619205434, 3)
,(@time_zone_id, -1593806400, 1)
,(@time_zone_id, -1335986234, 4)
,(@time_zone_id, -1317585600, 2)
,(@time_zone_id, -1304362800, 4)
,(@time_zone_id, -1286049600, 2)
,(@time_zone_id, -1272826800, 4)
,(@time_zone_id, -1254513600, 2)
,(@time_zone_id, -1241290800, 4)
,(@time_zone_id, -1222977600, 2)
,(@time_zone_id, -1209754800, 4)
,(@time_zone_id, -1191355200, 2)
,(@time_zone_id, -1178132400, 3)
,(@time_zone_id, -870552000, 2)
,(@time_zone_id, -865278000, 3)
,(@time_zone_id, -740520000, 5)
,(@time_zone_id, -736376400, 3)
,(@time_zone_id, -718056000, 2)
,(@time_zone_id, -713649600, 3)
,(@time_zone_id, -36619200, 6)
,(@time_zone_id, -23922000, 7)
,(@time_zone_id, -3355200, 6)
,(@time_zone_id, 7527600, 7)
,(@time_zone_id, 24465600, 6)
,(@time_zone_id, 37767600, 7)
,(@time_zone_id, 55915200, 6)
,(@time_zone_id, 69217200, 7)
,(@time_zone_id, 87969600, 6)
,(@time_zone_id, 100666800, 7)
,(@time_zone_id, 118209600, 6)
,(@time_zone_id, 132116400, 7)
,(@time_zone_id, 150868800, 6)
,(@time_zone_id, 163566000, 7)
,(@time_zone_id, 182318400, 6)
,(@time_zone_id, 195620400, 7)
,(@time_zone_id, 213768000, 6)
,(@time_zone_id, 227070000, 7)
,(@time_zone_id, 245217600, 6)
,(@time_zone_id, 258519600, 7)
,(@time_zone_id, 277272000, 6)
,(@time_zone_id, 289969200, 7)
,(@time_zone_id, 308721600, 6)
,(@time_zone_id, 321418800, 7)
,(@time_zone_id, 340171200, 6)
,(@time_zone_id, 353473200, 7)
,(@time_zone_id, 371620800, 6)
,(@time_zone_id, 384922800, 7)
,(@time_zone_id, 403070400, 6)
,(@time_zone_id, 416372400, 7)
,(@time_zone_id, 434520000, 6)
,(@time_zone_id, 447822000, 7)
,(@time_zone_id, 466574400, 6)
,(@time_zone_id, 479271600, 7)
,(@time_zone_id, 498024000, 6)
,(@time_zone_id, 510721200, 7)
,(@time_zone_id, 529473600, 6)
,(@time_zone_id, 545194800, 7)
,(@time_zone_id, 560923200, 6)
,(@time_zone_id, 574225200, 7)
,(@time_zone_id, 592372800, 6)
,(@time_zone_id, 605674800, 7)
,(@time_zone_id, 624427200, 6)
,(@time_zone_id, 637124400, 7)
,(@time_zone_id, 653457600, 6)
,(@time_zone_id, 668574000, 7)
,(@time_zone_id, 687326400, 6)
,(@time_zone_id, 700628400, 7)
,(@time_zone_id, 718776000, 6)
,(@time_zone_id, 732078000, 7)
,(@time_zone_id, 750225600, 6)
,(@time_zone_id, 763527600, 7)
,(@time_zone_id, 781675200, 6)
,(@time_zone_id, 794977200, 7)
,(@time_zone_id, 813729600, 6)
,(@time_zone_id, 826426800, 7)
,(@time_zone_id, 845179200, 6)
,(@time_zone_id, 859690800, 7)
,(@time_zone_id, 876628800, 6)
,(@time_zone_id, 889930800, 7)
,(@time_zone_id, 906868800, 6)
,(@time_zone_id, 923194800, 7)
,(@time_zone_id, 939528000, 6)
,(@time_zone_id, 952830000, 7)
,(@time_zone_id, 971582400, 6)
,(@time_zone_id, 984279600, 7)
,(@time_zone_id, 1003032000, 6)
,(@time_zone_id, 1015729200, 7)
,(@time_zone_id, 1034481600, 6)
,(@time_zone_id, 1047178800, 7)
,(@time_zone_id, 1065931200, 6)
,(@time_zone_id, 1079233200, 7)
,(@time_zone_id, 1097380800, 6)
,(@time_zone_id, 1110682800, 7)
,(@time_zone_id, 1128830400, 6)
,(@time_zone_id, 1142132400, 7)
,(@time_zone_id, 1160884800, 6)
,(@time_zone_id, 1173582000, 7)
,(@time_zone_id, 1192334400, 6)
,(@time_zone_id, 1206846000, 7)
,(@time_zone_id, 1223784000, 6)
,(@time_zone_id, 1237086000, 7)
,(@time_zone_id, 1255233600, 6)
,(@time_zone_id, 1270350000, 7)
,(@time_zone_id, 1286683200, 6)
,(@time_zone_id, 1304823600, 7)
,(@time_zone_id, 1313899200, 6)
,(@time_zone_id, 1335668400, 7)
,(@time_zone_id, 1346558400, 6)
,(@time_zone_id, 1367118000, 7)
,(@time_zone_id, 1378612800, 6)
,(@time_zone_id, 1398567600, 7)
,(@time_zone_id, 1410062400, 6)
,(@time_zone_id, 1463281200, 7)
,(@time_zone_id, 1471147200, 6)
,(@time_zone_id, 1494730800, 7)
,(@time_zone_id, 1502596800, 6)
,(@time_zone_id, 1526180400, 7)
,(@time_zone_id, 1534046400, 6)
,(@time_zone_id, 1554606000, 7)
,(@time_zone_id, 1567915200, 6)
,(@time_zone_id, 1586055600, 7)
,(@time_zone_id, 1599364800, 6)
,(@time_zone_id, 1617505200, 7)
,(@time_zone_id, 1630814400, 6)
,(@time_zone_id, 1648954800, 7)
,(@time_zone_id, 1662264000, 6)
,(@time_zone_id, 1680404400, 7)
,(@time_zone_id, 1693713600, 6)
,(@time_zone_id, 1712458800, 7)
,(@time_zone_id, 1725768000, 6)
,(@time_zone_id, 1743908400, 7)
,(@time_zone_id, 1757217600, 6)
,(@time_zone_id, 1775358000, 7)
,(@time_zone_id, 1788667200, 6)
,(@time_zone_id, 1806807600, 7)
,(@time_zone_id, 1820116800, 6)
,(@time_zone_id, 1838257200, 7)
,(@time_zone_id, 1851566400, 6)
,(@time_zone_id, 1870311600, 7)
,(@time_zone_id, 1883016000, 6)
,(@time_zone_id, 1901761200, 7)
,(@time_zone_id, 1915070400, 6)
,(@time_zone_id, 1933210800, 7)
,(@time_zone_id, 1946520000, 6)
,(@time_zone_id, 1964660400, 7)
,(@time_zone_id, 1977969600, 6)
,(@time_zone_id, 1996110000, 7)
,(@time_zone_id, 2009419200, 6)
,(@time_zone_id, 2027559600, 7)
,(@time_zone_id, 2040868800, 6)
,(@time_zone_id, 2059614000, 7)
,(@time_zone_id, 2072318400, 6)
,(@time_zone_id, 2091063600, 7)
,(@time_zone_id, 2104372800, 6)
,(@time_zone_id, 2122513200, 7)
,(@time_zone_id, 2135822400, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16966, 0, 'LMT')
,(@time_zone_id, 1, -16966, 0, 'SMT')
,(@time_zone_id, 2, -18000, 0, '-05')
,(@time_zone_id, 3, -14400, 0, '-04')
,(@time_zone_id, 4, -14400, 1, '-04')
,(@time_zone_id, 5, -10800, 1, '-03')
,(@time_zone_id, 6, -10800, 1, '-03')
,(@time_zone_id, 7, -14400, 0, '-04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Santo_Domingo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1159773600, 3)
,(@time_zone_id, -100119600, 2)
,(@time_zone_id, -89668800, 3)
,(@time_zone_id, -5770800, 4)
,(@time_zone_id, 4422600, 3)
,(@time_zone_id, 25678800, 4)
,(@time_zone_id, 33193800, 3)
,(@time_zone_id, 57733200, 4)
,(@time_zone_id, 64816200, 3)
,(@time_zone_id, 89182800, 4)
,(@time_zone_id, 96438600, 3)
,(@time_zone_id, 120632400, 4)
,(@time_zone_id, 127974600, 3)
,(@time_zone_id, 152082000, 5)
,(@time_zone_id, 972799200, 3)
,(@time_zone_id, 975823200, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16776, 0, 'LMT')
,(@time_zone_id, 1, -16800, 0, 'SDMT')
,(@time_zone_id, 2, -14400, 1, 'EDT')
,(@time_zone_id, 3, -18000, 0, 'EST')
,(@time_zone_id, 4, -16200, 1, '-0430')
,(@time_zone_id, 5, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Sao_Paulo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1767214412, 2)
,(@time_zone_id, -1206957600, 1)
,(@time_zone_id, -1191362400, 2)
,(@time_zone_id, -1175374800, 1)
,(@time_zone_id, -1159826400, 2)
,(@time_zone_id, -633819600, 1)
,(@time_zone_id, -622069200, 2)
,(@time_zone_id, -602283600, 1)
,(@time_zone_id, -591832800, 2)
,(@time_zone_id, -570747600, 1)
,(@time_zone_id, -560210400, 2)
,(@time_zone_id, -539125200, 1)
,(@time_zone_id, -531352800, 2)
,(@time_zone_id, -195426000, 1)
,(@time_zone_id, -184197600, 2)
,(@time_zone_id, -155163600, 1)
,(@time_zone_id, -150069600, 2)
,(@time_zone_id, -128898000, 1)
,(@time_zone_id, -121125600, 2)
,(@time_zone_id, -99954000, 1)
,(@time_zone_id, -89589600, 2)
,(@time_zone_id, -68418000, 1)
,(@time_zone_id, -57967200, 2)
,(@time_zone_id, 499748400, 1)
,(@time_zone_id, 511236000, 2)
,(@time_zone_id, 530593200, 1)
,(@time_zone_id, 540266400, 2)
,(@time_zone_id, 562129200, 1)
,(@time_zone_id, 571197600, 2)
,(@time_zone_id, 592974000, 1)
,(@time_zone_id, 602042400, 2)
,(@time_zone_id, 624423600, 1)
,(@time_zone_id, 634701600, 2)
,(@time_zone_id, 656478000, 1)
,(@time_zone_id, 666756000, 2)
,(@time_zone_id, 687927600, 1)
,(@time_zone_id, 697600800, 2)
,(@time_zone_id, 719982000, 1)
,(@time_zone_id, 728445600, 2)
,(@time_zone_id, 750826800, 1)
,(@time_zone_id, 761709600, 2)
,(@time_zone_id, 782276400, 1)
,(@time_zone_id, 793159200, 2)
,(@time_zone_id, 813726000, 1)
,(@time_zone_id, 824004000, 2)
,(@time_zone_id, 844570800, 1)
,(@time_zone_id, 856058400, 2)
,(@time_zone_id, 876106800, 1)
,(@time_zone_id, 888717600, 2)
,(@time_zone_id, 908074800, 1)
,(@time_zone_id, 919562400, 2)
,(@time_zone_id, 938919600, 1)
,(@time_zone_id, 951616800, 2)
,(@time_zone_id, 970974000, 1)
,(@time_zone_id, 982461600, 2)
,(@time_zone_id, 1003028400, 1)
,(@time_zone_id, 1013911200, 2)
,(@time_zone_id, 1036292400, 1)
,(@time_zone_id, 1045360800, 2)
,(@time_zone_id, 1066532400, 1)
,(@time_zone_id, 1076810400, 2)
,(@time_zone_id, 1099364400, 1)
,(@time_zone_id, 1108864800, 2)
,(@time_zone_id, 1129431600, 1)
,(@time_zone_id, 1140314400, 2)
,(@time_zone_id, 1162695600, 1)
,(@time_zone_id, 1172368800, 2)
,(@time_zone_id, 1192330800, 1)
,(@time_zone_id, 1203213600, 2)
,(@time_zone_id, 1224385200, 1)
,(@time_zone_id, 1234663200, 2)
,(@time_zone_id, 1255834800, 1)
,(@time_zone_id, 1266717600, 2)
,(@time_zone_id, 1287284400, 1)
,(@time_zone_id, 1298167200, 2)
,(@time_zone_id, 1318734000, 1)
,(@time_zone_id, 1330221600, 2)
,(@time_zone_id, 1350788400, 1)
,(@time_zone_id, 1361066400, 2)
,(@time_zone_id, 1382238000, 1)
,(@time_zone_id, 1392516000, 2)
,(@time_zone_id, 1413687600, 1)
,(@time_zone_id, 1424570400, 2)
,(@time_zone_id, 1445137200, 1)
,(@time_zone_id, 1456020000, 2)
,(@time_zone_id, 1476586800, 1)
,(@time_zone_id, 1487469600, 2)
,(@time_zone_id, 1508036400, 1)
,(@time_zone_id, 1518919200, 2)
,(@time_zone_id, 1541300400, 1)
,(@time_zone_id, 1550368800, 2)
,(@time_zone_id, 1572750000, 1)
,(@time_zone_id, 1581818400, 2)
,(@time_zone_id, 1604199600, 1)
,(@time_zone_id, 1613872800, 2)
,(@time_zone_id, 1636254000, 1)
,(@time_zone_id, 1645322400, 2)
,(@time_zone_id, 1667703600, 1)
,(@time_zone_id, 1677376800, 2)
,(@time_zone_id, 1699153200, 1)
,(@time_zone_id, 1708221600, 2)
,(@time_zone_id, 1730602800, 1)
,(@time_zone_id, 1739671200, 2)
,(@time_zone_id, 1762052400, 1)
,(@time_zone_id, 1771725600, 2)
,(@time_zone_id, 1793502000, 1)
,(@time_zone_id, 1803175200, 2)
,(@time_zone_id, 1825556400, 1)
,(@time_zone_id, 1834624800, 2)
,(@time_zone_id, 1857006000, 1)
,(@time_zone_id, 1866074400, 2)
,(@time_zone_id, 1888455600, 1)
,(@time_zone_id, 1897524000, 2)
,(@time_zone_id, 1919905200, 1)
,(@time_zone_id, 1928973600, 2)
,(@time_zone_id, 1951354800, 1)
,(@time_zone_id, 1960423200, 2)
,(@time_zone_id, 1983409200, 1)
,(@time_zone_id, 1992477600, 2)
,(@time_zone_id, 2014858800, 1)
,(@time_zone_id, 2024532000, 2)
,(@time_zone_id, 2046308400, 1)
,(@time_zone_id, 2055376800, 2)
,(@time_zone_id, 2077758000, 1)
,(@time_zone_id, 2086826400, 2)
,(@time_zone_id, 2109207600, 1)
,(@time_zone_id, 2118880800, 2)
,(@time_zone_id, 2140657200, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -11188, 0, 'LMT')
,(@time_zone_id, 1, -7200, 1, '-02')
,(@time_zone_id, 2, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Scoresbysund', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1686090728, 1)
,(@time_zone_id, 323841600, 2)
,(@time_zone_id, 338961600, 3)
,(@time_zone_id, 354679200, 6)
,(@time_zone_id, 370400400, 4)
,(@time_zone_id, 386125200, 5)
,(@time_zone_id, 401850000, 4)
,(@time_zone_id, 417574800, 5)
,(@time_zone_id, 433299600, 4)
,(@time_zone_id, 449024400, 5)
,(@time_zone_id, 465354000, 4)
,(@time_zone_id, 481078800, 5)
,(@time_zone_id, 496803600, 4)
,(@time_zone_id, 512528400, 5)
,(@time_zone_id, 528253200, 4)
,(@time_zone_id, 543978000, 5)
,(@time_zone_id, 559702800, 4)
,(@time_zone_id, 575427600, 5)
,(@time_zone_id, 591152400, 4)
,(@time_zone_id, 606877200, 5)
,(@time_zone_id, 622602000, 4)
,(@time_zone_id, 638326800, 5)
,(@time_zone_id, 654656400, 4)
,(@time_zone_id, 670381200, 5)
,(@time_zone_id, 686106000, 4)
,(@time_zone_id, 701830800, 5)
,(@time_zone_id, 717555600, 4)
,(@time_zone_id, 733280400, 5)
,(@time_zone_id, 749005200, 4)
,(@time_zone_id, 764730000, 5)
,(@time_zone_id, 780454800, 4)
,(@time_zone_id, 796179600, 5)
,(@time_zone_id, 811904400, 4)
,(@time_zone_id, 828234000, 5)
,(@time_zone_id, 846378000, 4)
,(@time_zone_id, 859683600, 5)
,(@time_zone_id, 877827600, 4)
,(@time_zone_id, 891133200, 5)
,(@time_zone_id, 909277200, 4)
,(@time_zone_id, 922582800, 5)
,(@time_zone_id, 941331600, 4)
,(@time_zone_id, 954032400, 5)
,(@time_zone_id, 972781200, 4)
,(@time_zone_id, 985482000, 5)
,(@time_zone_id, 1004230800, 4)
,(@time_zone_id, 1017536400, 5)
,(@time_zone_id, 1035680400, 4)
,(@time_zone_id, 1048986000, 5)
,(@time_zone_id, 1067130000, 4)
,(@time_zone_id, 1080435600, 5)
,(@time_zone_id, 1099184400, 4)
,(@time_zone_id, 1111885200, 5)
,(@time_zone_id, 1130634000, 4)
,(@time_zone_id, 1143334800, 5)
,(@time_zone_id, 1162083600, 4)
,(@time_zone_id, 1174784400, 5)
,(@time_zone_id, 1193533200, 4)
,(@time_zone_id, 1206838800, 5)
,(@time_zone_id, 1224982800, 4)
,(@time_zone_id, 1238288400, 5)
,(@time_zone_id, 1256432400, 4)
,(@time_zone_id, 1269738000, 5)
,(@time_zone_id, 1288486800, 4)
,(@time_zone_id, 1301187600, 5)
,(@time_zone_id, 1319936400, 4)
,(@time_zone_id, 1332637200, 5)
,(@time_zone_id, 1351386000, 4)
,(@time_zone_id, 1364691600, 5)
,(@time_zone_id, 1382835600, 4)
,(@time_zone_id, 1396141200, 5)
,(@time_zone_id, 1414285200, 4)
,(@time_zone_id, 1427590800, 5)
,(@time_zone_id, 1445734800, 4)
,(@time_zone_id, 1459040400, 5)
,(@time_zone_id, 1477789200, 4)
,(@time_zone_id, 1490490000, 5)
,(@time_zone_id, 1509238800, 4)
,(@time_zone_id, 1521939600, 5)
,(@time_zone_id, 1540688400, 4)
,(@time_zone_id, 1553994000, 5)
,(@time_zone_id, 1572138000, 4)
,(@time_zone_id, 1585443600, 5)
,(@time_zone_id, 1603587600, 4)
,(@time_zone_id, 1616893200, 5)
,(@time_zone_id, 1635642000, 4)
,(@time_zone_id, 1648342800, 5)
,(@time_zone_id, 1667091600, 4)
,(@time_zone_id, 1679792400, 5)
,(@time_zone_id, 1698541200, 4)
,(@time_zone_id, 1711846800, 5)
,(@time_zone_id, 1729990800, 4)
,(@time_zone_id, 1743296400, 5)
,(@time_zone_id, 1761440400, 4)
,(@time_zone_id, 1774746000, 5)
,(@time_zone_id, 1792890000, 4)
,(@time_zone_id, 1806195600, 5)
,(@time_zone_id, 1824944400, 4)
,(@time_zone_id, 1837645200, 5)
,(@time_zone_id, 1856394000, 4)
,(@time_zone_id, 1869094800, 5)
,(@time_zone_id, 1887843600, 4)
,(@time_zone_id, 1901149200, 5)
,(@time_zone_id, 1919293200, 4)
,(@time_zone_id, 1932598800, 5)
,(@time_zone_id, 1950742800, 4)
,(@time_zone_id, 1964048400, 5)
,(@time_zone_id, 1982797200, 4)
,(@time_zone_id, 1995498000, 5)
,(@time_zone_id, 2014246800, 4)
,(@time_zone_id, 2026947600, 5)
,(@time_zone_id, 2045696400, 4)
,(@time_zone_id, 2058397200, 5)
,(@time_zone_id, 2077146000, 4)
,(@time_zone_id, 2090451600, 5)
,(@time_zone_id, 2108595600, 4)
,(@time_zone_id, 2121901200, 5)
,(@time_zone_id, 2140045200, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -5272, 0, 'LMT')
,(@time_zone_id, 1, -7200, 0, '-02')
,(@time_zone_id, 2, -3600, 1, '-01')
,(@time_zone_id, 3, -7200, 0, '-02')
,(@time_zone_id, 4, -3600, 0, '-01')
,(@time_zone_id, 5, 0, 1, '+00')
,(@time_zone_id, 6, 0, 1, '+00')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Shiprock', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1633273200, 1)
,(@time_zone_id, -1615132800, 2)
,(@time_zone_id, -1601823600, 1)
,(@time_zone_id, -1583683200, 2)
,(@time_zone_id, -1570374000, 1)
,(@time_zone_id, -1551628800, 2)
,(@time_zone_id, -1538924400, 1)
,(@time_zone_id, -1534089600, 2)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765388800, 2)
,(@time_zone_id, -147884400, 1)
,(@time_zone_id, -131558400, 2)
,(@time_zone_id, -116434800, 1)
,(@time_zone_id, -100108800, 2)
,(@time_zone_id, -84380400, 1)
,(@time_zone_id, -68659200, 2)
,(@time_zone_id, -52930800, 1)
,(@time_zone_id, -37209600, 2)
,(@time_zone_id, -21481200, 1)
,(@time_zone_id, -5760000, 2)
,(@time_zone_id, 9968400, 1)
,(@time_zone_id, 25689600, 2)
,(@time_zone_id, 41418000, 1)
,(@time_zone_id, 57744000, 2)
,(@time_zone_id, 73472400, 1)
,(@time_zone_id, 89193600, 2)
,(@time_zone_id, 104922000, 1)
,(@time_zone_id, 120643200, 2)
,(@time_zone_id, 126694800, 1)
,(@time_zone_id, 152092800, 2)
,(@time_zone_id, 162378000, 1)
,(@time_zone_id, 183542400, 2)
,(@time_zone_id, 199270800, 1)
,(@time_zone_id, 215596800, 2)
,(@time_zone_id, 230720400, 1)
,(@time_zone_id, 247046400, 2)
,(@time_zone_id, 262774800, 1)
,(@time_zone_id, 278496000, 2)
,(@time_zone_id, 294224400, 1)
,(@time_zone_id, 309945600, 2)
,(@time_zone_id, 325674000, 1)
,(@time_zone_id, 341395200, 2)
,(@time_zone_id, 357123600, 1)
,(@time_zone_id, 372844800, 2)
,(@time_zone_id, 388573200, 1)
,(@time_zone_id, 404899200, 2)
,(@time_zone_id, 420022800, 1)
,(@time_zone_id, 436348800, 2)
,(@time_zone_id, 452077200, 1)
,(@time_zone_id, 467798400, 2)
,(@time_zone_id, 483526800, 1)
,(@time_zone_id, 499248000, 2)
,(@time_zone_id, 514976400, 1)
,(@time_zone_id, 530697600, 2)
,(@time_zone_id, 544611600, 1)
,(@time_zone_id, 562147200, 2)
,(@time_zone_id, 576061200, 1)
,(@time_zone_id, 594201600, 2)
,(@time_zone_id, 607510800, 1)
,(@time_zone_id, 625651200, 2)
,(@time_zone_id, 638960400, 1)
,(@time_zone_id, 657100800, 2)
,(@time_zone_id, 671014800, 1)
,(@time_zone_id, 688550400, 2)
,(@time_zone_id, 702464400, 1)
,(@time_zone_id, 720000000, 2)
,(@time_zone_id, 733914000, 1)
,(@time_zone_id, 752054400, 2)
,(@time_zone_id, 765363600, 1)
,(@time_zone_id, 783504000, 2)
,(@time_zone_id, 796813200, 1)
,(@time_zone_id, 814953600, 2)
,(@time_zone_id, 828867600, 1)
,(@time_zone_id, 846403200, 2)
,(@time_zone_id, 860317200, 1)
,(@time_zone_id, 877852800, 2)
,(@time_zone_id, 891766800, 1)
,(@time_zone_id, 909302400, 2)
,(@time_zone_id, 923216400, 1)
,(@time_zone_id, 941356800, 2)
,(@time_zone_id, 954666000, 1)
,(@time_zone_id, 972806400, 2)
,(@time_zone_id, 986115600, 1)
,(@time_zone_id, 1004256000, 2)
,(@time_zone_id, 1018170000, 1)
,(@time_zone_id, 1035705600, 2)
,(@time_zone_id, 1049619600, 1)
,(@time_zone_id, 1067155200, 2)
,(@time_zone_id, 1081069200, 1)
,(@time_zone_id, 1099209600, 2)
,(@time_zone_id, 1112518800, 1)
,(@time_zone_id, 1130659200, 2)
,(@time_zone_id, 1143968400, 1)
,(@time_zone_id, 1162108800, 2)
,(@time_zone_id, 1173603600, 1)
,(@time_zone_id, 1194163200, 2)
,(@time_zone_id, 1205053200, 1)
,(@time_zone_id, 1225612800, 2)
,(@time_zone_id, 1236502800, 1)
,(@time_zone_id, 1257062400, 2)
,(@time_zone_id, 1268557200, 1)
,(@time_zone_id, 1289116800, 2)
,(@time_zone_id, 1300006800, 1)
,(@time_zone_id, 1320566400, 2)
,(@time_zone_id, 1331456400, 1)
,(@time_zone_id, 1352016000, 2)
,(@time_zone_id, 1362906000, 1)
,(@time_zone_id, 1383465600, 2)
,(@time_zone_id, 1394355600, 1)
,(@time_zone_id, 1414915200, 2)
,(@time_zone_id, 1425805200, 1)
,(@time_zone_id, 1446364800, 2)
,(@time_zone_id, 1457859600, 1)
,(@time_zone_id, 1478419200, 2)
,(@time_zone_id, 1489309200, 1)
,(@time_zone_id, 1509868800, 2)
,(@time_zone_id, 1520758800, 1)
,(@time_zone_id, 1541318400, 2)
,(@time_zone_id, 1552208400, 1)
,(@time_zone_id, 1572768000, 2)
,(@time_zone_id, 1583658000, 1)
,(@time_zone_id, 1604217600, 2)
,(@time_zone_id, 1615712400, 1)
,(@time_zone_id, 1636272000, 2)
,(@time_zone_id, 1647162000, 1)
,(@time_zone_id, 1667721600, 2)
,(@time_zone_id, 1678611600, 1)
,(@time_zone_id, 1699171200, 2)
,(@time_zone_id, 1710061200, 1)
,(@time_zone_id, 1730620800, 2)
,(@time_zone_id, 1741510800, 1)
,(@time_zone_id, 1762070400, 2)
,(@time_zone_id, 1772960400, 1)
,(@time_zone_id, 1793520000, 2)
,(@time_zone_id, 1805014800, 1)
,(@time_zone_id, 1825574400, 2)
,(@time_zone_id, 1836464400, 1)
,(@time_zone_id, 1857024000, 2)
,(@time_zone_id, 1867914000, 1)
,(@time_zone_id, 1888473600, 2)
,(@time_zone_id, 1899363600, 1)
,(@time_zone_id, 1919923200, 2)
,(@time_zone_id, 1930813200, 1)
,(@time_zone_id, 1951372800, 2)
,(@time_zone_id, 1962867600, 1)
,(@time_zone_id, 1983427200, 2)
,(@time_zone_id, 1994317200, 1)
,(@time_zone_id, 2014876800, 2)
,(@time_zone_id, 2025766800, 1)
,(@time_zone_id, 2046326400, 2)
,(@time_zone_id, 2057216400, 1)
,(@time_zone_id, 2077776000, 2)
,(@time_zone_id, 2088666000, 1)
,(@time_zone_id, 2109225600, 2)
,(@time_zone_id, 2120115600, 1)
,(@time_zone_id, 2140675200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -25196, 0, 'LMT')
,(@time_zone_id, 1, -21600, 1, 'MDT')
,(@time_zone_id, 2, -25200, 0, 'MST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
,(@time_zone_id, 4, -21600, 1, 'MPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Sitka', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -880207200, 2)
,(@time_zone_id, -769395600, 3)
,(@time_zone_id, -765385200, 1)
,(@time_zone_id, -21477600, 4)
,(@time_zone_id, -5756400, 1)
,(@time_zone_id, 9972000, 4)
,(@time_zone_id, 25693200, 1)
,(@time_zone_id, 41421600, 4)
,(@time_zone_id, 57747600, 1)
,(@time_zone_id, 73476000, 4)
,(@time_zone_id, 89197200, 1)
,(@time_zone_id, 104925600, 4)
,(@time_zone_id, 120646800, 1)
,(@time_zone_id, 126698400, 4)
,(@time_zone_id, 152096400, 1)
,(@time_zone_id, 162381600, 4)
,(@time_zone_id, 183546000, 1)
,(@time_zone_id, 199274400, 4)
,(@time_zone_id, 215600400, 1)
,(@time_zone_id, 230724000, 4)
,(@time_zone_id, 247050000, 1)
,(@time_zone_id, 262778400, 4)
,(@time_zone_id, 278499600, 1)
,(@time_zone_id, 294228000, 4)
,(@time_zone_id, 309949200, 1)
,(@time_zone_id, 325677600, 4)
,(@time_zone_id, 341398800, 1)
,(@time_zone_id, 357127200, 4)
,(@time_zone_id, 372848400, 1)
,(@time_zone_id, 388576800, 4)
,(@time_zone_id, 404902800, 1)
,(@time_zone_id, 420026400, 4)
,(@time_zone_id, 436352400, 5)
,(@time_zone_id, 439030800, 7)
,(@time_zone_id, 452084400, 6)
,(@time_zone_id, 467805600, 7)
,(@time_zone_id, 483534000, 6)
,(@time_zone_id, 499255200, 7)
,(@time_zone_id, 514983600, 6)
,(@time_zone_id, 530704800, 7)
,(@time_zone_id, 544618800, 6)
,(@time_zone_id, 562154400, 7)
,(@time_zone_id, 576068400, 6)
,(@time_zone_id, 594208800, 7)
,(@time_zone_id, 607518000, 6)
,(@time_zone_id, 625658400, 7)
,(@time_zone_id, 638967600, 6)
,(@time_zone_id, 657108000, 7)
,(@time_zone_id, 671022000, 6)
,(@time_zone_id, 688557600, 7)
,(@time_zone_id, 702471600, 6)
,(@time_zone_id, 720007200, 7)
,(@time_zone_id, 733921200, 6)
,(@time_zone_id, 752061600, 7)
,(@time_zone_id, 765370800, 6)
,(@time_zone_id, 783511200, 7)
,(@time_zone_id, 796820400, 6)
,(@time_zone_id, 814960800, 7)
,(@time_zone_id, 828874800, 6)
,(@time_zone_id, 846410400, 7)
,(@time_zone_id, 860324400, 6)
,(@time_zone_id, 877860000, 7)
,(@time_zone_id, 891774000, 6)
,(@time_zone_id, 909309600, 7)
,(@time_zone_id, 923223600, 6)
,(@time_zone_id, 941364000, 7)
,(@time_zone_id, 954673200, 6)
,(@time_zone_id, 972813600, 7)
,(@time_zone_id, 986122800, 6)
,(@time_zone_id, 1004263200, 7)
,(@time_zone_id, 1018177200, 6)
,(@time_zone_id, 1035712800, 7)
,(@time_zone_id, 1049626800, 6)
,(@time_zone_id, 1067162400, 7)
,(@time_zone_id, 1081076400, 6)
,(@time_zone_id, 1099216800, 7)
,(@time_zone_id, 1112526000, 6)
,(@time_zone_id, 1130666400, 7)
,(@time_zone_id, 1143975600, 6)
,(@time_zone_id, 1162116000, 7)
,(@time_zone_id, 1173610800, 6)
,(@time_zone_id, 1194170400, 7)
,(@time_zone_id, 1205060400, 6)
,(@time_zone_id, 1225620000, 7)
,(@time_zone_id, 1236510000, 6)
,(@time_zone_id, 1257069600, 7)
,(@time_zone_id, 1268564400, 6)
,(@time_zone_id, 1289124000, 7)
,(@time_zone_id, 1300014000, 6)
,(@time_zone_id, 1320573600, 7)
,(@time_zone_id, 1331463600, 6)
,(@time_zone_id, 1352023200, 7)
,(@time_zone_id, 1362913200, 6)
,(@time_zone_id, 1383472800, 7)
,(@time_zone_id, 1394362800, 6)
,(@time_zone_id, 1414922400, 7)
,(@time_zone_id, 1425812400, 6)
,(@time_zone_id, 1446372000, 7)
,(@time_zone_id, 1457866800, 6)
,(@time_zone_id, 1478426400, 7)
,(@time_zone_id, 1489316400, 6)
,(@time_zone_id, 1509876000, 7)
,(@time_zone_id, 1520766000, 6)
,(@time_zone_id, 1541325600, 7)
,(@time_zone_id, 1552215600, 6)
,(@time_zone_id, 1572775200, 7)
,(@time_zone_id, 1583665200, 6)
,(@time_zone_id, 1604224800, 7)
,(@time_zone_id, 1615719600, 6)
,(@time_zone_id, 1636279200, 7)
,(@time_zone_id, 1647169200, 6)
,(@time_zone_id, 1667728800, 7)
,(@time_zone_id, 1678618800, 6)
,(@time_zone_id, 1699178400, 7)
,(@time_zone_id, 1710068400, 6)
,(@time_zone_id, 1730628000, 7)
,(@time_zone_id, 1741518000, 6)
,(@time_zone_id, 1762077600, 7)
,(@time_zone_id, 1772967600, 6)
,(@time_zone_id, 1793527200, 7)
,(@time_zone_id, 1805022000, 6)
,(@time_zone_id, 1825581600, 7)
,(@time_zone_id, 1836471600, 6)
,(@time_zone_id, 1857031200, 7)
,(@time_zone_id, 1867921200, 6)
,(@time_zone_id, 1888480800, 7)
,(@time_zone_id, 1899370800, 6)
,(@time_zone_id, 1919930400, 7)
,(@time_zone_id, 1930820400, 6)
,(@time_zone_id, 1951380000, 7)
,(@time_zone_id, 1962874800, 6)
,(@time_zone_id, 1983434400, 7)
,(@time_zone_id, 1994324400, 6)
,(@time_zone_id, 2014884000, 7)
,(@time_zone_id, 2025774000, 6)
,(@time_zone_id, 2046333600, 7)
,(@time_zone_id, 2057223600, 6)
,(@time_zone_id, 2077783200, 7)
,(@time_zone_id, 2088673200, 6)
,(@time_zone_id, 2109232800, 7)
,(@time_zone_id, 2120122800, 6)
,(@time_zone_id, 2140682400, 7)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -32473, 0, 'LMT')
,(@time_zone_id, 1, -28800, 0, 'PST')
,(@time_zone_id, 2, -25200, 1, 'PWT')
,(@time_zone_id, 3, -25200, 1, 'PPT')
,(@time_zone_id, 4, -25200, 1, 'PDT')
,(@time_zone_id, 5, -32400, 0, 'YST')
,(@time_zone_id, 6, -28800, 1, 'AKDT')
,(@time_zone_id, 7, -32400, 0, 'AKST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/St_Barthelemy', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/St_Johns', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1664130548, 1)
,(@time_zone_id, -1650137348, 2)
,(@time_zone_id, -1632076148, 1)
,(@time_zone_id, -1615145348, 2)
,(@time_zone_id, -1598650148, 1)
,(@time_zone_id, -1590100148, 2)
,(@time_zone_id, -1567286948, 1)
,(@time_zone_id, -1551565748, 2)
,(@time_zone_id, -1535837348, 1)
,(@time_zone_id, -1520116148, 2)
,(@time_zone_id, -1503782948, 1)
,(@time_zone_id, -1488666548, 2)
,(@time_zone_id, -1472333348, 1)
,(@time_zone_id, -1457216948, 2)
,(@time_zone_id, -1440883748, 1)
,(@time_zone_id, -1425767348, 2)
,(@time_zone_id, -1409434148, 1)
,(@time_zone_id, -1394317748, 2)
,(@time_zone_id, -1377984548, 1)
,(@time_zone_id, -1362263348, 2)
,(@time_zone_id, -1346534948, 1)
,(@time_zone_id, -1330813748, 2)
,(@time_zone_id, -1314480548, 1)
,(@time_zone_id, -1299364148, 2)
,(@time_zone_id, -1283030948, 1)
,(@time_zone_id, -1267914548, 2)
,(@time_zone_id, -1251581348, 1)
,(@time_zone_id, -1236464948, 2)
,(@time_zone_id, -1220131748, 1)
,(@time_zone_id, -1205015348, 2)
,(@time_zone_id, -1188682148, 1)
,(@time_zone_id, -1172960948, 2)
,(@time_zone_id, -1156627748, 1)
,(@time_zone_id, -1141511348, 2)
,(@time_zone_id, -1125178148, 1)
,(@time_zone_id, -1110061748, 2)
,(@time_zone_id, -1096921748, 4)
,(@time_zone_id, -1093728600, 3)
,(@time_zone_id, -1078612200, 4)
,(@time_zone_id, -1061670600, 3)
,(@time_zone_id, -1048973400, 4)
,(@time_zone_id, -1030221000, 3)
,(@time_zone_id, -1017523800, 4)
,(@time_zone_id, -998771400, 3)
,(@time_zone_id, -986074200, 4)
,(@time_zone_id, -966717000, 3)
,(@time_zone_id, -954624600, 4)
,(@time_zone_id, -935267400, 3)
,(@time_zone_id, -922570200, 4)
,(@time_zone_id, -903817800, 3)
,(@time_zone_id, -891120600, 4)
,(@time_zone_id, -872368200, 6)
,(@time_zone_id, -769395600, 5)
,(@time_zone_id, -765401400, 4)
,(@time_zone_id, -746044200, 3)
,(@time_zone_id, -733347000, 4)
,(@time_zone_id, -714594600, 3)
,(@time_zone_id, -701897400, 4)
,(@time_zone_id, -683145000, 3)
,(@time_zone_id, -670447800, 4)
,(@time_zone_id, -651695400, 3)
,(@time_zone_id, -638998200, 4)
,(@time_zone_id, -619641000, 3)
,(@time_zone_id, -606943800, 4)
,(@time_zone_id, -589401000, 3)
,(@time_zone_id, -576099000, 4)
,(@time_zone_id, -557951400, 3)
,(@time_zone_id, -544649400, 4)
,(@time_zone_id, -526501800, 3)
,(@time_zone_id, -513199800, 4)
,(@time_zone_id, -495052200, 3)
,(@time_zone_id, -481750200, 4)
,(@time_zone_id, -463602600, 3)
,(@time_zone_id, -450300600, 4)
,(@time_zone_id, -431548200, 3)
,(@time_zone_id, -418246200, 4)
,(@time_zone_id, -400098600, 3)
,(@time_zone_id, -386796600, 4)
,(@time_zone_id, -368649000, 3)
,(@time_zone_id, -355347000, 4)
,(@time_zone_id, -337199400, 3)
,(@time_zone_id, -323897400, 4)
,(@time_zone_id, -305749800, 3)
,(@time_zone_id, -289423800, 4)
,(@time_zone_id, -273695400, 3)
,(@time_zone_id, -257974200, 4)
,(@time_zone_id, -242245800, 3)
,(@time_zone_id, -226524600, 4)
,(@time_zone_id, -210796200, 3)
,(@time_zone_id, -195075000, 4)
,(@time_zone_id, -179346600, 3)
,(@time_zone_id, -163625400, 4)
,(@time_zone_id, -147897000, 3)
,(@time_zone_id, -131571000, 4)
,(@time_zone_id, -116447400, 3)
,(@time_zone_id, -100121400, 4)
,(@time_zone_id, -84393000, 3)
,(@time_zone_id, -68671800, 4)
,(@time_zone_id, -52943400, 3)
,(@time_zone_id, -37222200, 4)
,(@time_zone_id, -21493800, 3)
,(@time_zone_id, -5772600, 4)
,(@time_zone_id, 9955800, 3)
,(@time_zone_id, 25677000, 4)
,(@time_zone_id, 41405400, 3)
,(@time_zone_id, 57731400, 4)
,(@time_zone_id, 73459800, 3)
,(@time_zone_id, 89181000, 4)
,(@time_zone_id, 104909400, 3)
,(@time_zone_id, 120630600, 4)
,(@time_zone_id, 136359000, 3)
,(@time_zone_id, 152080200, 4)
,(@time_zone_id, 167808600, 3)
,(@time_zone_id, 183529800, 4)
,(@time_zone_id, 199258200, 3)
,(@time_zone_id, 215584200, 4)
,(@time_zone_id, 230707800, 3)
,(@time_zone_id, 247033800, 4)
,(@time_zone_id, 262762200, 3)
,(@time_zone_id, 278483400, 4)
,(@time_zone_id, 294211800, 3)
,(@time_zone_id, 309933000, 4)
,(@time_zone_id, 325661400, 3)
,(@time_zone_id, 341382600, 4)
,(@time_zone_id, 357111000, 3)
,(@time_zone_id, 372832200, 4)
,(@time_zone_id, 388560600, 3)
,(@time_zone_id, 404886600, 4)
,(@time_zone_id, 420010200, 3)
,(@time_zone_id, 436336200, 4)
,(@time_zone_id, 452064600, 3)
,(@time_zone_id, 467785800, 4)
,(@time_zone_id, 483514200, 3)
,(@time_zone_id, 499235400, 4)
,(@time_zone_id, 514963800, 3)
,(@time_zone_id, 530685000, 4)
,(@time_zone_id, 544591860, 3)
,(@time_zone_id, 562127460, 4)
,(@time_zone_id, 576041460, 7)
,(@time_zone_id, 594178260, 4)
,(@time_zone_id, 607491060, 3)
,(@time_zone_id, 625631460, 4)
,(@time_zone_id, 638940660, 3)
,(@time_zone_id, 657081060, 4)
,(@time_zone_id, 670995060, 3)
,(@time_zone_id, 688530660, 4)
,(@time_zone_id, 702444660, 3)
,(@time_zone_id, 719980260, 4)
,(@time_zone_id, 733894260, 3)
,(@time_zone_id, 752034660, 4)
,(@time_zone_id, 765343860, 3)
,(@time_zone_id, 783484260, 4)
,(@time_zone_id, 796793460, 3)
,(@time_zone_id, 814933860, 4)
,(@time_zone_id, 828847860, 3)
,(@time_zone_id, 846383460, 4)
,(@time_zone_id, 860297460, 3)
,(@time_zone_id, 877833060, 4)
,(@time_zone_id, 891747060, 3)
,(@time_zone_id, 909282660, 4)
,(@time_zone_id, 923196660, 3)
,(@time_zone_id, 941337060, 4)
,(@time_zone_id, 954646260, 3)
,(@time_zone_id, 972786660, 4)
,(@time_zone_id, 986095860, 3)
,(@time_zone_id, 1004236260, 4)
,(@time_zone_id, 1018150260, 3)
,(@time_zone_id, 1035685860, 4)
,(@time_zone_id, 1049599860, 3)
,(@time_zone_id, 1067135460, 4)
,(@time_zone_id, 1081049460, 3)
,(@time_zone_id, 1099189860, 4)
,(@time_zone_id, 1112499060, 3)
,(@time_zone_id, 1130639460, 4)
,(@time_zone_id, 1143948660, 3)
,(@time_zone_id, 1162089060, 4)
,(@time_zone_id, 1173583860, 3)
,(@time_zone_id, 1194143460, 4)
,(@time_zone_id, 1205033460, 3)
,(@time_zone_id, 1225593060, 4)
,(@time_zone_id, 1236483060, 3)
,(@time_zone_id, 1257042660, 4)
,(@time_zone_id, 1268537460, 3)
,(@time_zone_id, 1289097060, 4)
,(@time_zone_id, 1299987060, 3)
,(@time_zone_id, 1320553800, 4)
,(@time_zone_id, 1331443800, 3)
,(@time_zone_id, 1352003400, 4)
,(@time_zone_id, 1362893400, 3)
,(@time_zone_id, 1383453000, 4)
,(@time_zone_id, 1394343000, 3)
,(@time_zone_id, 1414902600, 4)
,(@time_zone_id, 1425792600, 3)
,(@time_zone_id, 1446352200, 4)
,(@time_zone_id, 1457847000, 3)
,(@time_zone_id, 1478406600, 4)
,(@time_zone_id, 1489296600, 3)
,(@time_zone_id, 1509856200, 4)
,(@time_zone_id, 1520746200, 3)
,(@time_zone_id, 1541305800, 4)
,(@time_zone_id, 1552195800, 3)
,(@time_zone_id, 1572755400, 4)
,(@time_zone_id, 1583645400, 3)
,(@time_zone_id, 1604205000, 4)
,(@time_zone_id, 1615699800, 3)
,(@time_zone_id, 1636259400, 4)
,(@time_zone_id, 1647149400, 3)
,(@time_zone_id, 1667709000, 4)
,(@time_zone_id, 1678599000, 3)
,(@time_zone_id, 1699158600, 4)
,(@time_zone_id, 1710048600, 3)
,(@time_zone_id, 1730608200, 4)
,(@time_zone_id, 1741498200, 3)
,(@time_zone_id, 1762057800, 4)
,(@time_zone_id, 1772947800, 3)
,(@time_zone_id, 1793507400, 4)
,(@time_zone_id, 1805002200, 3)
,(@time_zone_id, 1825561800, 4)
,(@time_zone_id, 1836451800, 3)
,(@time_zone_id, 1857011400, 4)
,(@time_zone_id, 1867901400, 3)
,(@time_zone_id, 1888461000, 4)
,(@time_zone_id, 1899351000, 3)
,(@time_zone_id, 1919910600, 4)
,(@time_zone_id, 1930800600, 3)
,(@time_zone_id, 1951360200, 4)
,(@time_zone_id, 1962855000, 3)
,(@time_zone_id, 1983414600, 4)
,(@time_zone_id, 1994304600, 3)
,(@time_zone_id, 2014864200, 4)
,(@time_zone_id, 2025754200, 3)
,(@time_zone_id, 2046313800, 4)
,(@time_zone_id, 2057203800, 3)
,(@time_zone_id, 2077763400, 4)
,(@time_zone_id, 2088653400, 3)
,(@time_zone_id, 2109213000, 4)
,(@time_zone_id, 2120103000, 3)
,(@time_zone_id, 2140662600, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -12652, 0, 'LMT')
,(@time_zone_id, 1, -9052, 1, 'NDT')
,(@time_zone_id, 2, -12652, 0, 'NST')
,(@time_zone_id, 3, -9000, 1, 'NDT')
,(@time_zone_id, 4, -12600, 0, 'NST')
,(@time_zone_id, 5, -9000, 1, 'NPT')
,(@time_zone_id, 6, -9000, 1, 'NWT')
,(@time_zone_id, 7, -5400, 1, 'NDDT')
,(@time_zone_id, 8, -9000, 1, 'NDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/St_Kitts', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/St_Lucia', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/St_Thomas', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/St_Vincent', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Swift_Current', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2030201320, 2)
,(@time_zone_id, -1632063600, 1)
,(@time_zone_id, -1615132800, 2)
,(@time_zone_id, -880210800, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765388800, 2)
,(@time_zone_id, -747241200, 1)
,(@time_zone_id, -732729600, 2)
,(@time_zone_id, -715791600, 1)
,(@time_zone_id, -702489600, 2)
,(@time_zone_id, -684342000, 1)
,(@time_zone_id, -671040000, 2)
,(@time_zone_id, -652892400, 1)
,(@time_zone_id, -639590400, 2)
,(@time_zone_id, -400086000, 1)
,(@time_zone_id, -384364800, 2)
,(@time_zone_id, -337186800, 1)
,(@time_zone_id, -321465600, 2)
,(@time_zone_id, -305737200, 1)
,(@time_zone_id, -292435200, 2)
,(@time_zone_id, -273682800, 1)
,(@time_zone_id, -260985600, 2)
,(@time_zone_id, 73472400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -25880, 0, 'LMT')
,(@time_zone_id, 1, -21600, 1, 'MDT')
,(@time_zone_id, 2, -25200, 0, 'MST')
,(@time_zone_id, 3, -21600, 1, 'MWT')
,(@time_zone_id, 4, -21600, 1, 'MPT')
,(@time_zone_id, 5, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Tegucigalpa', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1538503868, 2)
,(@time_zone_id, 547020000, 1)
,(@time_zone_id, 559717200, 2)
,(@time_zone_id, 578469600, 1)
,(@time_zone_id, 591166800, 2)
,(@time_zone_id, 1146981600, 1)
,(@time_zone_id, 1154926800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -20932, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Thule', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1686079492, 2)
,(@time_zone_id, 670399200, 1)
,(@time_zone_id, 686120400, 2)
,(@time_zone_id, 701848800, 1)
,(@time_zone_id, 717570000, 2)
,(@time_zone_id, 733903200, 1)
,(@time_zone_id, 752043600, 2)
,(@time_zone_id, 765352800, 1)
,(@time_zone_id, 783493200, 2)
,(@time_zone_id, 796802400, 1)
,(@time_zone_id, 814942800, 2)
,(@time_zone_id, 828856800, 1)
,(@time_zone_id, 846392400, 2)
,(@time_zone_id, 860306400, 1)
,(@time_zone_id, 877842000, 2)
,(@time_zone_id, 891756000, 1)
,(@time_zone_id, 909291600, 2)
,(@time_zone_id, 923205600, 1)
,(@time_zone_id, 941346000, 2)
,(@time_zone_id, 954655200, 1)
,(@time_zone_id, 972795600, 2)
,(@time_zone_id, 986104800, 1)
,(@time_zone_id, 1004245200, 2)
,(@time_zone_id, 1018159200, 1)
,(@time_zone_id, 1035694800, 2)
,(@time_zone_id, 1049608800, 1)
,(@time_zone_id, 1067144400, 2)
,(@time_zone_id, 1081058400, 1)
,(@time_zone_id, 1099198800, 2)
,(@time_zone_id, 1112508000, 1)
,(@time_zone_id, 1130648400, 2)
,(@time_zone_id, 1143957600, 1)
,(@time_zone_id, 1162098000, 2)
,(@time_zone_id, 1173592800, 1)
,(@time_zone_id, 1194152400, 2)
,(@time_zone_id, 1205042400, 1)
,(@time_zone_id, 1225602000, 2)
,(@time_zone_id, 1236492000, 1)
,(@time_zone_id, 1257051600, 2)
,(@time_zone_id, 1268546400, 1)
,(@time_zone_id, 1289106000, 2)
,(@time_zone_id, 1299996000, 1)
,(@time_zone_id, 1320555600, 2)
,(@time_zone_id, 1331445600, 1)
,(@time_zone_id, 1352005200, 2)
,(@time_zone_id, 1362895200, 1)
,(@time_zone_id, 1383454800, 2)
,(@time_zone_id, 1394344800, 1)
,(@time_zone_id, 1414904400, 2)
,(@time_zone_id, 1425794400, 1)
,(@time_zone_id, 1446354000, 2)
,(@time_zone_id, 1457848800, 1)
,(@time_zone_id, 1478408400, 2)
,(@time_zone_id, 1489298400, 1)
,(@time_zone_id, 1509858000, 2)
,(@time_zone_id, 1520748000, 1)
,(@time_zone_id, 1541307600, 2)
,(@time_zone_id, 1552197600, 1)
,(@time_zone_id, 1572757200, 2)
,(@time_zone_id, 1583647200, 1)
,(@time_zone_id, 1604206800, 2)
,(@time_zone_id, 1615701600, 1)
,(@time_zone_id, 1636261200, 2)
,(@time_zone_id, 1647151200, 1)
,(@time_zone_id, 1667710800, 2)
,(@time_zone_id, 1678600800, 1)
,(@time_zone_id, 1699160400, 2)
,(@time_zone_id, 1710050400, 1)
,(@time_zone_id, 1730610000, 2)
,(@time_zone_id, 1741500000, 1)
,(@time_zone_id, 1762059600, 2)
,(@time_zone_id, 1772949600, 1)
,(@time_zone_id, 1793509200, 2)
,(@time_zone_id, 1805004000, 1)
,(@time_zone_id, 1825563600, 2)
,(@time_zone_id, 1836453600, 1)
,(@time_zone_id, 1857013200, 2)
,(@time_zone_id, 1867903200, 1)
,(@time_zone_id, 1888462800, 2)
,(@time_zone_id, 1899352800, 1)
,(@time_zone_id, 1919912400, 2)
,(@time_zone_id, 1930802400, 1)
,(@time_zone_id, 1951362000, 2)
,(@time_zone_id, 1962856800, 1)
,(@time_zone_id, 1983416400, 2)
,(@time_zone_id, 1994306400, 1)
,(@time_zone_id, 2014866000, 2)
,(@time_zone_id, 2025756000, 1)
,(@time_zone_id, 2046315600, 2)
,(@time_zone_id, 2057205600, 1)
,(@time_zone_id, 2077765200, 2)
,(@time_zone_id, 2088655200, 1)
,(@time_zone_id, 2109214800, 2)
,(@time_zone_id, 2120104800, 1)
,(@time_zone_id, 2140664400, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -16508, 0, 'LMT')
,(@time_zone_id, 1, -10800, 1, 'ADT')
,(@time_zone_id, 2, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Thunder_Bay', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1893434400, 2)
,(@time_zone_id, -880218000, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765396000, 2)
,(@time_zone_id, 9961200, 5)
,(@time_zone_id, 25682400, 2)
,(@time_zone_id, 41410800, 5)
,(@time_zone_id, 57736800, 2)
,(@time_zone_id, 73465200, 5)
,(@time_zone_id, 89186400, 2)
,(@time_zone_id, 136364400, 5)
,(@time_zone_id, 152085600, 2)
,(@time_zone_id, 167814000, 5)
,(@time_zone_id, 183535200, 2)
,(@time_zone_id, 199263600, 5)
,(@time_zone_id, 215589600, 2)
,(@time_zone_id, 230713200, 5)
,(@time_zone_id, 247039200, 2)
,(@time_zone_id, 262767600, 5)
,(@time_zone_id, 278488800, 2)
,(@time_zone_id, 294217200, 5)
,(@time_zone_id, 309938400, 2)
,(@time_zone_id, 325666800, 5)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 5)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 5)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 5)
,(@time_zone_id, 436341600, 2)
,(@time_zone_id, 452070000, 5)
,(@time_zone_id, 467791200, 2)
,(@time_zone_id, 483519600, 5)
,(@time_zone_id, 499240800, 2)
,(@time_zone_id, 514969200, 5)
,(@time_zone_id, 530690400, 2)
,(@time_zone_id, 544604400, 5)
,(@time_zone_id, 562140000, 2)
,(@time_zone_id, 576054000, 5)
,(@time_zone_id, 594194400, 2)
,(@time_zone_id, 607503600, 5)
,(@time_zone_id, 625644000, 2)
,(@time_zone_id, 638953200, 5)
,(@time_zone_id, 657093600, 2)
,(@time_zone_id, 671007600, 5)
,(@time_zone_id, 688543200, 2)
,(@time_zone_id, 702457200, 5)
,(@time_zone_id, 719992800, 2)
,(@time_zone_id, 733906800, 5)
,(@time_zone_id, 752047200, 2)
,(@time_zone_id, 765356400, 5)
,(@time_zone_id, 783496800, 2)
,(@time_zone_id, 796806000, 5)
,(@time_zone_id, 814946400, 2)
,(@time_zone_id, 828860400, 5)
,(@time_zone_id, 846396000, 2)
,(@time_zone_id, 860310000, 5)
,(@time_zone_id, 877845600, 2)
,(@time_zone_id, 891759600, 5)
,(@time_zone_id, 909295200, 2)
,(@time_zone_id, 923209200, 5)
,(@time_zone_id, 941349600, 2)
,(@time_zone_id, 954658800, 5)
,(@time_zone_id, 972799200, 2)
,(@time_zone_id, 986108400, 5)
,(@time_zone_id, 1004248800, 2)
,(@time_zone_id, 1018162800, 5)
,(@time_zone_id, 1035698400, 2)
,(@time_zone_id, 1049612400, 5)
,(@time_zone_id, 1067148000, 2)
,(@time_zone_id, 1081062000, 5)
,(@time_zone_id, 1099202400, 2)
,(@time_zone_id, 1112511600, 5)
,(@time_zone_id, 1130652000, 2)
,(@time_zone_id, 1143961200, 5)
,(@time_zone_id, 1162101600, 2)
,(@time_zone_id, 1173596400, 5)
,(@time_zone_id, 1194156000, 2)
,(@time_zone_id, 1205046000, 5)
,(@time_zone_id, 1225605600, 2)
,(@time_zone_id, 1236495600, 5)
,(@time_zone_id, 1257055200, 2)
,(@time_zone_id, 1268550000, 5)
,(@time_zone_id, 1289109600, 2)
,(@time_zone_id, 1299999600, 5)
,(@time_zone_id, 1320559200, 2)
,(@time_zone_id, 1331449200, 5)
,(@time_zone_id, 1352008800, 2)
,(@time_zone_id, 1362898800, 5)
,(@time_zone_id, 1383458400, 2)
,(@time_zone_id, 1394348400, 5)
,(@time_zone_id, 1414908000, 2)
,(@time_zone_id, 1425798000, 5)
,(@time_zone_id, 1446357600, 2)
,(@time_zone_id, 1457852400, 5)
,(@time_zone_id, 1478412000, 2)
,(@time_zone_id, 1489302000, 5)
,(@time_zone_id, 1509861600, 2)
,(@time_zone_id, 1520751600, 5)
,(@time_zone_id, 1541311200, 2)
,(@time_zone_id, 1552201200, 5)
,(@time_zone_id, 1572760800, 2)
,(@time_zone_id, 1583650800, 5)
,(@time_zone_id, 1604210400, 2)
,(@time_zone_id, 1615705200, 5)
,(@time_zone_id, 1636264800, 2)
,(@time_zone_id, 1647154800, 5)
,(@time_zone_id, 1667714400, 2)
,(@time_zone_id, 1678604400, 5)
,(@time_zone_id, 1699164000, 2)
,(@time_zone_id, 1710054000, 5)
,(@time_zone_id, 1730613600, 2)
,(@time_zone_id, 1741503600, 5)
,(@time_zone_id, 1762063200, 2)
,(@time_zone_id, 1772953200, 5)
,(@time_zone_id, 1793512800, 2)
,(@time_zone_id, 1805007600, 5)
,(@time_zone_id, 1825567200, 2)
,(@time_zone_id, 1836457200, 5)
,(@time_zone_id, 1857016800, 2)
,(@time_zone_id, 1867906800, 5)
,(@time_zone_id, 1888466400, 2)
,(@time_zone_id, 1899356400, 5)
,(@time_zone_id, 1919916000, 2)
,(@time_zone_id, 1930806000, 5)
,(@time_zone_id, 1951365600, 2)
,(@time_zone_id, 1962860400, 5)
,(@time_zone_id, 1983420000, 2)
,(@time_zone_id, 1994310000, 5)
,(@time_zone_id, 2014869600, 2)
,(@time_zone_id, 2025759600, 5)
,(@time_zone_id, 2046319200, 2)
,(@time_zone_id, 2057209200, 5)
,(@time_zone_id, 2077768800, 2)
,(@time_zone_id, 2088658800, 5)
,(@time_zone_id, 2109218400, 2)
,(@time_zone_id, 2120108400, 5)
,(@time_zone_id, 2140668000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -21420, 0, 'LMT')
,(@time_zone_id, 1, -21600, 0, 'CST')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -14400, 1, 'EWT')
,(@time_zone_id, 4, -14400, 1, 'EPT')
,(@time_zone_id, 5, -14400, 1, 'EDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Tijuana', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1514736000, 1)
,(@time_zone_id, -1451667600, 2)
,(@time_zone_id, -1343062800, 1)
,(@time_zone_id, -1234803600, 2)
,(@time_zone_id, -1222963200, 3)
,(@time_zone_id, -1207242000, 2)
,(@time_zone_id, -873820800, 4)
,(@time_zone_id, -769395600, 5)
,(@time_zone_id, -761677200, 2)
,(@time_zone_id, -686073600, 3)
,(@time_zone_id, -661539600, 2)
,(@time_zone_id, -495039600, 3)
,(@time_zone_id, -481734000, 2)
,(@time_zone_id, -463590000, 3)
,(@time_zone_id, -450284400, 2)
,(@time_zone_id, -431535600, 3)
,(@time_zone_id, -418230000, 2)
,(@time_zone_id, -400086000, 3)
,(@time_zone_id, -386780400, 2)
,(@time_zone_id, -368636400, 3)
,(@time_zone_id, -355330800, 2)
,(@time_zone_id, -337186800, 3)
,(@time_zone_id, -323881200, 2)
,(@time_zone_id, -305737200, 3)
,(@time_zone_id, -292431600, 2)
,(@time_zone_id, 199274400, 3)
,(@time_zone_id, 215600400, 2)
,(@time_zone_id, 230724000, 3)
,(@time_zone_id, 247050000, 2)
,(@time_zone_id, 262778400, 3)
,(@time_zone_id, 278499600, 2)
,(@time_zone_id, 294228000, 3)
,(@time_zone_id, 309949200, 2)
,(@time_zone_id, 325677600, 3)
,(@time_zone_id, 341398800, 2)
,(@time_zone_id, 357127200, 3)
,(@time_zone_id, 372848400, 2)
,(@time_zone_id, 388576800, 3)
,(@time_zone_id, 404902800, 2)
,(@time_zone_id, 420026400, 3)
,(@time_zone_id, 436352400, 2)
,(@time_zone_id, 452080800, 3)
,(@time_zone_id, 467802000, 2)
,(@time_zone_id, 483530400, 3)
,(@time_zone_id, 499251600, 2)
,(@time_zone_id, 514980000, 3)
,(@time_zone_id, 530701200, 2)
,(@time_zone_id, 544615200, 3)
,(@time_zone_id, 562150800, 2)
,(@time_zone_id, 576064800, 3)
,(@time_zone_id, 594205200, 2)
,(@time_zone_id, 607514400, 3)
,(@time_zone_id, 625654800, 2)
,(@time_zone_id, 638964000, 3)
,(@time_zone_id, 657104400, 2)
,(@time_zone_id, 671018400, 3)
,(@time_zone_id, 688554000, 2)
,(@time_zone_id, 702468000, 3)
,(@time_zone_id, 720003600, 2)
,(@time_zone_id, 733917600, 3)
,(@time_zone_id, 752058000, 2)
,(@time_zone_id, 765367200, 3)
,(@time_zone_id, 783507600, 2)
,(@time_zone_id, 796816800, 3)
,(@time_zone_id, 814957200, 2)
,(@time_zone_id, 828871200, 3)
,(@time_zone_id, 846406800, 2)
,(@time_zone_id, 860320800, 3)
,(@time_zone_id, 877856400, 2)
,(@time_zone_id, 891770400, 3)
,(@time_zone_id, 909306000, 2)
,(@time_zone_id, 923220000, 3)
,(@time_zone_id, 941360400, 2)
,(@time_zone_id, 954669600, 3)
,(@time_zone_id, 972810000, 2)
,(@time_zone_id, 986119200, 3)
,(@time_zone_id, 1004259600, 2)
,(@time_zone_id, 1018173600, 3)
,(@time_zone_id, 1035709200, 2)
,(@time_zone_id, 1049623200, 3)
,(@time_zone_id, 1067158800, 2)
,(@time_zone_id, 1081072800, 3)
,(@time_zone_id, 1099213200, 2)
,(@time_zone_id, 1112522400, 3)
,(@time_zone_id, 1130662800, 2)
,(@time_zone_id, 1143972000, 3)
,(@time_zone_id, 1162112400, 2)
,(@time_zone_id, 1175421600, 3)
,(@time_zone_id, 1193562000, 2)
,(@time_zone_id, 1207476000, 3)
,(@time_zone_id, 1225011600, 2)
,(@time_zone_id, 1238925600, 3)
,(@time_zone_id, 1256461200, 2)
,(@time_zone_id, 1268560800, 3)
,(@time_zone_id, 1289120400, 2)
,(@time_zone_id, 1300010400, 3)
,(@time_zone_id, 1320570000, 2)
,(@time_zone_id, 1331460000, 3)
,(@time_zone_id, 1352019600, 2)
,(@time_zone_id, 1362909600, 3)
,(@time_zone_id, 1383469200, 2)
,(@time_zone_id, 1394359200, 3)
,(@time_zone_id, 1414918800, 2)
,(@time_zone_id, 1425808800, 3)
,(@time_zone_id, 1446368400, 2)
,(@time_zone_id, 1457863200, 3)
,(@time_zone_id, 1478422800, 2)
,(@time_zone_id, 1489312800, 3)
,(@time_zone_id, 1509872400, 2)
,(@time_zone_id, 1520762400, 3)
,(@time_zone_id, 1541322000, 2)
,(@time_zone_id, 1552212000, 3)
,(@time_zone_id, 1572771600, 2)
,(@time_zone_id, 1583661600, 3)
,(@time_zone_id, 1604221200, 2)
,(@time_zone_id, 1615716000, 3)
,(@time_zone_id, 1636275600, 2)
,(@time_zone_id, 1647165600, 3)
,(@time_zone_id, 1667725200, 2)
,(@time_zone_id, 1678615200, 3)
,(@time_zone_id, 1699174800, 2)
,(@time_zone_id, 1710064800, 3)
,(@time_zone_id, 1730624400, 2)
,(@time_zone_id, 1741514400, 3)
,(@time_zone_id, 1762074000, 2)
,(@time_zone_id, 1772964000, 3)
,(@time_zone_id, 1793523600, 2)
,(@time_zone_id, 1805018400, 3)
,(@time_zone_id, 1825578000, 2)
,(@time_zone_id, 1836468000, 3)
,(@time_zone_id, 1857027600, 2)
,(@time_zone_id, 1867917600, 3)
,(@time_zone_id, 1888477200, 2)
,(@time_zone_id, 1899367200, 3)
,(@time_zone_id, 1919926800, 2)
,(@time_zone_id, 1930816800, 3)
,(@time_zone_id, 1951376400, 2)
,(@time_zone_id, 1962871200, 3)
,(@time_zone_id, 1983430800, 2)
,(@time_zone_id, 1994320800, 3)
,(@time_zone_id, 2014880400, 2)
,(@time_zone_id, 2025770400, 3)
,(@time_zone_id, 2046330000, 2)
,(@time_zone_id, 2057220000, 3)
,(@time_zone_id, 2077779600, 2)
,(@time_zone_id, 2088669600, 3)
,(@time_zone_id, 2109229200, 2)
,(@time_zone_id, 2120119200, 3)
,(@time_zone_id, 2140678800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -28084, 0, 'LMT')
,(@time_zone_id, 1, -25200, 0, 'MST')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -25200, 1, 'PDT')
,(@time_zone_id, 4, -25200, 1, 'PWT')
,(@time_zone_id, 5, -25200, 1, 'PPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Toronto', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632070800, 1)
,(@time_zone_id, -1615140000, 2)
,(@time_zone_id, -1601753400, 1)
,(@time_zone_id, -1583697600, 2)
,(@time_zone_id, -1567357200, 1)
,(@time_zone_id, -1554667200, 2)
,(@time_zone_id, -1534698000, 1)
,(@time_zone_id, -1524074400, 2)
,(@time_zone_id, -1503248400, 1)
,(@time_zone_id, -1492365600, 2)
,(@time_zone_id, -1471798800, 1)
,(@time_zone_id, -1460916000, 2)
,(@time_zone_id, -1440954000, 1)
,(@time_zone_id, -1428861600, 2)
,(@time_zone_id, -1409504400, 1)
,(@time_zone_id, -1397412000, 2)
,(@time_zone_id, -1378054800, 1)
,(@time_zone_id, -1365962400, 2)
,(@time_zone_id, -1346605200, 1)
,(@time_zone_id, -1333908000, 2)
,(@time_zone_id, -1315155600, 1)
,(@time_zone_id, -1301853600, 2)
,(@time_zone_id, -1283706000, 1)
,(@time_zone_id, -1270404000, 2)
,(@time_zone_id, -1252256400, 1)
,(@time_zone_id, -1238954400, 2)
,(@time_zone_id, -1220806800, 1)
,(@time_zone_id, -1207504800, 2)
,(@time_zone_id, -1188752400, 1)
,(@time_zone_id, -1176055200, 2)
,(@time_zone_id, -1157302800, 1)
,(@time_zone_id, -1144000800, 2)
,(@time_zone_id, -1125853200, 1)
,(@time_zone_id, -1112551200, 2)
,(@time_zone_id, -1094403600, 1)
,(@time_zone_id, -1081101600, 2)
,(@time_zone_id, -1062954000, 1)
,(@time_zone_id, -1049652000, 2)
,(@time_zone_id, -1031504400, 1)
,(@time_zone_id, -1018202400, 2)
,(@time_zone_id, -1000054800, 1)
,(@time_zone_id, -986752800, 2)
,(@time_zone_id, -968000400, 1)
,(@time_zone_id, -955303200, 2)
,(@time_zone_id, -936550800, 1)
,(@time_zone_id, -880218000, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765396000, 2)
,(@time_zone_id, -747248400, 1)
,(@time_zone_id, -733946400, 2)
,(@time_zone_id, -715806000, 1)
,(@time_zone_id, -702504000, 2)
,(@time_zone_id, -684356400, 1)
,(@time_zone_id, -671054400, 2)
,(@time_zone_id, -652906800, 1)
,(@time_zone_id, -634161600, 2)
,(@time_zone_id, -620845200, 1)
,(@time_zone_id, -602704800, 2)
,(@time_zone_id, -589395600, 1)
,(@time_zone_id, -576093600, 2)
,(@time_zone_id, -557946000, 1)
,(@time_zone_id, -544644000, 2)
,(@time_zone_id, -526496400, 1)
,(@time_zone_id, -513194400, 2)
,(@time_zone_id, -495046800, 1)
,(@time_zone_id, -481744800, 2)
,(@time_zone_id, -463597200, 1)
,(@time_zone_id, -450295200, 2)
,(@time_zone_id, -431542800, 1)
,(@time_zone_id, -418240800, 2)
,(@time_zone_id, -400093200, 1)
,(@time_zone_id, -384372000, 2)
,(@time_zone_id, -368643600, 1)
,(@time_zone_id, -352922400, 2)
,(@time_zone_id, -337194000, 1)
,(@time_zone_id, -321472800, 2)
,(@time_zone_id, -305744400, 1)
,(@time_zone_id, -289418400, 2)
,(@time_zone_id, -273690000, 1)
,(@time_zone_id, -257968800, 2)
,(@time_zone_id, -242240400, 1)
,(@time_zone_id, -226519200, 2)
,(@time_zone_id, -210790800, 1)
,(@time_zone_id, -195069600, 2)
,(@time_zone_id, -179341200, 1)
,(@time_zone_id, -163620000, 2)
,(@time_zone_id, -147891600, 1)
,(@time_zone_id, -131565600, 2)
,(@time_zone_id, -116442000, 1)
,(@time_zone_id, -100116000, 2)
,(@time_zone_id, -84387600, 1)
,(@time_zone_id, -68666400, 2)
,(@time_zone_id, -52938000, 1)
,(@time_zone_id, -37216800, 2)
,(@time_zone_id, -21488400, 1)
,(@time_zone_id, -5767200, 2)
,(@time_zone_id, 9961200, 1)
,(@time_zone_id, 25682400, 2)
,(@time_zone_id, 41410800, 1)
,(@time_zone_id, 57736800, 2)
,(@time_zone_id, 73465200, 1)
,(@time_zone_id, 89186400, 2)
,(@time_zone_id, 104914800, 1)
,(@time_zone_id, 120636000, 2)
,(@time_zone_id, 136364400, 1)
,(@time_zone_id, 152085600, 2)
,(@time_zone_id, 167814000, 1)
,(@time_zone_id, 183535200, 2)
,(@time_zone_id, 199263600, 1)
,(@time_zone_id, 215589600, 2)
,(@time_zone_id, 230713200, 1)
,(@time_zone_id, 247039200, 2)
,(@time_zone_id, 262767600, 1)
,(@time_zone_id, 278488800, 2)
,(@time_zone_id, 294217200, 1)
,(@time_zone_id, 309938400, 2)
,(@time_zone_id, 325666800, 1)
,(@time_zone_id, 341388000, 2)
,(@time_zone_id, 357116400, 1)
,(@time_zone_id, 372837600, 2)
,(@time_zone_id, 388566000, 1)
,(@time_zone_id, 404892000, 2)
,(@time_zone_id, 420015600, 1)
,(@time_zone_id, 436341600, 2)
,(@time_zone_id, 452070000, 1)
,(@time_zone_id, 467791200, 2)
,(@time_zone_id, 483519600, 1)
,(@time_zone_id, 499240800, 2)
,(@time_zone_id, 514969200, 1)
,(@time_zone_id, 530690400, 2)
,(@time_zone_id, 544604400, 1)
,(@time_zone_id, 562140000, 2)
,(@time_zone_id, 576054000, 1)
,(@time_zone_id, 594194400, 2)
,(@time_zone_id, 607503600, 1)
,(@time_zone_id, 625644000, 2)
,(@time_zone_id, 638953200, 1)
,(@time_zone_id, 657093600, 2)
,(@time_zone_id, 671007600, 1)
,(@time_zone_id, 688543200, 2)
,(@time_zone_id, 702457200, 1)
,(@time_zone_id, 719992800, 2)
,(@time_zone_id, 733906800, 1)
,(@time_zone_id, 752047200, 2)
,(@time_zone_id, 765356400, 1)
,(@time_zone_id, 783496800, 2)
,(@time_zone_id, 796806000, 1)
,(@time_zone_id, 814946400, 2)
,(@time_zone_id, 828860400, 1)
,(@time_zone_id, 846396000, 2)
,(@time_zone_id, 860310000, 1)
,(@time_zone_id, 877845600, 2)
,(@time_zone_id, 891759600, 1)
,(@time_zone_id, 909295200, 2)
,(@time_zone_id, 923209200, 1)
,(@time_zone_id, 941349600, 2)
,(@time_zone_id, 954658800, 1)
,(@time_zone_id, 972799200, 2)
,(@time_zone_id, 986108400, 1)
,(@time_zone_id, 1004248800, 2)
,(@time_zone_id, 1018162800, 1)
,(@time_zone_id, 1035698400, 2)
,(@time_zone_id, 1049612400, 1)
,(@time_zone_id, 1067148000, 2)
,(@time_zone_id, 1081062000, 1)
,(@time_zone_id, 1099202400, 2)
,(@time_zone_id, 1112511600, 1)
,(@time_zone_id, 1130652000, 2)
,(@time_zone_id, 1143961200, 1)
,(@time_zone_id, 1162101600, 2)
,(@time_zone_id, 1173596400, 1)
,(@time_zone_id, 1194156000, 2)
,(@time_zone_id, 1205046000, 1)
,(@time_zone_id, 1225605600, 2)
,(@time_zone_id, 1236495600, 1)
,(@time_zone_id, 1257055200, 2)
,(@time_zone_id, 1268550000, 1)
,(@time_zone_id, 1289109600, 2)
,(@time_zone_id, 1299999600, 1)
,(@time_zone_id, 1320559200, 2)
,(@time_zone_id, 1331449200, 1)
,(@time_zone_id, 1352008800, 2)
,(@time_zone_id, 1362898800, 1)
,(@time_zone_id, 1383458400, 2)
,(@time_zone_id, 1394348400, 1)
,(@time_zone_id, 1414908000, 2)
,(@time_zone_id, 1425798000, 1)
,(@time_zone_id, 1446357600, 2)
,(@time_zone_id, 1457852400, 1)
,(@time_zone_id, 1478412000, 2)
,(@time_zone_id, 1489302000, 1)
,(@time_zone_id, 1509861600, 2)
,(@time_zone_id, 1520751600, 1)
,(@time_zone_id, 1541311200, 2)
,(@time_zone_id, 1552201200, 1)
,(@time_zone_id, 1572760800, 2)
,(@time_zone_id, 1583650800, 1)
,(@time_zone_id, 1604210400, 2)
,(@time_zone_id, 1615705200, 1)
,(@time_zone_id, 1636264800, 2)
,(@time_zone_id, 1647154800, 1)
,(@time_zone_id, 1667714400, 2)
,(@time_zone_id, 1678604400, 1)
,(@time_zone_id, 1699164000, 2)
,(@time_zone_id, 1710054000, 1)
,(@time_zone_id, 1730613600, 2)
,(@time_zone_id, 1741503600, 1)
,(@time_zone_id, 1762063200, 2)
,(@time_zone_id, 1772953200, 1)
,(@time_zone_id, 1793512800, 2)
,(@time_zone_id, 1805007600, 1)
,(@time_zone_id, 1825567200, 2)
,(@time_zone_id, 1836457200, 1)
,(@time_zone_id, 1857016800, 2)
,(@time_zone_id, 1867906800, 1)
,(@time_zone_id, 1888466400, 2)
,(@time_zone_id, 1899356400, 1)
,(@time_zone_id, 1919916000, 2)
,(@time_zone_id, 1930806000, 1)
,(@time_zone_id, 1951365600, 2)
,(@time_zone_id, 1962860400, 1)
,(@time_zone_id, 1983420000, 2)
,(@time_zone_id, 1994310000, 1)
,(@time_zone_id, 2014869600, 2)
,(@time_zone_id, 2025759600, 1)
,(@time_zone_id, 2046319200, 2)
,(@time_zone_id, 2057209200, 1)
,(@time_zone_id, 2077768800, 2)
,(@time_zone_id, 2088658800, 1)
,(@time_zone_id, 2109218400, 2)
,(@time_zone_id, 2120108400, 1)
,(@time_zone_id, 2140668000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -19052, 0, 'LMT')
,(@time_zone_id, 1, -14400, 1, 'EDT')
,(@time_zone_id, 2, -18000, 0, 'EST')
,(@time_zone_id, 3, -14400, 1, 'EWT')
,(@time_zone_id, 4, -14400, 1, 'EPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Tortola', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Vancouver', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632060000, 1)
,(@time_zone_id, -1615129200, 2)
,(@time_zone_id, -880207200, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765385200, 2)
,(@time_zone_id, -747237600, 1)
,(@time_zone_id, -732726000, 2)
,(@time_zone_id, -715788000, 1)
,(@time_zone_id, -702486000, 2)
,(@time_zone_id, -684338400, 1)
,(@time_zone_id, -671036400, 2)
,(@time_zone_id, -652888800, 1)
,(@time_zone_id, -639586800, 2)
,(@time_zone_id, -620834400, 1)
,(@time_zone_id, -608137200, 2)
,(@time_zone_id, -589384800, 1)
,(@time_zone_id, -576082800, 2)
,(@time_zone_id, -557935200, 1)
,(@time_zone_id, -544633200, 2)
,(@time_zone_id, -526485600, 1)
,(@time_zone_id, -513183600, 2)
,(@time_zone_id, -495036000, 1)
,(@time_zone_id, -481734000, 2)
,(@time_zone_id, -463586400, 1)
,(@time_zone_id, -450284400, 2)
,(@time_zone_id, -431532000, 1)
,(@time_zone_id, -418230000, 2)
,(@time_zone_id, -400082400, 1)
,(@time_zone_id, -386780400, 2)
,(@time_zone_id, -368632800, 1)
,(@time_zone_id, -355330800, 2)
,(@time_zone_id, -337183200, 1)
,(@time_zone_id, -323881200, 2)
,(@time_zone_id, -305733600, 1)
,(@time_zone_id, -292431600, 2)
,(@time_zone_id, -273679200, 1)
,(@time_zone_id, -260982000, 2)
,(@time_zone_id, -242229600, 1)
,(@time_zone_id, -226508400, 2)
,(@time_zone_id, -210780000, 1)
,(@time_zone_id, -195058800, 2)
,(@time_zone_id, -179330400, 1)
,(@time_zone_id, -163609200, 2)
,(@time_zone_id, -147880800, 1)
,(@time_zone_id, -131554800, 2)
,(@time_zone_id, -116431200, 1)
,(@time_zone_id, -100105200, 2)
,(@time_zone_id, -84376800, 1)
,(@time_zone_id, -68655600, 2)
,(@time_zone_id, -52927200, 1)
,(@time_zone_id, -37206000, 2)
,(@time_zone_id, -21477600, 1)
,(@time_zone_id, -5756400, 2)
,(@time_zone_id, 9972000, 1)
,(@time_zone_id, 25693200, 2)
,(@time_zone_id, 41421600, 1)
,(@time_zone_id, 57747600, 2)
,(@time_zone_id, 73476000, 1)
,(@time_zone_id, 89197200, 2)
,(@time_zone_id, 104925600, 1)
,(@time_zone_id, 120646800, 2)
,(@time_zone_id, 136375200, 1)
,(@time_zone_id, 152096400, 2)
,(@time_zone_id, 167824800, 1)
,(@time_zone_id, 183546000, 2)
,(@time_zone_id, 199274400, 1)
,(@time_zone_id, 215600400, 2)
,(@time_zone_id, 230724000, 1)
,(@time_zone_id, 247050000, 2)
,(@time_zone_id, 262778400, 1)
,(@time_zone_id, 278499600, 2)
,(@time_zone_id, 294228000, 1)
,(@time_zone_id, 309949200, 2)
,(@time_zone_id, 325677600, 1)
,(@time_zone_id, 341398800, 2)
,(@time_zone_id, 357127200, 1)
,(@time_zone_id, 372848400, 2)
,(@time_zone_id, 388576800, 1)
,(@time_zone_id, 404902800, 2)
,(@time_zone_id, 420026400, 1)
,(@time_zone_id, 436352400, 2)
,(@time_zone_id, 452080800, 1)
,(@time_zone_id, 467802000, 2)
,(@time_zone_id, 483530400, 1)
,(@time_zone_id, 499251600, 2)
,(@time_zone_id, 514980000, 1)
,(@time_zone_id, 530701200, 2)
,(@time_zone_id, 544615200, 1)
,(@time_zone_id, 562150800, 2)
,(@time_zone_id, 576064800, 1)
,(@time_zone_id, 594205200, 2)
,(@time_zone_id, 607514400, 1)
,(@time_zone_id, 625654800, 2)
,(@time_zone_id, 638964000, 1)
,(@time_zone_id, 657104400, 2)
,(@time_zone_id, 671018400, 1)
,(@time_zone_id, 688554000, 2)
,(@time_zone_id, 702468000, 1)
,(@time_zone_id, 720003600, 2)
,(@time_zone_id, 733917600, 1)
,(@time_zone_id, 752058000, 2)
,(@time_zone_id, 765367200, 1)
,(@time_zone_id, 783507600, 2)
,(@time_zone_id, 796816800, 1)
,(@time_zone_id, 814957200, 2)
,(@time_zone_id, 828871200, 1)
,(@time_zone_id, 846406800, 2)
,(@time_zone_id, 860320800, 1)
,(@time_zone_id, 877856400, 2)
,(@time_zone_id, 891770400, 1)
,(@time_zone_id, 909306000, 2)
,(@time_zone_id, 923220000, 1)
,(@time_zone_id, 941360400, 2)
,(@time_zone_id, 954669600, 1)
,(@time_zone_id, 972810000, 2)
,(@time_zone_id, 986119200, 1)
,(@time_zone_id, 1004259600, 2)
,(@time_zone_id, 1018173600, 1)
,(@time_zone_id, 1035709200, 2)
,(@time_zone_id, 1049623200, 1)
,(@time_zone_id, 1067158800, 2)
,(@time_zone_id, 1081072800, 1)
,(@time_zone_id, 1099213200, 2)
,(@time_zone_id, 1112522400, 1)
,(@time_zone_id, 1130662800, 2)
,(@time_zone_id, 1143972000, 1)
,(@time_zone_id, 1162112400, 2)
,(@time_zone_id, 1173607200, 1)
,(@time_zone_id, 1194166800, 2)
,(@time_zone_id, 1205056800, 1)
,(@time_zone_id, 1225616400, 2)
,(@time_zone_id, 1236506400, 1)
,(@time_zone_id, 1257066000, 2)
,(@time_zone_id, 1268560800, 1)
,(@time_zone_id, 1289120400, 2)
,(@time_zone_id, 1300010400, 1)
,(@time_zone_id, 1320570000, 2)
,(@time_zone_id, 1331460000, 1)
,(@time_zone_id, 1352019600, 2)
,(@time_zone_id, 1362909600, 1)
,(@time_zone_id, 1383469200, 2)
,(@time_zone_id, 1394359200, 1)
,(@time_zone_id, 1414918800, 2)
,(@time_zone_id, 1425808800, 1)
,(@time_zone_id, 1446368400, 2)
,(@time_zone_id, 1457863200, 1)
,(@time_zone_id, 1478422800, 2)
,(@time_zone_id, 1489312800, 1)
,(@time_zone_id, 1509872400, 2)
,(@time_zone_id, 1520762400, 1)
,(@time_zone_id, 1541322000, 2)
,(@time_zone_id, 1552212000, 1)
,(@time_zone_id, 1572771600, 2)
,(@time_zone_id, 1583661600, 1)
,(@time_zone_id, 1604221200, 2)
,(@time_zone_id, 1615716000, 1)
,(@time_zone_id, 1636275600, 2)
,(@time_zone_id, 1647165600, 1)
,(@time_zone_id, 1667725200, 2)
,(@time_zone_id, 1678615200, 1)
,(@time_zone_id, 1699174800, 2)
,(@time_zone_id, 1710064800, 1)
,(@time_zone_id, 1730624400, 2)
,(@time_zone_id, 1741514400, 1)
,(@time_zone_id, 1762074000, 2)
,(@time_zone_id, 1772964000, 1)
,(@time_zone_id, 1793523600, 2)
,(@time_zone_id, 1805018400, 1)
,(@time_zone_id, 1825578000, 2)
,(@time_zone_id, 1836468000, 1)
,(@time_zone_id, 1857027600, 2)
,(@time_zone_id, 1867917600, 1)
,(@time_zone_id, 1888477200, 2)
,(@time_zone_id, 1899367200, 1)
,(@time_zone_id, 1919926800, 2)
,(@time_zone_id, 1930816800, 1)
,(@time_zone_id, 1951376400, 2)
,(@time_zone_id, 1962871200, 1)
,(@time_zone_id, 1983430800, 2)
,(@time_zone_id, 1994320800, 1)
,(@time_zone_id, 2014880400, 2)
,(@time_zone_id, 2025770400, 1)
,(@time_zone_id, 2046330000, 2)
,(@time_zone_id, 2057220000, 1)
,(@time_zone_id, 2077779600, 2)
,(@time_zone_id, 2088669600, 1)
,(@time_zone_id, 2109229200, 2)
,(@time_zone_id, 2120119200, 1)
,(@time_zone_id, 2140678800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -29548, 0, 'LMT')
,(@time_zone_id, 1, -25200, 1, 'PDT')
,(@time_zone_id, 2, -28800, 0, 'PST')
,(@time_zone_id, 3, -25200, 1, 'PWT')
,(@time_zone_id, 4, -25200, 1, 'PPT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Virgin', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1825098836, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -14764, 0, 'LMT')
,(@time_zone_id, 1, -14400, 0, 'AST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Whitehorse', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1632056400, 1)
,(@time_zone_id, -1615125600, 2)
,(@time_zone_id, -1596978000, 1)
,(@time_zone_id, -1583164800, 2)
,(@time_zone_id, -880203600, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765381600, 2)
,(@time_zone_id, -147884400, 5)
,(@time_zone_id, -131554800, 2)
,(@time_zone_id, -81961200, 6)
,(@time_zone_id, 325677600, 7)
,(@time_zone_id, 341398800, 6)
,(@time_zone_id, 357127200, 7)
,(@time_zone_id, 372848400, 6)
,(@time_zone_id, 388576800, 7)
,(@time_zone_id, 404902800, 6)
,(@time_zone_id, 420026400, 7)
,(@time_zone_id, 436352400, 6)
,(@time_zone_id, 452080800, 7)
,(@time_zone_id, 467802000, 6)
,(@time_zone_id, 483530400, 7)
,(@time_zone_id, 499251600, 6)
,(@time_zone_id, 514980000, 7)
,(@time_zone_id, 530701200, 6)
,(@time_zone_id, 544615200, 7)
,(@time_zone_id, 562150800, 6)
,(@time_zone_id, 576064800, 7)
,(@time_zone_id, 594205200, 6)
,(@time_zone_id, 607514400, 7)
,(@time_zone_id, 625654800, 6)
,(@time_zone_id, 638964000, 7)
,(@time_zone_id, 657104400, 6)
,(@time_zone_id, 671018400, 7)
,(@time_zone_id, 688554000, 6)
,(@time_zone_id, 702468000, 7)
,(@time_zone_id, 720003600, 6)
,(@time_zone_id, 733917600, 7)
,(@time_zone_id, 752058000, 6)
,(@time_zone_id, 765367200, 7)
,(@time_zone_id, 783507600, 6)
,(@time_zone_id, 796816800, 7)
,(@time_zone_id, 814957200, 6)
,(@time_zone_id, 828871200, 7)
,(@time_zone_id, 846406800, 6)
,(@time_zone_id, 860320800, 7)
,(@time_zone_id, 877856400, 6)
,(@time_zone_id, 891770400, 7)
,(@time_zone_id, 909306000, 6)
,(@time_zone_id, 923220000, 7)
,(@time_zone_id, 941360400, 6)
,(@time_zone_id, 954669600, 7)
,(@time_zone_id, 972810000, 6)
,(@time_zone_id, 986119200, 7)
,(@time_zone_id, 1004259600, 6)
,(@time_zone_id, 1018173600, 7)
,(@time_zone_id, 1035709200, 6)
,(@time_zone_id, 1049623200, 7)
,(@time_zone_id, 1067158800, 6)
,(@time_zone_id, 1081072800, 7)
,(@time_zone_id, 1099213200, 6)
,(@time_zone_id, 1112522400, 7)
,(@time_zone_id, 1130662800, 6)
,(@time_zone_id, 1143972000, 7)
,(@time_zone_id, 1162112400, 6)
,(@time_zone_id, 1173607200, 7)
,(@time_zone_id, 1194166800, 6)
,(@time_zone_id, 1205056800, 7)
,(@time_zone_id, 1225616400, 6)
,(@time_zone_id, 1236506400, 7)
,(@time_zone_id, 1257066000, 6)
,(@time_zone_id, 1268560800, 7)
,(@time_zone_id, 1289120400, 6)
,(@time_zone_id, 1300010400, 7)
,(@time_zone_id, 1320570000, 6)
,(@time_zone_id, 1331460000, 7)
,(@time_zone_id, 1352019600, 6)
,(@time_zone_id, 1362909600, 7)
,(@time_zone_id, 1383469200, 6)
,(@time_zone_id, 1394359200, 7)
,(@time_zone_id, 1414918800, 6)
,(@time_zone_id, 1425808800, 7)
,(@time_zone_id, 1446368400, 6)
,(@time_zone_id, 1457863200, 7)
,(@time_zone_id, 1478422800, 6)
,(@time_zone_id, 1489312800, 7)
,(@time_zone_id, 1509872400, 6)
,(@time_zone_id, 1520762400, 7)
,(@time_zone_id, 1541322000, 6)
,(@time_zone_id, 1552212000, 7)
,(@time_zone_id, 1572771600, 6)
,(@time_zone_id, 1583661600, 7)
,(@time_zone_id, 1604221200, 6)
,(@time_zone_id, 1615716000, 7)
,(@time_zone_id, 1636275600, 6)
,(@time_zone_id, 1647165600, 7)
,(@time_zone_id, 1667725200, 6)
,(@time_zone_id, 1678615200, 7)
,(@time_zone_id, 1699174800, 6)
,(@time_zone_id, 1710064800, 7)
,(@time_zone_id, 1730624400, 6)
,(@time_zone_id, 1741514400, 7)
,(@time_zone_id, 1762074000, 6)
,(@time_zone_id, 1772964000, 7)
,(@time_zone_id, 1793523600, 6)
,(@time_zone_id, 1805018400, 7)
,(@time_zone_id, 1825578000, 6)
,(@time_zone_id, 1836468000, 7)
,(@time_zone_id, 1857027600, 6)
,(@time_zone_id, 1867917600, 7)
,(@time_zone_id, 1888477200, 6)
,(@time_zone_id, 1899367200, 7)
,(@time_zone_id, 1919926800, 6)
,(@time_zone_id, 1930816800, 7)
,(@time_zone_id, 1951376400, 6)
,(@time_zone_id, 1962871200, 7)
,(@time_zone_id, 1983430800, 6)
,(@time_zone_id, 1994320800, 7)
,(@time_zone_id, 2014880400, 6)
,(@time_zone_id, 2025770400, 7)
,(@time_zone_id, 2046330000, 6)
,(@time_zone_id, 2057220000, 7)
,(@time_zone_id, 2077779600, 6)
,(@time_zone_id, 2088669600, 7)
,(@time_zone_id, 2109229200, 6)
,(@time_zone_id, 2120119200, 7)
,(@time_zone_id, 2140678800, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -32412, 0, 'LMT')
,(@time_zone_id, 1, -28800, 1, 'YDT')
,(@time_zone_id, 2, -32400, 0, 'YST')
,(@time_zone_id, 3, -28800, 1, 'YWT')
,(@time_zone_id, 4, -28800, 1, 'YPT')
,(@time_zone_id, 5, -25200, 1, 'YDDT')
,(@time_zone_id, 6, -28800, 0, 'PST')
,(@time_zone_id, 7, -25200, 1, 'PDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Winnipeg', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1694368800, 1)
,(@time_zone_id, -1681671600, 2)
,(@time_zone_id, -1632067200, 1)
,(@time_zone_id, -1615136400, 2)
,(@time_zone_id, -1029686400, 1)
,(@time_zone_id, -1018198800, 2)
,(@time_zone_id, -880214400, 3)
,(@time_zone_id, -769395600, 4)
,(@time_zone_id, -765392400, 2)
,(@time_zone_id, -746035200, 1)
,(@time_zone_id, -732733200, 2)
,(@time_zone_id, -715795200, 1)
,(@time_zone_id, -702493200, 2)
,(@time_zone_id, -684345600, 1)
,(@time_zone_id, -671043600, 2)
,(@time_zone_id, -652896000, 1)
,(@time_zone_id, -639594000, 2)
,(@time_zone_id, -620755200, 1)
,(@time_zone_id, -607626000, 2)
,(@time_zone_id, -589392000, 1)
,(@time_zone_id, -576090000, 2)
,(@time_zone_id, -557942400, 1)
,(@time_zone_id, -544640400, 2)
,(@time_zone_id, -526492800, 1)
,(@time_zone_id, -513190800, 2)
,(@time_zone_id, -495043200, 1)
,(@time_zone_id, -481741200, 2)
,(@time_zone_id, -463593600, 1)
,(@time_zone_id, -450291600, 2)
,(@time_zone_id, -431539200, 1)
,(@time_zone_id, -418237200, 2)
,(@time_zone_id, -400089600, 1)
,(@time_zone_id, -386787600, 2)
,(@time_zone_id, -368640000, 1)
,(@time_zone_id, -355338000, 2)
,(@time_zone_id, -337190400, 1)
,(@time_zone_id, -321469200, 2)
,(@time_zone_id, -305740800, 1)
,(@time_zone_id, -292438800, 2)
,(@time_zone_id, -210787200, 1)
,(@time_zone_id, -198090000, 2)
,(@time_zone_id, -116438400, 5)
,(@time_zone_id, -100108800, 6)
,(@time_zone_id, -84384000, 5)
,(@time_zone_id, -68659200, 6)
,(@time_zone_id, -52934400, 5)
,(@time_zone_id, -37209600, 6)
,(@time_zone_id, -21484800, 5)
,(@time_zone_id, -5760000, 6)
,(@time_zone_id, 9964800, 5)
,(@time_zone_id, 25689600, 6)
,(@time_zone_id, 41414400, 5)
,(@time_zone_id, 57744000, 6)
,(@time_zone_id, 73468800, 5)
,(@time_zone_id, 89193600, 6)
,(@time_zone_id, 104918400, 5)
,(@time_zone_id, 120643200, 6)
,(@time_zone_id, 136368000, 5)
,(@time_zone_id, 152092800, 6)
,(@time_zone_id, 167817600, 5)
,(@time_zone_id, 183542400, 6)
,(@time_zone_id, 199267200, 5)
,(@time_zone_id, 215596800, 6)
,(@time_zone_id, 230716800, 5)
,(@time_zone_id, 247046400, 6)
,(@time_zone_id, 262771200, 5)
,(@time_zone_id, 278496000, 6)
,(@time_zone_id, 294220800, 5)
,(@time_zone_id, 309945600, 6)
,(@time_zone_id, 325670400, 5)
,(@time_zone_id, 341395200, 6)
,(@time_zone_id, 357120000, 5)
,(@time_zone_id, 372844800, 6)
,(@time_zone_id, 388569600, 5)
,(@time_zone_id, 404899200, 6)
,(@time_zone_id, 420019200, 5)
,(@time_zone_id, 436348800, 6)
,(@time_zone_id, 452073600, 5)
,(@time_zone_id, 467798400, 6)
,(@time_zone_id, 483523200, 5)
,(@time_zone_id, 499248000, 6)
,(@time_zone_id, 514972800, 5)
,(@time_zone_id, 530697600, 6)
,(@time_zone_id, 544608000, 5)
,(@time_zone_id, 562147200, 6)
,(@time_zone_id, 576057600, 5)
,(@time_zone_id, 594201600, 6)
,(@time_zone_id, 607507200, 5)
,(@time_zone_id, 625651200, 6)
,(@time_zone_id, 638956800, 5)
,(@time_zone_id, 657100800, 6)
,(@time_zone_id, 671011200, 5)
,(@time_zone_id, 688550400, 6)
,(@time_zone_id, 702460800, 5)
,(@time_zone_id, 720000000, 6)
,(@time_zone_id, 733910400, 5)
,(@time_zone_id, 752054400, 6)
,(@time_zone_id, 765360000, 5)
,(@time_zone_id, 783504000, 6)
,(@time_zone_id, 796809600, 5)
,(@time_zone_id, 814953600, 6)
,(@time_zone_id, 828864000, 5)
,(@time_zone_id, 846403200, 6)
,(@time_zone_id, 860313600, 5)
,(@time_zone_id, 877852800, 6)
,(@time_zone_id, 891763200, 5)
,(@time_zone_id, 909302400, 6)
,(@time_zone_id, 923212800, 5)
,(@time_zone_id, 941356800, 6)
,(@time_zone_id, 954662400, 5)
,(@time_zone_id, 972806400, 6)
,(@time_zone_id, 986112000, 5)
,(@time_zone_id, 1004256000, 6)
,(@time_zone_id, 1018166400, 5)
,(@time_zone_id, 1035705600, 6)
,(@time_zone_id, 1049616000, 5)
,(@time_zone_id, 1067155200, 6)
,(@time_zone_id, 1081065600, 5)
,(@time_zone_id, 1099209600, 6)
,(@time_zone_id, 1112515200, 5)
,(@time_zone_id, 1130659200, 6)
,(@time_zone_id, 1136095200, 2)
,(@time_zone_id, 1143964800, 1)
,(@time_zone_id, 1162105200, 2)
,(@time_zone_id, 1173600000, 1)
,(@time_zone_id, 1194159600, 2)
,(@time_zone_id, 1205049600, 1)
,(@time_zone_id, 1225609200, 2)
,(@time_zone_id, 1236499200, 1)
,(@time_zone_id, 1257058800, 2)
,(@time_zone_id, 1268553600, 1)
,(@time_zone_id, 1289113200, 2)
,(@time_zone_id, 1300003200, 1)
,(@time_zone_id, 1320562800, 2)
,(@time_zone_id, 1331452800, 1)
,(@time_zone_id, 1352012400, 2)
,(@time_zone_id, 1362902400, 1)
,(@time_zone_id, 1383462000, 2)
,(@time_zone_id, 1394352000, 1)
,(@time_zone_id, 1414911600, 2)
,(@time_zone_id, 1425801600, 1)
,(@time_zone_id, 1446361200, 2)
,(@time_zone_id, 1457856000, 1)
,(@time_zone_id, 1478415600, 2)
,(@time_zone_id, 1489305600, 1)
,(@time_zone_id, 1509865200, 2)
,(@time_zone_id, 1520755200, 1)
,(@time_zone_id, 1541314800, 2)
,(@time_zone_id, 1552204800, 1)
,(@time_zone_id, 1572764400, 2)
,(@time_zone_id, 1583654400, 1)
,(@time_zone_id, 1604214000, 2)
,(@time_zone_id, 1615708800, 1)
,(@time_zone_id, 1636268400, 2)
,(@time_zone_id, 1647158400, 1)
,(@time_zone_id, 1667718000, 2)
,(@time_zone_id, 1678608000, 1)
,(@time_zone_id, 1699167600, 2)
,(@time_zone_id, 1710057600, 1)
,(@time_zone_id, 1730617200, 2)
,(@time_zone_id, 1741507200, 1)
,(@time_zone_id, 1762066800, 2)
,(@time_zone_id, 1772956800, 1)
,(@time_zone_id, 1793516400, 2)
,(@time_zone_id, 1805011200, 1)
,(@time_zone_id, 1825570800, 2)
,(@time_zone_id, 1836460800, 1)
,(@time_zone_id, 1857020400, 2)
,(@time_zone_id, 1867910400, 1)
,(@time_zone_id, 1888470000, 2)
,(@time_zone_id, 1899360000, 1)
,(@time_zone_id, 1919919600, 2)
,(@time_zone_id, 1930809600, 1)
,(@time_zone_id, 1951369200, 2)
,(@time_zone_id, 1962864000, 1)
,(@time_zone_id, 1983423600, 2)
,(@time_zone_id, 1994313600, 1)
,(@time_zone_id, 2014873200, 2)
,(@time_zone_id, 2025763200, 1)
,(@time_zone_id, 2046322800, 2)
,(@time_zone_id, 2057212800, 1)
,(@time_zone_id, 2077772400, 2)
,(@time_zone_id, 2088662400, 1)
,(@time_zone_id, 2109222000, 2)
,(@time_zone_id, 2120112000, 1)
,(@time_zone_id, 2140671600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -23316, 0, 'LMT')
,(@time_zone_id, 1, -18000, 1, 'CDT')
,(@time_zone_id, 2, -21600, 0, 'CST')
,(@time_zone_id, 3, -18000, 1, 'CWT')
,(@time_zone_id, 4, -18000, 1, 'CPT')
,(@time_zone_id, 5, -18000, 1, 'CDT')
,(@time_zone_id, 6, -21600, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Yakutat', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -880203600, 2)
,(@time_zone_id, -769395600, 3)
,(@time_zone_id, -765381600, 1)
,(@time_zone_id, -21474000, 4)
,(@time_zone_id, -5752800, 1)
,(@time_zone_id, 9975600, 4)
,(@time_zone_id, 25696800, 1)
,(@time_zone_id, 41425200, 4)
,(@time_zone_id, 57751200, 1)
,(@time_zone_id, 73479600, 4)
,(@time_zone_id, 89200800, 1)
,(@time_zone_id, 104929200, 4)
,(@time_zone_id, 120650400, 1)
,(@time_zone_id, 126702000, 4)
,(@time_zone_id, 152100000, 1)
,(@time_zone_id, 162385200, 4)
,(@time_zone_id, 183549600, 1)
,(@time_zone_id, 199278000, 4)
,(@time_zone_id, 215604000, 1)
,(@time_zone_id, 230727600, 4)
,(@time_zone_id, 247053600, 1)
,(@time_zone_id, 262782000, 4)
,(@time_zone_id, 278503200, 1)
,(@time_zone_id, 294231600, 4)
,(@time_zone_id, 309952800, 1)
,(@time_zone_id, 325681200, 4)
,(@time_zone_id, 341402400, 1)
,(@time_zone_id, 357130800, 4)
,(@time_zone_id, 372852000, 1)
,(@time_zone_id, 388580400, 4)
,(@time_zone_id, 404906400, 1)
,(@time_zone_id, 420030000, 4)
,(@time_zone_id, 436356000, 1)
,(@time_zone_id, 439030800, 6)
,(@time_zone_id, 452084400, 5)
,(@time_zone_id, 467805600, 6)
,(@time_zone_id, 483534000, 5)
,(@time_zone_id, 499255200, 6)
,(@time_zone_id, 514983600, 5)
,(@time_zone_id, 530704800, 6)
,(@time_zone_id, 544618800, 5)
,(@time_zone_id, 562154400, 6)
,(@time_zone_id, 576068400, 5)
,(@time_zone_id, 594208800, 6)
,(@time_zone_id, 607518000, 5)
,(@time_zone_id, 625658400, 6)
,(@time_zone_id, 638967600, 5)
,(@time_zone_id, 657108000, 6)
,(@time_zone_id, 671022000, 5)
,(@time_zone_id, 688557600, 6)
,(@time_zone_id, 702471600, 5)
,(@time_zone_id, 720007200, 6)
,(@time_zone_id, 733921200, 5)
,(@time_zone_id, 752061600, 6)
,(@time_zone_id, 765370800, 5)
,(@time_zone_id, 783511200, 6)
,(@time_zone_id, 796820400, 5)
,(@time_zone_id, 814960800, 6)
,(@time_zone_id, 828874800, 5)
,(@time_zone_id, 846410400, 6)
,(@time_zone_id, 860324400, 5)
,(@time_zone_id, 877860000, 6)
,(@time_zone_id, 891774000, 5)
,(@time_zone_id, 909309600, 6)
,(@time_zone_id, 923223600, 5)
,(@time_zone_id, 941364000, 6)
,(@time_zone_id, 954673200, 5)
,(@time_zone_id, 972813600, 6)
,(@time_zone_id, 986122800, 5)
,(@time_zone_id, 1004263200, 6)
,(@time_zone_id, 1018177200, 5)
,(@time_zone_id, 1035712800, 6)
,(@time_zone_id, 1049626800, 5)
,(@time_zone_id, 1067162400, 6)
,(@time_zone_id, 1081076400, 5)
,(@time_zone_id, 1099216800, 6)
,(@time_zone_id, 1112526000, 5)
,(@time_zone_id, 1130666400, 6)
,(@time_zone_id, 1143975600, 5)
,(@time_zone_id, 1162116000, 6)
,(@time_zone_id, 1173610800, 5)
,(@time_zone_id, 1194170400, 6)
,(@time_zone_id, 1205060400, 5)
,(@time_zone_id, 1225620000, 6)
,(@time_zone_id, 1236510000, 5)
,(@time_zone_id, 1257069600, 6)
,(@time_zone_id, 1268564400, 5)
,(@time_zone_id, 1289124000, 6)
,(@time_zone_id, 1300014000, 5)
,(@time_zone_id, 1320573600, 6)
,(@time_zone_id, 1331463600, 5)
,(@time_zone_id, 1352023200, 6)
,(@time_zone_id, 1362913200, 5)
,(@time_zone_id, 1383472800, 6)
,(@time_zone_id, 1394362800, 5)
,(@time_zone_id, 1414922400, 6)
,(@time_zone_id, 1425812400, 5)
,(@time_zone_id, 1446372000, 6)
,(@time_zone_id, 1457866800, 5)
,(@time_zone_id, 1478426400, 6)
,(@time_zone_id, 1489316400, 5)
,(@time_zone_id, 1509876000, 6)
,(@time_zone_id, 1520766000, 5)
,(@time_zone_id, 1541325600, 6)
,(@time_zone_id, 1552215600, 5)
,(@time_zone_id, 1572775200, 6)
,(@time_zone_id, 1583665200, 5)
,(@time_zone_id, 1604224800, 6)
,(@time_zone_id, 1615719600, 5)
,(@time_zone_id, 1636279200, 6)
,(@time_zone_id, 1647169200, 5)
,(@time_zone_id, 1667728800, 6)
,(@time_zone_id, 1678618800, 5)
,(@time_zone_id, 1699178400, 6)
,(@time_zone_id, 1710068400, 5)
,(@time_zone_id, 1730628000, 6)
,(@time_zone_id, 1741518000, 5)
,(@time_zone_id, 1762077600, 6)
,(@time_zone_id, 1772967600, 5)
,(@time_zone_id, 1793527200, 6)
,(@time_zone_id, 1805022000, 5)
,(@time_zone_id, 1825581600, 6)
,(@time_zone_id, 1836471600, 5)
,(@time_zone_id, 1857031200, 6)
,(@time_zone_id, 1867921200, 5)
,(@time_zone_id, 1888480800, 6)
,(@time_zone_id, 1899370800, 5)
,(@time_zone_id, 1919930400, 6)
,(@time_zone_id, 1930820400, 5)
,(@time_zone_id, 1951380000, 6)
,(@time_zone_id, 1962874800, 5)
,(@time_zone_id, 1983434400, 6)
,(@time_zone_id, 1994324400, 5)
,(@time_zone_id, 2014884000, 6)
,(@time_zone_id, 2025774000, 5)
,(@time_zone_id, 2046333600, 6)
,(@time_zone_id, 2057223600, 5)
,(@time_zone_id, 2077783200, 6)
,(@time_zone_id, 2088673200, 5)
,(@time_zone_id, 2109232800, 6)
,(@time_zone_id, 2120122800, 5)
,(@time_zone_id, 2140682400, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -33535, 0, 'LMT')
,(@time_zone_id, 1, -32400, 0, 'YST')
,(@time_zone_id, 2, -28800, 1, 'YWT')
,(@time_zone_id, 3, -28800, 1, 'YPT')
,(@time_zone_id, 4, -28800, 1, 'YDT')
,(@time_zone_id, 5, -28800, 1, 'AKDT')
,(@time_zone_id, 6, -32400, 0, 'AKST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('America/Yellowknife', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1104537600, 3)
,(@time_zone_id, -880210800, 1)
,(@time_zone_id, -769395600, 2)
,(@time_zone_id, -765388800, 3)
,(@time_zone_id, -147891600, 4)
,(@time_zone_id, -131562000, 3)
,(@time_zone_id, 325674000, 5)
,(@time_zone_id, 341395200, 3)
,(@time_zone_id, 357123600, 5)
,(@time_zone_id, 372844800, 3)
,(@time_zone_id, 388573200, 5)
,(@time_zone_id, 404899200, 3)
,(@time_zone_id, 420022800, 5)
,(@time_zone_id, 436348800, 3)
,(@time_zone_id, 452077200, 5)
,(@time_zone_id, 467798400, 3)
,(@time_zone_id, 483526800, 5)
,(@time_zone_id, 499248000, 3)
,(@time_zone_id, 514976400, 5)
,(@time_zone_id, 530697600, 3)
,(@time_zone_id, 544611600, 5)
,(@time_zone_id, 562147200, 3)
,(@time_zone_id, 576061200, 5)
,(@time_zone_id, 594201600, 3)
,(@time_zone_id, 607510800, 5)
,(@time_zone_id, 625651200, 3)
,(@time_zone_id, 638960400, 5)
,(@time_zone_id, 657100800, 3)
,(@time_zone_id, 671014800, 5)
,(@time_zone_id, 688550400, 3)
,(@time_zone_id, 702464400, 5)
,(@time_zone_id, 720000000, 3)
,(@time_zone_id, 733914000, 5)
,(@time_zone_id, 752054400, 3)
,(@time_zone_id, 765363600, 5)
,(@time_zone_id, 783504000, 3)
,(@time_zone_id, 796813200, 5)
,(@time_zone_id, 814953600, 3)
,(@time_zone_id, 828867600, 5)
,(@time_zone_id, 846403200, 3)
,(@time_zone_id, 860317200, 5)
,(@time_zone_id, 877852800, 3)
,(@time_zone_id, 891766800, 5)
,(@time_zone_id, 909302400, 3)
,(@time_zone_id, 923216400, 5)
,(@time_zone_id, 941356800, 3)
,(@time_zone_id, 954666000, 5)
,(@time_zone_id, 972806400, 3)
,(@time_zone_id, 986115600, 5)
,(@time_zone_id, 1004256000, 3)
,(@time_zone_id, 1018170000, 5)
,(@time_zone_id, 1035705600, 3)
,(@time_zone_id, 1049619600, 5)
,(@time_zone_id, 1067155200, 3)
,(@time_zone_id, 1081069200, 5)
,(@time_zone_id, 1099209600, 3)
,(@time_zone_id, 1112518800, 5)
,(@time_zone_id, 1130659200, 3)
,(@time_zone_id, 1143968400, 5)
,(@time_zone_id, 1162108800, 3)
,(@time_zone_id, 1173603600, 5)
,(@time_zone_id, 1194163200, 3)
,(@time_zone_id, 1205053200, 5)
,(@time_zone_id, 1225612800, 3)
,(@time_zone_id, 1236502800, 5)
,(@time_zone_id, 1257062400, 3)
,(@time_zone_id, 1268557200, 5)
,(@time_zone_id, 1289116800, 3)
,(@time_zone_id, 1300006800, 5)
,(@time_zone_id, 1320566400, 3)
,(@time_zone_id, 1331456400, 5)
,(@time_zone_id, 1352016000, 3)
,(@time_zone_id, 1362906000, 5)
,(@time_zone_id, 1383465600, 3)
,(@time_zone_id, 1394355600, 5)
,(@time_zone_id, 1414915200, 3)
,(@time_zone_id, 1425805200, 5)
,(@time_zone_id, 1446364800, 3)
,(@time_zone_id, 1457859600, 5)
,(@time_zone_id, 1478419200, 3)
,(@time_zone_id, 1489309200, 5)
,(@time_zone_id, 1509868800, 3)
,(@time_zone_id, 1520758800, 5)
,(@time_zone_id, 1541318400, 3)
,(@time_zone_id, 1552208400, 5)
,(@time_zone_id, 1572768000, 3)
,(@time_zone_id, 1583658000, 5)
,(@time_zone_id, 1604217600, 3)
,(@time_zone_id, 1615712400, 5)
,(@time_zone_id, 1636272000, 3)
,(@time_zone_id, 1647162000, 5)
,(@time_zone_id, 1667721600, 3)
,(@time_zone_id, 1678611600, 5)
,(@time_zone_id, 1699171200, 3)
,(@time_zone_id, 1710061200, 5)
,(@time_zone_id, 1730620800, 3)
,(@time_zone_id, 1741510800, 5)
,(@time_zone_id, 1762070400, 3)
,(@time_zone_id, 1772960400, 5)
,(@time_zone_id, 1793520000, 3)
,(@time_zone_id, 1805014800, 5)
,(@time_zone_id, 1825574400, 3)
,(@time_zone_id, 1836464400, 5)
,(@time_zone_id, 1857024000, 3)
,(@time_zone_id, 1867914000, 5)
,(@time_zone_id, 1888473600, 3)
,(@time_zone_id, 1899363600, 5)
,(@time_zone_id, 1919923200, 3)
,(@time_zone_id, 1930813200, 5)
,(@time_zone_id, 1951372800, 3)
,(@time_zone_id, 1962867600, 5)
,(@time_zone_id, 1983427200, 3)
,(@time_zone_id, 1994317200, 5)
,(@time_zone_id, 2014876800, 3)
,(@time_zone_id, 2025766800, 5)
,(@time_zone_id, 2046326400, 3)
,(@time_zone_id, 2057216400, 5)
,(@time_zone_id, 2077776000, 3)
,(@time_zone_id, 2088666000, 5)
,(@time_zone_id, 2109225600, 3)
,(@time_zone_id, 2120115600, 5)
,(@time_zone_id, 2140675200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, -21600, 1, 'MWT')
,(@time_zone_id, 2, -21600, 1, 'MPT')
,(@time_zone_id, 3, -25200, 0, 'MST')
,(@time_zone_id, 4, -18000, 1, 'MDDT')
,(@time_zone_id, 5, -21600, 1, 'MDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/Casey', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -31536000, 1)
,(@time_zone_id, 1255802400, 2)
,(@time_zone_id, 1267714800, 1)
,(@time_zone_id, 1319738400, 2)
,(@time_zone_id, 1329843600, 3)
,(@time_zone_id, 1477065600, 2)
,(@time_zone_id, 1520701200, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, 28800, 0, '+08')
,(@time_zone_id, 2, 39600, 0, '+11')
,(@time_zone_id, 3, 28800, 0, '+08')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/Davis', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -409190400, 1)
,(@time_zone_id, -163062000, 0)
,(@time_zone_id, -28857600, 1)
,(@time_zone_id, 1255806000, 2)
,(@time_zone_id, 1268251200, 3)
,(@time_zone_id, 1319742000, 2)
,(@time_zone_id, 1329854400, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, 25200, 0, '+07')
,(@time_zone_id, 2, 18000, 0, '+05')
,(@time_zone_id, 3, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/DumontDUrville', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -725846400, 1)
,(@time_zone_id, -566992800, 0)
,(@time_zone_id, -415497600, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, 36000, 0, '+10')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/Macquarie', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1680508800, 2)
,(@time_zone_id, -1665392400, 1)
,(@time_zone_id, -1601719200, 3)
,(@time_zone_id, -687052800, 1)
,(@time_zone_id, -71136000, 4)
,(@time_zone_id, -55411200, 5)
,(@time_zone_id, -37267200, 4)
,(@time_zone_id, -25776000, 5)
,(@time_zone_id, -5817600, 4)
,(@time_zone_id, 5673600, 5)
,(@time_zone_id, 25632000, 4)
,(@time_zone_id, 37728000, 5)
,(@time_zone_id, 57686400, 4)
,(@time_zone_id, 67968000, 5)
,(@time_zone_id, 89136000, 4)
,(@time_zone_id, 100022400, 5)
,(@time_zone_id, 120585600, 4)
,(@time_zone_id, 131472000, 5)
,(@time_zone_id, 152035200, 4)
,(@time_zone_id, 162921600, 5)
,(@time_zone_id, 183484800, 4)
,(@time_zone_id, 194976000, 5)
,(@time_zone_id, 215539200, 4)
,(@time_zone_id, 226425600, 5)
,(@time_zone_id, 246988800, 4)
,(@time_zone_id, 257875200, 5)
,(@time_zone_id, 278438400, 4)
,(@time_zone_id, 289324800, 5)
,(@time_zone_id, 309888000, 4)
,(@time_zone_id, 320774400, 5)
,(@time_zone_id, 341337600, 4)
,(@time_zone_id, 352224000, 5)
,(@time_zone_id, 372787200, 4)
,(@time_zone_id, 386092800, 5)
,(@time_zone_id, 404841600, 4)
,(@time_zone_id, 417542400, 5)
,(@time_zone_id, 436291200, 4)
,(@time_zone_id, 447177600, 5)
,(@time_zone_id, 467740800, 4)
,(@time_zone_id, 478627200, 5)
,(@time_zone_id, 499190400, 4)
,(@time_zone_id, 510076800, 5)
,(@time_zone_id, 530035200, 4)
,(@time_zone_id, 542736000, 5)
,(@time_zone_id, 562089600, 4)
,(@time_zone_id, 574790400, 5)
,(@time_zone_id, 594144000, 4)
,(@time_zone_id, 606240000, 5)
,(@time_zone_id, 625593600, 4)
,(@time_zone_id, 637689600, 5)
,(@time_zone_id, 657043200, 4)
,(@time_zone_id, 670348800, 5)
,(@time_zone_id, 686678400, 4)
,(@time_zone_id, 701798400, 5)
,(@time_zone_id, 718128000, 4)
,(@time_zone_id, 733248000, 5)
,(@time_zone_id, 749577600, 4)
,(@time_zone_id, 764697600, 5)
,(@time_zone_id, 781027200, 4)
,(@time_zone_id, 796147200, 5)
,(@time_zone_id, 812476800, 4)
,(@time_zone_id, 828201600, 5)
,(@time_zone_id, 844531200, 4)
,(@time_zone_id, 859651200, 5)
,(@time_zone_id, 875980800, 4)
,(@time_zone_id, 891100800, 5)
,(@time_zone_id, 907430400, 4)
,(@time_zone_id, 922550400, 5)
,(@time_zone_id, 938880000, 4)
,(@time_zone_id, 954000000, 5)
,(@time_zone_id, 967305600, 4)
,(@time_zone_id, 985449600, 5)
,(@time_zone_id, 1002384000, 4)
,(@time_zone_id, 1017504000, 5)
,(@time_zone_id, 1033833600, 4)
,(@time_zone_id, 1048953600, 5)
,(@time_zone_id, 1065283200, 4)
,(@time_zone_id, 1080403200, 5)
,(@time_zone_id, 1096732800, 4)
,(@time_zone_id, 1111852800, 5)
,(@time_zone_id, 1128182400, 4)
,(@time_zone_id, 1143907200, 5)
,(@time_zone_id, 1159632000, 4)
,(@time_zone_id, 1174752000, 5)
,(@time_zone_id, 1191686400, 4)
,(@time_zone_id, 1207411200, 5)
,(@time_zone_id, 1223136000, 4)
,(@time_zone_id, 1238860800, 5)
,(@time_zone_id, 1254585600, 4)
,(@time_zone_id, 1270310400, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, 36000, 0, 'AEST')
,(@time_zone_id, 2, 39600, 1, 'AEDT')
,(@time_zone_id, 3, 0, 0, '-00')
,(@time_zone_id, 4, 39600, 1, 'AEDT')
,(@time_zone_id, 5, 36000, 0, 'AEST')
,(@time_zone_id, 6, 39600, 0, '+11')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/Mawson', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -501206400, 1)
,(@time_zone_id, 1255809600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, 21600, 0, '+06')
,(@time_zone_id, 2, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/McMurdo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1330335000, 1)
,(@time_zone_id, -1320057000, 2)
,(@time_zone_id, -1300699800, 3)
,(@time_zone_id, -1287396000, 2)
,(@time_zone_id, -1269250200, 3)
,(@time_zone_id, -1255946400, 2)
,(@time_zone_id, -1237800600, 3)
,(@time_zone_id, -1224496800, 2)
,(@time_zone_id, -1206351000, 3)
,(@time_zone_id, -1192442400, 2)
,(@time_zone_id, -1174901400, 3)
,(@time_zone_id, -1160992800, 2)
,(@time_zone_id, -1143451800, 3)
,(@time_zone_id, -1125914400, 2)
,(@time_zone_id, -1112607000, 3)
,(@time_zone_id, -1094464800, 2)
,(@time_zone_id, -1081157400, 3)
,(@time_zone_id, -1063015200, 2)
,(@time_zone_id, -1049707800, 3)
,(@time_zone_id, -1031565600, 2)
,(@time_zone_id, -1018258200, 3)
,(@time_zone_id, -1000116000, 2)
,(@time_zone_id, -986808600, 3)
,(@time_zone_id, -968061600, 2)
,(@time_zone_id, -955359000, 3)
,(@time_zone_id, -936612000, 2)
,(@time_zone_id, -923304600, 3)
,(@time_zone_id, -757425600, 6)
,(@time_zone_id, 152632800, 4)
,(@time_zone_id, 162309600, 5)
,(@time_zone_id, 183477600, 4)
,(@time_zone_id, 194968800, 5)
,(@time_zone_id, 215532000, 4)
,(@time_zone_id, 226418400, 5)
,(@time_zone_id, 246981600, 4)
,(@time_zone_id, 257868000, 5)
,(@time_zone_id, 278431200, 4)
,(@time_zone_id, 289317600, 5)
,(@time_zone_id, 309880800, 4)
,(@time_zone_id, 320767200, 5)
,(@time_zone_id, 341330400, 4)
,(@time_zone_id, 352216800, 5)
,(@time_zone_id, 372780000, 4)
,(@time_zone_id, 384271200, 5)
,(@time_zone_id, 404834400, 4)
,(@time_zone_id, 415720800, 5)
,(@time_zone_id, 436284000, 4)
,(@time_zone_id, 447170400, 5)
,(@time_zone_id, 467733600, 4)
,(@time_zone_id, 478620000, 5)
,(@time_zone_id, 499183200, 4)
,(@time_zone_id, 510069600, 5)
,(@time_zone_id, 530632800, 4)
,(@time_zone_id, 541519200, 5)
,(@time_zone_id, 562082400, 4)
,(@time_zone_id, 573573600, 5)
,(@time_zone_id, 594136800, 4)
,(@time_zone_id, 605023200, 5)
,(@time_zone_id, 623772000, 4)
,(@time_zone_id, 637682400, 5)
,(@time_zone_id, 655221600, 4)
,(@time_zone_id, 669132000, 5)
,(@time_zone_id, 686671200, 4)
,(@time_zone_id, 700581600, 5)
,(@time_zone_id, 718120800, 4)
,(@time_zone_id, 732636000, 5)
,(@time_zone_id, 749570400, 4)
,(@time_zone_id, 764085600, 5)
,(@time_zone_id, 781020000, 4)
,(@time_zone_id, 795535200, 5)
,(@time_zone_id, 812469600, 4)
,(@time_zone_id, 826984800, 5)
,(@time_zone_id, 844524000, 4)
,(@time_zone_id, 858434400, 5)
,(@time_zone_id, 875973600, 4)
,(@time_zone_id, 889884000, 5)
,(@time_zone_id, 907423200, 4)
,(@time_zone_id, 921938400, 5)
,(@time_zone_id, 938872800, 4)
,(@time_zone_id, 953388000, 5)
,(@time_zone_id, 970322400, 4)
,(@time_zone_id, 984837600, 5)
,(@time_zone_id, 1002376800, 4)
,(@time_zone_id, 1016287200, 5)
,(@time_zone_id, 1033826400, 4)
,(@time_zone_id, 1047736800, 5)
,(@time_zone_id, 1065276000, 4)
,(@time_zone_id, 1079791200, 5)
,(@time_zone_id, 1096725600, 4)
,(@time_zone_id, 1111240800, 5)
,(@time_zone_id, 1128175200, 4)
,(@time_zone_id, 1142690400, 5)
,(@time_zone_id, 1159624800, 4)
,(@time_zone_id, 1174140000, 5)
,(@time_zone_id, 1191074400, 4)
,(@time_zone_id, 1207404000, 5)
,(@time_zone_id, 1222524000, 4)
,(@time_zone_id, 1238853600, 5)
,(@time_zone_id, 1253973600, 4)
,(@time_zone_id, 1270303200, 5)
,(@time_zone_id, 1285423200, 4)
,(@time_zone_id, 1301752800, 5)
,(@time_zone_id, 1316872800, 4)
,(@time_zone_id, 1333202400, 5)
,(@time_zone_id, 1348927200, 4)
,(@time_zone_id, 1365256800, 5)
,(@time_zone_id, 1380376800, 4)
,(@time_zone_id, 1396706400, 5)
,(@time_zone_id, 1411826400, 4)
,(@time_zone_id, 1428156000, 5)
,(@time_zone_id, 1443276000, 4)
,(@time_zone_id, 1459605600, 5)
,(@time_zone_id, 1474725600, 4)
,(@time_zone_id, 1491055200, 5)
,(@time_zone_id, 1506175200, 4)
,(@time_zone_id, 1522504800, 5)
,(@time_zone_id, 1538229600, 4)
,(@time_zone_id, 1554559200, 5)
,(@time_zone_id, 1569679200, 4)
,(@time_zone_id, 1586008800, 5)
,(@time_zone_id, 1601128800, 4)
,(@time_zone_id, 1617458400, 5)
,(@time_zone_id, 1632578400, 4)
,(@time_zone_id, 1648908000, 5)
,(@time_zone_id, 1664028000, 4)
,(@time_zone_id, 1680357600, 5)
,(@time_zone_id, 1695477600, 4)
,(@time_zone_id, 1712412000, 5)
,(@time_zone_id, 1727532000, 4)
,(@time_zone_id, 1743861600, 5)
,(@time_zone_id, 1758981600, 4)
,(@time_zone_id, 1775311200, 5)
,(@time_zone_id, 1790431200, 4)
,(@time_zone_id, 1806760800, 5)
,(@time_zone_id, 1821880800, 4)
,(@time_zone_id, 1838210400, 5)
,(@time_zone_id, 1853330400, 4)
,(@time_zone_id, 1869660000, 5)
,(@time_zone_id, 1885384800, 4)
,(@time_zone_id, 1901714400, 5)
,(@time_zone_id, 1916834400, 4)
,(@time_zone_id, 1933164000, 5)
,(@time_zone_id, 1948284000, 4)
,(@time_zone_id, 1964613600, 5)
,(@time_zone_id, 1979733600, 4)
,(@time_zone_id, 1996063200, 5)
,(@time_zone_id, 2011183200, 4)
,(@time_zone_id, 2027512800, 5)
,(@time_zone_id, 2042632800, 4)
,(@time_zone_id, 2058962400, 5)
,(@time_zone_id, 2074687200, 4)
,(@time_zone_id, 2091016800, 5)
,(@time_zone_id, 2106136800, 4)
,(@time_zone_id, 2122466400, 5)
,(@time_zone_id, 2137586400, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 41944, 0, 'LMT')
,(@time_zone_id, 1, 45000, 1, 'NZST')
,(@time_zone_id, 2, 41400, 0, 'NZMT')
,(@time_zone_id, 3, 43200, 1, 'NZST')
,(@time_zone_id, 4, 46800, 1, 'NZDT')
,(@time_zone_id, 5, 43200, 0, 'NZST')
,(@time_zone_id, 6, 43200, 0, 'NZST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/Palmer', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -157766400, 2)
,(@time_zone_id, -152658000, 1)
,(@time_zone_id, -132955200, 2)
,(@time_zone_id, -121122000, 1)
,(@time_zone_id, -101419200, 2)
,(@time_zone_id, -86821200, 1)
,(@time_zone_id, -71092800, 2)
,(@time_zone_id, -54766800, 1)
,(@time_zone_id, -39038400, 2)
,(@time_zone_id, -23317200, 1)
,(@time_zone_id, -7588800, 4)
,(@time_zone_id, 128142000, 3)
,(@time_zone_id, 136605600, 4)
,(@time_zone_id, 389070000, 1)
,(@time_zone_id, 403070400, 5)
,(@time_zone_id, 416372400, 6)
,(@time_zone_id, 434520000, 5)
,(@time_zone_id, 447822000, 6)
,(@time_zone_id, 466574400, 5)
,(@time_zone_id, 479271600, 6)
,(@time_zone_id, 498024000, 5)
,(@time_zone_id, 510721200, 6)
,(@time_zone_id, 529473600, 5)
,(@time_zone_id, 545194800, 6)
,(@time_zone_id, 560923200, 5)
,(@time_zone_id, 574225200, 6)
,(@time_zone_id, 592372800, 5)
,(@time_zone_id, 605674800, 6)
,(@time_zone_id, 624427200, 5)
,(@time_zone_id, 637124400, 6)
,(@time_zone_id, 653457600, 5)
,(@time_zone_id, 668574000, 6)
,(@time_zone_id, 687326400, 5)
,(@time_zone_id, 700628400, 6)
,(@time_zone_id, 718776000, 5)
,(@time_zone_id, 732078000, 6)
,(@time_zone_id, 750225600, 5)
,(@time_zone_id, 763527600, 6)
,(@time_zone_id, 781675200, 5)
,(@time_zone_id, 794977200, 6)
,(@time_zone_id, 813729600, 5)
,(@time_zone_id, 826426800, 6)
,(@time_zone_id, 845179200, 5)
,(@time_zone_id, 859690800, 6)
,(@time_zone_id, 876628800, 5)
,(@time_zone_id, 889930800, 6)
,(@time_zone_id, 906868800, 5)
,(@time_zone_id, 923194800, 6)
,(@time_zone_id, 939528000, 5)
,(@time_zone_id, 952830000, 6)
,(@time_zone_id, 971582400, 5)
,(@time_zone_id, 984279600, 6)
,(@time_zone_id, 1003032000, 5)
,(@time_zone_id, 1015729200, 6)
,(@time_zone_id, 1034481600, 5)
,(@time_zone_id, 1047178800, 6)
,(@time_zone_id, 1065931200, 5)
,(@time_zone_id, 1079233200, 6)
,(@time_zone_id, 1097380800, 5)
,(@time_zone_id, 1110682800, 6)
,(@time_zone_id, 1128830400, 5)
,(@time_zone_id, 1142132400, 6)
,(@time_zone_id, 1160884800, 5)
,(@time_zone_id, 1173582000, 6)
,(@time_zone_id, 1192334400, 5)
,(@time_zone_id, 1206846000, 6)
,(@time_zone_id, 1223784000, 5)
,(@time_zone_id, 1237086000, 6)
,(@time_zone_id, 1255233600, 5)
,(@time_zone_id, 1270350000, 6)
,(@time_zone_id, 1286683200, 5)
,(@time_zone_id, 1304823600, 6)
,(@time_zone_id, 1313899200, 5)
,(@time_zone_id, 1335668400, 6)
,(@time_zone_id, 1346558400, 5)
,(@time_zone_id, 1367118000, 6)
,(@time_zone_id, 1378612800, 5)
,(@time_zone_id, 1398567600, 6)
,(@time_zone_id, 1410062400, 5)
,(@time_zone_id, 1463281200, 6)
,(@time_zone_id, 1471147200, 5)
,(@time_zone_id, 1480820400, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, -14400, 0, '-04')
,(@time_zone_id, 2, -10800, 1, '-03')
,(@time_zone_id, 3, -7200, 1, '-02')
,(@time_zone_id, 4, -10800, 0, '-03')
,(@time_zone_id, 5, -10800, 1, '-03')
,(@time_zone_id, 6, -14400, 0, '-04')
,(@time_zone_id, 7, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/Rothera', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, 218246400, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, -10800, 0, '-03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/South_Pole', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1330335000, 1)
,(@time_zone_id, -1320057000, 2)
,(@time_zone_id, -1300699800, 3)
,(@time_zone_id, -1287396000, 2)
,(@time_zone_id, -1269250200, 3)
,(@time_zone_id, -1255946400, 2)
,(@time_zone_id, -1237800600, 3)
,(@time_zone_id, -1224496800, 2)
,(@time_zone_id, -1206351000, 3)
,(@time_zone_id, -1192442400, 2)
,(@time_zone_id, -1174901400, 3)
,(@time_zone_id, -1160992800, 2)
,(@time_zone_id, -1143451800, 3)
,(@time_zone_id, -1125914400, 2)
,(@time_zone_id, -1112607000, 3)
,(@time_zone_id, -1094464800, 2)
,(@time_zone_id, -1081157400, 3)
,(@time_zone_id, -1063015200, 2)
,(@time_zone_id, -1049707800, 3)
,(@time_zone_id, -1031565600, 2)
,(@time_zone_id, -1018258200, 3)
,(@time_zone_id, -1000116000, 2)
,(@time_zone_id, -986808600, 3)
,(@time_zone_id, -968061600, 2)
,(@time_zone_id, -955359000, 3)
,(@time_zone_id, -936612000, 2)
,(@time_zone_id, -923304600, 3)
,(@time_zone_id, -757425600, 6)
,(@time_zone_id, 152632800, 4)
,(@time_zone_id, 162309600, 5)
,(@time_zone_id, 183477600, 4)
,(@time_zone_id, 194968800, 5)
,(@time_zone_id, 215532000, 4)
,(@time_zone_id, 226418400, 5)
,(@time_zone_id, 246981600, 4)
,(@time_zone_id, 257868000, 5)
,(@time_zone_id, 278431200, 4)
,(@time_zone_id, 289317600, 5)
,(@time_zone_id, 309880800, 4)
,(@time_zone_id, 320767200, 5)
,(@time_zone_id, 341330400, 4)
,(@time_zone_id, 352216800, 5)
,(@time_zone_id, 372780000, 4)
,(@time_zone_id, 384271200, 5)
,(@time_zone_id, 404834400, 4)
,(@time_zone_id, 415720800, 5)
,(@time_zone_id, 436284000, 4)
,(@time_zone_id, 447170400, 5)
,(@time_zone_id, 467733600, 4)
,(@time_zone_id, 478620000, 5)
,(@time_zone_id, 499183200, 4)
,(@time_zone_id, 510069600, 5)
,(@time_zone_id, 530632800, 4)
,(@time_zone_id, 541519200, 5)
,(@time_zone_id, 562082400, 4)
,(@time_zone_id, 573573600, 5)
,(@time_zone_id, 594136800, 4)
,(@time_zone_id, 605023200, 5)
,(@time_zone_id, 623772000, 4)
,(@time_zone_id, 637682400, 5)
,(@time_zone_id, 655221600, 4)
,(@time_zone_id, 669132000, 5)
,(@time_zone_id, 686671200, 4)
,(@time_zone_id, 700581600, 5)
,(@time_zone_id, 718120800, 4)
,(@time_zone_id, 732636000, 5)
,(@time_zone_id, 749570400, 4)
,(@time_zone_id, 764085600, 5)
,(@time_zone_id, 781020000, 4)
,(@time_zone_id, 795535200, 5)
,(@time_zone_id, 812469600, 4)
,(@time_zone_id, 826984800, 5)
,(@time_zone_id, 844524000, 4)
,(@time_zone_id, 858434400, 5)
,(@time_zone_id, 875973600, 4)
,(@time_zone_id, 889884000, 5)
,(@time_zone_id, 907423200, 4)
,(@time_zone_id, 921938400, 5)
,(@time_zone_id, 938872800, 4)
,(@time_zone_id, 953388000, 5)
,(@time_zone_id, 970322400, 4)
,(@time_zone_id, 984837600, 5)
,(@time_zone_id, 1002376800, 4)
,(@time_zone_id, 1016287200, 5)
,(@time_zone_id, 1033826400, 4)
,(@time_zone_id, 1047736800, 5)
,(@time_zone_id, 1065276000, 4)
,(@time_zone_id, 1079791200, 5)
,(@time_zone_id, 1096725600, 4)
,(@time_zone_id, 1111240800, 5)
,(@time_zone_id, 1128175200, 4)
,(@time_zone_id, 1142690400, 5)
,(@time_zone_id, 1159624800, 4)
,(@time_zone_id, 1174140000, 5)
,(@time_zone_id, 1191074400, 4)
,(@time_zone_id, 1207404000, 5)
,(@time_zone_id, 1222524000, 4)
,(@time_zone_id, 1238853600, 5)
,(@time_zone_id, 1253973600, 4)
,(@time_zone_id, 1270303200, 5)
,(@time_zone_id, 1285423200, 4)
,(@time_zone_id, 1301752800, 5)
,(@time_zone_id, 1316872800, 4)
,(@time_zone_id, 1333202400, 5)
,(@time_zone_id, 1348927200, 4)
,(@time_zone_id, 1365256800, 5)
,(@time_zone_id, 1380376800, 4)
,(@time_zone_id, 1396706400, 5)
,(@time_zone_id, 1411826400, 4)
,(@time_zone_id, 1428156000, 5)
,(@time_zone_id, 1443276000, 4)
,(@time_zone_id, 1459605600, 5)
,(@time_zone_id, 1474725600, 4)
,(@time_zone_id, 1491055200, 5)
,(@time_zone_id, 1506175200, 4)
,(@time_zone_id, 1522504800, 5)
,(@time_zone_id, 1538229600, 4)
,(@time_zone_id, 1554559200, 5)
,(@time_zone_id, 1569679200, 4)
,(@time_zone_id, 1586008800, 5)
,(@time_zone_id, 1601128800, 4)
,(@time_zone_id, 1617458400, 5)
,(@time_zone_id, 1632578400, 4)
,(@time_zone_id, 1648908000, 5)
,(@time_zone_id, 1664028000, 4)
,(@time_zone_id, 1680357600, 5)
,(@time_zone_id, 1695477600, 4)
,(@time_zone_id, 1712412000, 5)
,(@time_zone_id, 1727532000, 4)
,(@time_zone_id, 1743861600, 5)
,(@time_zone_id, 1758981600, 4)
,(@time_zone_id, 1775311200, 5)
,(@time_zone_id, 1790431200, 4)
,(@time_zone_id, 1806760800, 5)
,(@time_zone_id, 1821880800, 4)
,(@time_zone_id, 1838210400, 5)
,(@time_zone_id, 1853330400, 4)
,(@time_zone_id, 1869660000, 5)
,(@time_zone_id, 1885384800, 4)
,(@time_zone_id, 1901714400, 5)
,(@time_zone_id, 1916834400, 4)
,(@time_zone_id, 1933164000, 5)
,(@time_zone_id, 1948284000, 4)
,(@time_zone_id, 1964613600, 5)
,(@time_zone_id, 1979733600, 4)
,(@time_zone_id, 1996063200, 5)
,(@time_zone_id, 2011183200, 4)
,(@time_zone_id, 2027512800, 5)
,(@time_zone_id, 2042632800, 4)
,(@time_zone_id, 2058962400, 5)
,(@time_zone_id, 2074687200, 4)
,(@time_zone_id, 2091016800, 5)
,(@time_zone_id, 2106136800, 4)
,(@time_zone_id, 2122466400, 5)
,(@time_zone_id, 2137586400, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 41944, 0, 'LMT')
,(@time_zone_id, 1, 45000, 1, 'NZST')
,(@time_zone_id, 2, 41400, 0, 'NZMT')
,(@time_zone_id, 3, 43200, 1, 'NZST')
,(@time_zone_id, 4, 46800, 1, 'NZDT')
,(@time_zone_id, 5, 43200, 0, 'NZST')
,(@time_zone_id, 6, 43200, 0, 'NZST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/Syowa', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -407808000, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, 10800, 0, '+03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/Troll', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, 1108166400, 3)
,(@time_zone_id, 1111885200, 1)
,(@time_zone_id, 1130634000, 2)
,(@time_zone_id, 1143334800, 1)
,(@time_zone_id, 1162083600, 2)
,(@time_zone_id, 1174784400, 1)
,(@time_zone_id, 1193533200, 2)
,(@time_zone_id, 1206838800, 1)
,(@time_zone_id, 1224982800, 2)
,(@time_zone_id, 1238288400, 1)
,(@time_zone_id, 1256432400, 2)
,(@time_zone_id, 1269738000, 1)
,(@time_zone_id, 1288486800, 2)
,(@time_zone_id, 1301187600, 1)
,(@time_zone_id, 1319936400, 2)
,(@time_zone_id, 1332637200, 1)
,(@time_zone_id, 1351386000, 2)
,(@time_zone_id, 1364691600, 1)
,(@time_zone_id, 1382835600, 2)
,(@time_zone_id, 1396141200, 1)
,(@time_zone_id, 1414285200, 2)
,(@time_zone_id, 1427590800, 1)
,(@time_zone_id, 1445734800, 2)
,(@time_zone_id, 1459040400, 1)
,(@time_zone_id, 1477789200, 2)
,(@time_zone_id, 1490490000, 1)
,(@time_zone_id, 1509238800, 2)
,(@time_zone_id, 1521939600, 1)
,(@time_zone_id, 1540688400, 2)
,(@time_zone_id, 1553994000, 1)
,(@time_zone_id, 1572138000, 2)
,(@time_zone_id, 1585443600, 1)
,(@time_zone_id, 1603587600, 2)
,(@time_zone_id, 1616893200, 1)
,(@time_zone_id, 1635642000, 2)
,(@time_zone_id, 1648342800, 1)
,(@time_zone_id, 1667091600, 2)
,(@time_zone_id, 1679792400, 1)
,(@time_zone_id, 1698541200, 2)
,(@time_zone_id, 1711846800, 1)
,(@time_zone_id, 1729990800, 2)
,(@time_zone_id, 1743296400, 1)
,(@time_zone_id, 1761440400, 2)
,(@time_zone_id, 1774746000, 1)
,(@time_zone_id, 1792890000, 2)
,(@time_zone_id, 1806195600, 1)
,(@time_zone_id, 1824944400, 2)
,(@time_zone_id, 1837645200, 1)
,(@time_zone_id, 1856394000, 2)
,(@time_zone_id, 1869094800, 1)
,(@time_zone_id, 1887843600, 2)
,(@time_zone_id, 1901149200, 1)
,(@time_zone_id, 1919293200, 2)
,(@time_zone_id, 1932598800, 1)
,(@time_zone_id, 1950742800, 2)
,(@time_zone_id, 1964048400, 1)
,(@time_zone_id, 1982797200, 2)
,(@time_zone_id, 1995498000, 1)
,(@time_zone_id, 2014246800, 2)
,(@time_zone_id, 2026947600, 1)
,(@time_zone_id, 2045696400, 2)
,(@time_zone_id, 2058397200, 1)
,(@time_zone_id, 2077146000, 2)
,(@time_zone_id, 2090451600, 1)
,(@time_zone_id, 2108595600, 2)
,(@time_zone_id, 2121901200, 1)
,(@time_zone_id, 2140045200, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, 7200, 1, '+02')
,(@time_zone_id, 2, 0, 0, '+00')
,(@time_zone_id, 3, 0, 0, '+00')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Antarctica/Vostok', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -380073600, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 0, 0, '-00')
,(@time_zone_id, 1, 21600, 0, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Arctic/Longyearbyen', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1691884800, 1)
,(@time_zone_id, -1680573600, 2)
,(@time_zone_id, -927511200, 1)
,(@time_zone_id, -857257200, 3)
,(@time_zone_id, -844556400, 4)
,(@time_zone_id, -828226800, 3)
,(@time_zone_id, -812502000, 4)
,(@time_zone_id, -796777200, 3)
,(@time_zone_id, -781052400, 4)
,(@time_zone_id, -765327600, 3)
,(@time_zone_id, -340844400, 4)
,(@time_zone_id, -324514800, 3)
,(@time_zone_id, -308790000, 4)
,(@time_zone_id, -293065200, 3)
,(@time_zone_id, -277340400, 4)
,(@time_zone_id, -261615600, 3)
,(@time_zone_id, -245890800, 4)
,(@time_zone_id, -230166000, 3)
,(@time_zone_id, -214441200, 4)
,(@time_zone_id, -198716400, 3)
,(@time_zone_id, -182991600, 4)
,(@time_zone_id, -166662000, 3)
,(@time_zone_id, -147913200, 4)
,(@time_zone_id, -135212400, 3)
,(@time_zone_id, 315529200, 2)
,(@time_zone_id, 323830800, 5)
,(@time_zone_id, 338950800, 6)
,(@time_zone_id, 354675600, 5)
,(@time_zone_id, 370400400, 6)
,(@time_zone_id, 386125200, 5)
,(@time_zone_id, 401850000, 6)
,(@time_zone_id, 417574800, 5)
,(@time_zone_id, 433299600, 6)
,(@time_zone_id, 449024400, 5)
,(@time_zone_id, 465354000, 6)
,(@time_zone_id, 481078800, 5)
,(@time_zone_id, 496803600, 6)
,(@time_zone_id, 512528400, 5)
,(@time_zone_id, 528253200, 6)
,(@time_zone_id, 543978000, 5)
,(@time_zone_id, 559702800, 6)
,(@time_zone_id, 575427600, 5)
,(@time_zone_id, 591152400, 6)
,(@time_zone_id, 606877200, 5)
,(@time_zone_id, 622602000, 6)
,(@time_zone_id, 638326800, 5)
,(@time_zone_id, 654656400, 6)
,(@time_zone_id, 670381200, 5)
,(@time_zone_id, 686106000, 6)
,(@time_zone_id, 701830800, 5)
,(@time_zone_id, 717555600, 6)
,(@time_zone_id, 733280400, 5)
,(@time_zone_id, 749005200, 6)
,(@time_zone_id, 764730000, 5)
,(@time_zone_id, 780454800, 6)
,(@time_zone_id, 796179600, 5)
,(@time_zone_id, 811904400, 6)
,(@time_zone_id, 828234000, 5)
,(@time_zone_id, 846378000, 6)
,(@time_zone_id, 859683600, 5)
,(@time_zone_id, 877827600, 6)
,(@time_zone_id, 891133200, 5)
,(@time_zone_id, 909277200, 6)
,(@time_zone_id, 922582800, 5)
,(@time_zone_id, 941331600, 6)
,(@time_zone_id, 954032400, 5)
,(@time_zone_id, 972781200, 6)
,(@time_zone_id, 985482000, 5)
,(@time_zone_id, 1004230800, 6)
,(@time_zone_id, 1017536400, 5)
,(@time_zone_id, 1035680400, 6)
,(@time_zone_id, 1048986000, 5)
,(@time_zone_id, 1067130000, 6)
,(@time_zone_id, 1080435600, 5)
,(@time_zone_id, 1099184400, 6)
,(@time_zone_id, 1111885200, 5)
,(@time_zone_id, 1130634000, 6)
,(@time_zone_id, 1143334800, 5)
,(@time_zone_id, 1162083600, 6)
,(@time_zone_id, 1174784400, 5)
,(@time_zone_id, 1193533200, 6)
,(@time_zone_id, 1206838800, 5)
,(@time_zone_id, 1224982800, 6)
,(@time_zone_id, 1238288400, 5)
,(@time_zone_id, 1256432400, 6)
,(@time_zone_id, 1269738000, 5)
,(@time_zone_id, 1288486800, 6)
,(@time_zone_id, 1301187600, 5)
,(@time_zone_id, 1319936400, 6)
,(@time_zone_id, 1332637200, 5)
,(@time_zone_id, 1351386000, 6)
,(@time_zone_id, 1364691600, 5)
,(@time_zone_id, 1382835600, 6)
,(@time_zone_id, 1396141200, 5)
,(@time_zone_id, 1414285200, 6)
,(@time_zone_id, 1427590800, 5)
,(@time_zone_id, 1445734800, 6)
,(@time_zone_id, 1459040400, 5)
,(@time_zone_id, 1477789200, 6)
,(@time_zone_id, 1490490000, 5)
,(@time_zone_id, 1509238800, 6)
,(@time_zone_id, 1521939600, 5)
,(@time_zone_id, 1540688400, 6)
,(@time_zone_id, 1553994000, 5)
,(@time_zone_id, 1572138000, 6)
,(@time_zone_id, 1585443600, 5)
,(@time_zone_id, 1603587600, 6)
,(@time_zone_id, 1616893200, 5)
,(@time_zone_id, 1635642000, 6)
,(@time_zone_id, 1648342800, 5)
,(@time_zone_id, 1667091600, 6)
,(@time_zone_id, 1679792400, 5)
,(@time_zone_id, 1698541200, 6)
,(@time_zone_id, 1711846800, 5)
,(@time_zone_id, 1729990800, 6)
,(@time_zone_id, 1743296400, 5)
,(@time_zone_id, 1761440400, 6)
,(@time_zone_id, 1774746000, 5)
,(@time_zone_id, 1792890000, 6)
,(@time_zone_id, 1806195600, 5)
,(@time_zone_id, 1824944400, 6)
,(@time_zone_id, 1837645200, 5)
,(@time_zone_id, 1856394000, 6)
,(@time_zone_id, 1869094800, 5)
,(@time_zone_id, 1887843600, 6)
,(@time_zone_id, 1901149200, 5)
,(@time_zone_id, 1919293200, 6)
,(@time_zone_id, 1932598800, 5)
,(@time_zone_id, 1950742800, 6)
,(@time_zone_id, 1964048400, 5)
,(@time_zone_id, 1982797200, 6)
,(@time_zone_id, 1995498000, 5)
,(@time_zone_id, 2014246800, 6)
,(@time_zone_id, 2026947600, 5)
,(@time_zone_id, 2045696400, 6)
,(@time_zone_id, 2058397200, 5)
,(@time_zone_id, 2077146000, 6)
,(@time_zone_id, 2090451600, 5)
,(@time_zone_id, 2108595600, 6)
,(@time_zone_id, 2121901200, 5)
,(@time_zone_id, 2140045200, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 2580, 0, 'LMT')
,(@time_zone_id, 1, 7200, 1, 'CEST')
,(@time_zone_id, 2, 3600, 0, 'CET')
,(@time_zone_id, 3, 3600, 0, 'CET')
,(@time_zone_id, 4, 7200, 1, 'CEST')
,(@time_zone_id, 5, 7200, 1, 'CEST')
,(@time_zone_id, 6, 3600, 0, 'CET')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Aden', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -719636812, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 11212, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, '+03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Almaty', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441170468, 1)
,(@time_zone_id, -1247547600, 3)
,(@time_zone_id, 354909600, 2)
,(@time_zone_id, 370717200, 3)
,(@time_zone_id, 386445600, 2)
,(@time_zone_id, 402253200, 3)
,(@time_zone_id, 417981600, 2)
,(@time_zone_id, 433789200, 3)
,(@time_zone_id, 449604000, 2)
,(@time_zone_id, 465336000, 4)
,(@time_zone_id, 481060800, 5)
,(@time_zone_id, 496785600, 4)
,(@time_zone_id, 512510400, 5)
,(@time_zone_id, 528235200, 4)
,(@time_zone_id, 543960000, 5)
,(@time_zone_id, 559684800, 4)
,(@time_zone_id, 575409600, 5)
,(@time_zone_id, 591134400, 4)
,(@time_zone_id, 606859200, 5)
,(@time_zone_id, 622584000, 4)
,(@time_zone_id, 638308800, 5)
,(@time_zone_id, 654638400, 4)
,(@time_zone_id, 670363200, 6)
,(@time_zone_id, 686091600, 7)
,(@time_zone_id, 695768400, 4)
,(@time_zone_id, 701812800, 5)
,(@time_zone_id, 717537600, 4)
,(@time_zone_id, 733262400, 5)
,(@time_zone_id, 748987200, 4)
,(@time_zone_id, 764712000, 5)
,(@time_zone_id, 780436800, 4)
,(@time_zone_id, 796161600, 5)
,(@time_zone_id, 811886400, 4)
,(@time_zone_id, 828216000, 5)
,(@time_zone_id, 846360000, 4)
,(@time_zone_id, 859665600, 5)
,(@time_zone_id, 877809600, 4)
,(@time_zone_id, 891115200, 5)
,(@time_zone_id, 909259200, 4)
,(@time_zone_id, 922564800, 5)
,(@time_zone_id, 941313600, 4)
,(@time_zone_id, 954014400, 5)
,(@time_zone_id, 972763200, 4)
,(@time_zone_id, 985464000, 5)
,(@time_zone_id, 1004212800, 4)
,(@time_zone_id, 1017518400, 5)
,(@time_zone_id, 1035662400, 4)
,(@time_zone_id, 1048968000, 5)
,(@time_zone_id, 1067112000, 4)
,(@time_zone_id, 1080417600, 5)
,(@time_zone_id, 1099166400, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 18468, 0, 'LMT')
,(@time_zone_id, 1, 18000, 0, '+05')
,(@time_zone_id, 2, 25200, 1, '+07')
,(@time_zone_id, 3, 21600, 0, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 25200, 1, '+07')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 0, '+05')
,(@time_zone_id, 8, 25200, 1, '+07')
,(@time_zone_id, 9, 21600, 0, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Amman', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1230776624, 2)
,(@time_zone_id, 108165600, 1)
,(@time_zone_id, 118270800, 2)
,(@time_zone_id, 136591200, 1)
,(@time_zone_id, 149806800, 2)
,(@time_zone_id, 168127200, 1)
,(@time_zone_id, 181342800, 2)
,(@time_zone_id, 199749600, 1)
,(@time_zone_id, 215643600, 2)
,(@time_zone_id, 231285600, 1)
,(@time_zone_id, 244501200, 2)
,(@time_zone_id, 262735200, 1)
,(@time_zone_id, 275950800, 2)
,(@time_zone_id, 481154400, 1)
,(@time_zone_id, 496962000, 2)
,(@time_zone_id, 512949600, 1)
,(@time_zone_id, 528670800, 2)
,(@time_zone_id, 544399200, 1)
,(@time_zone_id, 560120400, 2)
,(@time_zone_id, 575848800, 1)
,(@time_zone_id, 592174800, 2)
,(@time_zone_id, 610581600, 1)
,(@time_zone_id, 623624400, 2)
,(@time_zone_id, 641167200, 1)
,(@time_zone_id, 655074000, 2)
,(@time_zone_id, 671839200, 1)
,(@time_zone_id, 685918800, 2)
,(@time_zone_id, 702856800, 1)
,(@time_zone_id, 717973200, 2)
,(@time_zone_id, 733701600, 1)
,(@time_zone_id, 749422800, 2)
,(@time_zone_id, 765151200, 1)
,(@time_zone_id, 779662800, 2)
,(@time_zone_id, 797205600, 1)
,(@time_zone_id, 811116000, 3)
,(@time_zone_id, 828655200, 1)
,(@time_zone_id, 843170400, 3)
,(@time_zone_id, 860104800, 1)
,(@time_zone_id, 874620000, 3)
,(@time_zone_id, 891554400, 1)
,(@time_zone_id, 906069600, 3)
,(@time_zone_id, 930780000, 4)
,(@time_zone_id, 938124000, 3)
,(@time_zone_id, 954367200, 4)
,(@time_zone_id, 970178400, 3)
,(@time_zone_id, 985816800, 4)
,(@time_zone_id, 1001628000, 3)
,(@time_zone_id, 1017352800, 1)
,(@time_zone_id, 1033077600, 3)
,(@time_zone_id, 1048802400, 1)
,(@time_zone_id, 1066946400, 3)
,(@time_zone_id, 1080252000, 1)
,(@time_zone_id, 1097791200, 3)
,(@time_zone_id, 1112306400, 1)
,(@time_zone_id, 1128031200, 3)
,(@time_zone_id, 1143756000, 1)
,(@time_zone_id, 1161900000, 3)
,(@time_zone_id, 1175205600, 1)
,(@time_zone_id, 1193349600, 3)
,(@time_zone_id, 1206655200, 1)
,(@time_zone_id, 1225404000, 3)
,(@time_zone_id, 1238104800, 1)
,(@time_zone_id, 1256853600, 3)
,(@time_zone_id, 1269554400, 1)
,(@time_zone_id, 1288303200, 3)
,(@time_zone_id, 1301608800, 1)
,(@time_zone_id, 1319752800, 3)
,(@time_zone_id, 1333058400, 1)
,(@time_zone_id, 1387486800, 2)
,(@time_zone_id, 1395957600, 1)
,(@time_zone_id, 1414706400, 3)
,(@time_zone_id, 1427407200, 1)
,(@time_zone_id, 1446156000, 3)
,(@time_zone_id, 1459461600, 1)
,(@time_zone_id, 1477605600, 3)
,(@time_zone_id, 1490911200, 1)
,(@time_zone_id, 1509055200, 3)
,(@time_zone_id, 1522360800, 1)
,(@time_zone_id, 1540504800, 3)
,(@time_zone_id, 1553810400, 1)
,(@time_zone_id, 1571954400, 3)
,(@time_zone_id, 1585260000, 1)
,(@time_zone_id, 1604008800, 3)
,(@time_zone_id, 1616709600, 1)
,(@time_zone_id, 1635458400, 3)
,(@time_zone_id, 1648764000, 1)
,(@time_zone_id, 1666908000, 3)
,(@time_zone_id, 1680213600, 1)
,(@time_zone_id, 1698357600, 3)
,(@time_zone_id, 1711663200, 1)
,(@time_zone_id, 1729807200, 3)
,(@time_zone_id, 1743112800, 1)
,(@time_zone_id, 1761861600, 3)
,(@time_zone_id, 1774562400, 1)
,(@time_zone_id, 1793311200, 3)
,(@time_zone_id, 1806012000, 1)
,(@time_zone_id, 1824760800, 3)
,(@time_zone_id, 1838066400, 1)
,(@time_zone_id, 1856210400, 3)
,(@time_zone_id, 1869516000, 1)
,(@time_zone_id, 1887660000, 3)
,(@time_zone_id, 1900965600, 1)
,(@time_zone_id, 1919109600, 3)
,(@time_zone_id, 1932415200, 1)
,(@time_zone_id, 1951164000, 3)
,(@time_zone_id, 1963864800, 1)
,(@time_zone_id, 1982613600, 3)
,(@time_zone_id, 1995919200, 1)
,(@time_zone_id, 2014063200, 3)
,(@time_zone_id, 2027368800, 1)
,(@time_zone_id, 2045512800, 3)
,(@time_zone_id, 2058818400, 1)
,(@time_zone_id, 2076962400, 3)
,(@time_zone_id, 2090268000, 1)
,(@time_zone_id, 2109016800, 3)
,(@time_zone_id, 2121717600, 1)
,(@time_zone_id, 2140466400, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8624, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'EEST')
,(@time_zone_id, 2, 7200, 0, 'EET')
,(@time_zone_id, 3, 7200, 0, 'EET')
,(@time_zone_id, 4, 10800, 1, 'EEST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Anadyr', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441194596, 1)
,(@time_zone_id, -1247572800, 3)
,(@time_zone_id, 354884400, 2)
,(@time_zone_id, 370692000, 3)
,(@time_zone_id, 386420400, 4)
,(@time_zone_id, 402231600, 1)
,(@time_zone_id, 417960000, 4)
,(@time_zone_id, 433767600, 1)
,(@time_zone_id, 449582400, 4)
,(@time_zone_id, 465314400, 5)
,(@time_zone_id, 481039200, 6)
,(@time_zone_id, 496764000, 5)
,(@time_zone_id, 512488800, 6)
,(@time_zone_id, 528213600, 5)
,(@time_zone_id, 543938400, 6)
,(@time_zone_id, 559663200, 5)
,(@time_zone_id, 575388000, 6)
,(@time_zone_id, 591112800, 5)
,(@time_zone_id, 606837600, 6)
,(@time_zone_id, 622562400, 5)
,(@time_zone_id, 638287200, 6)
,(@time_zone_id, 654616800, 5)
,(@time_zone_id, 670341600, 7)
,(@time_zone_id, 686070000, 8)
,(@time_zone_id, 695746800, 5)
,(@time_zone_id, 701791200, 6)
,(@time_zone_id, 717516000, 5)
,(@time_zone_id, 733240800, 6)
,(@time_zone_id, 748965600, 5)
,(@time_zone_id, 764690400, 6)
,(@time_zone_id, 780415200, 5)
,(@time_zone_id, 796140000, 6)
,(@time_zone_id, 811864800, 5)
,(@time_zone_id, 828194400, 6)
,(@time_zone_id, 846338400, 5)
,(@time_zone_id, 859644000, 6)
,(@time_zone_id, 877788000, 5)
,(@time_zone_id, 891093600, 6)
,(@time_zone_id, 909237600, 5)
,(@time_zone_id, 922543200, 6)
,(@time_zone_id, 941292000, 5)
,(@time_zone_id, 953992800, 6)
,(@time_zone_id, 972741600, 5)
,(@time_zone_id, 985442400, 6)
,(@time_zone_id, 1004191200, 5)
,(@time_zone_id, 1017496800, 6)
,(@time_zone_id, 1035640800, 5)
,(@time_zone_id, 1048946400, 6)
,(@time_zone_id, 1067090400, 5)
,(@time_zone_id, 1080396000, 6)
,(@time_zone_id, 1099144800, 5)
,(@time_zone_id, 1111845600, 6)
,(@time_zone_id, 1130594400, 5)
,(@time_zone_id, 1143295200, 6)
,(@time_zone_id, 1162044000, 5)
,(@time_zone_id, 1174744800, 6)
,(@time_zone_id, 1193493600, 5)
,(@time_zone_id, 1206799200, 6)
,(@time_zone_id, 1224943200, 5)
,(@time_zone_id, 1238248800, 6)
,(@time_zone_id, 1256392800, 5)
,(@time_zone_id, 1269698400, 7)
,(@time_zone_id, 1288450800, 8)
,(@time_zone_id, 1301151600, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 42596, 0, 'LMT')
,(@time_zone_id, 1, 43200, 0, '+12')
,(@time_zone_id, 2, 50400, 1, '+14')
,(@time_zone_id, 3, 46800, 0, '+13')
,(@time_zone_id, 4, 46800, 1, '+13')
,(@time_zone_id, 5, 43200, 0, '+12')
,(@time_zone_id, 6, 46800, 1, '+13')
,(@time_zone_id, 7, 43200, 1, '+12')
,(@time_zone_id, 8, 39600, 0, '+11')
,(@time_zone_id, 9, 43200, 0, '+12')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Aqtau', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441164064, 1)
,(@time_zone_id, -1247544000, 2)
,(@time_zone_id, 370724400, 3)
,(@time_zone_id, 386445600, 4)
,(@time_zone_id, 402256800, 2)
,(@time_zone_id, 417985200, 4)
,(@time_zone_id, 433792800, 2)
,(@time_zone_id, 449607600, 4)
,(@time_zone_id, 465339600, 5)
,(@time_zone_id, 481064400, 6)
,(@time_zone_id, 496789200, 5)
,(@time_zone_id, 512514000, 6)
,(@time_zone_id, 528238800, 5)
,(@time_zone_id, 543963600, 6)
,(@time_zone_id, 559688400, 5)
,(@time_zone_id, 575413200, 6)
,(@time_zone_id, 591138000, 5)
,(@time_zone_id, 606862800, 6)
,(@time_zone_id, 622587600, 5)
,(@time_zone_id, 638312400, 6)
,(@time_zone_id, 654642000, 5)
,(@time_zone_id, 670366800, 7)
,(@time_zone_id, 686095200, 8)
,(@time_zone_id, 695772000, 5)
,(@time_zone_id, 701816400, 6)
,(@time_zone_id, 717541200, 5)
,(@time_zone_id, 733266000, 6)
,(@time_zone_id, 748990800, 5)
,(@time_zone_id, 764715600, 6)
,(@time_zone_id, 780440400, 8)
,(@time_zone_id, 796168800, 7)
,(@time_zone_id, 811893600, 8)
,(@time_zone_id, 828223200, 7)
,(@time_zone_id, 846367200, 8)
,(@time_zone_id, 859672800, 7)
,(@time_zone_id, 877816800, 8)
,(@time_zone_id, 891122400, 7)
,(@time_zone_id, 909266400, 8)
,(@time_zone_id, 922572000, 7)
,(@time_zone_id, 941320800, 8)
,(@time_zone_id, 954021600, 7)
,(@time_zone_id, 972770400, 8)
,(@time_zone_id, 985471200, 7)
,(@time_zone_id, 1004220000, 8)
,(@time_zone_id, 1017525600, 7)
,(@time_zone_id, 1035669600, 8)
,(@time_zone_id, 1048975200, 7)
,(@time_zone_id, 1067119200, 8)
,(@time_zone_id, 1080424800, 7)
,(@time_zone_id, 1099173600, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 12064, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 18000, 0, '+05')
,(@time_zone_id, 3, 21600, 0, '+06')
,(@time_zone_id, 4, 21600, 1, '+06')
,(@time_zone_id, 5, 18000, 0, '+05')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 1, '+05')
,(@time_zone_id, 8, 14400, 0, '+04')
,(@time_zone_id, 9, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Aqtobe', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441165720, 1)
,(@time_zone_id, -1247544000, 2)
,(@time_zone_id, 354913200, 3)
,(@time_zone_id, 370720800, 4)
,(@time_zone_id, 386445600, 3)
,(@time_zone_id, 402256800, 2)
,(@time_zone_id, 417985200, 3)
,(@time_zone_id, 433792800, 2)
,(@time_zone_id, 449607600, 3)
,(@time_zone_id, 465339600, 5)
,(@time_zone_id, 481064400, 6)
,(@time_zone_id, 496789200, 5)
,(@time_zone_id, 512514000, 6)
,(@time_zone_id, 528238800, 5)
,(@time_zone_id, 543963600, 6)
,(@time_zone_id, 559688400, 5)
,(@time_zone_id, 575413200, 6)
,(@time_zone_id, 591138000, 5)
,(@time_zone_id, 606862800, 6)
,(@time_zone_id, 622587600, 5)
,(@time_zone_id, 638312400, 6)
,(@time_zone_id, 654642000, 5)
,(@time_zone_id, 670366800, 7)
,(@time_zone_id, 686095200, 8)
,(@time_zone_id, 695772000, 5)
,(@time_zone_id, 701816400, 6)
,(@time_zone_id, 717541200, 5)
,(@time_zone_id, 733266000, 6)
,(@time_zone_id, 748990800, 5)
,(@time_zone_id, 764715600, 6)
,(@time_zone_id, 780440400, 5)
,(@time_zone_id, 796165200, 6)
,(@time_zone_id, 811890000, 5)
,(@time_zone_id, 828219600, 6)
,(@time_zone_id, 846363600, 5)
,(@time_zone_id, 859669200, 6)
,(@time_zone_id, 877813200, 5)
,(@time_zone_id, 891118800, 6)
,(@time_zone_id, 909262800, 5)
,(@time_zone_id, 922568400, 6)
,(@time_zone_id, 941317200, 5)
,(@time_zone_id, 954018000, 6)
,(@time_zone_id, 972766800, 5)
,(@time_zone_id, 985467600, 6)
,(@time_zone_id, 1004216400, 5)
,(@time_zone_id, 1017522000, 6)
,(@time_zone_id, 1035666000, 5)
,(@time_zone_id, 1048971600, 6)
,(@time_zone_id, 1067115600, 5)
,(@time_zone_id, 1080421200, 6)
,(@time_zone_id, 1099170000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 13720, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 18000, 0, '+05')
,(@time_zone_id, 3, 21600, 1, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 18000, 0, '+05')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 1, '+05')
,(@time_zone_id, 8, 14400, 0, '+04')
,(@time_zone_id, 9, 21600, 1, '+06')
,(@time_zone_id, 10, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Ashgabat', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441166012, 1)
,(@time_zone_id, -1247544000, 3)
,(@time_zone_id, 354913200, 2)
,(@time_zone_id, 370720800, 3)
,(@time_zone_id, 386449200, 2)
,(@time_zone_id, 402256800, 3)
,(@time_zone_id, 417985200, 2)
,(@time_zone_id, 433792800, 3)
,(@time_zone_id, 449607600, 2)
,(@time_zone_id, 465339600, 4)
,(@time_zone_id, 481064400, 5)
,(@time_zone_id, 496789200, 4)
,(@time_zone_id, 512514000, 5)
,(@time_zone_id, 528238800, 4)
,(@time_zone_id, 543963600, 5)
,(@time_zone_id, 559688400, 4)
,(@time_zone_id, 575413200, 5)
,(@time_zone_id, 591138000, 4)
,(@time_zone_id, 606862800, 5)
,(@time_zone_id, 622587600, 4)
,(@time_zone_id, 638312400, 5)
,(@time_zone_id, 654642000, 4)
,(@time_zone_id, 670366800, 6)
,(@time_zone_id, 686095200, 7)
,(@time_zone_id, 695772000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 14012, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 21600, 1, '+06')
,(@time_zone_id, 3, 18000, 0, '+05')
,(@time_zone_id, 4, 18000, 0, '+05')
,(@time_zone_id, 5, 21600, 1, '+06')
,(@time_zone_id, 6, 18000, 1, '+05')
,(@time_zone_id, 7, 14400, 0, '+04')
,(@time_zone_id, 8, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Ashkhabad', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441166012, 1)
,(@time_zone_id, -1247544000, 3)
,(@time_zone_id, 354913200, 2)
,(@time_zone_id, 370720800, 3)
,(@time_zone_id, 386449200, 2)
,(@time_zone_id, 402256800, 3)
,(@time_zone_id, 417985200, 2)
,(@time_zone_id, 433792800, 3)
,(@time_zone_id, 449607600, 2)
,(@time_zone_id, 465339600, 4)
,(@time_zone_id, 481064400, 5)
,(@time_zone_id, 496789200, 4)
,(@time_zone_id, 512514000, 5)
,(@time_zone_id, 528238800, 4)
,(@time_zone_id, 543963600, 5)
,(@time_zone_id, 559688400, 4)
,(@time_zone_id, 575413200, 5)
,(@time_zone_id, 591138000, 4)
,(@time_zone_id, 606862800, 5)
,(@time_zone_id, 622587600, 4)
,(@time_zone_id, 638312400, 5)
,(@time_zone_id, 654642000, 4)
,(@time_zone_id, 670366800, 6)
,(@time_zone_id, 686095200, 7)
,(@time_zone_id, 695772000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 14012, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 21600, 1, '+06')
,(@time_zone_id, 3, 18000, 0, '+05')
,(@time_zone_id, 4, 18000, 0, '+05')
,(@time_zone_id, 5, 21600, 1, '+06')
,(@time_zone_id, 6, 18000, 1, '+05')
,(@time_zone_id, 7, 14400, 0, '+04')
,(@time_zone_id, 8, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Atyrau', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441164464, 1)
,(@time_zone_id, -1247540400, 2)
,(@time_zone_id, 370724400, 3)
,(@time_zone_id, 386445600, 4)
,(@time_zone_id, 402256800, 2)
,(@time_zone_id, 417985200, 4)
,(@time_zone_id, 433792800, 2)
,(@time_zone_id, 449607600, 4)
,(@time_zone_id, 465339600, 5)
,(@time_zone_id, 481064400, 6)
,(@time_zone_id, 496789200, 5)
,(@time_zone_id, 512514000, 6)
,(@time_zone_id, 528238800, 5)
,(@time_zone_id, 543963600, 6)
,(@time_zone_id, 559688400, 5)
,(@time_zone_id, 575413200, 6)
,(@time_zone_id, 591138000, 5)
,(@time_zone_id, 606862800, 6)
,(@time_zone_id, 622587600, 5)
,(@time_zone_id, 638312400, 6)
,(@time_zone_id, 654642000, 5)
,(@time_zone_id, 670366800, 7)
,(@time_zone_id, 686095200, 8)
,(@time_zone_id, 695772000, 5)
,(@time_zone_id, 701816400, 6)
,(@time_zone_id, 717541200, 5)
,(@time_zone_id, 733266000, 6)
,(@time_zone_id, 748990800, 5)
,(@time_zone_id, 764715600, 6)
,(@time_zone_id, 780440400, 5)
,(@time_zone_id, 796165200, 6)
,(@time_zone_id, 811890000, 5)
,(@time_zone_id, 828219600, 6)
,(@time_zone_id, 846363600, 5)
,(@time_zone_id, 859669200, 6)
,(@time_zone_id, 877813200, 5)
,(@time_zone_id, 891118800, 6)
,(@time_zone_id, 909262800, 5)
,(@time_zone_id, 922568400, 7)
,(@time_zone_id, 941320800, 8)
,(@time_zone_id, 954021600, 7)
,(@time_zone_id, 972770400, 8)
,(@time_zone_id, 985471200, 7)
,(@time_zone_id, 1004220000, 8)
,(@time_zone_id, 1017525600, 7)
,(@time_zone_id, 1035669600, 8)
,(@time_zone_id, 1048975200, 7)
,(@time_zone_id, 1067119200, 8)
,(@time_zone_id, 1080424800, 7)
,(@time_zone_id, 1099173600, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 12464, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, '+03')
,(@time_zone_id, 2, 18000, 0, '+05')
,(@time_zone_id, 3, 21600, 0, '+06')
,(@time_zone_id, 4, 21600, 1, '+06')
,(@time_zone_id, 5, 18000, 0, '+05')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 1, '+05')
,(@time_zone_id, 8, 14400, 0, '+04')
,(@time_zone_id, 9, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Baghdad', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1641005856, 2)
,(@time_zone_id, 389048400, 3)
,(@time_zone_id, 402264000, 2)
,(@time_zone_id, 417906000, 3)
,(@time_zone_id, 433800000, 2)
,(@time_zone_id, 449614800, 3)
,(@time_zone_id, 465422400, 2)
,(@time_zone_id, 481150800, 3)
,(@time_zone_id, 496792800, 4)
,(@time_zone_id, 512517600, 5)
,(@time_zone_id, 528242400, 4)
,(@time_zone_id, 543967200, 5)
,(@time_zone_id, 559692000, 4)
,(@time_zone_id, 575416800, 5)
,(@time_zone_id, 591141600, 4)
,(@time_zone_id, 606866400, 5)
,(@time_zone_id, 622591200, 4)
,(@time_zone_id, 638316000, 5)
,(@time_zone_id, 654645600, 4)
,(@time_zone_id, 670464000, 5)
,(@time_zone_id, 686275200, 4)
,(@time_zone_id, 702086400, 5)
,(@time_zone_id, 717897600, 4)
,(@time_zone_id, 733622400, 5)
,(@time_zone_id, 749433600, 4)
,(@time_zone_id, 765158400, 5)
,(@time_zone_id, 780969600, 4)
,(@time_zone_id, 796694400, 5)
,(@time_zone_id, 812505600, 4)
,(@time_zone_id, 828316800, 5)
,(@time_zone_id, 844128000, 4)
,(@time_zone_id, 859852800, 5)
,(@time_zone_id, 875664000, 4)
,(@time_zone_id, 891388800, 5)
,(@time_zone_id, 907200000, 4)
,(@time_zone_id, 922924800, 5)
,(@time_zone_id, 938736000, 4)
,(@time_zone_id, 954547200, 5)
,(@time_zone_id, 970358400, 4)
,(@time_zone_id, 986083200, 5)
,(@time_zone_id, 1001894400, 4)
,(@time_zone_id, 1017619200, 5)
,(@time_zone_id, 1033430400, 4)
,(@time_zone_id, 1049155200, 5)
,(@time_zone_id, 1064966400, 4)
,(@time_zone_id, 1080777600, 5)
,(@time_zone_id, 1096588800, 4)
,(@time_zone_id, 1112313600, 5)
,(@time_zone_id, 1128124800, 4)
,(@time_zone_id, 1143849600, 5)
,(@time_zone_id, 1159660800, 4)
,(@time_zone_id, 1175385600, 5)
,(@time_zone_id, 1191196800, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 10660, 0, 'LMT')
,(@time_zone_id, 1, 10656, 0, 'BMT')
,(@time_zone_id, 2, 10800, 0, '+03')
,(@time_zone_id, 3, 14400, 1, '+04')
,(@time_zone_id, 4, 10800, 0, '+03')
,(@time_zone_id, 5, 14400, 1, '+04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Bahrain', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577935568, 1)
,(@time_zone_id, 76190400, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 12368, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 10800, 0, '+03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Baku', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441163964, 1)
,(@time_zone_id, -405140400, 3)
,(@time_zone_id, 354916800, 2)
,(@time_zone_id, 370724400, 3)
,(@time_zone_id, 386452800, 2)
,(@time_zone_id, 402260400, 3)
,(@time_zone_id, 417988800, 2)
,(@time_zone_id, 433796400, 3)
,(@time_zone_id, 449611200, 2)
,(@time_zone_id, 465343200, 4)
,(@time_zone_id, 481068000, 5)
,(@time_zone_id, 496792800, 4)
,(@time_zone_id, 512517600, 5)
,(@time_zone_id, 528242400, 4)
,(@time_zone_id, 543967200, 5)
,(@time_zone_id, 559692000, 4)
,(@time_zone_id, 575416800, 5)
,(@time_zone_id, 591141600, 4)
,(@time_zone_id, 606866400, 5)
,(@time_zone_id, 622591200, 4)
,(@time_zone_id, 638316000, 5)
,(@time_zone_id, 654645600, 4)
,(@time_zone_id, 670370400, 6)
,(@time_zone_id, 686098800, 7)
,(@time_zone_id, 701823600, 6)
,(@time_zone_id, 717548400, 4)
,(@time_zone_id, 820440000, 3)
,(@time_zone_id, 828234000, 8)
,(@time_zone_id, 846378000, 9)
,(@time_zone_id, 852062400, 3)
,(@time_zone_id, 859680000, 2)
,(@time_zone_id, 877824000, 3)
,(@time_zone_id, 891129600, 2)
,(@time_zone_id, 909273600, 3)
,(@time_zone_id, 922579200, 2)
,(@time_zone_id, 941328000, 3)
,(@time_zone_id, 954028800, 2)
,(@time_zone_id, 972777600, 3)
,(@time_zone_id, 985478400, 2)
,(@time_zone_id, 1004227200, 3)
,(@time_zone_id, 1017532800, 2)
,(@time_zone_id, 1035676800, 3)
,(@time_zone_id, 1048982400, 2)
,(@time_zone_id, 1067126400, 3)
,(@time_zone_id, 1080432000, 2)
,(@time_zone_id, 1099180800, 3)
,(@time_zone_id, 1111881600, 2)
,(@time_zone_id, 1130630400, 3)
,(@time_zone_id, 1143331200, 2)
,(@time_zone_id, 1162080000, 3)
,(@time_zone_id, 1174780800, 2)
,(@time_zone_id, 1193529600, 3)
,(@time_zone_id, 1206835200, 2)
,(@time_zone_id, 1224979200, 3)
,(@time_zone_id, 1238284800, 2)
,(@time_zone_id, 1256428800, 3)
,(@time_zone_id, 1269734400, 2)
,(@time_zone_id, 1288483200, 3)
,(@time_zone_id, 1301184000, 2)
,(@time_zone_id, 1319932800, 3)
,(@time_zone_id, 1332633600, 2)
,(@time_zone_id, 1351382400, 3)
,(@time_zone_id, 1364688000, 2)
,(@time_zone_id, 1382832000, 3)
,(@time_zone_id, 1396137600, 2)
,(@time_zone_id, 1414281600, 3)
,(@time_zone_id, 1427587200, 2)
,(@time_zone_id, 1445731200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 11964, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, '+03')
,(@time_zone_id, 2, 18000, 1, '+05')
,(@time_zone_id, 3, 14400, 0, '+04')
,(@time_zone_id, 4, 14400, 0, '+04')
,(@time_zone_id, 5, 18000, 1, '+05')
,(@time_zone_id, 6, 14400, 1, '+04')
,(@time_zone_id, 7, 10800, 0, '+03')
,(@time_zone_id, 8, 18000, 1, '+05')
,(@time_zone_id, 9, 14400, 0, '+04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Bangkok', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1570084924, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 24124, 0, 'LMT')
,(@time_zone_id, 1, 24124, 0, 'BMT')
,(@time_zone_id, 2, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Barnaul', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1579844100, 1)
,(@time_zone_id, -1247551200, 3)
,(@time_zone_id, 354906000, 2)
,(@time_zone_id, 370713600, 3)
,(@time_zone_id, 386442000, 2)
,(@time_zone_id, 402249600, 3)
,(@time_zone_id, 417978000, 2)
,(@time_zone_id, 433785600, 3)
,(@time_zone_id, 449600400, 2)
,(@time_zone_id, 465332400, 4)
,(@time_zone_id, 481057200, 5)
,(@time_zone_id, 496782000, 4)
,(@time_zone_id, 512506800, 5)
,(@time_zone_id, 528231600, 4)
,(@time_zone_id, 543956400, 5)
,(@time_zone_id, 559681200, 4)
,(@time_zone_id, 575406000, 5)
,(@time_zone_id, 591130800, 4)
,(@time_zone_id, 606855600, 5)
,(@time_zone_id, 622580400, 4)
,(@time_zone_id, 638305200, 5)
,(@time_zone_id, 654634800, 4)
,(@time_zone_id, 670359600, 6)
,(@time_zone_id, 686088000, 7)
,(@time_zone_id, 695764800, 4)
,(@time_zone_id, 701809200, 5)
,(@time_zone_id, 717534000, 4)
,(@time_zone_id, 733258800, 5)
,(@time_zone_id, 748983600, 4)
,(@time_zone_id, 764708400, 5)
,(@time_zone_id, 780433200, 4)
,(@time_zone_id, 796158000, 5)
,(@time_zone_id, 801590400, 8)
,(@time_zone_id, 811886400, 7)
,(@time_zone_id, 828216000, 6)
,(@time_zone_id, 846360000, 7)
,(@time_zone_id, 859665600, 6)
,(@time_zone_id, 877809600, 7)
,(@time_zone_id, 891115200, 6)
,(@time_zone_id, 909259200, 7)
,(@time_zone_id, 922564800, 6)
,(@time_zone_id, 941313600, 7)
,(@time_zone_id, 954014400, 6)
,(@time_zone_id, 972763200, 7)
,(@time_zone_id, 985464000, 6)
,(@time_zone_id, 1004212800, 7)
,(@time_zone_id, 1017518400, 6)
,(@time_zone_id, 1035662400, 7)
,(@time_zone_id, 1048968000, 6)
,(@time_zone_id, 1067112000, 7)
,(@time_zone_id, 1080417600, 6)
,(@time_zone_id, 1099166400, 7)
,(@time_zone_id, 1111867200, 6)
,(@time_zone_id, 1130616000, 7)
,(@time_zone_id, 1143316800, 6)
,(@time_zone_id, 1162065600, 7)
,(@time_zone_id, 1174766400, 6)
,(@time_zone_id, 1193515200, 7)
,(@time_zone_id, 1206820800, 6)
,(@time_zone_id, 1224964800, 7)
,(@time_zone_id, 1238270400, 6)
,(@time_zone_id, 1256414400, 7)
,(@time_zone_id, 1269720000, 6)
,(@time_zone_id, 1288468800, 7)
,(@time_zone_id, 1301169600, 4)
,(@time_zone_id, 1414263600, 7)
,(@time_zone_id, 1459022400, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 20100, 0, 'LMT')
,(@time_zone_id, 1, 21600, 0, '+06')
,(@time_zone_id, 2, 28800, 1, '+08')
,(@time_zone_id, 3, 25200, 0, '+07')
,(@time_zone_id, 4, 25200, 0, '+07')
,(@time_zone_id, 5, 28800, 1, '+08')
,(@time_zone_id, 6, 25200, 1, '+07')
,(@time_zone_id, 7, 21600, 0, '+06')
,(@time_zone_id, 8, 25200, 1, '+07')
,(@time_zone_id, 9, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Beirut', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1570413600, 1)
,(@time_zone_id, -1552186800, 2)
,(@time_zone_id, -1538359200, 1)
,(@time_zone_id, -1522551600, 2)
,(@time_zone_id, -1507514400, 1)
,(@time_zone_id, -1490583600, 2)
,(@time_zone_id, -1473645600, 1)
,(@time_zone_id, -1460948400, 2)
,(@time_zone_id, -399866400, 1)
,(@time_zone_id, -386650800, 2)
,(@time_zone_id, -368330400, 1)
,(@time_zone_id, -355114800, 2)
,(@time_zone_id, -336794400, 1)
,(@time_zone_id, -323578800, 2)
,(@time_zone_id, -305172000, 1)
,(@time_zone_id, -291956400, 2)
,(@time_zone_id, -273636000, 1)
,(@time_zone_id, -260420400, 2)
,(@time_zone_id, 78012000, 1)
,(@time_zone_id, 86734800, 2)
,(@time_zone_id, 105055200, 1)
,(@time_zone_id, 118270800, 2)
,(@time_zone_id, 136591200, 1)
,(@time_zone_id, 149806800, 2)
,(@time_zone_id, 168127200, 1)
,(@time_zone_id, 181342800, 2)
,(@time_zone_id, 199749600, 1)
,(@time_zone_id, 212965200, 2)
,(@time_zone_id, 231285600, 1)
,(@time_zone_id, 244501200, 2)
,(@time_zone_id, 262735200, 1)
,(@time_zone_id, 275950800, 2)
,(@time_zone_id, 452210400, 1)
,(@time_zone_id, 466722000, 2)
,(@time_zone_id, 483746400, 1)
,(@time_zone_id, 498258000, 2)
,(@time_zone_id, 515282400, 1)
,(@time_zone_id, 529794000, 2)
,(@time_zone_id, 546818400, 1)
,(@time_zone_id, 561330000, 2)
,(@time_zone_id, 581119200, 1)
,(@time_zone_id, 592952400, 2)
,(@time_zone_id, 610754400, 1)
,(@time_zone_id, 624488400, 2)
,(@time_zone_id, 641512800, 1)
,(@time_zone_id, 656024400, 2)
,(@time_zone_id, 673048800, 1)
,(@time_zone_id, 687560400, 2)
,(@time_zone_id, 704671200, 1)
,(@time_zone_id, 718146000, 2)
,(@time_zone_id, 733269600, 1)
,(@time_zone_id, 748990800, 2)
,(@time_zone_id, 764719200, 1)
,(@time_zone_id, 780440400, 2)
,(@time_zone_id, 796168800, 1)
,(@time_zone_id, 811890000, 2)
,(@time_zone_id, 828223200, 1)
,(@time_zone_id, 843944400, 2)
,(@time_zone_id, 859672800, 1)
,(@time_zone_id, 875394000, 2)
,(@time_zone_id, 891122400, 1)
,(@time_zone_id, 906843600, 2)
,(@time_zone_id, 922572000, 1)
,(@time_zone_id, 941317200, 2)
,(@time_zone_id, 954021600, 1)
,(@time_zone_id, 972766800, 2)
,(@time_zone_id, 985471200, 1)
,(@time_zone_id, 1004216400, 2)
,(@time_zone_id, 1017525600, 1)
,(@time_zone_id, 1035666000, 2)
,(@time_zone_id, 1048975200, 1)
,(@time_zone_id, 1067115600, 2)
,(@time_zone_id, 1080424800, 1)
,(@time_zone_id, 1099170000, 2)
,(@time_zone_id, 1111874400, 1)
,(@time_zone_id, 1130619600, 2)
,(@time_zone_id, 1143324000, 1)
,(@time_zone_id, 1162069200, 2)
,(@time_zone_id, 1174773600, 1)
,(@time_zone_id, 1193518800, 2)
,(@time_zone_id, 1206828000, 1)
,(@time_zone_id, 1224968400, 2)
,(@time_zone_id, 1238277600, 1)
,(@time_zone_id, 1256418000, 2)
,(@time_zone_id, 1269727200, 1)
,(@time_zone_id, 1288472400, 2)
,(@time_zone_id, 1301176800, 1)
,(@time_zone_id, 1319922000, 2)
,(@time_zone_id, 1332626400, 1)
,(@time_zone_id, 1351371600, 2)
,(@time_zone_id, 1364680800, 1)
,(@time_zone_id, 1382821200, 2)
,(@time_zone_id, 1396130400, 1)
,(@time_zone_id, 1414270800, 2)
,(@time_zone_id, 1427580000, 1)
,(@time_zone_id, 1445720400, 2)
,(@time_zone_id, 1459029600, 1)
,(@time_zone_id, 1477774800, 2)
,(@time_zone_id, 1490479200, 1)
,(@time_zone_id, 1509224400, 2)
,(@time_zone_id, 1521928800, 1)
,(@time_zone_id, 1540674000, 2)
,(@time_zone_id, 1553983200, 1)
,(@time_zone_id, 1572123600, 2)
,(@time_zone_id, 1585432800, 1)
,(@time_zone_id, 1603573200, 2)
,(@time_zone_id, 1616882400, 1)
,(@time_zone_id, 1635627600, 2)
,(@time_zone_id, 1648332000, 1)
,(@time_zone_id, 1667077200, 2)
,(@time_zone_id, 1679781600, 1)
,(@time_zone_id, 1698526800, 2)
,(@time_zone_id, 1711836000, 1)
,(@time_zone_id, 1729976400, 2)
,(@time_zone_id, 1743285600, 1)
,(@time_zone_id, 1761426000, 2)
,(@time_zone_id, 1774735200, 1)
,(@time_zone_id, 1792875600, 2)
,(@time_zone_id, 1806184800, 1)
,(@time_zone_id, 1824930000, 2)
,(@time_zone_id, 1837634400, 1)
,(@time_zone_id, 1856379600, 2)
,(@time_zone_id, 1869084000, 1)
,(@time_zone_id, 1887829200, 2)
,(@time_zone_id, 1901138400, 1)
,(@time_zone_id, 1919278800, 2)
,(@time_zone_id, 1932588000, 1)
,(@time_zone_id, 1950728400, 2)
,(@time_zone_id, 1964037600, 1)
,(@time_zone_id, 1982782800, 2)
,(@time_zone_id, 1995487200, 1)
,(@time_zone_id, 2014232400, 2)
,(@time_zone_id, 2026936800, 1)
,(@time_zone_id, 2045682000, 2)
,(@time_zone_id, 2058386400, 1)
,(@time_zone_id, 2077131600, 2)
,(@time_zone_id, 2090440800, 1)
,(@time_zone_id, 2108581200, 2)
,(@time_zone_id, 2121890400, 1)
,(@time_zone_id, 2140030800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8520, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'EEST')
,(@time_zone_id, 2, 7200, 0, 'EET')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Bishkek', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441169904, 1)
,(@time_zone_id, -1247547600, 3)
,(@time_zone_id, 354909600, 2)
,(@time_zone_id, 370717200, 3)
,(@time_zone_id, 386445600, 2)
,(@time_zone_id, 402253200, 3)
,(@time_zone_id, 417981600, 2)
,(@time_zone_id, 433789200, 3)
,(@time_zone_id, 449604000, 2)
,(@time_zone_id, 465336000, 4)
,(@time_zone_id, 481060800, 5)
,(@time_zone_id, 496785600, 4)
,(@time_zone_id, 512510400, 5)
,(@time_zone_id, 528235200, 4)
,(@time_zone_id, 543960000, 5)
,(@time_zone_id, 559684800, 4)
,(@time_zone_id, 575409600, 5)
,(@time_zone_id, 591134400, 4)
,(@time_zone_id, 606859200, 5)
,(@time_zone_id, 622584000, 4)
,(@time_zone_id, 638308800, 5)
,(@time_zone_id, 654638400, 4)
,(@time_zone_id, 670363200, 6)
,(@time_zone_id, 683582400, 1)
,(@time_zone_id, 703018800, 6)
,(@time_zone_id, 717530400, 1)
,(@time_zone_id, 734468400, 6)
,(@time_zone_id, 748980000, 1)
,(@time_zone_id, 765918000, 6)
,(@time_zone_id, 780429600, 1)
,(@time_zone_id, 797367600, 6)
,(@time_zone_id, 811879200, 1)
,(@time_zone_id, 828817200, 6)
,(@time_zone_id, 843933600, 1)
,(@time_zone_id, 859671000, 8)
,(@time_zone_id, 877811400, 1)
,(@time_zone_id, 891120600, 8)
,(@time_zone_id, 909261000, 1)
,(@time_zone_id, 922570200, 8)
,(@time_zone_id, 941315400, 1)
,(@time_zone_id, 954019800, 8)
,(@time_zone_id, 972765000, 1)
,(@time_zone_id, 985469400, 8)
,(@time_zone_id, 1004214600, 1)
,(@time_zone_id, 1017523800, 8)
,(@time_zone_id, 1035664200, 1)
,(@time_zone_id, 1048973400, 8)
,(@time_zone_id, 1067113800, 1)
,(@time_zone_id, 1080423000, 8)
,(@time_zone_id, 1099168200, 1)
,(@time_zone_id, 1111872600, 8)
,(@time_zone_id, 1123783200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 17904, 0, 'LMT')
,(@time_zone_id, 1, 18000, 0, '+05')
,(@time_zone_id, 2, 25200, 1, '+07')
,(@time_zone_id, 3, 21600, 0, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 25200, 1, '+07')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 0, '+05')
,(@time_zone_id, 8, 21600, 1, '+06')
,(@time_zone_id, 9, 21600, 0, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Brunei', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1383464380, 1)
,(@time_zone_id, -1167636600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 27580, 0, 'LMT')
,(@time_zone_id, 1, 27000, 0, '+0730')
,(@time_zone_id, 2, 28800, 0, '+08')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Calcutta', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2019705670, 2)
,(@time_zone_id, -891581400, 3)
,(@time_zone_id, -872058600, 2)
,(@time_zone_id, -862637400, 3)
,(@time_zone_id, -764145000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 21200, 0, 'HMT')
,(@time_zone_id, 1, 19270, 0, 'MMT')
,(@time_zone_id, 2, 19800, 0, 'IST')
,(@time_zone_id, 3, 23400, 1, '+0630')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Chita', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1579419232, 1)
,(@time_zone_id, -1247558400, 3)
,(@time_zone_id, 354898800, 2)
,(@time_zone_id, 370706400, 3)
,(@time_zone_id, 386434800, 2)
,(@time_zone_id, 402242400, 3)
,(@time_zone_id, 417970800, 2)
,(@time_zone_id, 433778400, 3)
,(@time_zone_id, 449593200, 2)
,(@time_zone_id, 465325200, 4)
,(@time_zone_id, 481050000, 5)
,(@time_zone_id, 496774800, 4)
,(@time_zone_id, 512499600, 5)
,(@time_zone_id, 528224400, 4)
,(@time_zone_id, 543949200, 5)
,(@time_zone_id, 559674000, 4)
,(@time_zone_id, 575398800, 5)
,(@time_zone_id, 591123600, 4)
,(@time_zone_id, 606848400, 5)
,(@time_zone_id, 622573200, 4)
,(@time_zone_id, 638298000, 5)
,(@time_zone_id, 654627600, 4)
,(@time_zone_id, 670352400, 6)
,(@time_zone_id, 686080800, 7)
,(@time_zone_id, 695757600, 4)
,(@time_zone_id, 701802000, 5)
,(@time_zone_id, 717526800, 4)
,(@time_zone_id, 733251600, 5)
,(@time_zone_id, 748976400, 4)
,(@time_zone_id, 764701200, 5)
,(@time_zone_id, 780426000, 4)
,(@time_zone_id, 796150800, 5)
,(@time_zone_id, 811875600, 4)
,(@time_zone_id, 828205200, 5)
,(@time_zone_id, 846349200, 4)
,(@time_zone_id, 859654800, 5)
,(@time_zone_id, 877798800, 4)
,(@time_zone_id, 891104400, 5)
,(@time_zone_id, 909248400, 4)
,(@time_zone_id, 922554000, 5)
,(@time_zone_id, 941302800, 4)
,(@time_zone_id, 954003600, 5)
,(@time_zone_id, 972752400, 4)
,(@time_zone_id, 985453200, 5)
,(@time_zone_id, 1004202000, 4)
,(@time_zone_id, 1017507600, 5)
,(@time_zone_id, 1035651600, 4)
,(@time_zone_id, 1048957200, 5)
,(@time_zone_id, 1067101200, 4)
,(@time_zone_id, 1080406800, 5)
,(@time_zone_id, 1099155600, 4)
,(@time_zone_id, 1111856400, 5)
,(@time_zone_id, 1130605200, 4)
,(@time_zone_id, 1143306000, 5)
,(@time_zone_id, 1162054800, 4)
,(@time_zone_id, 1174755600, 5)
,(@time_zone_id, 1193504400, 4)
,(@time_zone_id, 1206810000, 5)
,(@time_zone_id, 1224954000, 4)
,(@time_zone_id, 1238259600, 5)
,(@time_zone_id, 1256403600, 4)
,(@time_zone_id, 1269709200, 5)
,(@time_zone_id, 1288458000, 4)
,(@time_zone_id, 1301158800, 8)
,(@time_zone_id, 1414252800, 7)
,(@time_zone_id, 1459015200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 27232, 0, 'LMT')
,(@time_zone_id, 1, 28800, 0, '+08')
,(@time_zone_id, 2, 36000, 1, '+10')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 32400, 0, '+09')
,(@time_zone_id, 5, 36000, 1, '+10')
,(@time_zone_id, 6, 32400, 1, '+09')
,(@time_zone_id, 7, 28800, 0, '+08')
,(@time_zone_id, 8, 36000, 0, '+10')
,(@time_zone_id, 9, 36000, 1, '+10')
,(@time_zone_id, 10, 32400, 0, '+09')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Choibalsan', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2032933080, 1)
,(@time_zone_id, 252435600, 2)
,(@time_zone_id, 417974400, 4)
,(@time_zone_id, 433778400, 3)
,(@time_zone_id, 449593200, 4)
,(@time_zone_id, 465314400, 3)
,(@time_zone_id, 481042800, 4)
,(@time_zone_id, 496764000, 3)
,(@time_zone_id, 512492400, 4)
,(@time_zone_id, 528213600, 3)
,(@time_zone_id, 543942000, 4)
,(@time_zone_id, 559663200, 3)
,(@time_zone_id, 575391600, 4)
,(@time_zone_id, 591112800, 3)
,(@time_zone_id, 606841200, 4)
,(@time_zone_id, 622562400, 3)
,(@time_zone_id, 638290800, 4)
,(@time_zone_id, 654616800, 3)
,(@time_zone_id, 670345200, 4)
,(@time_zone_id, 686066400, 3)
,(@time_zone_id, 701794800, 4)
,(@time_zone_id, 717516000, 3)
,(@time_zone_id, 733244400, 4)
,(@time_zone_id, 748965600, 3)
,(@time_zone_id, 764694000, 4)
,(@time_zone_id, 780415200, 3)
,(@time_zone_id, 796143600, 4)
,(@time_zone_id, 811864800, 3)
,(@time_zone_id, 828198000, 4)
,(@time_zone_id, 843919200, 3)
,(@time_zone_id, 859647600, 4)
,(@time_zone_id, 875368800, 3)
,(@time_zone_id, 891097200, 4)
,(@time_zone_id, 906818400, 3)
,(@time_zone_id, 988390800, 4)
,(@time_zone_id, 1001692800, 3)
,(@time_zone_id, 1017421200, 4)
,(@time_zone_id, 1033142400, 3)
,(@time_zone_id, 1048870800, 4)
,(@time_zone_id, 1064592000, 3)
,(@time_zone_id, 1080320400, 4)
,(@time_zone_id, 1096041600, 3)
,(@time_zone_id, 1111770000, 4)
,(@time_zone_id, 1127491200, 3)
,(@time_zone_id, 1143219600, 4)
,(@time_zone_id, 1159545600, 3)
,(@time_zone_id, 1206889200, 2)
,(@time_zone_id, 1427479200, 5)
,(@time_zone_id, 1443193200, 2)
,(@time_zone_id, 1458928800, 5)
,(@time_zone_id, 1474642800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 27480, 0, 'LMT')
,(@time_zone_id, 1, 25200, 0, '+07')
,(@time_zone_id, 2, 28800, 0, '+08')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 36000, 1, '+10')
,(@time_zone_id, 5, 32400, 1, '+09')
,(@time_zone_id, 6, 28800, 0, '+08')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Chongqing', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -933667200, 1)
,(@time_zone_id, -922093200, 2)
,(@time_zone_id, -908870400, 1)
,(@time_zone_id, -888829200, 2)
,(@time_zone_id, -881049600, 1)
,(@time_zone_id, -767869200, 2)
,(@time_zone_id, -745833600, 1)
,(@time_zone_id, -733827600, 2)
,(@time_zone_id, -716889600, 1)
,(@time_zone_id, -699613200, 2)
,(@time_zone_id, -683884800, 1)
,(@time_zone_id, -670669200, 2)
,(@time_zone_id, -652348800, 1)
,(@time_zone_id, -650019600, 2)
,(@time_zone_id, 515527200, 1)
,(@time_zone_id, 527014800, 2)
,(@time_zone_id, 545162400, 1)
,(@time_zone_id, 558464400, 2)
,(@time_zone_id, 577216800, 1)
,(@time_zone_id, 589914000, 2)
,(@time_zone_id, 608666400, 1)
,(@time_zone_id, 621968400, 2)
,(@time_zone_id, 640116000, 1)
,(@time_zone_id, 653418000, 2)
,(@time_zone_id, 671565600, 1)
,(@time_zone_id, 684867600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 29143, 0, 'LMT')
,(@time_zone_id, 1, 32400, 1, 'CDT')
,(@time_zone_id, 2, 28800, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Chungking', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -933667200, 1)
,(@time_zone_id, -922093200, 2)
,(@time_zone_id, -908870400, 1)
,(@time_zone_id, -888829200, 2)
,(@time_zone_id, -881049600, 1)
,(@time_zone_id, -767869200, 2)
,(@time_zone_id, -745833600, 1)
,(@time_zone_id, -733827600, 2)
,(@time_zone_id, -716889600, 1)
,(@time_zone_id, -699613200, 2)
,(@time_zone_id, -683884800, 1)
,(@time_zone_id, -670669200, 2)
,(@time_zone_id, -652348800, 1)
,(@time_zone_id, -650019600, 2)
,(@time_zone_id, 515527200, 1)
,(@time_zone_id, 527014800, 2)
,(@time_zone_id, 545162400, 1)
,(@time_zone_id, 558464400, 2)
,(@time_zone_id, 577216800, 1)
,(@time_zone_id, 589914000, 2)
,(@time_zone_id, 608666400, 1)
,(@time_zone_id, 621968400, 2)
,(@time_zone_id, 640116000, 1)
,(@time_zone_id, 653418000, 2)
,(@time_zone_id, 671565600, 1)
,(@time_zone_id, 684867600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 29143, 0, 'LMT')
,(@time_zone_id, 1, 32400, 1, 'CDT')
,(@time_zone_id, 2, 28800, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Colombo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2019705572, 2)
,(@time_zone_id, -883287000, 3)
,(@time_zone_id, -862639200, 4)
,(@time_zone_id, -764051400, 2)
,(@time_zone_id, 832962600, 5)
,(@time_zone_id, 846266400, 6)
,(@time_zone_id, 1145039400, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 19164, 0, 'LMT')
,(@time_zone_id, 1, 19172, 0, 'MMT')
,(@time_zone_id, 2, 19800, 0, '+0530')
,(@time_zone_id, 3, 21600, 1, '+06')
,(@time_zone_id, 4, 23400, 1, '+0630')
,(@time_zone_id, 5, 23400, 0, '+0630')
,(@time_zone_id, 6, 21600, 0, '+06')
,(@time_zone_id, 7, 19800, 0, '+0530')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Dacca', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -891582800, 2)
,(@time_zone_id, -872058600, 3)
,(@time_zone_id, -862637400, 2)
,(@time_zone_id, -576138600, 4)
,(@time_zone_id, 1245430800, 5)
,(@time_zone_id, 1262278800, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 21700, 0, 'LMT')
,(@time_zone_id, 1, 21200, 0, 'HMT')
,(@time_zone_id, 2, 23400, 0, '+0630')
,(@time_zone_id, 3, 19800, 0, '+0530')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 25200, 1, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Damascus', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577931912, 2)
,(@time_zone_id, -1568592000, 1)
,(@time_zone_id, -1554080400, 2)
,(@time_zone_id, -1537142400, 1)
,(@time_zone_id, -1522630800, 2)
,(@time_zone_id, -1505692800, 1)
,(@time_zone_id, -1491181200, 2)
,(@time_zone_id, -1474243200, 1)
,(@time_zone_id, -1459126800, 2)
,(@time_zone_id, -242265600, 1)
,(@time_zone_id, -228877200, 2)
,(@time_zone_id, -210556800, 1)
,(@time_zone_id, -197427600, 2)
,(@time_zone_id, -178934400, 1)
,(@time_zone_id, -165718800, 2)
,(@time_zone_id, -147398400, 1)
,(@time_zone_id, -134269200, 2)
,(@time_zone_id, -116467200, 1)
,(@time_zone_id, -102646800, 2)
,(@time_zone_id, -84326400, 1)
,(@time_zone_id, -71110800, 2)
,(@time_zone_id, -52704000, 1)
,(@time_zone_id, -39488400, 2)
,(@time_zone_id, -21168000, 1)
,(@time_zone_id, -7952400, 2)
,(@time_zone_id, 10368000, 1)
,(@time_zone_id, 23583600, 2)
,(@time_zone_id, 41904000, 1)
,(@time_zone_id, 55119600, 2)
,(@time_zone_id, 73526400, 1)
,(@time_zone_id, 86742000, 2)
,(@time_zone_id, 105062400, 1)
,(@time_zone_id, 118278000, 2)
,(@time_zone_id, 136598400, 1)
,(@time_zone_id, 149814000, 2)
,(@time_zone_id, 168134400, 1)
,(@time_zone_id, 181350000, 2)
,(@time_zone_id, 199756800, 1)
,(@time_zone_id, 212972400, 2)
,(@time_zone_id, 231292800, 1)
,(@time_zone_id, 241916400, 2)
,(@time_zone_id, 262828800, 1)
,(@time_zone_id, 273452400, 2)
,(@time_zone_id, 418694400, 1)
,(@time_zone_id, 433810800, 2)
,(@time_zone_id, 450316800, 1)
,(@time_zone_id, 465433200, 2)
,(@time_zone_id, 508896000, 1)
,(@time_zone_id, 529196400, 2)
,(@time_zone_id, 541555200, 1)
,(@time_zone_id, 562633200, 2)
,(@time_zone_id, 574387200, 1)
,(@time_zone_id, 594255600, 2)
,(@time_zone_id, 607305600, 1)
,(@time_zone_id, 623199600, 2)
,(@time_zone_id, 638928000, 1)
,(@time_zone_id, 654649200, 2)
,(@time_zone_id, 670456800, 1)
,(@time_zone_id, 686264400, 2)
,(@time_zone_id, 702684000, 1)
,(@time_zone_id, 717886800, 2)
,(@time_zone_id, 733096800, 1)
,(@time_zone_id, 748904400, 2)
,(@time_zone_id, 765151200, 1)
,(@time_zone_id, 780958800, 2)
,(@time_zone_id, 796687200, 1)
,(@time_zone_id, 812494800, 2)
,(@time_zone_id, 828309600, 1)
,(@time_zone_id, 844117200, 2)
,(@time_zone_id, 859759200, 1)
,(@time_zone_id, 875653200, 2)
,(@time_zone_id, 891208800, 1)
,(@time_zone_id, 907189200, 2)
,(@time_zone_id, 922917600, 1)
,(@time_zone_id, 938725200, 2)
,(@time_zone_id, 954540000, 1)
,(@time_zone_id, 970347600, 2)
,(@time_zone_id, 986076000, 1)
,(@time_zone_id, 1001883600, 2)
,(@time_zone_id, 1017612000, 1)
,(@time_zone_id, 1033419600, 2)
,(@time_zone_id, 1049148000, 1)
,(@time_zone_id, 1064955600, 2)
,(@time_zone_id, 1080770400, 1)
,(@time_zone_id, 1096578000, 2)
,(@time_zone_id, 1112306400, 1)
,(@time_zone_id, 1128114000, 2)
,(@time_zone_id, 1143842400, 1)
,(@time_zone_id, 1158872400, 2)
,(@time_zone_id, 1175205600, 1)
,(@time_zone_id, 1193950800, 2)
,(@time_zone_id, 1207260000, 1)
,(@time_zone_id, 1225486800, 2)
,(@time_zone_id, 1238104800, 1)
,(@time_zone_id, 1256850000, 2)
,(@time_zone_id, 1270159200, 1)
,(@time_zone_id, 1288299600, 2)
,(@time_zone_id, 1301608800, 1)
,(@time_zone_id, 1319749200, 2)
,(@time_zone_id, 1333058400, 1)
,(@time_zone_id, 1351198800, 2)
,(@time_zone_id, 1364508000, 1)
,(@time_zone_id, 1382648400, 2)
,(@time_zone_id, 1395957600, 1)
,(@time_zone_id, 1414702800, 2)
,(@time_zone_id, 1427407200, 1)
,(@time_zone_id, 1446152400, 2)
,(@time_zone_id, 1458856800, 1)
,(@time_zone_id, 1477602000, 2)
,(@time_zone_id, 1490911200, 1)
,(@time_zone_id, 1509051600, 2)
,(@time_zone_id, 1522360800, 1)
,(@time_zone_id, 1540501200, 2)
,(@time_zone_id, 1553810400, 1)
,(@time_zone_id, 1571950800, 2)
,(@time_zone_id, 1585260000, 1)
,(@time_zone_id, 1604005200, 2)
,(@time_zone_id, 1616709600, 1)
,(@time_zone_id, 1635454800, 2)
,(@time_zone_id, 1648159200, 1)
,(@time_zone_id, 1666904400, 2)
,(@time_zone_id, 1680213600, 1)
,(@time_zone_id, 1698354000, 2)
,(@time_zone_id, 1711663200, 1)
,(@time_zone_id, 1729803600, 2)
,(@time_zone_id, 1743112800, 1)
,(@time_zone_id, 1761858000, 2)
,(@time_zone_id, 1774562400, 1)
,(@time_zone_id, 1793307600, 2)
,(@time_zone_id, 1806012000, 1)
,(@time_zone_id, 1824757200, 2)
,(@time_zone_id, 1838066400, 1)
,(@time_zone_id, 1856206800, 2)
,(@time_zone_id, 1869516000, 1)
,(@time_zone_id, 1887656400, 2)
,(@time_zone_id, 1900965600, 1)
,(@time_zone_id, 1919106000, 2)
,(@time_zone_id, 1932415200, 1)
,(@time_zone_id, 1951160400, 2)
,(@time_zone_id, 1963864800, 1)
,(@time_zone_id, 1982610000, 2)
,(@time_zone_id, 1995314400, 1)
,(@time_zone_id, 2014059600, 2)
,(@time_zone_id, 2027368800, 1)
,(@time_zone_id, 2045509200, 2)
,(@time_zone_id, 2058818400, 1)
,(@time_zone_id, 2076958800, 2)
,(@time_zone_id, 2090268000, 1)
,(@time_zone_id, 2109013200, 2)
,(@time_zone_id, 2121717600, 1)
,(@time_zone_id, 2140462800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8712, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'EEST')
,(@time_zone_id, 2, 7200, 0, 'EET')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Dhaka', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -891582800, 2)
,(@time_zone_id, -872058600, 3)
,(@time_zone_id, -862637400, 2)
,(@time_zone_id, -576138600, 4)
,(@time_zone_id, 1245430800, 5)
,(@time_zone_id, 1262278800, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 21700, 0, 'LMT')
,(@time_zone_id, 1, 21200, 0, 'HMT')
,(@time_zone_id, 2, 23400, 0, '+0630')
,(@time_zone_id, 3, 19800, 0, '+0530')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 25200, 1, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Dili', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1830414140, 1)
,(@time_zone_id, -879152400, 2)
,(@time_zone_id, 199897200, 1)
,(@time_zone_id, 969120000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 30140, 0, 'LMT')
,(@time_zone_id, 1, 28800, 0, '+08')
,(@time_zone_id, 2, 32400, 0, '+09')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Dubai', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577936472, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 13272, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Dushanbe', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441168512, 1)
,(@time_zone_id, -1247547600, 3)
,(@time_zone_id, 354909600, 2)
,(@time_zone_id, 370717200, 3)
,(@time_zone_id, 386445600, 2)
,(@time_zone_id, 402253200, 3)
,(@time_zone_id, 417981600, 2)
,(@time_zone_id, 433789200, 3)
,(@time_zone_id, 449604000, 2)
,(@time_zone_id, 465336000, 4)
,(@time_zone_id, 481060800, 5)
,(@time_zone_id, 496785600, 4)
,(@time_zone_id, 512510400, 5)
,(@time_zone_id, 528235200, 4)
,(@time_zone_id, 543960000, 5)
,(@time_zone_id, 559684800, 4)
,(@time_zone_id, 575409600, 5)
,(@time_zone_id, 591134400, 4)
,(@time_zone_id, 606859200, 5)
,(@time_zone_id, 622584000, 4)
,(@time_zone_id, 638308800, 5)
,(@time_zone_id, 654638400, 4)
,(@time_zone_id, 670363200, 6)
,(@time_zone_id, 684363600, 7)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 16512, 0, 'LMT')
,(@time_zone_id, 1, 18000, 0, '+05')
,(@time_zone_id, 2, 25200, 1, '+07')
,(@time_zone_id, 3, 21600, 0, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 25200, 1, '+07')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Famagusta', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1518920148, 2)
,(@time_zone_id, 166572000, 1)
,(@time_zone_id, 182293200, 2)
,(@time_zone_id, 200959200, 1)
,(@time_zone_id, 213829200, 2)
,(@time_zone_id, 228866400, 1)
,(@time_zone_id, 243982800, 2)
,(@time_zone_id, 260316000, 1)
,(@time_zone_id, 276123600, 2)
,(@time_zone_id, 291765600, 1)
,(@time_zone_id, 307486800, 2)
,(@time_zone_id, 323820000, 1)
,(@time_zone_id, 338936400, 2)
,(@time_zone_id, 354664800, 1)
,(@time_zone_id, 370386000, 2)
,(@time_zone_id, 386114400, 1)
,(@time_zone_id, 401835600, 2)
,(@time_zone_id, 417564000, 1)
,(@time_zone_id, 433285200, 2)
,(@time_zone_id, 449013600, 1)
,(@time_zone_id, 465339600, 2)
,(@time_zone_id, 481068000, 1)
,(@time_zone_id, 496789200, 2)
,(@time_zone_id, 512517600, 1)
,(@time_zone_id, 528238800, 2)
,(@time_zone_id, 543967200, 1)
,(@time_zone_id, 559688400, 2)
,(@time_zone_id, 575416800, 1)
,(@time_zone_id, 591138000, 2)
,(@time_zone_id, 606866400, 1)
,(@time_zone_id, 622587600, 2)
,(@time_zone_id, 638316000, 1)
,(@time_zone_id, 654642000, 2)
,(@time_zone_id, 670370400, 1)
,(@time_zone_id, 686091600, 2)
,(@time_zone_id, 701820000, 1)
,(@time_zone_id, 717541200, 2)
,(@time_zone_id, 733269600, 1)
,(@time_zone_id, 748990800, 2)
,(@time_zone_id, 764719200, 1)
,(@time_zone_id, 780440400, 2)
,(@time_zone_id, 796168800, 1)
,(@time_zone_id, 811890000, 2)
,(@time_zone_id, 828223200, 1)
,(@time_zone_id, 843944400, 2)
,(@time_zone_id, 859672800, 1)
,(@time_zone_id, 875394000, 2)
,(@time_zone_id, 891122400, 1)
,(@time_zone_id, 909277200, 3)
,(@time_zone_id, 922582800, 4)
,(@time_zone_id, 941331600, 3)
,(@time_zone_id, 954032400, 4)
,(@time_zone_id, 972781200, 3)
,(@time_zone_id, 985482000, 4)
,(@time_zone_id, 1004230800, 3)
,(@time_zone_id, 1017536400, 4)
,(@time_zone_id, 1035680400, 3)
,(@time_zone_id, 1048986000, 4)
,(@time_zone_id, 1067130000, 3)
,(@time_zone_id, 1080435600, 4)
,(@time_zone_id, 1099184400, 3)
,(@time_zone_id, 1111885200, 4)
,(@time_zone_id, 1130634000, 3)
,(@time_zone_id, 1143334800, 4)
,(@time_zone_id, 1162083600, 3)
,(@time_zone_id, 1174784400, 4)
,(@time_zone_id, 1193533200, 3)
,(@time_zone_id, 1206838800, 4)
,(@time_zone_id, 1224982800, 3)
,(@time_zone_id, 1238288400, 4)
,(@time_zone_id, 1256432400, 3)
,(@time_zone_id, 1269738000, 4)
,(@time_zone_id, 1288486800, 3)
,(@time_zone_id, 1301187600, 4)
,(@time_zone_id, 1319936400, 3)
,(@time_zone_id, 1332637200, 4)
,(@time_zone_id, 1351386000, 3)
,(@time_zone_id, 1364691600, 4)
,(@time_zone_id, 1382835600, 3)
,(@time_zone_id, 1396141200, 4)
,(@time_zone_id, 1414285200, 3)
,(@time_zone_id, 1427590800, 4)
,(@time_zone_id, 1445734800, 3)
,(@time_zone_id, 1459040400, 4)
,(@time_zone_id, 1473282000, 5)
,(@time_zone_id, 1509238800, 3)
,(@time_zone_id, 1521939600, 4)
,(@time_zone_id, 1540688400, 3)
,(@time_zone_id, 1553994000, 4)
,(@time_zone_id, 1572138000, 3)
,(@time_zone_id, 1585443600, 4)
,(@time_zone_id, 1603587600, 3)
,(@time_zone_id, 1616893200, 4)
,(@time_zone_id, 1635642000, 3)
,(@time_zone_id, 1648342800, 4)
,(@time_zone_id, 1667091600, 3)
,(@time_zone_id, 1679792400, 4)
,(@time_zone_id, 1698541200, 3)
,(@time_zone_id, 1711846800, 4)
,(@time_zone_id, 1729990800, 3)
,(@time_zone_id, 1743296400, 4)
,(@time_zone_id, 1761440400, 3)
,(@time_zone_id, 1774746000, 4)
,(@time_zone_id, 1792890000, 3)
,(@time_zone_id, 1806195600, 4)
,(@time_zone_id, 1824944400, 3)
,(@time_zone_id, 1837645200, 4)
,(@time_zone_id, 1856394000, 3)
,(@time_zone_id, 1869094800, 4)
,(@time_zone_id, 1887843600, 3)
,(@time_zone_id, 1901149200, 4)
,(@time_zone_id, 1919293200, 3)
,(@time_zone_id, 1932598800, 4)
,(@time_zone_id, 1950742800, 3)
,(@time_zone_id, 1964048400, 4)
,(@time_zone_id, 1982797200, 3)
,(@time_zone_id, 1995498000, 4)
,(@time_zone_id, 2014246800, 3)
,(@time_zone_id, 2026947600, 4)
,(@time_zone_id, 2045696400, 3)
,(@time_zone_id, 2058397200, 4)
,(@time_zone_id, 2077146000, 3)
,(@time_zone_id, 2090451600, 4)
,(@time_zone_id, 2108595600, 3)
,(@time_zone_id, 2121901200, 4)
,(@time_zone_id, 2140045200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8148, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'EEST')
,(@time_zone_id, 2, 7200, 0, 'EET')
,(@time_zone_id, 3, 7200, 0, 'EET')
,(@time_zone_id, 4, 10800, 1, 'EEST')
,(@time_zone_id, 5, 10800, 0, '+03')
,(@time_zone_id, 6, 7200, 0, 'EET')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Gaza', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -933645600, 1)
,(@time_zone_id, -857358000, 2)
,(@time_zone_id, -844300800, 1)
,(@time_zone_id, -825822000, 2)
,(@time_zone_id, -812685600, 1)
,(@time_zone_id, -794199600, 2)
,(@time_zone_id, -779853600, 1)
,(@time_zone_id, -762656400, 2)
,(@time_zone_id, -748310400, 1)
,(@time_zone_id, -731127600, 2)
,(@time_zone_id, -399088800, 1)
,(@time_zone_id, -386650800, 2)
,(@time_zone_id, -368330400, 1)
,(@time_zone_id, -355114800, 2)
,(@time_zone_id, -336790800, 1)
,(@time_zone_id, -323654400, 2)
,(@time_zone_id, -305168400, 1)
,(@time_zone_id, -292032000, 2)
,(@time_zone_id, -273632400, 1)
,(@time_zone_id, -260496000, 2)
,(@time_zone_id, -242096400, 1)
,(@time_zone_id, -228960000, 2)
,(@time_zone_id, -210560400, 1)
,(@time_zone_id, -197424000, 2)
,(@time_zone_id, -178938000, 1)
,(@time_zone_id, -165801600, 2)
,(@time_zone_id, -147402000, 1)
,(@time_zone_id, -134265600, 2)
,(@time_zone_id, -115866000, 1)
,(@time_zone_id, -102643200, 2)
,(@time_zone_id, -84330000, 1)
,(@time_zone_id, -81313200, 4)
,(@time_zone_id, 142380000, 3)
,(@time_zone_id, 150843600, 4)
,(@time_zone_id, 167176800, 3)
,(@time_zone_id, 178664400, 4)
,(@time_zone_id, 482277600, 3)
,(@time_zone_id, 495579600, 4)
,(@time_zone_id, 516751200, 3)
,(@time_zone_id, 526424400, 4)
,(@time_zone_id, 545436000, 3)
,(@time_zone_id, 558478800, 4)
,(@time_zone_id, 576626400, 3)
,(@time_zone_id, 589323600, 4)
,(@time_zone_id, 609890400, 3)
,(@time_zone_id, 620773200, 4)
,(@time_zone_id, 638316000, 3)
,(@time_zone_id, 651618000, 4)
,(@time_zone_id, 669765600, 3)
,(@time_zone_id, 683672400, 4)
,(@time_zone_id, 701820000, 3)
,(@time_zone_id, 715726800, 4)
,(@time_zone_id, 733701600, 3)
,(@time_zone_id, 747176400, 4)
,(@time_zone_id, 765151200, 3)
,(@time_zone_id, 778021200, 4)
,(@time_zone_id, 796600800, 3)
,(@time_zone_id, 810075600, 4)
,(@time_zone_id, 820447200, 2)
,(@time_zone_id, 828655200, 1)
,(@time_zone_id, 843170400, 5)
,(@time_zone_id, 860104800, 1)
,(@time_zone_id, 874620000, 5)
,(@time_zone_id, 891554400, 1)
,(@time_zone_id, 906069600, 5)
,(@time_zone_id, 915141600, 2)
,(@time_zone_id, 924213600, 1)
,(@time_zone_id, 939934800, 2)
,(@time_zone_id, 956268000, 1)
,(@time_zone_id, 971989200, 2)
,(@time_zone_id, 987717600, 1)
,(@time_zone_id, 1003438800, 2)
,(@time_zone_id, 1019167200, 1)
,(@time_zone_id, 1034888400, 2)
,(@time_zone_id, 1050616800, 1)
,(@time_zone_id, 1066338000, 2)
,(@time_zone_id, 1082066400, 1)
,(@time_zone_id, 1096581600, 2)
,(@time_zone_id, 1113516000, 1)
,(@time_zone_id, 1128380400, 2)
,(@time_zone_id, 1143842400, 1)
,(@time_zone_id, 1158872400, 2)
,(@time_zone_id, 1175378400, 1)
,(@time_zone_id, 1189638000, 2)
,(@time_zone_id, 1206655200, 1)
,(@time_zone_id, 1219957200, 2)
,(@time_zone_id, 1238104800, 1)
,(@time_zone_id, 1252015200, 2)
,(@time_zone_id, 1269640860, 1)
,(@time_zone_id, 1281474000, 2)
,(@time_zone_id, 1301608860, 1)
,(@time_zone_id, 1312146000, 2)
,(@time_zone_id, 1333058400, 1)
,(@time_zone_id, 1348178400, 2)
,(@time_zone_id, 1364508000, 1)
,(@time_zone_id, 1380229200, 2)
,(@time_zone_id, 1395957600, 1)
,(@time_zone_id, 1414098000, 2)
,(@time_zone_id, 1427493600, 1)
,(@time_zone_id, 1445547600, 2)
,(@time_zone_id, 1458946800, 1)
,(@time_zone_id, 1477692000, 2)
,(@time_zone_id, 1490396400, 1)
,(@time_zone_id, 1509141600, 2)
,(@time_zone_id, 1521846000, 1)
,(@time_zone_id, 1540591200, 2)
,(@time_zone_id, 1553295600, 1)
,(@time_zone_id, 1572040800, 2)
,(@time_zone_id, 1585350000, 1)
,(@time_zone_id, 1604095200, 2)
,(@time_zone_id, 1616799600, 1)
,(@time_zone_id, 1635544800, 2)
,(@time_zone_id, 1648249200, 1)
,(@time_zone_id, 1666994400, 2)
,(@time_zone_id, 1679698800, 1)
,(@time_zone_id, 1698444000, 2)
,(@time_zone_id, 1711148400, 1)
,(@time_zone_id, 1729893600, 2)
,(@time_zone_id, 1742598000, 1)
,(@time_zone_id, 1761343200, 2)
,(@time_zone_id, 1774652400, 1)
,(@time_zone_id, 1793397600, 2)
,(@time_zone_id, 1806102000, 1)
,(@time_zone_id, 1824847200, 2)
,(@time_zone_id, 1837551600, 1)
,(@time_zone_id, 1856296800, 2)
,(@time_zone_id, 1869001200, 1)
,(@time_zone_id, 1887746400, 2)
,(@time_zone_id, 1900450800, 1)
,(@time_zone_id, 1919196000, 2)
,(@time_zone_id, 1931900400, 1)
,(@time_zone_id, 1950645600, 2)
,(@time_zone_id, 1963954800, 1)
,(@time_zone_id, 1982700000, 2)
,(@time_zone_id, 1995404400, 1)
,(@time_zone_id, 2014149600, 2)
,(@time_zone_id, 2026854000, 1)
,(@time_zone_id, 2045599200, 2)
,(@time_zone_id, 2058303600, 1)
,(@time_zone_id, 2077048800, 2)
,(@time_zone_id, 2089753200, 1)
,(@time_zone_id, 2108498400, 2)
,(@time_zone_id, 2121807600, 1)
,(@time_zone_id, 2140552800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8272, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'EEST')
,(@time_zone_id, 2, 7200, 0, 'EET')
,(@time_zone_id, 3, 10800, 1, 'IDT')
,(@time_zone_id, 4, 7200, 0, 'IST')
,(@time_zone_id, 5, 7200, 0, 'EET')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Harbin', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -933667200, 1)
,(@time_zone_id, -922093200, 2)
,(@time_zone_id, -908870400, 1)
,(@time_zone_id, -888829200, 2)
,(@time_zone_id, -881049600, 1)
,(@time_zone_id, -767869200, 2)
,(@time_zone_id, -745833600, 1)
,(@time_zone_id, -733827600, 2)
,(@time_zone_id, -716889600, 1)
,(@time_zone_id, -699613200, 2)
,(@time_zone_id, -683884800, 1)
,(@time_zone_id, -670669200, 2)
,(@time_zone_id, -652348800, 1)
,(@time_zone_id, -650019600, 2)
,(@time_zone_id, 515527200, 1)
,(@time_zone_id, 527014800, 2)
,(@time_zone_id, 545162400, 1)
,(@time_zone_id, 558464400, 2)
,(@time_zone_id, 577216800, 1)
,(@time_zone_id, 589914000, 2)
,(@time_zone_id, 608666400, 1)
,(@time_zone_id, 621968400, 2)
,(@time_zone_id, 640116000, 1)
,(@time_zone_id, 653418000, 2)
,(@time_zone_id, 671565600, 1)
,(@time_zone_id, 684867600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 29143, 0, 'LMT')
,(@time_zone_id, 1, 32400, 1, 'CDT')
,(@time_zone_id, 2, 28800, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Hebron', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -933645600, 1)
,(@time_zone_id, -857358000, 2)
,(@time_zone_id, -844300800, 1)
,(@time_zone_id, -825822000, 2)
,(@time_zone_id, -812685600, 1)
,(@time_zone_id, -794199600, 2)
,(@time_zone_id, -779853600, 1)
,(@time_zone_id, -762656400, 2)
,(@time_zone_id, -748310400, 1)
,(@time_zone_id, -731127600, 2)
,(@time_zone_id, -399088800, 1)
,(@time_zone_id, -386650800, 2)
,(@time_zone_id, -368330400, 1)
,(@time_zone_id, -355114800, 2)
,(@time_zone_id, -336790800, 1)
,(@time_zone_id, -323654400, 2)
,(@time_zone_id, -305168400, 1)
,(@time_zone_id, -292032000, 2)
,(@time_zone_id, -273632400, 1)
,(@time_zone_id, -260496000, 2)
,(@time_zone_id, -242096400, 1)
,(@time_zone_id, -228960000, 2)
,(@time_zone_id, -210560400, 1)
,(@time_zone_id, -197424000, 2)
,(@time_zone_id, -178938000, 1)
,(@time_zone_id, -165801600, 2)
,(@time_zone_id, -147402000, 1)
,(@time_zone_id, -134265600, 2)
,(@time_zone_id, -115866000, 1)
,(@time_zone_id, -102643200, 2)
,(@time_zone_id, -84330000, 1)
,(@time_zone_id, -81313200, 4)
,(@time_zone_id, 142380000, 3)
,(@time_zone_id, 150843600, 4)
,(@time_zone_id, 167176800, 3)
,(@time_zone_id, 178664400, 4)
,(@time_zone_id, 482277600, 3)
,(@time_zone_id, 495579600, 4)
,(@time_zone_id, 516751200, 3)
,(@time_zone_id, 526424400, 4)
,(@time_zone_id, 545436000, 3)
,(@time_zone_id, 558478800, 4)
,(@time_zone_id, 576626400, 3)
,(@time_zone_id, 589323600, 4)
,(@time_zone_id, 609890400, 3)
,(@time_zone_id, 620773200, 4)
,(@time_zone_id, 638316000, 3)
,(@time_zone_id, 651618000, 4)
,(@time_zone_id, 669765600, 3)
,(@time_zone_id, 683672400, 4)
,(@time_zone_id, 701820000, 3)
,(@time_zone_id, 715726800, 4)
,(@time_zone_id, 733701600, 3)
,(@time_zone_id, 747176400, 4)
,(@time_zone_id, 765151200, 3)
,(@time_zone_id, 778021200, 4)
,(@time_zone_id, 796600800, 3)
,(@time_zone_id, 810075600, 4)
,(@time_zone_id, 820447200, 2)
,(@time_zone_id, 828655200, 1)
,(@time_zone_id, 843170400, 5)
,(@time_zone_id, 860104800, 1)
,(@time_zone_id, 874620000, 5)
,(@time_zone_id, 891554400, 1)
,(@time_zone_id, 906069600, 5)
,(@time_zone_id, 915141600, 2)
,(@time_zone_id, 924213600, 1)
,(@time_zone_id, 939934800, 2)
,(@time_zone_id, 956268000, 1)
,(@time_zone_id, 971989200, 2)
,(@time_zone_id, 987717600, 1)
,(@time_zone_id, 1003438800, 2)
,(@time_zone_id, 1019167200, 1)
,(@time_zone_id, 1034888400, 2)
,(@time_zone_id, 1050616800, 1)
,(@time_zone_id, 1066338000, 2)
,(@time_zone_id, 1082066400, 1)
,(@time_zone_id, 1096581600, 2)
,(@time_zone_id, 1113516000, 1)
,(@time_zone_id, 1128380400, 2)
,(@time_zone_id, 1143842400, 1)
,(@time_zone_id, 1158872400, 2)
,(@time_zone_id, 1175378400, 1)
,(@time_zone_id, 1189638000, 2)
,(@time_zone_id, 1206655200, 1)
,(@time_zone_id, 1220216400, 2)
,(@time_zone_id, 1238104800, 1)
,(@time_zone_id, 1252015200, 2)
,(@time_zone_id, 1269554400, 1)
,(@time_zone_id, 1281474000, 2)
,(@time_zone_id, 1301608860, 1)
,(@time_zone_id, 1312146000, 2)
,(@time_zone_id, 1314655200, 1)
,(@time_zone_id, 1317330000, 2)
,(@time_zone_id, 1333058400, 1)
,(@time_zone_id, 1348178400, 2)
,(@time_zone_id, 1364508000, 1)
,(@time_zone_id, 1380229200, 2)
,(@time_zone_id, 1395957600, 1)
,(@time_zone_id, 1414098000, 2)
,(@time_zone_id, 1427493600, 1)
,(@time_zone_id, 1445547600, 2)
,(@time_zone_id, 1458946800, 1)
,(@time_zone_id, 1477692000, 2)
,(@time_zone_id, 1490396400, 1)
,(@time_zone_id, 1509141600, 2)
,(@time_zone_id, 1521846000, 1)
,(@time_zone_id, 1540591200, 2)
,(@time_zone_id, 1553295600, 1)
,(@time_zone_id, 1572040800, 2)
,(@time_zone_id, 1585350000, 1)
,(@time_zone_id, 1604095200, 2)
,(@time_zone_id, 1616799600, 1)
,(@time_zone_id, 1635544800, 2)
,(@time_zone_id, 1648249200, 1)
,(@time_zone_id, 1666994400, 2)
,(@time_zone_id, 1679698800, 1)
,(@time_zone_id, 1698444000, 2)
,(@time_zone_id, 1711148400, 1)
,(@time_zone_id, 1729893600, 2)
,(@time_zone_id, 1742598000, 1)
,(@time_zone_id, 1761343200, 2)
,(@time_zone_id, 1774652400, 1)
,(@time_zone_id, 1793397600, 2)
,(@time_zone_id, 1806102000, 1)
,(@time_zone_id, 1824847200, 2)
,(@time_zone_id, 1837551600, 1)
,(@time_zone_id, 1856296800, 2)
,(@time_zone_id, 1869001200, 1)
,(@time_zone_id, 1887746400, 2)
,(@time_zone_id, 1900450800, 1)
,(@time_zone_id, 1919196000, 2)
,(@time_zone_id, 1931900400, 1)
,(@time_zone_id, 1950645600, 2)
,(@time_zone_id, 1963954800, 1)
,(@time_zone_id, 1982700000, 2)
,(@time_zone_id, 1995404400, 1)
,(@time_zone_id, 2014149600, 2)
,(@time_zone_id, 2026854000, 1)
,(@time_zone_id, 2045599200, 2)
,(@time_zone_id, 2058303600, 1)
,(@time_zone_id, 2077048800, 2)
,(@time_zone_id, 2089753200, 1)
,(@time_zone_id, 2108498400, 2)
,(@time_zone_id, 2121807600, 1)
,(@time_zone_id, 2140552800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8423, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'EEST')
,(@time_zone_id, 2, 7200, 0, 'EET')
,(@time_zone_id, 3, 10800, 1, 'IDT')
,(@time_zone_id, 4, 7200, 0, 'IST')
,(@time_zone_id, 5, 7200, 0, 'EET')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Ho_Chi_Minh', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2004073600, 1)
,(@time_zone_id, -1851577590, 2)
,(@time_zone_id, -852105600, 3)
,(@time_zone_id, -782643600, 4)
,(@time_zone_id, -767869200, 2)
,(@time_zone_id, -718095600, 3)
,(@time_zone_id, -457776000, 2)
,(@time_zone_id, -315648000, 3)
,(@time_zone_id, 171820800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 25600, 0, 'LMT')
,(@time_zone_id, 1, 25590, 0, 'PLMT')
,(@time_zone_id, 2, 25200, 0, '+07')
,(@time_zone_id, 3, 28800, 0, '+08')
,(@time_zone_id, 4, 32400, 0, '+09')
,(@time_zone_id, 5, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Hong_Kong', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2056690800, 1)
,(@time_zone_id, -900909000, 2)
,(@time_zone_id, -891579600, 3)
,(@time_zone_id, -884248200, 4)
,(@time_zone_id, -766659600, 1)
,(@time_zone_id, -747981000, 2)
,(@time_zone_id, -728544600, 1)
,(@time_zone_id, -717049800, 2)
,(@time_zone_id, -694503000, 1)
,(@time_zone_id, -683785800, 2)
,(@time_zone_id, -668064600, 1)
,(@time_zone_id, -654755400, 2)
,(@time_zone_id, -636615000, 1)
,(@time_zone_id, -623305800, 2)
,(@time_zone_id, -605165400, 1)
,(@time_zone_id, -591856200, 2)
,(@time_zone_id, -573715800, 1)
,(@time_zone_id, -559801800, 2)
,(@time_zone_id, -541661400, 1)
,(@time_zone_id, -528352200, 2)
,(@time_zone_id, -510211800, 1)
,(@time_zone_id, -498112200, 2)
,(@time_zone_id, -478762200, 1)
,(@time_zone_id, -466662600, 2)
,(@time_zone_id, -446707800, 1)
,(@time_zone_id, -435213000, 2)
,(@time_zone_id, -415258200, 1)
,(@time_zone_id, -403158600, 2)
,(@time_zone_id, -383808600, 1)
,(@time_zone_id, -371709000, 2)
,(@time_zone_id, -352359000, 1)
,(@time_zone_id, -340259400, 2)
,(@time_zone_id, -320909400, 1)
,(@time_zone_id, -308809800, 2)
,(@time_zone_id, -288855000, 1)
,(@time_zone_id, -277360200, 2)
,(@time_zone_id, -257405400, 1)
,(@time_zone_id, -245910600, 2)
,(@time_zone_id, -225955800, 1)
,(@time_zone_id, -213856200, 2)
,(@time_zone_id, -194506200, 1)
,(@time_zone_id, -182406600, 2)
,(@time_zone_id, -163056600, 1)
,(@time_zone_id, -148537800, 2)
,(@time_zone_id, -132816600, 1)
,(@time_zone_id, -117088200, 2)
,(@time_zone_id, -101367000, 1)
,(@time_zone_id, -85638600, 2)
,(@time_zone_id, -69312600, 1)
,(@time_zone_id, -53584200, 2)
,(@time_zone_id, -37863000, 1)
,(@time_zone_id, -22134600, 2)
,(@time_zone_id, -6413400, 1)
,(@time_zone_id, 9315000, 2)
,(@time_zone_id, 25036200, 1)
,(@time_zone_id, 40764600, 2)
,(@time_zone_id, 56485800, 1)
,(@time_zone_id, 72214200, 2)
,(@time_zone_id, 88540200, 1)
,(@time_zone_id, 104268600, 2)
,(@time_zone_id, 119989800, 1)
,(@time_zone_id, 126041400, 2)
,(@time_zone_id, 151439400, 1)
,(@time_zone_id, 167167800, 2)
,(@time_zone_id, 182889000, 1)
,(@time_zone_id, 198617400, 2)
,(@time_zone_id, 214338600, 1)
,(@time_zone_id, 295385400, 2)
,(@time_zone_id, 309292200, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 27402, 0, 'LMT')
,(@time_zone_id, 1, 28800, 0, 'HKT')
,(@time_zone_id, 2, 32400, 1, 'HKST')
,(@time_zone_id, 3, 30600, 0, 'HKT')
,(@time_zone_id, 4, 32400, 0, 'JST')
,(@time_zone_id, 5, 28800, 0, 'HKT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Hovd', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2032927596, 1)
,(@time_zone_id, 252439200, 3)
,(@time_zone_id, 417978000, 2)
,(@time_zone_id, 433785600, 3)
,(@time_zone_id, 449600400, 2)
,(@time_zone_id, 465321600, 3)
,(@time_zone_id, 481050000, 2)
,(@time_zone_id, 496771200, 3)
,(@time_zone_id, 512499600, 2)
,(@time_zone_id, 528220800, 3)
,(@time_zone_id, 543949200, 2)
,(@time_zone_id, 559670400, 3)
,(@time_zone_id, 575398800, 2)
,(@time_zone_id, 591120000, 3)
,(@time_zone_id, 606848400, 2)
,(@time_zone_id, 622569600, 3)
,(@time_zone_id, 638298000, 2)
,(@time_zone_id, 654624000, 3)
,(@time_zone_id, 670352400, 2)
,(@time_zone_id, 686073600, 3)
,(@time_zone_id, 701802000, 2)
,(@time_zone_id, 717523200, 3)
,(@time_zone_id, 733251600, 2)
,(@time_zone_id, 748972800, 3)
,(@time_zone_id, 764701200, 2)
,(@time_zone_id, 780422400, 3)
,(@time_zone_id, 796150800, 2)
,(@time_zone_id, 811872000, 3)
,(@time_zone_id, 828205200, 2)
,(@time_zone_id, 843926400, 3)
,(@time_zone_id, 859654800, 2)
,(@time_zone_id, 875376000, 3)
,(@time_zone_id, 891104400, 2)
,(@time_zone_id, 906825600, 3)
,(@time_zone_id, 988398000, 2)
,(@time_zone_id, 1001700000, 3)
,(@time_zone_id, 1017428400, 2)
,(@time_zone_id, 1033149600, 3)
,(@time_zone_id, 1048878000, 2)
,(@time_zone_id, 1064599200, 3)
,(@time_zone_id, 1080327600, 2)
,(@time_zone_id, 1096048800, 3)
,(@time_zone_id, 1111777200, 2)
,(@time_zone_id, 1127498400, 3)
,(@time_zone_id, 1143226800, 2)
,(@time_zone_id, 1159552800, 3)
,(@time_zone_id, 1427482800, 2)
,(@time_zone_id, 1443196800, 3)
,(@time_zone_id, 1458932400, 2)
,(@time_zone_id, 1474646400, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 21996, 0, 'LMT')
,(@time_zone_id, 1, 21600, 0, '+06')
,(@time_zone_id, 2, 28800, 1, '+08')
,(@time_zone_id, 3, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Irkutsk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1575874625, 2)
,(@time_zone_id, -1247554800, 4)
,(@time_zone_id, 354902400, 3)
,(@time_zone_id, 370710000, 4)
,(@time_zone_id, 386438400, 3)
,(@time_zone_id, 402246000, 4)
,(@time_zone_id, 417974400, 3)
,(@time_zone_id, 433782000, 4)
,(@time_zone_id, 449596800, 3)
,(@time_zone_id, 465328800, 5)
,(@time_zone_id, 481053600, 6)
,(@time_zone_id, 496778400, 5)
,(@time_zone_id, 512503200, 6)
,(@time_zone_id, 528228000, 5)
,(@time_zone_id, 543952800, 6)
,(@time_zone_id, 559677600, 5)
,(@time_zone_id, 575402400, 6)
,(@time_zone_id, 591127200, 5)
,(@time_zone_id, 606852000, 6)
,(@time_zone_id, 622576800, 5)
,(@time_zone_id, 638301600, 6)
,(@time_zone_id, 654631200, 5)
,(@time_zone_id, 670356000, 7)
,(@time_zone_id, 686084400, 8)
,(@time_zone_id, 695761200, 5)
,(@time_zone_id, 701805600, 6)
,(@time_zone_id, 717530400, 5)
,(@time_zone_id, 733255200, 6)
,(@time_zone_id, 748980000, 5)
,(@time_zone_id, 764704800, 6)
,(@time_zone_id, 780429600, 5)
,(@time_zone_id, 796154400, 6)
,(@time_zone_id, 811879200, 5)
,(@time_zone_id, 828208800, 6)
,(@time_zone_id, 846352800, 5)
,(@time_zone_id, 859658400, 6)
,(@time_zone_id, 877802400, 5)
,(@time_zone_id, 891108000, 6)
,(@time_zone_id, 909252000, 5)
,(@time_zone_id, 922557600, 6)
,(@time_zone_id, 941306400, 5)
,(@time_zone_id, 954007200, 6)
,(@time_zone_id, 972756000, 5)
,(@time_zone_id, 985456800, 6)
,(@time_zone_id, 1004205600, 5)
,(@time_zone_id, 1017511200, 6)
,(@time_zone_id, 1035655200, 5)
,(@time_zone_id, 1048960800, 6)
,(@time_zone_id, 1067104800, 5)
,(@time_zone_id, 1080410400, 6)
,(@time_zone_id, 1099159200, 5)
,(@time_zone_id, 1111860000, 6)
,(@time_zone_id, 1130608800, 5)
,(@time_zone_id, 1143309600, 6)
,(@time_zone_id, 1162058400, 5)
,(@time_zone_id, 1174759200, 6)
,(@time_zone_id, 1193508000, 5)
,(@time_zone_id, 1206813600, 6)
,(@time_zone_id, 1224957600, 5)
,(@time_zone_id, 1238263200, 6)
,(@time_zone_id, 1256407200, 5)
,(@time_zone_id, 1269712800, 6)
,(@time_zone_id, 1288461600, 5)
,(@time_zone_id, 1301162400, 9)
,(@time_zone_id, 1414256400, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 25025, 0, 'LMT')
,(@time_zone_id, 1, 25025, 0, 'IMT')
,(@time_zone_id, 2, 25200, 0, '+07')
,(@time_zone_id, 3, 32400, 1, '+09')
,(@time_zone_id, 4, 28800, 0, '+08')
,(@time_zone_id, 5, 28800, 0, '+08')
,(@time_zone_id, 6, 32400, 1, '+09')
,(@time_zone_id, 7, 28800, 1, '+08')
,(@time_zone_id, 8, 25200, 0, '+07')
,(@time_zone_id, 9, 32400, 0, '+09')
,(@time_zone_id, 10, 32400, 1, '+09')
,(@time_zone_id, 11, 28800, 0, '+08')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Istanbul', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1869875816, 3)
,(@time_zone_id, -1693706400, 2)
,(@time_zone_id, -1680490800, 3)
,(@time_zone_id, -1570413600, 2)
,(@time_zone_id, -1552186800, 3)
,(@time_zone_id, -1538359200, 2)
,(@time_zone_id, -1522551600, 3)
,(@time_zone_id, -1507514400, 2)
,(@time_zone_id, -1490583600, 3)
,(@time_zone_id, -1440208800, 2)
,(@time_zone_id, -1428030000, 3)
,(@time_zone_id, -1409709600, 2)
,(@time_zone_id, -1396494000, 3)
,(@time_zone_id, -931140000, 2)
,(@time_zone_id, -922762800, 3)
,(@time_zone_id, -917834400, 2)
,(@time_zone_id, -892436400, 3)
,(@time_zone_id, -875844000, 2)
,(@time_zone_id, -857358000, 3)
,(@time_zone_id, -781063200, 2)
,(@time_zone_id, -764737200, 3)
,(@time_zone_id, -744343200, 2)
,(@time_zone_id, -733806000, 3)
,(@time_zone_id, -716436000, 2)
,(@time_zone_id, -701924400, 3)
,(@time_zone_id, -684986400, 2)
,(@time_zone_id, -670474800, 3)
,(@time_zone_id, -654141600, 2)
,(@time_zone_id, -639025200, 3)
,(@time_zone_id, -621828000, 2)
,(@time_zone_id, -606970800, 3)
,(@time_zone_id, -590032800, 2)
,(@time_zone_id, -575434800, 3)
,(@time_zone_id, -235620000, 2)
,(@time_zone_id, -228279600, 3)
,(@time_zone_id, -177732000, 2)
,(@time_zone_id, -165726000, 3)
,(@time_zone_id, 10533600, 2)
,(@time_zone_id, 23835600, 3)
,(@time_zone_id, 41983200, 2)
,(@time_zone_id, 55285200, 3)
,(@time_zone_id, 74037600, 2)
,(@time_zone_id, 87339600, 3)
,(@time_zone_id, 107910000, 2)
,(@time_zone_id, 121219200, 3)
,(@time_zone_id, 133920000, 2)
,(@time_zone_id, 152676000, 3)
,(@time_zone_id, 165362400, 2)
,(@time_zone_id, 183502800, 3)
,(@time_zone_id, 202428000, 2)
,(@time_zone_id, 215557200, 3)
,(@time_zone_id, 228866400, 2)
,(@time_zone_id, 245797200, 3)
,(@time_zone_id, 260316000, 2)
,(@time_zone_id, 277246800, 4)
,(@time_zone_id, 308779200, 5)
,(@time_zone_id, 323827200, 4)
,(@time_zone_id, 340228800, 5)
,(@time_zone_id, 354672000, 4)
,(@time_zone_id, 371678400, 5)
,(@time_zone_id, 386121600, 4)
,(@time_zone_id, 403128000, 5)
,(@time_zone_id, 428446800, 4)
,(@time_zone_id, 433886400, 5)
,(@time_zone_id, 482792400, 2)
,(@time_zone_id, 496702800, 3)
,(@time_zone_id, 512521200, 6)
,(@time_zone_id, 528246000, 7)
,(@time_zone_id, 543970800, 6)
,(@time_zone_id, 559695600, 7)
,(@time_zone_id, 575420400, 6)
,(@time_zone_id, 591145200, 7)
,(@time_zone_id, 606870000, 6)
,(@time_zone_id, 622594800, 7)
,(@time_zone_id, 638319600, 6)
,(@time_zone_id, 654649200, 7)
,(@time_zone_id, 670374000, 6)
,(@time_zone_id, 686098800, 7)
,(@time_zone_id, 701823600, 6)
,(@time_zone_id, 717548400, 7)
,(@time_zone_id, 733273200, 6)
,(@time_zone_id, 748998000, 7)
,(@time_zone_id, 764118000, 6)
,(@time_zone_id, 780447600, 7)
,(@time_zone_id, 796172400, 6)
,(@time_zone_id, 811897200, 7)
,(@time_zone_id, 828226800, 6)
,(@time_zone_id, 846370800, 7)
,(@time_zone_id, 859676400, 6)
,(@time_zone_id, 877820400, 7)
,(@time_zone_id, 891126000, 6)
,(@time_zone_id, 909270000, 7)
,(@time_zone_id, 922575600, 6)
,(@time_zone_id, 941324400, 7)
,(@time_zone_id, 954025200, 6)
,(@time_zone_id, 972774000, 7)
,(@time_zone_id, 985474800, 6)
,(@time_zone_id, 1004223600, 7)
,(@time_zone_id, 1017529200, 6)
,(@time_zone_id, 1035673200, 7)
,(@time_zone_id, 1048978800, 6)
,(@time_zone_id, 1067122800, 7)
,(@time_zone_id, 1080428400, 6)
,(@time_zone_id, 1099177200, 7)
,(@time_zone_id, 1111878000, 6)
,(@time_zone_id, 1130626800, 7)
,(@time_zone_id, 1143327600, 6)
,(@time_zone_id, 1162076400, 7)
,(@time_zone_id, 1167602400, 3)
,(@time_zone_id, 1174784400, 8)
,(@time_zone_id, 1193533200, 9)
,(@time_zone_id, 1206838800, 8)
,(@time_zone_id, 1224982800, 9)
,(@time_zone_id, 1238288400, 8)
,(@time_zone_id, 1256432400, 9)
,(@time_zone_id, 1269738000, 8)
,(@time_zone_id, 1288486800, 9)
,(@time_zone_id, 1301274000, 8)
,(@time_zone_id, 1319936400, 9)
,(@time_zone_id, 1332637200, 8)
,(@time_zone_id, 1351386000, 9)
,(@time_zone_id, 1364691600, 8)
,(@time_zone_id, 1382835600, 9)
,(@time_zone_id, 1396227600, 8)
,(@time_zone_id, 1414285200, 9)
,(@time_zone_id, 1427590800, 8)
,(@time_zone_id, 1446944400, 9)
,(@time_zone_id, 1459040400, 8)
,(@time_zone_id, 1473195600, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 6952, 0, 'LMT')
,(@time_zone_id, 1, 7016, 0, 'IMT')
,(@time_zone_id, 2, 10800, 1, 'EEST')
,(@time_zone_id, 3, 7200, 0, 'EET')
,(@time_zone_id, 4, 14400, 1, '+04')
,(@time_zone_id, 5, 10800, 0, '+03')
,(@time_zone_id, 6, 10800, 1, 'EEST')
,(@time_zone_id, 7, 7200, 0, 'EET')
,(@time_zone_id, 8, 10800, 1, 'EEST')
,(@time_zone_id, 9, 7200, 0, 'EET')
,(@time_zone_id, 10, 10800, 0, '+03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Jakarta', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1451719200, 2)
,(@time_zone_id, -1172906400, 3)
,(@time_zone_id, -876641400, 4)
,(@time_zone_id, -766054800, 3)
,(@time_zone_id, -683883000, 5)
,(@time_zone_id, -620812800, 3)
,(@time_zone_id, -189415800, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 25632, 0, 'LMT')
,(@time_zone_id, 1, 25632, 0, 'BMT')
,(@time_zone_id, 2, 26400, 0, '+0720')
,(@time_zone_id, 3, 27000, 0, '+0730')
,(@time_zone_id, 4, 32400, 0, '+09')
,(@time_zone_id, 5, 28800, 0, '+08')
,(@time_zone_id, 6, 25200, 0, 'WIB')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Jayapura', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1172913768, 1)
,(@time_zone_id, -799491600, 2)
,(@time_zone_id, -189423000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 33768, 0, 'LMT')
,(@time_zone_id, 1, 32400, 0, '+09')
,(@time_zone_id, 2, 34200, 0, '+0930')
,(@time_zone_id, 3, 32400, 0, 'WIT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Jerusalem', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1641003640, 3)
,(@time_zone_id, -933645600, 2)
,(@time_zone_id, -857358000, 3)
,(@time_zone_id, -844300800, 2)
,(@time_zone_id, -825822000, 3)
,(@time_zone_id, -812685600, 2)
,(@time_zone_id, -794199600, 3)
,(@time_zone_id, -779853600, 2)
,(@time_zone_id, -762656400, 3)
,(@time_zone_id, -748310400, 2)
,(@time_zone_id, -731127600, 3)
,(@time_zone_id, -681962400, 4)
,(@time_zone_id, -673243200, 2)
,(@time_zone_id, -667962000, 3)
,(@time_zone_id, -652327200, 2)
,(@time_zone_id, -636426000, 3)
,(@time_zone_id, -622087200, 2)
,(@time_zone_id, -608947200, 3)
,(@time_zone_id, -591847200, 2)
,(@time_zone_id, -572486400, 3)
,(@time_zone_id, -558576000, 2)
,(@time_zone_id, -542851200, 3)
,(@time_zone_id, -527731200, 2)
,(@time_zone_id, -514425600, 3)
,(@time_zone_id, -490845600, 2)
,(@time_zone_id, -482986800, 3)
,(@time_zone_id, -459475200, 2)
,(@time_zone_id, -451537200, 3)
,(@time_zone_id, -428551200, 2)
,(@time_zone_id, -418262400, 3)
,(@time_zone_id, -400032000, 2)
,(@time_zone_id, -387428400, 3)
,(@time_zone_id, 142380000, 2)
,(@time_zone_id, 150843600, 3)
,(@time_zone_id, 167176800, 2)
,(@time_zone_id, 178664400, 3)
,(@time_zone_id, 482277600, 2)
,(@time_zone_id, 495579600, 3)
,(@time_zone_id, 516751200, 2)
,(@time_zone_id, 526424400, 3)
,(@time_zone_id, 545436000, 2)
,(@time_zone_id, 558478800, 3)
,(@time_zone_id, 576626400, 2)
,(@time_zone_id, 589323600, 3)
,(@time_zone_id, 609890400, 2)
,(@time_zone_id, 620773200, 3)
,(@time_zone_id, 638316000, 2)
,(@time_zone_id, 651618000, 3)
,(@time_zone_id, 669765600, 2)
,(@time_zone_id, 683672400, 3)
,(@time_zone_id, 701820000, 2)
,(@time_zone_id, 715726800, 3)
,(@time_zone_id, 733701600, 2)
,(@time_zone_id, 747176400, 3)
,(@time_zone_id, 765151200, 2)
,(@time_zone_id, 778021200, 3)
,(@time_zone_id, 796600800, 2)
,(@time_zone_id, 810075600, 3)
,(@time_zone_id, 826840800, 2)
,(@time_zone_id, 842821200, 3)
,(@time_zone_id, 858895200, 2)
,(@time_zone_id, 874184400, 3)
,(@time_zone_id, 890344800, 2)
,(@time_zone_id, 905029200, 3)
,(@time_zone_id, 923011200, 2)
,(@time_zone_id, 936313200, 3)
,(@time_zone_id, 955670400, 2)
,(@time_zone_id, 970783200, 3)
,(@time_zone_id, 986770800, 2)
,(@time_zone_id, 1001282400, 3)
,(@time_zone_id, 1017356400, 2)
,(@time_zone_id, 1033941600, 3)
,(@time_zone_id, 1048806000, 2)
,(@time_zone_id, 1065132000, 3)
,(@time_zone_id, 1081292400, 2)
,(@time_zone_id, 1095804000, 3)
,(@time_zone_id, 1112313600, 2)
,(@time_zone_id, 1128812400, 3)
,(@time_zone_id, 1143763200, 2)
,(@time_zone_id, 1159657200, 3)
,(@time_zone_id, 1175212800, 2)
,(@time_zone_id, 1189897200, 3)
,(@time_zone_id, 1206662400, 2)
,(@time_zone_id, 1223161200, 3)
,(@time_zone_id, 1238112000, 2)
,(@time_zone_id, 1254006000, 3)
,(@time_zone_id, 1269561600, 2)
,(@time_zone_id, 1284246000, 3)
,(@time_zone_id, 1301616000, 2)
,(@time_zone_id, 1317510000, 3)
,(@time_zone_id, 1333065600, 2)
,(@time_zone_id, 1348354800, 3)
,(@time_zone_id, 1364515200, 2)
,(@time_zone_id, 1382828400, 3)
,(@time_zone_id, 1395964800, 2)
,(@time_zone_id, 1414278000, 3)
,(@time_zone_id, 1427414400, 2)
,(@time_zone_id, 1445727600, 3)
,(@time_zone_id, 1458864000, 2)
,(@time_zone_id, 1477782000, 3)
,(@time_zone_id, 1490313600, 2)
,(@time_zone_id, 1509231600, 3)
,(@time_zone_id, 1521763200, 2)
,(@time_zone_id, 1540681200, 3)
,(@time_zone_id, 1553817600, 2)
,(@time_zone_id, 1572130800, 3)
,(@time_zone_id, 1585267200, 2)
,(@time_zone_id, 1603580400, 3)
,(@time_zone_id, 1616716800, 2)
,(@time_zone_id, 1635634800, 3)
,(@time_zone_id, 1648166400, 2)
,(@time_zone_id, 1667084400, 3)
,(@time_zone_id, 1679616000, 2)
,(@time_zone_id, 1698534000, 3)
,(@time_zone_id, 1711670400, 2)
,(@time_zone_id, 1729983600, 3)
,(@time_zone_id, 1743120000, 2)
,(@time_zone_id, 1761433200, 3)
,(@time_zone_id, 1774569600, 2)
,(@time_zone_id, 1792882800, 3)
,(@time_zone_id, 1806019200, 2)
,(@time_zone_id, 1824937200, 3)
,(@time_zone_id, 1837468800, 2)
,(@time_zone_id, 1856386800, 3)
,(@time_zone_id, 1868918400, 2)
,(@time_zone_id, 1887836400, 3)
,(@time_zone_id, 1900972800, 2)
,(@time_zone_id, 1919286000, 3)
,(@time_zone_id, 1932422400, 2)
,(@time_zone_id, 1950735600, 3)
,(@time_zone_id, 1963872000, 2)
,(@time_zone_id, 1982790000, 3)
,(@time_zone_id, 1995321600, 2)
,(@time_zone_id, 2014239600, 3)
,(@time_zone_id, 2026771200, 2)
,(@time_zone_id, 2045689200, 3)
,(@time_zone_id, 2058220800, 2)
,(@time_zone_id, 2077138800, 3)
,(@time_zone_id, 2090275200, 2)
,(@time_zone_id, 2108588400, 3)
,(@time_zone_id, 2121724800, 2)
,(@time_zone_id, 2140038000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8454, 0, 'LMT')
,(@time_zone_id, 1, 8440, 0, 'JMT')
,(@time_zone_id, 2, 10800, 1, 'IDT')
,(@time_zone_id, 3, 7200, 0, 'IST')
,(@time_zone_id, 4, 14400, 1, 'IDDT')
,(@time_zone_id, 5, 10800, 1, 'IDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Kabul', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -788932800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 16608, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 16200, 0, '+0430')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Kamchatka', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1487759676, 1)
,(@time_zone_id, -1247569200, 3)
,(@time_zone_id, 354888000, 2)
,(@time_zone_id, 370695600, 3)
,(@time_zone_id, 386424000, 2)
,(@time_zone_id, 402231600, 3)
,(@time_zone_id, 417960000, 2)
,(@time_zone_id, 433767600, 3)
,(@time_zone_id, 449582400, 2)
,(@time_zone_id, 465314400, 4)
,(@time_zone_id, 481039200, 5)
,(@time_zone_id, 496764000, 4)
,(@time_zone_id, 512488800, 5)
,(@time_zone_id, 528213600, 4)
,(@time_zone_id, 543938400, 5)
,(@time_zone_id, 559663200, 4)
,(@time_zone_id, 575388000, 5)
,(@time_zone_id, 591112800, 4)
,(@time_zone_id, 606837600, 5)
,(@time_zone_id, 622562400, 4)
,(@time_zone_id, 638287200, 5)
,(@time_zone_id, 654616800, 4)
,(@time_zone_id, 670341600, 6)
,(@time_zone_id, 686070000, 7)
,(@time_zone_id, 695746800, 4)
,(@time_zone_id, 701791200, 5)
,(@time_zone_id, 717516000, 4)
,(@time_zone_id, 733240800, 5)
,(@time_zone_id, 748965600, 4)
,(@time_zone_id, 764690400, 5)
,(@time_zone_id, 780415200, 4)
,(@time_zone_id, 796140000, 5)
,(@time_zone_id, 811864800, 4)
,(@time_zone_id, 828194400, 5)
,(@time_zone_id, 846338400, 4)
,(@time_zone_id, 859644000, 5)
,(@time_zone_id, 877788000, 4)
,(@time_zone_id, 891093600, 5)
,(@time_zone_id, 909237600, 4)
,(@time_zone_id, 922543200, 5)
,(@time_zone_id, 941292000, 4)
,(@time_zone_id, 953992800, 5)
,(@time_zone_id, 972741600, 4)
,(@time_zone_id, 985442400, 5)
,(@time_zone_id, 1004191200, 4)
,(@time_zone_id, 1017496800, 5)
,(@time_zone_id, 1035640800, 4)
,(@time_zone_id, 1048946400, 5)
,(@time_zone_id, 1067090400, 4)
,(@time_zone_id, 1080396000, 5)
,(@time_zone_id, 1099144800, 4)
,(@time_zone_id, 1111845600, 5)
,(@time_zone_id, 1130594400, 4)
,(@time_zone_id, 1143295200, 5)
,(@time_zone_id, 1162044000, 4)
,(@time_zone_id, 1174744800, 5)
,(@time_zone_id, 1193493600, 4)
,(@time_zone_id, 1206799200, 5)
,(@time_zone_id, 1224943200, 4)
,(@time_zone_id, 1238248800, 5)
,(@time_zone_id, 1256392800, 4)
,(@time_zone_id, 1269698400, 6)
,(@time_zone_id, 1288450800, 7)
,(@time_zone_id, 1301151600, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 38076, 0, 'LMT')
,(@time_zone_id, 1, 39600, 0, '+11')
,(@time_zone_id, 2, 46800, 1, '+13')
,(@time_zone_id, 3, 43200, 0, '+12')
,(@time_zone_id, 4, 43200, 0, '+12')
,(@time_zone_id, 5, 46800, 1, '+13')
,(@time_zone_id, 6, 43200, 1, '+12')
,(@time_zone_id, 7, 39600, 0, '+11')
,(@time_zone_id, 8, 43200, 0, '+12')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Karachi', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1988166492, 1)
,(@time_zone_id, -862637400, 2)
,(@time_zone_id, -764145000, 1)
,(@time_zone_id, -576135000, 3)
,(@time_zone_id, 38775600, 5)
,(@time_zone_id, 1018119600, 4)
,(@time_zone_id, 1033840800, 5)
,(@time_zone_id, 1212260400, 4)
,(@time_zone_id, 1225476000, 5)
,(@time_zone_id, 1239735600, 4)
,(@time_zone_id, 1257012000, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 16092, 0, 'LMT')
,(@time_zone_id, 1, 19800, 0, '+0530')
,(@time_zone_id, 2, 23400, 1, '+0630')
,(@time_zone_id, 3, 18000, 0, '+05')
,(@time_zone_id, 4, 21600, 1, 'PKST')
,(@time_zone_id, 5, 18000, 0, 'PKT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Kashgar', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1325483420, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 21020, 0, 'LMT')
,(@time_zone_id, 1, 21600, 0, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Kathmandu', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577943676, 1)
,(@time_zone_id, 504901800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 20476, 0, 'LMT')
,(@time_zone_id, 1, 19800, 0, '+0530')
,(@time_zone_id, 2, 20700, 0, '+0545')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Katmandu', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577943676, 1)
,(@time_zone_id, 504901800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 20476, 0, 'LMT')
,(@time_zone_id, 1, 19800, 0, '+0530')
,(@time_zone_id, 2, 20700, 0, '+0545')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Khandyga', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1579424533, 1)
,(@time_zone_id, -1247558400, 3)
,(@time_zone_id, 354898800, 2)
,(@time_zone_id, 370706400, 3)
,(@time_zone_id, 386434800, 2)
,(@time_zone_id, 402242400, 3)
,(@time_zone_id, 417970800, 2)
,(@time_zone_id, 433778400, 3)
,(@time_zone_id, 449593200, 2)
,(@time_zone_id, 465325200, 4)
,(@time_zone_id, 481050000, 5)
,(@time_zone_id, 496774800, 4)
,(@time_zone_id, 512499600, 5)
,(@time_zone_id, 528224400, 4)
,(@time_zone_id, 543949200, 5)
,(@time_zone_id, 559674000, 4)
,(@time_zone_id, 575398800, 5)
,(@time_zone_id, 591123600, 4)
,(@time_zone_id, 606848400, 5)
,(@time_zone_id, 622573200, 4)
,(@time_zone_id, 638298000, 5)
,(@time_zone_id, 654627600, 4)
,(@time_zone_id, 670352400, 6)
,(@time_zone_id, 686080800, 7)
,(@time_zone_id, 695757600, 4)
,(@time_zone_id, 701802000, 5)
,(@time_zone_id, 717526800, 4)
,(@time_zone_id, 733251600, 5)
,(@time_zone_id, 748976400, 4)
,(@time_zone_id, 764701200, 5)
,(@time_zone_id, 780426000, 4)
,(@time_zone_id, 796150800, 5)
,(@time_zone_id, 811875600, 4)
,(@time_zone_id, 828205200, 5)
,(@time_zone_id, 846349200, 4)
,(@time_zone_id, 859654800, 5)
,(@time_zone_id, 877798800, 4)
,(@time_zone_id, 891104400, 5)
,(@time_zone_id, 909248400, 4)
,(@time_zone_id, 922554000, 5)
,(@time_zone_id, 941302800, 4)
,(@time_zone_id, 954003600, 5)
,(@time_zone_id, 972752400, 4)
,(@time_zone_id, 985453200, 5)
,(@time_zone_id, 1004202000, 4)
,(@time_zone_id, 1017507600, 5)
,(@time_zone_id, 1035651600, 4)
,(@time_zone_id, 1048957200, 5)
,(@time_zone_id, 1067101200, 4)
,(@time_zone_id, 1072882800, 10)
,(@time_zone_id, 1080403200, 8)
,(@time_zone_id, 1099152000, 9)
,(@time_zone_id, 1111852800, 8)
,(@time_zone_id, 1130601600, 9)
,(@time_zone_id, 1143302400, 8)
,(@time_zone_id, 1162051200, 9)
,(@time_zone_id, 1174752000, 8)
,(@time_zone_id, 1193500800, 9)
,(@time_zone_id, 1206806400, 8)
,(@time_zone_id, 1224950400, 9)
,(@time_zone_id, 1238256000, 8)
,(@time_zone_id, 1256400000, 9)
,(@time_zone_id, 1269705600, 8)
,(@time_zone_id, 1288454400, 9)
,(@time_zone_id, 1301155200, 11)
,(@time_zone_id, 1315832400, 9)
,(@time_zone_id, 1414252800, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 32533, 0, 'LMT')
,(@time_zone_id, 1, 28800, 0, '+08')
,(@time_zone_id, 2, 36000, 1, '+10')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 32400, 0, '+09')
,(@time_zone_id, 5, 36000, 1, '+10')
,(@time_zone_id, 6, 32400, 1, '+09')
,(@time_zone_id, 7, 28800, 0, '+08')
,(@time_zone_id, 8, 39600, 1, '+11')
,(@time_zone_id, 9, 36000, 0, '+10')
,(@time_zone_id, 10, 36000, 0, '+10')
,(@time_zone_id, 11, 39600, 0, '+11')
,(@time_zone_id, 12, 32400, 0, '+09')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Kolkata', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2019705670, 2)
,(@time_zone_id, -891581400, 3)
,(@time_zone_id, -872058600, 2)
,(@time_zone_id, -862637400, 3)
,(@time_zone_id, -764145000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 21200, 0, 'HMT')
,(@time_zone_id, 1, 19270, 0, 'MMT')
,(@time_zone_id, 2, 19800, 0, 'IST')
,(@time_zone_id, 3, 23400, 1, '+0630')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Krasnoyarsk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577513486, 1)
,(@time_zone_id, -1247551200, 3)
,(@time_zone_id, 354906000, 2)
,(@time_zone_id, 370713600, 3)
,(@time_zone_id, 386442000, 2)
,(@time_zone_id, 402249600, 3)
,(@time_zone_id, 417978000, 2)
,(@time_zone_id, 433785600, 3)
,(@time_zone_id, 449600400, 2)
,(@time_zone_id, 465332400, 4)
,(@time_zone_id, 481057200, 5)
,(@time_zone_id, 496782000, 4)
,(@time_zone_id, 512506800, 5)
,(@time_zone_id, 528231600, 4)
,(@time_zone_id, 543956400, 5)
,(@time_zone_id, 559681200, 4)
,(@time_zone_id, 575406000, 5)
,(@time_zone_id, 591130800, 4)
,(@time_zone_id, 606855600, 5)
,(@time_zone_id, 622580400, 4)
,(@time_zone_id, 638305200, 5)
,(@time_zone_id, 654634800, 4)
,(@time_zone_id, 670359600, 6)
,(@time_zone_id, 686088000, 7)
,(@time_zone_id, 695764800, 4)
,(@time_zone_id, 701809200, 5)
,(@time_zone_id, 717534000, 4)
,(@time_zone_id, 733258800, 5)
,(@time_zone_id, 748983600, 4)
,(@time_zone_id, 764708400, 5)
,(@time_zone_id, 780433200, 4)
,(@time_zone_id, 796158000, 5)
,(@time_zone_id, 811882800, 4)
,(@time_zone_id, 828212400, 5)
,(@time_zone_id, 846356400, 4)
,(@time_zone_id, 859662000, 5)
,(@time_zone_id, 877806000, 4)
,(@time_zone_id, 891111600, 5)
,(@time_zone_id, 909255600, 4)
,(@time_zone_id, 922561200, 5)
,(@time_zone_id, 941310000, 4)
,(@time_zone_id, 954010800, 5)
,(@time_zone_id, 972759600, 4)
,(@time_zone_id, 985460400, 5)
,(@time_zone_id, 1004209200, 4)
,(@time_zone_id, 1017514800, 5)
,(@time_zone_id, 1035658800, 4)
,(@time_zone_id, 1048964400, 5)
,(@time_zone_id, 1067108400, 4)
,(@time_zone_id, 1080414000, 5)
,(@time_zone_id, 1099162800, 4)
,(@time_zone_id, 1111863600, 5)
,(@time_zone_id, 1130612400, 4)
,(@time_zone_id, 1143313200, 5)
,(@time_zone_id, 1162062000, 4)
,(@time_zone_id, 1174762800, 5)
,(@time_zone_id, 1193511600, 4)
,(@time_zone_id, 1206817200, 5)
,(@time_zone_id, 1224961200, 4)
,(@time_zone_id, 1238266800, 5)
,(@time_zone_id, 1256410800, 4)
,(@time_zone_id, 1269716400, 5)
,(@time_zone_id, 1288465200, 4)
,(@time_zone_id, 1301166000, 8)
,(@time_zone_id, 1414260000, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 22286, 0, 'LMT')
,(@time_zone_id, 1, 21600, 0, '+06')
,(@time_zone_id, 2, 28800, 1, '+08')
,(@time_zone_id, 3, 25200, 0, '+07')
,(@time_zone_id, 4, 25200, 0, '+07')
,(@time_zone_id, 5, 28800, 1, '+08')
,(@time_zone_id, 6, 25200, 1, '+07')
,(@time_zone_id, 7, 21600, 0, '+06')
,(@time_zone_id, 8, 28800, 0, '+08')
,(@time_zone_id, 9, 28800, 1, '+08')
,(@time_zone_id, 10, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Kuala_Lumpur', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2038200925, 2)
,(@time_zone_id, -1167634800, 3)
,(@time_zone_id, -1073028000, 4)
,(@time_zone_id, -894180000, 5)
,(@time_zone_id, -879665400, 6)
,(@time_zone_id, -767005200, 5)
,(@time_zone_id, 378664200, 7)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 24406, 0, 'LMT')
,(@time_zone_id, 1, 24925, 0, 'SMT')
,(@time_zone_id, 2, 25200, 0, '+07')
,(@time_zone_id, 3, 26400, 1, '+0720')
,(@time_zone_id, 4, 26400, 0, '+0720')
,(@time_zone_id, 5, 27000, 0, '+0730')
,(@time_zone_id, 6, 32400, 0, '+09')
,(@time_zone_id, 7, 28800, 0, '+08')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Kuching', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1383463280, 1)
,(@time_zone_id, -1167636600, 3)
,(@time_zone_id, -1082448000, 2)
,(@time_zone_id, -1074586800, 3)
,(@time_zone_id, -1050825600, 2)
,(@time_zone_id, -1042964400, 3)
,(@time_zone_id, -1019289600, 2)
,(@time_zone_id, -1011428400, 3)
,(@time_zone_id, -987753600, 2)
,(@time_zone_id, -979892400, 3)
,(@time_zone_id, -956217600, 2)
,(@time_zone_id, -948356400, 3)
,(@time_zone_id, -924595200, 2)
,(@time_zone_id, -916734000, 3)
,(@time_zone_id, -893059200, 2)
,(@time_zone_id, -885198000, 3)
,(@time_zone_id, -879667200, 4)
,(@time_zone_id, -767005200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 26480, 0, 'LMT')
,(@time_zone_id, 1, 27000, 0, '+0730')
,(@time_zone_id, 2, 30000, 1, '+0820')
,(@time_zone_id, 3, 28800, 0, '+08')
,(@time_zone_id, 4, 32400, 0, '+09')
,(@time_zone_id, 5, 28800, 0, '+08')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Kuwait', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -719636812, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 11212, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, '+03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Macao', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2056692850, 1)
,(@time_zone_id, -884509200, 3)
,(@time_zone_id, -873280800, 2)
,(@time_zone_id, -855918000, 3)
,(@time_zone_id, -841744800, 2)
,(@time_zone_id, -828529200, 3)
,(@time_zone_id, -765363600, 1)
,(@time_zone_id, -747046800, 4)
,(@time_zone_id, -733827600, 5)
,(@time_zone_id, -716461200, 4)
,(@time_zone_id, -697021200, 5)
,(@time_zone_id, -683715600, 4)
,(@time_zone_id, -667990800, 5)
,(@time_zone_id, -654771600, 4)
,(@time_zone_id, -636627600, 5)
,(@time_zone_id, -623322000, 4)
,(@time_zone_id, -605178000, 5)
,(@time_zone_id, -591872400, 4)
,(@time_zone_id, -573642000, 5)
,(@time_zone_id, -559818000, 4)
,(@time_zone_id, -541674000, 5)
,(@time_zone_id, -528368400, 4)
,(@time_zone_id, -510224400, 5)
,(@time_zone_id, -498128400, 4)
,(@time_zone_id, -478774800, 5)
,(@time_zone_id, -466678800, 4)
,(@time_zone_id, -446720400, 5)
,(@time_zone_id, -435229200, 4)
,(@time_zone_id, -415258200, 1)
,(@time_zone_id, -403158600, 6)
,(@time_zone_id, -383808600, 1)
,(@time_zone_id, -371709000, 6)
,(@time_zone_id, -352359000, 1)
,(@time_zone_id, -340259400, 6)
,(@time_zone_id, -320909400, 1)
,(@time_zone_id, -308809800, 6)
,(@time_zone_id, -288855000, 1)
,(@time_zone_id, -277360200, 6)
,(@time_zone_id, -257405400, 1)
,(@time_zone_id, -245910600, 6)
,(@time_zone_id, -225955800, 1)
,(@time_zone_id, -213856200, 6)
,(@time_zone_id, -194506200, 1)
,(@time_zone_id, -182406600, 6)
,(@time_zone_id, -163056600, 1)
,(@time_zone_id, -148537800, 6)
,(@time_zone_id, -132820200, 1)
,(@time_zone_id, -117088200, 6)
,(@time_zone_id, -101370600, 1)
,(@time_zone_id, -85638600, 6)
,(@time_zone_id, -69312600, 1)
,(@time_zone_id, -53584200, 6)
,(@time_zone_id, -37863000, 1)
,(@time_zone_id, -22134600, 6)
,(@time_zone_id, -6413400, 1)
,(@time_zone_id, 9315000, 6)
,(@time_zone_id, 25036200, 1)
,(@time_zone_id, 40764600, 6)
,(@time_zone_id, 56485800, 1)
,(@time_zone_id, 72214200, 6)
,(@time_zone_id, 88540200, 1)
,(@time_zone_id, 104268600, 6)
,(@time_zone_id, 119989800, 1)
,(@time_zone_id, 126041400, 6)
,(@time_zone_id, 151439400, 1)
,(@time_zone_id, 167167800, 6)
,(@time_zone_id, 182889000, 1)
,(@time_zone_id, 198617400, 6)
,(@time_zone_id, 214338600, 1)
,(@time_zone_id, 295385400, 6)
,(@time_zone_id, 309292200, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 27250, 0, 'LMT')
,(@time_zone_id, 1, 28800, 0, 'CST')
,(@time_zone_id, 2, 36000, 1, '+10')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 32400, 1, 'CDT')
,(@time_zone_id, 5, 28800, 0, 'CST')
,(@time_zone_id, 6, 32400, 1, 'CDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Macau', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2056692850, 1)
,(@time_zone_id, -884509200, 3)
,(@time_zone_id, -873280800, 2)
,(@time_zone_id, -855918000, 3)
,(@time_zone_id, -841744800, 2)
,(@time_zone_id, -828529200, 3)
,(@time_zone_id, -765363600, 1)
,(@time_zone_id, -747046800, 4)
,(@time_zone_id, -733827600, 5)
,(@time_zone_id, -716461200, 4)
,(@time_zone_id, -697021200, 5)
,(@time_zone_id, -683715600, 4)
,(@time_zone_id, -667990800, 5)
,(@time_zone_id, -654771600, 4)
,(@time_zone_id, -636627600, 5)
,(@time_zone_id, -623322000, 4)
,(@time_zone_id, -605178000, 5)
,(@time_zone_id, -591872400, 4)
,(@time_zone_id, -573642000, 5)
,(@time_zone_id, -559818000, 4)
,(@time_zone_id, -541674000, 5)
,(@time_zone_id, -528368400, 4)
,(@time_zone_id, -510224400, 5)
,(@time_zone_id, -498128400, 4)
,(@time_zone_id, -478774800, 5)
,(@time_zone_id, -466678800, 4)
,(@time_zone_id, -446720400, 5)
,(@time_zone_id, -435229200, 4)
,(@time_zone_id, -415258200, 1)
,(@time_zone_id, -403158600, 6)
,(@time_zone_id, -383808600, 1)
,(@time_zone_id, -371709000, 6)
,(@time_zone_id, -352359000, 1)
,(@time_zone_id, -340259400, 6)
,(@time_zone_id, -320909400, 1)
,(@time_zone_id, -308809800, 6)
,(@time_zone_id, -288855000, 1)
,(@time_zone_id, -277360200, 6)
,(@time_zone_id, -257405400, 1)
,(@time_zone_id, -245910600, 6)
,(@time_zone_id, -225955800, 1)
,(@time_zone_id, -213856200, 6)
,(@time_zone_id, -194506200, 1)
,(@time_zone_id, -182406600, 6)
,(@time_zone_id, -163056600, 1)
,(@time_zone_id, -148537800, 6)
,(@time_zone_id, -132820200, 1)
,(@time_zone_id, -117088200, 6)
,(@time_zone_id, -101370600, 1)
,(@time_zone_id, -85638600, 6)
,(@time_zone_id, -69312600, 1)
,(@time_zone_id, -53584200, 6)
,(@time_zone_id, -37863000, 1)
,(@time_zone_id, -22134600, 6)
,(@time_zone_id, -6413400, 1)
,(@time_zone_id, 9315000, 6)
,(@time_zone_id, 25036200, 1)
,(@time_zone_id, 40764600, 6)
,(@time_zone_id, 56485800, 1)
,(@time_zone_id, 72214200, 6)
,(@time_zone_id, 88540200, 1)
,(@time_zone_id, 104268600, 6)
,(@time_zone_id, 119989800, 1)
,(@time_zone_id, 126041400, 6)
,(@time_zone_id, 151439400, 1)
,(@time_zone_id, 167167800, 6)
,(@time_zone_id, 182889000, 1)
,(@time_zone_id, 198617400, 6)
,(@time_zone_id, 214338600, 1)
,(@time_zone_id, 295385400, 6)
,(@time_zone_id, 309292200, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 27250, 0, 'LMT')
,(@time_zone_id, 1, 28800, 0, 'CST')
,(@time_zone_id, 2, 36000, 1, '+10')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 32400, 1, 'CDT')
,(@time_zone_id, 5, 28800, 0, 'CST')
,(@time_zone_id, 6, 32400, 1, 'CDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Magadan', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441188192, 1)
,(@time_zone_id, -1247565600, 3)
,(@time_zone_id, 354891600, 2)
,(@time_zone_id, 370699200, 3)
,(@time_zone_id, 386427600, 2)
,(@time_zone_id, 402235200, 3)
,(@time_zone_id, 417963600, 2)
,(@time_zone_id, 433771200, 3)
,(@time_zone_id, 449586000, 2)
,(@time_zone_id, 465318000, 4)
,(@time_zone_id, 481042800, 5)
,(@time_zone_id, 496767600, 4)
,(@time_zone_id, 512492400, 5)
,(@time_zone_id, 528217200, 4)
,(@time_zone_id, 543942000, 5)
,(@time_zone_id, 559666800, 4)
,(@time_zone_id, 575391600, 5)
,(@time_zone_id, 591116400, 4)
,(@time_zone_id, 606841200, 5)
,(@time_zone_id, 622566000, 4)
,(@time_zone_id, 638290800, 5)
,(@time_zone_id, 654620400, 4)
,(@time_zone_id, 670345200, 6)
,(@time_zone_id, 686073600, 7)
,(@time_zone_id, 695750400, 4)
,(@time_zone_id, 701794800, 5)
,(@time_zone_id, 717519600, 4)
,(@time_zone_id, 733244400, 5)
,(@time_zone_id, 748969200, 4)
,(@time_zone_id, 764694000, 5)
,(@time_zone_id, 780418800, 4)
,(@time_zone_id, 796143600, 5)
,(@time_zone_id, 811868400, 4)
,(@time_zone_id, 828198000, 5)
,(@time_zone_id, 846342000, 4)
,(@time_zone_id, 859647600, 5)
,(@time_zone_id, 877791600, 4)
,(@time_zone_id, 891097200, 5)
,(@time_zone_id, 909241200, 4)
,(@time_zone_id, 922546800, 5)
,(@time_zone_id, 941295600, 4)
,(@time_zone_id, 953996400, 5)
,(@time_zone_id, 972745200, 4)
,(@time_zone_id, 985446000, 5)
,(@time_zone_id, 1004194800, 4)
,(@time_zone_id, 1017500400, 5)
,(@time_zone_id, 1035644400, 4)
,(@time_zone_id, 1048950000, 5)
,(@time_zone_id, 1067094000, 4)
,(@time_zone_id, 1080399600, 5)
,(@time_zone_id, 1099148400, 4)
,(@time_zone_id, 1111849200, 5)
,(@time_zone_id, 1130598000, 4)
,(@time_zone_id, 1143298800, 5)
,(@time_zone_id, 1162047600, 4)
,(@time_zone_id, 1174748400, 5)
,(@time_zone_id, 1193497200, 4)
,(@time_zone_id, 1206802800, 5)
,(@time_zone_id, 1224946800, 4)
,(@time_zone_id, 1238252400, 5)
,(@time_zone_id, 1256396400, 4)
,(@time_zone_id, 1269702000, 5)
,(@time_zone_id, 1288450800, 4)
,(@time_zone_id, 1301151600, 8)
,(@time_zone_id, 1414245600, 7)
,(@time_zone_id, 1461427200, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 36192, 0, 'LMT')
,(@time_zone_id, 1, 36000, 0, '+10')
,(@time_zone_id, 2, 43200, 1, '+12')
,(@time_zone_id, 3, 39600, 0, '+11')
,(@time_zone_id, 4, 39600, 0, '+11')
,(@time_zone_id, 5, 43200, 1, '+12')
,(@time_zone_id, 6, 39600, 1, '+11')
,(@time_zone_id, 7, 36000, 0, '+10')
,(@time_zone_id, 8, 43200, 0, '+12')
,(@time_zone_id, 9, 43200, 1, '+12')
,(@time_zone_id, 10, 39600, 0, '+11')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Makassar', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577951856, 1)
,(@time_zone_id, -1172908656, 2)
,(@time_zone_id, -880272000, 3)
,(@time_zone_id, -766054800, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 28656, 0, 'LMT')
,(@time_zone_id, 1, 28656, 0, 'MMT')
,(@time_zone_id, 2, 28800, 0, '+08')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 28800, 0, 'WITA')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Manila', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -1046678400, 1)
,(@time_zone_id, -1038733200, 2)
,(@time_zone_id, -873273600, 3)
,(@time_zone_id, -794221200, 2)
,(@time_zone_id, -496224000, 1)
,(@time_zone_id, -489315600, 2)
,(@time_zone_id, 259344000, 1)
,(@time_zone_id, 275151600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 29040, 0, 'LMT')
,(@time_zone_id, 1, 32400, 1, 'PDT')
,(@time_zone_id, 2, 28800, 0, 'PST')
,(@time_zone_id, 3, 32400, 0, 'JST')
,(@time_zone_id, 4, 28800, 0, 'PST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Muscat', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577936472, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 13272, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Nicosia', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1518920008, 2)
,(@time_zone_id, 166572000, 1)
,(@time_zone_id, 182293200, 2)
,(@time_zone_id, 200959200, 1)
,(@time_zone_id, 213829200, 2)
,(@time_zone_id, 228866400, 1)
,(@time_zone_id, 243982800, 2)
,(@time_zone_id, 260316000, 1)
,(@time_zone_id, 276123600, 2)
,(@time_zone_id, 291765600, 1)
,(@time_zone_id, 307486800, 2)
,(@time_zone_id, 323820000, 1)
,(@time_zone_id, 338936400, 2)
,(@time_zone_id, 354664800, 1)
,(@time_zone_id, 370386000, 2)
,(@time_zone_id, 386114400, 1)
,(@time_zone_id, 401835600, 2)
,(@time_zone_id, 417564000, 1)
,(@time_zone_id, 433285200, 2)
,(@time_zone_id, 449013600, 1)
,(@time_zone_id, 465339600, 2)
,(@time_zone_id, 481068000, 1)
,(@time_zone_id, 496789200, 2)
,(@time_zone_id, 512517600, 1)
,(@time_zone_id, 528238800, 2)
,(@time_zone_id, 543967200, 1)
,(@time_zone_id, 559688400, 2)
,(@time_zone_id, 575416800, 1)
,(@time_zone_id, 591138000, 2)
,(@time_zone_id, 606866400, 1)
,(@time_zone_id, 622587600, 2)
,(@time_zone_id, 638316000, 1)
,(@time_zone_id, 654642000, 2)
,(@time_zone_id, 670370400, 1)
,(@time_zone_id, 686091600, 2)
,(@time_zone_id, 701820000, 1)
,(@time_zone_id, 717541200, 2)
,(@time_zone_id, 733269600, 1)
,(@time_zone_id, 748990800, 2)
,(@time_zone_id, 764719200, 1)
,(@time_zone_id, 780440400, 2)
,(@time_zone_id, 796168800, 1)
,(@time_zone_id, 811890000, 2)
,(@time_zone_id, 828223200, 1)
,(@time_zone_id, 843944400, 2)
,(@time_zone_id, 859672800, 1)
,(@time_zone_id, 875394000, 2)
,(@time_zone_id, 891122400, 1)
,(@time_zone_id, 909277200, 3)
,(@time_zone_id, 922582800, 4)
,(@time_zone_id, 941331600, 3)
,(@time_zone_id, 954032400, 4)
,(@time_zone_id, 972781200, 3)
,(@time_zone_id, 985482000, 4)
,(@time_zone_id, 1004230800, 3)
,(@time_zone_id, 1017536400, 4)
,(@time_zone_id, 1035680400, 3)
,(@time_zone_id, 1048986000, 4)
,(@time_zone_id, 1067130000, 3)
,(@time_zone_id, 1080435600, 4)
,(@time_zone_id, 1099184400, 3)
,(@time_zone_id, 1111885200, 4)
,(@time_zone_id, 1130634000, 3)
,(@time_zone_id, 1143334800, 4)
,(@time_zone_id, 1162083600, 3)
,(@time_zone_id, 1174784400, 4)
,(@time_zone_id, 1193533200, 3)
,(@time_zone_id, 1206838800, 4)
,(@time_zone_id, 1224982800, 3)
,(@time_zone_id, 1238288400, 4)
,(@time_zone_id, 1256432400, 3)
,(@time_zone_id, 1269738000, 4)
,(@time_zone_id, 1288486800, 3)
,(@time_zone_id, 1301187600, 4)
,(@time_zone_id, 1319936400, 3)
,(@time_zone_id, 1332637200, 4)
,(@time_zone_id, 1351386000, 3)
,(@time_zone_id, 1364691600, 4)
,(@time_zone_id, 1382835600, 3)
,(@time_zone_id, 1396141200, 4)
,(@time_zone_id, 1414285200, 3)
,(@time_zone_id, 1427590800, 4)
,(@time_zone_id, 1445734800, 3)
,(@time_zone_id, 1459040400, 4)
,(@time_zone_id, 1477789200, 3)
,(@time_zone_id, 1490490000, 4)
,(@time_zone_id, 1509238800, 3)
,(@time_zone_id, 1521939600, 4)
,(@time_zone_id, 1540688400, 3)
,(@time_zone_id, 1553994000, 4)
,(@time_zone_id, 1572138000, 3)
,(@time_zone_id, 1585443600, 4)
,(@time_zone_id, 1603587600, 3)
,(@time_zone_id, 1616893200, 4)
,(@time_zone_id, 1635642000, 3)
,(@time_zone_id, 1648342800, 4)
,(@time_zone_id, 1667091600, 3)
,(@time_zone_id, 1679792400, 4)
,(@time_zone_id, 1698541200, 3)
,(@time_zone_id, 1711846800, 4)
,(@time_zone_id, 1729990800, 3)
,(@time_zone_id, 1743296400, 4)
,(@time_zone_id, 1761440400, 3)
,(@time_zone_id, 1774746000, 4)
,(@time_zone_id, 1792890000, 3)
,(@time_zone_id, 1806195600, 4)
,(@time_zone_id, 1824944400, 3)
,(@time_zone_id, 1837645200, 4)
,(@time_zone_id, 1856394000, 3)
,(@time_zone_id, 1869094800, 4)
,(@time_zone_id, 1887843600, 3)
,(@time_zone_id, 1901149200, 4)
,(@time_zone_id, 1919293200, 3)
,(@time_zone_id, 1932598800, 4)
,(@time_zone_id, 1950742800, 3)
,(@time_zone_id, 1964048400, 4)
,(@time_zone_id, 1982797200, 3)
,(@time_zone_id, 1995498000, 4)
,(@time_zone_id, 2014246800, 3)
,(@time_zone_id, 2026947600, 4)
,(@time_zone_id, 2045696400, 3)
,(@time_zone_id, 2058397200, 4)
,(@time_zone_id, 2077146000, 3)
,(@time_zone_id, 2090451600, 4)
,(@time_zone_id, 2108595600, 3)
,(@time_zone_id, 2121901200, 4)
,(@time_zone_id, 2140045200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8008, 0, 'LMT')
,(@time_zone_id, 1, 10800, 1, 'EEST')
,(@time_zone_id, 2, 7200, 0, 'EET')
,(@time_zone_id, 3, 7200, 0, 'EET')
,(@time_zone_id, 4, 10800, 1, 'EEST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Novokuznetsk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441259328, 1)
,(@time_zone_id, -1247551200, 3)
,(@time_zone_id, 354906000, 2)
,(@time_zone_id, 370713600, 3)
,(@time_zone_id, 386442000, 2)
,(@time_zone_id, 402249600, 3)
,(@time_zone_id, 417978000, 2)
,(@time_zone_id, 433785600, 3)
,(@time_zone_id, 449600400, 2)
,(@time_zone_id, 465332400, 4)
,(@time_zone_id, 481057200, 5)
,(@time_zone_id, 496782000, 4)
,(@time_zone_id, 512506800, 5)
,(@time_zone_id, 528231600, 4)
,(@time_zone_id, 543956400, 5)
,(@time_zone_id, 559681200, 4)
,(@time_zone_id, 575406000, 5)
,(@time_zone_id, 591130800, 4)
,(@time_zone_id, 606855600, 5)
,(@time_zone_id, 622580400, 4)
,(@time_zone_id, 638305200, 5)
,(@time_zone_id, 654634800, 4)
,(@time_zone_id, 670359600, 6)
,(@time_zone_id, 686088000, 7)
,(@time_zone_id, 695764800, 4)
,(@time_zone_id, 701809200, 5)
,(@time_zone_id, 717534000, 4)
,(@time_zone_id, 733258800, 5)
,(@time_zone_id, 748983600, 4)
,(@time_zone_id, 764708400, 5)
,(@time_zone_id, 780433200, 4)
,(@time_zone_id, 796158000, 5)
,(@time_zone_id, 811882800, 4)
,(@time_zone_id, 828212400, 5)
,(@time_zone_id, 846356400, 4)
,(@time_zone_id, 859662000, 5)
,(@time_zone_id, 877806000, 4)
,(@time_zone_id, 891111600, 5)
,(@time_zone_id, 909255600, 4)
,(@time_zone_id, 922561200, 5)
,(@time_zone_id, 941310000, 4)
,(@time_zone_id, 954010800, 5)
,(@time_zone_id, 972759600, 4)
,(@time_zone_id, 985460400, 5)
,(@time_zone_id, 1004209200, 4)
,(@time_zone_id, 1017514800, 5)
,(@time_zone_id, 1035658800, 4)
,(@time_zone_id, 1048964400, 5)
,(@time_zone_id, 1067108400, 4)
,(@time_zone_id, 1080414000, 5)
,(@time_zone_id, 1099162800, 4)
,(@time_zone_id, 1111863600, 5)
,(@time_zone_id, 1130612400, 4)
,(@time_zone_id, 1143313200, 5)
,(@time_zone_id, 1162062000, 4)
,(@time_zone_id, 1174762800, 5)
,(@time_zone_id, 1193511600, 4)
,(@time_zone_id, 1206817200, 5)
,(@time_zone_id, 1224961200, 4)
,(@time_zone_id, 1238266800, 5)
,(@time_zone_id, 1256410800, 4)
,(@time_zone_id, 1269716400, 6)
,(@time_zone_id, 1288468800, 7)
,(@time_zone_id, 1301169600, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 20928, 0, 'LMT')
,(@time_zone_id, 1, 21600, 0, '+06')
,(@time_zone_id, 2, 28800, 1, '+08')
,(@time_zone_id, 3, 25200, 0, '+07')
,(@time_zone_id, 4, 25200, 0, '+07')
,(@time_zone_id, 5, 28800, 1, '+08')
,(@time_zone_id, 6, 25200, 1, '+07')
,(@time_zone_id, 7, 21600, 0, '+06')
,(@time_zone_id, 8, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Novosibirsk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1579476700, 1)
,(@time_zone_id, -1247551200, 3)
,(@time_zone_id, 354906000, 2)
,(@time_zone_id, 370713600, 3)
,(@time_zone_id, 386442000, 2)
,(@time_zone_id, 402249600, 3)
,(@time_zone_id, 417978000, 2)
,(@time_zone_id, 433785600, 3)
,(@time_zone_id, 449600400, 2)
,(@time_zone_id, 465332400, 4)
,(@time_zone_id, 481057200, 5)
,(@time_zone_id, 496782000, 4)
,(@time_zone_id, 512506800, 5)
,(@time_zone_id, 528231600, 4)
,(@time_zone_id, 543956400, 5)
,(@time_zone_id, 559681200, 4)
,(@time_zone_id, 575406000, 5)
,(@time_zone_id, 591130800, 4)
,(@time_zone_id, 606855600, 5)
,(@time_zone_id, 622580400, 4)
,(@time_zone_id, 638305200, 5)
,(@time_zone_id, 654634800, 4)
,(@time_zone_id, 670359600, 6)
,(@time_zone_id, 686088000, 7)
,(@time_zone_id, 695764800, 4)
,(@time_zone_id, 701809200, 5)
,(@time_zone_id, 717534000, 4)
,(@time_zone_id, 733258800, 5)
,(@time_zone_id, 738086400, 8)
,(@time_zone_id, 748987200, 7)
,(@time_zone_id, 764712000, 6)
,(@time_zone_id, 780436800, 7)
,(@time_zone_id, 796161600, 6)
,(@time_zone_id, 811886400, 7)
,(@time_zone_id, 828216000, 6)
,(@time_zone_id, 846360000, 7)
,(@time_zone_id, 859665600, 6)
,(@time_zone_id, 877809600, 7)
,(@time_zone_id, 891115200, 6)
,(@time_zone_id, 909259200, 7)
,(@time_zone_id, 922564800, 6)
,(@time_zone_id, 941313600, 7)
,(@time_zone_id, 954014400, 6)
,(@time_zone_id, 972763200, 7)
,(@time_zone_id, 985464000, 6)
,(@time_zone_id, 1004212800, 7)
,(@time_zone_id, 1017518400, 6)
,(@time_zone_id, 1035662400, 7)
,(@time_zone_id, 1048968000, 6)
,(@time_zone_id, 1067112000, 7)
,(@time_zone_id, 1080417600, 6)
,(@time_zone_id, 1099166400, 7)
,(@time_zone_id, 1111867200, 6)
,(@time_zone_id, 1130616000, 7)
,(@time_zone_id, 1143316800, 6)
,(@time_zone_id, 1162065600, 7)
,(@time_zone_id, 1174766400, 6)
,(@time_zone_id, 1193515200, 7)
,(@time_zone_id, 1206820800, 6)
,(@time_zone_id, 1224964800, 7)
,(@time_zone_id, 1238270400, 6)
,(@time_zone_id, 1256414400, 7)
,(@time_zone_id, 1269720000, 6)
,(@time_zone_id, 1288468800, 7)
,(@time_zone_id, 1301169600, 4)
,(@time_zone_id, 1414263600, 7)
,(@time_zone_id, 1469304000, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 19900, 0, 'LMT')
,(@time_zone_id, 1, 21600, 0, '+06')
,(@time_zone_id, 2, 28800, 1, '+08')
,(@time_zone_id, 3, 25200, 0, '+07')
,(@time_zone_id, 4, 25200, 0, '+07')
,(@time_zone_id, 5, 28800, 1, '+08')
,(@time_zone_id, 6, 25200, 1, '+07')
,(@time_zone_id, 7, 21600, 0, '+06')
,(@time_zone_id, 8, 25200, 1, '+07')
,(@time_zone_id, 9, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Omsk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1582088010, 1)
,(@time_zone_id, -1247547600, 3)
,(@time_zone_id, 354909600, 2)
,(@time_zone_id, 370717200, 3)
,(@time_zone_id, 386445600, 2)
,(@time_zone_id, 402253200, 3)
,(@time_zone_id, 417981600, 2)
,(@time_zone_id, 433789200, 3)
,(@time_zone_id, 449604000, 2)
,(@time_zone_id, 465336000, 4)
,(@time_zone_id, 481060800, 5)
,(@time_zone_id, 496785600, 4)
,(@time_zone_id, 512510400, 5)
,(@time_zone_id, 528235200, 4)
,(@time_zone_id, 543960000, 5)
,(@time_zone_id, 559684800, 4)
,(@time_zone_id, 575409600, 5)
,(@time_zone_id, 591134400, 4)
,(@time_zone_id, 606859200, 5)
,(@time_zone_id, 622584000, 4)
,(@time_zone_id, 638308800, 5)
,(@time_zone_id, 654638400, 4)
,(@time_zone_id, 670363200, 6)
,(@time_zone_id, 686091600, 7)
,(@time_zone_id, 695768400, 4)
,(@time_zone_id, 701812800, 5)
,(@time_zone_id, 717537600, 4)
,(@time_zone_id, 733262400, 5)
,(@time_zone_id, 748987200, 4)
,(@time_zone_id, 764712000, 5)
,(@time_zone_id, 780436800, 4)
,(@time_zone_id, 796161600, 5)
,(@time_zone_id, 811886400, 4)
,(@time_zone_id, 828216000, 5)
,(@time_zone_id, 846360000, 4)
,(@time_zone_id, 859665600, 5)
,(@time_zone_id, 877809600, 4)
,(@time_zone_id, 891115200, 5)
,(@time_zone_id, 909259200, 4)
,(@time_zone_id, 922564800, 5)
,(@time_zone_id, 941313600, 4)
,(@time_zone_id, 954014400, 5)
,(@time_zone_id, 972763200, 4)
,(@time_zone_id, 985464000, 5)
,(@time_zone_id, 1004212800, 4)
,(@time_zone_id, 1017518400, 5)
,(@time_zone_id, 1035662400, 4)
,(@time_zone_id, 1048968000, 5)
,(@time_zone_id, 1067112000, 4)
,(@time_zone_id, 1080417600, 5)
,(@time_zone_id, 1099166400, 4)
,(@time_zone_id, 1111867200, 5)
,(@time_zone_id, 1130616000, 4)
,(@time_zone_id, 1143316800, 5)
,(@time_zone_id, 1162065600, 4)
,(@time_zone_id, 1174766400, 5)
,(@time_zone_id, 1193515200, 4)
,(@time_zone_id, 1206820800, 5)
,(@time_zone_id, 1224964800, 4)
,(@time_zone_id, 1238270400, 5)
,(@time_zone_id, 1256414400, 4)
,(@time_zone_id, 1269720000, 5)
,(@time_zone_id, 1288468800, 4)
,(@time_zone_id, 1301169600, 8)
,(@time_zone_id, 1414263600, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 17610, 0, 'LMT')
,(@time_zone_id, 1, 18000, 0, '+05')
,(@time_zone_id, 2, 25200, 1, '+07')
,(@time_zone_id, 3, 21600, 0, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 25200, 1, '+07')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 0, '+05')
,(@time_zone_id, 8, 25200, 0, '+07')
,(@time_zone_id, 9, 25200, 1, '+07')
,(@time_zone_id, 10, 21600, 0, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Oral', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441164324, 1)
,(@time_zone_id, -1247540400, 2)
,(@time_zone_id, 354913200, 3)
,(@time_zone_id, 370720800, 4)
,(@time_zone_id, 386445600, 3)
,(@time_zone_id, 402256800, 2)
,(@time_zone_id, 417985200, 3)
,(@time_zone_id, 433792800, 2)
,(@time_zone_id, 449607600, 3)
,(@time_zone_id, 465339600, 5)
,(@time_zone_id, 481064400, 6)
,(@time_zone_id, 496789200, 5)
,(@time_zone_id, 512514000, 6)
,(@time_zone_id, 528238800, 5)
,(@time_zone_id, 543963600, 6)
,(@time_zone_id, 559688400, 5)
,(@time_zone_id, 575413200, 6)
,(@time_zone_id, 591138000, 5)
,(@time_zone_id, 606862800, 7)
,(@time_zone_id, 622591200, 8)
,(@time_zone_id, 638316000, 7)
,(@time_zone_id, 654645600, 8)
,(@time_zone_id, 670370400, 7)
,(@time_zone_id, 686095200, 8)
,(@time_zone_id, 695772000, 5)
,(@time_zone_id, 701816400, 7)
,(@time_zone_id, 717544800, 8)
,(@time_zone_id, 733269600, 7)
,(@time_zone_id, 748994400, 8)
,(@time_zone_id, 764719200, 7)
,(@time_zone_id, 780444000, 8)
,(@time_zone_id, 796168800, 7)
,(@time_zone_id, 811893600, 8)
,(@time_zone_id, 828223200, 7)
,(@time_zone_id, 846367200, 8)
,(@time_zone_id, 859672800, 7)
,(@time_zone_id, 877816800, 8)
,(@time_zone_id, 891122400, 7)
,(@time_zone_id, 909266400, 8)
,(@time_zone_id, 922572000, 7)
,(@time_zone_id, 941320800, 8)
,(@time_zone_id, 954021600, 7)
,(@time_zone_id, 972770400, 8)
,(@time_zone_id, 985471200, 7)
,(@time_zone_id, 1004220000, 8)
,(@time_zone_id, 1017525600, 7)
,(@time_zone_id, 1035669600, 8)
,(@time_zone_id, 1048975200, 7)
,(@time_zone_id, 1067119200, 8)
,(@time_zone_id, 1080424800, 7)
,(@time_zone_id, 1099173600, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 12324, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, '+03')
,(@time_zone_id, 2, 18000, 0, '+05')
,(@time_zone_id, 3, 21600, 1, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 18000, 0, '+05')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 1, '+05')
,(@time_zone_id, 8, 14400, 0, '+04')
,(@time_zone_id, 9, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Phnom_Penh', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1570084924, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 24124, 0, 'LMT')
,(@time_zone_id, 1, 24124, 0, 'BMT')
,(@time_zone_id, 2, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Pontianak', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1946186240, 1)
,(@time_zone_id, -1172906240, 2)
,(@time_zone_id, -881220600, 3)
,(@time_zone_id, -766054800, 2)
,(@time_zone_id, -683883000, 4)
,(@time_zone_id, -620812800, 2)
,(@time_zone_id, -189415800, 5)
,(@time_zone_id, 567964800, 6)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 26240, 0, 'LMT')
,(@time_zone_id, 1, 26240, 0, 'PMT')
,(@time_zone_id, 2, 27000, 0, '+0730')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 28800, 0, '+08')
,(@time_zone_id, 5, 28800, 0, 'WITA')
,(@time_zone_id, 6, 25200, 0, 'WIB')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Pyongyang', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1948782180, 1)
,(@time_zone_id, -1830414600, 2)
,(@time_zone_id, -768646800, 3)
,(@time_zone_id, 1439564400, 1)
,(@time_zone_id, 1525446000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 30180, 0, 'LMT')
,(@time_zone_id, 1, 30600, 0, 'KST')
,(@time_zone_id, 2, 32400, 0, 'JST')
,(@time_zone_id, 3, 32400, 0, 'KST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Qatar', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577935568, 1)
,(@time_zone_id, 76190400, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 12368, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 10800, 0, '+03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Qostanay', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441167268, 1)
,(@time_zone_id, -1247544000, 2)
,(@time_zone_id, 354913200, 3)
,(@time_zone_id, 370720800, 4)
,(@time_zone_id, 386445600, 3)
,(@time_zone_id, 402256800, 2)
,(@time_zone_id, 417985200, 3)
,(@time_zone_id, 433792800, 2)
,(@time_zone_id, 449607600, 3)
,(@time_zone_id, 465339600, 5)
,(@time_zone_id, 481064400, 6)
,(@time_zone_id, 496789200, 5)
,(@time_zone_id, 512514000, 6)
,(@time_zone_id, 528238800, 5)
,(@time_zone_id, 543963600, 6)
,(@time_zone_id, 559688400, 5)
,(@time_zone_id, 575413200, 6)
,(@time_zone_id, 591138000, 5)
,(@time_zone_id, 606862800, 6)
,(@time_zone_id, 622587600, 5)
,(@time_zone_id, 638312400, 6)
,(@time_zone_id, 654642000, 5)
,(@time_zone_id, 670366800, 7)
,(@time_zone_id, 686095200, 8)
,(@time_zone_id, 695772000, 5)
,(@time_zone_id, 701816400, 6)
,(@time_zone_id, 717541200, 5)
,(@time_zone_id, 733266000, 6)
,(@time_zone_id, 748990800, 5)
,(@time_zone_id, 764715600, 6)
,(@time_zone_id, 780440400, 5)
,(@time_zone_id, 796165200, 6)
,(@time_zone_id, 811890000, 5)
,(@time_zone_id, 828219600, 6)
,(@time_zone_id, 846363600, 5)
,(@time_zone_id, 859669200, 6)
,(@time_zone_id, 877813200, 5)
,(@time_zone_id, 891118800, 6)
,(@time_zone_id, 909262800, 5)
,(@time_zone_id, 922568400, 6)
,(@time_zone_id, 941317200, 5)
,(@time_zone_id, 954018000, 6)
,(@time_zone_id, 972766800, 5)
,(@time_zone_id, 985467600, 6)
,(@time_zone_id, 1004216400, 5)
,(@time_zone_id, 1017522000, 6)
,(@time_zone_id, 1035666000, 5)
,(@time_zone_id, 1048971600, 6)
,(@time_zone_id, 1067115600, 5)
,(@time_zone_id, 1080421200, 6)
,(@time_zone_id, 1099170000, 9)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 15268, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 18000, 0, '+05')
,(@time_zone_id, 3, 21600, 1, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 18000, 0, '+05')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 1, '+05')
,(@time_zone_id, 8, 14400, 0, '+04')
,(@time_zone_id, 9, 21600, 0, '+06')
,(@time_zone_id, 10, 21600, 1, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Qyzylorda', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441167712, 1)
,(@time_zone_id, -1247544000, 2)
,(@time_zone_id, 354913200, 3)
,(@time_zone_id, 370720800, 4)
,(@time_zone_id, 386445600, 3)
,(@time_zone_id, 402256800, 2)
,(@time_zone_id, 417985200, 3)
,(@time_zone_id, 433792800, 2)
,(@time_zone_id, 449607600, 3)
,(@time_zone_id, 465339600, 5)
,(@time_zone_id, 481064400, 6)
,(@time_zone_id, 496789200, 5)
,(@time_zone_id, 512514000, 6)
,(@time_zone_id, 528238800, 5)
,(@time_zone_id, 543963600, 6)
,(@time_zone_id, 559688400, 5)
,(@time_zone_id, 575413200, 6)
,(@time_zone_id, 591138000, 5)
,(@time_zone_id, 606862800, 6)
,(@time_zone_id, 622587600, 5)
,(@time_zone_id, 638312400, 6)
,(@time_zone_id, 654642000, 5)
,(@time_zone_id, 670366800, 7)
,(@time_zone_id, 686095200, 5)
,(@time_zone_id, 695768400, 9)
,(@time_zone_id, 701812800, 6)
,(@time_zone_id, 717541200, 5)
,(@time_zone_id, 733266000, 6)
,(@time_zone_id, 748990800, 5)
,(@time_zone_id, 764715600, 6)
,(@time_zone_id, 780440400, 5)
,(@time_zone_id, 796165200, 6)
,(@time_zone_id, 811890000, 5)
,(@time_zone_id, 828219600, 6)
,(@time_zone_id, 846363600, 5)
,(@time_zone_id, 859669200, 6)
,(@time_zone_id, 877813200, 5)
,(@time_zone_id, 891118800, 6)
,(@time_zone_id, 909262800, 5)
,(@time_zone_id, 922568400, 6)
,(@time_zone_id, 941317200, 5)
,(@time_zone_id, 954018000, 6)
,(@time_zone_id, 972766800, 5)
,(@time_zone_id, 985467600, 6)
,(@time_zone_id, 1004216400, 5)
,(@time_zone_id, 1017522000, 6)
,(@time_zone_id, 1035666000, 5)
,(@time_zone_id, 1048971600, 6)
,(@time_zone_id, 1067115600, 5)
,(@time_zone_id, 1080421200, 6)
,(@time_zone_id, 1099170000, 9)
,(@time_zone_id, 1545328800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 15712, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 18000, 0, '+05')
,(@time_zone_id, 3, 21600, 1, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 18000, 0, '+05')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 1, '+05')
,(@time_zone_id, 8, 14400, 0, '+04')
,(@time_zone_id, 9, 21600, 0, '+06')
,(@time_zone_id, 10, 21600, 1, '+06')
,(@time_zone_id, 11, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Rangoon', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1577946287, 2)
,(@time_zone_id, -873268200, 3)
,(@time_zone_id, -778410000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 23087, 0, 'LMT')
,(@time_zone_id, 1, 23087, 0, 'RMT')
,(@time_zone_id, 2, 23400, 0, '+0630')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 23400, 0, '+0630')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Riyadh', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -719636812, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 11212, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, '+03')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Saigon', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2004073600, 1)
,(@time_zone_id, -1851577590, 2)
,(@time_zone_id, -852105600, 3)
,(@time_zone_id, -782643600, 4)
,(@time_zone_id, -767869200, 2)
,(@time_zone_id, -718095600, 3)
,(@time_zone_id, -457776000, 2)
,(@time_zone_id, -315648000, 3)
,(@time_zone_id, 171820800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 25600, 0, 'LMT')
,(@time_zone_id, 1, 25590, 0, 'PLMT')
,(@time_zone_id, 2, 25200, 0, '+07')
,(@time_zone_id, 3, 28800, 0, '+08')
,(@time_zone_id, 4, 32400, 0, '+09')
,(@time_zone_id, 5, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Sakhalin', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2031039048, 1)
,(@time_zone_id, -768560400, 3)
,(@time_zone_id, 354891600, 2)
,(@time_zone_id, 370699200, 3)
,(@time_zone_id, 386427600, 2)
,(@time_zone_id, 402235200, 3)
,(@time_zone_id, 417963600, 2)
,(@time_zone_id, 433771200, 3)
,(@time_zone_id, 449586000, 2)
,(@time_zone_id, 465318000, 4)
,(@time_zone_id, 481042800, 5)
,(@time_zone_id, 496767600, 4)
,(@time_zone_id, 512492400, 5)
,(@time_zone_id, 528217200, 4)
,(@time_zone_id, 543942000, 5)
,(@time_zone_id, 559666800, 4)
,(@time_zone_id, 575391600, 5)
,(@time_zone_id, 591116400, 4)
,(@time_zone_id, 606841200, 5)
,(@time_zone_id, 622566000, 4)
,(@time_zone_id, 638290800, 5)
,(@time_zone_id, 654620400, 4)
,(@time_zone_id, 670345200, 6)
,(@time_zone_id, 686073600, 7)
,(@time_zone_id, 695750400, 4)
,(@time_zone_id, 701794800, 5)
,(@time_zone_id, 717519600, 4)
,(@time_zone_id, 733244400, 5)
,(@time_zone_id, 748969200, 4)
,(@time_zone_id, 764694000, 5)
,(@time_zone_id, 780418800, 4)
,(@time_zone_id, 796143600, 5)
,(@time_zone_id, 811868400, 4)
,(@time_zone_id, 828198000, 5)
,(@time_zone_id, 846342000, 4)
,(@time_zone_id, 859647600, 6)
,(@time_zone_id, 877795200, 7)
,(@time_zone_id, 891100800, 6)
,(@time_zone_id, 909244800, 7)
,(@time_zone_id, 922550400, 6)
,(@time_zone_id, 941299200, 7)
,(@time_zone_id, 954000000, 6)
,(@time_zone_id, 972748800, 7)
,(@time_zone_id, 985449600, 6)
,(@time_zone_id, 1004198400, 7)
,(@time_zone_id, 1017504000, 6)
,(@time_zone_id, 1035648000, 7)
,(@time_zone_id, 1048953600, 6)
,(@time_zone_id, 1067097600, 7)
,(@time_zone_id, 1080403200, 6)
,(@time_zone_id, 1099152000, 7)
,(@time_zone_id, 1111852800, 6)
,(@time_zone_id, 1130601600, 7)
,(@time_zone_id, 1143302400, 6)
,(@time_zone_id, 1162051200, 7)
,(@time_zone_id, 1174752000, 6)
,(@time_zone_id, 1193500800, 7)
,(@time_zone_id, 1206806400, 6)
,(@time_zone_id, 1224950400, 7)
,(@time_zone_id, 1238256000, 6)
,(@time_zone_id, 1256400000, 7)
,(@time_zone_id, 1269705600, 6)
,(@time_zone_id, 1288454400, 7)
,(@time_zone_id, 1301155200, 4)
,(@time_zone_id, 1414249200, 7)
,(@time_zone_id, 1459008000, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 34248, 0, 'LMT')
,(@time_zone_id, 1, 32400, 0, '+09')
,(@time_zone_id, 2, 43200, 1, '+12')
,(@time_zone_id, 3, 39600, 0, '+11')
,(@time_zone_id, 4, 39600, 0, '+11')
,(@time_zone_id, 5, 43200, 1, '+12')
,(@time_zone_id, 6, 39600, 1, '+11')
,(@time_zone_id, 7, 36000, 0, '+10')
,(@time_zone_id, 8, 39600, 0, '+11')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Samarkand', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441168073, 1)
,(@time_zone_id, -1247544000, 2)
,(@time_zone_id, 354913200, 3)
,(@time_zone_id, 370720800, 4)
,(@time_zone_id, 386445600, 3)
,(@time_zone_id, 402256800, 2)
,(@time_zone_id, 417985200, 3)
,(@time_zone_id, 433792800, 2)
,(@time_zone_id, 449607600, 3)
,(@time_zone_id, 465339600, 5)
,(@time_zone_id, 481064400, 6)
,(@time_zone_id, 496789200, 5)
,(@time_zone_id, 512514000, 6)
,(@time_zone_id, 528238800, 5)
,(@time_zone_id, 543963600, 6)
,(@time_zone_id, 559688400, 5)
,(@time_zone_id, 575413200, 6)
,(@time_zone_id, 591138000, 5)
,(@time_zone_id, 606862800, 6)
,(@time_zone_id, 622587600, 5)
,(@time_zone_id, 638312400, 6)
,(@time_zone_id, 654642000, 5)
,(@time_zone_id, 670366800, 6)
,(@time_zone_id, 686091600, 5)
,(@time_zone_id, 694206000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 16073, 0, 'LMT')
,(@time_zone_id, 1, 14400, 0, '+04')
,(@time_zone_id, 2, 18000, 0, '+05')
,(@time_zone_id, 3, 21600, 1, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 18000, 0, '+05')
,(@time_zone_id, 6, 21600, 1, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Seoul', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1948782472, 1)
,(@time_zone_id, -1830414600, 2)
,(@time_zone_id, -767350800, 3)
,(@time_zone_id, -498128400, 1)
,(@time_zone_id, -462702600, 4)
,(@time_zone_id, -451733400, 1)
,(@time_zone_id, -429784200, 4)
,(@time_zone_id, -418296600, 1)
,(@time_zone_id, -399544200, 4)
,(@time_zone_id, -387451800, 1)
,(@time_zone_id, -368094600, 4)
,(@time_zone_id, -356002200, 1)
,(@time_zone_id, -336645000, 4)
,(@time_zone_id, -324552600, 1)
,(@time_zone_id, -305195400, 4)
,(@time_zone_id, -293103000, 1)
,(@time_zone_id, -264933000, 3)
,(@time_zone_id, 547578000, 5)
,(@time_zone_id, 560883600, 3)
,(@time_zone_id, 579027600, 5)
,(@time_zone_id, 592333200, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 30472, 0, 'LMT')
,(@time_zone_id, 1, 30600, 0, 'KST')
,(@time_zone_id, 2, 32400, 0, 'JST')
,(@time_zone_id, 3, 32400, 0, 'KST')
,(@time_zone_id, 4, 34200, 1, 'KDT')
,(@time_zone_id, 5, 36000, 1, 'KDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Shanghai', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 2)
,(@time_zone_id, -933667200, 1)
,(@time_zone_id, -922093200, 2)
,(@time_zone_id, -908870400, 1)
,(@time_zone_id, -888829200, 2)
,(@time_zone_id, -881049600, 1)
,(@time_zone_id, -767869200, 2)
,(@time_zone_id, -745833600, 1)
,(@time_zone_id, -733827600, 2)
,(@time_zone_id, -716889600, 1)
,(@time_zone_id, -699613200, 2)
,(@time_zone_id, -683884800, 1)
,(@time_zone_id, -670669200, 2)
,(@time_zone_id, -652348800, 1)
,(@time_zone_id, -650019600, 2)
,(@time_zone_id, 515527200, 1)
,(@time_zone_id, 527014800, 2)
,(@time_zone_id, 545162400, 1)
,(@time_zone_id, 558464400, 2)
,(@time_zone_id, 577216800, 1)
,(@time_zone_id, 589914000, 2)
,(@time_zone_id, 608666400, 1)
,(@time_zone_id, 621968400, 2)
,(@time_zone_id, 640116000, 1)
,(@time_zone_id, 653418000, 2)
,(@time_zone_id, 671565600, 1)
,(@time_zone_id, 684867600, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 29143, 0, 'LMT')
,(@time_zone_id, 1, 32400, 1, 'CDT')
,(@time_zone_id, 2, 28800, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Singapore', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -2038200925, 2)
,(@time_zone_id, -1167634800, 3)
,(@time_zone_id, -1073028000, 4)
,(@time_zone_id, -894180000, 5)
,(@time_zone_id, -879665400, 6)
,(@time_zone_id, -767005200, 5)
,(@time_zone_id, 378664200, 7)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 24925, 0, 'LMT')
,(@time_zone_id, 1, 24925, 0, 'SMT')
,(@time_zone_id, 2, 25200, 0, '+07')
,(@time_zone_id, 3, 26400, 1, '+0720')
,(@time_zone_id, 4, 26400, 0, '+0720')
,(@time_zone_id, 5, 27000, 0, '+0730')
,(@time_zone_id, 6, 32400, 0, '+09')
,(@time_zone_id, 7, 28800, 0, '+08')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Srednekolymsk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441188892, 1)
,(@time_zone_id, -1247565600, 3)
,(@time_zone_id, 354891600, 2)
,(@time_zone_id, 370699200, 3)
,(@time_zone_id, 386427600, 2)
,(@time_zone_id, 402235200, 3)
,(@time_zone_id, 417963600, 2)
,(@time_zone_id, 433771200, 3)
,(@time_zone_id, 449586000, 2)
,(@time_zone_id, 465318000, 4)
,(@time_zone_id, 481042800, 5)
,(@time_zone_id, 496767600, 4)
,(@time_zone_id, 512492400, 5)
,(@time_zone_id, 528217200, 4)
,(@time_zone_id, 543942000, 5)
,(@time_zone_id, 559666800, 4)
,(@time_zone_id, 575391600, 5)
,(@time_zone_id, 591116400, 4)
,(@time_zone_id, 606841200, 5)
,(@time_zone_id, 622566000, 4)
,(@time_zone_id, 638290800, 5)
,(@time_zone_id, 654620400, 4)
,(@time_zone_id, 670345200, 6)
,(@time_zone_id, 686073600, 7)
,(@time_zone_id, 695750400, 4)
,(@time_zone_id, 701794800, 5)
,(@time_zone_id, 717519600, 4)
,(@time_zone_id, 733244400, 5)
,(@time_zone_id, 748969200, 4)
,(@time_zone_id, 764694000, 5)
,(@time_zone_id, 780418800, 4)
,(@time_zone_id, 796143600, 5)
,(@time_zone_id, 811868400, 4)
,(@time_zone_id, 828198000, 5)
,(@time_zone_id, 846342000, 4)
,(@time_zone_id, 859647600, 5)
,(@time_zone_id, 877791600, 4)
,(@time_zone_id, 891097200, 5)
,(@time_zone_id, 909241200, 4)
,(@time_zone_id, 922546800, 5)
,(@time_zone_id, 941295600, 4)
,(@time_zone_id, 953996400, 5)
,(@time_zone_id, 972745200, 4)
,(@time_zone_id, 985446000, 5)
,(@time_zone_id, 1004194800, 4)
,(@time_zone_id, 1017500400, 5)
,(@time_zone_id, 1035644400, 4)
,(@time_zone_id, 1048950000, 5)
,(@time_zone_id, 1067094000, 4)
,(@time_zone_id, 1080399600, 5)
,(@time_zone_id, 1099148400, 4)
,(@time_zone_id, 1111849200, 5)
,(@time_zone_id, 1130598000, 4)
,(@time_zone_id, 1143298800, 5)
,(@time_zone_id, 1162047600, 4)
,(@time_zone_id, 1174748400, 5)
,(@time_zone_id, 1193497200, 4)
,(@time_zone_id, 1206802800, 5)
,(@time_zone_id, 1224946800, 4)
,(@time_zone_id, 1238252400, 5)
,(@time_zone_id, 1256396400, 4)
,(@time_zone_id, 1269702000, 5)
,(@time_zone_id, 1288450800, 4)
,(@time_zone_id, 1301151600, 8)
,(@time_zone_id, 1414245600, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 36892, 0, 'LMT')
,(@time_zone_id, 1, 36000, 0, '+10')
,(@time_zone_id, 2, 43200, 1, '+12')
,(@time_zone_id, 3, 39600, 0, '+11')
,(@time_zone_id, 4, 39600, 0, '+11')
,(@time_zone_id, 5, 43200, 1, '+12')
,(@time_zone_id, 6, 39600, 1, '+11')
,(@time_zone_id, 7, 36000, 0, '+10')
,(@time_zone_id, 8, 43200, 0, '+12')
,(@time_zone_id, 9, 43200, 1, '+12')
,(@time_zone_id, 10, 39600, 0, '+11')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Taipei', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1017820800, 2)
,(@time_zone_id, -766224000, 1)
,(@time_zone_id, -745833600, 3)
,(@time_zone_id, -733827600, 1)
,(@time_zone_id, -716889600, 3)
,(@time_zone_id, -699613200, 1)
,(@time_zone_id, -683884800, 3)
,(@time_zone_id, -670669200, 1)
,(@time_zone_id, -652348800, 3)
,(@time_zone_id, -639133200, 1)
,(@time_zone_id, -620812800, 3)
,(@time_zone_id, -607597200, 1)
,(@time_zone_id, -589276800, 3)
,(@time_zone_id, -576061200, 1)
,(@time_zone_id, -562924800, 3)
,(@time_zone_id, -541760400, 1)
,(@time_zone_id, -528710400, 3)
,(@time_zone_id, -510224400, 1)
,(@time_zone_id, -497174400, 3)
,(@time_zone_id, -478688400, 1)
,(@time_zone_id, -465638400, 3)
,(@time_zone_id, -449830800, 1)
,(@time_zone_id, -434016000, 3)
,(@time_zone_id, -418208400, 1)
,(@time_zone_id, -402480000, 3)
,(@time_zone_id, -386672400, 1)
,(@time_zone_id, -370944000, 3)
,(@time_zone_id, -355136400, 1)
,(@time_zone_id, -339408000, 3)
,(@time_zone_id, -323600400, 1)
,(@time_zone_id, -302515200, 3)
,(@time_zone_id, -291978000, 1)
,(@time_zone_id, -270979200, 3)
,(@time_zone_id, -260442000, 1)
,(@time_zone_id, 133977600, 3)
,(@time_zone_id, 149785200, 1)
,(@time_zone_id, 165513600, 3)
,(@time_zone_id, 181321200, 1)
,(@time_zone_id, 299606400, 3)
,(@time_zone_id, 307551600, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 29160, 0, 'LMT')
,(@time_zone_id, 1, 28800, 0, 'CST')
,(@time_zone_id, 2, 32400, 0, 'JST')
,(@time_zone_id, 3, 32400, 1, 'CDT')
,(@time_zone_id, 4, 28800, 0, 'CST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Tashkent', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441168631, 1)
,(@time_zone_id, -1247547600, 3)
,(@time_zone_id, 354909600, 2)
,(@time_zone_id, 370717200, 3)
,(@time_zone_id, 386445600, 2)
,(@time_zone_id, 402253200, 3)
,(@time_zone_id, 417981600, 2)
,(@time_zone_id, 433789200, 3)
,(@time_zone_id, 449604000, 2)
,(@time_zone_id, 465336000, 4)
,(@time_zone_id, 481060800, 5)
,(@time_zone_id, 496785600, 4)
,(@time_zone_id, 512510400, 5)
,(@time_zone_id, 528235200, 4)
,(@time_zone_id, 543960000, 5)
,(@time_zone_id, 559684800, 4)
,(@time_zone_id, 575409600, 5)
,(@time_zone_id, 591134400, 4)
,(@time_zone_id, 606859200, 5)
,(@time_zone_id, 622584000, 4)
,(@time_zone_id, 638308800, 5)
,(@time_zone_id, 654638400, 4)
,(@time_zone_id, 670363200, 6)
,(@time_zone_id, 686091600, 7)
,(@time_zone_id, 694206000, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 16631, 0, 'LMT')
,(@time_zone_id, 1, 18000, 0, '+05')
,(@time_zone_id, 2, 25200, 1, '+07')
,(@time_zone_id, 3, 21600, 0, '+06')
,(@time_zone_id, 4, 21600, 0, '+06')
,(@time_zone_id, 5, 25200, 1, '+07')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Tbilisi', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1441162751, 2)
,(@time_zone_id, -405140400, 4)
,(@time_zone_id, 354916800, 3)
,(@time_zone_id, 370724400, 4)
,(@time_zone_id, 386452800, 3)
,(@time_zone_id, 402260400, 4)
,(@time_zone_id, 417988800, 3)
,(@time_zone_id, 433796400, 4)
,(@time_zone_id, 449611200, 3)
,(@time_zone_id, 465343200, 5)
,(@time_zone_id, 481068000, 6)
,(@time_zone_id, 496792800, 5)
,(@time_zone_id, 512517600, 6)
,(@time_zone_id, 528242400, 5)
,(@time_zone_id, 543967200, 6)
,(@time_zone_id, 559692000, 5)
,(@time_zone_id, 575416800, 6)
,(@time_zone_id, 591141600, 5)
,(@time_zone_id, 606866400, 6)
,(@time_zone_id, 622591200, 5)
,(@time_zone_id, 638316000, 6)
,(@time_zone_id, 654645600, 5)
,(@time_zone_id, 670370400, 7)
,(@time_zone_id, 686098800, 8)
,(@time_zone_id, 694213200, 2)
,(@time_zone_id, 701816400, 9)
,(@time_zone_id, 717537600, 2)
,(@time_zone_id, 733266000, 9)
,(@time_zone_id, 748987200, 2)
,(@time_zone_id, 764715600, 9)
,(@time_zone_id, 780436800, 4)
,(@time_zone_id, 796161600, 3)
,(@time_zone_id, 811882800, 4)
,(@time_zone_id, 828216000, 3)
,(@time_zone_id, 859662000, 3)
,(@time_zone_id, 877806000, 4)
,(@time_zone_id, 891115200, 3)
,(@time_zone_id, 909255600, 4)
,(@time_zone_id, 922564800, 3)
,(@time_zone_id, 941310000, 4)
,(@time_zone_id, 954014400, 3)
,(@time_zone_id, 972759600, 4)
,(@time_zone_id, 985464000, 3)
,(@time_zone_id, 1004209200, 4)
,(@time_zone_id, 1017518400, 3)
,(@time_zone_id, 1035658800, 4)
,(@time_zone_id, 1048968000, 3)
,(@time_zone_id, 1067108400, 4)
,(@time_zone_id, 1080417600, 3)
,(@time_zone_id, 1088276400, 9)
,(@time_zone_id, 1099177200, 8)
,(@time_zone_id, 1111878000, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 10751, 0, 'LMT')
,(@time_zone_id, 1, 10751, 0, 'TBMT')
,(@time_zone_id, 2, 10800, 0, '+03')
,(@time_zone_id, 3, 18000, 1, '+05')
,(@time_zone_id, 4, 14400, 0, '+04')
,(@time_zone_id, 5, 14400, 0, '+04')
,(@time_zone_id, 6, 18000, 1, '+05')
,(@time_zone_id, 7, 14400, 1, '+04')
,(@time_zone_id, 8, 10800, 0, '+03')
,(@time_zone_id, 9, 14400, 1, '+04')
,(@time_zone_id, 10, 14400, 0, '+04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Tehran', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1704165944, 1)
,(@time_zone_id, -757394744, 2)
,(@time_zone_id, 247177800, 4)
,(@time_zone_id, 259272000, 3)
,(@time_zone_id, 277758000, 4)
,(@time_zone_id, 283982400, 2)
,(@time_zone_id, 290809800, 5)
,(@time_zone_id, 306531000, 2)
,(@time_zone_id, 322432200, 5)
,(@time_zone_id, 338499000, 2)
,(@time_zone_id, 673216200, 5)
,(@time_zone_id, 685481400, 2)
,(@time_zone_id, 701209800, 5)
,(@time_zone_id, 717103800, 2)
,(@time_zone_id, 732745800, 5)
,(@time_zone_id, 748639800, 2)
,(@time_zone_id, 764281800, 5)
,(@time_zone_id, 780175800, 2)
,(@time_zone_id, 795817800, 5)
,(@time_zone_id, 811711800, 2)
,(@time_zone_id, 827353800, 5)
,(@time_zone_id, 843247800, 2)
,(@time_zone_id, 858976200, 5)
,(@time_zone_id, 874870200, 2)
,(@time_zone_id, 890512200, 5)
,(@time_zone_id, 906406200, 2)
,(@time_zone_id, 922048200, 5)
,(@time_zone_id, 937942200, 2)
,(@time_zone_id, 953584200, 5)
,(@time_zone_id, 969478200, 2)
,(@time_zone_id, 985206600, 5)
,(@time_zone_id, 1001100600, 2)
,(@time_zone_id, 1016742600, 5)
,(@time_zone_id, 1032636600, 2)
,(@time_zone_id, 1048278600, 5)
,(@time_zone_id, 1064172600, 2)
,(@time_zone_id, 1079814600, 5)
,(@time_zone_id, 1095708600, 2)
,(@time_zone_id, 1111437000, 5)
,(@time_zone_id, 1127331000, 2)
,(@time_zone_id, 1206045000, 5)
,(@time_zone_id, 1221939000, 2)
,(@time_zone_id, 1237667400, 5)
,(@time_zone_id, 1253561400, 2)
,(@time_zone_id, 1269203400, 5)
,(@time_zone_id, 1285097400, 2)
,(@time_zone_id, 1300739400, 5)
,(@time_zone_id, 1316633400, 2)
,(@time_zone_id, 1332275400, 5)
,(@time_zone_id, 1348169400, 2)
,(@time_zone_id, 1363897800, 5)
,(@time_zone_id, 1379791800, 2)
,(@time_zone_id, 1395433800, 5)
,(@time_zone_id, 1411327800, 2)
,(@time_zone_id, 1426969800, 5)
,(@time_zone_id, 1442863800, 2)
,(@time_zone_id, 1458505800, 5)
,(@time_zone_id, 1474399800, 2)
,(@time_zone_id, 1490128200, 5)
,(@time_zone_id, 1506022200, 2)
,(@time_zone_id, 1521664200, 5)
,(@time_zone_id, 1537558200, 2)
,(@time_zone_id, 1553200200, 5)
,(@time_zone_id, 1569094200, 2)
,(@time_zone_id, 1584736200, 5)
,(@time_zone_id, 1600630200, 2)
,(@time_zone_id, 1616358600, 5)
,(@time_zone_id, 1632252600, 2)
,(@time_zone_id, 1647894600, 5)
,(@time_zone_id, 1663788600, 2)
,(@time_zone_id, 1679430600, 5)
,(@time_zone_id, 1695324600, 2)
,(@time_zone_id, 1710966600, 5)
,(@time_zone_id, 1726860600, 2)
,(@time_zone_id, 1742589000, 5)
,(@time_zone_id, 1758483000, 2)
,(@time_zone_id, 1774125000, 5)
,(@time_zone_id, 1790019000, 2)
,(@time_zone_id, 1805661000, 5)
,(@time_zone_id, 1821555000, 2)
,(@time_zone_id, 1837197000, 5)
,(@time_zone_id, 1853091000, 2)
,(@time_zone_id, 1868733000, 5)
,(@time_zone_id, 1884627000, 2)
,(@time_zone_id, 1900355400, 5)
,(@time_zone_id, 1916249400, 2)
,(@time_zone_id, 1931891400, 5)
,(@time_zone_id, 1947785400, 2)
,(@time_zone_id, 1963427400, 5)
,(@time_zone_id, 1979321400, 2)
,(@time_zone_id, 1994963400, 5)
,(@time_zone_id, 2010857400, 2)
,(@time_zone_id, 2026585800, 5)
,(@time_zone_id, 2042479800, 2)
,(@time_zone_id, 2058121800, 5)
,(@time_zone_id, 2074015800, 2)
,(@time_zone_id, 2089657800, 5)
,(@time_zone_id, 2105551800, 2)
,(@time_zone_id, 2121193800, 5)
,(@time_zone_id, 2137087800, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 12344, 0, 'LMT')
,(@time_zone_id, 1, 12344, 0, 'TMT')
,(@time_zone_id, 2, 12600, 0, '+0330')
,(@time_zone_id, 3, 18000, 1, '+05')
,(@time_zone_id, 4, 14400, 0, '+04')
,(@time_zone_id, 5, 16200, 1, '+0430')
,(@time_zone_id, 6, 12600, 0, '+0330')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Tel_Aviv', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1641003640, 3)
,(@time_zone_id, -933645600, 2)
,(@time_zone_id, -857358000, 3)
,(@time_zone_id, -844300800, 2)
,(@time_zone_id, -825822000, 3)
,(@time_zone_id, -812685600, 2)
,(@time_zone_id, -794199600, 3)
,(@time_zone_id, -779853600, 2)
,(@time_zone_id, -762656400, 3)
,(@time_zone_id, -748310400, 2)
,(@time_zone_id, -731127600, 3)
,(@time_zone_id, -681962400, 4)
,(@time_zone_id, -673243200, 2)
,(@time_zone_id, -667962000, 3)
,(@time_zone_id, -652327200, 2)
,(@time_zone_id, -636426000, 3)
,(@time_zone_id, -622087200, 2)
,(@time_zone_id, -608947200, 3)
,(@time_zone_id, -591847200, 2)
,(@time_zone_id, -572486400, 3)
,(@time_zone_id, -558576000, 2)
,(@time_zone_id, -542851200, 3)
,(@time_zone_id, -527731200, 2)
,(@time_zone_id, -514425600, 3)
,(@time_zone_id, -490845600, 2)
,(@time_zone_id, -482986800, 3)
,(@time_zone_id, -459475200, 2)
,(@time_zone_id, -451537200, 3)
,(@time_zone_id, -428551200, 2)
,(@time_zone_id, -418262400, 3)
,(@time_zone_id, -400032000, 2)
,(@time_zone_id, -387428400, 3)
,(@time_zone_id, 142380000, 2)
,(@time_zone_id, 150843600, 3)
,(@time_zone_id, 167176800, 2)
,(@time_zone_id, 178664400, 3)
,(@time_zone_id, 482277600, 2)
,(@time_zone_id, 495579600, 3)
,(@time_zone_id, 516751200, 2)
,(@time_zone_id, 526424400, 3)
,(@time_zone_id, 545436000, 2)
,(@time_zone_id, 558478800, 3)
,(@time_zone_id, 576626400, 2)
,(@time_zone_id, 589323600, 3)
,(@time_zone_id, 609890400, 2)
,(@time_zone_id, 620773200, 3)
,(@time_zone_id, 638316000, 2)
,(@time_zone_id, 651618000, 3)
,(@time_zone_id, 669765600, 2)
,(@time_zone_id, 683672400, 3)
,(@time_zone_id, 701820000, 2)
,(@time_zone_id, 715726800, 3)
,(@time_zone_id, 733701600, 2)
,(@time_zone_id, 747176400, 3)
,(@time_zone_id, 765151200, 2)
,(@time_zone_id, 778021200, 3)
,(@time_zone_id, 796600800, 2)
,(@time_zone_id, 810075600, 3)
,(@time_zone_id, 826840800, 2)
,(@time_zone_id, 842821200, 3)
,(@time_zone_id, 858895200, 2)
,(@time_zone_id, 874184400, 3)
,(@time_zone_id, 890344800, 2)
,(@time_zone_id, 905029200, 3)
,(@time_zone_id, 923011200, 2)
,(@time_zone_id, 936313200, 3)
,(@time_zone_id, 955670400, 2)
,(@time_zone_id, 970783200, 3)
,(@time_zone_id, 986770800, 2)
,(@time_zone_id, 1001282400, 3)
,(@time_zone_id, 1017356400, 2)
,(@time_zone_id, 1033941600, 3)
,(@time_zone_id, 1048806000, 2)
,(@time_zone_id, 1065132000, 3)
,(@time_zone_id, 1081292400, 2)
,(@time_zone_id, 1095804000, 3)
,(@time_zone_id, 1112313600, 2)
,(@time_zone_id, 1128812400, 3)
,(@time_zone_id, 1143763200, 2)
,(@time_zone_id, 1159657200, 3)
,(@time_zone_id, 1175212800, 2)
,(@time_zone_id, 1189897200, 3)
,(@time_zone_id, 1206662400, 2)
,(@time_zone_id, 1223161200, 3)
,(@time_zone_id, 1238112000, 2)
,(@time_zone_id, 1254006000, 3)
,(@time_zone_id, 1269561600, 2)
,(@time_zone_id, 1284246000, 3)
,(@time_zone_id, 1301616000, 2)
,(@time_zone_id, 1317510000, 3)
,(@time_zone_id, 1333065600, 2)
,(@time_zone_id, 1348354800, 3)
,(@time_zone_id, 1364515200, 2)
,(@time_zone_id, 1382828400, 3)
,(@time_zone_id, 1395964800, 2)
,(@time_zone_id, 1414278000, 3)
,(@time_zone_id, 1427414400, 2)
,(@time_zone_id, 1445727600, 3)
,(@time_zone_id, 1458864000, 2)
,(@time_zone_id, 1477782000, 3)
,(@time_zone_id, 1490313600, 2)
,(@time_zone_id, 1509231600, 3)
,(@time_zone_id, 1521763200, 2)
,(@time_zone_id, 1540681200, 3)
,(@time_zone_id, 1553817600, 2)
,(@time_zone_id, 1572130800, 3)
,(@time_zone_id, 1585267200, 2)
,(@time_zone_id, 1603580400, 3)
,(@time_zone_id, 1616716800, 2)
,(@time_zone_id, 1635634800, 3)
,(@time_zone_id, 1648166400, 2)
,(@time_zone_id, 1667084400, 3)
,(@time_zone_id, 1679616000, 2)
,(@time_zone_id, 1698534000, 3)
,(@time_zone_id, 1711670400, 2)
,(@time_zone_id, 1729983600, 3)
,(@time_zone_id, 1743120000, 2)
,(@time_zone_id, 1761433200, 3)
,(@time_zone_id, 1774569600, 2)
,(@time_zone_id, 1792882800, 3)
,(@time_zone_id, 1806019200, 2)
,(@time_zone_id, 1824937200, 3)
,(@time_zone_id, 1837468800, 2)
,(@time_zone_id, 1856386800, 3)
,(@time_zone_id, 1868918400, 2)
,(@time_zone_id, 1887836400, 3)
,(@time_zone_id, 1900972800, 2)
,(@time_zone_id, 1919286000, 3)
,(@time_zone_id, 1932422400, 2)
,(@time_zone_id, 1950735600, 3)
,(@time_zone_id, 1963872000, 2)
,(@time_zone_id, 1982790000, 3)
,(@time_zone_id, 1995321600, 2)
,(@time_zone_id, 2014239600, 3)
,(@time_zone_id, 2026771200, 2)
,(@time_zone_id, 2045689200, 3)
,(@time_zone_id, 2058220800, 2)
,(@time_zone_id, 2077138800, 3)
,(@time_zone_id, 2090275200, 2)
,(@time_zone_id, 2108588400, 3)
,(@time_zone_id, 2121724800, 2)
,(@time_zone_id, 2140038000, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 8454, 0, 'LMT')
,(@time_zone_id, 1, 8440, 0, 'JMT')
,(@time_zone_id, 2, 10800, 1, 'IDT')
,(@time_zone_id, 3, 7200, 0, 'IST')
,(@time_zone_id, 4, 14400, 1, 'IDDT')
,(@time_zone_id, 5, 10800, 1, 'IDT')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Thimbu', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -706341516, 1)
,(@time_zone_id, 560025000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 21516, 0, 'LMT')
,(@time_zone_id, 1, 19800, 0, '+0530')
,(@time_zone_id, 2, 21600, 0, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Thimphu', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -706341516, 1)
,(@time_zone_id, 560025000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 21516, 0, 'LMT')
,(@time_zone_id, 1, 19800, 0, '+0530')
,(@time_zone_id, 2, 21600, 0, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Tokyo', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 3)
,(@time_zone_id, -683802000, 1)
,(@time_zone_id, -672310800, 2)
,(@time_zone_id, -654771600, 1)
,(@time_zone_id, -640861200, 2)
,(@time_zone_id, -620298000, 1)
,(@time_zone_id, -609411600, 2)
,(@time_zone_id, -588848400, 1)
,(@time_zone_id, -577962000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 33539, 0, 'LMT')
,(@time_zone_id, 1, 36000, 1, 'JDT')
,(@time_zone_id, 2, 32400, 0, 'JST')
,(@time_zone_id, 3, 32400, 0, 'JST')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Tomsk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1578807591, 1)
,(@time_zone_id, -1247551200, 3)
,(@time_zone_id, 354906000, 2)
,(@time_zone_id, 370713600, 3)
,(@time_zone_id, 386442000, 2)
,(@time_zone_id, 402249600, 3)
,(@time_zone_id, 417978000, 2)
,(@time_zone_id, 433785600, 3)
,(@time_zone_id, 449600400, 2)
,(@time_zone_id, 465332400, 4)
,(@time_zone_id, 481057200, 5)
,(@time_zone_id, 496782000, 4)
,(@time_zone_id, 512506800, 5)
,(@time_zone_id, 528231600, 4)
,(@time_zone_id, 543956400, 5)
,(@time_zone_id, 559681200, 4)
,(@time_zone_id, 575406000, 5)
,(@time_zone_id, 591130800, 4)
,(@time_zone_id, 606855600, 5)
,(@time_zone_id, 622580400, 4)
,(@time_zone_id, 638305200, 5)
,(@time_zone_id, 654634800, 4)
,(@time_zone_id, 670359600, 6)
,(@time_zone_id, 686088000, 7)
,(@time_zone_id, 695764800, 4)
,(@time_zone_id, 701809200, 5)
,(@time_zone_id, 717534000, 4)
,(@time_zone_id, 733258800, 5)
,(@time_zone_id, 748983600, 4)
,(@time_zone_id, 764708400, 5)
,(@time_zone_id, 780433200, 4)
,(@time_zone_id, 796158000, 5)
,(@time_zone_id, 811882800, 4)
,(@time_zone_id, 828212400, 5)
,(@time_zone_id, 846356400, 4)
,(@time_zone_id, 859662000, 5)
,(@time_zone_id, 877806000, 4)
,(@time_zone_id, 891111600, 5)
,(@time_zone_id, 909255600, 4)
,(@time_zone_id, 922561200, 5)
,(@time_zone_id, 941310000, 4)
,(@time_zone_id, 954010800, 5)
,(@time_zone_id, 972759600, 4)
,(@time_zone_id, 985460400, 5)
,(@time_zone_id, 1004209200, 4)
,(@time_zone_id, 1017514800, 5)
,(@time_zone_id, 1020193200, 8)
,(@time_zone_id, 1035662400, 7)
,(@time_zone_id, 1048968000, 6)
,(@time_zone_id, 1067112000, 7)
,(@time_zone_id, 1080417600, 6)
,(@time_zone_id, 1099166400, 7)
,(@time_zone_id, 1111867200, 6)
,(@time_zone_id, 1130616000, 7)
,(@time_zone_id, 1143316800, 6)
,(@time_zone_id, 1162065600, 7)
,(@time_zone_id, 1174766400, 6)
,(@time_zone_id, 1193515200, 7)
,(@time_zone_id, 1206820800, 6)
,(@time_zone_id, 1224964800, 7)
,(@time_zone_id, 1238270400, 6)
,(@time_zone_id, 1256414400, 7)
,(@time_zone_id, 1269720000, 6)
,(@time_zone_id, 1288468800, 7)
,(@time_zone_id, 1301169600, 4)
,(@time_zone_id, 1414263600, 7)
,(@time_zone_id, 1464465600, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 20391, 0, 'LMT')
,(@time_zone_id, 1, 21600, 0, '+06')
,(@time_zone_id, 2, 28800, 1, '+08')
,(@time_zone_id, 3, 25200, 0, '+07')
,(@time_zone_id, 4, 25200, 0, '+07')
,(@time_zone_id, 5, 28800, 1, '+08')
,(@time_zone_id, 6, 25200, 1, '+07')
,(@time_zone_id, 7, 21600, 0, '+06')
,(@time_zone_id, 8, 25200, 1, '+07')
,(@time_zone_id, 9, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Ujung_Pandang', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1577951856, 1)
,(@time_zone_id, -1172908656, 2)
,(@time_zone_id, -880272000, 3)
,(@time_zone_id, -766054800, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 28656, 0, 'LMT')
,(@time_zone_id, 1, 28656, 0, 'MMT')
,(@time_zone_id, 2, 28800, 0, '+08')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 28800, 0, 'WITA')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Ulaanbaatar', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2032931252, 1)
,(@time_zone_id, 252435600, 3)
,(@time_zone_id, 417974400, 2)
,(@time_zone_id, 433782000, 3)
,(@time_zone_id, 449596800, 2)
,(@time_zone_id, 465318000, 3)
,(@time_zone_id, 481046400, 2)
,(@time_zone_id, 496767600, 3)
,(@time_zone_id, 512496000, 2)
,(@time_zone_id, 528217200, 3)
,(@time_zone_id, 543945600, 2)
,(@time_zone_id, 559666800, 3)
,(@time_zone_id, 575395200, 2)
,(@time_zone_id, 591116400, 3)
,(@time_zone_id, 606844800, 2)
,(@time_zone_id, 622566000, 3)
,(@time_zone_id, 638294400, 2)
,(@time_zone_id, 654620400, 3)
,(@time_zone_id, 670348800, 2)
,(@time_zone_id, 686070000, 3)
,(@time_zone_id, 701798400, 2)
,(@time_zone_id, 717519600, 3)
,(@time_zone_id, 733248000, 2)
,(@time_zone_id, 748969200, 3)
,(@time_zone_id, 764697600, 2)
,(@time_zone_id, 780418800, 3)
,(@time_zone_id, 796147200, 2)
,(@time_zone_id, 811868400, 3)
,(@time_zone_id, 828201600, 2)
,(@time_zone_id, 843922800, 3)
,(@time_zone_id, 859651200, 2)
,(@time_zone_id, 875372400, 3)
,(@time_zone_id, 891100800, 2)
,(@time_zone_id, 906822000, 3)
,(@time_zone_id, 988394400, 2)
,(@time_zone_id, 1001696400, 3)
,(@time_zone_id, 1017424800, 2)
,(@time_zone_id, 1033146000, 3)
,(@time_zone_id, 1048874400, 2)
,(@time_zone_id, 1064595600, 3)
,(@time_zone_id, 1080324000, 2)
,(@time_zone_id, 1096045200, 3)
,(@time_zone_id, 1111773600, 2)
,(@time_zone_id, 1127494800, 3)
,(@time_zone_id, 1143223200, 2)
,(@time_zone_id, 1159549200, 3)
,(@time_zone_id, 1427479200, 2)
,(@time_zone_id, 1443193200, 3)
,(@time_zone_id, 1458928800, 2)
,(@time_zone_id, 1474642800, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 25652, 0, 'LMT')
,(@time_zone_id, 1, 25200, 0, '+07')
,(@time_zone_id, 2, 32400, 1, '+09')
,(@time_zone_id, 3, 28800, 0, '+08')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Ulan_Bator', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -2032931252, 1)
,(@time_zone_id, 252435600, 3)
,(@time_zone_id, 417974400, 2)
,(@time_zone_id, 433782000, 3)
,(@time_zone_id, 449596800, 2)
,(@time_zone_id, 465318000, 3)
,(@time_zone_id, 481046400, 2)
,(@time_zone_id, 496767600, 3)
,(@time_zone_id, 512496000, 2)
,(@time_zone_id, 528217200, 3)
,(@time_zone_id, 543945600, 2)
,(@time_zone_id, 559666800, 3)
,(@time_zone_id, 575395200, 2)
,(@time_zone_id, 591116400, 3)
,(@time_zone_id, 606844800, 2)
,(@time_zone_id, 622566000, 3)
,(@time_zone_id, 638294400, 2)
,(@time_zone_id, 654620400, 3)
,(@time_zone_id, 670348800, 2)
,(@time_zone_id, 686070000, 3)
,(@time_zone_id, 701798400, 2)
,(@time_zone_id, 717519600, 3)
,(@time_zone_id, 733248000, 2)
,(@time_zone_id, 748969200, 3)
,(@time_zone_id, 764697600, 2)
,(@time_zone_id, 780418800, 3)
,(@time_zone_id, 796147200, 2)
,(@time_zone_id, 811868400, 3)
,(@time_zone_id, 828201600, 2)
,(@time_zone_id, 843922800, 3)
,(@time_zone_id, 859651200, 2)
,(@time_zone_id, 875372400, 3)
,(@time_zone_id, 891100800, 2)
,(@time_zone_id, 906822000, 3)
,(@time_zone_id, 988394400, 2)
,(@time_zone_id, 1001696400, 3)
,(@time_zone_id, 1017424800, 2)
,(@time_zone_id, 1033146000, 3)
,(@time_zone_id, 1048874400, 2)
,(@time_zone_id, 1064595600, 3)
,(@time_zone_id, 1080324000, 2)
,(@time_zone_id, 1096045200, 3)
,(@time_zone_id, 1111773600, 2)
,(@time_zone_id, 1127494800, 3)
,(@time_zone_id, 1143223200, 2)
,(@time_zone_id, 1159549200, 3)
,(@time_zone_id, 1427479200, 2)
,(@time_zone_id, 1443193200, 3)
,(@time_zone_id, 1458928800, 2)
,(@time_zone_id, 1474642800, 3)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 25652, 0, 'LMT')
,(@time_zone_id, 1, 25200, 0, '+07')
,(@time_zone_id, 2, 32400, 1, '+09')
,(@time_zone_id, 3, 28800, 0, '+08')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Urumqi', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1325483420, 1)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 21020, 0, 'LMT')
,(@time_zone_id, 1, 21600, 0, '+06')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Ust-Nera', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1579426374, 1)
,(@time_zone_id, -1247558400, 2)
,(@time_zone_id, 354898800, 4)
,(@time_zone_id, 370699200, 3)
,(@time_zone_id, 386427600, 4)
,(@time_zone_id, 402235200, 3)
,(@time_zone_id, 417963600, 4)
,(@time_zone_id, 433771200, 3)
,(@time_zone_id, 449586000, 4)
,(@time_zone_id, 465318000, 5)
,(@time_zone_id, 481042800, 6)
,(@time_zone_id, 496767600, 5)
,(@time_zone_id, 512492400, 6)
,(@time_zone_id, 528217200, 5)
,(@time_zone_id, 543942000, 6)
,(@time_zone_id, 559666800, 5)
,(@time_zone_id, 575391600, 6)
,(@time_zone_id, 591116400, 5)
,(@time_zone_id, 606841200, 6)
,(@time_zone_id, 622566000, 5)
,(@time_zone_id, 638290800, 6)
,(@time_zone_id, 654620400, 5)
,(@time_zone_id, 670345200, 7)
,(@time_zone_id, 686073600, 8)
,(@time_zone_id, 695750400, 5)
,(@time_zone_id, 701794800, 6)
,(@time_zone_id, 717519600, 5)
,(@time_zone_id, 733244400, 6)
,(@time_zone_id, 748969200, 5)
,(@time_zone_id, 764694000, 6)
,(@time_zone_id, 780418800, 5)
,(@time_zone_id, 796143600, 6)
,(@time_zone_id, 811868400, 5)
,(@time_zone_id, 828198000, 6)
,(@time_zone_id, 846342000, 5)
,(@time_zone_id, 859647600, 6)
,(@time_zone_id, 877791600, 5)
,(@time_zone_id, 891097200, 6)
,(@time_zone_id, 909241200, 5)
,(@time_zone_id, 922546800, 6)
,(@time_zone_id, 941295600, 5)
,(@time_zone_id, 953996400, 6)
,(@time_zone_id, 972745200, 5)
,(@time_zone_id, 985446000, 6)
,(@time_zone_id, 1004194800, 5)
,(@time_zone_id, 1017500400, 6)
,(@time_zone_id, 1035644400, 5)
,(@time_zone_id, 1048950000, 6)
,(@time_zone_id, 1067094000, 5)
,(@time_zone_id, 1080399600, 6)
,(@time_zone_id, 1099148400, 5)
,(@time_zone_id, 1111849200, 6)
,(@time_zone_id, 1130598000, 5)
,(@time_zone_id, 1143298800, 6)
,(@time_zone_id, 1162047600, 5)
,(@time_zone_id, 1174748400, 6)
,(@time_zone_id, 1193497200, 5)
,(@time_zone_id, 1206802800, 6)
,(@time_zone_id, 1224946800, 5)
,(@time_zone_id, 1238252400, 6)
,(@time_zone_id, 1256396400, 5)
,(@time_zone_id, 1269702000, 6)
,(@time_zone_id, 1288450800, 5)
,(@time_zone_id, 1301151600, 9)
,(@time_zone_id, 1315828800, 5)
,(@time_zone_id, 1414249200, 8)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 34374, 0, 'LMT')
,(@time_zone_id, 1, 28800, 0, '+08')
,(@time_zone_id, 2, 32400, 0, '+09')
,(@time_zone_id, 3, 39600, 0, '+11')
,(@time_zone_id, 4, 43200, 1, '+12')
,(@time_zone_id, 5, 39600, 0, '+11')
,(@time_zone_id, 6, 43200, 1, '+12')
,(@time_zone_id, 7, 39600, 1, '+11')
,(@time_zone_id, 8, 36000, 0, '+10')
,(@time_zone_id, 9, 43200, 0, '+12')
,(@time_zone_id, 10, 43200, 1, '+12')
,(@time_zone_id, 11, 36000, 0, '+10')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Vientiane', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1570084924, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 24124, 0, 'LMT')
,(@time_zone_id, 1, 24124, 0, 'BMT')
,(@time_zone_id, 2, 25200, 0, '+07')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Vladivostok', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1487321251, 1)
,(@time_zone_id, -1247562000, 3)
,(@time_zone_id, 354895200, 2)
,(@time_zone_id, 370702800, 3)
,(@time_zone_id, 386431200, 2)
,(@time_zone_id, 402238800, 3)
,(@time_zone_id, 417967200, 2)
,(@time_zone_id, 433774800, 3)
,(@time_zone_id, 449589600, 2)
,(@time_zone_id, 465321600, 4)
,(@time_zone_id, 481046400, 5)
,(@time_zone_id, 496771200, 4)
,(@time_zone_id, 512496000, 5)
,(@time_zone_id, 528220800, 4)
,(@time_zone_id, 543945600, 5)
,(@time_zone_id, 559670400, 4)
,(@time_zone_id, 575395200, 5)
,(@time_zone_id, 591120000, 4)
,(@time_zone_id, 606844800, 5)
,(@time_zone_id, 622569600, 4)
,(@time_zone_id, 638294400, 5)
,(@time_zone_id, 654624000, 4)
,(@time_zone_id, 670348800, 6)
,(@time_zone_id, 686077200, 7)
,(@time_zone_id, 695754000, 4)
,(@time_zone_id, 701798400, 5)
,(@time_zone_id, 717523200, 4)
,(@time_zone_id, 733248000, 5)
,(@time_zone_id, 748972800, 4)
,(@time_zone_id, 764697600, 5)
,(@time_zone_id, 780422400, 4)
,(@time_zone_id, 796147200, 5)
,(@time_zone_id, 811872000, 4)
,(@time_zone_id, 828201600, 5)
,(@time_zone_id, 846345600, 4)
,(@time_zone_id, 859651200, 5)
,(@time_zone_id, 877795200, 4)
,(@time_zone_id, 891100800, 5)
,(@time_zone_id, 909244800, 4)
,(@time_zone_id, 922550400, 5)
,(@time_zone_id, 941299200, 4)
,(@time_zone_id, 954000000, 5)
,(@time_zone_id, 972748800, 4)
,(@time_zone_id, 985449600, 5)
,(@time_zone_id, 1004198400, 4)
,(@time_zone_id, 1017504000, 5)
,(@time_zone_id, 1035648000, 4)
,(@time_zone_id, 1048953600, 5)
,(@time_zone_id, 1067097600, 4)
,(@time_zone_id, 1080403200, 5)
,(@time_zone_id, 1099152000, 4)
,(@time_zone_id, 1111852800, 5)
,(@time_zone_id, 1130601600, 4)
,(@time_zone_id, 1143302400, 5)
,(@time_zone_id, 1162051200, 4)
,(@time_zone_id, 1174752000, 5)
,(@time_zone_id, 1193500800, 4)
,(@time_zone_id, 1206806400, 5)
,(@time_zone_id, 1224950400, 4)
,(@time_zone_id, 1238256000, 5)
,(@time_zone_id, 1256400000, 4)
,(@time_zone_id, 1269705600, 5)
,(@time_zone_id, 1288454400, 4)
,(@time_zone_id, 1301155200, 8)
,(@time_zone_id, 1414249200, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 31651, 0, 'LMT')
,(@time_zone_id, 1, 32400, 0, '+09')
,(@time_zone_id, 2, 39600, 1, '+11')
,(@time_zone_id, 3, 36000, 0, '+10')
,(@time_zone_id, 4, 36000, 0, '+10')
,(@time_zone_id, 5, 39600, 1, '+11')
,(@time_zone_id, 6, 36000, 1, '+10')
,(@time_zone_id, 7, 32400, 0, '+09')
,(@time_zone_id, 8, 39600, 0, '+11')
,(@time_zone_id, 9, 39600, 1, '+11')
,(@time_zone_id, 10, 36000, 0, '+10')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Yakutsk', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1579423138, 1)
,(@time_zone_id, -1247558400, 3)
,(@time_zone_id, 354898800, 2)
,(@time_zone_id, 370706400, 3)
,(@time_zone_id, 386434800, 2)
,(@time_zone_id, 402242400, 3)
,(@time_zone_id, 417970800, 2)
,(@time_zone_id, 433778400, 3)
,(@time_zone_id, 449593200, 2)
,(@time_zone_id, 465325200, 4)
,(@time_zone_id, 481050000, 5)
,(@time_zone_id, 496774800, 4)
,(@time_zone_id, 512499600, 5)
,(@time_zone_id, 528224400, 4)
,(@time_zone_id, 543949200, 5)
,(@time_zone_id, 559674000, 4)
,(@time_zone_id, 575398800, 5)
,(@time_zone_id, 591123600, 4)
,(@time_zone_id, 606848400, 5)
,(@time_zone_id, 622573200, 4)
,(@time_zone_id, 638298000, 5)
,(@time_zone_id, 654627600, 4)
,(@time_zone_id, 670352400, 6)
,(@time_zone_id, 686080800, 7)
,(@time_zone_id, 695757600, 4)
,(@time_zone_id, 701802000, 5)
,(@time_zone_id, 717526800, 4)
,(@time_zone_id, 733251600, 5)
,(@time_zone_id, 748976400, 4)
,(@time_zone_id, 764701200, 5)
,(@time_zone_id, 780426000, 4)
,(@time_zone_id, 796150800, 5)
,(@time_zone_id, 811875600, 4)
,(@time_zone_id, 828205200, 5)
,(@time_zone_id, 846349200, 4)
,(@time_zone_id, 859654800, 5)
,(@time_zone_id, 877798800, 4)
,(@time_zone_id, 891104400, 5)
,(@time_zone_id, 909248400, 4)
,(@time_zone_id, 922554000, 5)
,(@time_zone_id, 941302800, 4)
,(@time_zone_id, 954003600, 5)
,(@time_zone_id, 972752400, 4)
,(@time_zone_id, 985453200, 5)
,(@time_zone_id, 1004202000, 4)
,(@time_zone_id, 1017507600, 5)
,(@time_zone_id, 1035651600, 4)
,(@time_zone_id, 1048957200, 5)
,(@time_zone_id, 1067101200, 4)
,(@time_zone_id, 1080406800, 5)
,(@time_zone_id, 1099155600, 4)
,(@time_zone_id, 1111856400, 5)
,(@time_zone_id, 1130605200, 4)
,(@time_zone_id, 1143306000, 5)
,(@time_zone_id, 1162054800, 4)
,(@time_zone_id, 1174755600, 5)
,(@time_zone_id, 1193504400, 4)
,(@time_zone_id, 1206810000, 5)
,(@time_zone_id, 1224954000, 4)
,(@time_zone_id, 1238259600, 5)
,(@time_zone_id, 1256403600, 4)
,(@time_zone_id, 1269709200, 5)
,(@time_zone_id, 1288458000, 4)
,(@time_zone_id, 1301158800, 8)
,(@time_zone_id, 1414252800, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 31138, 0, 'LMT')
,(@time_zone_id, 1, 28800, 0, '+08')
,(@time_zone_id, 2, 36000, 1, '+10')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 32400, 0, '+09')
,(@time_zone_id, 5, 36000, 1, '+10')
,(@time_zone_id, 6, 32400, 1, '+09')
,(@time_zone_id, 7, 28800, 0, '+08')
,(@time_zone_id, 8, 36000, 0, '+10')
,(@time_zone_id, 9, 36000, 1, '+10')
,(@time_zone_id, 10, 32400, 0, '+09')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Yangon', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1577946287, 2)
,(@time_zone_id, -873268200, 3)
,(@time_zone_id, -778410000, 2)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 23087, 0, 'LMT')
,(@time_zone_id, 1, 23087, 0, 'RMT')
,(@time_zone_id, 2, 23400, 0, '+0630')
,(@time_zone_id, 3, 32400, 0, '+09')
,(@time_zone_id, 4, 23400, 0, '+0630')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Yekaterinburg', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1688270553, 1)
,(@time_zone_id, -1592610305, 2)
,(@time_zone_id, -1247544000, 4)
,(@time_zone_id, 354913200, 3)
,(@time_zone_id, 370720800, 4)
,(@time_zone_id, 386449200, 3)
,(@time_zone_id, 402256800, 4)
,(@time_zone_id, 417985200, 3)
,(@time_zone_id, 433792800, 4)
,(@time_zone_id, 449607600, 3)
,(@time_zone_id, 465339600, 5)
,(@time_zone_id, 481064400, 6)
,(@time_zone_id, 496789200, 5)
,(@time_zone_id, 512514000, 6)
,(@time_zone_id, 528238800, 5)
,(@time_zone_id, 543963600, 6)
,(@time_zone_id, 559688400, 5)
,(@time_zone_id, 575413200, 6)
,(@time_zone_id, 591138000, 5)
,(@time_zone_id, 606862800, 6)
,(@time_zone_id, 622587600, 5)
,(@time_zone_id, 638312400, 6)
,(@time_zone_id, 654642000, 5)
,(@time_zone_id, 670366800, 7)
,(@time_zone_id, 686095200, 8)
,(@time_zone_id, 695772000, 5)
,(@time_zone_id, 701816400, 6)
,(@time_zone_id, 717541200, 5)
,(@time_zone_id, 733266000, 6)
,(@time_zone_id, 748990800, 5)
,(@time_zone_id, 764715600, 6)
,(@time_zone_id, 780440400, 5)
,(@time_zone_id, 796165200, 6)
,(@time_zone_id, 811890000, 5)
,(@time_zone_id, 828219600, 6)
,(@time_zone_id, 846363600, 5)
,(@time_zone_id, 859669200, 6)
,(@time_zone_id, 877813200, 5)
,(@time_zone_id, 891118800, 6)
,(@time_zone_id, 909262800, 5)
,(@time_zone_id, 922568400, 6)
,(@time_zone_id, 941317200, 5)
,(@time_zone_id, 954018000, 6)
,(@time_zone_id, 972766800, 5)
,(@time_zone_id, 985467600, 6)
,(@time_zone_id, 1004216400, 5)
,(@time_zone_id, 1017522000, 6)
,(@time_zone_id, 1035666000, 5)
,(@time_zone_id, 1048971600, 6)
,(@time_zone_id, 1067115600, 5)
,(@time_zone_id, 1080421200, 6)
,(@time_zone_id, 1099170000, 5)
,(@time_zone_id, 1111870800, 6)
,(@time_zone_id, 1130619600, 5)
,(@time_zone_id, 1143320400, 6)
,(@time_zone_id, 1162069200, 5)
,(@time_zone_id, 1174770000, 6)
,(@time_zone_id, 1193518800, 5)
,(@time_zone_id, 1206824400, 6)
,(@time_zone_id, 1224968400, 5)
,(@time_zone_id, 1238274000, 6)
,(@time_zone_id, 1256418000, 5)
,(@time_zone_id, 1269723600, 6)
,(@time_zone_id, 1288472400, 5)
,(@time_zone_id, 1301173200, 9)
,(@time_zone_id, 1414267200, 5)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 14553, 0, 'LMT')
,(@time_zone_id, 1, 13505, 0, 'PMT')
,(@time_zone_id, 2, 14400, 0, '+04')
,(@time_zone_id, 3, 21600, 1, '+06')
,(@time_zone_id, 4, 18000, 0, '+05')
,(@time_zone_id, 5, 18000, 0, '+05')
,(@time_zone_id, 6, 21600, 1, '+06')
,(@time_zone_id, 7, 18000, 1, '+05')
,(@time_zone_id, 8, 14400, 0, '+04')
,(@time_zone_id, 9, 21600, 0, '+06')
,(@time_zone_id, 10, 21600, 1, '+06')
,(@time_zone_id, 11, 18000, 0, '+05')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Asia/Yerevan', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1441162680, 1)
,(@time_zone_id, -405140400, 3)
,(@time_zone_id, 354916800, 2)
,(@time_zone_id, 370724400, 3)
,(@time_zone_id, 386452800, 2)
,(@time_zone_id, 402260400, 3)
,(@time_zone_id, 417988800, 2)
,(@time_zone_id, 433796400, 3)
,(@time_zone_id, 449611200, 2)
,(@time_zone_id, 465343200, 4)
,(@time_zone_id, 481068000, 5)
,(@time_zone_id, 496792800, 4)
,(@time_zone_id, 512517600, 5)
,(@time_zone_id, 528242400, 4)
,(@time_zone_id, 543967200, 5)
,(@time_zone_id, 559692000, 4)
,(@time_zone_id, 575416800, 5)
,(@time_zone_id, 591141600, 4)
,(@time_zone_id, 606866400, 5)
,(@time_zone_id, 622591200, 4)
,(@time_zone_id, 638316000, 5)
,(@time_zone_id, 654645600, 4)
,(@time_zone_id, 670370400, 6)
,(@time_zone_id, 686098800, 7)
,(@time_zone_id, 701823600, 6)
,(@time_zone_id, 717548400, 7)
,(@time_zone_id, 733273200, 6)
,(@time_zone_id, 748998000, 7)
,(@time_zone_id, 764722800, 6)
,(@time_zone_id, 780447600, 7)
,(@time_zone_id, 796172400, 6)
,(@time_zone_id, 811897200, 4)
,(@time_zone_id, 852062400, 3)
,(@time_zone_id, 859672800, 5)
,(@time_zone_id, 877816800, 4)
,(@time_zone_id, 891122400, 5)
,(@time_zone_id, 909266400, 4)
,(@time_zone_id, 922572000, 5)
,(@time_zone_id, 941320800, 4)
,(@time_zone_id, 954021600, 5)
,(@time_zone_id, 972770400, 4)
,(@time_zone_id, 985471200, 5)
,(@time_zone_id, 1004220000, 4)
,(@time_zone_id, 1017525600, 5)
,(@time_zone_id, 1035669600, 4)
,(@time_zone_id, 1048975200, 5)
,(@time_zone_id, 1067119200, 4)
,(@time_zone_id, 1080424800, 5)
,(@time_zone_id, 1099173600, 4)
,(@time_zone_id, 1111874400, 5)
,(@time_zone_id, 1130623200, 4)
,(@time_zone_id, 1143324000, 5)
,(@time_zone_id, 1162072800, 4)
,(@time_zone_id, 1174773600, 5)
,(@time_zone_id, 1193522400, 4)
,(@time_zone_id, 1206828000, 5)
,(@time_zone_id, 1224972000, 4)
,(@time_zone_id, 1238277600, 5)
,(@time_zone_id, 1256421600, 4)
,(@time_zone_id, 1269727200, 5)
,(@time_zone_id, 1288476000, 4)
,(@time_zone_id, 1293825600, 3)
,(@time_zone_id, 1301176800, 5)
,(@time_zone_id, 1319925600, 4)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, 10680, 0, 'LMT')
,(@time_zone_id, 1, 10800, 0, '+03')
,(@time_zone_id, 2, 18000, 1, '+05')
,(@time_zone_id, 3, 14400, 0, '+04')
,(@time_zone_id, 4, 14400, 0, '+04')
,(@time_zone_id, 5, 18000, 1, '+05')
,(@time_zone_id, 6, 14400, 1, '+04')
,(@time_zone_id, 7, 10800, 0, '+03')
,(@time_zone_id, 8, 18000, 1, '+05')
,(@time_zone_id, 9, 14400, 0, '+04')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Atlantic/Azores', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 1)
,(@time_zone_id, -1830376800, 6)
,(@time_zone_id, -1689548400, 2)
,(@time_zone_id, -1677794400, 3)
,(@time_zone_id, -1667430000, 4)
,(@time_zone_id, -1647730800, 5)
,(@time_zone_id, -1635807600, 4)
,(@time_zone_id, -1616194800, 5)
,(@time_zone_id, -1604358000, 4)
,(@time_zone_id, -1584658800, 5)
,(@time_zone_id, -1572735600, 4)
,(@time_zone_id, -1553036400, 5)
,(@time_zone_id, -1541199600, 4)
,(@time_zone_id, -1521500400, 5)
,(@time_zone_id, -1442444400, 4)
,(@time_zone_id, -1426806000, 5)
,(@time_zone_id, -1379286000, 4)
,(@time_zone_id, -1364770800, 5)
,(@time_zone_id, -1348441200, 4)
,(@time_zone_id, -1333321200, 5)
,(@time_zone_id, -1316386800, 4)
,(@time_zone_id, -1301266800, 5)
,(@time_zone_id, -1284332400, 4)
,(@time_zone_id, -1269817200, 5)
,(@time_zone_id, -1221433200, 4)
,(@time_zone_id, -1206918000, 5)
,(@time_zone_id, -1191193200, 4)
,(@time_zone_id, -1175468400, 5)
,(@time_zone_id, -1127689200, 4)
,(@time_zone_id, -1111964400, 5)
,(@time_zone_id, -1096844400, 4)
,(@time_zone_id, -1080514800, 5)
,(@time_zone_id, -1063580400, 4)
,(@time_zone_id, -1049065200, 5)
,(@time_zone_id, -1033340400, 4)
,(@time_zone_id, -1017615600, 5)
,(@time_zone_id, -1002495600, 4)
,(@time_zone_id, -986166000, 5)
,(@time_zone_id, -969231600, 4)
,(@time_zone_id, -950482800, 5)
,(@time_zone_id, -942015600, 4)
,(@time_zone_id, -922662000, 5)
,(@time_zone_id, -906937200, 4)
,(@time_zone_id, -891126000, 5)
,(@time_zone_id, -877302000, 4)
,(@time_zone_id, -873676800, 7)
,(@time_zone_id, -864000000, 4)
,(@time_zone_id, -857948400, 5)
,(@time_zone_id, -845852400, 4)
,(@time_zone_id, -842832000, 7)
,(@time_zone_id, -831340800, 4)
,(@time_zone_id, -825894000, 5)
,(@time_zone_id, -814402800, 4)
,(@time_zone_id, -810777600, 7)
,(@time_zone_id, -799891200, 4)
,(@time_zone_id, -794444400, 5)
,(@time_zone_id, -782953200, 4)
,(@time_zone_id, -779328000, 7)
,(@time_zone_id, -768441600, 4)
,(@time_zone_id, -762994800, 5)
,(@time_zone_id, -749084400, 4)
,(@time_zone_id, -733359600, 5)
,(@time_zone_id, -717624000, 4)
,(@time_zone_id, -701899200, 5)
,(@time_zone_id, -686174400, 4)
,(@time_zone_id, -670449600, 5)
,(@time_zone_id, -654724800, 4)
,(@time_zone_id, -639000000, 5)
,(@time_zone_id, -591825600, 4)
,(@time_zone_id, -575496000, 5)
,(@time_zone_id, -559771200, 4)
,(@time_zone_id, -544046400, 5)
,(@time_zone_id, -528321600, 4)
,(@time_zone_id, -512596800, 5)
,(@time_zone_id, -496872000, 4)
,(@time_zone_id, -481147200, 5)
,(@time_zone_id, -465422400, 4)
,(@time_zone_id, -449697600, 5)
,(@time_zone_id, -433972800, 4)
,(@time_zone_id, -417643200, 5)
,(@time_zone_id, -401918400, 4)
,(@time_zone_id, -386193600, 5)
,(@time_zone_id, -370468800, 4)
,(@time_zone_id, -354744000, 5)
,(@time_zone_id, -339019200, 4)
,(@time_zone_id, -323294400, 5)
,(@time_zone_id, -307569600, 4)
,(@time_zone_id, -291844800, 5)
,(@time_zone_id, -276120000, 4)
,(@time_zone_id, -260395200, 5)
,(@time_zone_id, -244670400, 4)
,(@time_zone_id, -228340800, 5)
,(@time_zone_id, -212616000, 4)
,(@time_zone_id, -196891200, 5)
,(@time_zone_id, -181166400, 4)
,(@time_zone_id, -165441600, 5)
,(@time_zone_id, -149716800, 4)
,(@time_zone_id, -133992000, 5)
,(@time_zone_id, -118267200, 9)
,(@time_zone_id, 228272400, 7)
,(@time_zone_id, 243997200, 8)
,(@time_zone_id, 260326800, 7)
,(@time_zone_id, 276051600, 8)
,(@time_zone_id, 291776400, 7)
,(@time_zone_id, 307504800, 8)
,(@time_zone_id, 323226000, 7)
,(@time_zone_id, 338954400, 8)
,(@time_zone_id, 354679200, 7)
,(@time_zone_id, 370404000, 8)
,(@time_zone_id, 386128800, 7)
,(@time_zone_id, 401853600, 8)
,(@time_zone_id, 417582000, 7)
,(@time_zone_id, 433303200, 8)
,(@time_zone_id, 449028000, 7)
,(@time_zone_id, 465357600, 8)
,(@time_zone_id, 481082400, 7)
,(@time_zone_id, 496807200, 8)
,(@time_zone_id, 512532000, 7)
,(@time_zone_id, 528256800, 8)
,(@time_zone_id, 543981600, 7)
,(@time_zone_id, 559706400, 8)
,(@time_zone_id, 575431200, 7)
,(@time_zone_id, 591156000, 8)
,(@time_zone_id, 606880800, 7)
,(@time_zone_id, 622605600, 8)
,(@time_zone_id, 638330400, 7)
,(@time_zone_id, 654660000, 8)
,(@time_zone_id, 670384800, 7)
,(@time_zone_id, 686109600, 8)
,(@time_zone_id, 701834400, 7)
,(@time_zone_id, 717559200, 10)
,(@time_zone_id, 733280400, 11)
,(@time_zone_id, 749005200, 12)
,(@time_zone_id, 764730000, 11)
,(@time_zone_id, 780454800, 12)
,(@time_zone_id, 796179600, 11)
,(@time_zone_id, 811904400, 12)
,(@time_zone_id, 828234000, 11)
,(@time_zone_id, 846378000, 12)
,(@time_zone_id, 859683600, 11)
,(@time_zone_id, 877827600, 12)
,(@time_zone_id, 891133200, 11)
,(@time_zone_id, 909277200, 12)
,(@time_zone_id, 922582800, 11)
,(@time_zone_id, 941331600, 12)
,(@time_zone_id, 954032400, 11)
,(@time_zone_id, 972781200, 12)
,(@time_zone_id, 985482000, 11)
,(@time_zone_id, 1004230800, 12)
,(@time_zone_id, 1017536400, 11)
,(@time_zone_id, 1035680400, 12)
,(@time_zone_id, 1048986000, 11)
,(@time_zone_id, 1067130000, 12)
,(@time_zone_id, 1080435600, 11)
,(@time_zone_id, 1099184400, 12)
,(@time_zone_id, 1111885200, 11)
,(@time_zone_id, 1130634000, 12)
,(@time_zone_id, 1143334800, 11)
,(@time_zone_id, 1162083600, 12)
,(@time_zone_id, 1174784400, 11)
,(@time_zone_id, 1193533200, 12)
,(@time_zone_id, 1206838800, 11)
,(@time_zone_id, 1224982800, 12)
,(@time_zone_id, 1238288400, 11)
,(@time_zone_id, 1256432400, 12)
,(@time_zone_id, 1269738000, 11)
,(@time_zone_id, 1288486800, 12)
,(@time_zone_id, 1301187600, 11)
,(@time_zone_id, 1319936400, 12)
,(@time_zone_id, 1332637200, 11)
,(@time_zone_id, 1351386000, 12)
,(@time_zone_id, 1364691600, 11)
,(@time_zone_id, 1382835600, 12)
,(@time_zone_id, 1396141200, 11)
,(@time_zone_id, 1414285200, 12)
,(@time_zone_id, 1427590800, 11)
,(@time_zone_id, 1445734800, 12)
,(@time_zone_id, 1459040400, 11)
,(@time_zone_id, 1477789200, 12)
,(@time_zone_id, 1490490000, 11)
,(@time_zone_id, 1509238800, 12)
,(@time_zone_id, 1521939600, 11)
,(@time_zone_id, 1540688400, 12)
,(@time_zone_id, 1553994000, 11)
,(@time_zone_id, 1572138000, 12)
,(@time_zone_id, 1585443600, 11)
,(@time_zone_id, 1603587600, 12)
,(@time_zone_id, 1616893200, 11)
,(@time_zone_id, 1635642000, 12)
,(@time_zone_id, 1648342800, 11)
,(@time_zone_id, 1667091600, 12)
,(@time_zone_id, 1679792400, 11)
,(@time_zone_id, 1698541200, 12)
,(@time_zone_id, 1711846800, 11)
,(@time_zone_id, 1729990800, 12)
,(@time_zone_id, 1743296400, 11)
,(@time_zone_id, 1761440400, 12)
,(@time_zone_id, 1774746000, 11)
,(@time_zone_id, 1792890000, 12)
,(@time_zone_id, 1806195600, 11)
,(@time_zone_id, 1824944400, 12)
,(@time_zone_id, 1837645200, 11)
,(@time_zone_id, 1856394000, 12)
,(@time_zone_id, 1869094800, 11)
,(@time_zone_id, 1887843600, 12)
,(@time_zone_id, 1901149200, 11)
,(@time_zone_id, 1919293200, 12)
,(@time_zone_id, 1932598800, 11)
,(@time_zone_id, 1950742800, 12)
,(@time_zone_id, 1964048400, 11)
,(@time_zone_id, 1982797200, 12)
,(@time_zone_id, 1995498000, 11)
,(@time_zone_id, 2014246800, 12)
,(@time_zone_id, 2026947600, 11)
,(@time_zone_id, 2045696400, 12)
,(@time_zone_id, 2058397200, 11)
,(@time_zone_id, 2077146000, 12)
,(@time_zone_id, 2090451600, 11)
,(@time_zone_id, 2108595600, 12)
,(@time_zone_id, 2121901200, 11)
,(@time_zone_id, 2140045200, 12)
;
INSERT INTO time_zone_transition_type (Time_zone_id, Transition_type_id, Offset, Is_DST, Abbreviation) VALUES
 (@time_zone_id, 0, -6160, 0, 'LMT')
,(@time_zone_id, 1, -6872, 0, 'HMT')
,(@time_zone_id, 2, -3600, 1, '-01')
,(@time_zone_id, 3, -7200, 0, '-02')
,(@time_zone_id, 4, -3600, 1, '-01')
,(@time_zone_id, 5, -7200, 0, '-02')
,(@time_zone_id, 6, -7200, 0, '-02')
,(@time_zone_id, 7, 0, 1, '+00')
,(@time_zone_id, 8, -3600, 0, '-01')
,(@time_zone_id, 9, -3600, 0, '-01')
,(@time_zone_id, 10, 0, 0, 'WET')
,(@time_zone_id, 11, 0, 1, '+00')
,(@time_zone_id, 12, -3600, 0, '-01')
;
INSERT INTO time_zone (Use_leap_seconds) VALUES ('N');
SET @time_zone_id= LAST_INSERT_ID();
INSERT INTO time_zone_name (Name, Time_zone_id) VALUES ('Atlantic/Bermuda', @time_zone_id);
INSERT INTO time_zone_transition (Time_zone_id, Transition_time, Transition_type_id) VALUES
 (@time_zone_id, -2147483648, 0)
,(@time_zone_id, -1262281242, 1)
,(@time_zone_id, 136360800, 2)
,(@time_zone_id, 152082000, 1)
,(@time_zone_id, 167810400, 2)
,(@time_zone_id, 183531600, 1)
,(@time_zone_id, 199260000, 2)
,(@time_zone_id, 215586000, 1)
,(@time_zone_id, 230709600, 2)
,(@time_zone_id, 247035600, 1)
,(@time_zone_id, 262764000, 2)
,(@time_zone_id, 278485200, 1)
,(@time_zone_id, 294213600, 2)
,(@time_zone_id, 309934800, 1)
,(@time_zone_id, 325663200, 2)
,(@time_zone_id, 341384400, 1)
,(@time_zone_id, 357112800, 2)
,(@time_zone_id, 372834000, 1)
,(@time_zone_id, 388562400, 2)
,(@time_zone_id, 404888400, 1)
,(@time_zone_id, 420012000, 2)
,(@time_zone_id, 436338000, 1)
,(@time_zone_id, 452066400, 2)
,(@time_zone_id, 467787600, 1)
,(@time_zone_id, 483516000, 2)
,(@time_zone_id, 499237200, 1)
,(@time_zone_id, 514965600, 2)
,(@time_zone_id, 530686800, 1)
,(@time_zone_id, 544600800, 2)
,(@time_zone_id, 562136400, 1)
,(@time_zone_id, 576050400, 2)
,(@time_zone_id, 594190800, 1)
,(@time_zone_id, 607500000, 2)
,(@time_zone_id, 625640400, 1)
,(@time_zone_id, 638949600, 2)
,(@time_zone_id, 657090000, 1)
,(@time_zone_id, 671004000, 2)
,(@time_zone_id, 688539600, 1)
,(@time_zone_id, 702453600, 2)
,(@time_zone_id, 719989200, 1)
,(@time_zone_id, 733903200, 2)
,(@time_zone_id, 752043600, 1)
,(@time_zone_id, 765352800, 2)
,(@time_zone_id, 783493200, 1)
,(@time_zone_id, 796