<?php
/**
 * Include database and mail function access.
 */

require_once(__DIR__ . '/class.mysqldb.php');			// MySQL DB Class
require_once(__DIR__ . '/inc.setup.php');					// include file to determin DB etc.
require_once(__DIR__ . '/functions.php');					// Functions library (we use isMasterDB() to check if we are master database)
require_once(__DIR__ . '/functions.system.php');
require_once(__DIR__ . '/functions.mail.php');			// Mail functions (Including PHPMailer class)
require_once(__DIR__ . '/ac_logon.php');

session_write_close();

$disabled = "disabled";
$resendOnly = 0;

$to = "";
$from = "";
$subject = "";
$body = "";
$email_address = "";

if ( array_key_exists('email_address',$_GET) ) {
   $email_address = $_GET['email_address'];
}

if ( array_key_exists('email_address',$_POST) ) {
      $email_address = $_POST['email_address'];
}

if ( array_key_exists('email_subject',$_GET) ) {
	$subject = $_GET['email_subject'];
}

if ( array_key_exists('email_subject',$_POST) ) {
	$subject = $_POST['email_subject'];
}

if ( array_key_exists('email_body',$_GET) ) {
	$body = $_GET['email_body'];
}

if ( array_key_exists('email_body',$_POST) ) {
	$body = $_POST['email_body'];
}

if ( $email_address == "" ) {
	if ( $messageID != "" ) {
		$resendOnly = 1;
		$sql = "SELECT * FROM em_mail WHERE em_mail_ix = '$messageID'";
		$result = mysqli_query($GLOBALS['lDB']->conn,$sql);
		$messageArray = mysqli_fetch_assoc($result);
		$to = $messageArray['em_to'];
		$from = $messageArray['em_from'];
		$subject = $messageArray['em_subject'];
		$body = $messageArray['em_message'];
	} else {
		$disabled = "";
	}
} else {
	$to = $email_address;
}


/* If there is a message (not blank) then store the email in the database and send */
if ( array_key_exists('message',$_POST) ) {
	$_POST['subject'] = str_replace("\\'","'",$_POST['subject']);
	$_POST['message'] = str_replace("\\'","'",$_POST['message']);
	$error = email($_POST['from'], $to, $_POST['subject'], "", $_POST['message']);
}

$resOfficeID = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default",4);

$fax = $GLOBALS['lDB']->get("
	SELECT
		pr_phone.pr_phone_number
	FROM
		pr_phone, 
		rf_phone_type 
	WHERE 
		pr_phone.pr_persona_id = '" . $resOfficeID . "' 
	AND 
		pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix 
	AND 
		rf_phone_type.rf_phone_type_sys_code = '1' 
",4);

if ( trim($fax)=="" || $fax=="0" ) {
	$fax = "None";
}

$resOffTel = $GLOBALS['lDB']->get("
	SELECT 
		pr_phone.pr_phone_number 
	FROM 
		pr_phone 
	WHERE 
		pr_phone.pr_persona_id = '" . $resOfficeID . "' 
	AND 
		pr_phone.pr_default_yn = '1'
",4);

if ( trim($resOffTel)==""||$resOffTel=="0" ) {
	$resOffTel = "None";
}

$principalID = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default",4);

$princEml = $GLOBALS['lDB']->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '" . $principalID . "'",4);

if ( trim($to) != trim($princEml) ) {
	$hideDetails = " style=\"display: none;\"";
} elseif ( $fax == "0" && $resOffTel == "0" ) {
	$hideDetails = " style=\"display: none;\"";
} else {
	$hideDetails = "";
}

if ( $to == "info@resrequest.com" || $to == "support@resrequest.com" ) {
	$principal_name = $GLOBALS['support']['company'];
	$resOffTel = $GLOBALS['support']['telephone'];
	$fax = $GLOBALS['support']['fax'];
	$hideDetails = "";
}

if ( $from == "" ) {
	$userid = $_SESSION['userid'];
	$from = $GLOBALS['lDB']->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '" . $userid . "'",4);
}

// Close this popup window if required
if ( array_key_exists('closeWindow',$_POST) && $_POST['closeWindow'] == "1" ) {
	if(!$error) {
		echo "<body onload=\"if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close()\">";
	} else {
		echo "<body onload=\"if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close()\">";
	}
}

global $domain;

$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";
if ($userStatusId == "0") {
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/email_form.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file(__DIR__ . "/../images/$principal_id/email_form.htm")));
	}

	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/email_form.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/email_form.css\" type=\"text/css\" />";
	} else {
		$indexCSS = "";
	}
	$GLOBALS['temp']['customCSS'] = "
		<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />
		$indexCSS
	";

	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Do not include imageset CSS if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customCSS'] = "";
	}
}

?>

<html>
	<head>
		<title>Send Email</title>
		<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
		<meta name="file_name" content="email_form.php" />
		
		<script type="text/javascript" src="/resource/Resrequest/Application/public/include/js/overlib.js"></script>
		<script type="text/javascript" src="/resource/Resrequest/Application/public/include/js/ui-kit/uikit.min.js"></script>
		<script type="text/javascript" src="/resource/Resrequest/Application/public/include/js/ui-kit/uikit-icons.min.js"></script>
		<script type="text/javascript" src="/resource/Resrequest/Application/public/include/js/system.js"></script>
		<script type="text/javascript" src="/resource/Resrequest/Application/public/include/js/email_form.js"></script>

		<link rel="stylesheet" href="/resource/Resrequest/Application/public/css/sys.css" type="text/css" />
		<link rel="stylesheet" href="/resource/Resrequest/Application/public/css/enterprise.css" type="text/css">
		<?=$GLOBALS['temp']['customCSS']?>

	</head>

	<body class="uk-background-default" onload="initialisePage();" onunload="popupUnload()" onfocus="popupFocus();">
		<div id="container">
			<form action="email_form.php" method="post" style="margin: 0; padding: 0;">
				<div id="overDiv" style="position: absolute; visibility: hidden; z-index: 1;"></div>
				<nav class="darkbar tb-smaller-pop uk-navbar" uk-navbar="">
					<div class="uk-navbar-left mfont">
						Send an email
					</div>
				</nav>
				<div class="tb-smaller-pop uk-magin-xlarge-bottom">
					<div class="uk-child-width-expand@s" uk-grid>
						<div>
							<div  class="uk-child-width-expand" uk-grid>
								<div class="uk-width-1-3">
									<div class="align-m">To</div>
								</div>
								<div>
									<input type="text" id="to" name="disabled_to" class="fullWidth uk-input" value="<?php echo $to; ?>" <?php echo $disabled; ?> /><input type="hidden" id="toHidden" name="email_address" value="<?php echo $to; ?>" />
								</div>
							</div>
						</div>
						<div>
							<div class="uk-child-width-expand" uk-grid>
								<div class="uk-width-1-3">
									<div class="align-m">From</div>
								</div>
								<div>
									<input type="text" id="from" name="from" class="uk-input fullWidth" value="<?php echo $from; ?>" />
								</div>
							</div>
						</div>
					</div>
					<div class="uk-child-width-expand uk-margin-small-top" uk-grid>
						<div class="uk-width-1-6">
							<div class="align-m">Subject</div>
						</div>
						<div>
							<input type="text" id="subject" name="subject" class="uk-input fullWidth" size="78" value="<?php echo $subject; ?>" />
						</div>
					</div>
					<div class="uk-child-width-expand uk-margin-small-top" uk-grid>
						<div class="uk-width-1-6">
							<div>Message</div>
						</div>
						<div>
							<textarea class="uk-textarea" id="message" name="message" rows="15"><?php echo $body; ?></textarea>
						</div>
					</div>
				
					<div class="uk-child-width-expand uk-margin-small-top uk-margin-large-bottom" <?php echo $hideDetails; ?> uk-grid>
						<div class="uk-width-1-6">

						</div>
						<div>
							<div class="!hidePrinc! uk-text-bold">
								<?php echo $principal_name; ?>
							</div>
							<div>
								Tel: <?php echo $resOffTel; ?>
							</div>
							<div>
								Fax: <?php echo $fax; ?>
							</div>
						</div>
					</div>
				
				</div>
				<div class="footer-bar uk-text-center">
						<button type="button" class="btn btn-primary" onclick="processForm();" id="sendButton">
							Send Email
						</button>
						<button type="button" class="btn btn-lgrey uk-margin-small-left" onclick="windowClose();">
							Cancel
						</button>
				</div>

				<input type="hidden" id="closeWindow" name="closeWindow" />
				<input type="hidden" id="resendOnly" value="<?php echo $resendOnly; ?>" />

			</form>
			<?=$GLOBALS['temp']['customHTML']?>
		</div>
	</body>
</html>
