<?php
require_once(__DIR__ . '/class.mysqldb.php');       # MySQL DB Class  # obvious
require(__DIR__ . '/inc.setup.php');           # Database Connection   # customised setup and config file for installation

# Input parameters (for testing purposes)
$rv_reservation_id = 'RS21829';

$extrasTotal = extrasTotal($rv_reservation_id);
echo "Amt: ".$extrasTotal[amt]."<br>";
echo "Currency: ".$extrasTotal[currency]."<br>";

###################################
# Function: Get total extras cost #
###################################
      
// Input argument is reservation id.
// The function returns gross cost of extras recorded for the reservation and the currency symbol.
// Gross cost includes tax, commission and variance. Currency is invoice currency.
// Does NOT cater for exchange rate expiry.
      
function extrasTotal($rv_reservation_id){
	$selectSql = "
		SELECT
			rv_extra.rv_extra_charge,
			rv_extra.rv_extra_discount,
			rv_extra.rv_extra_exch_rate,
			rv_extra.rv_extra_units,
			rf_currency.rf_currency_symbol
		FROM
			rv_reservation
			LEFT JOIN rf_currency ON rv_reservation.rv_invoice_currency_id = rf_currency.rf_currency_ix
			INNER JOIN rv_extra ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
	";
	$extraArray = $GLOBALS[lDB] -> get ($selectSql,"2");
	$rowNum = sizeof($extraArray);
	$extrasTotal = array();
	$extrasTotal[amt]      = 0;
	$extrasTotal[currency] = $extraArray[0][rf_currency_symbol];
	for ($i = 0; $i < $rowNum; $i++) {
		$extraAmt = (($extraArray[$i][rv_extra_charge]* $extraArray[$i][rv_extra_units])
			+ $extraArray[$i][rv_extra_discount])* $extraArray[$i][rv_extra_exch_rate];
		$extrasTotal[amt] = $extrasTotal[amt] + $extraAmt;
	}
	return $extrasTotal;
}
