<?php

require_once(__DIR__ . "/db.pr_link.php");
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.pr_user.php");
require_once(__DIR__ . "/db.sc_group.php");

function archiveAccess() {
	global $lDB;
	global $flagChngs;
	global $userid;
	global $trTables;

	$flagChngs = false;

	if(!isset($trTables) || !is_array($trTables)) {
		$trTables = array();
	}

	if(!isset($userid)) {
		$userid = $_SESSION['userid'];
	}

	if(!db_pr_persona_exists($userid)) {
		$pr_persona_db = substr($userid,0,2);
		$pr_persona_id = substr($userid,2);
		$lDB->put("
			INSERT INTO pr_persona (
				pr_persona_db,
				pr_persona_id,
				pr_org_yn,
				pr_name_last
			) VALUES (
				'$pr_persona_db',
				'$pr_persona_id',
				0,
				'Archive user'
			)
		");
	}

	if(!db_pr_user_exists($userid)) {
		$lDB->put("
			INSERT INTO pr_user (
				pr_user_id,
				pr_user_name,
				pr_user_password
			) VALUES (
				'$userid',
				'$userid',
				'".md5(uniqid(rand(),1))."'
			)
		");
	}

	$pr_business_top = $lDB->get("
		SELECT
			pr_business.pr_business_id
		FROM
			pr_business
			LEFT JOIN pr_business AS parent_business ON parent_business.pr_business_id = pr_business.pr_business_parent
		WHERE
			parent_business.pr_business_id IS NULL
	",4);

	if(!db_pr_link_exists_by_all($userid, $pr_business_top, 'RS1')) {
		$lDB->put("
			DELETE FROM pr_link
			WHERE
				pr_link_from = '$userid'
				AND rf_link_type_id = 'RS1'
		");
		$lDB->put("
			INSERT INTO pr_link (
				pr_link_to,
				pr_link_from,
				rf_link_type_id
			) VALUES (
				'$pr_business_top',
				'$userid',
				'RS1'
			)
		");
	}

	if(!db_sc_group_exists(-1)) {
		$lDB->put("
			INSERT INTO sc_group (
				sc_group_id,
				sc_grp_code,
				sc_grp_desc
			) VALUES (
				-1,
				'ARCHIVE',
				'Archive'
			)
		");
	}
	$lDB->put("
		UPDATE sc_group SET
			sc_grp_avail_limit = 0,
			sc_grp_avail_limit_yn = 0,
			sc_grp_avail_prov_yn = 1,
			sc_grp_consultant_yn = 1
		WHERE
			sc_group.sc_group_id = -1 
	");

	$missing_functions = $lDB->get("
		SELECT
			sc_function.sc_function_id
		FROM
			sc_function
			LEFT JOIN sc_fun_group ON 
				sc_fun_group.sc_group_id = -1
				AND sc_fun_group.sc_function_id = sc_function.sc_function_id
		WHERE
			sc_fun_group.sc_fun_group_id IS NULL
	",3);
	foreach($missing_functions as $sc_function_id) {
		$lDB->put("
			INSERT INTO sc_fun_group (
				sc_group_id,
				sc_function_id
			) VALUES (
				-1,
				'$sc_function_id'
			)
		");
	}
	$lDB->put("UPDATE sc_fun_group SET sc_fun_grp_level = 5 WHERE sc_group_id = -1");
	
	$missing_accomm = $lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			LEFT JOIN sc_accomm ON
				sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				AND sc_accomm.sc_group_id = -1
		WHERE
			sc_accomm.sc_accomm_id IS NULL
	",3);
	foreach($missing_accomm as $ac_accomm_type_id) {
		$lDB->put("
			INSERT INTO sc_accomm (
				sc_group_id,
				ac_accomm_type_id
			) VALUES (
				-1,
				'$ac_accomm_type_id'
			)
		");
	}

	$user_check = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			sc_user
		WHERE
			sc_user.pr_user_id = '$userid'
			AND sc_user.sc_group_id = -1
	",4);
	if($user_check < 1) {
		$lDB->put("DELETE FROM sc_user WHERE sc_user.pr_user_id = '$userid'");
		$lDB->put("
			INSERT INTO sc_user (
				sc_group_id,
				pr_user_id
			) VALUES (
				-1,
				'$userid'
			)
		");
	}
}
