<?php

function db_ad_useraccess_detail_format($value,$ad_module_field_display_type_ind) {
	$max = 30;
	switch($ad_module_field_display_type_ind) {
		case DB_AD_RES_DETAIL_TYPE_BOOLEAN:
			return ($value == true) ? "True" : "False";
			break;
		case DB_AD_RES_DETAIL_TYPE_CURRENCY:
			return (empty($value)) ? "" : number_format((double)$value, 2);
			break;
		case DB_AD_RES_DETAIL_TYPE_DATE:
			return (empty($value) || $value == "0000-00-00" || $value == "0000-00-00 00:00:00") ? "" : date("Y-m-d", strtotime($value));;
			break;
		case DB_AD_RES_DETAIL_TYPE_DATETIME:
			return (empty($value) || $value == "0000-00-00" || $value == "0000-00-00 00:00:00") ? "" : date("Y-m-d H:i:s", strtotime($value));;
			break;
		case DB_AD_RES_DETAIL_TYPE_FLOAT:
			return (empty($value)) ? "" : number_format((double)$value, 2);
			break;
		case DB_AD_RES_DETAIL_TYPE_INTEGER:
			return (empty($value)) ? "" : number_format((double)$value, 0);
			break;
		case DB_AD_RES_DETAIL_TYPE_STRING:
			if (strlen($value) > $max) {
				$value = substr($value, 0, $max - 3) . "...<img class='eye' onmouseout='nd()' onmouseover='overlib(\"" . t_encodeOverlib($value) . "\",LEFT,WIDTH,400)' src='/resource/Resrequest/Application/public/img/button_note.gif' />";
			}
			return $value;
			break;
		case DB_AD_RES_DETAIL_TYPE_TEXT:
			if (strlen($value) > $max) {
				$value = substr($value, 0, $max - 3) . "...<img class='eye' onmouseout='nd()' onmouseover='overlib(\"" . t_encodeOverlib($value) . "\",LEFT,WIDTH,400)' src='/resource/Resrequest/Application/public/img/button_note.gif' />";
			}
			return $value;
			break;
		case DB_AD_RES_DETAIL_TYPE_TIME:
			return date("H:i:s", strtotime($value));;
			break;
		default:
			return $value;
	}
}