<?php

/* 
 * $Id: functions.availability.php,v 1.3 2011-05-17 14:08:23 light Exp $
 *
 * $Log: functions.availability.php,v $
 * Revision 1.3  2011-05-17 14:08:23  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.2  2006-12-28 14:31:00  gregs
 * Agent Allocations
 *
 * Revision 1.1  2006-12-27 08:12:23  gregs
 * Separated getAvail function into new include file: functions.availability.php
 *
 *
 */

function getAvailBooking($mode,$ac_accomm_type_id,$start_date,$end_date,$unit_limit=0,$showProvisionals=0,$showOverbookings=0) {
	if($GLOBALS['userStatusId'] == 1) {
		// User is an agent
		$SQL_occupancyAgent = " AND rv_reservation.rv_agent_id = '" . $GLOBALS['calAgentId'] . "'"; 
	} else {
		$SQL_occupancyAgent = "";
	}

	$today = date("Y-m-d");

	$dateArray = explode("-",$start_date);
	$numberOfDays = dateSubtract($end_date,$start_date) + 1;
	$returnArray = array();
	$returnArray['getAvailBooking'] = array();

	if($showProvisionals > 0) {
		$status = ",rv_reservation.rf_reservation_status_id ";
		$SQL_showProvisionals = "
			OR 	(
					rv_reservation.rf_reservation_status_id = '20'
					AND
					rv_reservation.rv_provision_expiry_date >= '$today'
					) ";
	} else {
		$status = "";
		$SQL_showProvisionals = " ";
	}

	for($count = 0; $count < $numberOfDays; $count++) {
		$thisDate = date("Y-m-d",mktime(0,0,0,$dateArray[1],$dateArray[2]+$count,$dateArray[0]));
		$SQL_accommInactiveCheck = "
			AND (
				(
					ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					AND ac_accomm_room.ac_accomm_room_create_date <= '$thisDate'
				) OR (
					ac_accomm_room.ac_accomm_room_inactive_yn = '1'
					AND ac_accomm_room.ac_accomm_room_inactive_date > '$thisDate'
				)
			)
		";
		
		$accommTypeCount = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				ac_accomm_room
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
			WHERE
				ac_accomm_type.ac_accomm_type_ix = '$ac_accomm_type_id'
				$SQL_accommInactiveCheck
		",4);

		$accommCount = $GLOBALS['lDB']->get("
			SELECT
				SUM(rv_reservation_item.rv_item_accomm_count)	
			FROM
				rv_reservation_item
			INNER JOIN rv_reservation ON 
				rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_reservation_item.ac_accomm_type_id = '$ac_accomm_type_id'
				AND rv_reservation_item.rv_item_date_arrive <= '$thisDate'
				AND rv_reservation_item.rv_item_date_depart > '$thisDate'
				AND (
						rv_reservation.rf_reservation_status_id = '30'
						OR rv_reservation.rf_reservation_status_id = '25'						
						" . $SQL_showProvisionals . "
						)
				" . $SQL_occupancyAgent . "
		",4);
		
		$provisionalCount = $GLOBALS['lDB']->get("
			SELECT
				COUNT(rv_reservation.rf_reservation_status_id)
			FROM
				rv_reservation_item
			INNER JOIN rv_reservation ON 
				rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_reservation_item.ac_accomm_type_id = '$ac_accomm_type_id'
				AND rv_reservation_item.rv_item_date_arrive <= '$thisDate'
				AND rv_reservation_item.rv_item_date_depart > '$thisDate'
				AND rv_reservation.rf_reservation_status_id = '20'
				AND rv_reservation.rv_provision_expiry_date >= '$thisDate'
		",4);
		
		$blockCount = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				ac_accomm_room_block
				INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = ac_accomm_room_block.ac_accomm_room_id
			WHERE
				ac_accomm_block.ac_accomm_type_id = '$ac_accomm_type_id' 
				AND ac_accomm_block.ac_start_date <= '$thisDate'
				AND ac_accomm_block.ac_end_date > '$thisDate'
				$SQL_accommInactiveCheck
				",4);

		switch($mode) {
		case "occupancy":
			if(!$accommCount) {
				$returnArray['getAvailBooking'][$thisDate] = 0;
			} else {
				$returnArray['getAvailBooking'][$thisDate] = $accommCount;
			}			
			break;
		case "availability":
			$returnArray['getAvailBooking'][$thisDate] = $accommTypeCount - $accommCount - $blockCount;
			break;
		}

		if($unit_limit > 0) {
			if($returnArray['getAvailBooking'][$thisDate] > $unit_limit) {
				$returnArray['getAvailBooking'][$thisDate] = $unit_limit;
			}
		}
		
		$returnArray['provCount'][$thisDate] = $provisionalCount;
		
		if($returnArray['getAvailBooking'][$thisDate] < 0) {
			if($showOverbookings == 0 || $unit_limit > 0) {
				$returnArray['getAvailBooking'][$thisDate] = 0;
			}
		}
	}

	// Take into account any limit on displaying Units --------------------------	
	$returnArray['units'] = ($unit_limit > 0 && $unit_limit < $accommTypeCount) ? $unit_limit : $accommTypeCount;
	
	if($returnArray['units'] < 0) {
		$returnArray['units'] = 0;
	}
	return $returnArray;
}
