<?php
/*************
 * Constants *
 *************/
define("CACHE_MEM",1);
define("CACHE_MEM_SHARED",2);
define("CACHE_DISK",3);
define("CACHE_DISK_SHARED",4);


/******************
 * Initialisation *
 ******************/
if(!isset($GLOBALS['cache'])) {
	$GLOBALS['cacheMem'] = array();
}

if(!isset($_SESSION['cache'])) {
	$_SESSION['cacheDisk'] = array();
}

$GLOBALS['cacheMemSharedConnected'] = false;
if(class_exists('Redis')) {
	$GLOBALS['cacheMemShared'] = new Redis;
} else {
	$GLOBLAS['cacheMemShared'] = false;
}

$GLOBALS['cacheTomorrow'] = false;

/*************
 * Functions *
 *************/
function cacheMemSharedConnect() {
	global $cacheMemShared;
	global $cacheMemSharedConnected;

	if($cacheMemSharedConnected) {
		return true;
	}

	if($cacheMemShared === false) {
		return false;
	}

	if(!$cacheMemShared->connect('127.0.0.1')) {
		$cacheMemShared = false;
		// TODO implement monitoring
		error_log("Unable to connect to Redis cache");
		return false;
	}

	$cacheMemSharedConnected = true;
	return true;
}

function cacheSet($cLabel, $cValue, $cType=CACHE_MEM, $cExpire=0) {
	global $cacheTomorrow;

	if($cExpire == "tomorrow") {
		if($cacheTomorrow === false) {
			$today = explode("-",date("Y-m-d"));
			$cacheTomorrow = mktime(0, 0, 0, $today[1], $today[2] + 1, $today[0]);
		}
		$cExpire = $cacheTomorrow;
	}
	switch($cType) {
	case CACHE_MEM:
	default:
		$GLOBALS['cacheMem'][$cLabel] = $cValue;
		break;
	case CACHE_MEM_SHARED:
		if(!cacheMemSharedConnect()) {
			return false;
		}
		$key = $GLOBALS['principal_id'] . "_" . $cLabel;
		try {
			if(!$GLOBALS['cacheMemShared']->set($key, json_encode($cValue))) {
				return false;
			}
			if($cExpire != 0) {
				$GLOBALS['cacheMemShared']->expireAt($key,$cExpire);
			}
		} catch (RedisException $e) {
			// TODO implement monitoring
			error_log("Unable to set key in Redis cache");
			return false;
		}
		break;
	case CACHE_DISK:
		session_restart();
		$_SESSION['cacheDisk'][$cLabel] = $cValue;
		session_write_close();
		break;	
	case CACHE_DISK_SHARED:
		$cValue = serialize($cValue);
		if (cacheExists($cLabel,CACHE_DISK_SHARED)) {
			/* check if its locked */
			if (cacheDiskLocked($cLabel)) {
				/* if object exists lock it */
				cacheDiskLock($cLabel);

				/* then create new one */
				cacheDiskSet($cLabel,$cValue);
				cacheDiskUnlock($cLabel);
			}
        } else {
			cacheDiskSet($cLabel,$cValue);
        } 
		break;
	}
	return true;
}

function cacheGet($cLabel,$cType=CACHE_MEM) {
	switch($cType) {
	case CACHE_MEM:
	default:
		return $GLOBALS['cacheMem'][$cLabel];
	case CACHE_MEM_SHARED:
		if(!cacheMemSharedConnect()) {
			return false;
		}
		try {
			$value = $GLOBALS['cacheMemShared']->get($GLOBALS['principal_id'] . "_" . $cLabel);
		} catch (RedisException $e) {
			// TODO implement monitoring
			error_log("Unable to get key from Redis cache");
			return false;
		}
		if($value === false) {
			return false;
		} else {
			return json_decode($value,true);
		}
	case CACHE_DISK:
		return $_SESSION['cacheDisk'][$cLabel];
	case CACHE_DISK_SHARED:
		if(!cacheDiskLocked($cLabel)) {
			return unserialize(cacheDiskContents($cLabel));
		} else {
			return unserialize(cacheDiskContents($cLabel . ".lock"));
		}
	}
}

function cacheExists($cLabel,$cType=CACHE_MEM) {
	switch($cType) {
	case CACHE_MEM:
	default:
		return isset($GLOBALS['cacheMem'][$cLabel]);
	case CACHE_MEM_SHARED:
		if(!cacheMemSharedConnect()) {
			return false;
		}
		try {
			return $GLOBALS['cacheMemShared']->exists($GLOBALS['principal_id'] . "_" . $cLabel);
		} catch (RedisException $e) {
			// TODO implement monitoring
			error_log("Unable to check key in Redis cache");
			return false;
		}
	case CACHE_DISK:
		return isset($_SESSION['cacheDisk'][$cLabel]);
	case CACHE_DISK_SHARED:
		return is_file(cacheRoot() . $cLabel);
	}
}

function cacheUnset($cLabel, $cType=CACHE_MEM) {
	$hasWildcard = (strpos($cLabel,"*") !== false);
	if(cacheExists($cLabel,$cType) || $hasWildcard) {
		switch($cType) {
			case CACHE_MEM:
			default:
				unset($GLOBALS['cacheMem'][$cLabel]);
				break;
			case CACHE_MEM_SHARED:
				if(!cacheMemSharedConnect()) {
					return false;
				}
				try {
					if(!$hasWildcard) {
						return $GLOBALS['cacheMemShared']->delete($GLOBALS['principal_id'] . "_" . $cLabel);
					} else {
						$keys = $GLOBALS['cacheMemShared']->keys($GLOBALS['principal_id'] . "_" . $cLabel);
						foreach($keys as $key) {
							$GLOBALS['cacheMemShared']->delete($key);
						}
						return true;
					}
				} catch (RedisException $e) {
					// TODO implement monitoring
					error_log("Unable to delete key from Redis cache");
					return false;
				}
			case CACHE_DISK:
				session_restart();
				unset($_SESSION['cacheDisk'][$cLabel]);
				session_write_close();
				break;
			case CACHE_DISK_SHARED:
				unlink(cacheRoot() . $cLabel);
				break;
		}
	}
}

function cacheRoot() {
	global $userStatusId;
	global $calAgentId;

	if(cacheExists("_cacheRoot")) {
		$cacheRoot = cacheGet("_cacheRoot");
	} else {
		$cacheRoot = $GLOBALS['cacheRoot'];
	
		if ($cacheRoot[(strlen($cacheRoot)-1)] != "/") {
			$cacheRoot .= "/";
		}

		
		if(!is_dir($cacheRoot)) {
			@mkdir($cacheRoot,0755);
		}

		$cacheRoot .= $GLOBALS['principal_id'] . "/";
		if(!is_dir($cacheRoot)) {
			@mkdir($cacheRoot,0755);
		}

		$cacheRoot .= "$GLOBALS[dbcode]_$GLOBALS[sc_group_id]";
		if($userStatusId < 2) {
			$cacheRoot .= "_$calAgentId";
		}
		$cacheRoot .= "/";

		if(!is_dir($cacheRoot)) {
			@mkdir($cacheRoot,0755);
		}
		cacheSet("_cacheRoot",$cacheRoot);
	}
	return $cacheRoot;
}

function cacheDiskLock($cLabel) {
	if(copy(cacheRoot() . $cLabel, cacheRoot() . $cLabel . ".lock")) {
		return true;
	} else {
		return false;
	}
}

function cacheDiskUnlock($cLabel) {
	if (unlink(cacheRoot() . $cLabel . ".lock")) {
		return true;
	} else {
		return false;
	}
} 


function cacheDiskLocked($cLabel) {
	return cacheExists($cLabel . ".lock", CACHE_DISK_SHARED);
}

function cacheDiskContents($cLabel) {
	$fd = @fopen(cacheRoot() . $cLabel,"r");
	if (!empty($fd)) {
		$contents = fread($fd, filesize(cacheRoot() . $cLabel));
		fclose($fd);
		return $contents;
	} else {
		die; // This may be wrong - it might be better to display an error here.
	}
} 

function cacheDiskSet($cLabel,$cValue) {
	$fp = @fopen(cacheRoot() . $cLabel,"w");
	if (!empty($fp)) {
		if (fputs($fp, $cValue)) {
			@fclose ($fp);
			return true;
		} else {
			return false;
		}
	} else {
		return false;
	}
} 

function cacheRemoveDir($dir) {
	if(!$dh = @opendir($dir)) return;
	while (($obj = @readdir($dh))) {
		if($obj=='.' || $obj=='..') continue;
		if(is_dir($dir.'/'.$obj)) {
			cacheRemoveDir($dir.'/'.$obj);
		} else {
			@unlink($dir.'/'.$obj);
		}
	}
	@closedir($dh);
	@rmdir($dir);
	cacheUnset("_cacheRoot");
}


function cacheClear() {
	$cacheRoot = $GLOBALS['cacheRoot'];
	
	if ($cacheRoot[(strlen($cacheRoot)-1)] != "/") {
		$cacheRoot .= "/";
	}

	if(is_dir($cacheRoot)) {
		cacheRemoveDir($cacheRoot);
	}

	$GLOBALS['cacheMem'] = array();

	session_restart();
	$_SESSION['cacheDisk'] = array();
	session_write_close();
}
