<?php

function csv_array_to_text($csvFile,$unixLines=true,$useTabs=false) {
	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) {
				if(!$useTabs) {
					$csvText .= ",";
				} else {
					$csvText .= "\t";
				}
			} else {
				$first = false;
			}
			if(!is_array($csvItem)) {
				if(!$useTabs) {
					$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
				} else {
					$csvText .= str_replace("\t","",$csvItem);
				}
			} else {
				$csvItem['type'] = isset($csvItem['type']) ? $csvItem['type'] : "";
				switch($csvItem['type']) {
				case "number":
					$csvText .= $csvItem['data'];
					break;
				}
			}
		}
		if($unixLines) {
			$csvText .= "\n";
		} else {
			$csvText .= "\r\n";
		}
	}
	return $csvText;
}

function csv_fix_filename($filename,$useTabs) {
	if(!$useTabs) {
		return $filename . ".csv";
	} else {
		return $filename . ".tsv";
	}
}

function csv_output($filename,$content,$die=true,$unixLines=true,$useTabs=false,$fixFilename=true) {
	$output = csv_array_to_text($content,$unixLines,$useTabs);
	if(headers_sent()) {
		echo('Some data has already been output to browser, can\'t send CSV file');
	}
	if(!$useTabs) {
		header('Content-Type: text/csv');
	} else {
		header('Content-Type: text/tab-separated-values');
	}
	header("Cache-control: private");
	header('Content-Length: '.strlen($output));

	$filename = strtolower(str_replace(" ","_",$filename));
	$filename = str_replace(",", "",$filename);
	if($fixFilename) {
		$filename = csv_fix_filename($filename,$useTabs);
	}
	header("Content-Disposition: inline; filename=$filename");
	ob_clean();
	echo $output;
	flush();
	if($die) {
		die();
	}
}

function xmlToCSV($xml) {
    if (trim($xml) == "") {
        return false;
    }

    $parser = xml_parser_create();
    xml_parse_into_struct($parser, $xml, $values, $index);
    xml_parser_free($parser);

    $csvText = array();
    $csvRow = array();
    $mergeCells = 0;

    foreach ($values as $value) {
        if ($value['tag'] == "ROW" && $value['type'] == "open") {
            $csvRow = array();  // new row
        }

        if ($value['tag'] == "CELL") {
            if (isset($value['attributes']['SS:MERGEACROSS'])) {
                $mergeCells = $value['attributes']['SS:MERGEACROSS'];
            }
        }

        if ($value['tag'] == "SS:DATA") {
            if (isset($value['attributes']['SS:TYPE']) && $value['attributes']['SS:TYPE'] == "String") {
                $val = isset($value['value']) ? $value['value'] : "";
                $val = str_replace(array("\r\n","\r","\n","\\n", "<br>"), " ", $val);
                $csvRow[] = '"'.$val.'"';
                
                if ($mergeCells != 0) {
                    foreach(range(1, $mergeCells) as $i) {
                        $csvRow[] = "";
                    }
                    $mergeCells = 0;
                }
            }
        }

        if ($value['tag'] == "ROW" && $value['type'] == "close") {
            $csvText[] = join(",", $csvRow);
        }
    }

    return join("\n", $csvText);
}