<?php

 /**
  * functions.datetime.php - Shared functions for date/time conversions with time zones
  * Job: 
  * Function:
  */

require_once(__DIR__ . "/db.sp_special.php");
require_once(__DIR__ . "/db.sp_rate_group_benefit.php");
require_once(__DIR__ . "/db.rv_special.php");
require_once(__DIR__ . "/class.specialmanager.php");

define("DATETIME_OBJECT",0);
define("DATETIME_FORMAT",1);


function convertDateTimeZone($timestamp, $original_timezone, $new_timezone, $mode = 1, $custom_format = '') {

	switch($mode) {
		case DATETIME_OBJECT:
			if ($original_timezone != $new_timezone) {
				$datetime_converted = new DateTime($timestamp, new DateTimeZone(date("e")) );
				$datetime_converted->setTimeZone( new DateTimeZone($new_timezone) );
			} else {
				$datetime_converted = new DateTime($timestamp);
			}
			return $datetime_converted;

		case DATETIME_FORMAT:
			$datetime_converted = new DateTime($timestamp, new DateTimeZone(date("e")) );
			$datetime_converted->setTimeZone( new DateTimeZone($new_timezone) );

			return array(
				"date" => $datetime_converted->format('d M Y'),
				"time" => $datetime_converted->format('H:i:s'),
				"datetime" => $datetime_converted->format('d M Y H:i:s'),
				"datetime_custom" => (!empty($custom_format)) ? $datetime_converted->format($custom_format) : ""
			);
	}
}

function zoneListingHTML($originalTimeZone = "") {
	$zones = '';
	$zones .= '<div class="rowHighlight" onclick="timezoneFilterSelect(\''.date("e").'\');" style="cursor: pointer; cursor: hand; padding-top:4px; padding-bottom:4px;">My Time Zone: '.date("e")."</div>";
	if (!empty($originalTimeZone)) {
		$zones .= '<div class="rowHighlight" onclick="timezoneFilterSelect(\''.$originalTimeZone.'\');" style="cursor: pointer; cursor: hand; padding-top:4px; padding-bottom:4px;">Original Time Zone: '.$originalTimeZone."</div>";
	}
	foreach(timezone_identifiers_list() as $zone) {
		$zones .= '<div class="rowHighlight" onclick="timezoneFilterSelect(\''.$zone.'\');" style="cursor: pointer; cursor: hand; padding-top:4px; padding-bottom:4px;">'.$zone."</div>";
	}
	return $zones;
}

function timezoneFilterContainerHTML($originalTimeZone = "") {
	$html = '
		<div id="timezoneFilterContainer" class="colLt" style="display:none; margin: 0px auto; width: 300px; height: 400px; border: 1px solid #663300; position:absolute;">
			<div class="outDk" style="text-align: center; padding:10px; font-size:13px;">Select Time Zone:</div>
			<div style="text-align:left; padding:20px; height: 295px; overflow-y: scroll;">
				'.zoneListingHTML($originalTimeZone = "").'
			</div>
			<div style="text-align:center;">
				<button class="button masterButton" type="button" onclick="timezoneFilterClose();" style="margin: 5px;">
					<span>Close</span>
				</button>
			</div>
		</div>
	';
	return $html;
}