<?php

/**
 * Determines whether a file with one of the extensions exists.
 * The returned value contains the keys 'exists', 'file', and
 * the 'extension' that matched.
 */
function fileExistsWithExtensions(
    string $directory,
    string $fileName,
    array $extensions
) {
    $result = [
        'exists' => false,
        'file' => '',
        'extension' => ''
    ];

    foreach ($extensions as $extension) {
        $file = $directory . DIRECTORY_SEPARATOR . $fileName . '.' . $extension;
        if (file_exists($file)) {
            $result['exists'] = true;
            $result['file'] = $fileName . '.' . $extension;
            $result['extension'] = $extension;
        }
    }

    return $result;
}

/**
 * Get the name of the image file with the extension that exists.
 * If emptyIfNotFound is set to true then an empty string will be
 * returned otherwise the image file concatenated with .jpg will
 * be returned.
 */
function imageFile($fileName, $emptyIfNotFound=true)
{
    $extensions = array(
        'jpg',
        'jpeg',
        'png',
        'pdf'
    );
    $principal_id = !empty($_SESSION['principal_id']) ? $_SESSION['principal_id'] : $GLOBALS['principal_id'];
    $directory = "$GLOBALS[images_dir_on_disk]/$principal_id";

    $fileWithExtensions = fileExistsWithExtensions($directory, $fileName, $extensions);
    if ($fileWithExtensions['exists']) {
        return $fileWithExtensions['file'];
    } else {
        if ($emptyIfNotFound) {
            return '';
        } else {
            return $fileName . '.jpg';
        }
    }
}

/**
 * Retrieves the name of the file with the extension if it exists
 * otherwise the name of the default file with the extension if it
 * doesn't.
 */
function imageFileWithDefault($fileName, $defaultFileName)
{
    $image = imageFile($fileName);

    if ($image) {
        return $image;
    }

    $image = imageFile($defaultFileName);

    if ($image) {
        return $image;
    }

    return $defaultFileName . '.jpg';
}