<?php
require_once(__DIR__ . "/functions.persona.php");
require_once(__DIR__ . "/db.fn_tran.php");
require_once(__DIR__ . "/db.sc_group.php");

function getItemsPerPayment($divKey,$resList,$rf_currency_id,$HTML,$mode="0",$rv_payment_id="", $folios=array()) {
	global $lDB;

	$rf_currency_symbol = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$rf_currency_id'",4);

	$resTag = "rowReplace";
	if ( !is_array($resList) ) {
		$resList = array($resList);
	}

	$blankObject = blankObject();
	$output = "";

	$rowNumber = str_replace("rowreplacer","",$divKey);

	foreach($resList as $rv_reservation_id) {
		$tagList = array();
		$sql = "SELECT DISTINCT ";

		if($mode != "0") {
			$sql .= "
				rv_payment_item.rv_payment_item_ix,
				rv_payment_item.rv_payment_item_db,
				rv_payment_item.rv_payment_item_amt,
				rv_payment_item.rv_pay_item_amt_rec,
				rv_payment_item.rv_pay_item_exch_rate,
				rv_payment_item.rv_payment_contra_id,
				rv_payment_item.rv_payment_id,
				rv_payment_item.rv_payment_item_trf_yn,
			";
		}

		$sql .= "
				rv_reservation.rv_reservation_ix AS resId,
				rv_reservation.rv_res_name AS resName,
				rv_reservation.rv_agent_ref AS agentRef,
				pr_persona.pr_name_last AS resAgent,
				fn_folio.fn_folio_ix AS folioId,
				fn_folio.fn_folio_amount AS folPayable,
				fn_folio.fn_folio_folio_num AS folioNum,
				fn_folio.pr_business_id,
				fn_folio.fn_folio_to_id,
				fn_folio.fn_invoice_id AS invoiceId,
				fn_invoice.fn_invoice_prefix,
				fn_invoice.fn_invoice_ix AS fnInvKey,
				rf_currency.rf_currency_symbol AS folioCurr,
				rf_currency.rf_currency_ix AS folioCurrId,
				ac_accomm_room.ac_desc
			FROM
		";
		if($mode != 0) {
			$sql .= "
				rv_payment_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_payment_item.rv_reservation_id
				LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment_item.rf_currency_id
			";
		} else {
			$sql .= "
				fn_folio
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			";
		}
		$sql .= "
				LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
				LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
				LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_folio.fn_invoice_id
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id 
			WHERE 
				rv_reservation.rv_reservation_ix = '$rv_reservation_id'
		";

		if($mode != "0") {
			$sql .= "
				AND rv_payment_item.rv_payment_id = '$rv_payment_id' 
			";
		}
		$sql .= "
			ORDER BY 
				rv_reservation.rv_reservation_ix
		";

		$result = $lDB->get($sql,2);
		$tagList[$resTag] = new tpParseTable();

		$i = 0;
		$dataArray = array();
		foreach($result as $row) {
			$data = array();

			$rv_reservation_id = "";
			if($i == 0) {
				$rv_reservation_id = $row['resId'];
			}

			if($rv_reservation_id != "") {
				$data['searchButton'] = setNewParam("onclick","resPopup('RSD_" . $divKey . "','" . $divKey . "');");

				$data['resId'] = setNewParam("value",$rv_reservation_id);
				$data['resId']->setParam("id","RSD_" . $divKey);
				$data['resId']->setParam("name",$rv_reservation_id);
				$data['resId']->setParam("onmouseout","nd();");
				$data['resId']->setParam("onmouseover","overlib('Voucher Ref: " . t_encodeOverlib($row['agentRef']) . "');");
				$data['resId']->setParam("readonly","readonly");

				$data['resName'] = $row['resName'];

				if ($row['resAgent'] == "") {
					$data['resAgent'] = "&nbsp;";
				} else {
					$data['resAgent'] = $row['resAgent'];
				}

				$data['docPopup'] = $blankObject;
				$data['folioButton'] = $blankObject;

				if($mode != "0") {
					$data['docPopup'] = setNewParam("name",$rv_reservation_id);
					$data['folioButton'] = setNewParam("name",$rv_reservation_id);
					$data['folioButton'] = setNewValue("&nbsp;");

					$data['resId']->setAttrib("disabled");

					$data['goRes'] = setNewParam("onmouseover","this.style.backgroundColor='#cfc';");
					$data['goRes']->setParam("onmouseout","this.style.backgroundColor='';");
					$data['goRes']->setParam("class","imgLink");
					$data['goRes']->setParam("onclick","Set_Cookie('finTabName','Payment'); window.location='/reservation.php?647+" . $rv_reservation_id . "';");
				}
			} else {
				$data['resId'] = $blankObject;
				$data['resIdDiv'] = "&nbsp;";
				$data['resName'] = "&nbsp;";
				$data['resAgent'] = "&nbsp;";
				$data['docPopup'] = $blankObject;
				$data['folioButton'] = $blankObject;
				$data['searchRes'] = setNewParam("style","visibility: hidden;");
				$data['searchRes'] = "&nbsp;";
			}

			if($mode != "0") {
				$disabled = "";
				if($row['rv_payment_contra_id'] != "" && $row['rv_payment_contra_id'] != "0") {
					$disabled = " disabled=\"disabled\" checked=\"checked\"";
				}

				$data['searchRes'] = "<input type=\"checkbox\" id=\"contraItems[" . $row['folioId'] . "]\" name=\"contraItems[" . $row['folioId'] . "]\" value=\"" . $row['rv_payment_item_ix'] . "\"" . $disabled . ">";
			}

			$canEdit = (
				db_sc_group_get_user_setting("sc_grp_res_void_payment_yn") == "1"
				&& (
					(isset($row['rv_payment_item_db']) && canEditDB($row['rv_payment_item_db']) )
					|| (
						(isset($row['rv_payment_item_db']) && $GLOBALS['dbcode'] == $row['rv_payment_item_db'])
						&& $row['rv_payment_item_trf_yn'] == "0"
						&& $GLOBALS['dbcode'][0] != "W"
					)
				)
			);

			if(!$canEdit) {
				$data['searchRes'] = "&nbsp;";
			}

			$folioName = "Folio  ";
			if($row['fnInvKey'] != "") {
				$folioName	= " " . $row['fn_invoice_prefix'] . " ";
				$folioName	= " " . $row['fnInvKey'] . " ";
				$invFolio = "Invoice Number: " . $row['fnInvKey'] . " ";

				if ( $row['invoiceId']) {
					$docId = "showInvoice('" . $row['invoiceId'] . "')";
				} else {
					$docId = "";
				}
			} else {
				$folioName .= $row['folioNum'];
				$invFolio = "Folio Number: " . $row['folioNum'];
				if ( $row['folioId'] ) {
					$docId = "showFolio('$row[folioId]')";
				} else {
					$docId = "";
				}
			}

			$folioTitle = $folioName;
			if ( trim($folioTitle) == "" ) {
				$folioTitle = "None";
			}
			$data['folioName'] = setNewValue("&nbsp;&nbsp;&nbsp;" . $folioTitle);
			$rowToLast = getPersona("pr_name_last",$row['fn_folio_to_id'],4);
			$rowToFirst = getPersona("pr_name_first",$row['fn_folio_to_id'],4);

			if ( $rowToFirst == "" ) {
				$row['TO'] = $rowToLast;
			} else {
				$row['TO'] = $rowToLast . ", " . $rowToFirst;
			}

			if ( $rowToLast == "" ) {
				$row['TO'] = $rowToFirst;
			}

			if ($row['TO'] == "0" ) {
				$row['TO'] = "N/A";
			}

			if ( $row['fn_folio_to_id'] == "" || $row['fn_folio_to_id'] == "0" ) {
				$row['TO'] = "Cash";
			}
			$row['BUS'] = getPersona("pr_name_last",$row['pr_business_id'],4);
			if ( $row['BUS'] == "0" ) {
				$row['BUS'] = "N/A";
			}

			if ( trim($row['ac_desc']) != "" ) {
				$room = "<br />Room: <strong>" . $row['ac_desc'] . "</strong>";
			} else {
				$room = "";
			}

            $data['folioName']->setParam("onmouseover","overlib('Folio ID: ". t_encodeOverlib($folioTitle) ."<br />To: " . t_encodeOverlib($row['TO']) . $room . "<br />Business Unit: " . t_encodeOverlib($row['BUS']) . "<br />',WIDTH,200)");
			$data['folioName']->setParam("onmouseout","nd()");
			$data['folioName']->setParam("onclick",$docId);

			$data['folioButton']->setParam("onmouseover","overlib('Open folio document',LEFT,WIDTH,100)");
			$data['folioButton']->setParam("onmouseout","nd()");
			$data['folioButton']->setParam("onclick",$docId);

			$paid = $lDB->get("SELECT SUM(rv_payment_item_amt) FROM rv_payment_item WHERE fn_folio_id = '" . $row['folioId'] . "'",4);
			$amount = $row['folPayable'] - $paid;
			$amount = (string) $amount;
			fixAmtDisplay($amount);

			$data['outstand'] = $amount;

			$data['folio_curr1'] = $row['folioCurr'];

			$data['folio_curr2'] = setNewParam("id","fc2_" . $rowNumber . "_" . $i);
			$data['folio_curr2']->setContent($row['folioCurr']);
			$data['folio_curr2'] = setNewParam("id","fc2_" . $rowNumber . "_" . $i);
			$data['folio_curr2']->setContent($row['folioCurr']);

			$data['folioDetails'] = setNewParam("id","fd_" . $rowNumber . "_" . $i);
			$data['folioDetails']->setContent($invFolio . "<br />To: " . $row['TO'] . "<br />Business Unit: " . $row['BUS']);
			$data['folioDetails']->setParam("class","collapse colWh printCollapse");
			$data['folioDetails']->setParam("style","position: relative; width: 640px; z-index: 3;");

			if ( $mode != "0" ) {
				fixAmtDisplay($row['rv_pay_item_amt_rec']);
				fixAmtDisplay($row['rv_pay_item_exch_rate'], exchDecimalPlaces());
				fixAmtDisplay($row['rv_payment_item_amt']);

				$data['recptAmount'] = setNewValue($row['rv_payment_item_amt']);
				$data['recptAmount']->setAttrib("disabled");
				$data['recptAmount']->setParam("id","recptAmount_" . $rowNumber . "_" . $i);
				$data['recptAmount']->setParam("name","recptAmount[" . $row['folioId'] . "]");

				$data['exchRate'] = setNewValue($row['rv_pay_item_exch_rate']);
				$data['exchRate']->setAttrib("disabled");
				$data['exchRate']->setParam("id","exchRate_" . $rowNumber . "_" . $i);
				$data['exchRate']->setParam("name","exchRate[" . $row['folioId'] . "]");

				$data['paidAmount'] = setNewValue($row['rv_pay_item_amt_rec']);
				$data['paidAmount']->setAttrib("disabled");
				$data['paidAmount']->setParam("id","folioPaid_" . $rowNumber . "_" . $i);
				$data['paidAmount']->setParam("name","paidAmount[" . $row['folioId'] . "]");
				$data['paidAmount']->setParam("cat","total");
			} else {
				if(!array_key_exists($row['folioId'],$folios)) {
					$data['paidAmount'] = setNewParam("id","folioPaid_" . $rowNumber . "_" . $i);
					$data['exchRate'] = setNewParam("id","exchRate_" . $rowNumber . "_" . $i);
					$data['recptAmount'] = setNewParam("id","recptAmount_" . $rowNumber . "_" . $i);
				} else {
					$data['paidAmount'] = setNewValue($folios[$row['folioId']]['paidAmount']);
					$data['paidAmount']->setParam("id","folioPaid_" . $rowNumber . "_" . $i);
					$data['exchRate'] = setNewValue($folios[$row['folioId']]['exchRate']);
					$data['exchRate']->setParam("id","exchRate_" . $rowNumber . "_" . $i);
					$data['recptAmount'] = setNewValue($folios[$row['folioId']]['recptAmount']);
					$data['recptAmount']->setParam("id","recptAmount_" . $rowNumber . "_" . $i);
				}
				$data['paidAmount']->setParam("onchange","relateTotal(this,'" . $rowNumber . "_" . $i . "','amnt')");
				$data['paidAmount']->setParam("name","paidAmount[" . $row['folioId'] . "]");
				$data['paidAmount']->setParam("cat","total");

				$data['exchRate']->setParam("onchange","relateTotal(this,'" . $rowNumber . "_" . $i . "','exch')");
				$data['exchRate']->setParam("name","exchRate[" . $row['folioId'] . "]");

				if ( $row['folioCurrId'] == $rf_currency_id ) {
					$data['exchRate']->setParam("value","1.00");
					$data['exchRate']->setAttrib("disabled");
				}

				$data['recptAmount']->setParam("onchange","relateTotal(this,'" . $rowNumber . "_" . $i . "','rcpt')");
				$data['recptAmount']->setParam("name","recptAmount[" . $row['folioId'] . "]");

				$data['folioId'] = setNewValue($row['folioId']);
				$data['folioId']->setParam("id","folioId_".$rowNumber."_".$i);
				$data['folioId']->setParam("name","folioId");

				$fn_system_id = $GLOBALS['lDB']->get("SELECT fn_system_id FROM pr_business WHERE pr_business_id = '$row[pr_business_id]'",4);
				$pr_bus_post_pmt_yn = $GLOBALS['lDB']->get("SELECT pr_bus_post_pmt_yn FROM pr_business WHERE pr_business_id = '$row[pr_business_id]'",4);
				$data['glCurrencyFromId'] = setNewValue($row['folioCurrId']);
				$data['glCurrencyFromId']->setParam("id","glCurrencyFromId_".$rowNumber."_".$i);
				if(db_fn_tran_payment_active($fn_system_id,$pr_bus_post_pmt_yn)) {
					$data['glCurrencyFromName'] = setNewValue($row['folioCurr']);
					$data['glCurrencyFromName']->setParam("id","glCurrencyFromName_".$rowNumber."_".$i);

					$glCurrencyId = $GLOBALS['lDB']->get("SELECT pr_bus_home_curr_id FROM pr_business WHERE pr_business_id = '$row[pr_business_id]'",4);
					$glCurrencySymbol = $GLOBALS['lDB']->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$glCurrencyId'",4);


					$data['glCurrencyToId'] = setNewValue($glCurrencyId);
					$data['glCurrencyToId']->setParam("id","glCurrencyToId_".$rowNumber."_".$i);
					$data['glCurrencyToName'] = setNewValue($glCurrencySymbol);
					$data['glCurrencyToName']->setParam("id","glCurrencyToName_".$rowNumber."_".$i);
					
					if(!array_key_exists($row['folioId'],$folios)) {
						$data['glCurrencyExchange'] = setNewValue("");
					} else {
						$data['glCurrencyExchange'] = setNewValue($folios[$row['folioId']]['glCurrencyExchange']);
					}
					$data['glCurrencyExchange']->setParam("id","glCurrencyExchange_".$rowNumber."_".$i);
					$data['glCurrencyExchange']->setParam("name","glCurrencyExchange[" . $row['folioId'] . "]");
				} else {
					//$data['glCurrencyFromId'] = $blankObject;
					$data['glCurrencyFromName'] = $blankObject;
					$data['glCurrencyToId'] = $blankObject;
					$data['glCurrencyToName'] = $blankObject;
					$data['glCurrencyExchange'] = $blankObject;
				}

			}
			$data['currPdSelect'] = setNewParam("id","fc1_" . $rowNumber . "_" . $i);
			$data['currPdSelect']->setContent($rf_currency_symbol);
			$data['recptCurr'] = $row['folioCurr'];

			array_push($dataArray,$data);
			$i++;
		}

		$tagList[$resTag]->Data = $dataArray;
		$tagList[$resTag]->setParam("id",$rv_reservation_id);
		$output .= tpParse($tagList,$HTML);

	}
	return $output;
}
