<?php

/**
 * Global Financial Functions
 *
 */

/*

Function with dependancies:

1) getDisplayExtTrvTotals($resId) - Gets total for extras / travel on a reservation - No link to accommodation calc
	init.form247.php - although init.form49.php does this in a different (and possibly correct way)
2) getDisplayResTotals($resId) - Gets the calculated reservation totals - No link to accommodation calc, only uses the totals
	init.form210.php
	init.form247.php
	init.form266.php
	init.form49.php
	init.form7.php
3) getDisplayAccommTotal($resId) - No link to accommodation calc, only uses the totals
	init.form212.php
	init.form213.php
	init.form247.php
4) getDisplayItemTotal($itemId) - No link to accommodation calc, only uses the totals
	functions.report.php
	init.form210.php
	init.form212.php
	init.form213.php
	init.form247.php
	init.form253.php
	init.form266.php
	init.form49.php
	init.form7.php
5) getCompTotals($record,$itemId=false,$folioId=false) - No link to accommodation calc, uses component nett or gross depending on deduct flag
	init.form215.php
	init.form253.php
	init.form395.php
6) recalcTotals($record,$mode="0",$itemList="",$batchmode="0") - RELATED -- OK for now
	regenFolio()
	regenBilling()
	db.rv_extra.php
	db.rv_payment_item.php
	functions.reservation_itinerary.php
	functions.transfer.common.php
	init.form0.php
	init.form219.php
	init.form247.php
	init.form248.php
	init.form313.php
	init.form366.php
	init.form86.php
	init.form87.php
7) getFolioList($rv_reservation_id) - No link to accommodation calc
	regenBilling()
8) regenFolio($fn_folio_id) - RELATED **DONE**
	init.form298.php
9) regenBilling($rv_reservation_id,$dbUpgrade=false)
	api/api.reservation.php
	init.form219.php
	init.form86.php
10) getExchange($reservationId,$folioId=false)  - No link to accommodation calc
	init.form215.php
	init.form253.php
	init.form395.php
11) getPayItems($reservationId,$resAmt=false,$adjustments=false,$folioId=false) - No link to accommodation calc
	init.form213.php
	init.form215.php
	init.form219.php
	init.form247.php
	init.form253.php
	init.form395.php
	init.form49.php
**) splitPaymentPlan($reservationId,$payItems) - No link to accommdation calc
	getPayItems()
12) getResDocTotals($reservationId,$accommRate=array(),$resExtra=array(),$resTravel=array(),$output="0",$flag=1,$folioId=false) - No link to accommodation calc
	init.form210.php
	init.form212.php
	init.form213.php
	init.form215.php
	init.form219.php
	init.form253.php
	init.form266.php
	init.form395.php
	init.form7.php
13) getExtraTotal($resExtra,$resData="0",$mode="0") - No link to accommodation calc
	getCompTotals()
	recalcTotals()
	init.form263.php
14) getRatePeriod($rv_item_date_arrive,$ac_accomm_type_id,$rt_rate_type_id) - RELATED -- No longer used by reports -- REMOVED
	functions.report.php
15) getRateDates($getRateDates) - RELATED
	init.form247.php
	init.form267.php
	init.form7.php
16) getItemDetails($rv_reservation_item_id) - No link to accommodation calc
	getResItemCost()
	functions.report.php
	functions.reservation.php
	inc.resitemfunction.php
	init.form210.php
	init.form212.php
	init.form213.php
	init.form247.php
	init.form266.php
	init.form304.php
	init.form49.php
	init.form7.php
	init.form86.php
	init.form87.php
17) getComponentDetails($rvResItemCompId) - RELATED - FIXED REMOVED
	getResItemCost()
	init.form86.php

18) getStdComponents($rv_reservation_item_id)- RELATED -- REMOVED
	getResItemCost()
19) calcComponentCost($resItemDetails,$compDetails) - RELATED FIXED - **REMOVED**
	getResItemCost()

20) getResItemCost($rv_reservation_item_id, $resItem="",$calc="1") - RELATED -- FIXED to use rate object
	functions.report.php -- No longer used
	init.form86.php
	init.form87.php
21) getTotalItemCost($components) - RELATED -- OK
	functions.report.php
	init.form86.php -- no longer used
	init.form87.php -- no longer used:
*22) getReservationCost($rvReservationId) - not used, can be removed *REMOVED*
23) genPaymentPlan($rvReservationId, $acPayPlanId="", $fnFolioList=array()) - No link to accomm calc
	regenBilling()
	init.form213.php
	init.form219.php

In functions.report.php

1) getAccommRateData()
	init.form215.php
	init.form247.php
	init.form253.php
	init.form395.php
 */

require_once(__DIR__ . "/functions.reservation.php");
require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/db.fn_folio.php");
require_once(__DIR__ . "/db.rv_extra.php");
require_once(__DIR__ . "/db.tc_res_update.php");
require_once(__DIR__ . "/class.itinerary.php");

function getDisplayExtTrvTotals($resId) {
	global $lDB;
	$extraCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_extra
		WHERE
			rv_extra.rv_reservation_id = '$resId'
			AND rv_extra.rv_extra_void_ind = '0'
	",4);
	
	if ($extraCount < 1) {
		return "N / A";
	} else {
		$data = $lDB->get("
			SELECT
				rv_tba_extra_yn,
				rv_tba_travel_yn,
				rv_commission_deduct_yn
			FROM
				rv_reservation
			WHERE
				rv_reservation_ix = '$resId'
		",1);
		if ($data['rv_tba_extra_yn'] == "1" || $data['rv_tba_travel_yn'] == "1") {
			return "TBA";
		} else {
			$rv_commission_deduct_yn = $data['rv_commission_deduct_yn'];
			if ($rv_commission_deduct_yn == "1") {
				$result = $lDB->get("SELECT rv_amt_extra_nett, rv_amt_travel_nett FROM rv_reservation WHERE rv_reservation_ix = '$resId'",1);
				$result = $result['rv_amt_extra_nett'] + $result['rv_amt_travel_nett'];
			} else {
				$result = $lDB->get("SELECT rv_amt_extra_gross, rv_amt_travel_gross FROM rv_reservation WHERE rv_reservation_ix = '$resId'",1);
				$result = $result['rv_amt_extra_gross'] + $result['rv_amt_travel_gross'];
			}
			fixAmtDisplay($result);
			return $result;
		}
	}
}

function getDisplayResTotals($resId) {
	global $lDB;
	
	$data = $lDB->get("
		SELECT
			rv_tba_extra_yn,
			rv_tba_travel_yn,
			rv_commission_deduct_yn
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '$resId'
	",1);
	if ($data['rv_tba_extra_yn'] == "1" || $data['rv_tba_travel_yn'] == "1") {
		return "TBA";
	}
	$rv_commission_deduct_yn = $data['rv_commission_deduct_yn'];
	if ($rv_commission_deduct_yn == "1") {
		$result = $lDB->get("
			SELECT
				rv_amt_accomm_nett,
				rv_amt_extra_nett,
				rv_amt_travel_nett
			FROM
				rv_reservation
			WHERE
				rv_reservation_ix = '$resId'
		",1);
		if (isset($result['rv_amt_accomm_nett'])) {
			$result = $result['rv_amt_accomm_nett'] + $result['rv_amt_extra_nett'] + $result['rv_amt_travel_nett'];
		} else {
			$result = NULL;
		}
	} else {
		$result = $lDB->get("
			SELECT
				rv_amt_accomm_gross,
				rv_amt_extra_gross,
				rv_amt_travel_gross
			FROM
				rv_reservation
			WHERE
				rv_reservation_ix = '$resId'
		",1);
		if (isset($result['rv_amt_accomm_gross'])) {
			$result = $result['rv_amt_accomm_gross'] + $result['rv_amt_extra_gross'] + $result['rv_amt_travel_gross'];
		} else {
			$result = NULL;
		}
	}

	if (isset($result) || is_array($result)) {
		fixAmtDisplay($result);
	} else {
		$result = "TBA";
	}
	return $result;
}

function getDisplayAccommTotal($resId) {
	global $lDB;
	
	$rv_commission_deduct_yn = $lDB->get("SELECT rv_commission_deduct_yn FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
	if ($rv_commission_deduct_yn == "1") {
		$result = $lDB->get("SELECT rv_amt_accomm_nett FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
	} else {
		$result = $lDB->get("SELECT rv_amt_accomm_gross FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
	}

	if (isset($result)) {
		fixAmtDisplay($result);
	} else {
		$result = "TBA";
	}
	return $result;
}

function getDisplayItemTotal($itemId) {
	global $lDB;
	
	$rv_commission_deduct_yn = $lDB->get("
		SELECT
			rv_reservation.rv_commission_deduct_yn
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$itemId'
	",4);
	if ($rv_commission_deduct_yn == "1") {
		$result = $lDB->get("SELECT rv_item_amt_nett FROM rv_reservation_item WHERE rv_reservation_item.rv_reservation_item_ix = '$itemId'",4);
	} else {
		$result = $lDB->get("SELECT rv_item_amt_gross FROM rv_reservation_item WHERE rv_reservation_item.rv_reservation_item_ix ='$itemId'",4);
	}

	if (isset($result)) {
		fixAmtDisplay($result);
	} else {
		$result = "TBA";
	}
	return $result;
}

function getCompTotals($record,$itemId=false,$folioId=false) { // Property of Dylan
	global $lDB;
	
	$result = array();
	$result['Accommodation'] = array();
	$result['Accomm-Extras'] = array();
	$result['Extras'] = array();
	$result['Travel'] = array();
	$result['Totals'] = array();

	if($folioId === false) {
		if ($itemId !== false) {
			$itemList = array($itemId);
		} else {
			$itemList = $lDB->get("select rv_reservation_item_ix from rv_reservation_item where rv_reservation_id = '$record'",3);
		}

		$itemId = join("','",$itemList);

		$sqlItemWhere = "
               rv_reservation_item.rv_reservation_item_ix IN ('$itemId')
		";
		$sqlExtraWhere = "
			rv_extra.rv_reservation_id = '".$record."'
		";
	} else {
		$sqlItemWhere = "
			rv_reservation_item.fn_folio_id = '$folioId'
		";
		$sqlExtraWhere = "
			rv_extra.fn_folio_id = '$folioId'
		";
	}
	$sqlExtraWhere .= "
			AND rv_extra.rv_extra_void_ind = '0'
	";
	// TBA CHECK
	$compCount = $lDB->get("
		SELECT
			COUNT(rv_res_item_comp.rv_res_item_comp_ix)
		FROM
			rv_reservation_item
			LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		WHERE
			$sqlItemWhere
		GROUP BY
			rv_reservation_item.rv_reservation_item_ix
	",3);
	if(in_array(0,$compCount)) {
		$isTBA = true;
	} else {
		$isTBA = false;
	}
	// END TBA CHECK
	$rv_commission_deduct_yn = $lDB->get("SELECT rv_commission_deduct_yn FROM rv_reservation where rv_reservation_ix = '$record'",4);
	$invCurr = $lDB->get("
		SELECT
			rf_currency.rf_currency_symbol
		FROM
			rv_reservation
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
		WHERE
			rv_reservation.rv_reservation_ix = '$record'
	",4);

	if ($rv_commission_deduct_yn == "0") {
		$payField = "rv_item_comp_amt_gross";
	} else {
		$payField = "rv_item_comp_amt_nett";
	}
	$components = $lDB->get("
		SELECT
			rv_res_item_comp.rt_component_id compId,
			rt_component.rt_component_desc as compDesc,
			rv_res_item_comp.rt_tax_id,
			rv_res_item_comp.rt_tax_ind,
			SUM(rv_res_item_comp.rv_item_comp_amt_tax) as taxAmt,
			SUM(rv_res_item_comp.$payField) as payAmt
		FROM
			rv_res_item_comp
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
			LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
		WHERE
			$sqlItemWhere
		GROUP BY
			rv_res_item_comp.rt_component_id,
			rv_res_item_comp.rt_tax_ind, rv_res_item_comp.rt_tax_id
		ORDER BY
			rt_component.rt_component_desc
	",2);

	$components = array_merge($lDB->get($sql = "
		SELECT
			rv_extra.rv_extra_ix as compId,
			ac_extra.ac_ext_desc as compDesc,
			rv_extra.rv_extra_tax_perc as taxRate,
			rv_extra_charge as extr_chrg,
			rv_extra_discount as extr_disc,
			rv_extra_ind as extr_ind,
			rv_extra_units as extr_units,
			rv_extra_nights as extr_nights,
			rv_extra_exch_rate as exch_rate,
			rv_extra_comm_pay as extr_cpay,
			1 as isExtra,
			rv_extra_ind as cat_ind,
			rf_currency.rf_currency_symbol
		FROM
			rv_extra
			LEFT JOIN ac_extra ON rv_extra.ac_extra_id = ac_extra.ac_extra_ix
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_extra.rv_extra_inv_curr_id
		WHERE
			$sqlExtraWhere
	",2),$components);

	$taxTotal = 0;
	$payTotal = 0;
	$imax = sizeof($components);
	$lastCurrency = false;
	for ($i=0; $i<$imax; $i++) {
		if (isset($components[$i]['isExtra']) && $components[$i]['isExtra'] == "1") {
			if ($components[$i]['cat_ind'] == "2") {
				$cat = "Travel";
			} else if ($components[$i]['cat_ind'] == "3") {
				$cat = "Accomm-Extras";
			} else {
				$cat = "Extras";
			}
			$extrArray = array(
				"rv_extra_charge" => $components[$i]['extr_chrg'],
				"rv_extra_discount" => $components[$i]['extr_disc'],
				"rv_extra_units" => $components[$i]['extr_units'],
				"rv_extra_ind" => $components[$i]['extr_ind'],
				"rv_extra_nights" => $components[$i]['extr_nights'],
				"rv_extra_exch_rate" => $components[$i]['exch_rate'],
				"rv_reservation_id" => $record,
				"rv_extra_comm_pay" => $components[$i]['extr_cpay'],
				"rv_extra_id" => $components[$i]['compId']
			);
			$components[$i]['payAmt'] = getExtraTotal($extrArray);

			$gross = $components[$i]['payAmt'];
			$commission = ($components[$i]['payAmt'] * $components[$i]['extr_cpay']/100);
			$net = $gross - $commission;
			if ($rv_commission_deduct_yn == "1") {
				$taxAmount = $net;
			} else {
				$taxAmount = $gross;
			}
			$components[$i]['taxAmt'] = round($taxAmount / ($components[$i]['taxRate'] + 100) * $components[$i]['taxRate'],6);
		} else {
			$cat = "Accommodation";
			$components[$i]['rf_currency_symbol'] = $invCurr;
		}
		if($lastCurrency === false && $lastCurrency != "!!!") {
			$lastCurrency = $components[$i]['rf_currency_symbol'];
		}
		if($lastCurrency != $components[$i]['rf_currency_symbol']) {
			$lastCurrency = "!!!";
		}

		if (isset($components[$i]['rt_tax_ind']) && $components[$i]['rt_tax_ind'] == 10){
			$components[$i]['taxRate']  = $lDB->get("SELECT rf_tax_rate_desc FROM rf_tax_rate WHERE rf_tax_rate.rf_tax_rate_ix = '".$components[$i]['rt_tax_id']."'",4);
		} else {
			if (isset($components[$i]['rt_tax_id'])) {
				$components[$i]['taxRate']  = $lDB->get("SELECT rt_tax_group_abbrev FROM rt_tax_group WHERE rt_tax_group.rt_tax_group_ix = '".$components[$i]['rt_tax_id']."'",4);	
			}
		}		
		
		if ($components[$i]['payAmt'] != null) {
			#echo $cat."+ ".$components[$i]['payAmt']."<br>";
			$components[$i]['taxAmt'] = round($components[$i]['taxAmt'],2);
			fixAmtDisplay($components[$i]['taxAmt'],2);
			$components[$i]['payAmt'] = round($components[$i]['payAmt'],2);
			fixAmtDisplay($components[$i]['payAmt'],2);
			$comp = array(
					"compId" => $components[$i]['compId'],
					"compDesc" => $components[$i]['compDesc'],
					"taxRate" => (isset($components[$i]['taxRate']) ? $components[$i]['taxRate'] : ""),
					"taxAmt" => $components[$i]['taxAmt'],
					"payAmt" => $components[$i]['payAmt'],
					"rf_currency_symbol" => $components[$i]['rf_currency_symbol']
			);
			array_push($result[$cat],$comp);
			$taxTotal = $taxTotal + $components[$i]['taxAmt'];
			$payTotal = $payTotal + $components[$i]['payAmt'];
		}
	}
	fixAmtDisplay($taxTotal);
	fixAmtDisplay($payTotal);
	if($isTBA) {
		$taxTotal = "";
		$payTotal = "TBA";
	}
	if($lastCurrency == "!!!") {
		//$result['Totals'] = null;
	} else {
		$result['Totals'][0] = array("compId" => "0", "compDesc" => "Totals", "taxRate" => "", "taxAmt" => $taxTotal, "payAmt" => $payTotal, "rf_currency_symbol" => $lastCurrency);
	}
	
	return $result;
}

function recalcTotals($record,$mode="0",$itemList="",$batchmode="0") {
	global $lDB;

	$oldFlagChngs = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = "0";
	$wasMaster = false;
	if ($lDB->isMaster == "0") {
		$lDB->isMaster = "1";
		$wasMaster = true;
	}
	list($rf_reservation_status_id,$rv_commission_deduct_yn) = $lDB->get("SELECT rf_reservation_status_id, rv_commission_deduct_yn FROM rv_reservation WHERE rv_reservation_ix = '$record'",1);
	// Only recalculate itinerary totals for non-allocation itineraries for increased performance
	if($rf_reservation_status_id != 15 && $rf_reservation_status_id != 97) {
		if ($mode == "0" || $mode == "4" || $mode == "5") {
			if ($itemList == "") {
				$itemList = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$record'",3);
			} else {
				if (!is_array($itemList)) {
					$itemList = array($itemList);
				}
			}
			foreach($itemList as $itemId){
				$itinerary = new Itinerary();
				$itinerary->SetReservationItemId($itemId);
				$itinerary->UpdateTotals();
			}
		}

		if ($mode == "0" || $mode == "1" || $mode == "4" || $batchmode == "1") {
			// update item row component amounts
			if ($itemList == "") {
				$list = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$record'",3);
			} else {
				if (!is_array($itemList)) {
					$list = array($itemList);
				} else {
					$list = $itemList;
				}
			}
			$imax = sizeof($list);
			for($i=0; $i<$imax; $i++) {
				$itemId = $list[$i];

				// update reservation row item amounts
				$totals = $lDB->get("
					SELECT
						SUM(rv_item_comp_amt_gross) as gross,
						SUM(rv_item_comp_amt_nett) as nett,
						SUM(rv_item_comp_amt_comm) as comm,
						SUM(rv_item_comp_amt_tax) as tax,
						SUM(rv_item_comp_amt_sp_discount) as special
					FROM
						rv_res_item_comp
					WHERE
						rv_reservation_item_id = '$itemId'
				",1);

				$gross_total = $totals['gross'];
				$nett_total = $totals['nett'];
				$comm_total = $totals['comm'];
				$tax_total = $totals['tax'];
				$special_total = $totals['special'];

				if ($batchmode == "1") {
					// Compare the saved totals with the item total.
					$itemTotal = $lDB->get("
						SELECT
							rv_item_amt_gross as gross,
							rv_item_amt_nett as nett,
							rv_item_amt_comm as comm,
							rv_item_amt_tax as tax
						FROM
							rv_reservation_item
						WHERE
							rv_reservation_item_ix = '$itemId'
					",1);

					$error = "";
					if ($totals['gross'] != $itemTotal['gross']) {
						if ($totals['gross'] == "0" && $itemTotal['gross'] == "") {
							echo $record." (".$itemId.") TBA totals<br>\n";
							flush();
							return;
						} else {
							$error .= "Gross totals differ! Components = '".$totals['gross']."', Item = '".$itemTotal['gross']."'<br>";
						}
					}
					if ($totals['nett'] != $itemTotal['nett']) {
						$error .= "Nett totals differ! Components = '".$totals['nett']."', Item = '".$itemTotal['nett']."'<br>";
					}
					if ($totals['comm'] != $itemTotal['comm']) {
						$error .= "Commission totals differ! Components = '".$totals['comm']."', Item = '".$itemTotal['comm']."'<br>";
					}
					if ($totals['tax'] != $itemTotal['tax']) {
						$error .= "Tax totals differ! Components = '".$totals['tax']."', Item = '".$itemTotal['tax']."'<br>";
					}

					if ($error != "") {
						echo $record." (".$itemId.") Totals differ<!-- ".$error." --><br>\n";
						flush();
					} else {
						if ($totals['gross'] != "0" && $totals['gross'] != "") {
							echo $record." (".$itemId.") Successful!<br>\n";
							flush();
						}
					}
				} else {
					if ($gross_total <> 0 && $gross_total != "") {
						if($rv_commission_deduct_yn == 1) {
							$payable_total = $nett_total;
						} else {
							$payable_total = $gross_total;
						}
						$sql = "
							UPDATE rv_reservation_item SET
								rv_item_amt_gross = '$gross_total',
								rv_item_amt_nett = '$nett_total',
								rv_item_amt_comm = '$comm_total',
								rv_item_amt_tax = '$tax_total',
								rv_item_amt_payable = '$payable_total',
								rv_item_amt_sp_discount = '$special_total'
							WHERE
								rv_reservation_item_ix = '$itemId'
						";
					} else {
						$count = $lDB->get("SELECT COUNT(*) FROM rv_res_item_comp WHERE rv_reservation_item_id = '$itemId'",4);
						if ($count > 0) {
							$sql = "
								UPDATE rv_reservation_item SET
									rv_item_amt_gross = '0',
									rv_item_amt_nett = '0',
									rv_item_amt_comm = '0',
									rv_item_amt_tax = '0',
									rv_item_amt_payable = '0',
									rv_item_amt_sp_discount = '0'
								WHERE
									rv_reservation_item_ix = '$itemId'
							";
						} else {
							$sql = "
								UPDATE rv_reservation_item SET
									rv_item_amt_gross = NULL,
									rv_item_amt_nett = NULL,
									rv_item_amt_comm = NULL,
									rv_item_amt_tax = NULL,
									rv_item_amt_payable = NULL,
									rv_item_amt_sp_discount = NULL
								WHERE
									rv_reservation_item_ix = '$itemId'
							";
						}
					}
					$lDB->put($sql);
				}
			}
		}

		if ($mode == "0" || $mode == "2" || $mode == "4") {
			$count = $lDB->get("SELECT count(*) FROM rv_reservation_item WHERE rv_item_amt_gross IS NULL AND rv_reservation_id = '$record'",4);
			if ($count <> 0) {
				$totals = array("gross" => "NULL", "nett" => "NULL", "comm" => "NULL", "tax" => "NULL");
			} else {
				// update reservation row item amounts
				$totals = $lDB->get("
					SELECT
						SUM(rv_item_amt_gross) as gross,
						SUM(rv_item_amt_nett) as nett,
						SUM(rv_item_amt_comm) as comm,
						SUM(rv_item_amt_tax) as tax,
						SUM(rv_item_amt_sp_discount) as special
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_id = '$record'
				",1);
			}

			if($rv_commission_deduct_yn == 1) {
				$payable_total = $totals['nett'];
			} else {
				$payable_total = $totals['gross'];
			}
			
			if($totals['gross'] != "NULL") {
				$lDB->put("
					UPDATE rv_reservation SET
						rv_amt_accomm_gross = '$totals[gross]',
						rv_amt_accomm_nett = '$totals[nett]',
						rv_amt_accomm_comm = '$totals[comm]',
						rv_amt_accomm_tax = '$totals[tax]',
						rv_amt_accomm_payable = '$payable_total',
						rv_amt_sp_discount = '$totals[special]'
					WHERE
						rv_reservation_ix = '$record'
				");
			} else {
				$lDB->put("
					UPDATE rv_reservation SET
						rv_amt_accomm_gross = NULL,
						rv_amt_accomm_nett = NULL,
						rv_amt_accomm_comm = NULL,
						rv_amt_accomm_tax = NULL,
						rv_amt_accomm_payable = NULL,
						rv_amt_sp_discount = NULL
					WHERE
						rv_reservation_ix = '$record'
				");
			}
		}
	} else {
		$lDB->put("
			UPDATE rv_reservation SET
				rv_amt_accomm_gross = NULL,
				rv_amt_accomm_nett = NULL,
				rv_amt_accomm_comm = NULL,
				rv_amt_accomm_tax = NULL,
				rv_amt_accomm_payable = NULL,
				rv_amt_sp_discount = NULL
			WHERE
				rv_reservation_ix = '$record'
		");
	}

	if ($mode == "0" || $mode == "3") {
		$resCurr = getInvCurr($record);
		// update reservation row extra and travel amounts
		$list = $lDB->get("SELECT rv_extra_ix FROM rv_extra WHERE rv_extra.rv_reservation_id = '$record'",3);
		foreach($list as $item) {
			db_rv_extra_update_totals($item);
		}
		$list = $lDB->get("
			SELECT
				rv_extra.rv_extra_discount as extr_disc,
				rv_extra.rv_extra_comm_pay as extr_cpay,
				rv_extra.rv_extra_units as extr_units,
				rv_extra.rv_extra_ind as extr_ind,
				rv_extra.rv_extra_nights as extr_nights,
				rv_extra.rv_extra_charge as extr_chrg,
				rv_extra.rv_extra_tax_perc as extr_perc,
				rv_extra.rv_extra_exch_rate as exch_rate,
				rv_extra.rv_extra_ind as extr_travel,
				rv_extra.rf_currency_id as extr_curr,
				rv_extra.rv_extra_ix as rv_extra_id
			FROM
				rv_extra
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_extra.rf_currency_id
			WHERE
				rv_extra.rv_reservation_id = '$record'
				AND rv_extra.rv_extra_void_ind = '0'
		",2);

		$ext_gross_total = 0;
		$ext_nett_total = 0;
		$ext_comm_total = 0;
		$ext_tax_total = 0;

		$trv_gross_total = 0;
		$trv_nett_total = 0;
		$trv_comm_total = 0;
		$trv_tax_total = 0;

		$extraTBA = 0;
		$travelTBA = 0;
		
		$imax = sizeof($list);
		for($i=0; $i<$imax; $i++) {			 
			$extra = $list[$i];
			//EXTRATOTAL
			$extrArray = array("rv_extra_charge" => $extra['extr_chrg'], "rv_extra_discount" => $extra['extr_disc'], "rv_extra_units" => $extra['extr_units'], "rv_extra_ind" => $extra['extr_ind'], "rv_extra_nights" => $extra['extr_nights'], "rv_extra_exch_rate" => $extra['exch_rate'], "rv_reservation_id" => $record, "rv_extra_comm_pay" => $extra['extr_cpay'], "rv_extra_id" => $extra['rv_extra_id']);
			$extra['extr_amnt'] = getExtraTotal($extrArray,0,2);

			$gross = $extra['extr_amnt'];
			$commission = ($extra['extr_amnt'] * $extra['extr_cpay']/100);
			$net = $gross - $commission;
			if ($rv_commission_deduct_yn == "1") {
				$taxAmount = $net;
			} else {
				$taxAmount = $gross;
			}
			$tax = $taxAmount / ($extra['extr_perc'] + 100) * $extra['extr_perc'];

			// Calc totals for the reservation row
			if ($extra['extr_travel'] != "2") {
				$ext_gross_total = $ext_gross_total + $gross;
				$ext_nett_total = $ext_nett_total + $net;
				$ext_comm_total = $ext_comm_total + $commission;
				$ext_tax_total = $ext_tax_total + $tax;

				// Toggle the extra TBA indicator if required
				if ($extra['extr_curr'] != $resCurr && $extra['exch_rate'] == 0 && $extraTBA == 0) {
					$extraTBA = 1;
				}
			} else {
				$trv_gross_total = $trv_gross_total + $gross;
				$trv_nett_total = $trv_nett_total + $net;
				$trv_comm_total = $trv_comm_total + $commission;
				$trv_tax_total = $trv_tax_total + $tax;

				// Toggle the extra TBA indicator if required
				if ($extra['extr_curr'] != $resCurr && $extra['exch_rate'] == 0 && $travelTBA == 0) {
					$travelTBA = 1;
				}
			}
		}

		$ext_gross_total = round($ext_gross_total,2);
		$ext_nett_total = round($ext_nett_total,2);
		$ext_comm_total = round($ext_comm_total,2);
		$ext_tax_total = round($ext_tax_total,6);

		$trv_gross_total = round($trv_gross_total,2);
		$trv_nett_total = round($trv_nett_total,2);
		$trv_comm_total = round($trv_comm_total,2);
		$trv_tax_total = round($trv_tax_total,6);

		if($rv_commission_deduct_yn == 1) {
			$ext_payable = $ext_nett_total;
			$trv_payable = $trv_nett_total;
		} else {
			$ext_payable = $ext_gross_total;
			$trv_payable = $trv_gross_total;
		}

		$lDB->put("
			UPDATE rv_reservation SET
				rv_amt_extra_payable = '".db_round($ext_payable)."',
				rv_amt_extra_gross = '".db_round($ext_gross_total)."',
				rv_amt_extra_comm = '".db_round($ext_comm_total)."',
				rv_amt_extra_nett = '".db_round($ext_nett_total)."',
				rv_amt_extra_tax = '".db_round($ext_tax_total,6)."',
				rv_tba_extra_yn = '$extraTBA'
			WHERE
				rv_reservation_ix = '$record'
		");
		
		$lDB->put("
			UPDATE rv_reservation SET
				rv_amt_travel_payable = '".db_round($trv_payable)."',
				rv_amt_travel_gross = '".db_round($trv_gross_total)."',
				rv_amt_travel_comm = '".db_round($trv_comm_total)."',
				rv_amt_travel_nett = '".db_round($trv_nett_total)."',
				rv_amt_travel_tax = '".db_round($trv_tax_total,6)."',
				rv_tba_travel_yn = '$travelTBA'
			WHERE
				rv_reservation_ix = '$record'
		");
	}
	$folioList = $lDB->get("SELECT fn_folio_ix FROM fn_folio WHERE rv_reservation_id = '$record'",3);
	foreach($folioList as $item) {
		db_fn_folio_update_totals($item);
	}
	db_rv_reservation_update_paid_amount($record);
	if($wasMaster) {
		$lDB->isMaster = "0";
	}
	db_tc_res_update_insert($record);
	updateReservation($record);
	$GLOBALS['flagChngs'] = $oldFlagChngs;
}

function getFolioList($rv_reservation_id) {

	// list all folios for this reservation that were created under this environment and that are not invoiced and that don't have payment items linked to them.
	global $lDB;
	global $dbcode;

	if($dbcode[0] == "R" || $dbcode[0] == "W") {
		// Lookup all web / resoffice database codes
		$dbCodeList = $lDB->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind <= 2",3);
	} else {
		// Must be a property
		$dbCodeList = array($dbcode);
	}
	
	$fnFolioList = $lDB->get("
		SELECT
			fn_folio.fn_folio_ix
		FROM
			fn_folio
		WHERE
			(
				fn_folio.fn_invoice_id IS NULL
				OR fn_folio.fn_invoice_id = '0'
				OR TRIM(fn_folio.fn_invoice_id) = ''
			)
			AND fn_folio.rv_reservation_id = '$rv_reservation_id'
			AND fn_folio_db IN ('".join("','",$dbCodeList)."')
	",2);
	$result = array();
	$imax = sizeof($fnFolioList);
	for ($i=0; $i<$imax; $i++) {
		$allow = true;
		$fnFolioId = $fnFolioList[$i]['fn_folio_ix'];

		// Verify only unpaid folios, of folios with a 0 payment balance are allowed
		$payTotal = $lDB->get("select SUM(rv_payment_item_amt) from rv_payment_item where fn_folio_id = '".$fnFolioId."'",4);
		if ($payTotal != "0" && trim($payTotal) != "") {
			$allow = false;
		}
		if($allow) {
			array_push($result,$fnFolioId);
		}
	}
	return $result;
}

function regenReservation($rv_reservation_id) {
	global $lDB;

	$folioList = $lDB->get("
		SELECT
			fn_folio.fn_folio_ix
		FROM
			fn_folio
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8
		WHERE
			fn_folio.rv_reservation_id = '$rv_reservation_id'
			AND fn_invoice.fn_invoice_ix IS NULL
	",3);

	foreach($folioList as $fn_folio_id) {
		regenFolio($fn_folio_id);
	}
	specialsAutoApply($rv_reservation_id, false, true);
}

function regenFolio($fn_folio_id) {
	global $lDB;

	$itemList = $lDB->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.fn_folio_id = '$fn_folio_id'
	",3);
	foreach($itemList as $rv_reservation_item_id) {
		$itinerary = new Itinerary();
		$itinerary->SetReservationItemId($rv_reservation_item_id);
		$itinerary->RegenerateRate();
	}
	db_fn_folio_update_totals($fn_folio_id);
	$rv_reservation_id = $lDB->get("SELECT rv_reservation_id FROM fn_folio WHERE fn_folio_ix = '$fn_folio_id'",4);
	recalcTotals($rv_reservation_id,"0",$itemList);
}

function regenBilling($rv_reservation_id,$dbUpgrade=false,$keepTBAs=false) {
	global $lDB;
	global $dbcode;

	if (!$dbUpgrade) {
		// List all uninvoiced folios for this reservation, created on this environment, that don't have any payment items linked.
		$fnFolioList = getFolioList($rv_reservation_id);

		if ($fnFolioList != array()) {
			// For each folio in the list, unlink reservation items, extras and travel items,then delete the empty folio.
			$imax = sizeof($fnFolioList);
			for ($i=0; $i<$imax; $i++) {
				$folio_id = $fnFolioList[$i];
				$resItems = $lDB->get("
					SELECT
						rv_reservation_item_ix
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_id = '$rv_reservation_id'
						AND fn_folio_id = '$folio_id'
				",3);

				foreach($resItems as $item){
					$lDB->put("
						UPDATE rv_reservation_item SET
							fn_folio_id = NULL
						WHERE
							rv_reservation_item_ix = '$item'
					");
				}
				
				$extraItems = $lDB->get("
					SELECT
						rv_extra_ix
					FROM
						rv_extra
					WHERE
						rv_reservation_id = '$rv_reservation_id'
						AND fn_folio_id = '$folio_id'
				",3);
				foreach($extraItems as $item){
					$lDB->put("
						UPDATE rv_extra SET
							fn_folio_id = NULL
						WHERE
							rv_extra_ix = '$item'
					");
				}
			}
			$list = $lDB->get("SELECT fn_folio_ix FROM fn_folio where fn_folio_ix IN ('".join("','",$fnFolioList)."')",3);
			foreach ($list as $folio_id) {
				//$lDB->put("DELETE FROM fn_folio WHERE fn_folio_ix = '$folio_id'");
				db_fn_folio_delete_by_id($folio_id);
			}
		}
	}

	// Regenerate and re-allocate reservation items to folios according to the standard ruleset.
	$itemList = $lDB->get("
		SELECT
			rv_reservation_item_ix
		FROM
			rv_reservation_item
		WHERE
			(
				fn_folio_id IS NULL
				OR fn_folio_id = '0'
				OR trim(fn_folio_id) = ''
			) AND (
				fn_invoice_id IS NULL
				OR fn_invoice_id = '0'
				OR trim(fn_invoice_id) = ''
			)
			AND rv_reservation_id = '$rv_reservation_id'
	",3);
	foreach($itemList as $item_id) {
		// Do not execute if we are running a db upgrade.
		if (!$dbUpgrade) {
			$itinerary = new Itinerary();
			$itinerary->SetReservationItemId($item_id);
			$itinerary->RegenerateRate($keepTBAs);
		}
	}

	// Re-allocate extras and travel items to folios according to the standard ruleset.
	$extraList = $lDB->get("
		SELECT
			rv_extra_ix
		FROM
			rv_extra
		WHERE
			rv_reservation_id = '$rv_reservation_id'
			AND rv_extra.rv_extra_void_ind = '0'
			AND (
				fn_folio_id IS NULL
				OR trim(fn_folio_id) = ''
				OR fn_folio_id = '0'
			) AND (
				fn_invoice_item_id IS NULL
				OR trim(fn_invoice_item_id) = ''
				OR fn_invoice_item_id = '0'
			)
	",3);
	$imax = sizeof($extraList);
	for ($i=0;$i<$imax;$i++) {
		$extra_id = $extraList[$i];
		$new_folio_id = db_fn_folio_insert_extra($extra_id, true, false, false, true);
		$lDB->put("UPDATE rv_extra SET fn_folio_id = '$new_folio_id' where rv_extra_ix = '$extra_id'");
	}

	// Get the new list of regenerated folios.
	$fnFolioList = getFolioList($rv_reservation_id);

	// Update the totals for the folios.
	foreach($fnFolioList as $folio_id) {
		db_fn_folio_update_totals($folio_id);
	}

	// Recalculate the stored totals for the 'regenerated' items and all extras (non invoiced on this system) only.
	if (!$dbUpgrade) {
		recalcTotals($rv_reservation_id,"0",$itemList);
	}
	if (!$dbUpgrade) {
		// if (master system) regenerate payment plan - only take items created on the (master environment) into account for the plan.
		if($dbcode[0] == "R" || $dbcode[0] == "W") {
			genPaymentPlan($rv_reservation_id, "", $fnFolioList);
		}
	}
	specialsAutoApply($rv_reservation_id);
}

function getExchange($reservationId,$folioId=false) {
	global $lDB;
	
	$exchange = array();
	$acExch = array();

	if($folioId === false) {
		$invCurrency = $lDB->get("
			SELECT
				rf_currency.rf_currency_ix as rf_currency_id,
				rf_currency.rf_currency_name,
				rf_currency.rf_currency_symbol
			FROM
				rv_reservation
            	INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
			WHERE
				rv_reservation.rv_reservation_ix = '$reservationId'
		",1);
		$exchange['note'] = "This reservation has been contracted in $invCurrency[rf_currency_name] and the exchange rates below apply. These rates are subject to all payments being received on due dates, failing which we reserve the right to revise the rates.";
		$resCurrency = $lDB->get("
			SELECT
				rt_rate_type.rf_currency_id
			FROM
				rv_reservation
				INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
			WHERE
				rv_reservation.rv_reservation_ix = '$reservationId'
		",4);
		if ($invCurrency[0] != $resCurrency) {
			$resCurrSymbol = $lDB->get("
				SELECT
					rf_currency_symbol
				FROM
					rf_currency
				WHERE
					rf_currency_ix = '$resCurrency'
			",4);
			$exch = $lDB->get("
				SELECT
					rv_exchg_rate,
					rv_exchg_expiry_date
				FROM
					rv_reservation
				WHERE
					rv_reservation.rv_reservation_ix = '$reservationId'
			",1);
			$accomm['exch_expiry'] = chng_date($exch['rv_exchg_expiry_date'],"-");
			$accomm['rv_extra_exch_rate'] = $exch['rv_exchg_rate'];
			$accomm['curr_conversion'] = $resCurrSymbol." to ".$invCurrency['rf_currency_symbol'];
			$accomm['ac_ext_desc'] = "Accommodation";
			fixAmtDisplay($accomm['rv_extra_exch_rate']);
			array_push($acExch,$accomm);
		}
		$sqlExtraWhere = "
			rv_extra.rv_reservation_id = '$reservationId'
		";
	} else {
		$invCurrency = $lDB->get("
			SELECT
				rf_currency.rf_currency_ix as rf_currency_id,
				rf_currency.rf_currency_name,
				rf_currency.rf_currency_symbol
			FROM
				fn_folio
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
		",1);
		$exchange['note'] = "This folio has been contracted in $invCurrency[rf_currency_name] and the exchange rates below apply. These rates are subject to all payments being received on due dates, failing which we reserve the right to revise the rates.";
		$sqlExtraWhere = "
			rv_extra.fn_folio_id = '$folioId'
		";
	}

	$exchExtra = $lDB->get("
		SELECT
			ac_extra.ac_ext_desc,
			rf_currency.rf_currency_symbol,
			rv_extra.rv_extra_exch_rate,
			rv_extra.rv_extra_exch_expiry
		FROM
			rv_extra
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_extra.rf_currency_id
		WHERE
			$sqlExtraWhere
			AND rv_extra.rf_currency_id != '$invCurrency[rf_currency_id]'
	",2);
	for($a=0; $a<sizeof($exchExtra); $a++) {
		$exchExtra[$a]['exch_expiry'] = chng_date($exchExtra[$a]['rv_extra_exch_expiry'],"-");
		fixAmtDisplay($exchExtra[$a]['rv_extra_exch_rate']);
		$exchExtra[$a]['curr_conversion'] = $exchExtra[$a]['rf_currency_symbol']." to ".$invCurrency['rf_currency_symbol'];
	}
	$exchange['extras'] = array_merge($acExch,$exchExtra);
	return $exchange;
}

function getPayItems($reservationId,$resAmt=false,$adjustments=false,$folioId=false) {
	global $lDB;
	
	if ($resAmt == false) {
		$invCurr = getInvCurr($reservationId);
		$resItemAmt = $lDB->get("SELECT SUM(rv_item_amt_payable) FROM rv_reservation_item WHERE rv_reservation_id = '$reservationId'",4);
		$resExtraAmt = $lDB->get("
			SELECT
				SUM(rv_extra.rv_extra_amt_payable)
			FROM
				rv_extra
				INNER JOIN rf_database ON rf_database.rf_db_code = rv_extra.rv_extra_db
			WHERE
				rv_extra.rv_reservation_id = '$reservationId'
				AND rv_extra.rv_extra_void_ind = '0'
				AND rf_database.rf_db_env_type_ind = '2'
				AND rv_extra.rv_extra_inv_curr_id = '$invCurr'
		",4);
		$onsiteExtraAmt = $lDB->get("
			SELECT
				SUM(rv_extra.rv_extra_amt_payable)
			FROM
				rv_extra
				INNER JOIN rf_database ON rf_database.rf_db_code = rv_extra.rv_extra_db
			WHERE
				rv_extra.rv_reservation_id = '$reservationId'
				AND rv_extra.rv_extra_void_ind = '0'
				AND rf_database.rf_db_env_type_ind = '4'
				AND rv_extra.rv_extra_inv_curr_id = '$invCurr'
		",4);

		$resAmt = $resItemAmt + $resExtraAmt;

		$isTBA = $lDB->get("SELECT rv_amt_accomm_gross FROM rv_reservation WHERE rv_reservation_ix = '$reservationId'",4);
		if($isTBA === null) {
			$resAmt = "TBA";
		}
	} else {
		$onsiteExtraAmt = 0;
	}
	if ($resAmt === "TBA" && $folioId == false) {
		$payPlan['outstanding'] = "TBA";
		$payPlan['items'] = array();
		$payPlan['splitItems'] = array();
		$GLOBALS['temp']['diff'] = "'TBA'";

		$payments = $lDB->get("
			SELECT
				rv_payment_item.rv_payment_item_amt,
				rv_payment.rv_pmnt_date,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first,
				rv_payment.rv_pmnt_ref,
				rv_payment.rv_pmnt_note,
				fn_folio.fn_folio_folio_num,
				fn_invoice.fn_invoice_ix,
				fn_invoice.fn_inv_status_ind,
				rv_payment_item.fn_folio_id,
				rv_payment.rv_payment_ix,
				rv_payment_item.rv_reservation_id,
				rv_payment_item.rv_payment_item_ix,
				rv_payment_item.rv_payment_item_db,
				rv_payment_item.rv_payment_item_trf_yn,
				rv_payment_item.rv_payment_gateway_id,
				fn_folio.fn_folio_id as checkFolio,
				rf_currency.rf_currency_symbol,
				rf_mthd_pmnt.rf_mthd_pmnt_desc,
				rf_bank.rf_bank_acc_name,
				rf_bank_currency.rf_currency_symbol as rf_bank_currency_symbol
			FROM
				rv_payment
				INNER JOIN rv_payment_item ON rv_payment_item.rv_payment_id = rv_payment.rv_payment_ix
					AND rv_payment_item.rv_reservation_id = '$reservationId'
				LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
				LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment_item.rf_currency_id
				LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix  AND fn_invoice.fn_inv_status_ind <> 8
				LEFT JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = rv_payment.rf_mthd_pmnt_id               
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_payment.pr_persona_id
				LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
				LEFT JOIN rf_currency AS rf_bank_currency ON rf_bank_currency.rf_currency_ix = rf_bank.rf_currency_id
			ORDER BY
				rv_payment.rv_pmnt_date
		",6);
		$rf_currency_symbol = getInvCurrSymbol($reservationId);
		for($a=0; $a<sizeof($payments); $a++) {
			$payments[$a]['pr_name_last'] = trim($payments[$a]['pr_name_first'] . " " . $payments[$a]['pr_name_last']);
			if (!isset($payments[$a]['fn_invoice_ix'])) $payments[$a]['fn_invoice_ix'] = "";
			if ($payments[$a]['pr_name_last'] == "") {
				$payments[$a]['pr_name_last'] = "Cash";
			}
			$payments[$a]['rv_pmnt_note'] = t_encodeOverlib($payments[$a]['rv_pmnt_note']);
			$payments[$a]['invCurrSym'] = $payments[$a]['rf_currency_symbol'];
			$payments[$a]['pay_date'] = chng_date($payments[$a]['rv_pmnt_date'],"-");
			$payments[$a]['hidePayBut'] = "button bNote";
			if(!isset($payments[$a]['invNum']) || $payments[$a]['invNum'] == "") $payments[$a]['invNum'] = "N/A";
			if ($payments[$a]['checkFolio'] == NULL) {
				$payments[$a]['fn_folio_id'] = "None";
				$payments[$a]['fn_folio_folio_num'] = "None";
			}
			if ($payments[$a]['rv_pmnt_note'] == "") {
				$payments[$a]['hidePayBut'] = "collapse";
			}
			if(trim($payments[$a]['fn_invoice_ix']) != "" && $payments[$a]['fn_invoice_ix'] != "0") {
				$payments[$a]['fn_folio_folio_num'] = "";
			}
		}
		$SQL="
			SELECT
				SUM(rv_payment_item.rv_payment_item_amt) AS SumOfrv_payment_item_amt
			FROM
				rv_payment_item
			WHERE
		";
		if ($adjustments) {
			$SQL .= "
				(
					rv_payment_item.rv_payment_contra_id IS NULL
					OR rv_payment_contra_id = '0'
					OR rv_payment_contra_id = ''
				)
				AND
			";
		}
		if ($folioId != false) {
			$SQL .= "
				rv_payment_item.fn_folio_id ='$folioId'
				GROUP BY rv_payment_item.fn_folio_id
			";
		} else {
			$SQL .= "
				rv_payment_item.rv_reservation_id='$reservationId'
				GROUP BY rv_payment_item.rv_reservation_id
			";
		}
		if ($folioId != false) {
			$payPlan['payTotal'] = $lDB->get("SELECT fn_folio_amount FROM fn_folio WHERE fn_folio_ix = '$folioId'",4);
			fixAmtDisplay($payPlan['payTotal']);
		}
		$payPlan['payedTotal'] = $lDB->get($SQL,4);
		fixAmtDisplay($payPlan['payedTotal']);

		$payPlan['payments'] = $payments;
	} else {
		$payPlan = array();
		$payItems = $lDB->get("
			SELECT
				rv_pay_plan_item.rv_pay_plan_item_ix as pay_id,
				rv_pay_plan_item.rv_pay_plan_date,
				rv_pay_plan_item.rv_pay_plan_amount,
				rf_currency.rf_currency_symbol
			FROM
				rv_pay_plan_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_pay_plan_item.rv_reservation_id
				LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
			WHERE
				rv_pay_plan_item.rv_reservation_id = '$reservationId'
			ORDER BY
				rv_pay_plan_item.rv_pay_plan_date
		",6);
		$payPlan['payTotal'] = "0";
		if(canEditDB()) {
			$hideShowDel = "";
		} else {
			$hideShowDel = " style=\"visibility:hidden\" ";
		}
		$date = "";
		$rf_currency_symbol = "";
		for($a=0; $a<sizeof($payItems); $a++) {
			$date = chng_date($payItems[$a]['rv_pay_plan_date'],"-");
			$payItems[$a]['date_pc'] = $payItems[$a]['rv_pay_plan_date'];
			$rf_currency_symbol = $payItems[$a]['rf_currency_symbol'];
			$payItems[$a]['pay_date'] = $date;
			$payItems[$a]['hideShowDel'] = $hideShowDel;
			$payItems[$a]['type'] = "item";
			$payPlan['payTotal'] = $payPlan['payTotal'] + $payItems[$a]['rv_pay_plan_amount'];
		}
		$GLOBALS['temp']['diff'] = "0";
		fixAmtDisplay($resAmt,2);
		fixAmtDisplay($payPlan['payTotal'],2);
		if ($payPlan['payTotal'] != $resAmt) {
			$diff = $resAmt - $payPlan['payTotal'];
			$GLOBALS['temp']['diff'] = $diff;
			fixAmtDisplay($diff);
			$rDate = date("Y-m-d");
			if (isset($GLOBALS['editPayPlan'])) {
				$date = "<span class=txtbred>Unallocated</span>";
			}
			if ($date == "") {
				$date = chng_date(date("Y-m-d"),"-");
			}
			if ($rf_currency_symbol == "") {
				$rf_currency_symbol = $lDB->get("
					SELECT
						rf_currency_symbol
					FROM
						rf_currency
					WHERE
						rf_currency_ix = '".getInvCurr($reservationId)."'
				",4);
			}
			$payItem = array("pay_id" => "1", "date_pc" => $rDate, "pay_date" => $date, "rv_pay_plan_amount" => $diff, "rf_currency_symbol" => $rf_currency_symbol, "hideShowDel" => " style=\"visibility:hidden\" ", "type"=>"item");
			array_push($payItems,$payItem);
			$payPlan['payTotal'] = $resAmt;
		}
		fixAmtDisplay($payPlan['payTotal']);
		$payPlan['items'] = $payItems;
		$payPlan['splitItems'] = splitPaymentPlan($reservationId,$payItems);

		$sql = "
			SELECT
				rv_payment_item.rv_payment_item_amt,
				rv_payment.rv_pmnt_date,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first,
				rv_payment.rv_pmnt_ref,
				rv_payment.rv_pmnt_note,
				fn_folio.fn_folio_folio_num,
				fn_invoice.fn_invoice_ix,
				fn_invoice.fn_inv_status_ind,
				rv_payment_item.fn_folio_id,
				rv_payment.rv_payment_ix,
				rv_payment_item.rv_reservation_id,
				rv_payment_item.rv_payment_item_ix,
				rv_payment_item.rv_payment_item_db,
				rv_payment_item.rv_payment_item_trf_yn,
				rv_payment_item.rv_payment_gateway_id,
				fn_folio.fn_folio_id as checkFolio,
				rf_currency.rf_currency_symbol,
				rf_mthd_pmnt.rf_mthd_pmnt_desc, 
				rf_bank.rf_bank_acc_name,
				rf_bank_currency.rf_currency_symbol as rf_bank_currency_symbol
			FROM
				rv_payment
				INNER JOIN rv_payment_item ON rv_payment_item.rv_payment_id = rv_payment.rv_payment_ix
				LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
				LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment_item.rf_currency_id
				LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_payment.pr_persona_id
				LEFT JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = rv_payment.rf_mthd_pmnt_id
				LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
				LEFT JOIN rf_currency AS rf_bank_currency ON rf_bank_currency.rf_currency_ix = rf_bank.rf_currency_id
			WHERE
				1
		";
		$folioTBA = false;
		if ($folioId != false) {
			$sql .= " AND rv_payment_item.fn_folio_id ='$folioId' ";
			$resItemList = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE fn_folio_id = '$folioId'",3);
			if($resItemList > 0) {
				$resItemCheck = $GLOBALS['lDB']->get("
					SELECT
						COUNT(rv_res_item_comp.rv_res_item_comp_ix)
					FROM
						rv_reservation_item
						LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					WHERE
						rv_reservation_item.rv_reservation_item_ix IN ('".join("','",$resItemList)."')
					GROUP BY
						rv_reservation_item.rv_reservation_item_ix
				",3);
				if(in_array("0",$resItemCheck)) {
					$folioTBA = true;
				}	
			}
		} else {
			$sql .=" AND rv_payment_item.rv_reservation_id ='$reservationId' ";
		}
		if ($adjustments) {
			$sql .= " AND ( rv_payment_item.rv_payment_contra_id is NULL OR rv_payment_contra_id = '0' OR rv_payment_contra_id = '') ";
		}
		$sql .="
			ORDER BY
				rv_payment.rv_pmnt_date
		";
		$payments = $lDB->get($sql,6);
		$rf_currency_symbol = getInvCurrSymbol($reservationId);
		$amax = sizeof($payments);
		for($a=0;$a<$amax;$a++) {
			$payments[$a]['pr_name_last'] = trim($payments[$a]['pr_name_first'] . " " . $payments[$a]['pr_name_last']);
			if (!isset($payments[$a]['fn_invoice_ix'])) $payments[$a]['fn_invoice_ix'] = "";
			if ($payments[$a]['pr_name_last'] == "") {
				$payments[$a]['pr_name_last'] = "Cash";
			}
			$payments[$a]['rv_pmnt_note'] = t_encodeOverlib($payments[$a]['rv_pmnt_note']);
			$payments[$a]['invCurrSym'] = $payments[$a]['rf_currency_symbol'];
			$payments[$a]['pay_date'] = chng_date($payments[$a]['rv_pmnt_date'],"-");
			$payments[$a]['hidePayBut'] = "button bNote";
			if (!isset($payments[$a]['invNum'])) {
				$payments[$a]['invNum'] = "";
			} else {
				$payments[$a]['invNum'] = "INV #".$payments[$a]['invNum'];
			}
			if ($payments[$a]['checkFolio'] == NULL) {
				$payments[$a]['fn_folio_id'] = "None";
				$payments[$a]['fn_folio_folio_num'] = "None";
			}
			if ($payments[$a]['rv_pmnt_note'] == "") {
				$payments[$a]['hidePayBut'] = "collapse";
			}
			if(trim($payments[$a]['fn_invoice_ix']) != "" && $payments[$a]['fn_invoice_ix'] != "0") {
				$payments[$a]['fn_folio_folio_num'] = "";
			}
		}
		$SQL = "
			SELECT
				SUM(rv_payment_item.rv_payment_item_amt) AS SumOfrv_payment_item_amt
			FROM rv_payment_item
		";
		if ($folioId != false) {
			$SQL .= "
				WHERE rv_payment_item.fn_folio_id='$folioId'
				GROUP BY rv_payment_item.fn_folio_id
			";
		} else {
			$SQL .= "
				WHERE rv_payment_item.rv_reservation_id='$reservationId'
				GROUP BY rv_payment_item.rv_reservation_id";
		}
		$payPlan['payedTotal'] = $GLOBALS['lDB']->get($SQL,4);
		if ($folioId != false) {
			$sql = "select fn_folio_amount from fn_folio where fn_folio_ix = '".$folioId."'";
			$payPlan['payTotal'] = $GLOBALS['lDB']->get($sql,4);
			fixAmtDisplay($payPlan['payTotal']);
		}
		fixAmtDisplay($payPlan['payedTotal']);
		$totalRes = 0;
		foreach($payItems as $item) {
			$totalRes += $item['rv_pay_plan_amount'];
		}
		$newPayItems = array();
		$rDate = date("Y-m-d");
		$totalPayable = $totalRes;
		$currCount = $lDB->get("SELECT COUNT(DISTINCT rf_currency_id) FROM fn_folio WHERE rv_reservation_id = '$reservationId'",4);
		if($currCount <= 1) {
			fixAmtDisplay($totalRes);
			$payItem = array("pay_id" => "0", "date_pc" => $rDate, "pay_date" => "Total planned payments", "rv_pay_plan_amount" => $totalRes, "rf_currency_symbol" => $rf_currency_symbol, "hideShowDel" => " style=\"visibility:hidden\" ", "pr_name"=>"", "type"=>"total_planned");
			array_push($newPayItems,$payItem);
			$onsiteAmt = $onsiteExtraAmt;
			if($onsiteAmt > 0) {
				$totalPayable += $onsiteAmt;
				fixAmtDisplay($onsiteAmt);
				$payItem = array("pay_id" => "0", "date_pc" => $rDate, "pay_date" => "Onsite extras", "rv_pay_plan_amount" => $onsiteAmt, "rf_currency_symbol" => $rf_currency_symbol, "hideShowDel" => " style=\"visibility:hidden\" ","pr_name"=>"","type"=>"onsite_extras");
				array_push($newPayItems,$payItem);
			}
			fixAmtDisplay($totalPayable);
			$payItem = array("pay_id" => "0", "date_pc" => $rDate, "pay_date" => "Total payable", "rv_pay_plan_amount" => $totalPayable, "rf_currency_symbol" => $rf_currency_symbol, "hideShowDel" => " style=\"visibility:hidden\" ","pr_name"=>"","type"=>"total_payable");
			array_push($newPayItems,$payItem);
		}
		$payPlan['items'] = array_merge($payItems,$newPayItems);
		$payPlan['splitItems'] = array_merge($payPlan['splitItems'],$newPayItems);
		$payPlan['outstanding'] = $totalPayable - $payPlan['payedTotal'];
		$payPlan['payments'] = $payments;
		fixAmtDisplay($payPlan['outstanding']);
		if($folioTBA) {
			$payPlan['outstanding'] = "TBA";
			$payPlan['items'] = array();
			$GLOBALS['temp']['diff'] = "'TBA'";
		}
	}
	return $payPlan;
}

function splitPaymentPlan($reservationId,$payItems) {
	global $lDB;

	$items = array_merge($lDB->get("
		SELECT
			SUM(rv_reservation_item.rv_item_amt_payable) AS amt_payable,
			fn_folio.pr_business_id
		FROM
			rv_reservation_item
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$reservationId'
		GROUP BY
			fn_folio.pr_business_id
	",2),$lDB->get("
		SELECT
			SUM(rv_extra.rv_extra_amt_payable) AS amt_payable,
			fn_folio.pr_business_id
		FROM
			rv_extra
			INNER JOIN rf_database ON rf_database.rf_db_code = rv_extra.rv_extra_db
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
		WHERE
			rv_extra.rv_reservation_id = '$reservationId'
			AND rv_extra.rv_extra_void_ind = '0'
			AND rf_database.rf_db_env_type_ind = '2'
		GROUP BY
			fn_folio.pr_business_id
	",2));
	$units = array();
	$total = 0;
	foreach($items as $item) {
		if(!array_key_exists($item['pr_business_id'],$units)) {
			$pr_name = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$item[pr_business_id]'",4);
			$units[$item['pr_business_id']] = array('name'=>$pr_name,'amount'=>0,'perc'=>0);
		}
		$units[$item['pr_business_id']]['amount'] += $item['amt_payable'];
		$total += $item['amt_payable'];
	}
	foreach($units as $unit=>$totals) { 
		if($total != 0) {
			$perc = $totals['amount'] / $total;
		} else {
			$perc = 0;
		}
		$units[$unit]['perc'] = $perc;
		$items =& $units[$unit]['items'];
		$left = $totals['amount'];
		foreach($payItems as $payKey=>$payItem) {
			$value = round($payItem['rv_pay_plan_amount'] * $perc,2);
			$left -= $value;
			$item['rv_pay_plan_amount'] = $value;
			$items[$payKey] = $item;
		}
		$left = round($left,2);
		if($left != 0) {
			$largestValue = 0;
			$largestKey = 0;
			if(isset($items)) {
				foreach($items as $key=>$item) {
					if($item['rv_pay_plan_amount'] > $largestValue) {
						$largestValue = $item['rv_pay_plan_amount'];
						$largestKey = $key;
					}
				}
			}
			$items[$largestKey]['rv_pay_plan_amount'] = round($items[$largestKey]['rv_pay_plan_amount'] + $left,2);
		}
	}
	$payInvItems = array();
	foreach($payItems as $payKey=>$payItem) {
		foreach($units as $unit) {
			$payInvItem = $payItem;
			$payInvItem['rv_pay_plan_amount'] = $unit['items'][$payKey]['rv_pay_plan_amount'];
			fixAmtDisplay($payInvItem['rv_pay_plan_amount']);
			$payInvItem['pr_name'] = $unit['name'];
			$payInvItems[] = $payInvItem;
		}
	}

	return $payInvItems;
}

function getResDocTotals($reservationId,$accommRate=array(),$resExtra=array(),$resTravel=array(),$output="0",$flag=1,$folioId=false){
	global $lDB;

	if ($flag) {
		$rv_commission_deduct_yn = $lDB->get("SELECT rv_commission_deduct_yn FROM rv_reservation WHERE rv_reservation_ix ='$reservationId'",4);
		$data = $GLOBALS['lDB']->get("
			SELECT
				rv_commission_deduct_yn,
				rv_amt_accomm_gross,
				rv_amt_accomm_comm,
				rv_amt_accomm_nett,
				rv_amt_accomm_tax,
				rv_amt_extra_gross,
				rv_amt_extra_comm,
				rv_amt_extra_nett,
				rv_amt_extra_tax,
				rv_amt_travel_gross,
				rv_amt_travel_comm,
				rv_amt_travel_nett,
				rv_amt_travel_tax,
				rv_tba_extra_yn,
				rv_tba_travel_yn
			FROM
				rv_reservation
			WHERE
				rv_reservation_ix = '$reservationId'
		",1);

		$data['gross'] = $data['rv_amt_accomm_gross'] + $data['rv_amt_extra_gross'] + $data['rv_amt_travel_gross'];
		$data['comm'] = $data['rv_amt_accomm_comm'] + $data['rv_amt_extra_comm'] + $data['rv_amt_travel_comm'];
		$data['tax'] = $data['rv_amt_accomm_tax'] + $data['rv_amt_extra_tax'] + $data['rv_amt_travel_tax'];
		$data['nett'] = $data['rv_amt_accomm_nett'] + $data['rv_amt_extra_nett'] + $data['rv_amt_travel_nett'];
		$rf_currency_symbol = getInvCurrSymbol($reservationId);
		$data['accomm_curr'] = $rf_currency_symbol;
		$data['extra_curr'] = $rf_currency_symbol;
		$data['travel_curr'] = $rf_currency_symbol;
		$data['total_curr'] = $rf_currency_symbol;

		if (!isset($data['rv_amt_accomm_gross'])) {
			$data['rv_amt_accomm_gross'] = "TBA";
			$data['rv_amt_accomm_tax'] = "TBA";
			$data['rv_amt_accomm_comm'] = "TBA";
			$data['rv_amt_accomm_nett'] = "TBA";
			$data['accomm_curr'] = "";

			$data['gross'] = "TBA";
			$data['comm'] = "TBA";
			$data['tax'] = "TBA";
			$data['nett'] = "TBA";
			$data['total_curr'] = "";
		}

		if ($data['rv_tba_extra_yn'] == "1") {
			$data['rv_amt_extra_gross'] = "TBA";
			$data['rv_amt_extra_tax'] = "TBA";
			$data['rv_amt_extra_comm'] = "TBA";
			$data['rv_amt_extra_nett'] = "TBA";
			$data['extra_curr'] = "";

			$data['gross'] = "TBA";
			$data['comm'] = "TBA";
			$data['tax'] = "TBA";
			$data['nett'] = "TBA";
			$data['total_curr'] = "";
		}

		if ($data['rv_tba_travel_yn'] == "1") {
			$data['rv_amt_travel_gross'] = "TBA";
			$data['rv_amt_travel_tax'] = "TBA";
			$data['rv_amt_travel_comm'] = "TBA";
			$data['rv_amt_travel_nett'] = "TBA";
			$data['travel_curr'] = "";

			$data['gross'] = "TBA";
			$data['comm'] = "TBA";
			$data['tax'] = "TBA";
			$data['nett'] = "TBA";
			$data['total_curr'] = "";
		}

		if ($rv_commission_deduct_yn == "0") {
			$data['rv_amt_accomm_invoice'] = $data['rv_amt_accomm_gross'];
			$data['rv_amt_extra_invoice'] = $data['rv_amt_extra_gross'];
			$data['rv_amt_travel_invoice'] = $data['rv_amt_travel_gross'];
			$data['invoice'] = $data['gross'];
		} else {
			$data['rv_amt_accomm_invoice'] = $data['rv_amt_accomm_nett'];
			$data['rv_amt_extra_invoice'] = $data['rv_amt_extra_nett'];
			$data['rv_amt_travel_invoice'] = $data['rv_amt_travel_nett'];
			$data['invoice'] = $data['nett'];
		}

		$resArray = array(
			"acc" => array(
				"invoice" => $data['rv_amt_accomm_invoice'],
				"gross" => $data['rv_amt_accomm_gross'],
				"tax" => $data['rv_amt_accomm_tax'],
				"comm" => $data['rv_amt_accomm_comm'],
				"net" => $data['rv_amt_accomm_nett'],
				"curr" => $data['accomm_curr']
			),
			"ext" => array(
				"invoice" => $data['rv_amt_extra_invoice'],
				"gross" => $data['rv_amt_extra_gross'],
				"tax" => $data['rv_amt_extra_tax'],
				"comm" => $data['rv_amt_extra_comm'],
				"net" => $data['rv_amt_extra_nett'],
				"curr" => $data['extra_curr']
			),
			"tra" => array(
				"invoice" => $data['rv_amt_travel_invoice'],
				"gross" => $data['rv_amt_travel_gross'],
				"tax" => $data['rv_amt_travel_tax'],
				"comm" => $data['rv_amt_travel_comm'],
				"net" => $data['rv_amt_travel_nett'],
				"curr" => $data['travel_curr']
			),
			"total" => array(
				"invoice" => $data['invoice'],
				"gross" => $data['gross'],
				"comm" => $data['comm'],
				"tax" => $data['tax'],
				"net" => $data['nett'],
				"curr" => $data['total_curr']
			)
		);

		$resTotals = $resArray;
	} else {
		$rv_commission_deduct_yn = $lDB->get("SELECT rv_commission_deduct_yn FROM rv_reservation WHERE rv_reservation_ix ='$reservationId'",4);
		$accommTotal = array("gross" => "0","tax" => "0","comm" => "0","net" => "0");
		foreach($accommRate as $acRate) {
			if ($acRate['compAmt'] === "TBA" || $accommTotal['gross'] === "TBA") {
				$accommTotal['gross'] = "TBA";
				$accommTotal['comm'] = "TBA";
				$accommTotal['tax'] = "TBA";
				$accommTotal['net'] = "TBA";
				break;
			} else {
				if ($rv_commission_deduct_yn == "1") {
					$net = ($acRate['rateAmt'] + $acRate['commAmt']);
				} else {
					$net = ($acRate['rateAmt'] - $acRate['commAmt']);
				}
				$accommTotal['gross'] = $accommTotal['gross'] + $acRate['compAmt'];
				$accommTotal['comm'] = $accommTotal['comm'] + $acRate['commAmt'];
				$accommTotal['tax'] = $accommTotal['tax'] + $acRate['taxAmt'];
				$accommTotal['net'] = $accommTotal['net'] + $net;
			}
		}

		$extraTotal = array("gross" => "0","tax" => "0","comm" => "0","net" => "0");
		foreach($resExtra as $extra) {
			$commission = ($extra['total'] * ($extra['rv_extra_comm_pay'] / 100));
			if ($rv_commission_deduct_yn == "1") {
				if ($commission > 0) { $commission = $commission * -1; }
				$net = ($extra['total'] + $commission);
				$taxAmount = $extra['total'] - $commission;
			} else {
				if ($commission < 0) { $commission = $commission * -1; }
				$net = ($extra['total'] - $commission);
				$taxAmount = $extra['total'];
			}
			$tax = $taxAmount * ($extra['rv_extra_tax_perc'] / 100) * -1;

			$extraTotal['gross'] = $extraTotal['gross'] + $extra['total'];
			$extraTotal['comm'] = $extraTotal['comm'] + $commission;
			$extraTotal['tax'] = $extraTotal['tax'] + $tax;
			$extraTotal['net'] = $extraTotal['net'] + $net;
		}
		$travelTotal = array("gross" => "0","tax" => "0","comm" => "0","net" => "0");
		foreach($resTravel as $travel) {
			$commission = ($travel['total'] * ($travel['rv_extra_comm_pay'] / 100));
			if ($rv_commission_deduct_yn == "1") {
				if ($commission > 0) { $commission = $commission * -1; }
				$net = ($travel['total'] + $commission);
				$taxAmount = $travel['total'] - $commission;
			} else {
				if ($commission < 0) { $commission = $commission * -1; }
				$net = ($travel['total'] - $commission);
				$taxAmount = $travel['total'];
			}
			$tax = $taxAmount * ($travel['rv_extra_tax_perc'] / 100) * -1;

			$travelTotal['gross'] = $travelTotal['gross'] + $travel['total'];
			$travelTotal['comm'] = $travelTotal['comm'] + $commission;
			$travelTotal['tax'] = $travelTotal['tax'] + $tax;
			$travelTotal['net'] = $travelTotal['net'] + $net;
		}

		if ($rv_commission_deduct_yn == "0") {
			$accommTotal['invoice'] = $accommTotal['gross'];
			$extraTotal['invoice'] = $extraTotal['gross'];
			$travelTotal['invoice'] = $travelTotal['gross'];
		} else {
			$accommTotal['invoice'] = $accommTotal['net'];
			$extraTotal['invoice'] = $extraTotal['net'];
			$travelTotal['invoice'] = $travelTotal['net'];
		}

		$grandTotals['gross'] = $accommTotal['gross'] + $extraTotal['gross'] + $travelTotal['gross'];
		$grandTotals['comm'] = $accommTotal['comm'] + $extraTotal['comm'] + $travelTotal['comm'];
		$grandTotals['tax'] = $accommTotal['tax'] + $extraTotal['tax'] + $travelTotal['tax'];
		$grandTotals['net'] = $accommTotal['net'] + $extraTotal['net'] + $travelTotal['net'];
		$grandTotals['invoice'] = $accommTotal['invoice'] + $extraTotal['invoice'] + $travelTotal['invoice'];
		if($accommTotal['gross'] === "TBA") {
			$grandTotals['gross'] = "TBA";
			$grandTotals['comm'] = "TBA";
			$grandTotals['tax'] = "TBA";
			$grandTotals['net'] = "TBA";
			$grandTotals['invoice'] = "TBA";
		}
		$resTotals = array("acc" => $accommTotal, "ext" => $extraTotal, "tra" => $travelTotal, "total" => $grandTotals);
	}
	if ($output == "1") {
		$nuResTotals = array();
		$keys = array_keys($resTotals);
		for($a=0;$a<sizeof($keys);$a++) {
			$section = $keys[$a];
			$bkeys = array_keys($resTotals[$section]);
			for ($b=0;$b<sizeof($bkeys);$b++) {
				$key = $bkeys[$b];
				$nuKey = $section."_".$key;
				$nuResTotals[$nuKey] = (string) $resTotals[$section][$key];
				if ($key != "curr") {
					fixAmtDisplay($nuResTotals[$nuKey]);
				}
			}
		}
		return $nuResTotals;
	} else {
		return $resTotals;
	}
}

function getExtraTotal($resExtra,$resData="0",$mode="0"){
	global $lDB;
	
	if (!is_array($resData)) {
		$resData = $lDB->get("
			SELECT
				rv_invoice_currency_id,
				rv_commission_deduct_yn
			FROM
				rv_reservation
			WHERE
				rv_reservation_ix = '$resExtra[rv_reservation_id]'
		",1);
	}
	$extraCurrency = $lDB->get("SELECT rf_currency_id FROM rv_extra WHERE rv_extra_ix = '$resExtra[rv_extra_id]'",4);
	if ($resExtra['rv_extra_exch_rate'] == "0") {
		if ($extraCurrency != $resData['rv_invoice_currency_id']) {
			return "TBA";
		} else {
			$resExtra['rv_extra_exch_rate'] = "1";
		}
	}

	if($resExtra['rv_extra_ind'] == 3) {
		$result = ($resExtra['rv_extra_charge'] - ($resExtra['rv_extra_charge'] * ($resExtra['rv_extra_discount']/100))) * $resExtra['rv_extra_units'] * $resExtra['rv_extra_nights'] * $resExtra['rv_extra_exch_rate'];

	} else {
		$result = ($resExtra['rv_extra_charge'] - ($resExtra['rv_extra_charge'] * ($resExtra['rv_extra_discount']/100))) * $resExtra['rv_extra_units'] * $resExtra['rv_extra_exch_rate'];
	}

	$rv_commission_deduct_yn = $resData['rv_commission_deduct_yn'];

	if ($rv_commission_deduct_yn == "1" && $mode == "0") {
		if ($resExtra['rv_extra_comm_pay'] > 0) {
			$extr_amnt = $result - ($result / ($resExtra['rv_extra_comm_pay']));
			$result = $extr_amnt;
		}
	}

	$result = round($result,2);
	fixAmtDisplay($result);

	return $result;
}

function getRateDates($getRateDates) {
	return $GLOBALS['lDB']->get("
		SELECT
			rt_period.rt_period_ix AS acPeriodId,
			rt_period.rt_period_date_from,
			rt_period.rt_period_date_to
		FROM
			rt_rate
			INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
		WHERE
			rt_rate.ac_accomm_type_id = '$getRateDates[accommType]'
			AND rt_rate.rt_rate_type_id = '$getRateDates[rateType]'
			AND (
				(rt_period.rt_period_date_from >= '$getRateDates[startDate]' AND rt_period.rt_period_date_from < '$getRateDates[endDate]')
				OR (rt_period.rt_period_date_to >= '$getRateDates[startDate]' AND rt_period.rt_period_date_to <= '$getRateDates[endDate]')
				OR (rt_period.rt_period_date_from <= '$getRateDates[startDate]' AND rt_period.rt_period_date_to >= '$getRateDates[endDate]')
			)
		ORDER BY
			rt_period.rt_period_date_from
	",2);
}

######################################################
# Function: Get reservation item details             #
######################################################
function getItemDetails($rv_reservation_item_id) {
	global $lDB;
	
	$resItemDetails = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			(TO_DAYS(rv_reservation_item.rv_item_date_depart) - TO_DAYS(rv_reservation_item.rv_item_date_arrive)) AS noNights,
			rf_currency.rf_currency_symbol AS invoice_currency,
			currency2.rf_currency_symbol AS rate_currency,
			rv_reservation.rv_commission_perc as commPerc,
			rv_reservation_item.rv_item_comm_perc as itemCommPerc,
			rv_reservation.rv_commission_deduct_yn as commDeductYn,
			rv_reservation.rv_exchg_rate as exchRate,
			rv_reservation_item.ac_accomm_type_id as ac_accomm_type_id,
			rv_reservation_item.rt_rate_type_id as rt_rate_type_id,
			rt_rate_type.rt_rate_type_desc,
			rt_rate_type.rt_rate_type_note,
			rt_rate_type.rt_rate_type_colour,
			ac_accomm_type.pr_business_id,
			rv_reservation_item.rv_reservation_id,
			rv_reservation_item.rv_item_split_yn,
			rv_reservation_item.rv_item_var_perc,
			fn_folio.fn_folio_folio_num,
			fn_folio.fn_folio_db as rf_db_code,
			rv_reservation_item.fn_invoice_id,
			rv_reservation_item.rv_reservation_item_db,
			rv_reservation_item.rv_item_overide_level_ind,
			rv_reservation_item.rv_item_overide_amt
			
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN ac_accomm_type ON rv_reservation_item.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
            LEFT JOIN rf_currency ON rv_reservation.rv_invoice_currency_id = rf_currency.rf_currency_ix
            LEFT JOIN pr_persona ON ac_accomm_type.pr_business_id = pr_persona.pr_persona_ix
			LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id
			LEFT JOIN rf_currency currency2 ON currency2.rf_currency_ix = rt_rate_type.rf_currency_id
            LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
	",1);
	
	$optionsList = $lDB->get("
		SELECT
			rt_component.rt_component_abbrv
		FROM
			rv_res_item_comp
			LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
		WHERE
			rv_reservation_item_id = '".$rv_reservation_item_id."'
			AND rv_item_comp_option_yn = '1'
		ORDER BY rt_component.rt_component_abbrv
	",3);
	if (sizeof($optionsList) > 0) {
		$listB = join(", ",$optionsList);
		if (trim($listB) != "," && trim($listB) != "") {
			$resItemDetails['ac_accomm_desc'] .= " (".$listB.")";
		}
	}
	$allocCount = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation_item as link_item ON link_item.rv_link_res_item_id = rv_reservation_item.rv_reservation_item_ix
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
	",4);
	$resItemDetails['hasAlloc'] = "<img src=\"/resource/Resrequest/Application/public/img/1x1.gif\">";
	$resItemDetails['allocCount'] = $allocCount;
	if($allocCount > 0) {		
		$resItemDetails['hasAlloc'] = "x";
	}

	$hasRooms = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_res_item_group.rv_reservation_item_id = '$rv_reservation_item_id'
	",4);
	
	$hasGuests = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_guest
			INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_guest.rv_reservation_item_id = '$rv_reservation_item_id'
	",4);

	if($hasRooms > 0 || $hasGuests > 0) {
		$resItemDetails['hasRooming'] = "1";
	} else {
		$resItemDetails['hasRooming'] = "0";
	}
	$blockDetails = $GLOBALS['lDB']->get("
		SELECT
			bl_block.bl_block_ix,
			bl_block.bl_block_name
		FROM
			bl_block
			INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
			LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
			LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
			LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
		WHERE
			draw_down_item.rv_reservation_item_ix = '$rv_reservation_item_id'
	",1);
	if (!empty($blockDetails)) {
		$resItemDetails['bl_block_ix'] = $blockDetails['bl_block_ix'];
		$resItemDetails['bl_block_name'] = $blockDetails['bl_block_name'];
	} else {
		$resItemDetails['bl_block_ix'] = "";
		$resItemDetails['bl_block_name'] = "";
	}

	return $resItemDetails;
}

#####################################################
# Function: Get reservation item cost details       #
#####################################################
function getResItemCost($rv_reservation_item_id, $resItem="",$calc="1") {
	if ($calc == "1") {
		if (!is_array($resItem)) {
			$resItem = getItemDetails($rv_reservation_item_id);
		}

		$components = array();
		$sysComp = $GLOBALS['lDB']->get("
			SELECT
				rv_res_item_comp.rv_res_item_comp_ix AS rvResItemCompId,
				rv_res_item_comp.rt_component_id,
				rt_component.rt_component_desc,
				rt_component.rt_component_abbrv,
				rt_component.rt_component_sys_code,
				rv_res_item_comp.rv_item_comp_freq_ind,
				rv_res_item_comp.rv_item_comp_freq_factor,
				rv_res_item_comp.rv_item_comp_rate AS rvItemCompRate,
				rv_res_item_comp.rv_item_comp_var AS rvItemCompDisc,
				rv_res_item_comp.rv_item_comp_comm_ind,
				rv_res_item_comp.rv_item_comp_tax_perc,
				rv_res_item_comp.rt_tax_id,
				rv_res_item_comp.rt_tax_ind,
				rv_res_item_comp.rv_item_comp_option_yn,
				rv_res_item_comp.rv_item_comp_amt_gross,
				rv_res_item_comp.rv_item_comp_amt_nett,
				rv_res_item_comp.rv_item_comp_amt_payable,
				rv_res_item_comp.rv_item_comp_amt_comm,
				rv_res_item_comp.rv_item_comp_amt_comm_calc,
				rv_res_item_comp.rv_item_comp_amt_tax,
				rv_reservation.rv_exchg_rate
			FROM
				rv_res_item_comp
				LEFT JOIN rt_component ON rv_res_item_comp.rt_component_id = rt_component.rt_component_ix
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_comp.rv_reservation_item_id='$rv_reservation_item_id'
		",2);	

		foreach($sysComp as $compDetails) {
			$compDetails['rateAmt'] = $compDetails['rvItemCompRate'] * $compDetails['rv_exchg_rate'];
			// $compDetails['discAmt'] = $compDetails['rv_item_comp_amt_gross'] - $compDetails['rateAmt'];
			$compDetails['discAmt'] = $compDetails['rvItemCompDisc'];
			if($compDetails['rateAmt'] > 0 || $compDetails['rateAmt'] < 0) {
				$compDetails['discPerc'] = $compDetails['discAmt'] / $compDetails['rateAmt'] * 100;
			} else {
				$compDetails['discPerc'] = 0;
			}
			$compDetails['commAmt'] = $compDetails['rv_item_comp_amt_comm'];
			if ($resItem['commDeductYn'] == 1) {
				$compDetails['commAmt'] = $compDetails['commAmt'] * -1;
			}
			$compDetails['compAmt'] = $compDetails['rv_item_comp_amt_gross'];
			$compDetails['taxAmt'] = $compDetails['rv_item_comp_amt_tax'];
			array_push($components,$compDetails);
		}

		return $components;
	}
}

#####################################################
# Function: Get total item costs                    #
#####################################################
function getTotalItemCost($components) {
	#    Add to reservation item total cost
	$isTBA = false;

	$resItemSum['rateAmt'] = "";
	$resItemSum['discAmt'] = "";
	$resItemSum['compAmt'] = "";
	$resItemSum['commAmt'] = "";
	$resItemSum['taxAmt'] = "";

	if(sizeof($components) == 0) {
		$resItemSum['rateAmt'] = "TBA";
	}

	

	foreach ($components as $component){
		if(!isset($component['rateAmt']) || $component['rateAmt'] === null) {
			$isTBA = true;
		}
		$resItemSum['rateAmt'] += isset($component['rateAmt']) ? $component['rateAmt'] : "";
		$resItemSum['discAmt'] += isset($component['discAmt']) ? $component['discAmt'] : "";
		$resItemSum['compAmt'] += isset($component['compAmt']) ? $component['compAmt'] : "";
		$resItemSum['commAmt'] += isset($component['commAmt']) ? $component['commAmt'] : "";
		$resItemSum['taxAmt']  += isset($component['taxAmt']) ? $component['taxAmt'] : "";
	}
	
	if($isTBA) {
		$resItemSum['rateAmt'] = "TBA";
	} else {
		fixAmtDisplay($resItemSum['rateAmt']);
		fixAmtDisplay($resItemSum['discAmt']);
		fixAmtDisplay($resItemSum['compAmt']);
		fixAmtDisplay($resItemSum['commAmt']);
		fixAmtDisplay($resItemSum['taxAmt']);
	}

	return $resItemSum;
}

#####################################################
# Function: Generate reservation payment plan       #
#####################################################
function genPaymentPlan($rvReservationId, $ac_pay_plan_id="", $fnFolioList=array()) {
	global $lDB;
	
	# Step1: Initialise - obtain reservation details: base dates & res amount

	// Obtain reservation dates
	$resDates = $lDB->get("
		SELECT
			rv_reservation.rv_confirmation_date,
			rv_reservation.rv_prov_date,
			rv_reservation.rv_date_recorded,
			rv_reservation.rv_commission_deduct_yn
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_reservation_ix='$rvReservationId'
	",1);

	// Obtain earliest arrival date
	$arriveDate = $lDB->get("
		SELECT
			rv_reservation_item.rv_item_date_arrive
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id='$rvReservationId'
		ORDER BY
			rv_reservation_item.rv_item_date_arrive
		LIMIT 1
	",1);

	// Obtain latest departure date
	$departDate = $lDB->get("
		SELECT
			rv_reservation_item.rv_item_date_depart
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id='$rvReservationId'
		ORDER BY
			rv_reservation_item.rv_item_date_depart DESC
		LIMIT 1
	",1);

	// Set up base date 2 (reservation date)
	if ($resDates['rv_confirmation_date'] > 0) {
		$base2 = $resDates['rv_confirmation_date'];
	} else if ($resDates['rv_prov_date'] > 0) {
		$base2 = $resDates['rv_prov_date'];
	} else {
		$base2 = $resDates['rv_date_recorded'];
	}

	// Set up Base date 4 (arrival) and base date 6 (departure)
	$base4 = $arriveDate[0];
	$base6 = $departDate[0];

	// Obtain full reservation payment amount
	if (sizeof($fnFolioList) > 0) {
		// find out how the totals are populated... from component level (sigh).
		// IDEA! Just sum the totals for the just created invoice / folios that relate to this DB! YEAH!
		$resAmt = $lDB->get("SELECT SUM(fn_folio_amount) FROM fn_folio WHERE fn_folio_ix IN ('".join("','",$fnFolioList)."')",4);
	} else {
		//$resAmt = getDisplayResTotals($rvReservationId);
		$resDB = $lDB->get("SELECT rv_reservation_db FROM rv_reservation WHERE rv_reservation_ix = '$rvReservationId'",4);
		$resEnv = $lDB->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_db_code = '$resDB'",4);
		$invCurr = $lDB->get("SELECT rv_invoice_currency_id FROM rv_reservation	WHERE rv_reservation_ix = '$rvReservationId'",4);
		$resAmt = $lDB->get("
			SELECT 
				SUM(fn_folio_amount)
			FROM
				fn_folio
				INNER JOIN rf_database ON fn_folio.fn_folio_db = rf_database.rf_db_code
			WHERE
				rf_database.rf_db_env_type_ind = '$resEnv'
				AND fn_folio.rv_reservation_id='$rvReservationId'		 
				AND fn_folio.rf_currency_id = '$invCurr'
		",4);
	}

	# Step 2: Derive payment dates and amounts

	// Obtain payment plan template

	// If the chosen payment plan is not found, get it off the reservation...
	if(!db_ac_pay_plan_exists($ac_pay_plan_id)) {
		$ac_pay_plan_id = $lDB->get("SELECT ac_pay_plan_id FROM rv_reservation WHERE rv_reservation_ix = '$rvReservationId'",4);
	}

	// ...if it is still not found, use the default
	if(!db_ac_pay_plan_exists($ac_pay_plan_id)) {
		$ac_pay_plan_id = $lDB->get("SELECT ac_pay_plan_id FROM rf_default",4);
	}

	// ..if it is still not found, return
	if(!db_ac_pay_plan_exists($ac_pay_plan_id)) {
		return false;
	}

	$pr_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$rvReservationId'",4);
	if(!empty($pr_agent_id)) {
		$agent = $lDB->get("
			SELECT
				ac_pay_final_base,
				ac_pay_final_days
			FROM
				pr_agent
			WHERE
				pr_agent_id = '$pr_agent_id'
		",1);
		if($agent['ac_pay_final_base'] != "2") {
			$agent = false;
		}
	} else {
		$agent = false;
	}
	
	$payItems = $lDB->get("
		SELECT
			ac_pay_item.ac_pay_base,
			ac_pay_item.ac_pay_days,
			ac_pay_item.ac_pay_final_base,
			ac_pay_item.ac_pay_final_days,
			ac_pay_item.ac_pay_final_agent_override_yn,
			ac_pay_item.ac_pay_amount_ind,
			ac_pay_item.ac_pay_amount
		FROM
			ac_pay_item
		WHERE
			ac_pay_item.ac_pay_plan_id='$ac_pay_plan_id'
		ORDER BY
			ac_pay_item.ac_pay_amount_ind
	",2);

	if(sizeof($payItems) < 1) {
		return false;
	}

	$today = date("Y-m-d");
	$percResAmt = $resAmt;
	// Set up actual pay dates
	$newPayItems = array();
	foreach($payItems as $item) {
		switch($item['ac_pay_base']) {
		case 2:
			$payDate = $base2;
			break;
		case 4:
			$payDate = $base4;
			break;
		case 6:
		default:
			$payDate = $base6;
			break;
		}

		// Apply date offset
		$payDateArray = explode("-",$payDate);
		$payDate = date("Y-m-d",mktime(0,0,0,$payDateArray[1],$payDateArray[2] + $item['ac_pay_days'],$payDateArray[0]));

		if($item['ac_pay_final_base'] == "2") {
			if($agent && $item['ac_pay_final_agent_override_yn'] == "1") {
				$item['ac_pay_final_days'] = $agent['ac_pay_final_days'];
			}
			$payDateArray = explode("-",$payDate);
			if($item['ac_pay_final_days'] < 1) {
				$monthOffset = 1;
			} else {
				$monthOffset = 0;
			}
			$newPayDate = date("Y-m-d",mktime(0,0,0,$payDateArray[1]+$monthOffset,$item['ac_pay_final_days'],$payDateArray[0]));
			if($newPayDate < $payDate) {
				$newPayDate = date("Y-m-d",mktime(0,0,0,$payDateArray[1]+$monthOffset+1,$item['ac_pay_final_days'],$payDateArray[0]));				
			}
			$payDate = $newPayDate;
		}

		// Check that pay date is not in the past
		if($payDate < $today) {
			$payDate = $today;
		}

		$item['payDate'] = $payDate;

		// Calculate payment amount
		if($item['ac_pay_amount_ind'] == "2") {
			$item['payAmt'] = $item['ac_pay_amount'];
			$percResAmt -= $item['ac_pay_amount'];
		} else {
			$item['payAmt'] = $percResAmt * $item['ac_pay_amount'] / 100;
		}
		fixAmtDisplay($item['payAmt']);

		// Consolidate payments allocated to the same day into one entry
		if(!array_key_exists($payDate,$newPayItems)) {
			$newPayItems[$payDate] = $item;
		} else {
			$newPayItems[$payDate]['payAmt'] += $item['payAmt'];
		}
	}
	ksort($newPayItems);

	// Verify we don't lose a cent in the rounding.
	$total = "0.00";
	foreach($newPayItems as $item) {
		$total += $item['payAmt'];
		$last = $item['payDate'];
	}
	if($resAmt != $total) {
		$diff = $resAmt - $total;
		$newPayItems[$last]['payAmt'] = $newPayItems[$last]['payAmt'] + $diff;
	}


	# Step 3: Delete existing payment plan
	if (!$lDB->count("rv_pay_plan_item","rv_reservation_id",$rvReservationId,"0")) {
		$list = $lDB->get("SELECT rv_pay_plan_item.rv_pay_plan_item_ix as rv_pay_plan_item_id FROM rv_pay_plan_item WHERE rv_reservation_id = '$rvReservationId'",3);
		foreach($list as $item) {
			$lDB->put("DELETE FROM rv_pay_plan_item WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '".$item."'");
		}
	}
	
	// Create payment plan entries
	foreach($newPayItems as $item) {
		$lDB->put("
			INSERT INTO rv_pay_plan_item (
				rv_pay_plan_item_db,
				rv_reservation_id,
				rv_pay_plan_date,
				rv_pay_plan_amount
			) VALUES (
				'$GLOBALS[dbcode]',
				'$rvReservationId',
				'$item[payDate]',
				'$item[payAmt]'
			)
		");
		$rv_pay_plan_item_ix = $lDB->insert_id;
		$lDB->put("UPDATE rv_reservation SET ac_pay_plan_id = '$ac_pay_plan_id' WHERE rv_reservation_ix = '$rvReservationId'");
	}

	return $newPayItems;
}
