<?php

/**
 * functions.imageset.php - Imageset specific function library
 */

function isV3Imageset($principalId="", $imagesetDir="") {
	if (isset($GLOBALS['isV3Imageset'])) {
		return $GLOBALS['isV3Imageset'];
	}
	$principalId = !empty($principalId) ? $principalId : $GLOBALS['principal_id'];
	$imagesetDir = !empty($imagesetDir) ? $imagesetDir : $GLOBALS['images_dir_on_disk'];
	if (file_exists($imagesetDir . "/" . $principalId . "/config.json")) {
		$imagesetConfig = json_decode(file_get_contents($imagesetDir . "/" . $principalId . "/config.json"), true);
		if (isset($imagesetConfig['imagesetVersion']) && $imagesetConfig['imagesetVersion'] >= 3) {
			$GLOBALS['isV3Imageset'] = true;
			return true;
		}
	}
	$GLOBALS['isV3Imageset'] = false;
	return false;
}

function imagesetLogoSizeOverride($key, $originalSize) {
	// Fetch logo size override from config file in imageset directory, if exists
	if (!isset($GLOBALS['images_dir_on_disk']) || !isset($_SESSION['principal_id'])) {
		return $originalSize;
	}
	$imagesetConfigFile = $GLOBALS['images_dir_on_disk'] . "/" . $_SESSION['principal_id'] . "/config.json";
	if (file_exists($imagesetConfigFile)) {
		$imagesetConfig = json_decode(file_get_contents($imagesetConfigFile), true);
		if (
			isset($imagesetConfig[$key]) &&
			!empty($imagesetConfig[$key]) &&
			is_numeric($imagesetConfig[$key])
		) {
			return $imagesetConfig[$key];
		}
	}
	return $originalSize;

	// Config File example
	// To override a logo width, have a file config.json in the root of the imageset directory, with only this template array in it,
	// and specify values where needed. Empty values will be ignored.

	// {
	// 	"imagesetVersion": "",
	// 	"apiURL": "",
	// 	"invoiceFolioResSummaryPdfLogoWidthOverride": "",
	// 	"paymentCaptureReceiptPdfLogoWidthOverride": "",
	// 	"paymentsDueReportAgentEmailPdfLogoWidthOverride": "",
	// 	"extraConfirmationPdfLogoWidthOverride": "",
	// 	"roomingCalendarPdfLogoWidthOverride": "",
	// 	"availabilityReportPdfLogoWidthOverride": "",
	// 	"allocationSummaryReportPdfLogoWidthOverride": "",
	// 	"allocationListReportPdfLogoWidthOverride": "",
	// 	"contactAgentAllocationReservationsListPdfLogoWidthOverride": "",
	// 	"itinerarySummaryPdfLogoWidthOverride": "",
	// 	"invoiceReportBulkEmailPdfLogoWidthOverride": "",
	// 	"customerStatementReportEmailPdfLogoWidthOverride": "",
	// 	"checkinRegistrationCardPdfLogoWidthOverride": ""
	// }
}

