<?php
/**
 * inc.functions_mail.php - email functions
 * @package Resrequest
 * @author Richard Howes
 * @copyright 2001 - 2003 Mandarin Trading (Pty) Ltd
 *
 * @todo Improve the delete functionality
 */

/**
 * Include the phpmailer class
 * @link http://phpmailer.sourceforge.net PHPMailer
 */


require(__DIR__ . "/phpmailer/Exception.php");
require(__DIR__ . "/phpmailer/PHPMailer.php");
require(__DIR__ . "/phpmailer/SMTP.php");
require_once(__DIR__ . '/db.pf_object.php');
require_once(__DIR__ . '/db.pf_option.php');
require_once(__DIR__ . '/db.pf_field.php');


function email_reset() {
	/**
	 *  Attempt to retrieve the SMTP server hostname, else default to 'localhost'
	 *  @global smtp $smtp
	 */
	global $lDB;

	$GLOBALS['smtp'] = $lDB->get("
		SELECT
			rf_db_smtp_address,
			rf_db_smtp_port,
			rf_db_smtp_auth_ind,
			rf_db_smtp_security_ind,
			rf_db_smtp_username,
			rf_db_smtp_password,
			rf_db_smtp_hostname_override
		FROM
			rf_database
		WHERE
			rf_db_code = '$GLOBALS[dbcode]'
	",1);
	if(empty($GLOBALS['smtp']['rf_db_smtp_address']) || substr($GLOBALS['dbcode'],0,1) == "W") {
	   $GLOBALS['smtp']['rf_db_smtp_address'] = "localhost";
	}

	$GLOBALS['smtp']['attachment_dir'] = "$GLOBALS[images_dir_on_disk]/$GLOBALS[principal_id]/attachments";


	/**
	 *  Server email is being sent from.
	 *  @global mailer $mailer
	 */
	$GLOBALS['mailer'] = new PHPMailer\PHPMailer\PHPMailer();
}

email_reset();


/**
 *  List of email addresses which will have the 'Information Block' appended to their email text
 *  @global internalEmail $internalEmail
 */
global $internalEmail;
$internalEmail = array("info@resrequest.com","support@resrequest.com","dylanb@resrequest.com","jacosn@resrequest.com","nicolvdm@resrequest.com","anthonys@resrequest.com");

function getAutoCC($pf_object_id) {
	$autoCC = array();
	$options = db_pf_option_get_defaults($pf_object_id, false);
	foreach($options as $pf_option_id) {
		if(db_pf_field_exists_by_name($pf_option_id,"email_address")) {
			$autoCC = array_merge($autoCC,preg_split("/[,;]/",db_pf_field_by_name($pf_option_id,"email_address")));
		}
	}
	$autoCC = array_unique($autoCC);
	return $autoCC;
}

/**
 * Sends email either immediately or via data transfer depending on flag in
 * database table ----, field ----
 *
 * @todo Make this function asynchronous because sending a large amount of mail
 *        will make data transfer very slow.
 *
 * @param string $from
 * @param string $to
 * @param string $subject
 * @param string $headers
 * @param string $action      # -1=create, 0=send(default), 1=resend, 2=forward, 3=print, 4=delete
 * @param string $emailID     # ID of message to resend, forward, print or delete
 * @param string $resID       # ID of reservation to attach mail to
 * @param string $attachString # Attachment data
 * @param string $attachStringFilename # Attachment filename
 * @param array $attachString # Alternative array of hashes with keys "data" and "filename"
 * @return string
 */
function email($from, $to, $subject, $headers, $message, $action=0, $emailID=0, $resID="", $fromName="Resrequest User", $attachString="", $attachStringFilename="",$pf_object_id=false, $attachments=false, $wordwrap=50, $isHtml = false, $embeddedImages = [], $showAttachmentMessage = true){

	if(isset($GLOBALS['archive']) && $GLOBALS['archive'] !== false) {
		return true;
	}
	$toArray = preg_split("/[,;]/",$to);
	if($pf_object_id !== false) {
		$toArray = array_merge($toArray,getAutoCC($pf_object_id));
	}
	$toArray = $recipients = array_unique($toArray);

	// To/CC block under message signature
	if(!$isHtml) {
		$message .= "\n\n-----Message recipients-----";
		$message .= "\nTo: " . array_shift($recipients);
		if (!empty($recipients)) {
			$message .= "\nCC: " . implode(', ', $recipients);
		}
	}

	$finalError = false;
	foreach($toArray as $to) {
		if (empty(trim($to))) {
			// Avoid empty email addresses
			continue;
		}

		/**
		 *  Get server email is being sent from.
		 *  @var string
		 */
		$server = $_SERVER['SERVER_NAME'];

		/* Temporarily set to master database so we can update */
		$setbacktozero = 0;
		if ($GLOBALS['lDB']->isMaster == "0"){
			$GLOBALS['lDB']->isMaster = "1";
			$setbacktozero = 1;
		}

		/**
		 * Determine this client's email method
		 */
		$sql = "SELECT rf_mail_id FROM rf_database WHERE rf_db_code = '$GLOBALS[dbcode]'";
		$result = mysqli_query($GLOBALS['lDB']->conn,$sql);
		$row = mysqli_fetch_assoc($result);

		/**
		 *  Email delivery method # 0=via mail server, 1=direct(SMTP class), 2=data transfer
		 *  @var string
		 */
		$deliveryMethod = $row['rf_mail_id'];

		/**
		 * IF   action is send or forward ($action=0 OR $action=2)
		 * THEN Save email into database
		 *      get insert ID
		 *      create email 'create' log entry
		 */
		if($action=='0' || $action=='2') {
			$attachments = attachmentValidate($attachments);			
			/* Remove single quotes to avoid breaking the code */
			/* :TO DO: Find a permanent, central solution to the ' and NL\CR problem */
			$message = str_replace("\\","\\\\",$message);
			$message = str_replace("'", "\\'",$message);
			if(!is_array($attachString)) {
				if($attachStringFilename != "") {
					if ($showAttachmentMessage) {
						$message .= "\n\n<< ATTACHMENT -- $attachStringFilename >>";
					}
				}
			} else {
				if ($showAttachmentMessage) {
					foreach ($attachString as $attachment) {
						$message .= "\n\n<< ATTACHMENT -- $attachment[filename] >>";
					}
				}
			}
			if ($showAttachmentMessage) {
				foreach($attachments as $attachment) {
					$message .= "\n\n<< ATTACHMENT -- ".trim($attachment)." >>";
				}
			}
			$subject = str_replace("\\", "\\\\", $subject);
			$subject = str_replace("'", "\\'",$subject);

			/* Create the email record */
			$sql = "
				INSERT INTO em_mail (
					em_mail_db,
					em_from,
					em_to,
					em_subject,
					em_message,
					rv_reservation_id
				) VALUES (
					'".$GLOBALS['dbcode']."',
					'$from',
					'$to',
					'$subject',
					'$message',
					'$resID'
				)
			";
			$result = $GLOBALS['lDB']->put($sql);
			$emailID = $GLOBALS['lDB']->insert_id;

			/* Create em_mail_log record for email creation */
			$now = date("Y-m-d H:i:s");
			$em_action_date_time_tz = date("e");
			$sql = "
				INSERT INTO em_mail_log (
					em_mail_log_db,
					em_server,
					em_mail_id,
					em_action,
					em_action_date_time,
					em_action_date_time_tz,
					em_status,
					pr_user_id
				) VALUES (
					'".$GLOBALS['dbcode']."',
					'$server',
					'$emailID',
					-1,
					'$now',
					'$em_action_date_time_tz',
					0,
					'$GLOBALS[userid]'
				)
			";
			$result = $GLOBALS['lDB']->put($sql);
			$logInsertID = $GLOBALS['lDB']->insert_id;
			$message = str_replace("\\'", "'",$message);
			$subject = str_replace("\\'", "'",$subject);
		
			$message = str_replace("\\\\", "\\", $message);
			$subject = str_replace("\\\\", "\\", $subject);
		}
		else {
			/**
			 * This is a resend, forward, print or delete
			 * so get the details for this email
			 * :TO DO: change this IF to SWITCH because we get the data for delete which is unnecessary
			 */
			$sql = "
				SELECT
					em_from,
					em_to,
					em_subject,
					em_message
				FROM
					em_mail
				WHERE
					em_mail_ix = '$emailID'
			";
			$result = $GLOBALS['lDB']->get($sql);

			$from = $result['em_from'];
			$to = $result['em_to'];
			$subject = $result['em_subject'];
			$message = $result['em_message'];
		}

		/**
		 * Create em_mail_log record
		 * For action requested (create log is already done above)
		 */
		$now = date("Y-m-d H:i:s");
		$em_action_date_time_tz = date("e");
		$sql = "
			INSERT INTO em_mail_log (
				em_mail_log_db,
				em_mail_id,
				em_action,
				em_status,
				pr_user_id,
				em_server,
				em_action_date_time,
				em_action_date_time_tz
			) VALUES (
				'$GLOBALS[dbcode]',
				'$emailID',
				'$action',
				9,
				'$GLOBALS[userid]',
				'$server',
				'$now',
				'$em_action_date_time_tz'
			)
		";
		$result = $GLOBALS['lDB']->put($sql);
		$logInsertID = $GLOBALS['lDB']->insert_id;

		/**
		 * IF we are sending, resending or forwarding
		 * THEN send message
		 */
		if($action<='2') {
			/**
			 * IF email method is direct or SMTP (i.e. not Data Transfer)
			 * OR we are on one of the hosted web servers (first char or dbcode = "W")
			 * THEN send via SMTP class now,
			 * ELSE wait for it to be sent after data transfer
			 */
			if($deliveryMethod != 2 || substr($GLOBALS['dbcode'],0,1) == "W") {

				/* Setup send parameters */
				$GLOBALS['mailer']->Host = $GLOBALS['smtp']['rf_db_smtp_address']; // SMTP server
				if(!empty($GLOBALS['smtp']['rf_db_smtp_port'])) {
					$GLOBALS['mailer']->Port = $GLOBALS['smtp']['rf_db_smtp_port'];
				}

				$GLOBALS['mailer']->From = $from;
				//$GLOBALS['mailer']->IsRecord();                    // telling class to record send transcript
				$GLOBALS['mailer']->IsSMTP();                      // telling the class to use SMTP
				$GLOBALS['mailer']->AddAddress($to);
				$GLOBALS['mailer']->Subject = $subject;
				if($isHtml) {
					$GLOBALS['mailer']->isHtml($isHtml);
					$GLOBALS['mailer']->msgHTML($message);
				}
				else $GLOBALS['mailer']->Body = $message;
				$GLOBALS['mailer']->WordWrap = $wordwrap;
				$GLOBALS['mailer']->FromName = $fromName;

				if($GLOBALS['smtp']['rf_db_smtp_auth_ind'] == "1") {
					$GLOBALS['mailer']->SMTPAuth = true;
					$GLOBALS['mailer']->Username = $GLOBALS['smtp']['rf_db_smtp_username'];
					$GLOBALS['mailer']->Password = $GLOBALS['smtp']['rf_db_smtp_password'];
				}

				if($GLOBALS['smtp']['rf_db_smtp_security_ind'] == 1) {
					$GLOBALS['mailer']->SMTPSecure = "tls";
				}
				if($GLOBALS['smtp']['rf_db_smtp_security_ind'] == 2) {
					$GLOBALS['mailer']->SMTPSecure = "ssl";
				}

				if(!empty($GLOBALS['smtp']['rf_db_smtp_hostname_override'])) {
					$GLOBALS['mailer']->Hostname = $GLOBALS['smtp']['rf_db_smtp_hostname_override'];
				}
		
				if(!is_array($attachString)) {
					if(trim($attachString) != "") {
						$GLOBALS['mailer']->AddStringAttachment($attachString,$attachStringFilename);
					}
				} else {
					foreach($attachString as $attachment) {
						$GLOBALS['mailer']->AddStringAttachment($attachment['data'],$attachment['filename']);
					}
				}
				if(isset($attachments) && is_array($attachments)) {
					$attachmentDir = $GLOBALS['smtp']['attachment_dir'];
					foreach($attachments as $attachment) {
						$GLOBALS['mailer']->AddAttachment($attachmentDir . "/" . $attachment);
					}
				}

				if (!empty($embeddedImages) && is_array($embeddedImages)) {
					foreach ($embeddedImages as $image) {
						if (!array_key_exists('path' ,$image) || !array_key_exists('cid', $image)) {
							continue;
						}

						$path = $image['path'];
						$cid = $image['cid'];
						$name = (empty($image['name']) ? '' : $image['name']);
						$encoding = (empty($image['encoding']) ? $GLOBALS['mailer']::ENCODING_BASE64 : $image['encoding']);
						$type = (empty($image['type']) ? '' : $image['type']);
						$disposition = (empty($image['disposition']) ? 'inline' : $image['disposition']);

						$GLOBALS['mailer']->addEmbeddedImage($path, $cid, $name, $encoding, $type, $disposition);
					}
				}

				$GLOBALS['mailer']->SMTPOptions = array(
					'ssl' => array(
						'verify_peer' => false,
						'verify_peer_name' => false,
						'allow_self_signed' => true
					)
				);

				/* Attempt to send the message */
				$sent = $GLOBALS['mailer']->Send();
				$error = $GLOBALS['mailer']->IsError();

				/* Process result of attempt to send message */
				if(!$error){
					$now = date("Y-m-d H:i:s");
					$em_action_date_time_tz = date("e");
					//$log = $GLOBALS['mailer']->Transcript;
					$log = "";
					$logSql = "
						UPDATE em_mail_log SET
							em_action_log='$log',
							em_action_date_time='$now',
							em_action_date_time_tz='$em_action_date_time_tz',
							em_status='0'
						WHERE
							em_mail_log_ix = '$logInsertID'
					";
				} else {
					$error = "Cound not send the message to $to.\nError: ".$GLOBALS['mailer']->ErrorInfo."\n";
					$finalError = true;
					$logSql = "
						UPDATE em_mail_log SET
							em_status='2',
							em_action_log='$error'
						WHERE
							em_mail_log_ix = '$logInsertID'
					";
				}
				/* Update action log with send status and error/send transcript */
				$result = $GLOBALS['lDB']->put($logSql);
			}
			else {
				/**
				 * Create em_mail_log record
				 * For 'send' with flag set to send mail via data transfer
				 */
				$sql = "
					INSERT INTO em_mail_log (
						em_mail_log_db,
						em_mail_id,
						em_action,
						em_status,
						pr_user_id,
						em_server,
						em_action_date_time,
						em_action_date_time_tz
					) VALUES (
						'$GLOBALS[dbcode]',
						'$emailID',
						'$action',
						5,
						'$_SESSION[userid]',
						'$server',
						'$now',
						'$em_action_date_time_tz'
					)
				";
				$result = $GLOBALS['lDB']->put($sql);
				$logInsertID = $GLOBALS['lDB']->insert_id;
			}
		}

		/**
		 * IF this was not a send, resend or forward (0 or 1)
		 * THEN update action timestamp now
		 * ELSE only update it if send was successful
		 */
		if($action >= '3') {
			$logSql = "
				UPDATE em_mail_log SET
					em_action_date_time='$now',
					em_action_date_time_tz='$em_action_date_time_tz'
				WHERE
					em_mail_log_ix = '$logInsertID'
			";
			$result = $GLOBALS['lDB']->put($logSql);
		}

		/**
		 * DELETE email
		 * :DEBUG:
		 */
		if($action >= '3') {
			$logSql = "
				UPDATE em_mail_log SET
					em_action_date_time='$now',
					em_action_date_time_tz='$em_action_date_time_tz'
				WHERE
					em_mail_log_ix = '$logInsertID'
			";
			$result = $GLOBALS['lDB']->put($logSql);
		}

		/* set db back to slave on the web, if it was slave when started */
		if ($setbacktozero == 1) {
			$GLOBALS['lDB']->isMaster = "0";
		}
		$GLOBALS['mailer']->SmtpClose();
		$GLOBALS['mailer']->ClearAllRecipients();
		$GLOBALS['mailer']->ClearAttachments();
		$GLOBALS['mailer']->ClearCustomHeaders();
		$GLOBALS['mailer']->ClearReplyTos();

		unset($GLOBALS['mailer']);
		$GLOBALS['mailer'] = new PHPMailer\PHPMailer\PHPMailer();
	}
	/* Return error status to calling function */
	return $finalError;
}


/**
 * Send data transfered mail
 *
 * Sends out email transferred from principal via Data transfer. This function
 * should be called asynchronously if possible (Dont know how at the moment).
 * Only called on hosted servers so will send to local sendmail for speed.
 *
 * @return void
 */
function webSendmail(){
	/* Set to master database to allow sending */
	$setbacktozero = 0;
	if ($GLOBALS['lDB']->isMaster == "0") {
		$GLOBALS['lDB']->isMaster = "1";
		$setbacktozero = 1;
	}

	/**
	 *  Get server email is being sent from.
	 *  @var string
	 */
	$server = $_SERVER['SERVER_NAME'];

	/* Get an array of email messages to send */
	$result = $GLOBALS['lDB']->get("SELECT em_mail_id FROM em_mail_log WHERE em_action = '0' AND em_status = '5'",3);

	/* Process each email (send via mail.resrequest.com) */
	foreach($result as $item){
		$email = $GLOBALS['lDB']->get("
			SELECT
				em_mail_ix AS emailID,
				em_from,
				em_to,
				em_subject,
				em_message
			FROM
				em_mail
			WHERE
				em_mail_ix = '$item'
		",1);

		/* Setup send parameters */
		$GLOBALS['mailer']->Host = "localhost";                      // SMTP server
		$GLOBALS['mailer']->From = $email['em_from'];
		//$GLOBALS['mailer']->IsRecord();                              // telling class to record send transcript
		$GLOBALS['mailer']->IsSMTP();                                // telling the class to use SMTP
		$GLOBALS['mailer']->AddAddress($email['em_to']);
		$GLOBALS['mailer']->Subject = $email['em_subject'];
		$GLOBALS['mailer']->Body = $email['em_message'];
		$GLOBALS['mailer']->WordWrap = 50;
		$fromName="Resrequest User";
		$GLOBALS['mailer']->FromName = $fromName;

		/* Attempt to send the message */
		$send = $GLOBALS['mailer']->Send();
		$error = $GLOBALS['mailer']->IsError();

		if(!$error) {
			$status = 0;
			$sentDate = date("Y-m-d H:i:s");
			$error = "Message sent to $email[em_to] OK.\n";
		} else {
			$status = 4;
			$sentDate = '0000-00-00 00:00:00';
			$error = "Could not send the message to $email[em_to].\nError: ".$GLOBALS['mailer']->ErrorInfo."\n";
		}
		$em_action_date_time_tz = date("e");
		/* Update the em_mail_log record with sent status */
		$sql = "UPDATE em_mail_log SET em_server='$server', em_action_date_time='$sentDate', em_action_date_time_tz='$em_action_date_time_tz', em_status = '$status', em_action_log = '".addslashes($error)."' WHERE em_mail_id='$email[emailID]'";
		$GLOBALS['lDB']->put($sql);

		// Reset the mailer
		$GLOBALS['mailer']->SmtpClose();
		$GLOBALS['mailer']->ClearAllRecipients();
		$GLOBALS['mailer']->ClearAttachments();
		$GLOBALS['mailer']->ClearCustomHeaders();
		$GLOBALS['mailer']->ClearReplyTos();

		unset($GLOBALS['mailer']);
		$GLOBALS['mailer'] = new PHPMailer\PHPMailer\PHPMailer();
		
	}

	/* set db back to slave on the web, if it was slave when started */
	if ($setbacktozero == 1) {
		$GLOBALS['lDB']->isMaster = "0";
	}
}

function attachmentToggle() {
	if($GLOBALS['userStatusId'] > 1) {
		return "attachmentsEnabled = true;";
	} else {
		return "";
	}
}

function attachmentList() {
	$attachmentDir = $GLOBALS['smtp']['attachment_dir'];
	if($GLOBALS['userStatusId'] < 2 || !file_exists($attachmentDir) || !is_dir($attachmentDir)) {
		return array();
	}

	$attachments = array();

	$directoryHandle = opendir($attachmentDir);
	while (false !== ($filename = readdir($directoryHandle))) {
		if($filename != "." && $filename != "..") {
			$attachments[] = $filename;
		}
	}
	
	sort($attachments);

	return $attachments;
}

function attachmentValidate($attachments) {
	if($GLOBALS['userStatusId'] < 2 || !is_array($attachments)) {
		return array();
	}

	$attachmentDir = $GLOBALS['smtp']['attachment_dir'];

	$newAttachments = array();
	foreach($attachments as $attachment) {
		if(!empty($attachment) && file_exists($attachmentDir . "/" . $attachment)) {
			$newAttachments[] = $attachment;
		}
	}

	return $newAttachments;
}
