<?php

require_once(__DIR__ . '/db.pg_account.php');
require_once(__DIR__ . "/db.rv_payment.php");
require_once(__DIR__ . "/db.rv_payment_gateway.php");
require_once(__DIR__ . "/db.rv_payment_item.php");

require_once(__DIR__ . "/functions.financial.php");
require_once(__DIR__ . "/functions.mail.php");

define("PAYMENT_GATEWAY_TYPE_WIZARD",1);
define("PAYMENT_GATEWAY_TYPE_RECORD_PAYMENT",2);
define("PAYMENT_GATEWAY_TYPE_DEPOSIT",3);

function loadPaymentGateway($type=false, $folios=false, $reference=false, $amount=false, $rf_currency_id=false) {
	global $lDB;

	if($type == PAYMENT_GATEWAY_TYPE_WIZARD) { 
		$sc_grp_force_payment_yn = $lDB->get("SELECT sc_grp_force_payment_yn FROM sc_group WHERE sc_group_id = '$GLOBALS[sc_group_id]'",4);
		if($sc_grp_force_payment_yn != 1) {
			return false;
		}
	}

	if($type === false && array_key_exists("rv_payment_gateway_type",$_SESSION) && !empty($_SESSION['rv_payment_gateway_type'])) {
		$type = $_SESSION['rv_payment_gateway_type'];
	}

	if($folios === false && array_key_exists("rv_payment_gateway_folios",$_SESSION) && !empty($_SESSION['rv_payment_gateway_folios'])) {
		$folios = $_SESSION['rv_payment_gateway_folios'];
	}

	if($reference === false && array_key_exists("rv_payment_gateway_reference",$_SESSION) && !empty($_SESSION['rv_payment_gateway_reference'])) {
		$reference = $_SESSION['rv_payment_gateway_reference'];
	}

	if($rf_currency_id === false && $amount === false && array_key_exists("rv_payment_gateway_exchanges",$_SESSION) && !empty($_SESSION['rv_payment_gateway_exchanges'])) {
		$exchanges = $_SESSION['rv_payment_gateway_exchanges'];
	} else {
		$exchanges = db_rf_exchange_rate_get_all_rates();
	}

	if(is_bool($rf_currency_id)) {
		if(array_key_exists("rv_payment_gateway_currency",$_SESSION) && !empty($_SESSION['rv_payment_gateway_currency']) && $rf_currency_id !== true) {
			$rf_currency_id = $_SESSION['rv_payment_gateway_currency'];
			$pg_account_ids = db_pg_account_get_by_folio($folios, $rf_currency_id);
		} else {
			$rf_currency_id = $lDB->get("SELECT DISTINCT(rf_currency_id) FROM fn_folio WHERE fn_folio_ix IN ('".join("','",$folios)."')",3);
			$pg_account_ids = false;
			if(sizeof($rf_currency_id) == 1) {
				$rf_currency_id = $rf_currency_id[0];
				$pg_account_ids = db_pg_account_get_by_folio($folios, $rf_currency_id);
			}
			if(!is_array($pg_account_ids) || sizeof($pg_account_ids) == 0) { 
				if(!is_array($rf_currency_id)) {
					$rf_currency_id = array($rf_currency_id);
				}
				// no direct match so check available exchange rates
				$exchTo = array();
				foreach($exchanges as $exchange) {
					if(!array_key_exists($exchange['rf_exch_curr_from_id'],$exchTo)) {
						$exchTo[$exchange['rf_exch_curr_from_id']] = array();
					}
					$exchTo[$exchange['rf_exch_curr_from_id']][] = $exchange['rf_exch_curr_to_id'];
				}
				foreach($exchTo as $rf_exch_curr_from_id=>$exchFrom) {
					// remove matching currencies as they won't need conversion
					$GLOBALS['rf_exch_curr_from_id'] = $rf_exch_curr_from_id;
					$check_currencies = array_filter($rf_currency_id,function($item) {
						global $rf_exch_curr_from_id;

						if($rf_exch_curr_from_id == $item) {
							return false;
						}

						return true;
					});

					// check if the list of currencies required is represented in the list of those available
					if(sizeof(array_intersect($exchFrom, $check_currencies)) == sizeof($check_currencies)) {
						$pg_account_ids = db_pg_account_get_by_folio($folios, $rf_exch_curr_from_id);
						if(is_array($pg_account_ids) && sizeof($pg_account_ids) > 0) { 
							$rf_currency_id = $rf_exch_curr_from_id;
							break;
						}
					}
				}
			}
		}
	} else {
		$pg_account_ids = db_pg_account_get_by_folio($folios, $rf_currency_id);
	}

	if(!is_array($pg_account_ids) || sizeof($pg_account_ids) == 0) {
		return false;
	}

	if(is_bool($amount)) {
		if(array_key_exists("rv_payment_gateway_amount",$_SESSION) && !empty($_SESSION['rv_payment_gateway_amount']) && $amount !== true) {
			$amount = $_SESSION['rv_payment_gateway_amount'];
		} else {
			$amounts = $lDB->get("
				SELECT
					SUM(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) AS fn_folio_amt_outstanding,
					fn_folio.rf_currency_id
				FROM
					fn_folio
				WHERE
					fn_folio.fn_folio_ix IN ('".join("','",$folios)."')
				GROUP BY
					fn_folio.rf_currency_id
			",2);
			$total = 0;
			foreach($amounts as $key=>$item) {
				if($item['rf_currency_id'] == $rf_currency_id) {
					$total += $item['fn_folio_amt_outstanding'];
					$amounts[$key]['rf_exch_rate'] = 1;
				} else {
					foreach($exchanges as $exchange) {
						if(
							$exchange['rf_exch_curr_to_id'] == $item['rf_currency_id']
							&& $exchange['rf_exch_curr_from_id'] == $rf_currency_id
						) {
							$total += $item['fn_folio_amt_outstanding'] / $exchange['rf_exch_rate'];
							$amounts[$key]['rf_exch_rate'] = $exchange['rf_exch_rate'];
							break;
						}
					}
				}
			}
			$amount = round($total,2);
			fixAmtDisplay($amount);
		}
	}

	$date = $lDB->get("
		SELECT
			MIN(fn_folio_date)
		FROM
			fn_folio
		WHERE
			fn_folio.fn_folio_ix IN ('".join("','",$folios)."')
	",4);


	$pg_accounts = array();
	foreach($pg_account_ids as $pg_account_id) {
		$pg_account = $lDB->get("
			SELECT
				pg_account.pg_account_ix,
				pg_account.pg_acc_name,
				pg_type.pg_type_ix,
				pg_type.pg_type_name,
				pg_type.pg_type_label,
				pg_type.pg_type_logo,
				pg_type.pg_type_api_url,
				pg_type.pg_type_site_url,
				pg_account.rf_mthd_pmnt_id
			FROM
				pg_account
				INNER JOIN pg_type ON pg_type.pg_type_ix = pg_account.pg_type_id
			WHERE
				pg_account.pg_account_ix = '$pg_account_id'
		",1);

		$pg_account['pg_acc_method'] = $lDB->get("
			SELECT
				pg_method.pg_method_name,
				pg_method.pg_method_image,
				pg_method.pg_method_note
			FROM
				pg_acc_method
				INNER JOIN pg_method ON pg_method.pg_method_ix = pg_acc_method.pg_method_id
			WHERE
				pg_acc_method.pg_account_id = '$pg_account_id'
		",2);

		$pg_account['pg_acc_currency_code'] = $lDB->get("
			SELECT
				pg_acc_currency.pg_acc_currency_code
			FROM
				pg_acc_currency
			WHERE
				pg_acc_currency.pg_account_id = '$pg_account_id'
				AND pg_acc_currency.rf_currency_id = '$rf_currency_id'
		",4);
		$pg_account['rf_bank_id'] = $lDB->get("
			SELECT
				pg_acc_currency.rf_bank_id
			FROM
				pg_acc_currency
			WHERE
				pg_acc_currency.pg_account_id = '$pg_account_id'
				AND pg_acc_currency.rf_currency_id = '$rf_currency_id'
		",4);
		$pg_account['reference'] = $reference;
		$pg_account['amount'] = $amount;
		$pg_account['rf_currency_id'] = $rf_currency_id;
		$pg_account['date'] = $date;
		$pg_account['folios'] = $folios;
		$pg_account['type'] = $type;

		require(__DIR__ . "/payment_gateway/" . $pg_account['pg_type_name'] . "/" . $pg_account['pg_type_name'] . "_api.php");

		$pg_accounts[] = $pg_account;
	}

	session_set("rv_payment_gateway_folios",$folios);
	session_set("rv_payment_gateway_amount",$amount);
	session_set("rv_payment_gateway_currency",$rf_currency_id);
	session_set("rv_payment_gateway_exchanges",$exchanges);
	session_set("rv_payment_gateway_reference",$reference);
	session_set("rv_payment_gateway_type",$type);
	return $pg_accounts;
}

function loadPaymentGatewayByReservation($rv_reservation_id) {
	global $lDB;

	$folios = $lDB->get("SELECT fn_folio_ix FROM fn_folio WHERE fn_folio.rv_reservation_id = '$rv_reservation_id'",3);

	return loadPaymentGateway(PAYMENT_GATEWAY_TYPE_WIZARD, $folios, $rv_reservation_id);
}



function createPaymentGatewayPopup($pg_accounts,$width=600,$showTitle=true,$allowClose=true) {
	global $userStatusId;
	global $principal_id;
	global $domain;
	global $server;
	global $lDB;

	// TODO: Multicurrency
	if($pg_accounts === false || sizeof($pg_accounts) != 1) {
		return false;
	}

	$pg_account = $pg_accounts[0];

	$pg_account['rf_currency_symbol'] = $lDB->get("
		SELECT
			rf_currency.rf_currency_symbol
		FROM
			rf_currency
		WHERE
			rf_currency.rf_currency_ix = '$pg_account[rf_currency_id]'
	",4);

	$resOfficeID = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default",4);
	$resOffTel = $GLOBALS['lDB']->get("
		SELECT 
			pr_phone.pr_phone_number 
		FROM 
			rf_default
			INNER JOIN pr_phone ON rf_default.rf_res_office_id = pr_phone.pr_persona_id
		ORDER BY
			pr_phone.pr_default_yn DESC
	",4);
	if(empty($resOffTel)) {
		$resOffTel = "None";
	}
	$pg_account['pr_phone_number'] = $resOffTel;

	$resOffEmail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_email
		FROM
			rf_default
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rf_default.rf_res_office_id
	",4);
	if(empty($resOffEmail)) {
		$resOffEmail = "None";
	}
	$pg_account['pr_email'] = $resOffEmail;

	$methodHTML = join("",file(__DIR__ . "/../../../public/html/payment_gateway_method_row.htm"));
	$methods = "";
	foreach($pg_account['pg_acc_method'] as $method) {
		$methods .= showpage($method,$methodHTML);
	}
	$pg_account['methods'] = $methods;

	if(file_exists("images/payment_gateway/$pg_account[pg_type_logo]")) {
		$label = "</td><td><img src=\"images/payment_gateway/$pg_account[pg_type_logo]\" alt=\"$pg_account[pg_type_label]\" />";
	} else {
		$label = ", $pg_account[pg_type_label]";
	}
	if(trim($pg_account['pg_type_site_url']) == "") {
		$pg_account['pg_type_label_link'] = "<span class=\"txtgb\">$label</span>";
	} else {
		$pg_account['pg_type_label_link'] = "<span class=\"txtgb txtu imgLink\" onclick=\"openPopup('$pg_account[pg_type_site_url]',640,480,false,false,true,true);\">$label</span>";
	}

	switch($pg_account['type']) {
	case PAYMENT_GATEWAY_TYPE_WIZARD:
		$pg_account['payment_label'] = "To confirm this booking kindly process a payment";
		$pg_account['cancel_label'] = "Cancel the booking";
		$pg_account['extra_payment_options_class'] = "expand";
		break;
	case PAYMENT_GATEWAY_TYPE_RECORD_PAYMENT:
	case PAYMENT_GATEWAY_TYPE_DEPOSIT:
		$pg_account['payment_label'] = "Finalise this payment process";
		$pg_account['cancel_label'] = "Cancel";
		$pg_account['extra_payment_options_class'] = "collapse printCollapse";
		break;
	}

	$pg_account['width'] = $width;
	$pg_account['titleWidth'] = $width - 2;

	if($showTitle) {
		$pg_account['titleClass'] = "outDk";
	} else {
		$pg_account['titleClass'] = "collapse";
	}
	
	if($allowClose) {
		$pg_account['allow_close'] = "true";
	} else {
		$pg_account['allow_close'] = "false";
	}

	$pg_account['customHTML'] = "";
	$pg_account['customCSS'] = "";
	if ($userStatusId == "0") {
		if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/payment_gateway_popup.htm")) {
			$pg_account['customHTML'] = showpage($pg_account,join("",file(__DIR__ . "/../images/$principal_id/payment_gateway_popup.htm")));
		}

		if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/payment_gateway_popup.css")) {
			$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/payment_gateway_popup.css\" type=\"text/css\" />";
		} elseif (file_exists("styles/payment_gateway_popup.css")) {
			$indexCSS = "<link rel=\"stylesheet\" href=\"styles/payment_gateway_popup.css\" type=\"text/css\" />";
		} else {
			$indexCSS = "";
		}

		if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/global.css")) {
			$globalCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />";
		} else {
			$globalCSS = "";
		}

		$pg_account['customCSS'] = "
			$globalCSS
			$indexCSS
		";

		require_once(__DIR__ . '/functions.imageset.php');
		if (isV3Imageset($principal_id)) {
			// Do not include imageset CSS if it's a V3+ imageset
			$pg_account['customHTML'] = "";
			$pg_account['customCSS'] = file_exists("styles/payment_gateway_popup.css") ? "<link rel=\"stylesheet\" href=\"styles/payment_gateway_popup.css\" type=\"text/css\" />" : "";
		}
	}

	if(!array_key_exists("form",$pg_account)) {
		$pg_account['form'] = "";
	}

	$pg_account['pg_acc_method'] = ""; // Removing the possible nested array to prevent 'Array to string conversion' error
	$pg_account['folios'] = ""; // Removing the possible nested array to prevent 'Array to string conversion' error

	return showpage($pg_account,join("",file(__DIR__ . "/../../../public/html/payment_gateway_popup.htm")));
}

function initPaymentGateway($pg_accounts) {
	if(is_array($pg_accounts) && sizeof($pg_accounts) > 0) {
		$pg_account = $pg_accounts[0];

		session_set("rv_payment_gateway_id",db_rv_payment_gateway_create($pg_account['pg_account_ix'], $pg_account['rf_currency_id'], $pg_account['amount'], $pg_account['folios']));

		if(array_key_exists("init",$pg_account)) {
			$pg_account = call_user_func($pg_account['init'],$pg_account);
		}

		echo "<!DOCTYPE html>
			<html>
			<head>
				<script src=\"/resource/Resrequest/Application/public/include/js/jquery.js\" language=\"javascript\"></script>
				<script src=\"/resource/Resrequest/Application/public/include/js/system.js\" language=\"javascript\"></script>
			</head>
			<body>
			$pg_account[form]
			<script language=\"javascript\">
				$pg_account[submit]		
			</script>
			</body>
			</html>
		";
		die();
	}	
}

function processPaymentGateway() {
	global $lDB;

	$rv_payment_gateway_id = $_SESSION['rv_payment_gateway_id'] ?? "";
	if(empty($rv_payment_gateway_id)) {
		return false;
	}

	$pg_accounts = loadPaymentGateway();
	if(!is_array($pg_accounts) || sizeof($pg_accounts) == 0) {
		return false;
	}

	$pg_account = $pg_accounts[0];
	$payment = call_user_func($pg_account['process'],$pg_account);

	db_rv_payment_gateway_update($rv_payment_gateway_id,$payment['status'],$payment['log'],$payment['id'],$payment['amount']);

	if($_SESSION['rv_payment_gateway_type'] == PAYMENT_GATEWAY_TYPE_WIZARD && $payment['status'] == DB_RV_PAYMENT_GATEWAY_SUCCESS) {
		$rv_payment_id = db_rv_payment_insert("",date("Y-m-d"),$pg_account['rf_bank_id'],$pg_account['rf_mthd_pmnt_id'],$payment['id']);
		$folios = $lDB->get("
			SELECT
				fn_folio.fn_folio_ix,
				fn_folio.fn_folio_amount,
				fn_folio.rv_reservation_id
			FROM
				fn_folio
			WHERE
				fn_folio.fn_folio_ix IN ('".join("','",$_SESSION['rv_payment_gateway_folios'])."')
		",2);
		$left = $payment['amount'];
		$reservations = array();
		foreach($folios as $folio) {
			if( ($left - $folio['fn_folio_amount']) < 0) {
				$amount = $left;
			} else {
				$amount = $folio['fn_folio_amount'];
			}
			if($amount > 0) {
				$rv_payment_item_id = db_rv_payment_item_insert($rv_payment_id,$folio['fn_folio_ix'],$amount,1,false,false,$rv_payment_gateway_id);
			}
			$reservations[] = $folio['rv_reservation_id'];
		}

		foreach($reservations as $rv_reservation_id) {
			recalcTotals($rv_reservation_id);
			ammendReservation($rv_reservation_id,"Payment");
		}

		$rf_payment_gateway_email_yn = $lDB->get("SELECT rf_payment_gateway_email_yn FROM rf_default",4);
		if($rf_payment_gateway_email_yn == 1) {
			$resOffEmail = $lDB->get("
				SELECT
					pr_persona.pr_email
				FROM
					rf_default
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rf_default.rf_res_office_id
			",4);
			$principalNames = $lDB->get("
				SELECT
					pr_persona.pr_name_first,
					pr_persona.pr_name_last
				FROM
					rf_default
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rf_default.rf_principal_id
			",1);
			$principalName = trim($principalNames['pr_name_first'] . " " . $principalNames['pr_name_last']);

			$from = $to = $resOffEmail;
			$subject = "Credit card payment received @ ".date("Y-m-d H:i:s")." for $rv_reservation_id";
			$headers = "From: ".$principalName."<$from>\r\n";

			$reservation = $lDB->get("
				SELECT
					rv_reservation.rv_res_name,
					agent_persona.pr_name_first,
					agent_persona.pr_name_last,
					rv_reservation.rv_note_general,
					rf_currency.rf_currency_symbol
				FROM
					rv_reservation
					LEFT JOIN pr_persona AS agent_persona ON agent_persona.pr_persona_ix = rv_reservation.rv_agent_id
					INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
				WHERE
				rv_reservation.rv_reservation_ix = '$rv_reservation_id'
			",1);

			$items = $lDB->get("
				SELECT
					pr_persona.pr_name_last,
					ac_accomm_type.ac_accomm_desc,
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.rv_item_date_depart,
					rv_reservation_item.rv_item_adult_count,
					rv_reservation_item.rv_item_child_count,
					rv_reservation_item.rv_item_accomm_count,
					rv_reservation_item.rv_item_nights
				FROM 
					rv_reservation_item
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
				WHERE
					rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
			",2);
			$itinerary = "";
			foreach($items as $item) {
				$item['rv_item_date_arrive'] = chng_date($item['rv_item_date_arrive'],"-");
				$item['rv_item_date_depart'] = chng_date($item['rv_item_date_depart'],"-");
				$itinerary .= "Property: $item[pr_name_last], Accommodation: $item[ac_accomm_desc], Arrive: $item[rv_item_date_arrive], Depart: $item[rv_item_date_depart], Rooms: $item[rv_item_accomm_count], Adults: $item[rv_item_adult_count], Children: $item[rv_item_child_count]\n";
			}
			$agent = trim($reservation['pr_name_first'] . " " . $reservation['pr_name_last']);
			if(!empty($agent)) {
				$agent = "\nAgent: $agent";
			}
			$message = "A credit card payment has been received with the following details:

Payment gateway: $pg_account[pg_acc_name]
Reference number: $payment[id]
Amount: $payment[amount] $reservation[rf_currency_symbol]
Reservation: $reservation[rv_res_name] ($rv_reservation_id)$agent
Itinerary:
$itinerary
Notes:
$reservation[rv_note_general]";

			email($from, $to, $subject, $headers, $message, 0, 0, $rv_reservation_id, $principalName);
		}
	}

	return $payment;
}

function clearPaymentGateway() {
	session_set("rv_payment_gateway_id","");
	session_set("rv_payment_gateway_folios","");
	session_set("rv_payment_gateway_amount","");
	session_set("rv_payment_gateway_reference","");
}
	
