<?php

/**
 * functions.audit.persona.php - Functions relating to audit trails for contacts
 */

require_once(__DIR__ . '/db.ad_res_detail.php');

// getPersonaAudit - returns all the audit records for a contact - already formatted for display
// =================================================================================================
function getPersonaAudit($record,$fromDate=false,$toDate=false,$parameters=false) {
	global $lDB;
	$fromDate = ($fromDate == "today") ? date("Y-m-d") : $fromDate;
	$toDate = ($toDate == "today") ? date("Y-m-d", strtotime("+1 days")) : $toDate;
	if ($fromDate == $toDate && $fromDate != null && $toDate != null) {
		$toDate = date('Y-m-d', strtotime($toDate . ' + 1 day'));
	}
	$users = false;
	$modules = false;
	$servers = false;
	$timezone = date("e");
	if (!empty($parameters)) {
		$users = (!empty($parameters['users'])) ? explode(":", $parameters['users']) : false;
		$modules = (!empty($parameters['modules'])) ? explode(":", $parameters['modules']) : false;
		$servers = (!empty($parameters['servers'])) ? explode(":", $parameters['servers']) : false;
		$timezone = (!empty($parameters['timezone'])) ? $parameters['timezone'] : date("e");
	}

	$where = "";
	$join = "";
	if($fromDate != false) {
		$where .= "
			AND ad_persona.ad_persona_time >= '$fromDate'
			";
	}
	if($toDate != false) {
		$where .= "
			AND ad_persona.ad_persona_time <= '$toDate'
			";
	}
	if($users != false) {
		$where .= "
			AND ad_persona.pr_user_id IN ('" . implode("','", $users) . "')
			";
	}
	if($modules != false) {
		$join .= "
			INNER JOIN ad_persona_detail ON ad_persona_detail.ad_persona_id = ad_persona.ad_persona_ix
			INNER JOIN ad_module_field ON ad_module_field.ad_module_field_id = ad_persona_detail.ad_module_field_id
			";
		$where = "
			AND ad_module_field.rf_audit_module_id IN ('" . implode("','", $modules) . "')
			";
	}
	if($servers != false) {
		$where .= "
			AND rf_database.rf_db_code IN ('" . implode("','", $servers) . "')
			";
	}
	$result = $lDB->get("
		SELECT DISTINCT
			ad_persona.ad_persona_ix,
			ad_persona.ad_persona_time,
			ad_persona.ad_persona_time_tz as timezone,
			rf_database.rf_db_code as server,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			ad_persona.pr_user_id as userid,
			ad_persona.ad_persona_form as details,
			ad_persona.rv_reservation_id AS res_id,
			rv_reservation.rv_res_name AS res_name
		FROM
			ad_persona
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ad_persona.pr_user_id
			INNER JOIN rf_database ON rf_database.rf_database_id = ad_persona.rf_database_id
			LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = ad_persona.rv_reservation_id
			$join
		WHERE
			ad_persona.pr_persona_id = '$record'
			$where
		ORDER BY
			ad_persona.ad_persona_time DESC
		",2);

	$olddate = 0;
	$max = sizeof($result);

	$data = array();
	foreach($result as $item) {
		$row = array();
		$temp = explode(" ",$item['ad_persona_time']);
		$row['date'] = "&nbsp;";
		
		if ($item['timezone'] != $timezone) {
			$datetime = new DateTime($item['ad_persona_time'], new DateTimeZone(date("e")) );
			$datetime->setTimeZone( new DateTimeZone($timezone) );
			$time = $datetime->format('H:i:s');
			if ($olddate != $temp[0]) {
				$row['date'] = $datetime->format('d M Y');
				$olddate = $temp[0];
			}
		} else {
			$time = $temp[1];
			if ($olddate != $temp[0]) {
				$row['date'] = chng_date($temp[0],"-");
				$olddate = $temp[0];
			}
		}
		$row['time'] = $time;
		$row['timeTitle'] = 'Original time zone: '.$item['timezone'].', displaying '.$timezone;
		$row['server'] = $item['server'];
		$row['user'] = trim($item['pr_name_first']." ".$item['pr_name_last']);
		$row['details'] = $item['details'];
		$row['res_id'] = (!empty($item['res_id'])?$item['res_id']:"");
		$row['res_name'] = (!empty($item['res_name'])?$item['res_name']:"");
		$row['items'] = getPersonaAuditDetails($item['ad_persona_ix']);
		$row['expander'] = strlen(trim($row['items'])) > 0 ? "<img id='img_" . $item['ad_persona_ix'] . "' onClick='toggle(this)' src='/resource/Resrequest/Application/public/img/property_collapsed.gif'>" : "";

		$relation = "0";
		$sql = "SELECT pr_link_to FROM pr_link WHERE pr_link_from = '$item[userid]' AND rf_link_type_id = 'RS1'";
		$staff = $lDB->get($sql,4);
		if ($staff == "0" || $staff == "") {
			$sql = "SELECT pr_link_to FROM pr_link WHERE pr_link_from = '$item[userid]' AND rf_link_type_id = 'RS2'";
			$agent = $lDB->get($sql,4);
			if ($agent != "0" && $agent != "") {
				$relation = $agent;
			}
		} else {
			$relation = $staff;
		}
		if ($relation != "0") {
			$row['user'] .= " (".$lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '".$relation."'",4).")";
		}
		if(strlen($row['user']) > 50) {
			$row['user'] = substr($row['user'],0,50) . "...";
		} else {
			$row['user'] = $row['user'];
		}
		array_push($data,$row);
	}
	if (sizeof($data) == 0) {
		return false;
	} else {
		return $data;
	}
}

// getResAuditDetails - returns all the audit detail records, formatted, for a contact audit record
// =================================================================================================
function getPersonaAuditDetails($ad_persona_id) {
	global $lDB;

	$auditDetails = $lDB->get("
		SELECT
			ad_module_field.ad_module_field_description,
			ad_module_field.ad_module_field_display_type_ind,
			rf_audit_module.rf_audit_module_name,
			rf_audit_module.rf_audit_module_description_internal,
			ad_persona_detail.ad_persona_detail_action_ind,
			ad_persona_detail.ad_persona_detail_value_from,
			ad_persona_detail.ad_persona_detail_value_to,
			ad_persona_detail.ad_persona_detail_value_from_display,
			ad_persona_detail.ad_persona_detail_value_to_display,
			ad_persona_detail.ad_persona_detail_field_id,
			ad_module_field.ad_module_field_display
		FROM
			ad_persona
			INNER JOIN ad_persona_detail ON ad_persona_detail.ad_persona_id = ad_persona.ad_persona_ix
			INNER JOIN ad_module_field ON ad_module_field.ad_module_field_id = ad_persona_detail.ad_module_field_id
			INNER JOIN rf_audit_module ON rf_audit_module.rf_audit_module_id = ad_module_field.rf_audit_module_id
			LEFT JOIN tc_table ON tc_table.tc_table_id = ad_module_field.tc_table_id_display
		WHERE
			ad_persona.ad_persona_ix = '$ad_persona_id'
		ORDER BY
			ad_persona_detail.ad_persona_detail_ix ASC
		",2);
	$resAuditDetailsTableHeader = "
		<table id='tbl_" . $ad_persona_id . "' style='table-layout:fixed; border-collapse: collapse;'>
			<tbody>
				<tr>
					<td class='outLt bAll' width='240px'>Field</td>
					<td class='outLt bAll' width='65px'>Module</td>
					<td class='outLt bAll' width='65px'>Action</td>
					<td class='outLt bAll' width='240px'>Before</td>
					<td class='outLt bAll' width='240px'>After</td>
				</tr>
	";
	$resAuditDetailsTableRows = array();
	$resAuditDetailsTableFooter = "</tbody></table>";
	$auditDetailsCounter = 1;
	foreach($auditDetails as $auditDetail) {
		$action = db_ad_persona_detail_action_desc($auditDetail['ad_persona_detail_action_ind']);
		$valueFrom = (!empty($auditDetail['ad_persona_detail_value_from_display'])) ? $auditDetail['ad_persona_detail_value_from_display'] : $auditDetail['ad_persona_detail_value_from'];
		$valueTo = (!empty($auditDetail['ad_persona_detail_value_to_display'])) ? $auditDetail['ad_persona_detail_value_to_display'] : $auditDetail['ad_persona_detail_value_to'];
		$tdFirst = (count($auditDetails) == $auditDetailsCounter) ? "<td class='bl bb'>" : "<td class='bl'>";
		$tdInner = (count($auditDetails) == $auditDetailsCounter) ? "<td class='bb'>" : "<td class=''>";
		$fieldDescription = $auditDetail['ad_module_field_description'];
		if(!empty($auditDetail['ad_persona_detail_field_id'])) {
			$newDescription = false;
			switch($auditDetail['rf_audit_module_description_internal']) {
			case "guest":
				$newDescription = $lDB->get("SELECT rf_obj_guest_label FROM rf_obj_guest WHERE rf_obj_guest_ix = '".$lDB->escape($auditDetail['ad_persona_detail_field_id'])."'",4);
				break;
			case "tripsheet":
				$newDescription = $lDB->get("SELECT rf_obj_trip_label FROM rf_obj_trip WHERE rf_obj_trip_ix = '".$lDB->escape($auditDetail['ad_persona_detail_field_id'])."'",4);
				break;
			}
			if($newDescription !== false) {
				$fieldDescription = $newDescription;
			}
		}
		$resAuditDetailsTableRows[] = $tdFirst . implode("</td>$tdInner", array(
			$fieldDescription,
			$auditDetail['rf_audit_module_name'],
			$action,
			db_ad_res_detail_format($valueFrom, $auditDetail['ad_module_field_display_type_ind']),
			db_ad_res_detail_format($valueTo, $auditDetail['ad_module_field_display_type_ind'])
		)) . "</td>";
		$auditDetailsCounter += 1;
	}
	$resAuditDetails = (count($auditDetails) == 0 ? "" :
		$resAuditDetailsTableHeader . "<tr>" . implode("</tr><tr>", $resAuditDetailsTableRows) . "</tr>" . $resAuditDetailsTableFooter
	);
	return $resAuditDetails;
}


