<?php

/**
 * functions.persona - Functions used when dealing with persona information
 */

require_once(__DIR__ . '/class.audit.php');
require_once(__DIR__ . "/db.ad_persona_detail.php");
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.tc_table.php");
require_once(__DIR__ . "/functions.error.php");

// canEditContact - returns true if a user can 'edit' a contact, and false if not allowed
// =================================================================================================
function canEditContact($record, $checkAccess=true, $job="45") {
	global $lDB;

	if($checkAccess) {
		$jobAllow = checkJob($job);
	} else {
		$jobAllow = true;
	}

	if (!canEditDB($lDB->get("SELECT pr_persona_db FROM pr_persona WHERE pr_persona_ix = '$record'",4))) {
		return false;
	}

	return $jobAllow;
}

function canDeleteContact($pr_persona_ix) {
	global $lDB;
	
	$canDelete = true;
	$GLOBALS['temp']['del_error'] = "";

	$resLinked = "0";
	$resCount = $lDB->get("
		SELECT
			COUNT(rv_reservation_id)
		FROM
			rv_reservation
			WHERE 
				rv_agent_id = '$pr_persona_ix'
				OR rv_billing_persona_id = '$pr_persona_ix'
				OR rv_consultant_id = '$pr_persona_ix'
				OR rv_cancel_user_id = '$pr_persona_ix'
				OR rv_confirmation_user_id = '$pr_persona_ix'
				OR rv_corr_persona_id = '$pr_persona_ix'
				OR rv_invoice_persona_id = '$pr_persona_ix'
				OR rv_origin_agent_id = '$pr_persona_ix'
				OR rv_wait_list_user_id = '$pr_persona_ix'
				OR pr_reservation_user_id = '$pr_persona_ix'
	",4);
	$auditCount = $lDB->get("SELECT COUNT(*) FROM ad_reservation WHERE ad_reservation.pr_user_id = '$pr_persona_ix'",4);
	if($resCount > 0 || $auditCount > 0) {
		$GLOBALS['temp']['del_error'] = "This contact is linked to a reservation.";
		$canDelete = false;
	}
	
	if ($resCount < 1) {
		$resItemCount = $lDB->get("SELECT COUNT(rv_reservation_item_id) FROM rv_reservation_item WHERE rv_item_user_id = '$pr_persona_ix'",4);
		if ($resItemCount > 0) {
			$resLinked = 1;
			$GLOBALS['temp']['del_error'] = "This Contact is linked to a reservation item!<br>";
		}
	} else {
		$resLinked = 1;
	}
    
	$extraCount = $lDB->get("SELECT COUNT(*) FROM ac_extra WHERE ac_extra.pr_supplier_id = '$pr_persona_ix'",4);
	$resExtraCount = $lDB->get("SELECT COUNT(*) FROM rv_extra WHERE rv_extra.pr_supplier_id = '$pr_persona_ix'",4);
	if($resExtraCount > 0 || $extraCount > 0 ) {
		$GLOBALS['temp']['del_error'] = "This contact is linked to an extra as a supplier.";
		$canDelete = false;
	}

	$resSurveyCount = $lDB->get("SELECT COUNT(*) FROM zg_transfer_guest WHERE zg_transfer_guest.pr_guest_id = '$pr_persona_ix'",4);
	if($resSurveyCount > 0 ) {
		$GLOBALS['temp']['del_error'] = "This guest is linked to a survey.";
		$canDelete = false;
	}

   $checkCount = $lDB->get("SELECT COUNT(rf_sys_admin.rf_sys_admin_ix) FROM rf_sys_admin WHERE rf_sys_admin.pr_persona_id = '$pr_persona_ix'",4);
   
	$GLOBALS['temp']['reqEmail'] = "0";
	if ($checkCount > 0) {
		$GLOBALS['temp']['del_error'] = "This contact is a system administrator. Deletion disallowed.<br>";
		$GLOBALS['temp']['reqEmail'] = "1";
		$canDelete = false;
	}

	$checkCount = $lDB->get("SELECT COUNT(rf_default.rf_principal_id) FROM rf_default WHERE rf_default.rf_principal_id = '$pr_persona_ix'",4);
	if ($checkCount > 0) {
		$GLOBALS['temp']['del_error'] = "This contact is the principal. Deletion disallowed.<br>";
		$canDelete = false;
	}

	$checkCount = $lDB->get("SELECT COUNT(pr_link_to) FROM pr_link where pr_link.pr_link_to = '$pr_persona_ix'",4);
	if ($checkCount > 0) {
		$GLOBALS['temp']['del_error'] = "Please delete links to other contacts before deleting this record.<br>";
		$canDelete = false;
	}

	$checkCount = $lDB->get("SELECT COUNT(*) from pr_business where pr_business_id = '$pr_persona_ix'",4);
	if ($checkCount > 0) {
		$GLOBALS['temp']['del_error'] = "This contact is a business or property. Deletion disallowed<br>";
		$canDelete = false;
	}

	if ($GLOBALS['userid'] == $pr_persona_ix) {
		$GLOBALS['temp']['del_error'] = "This user name is already in use. Please enter another.<br>";
		$canDelete = false;
	}


	// Guest contact checks start
	$checkCount = $lDB->get("SELECT count(*) from pr_guest where pr_guest_id = '$pr_persona_ix'",4);
	if($checkCount > 0) {
		$resCount = $lDB->get("SELECT COUNT(*) FROM rv_reservation_guest WHERE pr_guest_id = '$pr_persona_ix'",4);
		if($resCount > 0) {
			$canDelete = false;
		}
		$itemCount = $lDB->get("SELECT COUNT*) FROM rv_res_item_guest WHERE pr_guest_id = '$pr_persona_ix'",4);
		if($itemCount > 0) {
			$canDelete = false;
		}
	}
	// Guest contact checks end


	// Allocated consultant check start
	$count = $lDB->get("select count(*) from rv_reservation where rv_consultant_id = '".$pr_persona_ix."'",4);
	if ($count > 0) {
		$canDelete = false;
	}
	// Allocated consultant check end	
	
	// Financial document checks start
	$count = $lDB->get("SELECT COUNT(*) FROM fn_folio WHERE fn_folio_to_id = '$pr_persona_ix'",4);
	if ($count > 0) {
		$canDelete = false;
	}
	$count = $lDB->get("SELECT COUNT(*) FROM rv_payment WHERE pr_persona_id = '$pr_persona_ix'",4);
	if ($count > 0) {
		$canDelete = false;
	}
	$count = $lDB->get("SELECT COUNT(*) FROM rv_payment WHERE rv_pmnt_user_id = '$pr_persona_ix'",4);
	if ($count > 0) {
		$canDelete = false;
	}
	$count = $lDB->get("SELECT COUNT(*) FROM rv_payment_item WHERE rv_pay_item_void_user_id = '$pr_persona_ix'",4);
	if ($count > 0) {
		$canDelete = false;
	}
	// Financial document checks end

	$count = $lDB->get("SELECT COUNT(*) FROM pr_event_persona WHERE pr_persona_id = '$pr_persona_ix' AND pr_event_rep_ind >0",4);
	if ($count > 0) {
		$canDelete = false;
	}
	return $canDelete;
}

function cleanContact($pr_persona_ix) {
	global $lDB;

	error_log("CLEAN CONTACT");

	// Remove contact links
	$prlink = $lDB->get("SELECT pr_link_ix FROM pr_link WHERE pr_link_from = '$pr_persona_ix' OR pr_link_to = '$pr_persona_ix'",3);
	foreach($prlink as $item) {
		$lDB->put("DELETE FROM pr_link WHERE pr_link_ix = '$item'");
	}

	// Remove phone numbers
	$prphone = $lDB->get("select pr_phone_ix from pr_phone WHERE pr_persona_id = '$pr_persona_ix'",3);
	foreach($prphone as $item) {
		$lDB->put("DELETE FROM pr_phone WHERE pr_phone_ix = '$item'");
	}

	// Remove user role and linked data
	if (!$lDB->count("pr_user","pr_user_id",$pr_persona_ix,0)) {
		$lDB->put("DELETE FROM pr_user WHERE pr_user_id = '$pr_persona_ix'");

		$temp = $lDB->get("SELECT sc_user_id FROM sc_user WHERE pr_user_id = '$pr_persona_ix'",4);
		if ($temp != "0") {
			$lDB->put("DELETE FROM sc_user WHERE sc_user_id = '$temp'");
		}
	}

	// Remove agent role and linked agent rates
	if (!$lDB->count("pr_agent","pr_agent_id",$pr_persona_ix,0)) {
		$lDB->put("DELETE FROM pr_agent WHERE pr_agent_id = '$pr_persona_ix'");

		$pr_agent_rate_ids = $lDB->get("SELECT pr_agent_rate_ix FROM pr_agent_rate WHERE pr_agent_id = '$pr_persona_ix'",3);
		foreach($pr_agent_rate_ids as $pr_agent_rate_id) {
			$lDB->put("DELETE FROM pr_agent_rate WHERE pr_agent_rate_ix = '$pr_agent_rate_id'");
		}

		$pr_agent_prop_ids = $lDB->get("SELECT pr_agent_prop_ix FROM pr_agent_prop WHERE pr_agent_id = '$pr_persona_ix'",3);
		foreach($pr_agent_prop_ids as $pr_agent_prop_id) {
			$lDB->put("DELETE FROM pr_agent_prop WHERE pr_agent_prop_ix = '$pr_agent_prop_id'");
		}
	}

	// Remove guest role and any guest profile data
	if (!$lDB->count("pr_guest","pr_guest_id",$pr_persona_ix,0)) {
		$lDB->put("DELETE FROM pr_guest WHERE pr_guest_id = '$pr_persona_ix'");
		$pr_guest_obj_data_ids = $lDB->get("SELECT pr_guest_obj_data_ix FROM pr_guest_obj_data WHERE pr_guest_id = '$pr_persona_ix'",3);
		foreach($pr_guest_obj_data_ids as $pr_guest_obj_data_id) {
			$lDB->put("DELETE FROM pr_guest_obj_data WHERE pr_guest_obj_data_ix = '$pr_guest_obj_data_id'");
		}
	}

	// Remove supplier role
	if (!$lDB->count("pr_supplier","pr_supplier_id",$pr_persona_ix,0)) {
		$lDB->put("DELETE FROM pr_supplier WHERE pr_supplier_id = '$pr_persona_ix'");
	}

	// Remove financial interface mappings
	$pr_persona_inv_ids = $lDB->get("SELECT pr_persona_inv_ix FROM pr_persona_inv WHERE pr_persona_id = '$pr_persona_ix'",3);
	foreach($pr_persona_inv_ids as $pr_persona_inv_id) {
		$lDB->put("DELETE FROM pr_persona_inv WHERE pr_persona_inv_ix = '$pr_persona_inv_id'");
	}

	// Remove Sales profile data
	$pr_sales_obj_data_ids = $lDB->get("SELECT pr_sales_obj_data_ix FROM pr_sales_obj_data WHERE pr_persona_id = '$pr_persona_ix'",3);
	foreach($pr_sales_obj_data_ids as $pr_sales_obj_data_id) {
		$lDB->put("DELETE FROM pr_sales_obj_data WHERE pr_sales_obj_data_ix = '$pr_sales_obj_data_id'");
	}

	// Remove CRM data
	$crms = $lDB->get("SELECT pr_event_persona_ix, pr_event_id FROM pr_event_persona WHERE pr_persona_id = '$pr_persona_ix'",2);
	foreach($crms as $item) {
		$lDB->put("DELETE FROM pr_event WHERE pr_event_ix = '".$item['pr_event_id']."'");
		$lDB->put("DELETE FROM pr_event_persona WHERE pr_event_persona_ix = '".$item['pr_event_persona_ix']."'");
	}
}

function getLinkedAddressDetails($pr_persona_ix) {
   return $GLOBALS['lDB']->get("
      SELECT
         pr_corr_addr_line1,
         pr_corr_addr_line2,
         pr_corr_post_code,
         pr_phys_addr_line1,
         pr_phys_addr_line2,
         pr_phys_post_code
      FROM
         pr_persona
      WHERE
         pr_persona_ix = '".getFwdAddress($pr_persona_ix)."'
   ",1);
}

function getFaxNumber($pr_persona_ix) {
   return $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         rf_phone_type
         LEFT JOIN pr_phone ON pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND pr_phone.pr_persona_id = '$pr_persona_ix'
      WHERE
         rf_phone_type.rf_phone_type_sys_code = '1'
   ",4);
}

function getDefPhoneNumber($pr_persona_ix) {
   return $GLOBALS['lDB']->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone
      WHERE
         pr_phone.pr_persona_id = '$pr_persona_ix'
      ORDER BY
         pr_phone.pr_default_yn desc
      LIMIT 1
   ",4);
}

// getPersona - calls to mysql and returns the data based on parameters it recieves.
// =================================================================================================
function getPersona($fields,$id,$mode=1) {
   if (!is_array($fields)) {
      if (strpos($fields,":") !== false) {
         $fields = explode(":",$fields);
      } elseif (strpos($fields,";") !== false) {
         $fields = explode(";",$fields);
      } elseif (strpos($fields,",") !== false) {
         $fields = explode(",",$fields);
      } elseif (strpos($fields,"|") !== false) {
         $fields = explode("|",$fields);
      } else {
         $fields = array($fields);
      }
   }
   return $GLOBALS['lDB']->get("SELECT ".join(", ",$fields)." FROM pr_persona WHERE pr_persona_ix = '$id'",$mode);
}


// isPrincOrResOffice - returns true if the specified record is set as the principal or res office.
// =================================================================================================
function isPrincOrResOffice($id) {
   global $lDB;

   if ($lDB->get("SELECT COUNT(*) FROM rf_default WHERE rf_principal_id = '$id' or rf_res_office_id = '$id'",4) != "0") {
      return true;
   }
   return false;
}


function fwdContact($contactIdArray) {
   global $lDB;

   $rv_corr_persona_id = $contactIdArray['rv_corr_persona_id'];
   $fwdArray = $lDB->get("
      SELECT
         pr_persona_link_id,
         pr_persona_fwd_id
      FROM
         pr_persona
      WHERE
         pr_persona.pr_persona_ix = '$rv_corr_persona_id'
   ",1);
   $contactIdArray['pr_persona_link_id'] = $fwdArray['pr_persona_link_id'];
   $contactIdArray['pr_persona_fwd_id']  = $fwdArray['pr_persona_fwd_id'];
   if ($contactIdArray['pr_persona_fwd_id'] > '0') {
      $contactIdArray['rv_corr_persona_id'] = $fwdArray['pr_persona_fwd_id'];
   }
   return $contactIdArray;
}

#
# Function: Resolve linked address
#

function linkContact($contactIdArray,$mode=0) {
   global $lDB;

   if ($mode != 0) {
      $result = $contactIdArray;
      while($result != "0" && $result != "") {
         $result = $lDB->get("SELECT pr_persona_link_id FROM pr_persona WHERE pr_persona_ix = '$result'",4);
      }
      if ($result == "0" || $result = "") {
         $result = $contactIdArray;
      }
      return $result;
   } else {
      if (!is_array($contactIdArray)) {
         $contactIdArray = array("rv_corr_persona_id" => $contactIdArray);
      }
      $rv_corr_persona_id = $contactIdArray['rv_corr_persona_id'];
      $linkArray = $lDB->get("
         SELECT
            pr_persona_link_id
         FROM
            pr_persona
         WHERE
            pr_persona.pr_persona_ix = '$rv_corr_persona_id'
      ",4);
      $contactIdArray['pr_persona_link_id'] = $linkArray;
      if ($contactIdArray['pr_persona_link_id'] > '0') {
         $contactIdArray['rv_corr_persona_id'] = $linkArray;
      }
      return $contactIdArray;
   }
}

#
# Function: Get agent name
#

function agentName($rv_agent_id) {
   return $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '$rv_agent_id'",4);
}

function getContactFullName($pr_persona_id,$detailed=true) {
   $name = "";
   $nameData = $GLOBALS['lDB']->get("
      SELECT
         rf_title.rf_title_desc,
         pr_persona.pr_name_first,
         pr_persona.pr_name_last,
         rf_name_suffix.rf_suffix_desc
      FROM
         pr_persona
         LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
         LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
      WHERE
         pr_persona.pr_persona_ix = '$pr_persona_id'
   ",1);
   if ($nameData['rf_title_desc'] != "" && $detailed) { $name .= $nameData['rf_title_desc']." "; }
   if ($nameData['pr_name_first'] != "") {
      $name .= $nameData['pr_name_first'];
      if ($nameData['pr_name_last'] != "") { $name .= ", "; }
   }
   if ($nameData['pr_name_last'] != "") { $name .= $nameData['pr_name_last']." "; }
   if ($nameData['rf_suffix_desc'] != "" && $detailed) { $name .= $nameData['rf_suffix_desc']." "; }
   return $name;
}

function getReverseName($pr_persona_id) {
   $nameData = $GLOBALS['lDB']->get("
      SELECT
         trim(rf_title.rf_title_desc) as rf_title_desc,
         trim(pr_persona.pr_name_first) as pr_name_first,
         trim(pr_persona.pr_name_last) as pr_name_last,
         trim(rf_name_suffix.rf_suffix_desc) as rf_suffix_desc
      FROM
         pr_persona
         LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
         LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
      WHERE
         pr_persona.pr_persona_ix = '$pr_persona_id'
   ",1);
   $name = "";
   if ($nameData['pr_name_last'] != "") { $name .= $nameData['pr_name_last']; }
   if ($nameData['rf_suffix_desc'] != "") { $name .= " ".$nameData['rf_suffix_desc']; }   
   if ($nameData['pr_name_first'] != "") {
     if ($nameData['pr_name_last'] != "") { $name .= ", "; }
     $name .= $nameData['pr_name_first'];
   }
   if ($nameData['rf_title_desc'] != "") {
   	 $name .= " ".$nameData['rf_title_desc']; 
   }   
   return $name;
}


function getFwdPersona($pr_persona_id) {
	global $lDB;
	# Find the forward contact
	$result = $pr_persona_id;
	$addressId = "";
	$depthCount = 0;
	while ($result != "0" && trim($result) != "" && $addressId != $result) {
		$depthCount++;
		if ($depthCount > 10) {
			break;
		}
		$addressId = $result;
		$result = $lDB->get("SELECT pr_persona_fwd_id FROM pr_persona WHERE pr_persona.pr_persona_ix = '$result'",4);
	}
	if ($depthCount > 10) {
		$error_number = 1;
		$error_message = "A circular contact relationship error has occurred. Please contact support to resolve this issue";
		$error_file = "";
		$error_line = "";
		errorHandlerCreate($error_number,$error_message);
		errorHandler($error_number, $error_message, $error_file, $error_line);
	}
	return $addressId;
}

function getFwdAddress($pr_persona_id) {
	global $lDB;
	# Find the forward contact
	$result = $pr_persona_id;
	$addressId = "";
	$depthCount = 0;
	while ($result != "0" && trim($result) != "" && $addressId != $result) {
		$depthCount++;
		if ($depthCount > 10) {
			break;
		}
		$addressId = $result;
		$result = $lDB->get("SELECT pr_persona_link_id FROM pr_persona WHERE pr_persona.pr_persona_ix = '$result'",4);
	}
	if ($depthCount > 10) {
		$error_number = 1;
		$error_message = "A circular contact relationship error has occurred. Please contact support to resolve this issue";
		$error_file = "";
		$error_line = "";
		errorHandlerCreate($error_number,$error_message);
		errorHandler($error_number, $error_message, $error_file, $error_line);
	}
	return $addressId;
}

function getContactCorrAddress($pr_persona_id) {
   $pr_persona_id = getFwdPersona($pr_persona_id);
   $addressId = getFwdAddress($pr_persona_id);
   $address = "";

   $addressData = $GLOBALS['lDB']->get("
      SELECT
         pr_persona.pr_corr_addr_line1,
         pr_persona.pr_corr_addr_line2,
         pr_persona.pr_corr_addr_line3,
         pr_persona.pr_corr_city,
         rf_country.rf_country_name,
         pr_persona.pr_corr_post_code
      FROM
         pr_persona
         LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
      WHERE
         pr_persona.pr_persona_ix = '$addressId'
   ",1);
   if ($addressData[0] != "" && $addressData[0] != "0") { $address .= $addressData[0]."\n"; }
   if ($addressData[1] != "" && $addressData[1] != "0") { $address .= $addressData[1]."\n"; }
   if ($addressData[2] != "" && $addressData[2] != "0") { $address .= $addressData[2]."\n"; }
   if ($addressData[3] != "" && $addressData[3] != "0") { $address .= $addressData[3]."\n"; }
   if ($addressData[4] != "" && $addressData[4] != "0") { $address .= $addressData[4]."\n"; }
   if ($addressData[5] != "" && $addressData[5] != "0") { $address .= $addressData[5]."\n"; }

   return $address;
}

function getContactPhysAddress($pr_persona_id) {
	$address = "";
	$addressData = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_phys_addr_line1,
			pr_persona.pr_phys_addr_line2,
			pr_persona.pr_phys_addr_line3,
			pr_persona.pr_phys_city,
			rf_country.rf_country_name,
			pr_persona.pr_phys_post_code
		FROM
			pr_persona
			LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_phys_country_id
		WHERE
			pr_persona.pr_persona_ix = '$pr_persona_id'
		",1);
	if ($addressData[0] != "" && $addressData[0] != "0") { $address .= $addressData[0]."\n"; }
	if ($addressData[1] != "" && $addressData[1] != "0") { $address .= $addressData[1]."\n"; }
	if ($addressData[2] != "" && $addressData[2] != "0") { $address .= $addressData[2]."\n"; }
	if ($addressData[3] != "" && $addressData[3] != "0") { $address .= $addressData[3]."\n"; }
	if ($addressData[4] != "" && $addressData[4] != "0") { $address .= $addressData[4]."\n"; }
	if ($addressData[5] != "" && $addressData[5] != "0") { $address .= $addressData[5]."\n"; }
	
	return $address;
}

function getAddresseeDetails($reservationId) {
   # Part 1, get the addressee
   $data = $GLOBALS['lDB']->get("
      SELECT
         rv_corr_persona_id,
         rv_agent_id
      FROM
         rv_reservation
      WHERE
         rv_reservation_ix = '$reservationId'
   ",1);
   $addressee = (string) $data['rv_corr_persona_id'];
   if ($data['rv_agent_id'] != "0" && $data['rv_agent_id'] != "") { $addressee = (string) $data['rv_agent_id']; }

   # Part 2, get the addressee Name
   $name = getContactFullName($addressee);

   # Part 3, get the correct (?fwd) address
   $address = getContactCorrAddress($addressee);

   # Return formatted data
   return $name."<br>".nl2br($address);
}

function getFwdPersonaContactDetails($pr_persona_id) {
   $fwd_persona = getFwdPersona($pr_persona_id);
   $pr_persona_id = $fwd_persona;

   return getContactDetails($pr_persona_id);
}

function getContactDetails($pr_persona_id) {
   global $lDB;

   $result = array();
   $temp = $lDB->get("
      SELECT
         pr_email,
		 pr_web_addr,
		 pr_name_last,
		 pr_name_first
      FROM
         pr_persona
      WHERE
         pr_persona_ix = '$pr_persona_id'
   ",1);

   $result['first_name'] = $temp['pr_name_first'];
   $result['last_name'] = $temp['pr_name_last'];

   if ($temp['pr_email'] != "" && $temp['pr_email'] != "0") {
      $result['email_address'] = $temp['pr_email'];
   } else {
      $result['email_address'] = "None";
   }

   if ($temp['pr_web_addr'] != "" && $temp['pr_web_addr'] != "0") {
      $result['web_address'] = $temp['pr_web_addr'];
   } else {
      $result['web_address'] = "None";
   }

   $temp = $lDB->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         rf_phone_type
      LEFT JOIN
         pr_phone ON pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
         AND pr_phone.pr_persona_id = '$pr_persona_id'
      WHERE
         rf_phone_type.rf_phone_type_sys_code = '1'
   ",4);
   if ($temp != "" && $temp != "0") {
      $result['fax_number'] = $temp;
   } else {
      $result['fax_number'] = "None";
   }

   $temp = $lDB->get("
      SELECT
         pr_phone.pr_phone_number
      FROM
         pr_phone
      WHERE
         pr_phone.pr_persona_id = '$pr_persona_id'
      ORDER BY
         pr_phone.pr_default_yn desc
      LIMIT 1
   ",4);
   if ($temp != "" && $temp != "0") {
      $result['tel_number'] = $temp;
   } else {
      $result['tel_number'] = "None";
   }

   $result['persona_id'] = $pr_persona_id;

   return $result;
}

function getEmailPrincDetails($reservationId) {
   $contactIds = $GLOBALS['lDB']->get("
      SELECT
         rv_reservation.rv_consultant_id,
         rf_default.rf_principal_id
      FROM
         rv_reservation,
         rf_default,
         pr_persona
      WHERE
         rv_reservation.rv_reservation_ix = '$reservationId'
            AND pr_persona.pr_persona_ix = rf_default.rf_principal_id
   ",1);

   nozero($consultName,trim(getContactFullName($contactIds['rv_consultant_id'])));
   $princName = getContactFullName($contactIds['rf_principal_id']);
   $princPhone = getContactDetails($contactIds['rf_principal_id']);
   $princAddress = getContactCorrAddress($contactIds['rf_principal_id']);

   $end = "";
   if ($consultName != "") { $end .= $consultName."<br>"; }
   $end .= $princName;
   if ($princPhone['tel_number'] != "") { $end .= "<br>Telephone: ".$princPhone['tel_number']; }
   if ($princPhone['fax_number'] != "") { $end .= "<br>Fax: ".$princPhone['fax_number']; }
   $end .= "<br>".nl2br($princAddress);
   return $end."<br>";
}

function addLastContact($pr_pesona_id) {
	global $lDB;
	
	$check = $lDB->get("SELECT COUNT(*) FROM pr_persona WHERE pr_persona_ix = '$pr_pesona_id'",4);
	if($check == "0") { return false; }

	if(!isset($_SESSION['lastContactArray']) || !is_array($_SESSION['lastContactArray'])) {
		$lastContactArray = array();
	} else {
		$lastContactArray = $_SESSION['lastContactArray'];
	}
	if(in_array($pr_pesona_id,$lastContactArray)) {
		$newLastContactArray = array();
		foreach($lastContactArray as $item) {
			if($item != $pr_pesona_id) {
				array_push($newLastContactArray,$item);
			}
		}
		$lastContactArray = $newLastContactArray;
	}

	array_unshift($lastContactArray,$pr_pesona_id);
	if(sizeof($lastContactArray) > 20) {
		array_pop($lastContactArray);
	}

	session_set("lastContactArray",$lastContactArray);
	return $lastContactArray;
}

function getContactRoles($pr_persona_id) {
	global $lDB;

	$roles = array('agent','business','guest','supplier','user');

	$fields = array('pr_persona.pr_persona_ix');
	$joins = array();

	foreach($roles as $role) {
		$fields[] = "pr_" . $role . ".pr_" . $role . "_id";
		$joins[] = "LEFT JOIN pr_" . $role . " ON pr_" . $role . ".pr_" . $role . "_id = pr_persona.pr_persona_ix";
	}

	$result = $lDB->get("
		SELECT
			".join(",\n",$fields)."
		FROM
			pr_persona
			".join("\n",$joins)."
		WHERE
			pr_persona.pr_persona_ix = '".$lDB->escape($pr_persona_id)."'
	",1);


	if(empty($result)) {
		return false;
	}

	$response = array();

	foreach($roles as $role) {
		$response[$role] = (empty($result['pr_' . $role . '_id'])?false:true);
	}

	return $response;
}

function replaceContact($from, $to, $after="delete") {
	global $lDB;

	if(!is_array($from)) {
		$from = array($from);
	}

	// All from contacts must exist
	foreach($from as $from_persona_id) {
		if(!db_pr_persona_exists($from_persona_id)) {
			return array(false,"From contact does not exist");
		}
	}

	// To contact must exist
	if(!db_pr_persona_exists($to)) {
		return array(false,"To contact does not exist");
	}

	// All from contacts must have the same roles as to contact and not be a business
	$toRoles = getContactRoles($to);
	if($toRoles['business']) {
		return array(false,"To contact is a business");
	}
	foreach($from as $from_persona_id) {
		$fromRoles = getContactRoles($from_persona_id);
		if($fromRoles['business']) {
			return array(false,"From contact is a business");
		}
		foreach($fromRoles as $role=>$state) {
			if($toRoles[$role] != $state) {
				return array(false,"To contact roles do not match from contacts");
			}
		}
	}

	// After replacing contact the action can be:
	//   delete: Delete the from contacts
	//   inactive: Make the from contacts inactive
	//   active: Make the from contacts active
	//   none: Leave from contacts as is
	if($after != "delete" && $after != "inactive" && $after != "active" && $after != "none") {
		return array(false,"After action invalid");
	}

	// Reset the listed default toggle fields on the 'From' contacts to off (zero)
	$resetDefaultLinks = array(
		array(
			'table'=>'pr_phone',
			'key'=>'pr_persona_id',
			'default'=>'pr_default_yn'
		),
		array(
			'table'=>'pr_agent_rate',
			'key'=>'pr_agent_id',
			'default'=>'pr_agent_rate_default_yn'
		)
	);

	foreach($resetDefaultLinks as $link) {
		$tableKey = db_tc_table_get_key($link['table']);
		$ids = $lDB->get("
			SELECT
				$tableKey
			FROM
				$link[table]
			WHERE
				$link[key] IN ('".join("','",$from)."')
				AND $link[default] != '0'
		",3);
		foreach($ids as $id) {
			$lDB->put("UPDATE $link[table] SET $link[default] = '0' WHERE $tableKey = '$id'");
		}
	}

	// Find all occurances of the 'From' contacts id within the following tables and fields and
	// where found set it to the 'To' contact id
	$replaceLinks = array(
		'ad_db_status'=>array("ad_db_user_id"),
		'ad_reservation'=>array("pr_user_id"),
		'ad_user_log'=>array("pr_user_id"),
		'em_mail_log'=>array("pr_user_id"),
		'fn_batch'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'fn_debtor'=>array("pr_persona_id"),
		'fn_folio'=>array(
			"fn_folio_to_id",
			"ad_create_user_id",
			"ad_modify_user_id"
		),
		'fn_invoice'=>array(
			"ad_create_user_id",
			"ad_modify_user_id"
		),
		'fn_tran'=>array(
			"pr_persona_id",
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'fn_tran_item'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'fn_year'=>array(
			"ad_create_user_id"
		),
		'pg_account'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'pg_acc_business'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'pg_acc_currency'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'pg_acc_method'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'pg_acc_obj_data'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'pr_event_persona'=>array(
			"pr_persona_id"
		),
		'pr_link'=>array(
			"pr_link_to"
		),
		'pr_persona'=>array(
			"pr_persona_link_id",
			"pr_persona_fwd_id"
		),
      'rf_default'=>array(
         "rf_cc_res_summ_persona_id",
         "rf_cc_proforma_persona_id",
         "rf_cc_invoice_persona_id",
         "rf_sys_admin_id"
      ),
      'rf_sys_admin'=>array(
         "pr_persona_id"
      ),
		'rv_extra'=>array(
			"rv_extra_void_user_id",
			"pr_business_inv_id",
			"pr_supplier_id",
			"ad_create_user_id",
			"ad_modify_user_id"
		),
		'rv_note'=>array("ad_create_user_id"),
		'rv_payment'=>array(
			"pr_persona_id",
			"rv_pmnt_user_id"
		),
		'rv_payment_gateway'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'rv_payment_item'=>array("rv_pay_item_void_user_id"),
		'rv_reservation'=>array(
			"rv_agent_id",
			"rv_billing_persona_id",
			"rv_cancel_user_id",
			"rv_confirmation_user_id",
			"rv_consultant_id",
			"rv_corr_persona_id",
			"rv_invoice_persona_id",
			"rv_origin_agent_id",
			"rv_wait_list_user_id",
			"pr_reservation_user_id"
		),
		'rv_reservation_guest'=>array("pr_guest_id"),
		'rv_reservation_item'=>array("rv_item_user_id"),
		'rv_res_item_guest'=>array("pr_guest_id"),
		'rv_special'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'rv_trip_obj_data'=>array("pr_guest_id"),
		'sp_accomm_type'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'sp_rate_group_benefit'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'sp_rate_group_qualify'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'sp_special'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'sp_special_period'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'sp_special_rate_type'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'tc_transfer'=>array("tc_user_id"),
		'zg_transfer_guest'=>array("pr_guest_id"),
		'zs_queue'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'zs_schedule'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'zs_task'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'zs_task_log'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		),
		'zs_task_notify'=>array(
			"ad_create_user_id",
			"ad_delete_user_id",
			"ad_modify_user_id"
		)
	);

	foreach($replaceLinks as $table=>$fields) {
		$key = db_tc_table_get_key($table);
		foreach($fields as $field) {
			$ids = $lDB->get("SELECT $key FROM $table WHERE $field IN ('".join("','",$from)."')",3);
			if(sizeof($ids) > 0) {
				foreach($ids as $id) {
					$lDB->put("UPDATE $table SET $field = '".$lDB->escape($to)."' WHERE $key = '$id'");
				}
			}
		}
	}

	$nonDuplicateLinks = array(
		array(
			'table'=>'pr_phone',
			'key'=>'pr_persona_id',
			'fields'=>array(
				'pr_phone_number',
				'rf_phone_type_id'
			)
		),
		array(
			'table'=>'pr_agent_rate',
			'key'=>'pr_agent_id',
			'fields'=>array(
				'rt_rate_type_id'
			)
		),
		array(
			'table'=>'pr_link',
			'key'=>'pr_link_from',
			'fields'=>array(
				'rf_link_type_id'
			)
		)
	);

	foreach($nonDuplicateLinks as $link) {
		$tableKey = db_tc_table_get_key($link['table']);

		$toItems = $lDB->get("
			SELECT
				$tableKey as 'key',
				".join(",",$link['fields'])."
			FROM
				$link[table]
			WHERE
				$link[key] = '".$lDB->escape($to)."'
		",2);
		$newToItems = array();
		foreach($toItems as $toItem) {
			$fieldValues = array();
			foreach($link['fields'] as $field) {
				$fieldValues[] = $toItem[$field];
			}
			$newToItems[$toItem['key']] = join("_",$fieldValues);
		}
		$toItems = $newToItems;
		unset($newToItems);
		foreach($from as $from_persona_id) {
			$fromItems = $lDB->get("
				SELECT
					$tableKey as 'key',
					".join(",",$link['fields'])."
				FROM
					$link[table]
				WHERE
					$link[key] = '".$lDB->escape($from_persona_id)."'
			",2);
			$newFromItems = array();
			foreach($fromItems as $fromItem) {
				$fieldValues = array();
				foreach($link['fields'] as $field) {
					$fieldValues[] = $fromItem[$field];
				}
				if(!in_array(join("_",$fieldValues), $toItems)) {
					$newFromItems[] = $fromItem['key'];
				}
			}
			$fromItems = $newFromItems;
			unset($newFromItems);
			foreach($fromItems as $id) {
				$lDB->put("UPDATE $link[table] SET $link[key] = '".$lDB->escape($to)."' WHERE $tableKey = '$id'");
			}
		}
	}


	foreach($from as $pr_persona_id) {
		switch($after) {
		case "delete":
			removeContact($pr_persona_id);	
			break;
		case "inactive":
			removeContact($pr_persona_id,true);
			break;
		case "active":
			toggleContact($pr_persona_id,true);
			break;
		case "none":
		default:
			// no action
			break;
		}
	}
	
	return array(true, "Contact replaced");
}

function deleteContact($pr_persona_id) {
	global $lDB;

	$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);
	$audit->save("Contact details (Delete)");

	cleanContact($pr_persona_id);
	$lDB->put("DELETE FROM pr_persona WHERE pr_persona_ix = '$pr_persona_id'");
}

function toggleContact($pr_persona_id,$active=false) {
	global $lDB;

	if($active) {
		$inactive_yn = "0";
	} else {
		$inactive_yn = "1";
	}

	$current = $lDB->get("SELECT pr_persona_inactive_yn FROM pr_persona WHERE pr_persona_ix = '".$lDB->escape($pr_persona_id)."'",4);
	if($current != $inactive_yn) {
		$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);
		$audit->addDetail(
			$current,
			$inactive_yn,
			$pr_persona_id,
			$pr_persona_id,
			DB_AD_PERSONA_DETAIL_ACTION_EDIT,
			"persona",
			"pr_persona.pr_persona_inactive_yn"
		);
		$type = "Inactive";
		if($inactive_yn == "0") {
			$type = "Active";
		}
		$audit->save("Contact details ($type)");
	}

	$lDB->put("UPDATE pr_user SET pr_user.pr_user_inactive_yn = '$inactive_yn' WHERE pr_user.pr_user_id = '$pr_persona_id'");
	$lDB->put("UPDATE pr_agent SET pr_agent.pr_agent_inactive_yn = '$inactive_yn' WHERE pr_agent.pr_agent_id = '$pr_persona_id'");
	$lDB->put("UPDATE pr_guest SET pr_guest.pr_guest_inactive_yn = '$inactive_yn' WHERE pr_guest.pr_guest_id = '$pr_persona_id'");
	$lDB->put("UPDATE pr_persona SET pr_persona_inactive_yn = '$inactive_yn' WHERE pr_persona_ix = '$pr_persona_id'");
}

function removeContact($pr_persona_id,$forceInactive=false) {
	global $lDB;

	if (canDeleteContact($pr_persona_id) && !$forceInactive) {
		deleteContact($pr_persona_id);
	} else {
		toggleContact($pr_persona_id,false);
	}
}

/**
 * Check if an agent exists using the ID
 * @param string $personaId
 * @return bool
 */

function checkAgent($personaId) {
	$count = $GLOBALS['lDB']->get("
		SELECT
			COUNT(pr_agent_id)
		FROM
			pr_agent
		WHERE
			pr_agent_id = '$personaId'
	",4);
	if ($count > 0) {
		return true;
	} else {
		return false;
	}
}

/**
 * Return a linked agent ID, otherwise, return the original ID
 * @param string $personaId
 * @return string
 */
function getAgent($personaId) {
	$agentId = $GLOBALS['lDB']->get("
		SELECT
			pr_link_to
		FROM
			pr_link
		WHERE
			pr_link_from = '$personaId'
			AND rf_link_type_id = 'RS2'
	",4);
	if (checkAgent($agentId) == true) {
		return $agentId;
	}
	return $personaId;
}

/**
 * Determines whether the currently logged in user is censysad.
 *
 * @return boolean
 */
function isCensysadUser() {
	return strtolower($GLOBALS['username']) == "censysad";
}

function linkPrimary($primaryId, $secondaryId) {
	global $lDB;
	global $dbcode;
	
	$links = $lDB->get("SELECT pr_link_ix FROM pr_link WHERE pr_link_from = '$secondaryId' AND rf_link_type_id = 'RS3'",3);
	foreach($links as $id) {
		$lDB->put("DELETE FROM pr_link WHERE pr_link_ix = '$id'");
	}
	$lDB->put("
		INSERT INTO pr_link (
			pr_link_db,
			pr_link_from,
			pr_link_to,
			rf_link_type_id
		) VALUES (
			'$dbcode',
			'$secondaryId',
			'$primaryId',
			'RS3'
		)
	");

	$address = $lDB->get("
		SELECT
			pr_corr_addr_line1,
			pr_corr_addr_line2,
			pr_corr_addr_line3,
			pr_phys_addr_line1,
			pr_phys_addr_line2,
			pr_phys_addr_line3
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$secondaryId'
	",1);

	$addressTest = 
		$address['pr_corr_addr_line1'] .
		$address['pr_corr_addr_line2'] .
		$address['pr_corr_addr_line3'] .
		$address['pr_phys_addr_line1'] .
		$address['pr_phys_addr_line2'] .
		$address['pr_phys_addr_line3'];

	if(trim($addressTest) == "") { // Needs linked address...
		$lDB->put("
			UPDATE
				pr_persona
			SET
				pr_persona.pr_persona_link_id = '$primaryId'
			WHERE
				pr_persona.pr_persona_ix = '$secondaryId'
		");
	}		
}
