<?php

use MaglLegacyApplication\Application\MaglLegacy;
use Resrequest\Authentication\Service\Authenticate as Authenticate;

/**
 * functions.php - General purpose functions
 */

require_once(__DIR__ . "/functions.cache.php");

// debug - Shows debug messages if debugging is enabled.
// =====================================================
function debug() {
	if(isset($GLOBALS['debugEnabled']) && $GLOBALS['debugEnabled']) {
		echo "<PRE STYLE=\"font-family: courier;\">Debug message\n----- -------</PRE>";
		foreach(func_get_args() as $item) {
			echo "<PRE STYLE=\"font-family: courier;\">";
			print_r($item);
			echo "</PRE>";
		}
	}
}

function sdebug($message)
{
   echo "<script>alert('".str_replace("<BR>","\\n",t_encodeOverlib($message))."');</script>";
}

function fdebug($filename,$message) {
	$h = fopen(__DIR__ . "/" . $filename,"a+");
	fwrite($h,$message."\n");
	fclose($h);
}


// makeDateTime - takes a mysql type datetime field and returns in human readable format (array)
// =================================================================================================
function makeDateTime($datetime) {
   if ($datetime == "0000-00-00 00:00:00" || $datetime == "" || $datetime == "0") {
      return array('date'=>"",'time'=>"");
   }
   $temp = explode(" ",$datetime);
   $date = chng_date($temp[0],"-");
   $time = $temp[1];
   return array("date" => $date, "time" => $time);
}

// fixAmtDisplay - this will take any value and
// =================================================================================================
function fixAmtDisplay(&$var, $decimal = 2) {
   if($var !== "TBA") {
       $var = (string)trim(sprintf("%01.".$decimal."f",$var));
   }
}

// db_round - This will round a number for correct entry into the database
// =================================================================================================
function db_round($var, $decimal = 2) {
   $var = sprintf("%0.".$decimal."f",round($var, $decimal));
   return $var;
}

// rsOutput - this generates formatted output to be used in the censys rs procedures, from php array
// =================================================================================================
function rsOutput($rsUpdateInnerHTML,$rsUpdateValue,$rsUpdateVar,$rsFuncList) {
	$output = "";
   // Verify that we have arrays to work with
   if (!is_array($rsUpdateInnerHTML)) { $rsUpdateInnerHTML = array(); }
   if (!is_array($rsUpdateValue)) { $rsUpdateValue = array(); }
   if (!is_array($rsUpdateVar)) { $rsUpdateVar = array(); }
   if (!is_array($rsFuncList)) { $rsFuncList = array(); }

   // Process arrays for RS response
   $innerKeys = array_keys($rsUpdateInnerHTML);
   for($i=0;$i<sizeof($innerKeys);$i++) {
      $id = $innerKeys[$i];
      $output .= "<span id=\"".$id."\" style=\"display:none\">".$rsUpdateInnerHTML[$id]."</span>\n";
   }
   $valKeys = array_keys($rsUpdateValue);
   for($i=0;$i<sizeof($valKeys);$i++) {
      $id = $valKeys[$i];
      $output .= "<span id=\"".$id."\" style=\"display:none\">".$rsUpdateValue[$id]."</span>\n";
   }

   // Preparing for RS Response index
   $innerKeyJoin = join("','",$innerKeys);
   $valKeyJoin = join("','",$valKeys);

   // Did this rsResponse return anything?
   if ((sizeof($rsUpdateInnerHTML) + sizeof($rsUpdateValue) + sizeof($rsFuncList)) > 0) {
      $rsResponse = "success";
   } else {
      $rsResponse = "failure";
   }

   // Append RS response index
   $output .= "<script>\n";
   $output .= "var rsUpdateInnerHTML = new Array(";
   if (strlen($innerKeyJoin) > 0) { $output .= "'".$innerKeyJoin."'"; }
   $output .= ");\n";
   $output .= "var rsUpdateValue = new Array(";
   if (strlen($valKeyJoin) > 0) { $output .= "'".$valKeyJoin."'"; }
   $output .= ");\n";
   $output .= "var rsResponse = '".$rsResponse."';\n";

   $output .= "function initFrame(){\n";
   $varKeys = array_keys($rsUpdateVar);
   for($i=0;$i<sizeof($varKeys);$i++) {
      $id = $varKeys[$i];
      if (preg_match("/array/",$rsUpdateVar[$id])) {
         $output .= "   ".$id." = \"".$rsUpdateVar[$id]."\";";
      } else {
         $output .= "   ".$id." = ".$rsUpdateVar[$id].";";
      }
   }

   for($i=0;$i<sizeof($rsFuncList);$i++) {
      $funcName = $rsFuncList[$i++];
      $output .= "   parent.".$funcName."(".$rsFuncList[$i].");\n";
   }
   $output .= "}\n";

   $output .= "</script>";

   return $output;
}


// dateSubtract - subtracts 2 dates from each other, returning the number of days
// =================================================================================================
function dateSubtract($date2, $date1,$extra="0") {
   $s = strtotime($date2)-strtotime($date1);
   $d = round($s/86400);
/*   $s -= $d*86400;
   $h = intval($s/3600);
   $s -= $h*3600;
   $m = intval($s/60);
   $s -= $m*60;*/
   return (string) $d;
}

// makeDates - Generates dates from startDate for period days, $startDate:$endDate limits the period
// =================================================================================================
function makeDates($startDate,$period,$output="Y-m-d",$mode="0") {
   $endDate = "0";
   if(!(strpos($startDate,":") === false)) {
      list($startDate, $endDate) = explode(":",$startDate);
   }
   if (empty($startDate)) {
       return "";
   }
   list($startYear, $startMonth, $startDay) = explode("-", $startDate);

   $out = $startDate." for ".$period." = ";
   $dateList = array();
   for ($a=0;$a<$period;$a++) {
      $date = date($output,mktime (0,0,0,$startMonth,$startDay+$a,$startYear));
      ($output != "Y-m-d") ? $date2 = date("Y-m-d",mktime (0,0,0,$startMonth,$startDay+$a,$startYear)): $date2 = $date;
      if ($date2 > $endDate && $endDate != "0") {
         break;
      }
      if ($mode == "0") {
         array_push($dateList,$date);
      } else {
         if(date("w",mktime (0,0,0,$startMonth,$startDay+$a,$startYear)) == "0"
         || date("w",mktime (0,0,0,$startMonth,$startDay+$a,$startYear)) == "6") {
            array_push($dateList,$date);
         }
      }
      $out .= $date.", ";
   }
   $out .= "<br>";
   return $dateList;
}


// noZero - the final solution to all those BLOODY zeros popping up when we get null from the db :-)
// =================================================================================================
function noZero(&$destination,$source){
   $destination = "";
   if ($source != "0" && $source != "0000-00-00") {
      $destination = $source;
   }
}


// randUserName - Generates a random username of 9 or more characters
// ========================================================================================
function randUserName($userid) {

   $alpha = array(
      "a","A","b","B","c","C","d","D","e","E","f","F","g","G","h","H","i","I","j","J","k","K","l","L","m","M",
      "n","N","p","P","q","Q","r","R","s","S","t","T","u","U","v","V","w","W","x","X","y","Y","z","Z",
      "1","2","3","4","5","6","7","8","9"
   );

	$randval = "";

   for ($l=0;$l<6;$l++) {
      $rand = rand(0,58);
      $randval .= $alpha[$rand];
      if ($l == "2") {
         $randval .= $userid;
      }
   }

   return $randval;
}

// cleansing technique (copyleft) glowworm 2002 - deletes array cells containing only dirt
// =======================================================================================
function cleanse (&$string,$dirt="") {
   if(!is_array($string)) {
         return false;
   }
   $new = array();
   foreach ($string as $current) {
      if ($current != $dirt) {
         array_push($new,$current);
      }
   }
   $string = $new;
}


// change dateformat from 0000-00-00 to 00 Jan 0000 etc
// =======================================================================================
function chng_date ($olddate,$more=":",$mode=0){
   if ($olddate != "" && $olddate != "0000-00-00" && $olddate != "0000-00-00 00:00:00" && $olddate != "0" && count(explode($more,$olddate)) >= 3) {
      list($realyear,$month,$day) = explode($more,$olddate);
      if ($realyear <= "1980") {
		$year = "1980";
	  } else {
		$year = $realyear;
	  }
      if ($month < 1) { $month = "01"; }
      if ($day < 1) { $day = "01"; }

      if ($mode == "2") {
         $date = date("d M",mktime (12,0,0,$month,$day,$year));
      } elseif ($mode == "3") {
         $date = date("d M y D",mktime (12,0,0,$month,$day,$year));
      } elseif ($mode == "4") {
         $date = date("D, d M Y",mktime (12,0,0,$month,$day,$year));
      } elseif ($mode == "5") {
          list($day,$time) = explode(" ",$day);
          list($hour,$minute,$sec) = explode(":", $time);
          $date = date("d M Y H:i:s",mktime ($hour,$minute,$sec,$month,$day,$year));
      } else {
         $date = date("d M Y",mktime (12,0,0,$month,$day,$year));
      }

	  if ($realyear != $year){
		$date = str_replace('1980',$realyear,$date);
	  }

	  return $date;
   }
}


// checkarray technique (copyleft) glowworm 2002 - turns string input into an array on tnt
// =======================================================================================
function checkarray(&$string,$tnt=":") {
   if (!is_array($string)) {
      if (!(strpos($string,$tnt) === false)) {
         $string = explode($tnt,$string);
      } else {
         $string = (array) $string;
      }
   }
   cleanse($string);
}

// determine whether records of this dbcode is editable on this system
// =======================================================================================
function canEditDB($dbcode=false)
{
   global $lDB;
   global $data_synch_mthd;

   // If no dbcode to test, assume you want to test your own code.
   if ($dbcode === false) $dbcode = $GLOBALS['dbcode'];

   // If you (are a property server)
   if ($GLOBALS['isPropServer'])
   {
      // Edit only your own records
      if ($dbcode == $GLOBALS['dbcode'])
      {
         return true;
      }

      return false;
   }
   else
   {
      // If you (are the master) or you (sync via replication)
      if ($data_synch_mthd == "2" || isMasterDB())
      {
         // Edit all primary server dbcodes
         $editCodeList = $lDB->get("select rf_db_code from rf_database where rf_db_env_type_ind = 2",3);
         if (in_array($dbcode,$editCodeList))
         {
			 if(!$GLOBALS['isWebServer']) { // If resoffice - need to check replication
			 	$replicateYN = $lDB->get("SELECT rf_db_replicated_yn FROM rf_database WHERE rf_db_code = '$GLOBALS[dbcode]'",4);
				if($replicateYN == 1) {
					return true;
				} else {
					if(isMasterDB()) {
						return true;
					} else {
						return false;
					}
				}
			 } else {
	            return true;
			 }
         }
      }

      return false;
   }
}

function getDBCodes() {
   global $lDB;
	if($GLOBALS['isPropServer']) {
		return array($GLOBALS['dbcode']);
	} else {
		return $lDB->get("select rf_db_code from rf_database where rf_db_env_type_ind = 2",3);
	}
}

// determine whether the current database is the master or not
// =======================================================================================
function isMasterDB($mode="0") {
	global $lDB;
	global $dbcode;

	if(cacheExists("isMasterDB$mode")) {
		return cacheGet("isMasterDB$mode");
	}

	if ($lDB->get("select rf_sys_locked_yn from rf_system",4) && $mode == "0") {
		cacheSet("isMasterDB$mode",false);
		return false;
	}

	if ($GLOBALS['isPropServer']) {
		cacheSet("isMasterDB$mode",true);
		return true;
	}

	$db_master_id = $lDB->get("select rf_sys_db_master_id from rf_system",4);
	$rf_database_id = $lDB->get("select rf_database_id FROM rf_database WHERE rf_db_code = '$dbcode'",4);

	if($dbcode[0] != "W") { // RESOFFICE AND PROPERTY TESTS
		// Get database env index
		$envIndex = $lDB->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_db_code = '$dbcode'",4);
		if($envIndex == "4") { // property level
			if($db_master_id == $rf_database_id) {
				cacheSet("isMasterDB$mode",true);
				return true;
			} else {
				cacheSet("isMasterDB$mode",false);
				return false;
			}
		} else { // resoffice level
			$isRepl = $lDB->get("SELECT rf_db_replicated_yn FROM rf_database WHERE rf_db_code = '$dbcode'",4);
			if($isRepl != "1") {
				if($db_master_id == $rf_database_id) {
					cacheSet("isMasterDB$mode",true);
					return true;
				} else {
					cacheSet("isMasterDB$mode",false);
					return false;
				}
			} else {
				$replList = $lDB->get("SELECT rf_database_id FROM rf_database WHERE rf_db_replicated_yn = '1' AND rf_db_env_type_ind = '2'",3);
				if(in_array($db_master_id,$replList)) {
					cacheSet("isMasterDB$mode",true);
					return true;
				} else {
					cacheSet("isMasterDB$mode",false);
					return false;
				}
			}
		}
	} else { // WEB TESTS
		$webList = $lDB->get("SELECT rf_database_id FROM rf_database WHERE rf_db_code LIKE 'W%'",3);
		if($db_master_id == $rf_database_id) {
			cacheSet("isMasterDB$mode",true);
			return true;
		} else {
			cacheSet("isMasterDB$mode",false);
			return false;
		}
	}
}

// replaceNLCR - takes a string and converts newlines and carraige retruns to <BR /> for use in overlib
// ====================================================================================================
function replaceNLCR($string) {
   $string = preg_replace("(\r\n|\n|\r)", "<br />", $string);
   $string = preg_replace("'", "&#8217;", $string);
   return $string;
}

global $trText;
$trText = array(
   "&amp;"              => "&",
   "&quot;"             => "\"",
   "&#039;"             => "'",
   "&lt;"               => "<",
   "&gt;"               => ">",
   "&nbsp;&nbsp;&nbsp;" => "   ",
   "&nbsp;&nbsp;&nbsp;" => "\t",
   "&nbsp;&nbsp;"       => "  ",
   "<BR>"               => "\r\n",
   "<BR>"               => "\n\r",
   "<BR>"               => "\n",
   "<BR>"               => "\r",
   "<BR>"               => chr(10)
);

global $trOverlib;
$trOverlib = array(
   "\""     => "&quot;",
   "'"      => "\\'",
   "&#039;" => "\\'",
   "\\"     => "\\\\",
   "\n"     => "<BR>",
   "\r\n"   => "<BR>",
   "\r"     => "<BR>"
);

global $trHTML;
$trHTML = array_flip($trText);
$trText['&nbsp;'] = " ";

function t_encodeHTML($t_htmlString) {
   return strtr(t_decodeHTML($t_htmlString),$GLOBALS['trHTML']);
}

function t_decodeHTML($t_textString) {
   return strtr($t_textString,$GLOBALS['trText']);
}

function t_encodeOverlib($t_overlibString) {
   return strtr($t_overlibString, $GLOBALS['trOverlib']);
}

function t_encodeHTMLField($t_field) {
	return htmlspecialchars($t_field);
}

function dateAddDay($date,$add,$split="-")
{
   $temp = explode($split,$date);
   $year = $temp[0];
   $month = $temp[1];
   $day = $temp[2] + $add;

   return date("Y-m-d",mktime(0,0,0,$month,$day,$year));
}

function redirectTo($url, $fields=false, $parent=false) {
	if(!headers_sent() && empty($fields)) {
		header("Location: $url");
		die();
	}

   // Targets the parent element, effectively breaking out of an iframe
   $target = $parent ? "target='_parent'" : "";

	echo '
		<html>
			<body>
				<form id="redirect_form" method="POST" action="'.$url.'" ' . $target . '>
	';
	if(is_array($fields)) {
		foreach($fields as $name=>$value) {
			echo '					<textarea style="display:none" name="'.$name.'">'.t_encodeHTMLField($value).'</textarea>'."\n";
		}
	}
	echo '
				</form>
				<script>document.getElementById("redirect_form").submit();</script>
			</body>
		</html>
	';
	die();
}

// Ref: http://stackoverflow.com/questions/9153716/sharing-session-variables-between-multiple-subdomains
function session_init() {
	global $sessionServer;

	if(session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
	$globalVars = array("record","record2","userid","ceilingnum","securitygroup","wizResId");

	foreach($globalVars as $var) {
		$GLOBALS[$var] = isset($_SESSION[$var]) ? $_SESSION[$var] : "";
   }
}

// Ref: http://stackoverflow.com/questions/12315225/reopening-a-session-in-php
function session_restart() {
	global $session_restarted;

	if(session_status() === PHP_SESSION_ACTIVE) {
		return;
	}
	if(!isset($session_restarted) || !$session_restarted) {
		ini_set('session.use_only_cookies', false);
		ini_set('session.use_cookies', false);
		ini_set('session.use_trans_sid', false);
		ini_set('session.cache_limiter', null);
		$session_restarted = true;
	}
	session_start();
}

function session_set($keyOrList,$value=false) {
	session_restart();

	if(is_array($keyOrList)) {
		foreach($keyOrList as $key=>$value) {
			$_SESSION[$key] = $value;
		}
	} else {
		$_SESSION[$keyOrList] = $value;
	}

	session_write_close();
}

// Ref: http://www.farinspace.com/php-array-combinations/
// Ref: https://gist.github.com/farinspace/1126042
// Ref: https://gist.github.com/fabiocicerchia/4556892
function array_combinations(array $data, array &$all = array(), array $group = array(), $value = null, $i = 0) {
	$keys = array_keys($data);
	if(isset($value) === true) {
		$group[$keys[$i-1]] = $value;
//		array_push($group, $value);
	}
 
	if($i >= count($data)) {
		array_push($all, $group);
	} else {
		$currentKey = $keys[$i];
		$currentElement = $data[$currentKey];
		foreach ($currentElement as $val) {
			array_combinations($data, $all, $group, $val, $i + 1);
		}
	}

	return $all;
}

// [BEGIN] Section to implement missing functions in older versions of PHP
if(!function_exists("array_fill")) {

   function array_fill($start_index, $num, $value) {
      $newArray = array();
      for($count = $start_index; $count < ($start_index + $num); $count++) {
         $newArray[$count] = $value;
      }
      return $newArray;
   }
}

if (!function_exists('json_encode')) {
	function json_encode($a=false) {
		if (is_null($a)) return 'null';
		if ($a === false) return 'false';
		if ($a === true) return 'true';
		if (is_scalar($a)) {
			if (is_float($a)) {
				// Always use "." for floats.
				return floatval(str_replace(",", ".", strval($a)));
			}
			if (is_string($a)) {
				static $jsonReplaces = array(array("\\", "/", "\n", "\t", "\r", "\b", "\f", '"'), array('\\\\', '\\/', '\\n', '\\t', '\\r', '\\b', '\\f', '\"'));
				return '"' . str_replace($jsonReplaces[0], $jsonReplaces[1], $a) . '"';
			} else {
				return $a;
			}
		}
		$isList = true;
		for ($i = 0, reset($a); $i < count($a); $i++, next($a)) {
			if (key($a) !== $i) {
				$isList = false;
				break;
			}
		}
		$result = array();
		if ($isList) {
			foreach ($a as $v) $result[] = json_encode($v);
			return '[' . join(',', $result) . ']';
		} else {
			foreach ($a as $k => $v) $result[] = json_encode($k).':'.json_encode($v);
			return '{' . join(',', $result) . '}';
		}
	}
}

if(!function_exists('mb_rawurlencode')) {
	function mb_rawurlencode($url) {
		$encoded='';
		$length=mb_strlen($url);
		for($i=0;$i<$length;$i++){
			$encoded.='%'.wordwrap(bin2hex(mb_substr($url,$i,1)),2,'%',true);
		}
		return $encoded;
	}
}
// [END] Section to implement missing function in older versions of PHP

function set_timezone($timezone) {
	global $lDB;
	
	if(empty($timezone) || !in_array($timezone,timezone_identifiers_list())) {
		$timezone = 'Africa/Johannesburg'; // Default timezone
	}
	date_default_timezone_set($timezone);
  if (isset($lDB)) {
    $lDB->timezone();
  }
	$GLOBALS['timezone'] = $timezone;
}

function escapeName($name) {
	return str_replace(
		array('"', "'"),
		array('\\\"', "\\\'"),
		$name
	);
}

function escapeLabel($name) { 
	return str_replace(
		array('"', "'"),
		array('\\"', "\\'"),
		$name
	);
}
