<?php

require_once(__DIR__ . "/functions.reservation.itinerary.php");
require_once(__DIR__ . "/functions.rates.php");

function hasPOSExtraMappings($posId) {
	global $lDB;
	global $dbcode;

	$count = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			ac_pos
			INNER JOIN ac_pos_map ON ac_pos_map.ac_pos_id = ac_pos.ac_pos_ix
			INNER JOIN rf_db_business ON rf_db_business.pr_business_id = ac_pos.pr_business_id
		WHERE
			rf_db_business.rf_db_code = '" . $lDB->escape($dbcode) . "'
			AND ac_pos.ac_pos_name = '" . $lDB->escape($posId) . "'
			AND ac_pos.ac_inactive_yn = '0'
	",4);

	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function getPOSExtra($posId, $code=false, $apiMode=false) {
	global $lDB;
	global $dbcode;

	$dbCheckSQL = "rf_db_business.rf_db_code = '" . $lDB->escape($dbcode) . "'";
	$acPosSQL = "AND ac_pos.ac_pos_name = '" . $lDB->escape($posId) . "'";
	if($apiMode) {
		$dbCheckSQL = "";
		$acPosSQL = "ac_pos.ac_pos_ix = '" . $lDB->escape($posId) . "'";
	}

	/* Check for a match on mapping code */
	if(!empty($code)) {
		$POSExtra = $lDB->get("
			SELECT DISTINCT
				ac_pos.ac_pos_ix,
				ac_pos_stock.ac_extra_id
			FROM
				ac_pos_map
				INNER JOIN ac_pos_stock ON ac_pos_stock.ac_pos_stock_ix = ac_pos_map.ac_pos_stock_id
				INNER JOIN ac_pos ON ac_pos.ac_pos_ix = ac_pos_map.ac_pos_id
				INNER JOIN rf_db_business ON rf_db_business.pr_business_id = ac_pos.pr_business_id
			WHERE
				$dbCheckSQL
				$acPosSQL
				AND ac_pos.ac_inactive_yn = '0'
				AND ac_pos_stock.ac_pos_stock_code = '" . $lDB->escape($code) . "'
		",1);
		if(!empty($POSExtra['ac_extra_id'])) {
			return $POSExtra;
		}
	}

	/* Check for a general match */
	$POSExtra = $lDB->get("
		SELECT DISTINCT
			ac_pos.ac_pos_ix,
			ac_pos_stock.ac_extra_id
		FROM
			ac_pos
			INNER JOIN ac_pos_stock ON ac_pos_stock.ac_pos_stock_ix = ac_pos.ac_pos_stock_id
			INNER JOIN rf_db_business ON rf_db_business.pr_business_id = ac_pos.pr_business_id
		WHERE
			$dbCheckSQL
			$acPosSQL
			AND ac_inactive_yn = '0'			
	",1);
	if(!empty($POSExtra['ac_extra_id'])) {
		return $POSExtra;
	}

	return false;	
}

$GLOBALS['cashReservations'] = array();
function getCashReservation($ac_pos_id, $date) {
	global $lDB;
	global $cashReservations;
	global $calAgentId;


	// Return previously cached value if possible
	$key = $ac_pos_id . "_" . $date;
	if(array_key_exists($key, $cashReservations) && !empty($cashReservations[$key])) {
		return $cashReservations[$key];
	}

	// Return existing reservation for ac_pos, which is confirmed, for specified date, if possible
	$rv_reservation_id = $lDB->get("
		SELECT
			rv_reservation.rv_reservation_ix
		FROM
			rv_reservation
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		WHERE
			rv_reservation.ac_pos_id = '" . $lDB->escape($ac_pos_id) . "'
			AND rf_reservation_status_id = '30'
			AND rv_reservation_item.rv_item_date_arrive <= '" . $lDB->escape($date) . "'
			AND rv_reservation_item.rv_item_date_depart > '" . $lDB->escape($date) . "'
	",4);
	if(!empty($rv_reservation_id)) {
		$cashReservations[$key] = $rv_reservation_id;
		return $rv_reservation_id;
	}

	list($template_reservation_id, $template_period_ind) = $lDB->get("
		SELECT
			ac_pos.rv_reservation_id,
			ac_pos.ac_cash_period_ind
		FROM
			ac_pos
		WHERE
			ac_pos.ac_pos_ix = '" . $lDB->escape($ac_pos_id) . "'
	",1);
	if(empty($template_reservation_id)) {
		throw new Exception("Cash template reservation not found ($ac_pos_id)");
	}
	if(empty($template_period_ind)) {
		throw new Exception("Cash period not defined ($ac_pos_id)");
	}

	$template_reservation = $lDB->get("
		SELECT
			rv_reservation.rt_rate_type_id,
			rv_reservation.rv_corr_persona_id,
			rv_reservation.rv_agent_id,
			rv_reservation.rv_commission_perc,
			rv_reservation.rv_commission_deduct_yn,
			rv_reservation.rv_invoice_currency_id,
			rv_reservation.rv_billing_persona_id,
			rv_reservation.rv_invoice_persona_id,
			rv_reservation.rv_res_name,
			rv_reservation.rv_agent_ref,
			rv_reservation.rv_note_general,
			rv_reservation.rv_note_guests,
			rv_reservation.rv_note_internal,
			rv_reservation.ac_pay_plan_id,
			rv_reservation.rf_country_id,
			rv_reservation.rf_source_ix,
			rv_reservation.pr_reservation_user_id,
			rv_reservation.rv_consultant_id,
			rv_reservation.rv_origin_agent_id
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_reservation_ix = '" . $lDB->escape($template_reservation_id) . "'
	",1);
	if($template_reservation === false) {
		throw new Exception("Error looking up template reservation details for $template_reservation_id");
	}

	$template_itinerary = $lDB->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rt_rate_type_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '" . $lDB->escape($template_reservation_id). "'
		LIMIT 1
	",1);
	if($template_itinerary === false) {
		throw new Exception("Error looking up template reservation itinerary for reservation $template_reservation_id");
	}

	$template_rate_groups = $lDB->get("
		SELECT
			rv_res_item_rate_grp.rt_rate_group_id AS rt_rate_group_ix,
			rv_res_item_rate_grp.rv_res_item_rate_grp_count AS qty
		FROM
			rv_res_item_rate_grp
		WHERE
			rv_res_item_rate_grp.rv_reservation_item_id = '" .$lDB->escape($template_itinerary['rv_reservation_item_ix']) . "'
	",6);		
	if(sizeof($template_rate_groups) == 0) {
		throw new Exception("Error looking up template reservation rate groups for item " . $template_itinerary['rv_reservation_item_ix'] . " on reservation $template_reservation_id");
	}

	switch($template_period_ind) {
	case 1: // daily
		$arrive = $date;
		$depart = date("Y-m-d",strtotime("$date +1 day"));
		break;
	case 2: // weekly
		$dow_start = date("w",strtotime($template_itinerary['rv_item_date_arrive']));
		$dow_date = date("w",strtotime($date));
		$dow_diff = $dow_start - $dow_date;
		if($dow_diff > 0) {
			$dow_diff -= 7;
		}
		if($dow_diff == 0) {
			$arrive = $date;
		} else {
			$arrive = date("Y-m-d",strtotime("$date $dow_diff days"));
		}
		$depart = date("Y-m-d",strtotime("$arrive +7 days"));
		break;
	case 3: // monthly
		$dateArray = explode("-",$date);
		$arrive = $dateArray[0] . "-" . $dateArray[1] . "-01";
		$depart = $dateArray[0] . "-" . str_pad($dateArray[1] + 1,2,"0",STR_PAD_LEFT) . "-01";
		break;
	}

	$calAgentId =$template_reservation['rv_agent_id'];
	$rv_reservation_id = db_rv_reservation_insert(
		$template_reservation['rt_rate_type_id'],
		$template_reservation['rv_corr_persona_id'],
		$template_reservation['rv_agent_id'],
		$template_reservation['rv_commission_perc'],
		$template_reservation['rv_commission_deduct_yn'],
		$template_reservation['rv_invoice_currency_id'],
		$template_reservation['rv_billing_persona_id'],
		$template_reservation['rv_invoice_persona_id'],
		$template_reservation['rv_res_name'] . " $arrive to $depart",
		$template_reservation['rv_agent_ref'],
		$template_reservation['rv_note_general'],
		$template_reservation['rv_note_guests'],
		$template_reservation['rv_note_internal'],
		$template_reservation['ac_pay_plan_id'],
		$template_reservation['rf_country_id'],
		$template_reservation['rf_source_ix'],
		30, // rf_reservation_status_id=confirmed
		false, // rf_reservation_status_date
		false, // rv_provision_expiry_date
		$template_reservation['pr_reservation_user_id'], // pr_user_id
		$template_reservation['rv_consultant_id'],
		false, // rv_date_recorded
		false, // rv_date_changed
		false, // rv_ref_num
		false, // db_code
		false, // rv_reservation_id
		$template_reservation['rv_origin_agent_id'],
		$ac_pos_id
	);
	if(empty($rv_reservation_id)) {
		throw new Exception("Unable to create reservation for new period $arrive to $depart using template $template_reservation_id");
	}

	$itemDataRaw = convertItemToRaw($template_itinerary['ac_accomm_type_id'],$arrive,$depart,$template_rate_groups);

	$items = calCreateItem(
		$rv_reservation_id,
		$itemDataRaw,
		$template_itinerary['rt_rate_type_id'],
		"defaultOnly",
		false, // override
		false // split
	);
	if(!is_array($items) || sizeof($items) == 0) {
		throw new Exception("Unable to create itinerary on reservation $rv_reservation_id for new period $arrive to $depart using template $template_reservation_id");
	}

	$cashReservations[$key] = $rv_reservation_id;
	return $rv_reservation_id;
}
