<?php
require_once(__DIR__ . '/db.pf_object.php');
require_once(__DIR__ . '/db.pf_field.php');
require_once(__DIR__ . '/db.pf_option.php');

function loadProfile($pf_option_id,$profileFields) {
	$count = 1; // the job id is always 0
	foreach($profileFields as $item) {
		if($item == "pf_option_id") {
			$_SERVER['argv'][$count] = $pf_option_id;
		} else if($item != "") {
			db_pf_field_load_by_name($pf_option_id,$item,$_SERVER['argv'][$count]);
		} else {
			$_SERVER['argv'][$count] = "";
		}
		$count++;
	}
}

function applyProfile($pf_object_id,$profileFields) {
	if($_SERVER['argc'] == 1) {
		$pf_option_id = isset($_POST['pf_option_id']) ? $_POST['pf_option_id'] : "";
		if($pf_option_id == "") {
			$pf_option_id = db_pf_option_default($pf_object_id);
		}
		if($pf_option_id != "") {
			loadProfile($pf_option_id,$profileFields);
		}
	} else {
		$pf_option_id = (isset($_POST['pf_option_id']) ? $_POST['pf_option_id'] : "");
	}
	return $pf_option_id;

}
function saveProfile($pf_option_id,$profileFields,$new) {
	$url = explode('?',$_SERVER['argv'][0]);
	$job = (strpos($_SERVER['argv'][0], "?") !== false) ? end($url) : $_SERVER['argv'][0];
	if(db_pf_option_allow_save($pf_option_id,$job,$new)) {
		$count = 1;
		foreach($profileFields as $item) {
			if($item != "pf_option_id" && $item != "") {
				db_pf_field_update($pf_option_id,$item,$_SERVER['argv'][$count]);
			}
			$count++;
		}
	}
}

function deleteProfile($pf_option_id) {
	db_pf_option_delete($pf_option_id);
}

function processProfileAction($pf_object_id,$profileFields) {
	$action = isset($_POST['pf_action']) ? $_POST['pf_action'] : "";
	$pf_option_id = isset($_POST['pf_option_id']) ? $_POST['pf_option_id'] : "";

	if($action == "") { // Leave if no action is required
		return;
	}

	if($action == "saveAs" || $action == "saveDetail") {
		$pf_option_default_yn=false;
		if($_POST['pf_option_default_yn'] == "1") {
			$pf_option_default_yn=true;
		}
	}

	if($action == "saveAs") {
		if(db_pf_option_check_duplicate($pf_object_id,$_POST['pf_option_name'],false,$_POST['pf_level_ind'])) {
			echo "error|" . mb_rawurlencode("There is already a profile with this name.");
			die();
		}
		$pf_option_id = db_pf_option_insert($pf_object_id,$_POST['pf_option_name'],$_POST['pf_option_note'],$_POST['pf_level_ind'],false,$pf_option_default_yn,$_POST['pf_option_favourite_yn'],$_POST['pf_option_title']);
	}

	if($action == "saveDetail") {
		if(db_pf_option_check_duplicate($pf_object_id,$_POST['pf_option_name'],$pf_option_id)) {
			echo "error|" . mb_rawurlencode("There is already a profile with this name.");
			die();
		}
		db_pf_option_update($pf_option_id,$_POST['pf_option_name'],$_POST['pf_option_note'],$_POST['pf_level_ind'],false,$pf_option_default_yn,$_POST['pf_option_favourite_yn'],$_POST['pf_option_title']);
	}

	if($action == "delete") {
		deleteProfile($pf_option_id);
	}
	$output = mb_rawurlencode($action) . "|" . mb_rawurlencode(createProfileList($pf_object_id)) . "|" . mb_rawurlencode($pf_option_id);

	if($action == "save" || $action == "saveAs" || $action == "saveDetail") {
		$new = false;
		if($action == "saveAs") {
			$new = true;
		}
		if($action != "saveDetail") {
			saveProfile($pf_option_id,$profileFields,$new);
		}

		if (isset($_POST['pf_option_name'])) {
			$output .= "|" . mb_rawurlencode($_POST['pf_option_name']);
		}
	}

	echo $output;
	die();
}


function createProfileList($pf_object_id,$show_all_users=false) {
	$profileHTML = Join("", file(__DIR__ . "/../../../public/html/profile_list.htm"));
	$profileRowHTML = Join("", file(__DIR__ . "/../../../public/html/profile_list_rows.htm"));

	if($show_all_users) {
		$pr_user_id = "all";
	} else {
		$pr_user_id = false;
	}

	$profileList = db_pf_option_get_by_user($pf_object_id,false,$pr_user_id);

	$col = "";
	$colButton = "";
	if(checkProfileUpdate()) {
	/*	$col .= "
			<td>!pf_level_name!</td>
			";			*/
	}
	if(checkProfileManagement()) {
		$col .= "
			<td align=\"center\">!pf_level_env!</td>
		";
	}
	if(checkProfileUpdate()) {
		$col .= "
			<td align=\"center\">!pf_option_default!</td>
		";
		$colButton .= "
			<td align=\"center\" onclick=\"stopBubble(event);\">
				<button id=\"edit1\" type=\"button\" class=\"!edit_class!\" style=\"width: 22px; height: 20px; padding: 0; text-align: center;\" onclick=\"editProfile('!pf_option_ix!','!pf_option_name_url!','!pf_option_note_url!','!pf_option_default_yn!','!pf_level_ind!','!pf_option_favourite_yn!','!pf_option_title!');\">
					<img src=\"/resource/Resrequest/Application/public/img/icon_edit_16.gif\" width=\"16\" height=\"16\" alt=\"\" />
				</button>
			</td>
			<td align=\"center\" onclick=\"stopBubble(event);\">
				<button id=\"delete1\" type=\"button\" class=\"!delete_class!\" style=\"width: 22px; height: 20px; padding: 0; text-align: center;\" onclick=\"deleteProfile('!pf_option_ix!')\">
					<img src=\"/resource/Resrequest/Application/public/img/icon_delete_16.gif\" width=\"16\" height=\"16\" alt=\"\" />
				</button>
			</td>
		";
	}
	$item = array();
	$item['col'] = $col;
	$item['colButton'] = $colButton;
	$profileRowHTML = showpage($item,$profileRowHTML);

	$rows = "";
	foreach($profileList as $item) {
		$item['pf_level_env'] = "";
		if($item['pf_level_ind'] == DB_PF_LEVEL_ENV) {
			$item['pf_level_env'] = $item['pf_level_link_id'];
		}
		$item['pf_option_default'] = "";
		if($item['pf_option_default_yn'] == "1") {
			$item['pf_option_default'] = "x"; // this needs an image...
		}
		$item['note_class'] = "collapse printCollapse";
		if(trim($item['pf_option_note']) != "") {
			$item['note_class'] = "button";
		}
		$item['edit_class'] = "collapse printCollapse";
		$item['delete_class'] = "collapse printCollapse";
		if(
			$item['pf_level_ind'] != DB_PF_LEVEL_TEMPLATE
			&& canEditDB($item['pf_option_db'])
			&& ($item['pf_level_ind'] == DB_PF_LEVEL_USER || checkProfileManagement())
		) {
			$item['edit_class'] = "button";
			$item['delete_class'] = "button";
		}
		
		$rowClass = '';

		switch ($item['pf_level_ind']) {
			case DB_PF_LEVEL_USER:
				$rowClass = 'user';
				break;
			case DB_PF_LEVEL_GLOBAL:
				$rowClass = 'global';
				break;
			case DB_PF_LEVEL_TEMPLATE:
				$rowClass = 'template';
				break;
			default:
				$rowClass = '';
		}

		$item['rowClass'] = $rowClass;
		$item['pf_level_name'] = db_pf_option_level_name($item['pf_level_ind']);
		$item['pf_option_name_url'] = mb_rawurlencode($item['pf_option_name']);
		$item['pf_option_name'] = db_pf_option_level_name($item['pf_level_ind']). ": ".$item['pf_option_name'];
		$item['pf_option_note_js'] = t_encodeOverlib($item['pf_option_note']);
		$item['pf_option_note_url'] = mb_rawurlencode($item['pf_option_note']);
		$item['pf_option_title'] = mb_rawurlencode($item['pf_option_title']);
		$rows .= showpage($item,$profileRowHTML);
	}

	$colWidth = "";
	$colWidthButton = "";
	$colHead = "";
	$colHeadButton = "";
	if(checkProfileUpdate()) {
	/*	$colWidth .= "
			<col width=\"70\" />
		";
		$colHead .= "
			<th class=\"outDk\">Level</th>
			";*/
	}
	if(checkProfileManagement()) {
		$colWidth .= "
			<col width=\"30\" />
		";
		$colHead .= "
			<th class=\"outDk\">Env</th>
		";
	}
	if(checkProfileUpdate()) {
		$colWidth .= "
			<col width=\"50\" />
		";
		$colHead .= "
			<th class=\"outDk\">Default</th>
		";
		$colWidthButton .= "
			<col width=\"30\" />
			<col width=\"40\" />
		";
		$colHeadButton .= "
			<th class=\"outDk\">Edit</th>
			<th class=\"outDk\">Delete</th>
		";
	}

	$item = array();
	$item['colWidth'] = $colWidth;
	$item['colWidthButton'] = $colWidthButton;
	$item['colHead'] = $colHead;
	$item['colHeadButton'] = $colHeadButton;
	$item['rows'] = $rows;


	return showpage($item,$profileHTML);
}

function createProfileEdit($pf_option_id) {
	$levelClass = "collapse printCollapse";
	if(checkProfileManagement()) {
		$levelClass = "";
	}
	$systemLevel = "";
	if(db_pf_option_allow_system()) {
		$systemLevel = "
			<option value=\"".DB_PF_LEVEL_SYSTEM."\">System</option>
		";
	}
	$item = array(
		'pf_level_global'=>DB_PF_LEVEL_GLOBAL,
		'pf_level_env'=>DB_PF_LEVEL_ENV,
		'pf_level_user'=>DB_PF_LEVEL_USER,
		'pf_level_template'=>DB_PF_LEVEL_TEMPLATE,
		'level_class'=>$levelClass,
		'system_level'=>$systemLevel
	);
	$profileEditHTML = Join("", file(__DIR__ . "/../../../public/html/profile_edit.htm"));
	$profileEdit = showpage($item,$profileEditHTML);
	return $profileEdit;
}

function createProfileArea($pf_object_id,$pf_option_id) {
	$profileHTML = join("",file(__DIR__ . "/../../../public/html/profile.htm"));
	$item = array(
		'profile_list'=>createProfileList($pf_object_id),
		'profile_edit'=>createProfileEdit($pf_option_id)
	);
	$profile = showpage($item,$profileHTML);

	return $profile;
}

function isTemplateProfile($pf_option_id) {
    if (empty($pf_option_id)) {
        return false;
    }
    $pf_level_ind = $GLOBALS['lDB']->get("SELECT pf_level_ind FROM pf_option WHERE pf_option_ix = '$pf_option_id'",4);
    return $pf_level_ind == "9" ? true : false;
}

function createProfileSave($pf_option_id="") {
	if(checkProfileUpdate() && !isTemplateProfile($pf_option_id)) {
		return join("",file(__DIR__ . "/../../../public/html/profile_save.htm"));
	}
	return "";
}

function createProfileSaveAs() {
	if(checkProfileUpdate()) {
		return join("",file(__DIR__ . "/../../../public/html/profile_save_as.htm"));
	}
	return "";
}

function checkProfileUpdate() {
	global $jobLevelArray;
	global $archive;
	$url = explode('?',$_SERVER['argv'][0]);
	$job = (strpos($_SERVER['argv'][0], "?") !== false) ? end($url) : $_SERVER['argv'][0];
	if(isset($jobLevelArray[$job]) && ($jobLevelArray[$job] > 5 || $archive !== false)) {
		return true;
	} else {
		return false;
	}
}

function checkProfileManagement() {
	$url = explode('?',$_SERVER['argv'][0]);
	$job = (strpos($_SERVER['argv'][0], "?") !== false) ? end($url) : $_SERVER['argv'][0];
	if(isset($GLOBALS['jobLevelArray'][$job]) && $GLOBALS['jobLevelArray'][$job] > 10) {
		return true;
	} else {
		return false;
	}
}

function createProfileFilterClass() {
	if(checkProfileUpdate()) {
		return "";
	}
	return "collapse printCollapse";
}
function createProfileIds($pf_option_id) {
	$html = join("",file(__DIR__ . "/../../../public/html/profile_ids.htm"));
	$url = explode('?',$_SERVER['argv'][0]);
	$job = (strpos($_SERVER['argv'][0], "?") !== false) ? end($url) : $_SERVER['argv'][0];
	$pf_can_save = "0";
	if(db_pf_option_allow_save($pf_option_id,$job)) {
		$pf_can_save = "1";
	}

	$item = array(
		'pf_option_id'=>$pf_option_id,
		'pf_can_save'=>$pf_can_save,
		'pf_job_id'=>$job
	);

	return showpage($item,$html);
}

function createProfileName($pf_option_id) {
	$pf_option_name = $GLOBALS['lDB']->get("SELECT pf_option_name FROM pf_option WHERE pf_option_ix = '$pf_option_id'",4);
	if(trim($pf_option_name) == "" || $pf_option_name == "0") {
		$pf_option_name = "Custom";
	}
	return $pf_option_name;

}

function reportProfile($defaultTitle,$pf_object_name,$profileFields) {
	$pf_object_id = db_pf_object_by_name($pf_object_name);
	processProfileAction($pf_object_id,$profileFields);

	$pf_option_id = applyProfile($pf_object_id,$profileFields);
	$name = db_pf_option_get_name($pf_option_id);
	$rawTitle = db_pf_option_get_title($pf_option_id);
	if(trim($rawTitle) == "") {
		$title = $defaultTitle;
	} else {
		$tital = $rawTitle;
	}

	$GLOBALS['temp']['title'] = isset($title) ? $title : "";

	$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
	$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
	$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
	$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
	$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
	$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();	

	$GLOBALS['temp']['reportType'] = $pf_object_name;
	$GLOBALS['temp']['readOnly'] = checkProfileUpdate() ? 0 : 1;
	$GLOBALS['temp']['extraDateCheck'] = pfFieldValueByOption($pf_option_id, "extraDateCheck");
	$GLOBALS['temp']['paymentDateCheck'] = pfFieldValueByOption($pf_option_id, "paymentDateCheck");
	$GLOBALS['temp']['travelDateCheck'] = pfFieldValueByOption($pf_option_id, "travelDateCheck");
	$GLOBALS['temp']['createDateCheck'] = pfFieldValueByOption($pf_option_id, "createDateCheck");
	$GLOBALS['temp']['statusDateCheck'] = pfFieldValueByOption($pf_option_id, "statusDateCheck");	

	if(!empty($pf_option_id)) {
		return array(
			'pf_option_id'=>$pf_option_id,
			'pf_option_name'=>$name,
			'pf_option_title'=>$rawTitle
		);
	} else {
		return false;
	}
}

function pfFieldValueByOption($pf_option_id, $pf_field_name) {
	if (empty($pf_option_id) || empty($pf_field_name)) {
		return false;
	}

	return $GLOBALS['lDB']->get(
		"
			SELECT
				pf_field_contents
			FROM
				pf_field
			WHERE
				pf_option_id = '" . $pf_option_id . "'
				AND pf_field_name = '" . $pf_field_name . "'
		",
		4
	);
}
