<?php
/*
 * $Id: functions.property.php,v 1.15 2011-11-15 16:05:37 light Exp $
 *
 * $Log: functions.property.php,v $
 * Revision 1.15  2011-11-15 16:05:37  light
 * Bug #7810 - HOTFIX: All properties not showing on financial interface setup
 *
 * Revision 1.14  2011-05-30 12:49:57  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.13  2011-05-17 14:08:23  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.12  2007-07-05 12:59:56  light
 * Bug #5760 - Revenue report: Provide an accomm type filter
 *
 * Revision 1.11  2007-06-05 07:51:04  light
 * Bug #5871 - Financial Interface
 *
 * Revision 1.10  2007-03-12 12:42:08  light
 * Bug #5696 - Add new property
 *
 * Revision 1.9  2006-11-23 11:51:14  light
 * Removed assignment of $this in functions.property.php (PHP 5+ fix)
 *
 * Revision 1.8  2006-10-27 12:39:04  light
 * Cleaned up the code.
 *
 * Revision 1.7  2004-03-27 06:02:22  tvdspuy
 * patch
 *
 * Revision 1.6  2004/03/01 05:59:24  tvdspuy
 * Tobie week patch - after conflict resolution
 *
 * Revision 1.5  2004/02/25 14:10:15  light
 * Cleaned up code
 *
 * Revision 1.4  2004/02/25 09:25:58  light
 * Cleaned up code
 *
 * Revision 1.3  2004/02/25 08:57:17  light
 * Cleaned up code
 *
 */

/**
 * functions.property - Functions used when dealing with property and accommodation information
 */

require_once(__DIR__ . "/functions.persona.php");

// hasPropChildren - Returns true if a property id is found in it's non billing entity child tree.
// =============================================================================================================
function hasPropChildren($record_id,$propertyBilling=false) {
	global $lDB;

	if($propertyBilling) {
		$billingYN = "pr_bus_billing_prop_yn";
	} else {
		$billingYN = "pr_bus_billing_yn";
	}

	// Find all non-billing unit children of target
	$list = $lDB->get("SELECT pr_business_id FROM pr_business WHERE pr_business_parent = '$record_id' AND $billingYN = 0",3);

	// Return false if no children are found
	$imax = sizeof($list);
	if ($imax == 0) {
		return false;
	}

	// Return true if any non-billing child is an active property ...
	if ($lDB->get("
		SELECT
			COUNT(pr_bus_property_yn)
		FROM
			pr_business
		WHERE
			pr_business.pr_business_id IN ('".join("','",$list)."')
			AND $billingYN = '0'
			AND pr_bus_property_yn = 1
			AND pr_bus_inactive_yn = 0
	",4) != "0") {
		return true;
	}

	// ... return true if any non-billing properties are found further down the tree ...
	for ($i=0;$i<$imax;$i++) {
		$child_id = $list[$i];
		if (hasPropChildren($child_id,$propertyBilling)) {
			return true;
		}
	}

	// ... otherwise return false
	return false;
}

function getPropChildren($pr_business_id,$propertyBilling=false,$reentry=false) {
	global $lDB;

	if($propertyBilling) {
		$billingYN = "pr_bus_billing_prop_yn";
	} else {
		$billingYN = "pr_bus_billing_yn";
	}

	$check = $lDB->get("
		SELECT
			pr_business.pr_bus_billing_yn,
			pr_business.pr_bus_billing_prop_yn,
			pr_business.pr_bus_property_yn,
			pr_business.pr_bus_inactive_yn
		FROM
			pr_business
		WHERE
			pr_business_id = '$pr_business_id'
	",1);
	if(
		(!$reentry && $check['pr_bus_billing_yn'] != "1" && !$reentry && $check['pr_bus_billing_prop_yn'] != "1")
		|| ($reentry && $check['pr_bus_billing_yn'] == "1") 
		|| ($reentry && $check['pr_bus_billing_prop_yn'] == "1")
		|| $check['pr_bus_inactive_yn'] == "1"
	) {
		return array();
	}

	if($check['pr_bus_property_yn'] == "1") {
		return array($pr_business_id);
	}

	$propList = $lDB->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_business_parent = '$pr_business_id'
			AND $billingYN = '0'
			AND pr_bus_property_yn = '1'
			AND pr_bus_inactive_yn = '0'
	",3);

	$busList = $lDB->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_business_parent = '$pr_business_id'
			AND $billingYN = '0'
			AND pr_bus_property_yn = '0'
			AND pr_bus_inactive_yn = '0'
	",3);

	if(sizeof($busList) > 0) {
		foreach($busList as $busId) {
			$propList = array_merge($propList, getPropChildren($busId, $propertyBilling,true));
		}
	}

	return $propList;
}


// getBillingParent - Returns false if no billing entity parent is found. Takes only the parent id as argument.
// =============================================================================================================
function getBillingParent($parent_id) {
	global $lDB;

	while (1) {
		$billing = $lDB->get("select pr_bus_billing_yn from pr_business where pr_business_id = '$parent_id' and pr_bus_inactive_yn = 0",4);
		if ($billing == "1") {
			return $parent_id;
		}

		$parent_id = $lDB->get("select pr_business_parent from pr_business where pr_business_id = '$parent_id'",4);
		if ($parent_id == "0") {
			return false;
		}
	}
}


// hasBillingParent - Returns true if a parent billing entity is found. Takes either the record or the parent id
// =============================================================================================================
function hasBillingParent($record_id,$parent_id="") {
	global $lDB;

	if ($record_id != "") {
		$property_id = $lDB->get("select pr_business_parent from pr_business where pr_business_id = '$record_id'",4);
	} else {
		$property_id = $parent_id;
	}

	$result = getBillingParent($property_id);
	if ($result !== false) {
		return true;
	}
	return false;
}

// getBillingPropParent - Returns false if no billing property entity parent is found. Takes only the parent id as argument.
// =============================================================================================================
function getBillingPropParent($parent_id) {
	global $lDB;

	while (1) {
		$billing = $lDB->get("select pr_bus_billing_prop_yn from pr_business where pr_business_id = '$parent_id' and pr_bus_inactive_yn = 0",4);
		if ($billing == "1") {
			return $parent_id;
		}

		$parent_id = $lDB->get("select pr_business_parent from pr_business where pr_business_id = '$parent_id'",4);
		if ($parent_id == "0") {
			return false;
		}
	}
}


// hasBillingPropParent - Returns true if a parent billing property entity is found. Takes either the record or the parent id
// =============================================================================================================
function hasBillingPropParent($record_id,$parent_id="") {
	global $lDB;

	if ($record_id != "") {
		$property_id = $lDB->get("select pr_business_parent from pr_business where pr_business_id = '$record_id'",4);
	} else {
		$property_id = $parent_id;
	}

	$result = getBillingPropParent($property_id);
	if ($result !== false) {
		return true;
	}

	return false;
}

// calAcRecurse - lean recursive algo to get the allowed properties for the calendar in a flat array
// =================================================================================================
function calAcRecurse($parentId, $showAll=false) {
   global $lDB;
   global $calAcRecurseResult;

   if (!is_array($calAcRecurseResult)) {
      $calAcRecurseResult = array();
   }

   $accommInactiveWhere = "
	   AND ac_accomm_type_inactive_yn = '0'
   ";
   $propertyInactiveWhere = "
	   AND pr_bus_inactive_yn = '0'
   ";
	if($showAll) {
		$accommInactiveWhere = "";
		$propertyInactiveWhere = "";
	}
   $count = $lDB->get("
      SELECT
         COUNT(*)
      FROM
         ac_accomm_type
      WHERE
         pr_business_id = '$parentId'
         $accommInactiveWhere
   ",4);
   if ($count == "0") {
      $childIds = $lDB->get("
         SELECT
            pr_business_id
         FROM
            pr_business
         WHERE
            pr_business_parent = '$parentId'
            $propertyInactiveWhere
         ORDER BY
            pr_business_sequence
      ",3);
      foreach($childIds as $item) {
            calAcRecurse($item,$showAll);
      }
   } else {
      array_push($calAcRecurseResult,$parentId);
   }
}


// propCanDelete - Recursive child check for the deletion of a property.
// =================================================================================================
function propCanDelete($id) {
	global $lDB;
	global $propChildList2B;
	global $accommChildList2B;

	if(!is_array($propChildList2B)) {
		$propChildList2B = array();
	}
	if(!is_array($accommChildList2B)) {
		$accommChildList2B = array();
	}

	$breakout = "0";
	if(isPrincOrResOffice($id)) {
		$breakout = "1";
	}

	$agentPropCount = $lDB->get("
		SELECT
			COUNT(pr_agent_prop_ix)
		FROM
			pr_agent_prop
		WHERE
			pr_business_id = '" . $lDB->escape($id) . "'
	",4);
	if($agentPropCount > 0) {
		$breakout = "1";
	}

	# Add to the childlist in case we have to deactivate the records
	if(!in_array($id,$propChildList2B)) {
		array_push($propChildList2B,$id);
	}

	# Check for and add any accomm types linked to this property to the list (to be tested later).
	if(!$lDB->count("ac_accomm_type","pr_business_id",$id,0)) {
		$temp = $lDB->get("SELECT ac_accomm_type_ix FROM ac_accomm_type WHERE pr_business_id = '$id'",3);
		foreach($temp as $childId) {
			# Add to the childlist in case we have to deactivate the records
			if(!in_array($childId,$accommChildList2B)) {
				array_push($accommChildList2B,$childId);
			}
		}
	}

	$temp = $lDB->get("SELECT pr_business_id FROM pr_business WHERE pr_business_parent = '$id'",3);
	foreach($temp as $childId) {
		# Recursively test all the child nodes
		if(!propCanDelete($childId)) {
			$breakout = "1";
			break;
		}
	}

	if($breakout == "0") {
		return true;
	} else {
		return false;
	}
}

// accommCanDelete - Recursive property child check for the deletion of accomm types
// =================================================================================================
function accommCanDelete($accommId="") {
   global $lDB;
    global $accommChildList2B;

   if ($accommId != "") {
      $accommChildList2B = array($accommId);
   } else {
      if (!is_array($accommChildList2B) || sizeof($accommChildList2B) == "0") {
         return true;
      }
   }

   $result = $lDB->get("SELECT COUNT(*) FROM rv_reservation_item WHERE ac_accomm_type_id in ('".join("','",$accommChildList2B)."')",4);
   if ($result > 0) {
      return false;
   } else {
      return true;
   }
}


// recursion function  -  generate a hierarchial array of propertyid's
// =======================================================================================
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// In it's use in forms 14 and 74, only the $flag parameter is used externally
// it should be first
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function recurse_array ($record=0,$type=0,$flag=0) {
   global $lDB;
   global $dbcode;

   $array = array();
   if ($type == "0") {
      if ($record != $dbcode."0") {
         $name = trim($lDB->get("
            SELECT
               pr_name_last
            FROM
               pr_persona
            WHERE
               pr_persona_ix = '$record'
         ",4));
      } else {
         $name = "Properties";
      }
      # get children (see if accomms exist, if so just get accomms, else just get properties)
      $sep = "-";
      if ($flag == "1") {
         $sep = "&|&";
      }
      $array[0] = $record.$sep.$name;
      if ($lDB->count("ac_accomm_type","pr_business_id",$record,"0")) {
         $temp = $lDB->get("
            SELECT
               pr_business_id
            FROM
               pr_business
            WHERE
               pr_business_parent = '$record'
            ORDER BY
               pr_business_sequence
         ",3);
         cleanse($temp);
         # for each child property, push to array, then recurse
         $j = 1;
         foreach($temp as $child) {
            $array[$j] = recurse_array($child,0,$flag);
            $j++;
         }
      } else {
         $temp = $lDB->get("
            SELECT
               ac_accomm_type_ix
            FROM
               ac_accomm_type
            WHERE
               pr_business_id = '$record'
            ORDER BY
               ac_accomm_sequence
         ",3);
         cleanse($temp);

         # for each child accomm, push to array, then recurse
         $j = 1;
         foreach($temp as $child) {
            $array[$j] = recurse_array($child,1,$flag);
            $j++;
         }
      }
   } else {
      $temp = $lDB->get("
         SELECT
            ac_accomm_desc
         FROM
            ac_accomm_type
         WHERE
            ac_accomm_type_ix = '$record'
      ",4);
      $name = trim($temp);
      $sep = "-";
      if ($flag == "1") {
         $sep = "&|&";
         $name .= $sep."ACC";
      }
      $array = array("0" => $record.$sep.$name);
   }
   return $array;
}


// recursion display function  -  output a list of propertyid's in a javascript array tree
// =======================================================================================
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// This is ONLY used in Form 14 - maybe it should be moved there?
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
function recurse_display ($array,$level=0,$counter=0) {
	$varName = "row_".$level++."_".$counter;
	for ($i = 1; $i < sizeof($array); $i++) {
		$string .= recurse_display($array[$i],$level,$counter++);
	}
	$string .= "var ".$varName." = new Array(";
	$string .= "\"".$array[0]."\"";
	for ($i = 1; $i < sizeof($array); $i++) {
		$t = $i-1;
		$string .= ", row_".$level."_".$t;
	}
	$string .= ");\n";
	return $string;
}

function getPropNotes($record) {
   global $lDB;

   return $lDB->get("
      SELECT
         pr_persona.pr_name_last,
         pr_business.pr_bus_memo_info
      FROM
         rv_reservation_item
         INNER JOIN ac_accomm_type ON rv_reservation_item.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
         INNER JOIN pr_business ON ac_accomm_type.pr_business_id = pr_business.pr_business_id
         INNER JOIN pr_persona ON pr_business.pr_business_id = pr_persona.pr_persona_ix
      WHERE
         rv_reservation_item.rv_reservation_id='$record'
      GROUP BY
         pr_persona.pr_name_last,
         rv_reservation_item.rv_reservation_id,
         ac_accomm_type.pr_business_id,
         pr_business.pr_bus_memo_info
      HAVING
         pr_business.pr_bus_memo_info Is not Null
   ",2);
}

#
# Function: Get accommodation notes applicable to reservation
#

function getAccommNotes($record) {
   global $lDB;

   return $lDB->get("
      SELECT
         pr_persona.pr_name_last,
         ac_accomm_type.ac_accomm_desc,
         ac_accomm_type.ac_accomm_note
      FROM
         rv_reservation_item
         INNER JOIN ac_accomm_type ON rv_reservation_item.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
         INNER JOIN pr_business ON ac_accomm_type.pr_business_id = pr_business.pr_business_id
         INNER JOIN pr_persona ON pr_business.pr_business_id = pr_persona.pr_persona_ix
      WHERE
         rv_reservation_item.rv_reservation_id='$record'
      GROUP BY
         rv_reservation_item.ac_accomm_type_id
      HAVING
         ac_accomm_type.ac_accomm_note Is not Null
      ORDER BY
         pr_persona.pr_name_last,
         ac_accomm_type.ac_accomm_sequence
   ",2);
}

#
# Function: Get booking info note
#

function getBookNote() {
   return $GLOBALS['lDB']->get("SELECT rf_booking_info FROM rf_default WHERE rf_booking_info Is Not Null",4);
}

#
# Function: Find the common parent entities for a given set of properties and return
#           sorted by business structure order
#

function findCommonParents($properties = array()) {
	global $lDB;

	// Convert single id parameters to an array
	if(!is_array($properties)) {
		$properties = array($properties);
	}

	// Eliminate duplicates
	$properties = array_unique($properties);

	$finalParents = false;
	foreach($properties as $pr_business_id) {
		$currId = $pr_business_id;
		$currParents = array();
		while(!empty($currId)) {
			$currParents[] = $currId;
			$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
			$currId = $parentId;
		}
		if($finalParents === false) {
			$finalParents = $currParents;
		} else {
			$finalParents = array_intersect($finalParents, $currParents);
		}
	}
	return $finalParents;
}

function getDefaultProperties() {
	// Start process for default access controlled, correctly sequenced proplist

	$sql = "
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_bus_inactive_yn = '0'
		ORDER BY
			pr_business_parent ASC
		LIMIT 1
	";

	$propMaster = $GLOBALS['lDB']->get($sql,4);

	calAcRecurse($propMaster);

	global $calAcRecurseResult;

	// Get access control Property List
	$tempPropData = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			ac_accomm_type.pr_business_id,
			pr_persona.pr_name_last
		FROM
			sc_accomm, ac_accomm_type, pr_business, pr_persona
		WHERE
			sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
			AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			AND	ac_accomm_type.ac_accomm_type_inactive_yn=0
			AND	ac_accomm_type.pr_business_id = pr_business.pr_business_id
			AND	pr_business.pr_bus_inactive_yn= '0'
			AND	pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	",2);

	$acPropList	= array();
	$calPropData = array();
	$xmax = sizeof($tempPropData);

	for ($x = 0; $x < $xmax; $x++) {
		$key = $tempPropData[$x][0];
		array_push($acPropList,$key);
		$calPropData[$key] = $tempPropData[$x][1];
	}

	$defaultPropList = array();
	$aamax = sizeof($calAcRecurseResult);

	for($aa = 0;$aa < $aamax; $aa++) {
		$key = $calAcRecurseResult[$aa];
		if(in_array($key,$acPropList)) {
			array_push($defaultPropList,$key);
		}
	}
	// End get of default proplist
	return $defaultPropList;
}