<?php

/**
 * Global Rates Functions
 *
 */
 
require_once(__DIR__ . '/db.rt_rate.php');
require_once(__DIR__ . '/db.rt_rate_component.php');
require_once(__DIR__ . '/db.rt_rate_comp_grp.php');
require_once(__DIR__ . '/db.rt_rate_grp_amt.php');
 
function getRateHeader($rateID) {
	global $lDB;

	$rateHeader = $lDB->get("
		SELECT 
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,	
			ac_accomm_type.ac_accomm_type_ix,
			rt_rate_type.rt_rate_type_desc,
			rt_rate_type.rt_rate_type_ix,
			rf_currency.rf_currency_symbol,
			rt_period.rt_period_ix,
			rt_period.rt_period_desc,
			rt_period.rt_period_date_from,
			rt_period.rt_period_date_to,
			rt_rate.rt_rate_dist_yn,
			rt_rate.rt_rate_comm_yn,
			rt_rate.rt_rate_overide_level_ind,
			rt_rate_oride_comm_yn,
			rt_rate_ssupp_comm_yn,
			rt_rate.rt_rate_round_ind,
			rt_rate.rt_rate_round_dir,
			rt_rate.rt_rate_round_scale,			
			rt_rate.rt_rate_status_ind,
			rt_rate.rt_rate_waive_checks_yn,
			rt_rate.rt_pax_rate_group_yn,
			rt_rate.rt_rate_tba_yn
		FROM
			rt_rate
			INNER JOIN ac_accomm_type ON rt_rate.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			INNER JOIN pr_persona ON ac_accomm_type.pr_business_id = pr_persona.pr_persona_ix
			INNER JOIN rt_rate_type ON rt_rate.rt_rate_type_id = rt_rate_type.rt_rate_type_ix
			INNER JOIN rf_currency ON rt_rate_type.rf_currency_id = rf_currency.rf_currency_ix
			INNER JOIN rt_period ON rt_rate.rt_period_id = rt_period.rt_period_ix
		WHERE
			rt_rate.rt_rate_ix = '$rateID'
	",1);

	
	return $rateHeader;
}

function getRateComponents($rateID) {

	global $lDB;

	$rateComponents = $lDB->get("
		SELECT 
			rt_rate_component.rt_rate_component_ix,
			rt_rate_component.rt_comp_comm_yn,		
			rt_rate_component.rt_comp_freq_ind,				
			rt_rate_component.rt_comp_freq_factor,	
			rt_rate_component.rt_comp_itin_yn,
			rt_rate_component.rt_comp_los_yn,
			rt_rate_component.rt_comp_opt_yn,
			rt_rate_component.rt_comp_opt_def_yn,
			rt_rate_component.rt_comp_round_ind,
			rt_rate_component.rt_comp_separate_yn,
			rt_component.rt_component_desc,
			rt_rate_component.rt_component_id,
			rt_rate_component.rt_tax_id,
			rt_rate_component.rt_tax_ind
		FROM
			rt_rate_component
			INNER JOIN rt_rate ON rt_rate_component.rt_rate_id = rt_rate.rt_rate_ix
			INNER JOIN rt_component on rt_rate_component.rt_component_id = rt_component.rt_component_ix
		WHERE
			rt_rate_component.rt_rate_id = '$rateID'
		ORDER BY 
			rt_component.rt_component_desc
	",2);
	
	return $rateComponents;
}

function getUnusedComponents($rateID) {
	global $lDB;
	
	$usedComponents = $lDB->get("
		SELECT
			rt_component.rt_component_ix
		FROM
			rt_component
			INNER JOIN rt_rate_component ON rt_rate_component.rt_component_id = rt_component.rt_component_ix
		WHERE
			rt_rate_component.rt_rate_id = '$rateID'
	",3);	

	$usedIDs = "'".implode("','",$usedComponents)."'";
	
	$unusedComponents = $lDB->get("
		SELECT
			rt_component.rt_component_ix,
			rt_component.rt_component_desc 
		FROM
			rt_component
		WHERE
			rt_component.rt_component_ix NOT IN ($usedIDs)
	",2);
	
	return $unusedComponents;
}

// Note this gets a specific split value.  For all the splits across components, use getRateComponentSplits
function getRateComponentSplit($rateComponentID, $rateComponentGroupID){
	
	global $lDB;
	
	$rateCompSplit = $lDB->get("
		SELECT
			rt_rate_comp_grp.rt_rate_comp_amt,
			rt_rate_comp_grp.rt_rate_comp_perc,
			rt_rate_comp_grp.rt_rate_comp_grp_comm_yn,
			rt_rate_comp_grp.rt_rate_comp_grp_seq
		FROM
			rt_rate_comp_grp
		WHERE
			rt_rate_comp_grp.rt_rate_group_id = '$rateComponentGroupID'
		AND
			rt_rate_comp_grp.rt_rate_component_id = '$rateComponentID'
	",1);
	
	return $rateCompSplit;

}

function getRateComponentSplits($rateID, $rateGroupID){
	
	global $lDB;
	
	$rateCompSplits = $lDB->get("
		SELECT
			rt_rate_comp_grp.rt_rate_comp_grp_ix,
			rt_rate_component.rt_rate_component_ix,
			rt_rate_component.rt_component_id,
			rt_rate_component.rt_comp_opt_yn,
			rt_rate_component.rt_comp_freq_ind,
			rt_rate_component.rt_comp_freq_factor,
			rt_rate_comp_grp.rt_rate_comp_amt,
			rt_rate_comp_grp.rt_rate_comp_perc,
			rt_rate_comp_grp.rt_rate_comp_grp_comm_yn,
			rt_rate_comp_grp.rt_rate_comp_val_ind,
			rt_rate_group.rt_rate_group_ix
		FROM
			rt_rate_comp_grp
			INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
			INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
			INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id	
		WHERE
			rt_rate_comp_grp.rt_rate_group_id = '$rateGroupID'
		AND
			rt_rate_component.rt_rate_id = '$rateID'
		ORDER BY rt_rate_comp_grp.rt_rate_comp_val_ind, rt_rate_comp_grp.rt_rate_comp_amt, rt_rate_comp_grp.rt_rate_comp_perc
	",2);
	return $rateCompSplits;
}

function getRateComponentGroupHeaders($rateID, $paxInd=2){
	
	global $lDB;
	
	switch($paxInd){
	case 0:	// All including pax group
		$filter = " ";
		break;
	case 1:	// Pax group only
		$filter = "AND rt_rate_group.rt_rate_group_sys_code = 99 ";
		break;
	case 2:	// All EXCEPT pax group
		$filter = "AND rt_rate_group.rt_rate_group_sys_code != 99 ";
		break;
	}

	$rateCompGroupHeaders = $lDB->get("
		SELECT DISTINCT
			rt_rate_group.rt_rate_group_ix,
			rt_rate_group.rt_rate_group_desc,
			rt_rate_group.rt_rate_group_sys_code,
			rt_rate_comp_grp.rt_rate_comp_grp_seq
		FROM
			rt_rate_comp_grp
			INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
			INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
			INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
		WHERE
			rt_rate.rt_rate_ix = '$rateID' 
			$filter
		ORDER BY
			CASE rt_rate_comp_grp.rt_rate_comp_grp_seq WHEN 0 THEN 1 ELSE 0 END,
			rt_rate_comp_grp.rt_rate_comp_grp_seq, rt_rate_group.rt_rate_group_desc
	",2);
	
	return $rateCompGroupHeaders;

}

function getRateComponentGroupCommissionable($rateID, $rt_rate_group_id){
	
	global $lDB;
	
	$rateComponentGroupCommissionable = $lDB->get("
		SELECT DISTINCT
			rt_rate_comp_grp.rt_rate_comp_grp_comm_yn
		FROM
			rt_rate_comp_grp
			INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
			INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
			INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id			
		WHERE
			rt_rate.rt_rate_ix = '$rateID'
			AND rt_rate_group.rt_rate_group_ix = '$rt_rate_group_id'
	",4);
	
	return $rateComponentGroupCommissionable;
}

function getUnusedRateComponentGroups($rateID){
	
	global $lDB;
	
	$used = $lDB->get("
		SELECT DISTINCT
			rt_rate_group.rt_rate_group_ix
		FROM
			rt_rate_comp_grp
			INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
			INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
			INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
		WHERE
			rt_rate.rt_rate_ix = '$rateID'
	",3);
	
	$unusedRateGroups = $lDB->get("
		SELECT
			rt_rate_group.rt_rate_group_ix,
			rt_rate_group.rt_rate_group_desc
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_ix NOT IN ('".join("','",$used)."')
			AND rt_rate_group.rt_rate_group_inactive_yn = 0
			AND rt_rate_group.rt_rate_group_sys_code = 0;
		;
	",2);
	
	return $unusedRateGroups;

}

function getRateGroupAmts($rateID){
	
	global $lDB;
	
	$rateGroupAmounts = array();

	$rateGroupAmounts = $lDB->get("
		SELECT 
			rt_rate_grp_amt.rt_rate_grp_amt_ix,
			rt_rate_grp_amt.rt_rate_grp_amt_qty,
			rt_rate_grp_amt.rt_rate_grp_amt_amount AS rateGroupTotal,
			rt_rate_group.rt_rate_group_ix
		FROM
			rt_rate_grp_amt
			INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_grp_amt.rt_rate_id
			INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_grp_amt.rt_rate_group_id
		WHERE
			rt_rate.rt_rate_ix = '$rateID'
		GROUP BY
			rt_rate_grp_amt.rt_rate_grp_amt_qty, rt_rate_group.rt_rate_group_ix;
	",2);
	
	return $rateGroupAmounts;

}

function getAccommTypeMaxCapacity($ac_accomm_type_id){

	global $lDB;
	
	$maxCapacity = $lDB->get("
		SELECT 
			ac_accomm_type.ac_accomm_max_capacity
		FROM
			ac_accomm_type
		WHERE
			ac_accomm_type.ac_accomm_type_ix = '$ac_accomm_type_id'
	",4);
	
	return $maxCapacity;

}

function getAccommTypeMaxAdults($ac_accomm_type_id) {

	global $lDB;
	
	$maxAdults = $lDB->get("
		SELECT 
			ac_accomm_type.ac_accomm_max_adults
		FROM
			ac_accomm_type
		WHERE
			ac_accomm_type.ac_accomm_type_ix = '$ac_accomm_type_id'
	",4);
	
	return $maxAdults;

}

function restoreAmounts($rateID, $rateGroupAmts){

	//Get max capacity
	$rateHeader = getRateHeader($rateID);
	$maxCapacity = getAccommTypeMaxCapacity($rateHeader['ac_accomm_type_ix']);	

	//Get new rate groups that apply to this rate (they could have changed)
	if ($rateHeader['rt_pax_rate_group_yn'] == 1){
		$rateGroups = getRateComponentGroupHeaders($rateID,1);
	} else {
		$rateGroups = getRateComponentGroupHeaders($rateID);
	}

	//Delete old amounts
	rt_rate_grp_amt_delete_by_rate($rateID);

	//recalculate all amounts for the groups that we have values for
	for ($i=0;$i<=$maxCapacity; $i++){
		foreach ($rateGroups as $rateGroup){
			foreach ($rateGroupAmts as $rateGroupAmt){
				if ($rateGroupAmt['rt_rate_group_ix'] == $rateGroup['rt_rate_group_ix'] && $rateGroupAmt['rt_rate_grp_amt_qty'] == $i){
					//We had an amount for this rate group, so readd
					rt_rate_grp_amt_insert($rateID, $rateGroup['rt_rate_group_ix'], $i, $rateGroupAmt['rateGroupTotal']);
				}
			}
		}
	}
}

function deleteRateCompGroups($rateID, $rateGroupID=NULL, $rateCompID=NULL){

		// Delete Rate Comp Groups
		$sql = "
			SELECT 
				rt_rate_comp_grp_ix,
				rt_rate_group.rt_rate_group_sys_code 
			FROM 
				rt_rate_comp_grp 
				INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
				INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
				INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
			WHERE 
				rt_rate.rt_rate_ix = '$rateID'
		";
		
		if ($rateGroupID){
			$sql .= " AND rt_rate_comp_grp.rt_rate_group_id = '$rateGroupID'";
		}
		
		if ($rateCompID){
			$sql .= " AND rt_rate_comp_grp.rt_rate_component_id = '$rateCompID'";
		}
		
		$rateCompGroups = $GLOBALS['lDB']->get($sql,2);
		
		foreach($rateCompGroups as $rateCompGroup){
			if ($rateCompGroup['rt_rate_group_sys_code'] == 0 || $rateCompGroup['rt_rate_group_sys_code'] == 99 || $rateCompID){
				rt_rate_comp_grp_delete($rateCompGroup['rt_rate_comp_grp_ix']);
			}
		}
	
}

function updateRateCompGroupComm($rateID, $rateGroupID, $commYN){

		$sql = "
			SELECT 
				rt_rate_comp_grp_ix
			FROM 
				rt_rate_comp_grp 
				INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
				INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
				INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
			WHERE 
				rt_rate.rt_rate_ix = '$rateID'
		";
		
		if ($rateGroupID){
			$sql .= " AND rt_rate_comp_grp.rt_rate_group_id = '$rateGroupID'";
		}

		$rateCompGroups = $GLOBALS['lDB']->get($sql,2);
		foreach($rateCompGroups as $rateCompGroup){
			rt_rate_comp_grp_update($rateCompGroup['rt_rate_comp_grp_ix'], false, false, $commYN);
		}
	
}


function addRateCompGroups($rateID, $rateGroupID, $sequence=0){
	
	$rateComponents = getRateComponents($rateID);
	
	foreach ($rateComponents as $rateComponent){
		rt_rate_comp_grp_insert($rateComponent['rt_rate_component_ix'], $rateGroupID, 0, 0, false, $sequence);
	}
}

function tabStates($rateID){

	if (count(getRateComponents($rateID)) == 0){
		$GLOBALS['temp']['disableCompSplits'] = "style=\"color: grey;\"";
		$GLOBALS['temp']['disableAmounts'] = "style=\"color: grey;\"";	
	} else if (count(getRateComponentGroupHeaders($rateID)) == 0) {
		$GLOBALS['temp']['disableCompSplits'] = "";
		$GLOBALS['temp']['disableAmounts'] = "style=\"color: grey;\"";	
	} else {
		$GLOBALS['temp']['disableCompSplits'] = "";
		$GLOBALS['temp']['disableAmounts'] = "";		
	}
}

function checkTBA($rateID){
	if (count(getRateGroupAmts($rateID)) == 0){
		rt_rate_set_tba($rateID, 1);
	} else {
		rt_rate_set_tba($rateID, 0);
	}
}

function headerHTML($rateID){

	$rateHeader = getRateHeader($rateID);

	$headerItem['txtProperty'] = $rateHeader['pr_name_last'];
	$headerItem['txtAccommType'] = $rateHeader['ac_accomm_desc'];
	$headerItem['txtRateType'] = $rateHeader['rt_rate_type_desc'];
	$headerItem['txtCurrency'] = $rateHeader['rf_currency_symbol'];
	$headerItem['txtPeriod'] = $rateHeader['rt_period_desc'];
	$headerItem['ratePeriodID'] = $rateHeader['rt_period_ix'];

	$headerItem['rtWaive'] = $rateHeader['rt_rate_waive_checks_yn'];
	switch ($rateHeader['rt_rate_tba_yn']) {
		case 1:
			$headerItem['rtTBA'] = "To Be Advised (TBA)";
			break;
		case 0:
			$headerItem['rtTBA'] = "";
			break;
	}	
	
	$headerHTML = Join("",File(__DIR__ . "/../../../public/html/rate_edit_header.htm"));
	return showpage($headerItem,$headerHTML);
}

function setFixedAmounts($rateID) {

}

function array_flatten($a,$f=array()) {
	if(!$a||!is_array($a))return '';
	foreach($a as $k=>$v) {
		if(is_array($v))$f=array_flatten($v,$f);
		else $f[]=$v; // NOTE: I took out the $k, so it will just push the item at the end
	}
	return $f;
}

function convertToRateGroups($units=false, $adults=false, $children=false){
	global $lDB;

	// Convert Units, Adults and Children into their applicable rate groups
	$unitCode = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1",4);
	$adultCode = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 2",4);
	// Note: This will return the first child rate groups (there could be many)
	$childCode = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_class = 2",4);
	
	$rateGroups = array(
		"0" => array(
			"rt_rate_group_ix" => $unitCode,
			"name" => "Units",
			"qty" => $units
		),
		"1" => array(
			"rt_rate_group_ix" => $adultCode,
			"name" => "Adults",
			"qty" => $adults
		),
		"2" => array(
			"rt_rate_group_ix" => $childCode,
			"name" => "Child",
			"qty" => $children
		)
	);

	return $rateGroups;
	
}

function cleanRateGroups($rateGroups=false){
	global $lDB;

	if ($rateGroups === false){
		$rateGroups = array();
	}
	$newRateGroups = array();

	foreach($rateGroups as $key => $rateGroup){
		if(!array_key_exists('rt_rate_group_ix',$rateGroup)) {
			$newRateGroups[$key]['rt_rate_group_ix'] = $rateGroup[0];
			$newRateGroups[$key]['qty'] = $rateGroup[1] ?? 0;		
		} else {
			$newRateGroups[$key] = $rateGroup;
		}
		$newRateGroups[$key]['rt_rate_group_ix'] = strtoupper($newRateGroups[$key]['rt_rate_group_ix']);
	}

	return $newRateGroups;
	
}

/*

	Takes a single overide amount (ie. from the old format, based on the rate-default overide level) or a new-format array and converts it to the array 
	format that ResRequest expects.

*/
function convertToOrideArray($ac_accomm_type_id,$rv_item_date_arrive,$rv_item_date_depart,$rateGroups,$rt_rate_type_id,$overide){
	global $lDB;

/*
	Desired structure of overide array
	
	"level"		=> "1",
	"amounts"	=> array(
		"stay"			=>	"500.00",
		"rate_group"	=>	array(
			"RS1"	=>	"450.00",
			"RS2"	=>	"350.00",
			"RS3"	=>	"300.00"
		)
	)
*/	


	$unitCode = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1",4);
	// Init vars
	$orideLevel = 0;
	$orideStay = "";
	$newArray = array();
	$orideRateGroups = array();
	foreach ($rateGroups as $rateGroup){
		$orideRateGroups[$rateGroup['rt_rate_group_ix']] = "";
	}	
	
	if (is_array($overide)){

		foreach ($overide as $oride){
			$oride[0] = strtoupper($oride[0]);
			if ($oride[0] == 'STAY' && $oride[1] != ""){
				$orideLevel = 3;
				$orideStay = $oride[1];
			} elseif ($oride[0] == $unitCode && $oride[1] != ""){
				$orideLevel = 2;
				$orideStay = "";
				$orideRateGroups[$unitCode] = $oride[1];
			} elseif ($oride[0] != "" && $oride[1] != "") {
				$orideStay = "";
				$orideRateGroups[$unitCode] = "";
				$orideLevel = 1;
				if (array_key_exists($oride[0], $orideRateGroups)){
					$orideRateGroups[$oride[0]] = $oride[1];
				}
			}
		}
	
	} else {
		if(trim($overide) == "") {
			return array();
		}
		$rate = new Rate($ac_accomm_type_id,$rv_item_date_arrive,$rv_item_date_depart,$rateGroups,$rt_rate_type_id);
		$rate->ToPeriods();		
		$orideLevel = $rate->Periods[0]['rt_rate_overide_level_ind'];
		
		switch($orideLevel){
			case 1:


				foreach ($rateGroups as $rateGroup){
					if ($rateGroup['rt_rate_group_ix'] == $unitCode){
						$orideRateGroups[$rateGroup['rt_rate_group_ix']] = "";
					} else {
						$orideRateGroups[$rateGroup['rt_rate_group_ix']] = $overide;
					}
				}
			
				break;
			case 2:
				foreach ($rateGroups as $rateGroup){
					if ($rateGroup['rt_rate_group_ix'] == $unitCode){
						$orideRateGroups[$rateGroup['rt_rate_group_ix']] = $overide;
					} else {
						$orideRateGroups[$rateGroup['rt_rate_group_ix']] = "";
					}
				}
	
				break;			
			case 3:

				$orideStay = $overide;
	
				break;			
		}
		
		
	}
	
	$newArray = array(
		"level"		=> $orideLevel,
			"amounts"	=> array(
				"stay"			=>	$orideStay,
				"rate_group"	=>	$orideRateGroups
			)
	);
	
	return $newArray;
}

function getTotalUnits($rateGroups=false){
	global $lDB;

	if ($rateGroups === false){
		$rateGroups = array();
	}
	
	$unitCode = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1",4);
	$total = 0;
	
	foreach ($rateGroups as $rateGroup){
		if ($rateGroup['rt_rate_group_ix'] == $unitCode){
			$total += $rateGroup['qty'];
		}
	}
	
	return $total;
}


function getTotalPax($rateGroups=false){
	global $lDB;

	if ($rateGroups === false){
		$rateGroups = array();
	}	

	$unitCode = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1",4);
	$total = 0;
	
	foreach ($rateGroups as $rateGroup){
		if ($rateGroup['rt_rate_group_ix'] != $unitCode){
			$total += $rateGroup['qty'];
		}
	}
	
	return $total;
}

function getTotalAdults($rateGroups=false){
	global $lDB;

	if ($rateGroups === false){
		$rateGroups = array();
	}

	$total = 0;	
	
	foreach ($rateGroups as $rateGroup){
		$class = $lDB->get("SELECT rt_rate_group_class FROM rt_rate_group WHERE rt_rate_group_ix = '".$rateGroup['rt_rate_group_ix']."'",4);
		if ($class == 1){
			$total += $rateGroup['qty'];
		}
	}	
	
	return $total;
}

// Outputs a string required by calCreateItem for raw item data
function convertItemToRaw($ac_accomm_type_id,$rv_item_date_arrive,$rv_item_date_depart,$rateGroups) {
	$numnights = 0;
	$rateGroupStr = "";
	$rateGroupArray = array();
	foreach ($rateGroups as $rateGroup){
		$rateGroupArray[] = $rateGroup['rt_rate_group_ix']."_".$rateGroup['qty'];
	}
	$rateGroupStr = join("~",$rateGroupArray);

	return $ac_accomm_type_id.":".$rv_item_date_arrive.":".$rv_item_date_depart.":".$numnights.":".$rateGroupStr;

}

// Checks to see if there are any rate groups without percentage-based component splits. If there are, then override should not be allowed.
function checkCanOverride($rateID){
	$rateComponentGroupHeaders = getRateComponentGroupHeaders($rateID);
	foreach($rateComponentGroupHeaders as $rateGroup){
		$totalPerc = 0;
		$totalAmt = 0;
		$rateComponentSplits = getRateComponentSplits($rateID, $rateGroup['rt_rate_group_ix']);
		foreach ($rateComponentSplits as $rateComponentSplit){
			$totalPerc += $rateComponentSplit['rt_rate_comp_perc'];
			$totalAmt += $rateComponentSplit['rt_rate_comp_amt'];
		}
		if ($totalAmt <> 0 && $totalPerc <> 100){
			return false;
		}
	}

	return true;
}

// Checks the amounts for the rate, and in the event that there are only fixed component splits, sets the amounts to equal the sum total of those splits
function validateAmounts($rateID){
	$result = true;
	$totals = array();
	$rateGroupAmounts = array();
	$rateCompGroupHeaders = getRateComponentGroupHeaders($rateID);
	$rateComponents = getRateComponents($rateID);
	foreach ($rateComponents as $rc) {
		if ($rc['rt_comp_opt_yn'] != 1){
			foreach ($rateCompGroupHeaders as $key => $rateCompGroupHeader){
				if (!array_key_exists($rateCompGroupHeader['rt_rate_group_ix'], $totals)){
					$totals[$rateCompGroupHeader['rt_rate_group_ix']] = array(
						"amt" => 0,
						"perc" => 0
					);
				}

				$rateCompSplit = getRateComponentSplit($rc['rt_rate_component_ix'], $rateCompGroupHeader['rt_rate_group_ix']);
				$totals[$rateCompGroupHeader['rt_rate_group_ix']]['amt'] += $rateCompSplit['rt_rate_comp_amt'];
				$totals[$rateCompGroupHeader['rt_rate_group_ix']]['perc'] += $rateCompSplit['rt_rate_comp_perc'];
			}
		}
	}
	$rateGroupAmountsAll = getRateGroupAmts($rateID);

	foreach ($rateGroupAmountsAll as $rateGroupAmount){
		if (!array_key_exists($rateGroupAmount['rt_rate_group_ix'], $rateGroupAmounts)){
			$rateGroupAmounts[$rateGroupAmount['rt_rate_group_ix']] = array();
		}
		if (!array_key_exists($rateGroupAmount['rt_rate_grp_amt_qty'], $rateGroupAmounts[$rateGroupAmount['rt_rate_group_ix']])){
			$rateGroupAmounts[$rateGroupAmount['rt_rate_group_ix']][$rateGroupAmount['rt_rate_grp_amt_qty']] = array();
		}
		$rateGroupAmounts[$rateGroupAmount['rt_rate_group_ix']][$rateGroupAmount['rt_rate_grp_amt_qty']]['amt'] = isset($rateGroupAmounts[$rateGroupAmount['rt_rate_group_ix']][$rateGroupAmount['rt_rate_grp_amt_qty']]['amt']) ? $rateGroupAmounts[$rateGroupAmount['rt_rate_group_ix']][$rateGroupAmount['rt_rate_grp_amt_qty']]['amt'] + $rateGroupAmount['rateGroupTotal'] : 0;
		$rateGroupAmounts[$rateGroupAmount['rt_rate_group_ix']][$rateGroupAmount['rt_rate_grp_amt_qty']]['rt_rate_grp_amt_ix'] = $rateGroupAmount['rt_rate_grp_amt_ix'];
	}
	
	
	foreach ($totals as $rate_group_id => $total){
		if ($total['perc'] == 0 && $total['amt'] != 0){
			if (isset($rateGroupAmounts[$rate_group_id]) && is_array($rateGroupAmounts[$rate_group_id])){
				foreach($rateGroupAmounts[$rate_group_id] as $qty => $rateGroupAmount){
					if (($rateGroupAmount['amt'] / ($qty == 0 ? 1 : $qty)) != $total['amt']){
						// update amount
						rt_rate_grp_amt_delete($rateGroupAmount['rt_rate_grp_amt_ix']);
						rt_rate_grp_amt_insert($rateID, $rate_group_id, $qty, $total['amt'] * ($qty == 0 ? 1 : $qty));
						$result = false;
					}				
				}
			}
		}
	}
	
	return $result;
}

function getOverrideArray($rv_reservation_item_id='0'){
	global $lDB;

/*
	Expected structure of $overide
	
	"level"		=> "1",
	"amounts"	=> array(
		"stay"			=>	"500.00",
		"rate_group"	=>	array(
			"RS1"	=>	"450.00",
			"RS2"	=>	"350.00",
			"RS3"	=>	"300.00"
		)
	)
*/	
	$overrideArray = array(
		"level"		=> "",
		"amounts"	=> array(
			"stay" => "",
			"rate_group" => array(
			)
		)
	);
		
	if ($rv_reservation_item_id != '0'){
		$itemOverride = $lDB->get("
			SELECT
				rv_item_overide_level_ind,
				rv_item_overide_amt
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
		",1);
		
		$overrideArray['level'] = $itemOverride['rv_item_overide_level_ind'];
		
		switch($overrideArray['level']){
			case 1:
			case 2:
				$itemOverride =  $lDB->get("
					SELECT
						rv_res_item_rate_grp.rt_rate_group_id,
						rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt
					FROM
						rv_res_item_rate_grp
					WHERE
						rv_res_item_rate_grp.rv_reservation_item_id = '$rv_reservation_item_id'
				",2);
				foreach($itemOverride as $rateGroup){
					$overrideArray['amounts']['rate_group'][$rateGroup['rt_rate_group_id']] = $rateGroup['rv_res_item_rate_grp_overide_amt'];		
				}
				break;
			case 3:
				$overrideArray['amounts']['stay'] = $itemOverride['rv_item_overide_amt'];
				break;
			default:
				
		}
	}

	return $overrideArray;
	
}

function explodeOrides($overrideString){
// level:1|stay:|RS2:250|RS4:|RS3:|

	$overrideArray = array(
		"level"		=> "",
		"amounts"	=> array(
			"stay" => "",
			"rate_group" => array(
			)
		)
	);

	$pipeExplode = explode("|", $overrideString);

	foreach ($pipeExplode as $orideGroupString){
		$colonExplode = array_pad(explode(":",$orideGroupString),2,"");
		
		switch($colonExplode[0]){
			case "level":
				$overrideArray['level'] = $colonExplode[1];
				break;
			case "stay":
				$overrideArray['amounts']['stay'] = $colonExplode[1];
				break;
			default:
				if ($colonExplode[0] != "") {
					$overrideArray['amounts']['rate_group'][$colonExplode[0]] = $colonExplode[1];
				}
		}
		
	}
	
	return $overrideArray;
}

// Checks whether a rate group on a component has 100% percentage split (can therefore override)
function checkRateGroupOverride($rateID, $rateGroupID){

	$compSplits = getRateComponentSplits($rateID, $rateGroupID);
	$percTotal = 0;
	foreach($compSplits as $compSplit){
		if ($compSplit['rt_comp_opt_yn'] == 0){
			$percTotal += $compSplit['rt_rate_comp_perc'];
		}
	}
	
	if ($percTotal == 100){
		return true;
	} else {
		return false;
	}

}

function getRateTypeDesc($rt_rate_type_id){
	global $lDB;
	
	$rt_rate_type_desc = $lDB->get("
		SELECT 
			rt_rate_type_desc
		FROM
			rt_rate_type
		WHERE
			rt_rate_type.rt_rate_type_ix = '$rt_rate_type_id'
	",4);

	if ($rt_rate_type_desc != ""){
		return $rt_rate_type_desc;	
	} else {
		return "";
	}
}

function getRateGroupDesc($rt_rate_group_id){
	global $lDB;
	
	$rt_rate_group = $lDB->get("
		SELECT 
			rt_rate_group_desc,
			rt_rate_group_abbrv
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_ix = '$rt_rate_group_id'
	",1);

	if (!empty($rt_rate_group)){
		return $rt_rate_group;	
	} else {
		return "";
	}
}
