<?php

require_once(__DIR__ . "/functions.csv.php");
function getDocPropNotes($reservationId) {
	global $lDB;

	$propNotes = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_name_last,
			pr_business.pr_bus_memo_info
		FROM
			rv_reservation_item
			LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			LEFT JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$reservationId'
	",2);
	$noteOut = "";
	foreach($propNotes as $note) {
		if(trim($note['pr_bus_memo_info']) != "") {
			$noteOut .= nl2br($note['pr_name_last'] . ": " . $note['pr_bus_memo_info']);
		}
	}

	return trim($noteOut);
}


function getBankDetails($reservationId) {
	global $lDB;

	$bank = $lDB->get("
		SELECT DISTINCT
			rf_bank.rf_bank_name,
			rf_bank.rf_bank_acc_name,
			rf_bank.rf_bank_acc_no,
			rf_bank.rf_bank_detail_1,
			rf_bank.rf_bank_detail_2,
			rf_bank.rf_bank_detail_3
		FROM
			rv_reservation_item
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN pr_bus_bank ON pr_bus_bank.pr_business_id = ac_accomm_type.pr_business_id
			INNER JOIN rf_bank ON rf_bank.rf_bank_ix = pr_bus_bank.rf_bank_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$reservationId'
		ORDER BY
			rv_reservation_item.rv_item_date_arrive
		LIMIT 1
	",1);

	if ($bank['rf_bank_name'] != "") { $out .= "<b>Bank Name</b>:<br>"."&nbsp;".$bank['rf_bank_name']."<br>"; }
	if ($bank['rf_bank_acc_name'] != "") { $out .= "<b>Account Name</b>:<br>"."&nbsp;".$bank['rf_bank_acc_name']."<br>"; }
	if ($bank['rf_bank_acc_no'] != "") { $out .= "<b>Account Number</b>:<br>"."&nbsp;".$bank['rf_bank_acc_no']."<br>"; }
	if ($bank['rf_bank_detail_1'] != "") { $out .= "<b>Details</b>: <br>"."&nbsp;".$bank['rf_bank_detail_1']."<br>"; }
	if ($bank['rf_bank_detail_2'] != "") { $out .= "&nbsp;".$bank['rf_bank_detail_2']."<br>"; }
	if ($bank['rf_bank_detail_3'] != "") { $out .= "&nbsp;".$bank['rf_bank_detail_3']."<br>"; }

	if ($out == "") {
		$out = "Please contact the reservations office for bank account details.";
	}
	return $out;
}

function getAccommRateData($reservationId,$folioId=false) {
	global $lDB;

	if($folioId === false) {
		$sqlWhere = "
			rv_reservation_id = '$reservationId'
		";
	} else {
		$sqlWhere = "
			fn_folio_id = '$folioId'
		";
	}
	$rv_commission_deduct_yn = $lDB->get("SELECT rv_commission_deduct_yn FROM rv_reservation WHERE rv_reservation_ix = '$reservationId'",4);
	$itemList = $lDB->get("
		SELECT
			rv_reservation_item_ix
		FROM
			rv_reservation_item
		WHERE
			$sqlWhere
		ORDER BY
			rv_item_date_arrive,
			rv_item_date_depart,
			pr_business_id,
			ac_accomm_type_id
	",3);
	$resDataRay = array();
	$resItem = "";
	foreach($itemList as $reservationItemId){
		if (!isset($resItem) || !is_array($resItem)) {
			$resItem = getItemDetails($reservationItemId);
		}
		$resItem['rv_reservation_item_ix'] = $reservationItemId;
		$resItem['date_arrive'] = chng_date($resItem['rv_item_date_arrive'],"-");
		$resItem['date_depart'] = chng_date($resItem['rv_item_date_depart'],"-");

		$roomRateGroupTotal = 0;
		$adultRateGroupTotal = 0;
		$childRateGroupTotal = 0;
		$itinerary = new Itinerary();
		$itinerary->SetReservationItemId($reservationItemId);
		$itineraryArray = $itinerary->ToArray();
		$resItemCosts = $itineraryArray['components'];
		$rateGroupAmtsArray = array();
		$rateGroupQtyArray = array();

		// Get Unit Rate Group
		$unitRateGroup = $lDB->get("
			SELECT
				rt_rate_group_ix
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 1
		",4);

		// Get SysCode Adult Rate Group
		$sysCodeAdultRateGroup = $lDB->get("
			SELECT
				rt_rate_group_ix
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 2
		",4);

		// Get SysCode Child Rate Group
		$sysCodeChildRateGroup = $lDB->get("
			SELECT
				rt_rate_group_ix
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 3
		",4);

		foreach($resItemCosts as $comp) {
			$roomRateGroupTotal += $lDB->get("
				SELECT
					SUM(rv_item_comp_rate_grp_amt_payable)
				FROM
					rv_res_item_comp_rate_grp
					INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_comp_rate_grp.rt_rate_group_id
				WHERE
					rt_rate_group.rt_rate_group_ix = '$unitRateGroup'
					AND rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$comp['rv_res_item_comp_id']."'

			",4);

			// Get individual rate group payable amounts
			foreach ($comp['rate_groups'] as $rateGroupId => $rateGroupDetail){
				if (!isset($rateGroupAmtsArray[$rateGroupId])) { $rateGroupAmtsArray[$rateGroupId] = 0; }
				$rateGroupAmtsArray[$rateGroupId] += $lDB->get("
					SELECT
						rv_item_comp_rate_grp_amt_payable
					FROM
						rv_res_item_comp_rate_grp
						INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_comp_rate_grp.rt_rate_group_id
					WHERE
						rt_rate_group.rt_rate_group_ix = '$rateGroupId'
						AND rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$comp['rv_res_item_comp_id']."'
				",4);
			}

		}

		// Get rate group quantities
		$itinRateGroups = $lDB->get("
			SELECT
				rv_res_item_rate_grp.rt_rate_group_id,
				rv_res_item_rate_grp.rv_res_item_rate_grp_count
			FROM
				rv_res_item_rate_grp
			WHERE
				rv_res_item_rate_grp.rv_reservation_item_id = '".$reservationItemId."'
		",2);

		foreach ($itinRateGroups as $itinRateGroup){
			$rateGroupQtyArray[$itinRateGroup['rt_rate_group_id']] = $itinRateGroup['rv_res_item_rate_grp_count'];
		}


		$resItem = array_merge($resItem,getTotalItemCost($resItemCosts));
		$grandTotal = array_sum($rateGroupAmtsArray);
		if ($grandTotal != $resItem['compAmt']) {
			$resItem['compAmt'] = $grandTotal;
		}

		$nights = $resItem['noNights'];
		if (!isset($rateGroupQtyArray[$sysCodeAdultRateGroup]) || $rateGroupQtyArray[$sysCodeAdultRateGroup] == "") {
			$rateGroupQtyArray[$sysCodeAdultRateGroup] = 0;
		}

		if (!isset($rateGroupQtyArray[$sysCodeChildRateGroup]) || $rateGroupQtyArray[$sysCodeChildRateGroup] == "") {
			$rateGroupQtyArray[$sysCodeChildRateGroup] = 0;
		}

		$resItem['sysCodeAdultCount'] = $rateGroupQtyArray[$sysCodeAdultRateGroup];
		$resItem['sysCodeChildCount'] = $rateGroupQtyArray[$sysCodeChildRateGroup];
		$rooms = $resItem['rv_item_accomm_count'];
		if ($resItem['noNights'] == "0") { $nights = "1"; }
		if ($resItem['rv_item_accomm_count'] == "0") { $rooms = "1"; }

		$resItem['roomTotal2'] = "0";
		if ($roomRateGroupTotal != 0) {
			$resItem['roomTotal2'] = $roomRateGroupTotal / $nights / $rooms;
		}

		// Sys code Adult / Child row
		$resItem['adultTotal2'] = "0";
		$resItem['childTotal2'] = "0";

		if ($resItem['rv_item_overide_level_ind'] == 3 && $resItem['rv_item_overide_amt'] != ""){
			// Per stay override
			$resItem['adultTotal2'] = "N/A";
			$resItem['childTotal2'] = "N/A";
			$resItem['roomTotal2'] = "N/A";
		} else {
			if (isset($rateGroupAmtsArray[$sysCodeAdultRateGroup]) && $rateGroupAmtsArray[$sysCodeAdultRateGroup] != 0) {
				if(isset($rateGroupQtyArray[$sysCodeAdultRateGroup]) && $rateGroupQtyArray[$sysCodeAdultRateGroup] != 0) {
					$resItem['adultTotal2'] = $rateGroupAmtsArray[$sysCodeAdultRateGroup] / $nights / $rooms / $rateGroupQtyArray[$sysCodeAdultRateGroup];
				} else {
					$resItem['adultTotal2'] = 0;
				}
			}

			if(isset($rateGroupAmtsArray[$sysCodeChildRateGroup]) && $rateGroupAmtsArray[$sysCodeChildRateGroup] != 0) {
				if(isset($rateGroupQtyArray[$sysCodeChildRateGroup]) && $rateGroupQtyArray[$sysCodeChildRateGroup] != 0) {
					$resItem['childTotal2'] = $rateGroupAmtsArray[$sysCodeChildRateGroup] / $nights / $rooms / $rateGroupQtyArray[$sysCodeChildRateGroup];
				} else {
					$resItem['childTotal2'] = 0;
				}
			}
		}
		// Additional rate groups
		$resItem['add_rate_groups'] = array();
		foreach ($rateGroupAmtsArray as $rateGroupId => $amount){
			if ($rateGroupId != $unitRateGroup && $rateGroupId != $sysCodeAdultRateGroup && $rateGroupId != $sysCodeChildRateGroup){
				$resItem['add_rate_groups'][$rateGroupId] = array();
				$resItem['add_rate_groups'][$rateGroupId]['adultCount'] = "&nbsp;";
				$resItem['add_rate_groups'][$rateGroupId]['childCount'] = "&nbsp;";
				$resItem['add_rate_groups'][$rateGroupId]['adultAmount'] = "&nbsp;";
				$resItem['add_rate_groups'][$rateGroupId]['childAmount'] = "&nbsp;";
				$rateGroupInfo = $lDB->get("
					SELECT
						rt_rate_group_abbrv,
						rt_rate_group_class
					FROM
						rt_rate_group
					WHERE
						rt_rate_group.rt_rate_group_ix = '$rateGroupId'
				",1);
				$resItem['add_rate_groups'][$rateGroupId]['groupAbbrv'] = $rateGroupInfo['rt_rate_group_abbrv'];

				switch($rateGroupInfo['rt_rate_group_class']){
					case 1:
						if ($resItem['rv_item_overide_level_ind'] == 3 && $resItem['rv_item_overide_amt'] != ""){
							$resItem['add_rate_groups'][$rateGroupId]['adultAmount'] = "N/A";

						} else {
							$resItem['add_rate_groups'][$rateGroupId]['adultAmount'] = $amount / $nights / $rooms / $rateGroupQtyArray[$rateGroupId];
							fixAmtDisplay($resItem['add_rate_groups'][$rateGroupId]['adultAmount']);
						}
						$resItem['add_rate_groups'][$rateGroupId]['adultCount'] = $rateGroupQtyArray[$rateGroupId];
						break;
					case 2:
						if ($resItem['rv_item_overide_level_ind'] == 3 && $resItem['rv_item_overide_amt'] != ""){
							$resItem['add_rate_groups'][$rateGroupId]['childAmount'] = "N/A";
						} else {
							$resItem['add_rate_groups'][$rateGroupId]['childAmount'] = $amount / $nights / $rooms / $rateGroupQtyArray[$rateGroupId];
							fixAmtDisplay($resItem['add_rate_groups'][$rateGroupId]['childAmount']);
						}
						$resItem['add_rate_groups'][$rateGroupId]['childCount'] = $rateGroupQtyArray[$rateGroupId];
						break;
				}

			}
		}

		$resItem['rateAmt'] = (string) $resItem['rateAmt'];

		if ($resItem['rateAmt'] === "TBA") {
			$resItem['rateAmt'] = "TBA";
			$resItem['compAmt'] = "TBA";
			$resItem['commAmt'] = "TBA";
			$resItem['taxAmt'] = "TBA";
			$resItem['discAmt'] = "TBA";
			$resItem['rf_currency_symbol'] = "";
		} else {
			$resItem['compAmt'] = (string) $resItem['compAmt'];
			$resItem['commAmt'] = (string) $resItem['commAmt'];
			$resItem['taxAmt'] = (string) $resItem['taxAmt'];
			$resItem['discAmt'] = (string) $resItem['discAmt'];
		}

		$resItem['compAmt'] = getDisplayItemTotal($reservationItemId);
		fixAmtDisplay($roomRateGroupTotal);
		fixAmtDisplay($adultRateGroupTotal);
		fixAmtDisplay($childRateGroupTotal);
		if (is_numeric($resItem['roomTotal2'])){
			$resItem['roomTotal2'] = round($resItem['roomTotal2'],2);
			fixAmtDisplay($resItem['roomTotal2']);
		}
		if (is_numeric($resItem['adultTotal2'])){
			$resItem['adultTotal2'] = round($resItem['adultTotal2'],2);
			fixAmtDisplay($resItem['adultTotal2']);
		}
		if (is_numeric($resItem['childTotal2'])){
			$resItem['childTotal2'] = round($resItem['childTotal2'],2);
			fixAmtDisplay($resItem['childTotal2']);
		}
		fixAmtDisplay($resItem['rateAmt']);
		fixAmtDisplay($resItem['compAmt']);
		fixAmtDisplay($resItem['commAmt']);
		fixAmtDisplay($resItem['taxAmt']);
		fixAmtDisplay($resItem['discAmt']);

		array_push($resDataRay,$resItem);
		unset($resItem);
	}
	return $resDataRay;
}

function getTravelDetails($reservationId,$folioId=false,$propertyDetail=false,$nonPropertyDetail=false,$propertyFilter=false) {
	return getExtraDetails($reservationId,2,$folioId,$propertyDetail,$nonPropertyDetail,$propertyFilter);
}

# DEBUG - Function duplicated in inc.functions_rh.php
function getExtraDetails($reservationId,$catInd='0',$folioId=false,$propertyDetail=false,$nonPropertyDetail=false,$propertyFilter=false) {
	if($folioId === false) {
		$sqlWhere = "
			rv_extra.rv_reservation_id = '$reservationId'
		";
	} else {
		$sqlWhere = "
			rv_extra.fn_folio_id = '$folioId'
		";
	}
	$invCurr = getInvCurr($reservationId);
	$index = "= $catInd";
	$sqlFilter = "";
	if($propertyDetail == "1" && $nonPropertyDetail != "1") {

		$sqlFilter = "
			AND rv_extra.pr_business_id IN ('".join("','",explode(":",$propertyFilter['ids']))."')
		";
	}
	if($propertyDetail != "1" && $nonPropertyDetail == "1") {
		$sqlFilter = "
			AND pr_persona.pr_persona_ix IS NULL
		";
	}
	if($propertyDetail == "1" && $nonPropertyDetail == "1") {
		$sqlFilter = "
			AND (
				rv_extra.pr_business_id IN ('".join("','",explode(":",$propertyFilter['ids']))."')
				OR pr_persona.pr_persona_ix IS NULL
			)
		";
	}

	$sql="
		SELECT
			pr_persona.pr_name_last,
			ac_extra.ac_ext_desc,
			rf_currency.rf_currency_symbol,
			rv_extra.rf_currency_id,
			rv_extra.rv_extra_units,
			rv_extra.rv_extra_travel_eta,
			rv_extra.rv_extra_travel_etd,
			rv_extra.rv_extra_supplier_conf_yn,
			rv_extra.pr_supplier_id,
			rv_extra.pr_business_id,
			rv_extra.rv_extra_ref,
			rv_extra.rv_extra_trf_yn,
			CONCAT_WS(' ',pr_extra_supplier.pr_name_first,pr_extra_supplier.pr_name_last) AS supplier_name,
			rv_extra.rv_extra_charge,
			rv_extra.rv_extra_discount,
			rv_extra.rv_extra_tax_perc,
			rv_extra.rv_extra_comm_pay,
			rv_extra.rv_extra_exch_rate,
			rv_extra.rv_extra_exch_expiry,
			rv_extra.rv_extra_date_serv,
			rv_extra.rv_extra_ind,
			rv_extra.rv_extra_date_serv,
			rv_extra.rv_reservation_id,
			rv_extra.ac_extra_id,
			rv_extra.rv_extra_ix as rv_extra_id,
			ac_extra_category.ac_extra_cat_desc,
			ac_accomm_room.ac_desc,
			rv_extra.rv_res_item_group_id,
			rv_extra.rv_extra_note,
			rv_extra.rv_extra_note_internal,
			rv_extra.rv_extra_adult_count,
			rv_extra.rv_extra_child_count,
			rv_extra.rv_extra_nights,
			rv_extra.rv_extra_date_depart,
			rv_extra.rv_extra_amt_payable as total,
            ac_extra_category.ac_extra_cat_ind
		FROM
			rv_extra
			LEFT JOIN pr_persona ON rv_extra.pr_business_id = pr_persona.pr_persona_ix
			LEFT JOIN ac_extra ON rv_extra.ac_extra_id = ac_extra.ac_extra_ix
			LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_extra.rv_extra_inv_curr_id
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			LEFT JOIN pr_persona AS pr_extra_supplier ON pr_extra_supplier.pr_persona_ix = rv_extra.pr_supplier_id
		WHERE
			$sqlWhere
			$sqlFilter
			AND rv_extra.rv_extra_ind $index
			AND rv_extra.rv_extra_void_ind = '0'
		ORDER BY
			rv_extra.rv_extra_date_serv
	";

	$resExtra = $GLOBALS['lDB']->get($sql,2);
	for ($i=0;$i<sizeof($resExtra);$i++){
		$resExtra[$i]['date_service'] = chng_date($resExtra[$i]['rv_extra_date_serv'],"-");
		$resExtra[$i]['date_depart'] = chng_date($resExtra[$i]['rv_extra_date_depart'],"-");
		if($resExtra[$i]['rv_extra_ind'] == 2) {
			$resExtra[$i]['travel_type'] = "Travel";
		} else {
			$resExtra[$i]['travel_type'] = "Unknown";
		}
		fixAmtDisplay($resExtra[$i]['total']);
		fixAmtDisplay($resExtra[$i]['rv_extra_charge']);
		fixAmtDisplay($resExtra[$i]['rv_extra_discount']);
		fixAmtDisplay($resExtra[$i]['rv_extra_tax_perc']);
		fixAmtDisplay($resExtra[$i]['rv_extra_comm_pay']);
		$guestList = array();
		if (!empty($resExtra[$i]['rv_res_item_group_id'])) {
			$guestList = $GLOBALS['lDB']->get("
				SELECT
					pr_persona.pr_name_last,
					pr_persona.pr_name_first
				FROM
					rv_res_item_guest
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
				WHERE
					rv_res_item_guest.rv_res_item_group_id = '".$resExtra[$i]['rv_res_item_group_id']."'
			",2);
		}
		$guestNames = "";
		foreach($guestList as $guestItem) {
			$name = trim($guestItem['pr_name_first'] . " " . $guestItem['pr_name_last']);
			if($guestNames != "") {
				$guestNames .= ", ";
			}
			$guestNames .= $name;
		}
		$resExtra[$i]['guestNames'] = $guestNames;
		$roomDetails = "";
		if(trim($resExtra[$i]['ac_desc']) != "" ) {
			$roomDetails .= $resExtra[$i]['ac_desc'];
		}
		if(trim($guestNames) != "" ) {
			if(trim($roomDetails) != "") {
				$roomDetails .= ": ";
			}
			$roomDetails .= $guestNames;
		}
		$resExtra[$i]['roomDetails'] = $roomDetails;
		if($resExtra[$i]['rf_currency_id'] == "0" || trim($resExtra[$i]['rf_currency_id']) == "") {
			$resExtra[$i]['total'] = "";
			$resExtra[$i]['rf_currency_symbol'] = "";
		}
	}
	return $resExtra;
}

function getReservationNote($reservationId) {
	$note = $GLOBALS['lDB']->get("SELECT rv_note_general FROM rv_reservation WHERE rv_reservation_ix = '$reservationId'",4);
	if (trim($note) == "" || $note == "0"){
		return "FALSE";
	} else {
		return $note;
	}
}

function getReservationHeader($reservationId){
	$sql="
		SELECT
			rv_reservation.rv_corr_persona_id,
			rv_reservation.rv_billing_persona_id,
			rv_reservation.rv_res_name,
			rv_reservation.rv_agent_ref,
			rv_reservation.rv_reservation_ix as rv_reservation_id,
			rf_reservation_status.rf_reservation_status_desc,
			rv_reservation.rv_date_recorded,
			rv_reservation.rv_date_changed,
			ac_pay_plan.ac_pay_plan_desc,
			rt_rate_type.rt_rate_type_desc,
			rf_reservation_status.rf_reservation_status_id,
			rv_reservation.rv_consultant_id,
			rv_reservation.rv_provision_expiry_date
		FROM
			rv_reservation
			LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			LEFT JOIN ac_pay_plan ON ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id
			LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
		WHERE
			rv_reservation_ix = '$reservationId'
	";

	$resData = $GLOBALS['lDB']->get($sql,1);

	$resData['rv_contact'] = getContactFullName($resData['rv_corr_persona_id']);
	($resData['rv_billing_persona_id'] != "0") ? $rv_attention_id = $resData['rv_billing_persona_id']: $rv_attention_id = $resData['rv_contact'];
	$resData['rv_attention'] = getContactFullName($rv_attention_id);
	$resData['rv_date_recorded'] = chng_date($resData['rv_date_recorded'],"-");
	$resData['rv_date_changed'] = chng_date($resData['rv_date_changed'],"-");

	$temp = getFwdPersonaContactDetails($resData['rv_corr_persona_id']);
	$resData = array_merge($resData,$temp);

	if($resData['rv_consultant_id'] == "0" || trim($resData['rv_consultant_id']) == "") {
		$resData['rf_reservation_status_desc'] .= " (Request)";
	}
	if($resData['rf_reservation_status_id'] == 20){
		$resData['rf_reservation_status_desc'] .= " (Expires: ".chng_date($resData['rv_provision_expiry_date'],"-").")";
	}
	return $resData;
}

function getDocTitle($reservationId) {
	$cancelClass = "collapse";
	$resData = $GLOBALS['lDB']->get("select rf_reservation_status_id, rv_cancel_reason from rv_reservation where rv_reservation_ix = '$reservationId'",1);
	($resData[0] >= 20) ? $docTitle = $GLOBALS['lDB']->get("select rf_proforma_title from rf_default",4) : $docTitle = "Quotation";
	if($resData[0] == "90") { $docTitle = "Cancellation"; $cancelClass = "expand"; }
	if($docTitle == "") { $docTitle = "Proforma"; }
	$cancelNote = nl2br(trim($resData[1]));

	return array("docTitle" => $docTitle, "cancelNote" => $cancelNote, "cancelClass" => $cancelClass);
}

function getPerPerson($resItems) {
	global $lDB;

	$rt_rate_group_unit_id = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group.rt_rate_group_sys_code = 1",4);
	$perPersonItems = [];
	foreach($resItems as $rv_reservation_item) {
		$rate_groups = array_reduce($lDB->get("
			SELECT
				rt_rate_group.rt_rate_group_ix AS id,
				rt_rate_group.rt_rate_group_desc AS name,
				rt_rate_group.rt_rate_group_sys_code AS sys_code,
				rv_res_item_rate_grp.rv_res_item_rate_grp_count AS qty
			FROM
				rv_res_item_rate_grp
				INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_rate_grp.rt_rate_group_id
			WHERE
				rv_res_item_rate_grp.rv_reservation_item_id = '" . $lDB->escape($rv_reservation_item['rv_reservation_item_ix']) . "'
		",6), function($groups, $item) {
			$groups[$item['id']] = $item;
			return $groups;
		},[]);


		$total_per_night = 0;
		$rate_groups = array_reduce($lDB->get("
			SELECT
				rv_res_item_comp_rate_grp.rt_rate_group_id AS id,
				SUM(rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_nett) AS nett
			FROM
				rv_res_item_comp
				INNER JOIN rv_res_item_comp_rate_grp ON rv_res_item_comp_rate_grp.rv_res_item_comp_id = rv_res_item_comp.rv_res_item_comp_ix
			WHERE
				rv_res_item_comp.rv_reservation_item_id = '" . $lDB->escape($rv_reservation_item['rv_reservation_item_ix']) . "'
			GROUP BY
				rv_res_item_comp_rate_grp.rt_rate_group_id
		",6), function($groups, $item)  use ($rv_reservation_item, $rt_rate_group_unit_id, &$total_per_night) {
			$rt_rate_group_id = $item['id'];

			$groups[$rt_rate_group_id]['nett'] = $item['nett'];
			if($groups[$rt_rate_group_id]['qty'] != 0 && $rv_reservation_item['noNights'] != 0) {
				$per_person = $item['nett'] / $groups[$rt_rate_group_id]['qty'] / $rv_reservation_item['noNights'];
			} else {
				$per_person = 0;
			}
			if($groups[$rt_rate_group_id]['sys_code'] != 1) { // not the unit rate group
				if (isset($groups[$rt_rate_group_unit_id]['qty']) && $groups[$rt_rate_group_unit_id]['qty'] != 0) {
					$per_person /= $groups[$rt_rate_group_unit_id]['qty'];
				} else {
					$per_person = 0;
				}
			}

			$per_person = round($per_person,2);
			fixAmtDisplay($per_person);
			$groups[$rt_rate_group_id]['per_person'] = $per_person;

			$per_night = $per_person * $groups[$rt_rate_group_id]['qty'];
			$total_per_night += $per_night;
			fixAmtDisplay($per_night);
			$groups[$rt_rate_group_id]['per_night'] = $per_night;

			return $groups;
		}, $rate_groups);
		
		$hasTBA = false;
		$rate_groups = array_map(function($rate_group) use (&$hasTBA) {
			if(!array_key_exists("nett", $rate_group)) {
				$rate_group['nett'] = "TBA";
				$rate_group['per_person'] = "TBA";
				$rate_group['per_night'] = "TBA";
				$hasTBA = true;
			}
			return $rate_group;
		}, $rate_groups);
		if(!$hasTBA) {
			$total_per_night = round($total_per_night,2);
			fixAmtDisplay($total_per_night);
		} else {
			$total_per_night = "TBA";
		}

		$perPersonItems[] = [
			'date_arrive'=>$rv_reservation_item['date_arrive'],
			'date_depart'=>$rv_reservation_item['date_depart'],
			'pr_name_last'=>$rv_reservation_item['pr_name_last'],
			'ac_accomm_desc'=>$rv_reservation_item['ac_accomm_desc'],
			'nights'=>$rv_reservation_item['noNights'],
			'rv_item_accomm_count'=>$rv_reservation_item['rv_item_accomm_count'],
			'rv_item_adult_count'=>$rv_reservation_item['rv_item_adult_count'],
			'rv_item_child_count'=>$rv_reservation_item['rv_item_child_count'],
			'rate_groups'=>$rate_groups,
			'total_per_night'=>$total_per_night
		];
	}
	return $perPersonItems;
}

function useFilter($prefix,$itemList,$selectName,$whereName, $includeList, $emptyLabel=false, $emptyWhere=false, $emptyNull=false) {
	global $lDB;
	global $temp;

	$itemArray = explode(":",$itemList);

	$emptyEnabled = true;
	if($emptyLabel === false || $emptyWhere === false) {
		$emptyEnabled = false;
	}

	$matchInclude = false;
	if($includeList !== false) {
		$itemArray = array_intersect($itemArray,$includeList);
		sort($includeList);
		sort($itemArray);

		if($itemArray === $includeList) {
			$matchInclude = true;
		}
	}

	if(trim($itemList) == "" || sizeof($itemArray) == 0 || $matchInclude) {
		$where = "";
		$ids = "";
		if($includeList !== false) {
			$ids = join(":",$includeList);
			if(!$emptyEnabled || !in_array($emptyWhere,$includeList)) {
				$where = " AND " . $whereName . " IN ('".join("','",$includeList)."') ";
			} else {
				array_push($includeList,"");
				array_push($includeList,$emptyWhere);
				if(!$emptyNull) {
					$where = " AND " . $whereName . " IN ('".join("','",$includeList)."') ";
				} else {
					$where = "
						AND (
							" . $whereName . " IN ('".join("','",$includeList)."')
							OR $whereName IS NULL
						)
					";
					$ids .= ":NULL";
				}
			}
		}
		$temp[$prefix . "Ids"] = '<input type="hidden" id="'.$prefix.'Ids" name="'.$prefix.'Ids" value="'.$ids.'">';
		$temp[$prefix . "Names"] = "All";
		return array('ids'=>$ids, 'names'=>"All", 'where'=>$where, 'all'=>true);
	}

	if(!in_array($emptyWhere,$itemArray,true)) {
		$emptyEnabled = false;
	}

	$nameList = "";
	$addNull = false;
	if($emptyEnabled) {
		if( (!($includeList === false) && in_array($emptyWhere,$includeList)) || ($includeList === false) ) {
			array_push($itemArray,"");
			array_push($itemArray,$emptyWhere);
			$nameList .= $emptyLabel;
			if($emptyNull) {
				$addNull = true;
			}
		}
	}

	if(!$addNull) {
		$whereList = " AND " . $whereName . " IN ('".join("','",$itemArray)."') ";
	} else {
		$whereList = "
			AND (
				$whereName IN ('".join("','",$itemArray)."')
				OR $whereName IS NULL
			)";
	}
	foreach($itemArray as $item) {
		if($item !== $emptyWhere && $item != "") {
			$nameArray = $lDB->get($selectName . "'" . $item . "'",1);

			$name = "";
			if (is_array($nameArray)) {
				foreach($nameArray as $nameKey=>$nameItem) {
					if(!is_numeric($nameKey)) {
						$name .= $nameItem . " ";
					}
				}

				$name = trim($name);
				if($nameList != "") {
					$nameList .= ", ";
				}
				$nameList .= $name;
			}
		}
	}

	if(strlen($nameList) > 600) {
		$nameList = substr($nameList,0,600) . "... &#10;[Total records: ".(sizeof($itemArray))."]";
	}
	$temp[$prefix . "Ids"] = '<input type="hidden" id="'.$prefix.'Ids" name="'.$prefix.'Ids" value="'.$itemList.'">';
	$temp[$prefix . "Names"] = $nameList;
	return array('ids'=>$itemList, 'names'=>$nameList, 'where'=>$whereList, 'all'=>false);
}

function useDate($prefix,$date) {
	global $temp;
	if(trim($date) == "" || $date == "all") { $date = date("Y-m-d"); }
	$temp[$prefix . "Date"] = chng_date($date,"-");
	$dateArray = explode("-",$date);
	$temp[$prefix . "Y"] = $dateArray[0];
	$temp[$prefix . "M"] = $dateArray[1];
	$temp[$prefix . "D"] = $dateArray[2];
	return array('jsDate'=>$date, 'htmlDate'=>chng_date($date,"-"), 'dateArray'=>$dateArray);
}

function useDateRange($prefix,$dates) {
	if ($dates != "" && $dates != ":") {
		list($fromDate,$toDate) = explode(":",$dates);
	} else {
		$fromDate = "";
		$toDate = "";
	}
	$from = useDate($prefix . "From",$fromDate);
	$to = useDate($prefix . "To",$toDate);

	return array('from'=>$from, 'to'=>$to);
}

function getDefault($name) {
	return $GLOBALS['lDB']->get("SELECT $name FROM rf_default WHERE rf_default_id = '1'",4);
}

function getInvoiceDate() {
	return $GLOBALS['lDB']->get("SELECT rf_invoice_date FROM rf_default",4);
}

function setLastReport($url,$pf_option_id=false) {
	// Hack for filtering out double question marks, caused by an incorrect substr and strlen on getting
	// the argv parameters at the stat of each report. This is a general patch.
	$url = str_replace("reservation.php??", "reservation.php?", $url);
	$sessionList = array(
		'reportURL' => addslashes($url)
	);
	if($pf_option_id === false) {
		if(isset($_POST['pf_option_id'])) {
			$sessionList['reportProfile'] = $_POST['pf_option_id'];
		} else {
			$sessionList['reportProfile'] = "";
		}
	} else {
		$sessionList['reportProfile'] = $pf_option_id;
	}
	session_set($sessionList);
}

function setRecordScroll($records=array()) {
	session_set("resScrollSet",array_values($records));
}

function setContactScroll($records=array()) {
	session_set("conScrollSet",$records);
}

function importURL($name='url') {
	$_POST[$name] = isset($_POST[$name]) ? $_POST[$name] : "";
	if($_POST[$name] != "") {
		$_SERVER['argv'] = explode("+",explode("?", $_POST[$name])[1]);
		$_SERVER['argc'] = sizeof($_SERVER['argv']);
	}
	$GLOBALS['temp']['url'] = $_POST[$name];

	// Make the job id available to Javascript
	$GLOBALS['temp']['jobId'] = $_SERVER['argv'][0];
}

define("REP_VIEW_HTML",0);
define("REP_VIEW_PDF",1);
define("REP_EMAIL_PDF",2);
define("REP_SEND_PDF",3);
define("REP_VIEW_CSV",4);
define("REP_EMAIL_CSV",5);
define("REP_SEND_CSV",6);
define("REP_VIEW_OO",7);
define("REP_EMAIL_OO",8);
define("REP_SEND_OO",9);

define("REP_EMAIL_TEXT",10);
define("REP_SEND_TEXT",11);
define("REP_VIEW_CSV_GRID",12);
define("REP_VIEW_OO_GRID",13);
define("REP_VIEW_CSV_GRID_RAW",14);
define("REP_VIEW_CSV_FROM_XML",15);

function decodeRenderOption($renderOption) {
	switch ($renderOption) {
	case REP_VIEW_HTML:
		$renderMode = "html";
		$renderType = "";
		break;
	case REP_VIEW_PDF:
		$renderMode = "pdf";
		$renderType = "view";
		break;
	case REP_EMAIL_PDF:
		$renderMode = "pdf";
		$renderType = "email";
		break;
	case REP_SEND_PDF:
		$renderMode = "pdf";
		$renderType = "send";
		break;
	case REP_VIEW_CSV:
		$renderMode = "csv";
		$renderType = "view";
		break;
	case REP_EMAIL_CSV:
		$renderMode = "csv";
		$renderType = "email";
		break;
	case REP_SEND_CSV:
		$renderMode = "csv";
		$renderType = "send";
		break;
	case REP_VIEW_OO:
		$renderMode = "oofice";
		$renderType = "view";
		break;
	case REP_EMAIL_OO:
		$renderMode = "oofice";
		$renderType = "email";
		break;
	case REP_SEND_OO:
		$renderMode = "oofice";
		$renderType = "send";
		break;
	}
	return array($renderMode,$renderType);
}

function repOutputCSV($title,$csv) {
	csv_output($title,$csv);
}

$statusACL = $GLOBALS['lDB']->get("
	SELECT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id <> 25
		AND rf_reservation_status_id <> 15
		AND rf_reservation_status_id <> 97
",3);

$GLOBALS['repFilters'] = array(
	'agent'=>array(
		'selectName'=>"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =",
		'whereName'=>"rv_reservation.rv_agent_id",
		'includeList'=>false,
		'emptyLabel'=>"Direct booking",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Agent"
	),
	'agentPhysCountry'=>array(
		'selectName'=>"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =",
		'whereName'=>"agent_persona.pr_phys_country_id",
		'includeList'=>false,
		'emptyLabel'=>"No country",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Physical Country"
	),
	'agentPostCountry'=>array(
		'selectName'=>"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =",
		'whereName'=>"agent_persona.pr_corr_country_id",
		'includeList'=>false,
		'emptyLabel'=>"No country",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Postal Country"
	),
	'originatorPhysCountry'=>array(
		'selectName'=>"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =",
		'whereName'=>"originator_persona.pr_phys_country_id",
		'includeList'=>false,
		'emptyLabel'=>"No country",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Physical Country"
	),
	'originatorPostCountry'=>array(
		'selectName'=>"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =",
		'whereName'=>"originator_persona.pr_corr_country_id",
		'includeList'=>false,
		'emptyLabel'=>"No country",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Postal Country"
	),
	'agentRelationship'=>array(
		'selectName'=>"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =",
		'whereName'=>"rv_reservation.rv_agent_id",
		'includeList'=>false,
		'emptyLabel'=>"Direct booking",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Agent Relationship"
	),
	'createdBy'=>array(
		'selectName'=>"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =",
		'whereName'=>"rv_reservation.pr_reservation_user_id",
		'includeList'=>false,
		'emptyLabel'=>"No created by",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Created by"
	),
	'consultant'=>array(
		'selectName'=>"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =",
		'whereName'=>"rv_reservation.rv_consultant_id",
		'includeList'=>false,
		'emptyLabel'=>"No consultant",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Consultant"
	),
	'nationality'=>array(
		'selectName'=>"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =",
		'whereName'=>"rv_reservation.rf_country_id",
		'includeList'=>false,
		'emptyLabel'=>"No nationality",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Nationality"
	),
	'originator'=>array(
		'selectName'=>"SELECT pr_persona.pr_name_first, pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =",
		'whereName'=>"rv_reservation.rv_origin_agent_id",
		'includeList'=>false,
		'emptyLabel'=>"No originator",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Originator"
	),
	'source'=>array(
		'selectName'=>"SELECT rf_source.rf_source_desc FROM rf_source WHERE rf_source_ix =",
		'whereName'=>"rv_reservation.rf_source_ix",
		'includeList'=>false,
		'emptyLabel'=>"No Source",
		'emptyWhere'=>"0",
		'emptyNull'=>true,
		'label'=>"Source"
	),
	'paymentPlan'=>array(
		'selectName'=>"SELECT IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc) as nameLast FROM ac_pay_plan WHERE ac_pay_plan.ac_pay_plan_ix =",
		'whereName'=>"rv_reservation.ac_pay_plan_id",
		'includeList'=>false,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Payment plan"
	),
	'rate'=>array(
		'selectName'=>"SELECT rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix =",
		'whereName'=>"rv_reservation.rt_rate_type_id",
		'includeList'=>false,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Rate type"
	),
	'accomm'=>array(
		'selectName'=>"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =",
		'whereName'=>"rv_reservation_item.ac_accomm_type_id",
		'includeList'=>"
			SELECT DISTINCT
				ac_accomm_type.ac_accomm_type_ix
			FROM
				sc_accomm, ac_accomm_type
			WHERE
				sc_accomm.sc_group_id= '$GLOBALS[sc_group_id]'
				AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		",
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Prop / accomm",
		'type'=>"accomm"
	),
	'rateGroupSplit'=>array(
		'selectName'=>"SELECT rt_rate_group.rt_rate_group_desc FROM rt_rate_group WHERE rt_rate_group.rt_rate_group_ix =",
		'whereName'=>"rv_res_item_rate_grp.rt_rate_group_id",
		'includeList'=>false,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Rate group"
	),
	'rateComponent'=>array(
		'selectName'=>"SELECT rt_component.rt_component_desc FROM rt_component WHERE rt_component.rt_component_ix =",
		'whereName'=>"rv_res_item_comp.rt_component_id",
		'includeList'=>false,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Rate comp"
	),
	'folioContact'=>array(
		'selectName'=>"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =",
		'whereName'=>"fn_folio.fn_folio_to_id",
		'includeList'=>false,
		'emptyLabel'=>"Cash",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Debtor"
	),
	'server'=>array(
		'selectName'=>"SELECT rf_db_description FROM rf_database WHERE  rf_db_code=",
		'whereName'=>"fn_folio.fn_folio_db",
		'includeList'=>false,
		'emptyLabel'=>"Reservation Office",
		'emptyWhere'=>"Res",
		'emptyNull'=>false,
		'label'=>"Environment"
	),
	'serverAudit'=>array(
		'selectName'=>"SELECT rf_db_description FROM rf_database WHERE rf_db_code=",
		'whereName'=>"ad_reservation.ad_reservation_db",
		'includeList'=>false,
		'emptyLabel'=>"Reservation Office",
		'emptyWhere'=>"Res",
		'emptyNull'=>false,
		'label'=>"Environment"
	),
	'sourceAllActive'=>array(
		'selectName'=>"SELECT rf_db_code AS id, CONCAT(rf_db_description, '(', rf_db_code, ')) AS namelast FROM rf_database WHERE rf_db_code=",
		'whereName'=>"rf_database.rf_db_code",
		'includeList'=>false,
		'emptyLabel'=>"No server",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Environment"
	),
	'status'=>array(
		'selectName'=>"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =",
		'whereName'=>"rv_reservation.rf_reservation_status_id",
		'includeList'=>$statusACL,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Status"
	),
	'extra'=>array(
		'selectName'=>"SELECT ac_ext_desc FROM ac_extra WHERE ac_extra_ix =",
		'whereName'=>"ac_extra.ac_extra_ix",
		'includeList'=>false,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Extra"
	),
	'extraCategory'=>array(
		'selectName'=>"SELECT ac_extra_cat_desc  FROM ac_extra_category WHERE ac_extra_category_ix =",
		'whereName'=>"ac_extra.ac_extra_category_id",
		'includeList'=>false,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Extra category",
		'job'=>"753"
	),
	'currencies'=>array(
		'selectName'=>"SELECT rf_currency_name FROM rf_currency WHERE rf_currency_ix =",
		'whereName'=>"fn_folio.rf_currency_id",
		'includeList'=>false,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Currency"
	),
	'billingEntities'=>array(
		'selectName'=>"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) from pr_business INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id where pr_business.pr_bus_billing_yn = '1' AND pr_business.pr_business_id =",
		'whereName'=>"fn_folio.pr_business_id",
		'includeList'=>false,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Invoice from"
	),
	'agentCountry'=>array(
		'selectName'=>"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =",
		'whereName'=>"pr_persona.rf_country_id",
		'includeList'=>false,
		'emptyLabel'=>"No country",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Agent country"
	),
	'billingContact'=>array(
		'selectName'=>"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =",
		'whereName'=>"rv_reservation.rv_billing_persona_id",
		'includeList'=>false,
		'emptyLabel'=>"No billing contact",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Billing contact"
	),
	'ratePeriod'=>array(
		'selectName'=>"SELECT rt_period_desc FROM rt_period WHERE rt_period.rt_period_ix =",
		'whereName'=>"rt_period.rt_period_ix",
		'includeList'=>false,
		'emptyLabel'=>false,
		'emptyWhere'=>false,
		'emptyNull'=>false,
		'label'=>"Rate period"
	),
	'auditTrailModule'=>array(
		'selectName'=>"SELECT CONCAT(rf_audit_module_name, ' (', rf_audit_module_description_external, ')') FROM rf_audit_module WHERE rf_audit_module_id =",
		'whereName'=>"ad_module_field.rf_audit_module_id",
		'includeList'=>false,
		'emptyLabel'=>"No modules found",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Module"
	),
	'auditTrailField'=>array(
		'selectName'=>"SELECT CONCAT(ad_module_field_description, ' (', rf_audit_module_name, ')') FROM ad_module_field INNER JOIN rf_audit_module ON rf_audit_module.rf_audit_module_id = ad_module_field.rf_audit_module_id WHERE ad_module_field_id=",
		'whereName'=>"",
		'includeList'=>false,
		'emptyLabel'=>"",
		'emptyWhere'=>"",
		'emptyNull'=>false,
		'label'=>"Field"
	),
	'auditTrailUser'=>array(
		'selectName'=>"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =",
		'whereName'=>"ad_reservation.pr_user_id",
		'includeList'=>false,
		'emptyLabel'=>"No users found",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"User"
	),
	'auditTrailAction'=>array(
		'selectName'=>"SELECT act FROM ( SELECT 1 AS id, 'Add' AS act UNION SELECT 2 AS id, 'Edit' AS act UNION SELECT 3 AS id, 'Delete' AS act) AS act WHERE id =",
		'whereName'=>"ad_res_detail.ad_res_detail_action_ind",
		'includeList'=>false,
		'emptyLabel'=>"No actions found",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Action"
	),
	'specials'=>array(
		'selectName'=>"SELECT sp_special_desc FROM sp_special WHERE sp_special_ix =",
		'whereName'=>"sp_special.sp_special_ix",
		'includeList'=>false,
		'emptyLabel'=>"No specials found",
		'emptyWhere'=>'0',
		'emptyNull'=>false,
		'label'=>"Special"
	),
	'allocation'=>array(
		'selectName'=>"SELECT rv_reservation.rv_reservation_ix AS id, IF ( bl_block.bl_block_abbrev = '' OR bl_block.bl_block_abbrev IS NULL, rv_reservation.rv_res_name, CONCAT('Block (', bl_block.bl_block_abbrev, '): ', rv_reservation.rv_res_name)) AS namelast FROM rv_reservation LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id WHERE rv_reservation_ix =",
		'whereName'=>"rv_reservation.rv_reservation_ix",
		'includeList'=>false,
		'emptyLabel'=>"No allocation",
		'emptyWhere'=>"0",
		'emptyNull'=>false,
		'label'=>"Allocation"
	),
	/* NB NB NB
$serverFilter = useFilter("server",$_SERVER['argv'][3],"SELECT rf_db_description FROM rf_database WHERE  rf_db_code=","fn_folio.fn_folio_db",false,"Reservation Office","Res");
$resList = $GLOBALS['lDB']->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind = '2'",3);
$serverFilter[where] = str_replace("'Res'","'".join("','",$resList)."'",$serverFilter[where]);

	 */
);

// Compares colArg (ie. from a profile) with the current column list and add any additional fixed columns that may have been added
// since the profile was saved (for example, enhancements to the report in new version)
// Note: Custom columns are very much subject to change by the user so we only update fixed columns with this function
function updateFixedColArg($colArg, $cols, $customField){
	$cleanArgs = array();
	$fixedArg = array();
	$customArg = array();
	$fixedCols = array();
	$customCols = array();

	// Split fixed and custom columns from colArg
	if ($colArg != "") {
		foreach (explode(":",$colArg) as $item){
			$col = explode(",",$item);
			if (!isset($col[8]) || trim($col[8]) == ""){
				$fixedArg[] = $item;
			} else {
				$customArg[] = $item;
			}
		}
	}

	// Split fixed and custom columns
	foreach($cols as $item) {
		$item[$customField] = isset($item[$customField]) ? $item[$customField] : "";
		if (trim($item[$customField]) == ""){
			$fixedCols[] = $item;
		} else {
			$customCols[] = $item;
		}
	}

	// Add any missing new columns to colArg
	$count = 0;
	foreach ($fixedCols as $fixedCol){
		if (!isset($fixedArg[$count])) {
			$fixedArg[$count] = ",,,".$fixedCol['width'].",".$fixedCol['label'].",,l,,,";
		}
		$count++;
	}

	return join(":",array_merge($fixedArg, $customArg));
}
