<?php

require_once(__DIR__ . "/db.bl_block_period.php");

/**
 * getOrdinal() - Get the ordinal value of a number in "short hand" (e.g. "1st"; "2nd"; "3rd" etc.)
 * @param int $number
 * @return string
 **/
function getOrdinal($number) {
	// Fix bug "Class 'NumberFormatter' not found" on freebsd server
	//$nf = new NumberFormatter("en", NumberFormatter::ORDINAL);
	//return $nf->format($number);
	switch ($number) {
		case 1:
			return "1st";
			break;
		case 2:
			return "2nd";
			break;
		case 3:
			return "3rd";
			break;
		case 4:
			return "4th";
			break;
		case 5:
			return "5th";
			break;
		case 6:
			return "6th";
			break;
		case 7:
			return "7th";
			break;
		case 8:
			return "8th";
			break;
		case 9:
			return "9th";
			break;
		case 10:
			return "10th";
			break;
		default:
			return $number;
			break;
	}
}

/**
 * formatValue() - Formats values for display. If format isn't found, returns the original value
 * @param string $value
 * @param string $format
 * @return string
 **/
function formatValue($value, $format) {
	switch ($format) {
		case 'date':
			return chng_date($value,"-");
			break;
		case 'datetime':
			return chng_date($value,"-",5);
			break;
		default:
			return $value;
			break;
	}
}

/**
 * getWeekdayShortName() - Gets the short name description of a weekday
 * @param int $weekDayNumber
 * @return string
 **/
function getWeekdayShortName($weekDayNumber) {
	switch ($weekDayNumber) {
		case DB_BL_MONDAY:
			return "Mon";
			break;
		case DB_BL_TUESDAY:
			return "Tue";
			break;
		case DB_BL_WEDNESDAY:
			return "Wed";
			break;
		case DB_BL_THURSDAY:
			return "Thu";
			break;
		case DB_BL_FRIDAY:
			return "Fri";
			break;
		case DB_BL_SATURDAY:
			return "Sat";
			break;
		case DB_BL_SUNDAY:
			return "Sun";
			break;
		default:
			break;
	}
}

/**
 * getOrdinalName() - Gets the english ordinal of a number up to 10
 * @param int $number
 * @return string
 **/
function getOrdinalName($number) {
	switch ($number) {
		case 1:
			return "first";
			break;
		case 2:
			return "second";
			break;
		case 3:
			return "third";
			break;
		case 4:
			return "fourth";
			break;
		case 5:
			return "fifth";
			break;
		case 6:
			return "sixth";
			break;
		case 7:
			return "seventh";
			break;
		case 8:
			return "eighth";
			break;
		case 9:
			return "ninth";
			break;
		case 10:
			return "tenth";
			break;
		default:
			return $number;
			break;
	}
}

/**
 * getOccurrence() - get next date based on recurrence period
 * @param DateTime $intervalDate
 * @param int $bl_per_recurrence_per_ind
 * @param int $bl_per_recurrence_per_1
 * @param int $bl_per_recurrence_per_2
 * @param int $bl_per_recurrence_per_3
 * @param int $bl_per_recurrence_per_4
 * @param int $bl_per_recurrence_per_5
 * @param boolean $firstDate
 * @return DateTime
 **/
function getOccurrence(
	$intervalDate, 
	$bl_per_recurrence_per_ind,
	$bl_per_recurrence_per_1,
	$bl_per_recurrence_per_2,
	$bl_per_recurrence_per_3,
	$bl_per_recurrence_per_4,
	$bl_per_recurrence_per_5,
	$firstDate = false
) {
	$date = "";
	switch ($bl_per_recurrence_per_ind) {
		case DB_BL_PER_RECURRENCE_IND_WEEKLY_WEEKDAY:
			// Add one week (= 7 days)
			if ($intervalDate->format("N") != $bl_per_recurrence_per_1) {
				// if the start date isn't on the day of the week specified by the recurrence
				// change it to be the next date on that weekday
				$year = $intervalDate->format("Y");
				$month = $intervalDate->format("M");
				$day = $intervalDate->format("d");
				$weekday = getWeekdayShortName($bl_per_recurrence_per_1);
				$date = new DateTime(date('Y-m-d', strtotime('next ' . $weekday . ' ' . $day . ' ' . $month . ' ' . $year)));
			} else {
				if ($firstDate) {
					$date = $intervalDate;
				} else {
					$date = $intervalDate->add(new DateInterval('P7D'));
				}
			}
			break;
		case DB_BL_PER_RECURRENCE_IND_MONTHLY_DAY:
			// Each month on a specific day
			$monthlyDate = new DateTime($intervalDate->format("Y") . "-" . $intervalDate->format("m")  . "-" . $bl_per_recurrence_per_1);
			if ($firstDate && $monthlyDate >= $intervalDate) {
				// if the start date isn't on the day of the month specified by the recurrence
				// change it to be the next date for that month
				$date = $monthlyDate;
			} else {
				$year = date('Y', strtotime('+1 month ' . $intervalDate->format("Y-m-d")));
				$month = date('m', strtotime('+1 month ' . $intervalDate->format("Y-m-d")));
				$date = new DateTime($year . "-" . $month  . "-" . $bl_per_recurrence_per_1);
			}
			break;
		case DB_BL_PER_RECURRENCE_IND_ORDINAL_MONTH:
			// Each month on a specific week on a specific day. E.g. every month on the 2nd Thursday
			// e.g date('Y-m-d', strtotime('first monday of december 2014'));
			$monthlyDate = new DateTime(date('Y-m-d', strtotime(getOrdinalName($bl_per_recurrence_per_2) . ' ' . getWeekdayShortName($bl_per_recurrence_per_1) . ' of ' . $intervalDate->format("F Y"))));
			$thisMonthDate = new DateTime(date('Y-m-d', strtotime(getOrdinalName($bl_per_recurrence_per_2) . ' '. getWeekdayShortName($bl_per_recurrence_per_1) . ' of ' . date("F Y"))));
			if ($monthlyDate < $thisMonthDate) {
				$date = $thisMonthDate;
			} elseif  ($intervalDate < $monthlyDate) {
				$date = $monthlyDate;
			} else {
				$monthlyDate = new DateTime(date("Y-m-d", strtotime($monthlyDate->format("Y-m-d") . " +1 month")));
				$date = new DateTime(date('Y-m-d', strtotime(getOrdinalName($bl_per_recurrence_per_2) . ' ' . getWeekdayShortName($bl_per_recurrence_per_1) . ' of ' . $monthlyDate->format("F Y"))));
			}
			break;
		case DB_BL_PER_RECURRENCE_IND_INTERVAL_MONTH_OFFSET:
			// Every x months y days <after the start>/<before the end> of the month
			$day = 1;
			if ($firstDate) {
				switch ($bl_per_recurrence_per_5) {
					case DB_BL_INTERVAL_MONTH_OFFSET_AFTER_START:
						$day = $bl_per_recurrence_per_1 + 1; 
						break;
					case DB_BL_INTERVAL_MONTH_OFFSET_BEFORE_END:
						// (number of days in month) - offset
						$day = date("t", strtotime($intervalDate->format("Y-m-") . "-01")) - $bl_per_recurrence_per_1; 
						break;
					default:
						break;
				}
				$date = new DateTime(date('Y-m-d', strtotime($intervalDate->format("Y-m-") . $day)));
			} else {
				$year = $intervalDate->add(new DateInterval("P" . $bl_per_recurrence_per_4 . "M"))->format("Y");
				$month = $intervalDate->format("m");
				switch ($bl_per_recurrence_per_5) {
					case DB_BL_INTERVAL_MONTH_OFFSET_AFTER_START:
						// days start from 1
						$day = $bl_per_recurrence_per_1 + 1; 
						break;
					case DB_BL_INTERVAL_MONTH_OFFSET_BEFORE_END:
						// <number of days in month> - offset
						$day = date("t", strtotime($year . "-" . $month . "-" . "-01")) - $bl_per_recurrence_per_1; 
						break;
					default:
						break;
				}
				$date = new DateTime(date("Y-m-d", strtotime($year . "-" . $month . "-" . $day)));
			}
			break;
		case DB_BL_PER_RECURRENCE_IND_INTERVAL_MONTH_ORDINAL_WEEK:
			// Every x months on the y <weekday> of the month
			// e.g date('Y-m-d', strtotime('february 2011 second saturday'));
			$monthDate = new DateTime(date('Y-m-d', strtotime($intervalDate->format("F Y") . ' ' . getOrdinalName($bl_per_recurrence_per_3) . ' ' . getWeekdayShortName($bl_per_recurrence_per_1))));
			if ($intervalDate < $monthDate && $firstDate) {
				$date = $monthDate;
			} else {
				$monthDate = $monthDate->add(new DateInterval("P" . $bl_per_recurrence_per_4 . "M"));
				$date = new DateTime(date('Y-m-d', strtotime($monthDate->format("F Y") . ' ' . getOrdinalName($bl_per_recurrence_per_3) . ' ' . getWeekdayShortName($bl_per_recurrence_per_1))));
			}
			break;
		case DB_BL_PER_RECURRENCE_IND_INTERVAL_DAYS:
			// Every x days
			if ($firstDate) {
				$date = $intervalDate;
			} else {
				$date = new DateTime(date("Y-m-d", strtotime($intervalDate->format("Y-m-d") . " +". $bl_per_recurrence_per_4 ." day")));
			}
			break;
		default:
			break;
	}
	return $date;
}
