<?php

/**
 * functions.reservation - Functions relating to basic reservation information
 */

require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/db.tc_res_update.php");
require_once(__DIR__ . '/db.sc_group.php');
require_once(__DIR__ . '/db.ad_reservation.php');

require_once(__DIR__ . '/functions.reservation.advanced.php');


// ammendReservation - calculates and populates totals and other 'redundant' data fields for the res
// =================================================================================================
function ammendReservation($record,$detail,$update=true,array $items = array()) {
	global $lDB;
	global $dbcode;

	$oldFlagChngs = $GLOBALS['flagChngs'];

	$wasMaster = true;
	if ($GLOBALS['lDB']->isMaster != "1"){
		$GLOBALS['lDB']->isMaster = "1";
		$wasMaster = false;
	}

	$GLOBALS['flagChngs'] = "1";
	$server = $lDB->get("select rf_database_id from rf_database where rf_db_code = '".$dbcode."'",4);
	$datetime = date("Y-m-d H:i:s");
	$user = $GLOBALS['userid'];

	db_ad_reservation_insert($datetime,$detail,$user,$server,$record,$items);
	$GLOBALS['resAMMEND'] = true;

	$GLOBALS['flagChngs'] = "0";
	if ($detail != "Create" && $update == true) {
		$lDB->put("update rv_reservation set rv_date_changed = '".$datetime."' where rv_reservation_ix = '".$record."'");
	}
	if(!$wasMaster) {
		$GLOBALS['lDB']->isMaster = "0";
	}
	db_tc_res_update_insert($record);
	$GLOBALS['flagChngs'] = $oldFlagChngs;
}

// updateReservation - calculates and populates totals and other 'redundant' data fields for the res
// =================================================================================================
function updateReservation($record,$mode=0) {
	global $lDB;

	$oldFlagChngs = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = "0";

	updateItinerary($record,$mode);

	$dates = $lDB->get("
		SELECT
			MIN(rv_reservation_item.rv_item_date_arrive) as arrive,
			MAX(rv_reservation_item.rv_item_date_depart) as depart
		FROM
			rv_reservation_item
			LEFT JOIN rv_reservation_item as link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
			AND link_item.rv_reservation_item_ix IS NULL
	",1);
	$arrive = $dates['arrive'];
	$depart = $dates['depart'];

	$lDB->put("
		UPDATE
			rv_reservation
		SET
			rv_date_arrive = '$arrive',
			rv_date_depart = '$depart'
		WHERE
			rv_reservation_ix = '$record'
	");

	db_rv_reservation_update_notes($record);

	list($maxDate) = explode(" ",$lDB->get("SELECT MAX(ad_res_time) FROM ad_reservation WHERE rv_reservation_id = '$record'",4));
	if(!isset($GLOBALS['transferResUpdate'])) {
		$lDB->put("UPDATE rv_reservation SET rv_date_changed = '".$maxDate."' WHERE rv_reservation_ix = '$record'");
	}
	db_tc_res_update_insert($record);
	$GLOBALS['flagChngs'] = $oldFlagChngs;
}

// updateItinerary - calculates and populates totals and other 'redundant' data fields for the items
// =================================================================================================
function updateItinerary($record,$mode=0) {
	global $lDB;

	$oldFlagChngs = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = "0";

   $list = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$record'",3);
   foreach($list as $itemId) {
      if (trim($itemId) != "") {
         $pr_business_id = $lDB->get("
            SELECT
               ac_accomm_type.pr_business_id
            FROM
               rv_reservation_item
               LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
            WHERE
               rv_reservation_item_ix = '$itemId'
         ",4);
         $lDB->put("
            UPDATE
               rv_reservation_item
            SET
               pr_business_id = '$pr_business_id',
               rv_item_nights = (TO_DAYS(rv_item_date_depart) - TO_DAYS(rv_item_date_arrive))
            WHERE
               rv_reservation_item_ix = '$itemId'
         ");
      }
   }
	db_tc_res_update_insert($record);
	$GLOBALS['flagChngs'] = $oldFlagChngs;
}

// canDeleteReservation - returns true if a user can delete a reservation, and false if not allowed
// =================================================================================================
function canDeleteReservation($record){
   global $lDB;

   $delJob = "30";

   $data = $lDB->get("SELECT rf_reservation_status_id, rv_consultant_id FROM rv_reservation WHERE rv_reservation_ix = '$record'",1);
   $statusId = $data['rf_reservation_status_id'];
   $consultantId = $data['rv_consultant_id'];
   $paymentSum = $lDB->get("SELECT SUM(rv_payment_item_amt) FROM rv_payment_item WHERE rv_payment_item.rv_reservation_id = '$record'",4);

   if ($consultantId == "0" || $consultantId == 0) {
      if (checkJob($delJob,2) < 15 && $GLOBALS['isConsultant'] == "0") {
         return false;
      }
   }

   if ($statusId > "0") {
      return false;
   }

   if ($paymentSum != 0) {
	   return false;
   }

   if (!checkJob($delJob)) {
      return false;
   }
   return true;
}


// canEditReservation - returns true if a user can 'edit' a reservation, and false if not allowed
// =================================================================================================
function canEditReservation($record,$checkAccess=true,$job="2",$rv_reservation_item_id=false) {
	global $lDB;

	if($checkAccess) {
		$jobAllow = checkJob($job);
		$jobLevel = checkJob($job,2);
	} else {
		$jobAllow = true;
		$jobLevel = 15;
	}

	$data = $lDB->get("SELECT rf_reservation_status_id, rv_consultant_id, rv_reservation_db, rv_reservation_trf_yn,rv_date_arrive,rv_date_depart FROM rv_reservation WHERE rv_reservation_ix = '$record'",1);
	$statusId = $data['rf_reservation_status_id'];
	$consultantId = $data['rv_consultant_id'];
	$resCode = $data['rv_reservation_db'];
	$trfCode = $data['rv_reservation_trf_yn'];

	if(db_sc_group_get_user_setting("sc_grp_res_lock_yn") == "1") {
		$days = db_sc_group_get_user_setting("sc_grp_res_lock_days");
		$dateIndex = db_sc_group_get_user_setting("sc_grp_res_lock_ind");
		if($dateIndex == "1") {
			$date = $data['rv_date_arrive'];
		} else {
			$date = $data['rv_date_depart'];
		}

		list($year,$month,$day) = explode("-",$date);
		$day += $days;
		$finalDate = date("Y-m-d",mktime(0,0,0,$month,$day,$year));
		if($finalDate <= date("Y-m-d")) {
			return false;
		}
	}


	if($resCode == $GLOBALS['dbcode']) {
		if($trfCode == "0") {
			return $jobAllow;
		}
	}

	if ($consultantId == "0" || $consultantId == "") {
		if ($jobLevel < 15 || $GLOBALS['isConsultant'] == "0") {
			return false;
		}
	}

	if ($statusId == "90" && $GLOBALS['isConsultant'] == "0") {
		return false;
	}

	if($rv_reservation_item_id === false) {
		if (!canEditDB($lDB->get("SELECT rv_reservation_db FROM rv_reservation WHERE rv_reservation_ix = '$record'",4))) {
			return false;
		}
	} else {
		if (!canEditDB($lDB->get("SELECT rv_reservation_item_db FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",4))) {
			return false;
		}
	}

	if ($jobLevel < 10) {
		if ($statusId == "30") {
			return false;
		}
	}

	return $jobAllow;
}

/**
 * Whether or not the user can edit reservation details. This function only checks that the
 * 'Allow reservation detail changes' flag is checked in the user access and not that
 * reservations are editable in general.
 * 
 * @see canEditReservation()
 *
 * @return boolean
 */
function canEditReservationDetails() {
	return db_sc_group_get_user_setting("sc_grp_res_edit_details_yn") == "1";
}

/**
 * Whether or not the user can edit itineraries. This function only checks that the
 * 'Allow itinerary changes' flag is checked in the user access and not that
 * reservations are editable in general.
 * 
 * @see canEditReservation()
 *
 * @return boolean
 */
function canEditItineraries() {
	return db_sc_group_get_user_setting("sc_grp_res_edit_itineraries_yn") == "1";
}

function canAgentAccessReservation($rv_reservation_id, $userId)
{
	global $lDB;

	$rv_reservation_id = $lDB->escape($rv_reservation_id);

	$rv_agent_id = $lDB->get("
		SELECT rv_agent_id
		FROM rv_reservation
		WHERE rv_reservation_ix = '$rv_reservation_id'
	", 4);

	$agentId = getAgent($userId);

	return $rv_agent_id === $agentId;
}

function canChangeStatus($rv_reservation_id,$rf_reservation_status_id,$rv_expiry_date=false) {
	global $lDB;

	$unallocYN = db_sc_group_get_user_setting("sc_grp_res_status_unalloc_yn") == "1";
	$allocYN = db_sc_group_get_user_setting("sc_grp_res_status_alloc_yn") == "1";

	if($unallocYN && $allocYN) {
		return true;
	}

	$resInfo = $lDB->get("
		SELECT
		rv_reservation.rf_reservation_status_id,
		rv_reservation.rv_provision_expiry_date,
		rv_reservation.rv_create_expiry_date,
		rv_reservation.rv_alloc_expiry_date
		FROM
		rv_reservation
		WHERE
		rv_reservation.rv_reservation_ix = '$rv_reservation_id'
		",1);
	$hasStock = false;
	if($resInfo['rf_reservation_status_id'] >= 15 && $resInfo['rf_reservation_status_id'] <= 30) {
		$hasStock = true;
	}

	if($resInfo['rf_reservation_status_id'] == 25 && $resInfo['rv_create_expiry_date'] < date("Y-m-d H:i:s")) {
		$hasStock = false;
	}

	if($resInfo['rf_reservation_status_id'] == 20 && $resInfo['rv_provision_expiry_date'] < date("Y-m-d")) {
		$hasStock = false;
	}

	if($resInfo['rf_reservation_status_id'] == 15 && $resInfo['rv_alloc_expiry_date'] != "0000-00-00" && $resInfo['rv_alloc_expiry_date'] < date("Y-m-d")) {
		$hasStock = false;
	}

	if($hasStock) {
		if($rf_reservation_status_id >= 15 && $rf_reservation_status_id <= 30) { // stock -> stock (should check alloc / prov)
			return true;
		} else {
			if($unallocYN) {
				return true;
			}
		}
	} else {
		if($rf_reservation_status_id >= 15 && $rf_reservation_status_id <= 30) { // non-stock -> stock (should check alloc / prov)
			if($allocYN) {
				return true;
			}
		} else {
			return true;
		}
	}

	return false;
}

function disallowStatus(&$statuses, $reason, $list,$allow_date=true) {
	if(!is_array($list)) $list = array($list);
	foreach($list as $status) {
		$statuses[$status]['allow'] = false;
		$statuses[$status]['reasons'][] = $reason;
	}
	if(!$allow_date) {
		$statuses[DB_RF_RESERVATION_STATUS_PROVISIONAL]['allow_date'] = false;
		if(!in_array(DB_RF_RESERVATION_STATUS_PROVISIONAL,$list)) {
			$statuses[DB_RF_RESERVATION_STATUS_PROVISIONAL]['reasons'][] = $reason;
		}
	}
}

function allowStatuses($rv_reservation_id,$overrideOverbooking=true,$ignoreAllocatedRooms=false) {
	global $lDB;

	list(
		$rf_reservation_status_id,
		$rv_provision_expiry_date,
		$rv_amt_paid
	) = $lDB->get("
	SELECT
		rv_reservation.rf_reservation_status_id,
		rv_reservation.rv_provision_expiry_date,
		rv_reservation.rv_amt_paid
	FROM
		rv_reservation
	WHERE
		rv_reservation_ix = '$rv_reservation_id'
	",1);

	$hasOverbooking = !(check_availability($rv_reservation_id)===true);
	if($overrideOverbooking) {
		$allowOverbooking = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn") == "1";
	} else {
		$allowOverbooking = false;
	}

	$hasRooms = false;
	if ($lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
		",4) > "0") $hasRooms = true;

	$allocCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation_item AS link_item ON rv_reservation_item.rv_reservation_item_ix = link_item.rv_link_res_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
		",4);

	$statuses = array_flip(array(
		DB_RF_RESERVATION_STATUS_QUOTATION,
		DB_RF_RESERVATION_STATUS_WAITLIST,
		DB_RF_RESERVATION_STATUS_PROVISIONAL,
		DB_RF_RESERVATION_STATUS_CONFIRMED,
		DB_RF_RESERVATION_STATUS_CANCELLED
	));

	foreach($statuses as $id=>$null) {
		$statuses[$id] = array('allow'=>true, 'reasons'=>array());
		if($id == DB_RF_RESERVATION_STATUS_PROVISIONAL) {
			$statuses[$id]['allow_date'] = true;
		}
		if(!canChangeStatus($rv_reservation_id,$id)) {
			disallowStatus($statuses,"You do not have the required access to change to this status.",$id);
		}
	}

	if($GLOBALS['jobLevelArray'][0] < 15) {
		switch($rf_reservation_status_id) {
		case DB_RF_RESERVATION_STATUS_QUOTATION:
			break;
		case DB_RF_RESERVATION_STATUS_WAITLIST:
			disallowStatus($statuses,"Access denied. Requires management access.",array(
				DB_RF_RESERVATION_STATUS_QUOTATION
			));
			break;
		case DB_RF_RESERVATION_STATUS_PROVISIONAL:
			disallowStatus($statuses,"Access denied. Requires management access.",array(
				DB_RF_RESERVATION_STATUS_QUOTATION,
				DB_RF_RESERVATION_STATUS_WAITLIST
			));
			break;
		case DB_RF_RESERVATION_STATUS_CONFIRMED:
			disallowStatus($statuses,"Access denied. Requires management access.",array(
				DB_RF_RESERVATION_STATUS_QUOTATION,
				DB_RF_RESERVATION_STATUS_WAITLIST,
				DB_RF_RESERVATION_STATUS_PROVISIONAL
			));
			break;
		case DB_RF_RESERVATION_STATUS_CANCELLED:
			disallowStatus($statuses,"Access denied. Requires management access.",array(
				DB_RF_RESERVATION_STATUS_QUOTATION,
				DB_RF_RESERVATION_STATUS_WAITLIST,
				DB_RF_RESERVATION_STATUS_PROVISIONAL,
				DB_RF_RESERVATION_STATUS_CONFIRMED,
				DB_RF_RESERVATION_STATUS_CANCELLED
			));
			break;
		}
	}
	if($rv_amt_paid != 0) {
		disallowStatus($statuses,"There is a non-zero payment balance on this reservation.	Void all payments before continuing.",array(
			DB_RF_RESERVATION_STATUS_QUOTATION
		));
	}
	if ($hasRooms && !$ignoreAllocatedRooms) {
		disallowStatus($statuses,"There are rooms allocated to this reservation.	Please unallocate before continuing.",array(
			DB_RF_RESERVATION_STATUS_QUOTATION,
			DB_RF_RESERVATION_STATUS_WAITLIST
		));
		$allocRooms = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
			",4);
		if($allocRooms > "0") {
			disallowStatus($statuses,"There are rooms allocated to this reservation.	Please unallocate before continuing.",array(
				DB_RF_RESERVATION_STATUS_CANCELLED
			));
		}
	}
	if($hasOverbooking && !$allowOverbooking) {
		disallowStatus($statuses,"You have an overbooking on this reservation and your access permissions do not permit you to change to this status.",array(
			DB_RF_RESERVATION_STATUS_PROVISIONAL,
			DB_RF_RESERVATION_STATUS_CONFIRMED
		));
	}
	$allocOverbooking = false;
	if($allocCount > 0) {
		disallowStatus($statuses,"There are allocation draw downs on this reservation. Remove them to allow this status change.",array(
			DB_RF_RESERVATION_STATUS_QUOTATION,
			DB_RF_RESERVATION_STATUS_WAITLIST,
			DB_RF_RESERVATION_STATUS_CANCELLED
		));

		$agentInfo = $lDB->get("
			SELECT
				pr_agent.pr_agent_id,
				pr_agent.pr_agent_alloc_auto_yn
			FROM
				rv_reservation
				INNER JOIN pr_agent ON pr_agent.pr_agent_id = rv_reservation.rv_agent_id
			WHERE
				rv_reservation.rv_reservation_ix = '$rv_reservation_id'
			",1);

		$itemList = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation_item.rv_reservation_item_ix,
				rv_reservation_item.ac_accomm_type_id,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_item_accomm_count
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
			",2);
		foreach($itemList as $item) {
			$endArray = explode("-",$item['rv_item_date_depart']);
			$newEndDate = date("Y-m-d",mktime(0,0,0,$endArray[1],$endArray[2]-1,$endArray[0]));
			$agentId = $agentInfo['pr_agent_id'];
			if(trim($agentId) == "") {
				$agentId = "0";
			}
			$stock = new Stock($item['ac_accomm_type_id'],$item['rv_item_date_arrive'],$newEndDate,false,$agentId,true);
			$allocationArray = $stock->toReservationAllocation($item['rv_reservation_item_ix']);
			if($agentInfo['pr_agent_alloc_auto_yn'] == "0") {
				$allocations = array();
				foreach($allocationArray as $day) {
					foreach($day as $allocId=>$allocItem) {
						array_push($allocations,$allocId);
					}
				}
				$allocations = join(":",array_unique($allocations));
			} else {
				$allocations = join(":",$GLOBALS['lDB']->get("
					SELECT DISTINCT
						alloc.rv_reservation_ix
					FROM
						rv_reservation_item
						LEFT JOIN rv_reservation_item AS alloc_item ON alloc_item.rv_link_res_item_id = rv_reservation_item.rv_reservation_item_ix
						LEFT JOIN rv_reservation AS alloc ON alloc.rv_reservation_ix = alloc_item.rv_reservation_id
					WHERE
						rv_reservation_item.rv_reservation_item_ix = '$item[rv_reservation_item_ix]'
					",3));
			}
			$check = check_item_availability($item['rv_item_date_arrive'],$item['rv_item_date_depart'],$item['ac_accomm_type_id'],$item['rv_item_accomm_count'],$item['rv_reservation_item_ix'],$allocations);
			if($check !== true) {
				$allocOverbooking = true;
				if (!$allowOverbooking) {
					disallowStatus($statuses,"There is no space available for this reservation. Make space available for all itinerary items in order to confirm this reservation or to extend the expiry date.",array(
						DB_RF_RESERVATION_STATUS_CONFIRMED
					),false);
				}
			}
		}
	}
	$isInvoiced = false;
	if ($lDB->get("
		SELECT
		COUNT(*)
		FROM
		fn_invoice
		INNER JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
		WHERE
		fn_folio.rv_reservation_id = '$rv_reservation_id'
		AND fn_inv_status_ind != 8
		",4) > "0") $isInvoiced = true;

	if ($isInvoiced) {
		disallowStatus($statuses,"This reservation has already been invoiced and can only be confirmed or cancelled.",array(
			DB_RF_RESERVATION_STATUS_QUOTATION,
			DB_RF_RESERVATION_STATUS_WAITLIST,
			DB_RF_RESERVATION_STATUS_PROVISIONAL
		));
	}

	if($rf_reservation_status_id == DB_RF_RESERVATION_STATUS_PROVISIONAL) {
		$hasAvail = true;
		if($rv_provision_expiry_date < date("Y-m-d")) {
			$itemList = $GLOBALS['lDB']->get("
				SELECT
				rv_reservation_item.ac_accomm_type_id,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_item_accomm_count
				FROM
				rv_reservation_item
				WHERE
				rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
				",2);
			foreach($itemList as $resItem) {
				$fromDate = $resItem['rv_item_date_arrive'];
				$toDateArray = explode("-",$resItem['rv_item_date_depart']);
				$toDate = date("Y-m-d",mktime(0,0,0,$toDateArray[1],$toDateArray[2]-1,$toDateArray[0]));
				$stock = new Stock($resItem['ac_accomm_type_id'],$fromDate,$toDate);
				$avail =	$stock->ToAvailability();
				foreach($avail as $day) {
					if($day - $resItem['rv_item_accomm_count'] < 0) {
						$hasAvail = false;
					}
				}
			}
		}
		if(!$hasAvail && !$allocOverbooking && !$allowOverbooking) {
			disallowStatus($statuses,"There is no space available for this reservation. Make space available for all itinerary items in order to confirm this reservation or to extend the expiry date.",array(
				DB_RF_RESERVATION_STATUS_CONFIRMED
			),false);
		}
	}

	$test = testResConfirmation($rv_reservation_id);
	if ($test != "TRUE") {
		$test = str_replace("\r","",str_replace("\n","<br>",$test));
		if (!canEditReservation($rv_reservation_id) || $GLOBALS['jobLevelArray'][0] < "15") {
			disallowStatus($statuses,$test,array(
				DB_RF_RESERVATION_STATUS_CONFIRMED
			));
		}
	}

	return $statuses;
}


// getInvCurr - get the reservation invoice currency
// =================================================================================================
function getInvCurr($reservationId) {
	global $lDB;
	return $lDB->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$reservationId'",4);
}

function getInvCurrSymbol($reservationId) {
	global $lDB;

	$currId = getInvCurr($reservationId);
	return $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$currId'",4);
}

// Get details for Itinirary Popup
function getItinSummary($record) {
	global $lDB;
	$list = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$record' ORDER BY rv_item_date_arrive,rv_item_date_depart ",3);
	//debug($record);
	$summrowHTML = join("",file(__DIR__ . "/../../../public/html/reservation_item_summ_row.htm"));
	$imax = sizeof($list);
	$editItem = array();
	$lastArrive = "";
	$lastDepart = "";
	$lastProperty = "";
	$summout = "";
	for ($i=0;$i<$imax;$i++) {
		$itemId = $list[$i];
		$resItem = getItemDetails($itemId);
		$resItem['arrive'] = chng_date($resItem['rv_item_date_arrive'],"-");
		$resItem['depart'] = chng_date($resItem['rv_item_date_depart'],"-");
		$resItem['id'] = $itemId;

		if($lastArrive == $resItem['arrive'] && $lastDepart == $resItem['depart'] && $lastProperty == $resItem['pr_name_last']) {
			$resItem['arrive'] = "";
			$resItem['depart'] = "";
			$resItem['pr_name_last'] = "";
		} else {
			$lastArrive = $resItem['arrive'];
			$lastDepart = $resItem['depart'];
			$lastProperty = $resItem['pr_name_last'];
		}

		$invoiced = $GLOBALS['lDB']->get("
			SELECT
			count(rv_reservation_item_ix)
			FROM
			rv_reservation_item
			WHERE
			rv_reservation_item_ix = '$resItem[id]'
			AND fn_invoice_id IS NOT NULL
			AND fn_invoice_id <> '0'
			AND trim(fn_invoice_id) <> ''
			",4);
		if($invoiced > "0") {
			$resItem['rowClass'] = "txtred br";
			if (!in_array($itemId,$editItem)){
				array_push($editItem,$itemId);
			}
		} else {
			$resItem['rowClass'] = "txt br";
			// NB!!! once we implement server access control use class txtg for the server controlled items
			# Test to see whether this item's component(s) have been modified
			$sql = "SELECT count(rv_item_comp_edit_yn) FROM rv_res_item_comp WHERE rv_item_comp_edit_yn = 1 AND rv_reservation_item_id = '$resItem[id]'";
			$result = $GLOBALS['lDB']->get($sql,4);
			if($result >= "1"){
				$resItem['rowClass'] = "txtbr br";
			}else{
				if (!in_array($itemId,$editItem)){
					array_push($editItem,$itemId);
				}
			}
		}

		$trfFlag = $GLOBALS['lDB']->get("SELECT rv_reservation_item_trf_yn FROM rv_reservation_item WHERE rv_reservation_item_ix = '$itemId'",4);
		$canEdit = (canEditDB(substr($itemId,0,2)) || ($trfFlag == "0" && substr($itemId,0,2) == $GLOBALS['dbcode'])) && (isMasterDB() || $GLOBALS['dbcode'][0] != "W");
		if(!$canEdit){
			$resItem['rowClass'] = "txtg br";
		}

		$summout .= showpage($resItem,$summrowHTML);
	}
	$GLOBALS['temp']['summrows'] = $summout;
	// End details for Itinirary popup
}

function addLastRes($rv_reservation_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(*) FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
	if($check == "0") { return false; }

	if(!isset($_SESSION['lastResArray']) || !is_array($_SESSION['lastResArray'])) {
		$lastResArray = array();
	} else {
		$lastResArray = $_SESSION['lastResArray'];
	}
	if(in_array($rv_reservation_id,$lastResArray)) {
		$newLastResArray = array();
		foreach($lastResArray as $item) {
			if($item != $rv_reservation_id) {
				array_push($newLastResArray,$item);
			}
		}
		$lastResArray = $newLastResArray;
	}

	//	if(!in_array($rv_reservation_id,$lastResArray)) {
	//	if($lastResArray[0] != $rv_reservation_id) {
	array_unshift($lastResArray,$rv_reservation_id);
	if(sizeof($lastResArray) > 8) {
		array_pop($lastResArray);
	}
	//	}

	session_set("lastResArray",$lastResArray);
	return $lastResArray;
}

/**
 * createReservationInProgress() - Create a reservation with "In Progress" status.
 * 		It is intended to continue with the normal RR reservation creation wizard
 *		after creation
 * @param string rv_rate_type_id
 * @param string rv_agent_id
 * @param string rv_corr_persona_id
 * @param boolean rv_item_split_yn
 * @param string components
 * @param array itineraries
 *
 * components needs to be in one of the following formats:
 *		- string "defaultOnly": the only optionals that will be added are the defaults
 *		- array : a list of the default optionals to add
 * itineraries needs to be in the format:
 * 		[
 * 			{
 *				ac_accomm_type_id : "WB1",
 *				max_pax : "2",
 *				room_max : "2",
 *				rt_rate_type_id : "RS11",
 *				arrival_date : "2014-10-10",
 *				departure_date : "2014-10-12",
 *				allocation_item_id : "RS20",
 *				rate_groups : { <rate group id 1> : <number pax>, <rate group id 2> : <number pax> }
 *			},
 * 			{
 *				ac_accomm_type_id : "WB2",
 *				max_pax : "2",
 *				room_max : "2",
 *				rt_rate_type_id : "RS12",,
 *				arrival_date : "2014-10-12",
 *				departure_date : "2014-10-15",
 *				allocation_item_id : "RS21",
 *				rate_groups : { "RS1" : 1, "RS2" : 0 }
 *			}
 * 			...
 * 		]
 *
 */
function createReservationInProgress(
	$rt_rate_type_id,
	$rv_agent_id,
	$rv_corr_persona_id,
	$rv_item_split_yn,
	$components,
	array $itineraries,
	$bl_block_period_ix=null) {

	global $lDB;

	session_set("takenStep3",false);
	$wizResId = isset($_SESSION['wizResId']) ? $_SESSION['wizResId'] : "";
	validResId($wizResId);
	if (strpos($wizResId, "rsFrame") !== false) {
		unsetWizResId($wizResId);
	}

	$note = false;
	if (isset($_SESSION['requestRoomNote']) && $_SESSION['requestRoomNote'] != "") {
		$note = "\nOVERBOOKING REQUEST:\n".$_SESSION['requestRoomNote'];
		session_set("requestRoomNote","");
	}
	$wizResId = db_rv_reservation_insert($rt_rate_type_id,$rv_corr_persona_id,$rv_agent_id,false,false,false,false,false,false,false,$note);

	$override = array(
		"level"		=> "",
		"amounts"	=> array(
			"stay" => "",
			"rate_group" => array(
			)
		)
	);

	$items = array();
	foreach ($itineraries as $itinerary) {
		$numberNights = dateSubtract($itinerary['arrival_date'],$itinerary['departure_date']);
		$itemData = array(
			'ac_accomm_type_id'=>$itinerary['ac_accomm_type_id'],
			'rv_item_date_arrive'=>$itinerary['arrival_date'],
			'rv_item_date_depart'=>$itinerary['departure_date'],
			'nights'=>$numberNights,
			'rate_groups'=>$itinerary['rate_groups']
		);
		$itemRateId = $itinerary['rt_rate_type_id'];
		$allocationItem = $lDB->get("SELECT rv_reservation_id, bl_series_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '". $itinerary['allocation_item_id'] ."'", 1);
		$allocationId = false;
		$allocationSeries = false;
		if (!empty($itinerary['allocation_item_id'])) {
			$allocationId = $allocationItem['rv_reservation_id'];
			$bl_series_id = $allocationItem['bl_series_id'];
		}
		$allocations = array($allocationId);
		$items = array_merge($items, calCreateItem($wizResId, $itemData, $itemRateId, $components, $override, $rv_item_split_yn, "0", false, $allocations, false, false, false, $bl_series_id));
	}

	updateReservation($wizResId);
	if (!empty($bl_block_period_ix)) {
		$reservationAuditTrail = new AuditTrail($wizResId,TYPE_RESERVATION);
		$bl_block_ix = $lDB->get("SELECT bl_block_id FROM bl_block_period WHERE bl_block_period_ix = '$bl_block_period_ix'", 4);
		$reservationAuditTrail->save("Reservation Create - Block Template '$bl_block_ix' (period '$bl_block_period_ix')");
	}

	if(array_key_exists("wizItemOverbooking",$_SESSION)) {
		session_set("wizOverbooking",true);
	}
	session_set("wizResId",$wizResId);

	return $wizResId;
}
