<?php

require_once(__DIR__ . "/Roman/roman.php");

function getReservationRooming($resNum) {
	global $lDB;

	$guestList = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_ix,
			pr_guest.pr_guest_note,
			pr_guest.pr_guest_memo
		FROM
			rv_reservation_item
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$resNum'
	",2);

	$roomList = $lDB->get("
		SELECT
			rv_reservation_item.rv_item_date_arrive as arrive,
			rv_reservation_item.rv_item_date_depart as depart,
			pr_persona.pr_name_last as property,
			ac_accomm_type.ac_accomm_desc  as accomm,
			ac_accomm_room.ac_desc as room,
			rv_res_item_group.rv_room_requested_yn as locked,
			rv_room_request_reason as reason
		FROM
			rv_reservation_item
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$resNum'
		ORDER BY
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			(ac_accomm_room.ac_desc+0),
			ac_accomm_room.ac_desc
	",2);
	$arrive = null;
	$depart = null;
	$property = null;
	$accomm = null;
	$level = 1;
	foreach($roomList as $key=>$item) {
		$roomList[$key]['arrive'] = chng_date($item['arrive'],"-");	    
		$roomList[$key]['depart'] = chng_date($item['depart'],"-");
      
		if($arrive != $item['arrive']) {
			$arrive = $item['arrive'];
			$depart = $item['depart'];
			$property = $item['property'];
			$accomm = $item['accomm'];
			$level = 1;
		}
		if($depart != $item['depart']) {
			$depart = $item['depart'];
			$property = $item['property'];
			$accomm = $item['accomm'];
			$level = 2;
		}
		if($property != $item['property']) {
			$property = $item['property'];
			$accomm = $item['accomm'];
			$level = 3;
		}
		if($accomm != $item['accomm']) {
			$accomm = $item['accomm'];
			$level = 4;
		}

		if($level == 2) { $roomList[$key]['arrive'] = ""; }
		if($level == 3) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; }
		if($level == 4) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; $roomList[$key]['property'] = ""; }
		if($level == 5) { $roomList[$key]['arrive'] = ""; $roomList[$key]['depart'] = ""; $roomList[$key]['property'] = ""; $roomList[$key]['accomm'] = ""; }

		$level = 5;

		if($item['locked'] == "1") {
			$roomList[$key]['locked'] = "Yes";
		} else {
			$roomList[$key]['locked'] = "No";
			$roomList[$key]['reason'] = "";
		}
	}
	$guestGroup = array();
	$itemList = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$resNum'",3);

	$groupName = $lDB->get("
		SELECT DISTINCT
			rv_res_item_group.rv_res_item_group_ix
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
		WHERE
			rv_reservation.rv_reservation_ix = '$resNum'
			AND (
				rv_res_item_group.ac_accomm_room_id = ''
				OR rv_res_item_group.ac_accomm_room_id IS NULL
				OR rv_res_item_group.ac_accomm_room_id = '0'
			)
	",3);

	for($count = 0; $count < ceil(sizeof($itemList) / 4); $count++) {
		$row = array();
		$row['itemHeader1'] = "";
		$row['itemHeader2'] = "";
		$row['itemHeader3'] = "";
		$row['itemHeader4'] = "";
		$row['rows'] = array();
		foreach($guestList as $guestItem) {
			$item = array(
				'name' => $guestItem['pr_name_last'] . ($guestItem['pr_name_first'] != ""?", ".$guestItem['pr_name_first']:"")
			);
			if(trim($guestItem['pr_guest_note']) != "") {
				$item['guestNote'] = "x";
			} else {
				$item['guestNote'] = "";
			}
			if(trim($guestItem['pr_guest_memo']) != "") {
				$item['guestMemo'] = "x";
			} else {
				$item['guestMemo'] = "";
			}

			for($count2 = 0; $count2 < 4; $count2++) {
				if( ($count * 4) + $count2 < sizeof($itemList) ) {
					$guestRoom = $lDB->get("
						SELECT
							ac_accomm_room.ac_desc,
							rv_res_item_group.rv_room_requested_yn,
							rv_res_item_group.rv_res_item_group_ix as id,
							rv_reservation_item.rv_item_date_arrive,
							rv_reservation_item.rv_item_date_depart,
							rv_reservation_item.rv_item_adult_count,
							rv_reservation_item.rv_item_child_count,
							pr_business.pr_bus_name_short,
							ac_accomm_type.ac_accomm_name_short
						FROM
							rv_reservation_item
							INNER JOIN pr_business ON pr_business.pr_business_id = rv_reservation_item.pr_business_id
							INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
							INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
							LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
							INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
							INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
		               WHERE
							rv_reservation_item.rv_reservation_item_ix = '".$itemList[($count * 4) + $count2]."'
							AND rv_res_item_guest.pr_guest_id = '" . $guestItem['pr_persona_ix'] . "'
					",1);
					if($guestRoom !== false) {
						if($guestRoom['ac_desc'] == "" || $guestRoom['ac_desc'] == "0") {
							$groupKey = array_search($guestRoom['id'],$groupName);
							if($groupKey === false) {
								$guestRoom['ac_desc'] = "";
							} else {
								$guestRoom['ac_desc'] = "(" . strtolower(IntToRoman($groupKey+1)) . ")";
							}
						}
						$item["item".($count2+1)] = $guestRoom['ac_desc'];
						if($guestRoom['rv_room_requested_yn'] == "1") {
							$item["item".($count2+1)."Lock"] = "";
						} else {
							$item["item".($count2+1)."Lock"] = "display:none;";
						}
						$row['itemHeader'.($count2+1)] = 
							"Arr: " . chng_date($guestRoom['rv_item_date_arrive'],"-") . "<BR>" . 
							"Dep: " . chng_date($guestRoom['rv_item_date_depart'],"-") . "<BR>" .
							"Prop: " . $guestRoom['pr_bus_name_short'].", ".$guestRoom['ac_accomm_name_short']."<BR>" .
							"Adult: " .$guestRoom['rv_item_adult_count'] . "<BR>" .
							"Child: " .$guestRoom['rv_item_child_count'];					
					} else {
						$item["item".($count2+1)] = "";
						$row['itemHeader'.($count2+1)] = "";
					}
				} else {
					$item["item".($count2+1)] = "";
					$item["item".($count2+1)."Lock"] = "display:none;";
					$row['itemHeader'.($count2+1)] = "&nbsp;";
				}
			}
			array_push($row['rows'],$item);
		}
		$row['rows']['html'] = __DIR__ . "/../../../public/html/rep_detbilling_guest_group_rows.htm";
		$row['htmlRow'] = true;
		array_push($guestGroup,$row);
	}

	$notes = array();
	$memos = array();

	foreach($guestList as $item) {
		$name = $item['pr_name_last'] . ($item['pr_name_first'] != ""?", ".$item['pr_name_first']:"");
		if(trim($item['pr_guest_note']) != "") {
			array_push($notes,array('name'=>$name, 'note'=>$item['pr_guest_note']));
		}
		if(trim($item['pr_guest_memo']) != "") {
			array_push($memos,array('name'=>$name, 'note'=>$item['pr_guest_memo']));
		}
	}
	
	return array('guests'=>$guestList, 'rooms'=>$roomList, 'guestGroups'=>$guestGroup, 'notes'=>$notes, 'memos'=>$memos);
}

function getRoomDesc($room_id) {
	$roomDesc = $GLOBALS['lDB']->get("
	  SELECT
		 ac_accomm_room.ac_desc
	  FROM
		 ac_accomm_room
	  WHERE
		ac_accomm_room.ac_accomm_room_ix = '$room_id'
	",4);
	if ($roomDesc != "") { 
		return $roomDesc;
	} else {
		return "<none>";
	}
   
}
