<?php

require_once(__DIR__ . '/db.rt_rate_group.php');
require_once(__DIR__ . '/db.rv_reservation_item.php');
require_once(__DIR__ . '/db.rt_component.php');

function applySpecialToRes($rv_reservation_id, $auto = false, $specialsOld = []) {

	clearExistingSpecial($rv_reservation_id);

	$specials = db_rv_special_get_by_reservation($rv_reservation_id);
	$specialDescriptions = [];
	$discounts = [];
	$actionLogEnabled = isset($GLOBALS['username']) && strtolower($GLOBALS['username']) == "censysad" ? true : false;
	$actionLog = [];
	setcookie('specialActionLog', '', 1);

	if ($actionLogEnabled) $actionLog[] = "Applying specials";
	if ($actionLogEnabled) $actionLog[] = "Reservation: " . $rv_reservation_id;
	if ($actionLogEnabled) $actionLog[] = "Date: " . date("Y-m-d H:i:s");
	foreach($specials as $rv_special_id) {
		$benefits = getSpecialBenefits($rv_special_id);
		if(empty($benefits)) {
			continue;
		}

		$specialsAuditTrail = new AuditTrail($rv_reservation_id,TYPE_RESERVATION);
		$appliedSpecialId = $benefits['sp_rate_group_benefits'][0]['sp_special_id'];
		$thisSpecial = db_sp_special_get_desc($appliedSpecialId);
		$specialDescriptions[] = $thisSpecial;
		$specialMethod = ($auto) ? "Auto" : "Manual";
		if ($actionLogEnabled) $actionLog[] = "<br><strong>Processing special: " . $thisSpecial . "</strong> (" . $specialMethod . ")";

		$unitRateGroup =  $GLOBALS['lDB']->get("
			SELECT
				rt_rate_group_ix 
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 1
		",4);

		$paxRateGroup =  $GLOBALS['lDB']->get("
			SELECT
				rt_rate_group_ix 
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 99
		",4);

		$specialPeriodFilter = $GLOBALS['lDB']->get("
			SELECT
				sp_special_period.rt_period_id
			FROM
				sp_special_period
			WHERE 
				sp_special_period.sp_special_id = '".$appliedSpecialId."'
		",3);

		$specialPeriodsDates = $GLOBALS['lDB']->get("
			SELECT
				rt_period_from,
				rt_period_to
			FROM
				rt_period_dates
			WHERE
				rt_period_id IN ('".implode("','",$specialPeriodFilter)."')
		",2);

		$items = getSpecialResDetails($rv_reservation_id, $benefits['sp_accomm_types']);
		if(empty($items['rv_reservation_items'])) {
			if ($actionLogEnabled) $actionLog[] = "No reservation items found, stopping";
			return false;
		}

		$totals = array();

		// Iterate through benefits
		foreach ($benefits['sp_rate_group_benefits'] as $benefit) {
			if ($actionLogEnabled) $actionLog[] = "Processing benefit: " . db_rt_rate_group_get_desc($benefit['rt_rate_group_id']) . ", " .
				$benefit['sp_rate_group_recipients'] . " recipients, " .
				$benefit['sp_discount_nights'] . " nights, " .
				$benefit['sp_discount_perc'] . "% / " .
				$benefit['sp_discount_amount'] . " amount";
			$donor_property		= $benefit['sp_discount_donor_property_id'];
			$donor_properties 	= [];
			$benefitDates 		= array();

			if(empty($donor_property)) { // ""=all properties, "0"=last property
				foreach($items['rv_reservation_items'] as $rv_reservation_item) {
					$donor_properties[] = $rv_reservation_item['pr_business_id'];
					if($donor_property == "0") { // Last property only, which is first in the list due to sorting
						break;
					}
				}
			} else {
				$donor_properties[] = $donor_property;
			}
			$donor_properties 	= array_unique($donor_properties);

			$nights_unlimited	= ($benefit['sp_discount_nights'] == 0) ? true : false;
			$benefit_qty_nights	= $benefit['sp_discount_nights'];

			// Build list of qualifying nights to receive benefit
			foreach($donor_properties as $property) {
				foreach($items['rv_reservation_items'] as $reservation_item) {
					if(	// We are on the wrong property, or other fail criteria
						$reservation_item['pr_business_id'] != $property
						|| empty($reservation_item['rv_res_item_comps'])
						|| !in_array($reservation_item['rt_rate_type_id'], $benefits['sp_special_rate_types'])
						|| getSpecialItineraryHaveOverrides($reservation_item['rv_reservation_item_ix'])
						|| getSpecialItineraryHaveVariances($reservation_item['rv_reservation_item_ix'])
					) {
						continue;
					}

					// Passed other criteria, now we look at each day of the itinerary and see if it falls within the allowed rate period date range
					foreach ($specialPeriodsDates as $specialPeriodsDateRange) {
						$begin = new DateTime($reservation_item['rv_item_date_arrive']);
						$end = new DateTime($reservation_item['rv_item_date_depart']);

						for ($day = $begin; $day < $end; $day->modify('+1 day')) {
							if (
								$day->format("Y-m-d") >= $specialPeriodsDateRange['rt_period_from']
								&& $day->format("Y-m-d") <= $specialPeriodsDateRange['rt_period_to']
							) {
								$benefitDates[] = $day->format("Y-m-d");
							}
						}
					}
				}
			}

			$benefitDates = array_unique($benefitDates);
			sort($benefitDates);

			// Limited nights, shorten list to x number
			if(!$nights_unlimited) {
				$benefitDates = array_slice($benefitDates, 0, $benefit_qty_nights);
			}

			foreach($donor_properties as $property) {
				$recipients_unlimited 	= ($benefit['sp_rate_group_recipients'] == 0) ? true : false;
				$nights_unlimited 		= ($benefit['sp_discount_nights'] == 0) ? true : false;
				$recipient_is_pax 		= ($benefit['rt_rate_group_id'] == $paxRateGroup) ? true : false;
				$recipient_is_units 	= ($benefit['rt_rate_group_id'] == $unitRateGroup) ? true : false;
				$benefit_is_perc		= ($benefit['sp_discount_perc'] != 0) ? true : false;
				$benefit_rate_group		= $benefit['rt_rate_group_id'];
				$benefit_qty_recipients	= $benefit['sp_rate_group_recipients'];
				$benefit_amount			= $benefit['sp_discount_amount'];
				$benefit_perc			= $benefit['sp_discount_perc'];

				// Iterate through reservation itineraries to apply discount
				foreach($items['rv_reservation_items'] as $reservation_item) {
					if ($nights_unlimited) {	// Recipients to be deducted from every night, so reset number of recipients
						$benefit_qty_recipients	= $benefit['sp_rate_group_recipients'];
					}
					$rv_reservation_item_id = $reservation_item['rv_reservation_item_ix'];
					if ($actionLogEnabled) $actionLog[] = "<br> - Itinerary: " . db_rv_reservation_item_get_desc($rv_reservation_item_id);
					// Check if itinerary's dates is in calculated list
					$benefitDatesPass = false;
					$nightsEligible = 0;

					$begin = new DateTime($reservation_item['rv_item_date_arrive']);
					$end = new DateTime($reservation_item['rv_item_date_depart']);
					for($day = $begin; $day < $end; $day->modify('+1 day')) {
						if(in_array($day->format("Y-m-d"), $benefitDates)) {
							$benefitDatesPass = true;
							$nightsEligible++;
						}
					}

					// Skip itinerary if we've run out of our quotas, or are on the wrong property, or wrong rate period
					if(
						$reservation_item['pr_business_id'] != $property
						|| (
							!$recipients_unlimited
							&& $benefit_qty_recipients == 0
						) || (
							!$nights_unlimited 
							&& $benefit_qty_nights == 0
						)
						|| !$benefitDatesPass
						|| empty($reservation_item['rv_res_item_comps'])
						|| !in_array($reservation_item['rt_rate_type_id'], $benefits['sp_special_rate_types'])
						|| getSpecialItineraryHaveOverrides($rv_reservation_item_id)
						|| getSpecialItineraryHaveVariances($rv_reservation_item_id)
					) {
						if ($actionLogEnabled) $actionLog[] = "    - Does not qualify for Special";
						continue;
					}

					$item_gross = 0;
					$item_discount_applied = 0;
					$largest_group = false;
					$calc_only_value = array();
					$calc_and_deduct_component = array();
					$component_discount = 0;

					foreach ($reservation_item['rv_res_item_comps'] as $res_item_comp) {
						// Add up gross for item for applicable components
						foreach ($res_item_comp['rv_res_item_comp_rate_grps'] as $rt_rate_group_id => $res_item_comp_rate_grp ) {
							if ($recipient_is_pax) {
								if ($rt_rate_group_id != $unitRateGroup) {
									$item_gross += $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'];
								}
							} else {
								if ($rt_rate_group_id == $benefit['rt_rate_group_id']) {
									$item_gross += $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'];
								}
							}
						}
					}

					if ($item_gross == 0) {
						if ($actionLogEnabled) $actionLog[] = "    - Does not qualify for Special";
						continue; 
					}

					if(!array_key_exists($rv_reservation_item_id, $discounts)) {
						$discounts[$rv_reservation_item_id] = [];
					}
					if(!array_key_exists($appliedSpecialId, $discounts[$rv_reservation_item_id])) {
						$discounts[$rv_reservation_item_id][$appliedSpecialId] = [];
					}

					// Number of units is not applicable to Unit rate group
					$units = ($recipient_is_units) ? 1 : $reservation_item['rv_res_item_rate_grp'][$unitRateGroup];

					if ($recipient_is_pax) {
						$qty = $reservation_item['pax_count'] * $units;
					} else {
						$qty = $reservation_item['rv_res_item_rate_grp'][$benefit_rate_group] * $units;
					}

					if ($recipients_unlimited) {
						$recipients = $qty;
					} else {
						$recipients = ($benefit_qty_recipients >= $qty) ? $qty : $benefit_qty_recipients;
						$benefit_qty_recipients -= $recipients;
					}

					$nights = $nightsEligible;
					$item_gross_per_night = $item_gross / $reservation_item['rv_item_nights'];
					$item_gross_per_bednight = $item_gross / $reservation_item['rv_item_nights'] / $qty;

					if ($benefit_is_perc) {
						$item_discount = (($item_gross_per_bednight/100) * $benefit_perc) * $nights * $recipients;
					} else {
						$item_discount = $benefit_amount * $nights * $recipients;
					}
					$item_discount = round($item_discount,2);

					foreach ($reservation_item['rv_res_item_comps'] as $res_item_comp) {
						foreach ($res_item_comp['rv_res_item_comp_rate_grps'] as $rt_rate_group_id => $res_item_comp_rate_grp ) {
							if ($res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'] < 0) {
								// Ignore negative component amounts
								if ($actionLogEnabled) $actionLog[] = "    - Ignoring negative component: " . db_rt_component_get_desc_by_res_item_comp_id($res_item_comp['rv_res_item_comp_ix']) .
									", rate group: " . db_rt_rate_group_get_desc($rt_rate_group_id) .
									", gross: " . $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'];
								continue;
							}
							$component_discount = 0;
							if ($recipient_is_pax) {
								if ($rt_rate_group_id != $unitRateGroup) {
									$component_discount = round( (($item_discount / $item_gross) * $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross']),2);
									if ($res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'] >= 0) {
										$component_discount = ($component_discount > $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross']) ? $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'] : $component_discount;
									} else {
										$component_discount = ($component_discount < $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross']) ? $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'] : $component_discount;
									}

									if ($res_item_comp['rv_item_comp_comm_ind'] == 1) {	// Calculate only, do not apply to
										if (!isset($calc_only_value[$rt_rate_group_id])) {
											$calc_only_value[$rt_rate_group_id] = 0;
										}
										$calc_only_value[$rt_rate_group_id] += $component_discount;
									} else {
										$discounts[$rv_reservation_item_id][$appliedSpecialId][$res_item_comp_rate_grp['rv_res_item_comp_rate_grp_ix']] = $component_discount;
										$item_discount_applied += $component_discount;
									}
									if ($res_item_comp['rv_item_comp_comm_ind'] == 3) {	// Calc & deduct, apply additional calc-only later
										if (!isset($calc_and_deduct_component[$rt_rate_group_id])) {
											$calc_and_deduct_component[$rt_rate_group_id] = array();
										}
										$calc_and_deduct_component[$rt_rate_group_id]['id'] = $res_item_comp_rate_grp['rv_res_item_comp_rate_grp_ix'];
										$calc_and_deduct_component[$rt_rate_group_id]['value'] = $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'];
										$calc_and_deduct_component[$rt_rate_group_id]['sp_applied'] = $component_discount;
									}
								}
							} else {
								if ($res_item_comp_rate_grp['rt_rate_group_id'] == $benefit['rt_rate_group_id']) {
									$component_discount = round( (($item_discount / $item_gross) * $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross']),2);

									if ($res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'] >= 0) {
										$component_discount = ($component_discount > $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross']) ? $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'] : $component_discount;
									} else {
										$component_discount = ($component_discount < $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross']) ? $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'] : $component_discount;
									}

									if ($res_item_comp['rv_item_comp_comm_ind'] == 1) {	// Calculate only, do not apply to
										if (!isset($calc_only_value[$rt_rate_group_id])) {
											$calc_only_value[$rt_rate_group_id] = 0;
										}
										$calc_only_value[$rt_rate_group_id] += $component_discount;
									} else {
										$discounts[$rv_reservation_item_id][$appliedSpecialId][$res_item_comp_rate_grp['rv_res_item_comp_rate_grp_ix']] = $component_discount;
										$item_discount_applied += $component_discount;
									}
											
									if ($res_item_comp['rv_item_comp_comm_ind'] == 3) {	// Calc & deduct, apply additional calc-only later
										if (!isset($calc_and_deduct_component[$rt_rate_group_id])) {
											$calc_and_deduct_component[$rt_rate_group_id] = array();
										}
										$calc_and_deduct_component[$rt_rate_group_id]['id'] = $res_item_comp_rate_grp['rv_res_item_comp_rate_grp_ix'];
										$calc_and_deduct_component[$rt_rate_group_id]['value'] = $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'];
										$calc_and_deduct_component[$rt_rate_group_id]['sp_applied'] = $component_discount;
									}
								}
							}
							if (
								(
									// Only consider Calc & Deduct and Calc & Deduct All components as largest components
									// for the purpose of applying leftover discount (if neccesary)
									$res_item_comp_rate_grp['rv_item_comp_comm_ind'] == '2' ||
									$res_item_comp_rate_grp['rv_item_comp_comm_ind'] == '3'
								) && (
									$largest_group  === false ||
									$res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'] > $largest_group['value']
								)
							) {
								$largest_group = [
									'id'=>$res_item_comp_rate_grp['rv_res_item_comp_rate_grp_ix'],
									'value'=>$res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'],
									'applied'=>$component_discount,
									'rt_rate_group_id'=>$rt_rate_group_id,
									'rv_item_comp_comm_ind'=>$res_item_comp_rate_grp['rv_item_comp_comm_ind']
								];
								if ($actionLogEnabled) $actionLog[] = "    - Largest rategroup for leftover discount is now: Component: " . db_rt_component_get_desc_by_res_item_comp_id($res_item_comp['rv_res_item_comp_ix']) .
								", rate group: " . db_rt_rate_group_get_desc($rt_rate_group_id);
							}
							
							switch ($res_item_comp['rv_item_comp_comm_ind']) {
								case (1) :
									$comp_comm_ind = "Calculate only";
									break;
								case (2) :
									$comp_comm_ind = "Calc & deduct";
									break;
								case (3) :
									$comp_comm_ind = "Calc & deduct all";
									break;
							}
							if ($component_discount != 0) {
								if ($actionLogEnabled) $actionLog[] = "    - Component: " . db_rt_component_get_desc_by_res_item_comp_id($res_item_comp['rv_res_item_comp_ix']) .
											", rate group: " . db_rt_rate_group_get_desc($rt_rate_group_id) .
											", discount: " . $component_discount .
											" (" . $component_discount . "/" . $res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'] . "=" .
											((100/$res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'])*$component_discount) . "%, " .
											$comp_comm_ind . ")";
							}

						}
					}
					

					foreach ($calc_and_deduct_component as $rate_group_id => $component) {
						if ($calc_only_value[$rate_group_id] != 0 && $component['id'] != '') {
							$component_discount = $component['sp_applied'] + $calc_only_value[$rate_group_id];
							$component_discount = ($component_discount > $component['value']) ? $component['value'] : $component_discount;
							$discounts[$rv_reservation_item_id][$appliedSpecialId][$component['id']] = round($component_discount,2);
							$item_discount_applied += ($component_discount - $component['sp_applied']);
							if($component['id'] == $largest_group['id']) {
								$largest_group['applied'] = $component_discount;
							}
							if ($actionLogEnabled) $actionLog[] = "    - Adding " . $calc_only_value[$rate_group_id] .
								" to 'Calc & deduct all' component: " . db_rt_component_get_desc_by_res_item_comp_rate_grp_id($component['id']) .
								" for rate group " . db_rt_rate_group_get_desc($rate_group_id) .
								", new discount: " . round($component_discount,2);
						}
					}
					$leftover_discount = ($item_discount - $item_discount_applied);
					if ($leftover_discount != 0) {
						$component_discount = $discounts[$rv_reservation_item_id][$appliedSpecialId][$largest_group['id']] + $leftover_discount;
						$component_discount = ($component_discount > $largest_group['value']) ? $largest_group['value'] : $component_discount;
						$discounts[$rv_reservation_item_id][$appliedSpecialId][$largest_group['id']] = round($component_discount,2);
						if ($actionLogEnabled) {
							$actionLog[] = "    - Adding " . $leftover_discount .
								" leftover discount to largest component component rate group: " . db_rt_rate_group_get_desc($largest_group['rt_rate_group_id']) .
								", new discount: " . round($component_discount,2);
						}
					}
				}
			}
		}
	}

	if ($actionLogEnabled) $actionLog[] = "<br>Actioning deduction of special discount";
	// Apply all discounts across all specials
	foreach($discounts as $rv_reservation_item_id=>$discountSpecials) {
		if(empty($discountSpecials)) {
			continue;
		}
		if ($actionLogEnabled) $actionLog[] = " - Itinerary: " . db_rv_reservation_item_get_desc($rv_reservation_item_id);
		$discountsPerSpecial = [];
		$discountsPerComponentRateGroup = [];
		foreach($discountSpecials as $sp_special_id=>$discountComponentRateGroups) {
			if ($actionLogEnabled) $actionLog[] = "    - Special: " . db_sp_special_get_desc($sp_special_id);
			
			if(!array_key_exists($sp_special_id, $discountsPerSpecial)) {
				$discountsPerSpecial[$sp_special_id] = 0;
			}
			foreach($discountComponentRateGroups as $rv_res_item_comp_rate_grp_id=>$amount) {
				if(!array_key_exists($rv_res_item_comp_rate_grp_id, $discountsPerComponentRateGroup)) {
					$discountsPerComponentRateGroup[$rv_res_item_comp_rate_grp_id] = 0;
				}
				$discountsPerSpecial[$sp_special_id] += $amount;
				$discountsPerComponentRateGroup[$rv_res_item_comp_rate_grp_id] += $amount;
				if ($actionLogEnabled) {
					$rt_rate_group_desc = db_rt_rate_group_get_desc_by_rv_res_item_comp_rate_grp_id($rv_res_item_comp_rate_grp_id);
					if (!empty($rt_rate_group_desc)) {
						$actionLog[] = "    - Calculating deduction for rate group " . $rt_rate_group_desc . ": " . $amount;
					}
				}
			}
		}

		$hasDiscount = false;
		foreach($discountsPerSpecial as $sp_special_id=>$amount) {
			if(empty($amount)) {
				continue;
			}
			db_rv_res_item_special_insert($rv_reservation_item_id, $sp_special_id, $amount);
			$hasDiscount = true;
		}

		foreach($discountsPerComponentRateGroup as $rv_res_item_comp_rate_grp_id=>$amount) {
			if(empty($amount)) {
				continue;
			}
			db_rv_res_item_comp_rate_grp_set_discount($rv_res_item_comp_rate_grp_id, $amount);
			if ($actionLogEnabled) {
				$rt_rate_group_desc = db_rt_rate_group_get_desc_by_rv_res_item_comp_rate_grp_id($rv_res_item_comp_rate_grp_id);
				if (!empty($rt_rate_group_desc)) {
					$actionLog[] = "    - Deducting from rate group " . $rt_rate_group_desc . ": " . $amount;
				}
			}
			$hasDiscount = true;
		}
		if($hasDiscount) {
			if(empty($specialsOld)) {
				$action = DB_AD_RES_DETAIL_ACTION_ADD;
				$oldId = null;
				$oldDescription = "";
			} else {
				$action = DB_AD_RES_DETAIL_ACTION_EDIT;
				$oldId = join("_", array_keys($specialsOld));
				$oldDescription = join(", ", $specialsOld);
			}
			$specialsAuditTrail->addDetail(
				$oldDescription,
				join(", ", $specialDescriptions),
				$oldId,
				$rv_reservation_item_id,
				$action,
				"resitinerary",
				"rv_special.rv_special_ix"
			);
		}
	}

	if ($actionLogEnabled) session_set("specialActionLog", join("<br>", $actionLog));
	$specialsAuditTrail->save("Special (Apply, ".$specialMethod.")");

	recalcTotals($rv_reservation_id);
	return true;
}

function getSpecialItineraryHaveOverrides($rv_reservation_item_id) {
	global $lDB;

	$overrides_items = $lDB->get("
		SELECT
			rv_reservation_item.rv_item_overide_amt
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '" . $lDB->escape($rv_reservation_item_id) . "'
	",3);

	foreach ($overrides_items as $rv_item_overide_amt) {
		if ($rv_item_overide_amt != "") {
			return true;
		}
		$overrides_item_rte_grps = $lDB->get("
			SELECT
				rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt
			FROM
				rv_res_item_rate_grp
			WHERE
				rv_res_item_rate_grp.rv_reservation_item_id = '" . $lDB->escape($rv_reservation_item_id) . "'
		",3);
		foreach ($overrides_item_rte_grps as $rv_res_item_rate_grp_overide_amt) {
			if ($rv_res_item_rate_grp_overide_amt != "") {
				return true;
			}
		}
	}
	return false;
}

function getSpecialItineraryHaveVariances($rv_reservation_item_id) {
	global $lDB;

	$variances = $lDB->get("
		SELECT
			SUM(rv_res_item_comp.rv_item_comp_var)
		FROM
			rv_res_item_comp
		WHERE
			rv_res_item_comp.rv_reservation_item_id = '" . $lDB->escape($rv_reservation_item_id) . "'
	",4);

	if ($variances != 0){
		return true;
	} else {
		return false;
	}
}

function orphanedSpecialCheck($rv_reservation_id) {
	// This function checks if a special discount has been deducted from a reservation, without a special being currently applied,
	// and clears the uninvoiced special deductions

	if (db_rv_special_orphaned_check($rv_reservation_id)) {
		$cleared_count = 0;

		$rv_reservation_items = db_rv_reservation_item_by_reservation($rv_reservation_id);

		foreach ($rv_reservation_items as $rv_reservation_item_id) {
			$fn_folio_id = db_rv_reservation_item_get_folio($rv_reservation_item_id);
			$invoice_exists = db_fn_invoice_exists_by_folio($fn_folio_id);

			if (!db_fn_invoice_exists_by_folio($fn_folio_id) && db_rv_reservation_item_has_special($rv_reservation_item_id) ) {
				$res_item_comps = db_rv_res_item_comp_by_reservation_item($rv_reservation_item_id);

				foreach ($res_item_comps as $res_item_comp) {
					db_rv_res_item_comp_set_discount($res_item_comp, 0);
					$res_item_comp_rate_grps = db_rv_res_item_comp_rate_grp_by_res_item_comp($res_item_comp);

					foreach ($res_item_comp_rate_grps as $rv_res_item_comp_rate_grp_id) {
						db_rv_res_item_comp_rate_grp_set_discount($rv_res_item_comp_rate_grp_id, 0);
					}
				}
				db_rv_reservation_item_set_discount($rv_reservation_item_id,0);
				$cleared_count++;
			}
		}
		if ($cleared_count > 0) {
			recalcTotals($rv_reservation_id);
		}
	}
}

function specialsAutoApply($rv_reservation_id, $current_specials=false, $special_override=false, $new_booking=false) {

	orphanedSpecialCheck($rv_reservation_id);

	$auto_application = (db_sc_group_get_user_setting("sc_grp_res_sp_apply_auto_yn") == "1") ? true : false;
	$manual_application = (db_sc_group_get_user_setting("sc_grp_res_sp_apply_man_yn") == "1") ? true : false;

	if(empty($current_specials)) {
		$current_specials = db_rv_special_get_specials_by_reservation($rv_reservation_id);
	}
	$current_specials_desc = [];
	foreach($current_specials as $sp_special_id) {
		$current_specials_desc[$sp_special_id] = db_sp_special_get_desc($sp_special_id);
	}

	if(
		(!$manual_application && !$auto_application) // User does not have specials access, so do not apply
		|| db_fn_invoice_exists_by_reservation($rv_reservation_id) // An invoice exists, so do not apply
	) {
		if(!empty($current_specials)) {
			$GLOBALS['specialNotification'] = "Automatically removed special(s)<br><strong>" . join(", ", $current_specials_desc) . "</strong>";
		}
		return false;
	}

	// Override specials applied but no specials means a user removed all specials (no auto application)
	if($special_override && sizeof($current_specials) == 0) {
		return true;
	}

	// Override specials applied, so re-apply current specials with no questions asked
	if ($special_override && sizeof($current_specials) > 0) {
		db_rv_special_delete_by_reservation($rv_reservation_id);
		foreach($current_specials as $sp_special_id) {
			db_rv_special_insert($rv_reservation_id, $sp_special_id);
		}
		db_rv_reservation_set_special_override($rv_reservation_id, true);
		applySpecialToRes($rv_reservation_id, true, $current_specials_desc);
		return true;
	}

	$specialManager	= new SpecialManager($rv_reservation_id);
	$qualifying = $specialManager->GetQualifying();
	$qualifyingSuggested = [];
	if(sizeof($qualifying) > 0) {
		$qualifyingSuggested = $qualifying[0]['specials'];
	}
	$qualifyingSuggestedDesc = [];
	foreach($qualifyingSuggested as $sp_special_id) {
		$qualifyingSuggestedDesc[$sp_special_id] = db_sp_special_get_desc($sp_special_id);
	}
	
	$qualifyingCurrent = false;
	$qualifyingCurrentFirst = true;
	foreach($qualifying as $qualifyingItem) {
		if(array_diff($qualifyingItem['specials'],$current_specials) == array_diff($current_specials, $qualifyingItem['specials'])) {
			$qualifyingCurrent = true;
			break;
		}
		$qualifyingCurrentFirst = false;
	}

	// No current special or current no longer qualifying, auto-apply suggested special
	if(
		$auto_application
		&& (
			!$qualifyingCurrent
			|| $new_booking
		) && sizeof($qualifying) > 0
	) {
		if(sizeof($current_specials) == 0) {
			$GLOBALS['specialNotification'] = "Automatically applying specials<br><strong>" . join(", ", $qualifyingSuggestedDesc) . "</strong>";
		} else {
			$GLOBALS['specialNotification'] = "Automatically changing special from<br><strong>".join(", ", $current_specials_desc) . "</strong><br>to<br><strong>" . join(", ", $qualifyingSuggestedDesc) . "</strong>";
		}

		db_rv_special_delete_by_reservation($rv_reservation_id);
		foreach($qualifyingSuggested as $sp_special_id) {
			db_rv_special_insert($rv_reservation_id, $sp_special_id);
		}	
		applySpecialToRes($rv_reservation_id, true, $current_specials_desc);
		return true;
	}

	// Currently have special, which is still valid, and the same as the suggested special, so re-apply
	if(
		$qualifyingCurrent
		&& $qualifyingCurrentFirst
	) {
		db_rv_special_delete_by_reservation($rv_reservation_id);
		foreach($current_specials as $sp_special_id) {
			db_rv_special_insert($rv_reservation_id, $sp_special_id);
		}
		applySpecialToRes($rv_reservation_id, true, $current_specials_desc);
		return true;
	}

	// Current special qualifies, suggested special is better, re-apply current and ask for confirmation for suggested
	if(
		$auto_application
		&& $qualifyingCurrent
		&& !$qualifyingCurrentFirst
	) {
		$GLOBALS['specialNotification'] = "The specials applied are no longer the default specials. Click Apply Defaults, if required.";
		db_rv_special_delete_by_reservation($rv_reservation_id);
		foreach($current_specials as $sp_special_id) {
			db_rv_special_insert($rv_reservation_id, $sp_special_id);
		}
		applySpecialToRes($rv_reservation_id, true, $current_specials_desc);
		return true;
	}

	// No suggested (qualifying) specials, current special no longer qualifies either
	if(!empty($current_specials)) {
		$GLOBALS['specialNotification'] = "Automatically removed special(s)<br><strong>" . join(", ", $current_specials_desc) . "</strong>";
	}
	db_rv_special_delete_by_reservation($rv_reservation_id);
	db_rv_reservation_set_special_override($rv_reservation_id, true); // Set override to prevent future auto-application to this reservation
	clearExistingSpecial($rv_reservation_id);
}

function removeSpecialsFromRes($rv_reservation_id) {
	db_rv_special_delete_by_reservation($rv_reservation_id);
}

function getSpecialResDetails($rv_reservation_id, $sp_accomm_types) {
	global $lDB;
	$items = array();
	$ac_accomm_type_ids = array();

	foreach ($sp_accomm_types as $ac_accomm_type_id) {
		$ac_accomm_type_ids[] = $ac_accomm_type_id['ac_accomm_type_id'];
	}
	$ac_accomm_type_id_list = "'".implode("','",$ac_accomm_type_ids)."'";

	$rv_reservation = $lDB->get("
		SELECT
			rv_reservation.rv_amt_accomm_gross,
			rv_reservation.rv_amt_sp_discount
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_reservation_ix = '".$rv_reservation_id."'
	",1);

	$reservation['rv_reservation_ix'] = $rv_reservation_id;
	$reservation['rv_amt_accomm_gross'] = $rv_reservation['rv_amt_accomm_gross'];
	$reservation['rv_amt_sp_discount'] = $rv_reservation['rv_amt_sp_discount'];
	$reservation['rv_reservation_items'] = array();

	$rv_reservation_items = $lDB->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_amt_gross,
			rv_reservation_item.rv_item_amt_sp_discount,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_adult_count,
			rv_reservation_item.rv_item_child_count,
			(rv_reservation_item.rv_item_adult_count + rv_reservation_item.rv_item_child_count) AS pax_count,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.pr_business_id,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rt_rate_type_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '".$rv_reservation_id."'
			AND rv_reservation_item.ac_accomm_type_id IN (".$ac_accomm_type_id_list.")
		ORDER BY
			rv_reservation_item.rv_item_date_depart DESC,
			rv_reservation_item.rv_item_accomm_count DESC,
			(rv_reservation_item.rv_item_adult_count + rv_reservation_item.rv_item_child_count) DESC,
			rv_reservation_item.rv_item_amt_gross DESC,
			rv_reservation_item.rv_reservation_item_ix
	",6);

	foreach ($rv_reservation_items as $rv_reservation_item) {
		$rv_reservation_item['rv_res_item_comps'] = array();
		
		$rv_res_item_rate_grp = $lDB->get("
			SELECT
				rv_res_item_rate_grp.rt_rate_group_id,
				rv_res_item_rate_grp.rv_res_item_rate_grp_count
			FROM
				rv_res_item_rate_grp
			WHERE
				rv_res_item_rate_grp.rv_reservation_item_id = '".$rv_reservation_item['rv_reservation_item_ix']."'
		",2);

		$rv_reservation_item['rv_res_item_rate_grp'] = array();
		foreach($rv_res_item_rate_grp as $item) {
			$rv_reservation_item['rv_res_item_rate_grp'][$item['rt_rate_group_id']] = $item['rv_res_item_rate_grp_count'];
		}

		$rv_res_item_comps = $lDB->get("
			SELECT
				rv_res_item_comp.rv_res_item_comp_ix,
				rv_res_item_comp.rv_item_comp_amt_gross,
				rv_res_item_comp.rv_item_comp_amt_sp_discount,
				rv_res_item_comp.rv_item_comp_comm_ind
			FROM
				rv_res_item_comp
			WHERE
				rv_res_item_comp.rv_reservation_item_id = '".$rv_reservation_item['rv_reservation_item_ix']."'
				AND rv_res_item_comp.rv_item_comp_comm_ind != 0
			ORDER BY
				rv_res_item_comp.rv_item_comp_amt_gross DESC,
				rv_res_item_comp.rv_res_item_comp_ix
		",6);

		foreach ($rv_res_item_comps as $rv_res_item_comp) {
			$rv_res_item_comp_rate_grps = $lDB->get("
				SELECT
					rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix,
					rv_res_item_comp_rate_grp.rt_rate_group_id,
					rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_gross,
					rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_sp_discount,
					rv_res_item_comp.rv_item_comp_comm_ind
				FROM
					rv_res_item_comp_rate_grp
					LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
				WHERE
					rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$rv_res_item_comp['rv_res_item_comp_ix']."'
				ORDER BY
					rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix
			",2);

			foreach ($rv_res_item_comp_rate_grps as $rv_res_item_comp_rate_grp) {
				$rv_res_item_comp['rv_res_item_comp_rate_grps'][$rv_res_item_comp_rate_grp['rt_rate_group_id']] = $rv_res_item_comp_rate_grp;
			}
			$rv_reservation_item['rv_res_item_comps'][$rv_res_item_comp['rv_res_item_comp_ix']] = $rv_res_item_comp;
		}

		$end_date = date('Y-m-d',(strtotime ( '-1 day' , strtotime ( $rv_reservation_item['rv_item_date_depart'] ) ) ));
		$rate_period = $lDB->get("
			SELECT
				rt_period.rt_period_ix AS rt_period_ix
			FROM
				rt_rate
				INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
				INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
			WHERE
				rt_rate.ac_accomm_type_id = '".$rv_reservation_item['ac_accomm_type_id']."'
				AND rt_rate.rt_rate_type_id = '".$rv_reservation_item['rt_rate_type_id']."'
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".$rv_reservation_item['rv_item_date_arrive']."'
						AND rt_period_dates.rt_period_from <= '".$end_date."'
					) OR (
						rt_period_dates.rt_period_to >= '".$rv_reservation_item['rv_item_date_arrive']."'
						AND rt_period_dates.rt_period_to <= '".$end_date."'
					) OR (
						rt_period_dates.rt_period_from <= '".$rv_reservation_item['rv_item_date_arrive']."'
						AND rt_period_dates.rt_period_to >= '".$end_date."'
					)
				)
			ORDER BY 
				rt_period_dates.rt_period_from,
				rt_period_dates.rt_period_to
		",4);
		$rv_reservation_item['rt_period'] = $rate_period;


		$reservation['rv_reservation_items'][$rv_reservation_item['rv_reservation_item_ix']] = $rv_reservation_item;
	}
	return $reservation;
}

function clearExistingSpecial($rv_reservation_id) {
	global $lDB;

	db_rv_res_item_comp_rate_grp_set_discount_by_reservation($rv_reservation_id);

	db_rv_res_item_comp_set_discount_by_reservation($rv_reservation_id);

	db_rv_res_item_special_delete_by_reservation($rv_reservation_id);

	db_rv_reservation_item_set_discount_by_reservation($rv_reservation_id);

	db_rv_special_set_discount_by_reservation($rv_reservation_id);

	db_rv_reservation_set_discount($rv_reservation_id,0);

	recalcTotals($rv_reservation_id);

}

function getSpecialBenefits($rv_special_id) {
	global $lDB;

	$sp_rate_group_benefits = $lDB->get("
		SELECT
			sp_rate_group_benefit.sp_special_id,
			sp_rate_group_benefit.rt_rate_group_id,
			sp_rate_group_benefit.sp_discount_donor_property_id,
			sp_rate_group_benefit.sp_rate_group_recipients,
			sp_rate_group_benefit.sp_discount_nights,
			sp_rate_group_benefit.sp_discount_perc,
			sp_rate_group_benefit.sp_discount_amount,
			sp_rate_group_benefit.sp_free_nights_qty,
			sp_rate_group_benefit.sp_free_nights_rate_type
		FROM
			rv_special
			LEFT JOIN sp_rate_group_benefit ON rv_special.sp_special_id = sp_rate_group_benefit.sp_special_id
		WHERE
			rv_special.rv_special_ix = '" . $lDB->escape($rv_special_id) . "'
	",6);

	if (empty($sp_rate_group_benefits)) {
		return false;
	}

	$property_filter = "";

	$sp_accomm_types = $lDB->get("
		SELECT
			sp_accomm_type.ac_accomm_type_id,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc
		FROM
			sp_accomm_type
			LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sp_accomm_type.ac_accomm_type_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			sp_accomm_type.sp_special_id = '".$sp_rate_group_benefits[0]['sp_special_id']."'
			".$property_filter."
	",2);

	$sp_special_rate_types = $lDB->get("
		SELECT
			sp_special_rate_type.rt_rate_type_id
		FROM
			sp_special_rate_type
		WHERE
			sp_special_rate_type.sp_special_id = '".$sp_rate_group_benefits[0]['sp_special_id']."'
	",3);

	$benefits = array();
	$benefits['sp_rate_group_benefits'] = $sp_rate_group_benefits;
	$benefits['sp_accomm_types'] = $sp_accomm_types;
	$benefits['sp_special_rate_types'] = $sp_special_rate_types;

	return $benefits;
}
