<?php

function itemSpecialHaveApplied($itemId) {
	global $lDB;

	$amt_sp_discount = $lDB->get("
		SELECT
			SUM(rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_sp_discount) AS amt_sp_discount
		FROM
			rv_res_item_comp_rate_grp
			LEFT JOIN rv_res_item_comp ON rv_res_item_comp_rate_grp.rv_res_item_comp_id = rv_res_item_comp.rv_res_item_comp_ix
		WHERE
			rv_res_item_comp.rv_reservation_item_id = '".$itemId."'
	",4);

	if ($amt_sp_discount != 0) {
		return true;
	} else {
		return false;
	}
}

function itemSpecialItinLineIndicator($itemId) {
	if (itemSpecialHaveApplied($itemId)) {
		$special_indicator = '<span style="margin-left:5px; color:#FDD017; text-shadow: 0px 0px 0px rgba(0, 0, 0, 1);" title="Special applied">&#9733;</span>';
	} else {
		$special_indicator = '';
	}
	return $special_indicator;
}

function getSpecialHaveRateAmountOverrides($rv_reservation_id) {
	global $lDB;

	$overrides_items = $lDB->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_overide_amt
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '" . $rv_reservation_id . "'
	",6);

	foreach ($overrides_items as $item) {
		if(!is_null($item['rv_item_overide_amt'])) {
			return true;
		}
		$overrides_item_rte_grps = $lDB->get("
			SELECT
				rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt
			FROM
				rv_res_item_rate_grp
			WHERE
				rv_res_item_rate_grp.rv_reservation_item_id = '" . $item['rv_reservation_item_ix'] . "'
		",6);
		foreach ($overrides_item_rte_grps as $item_rte_grp) {
			if(!is_null($item_rte_grp['rv_res_item_rate_grp_overide_amt'])) {
				return true;
			}
		}
	}
	return false;
}

function getSpecialHaveVariances($rv_reservation_id) {

	$variances = $GLOBALS['lDB']->get("
		SELECT
			SUM(rv_res_item_comp.rv_item_comp_var)
		FROM
			rv_res_item_comp
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '" . $rv_reservation_id . "'
	",4);

	if ($variances != 0){
		return true;
	} else {
		return false;
	}
}

function getSpecialIndicationText($rv_reservation_id, $mode=0) {
	global $lDB;

	// Mode 0 : call from availability calendar
	// Mode 1 : call from reservation details

	$auto_application = (db_sc_group_get_user_setting("sc_grp_res_sp_apply_auto_yn") == "1") ? true : false;
	$manual_application = (db_sc_group_get_user_setting("sc_grp_res_sp_apply_man_yn") == "1") ? true : false;

	if($manual_application || $auto_application) {
		$specialManager = new SpecialManager($rv_reservation_id);
		$qualifyingSpecials = $specialManager->GetQualifyingSpecials();
		$qualifying = [];
		$combos = $specialManager->GetQualifyingCombos();

		foreach($combos as $sp_combo_id=>$specials) {
			$qualifying[] = [
				'type'=>"combo",
				'id'=>$sp_combo_id,
				'specials'=>$specials
			];
		}

		foreach($qualifyingSpecials as $special) {
			$qualifying[] = [
				'type'=>"single",
				'id'=>$special,
				'specials'=>[$special]
			];
		}

		$specials_count	= count($qualifyingSpecials);

		$current_specials = db_rv_special_get_specials_by_reservation($rv_reservation_id);
		$current_specials_count = sizeof($current_specials);

		$specialOverride = (db_rv_reservation_has_special_override($rv_reservation_id) ? ' (OVR)' : '');
		$reservation_invoiced = db_fn_invoice_exists_by_reservation($rv_reservation_id);

		if ($reservation_invoiced) {
			$manual_application = false;
		}

		// Increase number of specials for any inactive currently applied specials
		foreach($current_specials as $sp_special_id) {
			if(db_sp_special_inactive_check($sp_special_id)) {
				$specials_count++;
			}
		}

		$GLOBALS['temp']['hideApplySpecialsButton'] = ($manual_application) ? "" : " display: none;";
		$GLOBALS['temp']['hideSpecialsDisplay'] = ($manual_application || $auto_application) ? "" : " display: none;";

		if($current_specials_count > 0) {
			$qualifies_for_more = "";
			if(
				$manual_application
				&& $specials_count > $current_specials_count
			) {
				$extra = $specials_count - $current_specials_count;
				$qualifies_for_more = " (Qualifies for " . $extra . " other" . ($extra > 1 ? "s" : "") . ")";
			}
			if(sizeof($current_specials) > 1) {
				$special_overlib = [];
				foreach($current_specials as $sp_special_id) {
					$special_overlib[] = db_sp_special_get_desc($sp_special_id);
				}
				$appliedSpecialDesc = "
					<span onmouseout='nd();' data-tooltip='" . join("\n",$special_overlib) . "'>
						<i class=\"material-icons\" style=\"vertical-align: middle;\">info</i> Multiple specials applied
					</span>
				";
			} else {
				$appliedSpecialDesc = db_sp_special_get_desc($current_specials[0]);
			}
			$appliedSpecialDesc .= $specialOverride.$qualifies_for_more;
		} else {
			$appliedSpecialDesc = "No specials applied. Qualifies for ".$specials_count;
		}

		$qualifyingSuggested = [];
		if(sizeof($qualifying) > 0) {
			$qualifyingSuggested = $qualifying[0]['specials'];
		}
		$suggestedDefault = false;
		if(array_diff($qualifyingSuggested,$current_specials) == array_diff($current_specials, $qualifyingSuggested)) {
			$suggestedDefault = true;
		}
		if(
			$specials_count > 0
			&& !$suggestedDefault
			&& !$reservation_invoiced
		) {
			$defaultSpecialSuggestionDesc = '<div style="margin-top:10px;">
			';
			if(db_rv_reservation_has_special_override($rv_reservation_id)) {
				$defaultSpecialSuggestionDesc .= '
					Specials have been overridden.
				';
			} else {
				$defaultSpecialSuggestionDesc .= '
					This is not the default special application.<br>
				';
			}
			if($manual_application) {
				$defaultSpecialSuggestionDesc .= '
				<button class="button" onclick="recordSpecials(\'2\', \''.$rv_reservation_id.'\', \'0\', \''.join("_", $qualifyingSuggested).'\',\'0\');" style="width: 100px; height: 20px; margin-top: 5px;" type="button">
					Apply Default
				</button>
				';
			}
			$defaultSpecialSuggestionDesc .= '
				</div>';
		} else {
			$defaultSpecialSuggestionDesc = '<div style="margin-top:10px;">
				This is the default special application
				</div>';
		}

		if ($mode == 1) {
			$data['defaultSpecialSuggestionDesc'] = $defaultSpecialSuggestionDesc;
			$data['appliedSpecialDesc'] = $appliedSpecialDesc;
			return $data;
		} else {
			$GLOBALS['temp']['defaultSpecialSuggestionDesc'] = $defaultSpecialSuggestionDesc;
			$GLOBALS['temp']['appliedSpecialDesc'] = $appliedSpecialDesc;
		}
		
	}
}

function getSpecialItemDetails($rv_reservation_item_id) {
	global $lDB;
	$rate_groups = array();

	$qtys = $lDB->get("
		SELECT
			rv_res_item_rate_grp.rt_rate_group_id,
			rv_res_item_rate_grp.rv_res_item_rate_grp_count
		FROM
			rv_res_item_rate_grp
		WHERE
			rv_res_item_rate_grp.rv_reservation_item_id = '".$rv_reservation_item_id."'
	",2);

	foreach ($qtys as $rategroup) {
		$rate_groups[$rategroup['rt_rate_group_id']]['qty'] = $rategroup['rv_res_item_rate_grp_count'];
		$rate_groups[$rategroup['rt_rate_group_id']]['gross'] = 0;
		$rate_groups[$rategroup['rt_rate_group_id']]['discount'] = 0;
	}

	$rv_res_item_comps = $lDB->get("
		SELECT
			rv_res_item_comp.rv_res_item_comp_ix,
			rv_res_item_comp.rv_item_comp_amt_gross,
			rv_res_item_comp.rv_item_comp_amt_sp_discount,
			rv_res_item_comp.rv_item_comp_comm_ind
		FROM
			rv_res_item_comp
		WHERE
			rv_res_item_comp.rv_reservation_item_id = '".$rv_reservation_item_id."'
	",2);

	foreach ($rv_res_item_comps as $rv_res_item_comp) {
		$rv_res_item_comp_rate_grps = $lDB->get("
			SELECT
				rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix,
				rv_res_item_comp_rate_grp.rt_rate_group_id,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_gross,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_sp_discount
			FROM
				rv_res_item_comp_rate_grp
			WHERE
				rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$rv_res_item_comp['rv_res_item_comp_ix']."'
			ORDER BY
				rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix
		",2);

		foreach ($rv_res_item_comp_rate_grps as $rv_res_item_comp_rate_grp) {
			$rate_groups[$rv_res_item_comp_rate_grp['rt_rate_group_id']]['gross'] += $rv_res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_gross'];
			$rate_groups[$rv_res_item_comp_rate_grp['rt_rate_group_id']]['discount'] += $rv_res_item_comp_rate_grp['rv_item_comp_rate_grp_amt_sp_discount'];
		}
	}
	
	return $rate_groups;
}

function getPaxSummary($reservationId) {
	$reservationDetails = getReservationdetails($reservationId);

	$rategroup_names = array();
	$totals = array();
	$bednights = 0;
	$paxSummary = "";
	$bg_colour1 = "#fff";
	$bg_colour2 = "#ddd";
	$bg_colour = "";

	$paxRateGroup =  $GLOBALS['lDB']->get("
		SELECT
			rt_rate_group_ix 
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_sys_code = 99
	",4);

	$unitRateGroup =  $GLOBALS['lDB']->get("
		SELECT
			rt_rate_group_ix 
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_sys_code = 1
	",4);

	foreach ($reservationDetails['reservationBedNights'] as $rategroup => $qty) {
		if ($rategroup != $paxRateGroup) {
			$rategroup_names[$rategroup] = getRateGroupDesc($rategroup);
			$last_rategroup_id = $rategroup;
		}
		if ($rategroup != $paxRateGroup && $rategroup != $unitRateGroup) {
			$bednights += $qty;
		}
	}

	// Start wrapper
	$paxSummary .= '<table width="770" cellspacing="0" cellpadding="0" align="center" style="table-layout:fixed;">
	<tr>
		<td width="120" valign="top">';
	$paxSummary .= '<table width="120" border="0" cellpadding="2" cellspacing="0" class="outLt" style="table-layout:fixed; border-right-style: none;">
	<tr>
	<td class="" height="37">&nbsp;</td>
	</tr>';

	// Properties
	foreach ($reservationDetails['propertyRateGroups'] as $property => $days) {
		$property_name = db_per_persona_get_name_last($property);
		$paxSummary .= '<tr><td height="18" class="bt" style="overflow:hidden; white-space: nowrap;" title="'.$property_name.'">'.$property_name.'</td></tr>';
	}
	$paxSummary .= "<tr><td height='18' class='bt'>Total: Rate Groups</td></tr>";
	$paxSummary .= "</table>";

	$paxSummary .= '</td><td width="648" align="left">';
	$paxSummary .= '<div style="text-align:left;" class="scrollX bl br" align="left">';

	$table_width = 32 * (count($rategroup_names)+1) * ( (strtotime($reservationDetails['departDate']) - strtotime($reservationDetails['arrivalDate'])) / 86400 );
	$paxSummary .= '<table width="'.$table_width.'" border="0" cellpadding="2" cellspacing="0" class="outLt" align="left" style="table-layout:fixed;">';

	// Dates
	$date = $reservationDetails['arrivalDate'];
	$paxSummary .= '<tr class="expand">';
	while ($date < $reservationDetails['departDate']){
		$br = ($date == date('Y-m-d', strtotime($reservationDetails['departDate'] . ' - 1 day'))) ? '' : 'br';
		$paxSummary .= '<td height="18" colspan="'.(count($rategroup_names)+1).'" class="'.$br.' bb" align="center">'.date('d M Y', strtotime($date)).'</td>';
		$date = date('Y-m-d', strtotime($date . ' + 1 day'));
	}
	$paxSummary .= "</tr>";

	// Rate group names
	$paxSummary .= '<tr>';
	$date = $reservationDetails['arrivalDate'];
	while ($date < $reservationDetails['departDate']){
		foreach ($rategroup_names as $rategroup_id => $rategroup) {
			$br = ($date == date('Y-m-d', strtotime($reservationDetails['departDate'] . ' - 1 day'))) ? '' : 'br';
			$paxSummary .= '<td height="18" width="32" class="br bb" style="white-space:nowrap; text-align:center;" title="'.$rategroup['rt_rate_group_desc'].'">'.$rategroup['rt_rate_group_abbrv'].'</td>';
			$totals[$date][$rategroup_id] = 0;
		}
		$totals[$date]['pax'] = 0;
		$paxSummary .= '<td height="18" width="32" class="'.$br.' bb" style="white-space:nowrap; text-align:center;" title="PAX">PAX</td>';
		$date = date('Y-m-d', strtotime($date . ' + 1 day'));
	}
	$paxSummary .= "</tr>";

	// Pax
	foreach ($reservationDetails['propertyRateGroups'] as $property => $days) {
		$bg_colour = "";
		$date = $reservationDetails['arrivalDate'];
		$paxSummary .= '<tr style="background-color: rgb(255, 255, 255);" onmouseout="this.style.backgroundColor = \'#fff\';" onmouseover="this.style.backgroundColor = \'#cfc\';">';

		while ($date < $reservationDetails['departDate']){
			$bg_colour = ($bg_colour == $bg_colour1) ? $bg_colour2 : $bg_colour1;	// zebra striping days
			$pax_subtotal = 0;
			foreach ($rategroup_names as $rategroup_id => $rategroup) {
				$br = ($date == date('Y-m-d', strtotime($reservationDetails['departDate'] . ' - 1 day'))) ? '' : 'br';
				if (isset($days[$date][$rategroup_id])) {
					$paxSummary .= '<td height="18" width="67" class="br bb txt" style="width:32px; background-color: '.$bg_colour.'; text-align:center;" title="'.$rategroup['rt_rate_group_desc'].'">'.$days[$date][$rategroup_id].'</td>';
					$totals[$date][$rategroup_id] += $days[$date][$rategroup_id];
					if ($rategroup_id != $unitRateGroup) {
						$pax_subtotal += $days[$date][$rategroup_id];
						$totals[$date]['pax'] += $days[$date][$rategroup_id];
					}
				} else {
					$paxSummary .= '<td height="18" width="32" class="br bb txt" style="background-color: '.$bg_colour.';">&nbsp;</td>';
				}
			}
			$paxSummary .= '<td height="18" width="67" class="'.$br.' bb txt" style="width:32px; background-color: '.$bg_colour.'; text-align:center;" title="PAX">'.$pax_subtotal.'</td>';
			$date = date('Y-m-d', strtotime($date . ' + 1 day'));
		}
		$paxSummary .= "</tr>";
	}

	// Totals
	$date = $reservationDetails['arrivalDate'];
	$paxSummary .= "<tr>";
	while ($date < $reservationDetails['departDate']){
		foreach ($rategroup_names as $rategroup_id => $name) {
			$br = ($date == date('Y-m-d', strtotime($reservationDetails['departDate'] . ' - 1 day'))) ? '' : 'br';
			if ($totals[$date][$rategroup_id] != 0) {
				$paxSummary .= '<td height="18" class="br" title="'.$rategroup['rt_rate_group_desc'].'" style="text-align:center;">'.$totals[$date][$rategroup_id].'</td>';
			} else {
				$paxSummary .= '<td height="18" class="br">&nbsp;</td>';
			}
		}
		$paxSummary .= '<td height="18" class="'.$br.'" title="PAX" style="text-align:center;">'.$totals[$date]['pax'].'</td>';
		$date = date('Y-m-d', strtotime($date . ' + 1 day'));
	}
	$paxSummary .= "</tr>";




	$paxSummary .= "</table>";

	$paxSummary .= '</div>
			</td>
		</tr>
	</table>';

	$result['paxsummary'] = $paxSummary;
	$result['reservationBedNights'] = $bednights;

	return $result;
	
}

function getReservationdetails($reservationId) {
	global $lDB;
	$reservationDetails = array();

	$all_items = $lDB->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_date_added,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.rv_item_date_changed,
			rv_reservation_item.rv_item_nights,
			rv_reservation_item.rv_item_split_yn,
			rv_reservation_item.rt_rate_type_id,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.pr_business_id,
			rv_reservation_item.rv_item_timestamp
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '".$reservationId."'
	",2);	

	foreach ($all_items as $key => $item){
		$all_items[$key]['rate_groups'] = $lDB->get("
			SELECT
				rv_res_item_rate_grp.rt_rate_group_id,
				rv_res_item_rate_grp.rv_res_item_rate_grp_count
			FROM
				rv_res_item_rate_grp
			WHERE
				rv_res_item_rate_grp.rv_reservation_item_id ='".$item['rv_reservation_item_ix']."'
		",2);

	};


	$reservationDetails['itineraries'] = $all_items;
	$reservationDetails['reservationId'] = $reservationId;

	$reservation = $lDB->get("
		SELECT
			rv_commission_perc,
			rv_confirmation_date,
			rv_date_arrive,
			rv_date_depart,
			rt_rate_type_id				
		FROM
			rv_reservation
		WHERE 
			rv_reservation.rv_reservation_ix = '".$reservationId."'
	",1);

	$unitRateGroup =  $GLOBALS['lDB']->get("
		SELECT
			rt_rate_group_ix 
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_sys_code = 1
	",4);

	$paxRateGroup =  $GLOBALS['lDB']->get("
		SELECT
			rt_rate_group_ix 
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_sys_code = 99
	",4);

	$reservationDetails['commPerc'] = $reservation['rv_commission_perc'];

	if ($reservation['rv_confirmation_date'] != "" && $reservation['rv_confirmation_date'] != "0000-00-00"){
		$reservationDetails['bookingDate'] = $reservation['rv_confirmation_date'];
	} else {
		$reservationDetails['bookingDate'] = date("Y-m-d");	
	}

	if ($reservation['rv_date_arrive'] != ""){
		$reservationDetails['arrivalDate'] = $reservation['rv_date_arrive'];
	} else {
		$reservationDetails['arrivalDate'] = $reservationDetails['itineraries'][0]['rv_item_date_arrive'];
	}

	if ($reservation['rv_date_depart'] != ""){
		$reservationDetails['departDate'] = $reservation['rv_date_depart'];
	} else {
		$reservationDetails['departDate'] = $reservationDetails['itineraries'][0]['rv_item_date_depart'];
	}

	if ($reservation['rt_rate_type_id'] != ""){
		$reservationDetails['rateType'] = $reservation['rt_rate_type_id'];
	} else {
		$reservationDetails['rateType'] = $reservationDetails['itineraries'][0]['rt_rate_type_id'];
	}


	// Lead time
	$reservationDetails['leadTime'] = floor((strtotime($reservationDetails['arrivalDate'])-strtotime($reservationDetails['bookingDate']))/(60*60*24));



	// Initialise arrays
	foreach ($reservationDetails['itineraries'] as $item){
		$reservationDetails['accommTypes'][$item['pr_business_id']] = array();
		foreach ($item['rate_groups'] as $rate_group){
			$reservationDetails['reservationBedNights'][$rate_group['rt_rate_group_id']] = 0;
			$reservationDetails['propertyBedNights'][$item['pr_business_id']][$rate_group['rt_rate_group_id']] = 0;
		}
		$reservationDetails['reservationBedNights'][$paxRateGroup] = 0;
		$reservationDetails['propertyBedNights'][$item['pr_business_id']][$paxRateGroup] = 0;
	}


	// Bed nights
	$pax = 0;
	foreach ($reservationDetails['itineraries'] as $item){
		if (!in_array($item['ac_accomm_type_id'], $reservationDetails['accommTypes'][$item['pr_business_id']])){
			$reservationDetails['accommTypes'][$item['pr_business_id']][] = $item['ac_accomm_type_id'];
		}

		foreach ($item['rate_groups'] as $rate_group){

			if ($rate_group['rt_rate_group_id'] != $unitRateGroup){
				$reservationDetails['reservationBedNights'][$rate_group['rt_rate_group_id']] += $item['rv_item_nights'] * $item['rv_item_accomm_count'] * $rate_group['rv_res_item_rate_grp_count'];

				$reservationDetails['propertyBedNights'][$item['pr_business_id']][$rate_group['rt_rate_group_id']] += $item['rv_item_nights'] * $item['rv_item_accomm_count'] * $rate_group['rv_res_item_rate_grp_count'];

				$reservationDetails['propertyBedNights'][$item['pr_business_id']][$paxRateGroup] += $item['rv_item_nights'] * $item['rv_item_accomm_count'] * $rate_group['rv_res_item_rate_grp_count'];
				$reservationDetails['reservationBedNights'][$paxRateGroup] += $item['rv_item_nights'] * $item['rv_item_accomm_count'] * $rate_group['rv_res_item_rate_grp_count'];
			}



		}
	}

	// Number of properties

	$reservationDetails['allResPeriods'] = array();
	foreach ($reservationDetails['itineraries'] as $itinerary){
		$period_dates = $lDB->get("
			SELECT
				rt_period_ix
			FROM
				rt_period
				INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
			WHERE ( 
				(
					rt_period_dates.rt_period_from >= '".$itinerary['rv_item_date_arrive']."'
					AND rt_period_dates.rt_period_from < '".$itinerary['rv_item_date_depart']."'
				) OR (
					rt_period_dates.rt_period_to >= '".$itinerary['rv_item_date_arrive']."'
					AND rt_period_dates.rt_period_to <= '".$itinerary['rv_item_date_depart']."'
				) OR (
					rt_period_dates.rt_period_from <= '".$itinerary['rv_item_date_arrive']."'
					AND rt_period_dates.rt_period_to >= '".$itinerary['rv_item_date_depart']."'
				)
			)

		",3);

		$reservationDetails['allResPeriods'] = array_merge($reservationDetails['allResPeriods'], $period_dates);
	}
	
	// Rate group quantities
	$reservationDetails['reservationRateGroups'] = reservationGetTotalPax($reservationDetails, 1, '');
	foreach ($reservationDetails['accommTypes'] as $propertyId => $accommType){
		$reservationDetails['propertyRateGroups'][$propertyId] = reservationGetTotalPax($reservationDetails, 2, $propertyId);
	}
	return($reservationDetails);
}

// Tries to work out the total number of pax per rate group for the reservation
// level 	: Reservation (1), property (2) or accommodation type (3) level
// paxonly 	: Set to true if you're only intersted in the total number of people
function reservationGetTotalPax($reservationDetails, $level=1, $id="") {
	if ($level != 1 && $id == ""){
		return false;
	}

	$date = $reservationDetails['arrivalDate'];

	$unitRateGroup =  $GLOBALS['lDB']->get("
		SELECT
			rt_rate_group_ix 
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_sys_code = 1
	",4);

	$paxRateGroup =  $GLOBALS['lDB']->get("
		SELECT
			rt_rate_group_ix 
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_sys_code = 99
	",4);

	while ($date < $reservationDetails['departDate']){
		$rate_groups[$date] = array();
		$pax = 0;
		$rate_groups[$date][$unitRateGroup] = 0;
		
		foreach ($reservationDetails['itineraries'] as $item){

			if (($level == 1) || ($level == 2 && $item['pr_business_id'] == $id) || $level == 3 && $item['ac_accomm_type_id'] == $id){
				if ($date >= $item['rv_item_date_arrive'] && $date < $item['rv_item_date_depart']){
					// Unfortunately we have to first find number of rooms
					foreach ($item['rate_groups'] as $rate_group){
						if ($rate_group['rt_rate_group_id'] == $unitRateGroup){
							$rate_groups[$date][$unitRateGroup] += $rate_group['rv_res_item_rate_grp_count'];
							$rooms = $rate_group['rv_res_item_rate_grp_count'];
						}
					}
					$rooms = (!isset($rooms)) ? 1 : $rooms; 	// Fallback until TBA check is implemented
					foreach ($item['rate_groups'] as $rate_group){
						if ($rate_group['rt_rate_group_id'] != $unitRateGroup){
							if (array_key_exists($rate_group['rt_rate_group_id'], $rate_groups[$date])){
								$rate_groups[$date][$rate_group['rt_rate_group_id']] += $rate_group['rv_res_item_rate_grp_count'] * $rooms;	
							} else {
								$rate_groups[$date][$rate_group['rt_rate_group_id']] = $rate_group['rv_res_item_rate_grp_count'] * $rooms;
							}
							$pax = $pax + ($rate_group['rv_res_item_rate_grp_count'] * $rooms);
						}
					}	

				}
			}
		}
		$rate_groups[$date][$paxRateGroup] = $pax;

		$date = date('Y-m-d', strtotime($date . ' + 1 day'));
	}
	if (!isset($rate_groups) || empty($rate_groups)) {
		return false;
	}
	return $rate_groups;

}
