<?php

function getSpecialRateGroups($sp_special_id, $pr_business_id=false) {
	global $lDB;
	
	$rateGroups = array();

	if ($pr_business_id !== false){
		$table = "sp_prop_rate_group";
		$prop_join = " AND $table.pr_business_id = '".$pr_business_id."'";
	} else {
		$table = "sp_rate_group_qualify";
		$prop_join = "";
	}

	$rateGroups = $lDB->get("
		SELECT 
			rt_rate_group.rt_rate_group_ix,
			rt_rate_group.rt_rate_group_desc,
			$table.sp_rate_group_count,
			$table.sp_rate_group_nights,
			$table.sp_rate_group_bed_nights,
			rt_rate_group.rt_rate_group_class
		FROM
			rt_rate_group
			INNER JOIN $table ON $table.rt_rate_group_id = rt_rate_group.rt_rate_group_ix AND $table.sp_special_id = '".$sp_special_id."' $prop_join
		WHERE
			rt_rate_group.rt_rate_group_inactive_yn = 0
			
		ORDER BY
			rt_rate_group.rt_rate_group_class,
			rt_rate_group.rt_rate_group_desc
	",2);
	
	return $rateGroups;
}

// Provides the Javascript and HTMl for a YUI rate group table
function createSpecialRateGroupTable($pr_business_id=false, $read_only=false) {
	global $lDB;

	$result = array();

	if ($pr_business_id !== false){
		$prefix = "_$pr_business_id";
	} else {
		$prefix = "";
	}


	// Rate Group Table JAVASCRIPT
	$rateGroups = getSpecialRateGroups($_SERVER['argv'][1], $pr_business_id);
	$rateGroupData = array();
	foreach ($rateGroups as $rateGroup){
		$count = ($rateGroup['sp_rate_group_count'] == "") ? 0 : $rateGroup['sp_rate_group_count'];
		$nights = ($rateGroup['sp_rate_group_nights'] == "") ? 0 : $rateGroup['sp_rate_group_nights'];
		$bed_nights = ($rateGroup['sp_rate_group_bed_nights'] == "") ? 0 : $rateGroup['sp_rate_group_bed_nights'];
		$rateGroupData[] = "{rate_group_id:'".$rateGroup['rt_rate_group_ix']."', rate_group_desc:'".$rateGroup['rt_rate_group_desc']."', count:'".$count."', nights:'".$nights."', bed_nights:'".$bed_nights."'}";
	}

	// [START] All rate groups dropdown
	$allRateGroups = $lDB->get("
		SELECT 
			rt_rate_group.rt_rate_group_ix,
			rt_rate_group.rt_rate_group_desc
		FROM
			rt_rate_group
		WHERE
			rt_rate_group.rt_rate_group_inactive_yn = 0
		ORDER BY
			rt_rate_group.rt_rate_group_class,
			rt_rate_group.rt_rate_group_desc
	",2);

	$rateGroupOptions = "";
	foreach ($allRateGroups as $rateGroup){
		$rateGroupOptions .= "
			<option value=\"".$rateGroup['rt_rate_group_ix']."\">".$rateGroup['rt_rate_group_desc']."</option>
		";	
	}
	// [END] All rate groups dropdown

	$result['displayHTML'] = "

		<table style=\"border: 1px inset rgb(153, 153, 153);\">
			<tr>
				<td width=\"50px\">
					<select id=\"new_rate_group$prefix\" name=\"new_rate_group$prefix\" class=\"input_dropdown\">
						".$rateGroupOptions."
					</select>
				</td>
				<td>
					<span id=\"add$prefix\" class=\"yui-button yui-push-button\">
						<span class=\"first-child\">
							<button type=\"button\" class=\"button\">Add Row</button>
						</span>
					</span>
				</td>
			</tr>
			<tr>
				<td colspan=\"2\">
					<div id=\"yui_dt_rate_groups$prefix\"></div>
				</td>
			</tr>
		</table>
		<div class=\'txts\'>Click on individual cells to edit values.</div>
	";

	$result["displayJS"] = "
		rate_group_table_data$prefix = {
			rate_groups: [
				".join($rateGroupData,",")."
			]
		}
	
		YAHOO.util.Event.addListener(window, \"load\", function() {
			yui_dt_rate_groups$prefix = function() {

				var myColumnDefs = [
					{key:\"rate_group_desc\", label: \"Rate Group\", width:100},
					{key:\"count\", label: \"Count\", width: 55, editor: new YAHOO.widget.TextboxCellEditor({validator:YAHOO.widget.DataTable.validateNumber}),className: 'align-center'},
					{key:\"nights\", label: \"Nights\", width: 55, editor: new YAHOO.widget.TextboxCellEditor({validator:YAHOO.widget.DataTable.validateNumber}),className: 'align-center'},
					{key:\"bed_nights\", label: \"Bed Nights\", width: 55, editor: new YAHOO.widget.TextboxCellEditor({validator:YAHOO.widget.DataTable.validateNumber}),className: 'align-center'},
					{key:\"delete\",label:\" \", width: 5,className:\"delete-icon\"}    
				];

				var myDataSource = new YAHOO.util.DataSource(rate_group_table_data$prefix.rate_groups);
				myDataSource.responseType = YAHOO.util.DataSource.TYPE_JSARRAY;
				myDataSource.responseSchema = {
					fields: [\"rate_group_desc\",\"count\",\"nights\",\"bed_nights\",{key:\"rate_group_id\"}]
				};

				var myDataTable = new YAHOO.widget.DataTable(\"yui_dt_rate_groups$prefix\", myColumnDefs, myDataSource, {});

				// Set up editing flow
				var highlightEditableCell = function(oArgs) {
					var elCell = oArgs.target;
					if(YAHOO.util.Dom.hasClass(elCell, \"yui-dt-editable\")) {
						this.highlightCell(elCell);
					}
				};".( ($read_only) ? "" : "myDataTable.subscribe(\"cellClickEvent\", myDataTable.onEventShowCellEditor);" )."

				var getNewRowData = function() {
					var new_rg_desc = YAHOO.util.Dom.get(\"new_rate_group$prefix\").options[YAHOO.util.Dom.get(\"new_rate_group$prefix\").selectedIndex].text;
					var new_rg_id = YAHOO.util.Dom.get(\"new_rate_group$prefix\").value;
					return {row:0, rate_group_desc: new_rg_desc, count:\"0\", nights:\"0\", bed_nights:\"0\", rate_group_id: new_rg_id};
				};

				var handleClick = function(){
					var button = this.get(\"id\");
					switch(button){
					case \"add$prefix\":
						var new_rg_id = YAHOO.util.Dom.get(\"new_rate_group$prefix\").value;
						var rate_group_RS = myDataTable.getRecordSet();
						for (var i=0; i < rate_group_RS.getLength(); i++){
							record = rate_group_RS.getRecord(i).getData();
							if(record['rate_group_id'] == new_rg_id){
								return;
							}
						}
						myDataTable.addRow(getNewRowData(), 0);
						return;
					case \"del$prefix\":
						var selected = myDataTable.getSelectedRows();
						for (i=0; i < selected.length; i++){
							myDataTable.deleteRow(selected[i]);	
						}
						
						return;
					}
					
				}

				var btnAdd = new YAHOO.widget.Button(\"add$prefix\"); 
				btnAdd.on(\"click\", handleClick); 
				";
	
	if (!$read_only) {
		// Delete button
		$result["displayJS"] .= "
			myDataTable.on('cellClickEvent',function(oArgs) {
				var target = oArgs.target,
					record = this.getRecord(target),
				    column = this.getColumn(target);
				if (column.key == 'delete') {
					myDataTable.deleteRow(target);
				}
			});";
	}
			
	$result["displayJS"] .= "
				return {
					oDS: myDataSource,
					oDT: myDataTable
				};
			}();

			$(\"#form_clean\").val( form_change_check() );
			wait.hide();
			
		});



	";

	if ($pr_business_id !== false){

		$result["buildURLJS"] = "
			var rate_group_RS = yui_dt_rate_groups$prefix.oDT.getRecordSet();
			var jsArray = [];
			for (var i=0; i < rate_group_RS.getLength(); i++){
				jsArray.push(rate_group_RS.getRecord(i).getData())
			}
			rateGroupsArray['$pr_business_id'] = jsArray;

			var rate_group_data = JSON.stringify(rateGroupsArray);	
		";

	} else {

		$result["buildURLJS"] = "
			var rate_group_RS = yui_dt_rate_groups.oDT.getRecordSet();
			var jsArray = [];
			for (var i=0; i < rate_group_RS.getLength(); i++){
				jsArray.push(rate_group_RS.getRecord(i).getData())
			}
			
			rate_group_data = JSON.stringify(jsArray);
		";

	}

	return $result;
}
