<?php

/**
 * functions.system.php - System specific function library
 */

require_once(__DIR__ . "/db.fn_folio.php");
require_once(__DIR__ . "/db.pf_option.php");


// combolist generation technique (copyleft) glowworm 2002 - assemble combo array from var
// =======================================================================================
function combolist (&$db,$sql,$default="",$div=", ") {
	# generate array 'value-displayname'
	$grr = explode(",",$sql);
	$templist = $db->get($sql,"2");                    # from sql and the default parameter
	$list = array($default);                           # for a formfield object combobox
	cleanse($templist);
	$countup = 0;
	if(strpos($grr[0],"_db") !== false) {
		$countup = 1;
	}
	$jup = $countup + 1;
	for ($i = 0; $i < sizeof($templist); $i++) {
		$row = $templist[$i];
		$push = "";
		for ($j = 0; $j < sizeof($row); $j++) {
			$field = "";
			if(array_key_exists($j,$row)) {
				$field = $row[$j];
			}
			if ($j > $jup && $field != "") { $push .= $div; }
			$push .= $field;
			if ($j == $countup) { $push .= ":|:"; }
		}
		array_push($list,$push);
	}

	cleanse($list);
	if (sizeof($list) < "1") {
		return array(" - None");
	}
	return $list;
}


// basic action library (copyleft) glowworm 2002 - execute action depending on coordinates
// =======================================================================================
function go ($db,&$form,$paction=2,$pmode=0) {
	if($GLOBALS['debug'] >= "1") {                            # Debug Information
		echo "(".$form->Name.".$paction.$pmode) - [Record: ".$GLOBALS['record']."] <br>";
	}
	if($paction == "2") {
		$GLOBALS['backuprecord'] = $GLOBALS['record'];
	}
	if($paction >= "2" && $paction <= "4") {                # Pass "forms+submits" (2,3,4) to action 2
		$action = "2";
	} else {
		$action = $paction;
	}

	$record = "";
	$delrecord = "";
	if(array_key_exists('initrecord',$GLOBALS)) {
		$record = $GLOBALS['initrecord'];
	}
	if(array_key_exists('delrecord',$GLOBALS)) {
		$delrecord = $GLOBALS['delrecord'];
	}

	switch ($action) {
	case (0) :  # Display List (done)
		return $form->Show($paction,$db);
		break;
	case (1) :  # Display Record (done)
		return $form->Show($paction);
		break;
	case (2) :  # Add / Update / Delete Record (done)
		switch ($pmode) {
		case (0) :  # Display Form / Confirmation
			return $form->Show($paction,$db,$record);
			break;
		case (1) :  # Add/Update/Delete Record DB
			if ($form->Submit($paction,$delrecord)) {
				return true;
			} else {
				return false;
			}
			break;
		}
		break;
	default :  # Future Action - To be added
		break;
	}
}

// initform - initialise a form
// ============================
function initform($db,$formid,$action,$pmode="") {
	//  Start TIMER
	//  -----------
	$astimer = explode( ' ', microtime() );
	$astimer = $astimer[1] + $astimer[0];
	//  -----------

	global $lDB;
	global $dbcode;
	global $isConsultant;
	global $userStatusId;
	global $calAgentId;

	$form = "form".$formid;
	$record = "";
	$record2 = "";
	if(sizeof($_SERVER['argv']) > 1) {
		$record = $_SERVER['argv'][1];
	}
	if(sizeof($_SERVER['argv']) > 2) {
		$record2 = $_SERVER['argv'][2];
	}

	$incpage = "init.".$form.".php";       #  Depending on Formid, prepare form + fields
	$funcpage = "init.".$form.".func.php";
	if (is_file(__DIR__ . "/" . $funcpage)) {
		require_once(__DIR__ . "/" . $funcpage);
	}
	include(__DIR__ ."/$incpage");
	$GLOBALS['addCheckFailed'] = false;
	if(isset($GLOBALS[$form]) && strpos($GLOBALS[$form]->FormHTML,"TOP_CONTENTS") !== false) {
		$GLOBALS['isPopup'] = false;
		//    if($pmode==1) {
		// Random string used to prevent duplicate updates/adds/etc on refresh
		$GLOBALS['addCheckPrev'] = isset($_SESSION['addCheck'])?$_SESSION['addCheck']:"";
		$GLOBALS['addCheck'] = md5(uniqid(rand(),1));
		while($GLOBALS['addCheckPrev'] == $GLOBALS['addCheck']) {
			$GLOBALS['addCheck'] = md5(uniqid(rand(),1));
		}
		session_set("addCheck",$GLOBALS['addCheck']);
		//    }
	}
	//  End TIMER
	//  ---------
	$aetimer = explode( ' ', microtime() );
	$aetimer = $aetimer[1] + $aetimer[0];
	if ($GLOBALS['showScriptSpeed']) {
		if ($GLOBALS['showScriptSpeedLoc'] == "screen") {
			echo "<center>";
			printf( "Script timer: <b>%f</b> seconds.", ($aetimer-$astimer) );
			echo '</center>';
		} else {
			echo "<!-- ";
			printf( "Script timer: <b>%f</b> seconds.", ($aetimer-$astimer) );
			echo " -->";
		}
	}
	//  ---------
}

// legendary blowfish technique (copyleft) glowworm 2002 - run several actions in sequence
// =======================================================================================
global $cords;
function blowfish (&$db,$cords) {   # cords = "action(,mode):formid:show"
	$size = sizeof($cords);       # according to cords 'array', execute a queue
	$p = $size--;              # of actions in order, displaying only those
	$out = array();               # flagged for output, otherwise testing results
	$tempout = array();
	$history_check = true;
	foreach ($cords as $cord) {
		$temp1 = explode(":",$cord);
		if (strpos($temp1[0],",") !== false) {
			list($action, $mode) = explode(",",$temp1[0]);
		} else {
			$action = $temp1[0];
			$mode = "0";
		}
		$formid = $temp1[1];
		$show = $temp1[2];
		initform($db,$formid,$action,$mode);
		$formname = "form".$formid;
		if ($show == "1") {
			$tempout = array ($formname => showpage(go($db,$GLOBALS[$formname],$action,$mode)));
			$out = array_merge($out,$tempout);
		} else {
			if (!go($db,$GLOBALS[$formname],$action,$mode)) {
				$out['error'] = " [<b>$formname($action,$mode)</b>](DB): ".$db->error."<br>"
				. " [<b>$formname($action,$mode)</b>](Form): ".$GLOBALS[$formname]->error;
			}
		}
		// Only add non-update actions to the history
		if ($mode != "0") {
			$history_check = false;
		}
	}
	if($history_check) {
    historyAdd();
	}
	return $out;
}

function isAgent($pr_user_id) {
	global $lDB;

	if ($lDB->get("select count(*) from pr_agent where pr_agent_id = '$pr_user_id' and pr_agent_inactive_yn=0",4) == "0") {
		return false;
	}
	return true;
}

# Verify Internal Staff Role
function idBusLink($pr_user_id) {
	global $lDB;
	# identify business link
	$busArray = $lDB->get("
		SELECT
			pr_link.pr_link_to
		FROM
			pr_link
			INNER JOIN pr_business ON pr_link.pr_link_to = pr_business.pr_business_id
		WHERE
			pr_link.pr_link_from = '$pr_user_id'
			AND pr_link.rf_link_type_id='RS1'
			AND pr_business.pr_bus_inactive_yn=0
	","2");
	$busRows = sizeof($busArray);

	if ($busRows == 0) {
		$pr_business_link = 0;
	} else {
		$pr_business_link = $busArray[0][0];
	}
	return $pr_business_link;
}

# Verify Agent Role
function idAgentLink($pr_user_id) {
	global $lDB;
	# check for direct agent role
	if ($lDB->get("SELECT COUNT(pr_agent_id) FROM pr_agent WHERE pr_agent_id = '$pr_user_id' AND pr_agent_inactive_yn = 0",4) > 0) {
		$pr_agent_link = $pr_user_id;
		return;
	}

	# check for agent relationship link
	$agentArray = $lDB->get("
		SELECT
			pr_link.pr_link_to
		FROM
			pr_link
			INNER JOIN pr_agent ON pr_link.pr_link_to = pr_agent.pr_agent_id
		WHERE
			pr_link.pr_link_from='$pr_user_id'
			AND pr_link.rf_link_type_id='RS2'
			AND pr_agent.pr_agent_inactive_yn=0
	",2);
	$agentRows = sizeof($agentArray);

	if ($agentRows == 0) {
		$pr_agent_link = 0;
	} else {
		$pr_agent_link = $agentArray[0][0];
	}
	return $pr_agent_link;
}

# Retrieve the user's access group details
function idGroup($pr_user_id) {
	global $lDB;
	global $pr_agent_link;
	global $pr_business_link;
	global $is_an_agent;
	if ($pr_agent_link == "0" && $pr_business_link == "0" && $is_an_agent == "0") {
		$groupSql = "
			SELECT
				sc_group_id,
				sc_grp_avail_limit,
				sc_grp_avail_limit_yn,
				sc_grp_alloc_ind,
				sc_grp_desc
			FROM
				sc_group
			WHERE
				sc_grp_inactive_yn = 0
				AND sc_grp_sys_code = '5'
		";
	} else {
		$groupSql = "
			SELECT
				sc_user.sc_group_id,
				sc_group.sc_grp_avail_limit,
				sc_group.sc_grp_avail_limit_yn,
				sc_group.sc_grp_alloc_ind,
				sc_group.sc_grp_desc
			FROM
				sc_user
				INNER JOIN sc_group ON sc_user.sc_group_id = sc_group.sc_group_id
			WHERE
				sc_user.pr_user_id='$pr_user_id'
				AND sc_group.sc_grp_inactive_yn = 0
		";
	}
	$grpArray = $lDB->get($groupSql,1);

	#  Set up result array
	$groupArray = array();
	if($grpArray !== false) {
		$groupArray['sc_group_id'] = $grpArray[0];
		$groupArray['sc_grp_avail_limit'] = $grpArray[1];
		$groupArray['sc_grp_avail_limit_yn'] = $grpArray[2];
		$groupArray['sc_grp_alloc_ind'] = $grpArray[3];
		$groupArray['sc_grp_desc'] = $grpArray[4];
	} else {
		$groupArray['sc_group_id'] = "";
		$groupArray['sc_grp_avail_limit'] = "";
		$groupArray['sc_grp_avail_limit_yn'] = "";
		$groupArray['sc_grp_alloc_ind'] = "";
		$groupArray['sc_grp_desc'] = "";
	}
	return $groupArray;
}

# Identify authorised Jobs
function idJob($sc_group_id) {
	/*
		sc_fun_sys_code values
			1: No access for anyone.
			3: No access at property level.
			5: Read access at property level if normal access is read or higher.
			9: Management access for everyone.
	*/
	global $lDB;

	$propWhere = "";
	if ($GLOBALS['isPropServer']) {
		$propWhere = " AND sc_function.sc_fun_sys_code != '3'";
	}
	$jobArray = $lDB->get("
		SELECT DISTINCT
			sc_job.sc_job_id,
			sc_fun_group.sc_fun_grp_level,
			sc_function.sc_fun_sys_code
		FROM
			sc_function
			LEFT JOIN sc_fun_group ON sc_function.sc_function_id = sc_fun_group.sc_function_id
			INNER JOIN sc_fun_job ON sc_fun_job.sc_function_id = sc_function.sc_function_id
			INNER JOIN sc_job ON sc_job.sc_job_id = sc_fun_job.sc_job_id
		WHERE
			sc_function.sc_fun_sys_code = '9'
			OR (
				sc_fun_group.sc_group_id != '0'
				AND sc_fun_group.sc_group_id = '$sc_group_id'
				AND sc_function.sc_fun_sys_code != '1'
				$propWhere
				AND sc_job.sc_job_level < sc_fun_group.sc_fun_grp_level
			)
	",2);
	$returnArray = array();
	foreach($jobArray as $jobItem) {
		if($jobItem['sc_fun_sys_code'] == 9) {
			$jobItem['sc_fun_grp_level'] = "15";
		}
		if($GLOBALS['isPropServer'] && $jobItem['sc_fun_sys_code'] == 5) {
			$jobItem['sc_fun_grp_level'] = "5";
		}
		$jobId = $jobItem['sc_job_id'];
		array_push($returnArray,$jobId);
		$GLOBALS['jobLevelArray'][$jobId] = $jobItem['sc_fun_grp_level'];
	}

	$funcArray = $lDB->get("
		SELECT
			sc_function.sc_function_id,
			sc_fun_group.sc_fun_grp_level
		FROM
			sc_function
			LEFT JOIN sc_fun_group ON sc_function.sc_function_id = sc_fun_group.sc_function_id
		WHERE
			sc_function.sc_fun_sys_code = '9'
			OR (
				sc_fun_group.sc_group_id = '$sc_group_id'
				AND sc_function.sc_fun_sys_code != '1'
				$propWhere
			)
	",2);
	$GLOBALS['funLevelArray'] = array();
	foreach($funcArray as $item) {
		$GLOBALS['funLevelArray'][$item['sc_function_id']] = $item['sc_fun_grp_level'];
	}
	return $returnArray;
}

function findMenuParents($menuArray,$id) {
	$parentArray = array();
	$currId = $id;
	while(array_key_exists($currId,$menuArray)) {
		array_unshift($parentArray,$currId);
		$currId = $menuArray[$currId]['sc_menu_parent'];
	}
	return $parentArray;
}

function menuLevels($menuArray) {
	$levels = array();
	foreach($menuArray as $key=>$item) {
		$parents = findMenuParents($menuArray,$key);
		$menuArray[$key]['key'] = $parents;
		array_pop($parents);
		$levelKey = join("_",$parents);
		if(!array_key_exists($levelKey,$levels)) {
			$levels[$levelKey] = array();
		}
		array_push($levels[$levelKey],$key);
	}
	foreach($menuArray as $key=>$item) {
		$parents = $item['key'];
		$levelKeyArray = array();
		$curr = "";
		$out = "";
		foreach($parents as $id) {
			foreach($levels[$curr] as $levelKey=>$levelItem) {
				if($levelItem == $id) {
					if($out != "") { $out .= "_"; }
					$out .= ($levelKey+1);
				}
			}
			if($curr != "") { $curr .= "_"; }
			$curr .= $id;
		}
		$menuArray[$key]['levelKey'] = $out;
		$childKey = join("_",$parents);
		if(array_key_exists($childKey,$levels)) {
			$menuArray[$key]['childCount'] = sizeof($levels[join("_",$parents)]);
		} else {
			$menuArray[$key]['childCount'] = 0;
		}
	}
	return $menuArray;
}

function menuAccess($menuArray) {
	global $JobArray;
	global $userAnonId;
	global $userid;
	global $dbcode;

	$masterStatus = isMasterDB(1);

	$newMenuArray = array();
	foreach($menuArray as $key=>$item) {
		$use = false;
		$disabled = false;

		$jobAccess = false;
		if (in_array($item['sc_menu_job_top'],$JobArray) || in_array($item['sc_job_id'],$JobArray)) {
			$jobAccess = true;
		}

		$application = MaglLegacyApplication\Application\MaglLegacy::getInstance()->getApplication();
		$enterpriseSetup = $application->getServiceManager()->get('Resrequest\Setup\Service\Enterprise');
		$chartContainer = $application->getServiceManager()->get('Resrequest\Application\Chart\ChartContainer');

		// Check if menu item is Dashboards tab
		if ($item['sc_menu_parent'] == 9000) {
			// Get chart container ID by job
			$chartContainerId = false;

			switch ($item['sc_job_id']) {
				case 9002:
					// Todayboard
					$chartContainerId = true;
					break;
				case 9003:
					// Reservations
					$chartContainerId = '11e9d3a1cbb8051b8f6902399910d15e';
					break;
				case 9004:
					// Sales Overview
					$chartContainerId = '11ea1c3fae309e1a91f502399910d15e';
					break;
				case 9005:
					// Product Usage
					$chartContainerId = '11ea1c3faeproductusage399910d15e';
					break;
				case 9006: // Tourism.Today
					if (empty($GLOBALS['pr_business_link'])) {
						$chartContainerId = false;
					} else {
						$chartContainerId = true;
					}
					break;
			}

			if ($chartContainerId === true) {
				$jobAccess = true;
			} elseif ($chartContainerId === false) {
				$jobAccess = false;
			} elseif ($chartContainer->isChartContainerAllowed($chartContainerId)) {
				$jobAccess = true;
			} else {
				$jobAccess = false;
			}
		}


		if ($jobAccess || $item['sc_job_id'] == "" || $item['sc_job_id'] == "0") {
			if (!isset($userAnonID) || $userid != $userAnonID) {
				if ($masterStatus && $item['sc_menu_id'] == "84") {
					// Don't show the force master setting if you are master
				} elseif (!$masterStatus && $item['sc_menu_id'] == "83") {
					// Don't show the force slave setting if you are slave
				} elseif (!$masterStatus && $item['sc_menu_id'] == "81") {
					// Don't show the "Web as Master" option if slave (and resoffice)
				} elseif ($masterStatus && $item['sc_menu_id'] == "82") {
					// Don't show the "ResOffice as Master" option if master already (and resoffice)
				} elseif ($GLOBALS['envWebOverride'] && ($item['sc_menu_id'] == "26" || $item['sc_menu_id'] == "213")) {
					// Don't show run data transfer for web override environments
				} else {
					if ($dbcode[0] == "W" && ($item['sc_menu_id'] == "81" || $item['sc_menu_id'] == "82" || $item['sc_menu_id'] == "26" || $item['sc_menu_id'] == "213")) {
						// Don't show the set web as master and the set resoffice as master links
					} else {
						if($dbcode[0] == "W" || ($item['sc_menu_id'] != "84" && $item['sc_menu_id'] != "83")) {
							// remove set master / set slave option
							$use = true;
						}
					}


					if($dbcode[0] == "P" && (				// remove entries when on Property server
						$item['sc_menu_id'] == "270"		// Add Rates
						|| $item['sc_menu_id'] == "276"		// Rate Sheet
						|| $item['sc_menu_id'] == "289"		// Specials
					)) {
						$use = false;
						$disabled = true;
					}


					if($dbcode[0] == "P" && (				// disable entries when on Property server
						$item['sc_menu_id'] == "131"		// Environment Setup
						|| $item['sc_menu_id'] == "30"		// Defaults
					)) {
						$disabled = true;
					}
				}
			}
		} else {
			$use = true;
			$disabled = true;
		}
		if($use) {
			$item['link'] = "";
			if(!$disabled) {
				$func_call = "";
				if($item['sc_function_id'] != "" || $item['sc_job_id'] != "0") {
					if($item['sc_job_id'] != "0") {
						if($item['sc_menu_job_top'] != "") {
							if(in_array($item['sc_menu_job_top'],$GLOBALS['JobArray'])) {
								$item['sc_job_id'] = $item['sc_menu_job_top'];
							}
						}
						$func_call = "gotoLink('reservation.php?".$item['sc_job_id']."')";
					}
					if($item['sc_menu_param'] != "") {
						$func_call = str_replace("!url!",$func_call,$item['sc_menu_param']);
					}
				}
				$item['link'] = $func_call;
			}
			$newMenuArray[$key] = $item;
		}
	}
	return $newMenuArray;
}

function menuFavourites($menuArray) {
	$favourites = db_pf_option_get_by_user(false,true);
	$newFavourites = array();
	$count = 1;
	$extra = false;
	foreach($favourites as $item) {
		if($count > 9) {
			$extra = true;
			break;
		}
		if(in_array($item['sc_job_id'],$GLOBALS['JobArray'])) {
			array_push($newFavourites,$item);
			$count++;
		}
	}
	$childCount = sizeof($newFavourites);
	if($extra) {
		$childCount++;
	}
	$newMenuItems = array();
	foreach($menuArray as $key=>$item) {
		if($item['sc_menu_param'] == "favourites") {
			$menuArray[$key]['childCount'] = $childCount;
			$count = 1;
			foreach($newFavourites as $favItem) {
				array_push($newMenuItems,array(
					'levelKey'=>"$item[levelKey]_$count",
					'sc_menu_title'=>$favItem['pf_option_title'],
					'link'=>"menuProfile(".$favItem['sc_job_id'].",'". $favItem['pf_option_ix']."')",
					'childCount'=>0,
					'sc_menu_id'=>0
				));
				$count++;
			}
			if($extra) {
				array_push($newMenuItems,array(
					'levelKey'=>"$item[levelKey]_$count",
					'sc_menu_title'=>"More >>",
					'link'=>"openPopup('reservation.php?311',400,300);",
					'childCount'=>0,
					'sc_menu_id'=>0
				));
			}
		}
	}
	$menuArray = array_merge($menuArray,$newMenuItems);

	return $menuArray;
}

function getMenuArray() {
	$menuArray = $GLOBALS['lDB']->get("
		SELECT
			sc_menu.sc_menu_id,
			sc_menu.sc_job_id,
			sc_menu.sc_menu_job_top,
			sc_menu.sc_menu_parent,
			sc_menu.sc_menu_title,
			sc_menu.sc_function_id,
			sc_menu.sc_menu_parent,
			sc_menu.sc_menu_param,
			sc_menu.sc_job_id,
			sc_function.sc_fun_desc
		FROM
			sc_menu
			LEFT JOIN sc_function ON sc_function.sc_function_id = sc_menu.sc_function_id
		WHERE
			sc_menu.sc_menu_id NOT IN (5, 254, 132, 133, 145, 156, 197, 192, 193, 198)
			AND sc_menu.sc_menu_parent NOT IN (5, 254)
		ORDER BY
			sc_menu_parent,
			sc_menu_seq
	",2);
	$newMenuArray = array();
	foreach($menuArray as $item) {
		if(trim($item['sc_menu_title']) == "") {
			$item['sc_menu_title'] = $item['sc_fun_desc'];
		}
		// Fixing misspelling
		$item['sc_menu_title'] = (trim($item['sc_menu_title']) == "Rooming Calender" ? "Rooming Calendar" : $item['sc_menu_title']);
		$item['sc_menu_title'] = trim(str_replace("|", "", $item['sc_menu_title']));

		$newMenuArray[$item['sc_menu_id']] = $item;

		
	}
	$newMenuArray = menuAccess($newMenuArray);
	$newMenuArray = menuLevels($newMenuArray);
	return $newMenuArray;
}

function menuOutput($menuArray) {
	$out = "";
	foreach($menuArray as $item) {
		$out .= "Menu$item[levelKey]=new Array(\"".htmlspecialchars($item['sc_menu_title'])."\",\"$item[link]\",$item[childCount],$item[sc_menu_id]);\n";
	}
  $out .= "menuGenerated = true;\n";
	return $out;
}

function generateMenu() {
	if(!cacheExists("mainMenu",CACHE_DISK_SHARED)) {
		$menuArray = getMenuArray();
		cacheSet("mainMenu",$menuArray,CACHE_DISK_SHARED);
	} else {
		$menuArray = cacheGet("mainMenu",CACHE_DISK_SHARED);
	}
	$menuArray = menuFavourites($menuArray);
	$menuOutput = menuOutput($menuArray);
	return $menuOutput;
}

# Identify authorised properties
function idProperty($sc_group_id) {
	global $lDB;

	# Get the record set
	$propArray = $lDB->get("
		SELECT
			ac_accomm_type.pr_business_id,
			ac_accomm_type.ac_accomm_type_inactive_yn,
			pr_business.pr_bus_inactive_yn,
			sc_accomm.sc_group_id
		FROM
			sc_accomm
			INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			INNER JOIN pr_business ON ac_accomm_type.pr_business_id = pr_business.pr_business_id
		GROUP BY
			ac_accomm_type.pr_business_id,
			ac_accomm_type.ac_accomm_type_inactive_yn,
			pr_business.pr_bus_inactive_yn,
			sc_accomm.sc_group_id
		HAVING
			ac_accomm_type.ac_accomm_type_inactive_yn = 0
			AND pr_business.pr_bus_inactive_yn = 0
			AND sc_accomm.sc_group_id = '$sc_group_id'
	",2);
	return $propArray;
}

#
# Identify authorised properties
#
function getProperty($sc_group_id) {
	global $lDB;

	#
	# Get the record set
	#
	$propArray = $lDB->get("
		SELECT
			pr_business.pr_business_id
		FROM
			sc_accomm
			INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
			INNER JOIN pr_business ON ac_accomm_type.pr_business_id = pr_business.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = 0
			AND pr_business.pr_bus_inactive_yn = 0
			AND sc_accomm.sc_group_id='$sc_group_id'
		GROUP BY
			ac_accomm_type.pr_business_id
	",3);

	#
	# Add the parent hierarchy of each selected property
	#
	$parentArray = array();
	foreach($propArray as $item) {
		$nextParent = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id='$item'",4);
		while($nextParent != "0" && trim($nextParent) != "") {
			if(in_array($nextParent,$parentArray)) {
				$nextParent = "0";
			} else {
				# Add a new parent
				array_push($parentArray,$nextParent);
				$nextParent = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id='$nextParent'",4);
			}
		}
	}
	array_splice($propArray,sizeof($propArray),0,$parentArray);

	return $propArray;
}

# Identify authorised accommodation types
function idAccomm($sc_group_id) {
	global $lDB;

	$accommArray = $lDB->get("
		SELECT
			sc_accomm.ac_accomm_type_id,
			ac_accomm_type.pr_business_id
		FROM
			sc_accomm
			INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		WHERE
			sc_accomm.sc_group_id='$sc_group_id'
			AND ac_accomm_type.ac_accomm_type_inactive_yn=0
		ORDER BY
			ac_accomm_type.pr_business_id,
			ac_accomm_type.ac_accomm_sequence
	",2);
	return $accommArray;
}


# Establish system identity
function idSystem() {
	global $lDB;
	global $rf_sys_db_me_id;
	$systemArray = array();

	$systemArray['rf_sys_db_master_id'] = $lDB->get("SELECT rf_sys_db_master_id FROM rf_system",4);
	$systemArray['rf_sys_db_me_id'] = $rf_sys_db_me_id;
	return $systemArray;
}

function getFormattedData($data,$HTML,$itemName="records") {
	$result = "";
	$outHTML = Join("",file(__DIR__ . "/" . $HTML));
	for ($a=0;$a<sizeof($data);$a++) {
		$row = $data[$a];
		$result .= showpage($row,$outHTML);
	}
	if ($result == "" && (strstr($HTML,".txt") === false)) {
		$result = "<tr><td class='form' colspan='20' align='center'>No ".$itemName."</td></tr>\n";
	}
	if ($result == "" && !(strstr($HTML,".txt") === false)) {
		$result = "No ".$itemName."\n";
	}
	return $result;
}

// checkJob - returns information regarding this job, depending on the mode requested
// ========================================================================================
function checkJob($jobid,$mode=0) {
	global $lDB;
	global $CHECKJOBOVERRIDE;
	global $JobArray;

	$propDissallow = false;
	if ($GLOBALS['isPropServer']) {
		$sys_code = $lDB->get("select MAX(sc_fun_sys_code) from sc_function inner join sc_fun_job on sc_fun_job.sc_function_id = sc_function.sc_function_id and sc_fun_job.sc_job_id = '".$jobid."'",4);
		switch ($sys_code) {
		default:
			$propLevel = "";
			break;
		case "3":
			$propDissallow = true;
			$propLevel = "5";
			break;
		case "5":
			$propDissallow = true;
			$propLevel = "0";
			break;
		}
	}

	$masterCheck = isMasterDB();

	if ($mode == "1") {
		# Check if this job actually exists
		if ($lDB->get("SELECT COUNT(sc_job_id) FROM sc_job WHERE sc_job_id = '$jobid'",4) == "1") {
			# Give the actual impact level required to view this job
			$level = $lDB->get("SELECT sc_job_level FROM sc_job WHERE sc_job_id = '$jobid'",4);
			if (!$masterCheck && !$GLOBALS['isPropServer'] && $level > "4" && !$CHECKJOBOVERRIDE) {
				return False;
			}
			return (string) $level;
		}
		return false;
	} else {
		if (!in_array($jobid,$JobArray)) {
			# The user doesn't have access to this Job (or it doesn't exist)!
			return false;
		} else {
			if ($mode == "2") {
				# Give the max impact level this user has for this job
				if (!$CHECKJOBOVERRIDE && (!$masterCheck && !$GLOBALS['isPropServer'])) {
					return "5";
				}
				if ($GLOBALS['isPropServer'] && $propLevel != "") {
					return $propLevel;
				}
				return $GLOBALS['jobLevelArray'][$jobid];
			} else {
				$level = $lDB->get("SELECT sc_job_level FROM sc_job WHERE sc_job_id = '$jobid'",4);
				if (!$CHECKJOBOVERRIDE && !$masterCheck && !$GLOBALS['isPropServer']) {
					if ($level > "4") {
						return false;
					}
				}
				if ($GLOBALS['isPropServer'] && $propLevel != "") {
					if ($level >= $propLevel) {
						return false;
					}
				}

				# Yes, the user has access to this job
				return true;
			}
		}
	}
}

// showpage templating technique (copyleft) glowworm 2002 - replace anchors in html source
// =======================================================================================
function showpage ($values,$HTML="",$newline="<br />\n") {
	$temp = "";

	if ( !is_array($values) ) {
		$temp = $values;
	} else {
		$keys = array_keys($values); // HTML string with values stored in an array field with the tagname
		$new = "";

		// If no source html exists, generate our own -------------------------
		if ( $HTML == "" ) {
			for ( $i = 0; $i < sizeof($keys); $i++ ) {
				$name	= $keys[$i];
				$value = $values[$name];
				$target	= "!" . $name . "!";

				if($HTML == "" && (strpos($new,$name) === false)) {
					if ( $GLOBALS['debug'] == "1" ) {
						$new = " | <b>" . $name . "</b> :>> " . $target . $newline;
					} else {
						$new = $target;
					}
				}
				$temp .= $new;
			}
		}

		// Otherwise use the passed html
		if ( $temp == "" ) {
			$temp = $HTML;
		}

		$newKeys = array();

		foreach ( $keys as $item ) {
			array_push($newKeys,"!" . $item . "!");
		}
		$temp = str_replace($newKeys,$values,$temp);
	}
	return (string) $temp;
}

function appendSystemVersion($HTML , $systemVersion = ""){
    $patterns     = ["/\.js\"/", "/\.js'/", "/\.css\"/", "/\.css'/"];
    $replacements = [".js?{$systemVersion}\"", ".js?{$systemVersion}'", ".css?{$systemVersion}\"", ".css?{$systemVersion}'"];

    return preg_replace($patterns, $replacements, $HTML);
}

function getAddress($prAddressId) {
	global $lDB;

	$addressArray = $lDB->get("
		SELECT
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_addr_line3,
			pr_persona.pr_corr_city,
			rf_country.rf_country_name,
			pr_persona.pr_corr_post_code,
			pr_persona.pr_email,
			pr_persona.pr_web_addr
		FROM
			pr_persona
			LEFT JOIN rf_country ON pr_persona.pr_corr_country_id = rf_country.rf_country_ix
		WHERE
			pr_persona.pr_persona_ix = '$prAddressId'
	",1);

	if (!$addressArray) {
		return array();
	}

	$addressArray[9] = "";
	if(isset($addressArray['pr_corr_addr_line1']) && trim($addressArray['pr_corr_addr_line1']) != "") {
		if(trim($addressArray[9]) != "") {
			$addressArray[9] .= "\n";
		}
		$addressArray[9] .= $addressArray['pr_corr_addr_line1'];
	}
	if(isset($addressArray['pr_corr_addr_line2']) && trim($addressArray['pr_corr_addr_line2']) != "") {
		if(trim($addressArray[9]) != "") {
			$addressArray[9] .= "\n";
		}
		$addressArray[9] .= $addressArray['pr_corr_addr_line2'];
	}
	if(isset($addressArray['pr_corr_addr_line3']) && trim($addressArray['pr_corr_addr_line3']) != "") {
		if(trim($addressArray[9]) != "") {
			$addressArray[9] .= "\n";
		}
		$addressArray[9] .= $addressArray['pr_corr_addr_line3'];
	}
	if(trim($addressArray[9]) != "") {
		$addressArray[9] .= "\n";
	}

	$addressArray[8] = (isset($addressArray['rf_country_name']) ? $addressArray['rf_country_name'] : "")." ".(isset($addressArray['pr_corr_post_code']) ? $addressArray['pr_corr_post_code'] : "");
	return $addressArray;
}

function getPhysAddress($prAddressId) {
	global $lDB;

	$physaddressArray = $lDB->get("
		SELECT
			pr_persona.pr_phys_addr_line1,
			pr_persona.pr_phys_addr_line2,
			pr_persona.pr_phys_addr_line3,
			pr_persona.pr_phys_city,
			rf_country.rf_country_name,
			pr_persona.pr_phys_post_office_id,
			pr_persona.pr_email,
			pr_persona.pr_web_addr
		FROM
			pr_persona
			LEFT JOIN rf_country ON pr_persona.pr_phys_country_id = rf_country.rf_country_ix
		WHERE
			pr_persona.pr_persona_ix = '$prAddressId'
	",1);

	if (!$physaddressArray) {
		return array();
	}

	$physaddressArray[9] = "";
	if(isset($physaddressArray['pr_phys_addr_line1']) && trim($physaddressArray['pr_phys_addr_line1']) != "") {
		if(trim($physaddressArray[9]) != "") {
			$physaddressArray[9] .= "\n";
		}
		$physaddressArray[9] .= $physaddressArray['pr_phys_addr_line1'];
	}
	if(isset($physaddressArray['pr_phys_addr_line2']) && trim($physaddressArray['pr_phys_addr_line2']) != "") {
		if(trim($physaddressArray[9]) != "") {
			$physaddressArray[9] .= "\n";
		}
		$physaddressArray[9] .= $physaddressArray['pr_phys_addr_line2'];
	}
	if(isset($physaddressArray['pr_phys_addr_line3']) && trim($physaddressArray['pr_phys_addr_line3']) != "") {
		if(trim($physaddressArray[9]) != "") {
			$physaddressArray[9] .= "\n";
		}
		$physaddressArray[9] .= $physaddressArray['pr_phys_addr_line3'];
	}
	if(trim($physaddressArray[9]) != "") {
		$physaddressArray[9] .= "\n";
	}

	$physaddressArray[8] = (isset($physaddressArray['rf_country_name']) ? $physaddressArray['rf_country_name'] : "")." ". (isset($physaddressArray['pr_phys_post_code']) ? $physaddressArray['pr_phys_post_code'] : "");
	return $physaddressArray;
}

function killWizResId(&$wizResId) {
	global $lDB;
	global $wizResId;

	$tempMasterData = $lDB->isMaster;
	$lDB->isMaster = "1";

	session_set(array(
		'addedExpiry'=>false,
		'calStepNumber'=>"1"
	));

	# Delete EVERYTHING
	if ($wizResId != "" && $lDB->count("rv_reservation","rv_reservation_ix",$wizResId,1)) {
		$itemList = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$wizResId'",3);
		foreach($itemList as $item) {
			calDeleteItem($item, $wizResId, false, true, true);
		}
	}

	$lDB->isMaster = $tempMasterData;

	session_restart();
	unset($_SESSION['addCheck']);
	session_write_close();

	unsetWizResId($wizResId);
}


function unsetWizResId(&$wizResId) {
	$wizResId = "";
	unset($wizResId);
	unset($GLOBALS['wizResId']);

	session_restart();
	unset($_SESSION['wizResId']);
	unset($_SESSION['wizOverbooking']);
	session_write_close();
}

function validResId(&$wizResId) {
	global $lDB;

	if(array_key_exists('wizResId',$_SESSION)) {
		$wizResId = $_SESSION['wizResId'];
	} else {
		$wizResId = "";
	}

	if($lDB->get("SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation_ix = '$wizResId'",4) != 25) {
		unsetWizResId($wizResId);
	}

	$_GLOBALS['wizResId'] = $wizResId;

	$validResId = false;
	$cancelResId = false;
	$timeoutResId = false;
	$invalidResId = false;

	if(isset($wizResId) && $lDB->get("select count(*) from rv_reservation where rv_reservation_ix = '".$wizResId."'",4) > 0) {
		$validResId = true;
	}

	if($validResId) {
		if(isset($GLOBALS['wizCancelled']) && $GLOBALS['wizCancelled']) $cancelResId = true;

		$sql = "
			SELECT
				count(*)
			FROM
				rv_reservation
			WHERE
				rf_reservation_status_id = '25'
				AND rv_create_expiry_date < '".date("Y-m-d H:i:s")."'
				AND rv_reservation_ix = '$wizResId'
		";
		if ($lDB->get($sql,4) > "0") $timeoutResId = true;
	} else {
		if (isset($wizResId)) {
			if (strlen($wizResId) > 0) {
				$sql = "
					SELECT
						count(*)
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_id = '".$wizResId."'
				";
				if($lDB->get($sql,4) > "0") $invalidResId = true;
			}
		}
	}

	$GLOBALS['temp']['alertUser'] = "0";
	if($cancelResId || $timeoutResId || $invalidResId) {
		killWizResId($wizResId);
		if($timeoutResId) {
			$GLOBALS['temp']['alertUser'] = "1";
		}
	}
}

function generateLicenceChecksum($expiryDate, $clientIds) {
	$dateArray = explode("-",$expiryDate);
	$total = 0;
	foreach($clientIds as $item) {
		$total += $item;
	}
	return md5(($dateArray[0] + $dateArray[1] + $dateArray[2]) * $total);
}

function checkLicence() {
	$GLOBALS['licenceInfo'] = array("valid"=>false);
	if(!file_exists("ResRequest Licence.dat")) {
		$GLOBALS['licenceInfo']['error'] = "Unable to locate licence.";
		return;
	}
	require_once(__DIR__ . "/ResRequest Licence.dat");
	if($GLOBALS['licenceInfo']['expiry'] < date("Y-m-d") || trim($GLOBALS['licenceInfo']['expiry']) == "") {
		$GLOBALS['licenceInfo']['error'] = "The licence has expired.";
		return;
	}
	if(!in_array($GLOBALS['principal_id'],$GLOBALS['licenceInfo']['clientIds'])) {
		$GLOBALS['licenceInfo']['error'] = "The licence is invalid.";
		return;
	}
	if($GLOBALS['licenceInfo']['checksum'] != generateLicenceChecksum($GLOBALS['licenceInfo']['expiry'],$GLOBALS['licenceInfo']['clientIds'])) {
		$GLOBALS['licenceInfo']['error'] = "The licence is invalid.";
		return;
	}

	$GLOBALS['licenceInfo']['valid'] = true;
	$GLOBALS['licenceInfo']['error'] = "This licence is valid.";
//	return $GLOBALS['licenceInfo'];
}

function getAnalytics() {
	global $dbcode;
	global $lDB;
	global $userStatusId;

	if($dbcode[0] != "W" && !$GLOBALS['envWebOverride']) {
		return false;
	}
	$analyticsSettings = $lDB->get("
		SELECT
			rf_analytics_yn,
			rf_analytics_public_yn,
			rf_analytics_external_yn,
			rf_analytics_internal_yn,
			rf_analytics_code
		FROM
			rf_default
	",1);
	if(
		$analyticsSettings['rf_analytics_yn'] != "1"
		|| trim($analyticsSettings['rf_analytics_code']) == ""
		|| ($userStatusId > 1 && $analyticsSettings['rf_analytics_internal_yn'] != "1")
		|| ($userStatusId == 1 && $analyticsSettings['rf_analytics_external_yn'] != "1")
		|| ($userStatusId < 1 && $analyticsSettings['rf_analytics_public_yn'] != "1")
	) {
		return false;
	}

	return str_replace("!code!",$analyticsSettings['rf_analytics_code'],join("",file(__DIR__ . "/../../../public/html/analytics.htm")));
}

function applyAnalytics($html,$analytics) {
	return str_replace("</body>",$analytics . "\n</body>",$html);
}

function historyAdd() {
  // Add this item to the history array
  $job_info = array(
    "REQUEST_METHOD" => $_SERVER['REQUEST_METHOD'],
    "REQUEST_URI" => $_SERVER['REQUEST_URI'],
    'QUERY' => array()
  );
  $job_check = false;
  $count = 0;
  foreach($_SERVER['argv'] as $item) {
    if ($count == 0 && $item[0] == "?") { $item = str_replace("?","",$item); }
    array_push($job_info['QUERY'],$item);
    if(array_key_exists($count,$GLOBALS['history'])) {
      if($item != $GLOBALS['history'][$count]) {
        $job_check = true;
      }
    } else {
      $job_check = true;
    }
    $count++;
  }
  if ($job_check == true) {
    if(isset($_POST['url']) && !empty($_POST['url'])) {
      array_unshift($job_info['QUERY'],"url");
    }
    array_push($GLOBALS['history'],$job_info);
  }
}

function historyNavigate($direction) {
	// -=========================================================-
	//  If the users did a 'back' or 'forward' request, process it
	// -=========================================================-
	if(array_key_exists('forwardHistory',$_SESSION)) {
		$forwardHistory = $_SESSION['forwardHistory'];
		if($direction == "forward") {
			$item = array_pop($forwardHistory);
			if(isset($item['QUERY']) && is_array($item['QUERY']) && isset($item['QUERY'][0])) {
				historyAction($item);
				$_SESSION['forwardHistory'] = $forwardHistory;
				$_SESSION['wasForward'] = true;
				exit();
			}
		}
	} else {
		$forwardHistory = array();
	}
	if(!array_key_exists('wasBack',$_SESSION)) {
		$_SESSION['wasBack'] = false;
	}
	if(!array_key_exists('wasForward',$_SESSION)) {
		$_SESSION['wasForward'] = false;
	}
	if(!array_key_exists('goback',$_POST)) {
		$_POST['goback'] = false;
	}
  $preserve = false;
	if(isset($_POST['preserve']) && $_POST['preserve'] === "true") {
		$preserve = true;
  }

	if($_SESSION['wasBack'] || $_POST['goback'] == "true" || $_SESSION['wasForward']) {
		$_SESSION['wasBack'] = false;
		$_SESSION['wasForward'] = false;
	} else {
		$forwardHistory = array();
	}
	if(array_key_exists('history',$_SESSION)) {
		$history = $_SESSION['history'];
		if($direction == "back") {
			$forwardItem = array_pop($history);
			$item = $preserve ? $history[count($history) - 1] : array_pop($history);
			if(isset($item['QUERY']) && is_array($item['QUERY']) && isset($item['QUERY'][0])) {
				historyAction($item);
				$_SESSION['history'] = $history;
				array_push($forwardHistory,$forwardItem);
				$_SESSION['forwardHistory'] = $forwardHistory;
				$_SESSION['wasBack'] = true;
				exit();
			}
		}
	} else {
		$history = array();
	}
	// If the back button wasn't pressed, clear the forward list
	$GLOBALS['history'] = $history;
	$GLOBALS['forwardHistory'] = $forwardHistory;
}

function historyTrim() {
	// This checks if to add the current request to the history based on whether
	// the reuqest is for a popup or not (this method needs to be improved)
	if ($GLOBALS['isPopup']) {
	   array_pop($GLOBALS['history']);
	}
	// Check how many history entries there are
	// and remove any over 20
	while(count($GLOBALS['history']) > 20) {
	   array_shift($GLOBALS['history']);
	}
	$_SESSION['history'] = $GLOBALS['history'];
	while(count($GLOBALS['forwardHistory']) > 20) {
		array_shift($GLOBALS['forwardHistory']);
	}
	$_SESSION['forwardHistory'] = $GLOBALS['forwardHistory'];
}

function historyAction(array &$item) {
	if($item['QUERY'][0] === "url") {
		array_shift($item['QUERY']);
		echo "
			<form id=\"main\" method=\"POST\" action=\"reservation.php?".$item['QUERY'][0]."\">
				<input type=\"hidden\" name=\"url\" value=\"reservation.php?".htmlspecialchars(join("+",$item['QUERY']))."\" />
			</form>
			<script language=\"javascript\">
				document.getElementById(\"main\").submit();
			</script>
		";
	} elseif ($item['REQUEST_METHOD'] == "GET") {
		echo "</form>
		<script language=\"javascript\">
			window.location = \"".$item['REQUEST_URI']."\";
		</script>";
	} else {
		$param = join("+",$item['QUERY']);
		echo "
			<form id=\"main\" method=\"POST\" action=\"reservation.php?$param\">
				<input type=\"hidden\" name=\"url\" value=\"reservation.php?".htmlspecialchars($param)."\" />
			</form>
			<script language=\"javascript\">
				document.getElementById(\"main\").submit();
			</script>
		";
	}
}

function canAccessEnvironment($sc_group_id, $dbId="", $dbCode="") {
    global $lDB;

    $scEnvGroupCount = $lDB->get("SELECT COUNT(*) FROM sc_env_group", 4);
    if ($scEnvGroupCount == 0) {		// If sc_env_group not populated allow access to all user groups.
        return true;
    }

    $andWhere = "AND sc_env_group.rf_database_id = '" . (!empty($dbId) ? $dbId : $GLOBALS['environment_id']) . "'";
    $andWhere = !empty($dbCode) ? "AND rf_database.rf_db_code = '" . $dbCode . "'" : $andWhere;

    $canAccess = $lDB->get(
        "
            SELECT
                COUNT(sc_env_group.sc_env_group_ix)
            FROM
                sc_env_group
                LEFT JOIN rf_database ON rf_database.rf_database_id = sc_env_group.rf_database_id
            WHERE
                sc_env_group.sc_group_id = '" . $sc_group_id . "'
                " . $andWhere . "
        ",
        4
    );
    return $canAccess > 0 ? true : false;
}

function isEnvironmentActive($dbId="", $dbCode="") {
    global $lDB;

    $andWhere = "AND rf_database_id = '" . (!empty($dbId) ? $dbId : $GLOBALS['environment_id']) . "'";
    $andWhere = !empty($dbCode) ? "AND rf_db_code = '" . $dbCode . "'" : $andWhere;

    $isActive = $lDB->get(
        "
            SELECT
                COUNT(*)
            FROM
                rf_database
            WHERE
                rf_db_inactive_yn = 0
                " . $andWhere . "
        ",
        4
    );
    
    return $isActive > 0 ? true : false;
}

 function commissionLabelImplemented() {
	 global $lDB;
	 
	 $rfCommissionLabelExists = $lDB->get("SHOW COLUMNS from rf_default LIKE 'rf_commission_label_override'", 4);
	 return !empty($rfCommissionLabelExists) ? true : false;
 }
 
function commissionLabel() {
	global $lDB;

	$rfCommissionLabelOverride = '';
	if (commissionLabelImplemented()) {
		$rfCommissionLabelOverride = $lDB->get("SELECT rf_commission_label_override FROM rf_default", 4);
	}
	return trim($rfCommissionLabelOverride) != '' ? trim($rfCommissionLabelOverride) : "Commission";
}

function isWebEnv($env) {
	global $lDB;

	$envType = $lDB->get("
		SELECT
			rf_db_env_type_ind,
			rf_db_env_type_web_yn
		FROM
			rf_database
		WHERE
			rf_db_code = '" . $env . "'
	", 1);

	if ($envType['rf_db_env_type_ind'] == 2 || $envType['rf_db_env_type_web_yn'] == 1) {
		return true;
	}
	return false;
}

function exchDecimalPlacesImplemented() {
	global $lDB;

	$rfExchDecimalPlacesExists = $lDB->get("SHOW COLUMNS from rf_default LIKE 'rf_exch_decimal_places'", 4);
	return !empty($rfExchDecimalPlacesExists) ? true : false;
}
 
function exchDecimalPlaces() {
	global $lDB;

	$rfExchDecimalPlaces = 6;
	if (exchDecimalPlacesImplemented()) {
		$rfExchDecimalPlaces = $lDB->get("SELECT rf_exch_decimal_places FROM rf_default", 4);
	}
	if ($rfExchDecimalPlaces == '') {
		$rfExchDecimalPlaces = 6;
	}
	if ($rfExchDecimalPlaces < 6) {
		$rfExchDecimalPlaces = 6;
	}
	if ($rfExchDecimalPlaces > 20) {
		$rfExchDecimalPlaces = 20;
	}
	return $rfExchDecimalPlaces;
}

function trimExchangeRate($rf_exch_rate) {
	if (exchDecimalPlacesImplemented()) {
		// Convert number to string and chop decimal places to size, to avoid issues with rounding large numbers of decimal places
		$rfExchRateParts = explode('.', strval($rf_exch_rate));
		$rfExchRateParts = array_pad($rfExchRateParts,2,"");
		$truncated = $rfExchRateParts[0] . '.' . substr($rfExchRateParts[1], 0, exchDecimalPlaces());
		return $truncated;
	} else {
		return $rf_exch_rate;
	}
}
function loginFunctions() {
	// Functions / actions to be executed upon successful login to the system
	clearExpiredProvRooming();
}

function clearExpiredProvRooming() {
	// Find all expired provisional reservations with rooming info, and remove rooming info
	global $lDB;

	$reservations = $lDB->get("
		SELECT
			rv_reservation.rv_reservation_ix
		FROM
			rv_reservation
			LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		WHERE
			rv_reservation.rf_reservation_status_id = '20'
			AND rv_reservation.rv_provision_expiry_date < NOW()
			AND rv_res_item_group.rv_res_item_group_ix IS NOT NULL
		GROUP BY
			rv_reservation.rv_reservation_ix
	", 3);

	if (!empty($reservations)) {
		// This action needs to be performed as the System user (RS1), for audit purposes, so change userId, then set it back afterwards
		$currentUserId = $GLOBALS['userid'];
		$GLOBALS['userid'] = "RS1";
		foreach ($reservations as $reservationId) {
			removeRoomingInfo($reservationId);
		}
		$GLOBALS['userid'] = $currentUserId;
	}
}
