<?php

require_once(__DIR__ . "/functions.persona.php");

// If this code is called from AWF Triggers (CLI script),
// it doesn't go through the usual channels, so we need to set up the environment
require_once(__DIR__ . '/inc.setup.php');
$_SESSION['userName'] = $_SESSION['userName'] ?? "System";

function TemplatesReadAccess() {
	if(isset($GLOBALS['jobLevelArray'][782]) && $GLOBALS['jobLevelArray'][782] > 0) {
		return true;
	} else {
		return false;
	}
}

function TemplatesUpdateAccess() {
	if(isset($GLOBALS['jobLevelArray'][782]) && $GLOBALS['jobLevelArray'][782] > 5) {
		return true;
	} else {
		return false;
	}
}

function TemplatesManagementAccess() {
	
	if(isset($GLOBALS['jobLevelArray'][782]) && $GLOBALS['jobLevelArray'][782] > 10 && $GLOBALS['userStatusId'] > 1) {
		return true;
	} else {
		return false;
	}
}


function createTemplateList($actionFunc, $showSample, $pf_option_id=NULL) {

	$rows = "<table class=\"uk-table-striped\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" style=\"table-layout: fixed;\">";
	
	if ($showSample){
		$rows .= "<col width=\"130\" /><col width=\"70\" /><col width=\"40\" /><col width=\"30\" />";
	} else {
		$rows .= "<col width=\"130\" /><col width=\"70\" /><col width=\"70\" />";
	}

	$listRowHTML = "<tr style=\"background-color: !bgcolor!;\" onmouseover=\"this.style.backgroundColor = '#CCFFCC';\" onmouseout=\"this.style.backgroundColor = '!bgcolor!';\" onclick=\"$actionFunc('!pf_option_ix!',this);\" class=\"imgLink\">
		<td style=\"text-align:left;\">!pf_option_name!</td> 
		<td style=\"text-align:left;\">!pf_level_ind!</td> 
		<td style=\"text-align:center;\">!pf_option_default_yn!</td> 
		!templateSample!
	</tr>";



	$templateList = db_pf_option_get_by_user(db_pf_object_by_name("email_templates"),false,$GLOBALS['userid']);

	foreach ($templateList as $template){

		$item['pf_option_ix'] = $template['pf_option_ix'];	
		$item['pf_option_name'] = $template['pf_option_name'];
		$item['pf_level_ind'] = db_pf_option_level_name(db_pf_option_level($template['pf_option_ix']));
		$item['pf_option_default_yn'] = ($template['pf_option_default_yn'] == 1) ? "x" : "";
		if ($template['pf_option_ix'] == $pf_option_id){
			$item['bgcolor'] = "#31ff63";
		} else {
			$item['bgcolor'] = "#FFF";
		}
		
		if ($showSample){
			$templateSample = t_encodeOverlib(db_pf_field_by_name($template['pf_option_ix'], "templateText"));
			$item['templateSample']	= "<td><i name=\"templateSample\" class=\"material-icons\" onMouseOver=\"overlib('<div class=\'txts\'>$templateSample</div>',WIDTH,240)\" onMouseOut=\"nd()\">note</i></td>";
		} else {
			$item['templateSample']	= "";
		}
		
		$rows .= showpage($item,$listRowHTML);
	}

	$rows .= "</table>";

	return $rows;
}

function parseTemplate(&$text, $resId="", $folioId="", $invoiceId="") {
	global $lDB;

	if ($resId != ""){
		$consultantId = $GLOBALS['lDB']->get("SELECT rv_consultant_id FROM rv_reservation WHERE	rv_reservation_ix = '$resId'", 4);
		$agentId = $GLOBALS['lDB']->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'", 4);		
		$contactId = $GLOBALS['lDB']->get("SELECT rv_corr_persona_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);		
	} else {
		$consultantId = "";
		$agentId = "";
		$contactId = "";
	}
	$principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);

	preg_match_all("/({{[^}]+}})/i", $text, $matches);
	
	foreach($matches[1] as $dirtyfield){
		$field = "";

		$cleanfield = str_replace(array("{{","}}"),array("",""), $dirtyfield);
		$explodedfield = explode("|", $cleanfield);
		
		switch ($explodedfield[0]){
			case "Consultant":
				$persona = getPersonaRecord($consultantId);
				switch($explodedfield[1]){
					case "Firstname":
						$field = isset($persona[0])?$persona[0]['pr_name_first']:"";
						break;
					case "Lastname":
						$field = isset($persona[0])?$persona[0]['pr_name_last']:"";
						break;
					case "Telephone":
						$field = getTelephone($consultantId);					
						break;
					case "Email":
						$field = getEmail($consultantId);				
						break;
					case "Postal":
						$field = getContactCorrAddress($consultantId);				
						break;	
					case "Physical":
						$field = getContactPhysAddress($consultantId);
						break;																													
				}
				break;
			case "ConsultantRel":
				$consultantRelId = getConsultantRel($consultantId);
				$persona = getPersonaRecord($consultantRelId);
				switch($explodedfield[1]){
					case "Organisation Name":
						$field = isset($persona[0])?$persona[0]['pr_name_last']:"";
						break;
					case "Telephone":
						$field = getTelephone($consultantRelId);					
						break;
					case "Fax":
						$field = getFax($consultantRelId);					
						break;						
					case "Email":
						$field = getEmail($consultantRelId);				
						break;
					case "Postal Address":
						$field = getContactCorrAddress($consultantRelId);				
						break;	
					case "Physical Address":
						$field = getContactPhysAddress($consultantRelId);;
						break;			
					case "URL":
						$field = getURL($consultantRelId);					
						break;																																
				}
				break;
			case "ResDetails":
				$persona = getPersonaRecord($contactId);	
				$reservation = false;
				if (!empty($resId)) {
					$reservation = getReservationRecord($resId)[0];
				}

				switch($explodedfield[1]){
					case "Contact Firstname":
						$field = isset($persona[0])?$persona[0]['pr_name_first']:"";
						break;
					case "Contact Lastname":
						$field = isset($persona[0])?$persona[0]['pr_name_last']:"";
						break;
					case "Agent":
						$field = getFullName($agentId);					
						break;
					case "Number":
						if ($reservation != false) {
							$field = $reservation['rv_reservation_ix'];
						}
						break;
					case "Name":
						if ($reservation != false) {
							$field = $reservation['rv_res_name'];
						}
						break;
					case "NumberAndName":
						if ($reservation != false) {
							$field = $reservation['rv_reservation_ix'] . ' ' . $reservation['rv_res_name'];
						}
						break;
					case "ProvisionalExpiryDate":
						if ($reservation != false) {
							if ((bool)strtotime($reservation['rv_provision_expiry_date'])) {
								$field = (new DateTime($reservation['rv_provision_expiry_date']))->format('d M Y');
							} else {
								$field = '';
							}
						}
						break;
					case "Details":
						if (!empty($resId)) {
							$field = nl2br(getReservationsDetails([$resId]));
						}
						break;
					case "Payment URL":
						$url = $GLOBALS['http'] . $GLOBALS['domain'] . '/reservation.php?1021++' . $resId;
						$field = '<a href="' . $url . '" target="_blank">Payment link</a>';
						break;
				}			
				break;
			case "ResOffice":
				$persona = getPersonaRecord($resOfficeId);			
				switch($explodedfield[1]){
					case "Organisation Name":
						$field = isset($persona[0])?$persona[0]['pr_name_last']:"";
						break;
					case "Telephone":
						$field = getTelephone($resOfficeId);					
						break;
					case "Fax":
						$field = getFax($resOfficeId);					
						break;						
					case "Email":
						$field = getEmail($resOfficeId);				
						break;
					case "Postal Address":
						$field = getContactCorrAddress($resOfficeId);				
						break;	
					case "Physical Address":
						$field = getContactPhysAddress($resOfficeId);;
						break;			
					case "URL":
						$field = getURL($resOfficeId);					
						break;																																
				}			
				break;
			case "Principal":
				$persona = getPersonaRecord($principalId);			
				switch($explodedfield[1]){
					case "Organisation Name":
						$field = isset($persona[0])?$persona[0]['pr_name_last']:"";
						break;
					case "Telephone":
						$field = getTelephone($principalId);					
						break;
					case "Fax":
						$field = getFax($principalId);					
						break;						
					case "Email":
						$field = getEmail($principalId);				
						break;
					case "Postal Address":
						$field = getContactCorrAddress($principalId);				
						break;	
					case "Physical Address":
						$field = getContactPhysAddress($principalId);;
						break;			
					case "URL":
						$field = getURL($principalId);					
						break;
					case "Payment URL":
						$url = $GLOBALS['http'] . $GLOBALS['domain'] . '/reservation.php?1021';
						$field = '<a href="' . $url . '" target="_blank">Payment link</a>';
						break;
				}			
				break;								
			case "Payment":
				switch($explodedfield[1]) {
				case "CreditCardLink":
					$field = $GLOBALS['http'] . $_SESSION['principal_name_short'] . ".resrequest.com/pay.php";
					$params = array();
					if(!empty($resId)) {
						$params[] = "resid=$resId";
					}
					if(!empty($folioId)) {
						$email = $lDB->get("
							SELECT
								pr_persona.pr_email
							FROM
								fn_folio
								INNER JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
							WHERE
								fn_folio.fn_folio_ix = '$folioId'
						",4);
						if(!empty($email)) {
							$params[] = "email=$email";
						}
					}
					if(sizeof($params) > 0) {
						$field .= "?" . join("&",$params);
					}
					break;
				}
				break;
			case "Invoice":
				$folioIds = [];
				$invoiceIds = [];

				if (is_array($folioId)) {
					$folioIds = $folioId;
				} else if (empty($folioId)) {
					$folioIds[] = $folioId;
				}

				if (is_array($invoiceId)) {
					$invoiceIds = $invoiceId;
				} else if (empty($folioId)) {
					$invoiceIds[] = $invoiceId;
				}

				switch($explodedfield[1]){
					case "Debtor":
						$debtors = [];

						if (empty($folioIds) && empty($invoiceIds)) {
							$field = '';
							break;
						}

						if (!empty($folioIds)) {
							$folioDebtors = $lDB->get("
								SELECT
									TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last))
								FROM
									fn_folio
									INNER JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
								WHERE
									fn_folio.fn_folio_ix IN ('".join("','", $folioIds)."')
							", 3);

							$debtors = array_merge($debtors, $folioDebtors);
						}

						if (!empty($invoiceIds)) {
							$invoiceDebtors = $lDB->get("
								SELECT
									fn_inv_to
								FROM
									fn_invoice
								WHERE
								fn_invoice.fn_invoice_ix IN ('".join("','", $invoiceIds)."')
							", 3);

							$debtors = array_merge($debtors, $invoiceDebtors);
						}

						$field = join(', ', $debtors);
						break;
					case "Number":
						$number = [];
						$folioNumbers = $lDB->get("
							SELECT
								fn_folio_folio_num
							FROM
								fn_folio
							WHERE
								fn_folio.fn_folio_ix IN ('".join("','", $folioIds)."')
						", 3);
						$number = array_merge($folioNumbers, $invoiceIds);
						$field = join(', ', $number);
						break;
				}			
				break;
		}
		
		$text = str_replace($dirtyfield, $field, $text);	
	}
}

function parseConsolidatedTemplate(&$text, $resIds=[], $folioId="")
{
    global $lDB;

    $principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
    $resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);

    preg_match_all("/({{[^}]+}})/i", $text, $matches);
    
    foreach ($matches[1] as $dirtyfield) {
        $cleanfield = str_replace(array("{{","}}"), array("",""), $dirtyfield);
        $explodedfield = explode("|", $cleanfield);

        $values = [];
        $field ='';
        foreach ($resIds as $resId) {
            $consultantId = $GLOBALS['lDB']->get("SELECT rv_consultant_id FROM rv_reservation WHERE	rv_reservation_ix = '$resId'", 4);
            $agentId = $GLOBALS['lDB']->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'", 4);
            $contactId = $GLOBALS['lDB']->get("SELECT rv_corr_persona_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'", 4);

            switch ($explodedfield[0]) {
                case "Consultant":
                    $persona = getPersonaRecord($consultantId);
                    switch ($explodedfield[1]) {
                        case "Firstname":
                            $field = isset($persona[0])?$persona[0]['pr_name_first']:"";
                            break;
                        case "Lastname":
                            $field = isset($persona[0])?$persona[0]['pr_name_last']:"";
                            break;
                        case "Telephone":
                            $field = getTelephone($consultantId);
                            break;
                        case "Email":
                            $field = getEmail($consultantId);
                            break;
                        case "Postal":
                            $field = getContactCorrAddress($consultantId);
                            break;
                        case "Physical":
                            $field = getContactPhysAddress($consultantId);
                            break;
                    }
                    break;
                case "ConsultantRel":
                    $consultantRelId = getConsultantRel($consultantId);
                    $persona = getPersonaRecord($consultantRelId);
                    switch ($explodedfield[1]) {
                        case "Organisation Name":
                            $field = isset($persona[0])?$persona[0]['pr_name_last']:"";
                            break;
                        case "Telephone":
                            $field = getTelephone($consultantRelId);
                            break;
                        case "Fax":
                            $field = getFax($consultantRelId);
                            break;
                        case "Email":
                            $field = getEmail($consultantRelId);
                            break;
                        case "Postal Address":
                            $field = getContactCorrAddress($consultantRelId);
                            break;
                        case "Physical Address":
                            $field = getContactPhysAddress($consultantRelId);;
                            break;
                        case "URL":
                            $field = getURL($consultantRelId);
                            break;
                    }
                    break;
                case "ResDetails":
                    $persona = getPersonaRecord($contactId);
                    $reservation = getReservationRecord($resId)[0];
                    switch ($explodedfield[1]) {
                        case "Contact Firstname":
                            $field = isset($persona[0])?$persona[0]['pr_name_first']:"";
                            break;
                        case "Contact Lastname":
                            $field = isset($persona[0])?$persona[0]['pr_name_last']:"";
                            break;
                        case "Agent":
                            $field = getFullName($agentId);
                            break;
                        case "Number":
                            $field = $reservation['rv_reservation_ix'];
                            break;
                        case "Name":
                            $field = $reservation['rv_res_name'];
                            break;
                        case "NumberAndName":
                            $field = $reservation['rv_reservation_ix'] . ' ' . $reservation['rv_res_name'];
                            break;
                        case "ProvisionalExpiryDate":
                            if ((bool)strtotime($reservation['rv_provision_expiry_date'])) {
                                $field = (new DateTime($reservation['rv_provision_expiry_date']))->format('d M Y');
                            } else {
                                $field = '';
                            }
                            break;
                        case "Payment URL":
                            $url = $GLOBALS['http'] . $GLOBALS['principal_name_short'] . '.' . $GLOBALS['domain'] . '/reservation.php?1021++' . $resId;
                            $field = '<a href="' . $url . '" target="_blank">Payment link</a>';
                            break;
                    }
                    break;
                case "ResOffice":
                    $persona = getPersonaRecord($resOfficeId);
                    switch ($explodedfield[1]) {
                        case "Organisation Name":
                            $field = isset($persona[0])?$persona[0]['pr_name_last']:"";
                            break;
                        case "Telephone":
                            $field = getTelephone($resOfficeId);
                            break;
                        case "Fax":
                            $field = getFax($resOfficeId);
                            break;
                        case "Email":
                            $field = getEmail($resOfficeId);
                            break;
                        case "Postal Address":
                            $field = getContactCorrAddress($resOfficeId);
                            break;
                        case "Physical Address":
                            $field = getContactPhysAddress($resOfficeId);;
                            break;
                        case "URL":
                            $field = getURL($resOfficeId);
                            break;
                    }
                    break;
                case "Principal":
                    $persona = getPersonaRecord($principalId);
                    switch ($explodedfield[1]) {
                        case "Organisation Name":
                            $field = isset($persona[0])?$persona[0]['pr_name_last']:"";
                            break;
                        case "Telephone":
                            $field = getTelephone($principalId);
                            break;
                        case "Fax":
                            $field = getFax($principalId);
                            break;
                        case "Email":
                            $field = getEmail($principalId);
                            break;
                        case "Postal Address":
                            $field = getContactCorrAddress($principalId);
                            break;
                        case "Physical Address":
                            $field = getContactPhysAddress($principalId);;
                            break;
                        case "URL":
                            $field = getURL($principalId);
                            break;
                        case "Payment URL":
                            $url = $GLOBALS['http'] . $GLOBALS['principal_name_short'] . '.' . $GLOBALS['domain'] . '/reservation.php?1021';
                            $field = '<a href="' . $url . '" target="_blank">Payment link</a>';
                            break;
                    }
                    break;
                case "Payment":
                    switch ($explodedfield[1]) {
                    case "CreditCardLink":
                        $field = $GLOBALS['http'] . $_SESSION['principal_name_short'] . ".resrequest.com/pay.php";
                        $params = array();
                        if (!empty($resId)) {
                            $params[] = "resid=$resId";
                        }
                        if (!empty($folioId)) {
                            $email = $lDB->get("
								SELECT
									pr_persona.pr_email
								FROM
									fn_folio
									INNER JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
								WHERE
									fn_folio.fn_folio_ix = '$folioId'
							", 4);
                            if (!empty($email)) {
                                $params[] = "email=$email";
                            }
                        }
                        if (sizeof($params) > 0) {
                            $field .= "?" . join("&", $params);
                        }
                        break;
                    }
                    break;
            }

            if ($field != '') {
                $values[] = $field;
            }
        }

        if (!empty($values)) {
            $value = join(' / ', $values);
            $text = str_replace($dirtyfield, $value, $text);
        }

		$field = '';
		switch ($explodedfield[0]) {
			case "ResDetails":
				switch ($explodedfield[1]) {
					case "Details":
						$field = nl2br(getReservationsDetails($resIds));
						break;
				}
				break;
		}

		if (!empty($field)) {
			$text = str_replace($dirtyfield, $field, $text);
		}

	}
}

function getPersonaRecord($personaId){
	global $lDB;

	$record = $lDB->get("SELECT * FROM pr_persona WHERE pr_persona_ix = '$personaId'", 2);
	
	return $record;
}

function getReservationRecord($reservationId){
	global $lDB;

	$record = $lDB->get("SELECT * FROM rv_reservation WHERE rv_reservation_ix = '$reservationId'", 2);
	
	return $record;
}

function getReservationsDetails($ids) {
	global $lDB;

	$reservations = '';
	foreach( $ids as $resId) {
		$resItem = $lDB->get("SELECT rv_reservation_item.rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_item.rv_reservation_id = '$resId'", 3);
		foreach ($resItem as $index => $item) {
			$resSql = $lDB->get("SELECT
				rv_reservation.rv_reservation_ix as resNum,
				rv_reservation.rv_res_name as resName,
				rv_reservation.rv_provision_expiry_date as expDate,
				rv_reservation_item.rv_item_date_arrive as arrive,
				rv_reservation_item.rv_item_date_depart as depart,
				pr_business.pr_bus_name_short as prop,
				ac_accomm_type.ac_accomm_desc as accomm,
				rv_reservation_item.rv_item_accomm_count as rooms,
				rv_reservation_item.rv_item_adult_count as adults,            
				rv_reservation_item.rv_item_child_count as child,
				pr_persona.pr_name_last as name
				FROM rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				INNER JOIN pr_business ON pr_business.pr_business_id = rv_reservation_item.pr_business_id
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
				WHERE rv_reservation_item.rv_reservation_item_ix = '$item'
			", 1);

			if ($index === 0) {
				$reservations .= '<b>' . $resSql['resNum'] . ": " . $resSql['resName'] . "</b>";
			}

			$expire = chng_date($resSql['expDate'], "-");
			$arrive = chng_date($resSql['arrive'], "-");
			$depart = chng_date($resSql['depart'], "-");
			$reservations .= "<br><br>&nbsp;&nbsp;Arr: " . $arrive . " | Dep: " . $depart . " | Prop: " . $resSql['name'] . " | Accomm: " . $resSql['accomm'] . "<br>&nbsp;&nbsp;Rms: " . $resSql['rooms'] . " | Ad: " . $resSql['adults'] . " | Ch: " . $resSql['child'] . " | Exp date: " . $expire;
		}
	}

	return rtrim($reservations);
}

function getEmail($personaId) {
	global $lDB;

	$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($email) == "" || $email == "0") {
		$personaId = getLinkedPersonaRecord($personaId);
		$email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($email) == "" || $email == "0") {
			return "";
		} else {
			return $email;
		}
	} else {
		return $email;
	}
}


function getConsultantRel($personaId) {
	$cunsultantRel = $GLOBALS['lDB']->get("
		SELECT
			pr_link_to
		FROM
			pr_link
		WHERE
			pr_link_from = '$personaId'
			AND rf_link_type_id = 'RS1'
	",4);

	return $cunsultantRel;
}


function getURL($personaId) {
	global $lDB;

	$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if (trim($url) == "" || $url == "0") {
		$personaId = getLinkedPersonaRecord($personaId);
		$url = $lDB->get("SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
		if (trim($url) == "" || $url == "0") {
			return "";
		} else {
			return $url;
		}
	} else {
		return $url;
	}
}

function getFax($personaId) {
	global $lDB;
	
	$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
	if (trim($faxNumber) == "" || $faxNumber == "0") {
		$personaId = getLinkedPersonaRecord($personaId);
		$faxNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND rf_phone_type_id = 'RS1'",4);
		if (trim($faxNumber) == "" || $faxNumber == "0") {
			return "";
		} else {
			return $faxNumber;
		}
	} else {
		return $faxNumber;
	}
}

function getTelephone($personaId) {
	global $lDB;

	$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$personaId' AND pr_default_yn = 1", 4);
	if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
		$personaId = getLinkedPersonaRecord($personaId);
		$telephoneNumber = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '".$personaId."' AND pr_default_yn = 1", 4);
		if(trim($telephoneNumber) == "" || $telephoneNumber == "0") {
			return "";
		} else {
			return $telephoneNumber;
		}
	} else {
		return $telephoneNumber;
	}
}

function getFullName($personaId) {
	global $lDB;
	
	$nameArray = $lDB->get("
		SELECT
			/*0*/ pr_name_first,
			/*1*/ pr_name_second,
			/*2*/ pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$personaId'
	",1);
	$name = $nameArray['pr_name_last'];
	if (trim($nameArray['pr_name_second']) != "" && $nameArray['pr_name_second'] != "0") {
		$name = $nameArray['pr_name_second'] . " " . $name;
	}
	if (trim($nameArray['pr_name_first']) != "" && $nameArray['pr_name_first'] != "0") {
		$name = $nameArray['pr_name_first'] . " " . $name;
	}
	$link = $lDB->get("
		SELECT
			pr_name_last
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_to
		WHERE
			pr_link.pr_link_from = '$personaId'
			AND pr_link.rf_link_type_id IN ('RS1','RS2')
	",4);
	if($link != "0" && trim($link) != "") {
		$name .= " (".$link.")";
	}
	if($lDB->get("SELECT rf_res_office_id FROM rf_default",4) == $personaId) {
		$name .= " (Res Office)";
	}
	return $name;
}

function getLinkedPersonaRecord($personaId) {
	$linkId = $GLOBALS['lDB']->get("SELECT pr_persona_link_id FROM pr_persona WHERE pr_persona_ix = '$personaId'", 4);
	if(trim($linkId) != "" && $linkId != "0") {
		return $linkId;
	} else {
		return $personaId;
	}
}


function initTemplates($resId){

	$data = false;
	$GLOBALS['temp']['templateManageAccess'] = "hidden";

	if(TemplatesReadAccess()) {
		$data = array();
		$data['toggle'] = "templatesEnabled = true";
	
		if(TemplatesUpdateAccess()) {
			$GLOBALS['temp']['templateManageAccess'] = "visible";
		}
	
		$template = db_pf_option_default(db_pf_object_by_name("email_templates"));

		if ($template != ""){
			db_pf_field_load_by_name($template,'templateText',$templateText);
			parseTemplate($templateText, $resId);
		}
		
		$data['text'] = isset($templateText) ? $templateText : "";

	}
	
	return $data;
}
