<?php

function tran_debtor($fn_batch_id,$pr_business_id,$rf_currency_id=false,$export_ind=TRAN_DEBTOR_EXPORT_ALL,$export_set=false) {
	global $lDB;

	$batchWhere = "";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			AND fn_tran.fn_batch_id = '$fn_batch_id'
		";
	}
	if(!empty($rf_currency_id)) {
		$batchWhere .= "
			AND fn_debtor.rf_currency_id = '$rf_currency_id'
		";
	}
	switch($export_ind) {
	case TRAN_DEBTOR_EXPORT_NEW:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '0'
		";
		break;
	case TRAN_DEBTOR_EXPORT_OLD:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '1'
		";
		break;
	}

	$list = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			fn_debtor.fn_debtor_ix,
			fn_debtor.fn_debtor_code,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_addr_line3,
			pr_persona.pr_corr_post_code,
			pr_persona.pr_corr_city,
			pr_corr_country.rf_country_name AS pr_corr_country_name,
			pr_persona.pr_phys_addr_line1,
			pr_persona.pr_phys_addr_line2,
			pr_persona.pr_phys_addr_line3,
			pr_persona.pr_phys_post_code,
			pr_persona.pr_phys_city,
			pr_phys_country.rf_country_name AS pr_phys_country_name,
			/*pr_consultant.pr_name_first AS pr_consultant_name_first,
			pr_consultant.pr_name_last AS pr_consultant_name_last,*/
			pr_persona.pr_statutory_1,
			pr_persona.pr_statutory_2,
			pr_persona.pr_statutory_3,
			pr_persona.pr_email,
			rf_currency.rf_currency_symbol
		FROM
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
			INNER JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_debtor.rf_currency_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_debtor.pr_persona_id
			/*LEFT JOIN pr_persona AS pr_consultant ON pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id*/
			LEFT JOIN rf_country AS pr_corr_country ON pr_corr_country.rf_country_ix = pr_persona.pr_corr_country_id
			LEFT JOIN rf_country AS pr_phys_country ON pr_phys_country.rf_country_ix = pr_persona.pr_phys_country_id
		WHERE
			fn_tran.pr_business_id = '$pr_business_id'
			$batchWhere
	",2);

	$csvFile = array();

	$debtors = array();
	foreach($list as $item) {
		$debtors[] = $item['fn_debtor_ix'];
		$telephone = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code != '1'
			ORDER BY
				pr_default_yn DESC
		",4);
		$fax = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code = '1'
			ORDER BY
				pr_default_yn DESC
		",4);
		array_push($csvFile,array(
			/*  1 */ $item['fn_debtor_code'],
			/*  2 */ trim($item['pr_name_first'] . " " . $item['pr_name_last']),
			/*  3 */ $item['pr_corr_addr_line1'],
			/*  4 */ $item['pr_corr_addr_line2'],
			/*  5 */ $item['pr_corr_addr_line3'],
			/*  6 */ trim($item['pr_corr_post_code'] . " " . $item['pr_corr_city']),
			/*  7 */ $item['pr_corr_country_name'],
			/*  8 */ $telephone,
			/*  9 */ $fax,
			/* 10 */ "", // TODO: Add consultant to debtor trim($item['pr_consultant_name_first'] . " " . $item['pr_consultant_name_last']),
			/* 11 */ $item['pr_phys_addr_line1'],
			/* 12 */ $item['pr_phys_addr_line2'],
			/* 13 */ $item['pr_phys_addr_line3'],
			/* 14 */ trim($item['pr_phys_post_code'] . " " . $item['pr_phys_city']),
			/* 15 */ $item['pr_phys_country_name'],
			/* 16 */ $item['pr_statutory_1'],
			/* 17 */ $item['pr_email'],
			/* 18 */ $item['rf_currency_symbol'],
			/* 19 */ $item['pr_statutory_2'],
			/* 20 */ $item['pr_statutory_3']
		));
	}

	if($export_set) {
		foreach($debtors as $fn_debtor_id) {
			db_fn_debtor_set_export($fn_debtor_id);
		}
	}

	return $csvFile;
}

function tran_item_export($sql_where,$summary=false,$showHeader=true) {
	$exportDate = date("Y-m-d");
	$csvFile = array();

	if ($summary){
		$sql_select = "
			fn_tran.fn_batch_id,
			fn_year.fn_year_desc,
			pr_business.pr_bus_name_short,
			pr_business.pr_bus_post_source_curr_yn,
			SUM(fn_tran_item.fn_tran_item_amt) as fn_tran_item_amt,
			SUM(fn_tran_item.fn_tran_item_amt_source) as fn_tran_item_amt_source,
			source_curr.rf_currency_symbol AS source_currency,
			home_curr.rf_currency_symbol AS home_currency,
			cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
			cost_ctr2.fn_cost_centre_code AS cost_centre_2_code,
			fn_ledger.fn_ledger_code,
			fn_debtor.fn_debtor_code
		";

		$sql_group = "
			GROUP BY
				cost_ctr1.fn_cost_centre_code,
				cost_ctr2.fn_cost_centre_code,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code
		";


	} else {
		$sql_select = "
			fn_tran.fn_batch_id,
			pr_business.pr_bus_name_short,
			pr_business.pr_bus_post_source_curr_yn,
			fn_year.fn_year_desc,
			fn_tran.fn_tran_date_ledger,
			fn_tran_item.fn_tran_item_type_ind,
			fn_tran_item.fn_tran_item_amt,
			fn_tran_item.fn_tran_item_amt_source,
			source_curr.rf_currency_symbol AS source_currency,
			home_curr.rf_currency_symbol AS home_currency,
			cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
			cost_ctr2.fn_cost_centre_code AS cost_centre_2_code,
			fn_ledger.fn_ledger_code,
			fn_debtor.fn_debtor_code,
			fn_tran.fn_tran_detail
		";

		$sql_group = "";
	}

	$sql_from = "
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
			INNER JOIN rf_currency AS source_curr ON source_curr.rf_currency_ix = fn_tran_item.rf_currency_id
			INNER JOIN rf_currency AS home_curr ON home_curr.rf_currency_ix = pr_business.pr_bus_home_curr_id
			LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
			LEFT JOIN fn_cost_centre AS cost_ctr1 ON cost_ctr1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			LEFT JOIN fn_cost_centre AS cost_ctr2 ON cost_ctr2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
			LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
			LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
	";


	$list = $GLOBALS['lDB']->get("
		SELECT
			$sql_select
		FROM
			$sql_from
		WHERE
			$sql_where
		$sql_group
	",2);

	if ($list[0]['pr_bus_post_source_curr_yn'] == 1){
		$showSourceCurr = true;

		// Annoyingly, if we are showing the summary, and we want the source currency shown, we need to re-run the SQL with
		// another GROUPING
		if ($summary){
			$sql_group .= ",
				source_currency
			";
		}

		$list = $GLOBALS['lDB']->get("
			SELECT
				$sql_select
			FROM
				$sql_from
			WHERE
				$sql_where
			$sql_group
		",2);

	} else {
		$showSourceCurr = false;
	}

	if($showHeader) {

		$headerRow = array("Batch id","Invoice unit","Financial year");

		if ($summary){
			if ($showSourceCurr){
				array_push($headerRow,"GL Amount","GL Currency","Source Amount","Source Currency");
			} else {
				array_push($headerRow,"GL Amount","Source Currency");
			}

		} else {
			if ($showSourceCurr){
				array_push($headerRow,"Ledger date","Type","GL Amount","GL Currency","Source Amount","Source Currency","Transaction detail");
			} else {
				array_push($headerRow,"Ledger date","Type","GL Amount","Source Currency","Transaction detail");
			}

		}

		array_push($headerRow, "Cost centre 1","Cost centre 2","Ledger code","Debtor code","Export date");

		array_push($csvFile, $headerRow);

	}

	foreach($list as $item) {
		$item['fn_tran_item_amt'] = round($item['fn_tran_item_amt'],2);
		fixAmtDisplay($item['fn_tran_item_amt'],2);
		$dataRow = array();

		if ($summary){
			array_push($dataRow,
					($item['fn_batch_id'] == null) ? "n/a" : $item['fn_batch_id'],
					$item['pr_bus_name_short'],
					($item['fn_year_desc'] == null) ? "n/a" : $item['fn_year_desc'],
					$item['fn_tran_item_amt']
			);

			if ($showSourceCurr){
				array_push($dataRow,
					$item['home_currency'],
					$item['fn_tran_item_amt_source'],
					$item['source_currency']
				);
			} else {
				array_push($dataRow,
					$item['source_currency']
				);
			}

		} else {
			array_push($dataRow,
					$item['fn_batch_id'],
					$item['pr_bus_name_short'],
					$item['fn_year_desc'],
					$item['fn_tran_date_ledger'],
					db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']),
					$item['fn_tran_item_amt']
			);

			if ($showSourceCurr){
				array_push($dataRow,
					$item['home_currency'],
					$item['fn_tran_item_amt_source'],
					$item['source_currency'],
					$item['fn_tran_detail']
				);
			} else {
				array_push($dataRow,
					$item['source_currency'],
					$item['fn_tran_detail']
				);
			}

		}

		array_push($dataRow,
			$item['cost_centre_1_code'],
			$item['cost_centre_2_code'],
			$item['fn_ledger_code'],
			$item['fn_debtor_code'],
			$exportDate
		);

		array_push($csvFile, $dataRow);

	}
	return $csvFile;
}

function tran_export($sql_where="", $sql_extra="",$showHeader=true) {
	$csvFile = array();
	$inventTranTypes = [
		DB_FN_TRAN_LINK_PO_RECEIPT,
		DB_FN_TRAN_LINK_RETURN,
		DB_FN_TRAN_LINK_COS,
		DB_FN_TRAN_LINK_ISSUE,
		DB_FN_TRAN_LINK_TRANSFER
	];

	$list = $GLOBALS['lDB']->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_link_id,
			fn_tran.rv_reservation_id,
			rv_reservation.rv_res_name,
			fn_folio.fn_folio_ix,
			fn_folio.rf_currency_id AS folio_currency_id,
			pr_folio.pr_name_last as pr_folio_last,
			pr_folio.pr_name_first as pr_folio_first,
			rv_payment.rv_payment_ix,
			pr_payment.pr_name_last as pr_payment_last,
			pr_payment.pr_name_first as pr_payment_first,
			fn_tran.fn_tran_amt_incl,
			fn_tran.fn_tran_amt_source,
			pr_business.pr_bus_name_short,
			pr_business.pr_bus_post_source_curr_yn,
			fn_tran.fn_batch_id,
			fn_batch.fn_batch_ix,
			fn_batch.fn_batch_name,
			fn_batch.fn_batch_closed_yn,
			fn_year.fn_year_desc,
			fn_year.fn_year_end_date,
			home_curr.rf_currency_symbol as home_currency,
			source_curr.rf_currency_symbol as source_currency,
			SUM(fn_tran_item.fn_tran_item_amt) as fn_tran_item_amt,
			fn_cost_centre2.fn_cost_centre_desc AS location,
			fn_tran.fn_tran_inventory_doc AS tran_doc_ref
		FROM
			fn_tran
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
			LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
			INNER JOIN rf_currency AS source_curr ON source_curr.rf_currency_ix = fn_tran.rf_currency_id
			INNER JOIN rf_currency AS home_curr ON home_curr.rf_currency_ix = pr_business.pr_bus_home_curr_id
			LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = fn_tran.fn_folio_id
			LEFT JOIN pr_persona AS pr_folio ON pr_folio.pr_persona_ix = fn_folio.fn_folio_to_id
			LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
			LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
			LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
			LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
			LEFT JOIN pr_persona AS pr_payment ON pr_payment.pr_persona_ix = rv_payment.pr_persona_id
			LEFT JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix
			LEFT JOIN fn_cost_centre AS fn_cost_centre2 ON fn_cost_centre2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
		WHERE
		$sql_where
			GROUP BY
				fn_tran.fn_tran_ix
		$sql_extra
	",2);

	if ($list[0]['pr_bus_post_source_curr_yn'] == 1){
		$showSourceCurr = true;
	} else {
		$showSourceCurr = false;
	}

	if($showHeader) {
		$headerRow = array("Batch id","Invoice unit","Financial year","Ledger date","Type","Reservation number","Invoice / Payment / Doc number","Reservation / Payee name / Department");

		if ($showSourceCurr){
			array_push($headerRow, "Home Amount","Home Currency Symbol","Source Amount","Source Currency Symbol");
		} else {
			array_push($headerRow, "Amount");
		}

		array_push($csvFile,$headerRow);

	}

	foreach($list as $item) {
		$item['fn_tran_amt_incl'] = round($item['fn_tran_amt_incl'],2);
		fixAmtDisplay($item['fn_tran_amt_incl'],2);

		if(trim($item['fn_batch_id']) == "" || $item['fn_batch_id'] == "0") {
			$item['fn_batch_id'] = "unallocated";
		}

		list($fn_tran_date_ledger) = explode(" ",$item['fn_tran_date_ledger']);
		$item['fn_tran_date_ledger'] = chng_date($fn_tran_date_ledger,"-");

		if($item['fn_tran_link_ind'] != DB_FN_TRAN_LINK_INVOICE) {
			$pr_name = trim($item['pr_payment_first'] . " " . $item['pr_payment_last']);
			if($pr_name == "") {
				$pr_name = "Cash";
			}
			$item['fn_tran_link_id'] = $item['rv_payment_ix'];
			if (in_array($item['fn_tran_link_ind'], $inventTranTypes)) {
				$pr_name = $item['location'];
				$item['fn_tran_link_id'] = $item['tran_doc_ref'];
			}
		} else {
			$pr_name = trim($item['pr_folio_first'] . " " . $item['pr_folio_last']);
			if($pr_name == "") {
				if(!empty($item['fn_folio_ix'])) {	
					$pr_name = "Cash";
				} else {
					$pr_name = "Unknown";
				}
			}
		}

		$dataRow = array(
			$item['fn_batch_id'],
			$item['pr_bus_name_short'],
			$item['fn_year_desc'],
			$item['fn_tran_date_ledger'],
			db_fn_tran_link_desc($item['fn_tran_link_ind']),
			$item['rv_reservation_id'],
			$item['fn_tran_link_id'],
			$pr_name
		);

		if ($showSourceCurr){
			array_push($dataRow,
				$item['fn_tran_amt_incl'],
				$item['home_currency'],
				$item['fn_tran_amt_source'],
				$item['source_currency']
			);
		} else {
			array_push($dataRow,
				$item['fn_tran_amt_incl']
			);
		}
		array_push($csvFile,$dataRow);

	}
	return $csvFile;
}

function tran_export_options($pr_business_id) {
	global $lDB;

	$exportOptions = "
		<option value=\"debtor\">Debtors</option>
		<option value=\"tran\">Transaction</option>
		<option value=\"tran_item\">Transaction item</option>
		<option value=\"tran_item_summary\">Transaction item summary</option>
	";
	$fn_system = $lDB->get("
		SELECT
			*
		FROM
			pr_business
			INNER JOIN fn_system ON fn_system.fn_system_ix = pr_business.fn_system_id
		WHERE
			pr_business.pr_business_id = '$pr_business_id'
	",1);

	$allSelected = "";
	$creditNoteSelected = "";
	$debtorSelected = "";
	$invoiceSelected = "";
	$paymentSelected = "";
	$tranSelected = "";
	$refundSelected = "";
	$journalSelected = "";
	$debtorJournalSelected = "";

	if (!empty($fn_system)) { 

	if(array_key_exists('fn_sys_all_yn', $fn_system) && $fn_system['fn_sys_all_yn'] == "1") {
		$allSelected = "selected";
	} elseif(array_key_exists('fn_sys_debtor_yn', $fn_system) && $fn_system['fn_sys_debtor_yn'] == "1") {
		$debtorSelected = "selected";
	} elseif(array_key_exists('fn_sys_tran_yn', $fn_system) && $fn_system['fn_sys_tran_yn'] == "1") {
		$tranSelected = "selected";
	} elseif(array_key_exists('fn_sys_invoice_yn', $fn_system) && $fn_system['fn_sys_invoice_yn'] == "1") {
		$invoiceSelected = "selected";
	} elseif(array_key_exists('fn_sys_credit_note_yn', $fn_system) && $fn_system['fn_sys_credit_note_yn'] == "1") {
		$creditNoteSelected = "selcted";
	} elseif(array_key_exists('fn_sys_payment_yn', $fn_system) && $fn_system['fn_sys_payment_yn'] == "1") {
		$paymentSelected = "selected";
	} elseif(array_key_exists('fn_sys_refund_yn', $fn_system) && $fn_system['fn_sys_refund_yn'] == "1") {
		$refundSelected = "selected";
	} elseif(array_key_exists('fn_sys_journal_yn', $fn_system) && $fn_system['fn_sys_journal_yn'] == "1") {
		$journalSelected = "selected";
	} elseif(array_key_exists('fn_sys_debtor_journal_yn', $fn_system) && $fn_system['fn_sys_debtor_journal_yn'] == "1") {
		$debtorJournalSelected = "selected";
	}

	if(array_key_exists('fn_sys_all_yn', $fn_system) && $fn_system['fn_sys_all_yn'] == "1") {
		$exportOptions .= "
			<option $allSelected value=\"$fn_system[fn_system_name]_all\">$fn_system[fn_system_desc] (All)</option>
		";
	}

	if(array_key_exists('fn_sys_debtor_yn', $fn_system) && $fn_system['fn_sys_debtor_yn'] == "1") {
		$exportOptions .= "
			<option $debtorSelected value=\"$fn_system[fn_system_name]_debtor\">$fn_system[fn_system_desc] (Debtors)</option>
		";
	}
	if(array_key_exists('fn_sys_tran_yn', $fn_system) && $fn_system['fn_sys_tran_yn'] == "1") {
		$exportOptions .= "
			<option $tranSelected value=\"$fn_system[fn_system_name]_tran\">$fn_system[fn_system_desc] (Transactions)</option>
		";
	}
	if(array_key_exists('fn_sys_tran_summary_yn', $fn_system) && $fn_system['fn_sys_tran_summary_yn'] == "1") {
		$exportOptions .= "
			<option value=\"$fn_system[fn_system_name]_tran_summary\">$fn_system[fn_system_desc] (Transaction Summary)</option>
		";
	}
	if(array_key_exists('fn_sys_invoice_yn', $fn_system) && $fn_system['fn_sys_invoice_yn'] == "1") {
		$exportOptions .= "
			<option $invoiceSelected value=\"$fn_system[fn_system_name]_invoice\">$fn_system[fn_system_desc] (Invoices)</option>
		";
	}
	if(array_key_exists('fn_sys_credit_note_yn', $fn_system) && $fn_system['fn_sys_credit_note_yn'] == "1") {
		$exportOptions .= "
			<option $creditNoteSelected value=\"$fn_system[fn_system_name]_credit_note\">$fn_system[fn_system_desc] (Credit Notes)</option>
		";
	}
	if(array_key_exists('fn_sys_payment_yn', $fn_system) && $fn_system['fn_sys_payment_yn'] == "1") {
		$exportOptions .= "
			<option $paymentSelected value=\"$fn_system[fn_system_name]_payment\">$fn_system[fn_system_desc] (Payments)</option>
		";
	}
	if(array_key_exists('fn_sys_refund_yn', $fn_system) && $fn_system['fn_sys_refund_yn'] == "1") {
		$exportOptions .= "
			<option $refundSelected value=\"$fn_system[fn_system_name]_refund\">$fn_system[fn_system_desc] (Refunds)</option>
		";
	}
	if(array_key_exists('fn_sys_journal_yn', $fn_system) && $fn_system['fn_sys_journal_yn'] == "1") {
		$exportOptions .= "
			<option $journalSelected value=\"$fn_system[fn_system_name]_journal\">$fn_system[fn_system_desc] (Journal)</option>
		";
	}
	if(array_key_exists('fn_sys_debtor_journal_yn', $fn_system) && $fn_system['fn_sys_debtor_journal_yn'] == "1") {
		$exportOptions .= "
			<option $debtorJournalSelected value=\"$fn_system[fn_system_name]_dtr_journal\">$fn_system[fn_system_desc] (Debtor Journal)</option>
		";
	}

	} 

	return $exportOptions;
}

function tran_array_to_pipe($csvFile) {
	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) {
				$csvText .= "|";
			} else {
				$first = false;
			}
			$csvText .= str_replace("\\","\\\\",str_replace("|","\\|",$csvItem));
		}
		$csvText .= "\n";
	}
	return $csvText;
}
function tran_pipe_output($filename,$content,$die=true) {
	$output = tran_array_to_pipe($content);
	if(headers_sent()) {
		echo('Some data has already been output to browser, can\'t send pipe file');
	}
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: '.strlen($output));
	header("Content-Disposition: inline; filename=$filename");
	echo $output;
	flush();
	if($die) {
		die();
	}
}

function getTranCode($pr_business_id, $item) {
	$codeType = false;
	$codeType = db_fn_option_data_by_name($pr_business_id, "account_code_format");

	$codeSep = db_fn_option_data_by_name($pr_business_id, "account_code_separator");
	
	$revCentreFormat = db_fn_option_data_by_name($pr_business_id, "rev_ctr_format");

	$costCode = trim($item['cost_centre_2_code']);
	$costCentreCode = (!isset($revCentreFormat) || empty($revCentreFormat) || $revCentreFormat == '')
					? trim($item['cost_centre_1_code']) . trim($item['cost_centre_2_code'])
					: trim($item['cost_centre_1_code']);

	if ($codeSep === false){
		$codeSep = "";
	}

	if($codeType === false || ($codeType < 1 || $codeType > 3)) {
		$codeType = TRAN_CODE_FULL_GL;
	}

	switch($codeType) {
	case TRAN_CODE_FULL_GL:
		$accountNumber = $item['fn_ledger_code'];
		break;
	case TRAN_CODE_BEGIN_GL:
		if (trim($item['fn_ledger_code']) != "" && trim($item['cost_centre_1_code']) != ""){
			$accountNumber = $item['fn_ledger_code'] . $codeSep . $costCentreCode;
		} else {
			$accountNumber = $item['fn_ledger_code'] . $costCentreCode;
		}
		break;
	case TRAN_CODE_END_GL:
	default:
		if (trim($item['fn_ledger_code']) != "" && trim($item['cost_centre_1_code']) != ""){
			$accountNumber = $costCentreCode . $codeSep . $item['fn_ledger_code'];
		} else {
			$accountNumber = $costCentreCode . $item['fn_ledger_code'];
		}
		break;
	}

	return array($accountNumber, $costCode);

}

function getCostCentreCode($pr_business_id, $item) {

	$InvoiceLineClassFullNameFormat = db_fn_option_data_by_name($pr_business_id, 'rev_ctr_format');
	$codeSep = db_fn_option_data_by_name($pr_business_id, "account_code_separator");
	if ($codeSep === false){
		$codeSep = "";
	}

	switch ($InvoiceLineClassFullNameFormat) { 
		// Concatenate invoiceLineClassFullName as per option setting:
		// 0 = None (default), 1 = Rev Ctr 1, 2 = Rev Ctr 2, 3 = RC1 & RC2, 4 = RC2 & RC1
		case '1':
			$invoiceLineClassFullName = $item['cost_centre_1_code'];
			break;
		case '2':
			$invoiceLineClassFullName = $item['cost_centre_2_code'];
			break;
		case '3':
			$invoiceLineClassFullName = (!$item['cost_centre_1_code'] && !$item['cost_centre_1_code']) ? "" : $item['cost_centre_1_code'] . $codeSep . $item['cost_centre_2_code'];
			break;
		case '4':
			$invoiceLineClassFullName = (!$item['cost_centre_1_code'] && !$item['cost_centre_1_code']) ? "" : $item['cost_centre_2_code'] . $codeSep . $item['cost_centre_1_code'];
			break;
		default:
			$invoiceLineClassFullName = "";
			break;
	}

	return $invoiceLineClassFullName;

}

function tran_account_pair_label($code, $desc) {
	$label = "";
	if(trim($code) !== "") {
		$label .= $code;
	}
	if(trim($desc) !== "") {
		if($label !== "") {
			$label .= ": ";
		}
		$label .= $desc;
	}
	return $label;
}

function tran_update_mapping($codes,$pr_business_id) {
	global $lDB;

	foreach($codes as $code) {
		switch($code->type) {
		case "accomm":
			if(!db_rt_component_inv_exists($code->id, $pr_business_id)) {
				db_rt_component_inv_insert($code->id, "", $code->fn_ledger_id, $pr_business_id);
			} else {
				$component = $lDB->get("
					SELECT
						rt_component_inv.rt_component_inv_ix,
						rt_component_inv.fn_cost_centre_2_id	
					FROM
						rt_component_inv
					WHERE
						rt_component_inv.pr_business_id = '$pr_business_id'
						AND rt_component_inv.rt_component_id = '$code->id'
				",1);
				db_rt_component_inv_update($component['rt_component_inv_ix'], $component['fn_cost_centre_2_id'], $code->fn_ledger_id, $pr_business_id);
			}
			break;
		case "extra":
			if(!db_ac_extra_inv_exists($code->id, $pr_business_id)) {
				db_ac_extra_inv_insert($code->id, "", "", $code->fn_ledger_id, $pr_business_id);
			} else {
				$ac_extra_inv_id = $lDB->get("
					SELECT
						ac_extra_inv.ac_extra_inv_ix
					FROM
						ac_extra_inv
					WHERE
						ac_extra_inv.pr_business_id = '$pr_business_id'
						AND ac_extra_inv.ac_extra_id = '$code->id'
				",4);
				db_ac_extra_inv_update($ac_extra_inv_id, ["fn_ledger_id"], [$code->fn_ledger_id], $pr_business_id);
			}
			break;
		case "bank":
			if(!db_rf_bank_inv_exists_by_all($pr_business_id,$code->id)) {
				db_rf_bank_inv_insert($pr_business_id,$code->id,$code->fn_ledger_id,"");
			} else {
				$bank = $lDB->get("
					SELECT
						rf_bank_inv.rf_bank_inv_ix,
						rf_bank_inv.fn_ledger_id_deposit
					FROM
						rf_bank_inv
					WHERE
						rf_bank_inv.pr_business_id = '$pr_business_id'
						AND rf_bank_inv.rf_bank_id = '$code->id'
				",1);
				db_rf_bank_inv_update($bank['rf_bank_inv_ix'],$code->fn_ledger_id,$bank['fn_ledger_id_deposit']);
			}
			break;
		case "deposit":
			if(!db_rf_bank_inv_exists_by_all($pr_business_id,$code->id)) {
				db_rf_bank_inv_insert($pr_business_id,$code->id,"",$code->fn_ledger_id);
			} else {
				$bank = $lDB->get("
					SELECT
						rf_bank_inv.rf_bank_inv_ix,
						rf_bank_inv.fn_ledger_id_account
					FROM
						rf_bank_inv
					WHERE
						rf_bank_inv.pr_business_id = '$pr_business_id'
						AND rf_bank_inv.rf_bank_id = '$code->id'
				",1);
				db_rf_bank_inv_update($bank['rf_bank_inv_ix'],$bank['fn_ledger_id_account'],$code->fn_ledger_id);
			}
			break;
		case "tax":
			$rf_tax_inv_ix = db_rf_tax_inv_exists($code->id,10,$pr_business_id);
			if(!$rf_tax_inv_ix) {
				db_rf_tax_inv_insert($code->fn_ledger_id, $pr_business_id, $code->id, 10);
			} else {
				db_rf_tax_inv_update($rf_tax_inv_ix, $code->fn_ledger_id, $pr_business_id);
			}
			break;
		}
	}
}

function tran_regenerate($transactions) {
	global $lDB;

	$transactions = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_link_ind
		FROM
			fn_tran
		WHERE
			fn_tran.fn_tran_ix IN ('".join("','",$transactions)."')
	",2);
	foreach($transactions as $transaction) {
		switch($transaction['fn_tran_link_ind']) {
		case DB_FN_TRAN_LINK_PAYMENT:
			$rv_payment_item_id = $lDB->get("SELECT fn_tran_link_id FROM fn_tran WHERE fn_tran_ix = '$transaction[fn_tran_ix]'",4);
			$fn_tran_item_id = $lDB->get("
				SELECT
					fn_tran_item.fn_tran_item_ix
				FROM
					fn_tran_item
				WHERE
					fn_tran_item.fn_tran_id = '$transaction[fn_tran_ix]'
					AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_BANK."'
			",4);
			$paymentInfo = db_fn_tran_payment_lookup($rv_payment_item_id);

			if ($paymentInfo) {
				// Update fn_tran_item_note for payments
				$fn_tran_item_note = $paymentInfo['rv_pmnt_note'] . ';' . $paymentInfo['rv_pmnt_ref'];
				$lDB->put("
					UPDATE fn_tran_item
					SET fn_tran_item_note = '$fn_tran_item_note'
					WHERE fn_tran_item_ix = '$fn_tran_item_id'
				");
			}

			db_fn_tran_item_set_ledger($fn_tran_item_id,$paymentInfo['fn_ledger_id_account']);
			break;
		case DB_FN_TRAN_LINK_DEPOSIT:
			// no break
		case DB_FN_TRAN_LINK_REVERSAL:
			$rv_payment_item_id = $lDB->get("SELECT fn_tran_link_id FROM fn_tran WHERE fn_tran_ix = '$transaction[fn_tran_ix]'",4);
			$fn_tran_item_id = $lDB->get("
				SELECT
					fn_tran_item.fn_tran_item_ix
				FROM
					fn_tran_item
				WHERE
					fn_tran_item.fn_tran_id = '$transaction[fn_tran_ix]'
					AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEPOSIT."'
			",4);
			$paymentInfo = db_fn_tran_payment_lookup($rv_payment_item_id);
			db_fn_tran_item_set_ledger($fn_tran_item_id,$paymentInfo['fn_ledger_id_deposit']);
			break;
		case DB_FN_TRAN_LINK_INVOICE:
			db_fn_tran_invoice("",$transaction['fn_tran_ix']);
			break;
		}
	}
}
