<?php

function tran_netsuite_debtor($fn_batch_id,$pr_business_id,$rf_currency_id=false,$export_ind=TRAN_DEBTOR_EXPORT_ALL,$export_set=false,$version=false) {
	global $lDB;

	$batchWhere = "";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			AND fn_tran.fn_batch_id = '$fn_batch_id'
		";
	}

	if(!empty($rf_currency_id)) {
		$batchWhere .= "
			AND fn_debtor.rf_currency_id = '$rf_currency_id'
		";
	}
	switch($export_ind) {
	case TRAN_DEBTOR_EXPORT_NEW:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '0'
		";
		break;
	case TRAN_DEBTOR_EXPORT_OLD:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '1'
		";
		break;
	}

	$list = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			fn_debtor.fn_debtor_ix,
			fn_debtor.fn_debtor_code,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_addr_line3,
			pr_persona.pr_corr_post_code,
			pr_persona.pr_corr_city,
			pr_corr_country.rf_country_name AS pr_corr_country_name,
			pr_persona.pr_email
		FROM
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
			INNER JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_debtor.pr_persona_id
			LEFT JOIN rf_country AS pr_corr_country ON pr_corr_country.rf_country_ix = pr_persona.pr_corr_country_id
			LEFT JOIN rf_country AS pr_phys_country ON pr_phys_country.rf_country_ix = pr_persona.pr_phys_country_id
		WHERE
			fn_tran.pr_business_id = '$pr_business_id'
			$batchWhere
	",6);

	$billingUnitCode = $lDB->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$pr_business_id'",4);

	$debtors = array();
	$csvFile = array();
	foreach($list as $item) {
		$debtors[] = $item['fn_debtor_ix'];
		$telephone = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code != '1'
			ORDER BY
				pr_default_yn DESC
		",4);

		$csvFile[] = [
			/*  1 */ $billingUnitCode,
			/*  2 */ "DB",
			/*  3 */ "1",
			/*  4 */ $fn_batch_id,
			/*  5 */ $item['fn_debtor_code'],
			/*  6 */ trim($item['pr_name_first'] . " " . $item['pr_name_last']),
			/*  7 */ $item['pr_corr_addr_line1'],
			/*  8 */ $item['pr_corr_addr_line2'],
			/*  9 */ $item['pr_corr_addr_line3'],
			/* 10 */ $item['pr_corr_post_code'],
			/* 11 */ $item['pr_corr_city'],
			/* 12 */ $item['pr_corr_country_name'],
			/* 13 */ $item['pr_email'],
			/* 14 */ $telephone
		];
	}

	if($export_set) {
		foreach($debtors as $fn_debtor_id) {
			db_fn_debtor_set_export($fn_debtor_id);
		}
	}

	return $csvFile;
}

function tran_netsuite_payment($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	$batchYear = "";
	$billingUnitCode = "";
	$billingCurrencyCode = "";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '" . $lDB->escape($fn_batch_id). "'
		";
		$batchInfo = $lDB->get("
			SELECT
				pr_business.pr_bus_name_short,	
				fn_year.fn_year_desc,
				rf_currency.rf_currency_symbol
			FROM
				fn_batch
				INNER JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_batch.pr_business_id
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = pr_bus_home_curr_id
			WHERE
				fn_batch.fn_batch_ix = '" . $lDB->escape($fn_batch_id) . "'
		",1);
		$batchYear = $batchInfo['fn_year_desc'];
		$billingUnitCode = $batchInfo['pr_bus_name_short'];
		$billingCurrencyCode = $batchInfo['rf_currency_symbol'];
	}


	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.rv_reservation_id,
			rv_reservation.rv_res_name,
			invoice_currency.rf_currency_symbol AS invoice_currency_symbol,
			fn_invoice.fn_invoice_ix
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
			INNER JOIN rf_currency AS invoice_currency ON invoice_currency.rf_currency_ix = fn_tran.rf_currency_id
			INNER JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
			LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8
		WHERE
			$batchWhere
			AND fn_tran.fn_tran_link_ind IN ('".DB_FN_TRAN_LINK_PAYMENT."', '".DB_FN_TRAN_LINK_DEPOSIT."', '".DB_FN_TRAN_LINK_REVERSAL."')
	",6);
	$csvFile = [];
	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_debtor.fn_debtor_code,
				fn_debtor.fn_debtor_desc,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first	
			FROM
				fn_tran_item
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_debtor.pr_persona_id
			WHERE
				fn_tran_item.fn_tran_id = '" . $lDB->escape($tran['fn_tran_ix']). "'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt_incl,
				fn_tran_item.fn_tran_item_amt_source_incl,
				fn_ledger.fn_ledger_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",6);

		$typeCode = "";
		switch($tran['fn_tran_link_ind']) {
		case DB_FN_TRAN_LINK_PAYMENT:
			$typeCode = "PM";
			break;
		case DB_FN_TRAN_LINK_DEPOSIT:
			$typeCode = "DP";
			break;
		case DB_FN_TRAN_LINK_REVERSAL:
			$typeCode = "DR";
			break;
		}

	
		foreach($items as $item) {
			$bankCode = "";
			$depositCode = "";
			if($tran['fn_tran_link_ind'] == DB_FN_TRAN_LINK_PAYMENT) {
				$bankCode = $item['fn_ledger_code'];
			} else {
				$depositCode = $item['fn_ledger_code'];
			}
			$csvFile[] = [
				/*  1 */ $billingUnitCode,
				/*  2 */ $typeCode,
				/*  3 */ "1",
				/*  4 */ "1",
				/*  5 */ $tran['fn_tran_ix'],
				/*  6 */ $fn_batch_id,
				/*  7 */ $batchYear,
				/*  8 */ date("Ym",strtotime($tran['fn_tran_date_ledger'])),
				/*  9 */ date("Ymd",strtotime($tran['fn_tran_date_ledger'])),
				/* 10 */ $tran['fn_tran_link_id'],
				/* 11 */ $tran['rv_reservation_id'],
				/* 12 */ $tran['rv_res_name'],
				/* 13 */ $debtor['fn_debtor_code'],
				/* 14 */ $debtor['fn_debtor_desc'],
				/* 15 */ $tran['fn_invoice_ix'],
				/* 16 */ $bankCode,
				/* 17 */ $depositCode,
				/* 18 */ $billingCurrencyCode,
				/* 19 */ $item['fn_tran_item_amt_incl'],
				/* 20 */ $tran['invoice_currency_symbol'],
				/* 21 */ $item['fn_tran_item_amt_source_incl'],
			];
		}
	}

	return $csvFile;
}

function tran_netsuite_invoice($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	$batchYear = "";
	$billingUnitCode = "";
	$billingCurrencyCode = "";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
		$batchInfo = $lDB->get("
			SELECT
				pr_business.pr_bus_name_short,	
				fn_year.fn_year_desc,
				rf_currency.rf_currency_symbol
			FROM
				fn_batch
				INNER JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_batch.pr_business_id
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = pr_bus_home_curr_id
			WHERE
				fn_batch.fn_batch_ix = '" . $lDB->escape($fn_batch_id) . "'
		",1);
		$batchYear = $batchInfo['fn_year_desc'];
		$billingUnitCode = $batchInfo['pr_bus_name_short'];
		$billingCurrencyCode = $batchInfo['rf_currency_symbol'];
	}

	$csvFiles = [
		'header'=>[],
		'revenue'=>[],
		'statistics'=>[]
	];
	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.rv_reservation_id,
			rv_reservation.rv_res_name,
			rf_currency.rf_currency_symbol,
			fn_tran.fn_tran_exch_rate,
			contra_invoice.fn_invoice_id AS contra_invoice_id
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_tran.rf_currency_id
			INNER JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
			LEFT JOIN fn_invoice AS contra_invoice ON contra_invoice.fn_invoice_ix = fn_invoice.fn_inv_reverse_link_id
		WHERE
			$batchWhere
			AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
	",6);
	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_debtor.fn_debtor_code,
				fn_debtor.fn_debtor_desc,
				fn_tran_item.fn_tran_item_amt_incl
			FROM
				fn_tran_item
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			WHERE
				fn_tran_item.fn_tran_id = '" . $lDB->escape($tran['fn_tran_ix']). "'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		if($debtor['fn_tran_item_amt_incl'] < 0) {
			$typeCode = "CN";
		} else {
			$typeCode = "IN";
		}
		$csvFiles['header'][] = [
			/*  1 */ $billingUnitCode,
			/*  2 */ $typeCode,
			/*  3 */ "1",
			/*  4 */ "1",
			/*  5 */ $tran['fn_tran_ix'],
			/*  6 */ $fn_batch_id,
			/*  7 */ $batchYear,
			/*  8 */ date("Ym",strtotime($tran['fn_tran_date_ledger'])),
			/*  9 */ date("Ymd",strtotime($tran['fn_tran_date_ledger'])),
			/* 10 */ $tran['fn_tran_link_id'],
			/* 11 */ $tran['rv_reservation_id'],
			/* 12 */ $tran['rv_res_name'],
			/* 13 */ $debtor['fn_debtor_code'],
			/* 14 */ $debtor['fn_debtor_desc'],
			/* 15 */ $billingCurrencyCode,
			/* 16 */ $tran['rf_currency_symbol'],
			/* 17 */ $tran['fn_tran_exch_rate']
		];
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt_incl,
				fn_tran_item.fn_tran_item_amt_source_incl,
				fn_ledger.fn_ledger_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1,
				rt_component_inv.rt_component_inv_meal_code,
				tax_ledger.fn_ledger_code AS tax_ledger_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN rt_component_inv ON rt_component_inv.rt_component_inv_ix = fn_tran_item.rt_component_inv_id
				LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_inv_ix = fn_tran_item.rf_tax_inv_id
				LEFT JOIN fn_ledger AS tax_ledger ON tax_ledger.fn_ledger_ix = rf_tax_inv.fn_ledger_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind NOT IN ('".DB_FN_TRAN_ITEM_TYPE_DEBTOR."', '".DB_FN_TRAN_ITEM_TYPE_TAX."')
		",6);
		$count = 1;
		foreach($items as $item) {
			$csvFiles['revenue'][] = [
				/*  1 */ $billingUnitCode,
				/*  2 */ $typeCode,
				/*  3 */ "2",
				/*  4 */ $count,
				/*  5 */ $tran['fn_tran_ix'],
				/*  6 */ $item['fn_ledger_code'],
				/*  7 */ $item['fn_cost_centre_code_1'],
				/*  8 */ $item['rt_component_inv_meal_code'],
				/*  9 */ $item['fn_tran_item_amt_incl'],
				/* 10 */ $item['fn_tran_item_amt_source_incl'],
				/* 11 */ $item['tax_ledger_code'],
				/* 12 */ $tran['contra_invoice_id']
			];
			$count++;
		}

		$stats = $lDB->get("
			SELECT
				fn_tran_stat.fn_tran_stat_nights,
				fn_tran_stat.fn_tran_stat_pax,
				fn_tran_stat.fn_tran_stat_bed_nights,
				fn_tran_stat.fn_tran_stat_room_nights,
				fn_cost_centre.fn_cost_centre_code,
				rt_component_inv.rt_component_inv_meal_code
			FROM
				fn_tran_stat
				LEFT JOIN fn_cost_centre ON fn_cost_centre.fn_cost_centre_ix = fn_tran_stat.fn_cost_centre_id
				LEFT JOIN rt_component_inv ON rt_component_inv.rt_component_inv_ix = fn_tran_stat.rt_component_inv_id
			WHERE
				fn_tran_stat.fn_tran_id = '" . $lDB->escape($tran['fn_tran_ix']) . "'
		",6);
		$count = 1;
		foreach($stats as $stat) {
			$csvFiles['statistics'][] = [
				/*  1 */ $billingUnitCode,
				/*  2 */ $typeCode,
				/*  3 */ "3",
				/*  4 */ $count,
				/*  5 */ $tran['fn_tran_ix'],
				/*  6 */ $stat['fn_cost_centre_code'],
				/*  7 */ $stat['rt_component_inv_meal_code'],
				/*  8 */ $stat['fn_tran_stat_nights'],
				/*  9 */ $stat['fn_tran_stat_room_nights'],
				/* 10 */ $stat['fn_tran_stat_pax'],
				/* 11 */ $stat['fn_tran_stat_bed_nights']
			];
			$count++;
		}
	}

	return $csvFiles;
}
