<?php

define("TRAN_PASTEL_JOURNAL_STANDARD",1);
define("TRAN_PASTEL_JOURNAL_SOURCE",2);

function tran_pastel_export($list,$fn_batch_id) {
	global $lDB;
	$exportDate = date("Y-m-d");
	$csvFile = array();

	if(sizeof($list) > 0) {
		$pr_business_id = $list[0]['pr_business_id'];
		array_push($csvFile,array("ledger_post",$list[0]['pr_bus_name_short'],date("YmdHis"),$fn_batch_id));

		// Get Ids
		$glIds = array();
		$costIds = array();
		$debtors = array();
		foreach($list as $item) {
			array_push($glIds,$item['fn_ledger_id']);
			array_push($costIds,$item['fn_tran_cost_ctr1_id']);
			array_push($debtors,$item['fn_debtor_ix']);
		}

		// Output GL / Ledger codes
		$glIds = array_unique($glIds);
		$glCodes = $lDB->get("
			SELECT
				fn_ledger_code,
				fn_ledger_desc
			FROM
				fn_ledger
			WHERE
				fn_ledger_ix IN ('".join("','",$glIds)."')
			ORDER BY
				fn_ledger_code
		",2);
		foreach($glCodes as $glCode) {
			array_push($csvFile,array(
				"gl",
				$glCode['fn_ledger_code'],
				$glCode['fn_ledger_desc']
			));
		}

		// Output Cost centre codes
		$costIds = array_unique($costIds);
		$costCodes = $lDB->get("
			SELECT
				fn_cost_centre_code,
				fn_cost_centre_desc
			FROM
				fn_cost_centre
			WHERE
				fn_cost_centre_ix IN ('".join("','",$costIds)."')
			ORDER BY
				fn_cost_centre_code
		",2);
		foreach($costCodes as $costCode) {
			array_push($csvFile,array(
				"cost",
				$costCode['fn_cost_centre_code'],
				$costCode['fn_cost_centre_desc']
			));
		}

		// Output Debtor/Contact info
		$debtors = array_unique($debtors);
		$contacts = $lDB->get("
			SELECT
				fn_debtor.fn_debtor_code,
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_first,
				pr_persona.pr_name_last,
				pr_persona.pr_corr_addr_line1,
				pr_persona.pr_corr_addr_line2,
				pr_persona.pr_corr_addr_line3,
				pr_persona.pr_corr_city,
				rf_corr_country.rf_country_name AS rf_corr_country_name,
				pr_persona.pr_corr_post_code,
				pr_persona.pr_phys_addr_line1,
				pr_persona.pr_phys_addr_line2,
				pr_persona.pr_phys_addr_line3,
				pr_persona.pr_phys_city,
				rf_phys_country.rf_country_name AS rf_phys_country_name,
				pr_persona.pr_phys_post_code,
				pr_persona.pr_email
			FROM
				fn_debtor
				INNER JOIN pr_persona_inv ON pr_persona_inv.fn_debtor_id = fn_debtor.fn_debtor_ix
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_persona_inv.pr_persona_id
				LEFT JOIN rf_country AS rf_corr_country ON rf_corr_country.rf_country_ix = pr_persona.pr_corr_country_id
				LEFT JOIN rf_country AS rf_phys_country ON rf_phys_country.rf_country_ix = pr_persona.pr_phys_country_id
			WHERE
				fn_debtor.fn_debtor_ix IN ('".join("','",$debtors)."')
				AND pr_persona_inv.pr_business_id = '$pr_business_id'
			ORDER BY
				fn_debtor.fn_debtor_code
		",2);
		foreach($contacts as $contact) {
			$contact['pr_telephone'] = $lDB->get("
				SELECT
					pr_phone.pr_phone_number
				FROM
					pr_phone
				WHERE
					pr_phone.pr_persona_id = '$contact[pr_persona_ix]'
					AND pr_phone.pr_default_yn = '1'
			",4);
			$contact['pr_fax'] = $lDB->get("
				SELECT
					pr_phone.pr_phone_number
				FROM
					pr_phone
					INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
				WHERE
					pr_phone.pr_persona_id = '$contact[pr_persona_ix]'
					AND rf_phone_type.rf_phone_type_sys_code = '1'
			",4);
			array_push($csvFile,array(
				/*  1 */ "debtor",
				/*  2 */ $contact['fn_debtor_code'],
				/*  3 */ trim($contact['pr_name_first'] . " " . $contact['pr_name_last']),
				/*  4 */ $contact['pr_corr_addr_line1'],
				/*  5 */ $contact['pr_corr_addr_line2'],
				/*  6 */ $contact['pr_corr_addr_line3'],
				/*  7 */ $contact['pr_corr_city'],
				/*  8 */ trim($contact['rf_corr_country_name1'] . " " . $contact['pr_corr_post_code']),
				/*  9 */ $contact['pr_phys_addr_line1'],
				/* 10 */ $contact['pr_phys_addr_line2'],
				/* 11 */ $contact['pr_phys_addr_line3'],
				/* 12 */ $contact['pr_phys_city'],
				/* 13 */ trim($contact['rf_phys_country_name1'] . " " . $contact['pr_phys_post_code']),
				/* 14 */ $contact['pr_telephone'],
				/* 15 */ $contact['pr_fax'],
				/* 16 */ $contact['pr_email']
			));

		}
		foreach($list as $item) {
			if($item['fn_tran_item_type_ind'] == DB_FN_TRAN_ITEM_TYPE_ACCOMM || $item['fn_tran_item_type_ind'] == DB_FN_TRAN_ITEM_TYPE_EXTRA || $item['fn_tran_item_type_ind'] == DB_FN_TRAN_ITEM_TYPE_TAX) {
				$type = "Invoice";
				$docId = $item['fn_tran_link_id'];
			} else {
				$type = "Other";
				$docId = "";
			}
			array_push($csvFile,array(
				"tran",
				$item['fn_tran_item_amt'],
				$item['fn_ledger_code'],
				$item['fn_debtor_code'],
				$item['cost_centre_1_code'],
				/*$item['cost_centre_2_code'],*/
				$type,
				$docId,
				$item['fn_tran_date_ledger'],
				$item['fn_tran_detail']
			));
		}
	}
	return $csvFile;
}

function tran_pastel_journal($fn_batch_id,$version=false, $debtorJournal=false, $pr_business_id="0") {
	global $lDB;

	if ($debtorJournal) {
		$billingCurrency = $lDB->get("
			SELECT pr_bus_home_curr_id
			FROM pr_business
			WHERE pr_business_id = '$pr_business_id'
		", 4);
	}

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$fn_year_end_date = $lDB->get("
		SELECT
			fn_year.fn_year_end_date
		FROM
			fn_batch
			INNER JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
		WHERE
			$batchWhere
	",4);
	$dateArray = explode("-",$fn_year_end_date);
	$periodArray = array();
	$currentMonth = (integer)$dateArray[1];
	for($count=12;$count>0;$count--) {
		$periodArray[$currentMonth] = $count;
		$currentMonth--;
		if($currentMonth < 1) { $currentMonth = 12; }
	}

	$invoicesOnlySql = "";
	$suppressTaxSql = "";

	if ($debtorJournal) {
		$invoicesOnlySql = "
			AND fn_tran.fn_tran_link_ind = " . DB_FN_TRAN_LINK_INVOICE . "
		";

		$suppressDebtorAndTaxSql = "
			AND fn_tran_item.fn_tran_item_type_ind <> " . DB_FN_TRAN_ITEM_TYPE_TAX . "
			AND fn_tran_item.fn_tran_item_type_ind <> " . DB_FN_TRAN_ITEM_TYPE_DEBTOR . "
		";
	}

	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_date_ledger,
			fn_tran_item.fn_tran_item_type_ind,
			fn_tran_item.fn_tran_item_amt,
			fn_tran_item.fn_tran_item_amt_incl,
			fn_tran_item.fn_tran_item_amt_source,
			fn_tran_item.fn_tran_item_amt_source_incl,
			fn_ledger.fn_ledger_code,
			fn_debtor.fn_debtor_code,
			cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
			cost_ctr2.fn_cost_centre_code AS cost_centre_2_code,
			fn_tran.fn_tran_detail,
			fn_tran.pr_business_id,
			fn_tran.rv_reservation_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_exch_rate,
			tran_debtor.fn_debtor_code AS tran_debtor_code,
			fn_debtor.rf_currency_id AS debtor_currency_id,
			rv_payment_item.rv_payment_id,
			tax_ledger.fn_ledger_code AS tax_code,
			fn_tran_item.rf_currency_id
		FROM
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
			LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			LEFT JOIN fn_cost_centre AS cost_ctr1 ON cost_ctr1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			LEFT JOIN fn_cost_centre AS cost_ctr2 ON cost_ctr2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
			LEFT JOIN fn_tran_item AS debtor_item ON debtor_item.fn_tran_id = fn_tran_item.fn_tran_id AND debtor_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
			LEFT JOIN fn_debtor AS tran_debtor ON debtor_item.fn_debtor_id = tran_debtor.fn_debtor_ix
			LEFT JOIN rv_payment_item ON fn_tran.fn_tran_link_ind != '".DB_FN_TRAN_LINK_INVOICE."'
				AND rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
			LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_inv_ix = fn_tran_item.rf_tax_inv_id
			LEFT JOIN fn_ledger AS tax_ledger ON tax_ledger.fn_ledger_ix = rf_tax_inv.fn_ledger_id
		WHERE
			$batchWhere
			$invoicesOnlySql
			$suppressDebtorAndTaxSql
		ORDER BY
			fn_tran.fn_tran_ix,
			fn_tran_item.fn_tran_item_type_ind DESC
	",2);

	$csvFile = array();
	$rowCount = 0;

	$exchangeType = false;
	if(sizeof($list) > 0) {
		$exchangeType = db_fn_option_data_by_name($list[0]['pr_business_id'], "exchange_rate_format");
	}
	if($exchangeType === false || ($exchangeType < 1 && $exchangeType > 2)) {
		$exchangeType = 1;
	}


	$journalFormat = db_fn_option_data_by_name($list[0]['pr_business_id'], "journal_format");
	$referenceFormat = db_fn_option_data_by_name($list[0]['pr_business_id'], "reference_format");
	$debtorRecalc = strtolower(trim(db_fn_option_data_by_name($list[0]['pr_business_id'], "debtor_recalculate")));
	if($debtorRecalc == "1" || $debtorRecalc == "yes" || $debtorRecalc == "true") {
		$debtorRecalc = true;
		$debtorTotal = 0;
		$debtorLargestAmount = 0;
		$debtorLargestRow = 0;
	} else {
		$debtorRecalc = false;
	}

	if(sizeof($list) > 0) {
		$billingUnitId = $list[0]['pr_business_id'];
		$billingCurrency = $GLOBALS['lDB']->get("SELECT pr_bus_home_curr_id FROM pr_business WHERE pr_business_id = '$billingUnitId'",4);
	}
	foreach($list as $item) {
		list($date,$time) = explode(" ",$item['fn_tran_date_ledger']);
		$dateArray = explode("-",$date);
		$pastelDate = $dateArray[2] . "/" . $dateArray[1] . "/" . $dateArray[0];
		$period = $periodArray[(integer)$dateArray[1]];

		$item['fn_tran_item_amt'] = round($item['fn_tran_item_amt'],2);
		fixAmtDisplay($item['fn_tran_item_amt'],2);

		$exchange = "1.000000";
		if($item['fn_tran_item_type_ind'] == DB_FN_TRAN_ITEM_TYPE_DEBTOR) {
			$gdc = "D";
			$accountNumber = $item['fn_debtor_code'];
			$costCode = "";

			$debtorAmountDone = false;
			if($version == 11) {
				if(empty($item['debtor_currency_id'])) {
					$item['debtor_currency_id'] = $billingCurrency;
				}
				if($item['debtor_currency_id'] != $billingCurrency) {
					$item['fn_tran_item_amt'] = $item['fn_tran_item_amt_source'];
					$debtorAmountDone = true;

					if($exchangeType == 1) {
						$exchange = db_round(1/$item['fn_tran_exch_rate'],6);
						$debtorAmount = $item['fn_tran_item_amt'] / $exchange;
					} else {
						$exchange = db_round($item['fn_tran_exch_rate'],6);
						$debtorAmount = $item['fn_tran_item_amt'] * $exchange;
					}

					if($debtorRecalc) {
						$debtorDiff = db_round(round($debtorAmount,2) - round($debtorTotal * -1,2),2);
						if($debtorDiff != 0) {
							$csvFile[$debtorLargestRow][6]['data'] -= $debtorDiff;
						}
					}
				}
			}

			if($debtorRecalc) {
				if(!$debtorAmountDone) {
					$item['fn_tran_item_amt'] = round($debtorTotal * -1,2);
					fixAmtDisplay($item['fn_tran_item_amt'],2);
				}
				$debtorTotal = 0;
				$debtorLargestAmount = 0;
				$debtorLargestRow = 0;
			}
		} else {
			$gdc = "G";

			$tran_code_return = getTranCode($list[0]['pr_business_id'], $item);
			$accountNumber = $tran_code_return[0];
			$costCode = $tran_code_return[1];

			if($debtorRecalc) {
				$debtorTotal += $item['fn_tran_item_amt'];
				if(abs($item['fn_tran_item_amt']) > $debtorLargestAmount) {
					$debtorLargestAmount = abs($item['fn_tran_item_amt']);
					$debtorLargestRow = $rowCount;
				}
			}
			//$accountNumber = $item['fn_ledger_code'];
		}

		switch($referenceFormat) {
		case TRAN_REFERENCE_TYPE:
			$reference = db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']);
			break;
		case TRAN_REFERENCE_RESERVATION:
			$reference = $item['rv_reservation_id'];
			break;
		case TRAN_REFERENCE_LINK:
			$reference = $item['fn_tran_link_id'];
			break;
		case TRAN_REFERENCE_DEBTOR:
			$reference = $item['tran_debtor_code'];
			break;
		case TRAN_REFERENCE_DOCUMENT:
		default:
			if($item['fn_tran_link_ind'] != DB_FN_TRAN_LINK_INVOICE) {
				$reference = $item['rv_payment_id'];
			} else {
				$reference = $item['fn_tran_link_id'];
			}
			break;
		}
		$reference = str_pad(substr($reference,-8),8);

		$transactionAmount = array('type' => 'number', 'data' => $item['fn_tran_item_amt']);
		$taxType = array('type'=>'number','data'=>0);
		$taxAmount = array('type' => 'number','data' => 0);
		$contraAccount = "0000000";
		$homeAmount = array(
			'type' => 'number',
			'data' => ($version < 11 ?	$item['fn_tran_item_amt'] : 0)
		);

		if ($debtorJournal) {
			$gdc = 'D';

			$contraAccount = $accountNumber;
			$accountNumber = $item['tran_debtor_code'];
			
			// Determine tax on revenue items
			$taxType = $item['tax_code'];

			if ($item['rf_currency_id'] == $billingCurrency) {
				$tax = abs($item['fn_tran_item_amt_incl'] - $item['fn_tran_item_amt']);
			} else {
				$tax = abs($item['fn_tran_item_amt_source_incl'] - $item['fn_tran_item_amt_source']);
			}

			fixAmtDisplay($tax, 2);

			if ($tax == 0) {
				$tax = '';
			}

			$taxAmount = array('type' => 'number','data' => $tax);
			$transactionSourceAmountIncl = -1 * $item['fn_tran_item_amt_source_incl'];

			fixAmtDisplay($transactionSourceAmountIncl, 2);
			$transactionAmount = array('type' => 'number', 'data' =>  $transactionSourceAmountIncl);
			$homeAmount = array(
				'type' => 'number',
				'data' => abs($item['fn_tran_item_amt_incl'])
			);
		}

		$row = array(
			/*  1 */ array('type'=>'number','data'=>$period),
			/*  2 */ $pastelDate,
			/*  3 */ $gdc,
			/*  4 */ $accountNumber,
			/*  5 */ $reference,
			/*  6 */ str_pad(substr($item['fn_tran_detail'],0,36),36),
			/*  7 */ $transactionAmount,
			/*  8 */ $taxType,
			/*  9 */ $taxAmount,
			/* 10 */ "",
			/* 11 */ $costCode,
			/* 12 */ $contraAccount,
			/* 13 */ array('type'=>'number','data'=>$exchange),
			/* 14 */ array('type'=>'number','data'=>1),
			/* 15 */ array('type'=>'number','data'=>0),
			/* 16 */ array('type'=>'number','data'=>0),
			/* 17 */ array('type'=>'number','data'=>0),
			/* 18 */ $homeAmount
		);

		if($journalFormat == TRAN_PASTEL_JOURNAL_SOURCE) {
			$item['fn_tran_item_amt_source'] = round($item['fn_tran_item_amt_source'],2);
			fixAmtDisplay($item['fn_tran_item_amt_source'],2);
			array_push($row,array('type'=>'number','data'=>$item['fn_tran_item_amt_source']));
		}

		$csvFile[$rowCount] = $row;
		$rowCount++;
		//array_push($csvFile,$row);
	}
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		db_ad_batch_insert($fn_batch_id, DB_AD_BATCH_EXPORT);
	}

	return $csvFile;
}

function tran_pastel_journal_summary($fn_batch_id,$version=false) {
	global $lDB;

	$list = tran_pastel_journal($fn_batch_id,$version);

	$dateType = false; // 1=latest, 2=earliest
	if(sizeof($list) > 0) {
		$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_batch WHERE fn_batch_ix = '$fn_batch_id'",4);
		$dateType = db_fn_option_data_by_name($pr_business_id, "summary_date");
	}
	if($dateType === false || ($dateType < 1 && $dateType > 2)) {
		$dateType = "1";
	}

	if($dateType == "1") {
		$summaryPeriod = false;
		$summaryDate = "0000-00-00";
	} else {
		$summaryPeriod = false;
		$summaryDate = "9999-99-99";
	}

	$summary = array();
	$count = array();
	foreach($list as $item) {
		$period = $item[0]['data'];
		$dateArray = explode("/",$item[1]);
		$date = $dateArray[2] . "-" . $dateArray[1] . "-" .$dateArray[0];
		if($dateType == "1") {
			if($date > $summaryDate) {
				$summaryPeriod = $period;
				$summaryDate = $date;
			}
		} else {
			if($date < $summaryDate) {
				$summaryPeriod = $period;
				$summaryDate = $date;
			}
		}

		$gdc = $item[2];
		$accountNumber = $item[3];
		$amount = $item[6]['data'];
		$costCode = $item[10];
		$exchange = $item[12]['data'];
		$key = $gdc. "_" . $accountNumber . "_" . $costCode . "_" . $exchange;

		if(!array_key_exists($key,$summary)) {
			$summary[$key] = 0;
			$count[$key] = 0;
		}
		$summary[$key] += $amount;
		$count[$key]++;
	}

	$summaryDateArray = explode("-",$summaryDate);
	$summaryDate = $summaryDateArray[2] . "/" . $summaryDateArray[1] . "/" . $summaryDateArray[0];

	$reference = $lDB->get("SELECT CONCAT(fn_batch_db,fn_batch_id) FROM fn_batch WHERE fn_batch_ix = '$fn_batch_id'",4);
	$reference = str_pad(substr($reference,0,8),8);


	$csvFile = array();
	foreach($summary as $key=>$amount) {
		$detail = "Consolidated:$fn_batch_id,".$count[$key];
		$detail = str_pad(substr($detail,0,36),36);

		list($gdc,$accountNumber,$costCode,$exchange) = explode("_",$key);
		array_push($csvFile,array(
			/*  1 */ array('type'=>'number','data'=>$summaryPeriod),
			/*  2 */ $summaryDate,
			/*  3 */ $gdc,
			/*  4 */ $accountNumber,
			/*  5 */ $reference,
			/*  6 */ $detail,
			/*  7 */ array('type'=>'number','data'=>$amount),
			/*  8 */ array('type'=>'number','data'=>0),
			/*  9 */ array('type'=>'number','data'=>0),
			/* 10 */ "",
			/* 11 */ $costCode,
			/* 12 */ "0000000",
			/* 13 */ array('type'=>'number','data'=>$exchange),
			/* 14 */ array('type'=>'number','data'=>1),
			/* 15 */ array('type'=>'number','data'=>0),
			/* 16 */ array('type'=>'number','data'=>0),
			/* 17 */ array('type'=>'number','data'=>0),
			/* 18 */ array('type'=>'number','data'=>0)
		));
	}

	return $csvFile;
}

function tran_pastel_partner_debtor($fn_batch_id,$pr_business_id,$rf_currency_id=false,$export_ind=TRAN_DEBTOR_EXPORT_ALL,$export_set=false,$version=false) {
	global $lDB;

	$batchWhere = "";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			AND fn_tran.fn_batch_id = '$fn_batch_id'
		";
	}

	if(!empty($rf_currency_id)) {
		$batchWhere .= "
			AND fn_debtor.rf_currency_id = '$rf_currency_id'
		";
	}
	switch($export_ind) {
	case TRAN_DEBTOR_EXPORT_NEW:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '0'
		";
		break;
	case TRAN_DEBTOR_EXPORT_OLD:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '1'
		";
		break;
	}

	$list = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			fn_debtor.fn_debtor_ix,
			fn_debtor.fn_debtor_code,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_addr_line3,
			pr_persona.pr_corr_post_code,
			pr_persona.pr_corr_city,
			pr_corr_country.rf_country_name AS pr_corr_country_name,
			pr_persona.pr_phys_addr_line1,
			pr_persona.pr_phys_addr_line2,
			pr_persona.pr_phys_addr_line3,
			pr_persona.pr_phys_post_code,
			pr_persona.pr_phys_city,
			pr_phys_country.rf_country_name AS pr_phys_country_name,
			/*pr_consultant.pr_name_first AS pr_consultant_name_first,
			pr_consultant.pr_name_last AS pr_consultant_name_last,*/
			pr_persona.pr_statutory_1,
			pr_persona.pr_statutory_2,
			pr_persona.pr_statutory_3,
			pr_persona.pr_email,
			rf_currency_inv.rf_currency_inv_code
		FROM
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
			INNER JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_debtor.rf_currency_id
			LEFT JOIN rf_currency_inv ON
				rf_currency_inv.rf_currency_id = rf_currency.rf_currency_ix
				AND rf_currency_inv.pr_business_id = fn_tran.pr_business_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_debtor.pr_persona_id
			/*LEFT JOIN pr_persona AS pr_consultant ON pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id*/
			LEFT JOIN rf_country AS pr_corr_country ON pr_corr_country.rf_country_ix = pr_persona.pr_corr_country_id
			LEFT JOIN rf_country AS pr_phys_country ON pr_phys_country.rf_country_ix = pr_persona.pr_phys_country_id
		WHERE
			fn_tran.pr_business_id = '$pr_business_id'
			$batchWhere
	",2);

	$billingCurrency = $lDB->get("SELECT pr_bus_home_curr_id FROM pr_business WHERE pr_business_id = '$pr_business_id'",4);

	$debtors = array();
	$csvFile = array();
	foreach($list as $item) {
		$debtors[] = $item['fn_debtor_ix'];
		$telephone = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code != '1'
			ORDER BY
				pr_default_yn DESC
		",4);
		$fax = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code = '1'
			ORDER BY
				pr_default_yn DESC
		",4);

		if($version < 11 || empty($item['rf_currency_inv_code'])) {
			$item['rf_currency_inv_code'] = "0";
		}

		$line = array(
			/*  1 */ $item['fn_debtor_code'],
			/*  2 */ trim($item['pr_name_first'] . " " . $item['pr_name_last']),
			/*  3 */ $item['pr_corr_addr_line1'],
			/*  4 */ $item['pr_corr_addr_line2'],
			/*  5 */ $item['pr_corr_addr_line3'],
			/*  6 */ trim($item['pr_corr_post_code'] . " " . $item['pr_corr_city']),
			/*  7 */ $item['pr_corr_country_name'],
			/*  8 */ $telephone,
			/*  9 */ $fax,
			/* 10 */ "", // TODO: Contact person
			/* 11 */ "0", // No tax type default
			/* 12 */ "0", // Settlement terms
			/* 13 */ "", // Price list
			/* 14 */ "", // Sales analysis code
			/* 15 */ $item['pr_phys_addr_line1'],
			/* 16 */ $item['pr_phys_addr_line2'],
			/* 17 */ $item['pr_phys_addr_line3'],
			/* 18 */ trim($item['pr_phys_post_code'] . " " . $item['pr_phys_city']),
			/* 19 */ $item['pr_phys_country_name'],
			/* 20 */ "N", // Not blocked
			/* 21 */ "0",
			/* 22 */ "N", // Exclusive
			/* 23 */ "1", // Print oldest terms message
			/* 24 */ "Y", // Open item
			/* 25 */ "0", // Customer category
			/* 26 */ $item['rf_currency_inv_code'],
			/* 27 */ "00", // Payment terms
			/* 28 */ "0", // Credit limit
			/* 29 */ "", // User defined 1
			/* 30 */ "", // User defined 2
			/* 31 */ "", // User defined 3
			/* 32 */ "", // User defined 4
			/* 33 */ "", // User defined 5
			/* 34 */ $item['pr_statutory_1'],
			/* 35 */ "N", // Month based terms
			/* 36 */ "", // Mobile phone
			/* 37 */ $item['pr_email'],
			/* 38 */ "1", // Statement print
			/* 39 */ "1", // Document print
			/* 40 */ "", // Country code
			/* 41 */ "", // Freight
			/* 42 */ "", // Ship / deliver
			/* 43 */ "0", // Tax code
			/* 44 */ "N", // Not cash sales accont
			/* 45 */ $item['pr_statutory_2'],
			/* 46 */ $item['pr_statutory_3']
		);
		if($version == 11) {
			array_push($line,/* 45 */ "N"); // Accept email
		}
		array_push($csvFile,$line);
	}

	if($export_set) {
		foreach($debtors as $fn_debtor_id) {
			db_fn_debtor_set_export($fn_debtor_id);
		}
	}

	return $csvFile;
}

function tran_pastel_evolution_journal($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_detail,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_link_id,
			fn_tran.rv_reservation_id,
			fn_tran.pr_business_id,
			fn_tran.fn_tran_amt_excl,
			fn_tran.fn_tran_amt_incl,
			fn_tran.fn_tran_amt_source,
			fn_tran.fn_tran_exch_rate,
			fn_tran.fn_folio_id,
			rv_payment_item.rv_payment_id
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			LEFT JOIN rv_payment_item ON fn_tran.fn_tran_link_ind != '".DB_FN_TRAN_LINK_INVOICE."'
				AND rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
		WHERE
			$batchWhere
	",2);

	$csvFile = array(array(
		/*  1 */ "Trans Date",
		/*  2 */ "Account",
		/*  3 */ "Trans Code",
		/*  4 */ "Reference",
		/*  5 */ "Description",
		/*  6 */ "Order Number",
		/*  7 */ "Folio",
		/*  8 */ "Amount Excl",
		/*  9 */ "Amount Incl",
		/* 10 */ "Exchange Rate",
		/* 11 */ "Foreign Amount Excl",
		/* 12 */ "Foreign Amount Incl",
		/* 13 */ "Split Group",
		/* 14 */ "Split Tax Type",
		/* 15 */ "Split GL Account",
		/* 16 */ "Split Description",
		/* 17 */ "Split Amount Excl",
		/* 18 */ "Foreign Split Amount Incl",
		/* 19 */ "Split Amount Incl",
		/* 20 */ "Foreign Split Amount Excl"
	));

	$split = 1;
	$referenceFormat = db_fn_option_data_by_name($list[0]['pr_business_id'], "reference_format");
	foreach($list as $tran) {
		list($date,$time) = explode(" ",$tran['fn_tran_date_ledger']);
		$dateArray = explode("-",$date);
		$pastelDate = $dateArray[2] . "/" . $dateArray[1] . "/" . $dateArray[0];

		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_type_ind,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_incl,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
				cost_ctr2.fn_cost_centre_code AS cost_centre_2_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS cost_ctr1 ON cost_ctr1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN fn_cost_centre AS cost_ctr2 ON cost_ctr2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		switch($tran['fn_tran_link_ind']) {
		case DB_FN_TRAN_LINK_INVOICE:
			if($debtor['fn_tran_item_amt'] < 0) {
				$type = "CN";
			} else {
				$type = "IN";
			}
			break;
		case DB_FN_TRAN_LINK_PAYMENT:
			if($debtor['fn_tran_item_amt'] > 0) {
				$type = "RF";
			} else {
				$type = "PM";
			}
			break;
		case DB_FN_TRAN_LINK_DEPOSIT:
			$type = "DP";
			break;
		case DB_FN_TRAN_LINK_REVERSAL:
			$type = "DR";
			break;
		default:
			$type = "UK";
			break;
		}


		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_type_ind,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_incl,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
				cost_ctr2.fn_cost_centre_code AS cost_centre_2_code,
				tax_ledger.fn_ledger_code AS tax_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS cost_ctr1 ON cost_ctr1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN fn_cost_centre AS cost_ctr2 ON cost_ctr2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
				LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_inv_ix = fn_tran_item.rf_tax_inv_id
				LEFT JOIN fn_ledger AS tax_ledger ON tax_ledger.fn_ledger_ix = rf_tax_inv.fn_ledger_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_TAX."'
		",2);

		// Heading to avoid the first line not being imported
		foreach($items as $item) {
			switch($referenceFormat) {
			case TRAN_REFERENCE_TYPE:
				$reference = db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']);
				break;
			case TRAN_REFERENCE_RESERVATION:
				$reference = $tran['rv_reservation_id'];
				break;
			case TRAN_REFERENCE_LINK:
				$reference = $tran['fn_tran_link_id'];
				break;
			case TRAN_REFERENCE_DEBTOR:
				$reference = $debtor['fn_debtor_code'];
				break;
			case TRAN_REFERENCE_DOCUMENT:
			default:
				if($tran['fn_tran_link_ind'] != DB_FN_TRAN_LINK_INVOICE) {
					$reference = $tran['rv_payment_id'];
				} else {
					$reference = $tran['fn_tran_link_id'];
				}
				break;
			}

			$fn_tran_detail = substr($tran['fn_tran_detail'],0,40);
			$fn_tran_detail_split = substr($tran['fn_tran_detail'] . " Split",0,40);

			$tran['fn_tran_amt_excl'] = abs($tran['fn_tran_amt_excl']);
			$tran['fn_tran_amt_incl'] = abs($tran['fn_tran_amt_incl']);

			$tran['fn_tran_amt_source'] = abs($tran['fn_tran_amt_source']);
			$sourceExcl = abs($tran['fn_tran_amt_excl'] / $tran['fn_tran_exch_rate']);

			$item['fn_tran_item_amt'] = abs($item['fn_tran_item_amt']);
			$item['fn_tran_item_amt_incl'] = abs($item['fn_tran_item_amt_incl']);

			$item['fn_tran_item_amt_source'] = abs($item['fn_tran_item_amt_source']);
			$sourceItemIncl = abs($item['fn_tran_item_amt_incl'] / $tran['fn_tran_exch_rate']);

			$tran['fn_tran_amt_excl'] = round($tran['fn_tran_amt_excl'],4);
			$tran['fn_tran_amt_incl'] = round($tran['fn_tran_amt_incl'],4);
			fixAmtDisplay($tran['fn_tran_amt_excl'],4);
			fixAmtDisplay($tran['fn_tran_amt_incl'],4);

			$tran['fn_tran_amt_source'] = round($tran['fn_tran_amt_source'],4);
			$sourceExcl = round($sourceExcl,4);
			fixAmtDisplay($tran['fn_tran_amt_source'],4);
			fixAmtDisplay($sourceExcl,4);

			$item['fn_tran_item_amt'] = round($item['fn_tran_item_amt'],4);
			$item['fn_tran_item_amt_incl'] = round($item['fn_tran_item_amt_incl'],4);
			fixAmtDisplay($item['fn_tran_item_amt'],4);
			fixAmtDisplay($item['fn_tran_item_amt_incl'],4);

			$item['fn_tran_item_amt_source'] = round($item['fn_tran_item_amt_source'],4);
			$sourceItemIncl = round($sourceItemIncl,4);
			fixAmtDisplay($item['fn_tran_item_amt_source'],4);
			fixAmtDisplay($sourceItemIncl,4);

			array_push($csvFile,array(
				/*  1 */ $pastelDate,
				/*  2 */ $debtor['fn_debtor_code'],
				/*  3 */ $type,
				/*  4 */ $reference,
				/*  5 */ $fn_tran_detail,
				/*  6 */ $tran['rv_reservation_id'],
				/*  7 */ $tran['fn_folio_id'],
				/*  8 */ $tran['fn_tran_amt_excl'],
				/*  9 */ $tran['fn_tran_amt_incl'],
				/* 10 */ $tran['fn_tran_exch_rate'],
				/* 11 */ $sourceExcl,
				/* 12 */ $tran['fn_tran_amt_source'],
				/* 13 */ $split,
				/* 14 */ $item['tax_code'],
				/* 15 */ $item['fn_ledger_code'],
				/* 16 */ $fn_tran_detail_split,
				/* 17 */ $item['fn_tran_item_amt'],
				/* 18 */ $sourceItemIncl,
				/* 19 */ $item['fn_tran_item_amt_incl'],
				/* 20 */ $item['fn_tran_item_amt_source']
			));
		}
		$split++;
	}

	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		db_ad_batch_insert($fn_batch_id, DB_AD_BATCH_EXPORT);
	}

	return $csvFile;
}

function tran_pastel_evolution_7_journal($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_detail,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_link_id,
			fn_tran.rv_reservation_id,
			fn_tran.pr_business_id,
			fn_tran.fn_tran_amt_excl,
			fn_tran.fn_tran_amt_incl,
			fn_tran.fn_tran_amt_source,
			fn_tran.fn_tran_exch_rate,
			fn_tran.fn_folio_id,
			rv_payment_item.rv_payment_id
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			LEFT JOIN rv_payment_item ON fn_tran.fn_tran_link_ind != '".DB_FN_TRAN_LINK_INVOICE."'
				AND rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
		WHERE
			$batchWhere
	",2);

	$csvFile = array(array(
		/*  1 */ "Trans Date",
		/*  2 */ "Account",
		/*  3 */ "Module",
		/*  4 */ "Trans Code",
		/*  5 */ "Post Dates",
		/*  6 */ "Reference",
		/*  7 */ "Description",
		/*  8 */ "Order Number",
		/*  9 */ "Amount Excl",
		/* 10 */ "Tax Type",
		/* 11 */ "Tax Account",
		/* 12 */ "Is Debit",
		/* 13 */ "Amount Incl",
		/* 14 */ "Exchange Rate",
		/* 15 */ "Foreign Amount Excl",
		/* 16 */ "Foreign Amount Incl",
		/* 17 */ "Discount Percent",
		/* 18 */ "Discount Amount Excl",
		/* 19 */ "Discount Tax Type",
		/* 20 */ "Discount Amount Incl",
		/* 21 */ "Foreign Discount Amount Excl",
		/* 22 */ "Foreign Discount Amount Incl",
		/* 23 */ "Project Code",
		/* 24 */ "Rep Code",
		/* 25 */ "Split Group",
		/* 26 */ "Split GL Account",
		/* 27 */ "Split Description",
		/* 28 */ "Split Amount",
		/* 29 */ "Foreign Split Amount",
		/* 30 */ "Split Project Code",
		/* 31 */ "GL Contra Code",
		/* 32 */ "Split Tax Type",
		/* 33 */ "Split Tax Account"
	));

	$split = 1;
	$referenceFormat = db_fn_option_data_by_name($list[0]['pr_business_id'], "reference_format");
	foreach($list as $tran) {
		list($date,$time) = explode(" ",$tran['fn_tran_date_ledger']);
		$dateArray = explode("-",$date);
		$pastelDate = $dateArray[2] . "/" . $dateArray[1] . "/" . $dateArray[0];

		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_type_ind,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_incl,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
				cost_ctr2.fn_cost_centre_code AS cost_centre_2_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS cost_ctr1 ON cost_ctr1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN fn_cost_centre AS cost_ctr2 ON cost_ctr2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		switch($tran['fn_tran_link_ind']) {
		case DB_FN_TRAN_LINK_INVOICE:
			if($debtor['fn_tran_item_amt'] < 0) {
				$type = "CN";
				$isDebit = 0;
			} else {
				$type = "IN";
				$isDebit = 1;
			}
			break;
		case DB_FN_TRAN_LINK_PAYMENT:
			if($debtor['fn_tran_item_amt'] > 0) {
				$type = "RF";
				$isDebit = 1;
			} else {
				$type = "PM";
				$isDebit = 0;
			}
			break;
		case DB_FN_TRAN_LINK_DEPOSIT:
			$type = "DP";
			$isDebit = 1;
			break;
		case DB_FN_TRAN_LINK_REVERSAL:
			$type = "DR";
			$isDebit = 0;
			break;
		default:
			$type = "UK";
			$isDebit = 0;
			break;
		}

		if($tran['fn_tran_exch_rate'] == 0) {
			$tran['fn_tran_exch_rate'] = 1;
		}

		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_type_ind,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_incl,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
				cost_ctr2.fn_cost_centre_code AS cost_centre_2_code,
				tax_ledger.fn_ledger_code AS tax_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS cost_ctr1 ON cost_ctr1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN fn_cost_centre AS cost_ctr2 ON cost_ctr2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
				LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_inv_ix = fn_tran_item.rf_tax_inv_id
				LEFT JOIN fn_ledger AS tax_ledger ON tax_ledger.fn_ledger_ix = rf_tax_inv.fn_ledger_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_TAX."'
		",2);

		// Heading to avoid the first line not being imported
		foreach($items as $item) {
			switch($referenceFormat) {
			case TRAN_REFERENCE_TYPE:
				$reference = db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']);
				break;
			case TRAN_REFERENCE_RESERVATION:
				$reference = $tran['rv_reservation_id'];
				break;
			case TRAN_REFERENCE_LINK:
				$reference = $tran['fn_tran_link_id'];
				break;
			case TRAN_REFERENCE_DEBTOR:
				$reference = $debtor['fn_debtor_code'];
				break;
			case TRAN_REFERENCE_DOCUMENT:
			default:
				if($tran['fn_tran_link_ind'] != DB_FN_TRAN_LINK_INVOICE) {
					$reference = $tran['rv_payment_id'];
				} else {
					$reference = $tran['fn_tran_link_id'];
				}
				break;
			}

			$tran_code_return = getTranCode($list[0]['pr_business_id'], $item);
			$accountNumber = $tran_code_return[0];
			$costCode = $tran_code_return[1];

			$fn_tran_detail = substr($tran['fn_tran_detail'],0,40);
			$fn_tran_detail_split = substr($tran['fn_tran_detail'] . " Split",0,40);

			$tran['fn_tran_amt_excl'] = abs($tran['fn_tran_amt_excl']);
			$tran['fn_tran_amt_incl'] = abs($tran['fn_tran_amt_incl']);

			$tran['fn_tran_amt_source'] = abs($tran['fn_tran_amt_source']);
			$sourceExcl = abs($tran['fn_tran_amt_excl'] / $tran['fn_tran_exch_rate']);

			$item['fn_tran_item_amt'] = abs($item['fn_tran_item_amt']);
			$item['fn_tran_item_amt_incl'] = abs($item['fn_tran_item_amt_incl']);

			$item['fn_tran_item_amt_source'] = abs($item['fn_tran_item_amt_source']);
			$sourceItemIncl = abs($item['fn_tran_item_amt_incl'] / $tran['fn_tran_exch_rate']);

			$tran['fn_tran_amt_excl'] = round($tran['fn_tran_amt_excl'],2);
			$tran['fn_tran_amt_incl'] = round($tran['fn_tran_amt_incl'],2);
			fixAmtDisplay($tran['fn_tran_amt_excl'],2);
			fixAmtDisplay($tran['fn_tran_amt_incl'],2);

			$tran['fn_tran_amt_source'] = round($tran['fn_tran_amt_source'],2);
			$sourceExcl = round($sourceExcl,2);
			fixAmtDisplay($tran['fn_tran_amt_source'],2);
			fixAmtDisplay($sourceExcl,2);

			$item['fn_tran_item_amt'] = round($item['fn_tran_item_amt'],2);
			$item['fn_tran_item_amt_incl'] = round($item['fn_tran_item_amt_incl'],2);
			fixAmtDisplay($item['fn_tran_item_amt'],2);
			fixAmtDisplay($item['fn_tran_item_amt_incl'],2);

			$item['fn_tran_item_amt_source'] = round($item['fn_tran_item_amt_source'],2);
			$sourceItemIncl = round($sourceItemIncl,2);
			fixAmtDisplay($item['fn_tran_item_amt_source'],2);
			fixAmtDisplay($sourceItemIncl,2);

			array_push($csvFile,array(
				/*  1 */ $pastelDate,
				/*  2 */ $debtor['fn_debtor_code'],
				/*  3 */ "AR",
				/*  4 */ $type,
				/*  5 */ "0.00",
				/*  6 */ $reference,
				/*  7 */ $fn_tran_detail,
				/*  8 */ $tran['rv_reservation_id'],
				/*  9 */ $tran['fn_tran_amt_excl'],
				/* 10 */ "",
				/* 11 */ "",
				/* 12 */ $isDebit,
				/* 13 */ $tran['fn_tran_amt_incl'],
				/* 14 */ $tran['fn_tran_exch_rate'],
				/* 15 */ $sourceExcl,
				/* 16 */ $tran['fn_tran_amt_source'],
				/* 17 */ "0.00",
				/* 18 */ "0.00",
				/* 19 */ "",
				/* 20 */ "0.00",
				/* 21 */ "0.00",
				/* 22 */ "0.00",
				/* 23 */ "",
				/* 24 */ "",
				/* 25 */ $split,
				/* 26 */ $accountNumber,
				/* 27 */ $fn_tran_detail,
				/* 28 */ $item['fn_tran_item_amt'],
				/* 29 */ $item['fn_tran_item_amt_source'],
				/* 30 */ $costCode,
				/* 31 */ "",
				/* 32 */ $item['tax_code'],
				/* 33 */ "", // Tax account
			));
		}
		$split++;
	}

	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		db_ad_batch_insert($fn_batch_id, DB_AD_BATCH_EXPORT);
	}

	return $csvFile;
}

function tran_pastel_evolution_debtor($fn_batch_id,$pr_business_id,$rf_currency_id=false,$export_ind=TRAN_DEBTOR_EXPORT_ALL,$export_set=false) {
	global $lDB;

	$batchWhere = "";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			AND fn_tran.fn_batch_id = '$fn_batch_id'
		";
	}

	if(!empty($rf_currency_id)) {
		$batchWhere .= "
			AND fn_debtor.rf_currency_id = '$rf_currency_id'
		";
	}
	switch($export_ind) {
	case TRAN_DEBTOR_EXPORT_NEW:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '0'
		";
		break;
	case TRAN_DEBTOR_EXPORT_OLD:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '1'
		";
		break;
	}

	$list = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			fn_debtor.fn_debtor_ix,
			fn_debtor.fn_debtor_code,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_addr_line3,
			pr_persona.pr_corr_post_code,
			pr_persona.pr_corr_city,
			pr_corr_country.rf_country_name AS pr_corr_country_name,
			pr_persona.pr_phys_addr_line1,
			pr_persona.pr_phys_addr_line2,
			pr_persona.pr_phys_addr_line3,
			pr_persona.pr_phys_post_code,
			pr_persona.pr_phys_city,
			pr_phys_country.rf_country_name AS pr_phys_country_name,
			/*pr_consultant.pr_name_first AS pr_consultant_name_first,
			pr_consultant.pr_name_last AS pr_consultant_name_last,*/
			pr_persona.pr_statutory_1,
			pr_persona.pr_statutory_2,
			pr_persona.pr_statutory_3,
			pr_persona.pr_email,
			rf_currency.rf_currency_ix,
			rf_currency.rf_currency_symbol
		FROM
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
			INNER JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_debtor.rf_currency_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_debtor.pr_persona_id
			/*LEFT JOIN pr_persona AS pr_consultant ON pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id*/
			LEFT JOIN rf_country AS pr_corr_country ON pr_corr_country.rf_country_ix = pr_persona.pr_corr_country_id
			LEFT JOIN rf_country AS pr_phys_country ON pr_phys_country.rf_country_ix = pr_persona.pr_phys_country_id
		WHERE
			fn_tran.pr_business_id = '$pr_business_id'
			$batchWhere
	",2);

	$billingCurrency = $lDB->get("SELECT pr_bus_home_curr_id FROM pr_business WHERE pr_business_id = '$pr_business_id'",4);

	$csvFile = array(array(
		/*  1 */ "Debtor code",
		/*  2 */ "Name",
		/*  3 */ "Postal Address 1",
		/*  4 */ "Postal Address 2",
		/*  5 */ "Postal Address 3",
		/*  6 */ "Postal Address 4",
		/*  7 */ "Postal Country",
		/*  8 */ "Telephone",
		/*  9 */ "Fax",
		/* 10 */ "Consultant (unused)",
		/* 11 */ "Physical Address 1",
		/* 12 */ "Physical Address 2",
		/* 13 */ "Physical Address 3",
		/* 14 */ "Physical Address 4",
		/* 15 */ "Country",
		/* 16 */ "Tax Number",
		/* 17 */ "Email",
		/* 18 */ "Currency",
		/* 19 */ "Foreign Currency YN"
	));

	$debtors = array();
	foreach($list as $item) {
		$debtors[] = $item['fn_debtor_ix'];
		$telephone = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code != '1'
			ORDER BY
				pr_default_yn DESC
		",4);
		$fax = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code = '1'
			ORDER BY
				pr_default_yn DESC
		",4);
		if(empty($item['rf_currency_ix']) || $item['rf_currency_ix'] == $billingCurrency) {
			$foreignCurrencyYN = "0";
		} else {
			$foreignCurrencyYN = "1";
		}
		array_push($csvFile,array(
			/*  1 */ $item['fn_debtor_code'],
			/*  2 */ trim($item['pr_name_first'] . " " . $item['pr_name_last']),
			/*  3 */ $item['pr_corr_addr_line1'],
			/*  4 */ $item['pr_corr_addr_line2'],
			/*  5 */ $item['pr_corr_addr_line3'],
			/*  6 */ trim($item['pr_corr_post_code'] . " " . $item['pr_corr_city']),
			/*  7 */ $item['pr_corr_country_name'],
			/*  8 */ $telephone,
			/*  9 */ $fax,
			/* 10 */ "", // TODO: Add consultant to debtor trim($item['pr_consultant_name_first'] . " " . $item['pr_consultant_name_last']),
			/* 11 */ $item['pr_phys_addr_line1'],
			/* 12 */ $item['pr_phys_addr_line2'],
			/* 13 */ $item['pr_phys_addr_line3'],
			/* 14 */ trim($item['pr_phys_post_code'] . " " . $item['pr_phys_city']),
			/* 15 */ $item['pr_phys_country_name'],
			/* 16 */ $item['pr_statutory_1'],
			/* 17 */ $item['pr_email'],
			/* 18 */ $item['rf_currency_symbol'],
			/* 19 */ $foreignCurrencyYN,
			/* 16 */ $item['pr_statutory_2'],
			/* 16 */ $item['pr_statutory_3']
		));
	}

	if($export_set) {
		foreach($debtors as $fn_debtor_id) {
			db_fn_debtor_set_export($fn_debtor_id);
		}
	}

	return $csvFile;
}
