<?php

function tran_quickbooks_journal($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$csvFile = array();

	array_push($csvFile,array(
		"!TRNS",
		"TRNSID",
		"TRNSTYPE",
		"DATE",
		"ACCNT",
		//"CLASS",
		"NAME",
		"AMOUNT",
		"DOCNUM"
	));
	array_push($csvFile,array(
		"!SPL",
		"SPLID",
		"TRNSTYPE",
		"DATE",
		"ACCNT",
		//"CLASS",
		"NAME",
		"AMOUNT"//,
		//"TAXABLE"
	));
	array_push($csvFile,array(
		"!ENDTRNS"
	));
	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
		WHERE
			$batchWhere
			/*AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'*/
	",2);
	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",2);
		$dateArray = explode(" ",$tran['fn_tran_date_ledger']);
		$dateArray = explode("-",$dateArray[0]);
		$finalDate = $dateArray[1] . "/" . $dateArray[2] . "/" . substr($dateArray[0],2,2);

		switch($tran['fn_tran_link_ind']) {
		case DB_FN_TRAN_LINK_INVOICE:
			if($item['fn_tran_item_amt'] < 0) {
				$docType = "CREDIT MEMO";
				$splType = "CREDIT MEMO";
				$tran['fn_tran_link_id'] = $tran['fn_tran_link_id'] . "C";
			} else {
				$docType = "INVOICE";
				$splType = "INVOICE";
			}
			break;
		case DB_FN_TRAN_LINK_PAYMENT:
			$docType = "PAYMENT";
			$splType = "PAYMENT";
			// Quick books needs the bank as the header item.
			$newDebtor = $items[0];
			$items[0] = $debtor;
			$debtor = $newDebtor;
			$debtor['fn_debtor_code'] = $items[0]['fn_debtor_code'];
			break;
		default: // Deposit / deposit reversal
			$docType = "GENERAL JOURNAL";
			$splType = "GENERAL JOURNAL";
			break;
		}

		$debtor['fn_tran_item_amt'] = round($debtor['fn_tran_item_amt'],2);
		fixAmtDisplay($debtor['fn_tran_item_amt'],2);

		array_push($csvFile,array(
			"TRNS",
			$tran['fn_tran_ix'],
			$docType,
			$finalDate,
			$debtor['fn_ledger_code'],
			$debtor['fn_debtor_code'],
			$debtor['fn_tran_item_amt'],
			$tran['fn_tran_link_id']
		));
		foreach($items as $item) {
			$item['fn_tran_item_amt'] = round($item['fn_tran_item_amt'],2);
			fixAmtDisplay($item['fn_tran_item_amt'],2);

			array_push($csvFile,array(
				"SPL",
				$item['fn_tran_item_ix'],
				$splType,
				$finalDate,
				$item['fn_ledger_code'],
				$item['fn_debtor_code'],
				$item['fn_tran_item_amt']//,
				//"" // taxable
			));
		}
		array_push($csvFile,array(
			"ENDTRNS"
		));
	}

	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		db_ad_batch_insert($fn_batch_id, DB_AD_BATCH_EXPORT);
	}

	return $csvFile;

}

function tran_quickbooks_direct_journal($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$csvFile = array(array(
		/*  1 */ "Date",
		/*  2 */ "Reference",
		/*  3 */ "AdjustmentYN", /* true or false */
		/*  4 */ "Memo",
		/*  5 */ "Currency",
		/*  6 */ "Exchange rate",
		/*  7 */ "Credit", /* Incoming acc / tax acc / debtor(for bank)
		/*  8 */ "Debit", /* bank, debtor(for inv)
		/*  9 */ "Account",
		/* 10 */ "Customer",
		/* 11 */ "Class",
		/* 12 */ "BillableStatus" /* Billable, NotBillable, HasBeenBilled */
	));
	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_detail,
			rf_currency.rf_currency_symbol,
			rf_currency.rf_currency_name,
			fn_tran.fn_tran_exch_rate
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_tran.rf_currency_id
		WHERE
			$batchWhere
			/*AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'*/
	",2);
	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",2);
		foreach($items as $item) {
			if($tran['fn_tran_link_ind'] == DB_FN_TRAN_LINK_INVOICE) {
				$credit = $item['fn_tran_item_amt_source'] * -1;
				$debit = "0.00";
			} else {
				$credit = "0.00";
				$debit = $item['fn_tran_item_amt_source'] * -1;
			}
			if($credit < 0 || $debit < 0) {
				list($credit,$debit) = array(abs($debit),abs($credit));
			}
			if($credit == 0) { $credit = ""; }
			if($debit == 0) { $debit = ""; }

			$csvFile[] = array(
				/*  1 */ $tran['fn_tran_date_ledger'],
				/*  2 */ $tran['fn_tran_link_id'],
				/*  3 */ "false",
				/*  4 */ $tran['fn_tran_detail'],
				/*  5 */ $tran['rf_currency_name'],
				/*  6 */ $tran['fn_tran_exch_rate'],
				/*  7 */ $credit,
				/*  8 */ $debit,
				/*  9 */ $item['fn_ledger_code'],
				/* 10 */ $item['fn_debtor_code'],
				/* 11 */ $item['fn_cost_centre_code_1'],
				/* 12 */ "Billable" /* Billable, NotBillable, HasBeenBilled */
			);

		}
		if($tran['fn_tran_link_ind'] == DB_FN_TRAN_LINK_INVOICE) {
			$debtorCredit = "0.00";
			$debtorDebit = $debtor['fn_tran_item_amt_source'];
		} else {
			$debtorCredit = $debtor['fn_tran_item_amt_source'];
			$debtorDebit = "0.00";
		}
		if($debtorCredit < 0 || $debtorDebit < 0) {
			list($debtorCredit,$debtorDebit) = array(abs($debtorDebit),abs($debtorCredit));
		}
		if($debtorCredit == 0) { $debtorCredit = ""; }
		if($debtorDebit == 0) { $debtorDebit = ""; }

		$csvFile[] = array(
			/*  1 */ $tran['fn_tran_date_ledger'],
			/*  2 */ $tran['fn_tran_link_id'],
			/*  3 */ "false",
			/*  4 */ $tran['fn_tran_detail'],
			/*  5 */ $tran['rf_currency_name'],
			/*  6 */ $tran['fn_tran_exch_rate'],
			/*  7 */ $debtorCredit,
			/*  8 */ $debtorDebit,
			/*  9 */ $debtor['fn_ledger_code'],
			/* 10 */ $debtor['fn_debtor_code'],
			/* 11 */ $debtor['fn_cost_centre_code_1'],
			/* 12 */ "Billable" /* Billable, NotBillable, HasBeenBilled */
		);
	}

	return $csvFile;
}

function tran_quickbooks_direct_invoice($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$csvFile = array(array(
		/*  1 */ "Customer",
		/*  2 */ "Class",
		/*  3 */ /*"Account",*/
		/*  4 */ "Date",
		/*  5 */ "Reference",
		/*  6 */ "Memo",
		/*  7 */ "Exchange",
		/*  8 */ "Item",
		/*  9 */ "ItemClass",
		/* 10 */ "Amount"
	));
	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_detail,
			rf_currency.rf_currency_symbol,
			rf_currency.rf_currency_name,
			fn_tran.fn_tran_exch_rate
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_tran.rf_currency_id
			INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		WHERE
			$batchWhere
			AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
			AND fn_tran_item.fn_tran_item_amt >= 0
		GROUP BY
			fn_tran.fn_tran_ix
	",2);
	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",2);
		foreach($items as $item) {
			$amount = $item['fn_tran_item_amt_source'] * -1;
			$csvFile[] = array(
				/*  1 */ $debtor['fn_debtor_code'],
				/*  2 */ $debtor['fn_cost_centre_code_1'],
				/*  3 */ /*"Account",*/
				/*  4 */ $tran['fn_tran_date_ledger'],
				/*  5 */ $tran['fn_tran_link_id'],
				/*  6 */ $tran['fn_tran_detail'],
				/*  7 */ $tran['fn_tran_exch_rate'],
				/*  8 */ $item['fn_ledger_code'],
				/*  9 */ $item['fn_cost_centre_code_1'],
				/* 10 */ $amount
			);

		}
	}

	return $csvFile;
}

function tran_quickbooks_direct_credit_memo($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$csvFile = array(array(
		/*  1 */ "Customer",
		/*  2 */ "Class",
		/*  3 */ /*"Account",*/
		/*  4 */ "Date",
		/*  5 */ "Reference",
		/*  6 */ "Memo",
		/*  7 */ "Exchange",
		/*  8 */ "Item",
		/*  9 */ "ItemClass",
		/* 10 */ "Amount"
	));
	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_detail,
			rf_currency.rf_currency_symbol,
			rf_currency.rf_currency_name,
			fn_tran.fn_tran_exch_rate
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_tran.rf_currency_id
			INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		WHERE
			$batchWhere
			AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
			AND fn_tran_item.fn_tran_item_amt < 0
		GROUP BY
			fn_tran.fn_tran_ix
	",2);
	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",2);
		foreach($items as $item) {
			$amount = $item['fn_tran_item_amt_source'];
			$csvFile[] = array(
				/*  1 */ $debtor['fn_debtor_code'],
				/*  2 */ $debtor['fn_cost_centre_code_1'],
				/*  3 */ /*"Account",*/
				/*  4 */ $tran['fn_tran_date_ledger'],
				/*  5 */ $tran['fn_tran_link_id'],
				/*  6 */ $tran['fn_tran_detail'],
				/*  7 */ $tran['fn_tran_exch_rate'],
				/*  8 */ $item['fn_ledger_code'],
				/*  9 */ $item['fn_cost_centre_code_1'],
				/* 10 */ $amount
			);

		}
	}

	return $csvFile;
}

function tran_quickbooks_direct_payment($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$csvFile = array(array(
		/*  1 */ "Customer",
		/*  2 */ "Date",
		/*  3 */ "Reference",
		/*  4 */ "IsAutoApply", //"Invoice Reference",
		/*  5 */ "Amount",
		/*  6 */ "Exchange",
		/*  7 */ // TODO "Payment Method",
		/*  8 */ "Memo",
		/*  9 */ "Deposit Account",
	));
	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_detail,
			rf_currency.rf_currency_symbol,
			rf_currency.rf_currency_name,
			fn_tran.fn_tran_exch_rate,
			fn_folio.fn_invoice_id
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_tran.rf_currency_id
			INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		WHERE
			$batchWhere
			AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_PAYMENT."'
			AND fn_tran_item.fn_tran_item_amt <= 0
		GROUP BY
			fn_tran.fn_tran_ix
	",2);
	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",2);

		foreach($items as $item) {
			$amount = $item['fn_tran_item_amt_source'];
			$csvFile[] = array(
				/*  1 */ $debtor['fn_debtor_code'],
				/*  2 */ $tran['fn_tran_date_ledger'],
				/*  3 */ $tran['fn_tran_link_id'],
				/*  4 */ "true", //$tran['fn_invoice_id'],
				/*  5 */ $amount,
				/*  6 */ $tran['fn_tran_exch_rate'],
				/*  7 */ // TODO: $paymentMethod,
				/*  8 */ $tran['fn_tran_detail'],
				/*  9 */ $item['fn_ledger_code'],
			);

		}
	}

	return $csvFile;
}

function tran_quickbooks_zed_axis_debtor($fn_batch_id,$pr_business_id,$rf_currency_id=false,$export_ind=TRAN_DEBTOR_EXPORT_ALL,$export_set=false) {
	global $lDB;

	$batchWhere = "";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			AND fn_tran.fn_batch_id = '$fn_batch_id'
		";
	}

	if(!empty($rf_currency_id)) {
		$batchWhere .= "
			AND fn_debtor.rf_currency_id = '$rf_currency_id'
		";
	}
	switch($export_ind) {
	case TRAN_DEBTOR_EXPORT_NEW:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '0'
		";
		break;
	case TRAN_DEBTOR_EXPORT_OLD:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '1'
		";
		break;
	}

	$list = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			fn_debtor.fn_debtor_ix,
			fn_debtor.fn_debtor_code,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_addr_line3,
			pr_persona.pr_corr_post_code,
			pr_persona.pr_corr_city,
			pr_corr_country.rf_country_name AS pr_corr_country_name,
			pr_persona.pr_phys_addr_line1,
			pr_persona.pr_phys_addr_line2,
			pr_persona.pr_phys_addr_line3,
			pr_persona.pr_phys_post_code,
			pr_persona.pr_phys_city,
			pr_phys_country.rf_country_name AS pr_phys_country_name,
			/*pr_consultant.pr_name_first AS pr_consultant_name_first,
			pr_consultant.pr_name_last AS pr_consultant_name_last,*/
			pr_persona.pr_statutory_1,
			pr_persona.pr_statutory_2,
			pr_persona.pr_statutory_3,
			pr_persona.pr_email,
			rf_currency.rf_currency_ix,
			rf_currency_inv.rf_currency_inv_code
		FROM
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
			INNER JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_debtor.rf_currency_id
			LEFT JOIN rf_currency_inv ON rf_currency_inv.rf_currency_id = rf_currency.rf_currency_ix
				AND rf_currency_inv.pr_business_id = fn_tran.pr_business_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_debtor.pr_persona_id
			/*LEFT JOIN pr_persona AS pr_consultant ON pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id*/
			LEFT JOIN rf_country AS pr_corr_country ON pr_corr_country.rf_country_ix = pr_persona.pr_corr_country_id
			LEFT JOIN rf_country AS pr_phys_country ON pr_phys_country.rf_country_ix = pr_persona.pr_phys_country_id
		WHERE
			fn_tran.pr_business_id = '$pr_business_id'
			$batchWhere
	",2);

	$billingCurrency = $lDB->get("SELECT pr_bus_home_curr_id FROM pr_business WHERE pr_business_id = '$pr_business_id'",4);

	$csvFile = array(array(
		/*  1 */ "Customer",
		/*  2 */ "Telephone",
		/*  3 */ "Fax",
		/*  4 */ "Email",
		/*  5 */ "Billing Address 1",
		/*  6 */ "Billing Address 2",
		/*  7 */ "Billing Address 3",
		/*  8 */ "Billing Post Code",
		/*  9 */ "Billing City",
		/* 10 */ "Billing Country",
		/* 11 */ "Shipping Address 1",
		/* 12 */ "Shipping Address 2",
		/* 13 */ "Shipping Address 3",
		/* 14 */ "Shipping Post Code",
		/* 15 */ "Shipping City",
		/* 16 */ "Shipping Country",
		/* 17 */ "Currency Name",
		/* 18 */ "Tax Number"
	));

	$debtors = array();
	foreach($list as $item) {
		$debtors[] = $item['fn_debtor_ix'];
		$telephone = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code != '1'
			ORDER BY
				pr_default_yn DESC
		",4);
		$fax = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code = '1'
			ORDER BY
				pr_default_yn DESC
		",4);
		if(empty($item['rf_currency_ix']) || $item['rf_currency_ix'] == $billingCurrency) {
			$foreignCurrencyYN = "0";
		} else {
			$foreignCurrencyYN = "1";
		}
		array_push($csvFile,array(
			/*  1 */ $item['fn_debtor_code'],
			/*  2 */ $telephone,
			/*  3 */ $fax,
			/*  4 */ $item['pr_email'],
			/*  5 */ $item['pr_corr_addr_line1'],
			/*  6 */ $item['pr_corr_addr_line2'],
			/*  7 */ $item['pr_corr_addr_line3'],
			/*  8 */ $item['pr_corr_post_code'],
			/*  9 */ $item['pr_corr_city'],
			/* 10 */ $item['pr_corr_country_name'],
			/* 11 */ $item['pr_phys_addr_line1'],
			/* 12 */ $item['pr_phys_addr_line2'],
			/* 13 */ $item['pr_phys_addr_line3'],
			/* 14 */ $item['pr_phys_post_code'],
			/* 15 */ $item['pr_phys_city'],
			/* 16 */ $item['pr_phys_country_name'],
			/* 17 */ $item['rf_currency_inv_code'],
			/* 18 */ $item['pr_statutory_1'],
			/* 18 */ $item['pr_statutory_2'],
			/* 18 */ $item['pr_statutory_3']

		));
	}

	if($export_set) {
		foreach($debtors as $fn_debtor_id) {
			db_fn_debtor_set_export($fn_debtor_id);
		}
	}

	return $csvFile;
}

function tran_quickbooks_zed_axis_journal($fn_batch_id, $refunds_only=false) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$csvFile = array(array(
		/*  1 */ "Date",
		/*  2 */ "Reference",
		/*  3 */ "AdjustmentYN", /* true or false */
		/*  4 */ "Memo",
		/*  5 */ "Currency",
		/*  6 */ "Exchange rate",
		/*  7 */ "Credit", /* Incoming acc / tax acc / debtor(for bank)
		/*  8 */ "Debit", /* bank, debtor(for inv)
		/*  9 */ "Account",
		/* 10 */ "Customer",
		/* 11 */ "Class"
	));

	$linkWhere = "";
	if ($refunds_only !== false){
		$linkWhere = "AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_PAYMENT."'";
	}

	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_detail,
			fn_tran.pr_business_id,
			rf_currency_inv.rf_currency_inv_code,
			fn_tran.fn_tran_exch_rate,
			fn_tran.rv_reservation_id
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			LEFT JOIN rf_currency_inv ON rf_currency_inv.rf_currency_id = fn_tran.rf_currency_id AND rf_currency_inv.pr_business_id = fn_tran.pr_business_id
		WHERE
			$batchWhere
			$linkWhere
	",2);
	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_tran_item.fn_tran_item_type_ind,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS cost_centre_1_code,
				fn_cost_centre_2.fn_cost_centre_code AS cost_centre_2_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_2 ON fn_cost_centre_2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_tran_item.fn_tran_item_type_ind,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS cost_centre_1_code,
				fn_cost_centre_2.fn_cost_centre_code AS cost_centre_2_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_2 ON fn_cost_centre_2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",2);
		foreach($items as $item) {
			if ($refunds_only !== false){
				if ($item['fn_tran_item_amt_source'] < 0 && $item['fn_tran_item_type_ind'] == "60"){
					// This is a Refund transaction, continue
				} else {
					break;
				}
			}
			$tran_code_return = getTranCode($tran['pr_business_id'], $item); // journals - uses Acc No and cost
			$accountNumber = $tran_code_return[0];
			$costCode = getCostCentreCode($tran['pr_business_id'], $item); // Concatenate cost codes as per option selection

			$credit = $item['fn_tran_item_amt_source'] * -1;
			$debit = "0.00";

			if($credit < 0 || $debit < 0) {
				list($credit,$debit) = array(abs($debit),abs($credit));
			}
			if($credit == 0) { $credit = ""; }
			if($debit == 0) { $debit = ""; }

			$csvFile[] = array(
				/*  1 */ $tran['fn_tran_date_ledger'],
				/*  2 */ $tran['rv_reservation_id'],
				/*  3 */ "false",
				/*  4 */ $tran['fn_tran_detail'],
				/*  5 */ $tran['rf_currency_inv_code'],
				/*  6 */ $tran['fn_tran_exch_rate'],
				/*  7 */ $credit,
				/*  8 */ $debit,
				/*  9 */ $accountNumber,
				/* 10 */ $item['fn_debtor_code'],
				/* 11 */ $costCode
			);

		}

		if ($refunds_only !== false){
			if ($debtor['fn_tran_item_amt_source'] > 0 && $debtor['fn_tran_item_type_ind'] == "10"){
				// This is a Refund transaction, continue
			} else {
				continue;
			}
		}

		$debtorCredit = "0.00";
		$debtorDebit = $debtor['fn_tran_item_amt_source'];

		if($debtorCredit < 0 || $debtorDebit < 0) {
			list($debtorCredit,$debtorDebit) = array(abs($debtorDebit),abs($debtorCredit));
		}
		if($debtorCredit == 0) { $debtorCredit = ""; }
		if($debtorDebit == 0) { $debtorDebit = ""; }

		$tran_code_return = getTranCode($tran['pr_business_id'], $debtor);
		$accountNumber = $tran_code_return[0];
		$costCode = getCostCentreCode($tran['pr_business_id'], $item); // Concatenate cost code as per option setting

		$csvFile[] = array(
			/*  1 */ $tran['fn_tran_date_ledger'],
			/*  2 */ $tran['rv_reservation_id'],
			/*  3 */ "false",
			/*  4 */ $tran['fn_tran_detail'],
			/*  5 */ $tran['rf_currency_inv_code'],
			/*  6 */ $tran['fn_tran_exch_rate'],
			/*  7 */ $debtorCredit,
			/*  8 */ $debtorDebit,
			/*  9 */ $accountNumber,
			/* 10 */ $debtor['fn_debtor_code'],
			/* 11 */ $costCode
		);
	}

	return $csvFile;
}

function tran_quickbooks_zed_axis_invoice($fn_batch_id,$pr_business_id="") {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$extraColumnLabels = db_fn_option_data_by_name($pr_business_id, "Xero tracking labels");
	$extraColumnValues = [];

	if ($extraColumnLabels) {
		$extraColumnLabels = explode(',', $extraColumnLabels);
		$extraColumnValues = db_fn_option_data_by_name($pr_business_id, "Xero tracking values");
		$extraColumnValues = explode(',', $extraColumnValues);
	}

	$columnHeadings = array(
		/*  1 */ "CustomerRefFullName",
		/*  2 */ "ARAccountRefFullName",
		/*  3 */ "TxnDate",
		/*  4 */ "Reference",
		/*  5 */ "CurrencyFullName",
		/*  6 */ "ExchangeRate",
		/*  7 */ "ItemRefFullName",
		/*  8 */ "Desc",
		/*  9 */ "Amount",
		/* 10 */ "SalesTaxCodeFullName",
		/* 11 */ "InvoiceLineClassFullName",
		/* 12 */ "ShipAddr1"
	);

	if ($extraColumnLabels) {
		$columnHeadings = array_merge($columnHeadings, $extraColumnLabels);
	}

	$csvFile = array($columnHeadings);

	$referenceFormat = db_fn_option_data_by_name($pr_business_id, 'reference_format');
	$useTaxGroups    = db_fn_option_data_by_name($pr_business_id, 'tax_group');

	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_detail,
			rf_currency_inv.rf_currency_inv_code,
			fn_tran.fn_tran_exch_rate,
			fn_tran.pr_business_id,
			rf_currency_inv.fn_ledger_id_debtors,
			fn_tran.rv_reservation_id,
			rv_reservation.rv_res_name
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			INNER JOIN rf_currency_inv ON rf_currency_inv.rf_currency_id = fn_tran.rf_currency_id AND rf_currency_inv.pr_business_id = fn_tran.pr_business_id
			INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
		WHERE
			$batchWhere
			AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
			AND fn_tran_item.fn_tran_item_amt >= 0
		GROUP BY
			fn_tran.fn_tran_ix
	",2);

	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_incl,
				fn_tran_item.fn_tran_item_amt_source,
				fn_tran_item.fn_tran_item_amt_source_incl,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_debtor.rf_currency_id,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1,
				fn_cost_centre_2.fn_cost_centre_code AS fn_cost_centre_code_2,
				rf_tax_inv.rf_tax_id,
				rf_tax_inv.rf_tax_ind,
				debtor_ledger.fn_ledger_code AS AR_code,
				rf_currency_inv.rf_currency_inv_code AS debtor_currency_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN rf_currency_inv ON rf_currency_inv.rf_currency_id = fn_debtor.rf_currency_id AND rf_currency_inv.pr_business_id = '".$tran['pr_business_id']."'
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_2 ON fn_cost_centre_2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
				LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_inv_ix = fn_tran_item.rf_tax_inv_id
				LEFT JOIN fn_ledger AS debtor_ledger ON debtor_ledger.fn_ledger_ix = '".$tran['fn_ledger_id_debtors']."'
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_incl,
				fn_tran_item.fn_tran_item_amt_source,
				fn_tran_item.fn_tran_item_amt_source_incl,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS cost_centre_1_code,
				fn_cost_centre_2.fn_cost_centre_code AS cost_centre_2_code,
				rf_tax_inv.rf_tax_id,
				rf_tax_inv.rf_tax_ind,
				rf_tax_inv.fn_ledger_id AS tax_ledger_id,
				tax_ledger.fn_ledger_code AS tax_ledger_code,
				pr_business.pr_bus_home_curr_id,
				fn_tran_item.fn_tran_item_type_ind as ref_type,
				fn_tran_item.rv_payment_item_id as payment_number
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_ledger.pr_business_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_2 ON fn_cost_centre_2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
				LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_inv_ix = fn_tran_item.rf_tax_inv_id
				LEFT JOIN fn_ledger AS tax_ledger ON tax_ledger.fn_ledger_ix = rf_tax_inv.fn_ledger_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_TAX."'
		",2);

		foreach($items as $item) {

			$subject_to_tax = "Non";

			switch ($item['rf_tax_ind']){
			case 10:
				$tax_rate = $lDB->get("
					SELECT
						rf_tax_rate.rf_tax_rate_desc,
						rf_tax_rate.rf_tax_rate_perc
					FROM
						rf_tax_rate
					WHERE
						rf_tax_rate.rf_tax_rate_ix = '".$item['rf_tax_id']."'
				",1);

				if(!empty($item['tax_ledger_code'])) {
					$subject_to_tax = $item['tax_ledger_code'];
				} else {
					if ($tax_rate['rf_tax_rate_perc'] != 0.00){
						$subject_to_tax = "Tax";
					}
				}
				break;
			case 20:
				if ($useTaxGroups == 1){
					$subject_to_tax = $item['tax_ledger_code'];
				}
				else {
					$tax_rates = $lDB->get("
						SELECT
							rt_tax_group_item.rt_tax_group_id,
							rf_tax_rate.rf_tax_rate_perc
						FROM
							rt_tax_group_item
							INNER JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
						WHERE
							rt_tax_group_item.rt_tax_group_id = '".$item['rf_tax_id']."'
					",2);

					foreach ($tax_rates as $tax_rate){
						if ($tax_rate['rf_tax_rate_perc'] != 0){
							$subject_to_tax = "Tax";
						}
					}
				}
				break;
			}

			if ($debtor['rf_currency_id'] == $item['pr_bus_home_curr_id']){
				$amount = $item['fn_tran_item_amt'] * -1;
			} else {
				$amount = $item['fn_tran_item_amt_source'] * -1;
			}



			$tran_code_return = getTranCode($tran['pr_business_id'], $item);
			$accountNumber = $tran_code_return[0];
			$invoiceLineClassFullName = getCostCentreCode($tran['pr_business_id'], $item); // Concatenate invoiceLineClassFullName as per option setting

			$QB_inv_amt = db_fn_option_data_by_name($pr_business_id, "QB_inv_amt");

			switch ($QB_inv_amt){
			case 1:
				$amount = $item['fn_tran_item_amt_source_incl'] * -1;
				break;
			case 2:
				$amount = $item['fn_tran_item_amt_source'] * -1;
				break;
			case 3:
				$amount = $item['fn_tran_item_amt_incl'] * -1;
				break;
			case 4:
				$amount = $item['fn_tran_item_amt'] * -1;
				break;
			}

			switch($referenceFormat) {
				case '1':
					// Line item
					switch ($item['ref_type']) {
						case '10':
                            $item['reference'] = 'Debtor';
                            break;
                        case '20':
                            $item['reference'] = 'Tax';
                            break;
                        case '30':
                            $item['reference'] = 'Accommodation';
                            break;
                        case '40':
                            $item['reference'] = 'Extra';
                            break;
                        case '50':
                            $item['reference'] = 'Deposit';
                            break;
                        case '60':
                            $item['reference'] = 'Bank';
                            break;
                        default:
                            $item['reference'] = 'Unknown';
                            break;
					}
					break;
				case '2':
					// Reservation number
					$item['reference'] = $tran['rv_reservation_id'];
					break;
				case '3':
					// Link
					$item['reference'] = $tran['fn_tran_link_id'];
					break;
				case '4':
					// Debtor code
					$item['reference'] = $item['fn_debtor_code'];
					break;
				case '5':
					// Document number
					if ($tran['fn_tran_link_ind'] != DB_FN_TRAN_LINK_INVOICE) {
                        $item['reference'] = $item['payment_number'];
                    } else {
                        $item['reference'] = $tran['fn_tran_link_id'];
                    }
					break;
				case '6':
					// Reservation number + Invoice number
					$item['reference'] = $tran['rv_reservation_id'] . ', ' . $tran['fn_tran_link_id'];
					break;
				default:
					// The link is the default for Quickbooks
					$item['reference'] = $tran['fn_tran_link_id'];
					break;
			}

			$outputData = array(
				/*  1 */ $debtor['fn_debtor_code'],
				/*  2 */ $debtor['AR_code'],
				/*  3 */ $tran['fn_tran_date_ledger'],
				/*  4 */ $item['reference'],
				/*  5 */ $debtor['debtor_currency_code'],
				/*  6 */ $tran['fn_tran_exch_rate'],
				/*  7 */ $accountNumber,
				/*  8 */ $tran['fn_tran_detail'],
				/*  9 */ $amount,
				/* 10 */ $subject_to_tax,
				/* 11 */ $invoiceLineClassFullName,
				/* 12 */ $tran['rv_res_name']
			);

			if ($extraColumnValues) {
				foreach ($extraColumnValues as $extraColumnValue) {
					switch ($extraColumnValue) {
						case '1':
							array_push($outputData, '');
							break;
						case '2':
							array_push($outputData, $item['cost_centre_1_code']);
							break;
						case '3':
							array_push($outputData, $tran['rv_reservation_id']);
							break;
						case '4':
							array_push($outputData, $tran['fn_tran_link_id']);
							break;
						case '5':
							array_push($outputData, $debtor['fn_debtor_code']);
							break;
						default:
							array_push($outputData, '');
							break;
					}
				}
			}

			$csvFile[] = $outputData;
		}
	}

	return $csvFile;
}

function tran_quickbooks_zed_axis_payment($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$csvFile = array(array(
		/*  1 */ "CustomerRefFullName",
		/*  2 */ "ARAccountRefFullName",
		/*  3 */ "TxnDate",
		/*  4 */ "RefNumber",
		/*  5 */ "App to Inv",
		/*  6 */ "TotalAmount",
		/*  7 */ "CurrencyFullName",
		/*  8 */ "ExchangeRate",
		/*  9 */ "DepositToAccountRefFullName",
		/* 10 */ "AppliedToTxnRetAmount",
		/* 11 */ "Memo",
	));
	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_detail,
			fn_tran.pr_business_id,
			rf_currency_inv.rf_currency_inv_code,
			rf_currency_inv.fn_ledger_id_debtors,
			fn_tran.fn_tran_exch_rate,
			fn_folio.fn_invoice_id,
			fn_folio.fn_invoice_id,
			fn_tran.fn_tran_link_ind,
			rv_payment.rv_pmnt_ref,
			fn_tran.rv_reservation_id,
			rv_payment.rv_payment_ix
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			INNER JOIN rf_currency_inv ON rf_currency_inv.rf_currency_id = fn_tran.rf_currency_id AND rf_currency_inv.pr_business_id = fn_tran.pr_business_id
			INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
			LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = fn_tran.fn_folio_id
			LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
			LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
		WHERE
			$batchWhere
			AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_PAYMENT."'
			AND fn_tran_item.fn_tran_item_amt <= 0
		GROUP BY
			fn_tran.fn_tran_ix
	",2);

	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_desc,
				fn_debtor.fn_debtor_code,
				fn_debtor.rf_currency_id,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1,
				debtor_ledger.fn_ledger_code AS AR_code
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
				LEFT JOIN fn_ledger AS debtor_ledger ON debtor_ledger.fn_ledger_ix = '".$tran['fn_ledger_id_debtors']."'
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);

		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_desc,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1,
				pr_business.pr_bus_home_curr_id
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_ledger.pr_business_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",2);

		foreach($items as $item) {

			if ($debtor['rf_currency_id'] == $item['pr_bus_home_curr_id']){
				$amount = $item['fn_tran_item_amt'];
			} else {
				$amount = $item['fn_tran_item_amt_source'];
			}

			$csvFile[] = array(
				/*  1 */ $debtor['fn_debtor_code'],
				/*  2 */ $debtor['AR_code'],
				/*  3 */ $tran['fn_tran_date_ledger'],
				/*  4 */ $tran['rv_payment_ix'].";".$tran['rv_reservation_id'],
				/*  5 */ $tran['fn_invoice_id'], // Inv number to which pmt is applied.
				/*  6 */ $amount, // ???
				/*  7 */ $tran['rf_currency_inv_code'],
				/*  8 */ $tran['fn_tran_exch_rate'],
				/*  9 */ $item['fn_ledger_code'],
				/* 10 */ $amount, //Amt applied to this invoice
				/* 10 */ $tran['rv_payment_ix'].";".$tran['rv_pmnt_ref'] //Memo
			);


		}

	}

	return $csvFile;
}
