<?php

function tran_sage_journal($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$csvFile = array();
}

function tran_sage_debtor($fn_batch_id,$pr_business_id,$rf_currency_id=false,$export_ind=TRAN_DEBTOR_EXPORT_ALL,$export_set=false) {
}

function tran_sage_300_debtor($fn_batch_id,$pr_business_id,$rf_currency_id=false,$export_ind=TRAN_DEBTOR_EXPORT_ALL,$export_set=false) {
	global $lDB;

	$batchWhere = "";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			AND fn_tran.fn_batch_id = '$fn_batch_id'
		";
	}
	if(!empty($rf_currency_id)) {
		$batchWhere .= "
			AND fn_debtor.rf_currency_id = '$rf_currency_id'
		";
	}
	switch($export_ind) {
	case TRAN_DEBTOR_EXPORT_NEW:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '0'
		";
		break;
	case TRAN_DEBTOR_EXPORT_OLD:
		$batchWhere .= "
			AND fn_debtor.fn_debtor_export_yn = '1'
		";
		break;
	}

	$list = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			fn_debtor.fn_debtor_ix,
			fn_debtor.fn_debtor_code,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_addr_line3,
			pr_persona.pr_corr_post_code,
			pr_persona.pr_corr_city,
			pr_corr_country.rf_country_name AS pr_corr_country_name,
			pr_persona.pr_phys_addr_line1,
			pr_persona.pr_phys_addr_line2,
			pr_persona.pr_phys_addr_line3,
			pr_persona.pr_phys_post_code,
			pr_persona.pr_phys_city,
			pr_phys_country.rf_country_name AS pr_phys_country_name,
			/*pr_consultant.pr_name_first AS pr_consultant_name_first,
			pr_consultant.pr_name_last AS pr_consultant_name_last,*/
			pr_persona.pr_tax_number,
			pr_persona.pr_email,
			rf_currency.rf_currency_symbol
		FROM
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_tran.rv_reservation_id
			INNER JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_debtor.rf_currency_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_debtor.pr_persona_id
			/*LEFT JOIN pr_persona AS pr_consultant ON pr_consultant.pr_persona_ix = rv_reservation.rv_consultant_id*/
			LEFT JOIN rf_country AS pr_corr_country ON pr_corr_country.rf_country_ix = pr_persona.pr_corr_country_id
			LEFT JOIN rf_country AS pr_phys_country ON pr_phys_country.rf_country_ix = pr_persona.pr_phys_country_id
		WHERE
			fn_tran.pr_business_id = '$pr_business_id'
			$batchWhere
	",2);

	$csvFile = array();

	$debtors = array();
	foreach($list as $item) {
		$debtors[] = $item['fn_debtor_ix'];
		$telephone = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code != '1'
			ORDER BY
				pr_default_yn DESC
		",4);
		$fax = $lDB->get("
			SELECT
				pr_phone.pr_phone_number
			FROM
				pr_phone
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id = '$item[pr_persona_ix]'
				AND rf_phone_type.rf_phone_type_sys_code = '1'
			ORDER BY
				pr_default_yn DESC
		",4);
		array_push($csvFile,array(
			/*  1 */ $item['fn_debtor_code'],
			/*  2 */ trim($item['pr_name_first'] . " " . $item['pr_name_last']),
			/*  3 */ $item['pr_corr_addr_line1'],
			/*  4 */ $item['pr_corr_addr_line2'],
			/*  5 */ $item['pr_corr_addr_line3'],
			/*  6 */ trim($item['pr_corr_post_code'] . " " . $item['pr_corr_city']),
			/*  7 */ $item['pr_corr_country_name'],
			/*  8 */ $telephone,
			/*  9 */ $fax,
			/* 10 */ "", // TODO: Add consultant to debtor trim($item['pr_consultant_name_first'] . " " . $item['pr_consultant_name_last']),
			/* 11 */ $item['pr_phys_addr_line1'],
			/* 12 */ $item['pr_phys_addr_line2'],
			/* 13 */ $item['pr_phys_addr_line3'],
			/* 14 */ trim($item['pr_phys_post_code'] . " " . $item['pr_phys_city']),
			/* 15 */ $item['pr_phys_country_name'],
			/* 16 */ $item['pr_tax_number'],
			/* 17 */ $item['pr_email'],
			/* 18 */ $item['rf_currency_symbol']
		));
	}

	if($export_set) {
		foreach($debtors as $fn_debtor_id) {
			db_fn_debtor_set_export($fn_debtor_id);
		}
	}

	return $csvFile;
}

function sage_300_tran_item_export($sql_where,$summary=false,$showHeader=true,$creditNote=false) {
	$exportDate = date("Y-m-d");
	$csvFile = array();
	$creditNoteWhere = '';

	if ($creditNote) {
		$sql_where .= ' AND LEFT(fn_tran.fn_tran_detail, 2) = "CN"';
	} else {
		$sql_where .= ' AND LEFT(fn_tran.fn_tran_detail, 2) != "CN"';
	}

	if ($summary){
		$sql_select = "
			fn_tran.fn_batch_id,
			fn_year.fn_year_desc,
			pr_business.pr_bus_name_short,
			pr_business.pr_bus_post_source_curr_yn,
			SUM(fn_tran_item.fn_tran_item_amt) as fn_tran_item_amt,
			SUM(fn_tran_item.fn_tran_item_amt_source) as fn_tran_item_amt_source,
			source_curr.rf_currency_symbol AS source_currency,
			home_curr.rf_currency_symbol AS home_currency,
			cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
			cost_ctr2.fn_cost_centre_code AS cost_centre_2_code,
			fn_ledger.fn_ledger_code,
			fn_debtor.fn_debtor_code
		";

		$sql_group = "
			GROUP BY
				cost_ctr1.fn_cost_centre_code,
				cost_ctr2.fn_cost_centre_code,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code
		";


	} else {
		$sql_select = "
			fn_tran.fn_tran_ix,
			fn_tran.fn_batch_id,
			pr_business.pr_bus_name_short,
			pr_business.pr_bus_post_source_curr_yn,
			fn_year.fn_year_desc,
			fn_tran.fn_tran_date_ledger,
			fn_tran_item.fn_tran_item_type_ind,
			fn_tran_item.fn_tran_item_amt,
			fn_tran_item.fn_tran_item_amt_source,
			source_curr.rf_currency_symbol AS source_currency,
			home_curr.rf_currency_symbol AS home_currency,
			cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
			cost_ctr2.fn_cost_centre_code AS cost_centre_2_code,
			fn_ledger.fn_ledger_code,
			fn_debtor.fn_debtor_code,
			fn_tran.fn_tran_detail,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_contra_id
		";

		$sql_group = "";
	}

	$sql_from = "
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
			INNER JOIN rf_currency AS source_curr ON source_curr.rf_currency_ix = fn_tran_item.rf_currency_id
			INNER JOIN rf_currency AS home_curr ON home_curr.rf_currency_ix = pr_business.pr_bus_home_curr_id
			LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
			LEFT JOIN fn_cost_centre AS cost_ctr1 ON cost_ctr1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			LEFT JOIN fn_cost_centre AS cost_ctr2 ON cost_ctr2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
			LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
			LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
	";


	$list = $GLOBALS['lDB']->get("
		SELECT
			$sql_select
		FROM
			$sql_from
		WHERE
			$sql_where
			$creditNoteWhere
		$sql_group
	",2);

	if ($list[0]['pr_bus_post_source_curr_yn'] == 1){
		$showSourceCurr = true;

		// Annoyingly, if we are showing the summary, and we want the source currency shown, we need to re-run the SQL with
		// another GROUPING
		if ($summary){
			$sql_group .= ",
				source_currency
			";
		}

		$list = $GLOBALS['lDB']->get("
			SELECT
				$sql_select
			FROM
				$sql_from
			WHERE
				$sql_where
			$sql_group
		",2);

	} else {
		$showSourceCurr = false;
	}

	if($showHeader) {

		$headerRow = array("RECTYPE", "LINE", "BATCHID", "Field1", "Field2", "Field3", "Field4", "Field5", "Field6", "Field7", "Field8", "Field9", "Field10", "TRANID");
		if ($creditNote) {
			$headerRow = array("RECTYPE", "LINE", "BATCHID", "Field1", "Field2", "Field3", "Field4", "Field5", "Field6", "Field7", "Field8", "Field9", "Field10","Field11", "TRANID");
		}



		if ($summary){
			if ($showSourceCurr){
				array_push($headerRow,"GL Amount","GL Currency","Source Amount","Source Currency");
			} else {
				array_push($headerRow,"GL Amount","Source Currency");
			}

		} else {
			if ($showSourceCurr){
				//array_push($headerRow,"Ledger date","Type","GL Amount","GL Currency","Source Amount","Source Currency","Transaction detail");
			} else {
				//array_push($headerRow,"Ledger date","Type","GL Amount","Source Currency","Transaction detail");
			}

		}

		//array_push($headerRow, "Cost centre 1","Cost centre 2","Ledger code","Debtor code","Export date");

		array_push($csvFile, $headerRow);

	}

	$transactions = array();
	foreach($list as $item) {
		if (!isset($transactions[$item['fn_tran_ix']]['items'])) {
			$transactions[$item['fn_tran_ix']]['items'] = array();
		}
		$transactions[$item['fn_tran_ix']]['items'][] = $item;

		if (!isset($transactions[$item['fn_tran_ix']]['header'])) {
			$transactions[$item['fn_tran_ix']]['header'] = array();
			$fn_tran_detail = explode(";", $item['fn_tran_detail']);
			$res_details = explode(" ",$fn_tran_detail[2], 2);
			$transactions[$item['fn_tran_ix']]['header'][] = "1";							// RECTYPE: Record type, header is always 1
			$transactions[$item['fn_tran_ix']]['header'][] = "1";							// LINE: Line number, header is line 1
			$transactions[$item['fn_tran_ix']]['header'][] = ($item['fn_batch_id'] == null) ? "n/a" : $item['fn_batch_id'];	// BATCHID: Batch ID
			$transactions[$item['fn_tran_ix']]['header'][] = $fn_tran_detail[0];			// Field 1: Tran type
			$transactions[$item['fn_tran_ix']]['header'][] = $item['pr_bus_name_short'];	// Field 2: Company abbreviation
			if ($creditNote) {
				$origInvoice = "";
				if ($item['fn_tran_link_ind'] == "40" && !empty($item['fn_tran_contra_id'])) {
					$origMemo = $GLOBALS['lDB']->get("
						SELECT
							fn_tran.fn_tran_detail
						FROM
							fn_tran
						WHERE
							fn_tran.fn_tran_ix = '".$item['fn_tran_contra_id']."'
					",4);
					$origMemoParts = explode(";", $origMemo);
					$origInvoice = $origMemoParts[1];
				}
				$transactions[$item['fn_tran_ix']]['header'][] = $origInvoice;				// Field 3: Original invoice number
			}
			$transactions[$item['fn_tran_ix']]['header'][] = $fn_tran_detail[1];			// Field 3: Invoice number
			$transactions[$item['fn_tran_ix']]['header'][] = $res_details[0];				// Field 4: Res number
			$transactions[$item['fn_tran_ix']]['header'][] = $res_details[1];				// Field 5: Res name
			$transactions[$item['fn_tran_ix']]['header'][] = $fn_tran_detail[3];			// Field 6: Agent name
			$transactions[$item['fn_tran_ix']]['header'][] = $fn_tran_detail[4];			// Field 7: Currency
			$transactions[$item['fn_tran_ix']]['header'][] = $fn_tran_detail[5];			// Field 8: Exchange rate
			$transactions[$item['fn_tran_ix']]['header'][] = $item['fn_tran_date_ledger'];// Field 9: Ledger date
			$transactions[$item['fn_tran_ix']]['header'][] = $item['fn_year_desc'];		// Field 10: Financial year
			$transactions[$item['fn_tran_ix']]['header'][] = $item['fn_tran_ix'];			// TRANID: Transaction ID
		}
	}

	foreach ($transactions as $fn_tran_id => $transaction) {
		error_log(serialize($transaction));
		array_push($csvFile, $transaction['header']);
		$itemLine = "1";
		$recType = "2";
		foreach ($transaction['items'] as $item) {
			$dataRow = array();
			array_push($dataRow,
					$recType,																// RECTYPE
					$itemLine,																// LINE
					($item['fn_batch_id'] == null) ? "n/a" : $item['fn_batch_id'],			// BATCHID
					db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']),				// Field 1
					$item['fn_tran_item_amt_source'],										// Field 2
					$item['fn_tran_item_amt'],												// Field 3
					$item['cost_centre_1_code']);											// Field 4
			if ($creditNote) { array_push($dataRow,""); }									// Original Invoice number
			array_push($dataRow,
					$item['cost_centre_2_code'],											// Field 5
					$item['fn_ledger_code'],												// Field 6
					$item['fn_debtor_code'],												// Field 7
					"",																		// Field 8
					"",																		// Field 9
					"",																		// Field 10
					$item['fn_tran_ix']														// Field TRANID
			);
			$itemLine++;
			array_push($csvFile, $dataRow);
		}
	}

	foreach($list as $item) {
		$item['fn_tran_item_amt'] = round($item['fn_tran_item_amt'],2);
		fixAmtDisplay($item['fn_tran_item_amt'],2);
		$dataRow = array();

		$recType = "1";
		$line = "1";



		if ($summary){
			array_push($dataRow,
					($item['fn_batch_id'] == null) ? "n/a" : $item['fn_batch_id'],
					$item['pr_bus_name_short'],
					($item['fn_year_desc'] == null) ? "n/a" : $item['fn_year_desc'],
					$item['fn_tran_item_amt']
			);

			if ($showSourceCurr){
				array_push($dataRow,
					$item['home_currency'],
					$item['fn_tran_item_amt_source'],
					$item['source_currency']
				);
			} else {
				array_push($dataRow,
					$item['source_currency']
				);
			}

		} else {
			array_push($dataRow,
					$recType,
					$line,
					($item['fn_batch_id'] == null) ? "n/a" : $item['fn_batch_id'],
					db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']),
					$item['fn_tran_item_amt_source'],
					$item['fn_tran_item_amt'],
					$item['pr_bus_name_short'],
					"Res name",
					$item['fn_ledger_code'],
					$item['fn_debtor_code'],
					"",
					"",
					"",
					$item['fn_tran_ix']
			);

		}

		//array_push($csvFile, $dataRow);

	}
	return $csvFile;
}

function sage_300_payment($sql_where,$showHeader=true) {
	global $lDB;

	$exportDate = date("Y-m-d");
	$csvFile = array();

	$sql_select = "
		fn_tran.fn_tran_ix,
		fn_tran.fn_batch_id,
		pr_business.pr_bus_name_short,
		pr_business.pr_bus_post_source_curr_yn,
		fn_year.fn_year_desc,
		fn_tran.fn_tran_date_ledger,
		fn_tran_item.fn_tran_item_type_ind,
		fn_tran_item.fn_tran_item_amt,
		fn_tran_item.fn_tran_item_amt_source,
		source_curr.rf_currency_symbol AS source_currency,
		home_curr.rf_currency_symbol AS home_currency,
		cost_ctr1.fn_cost_centre_code AS cost_centre_1_code,
		cost_ctr2.fn_cost_centre_code AS cost_centre_2_code,
		fn_ledger.fn_ledger_code,
		fn_debtor.fn_debtor_code,
		fn_tran.fn_tran_detail,
		fn_tran.fn_tran_link_ind,
		fn_tran.fn_tran_contra_id,
		rv_payment.rv_pmnt_ref,
		rv_payment_item.rv_payment_id,
		rv_payment_item.rv_payment_item_ix,
		fn_folio.fn_invoice_id
	";

	$sql_group = "";

	$sql_from = "
			fn_tran_item
			INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
			INNER JOIN rf_currency AS source_curr ON source_curr.rf_currency_ix = fn_tran_item.rf_currency_id
			INNER JOIN rf_currency AS home_curr ON home_curr.rf_currency_ix = pr_business.pr_bus_home_curr_id
			LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
			LEFT JOIN fn_cost_centre AS cost_ctr1 ON cost_ctr1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			LEFT JOIN fn_cost_centre AS cost_ctr2 ON cost_ctr2.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr2_id
			LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
			LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
			LEFT JOIN rv_payment_item ON fn_tran.fn_tran_link_ind != '".DB_FN_TRAN_LINK_INVOICE."'
				AND rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
			LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
			LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
	";

	$list = $GLOBALS['lDB']->get("
		SELECT
			$sql_select
		FROM
			$sql_from
		WHERE
			$sql_where
		$sql_group
	",2);

	$showSourceCurr = false;

	if($showHeader) {
		//$headerRow = array("Record type", "Line no.", "Batch ID", "Tran type", "Invoice unit", "Receipt No", "Res No", "Inv no.", "Debtor name", "Source Curr", "Exch rate", "Ledger date", "Financial year", "Tran ID");
		$headerRow = array("RECTYPE", "LINE", "BATCHID", "Field1", "Field2", "Field3", "Field4", "Field5", "Field6", "Field7", "Field8", "Field9", "Field10", "TRANID");
		array_push($csvFile, $headerRow);
	}

	$transactions = array();
	foreach($list as $item) {
		if (!isset($transactions[$item['fn_tran_ix']]['items'])) {
			$transactions[$item['fn_tran_ix']]['items'] = array();
		}
		$transactions[$item['fn_tran_ix']]['items'][] = $item;

		if (!isset($transactions[$item['fn_tran_ix']]['header'])) {
			$transactions[$item['fn_tran_ix']]['header'] = array();

			$fn_tran_detail = explode(";", $item['fn_tran_detail']);
			$res_details = explode(" ",$fn_tran_detail[3], 2);
			// PM;WB21698;;RS1973 Kalio x2;K Kalio;USD;1.230000;ALC
			$transactions[$item['fn_tran_ix']]['header'][] = "1";							// Field A: Record type, header is always 1
			$transactions[$item['fn_tran_ix']]['header'][] = "1";							// Field B: Line number, header is line 1
			$transactions[$item['fn_tran_ix']]['header'][] = ($item['fn_batch_id'] == null) ? "n/a" : $item['fn_batch_id'];	// Field C: Batch ID
			$transactions[$item['fn_tran_ix']]['header'][] = $fn_tran_detail[0];			// Field 1: Tran type
			$transactions[$item['fn_tran_ix']]['header'][] = $item['pr_bus_name_short'];	// Field 2: Invoice unit *?
			$transactions[$item['fn_tran_ix']]['header'][] = $item['rv_payment_id'];		// Field 3: Receipt number
			$transactions[$item['fn_tran_ix']]['header'][] = $res_details[0];				// Field 4: Res number
			$transactions[$item['fn_tran_ix']]['header'][] = $item['fn_invoice_id'];		// Field 5: Invoice number ?
			$transactions[$item['fn_tran_ix']]['header'][] = $fn_tran_detail[4];			// Field 6: Debtor code
			$transactions[$item['fn_tran_ix']]['header'][] = $fn_tran_detail[5];			// Field 7: Source Currency
			$transactions[$item['fn_tran_ix']]['header'][] = $fn_tran_detail[6];			// Field 8: Exchange rate
			$transactions[$item['fn_tran_ix']]['header'][] = $item['fn_tran_date_ledger'];	// Field 9: Ledger date
			$transactions[$item['fn_tran_ix']]['header'][] = $item['fn_year_desc'];			// Field 10: Financial year
			$transactions[$item['fn_tran_ix']]['header'][] = $item['fn_tran_ix'];			// Field D: Transaction ID
		}
	}

	foreach ($transactions as $fn_tran_id => $transaction) {
		array_push($csvFile, $transaction['header']);
		$itemLine = "1";
		$recType = "2";
		foreach ($transaction['items'] as $item) {
			$dataRow = array();
			array_push($dataRow,
					$recType,																// RECTYPE
					$itemLine,																// LINE
					($item['fn_batch_id'] == null) ? "n/a" : $item['fn_batch_id'],			// BATCHID
					db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']),				// Field 1
					$item['fn_tran_item_amt_source'],										// Field 2
					$item['fn_tran_item_amt'],												// Field 3
					"",																		// Field 4
					"",																		// Field 5
					$item['fn_ledger_code'],												// Field 6
					$item['fn_debtor_code'],												// Field 7
					"",																		// Field 8
					"",																		// Field 9
					$item['rv_payment_item_ix'],											// Field 10
					$item['fn_tran_ix']														// TRANID
			);
			$itemLine++;
			array_push($csvFile, $dataRow);
		}
	}

	foreach($list as $item) {
		$item['fn_tran_item_amt'] = round($item['fn_tran_item_amt'],2);
		fixAmtDisplay($item['fn_tran_item_amt'],2);
		$dataRow = array();

		$recType = "1";
		$line = "1";

		array_push($dataRow,
				$recType,
				$line,
				($item['fn_batch_id'] == null) ? "n/a" : $item['fn_batch_id'],
				db_fn_tran_item_type_desc($item['fn_tran_item_type_ind']),
				$item['fn_tran_item_amt_source'],
				$item['fn_tran_item_amt'],
				$item['pr_bus_name_short'],
				"Res name",
				$item['fn_ledger_code'],
				$item['fn_debtor_code'],
				"",
				"",
				"",
				$item['fn_tran_ix']
		);

		//array_push($csvFile, $dataRow);

	}
	return $csvFile;
}
