<?php

function tran_tally_invoice($fn_batch_id) {
	global $lDB;

	$batchWhere = "
		1
	";
	if(!empty($fn_batch_id) && $fn_batch_id != "all" ) {
		$batchWhere = "
			fn_batch.fn_batch_ix = '$fn_batch_id'
		";
	}

	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix,
			fn_tran.fn_tran_date_ledger,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_detail,
			rf_currency.rf_currency_symbol,
			rf_currency.rf_currency_name,
			fn_tran.fn_tran_exch_rate,
			pr_business.pr_bus_home_curr_id,
			pr_business.pr_business_id,
			pr_business.pr_bus_inv_prefix,
			pr_persona.pr_name_last,
			gl_currency.rf_currency_symbol AS gl_currency_symbol,
			gl_currency.rf_currency_name AS gl_currency_name,
			fn_tran.ad_create_date,
			contra_tran.fn_tran_ix AS contra_tran_ix,
			contra_tran.ad_create_date AS contra_create_date
		FROM
			fn_tran
			INNER JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_tran.rf_currency_id
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
			INNER JOIN pr_persona ON pr_business.pr_business_id = pr_persona.pr_persona_ix
			INNER JOIN rf_currency AS gl_currency ON gl_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
			INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
			LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
		WHERE
			$batchWhere
			AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
			AND fn_tran_item.fn_tran_item_amt != 0
		GROUP BY
			fn_tran.fn_tran_ix
	",2);

	$company = db_fn_option_data_by_name($list[0]['pr_business_id'], 'company_name');
	$companyPrefix = htmlspecialchars($list[0]['pr_bus_inv_prefix']);
	if (!$company) {
		$company = $list[0]['pr_name_last'];
	}
	$company = htmlspecialchars($company);
	$counter = 0;

	$xmlText = "";
	$xmlText .= '
		<ENVELOPE>
		 <HEADER>
		  <TALLYREQUEST>Import Data</TALLYREQUEST>
		 </HEADER>
		 <BODY>
		  <IMPORTDATA>
		   <REQUESTDESC>
		    <REPORTNAME>Vouchers</REPORTNAME>
		    <STATICVARIABLES>
		     <SVCURRENTCOMPANY>'.$company.'</SVCURRENTCOMPANY>
		    </STATICVARIABLES>
		   </REQUESTDESC>
		   <REQUESTDATA>
		    <TALLYMESSAGE xmlns:UDF="TallyUDF">
	';

	foreach($list as $tran) {
		$debtor = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",1);
		$items = $lDB->get("
			SELECT
				fn_tran_item.fn_tran_item_ix,
				fn_tran_item.fn_tran_item_amt,
				fn_tran_item.fn_tran_item_amt_source,
				fn_ledger.fn_ledger_code,
				fn_debtor.fn_debtor_code,
				fn_cost_centre_1.fn_cost_centre_code AS fn_cost_centre_code_1
			FROM
				fn_tran_item
				LEFT JOIN fn_ledger ON fn_ledger.fn_ledger_ix = fn_tran_item.fn_ledger_id
				LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = fn_tran_item.fn_debtor_id
				LEFT JOIN fn_cost_centre AS fn_cost_centre_1 ON fn_cost_centre_1.fn_cost_centre_ix = fn_tran_item.fn_tran_cost_ctr1_id
			WHERE
				fn_tran_item.fn_tran_id = '$tran[fn_tran_ix]'
				AND fn_tran_item_type_ind != '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
		",2);

		$partyledgername 	= htmlspecialchars($debtor['fn_debtor_code']);	//customer
		if(trim($partyledgername) == "") {
			$partyledgername = htmlspecialchars($debtor['fn_ledger_code']);
		}
		$date 				= str_replace('-', '', substr($tran['fn_tran_date_ledger'], 0, 10));
		$void 				= false;

		$vouchernumber 		= $tran['fn_tran_link_id'];	//reference
		// If the transaction is the result of a void, append a "V" to the voucher code
		if(!empty($tran['contra_tran_ix']) && $tran['ad_create_date'] > $tran['contra_create_date']) {
			$vouchernumber .= "V";
			$void = true;
		}

		$narration 			= htmlspecialchars($tran['fn_tran_detail']);	//memo
		$exchange 			= $tran['fn_tran_exch_rate'];	//exchange rate
		$currencysymbol 	= htmlspecialchars($tran['rf_currency_symbol']);
		$currencyname 		= htmlspecialchars($tran['rf_currency_name']);
		$glcurrencysymbol 	= htmlspecialchars($tran['gl_currency_symbol']);
		$glcurrencyname 	= htmlspecialchars($tran['gl_currency_name']);
		$enteredby 			= 'Admin';
		$vouchertypename 	= $companyPrefix.' Sales';
		$id 				= date('Ymd').'-'.date('Hi').'-'.date('s').'00-0000-'.sprintf('%012s', preg_replace('/[^0-9a-fA-F]/', '', $fn_batch_id)).'-'.sprintf('%08d', $counter);
		$vchkey 			= $id.':000'.sprintf('%05d', $counter);
		$counter++;
		$xmlTextCredits 	= "";
		$amounttotal 		= 0;
		$amountexchangetotal= 0;
		$debittotal 		= sprintf("%01.2f",-$debtor['fn_tran_item_amt_source']);
		$debitexchangetotal = sprintf("%01.2f",-$debtor['fn_tran_item_amt']);

		// Invoice information
		$xmlText .= '
		     <VOUCHER REMOTEID="'.$id.'" VCHKEY="'.$vchkey.'" VCHTYPE="'.$vouchertypename.'" ACTION="Create" OBJVIEW="Accounting Voucher View">
		      <OLDAUDITENTRYIDS.LIST TYPE="Number">
		       <OLDAUDITENTRYIDS>-1</OLDAUDITENTRYIDS>
		      </OLDAUDITENTRYIDS.LIST>
		      <DATE>'.$date.'</DATE>
		      <GUID>'.$id.'</GUID>
		      <NARRATION>'.$narration.'</NARRATION>
		      <VOUCHERTYPENAME>'.$vouchertypename.'</VOUCHERTYPENAME>
		      <VOUCHERNUMBER>'.$vouchernumber.'</VOUCHERNUMBER>
		      <PARTYLEDGERNAME>'.$partyledgername.'</PARTYLEDGERNAME>
		      <CSTFORMISSUETYPE/>
		      <CSTFORMRECVTYPE/>
		      <FBTPAYMENTTYPE>Default</FBTPAYMENTTYPE>
		      <PERSISTEDVIEW>Accounting Voucher View</PERSISTEDVIEW>
		      <VCHGSTCLASS/>
		      <ENTEREDBY>'.$enteredby.'</ENTEREDBY>
		      <DIFFACTUALQTY>No</DIFFACTUALQTY>
		      <AUDITED>No</AUDITED>
		      <FORJOBCOSTING>No</FORJOBCOSTING>
		      <ISOPTIONAL>No</ISOPTIONAL>
		      <EFFECTIVEDATE>'.$date.'</EFFECTIVEDATE>
		      <ISFORJOBWORKIN>No</ISFORJOBWORKIN>
		      <ALLOWCONSUMPTION>No</ALLOWCONSUMPTION>
		      <USEFORINTEREST>No</USEFORINTEREST>
		      <USEFORGAINLOSS>No</USEFORGAINLOSS>
		      <USEFORGODOWNTRANSFER>No</USEFORGODOWNTRANSFER>
		      <USEFORCOMPOUND>No</USEFORCOMPOUND>
		      <ALTERID>000000</ALTERID>
		      <EXCISEOPENING>No</EXCISEOPENING>
		      <USEFORFINALPRODUCTION>No</USEFORFINALPRODUCTION>
		      <ISCANCELLED>No</ISCANCELLED>
		      <HASCASHFLOW>No</HASCASHFLOW>
		      <ISPOSTDATED>No</ISPOSTDATED>
		      <USETRACKINGNUMBER>No</USETRACKINGNUMBER>
		      <ISINVOICE>No</ISINVOICE>
		      <MFGJOURNAL>No</MFGJOURNAL>
		      <HASDISCOUNTS>No</HASDISCOUNTS>
		      <ASPAYSLIP>No</ASPAYSLIP>
		      <ISCOSTCENTRE>No</ISCOSTCENTRE>
		      <ISSTXNONREALIZEDVCH>No</ISSTXNONREALIZEDVCH>
		      <ISEXCISEMANUFACTURERON>No</ISEXCISEMANUFACTURERON>
		      <ISBLANKCHEQUE>No</ISBLANKCHEQUE>
		      <ISDELETED>No</ISDELETED>
		      <ASORIGINAL>No</ASORIGINAL>
		      <VCHISFROMSYNC>No</VCHISFROMSYNC>
		      <MASTERID>000000</MASTERID>
		      <VOUCHERKEY>000000000000000</VOUCHERKEY>
		      <OLDAUDITENTRIES.LIST>      </OLDAUDITENTRIES.LIST>
		      <ACCOUNTAUDITENTRIES.LIST>      </ACCOUNTAUDITENTRIES.LIST>
		      <AUDITENTRIES.LIST>      </AUDITENTRIES.LIST>
		      <INVOICEDELNOTES.LIST>      </INVOICEDELNOTES.LIST>
		      <INVOICEORDERLIST.LIST>      </INVOICEORDERLIST.LIST>
		      <INVOICEINDENTLIST.LIST>      </INVOICEINDENTLIST.LIST>
		      <ATTENDANCEENTRIES.LIST>      </ATTENDANCEENTRIES.LIST>
		';

		// Debit information
		$positivetotal = $lastpositivetotal	= ($debittotal < 0) ? "Yes" : "No";
		$xmlText .= '
		      <ALLLEDGERENTRIES.LIST>
		       <OLDAUDITENTRYIDS.LIST TYPE="Number">
		        <OLDAUDITENTRYIDS>-1</OLDAUDITENTRYIDS>
		       </OLDAUDITENTRYIDS.LIST>
		       <LEDGERNAME>'.$partyledgername.'</LEDGERNAME>
		       <GSTCLASS/>
		       <ISDEEMEDPOSITIVE>'.$positivetotal.'</ISDEEMEDPOSITIVE>
		       <LEDGERFROMITEM>No</LEDGERFROMITEM>
		       <REMOVEZEROENTRIES>No</REMOVEZEROENTRIES>
		       <ISPARTYLEDGER>Yes</ISPARTYLEDGER>
		       <ISLASTDEEMEDPOSITIVE>'.$lastpositivetotal.'</ISLASTDEEMEDPOSITIVE>
		       <AMOUNT>'.$debittotal.' '.$currencysymbol.' @ '.$exchange.' '.$glcurrencysymbol.' / '.$currencysymbol.' = '.$debitexchangetotal.' '.$glcurrencysymbol.'</AMOUNT>
		       <BANKALLOCATIONS.LIST>       </BANKALLOCATIONS.LIST>
		       <BILLALLOCATIONS.LIST>       </BILLALLOCATIONS.LIST>
		       <INTERESTCOLLECTION.LIST>       </INTERESTCOLLECTION.LIST>
		       <OLDAUDITENTRIES.LIST>       </OLDAUDITENTRIES.LIST>
		       <ACCOUNTAUDITENTRIES.LIST>       </ACCOUNTAUDITENTRIES.LIST>
		       <AUDITENTRIES.LIST>       </AUDITENTRIES.LIST>
		       <TAXBILLALLOCATIONS.LIST>       </TAXBILLALLOCATIONS.LIST>
		       <TAXOBJECTALLOCATIONS.LIST>       </TAXOBJECTALLOCATIONS.LIST>
		       <TDSEXPENSEALLOCATIONS.LIST>       </TDSEXPENSEALLOCATIONS.LIST>
		       <VATSTATUTORYDETAILS.LIST>       </VATSTATUTORYDETAILS.LIST>
		       <COSTTRACKALLOCATIONS.LIST>       </COSTTRACKALLOCATIONS.LIST>
		      </ALLLEDGERENTRIES.LIST>
		';

		$credit = ($debittotal > 0) ? true : false;

		$largestdebtor = 0;
		$largestdebtoramount = 0;
		$largestdebtorexchangeamount = 0;

		foreach ($items as $key=>$item) {
			$amount 			= db_round($item['fn_tran_item_amt_source'],2);
			$amountexchange 	= db_round($item['fn_tran_item_amt'],2);
			$amounttotal 		+= $amount;
			$amountexchangetotal+= $amountexchange;
			if ($credit) {
				if ($amount > $largestdebtoramount) {
					$largestdebtor = $key;
					$largestdebtoramount = $amount;
					$largestdebtorexchangeamount = $amountexchange;
				}
			} else {
				if ($amount < $largestdebtoramount) {
					$largestdebtor = $key;
					$largestdebtoramount = $amount;
					$largestdebtorexchangeamount = $amountexchange;
				}
			}
		}

		$debtorDiff = $debittotal - $amounttotal;
		$largestdebtoramount += $debtorDiff;
		$items[$largestdebtor]['fn_tran_item_amt_source'] = db_round($largestdebtoramount,2);

		$debtorexchangeDiff = $debitexchangetotal - $amountexchangetotal;
		$largestdebtorexchangeamount += $debtorexchangeDiff;
		$items[$largestdebtor]['fn_tran_item_amt'] = db_round($largestdebtorexchangeamount,2);

		foreach ($items as $item) {
			$category 			= htmlspecialchars($item['fn_ledger_code']);	//ledger code
			$costcentre 		= htmlspecialchars($item['fn_cost_centre_code_1']);	//cost centre code
			$amount 			= db_round(-$item['fn_tran_item_amt_source'],2);
			$amountexchange 	= db_round(-$item['fn_tran_item_amt'],2);
			$positive 			= ($amount < 0) ? "Yes" : "No";	//credit/debit
			$lastpositive		= $positive;
			$costcentrename 	= 'General Cost Centre '.$companyPrefix;
			$ledgername 		= htmlspecialchars($item['fn_ledger_code']);

			// Credit information
			$xmlText .= '
			      <ALLLEDGERENTRIES.LIST>
			       <OLDAUDITENTRYIDS.LIST TYPE="Number">
			        <OLDAUDITENTRYIDS>-1</OLDAUDITENTRYIDS>
			       </OLDAUDITENTRYIDS.LIST>
			       <LEDGERNAME>'.$ledgername.'</LEDGERNAME>
			       <GSTCLASS/>
			       <ISDEEMEDPOSITIVE>'.$positive.'</ISDEEMEDPOSITIVE>
			       <LEDGERFROMITEM>No</LEDGERFROMITEM>
			       <REMOVEZEROENTRIES>No</REMOVEZEROENTRIES>
			       <ISPARTYLEDGER>No</ISPARTYLEDGER>
			       <ISLASTDEEMEDPOSITIVE>'.$lastpositive.'</ISLASTDEEMEDPOSITIVE>
			       <AMOUNT>'.$amount.' '.$currencysymbol.' @ '.$exchange.' '.$glcurrencysymbol.' / '.$currencysymbol.' = '.$amountexchange.' '.$glcurrencysymbol.'</AMOUNT>
			       <CATEGORYALLOCATIONS.LIST>
			        <CATEGORY>'.$costcentre.'</CATEGORY>
			        <ISDEEMEDPOSITIVE>'.$positive.'</ISDEEMEDPOSITIVE>
			        <COSTCENTREALLOCATIONS.LIST>
			         <NAME>'.$costcentrename.'</NAME>
			         <AMOUNT>'.$amountexchange.'</AMOUNT>
			        </COSTCENTREALLOCATIONS.LIST>
			       </CATEGORYALLOCATIONS.LIST>
			       <BANKALLOCATIONS.LIST>       </BANKALLOCATIONS.LIST>
			       <BILLALLOCATIONS.LIST>       </BILLALLOCATIONS.LIST>
			       <INTERESTCOLLECTION.LIST>       </INTERESTCOLLECTION.LIST>
			       <OLDAUDITENTRIES.LIST>       </OLDAUDITENTRIES.LIST>
			       <ACCOUNTAUDITENTRIES.LIST>       </ACCOUNTAUDITENTRIES.LIST>
			       <AUDITENTRIES.LIST>       </AUDITENTRIES.LIST>
			       <TAXBILLALLOCATIONS.LIST>       </TAXBILLALLOCATIONS.LIST>
			       <TAXOBJECTALLOCATIONS.LIST>       </TAXOBJECTALLOCATIONS.LIST>
			       <TDSEXPENSEALLOCATIONS.LIST>       </TDSEXPENSEALLOCATIONS.LIST>
			       <VATSTATUTORYDETAILS.LIST>       </VATSTATUTORYDETAILS.LIST>
			       <COSTTRACKALLOCATIONS.LIST>       </COSTTRACKALLOCATIONS.LIST>
			      </ALLLEDGERENTRIES.LIST>
			';
		}

		$xmlText .= '
			      <ATTDRECORDS.LIST>      </ATTDRECORDS.LIST>
			     </VOUCHER>
		';
	}

	$xmlText .= '
			    </TALLYMESSAGE>
		   </REQUESTDATA>
		  </IMPORTDATA>
		 </BODY>
		</ENVELOPE>
	';

	return $xmlText;
}
